/*
 * @author prathamesh.sheth
 * 
 * This controller is used for Custom Field details.   
 */
Ext.define('Academia.controller.customfields.CustomFieldController', {
    extend: 'Academia.controller.base.BaseController',

    models: ['customfields.CustomFieldModel'],

    stores: ['customfields.CustomFieldStore', 'customfields.FieldTypeStore',
             'customcategories.TableConfigCategoryMasterSearchStore'],

    views: ['customfields.CustomFieldGrid', 'customfields.CustomFieldFormWindow', 'customfields.CustomFieldPanel',
            'common.CustomFieldForm'],

    alias: "widget.customfieldcontroller",

    refs: [{
        ref: 'customFieldGrid',
        selector: 'customfieldgrid[itemId=customFieldGrid]'
    }, {
        ref: 'customFieldFormWindow',
        selector: 'customfieldformwindow'
    }, {
        ref: 'customFieldForm',
        selector: 'customfieldformwindow form[itemId=customFieldForm]'
    }],
    config: {
        CUSTOM_FIELDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CUSTOM_FIELDS_PRIVILEGES')
    },
    init: function(application) {
        this.control({

        	/**
             * Standard master custom category add/edit/view/delete
             */
        	'customfieldgrid[itemId=customFieldGrid]': {
        		render: function(grid){
    				this.doAccessControlValidation(grid, this.getCUSTOM_FIELDS_PERMISSIONS());
    			},
        	},
        	'customfieldgrid[itemId=customFieldGrid] combo[itemId=gridCustomTableConfigField]': {
        		select: function(combo, records, eOpts) {
                	var grid = this.getCustomFieldGrid();
                	var customTableConfigValue = combo.getValue();
                	this.loadCustomFieldGridStore(grid, customTableConfigValue, 'CUSTOM_FIELD', false);
                }
            },
            'customfieldgrid[itemId=customFieldGrid] button[itemId=btnAdd]': {
                click: function() {
                	this.showCustomFieldForm();
                }
            },
            'customfieldgrid[itemId=customFieldGrid] button[itemId=btnEdit]': {
                click: function() {
                    this.editCustomFieldForm(false);
                }
            },
            'customfieldgrid[itemId=customFieldGrid] button[itemId=btnView]': {
                click: function() {
                    this.editCustomFieldForm(true);
                }
            },
            'customfieldgrid[itemId=customFieldGrid] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteCustomFieldForm();
                }
            },
            /*'customfieldformwindow form[itemId=customFieldForm]': {
                render: function(form) {
                	//this.loadTableConfigFieldDropDown(form);
                	this.loadFieldTypedropDown(form);
                }
            },*/
            'customfieldformwindow form[itemId=customFieldForm] nestedJsonCombo[itemId=customTableConfigField]': {
                select: function(combo, records, eOpts) {
                	var form = this.getCustomFieldForm();
                	var fieldType = form.down('#cmbFieldType').getValue();
                	this.loadColumnNameDropDown(form, combo.getValue(), 'CUSTOM_FIELD', fieldType);
                }
            },
            'customfieldformwindow form[itemId=customFieldForm] combo[itemId=cmbFieldType]': {
            	select: function(combo, records, eOpts) {
                	var form = this.getCustomFieldForm();
                	var customTableConfigId = form.down('#customTableConfigField').getValue();
                	this.loadColumnNameDropDown(form, customTableConfigId, 'CUSTOM_FIELD', combo.getValue());
                }
            },
            'customfieldformwindow form[itemId=customFieldForm] button[itemId=submitButtonId]': {
                click: function() {
                    this.saveCustomFieldForm();
                }
            },
            'customfieldformwindow form[itemId=customFieldForm] button[itemId=cancelButtonId]': {
                click: function() {
                    this.getCustomFieldFormWindow().close();
                }
            }
        });
    },
    /**
     * Load custom field grid store
     */
    loadCustomFieldGridStore: function(grid, customTableConfigValue, customType, whetherStandardMaster){
    	if(grid){
    		var store = grid.getStore();
    		store.getProxy().extraParams = {
    			customType: customType,
    			customTableConfigId: customTableConfigValue,
    			whetherStandardMaster: whetherStandardMaster
    		}; 
    		store.load();
    	}
    },
    /**
     * show Custom Field Form
     */
    showCustomFieldForm: function() {
        var this$ = this;
        var customFieldFormWindow = this$.getCustomFieldFormWindow();
        if (!customFieldFormWindow) {
        	customFieldFormWindow = Ext.widget('customfieldformwindow');
        }

        customFieldFormWindow.show();
    },
    /**
     * load enity name store
     * @param form custom field form
     * @param entityValue
     */
    loadTableConfigFieldDropDown: function(form){
    	var this$ = this;
    	if(form){
    		var customTableConfigField = form.down('#customTableConfigField');
    		var customTableConfigId = customTableConfigField.getValue();
    		var fieldType = form.down('#cmbFieldType').getValue();
//        	var store = customTableConfigField.getStore();
//        	store.load();
        	this$.loadColumnNameDropDown(form, customTableConfigId, 'CUSTOM_FIELD', fieldType);
    	}
    	
    },
    loadFieldTypedropDown: function(form){
    	var this$ = this;
    	if(form){
    		var cmbFieldType = form.down('#cmbFieldType');
    		var customTableConfigId = form.down('#customTableConfigField').getValue();
    		var fieldType = cmbFieldType.getValue();
//        	var store = cmbFieldType.getStore();
//        	store.load();
        	this$.loadColumnNameDropDown(form, customTableConfigId, 'CUSTOM_FIELD', fieldType);
    	}
    },
    /**
     * load column name store
     * @param form custom field form
     * @param entityValue
     */
    loadColumnNameDropDown: function(form, customTableConfigId, customType, fieldType, columnMappingId){
    	if(form){
    		var columnNameField = form.down('#columnNameField');
    		if(!isNullOrEmpty(customTableConfigId) && !isNullOrEmpty(fieldType)){
    			var store = columnNameField.getStore();
            	/*store.load({
            		params:{
            			customType: customType,
            			customFieldDataType: fieldType,
                		customTableConfigId: customTableConfigId
            		}
            	});*/
    			store.getProxy().extraParams = {
        			customType: customType,
        			customFieldDataType: fieldType,
        			columnMappingId: columnMappingId,
            		customTableConfigId: customTableConfigId
        		};
    			
    			store.load();
    		}
        	
    	}
    	
    },
    /**
     * view CustomField form window
     */
    viewCustomFieldFormWindow: function(form) {

        if (form) {
            form.down('#submitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },

    /**
     * Close CustomField form window
     */
    closeCustomFieldFormWindow: function() {
        var this$ = this;
        this$.getPersonCommonWindow().close();
    },

    /*
     * This function is used for to edit standard master custom field details   
     */
    editCustomFieldForm: function(isView) {
        var this$ = this;
        var grid = this$.getCustomFieldGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            this$.showCustomFieldForm();
            var record = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(record)) {
                var form = this$.getCustomFieldForm();
                form.down('#cmbFieldType').getStore().load();
                this$.loadColumnNameDropDown(form, record.get('customTableConfigId'), 'CUSTOM_FIELD', record.get('customFieldDataType'), record.get('columnMappingId'));
                form.down('#customTableConfigField').getStore().load({
                    callback: function(records, operation, success) {
                    	form.down('#customTableConfigField').setValue(record.data.customTableConfigId);
                    }
                });
                form.down('#customTableConfigField').setReadOnly(true);
                form.down('#cmbFieldType').setReadOnly(true);
                form.down('#columnNameField').setReadOnly(true);
                form.loadRecord(record);
                if (isView) {
                    this$.viewCustomFieldFormWindow(form);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('CUSTOM_FIELD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },


    /*
     * This function is used for to delete standard master custom category after clicking on delete button   
     */
    deleteCustomFieldForm: function() {
    	var this$ = this;
        var grid = this$.getCustomFieldGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('CUSTOM_FIELD'), getCommonTranslation('DELETE_CUSTOM_FIELD_CATEGORY'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection();
                    for (var count = 0; count < records.length; count++) {
                        var id = "";
                        if (!isNullOrEmpty(records[count].get("id"))) {
                            id = records[count].get("id");
                        }
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.CUSTOM_CATEGORY_DELETE,
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            params: {
                                id: id,
                                whetherConfiremd:false
                            },
                            success: function(form, action) {
                                grid.getStore().reload();
                                if (form.responseText == 'DEPENDENT_RECORD_EXISTS') {
                                	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENT_RECORD_EXISTS'));
								}else{
									showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_CUSTOM_FIELD_MSG'));	
								}
                            },
                            failure:function(response){
                            	if(response.status!=401) {
                            	console.log(response.responseText);
                            	showConfirmMessage("Field In Use", generateErrorMessage(response)+getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                                     if (btn == 'yes') {
                                    	 
                                    	 
                                    	 Ext.Ajax.request({
                                             type: 'rest',
                                             url: SERVERURL.CUSTOM_CATEGORY_DELETE,
                                             method: 'DELETE',
                                             headers: {
                                                 'Content-Type': 'application/json'
                                             },
                                             params: {
                                                 id: id,
                                                 whetherConfiremd:true
                                             },
                                             success: function(form, action) {
                                                 grid.getStore().reload();
                                                 showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_CUSTOM_FIELD_MSG'));
                                             }
                                    	 });
                                    	 
                                    	 
                                    	 
                                     }
                            	 });
                            	} 
                            }
                        });
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('CUSTOM_FIELD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * save the value for standard master custom category values
     */
    saveCustomFieldForm: function() {

        var this$ = this;
        var form = this$.getCustomFieldForm();
        var grid = this$.getCustomFieldGrid();
        var submitUrl,  methodType, isUpdate = false;
        var id = form.down('#id_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.CUSTOM_CATEGORY_SAVE;
            methodType = 'POST';
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.CUSTOM_CATEGORY_SAVE;
            methodType = 'PUT';
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonCustomFieldForm(form);
        this$.applyWindowMask(); 
        this.sendSaveAjaxRequest(submitUrl, methodType, jsonFormatFormData, function(option, success, response) {
        	 this$.hideWindowMask();
            if (success) {
            	var result = response.responseText;
            	this$.getCustomFieldFormWindow().close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if(result == "0"){
                	showErrorMessage(getCommonTranslation('CUSTOM_FIELD'),getCommonTranslation('DUPLICATE_CUSTOM_FIELD_MSG'));
                }
                else{
                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('CUSTOM_FIELD'), getCommonTranslation('UPDATE_CUSTOM_FIELD_MSG'));
                } else {
                    showSuccessMessage(getCommonTranslation('CUSTOM_FIELD'), getCommonTranslation('ADD_CUSTOM_FIELD_MSG'));
                } }
            } else {
            	this$.getCustomFieldFormWindow().close();
                grid.getStore().reload();
            }
        });
    },

    getJsonCustomFieldForm: function(form){
    	var this$ = this;
        var jsonFormFieldData = new Object();
    	var formData = form.getValues();
    	formData.customTableConfig = this$.getIdValueJson(formData.customTableConfig);
    	if(!isNullOrEmpty(form.down('#customTableConfigField').valueModels[0].raw.viewCode)) {
        	formData.customTableConfig.viewCode = form.down('#customTableConfigField').valueModels[0].raw.viewCode;
    	}
    	jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    getIdValueJson: function(id, value) {
   		if (id) return {
   			id: id,
   			value: value
   		};
   	}
});
