Ext.define('Academia.controller.datagridconfiguration.DataGridConfigurationController', {
    extend: 'Academia.controller.base.BaseController',
    views: [
    	'datagridconfiguration.ConfigureDatagridStructure'
    ],
    models: [],
    stores: [],
    config: {
    	DATA_GRID_CONFIG_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DATA_GRID_CONFIG_PRIVILEGE'),  		  
    },
    refs: [{
    	ref:'configuredatagridstructure',
    	selector:'configuredatagridstructure'
    }],
    init: function(application) {
        this.control({
        	'configuredatagridstructure button[itemId=searchBtn]':{
        		click: function(btn){
        			var me = this;
        			var form = btn.up('form');
        			var grid = btn.up('configuredatagridstructure').down('grid');
        			var gridNameCombo = form.down('#gridNameComboItemId');
        			var gridClass = gridNameCombo.getValue();
        			var portalId = form.down('#portalIdComboItemId').getValue();
        			
        			var isCBGrid = false;
        			if(gridClass.indexOf("SearchResultGrid")!=-1){
    					isCBGrid = true;
    				}
        			
        			var saveBtn = btn.up('configuredatagridstructure').down('#btnSave');
        			saveBtn.setDisabled(true);
        			
        			var resultGrid = btn.up('configuredatagridstructure').down('grid');
        			var enableSortingCheckBox = resultGrid.down('#enableSortingConfigItemId');
        			var gridtoolBar = resultGrid.query('toolbar')[0];
        			gridtoolBar.items.items[1].reset();
        			gridtoolBar.items.items[2].reset();
        			
        			if(portalId == "3" && gridClass == "Academia.view.student.studentprofile.AcademicsTopicQuickSearchGrid") {
        				gridClass = "Academia.view.personinfo.student.StudentForAcademicToicsGrid";
        			}
        			
         			var column = grid.down('[dataIndex=columnName]');
         	        if (column) {
         	            column.sortable = (gridClass=='Academia.view.examinationcenters.remark.EvaluationRemarkGrid') ? false : true;
         	        }        			
        			var showEnableSorting = this.showEnableSortingCheckBox(resultGrid,this.getDATA_GRID_CONFIG_PERMISSIONS(),gridClass,portalId);
        			Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PATH_GET_GRID_COLUMN_CONFIGURATION_DEFAULT,
        				params : {
        					portalId : portalId,
        					gridName : gridClass
        				},
        				method : 'GET',
        				success : function(response) {
        					var respData = Ext.decode(response.responseText);
        					
        					if(!isNullOrEmpty(respData) && respData.length>0){
        						var responseData = Ext.decode(respData[0].jsonObject);
        						if(respData[0].isVisibleColumn){
        							gridtoolBar.items.items[1].setValue(true);
        						}
        						
        						if(respData[0].enableSortingConfig && showEnableSorting){
        							enableSortingCheckBox.setValue(true);
        						}
        						
            					resultGrid.config.id = respData[0].id;
                    			
                    			var resultGridStoreData = [];
                    			Ext.each(responseData, function(currentGridColumn){
                    				currentGridColumn.keyName = currentGridColumn.columnName;
                    				if(!isCBGrid){
                    					currentGridColumn.columnName = getCommonTranslation(currentGridColumn.columnName);
                    				}
                    				resultGridStoreData.push({
                    					id: currentGridColumn.id,
                    					columnName: currentGridColumn.columnName,
                    					dataIndex: currentGridColumn.dataIndex,
                    					columnVisibility: currentGridColumn.columnVisibility,
                    					mandatory: currentGridColumn.mandatory,
                    					sequence: currentGridColumn.sequence,
                    					keyName: currentGridColumn.keyName,
                    					defaultSortBy:currentGridColumn.defaultSortBy,
                    					orderBy:currentGridColumn.orderBy
                    				});
                    			});
                    			
                    			if(resultGridStoreData.length){
                    				saveBtn.setDisabled(false);
                    			}
                    			
                    			var resultGridStore = resultGrid.getStore();
                    			resultGridStore.removeAll();
                    			resultGridStore.add(resultGridStoreData);
        					}
        					else{
        						var resultGridStore = resultGrid.getStore();
                    			resultGridStore.removeAll();
        					}
        				}
        			});
        		}
        	},
        	'configuredatagridstructure button[itemId=resetBtn]': {
        		click: function(btn) {
        			btn.up('form').getForm().reset();
        		}
        	},
        	'configuredatagridstructure button[itemId=btnSave]':{
        		click: function(btn){
        			var me = this;
        			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			var grid = btn.up('grid');
        			var form = btn.up('configuredatagridstructure').down('form');
        			var gridNameCombo = form.down('#gridNameComboItemId');
        			var gridClass = gridNameCombo.getValue();
        			var portalId = form.down('#portalIdComboItemId').getValue();
        			var submitValue = [];
        			var removeColumns=[];
        			var recordId = grid.config.id;
        			var buttonsToolBar = grid.query('toolbar')[0];
        			var dataGridCheckColumn = buttonsToolBar.items.items[1].getValue();
        			var enableSortingConfig = buttonsToolBar.items.items[2].getValue();
        			var sortBy ;
        			var sequence = 0;
        			var sortedColumn ;
       			    var orderBy;
        			Ext.each(grid.getStore().data.items, function(currentRecord){
        				sequence = sequence+1;
        				
        				if(currentRecord.data.defaultSortBy){
        					//sortBy = true;
        					sortedColumn=currentRecord.data.dataIndex;
        					orderBy=currentRecord.data.orderBy;
        				}else{
        					//sortBy = false;
        				}
        				var currentRecordValue = {
        						id: currentRecord.data.id,
        						columnName: currentRecord.data.keyName,
        						dataIndex: currentRecord.data.dataIndex,
        						columnVisibility: currentRecord.data.columnVisibility,
        						mandatory: currentRecord.data.mandatory,
        						sequence: sequence,
        						defaultSortBy:currentRecord.data.defaultSortBy,
            					orderBy:currentRecord.data.orderBy
        				};
        				if(currentRecord.data.columnVisibility=="REMOVE"){
        					removeColumns.push(currentRecordValue);
        				}
        				submitValue.push(currentRecordValue);
        			});
        			if(portalId == "3" && gridClass == "Academia.view.student.studentprofile.AcademicsTopicQuickSearchGrid") {
        				gridClass = "Academia.view.personinfo.student.StudentForAcademicToicsGrid";
        			}
        			Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PATH_SAVE_GRID_COLUMN_CONFIGURATION,
        				async:false,
        				jsonData : {
        					id: recordId,
        					portalId:{
        						id: portalId
        					},
        					gridName: gridClass,
        					jsonObjectList: submitValue,
        					removedColumn:removeColumns,
        					isVisibleColumn:dataGridCheckColumn,
        					enableSortingConfig:enableSortingConfig,
        					sortedColumn:sortedColumn,
        					orderBy:orderBy
        				},
        				method : 'POST',
        				success : function(form, action) {
        					Ext.getBody().unmask();
        					showSuccessMessage(getCommonTranslation('GRID_CONFIGURATION'),getCommonTranslation('SUCCESS'));	
        				}
        			});
        		}
        	},
        	'configuredatagridstructure grid':{
        		cellclick: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts ){
        			var me = this;
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			//record.set('dafaultSortBy',true);
        			
        			var totalItems =grid.getStore().data.items;
        			if(cellIndex==2 && e.target.tagName == 'INPUT'){
        				document.getElementById('dafaultSortById_'+record.get('dataIndex')).checked =true;
        				if(totalItems.length >0){
            				for(var i=0;i< totalItems.length ;i++){
            					if(totalItems[i].data.dataIndex != record.data.dataIndex  && e.target.checked == true ){
            						totalItems[i].set('orderBy','');
                					totalItems[i].set('defaultSortBy',false);
            					}
            				}
            			}
            			
        			}
        			if(cellIndex==1 && e.target.tagName == 'INPUT'){
        				
        				//selectedRecord.set('columnVisibility',e.target.value);
        				if(e.target.value=="SHOW"){
        					if(document.getElementById('dafaultSortById_'+record.get('dataIndex')) != null)
            				  document.getElementById('dafaultSortById_'+record.get('dataIndex')).disabled = false;
            			}else{
            				if(document.getElementById('dafaultSortById_'+record.get('dataIndex')) != null){
            			      document.getElementById('dafaultSortById_'+record.get('dataIndex')).disabled = true;
               				  document.getElementById('dafaultSortById_'+record.get('dataIndex')).checked =false;
            				}
            				  record.set('orderBy','');
            				  record.set('defaultSortBy',false);
            			}
        			}
        			try{
            			if(e.target.name.indexOf("visibility")==0){
            				record.data.columnVisibility = e.target.value;
            			}
            			if(e.target.name.indexOf("defaultSortBy")==0){
            				record.set('defaultSortBy',e.target.checked);
            			}
        			}
        			catch(e){}
        		}
        	},
        	'configuredatagridstructure checkbox[itemId=enableSortingConfigItemId]':{
        		change: function(obj){
        			var grid = obj.up().up();
        			if(obj.getValue()){
        				this.showColumnForSortingConfiguration(grid);
        			}else{
        				this.hideColumnOfSortingConfiguration(grid);
        			}
        		}
        	}
        })
    },
    showColumnForSortingConfiguration:function(grid){
    	grid.reconfigure(this.createStoreOfDataGrid(), [{
    		header:  getCommonTranslation('COLUMN_NAME'),
    		dataIndex: 'columnName',
    		flex:1,
    		sortable:false
    	},/*{
    		header:  getCommonTranslation('DATA_INDEX'),
    		dataIndex: 'dataIndex',
    		flex:1,
    		sortable:true
    	},*/{
    		header: getCommonTranslation('COLUMN_VISIBILITY'),
    		flex:1,
            dataIndex: 'columnVisibility',
            sortable: false, 
            renderer:function(value,meta,record){
            	var checkedShow = '';
            	var checkedHide = '';
            	var checkedRemove = '';
            	var checkMandatory = '';
            	if(value=="SHOW"){
            		checkedShow = "checked";
            	}
            	else if(value=="HIDE"){
            		checkedHide = "checked";
            	}
            	else if(value=="REMOVE"){
            		checkedRemove = "checked";
            	}
            	if(record.get('mandatory')){
            		checkMandatory = 'disabled="disabled"';
            	}
            	return '<input type="radio" id="columnVisibilityId" name="visibility_'+record.get('dataIndex')+'" value="SHOW" '+checkedShow+' '+checkMandatory+' /> Show <input type="radio" name="visibility_'+record.get('dataIndex')+'" value="HIDE" '+checkedHide+' '+checkMandatory+' /> Hide <input type="radio" name="visibility_'+record.get('dataIndex')+'" value="REMOVE" '+checkedRemove+' '+checkMandatory+' /> Remove';
    		}
    	},{
    		header: getCommonTranslation('DEFAULT_SORT_BY'),
    		flex:1,
            dataIndex: 'defaultSortBy',
            sortable: false, 
            renderer:function(value,meta,record){
            	
            	var checked;
            	if(value==true){
            		checked = "checked";
            	}
            	if(record.get('columnVisibility')=="HIDE" || record.get('columnVisibility')=="REMOVE"){
            		return '<input type="radio" id="dafaultSortById_'+record.get('dataIndex')+'" name="defaultSortBy"  disabled=true/>';
            	}else{
            		return '<input type="radio" id="dafaultSortById_'+record.get('dataIndex')+'" name="defaultSortBy" '+checked+'/>';
            	}
    		}
    	},{
    		header:  getCommonTranslation('ORDER_BY'),
    		dataIndex: 'orderBy',
    		flex:1,
    		sortable: false, 
    		editor:{
    			xtype: 'customcombobox',
    			itemId: 'orderById',
    			name: 'orderBy', 
    			store:Ext.create('Academia.store.dataGridConfiguration.dataGridOrderBySort'),
    			valueField:'id',
    			displayField:'value',
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            	enableKeyEvents  : 'true',
            	hideTrigger:false,
            	forceSelection:true,
            	triggerAction: 'all',
    			queryParam:'id',
    			minChars:3,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
    		},
    		 renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
         		var editor = rec.column.getEditor();
             	if(!isNullOrEmpty(value) && value !== '') {
             		try{
             			if(Ext.isObject(value)){
             			return value.value;
             			}else{
             				var index = rec.column.getEditor().store.findExact('id',value);
             				if(index !== -1){
             					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
             				}else{
             					rec.tdCls = 'gridInputCustomStyle';
             					return getExaminationTranslation('CLICK_TO_ENTER');
             				}
             			}
         			}
         			catch(e){
         				return null;
         			}
             	}
             	else{
             		if(record.data.defaultSortBy && record.data.columnVisibility == "SHOW"){
             			rec.tdCls = 'gridInputCustomStyle';
                 		return getExaminationTranslation('CLICK_TO_ENTER');
             		}else{
             			return null;
             		}
             	}
         }
    	}]);
    },
    hideColumnOfSortingConfiguration:function(grid){
    	grid.reconfigure(this.createStoreOfDataGrid(), [{
    		header:  getCommonTranslation('COLUMN_NAME'),
    		dataIndex: 'columnName',
    		flex:1,
    		sortable:false
    	},/*{
    		header:  getCommonTranslation('DATA_INDEX'),
    		dataIndex: 'dataIndex',
    		flex:1,
    		sortable:true
    	},*/{
    		header: getCommonTranslation('COLUMN_VISIBILITY'),
    		flex:1,
            dataIndex: 'columnVisibility',
            sortable:false,
            renderer:function(value,meta,record){
            	var checkedShow = '';
            	var checkedHide = '';
            	var checkedRemove = '';
            	var checkMandatory = '';
            	if(value=="SHOW"){
            		checkedShow = "checked";
            	}
            	else if(value=="HIDE"){
            		checkedHide = "checked";
            	}
            	else if(value=="REMOVE"){
            		checkedRemove = "checked";
            	}
            	if(record.get('mandatory')){
            		checkMandatory = 'disabled="disabled"';
            	}
            	return '<input type="radio" name="visibility_'+record.get('dataIndex')+'" value="SHOW" '+checkedShow+' '+checkMandatory+' /> Show <input type="radio" name="visibility_'+record.get('dataIndex')+'" value="HIDE" '+checkedHide+' '+checkMandatory+' /> Hide <input type="radio" name="visibility_'+record.get('dataIndex')+'" value="REMOVE" '+checkedRemove+' '+checkMandatory+' /> Remove';
    		}
    	}]);
    },
    createStoreOfDataGrid:function(){
    	new Ext.data.ArrayStore({
    		id: 0,
    		fields: ['id', 'columnName', 'dataIndex', 'columnVisibility', 'mandatory', 'keyName','orderBy','defaultSortBy'],
			data: []
    	})
    },
    
    showEnableSortingCheckBox:function(grid,permissionsMap,gridClass,portalId){
    	
    	 var associatedAcadLocationIds = new Array();
    	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	 var enableSortingCheckBox = grid.down('#enableSortingConfigItemId');
    	 var showEnableSorting = false;
    	 
    	 Ext.each(permissionList, function(privilege) {
    		 if (privilege == 'ENABLE_SORTING_CONFIGURATION') {
    				 showEnableSorting = true;
    		 } 
    	 });
    	
		if(showEnableSorting && (gridClass=='Academia.view.examinationcenters.remark.EvaluationRemarkGrid' && (portalId==1 || portalId==2))){
			enableSortingCheckBox.setVisible(true);
		}else{
			enableSortingCheckBox.setVisible(false);
			enableSortingCheckBox.setValue(false)
		}
		
		return showEnableSorting;
    }
});