/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.controller.enquiry.EnquiryRevampController', {
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
	models: ['enquiry.EnquiryModel','campaign.CampaignModel', 'organization.Country',
	         'enquiry.assignhours.AssignHoursModel', 'enquiry.assignhours.AssignHoursSubmitModel', 'enquiry.ViewDocuments', 'enquiry.dashboard.FollowupScheduled'
	         ],
	         stores: ['enquiry.EnquirySourceStore', 'campaign.CampaignComboStore','enquiry.ReferredIdStore',
	                  'enquiry.EnquiryRegisteredBy','enquiry.ReferredStudentId','common.CountryStore',
	                  'organization.CityStore','enquiry.FollowUpUserWithDepartment','enquiry.EnquiryGridStore',
	                  'common.SalutationStore','common.AcademyLocationNameSeparated','enquiry.AcademicBatchStore',
	                  'common.ProgramByAcAndLoIdStore','enquiry.ProgramBatchSeatTypeStore','enquiry.ProxyMemoryStore',
	                  'enquiry.assignhours.AssignHoursStore','enquiry.dashboard.CountOfEnquiry', 'scholarships.LogedInUserAcademyLocationStore',
	                  'enquiry.dashboard.EnquiryClosureReasonStore','common.CountryStoreSmartSearch',
	                  'organization.CityByCountryRegion','organization.CountryRegionStore','enquiry.ReferredInternalUserId',
	                  'admission.applicationFormSale.ProgramGroupComboStore',
	                  'campaignnew.CampaignNameFilterStore','enquiry.EnquiryModeStore','campaignnew.CampaignSchoolNameStore',
	                  'campaignnew.AllSchoolPriorityStore','enquiry.EducationDepartmentStore','common.ExamBoardStore'

	                  /*'organization.academylocations.AcademyStore', '', 'common.AcademyStore', 'common.AcademyLocationByAcademyId',
		'common.ProgramByAcademyLocationStore', 'common.UsersWithDepartmentStore',
		 'organization.CountryRegionStore',
		'', 
		'enquiry.dashboard.FollowupScheduled', 
		'enquiry.dashboard.EnquiryClosureReasonStore','enquiry.dashboard.CountOfEnquiry','enquiry.dashboard.PendingEnquiry','enquiry.dashboard.PendingEnquiryFormGrid',*/
	                  ],

	                  views: ['enquiry.EnquiryStructure', 'enquiry.EnquiryForm', 'enquiry.EnquiryGrid', 'enquiry.EnquiryMulProgramForm', 
	                          'enquiry.assignhours.EnquiryAssignHoursStructure','enquiry.assignhours.EnquiryAssignHoursGrid',
	                          'enquiry.EnquiryFormRevamp','enquiry.EnquiryFormRevampStructure','enquiry.EnquiryRevampGrid'
	                          /*'', '', 'enquiry.assignhours.EnquiryAssignHours',
		'enquiry.ViewPastRecordsStructure', 'enquiry.ViewPastSearchForm', 'enquiry.import.EnquiryImportForm', 'enquiry.import.EnquiryImportStructure',
		'enquiry.dashboard.EnquiryDashboardManagementStructure', 'enquiry.dashboard.EnquiryDashBoardChart', 'enquiry.dashboard.FollowupScheduledStructure',
		'enquiry.dashboard.FollowupScheduledForm', 'enquiry.dashboard.FollowupScheduledGrid', 'enquiry.dashboard.PendingEnquiryForm',
		'enquiry.dashboard.DashBoardChartForClosureReason', 'enquiry.dashboard.GroupBarChartForCountofEnquiry', 'enquiry.dashboard.RichTipChartForClosureRate',
		'enquiry.dashboard.PendingEnquiryGrid','enquiry.dashboard.EnquiryGridsForPendingEnquiryDashboard'*/
	                          ],
	                          config: {
	                        	  /*
	                        	   * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	                        	   */
	                        	  /**
	                        	   * @cfg {Array} ENQUIRY_PERMISSIONS array (required)
	                        	   * The array of permissions to use for Access control wise enabling and disabling buttons.
	                        	   * @accessor
	                        	   */
	                        	  ENQUIRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_PRIVILEGES'),
	                        	  FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FOLLOWUPSCHEDULED_PRIVILEGES'),
	                        	  ENQUIRYDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRYDASHBOARD_PRIVILEGES'),

	                        	  COUNT_OF_ENQUIRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COUNT_OF_ENQUIRY_PRIVILEGES'),
	                        	  ENQUIRY_CLOSURE_RATE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_CLOSURE_RATE_PRIVILEGES'),
	                        	  ENQUIRY_CLOSURE_REASON_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_CLOSURE_REASON_PRIVILEGES'),
	                        	  ENQUIRY_FOLLOWUP_SCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_FOLLOWUP_SCHEDULED_PRIVILEGES'),
	                        	  PENDING_ENQUIRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PENDING_ENQUIRY_PRIVILEGES'),
	                        	  STUDENT_DETAILS_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_DETAILS_PRIVILEGES'),

	                          },    
	                          refs: [{
	                        	  ref: 'contentpanel',
	                        	  selector: 'contentpanel'
	                          }, {
	                        	  ref: 'enquiryformrevamp',
	                        	  selector: 'enquiryformrevamp'
	                          },{
	                        	  ref:'searchresultgrid',
	                        	  selector:'searchresultgrid[itemId=trackenquirygrid]'
	                          },{
	                        	  ref:'enquirygrid',
	                        	  selector:'enquirygrid'
	                          }],
	                          init: function() {
	                        	  this.control({


	                        		  /*'enquiryform combo#followUpUser': {
                          select:function(obj, record){
                        	 var department = Ext.ComponentQuery.query('textfield#departmentName')[0];
                        	 department.setValue(record[0].data.code);
                          }
            		  },*/
	                        		  'enquiryformrevamp combo#enquiryTypeCombo': {
	                        			  change: function(obj, newRecord) {
	                        				  var $this = this;
	                        				  var form = this.getEnquiryformrevamp().getForm();
	                        				  var sourceOther = form.findField("enquirySourceOther");
	                        				  sourceOther.setVisible(false);
	                        				  form.findField("enquirySource").clearValue();
	                        				  if (newRecord != 1) {
	                        					  this.getEnquirygrid().hide();
	                        				  } else {
	                        					  var grid = this.getEnquirygrid();
	                        					  grid.show();
	                        					  grid.getStore().removeAll();
	                        				  }
	                        				  var enqTypeData = obj.getStore().findRecord('id',newRecord);
	                        				  var enqTypeCode = null;
	                        				  if(enqTypeData!=undefined && !isNullOrEmpty(enqTypeData)) {
	                        					  var enqTypeCode = enqTypeData.data.code;
	                        			  	  }
	                        				  if (enqTypeCode == 'Counselling') {
	                        					  this.checkProgramCategoryDfr(form);
	                        				  }
	                        				  else {
	                        					  var programCategoryField = form.findField('programCategory');
	                        					  programCategoryField.setVisible(false);
	                        					  programCategoryField.allowBlank = true;
	                        					  programCategoryField.reset();
	                        					  var checkFormValidity = $this.getEnquiryformrevamp();
	  		                        			  checkFormValidity.getForm().checkValidity();
	                        				  }
	                        			  },
	                        			  select: function(obj, record) {
	                        				  var $this = this;
	                        				  var form = this.getEnquiryformrevamp().getForm();
	                        				  var id = record[0].get("id");
	                        				  var enquiryType = record[0].get("code");
	                        				  var enquirerFirstName = form.findField("enquirerFirstName");
	                        				  var enquirerMiddleName = form.findField("enquirerMiddleName");
	                        				  var enquirerLastName = form.findField("enquirerLastName");
	                        				  var enquirySource = form.findField("enquirySource");
	                        				  var nationId = form.findField("nationalId");
	                        				  var areYouSouthAfrStudent = form.findField("isLearnerSACitizenItemId");
	                        				  /*
													Check DFR Functionality For National id and AreYouSouthAfrStudent
	                        				  */
	                        				  var checkVisableNationalId=false;
	                        				  var checkisMandatoryNationalId=false;
	                        				  var checkVisableSoutStudent=false; 

	                        				  var checkNationalId = this.checkNationalId(nationId);
	                        				  var checkAreYouSouthAfrStudent = this.checkAreYouSouthAfrStudent(areYouSouthAfrStudent);
	                        				  
	                        				  if(checkNationalId == true){
	                        					  checkVisableNationalId = nationId.isVisible();
		                        				  checkisMandatoryNationalId = nationId.allowBlank;
	                        				  }
	                        				  if(checkAreYouSouthAfrStudent==true){
		                        				  checkVisableSoutStudent = areYouSouthAfrStudent.isVisible();	                        					  
	                        				  }
	                        				  
	                        				  if (enquiryType == getCommonTranslation('CNTRL_CORPORATE')) {
	                        					  enquirerFirstName.setVisible(true);
	                        					  enquirerMiddleName.setVisible(true);
	                        					  enquirerLastName.setVisible(true);
	                        					  enquirerFirstName.allowBlank =false;
	                        					  nationId.allowBlank=true;
	                        				  } else {
	                        					  enquirerFirstName.setVisible(true);
	                        					  enquirerMiddleName.setVisible(true);
	                        					  enquirerLastName.setVisible(true);
 	                        					  enquirySource.setVisible(true);
 	                        					  enquirerFirstName.allowBlank = false;
	                        					  nationId.allowBlank=true;
	                        				  }
	                        				  var registeredBy = form.findField("registeredBy").getValue();
	                        				  if(record[0].get("code")=='Admission' && registeredBy=='PROSPECTIVE_STUDENT'){
	                        					  if(checkNationalId==true ){
	                        						  if(checkVisableNationalId){
	                        							  nationId.setVisible(true);
	                        						  }else{
	                        							  nationId.setVisible(false);
	                        						  }
	                        						  if(!checkisMandatoryNationalId){
	                        							  if(!checkVisableNationalId){
	                        								  nationId.allowBlank=true;
	                        							  }else{
	                        								  nationId.allowBlank=false;	                        							  
	                        							  }
	                        						  }else{
	                        							  nationId.allowBlank=true;
	                        						  }
	                        					  }else{
	                        						  nationId.setVisible(true);
	                        						  nationId.allowBlank=true;
	                        					  }
	                        					  if(checkAreYouSouthAfrStudent){
	                        						  if(checkVisableSoutStudent){
	                        							  areYouSouthAfrStudent.setVisible(true);   
	                        						  }else{
	                        							  areYouSouthAfrStudent.setVisible(false); 
	                        						  }
	                        					  }else{
	                        						  areYouSouthAfrStudent.setVisible(true);
	                        					  }
	                        				  }else{
	            	                        	  nationId.setVisible(false);
	            	                        	  areYouSouthAfrStudent.setVisible(false);
	            	                        	  nationId.allowBlank=true;
	            	                        	  nationId.reset();
	            	                        	  areYouSouthAfrStudent.reset();
	                        				  }
	                        				  Ext.Ajax.request({
	                        					  method: 'GET',
	                        					  url: SERVERURL.ENQUIRY_ADMISSION_TYPE,
	                        					  params: {
	                        						  id: id
	                        					  },
	                        					  success: function(response) {
	                        						  var id = Ext.decode(response.responseText);
	                        						  if (id != null && id > 0) {
	                        							  var store = $this.getStore('common.UsersWithDepartmentStore');
	                        							  store.load({
	                        								  callback: function(record, operation, success) {
	                        									  if (success) {
	                        										  form.findField("followUpUser").setValue(id);
	                        									  }
	                        								  }
	                        							  });
	                        						  } else {
	                        							  form.findField("followUpUser").clearValue();
	                        						  }
	                        					  }
	                        				  });
	                        			  }
	                        		  },
	                        		  'enquiryformrevamp combo#enqRegByStudent': {
	                        			  select: function(obj, record){
	                        				  var data = record[0].data;
	                        				  var form = this.getEnquiryformrevamp().getForm();
	                        				  /**
	                        				   * load data in address fields while selecting student in create enquiry form.
	                        				   */
	                        				  this.loadDataInAddressFieldsInCreateEnquiryForm(data,form);
	                        			  }
	                        		  },
	                        		  'enquiryformrevamp combo#enqRegByInternalUser': {
	                        			  select: function(obj, record){
	                        				  var data = record[0].data;
	                        				  var form = this.getEnquiryformrevamp().getForm();
	                        				  /**
	                        				   * load data in address fields while selecting student in create enquiry form.
	                        				   */
	                        				  this.loadDataInAddressFieldsInCreateEnquiryForm(data,form);
	                        			  }
	                        		  },
	                        		  'enquiryformrevamp combo#registeredBy': {
	                        			  select: function(obj, record) {
	                        				  var $this = this;
	                        				  var form=obj.up('form').getForm();
	                        				  var enqRegByStudentField = this.getEnquiryformrevamp().down('textfield#enqRegByStudent');
	                        				  var enqregByInteralUser = this.getEnquiryformrevamp().down('#enqRegByInternalUser');
	                        				  var raiseEnquirySalutationField = this.getEnquiryformrevamp().down('#raiseEnqSalutaion');
	                        				  var nationId = form.findField("nationalId");
            	                        	  var areYouSouthAfrStudent = form.findField("isLearnerSACitizenItemId");
	                        				  var refType = obj.getValue();
	                        				  var enqType  = form.findField("enquiryType");
	                        				  var enqTypeData = enqType.getStore().findRecord('id',enqType.value);
	                        				  var enqTypeCode = enqTypeData.data.code;
	                        				  
	                        				  enqRegByStudentField.setVisible(false);
	                        				  enqRegByStudentField.reset();
	                        				  enqRegByStudentField.allowBlank = true;
	                        				  enqregByInteralUser.setVisible(false);
	                        				  enqregByInteralUser.reset();
	                        				  enqregByInteralUser.allowBlank = true;
	                        				  raiseEnquirySalutationField.reset();

	                        				  /*
												Check DFR Functionality For National id and AreYouSouthAfrStudent
	                        				   */
	                        				  var checkVisableNationalId=false;
	                        				  var checkisMandatoryNationalId=false;
	                        				  var checkVisableSoutStudent=false; 

	                        				  var checkNationalId = this.checkNationalId(nationId);
	                        				  var checkAreYouSouthAfrStudent = this.checkAreYouSouthAfrStudent(areYouSouthAfrStudent);
	                        				  
	                        				  if(checkNationalId == true){
	                        					  checkVisableNationalId = nationId.isVisible();
		                        				  checkisMandatoryNationalId = nationId.allowBlank;
	                        				  }
	                        				  if(checkAreYouSouthAfrStudent==true){
		                        				  checkVisableSoutStudent = areYouSouthAfrStudent.isVisible();	                        					  
	                        				  }

	                        				  if(refType == 'STUDENT'){
	                        					  enqRegByStudentField.setVisible(true);
	                        					  enqRegByStudentField.allowBlank = false;
	                        					  enqRegByStudentField.setFieldLabel(getCommonTranslation('STUDENT_ID_STUDENT_NAME')+'<span class="required" style="color:red"> *</span>');
	                        					  var store = this.getStore('enquiry.ReferredStudentId');
		                        				  store.getProxy().extraParams = {
		                        					  name: "%%%"
		                        				  };
//		                        				  store.load();
		                        				  nationId.reset();
	            	                        	  areYouSouthAfrStudent.reset();
	            	                        	  nationId.setVisible(false);
	            	                        	  areYouSouthAfrStudent.setVisible(false);
	            	                        	  nationId.allowBlank=true;
		                        				  form.isValid();
	                        				  }else if(refType == 'INTERNAL_USERS'){
	                        					  enqregByInteralUser.setVisible(true);
	                        					  enqregByInteralUser.allowBlank = false;
	                        					  enqregByInteralUser.setFieldLabel(getCommonTranslation('INTERNAL_USER')+'<span class="required" style="color:red"> *</span>');
	                        					 var store = enqregByInteralUser.getStore();
	                        					 store.getProxy().extraParams = {
	                        						 name: ""
		                        				  };
		                        				  store.load();
	            	                        	  nationId.setVisible(false);
	            	                        	  areYouSouthAfrStudent.setVisible(false);
	            	                        	  nationId.allowBlank=true;
	            	                        	  nationId.reset();
	            	                        	  areYouSouthAfrStudent.reset();
		                        				  form.isValid();
	                        				  }else if(refType == 'PROSPECTIVE_STUDENT' && enqTypeCode=='Admission'){
	                        					  if(checkNationalId==true ){
	                        						  if(checkVisableNationalId){
	                        							  nationId.setVisible(true);
	                        						  }else{
	                        							  nationId.setVisible(false);
	                        						  }
	                        						  if(!checkisMandatoryNationalId){
	                        							  if(!checkVisableNationalId){
	                        								  nationId.allowBlank=true;
	                        							  }else{
	                        								  nationId.allowBlank=false;	                        							  
	                        							  }
	                        						  }else{
	                        							  nationId.allowBlank=true;
	                        						  }
	                        					  }else{
	                        						  nationId.setVisible(true);
	                        						  nationId.allowBlank=true;
	                        					  }
	                        					  if(checkAreYouSouthAfrStudent){
	                        						  if(checkVisableSoutStudent){
	                        							  areYouSouthAfrStudent.setVisible(true);   
	                        						  }else{
	                        							  areYouSouthAfrStudent.setVisible(false); 
	                        						  }
	                        					  }else{
	                        						  areYouSouthAfrStudent.setVisible(true);
	                        					  }
	                        				  }else{
	                        					  form.findField('enquirerFirstName').reset();
	                        					  form.findField('enquirerMiddleName').reset();
	                        					  form.findField('enquirerLastName').reset();
	            	                        	  form.findField("nationalId").reset();
	            	                        	  form.findField("isLearnerSACitizenItemId").reset();
	            	                        	  form.findField("nationalId").setVisible(false);
	            	                        	  form.findField("nationalId").allowBlank=true;
	            	                        	  form.findField("isLearnerSACitizenItemId").setVisible(false);
	                        					  /**
	                        					   * load data in address fields while selecting student in create enquiry form.
	                        					   */
	                        					  var data=null;
	                        					  this.loadDataInAddressFieldsInCreateEnquiryForm(data,form);
	                        				  }
	                        			  }  
	                        		  },
	                        		  'enquiryformrevamp combo#academyLocationId': {
	                        			  select: function(obj, record) {
	                        				  var form =this.getEnquiryformrevamp().getForm();
	                        				  var program=form.findField('programId').reset();
	                        				  var batch=form.findField('batchId').reset();
	                        				  var seatType=form.findField('seatTypeId').reset();
	                        				  var academyLocationId = record[0].get("id");
	                        				  if (academyLocationId > 0) {
	                        					  var store = this.getStore('common.ProgramByAcAndLoIdStore');
	                        					  store.getProxy().extraParams = {
	                        						  academyLocationId: academyLocationId
	                        					  };
	                        					  store.load();
	                        				  }
	                        			  }
	                        		  },
	                        		  'enquiryformrevamp combo#programId': {
	                        			  select: function(obj, record) {
	                        				  var form =this.getEnquiryformrevamp().getForm();
	                        				  var batch=form.findField('batchId').reset();
	                        				  var seatType=form.findField('seatTypeId').reset();
	                        				  var programId = record[0].get("id");
	                        				  if (programId > 0) {
	                        					  var store = this.getStore('enquiry.AcademicBatchStore');
	                        					  store.getProxy().extraParams = {
	                        						  id: programId
	                        					  };
	                        					  store.load();
	                        				  }
	                        			  }
	                        		  },
	                        		  'enquiryformrevamp combo#batchId': {
	                        			  select: function(obj, record) {
	                        				  var form =this.getEnquiryformrevamp().getForm();
	                        				  var seatType=form.findField('seatTypeId').reset();
	                        				  var batchId = record[0].get("id");
	                        				  if (batchId > 0) {
	                        					  var store = this.getStore('enquiry.ProgramBatchSeatTypeStore');
	                        					  store.getProxy().extraParams = {
	                        						  id: batchId
	                        					  };
	                        					  store.load();
	                        				  }
	                        			  }
	                        		  },
	                        		  'enquiryformrevamp customcombobox#countryComboId': {
	              	        			select: function(obj, record) {
	              	        				var form = obj.up('form');
	              	        				form.down('#countryRegionComboId').clearValue();
	              	        				form.down('#countryRegionComboId').setDisabled(false);
	              	        				form.down('#cityComboId').clearValue();
	              	        				form.down('#cityComboId').setDisabled(true);
	              	        				var countryId = record[0].get("id");
	              	        				if (countryId > 0) {
	              	        					var store = form.down('#countryRegionComboId').getStore();
	              	        					store.getProxy().extraParams = {
	              	        						cid: countryId
	              	        					};
	              	        					store.load();
	              	        				}
	              	        				form.getForm().checkValidity();
	              	        			 }
	              	        		  },
	              	        		  'enquiryformrevamp customcombobox#countryRegionComboId':{
	              	        			select:function(obj,rec){
	              	        				var form = obj.up('form');
	              	        				form.down('#cityComboId').clearValue();
	              	        				form.down('#cityComboId').setDisabled(false);
	              	        				var countryRegionId=rec[0].data.id;
	              	        				var store = form.down('#cityComboId').getStore();
	              	        				store.getProxy().extraParams = {
	              	        					id: countryRegionId
	              	        				};
	              	        				store.load();
	              	        				form.getForm().checkValidity();
	              	        			}
	              	        		  },
	                        		  'enquiryformrevamp button#enquirySubmitButtonId': {
	                        			  click: this.addEnquiry
	                        		  },
	                        		  // button to reset enquiry form
	                        		  'enquiryformrevamp button#enquiryform_cancelbuttonId':{
	                        			  click: function(obj) {
	                        				  var form = this.getEnquiryformrevamp();
	                        				  form.getForm().reset();
	                        				  form.getForm().findField('enqRegByStudent').setVisible(false);
	                        				  var enqGrid = this.getEnquirygrid();
	                        				  enqGrid.setVisible(true);
	                        				  enqGrid.getStore().removeAll();
	                        		
	                        				  var CampaignSchoolStore = form.getForm().findField("campaignSchool").getStore();	  
	                        				  CampaignSchoolStore.getProxy().extraParams = {};
	                        				  CampaignSchoolStore.load();
	                        				  this.setAllowBlank(form.getForm().findField('campaignSchool'),true);	                        				  
	                        				  
	                        				  form.getForm().findField("countryRegionCombo").setDisabled(true);
	                        				  form.getForm().findField("cityCombo").setDisabled(true);
	                        				  var schoolPriorityField = form.getForm().findField("schoolPriority");
	                        				  var newSchoolPriorityField = form.getForm().findField("schoolPriorityNew");
            	                        	  schoolPriorityField.setVisible(false);
            	                        	  this.loadDFRForSchoolPriority(newSchoolPriorityField);
            	                        	  var programCategoryField = form.getForm().findField("programCategory");
            	                        	  programCategoryField.setVisible(false);
            	                        	  programCategoryField.allowBlank = true;
	                        			  }
	                        		  },

	                        		  'enquiryformrevamp textfield#cellNumber': {
	                        			  blur: function(obj, record) {
	                        				  var data = obj.getValue();
	                        				  if (data) {
	                        					  var Url = SERVERURL.ENQUIRY_CHECK_CELL_NO + '?cellNo=' + data;
	                        					  this.checkUniqRecords(Url);
	                        				  }
	                        			  }
	                        		  },
	                        		  'enquiryformrevamp textfield#regdEmail': {
	                        			  blur: function(obj, record) {
	                        				  var data = obj.getValue();
	                        				  if (data) {
	                        					  var Url = SERVERURL.ENQUIRY_CHECK_EMAIL + '?email=' + data;
	                        					  this.checkUniqRecords(Url);
	                        				  }
	                        			  }
	                        		  },

	                        		  'enquiryformrevamp button[itemId=addFilterBtn]':{
	                        			  click: function(obj){
	                        				  this.addMultipleStudentDetailsfilter(obj);
	                        			  }
	                        		  },

	                        		  'enquiryformrevamp': {
	                        			  afterrender: function() {
	                        				  var $this=this;
	                        				  var form = this.getEnquiryformrevamp().getForm();
	                        				  var currentLoggedUser=this.getCurrentlyLoggedInUser();
	                        				  var enquiryTypeField = form.findField("enquiryType");
	                        				  var enquirerFirstName = form.findField("enquirerFirstName");
	                        				  var enquirerMiddleName = form.findField("enquirerMiddleName");
	                        				  var enquirerLastName = form.findField("enquirerLastName");
	                        				  var regdEmail=form.findField("regdEmail");
	                        				  var nationId = form.findField("nationalId");
            	                        	  var areYouSouthAfrStudent = form.findField("isLearnerSACitizenItemId");
            	                        	  var schoolPriorityField = form.findField("schoolPriority");
            	                        	  nationId.setVisible(false);
            	                        	  areYouSouthAfrStudent.setVisible(false);
            	                        	  schoolPriorityField.setVisible(false);
            	                        	  nationId.reset();
            	                        	  areYouSouthAfrStudent.reset();
	                        				  enquiryTypeField.store.load({
	                        					  callback: function(records, operation, success) {
	                        						  if (success) {
	                        							  var id;
	                        							  for(var i=0; i<records.length; i++){
	                        								  var code = records[i].data.code;
	                        								  if(code == 'Admission'){
	                        									  id=records[i].data.id;
	                        								  }
	                        							  }
	                        							  enquiryTypeField.setValue(id);
	                        							  
	                        				 //Cause of already seted pros. student
	                        							  var nationId = form.findField("nationalId");
	                    	                        	  var areYouSouthAfrStudent = form.findField("isLearnerSACitizenItemId");
	        	                        				  var enqType  = form.findField("enquiryType");
	        	                        				  var enqTypeData = enqType.getStore().findRecord('id',enqType.value);
	        	                        				  var enqTypeCode = enqTypeData.data.code;
	        	                        				  /*
	        												Check DFR Functionality For National id and AreYouSouthAfrStudent
	        	                        				   */
	        	                        				  var checkVisableNationalId=false;
	        	                        				  var checkisMandatoryNationalId=false;
	        	                        				  var checkVisableSoutStudent=false; 

	        	                        				  var checkNationalId = $this.checkNationalId(nationId);
	        	                        				  var checkAreYouSouthAfrStudent = $this.checkAreYouSouthAfrStudent(areYouSouthAfrStudent);
	        	                        				  
	        	                        				  if(checkNationalId == true){
	        	                        					  checkVisableNationalId = nationId.isVisible();
	        		                        				  checkisMandatoryNationalId = nationId.allowBlank;
	        	                        				  }
	        	                        				  if(checkAreYouSouthAfrStudent==true){
	        		                        				  checkVisableSoutStudent = areYouSouthAfrStudent.isVisible();	                        					  
	        	                        				  }
	        	                        				  var refType = form.findField("registeredBy").getValue();
	        	                        				  if(refType == 'PROSPECTIVE_STUDENT' && enqTypeCode=='Admission'){
	        	                        					  if(checkNationalId==true ){
	        	                        						  if(checkVisableNationalId){
	        	                        							  nationId.setVisible(true);
	        	                        						  }else{
	        	                        							  nationId.setVisible(false);
	        	                        						  }
	        	                        						  if(!checkisMandatoryNationalId){
	        	                        							  if(!checkVisableNationalId){
	        	                        								  nationId.allowBlank=true;
	        	                        							  }else{
	        	                        								  nationId.allowBlank=false;	                        							  
	        	                        							  }
	        	                        						  }else{
	        	                        							  nationId.allowBlank=true;
	        	                        						  }
	        	                        					  }else{
	        	                        						  nationId.setVisible(true);
	        	                        						  nationId.allowBlank=true;
	        	                        					  }
	        	                        					  if(checkAreYouSouthAfrStudent){
	        	                        						  if(checkVisableSoutStudent){
	        	                        							  areYouSouthAfrStudent.setVisible(true);   
	        	                        						  }else{
	        	                        							  areYouSouthAfrStudent.setVisible(false); 
	        	                        						  }
	        	                        					  }else{
	        	                        						  areYouSouthAfrStudent.setVisible(true);
	        	                        					  }
	        	                        				  }
	                        						  }
	                        					  }
	                        				  });
	                        				  Ext.Ajax.request({
	        	                        		  type: 'rest',
	        	                        		  url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
	        	                        		  method: 'GET',
	        	                        		  success: function(response, action) {
	        	                        			  var MSSG = response.responseText;
	        	                        			  var jdata = Ext.decode(response.responseText);
	        	                        			  var defaultCountryId = -1;
	        	                        			  if(!isNullOrEmpty(jdata.id)){
	        	                        				  defaultCountryId = jdata.id; 
	        	                        			  }
	    	                        					 var phoneCode=form.findField('phoneCountryCode');
	    	                        					 phoneCode.getStore().load({
	    		                        					  callback: function(records, operation, success) {
	    		                        						  if (success) {
	    		                        							  for(i in records){
	    		                        								  if(defaultCountryId == -1){
	    		                        									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
		    		                        									  phoneCode.setValue(records[i].data.isdCode);  									  
		    		                        								  } 
	    		                        								  }else{
	    		                        									  if(records[i].data.id == defaultCountryId){
		    		                        									  phoneCode.setValue(records[i].data.isdCode);  									  
		    		                        								  }
	    		                        								  }
	    		                        							  }
	    		                        						  }
	    		                        					  }
	    		                        				  });
	    	                        					 var alternatePhoneCode=form.findField('alternatePhoneCountryCode');
	    	                        					 alternatePhoneCode.getStore().load({
	    		                        					  callback: function(records, operation, success) {
	    		                        						  if (success) {
	    		                        							  for(i in records){
	    		                        								  if(defaultCountryId == -1){
		    		                        								  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
		    		                        									  alternatePhoneCode.setValue(records[i].data.isdCode);  									  
		    		                        								  }
	    		                        								  }else{
	    		                        									  if(records[i].data.id == defaultCountryId){
	    		                        										  alternatePhoneCode.setValue(records[i].data.isdCode);  									  
		    		                        								  }
	    		                        								  }
	    		                        							  }
	    		                        						  }
	    		                        					  }
	    		                        				  });
	        	                        			  
	        	                        		  }
	                        				  });
	                        				  
	                        				  var locations = [];
	                        				  var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
	                        				  for(var i=0; i<academyLocationList.length; i++){
	                        					  locations.push(academyLocationList[i].id);
	                        				  }
	                        				  followUpUserStore = form.findField("followUpUser").getStore();
	                        				  followUpUserStore.getProxy().extraParams = {
	                        					  academyLocationIds: locations.join()
	                        				  };
	                        				  followUpUserStore.load();
	                        				  if(isNullOrEmpty(form.findField("enquiryDate").getValue())) {
	                        					  form.findField("enquiryDate").setValue(new Date());
	                        				  }
	                        			  }
	                        		  },
	                        		  'enquirygrid': {
		                        		  afterrender:function(grid){
		                        			  var me = this;
		                        			  me.addDataGridConfigButton(grid,me.getSTUDENT_DETAILS_PRIVILEGES());
		                        	      }
                        			  },
	                        		  'enquiryformrevamp customcombobox#campaignNew': {
	                        			  render: function(obj){
	                        				  var campaignNewStore = obj.getStore();
	                        				  campaignNewStore.getProxy().extraParams = {
	                        					  academyLocationIds:this.getCurrentAcademyLocation(),
	                        					  isActive:true
	                        				  };
	                        				  campaignNewStore.load();
	                        			  },
	                        			  select: function(obj, record){
	                        				  var campaignId = record[0].get("id");
	                        				  var form = obj.up('form');
	                        				  var campaignSchoolCombo = form.down("#campaignSchool");
	                        				  var campaignTypeField = form.down("#campaignType");
	                        				  var presentationTypeField = form.down("#presentationType");
	                        				  var schoolPriorityField = form.down("#schoolPriority");
	                        				  var newSchoolPriorityField = form.down("#schoolPriorityNew");
	                        				  var intakeYear = form.down("#enqIntakeYear");
	                        				  var registrationType = form.down("#regType");
	                        				  schoolPriorityField.reset();
	                        				  schoolPriorityField.setVisible(true);
	                        				  newSchoolPriorityField.setVisible(false);
	                        				  this.loadDFRForSchoolPriority(schoolPriorityField);
	                        				  $this = this;
	                        				  $this.setAllowBlank(campaignSchoolCombo,true);
	                        				  if( form.isValid() ){
	                        					  form.down("#enquirySubmitButtonId").setDisabled(false);
	                        				  } else{
	                        					  form.down("#enquirySubmitButtonId").setDisabled(true);
	                        				  }
	                        				  if(campaignId!=null){
	                        					  var url = SERVERURL.PATH_CAMPAIGN_DEATIL_BY_ID +"?campaignId="+campaignId;
	                        					  Ext.Ajax.request({
	                        						  type: 'rest',
	                        						  url: url,
	                        						  method: 'GET',
	                        						  success: function(response) {
	                        							  if(response.responseText != null && response.responseText != ""){
	                        								  var responseData = Ext.JSON.decode(response.responseText);
	                        								  if( !isNullOrEmpty(campaignTypeField) && !isNullOrEmpty(responseData.campaignType) ){
	                        									  campaignTypeField.setValue(responseData.campaignType);
	                        								  }
	                        								  if( !isNullOrEmpty(presentationTypeField) && !isNullOrEmpty(responseData.presentationType) ){
	                        									  presentationTypeField.setValue(responseData.presentationType);
	                        								  }
	                        								  if(!isNullOrEmpty(intakeYear) && !isNullOrEmpty(responseData.intakeYearId) ){
	                        									  intakeYear.getStore().load({
	                        										  callback: function(records, operation, success) {
	                        											  for(i in records){
	                        												  if(records[i].data.id==responseData.intakeYearId){
	                        													  intakeYear.setValue(records[i].data.id);  
	                        												  }
	                        											  }
	                        										  }	
	                        									  });
	                        								  }else if( !isNullOrEmpty(intakeYear)){
	                        									  intakeYear.reset();
	                        								  }
	                        								  if( !isNullOrEmpty(registrationType) && !isNullOrEmpty(responseData.registrationType) ){
	                        									  registrationType.setValue(responseData.registrationType);
	                        								  }
	                        						  		}
	                        						     }
	                        					  });
	                        					 }
	                        				  var campaignSchoolStore = campaignSchoolCombo.getStore();
	                        				  campaignSchoolStore.getProxy().extraParams = {
	                        					  campaigId:campaignId
	                        				  };
	                        				  
	                        				  var educationDepartmentCombo = form.down("#educationDepartmentItemId");
	                        				  
	                        				  var educationDepartmentId = null;
	                        				  var isEducationDeptOthers = false;
	                        				  if( !isNullOrEmpty(educationDepartmentCombo) && !isNullOrEmpty(educationDepartmentCombo.getValue()) ) {
	                        					  educationDepartmentId = educationDepartmentCombo.getValue();
	                        					  if( educationDepartmentCombo.getRawValue() == 'Others' ){
                            						  isEducationDeptOthers = true;
                            					  }
                            					  campaignSchoolStore.getProxy().extraParams.educationDepartmentId = educationDepartmentId;
                            					  campaignSchoolStore.getProxy().extraParams.isEducationDeptOthers = isEducationDeptOthers;
                            				  }
	                        				  
	                        				  campaignSchoolStore.removeAll();
	                                          campaignSchoolCombo.reset();
	                                          
	                        				  campaignSchoolStore.load({
	                        					  callback: function(records, operation, success) {	                        						
	                        						  if(records.length!=0){
	                        							  $this.setAllowBlank(campaignSchoolCombo,false);
	                        							  if( records.length != 1 ){
                        									  if( form.isValid() ){
    	        	                        					  form.down("#enquirySubmitButtonId").setDisabled(false);
    	        	                        				  } else{
    	        	                        					  form.down("#enquirySubmitButtonId").setDisabled(true);
    	        	                        				  }
                        								  }
	                        						  }
	                        						  if( !isNullOrEmpty(records) && records.length == 1 ){
	                        							  campaignSchoolCombo.select(records[0].data.schoolId);
	                        							  schoolPriorityField.setValue(records[0].data.schoolPriority.value);
	                        						  }
	                        					  }  
	                        				  });
	                        			  }
	                        		  },
	                        		  'enquiryformrevamp customcombobox#educationDepartmentItemId': {
	                        			  select: function(obj, record){
	                        				  var educationDepartmentId = record[0].get("id");
	                        				  var form = obj.up('form');
	                        				  var campaignSchoolCombo = form.down("#campaignSchool");
	                        				  var campaignSchoolStore = campaignSchoolCombo.getStore();
	                        				  
                            				  var isEducationDeptOthers = false;
                            				  var educationDepartmentCombo = form.down("#educationDepartmentItemId");

                            				  if( !isNullOrEmpty(educationDepartmentCombo) && !isNullOrEmpty(educationDepartmentCombo.getValue()) ) {
                            					  if( educationDepartmentCombo.getRawValue() == 'Others' ){
                            						  isEducationDeptOthers = true;
                            					  }
                            					  campaignSchoolStore.getProxy().extraParams.educationDepartmentId = educationDepartmentId;
                            					  campaignSchoolStore.getProxy().extraParams.isEducationDeptOthers = isEducationDeptOthers;
                            				  }
                            				  
                            				  campaignSchoolStore.removeAll();
	                                          campaignSchoolCombo.reset();
	                                          campaignSchoolCombo.setReadOnly(false);
	                                          
	                                          campaignSchoolStore.load();
	                        				  
	                        			  } 
	                        		  },
	                        		  'enquiryformrevamp customcombobox#campaignSchool': { 
	                        			  render: function(obj){
	                        				  var campaignSchoolStore = obj.getStore();
	                        				  campaignSchoolStore.removeAll();
	                        				  campaignSchoolStore.getProxy().extraParams = {};
	                        				  campaignSchoolStore.load();
	                        			  },
	                        			  select: function(obj, record){
	                        				  var form = obj.up('form');
	                        				  var campaignNewCombo = form.down("#campaignNew");
	                        				  var campaignIdd = campaignNewCombo.getValue();
	                        				  if( !isNullOrEmpty(campaignIdd) ){
	                        					  var schoolPriorityField = form.down("#schoolPriority");
	                        					  schoolPriorityField.setValue(record[0].data.schoolPriority.value);                        					 
	                        				  }
	                        			  },
	                        			  change: function(obj, newRecord) {
	                        				  var form = obj.up('form');
	                        				  var newSchoolPriorityField = form.down("#schoolPriorityNew");
	                        				  if (newRecord != null) {
	                        					  newSchoolPriorityField.setDisabled(false);
	                        				  } else {
	                        					  newSchoolPriorityField.setDisabled(true);
	                        				  }
	                        			  }
	                        			 },
	                        			 'enquiryformrevamp customcombobox#phoneCountryCode': { 
	                        				 select: function(obj, record){
		                        				  var form = obj.up('form');
		                                      	  var countryCodeField = form.down("#phoneCountryCode");
		                                       	  var mobileField = form.down("#cellNumber");
		                                      	  this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
		                        			  }
		                        		 },
		                        		 'enquiryformrevamp customcombobox#enquirySource': {
		             	                    select: function(rowModel, record) {
		             	                    	var this$ = this;
		             	                    	var form = this$.getEnquiryformrevamp();
		             	                    	var sourceOther = form.down("#enquirySourceOther");
		             	                    	if(record[0].data.value.toLowerCase()=='other' || record[0].data.value.toLowerCase()=='others'){
		            	                    		sourceOther.setVisible(true);
		            	                    		this.loadDFRForsourceOther(sourceOther);
		            	                    	}
		            	                    	else{
		            	                    		sourceOther.reset();
		            	                    		sourceOther.setVisible(false);
		            	                    	}
		             	                    }
		             	                },
		                        		 'enquiryformrevamp customcombobox#cellNumber': { 
		                        		 	  change: function(record){
		                                 	      var form = this.getEnquiryformrevamp();
		                                  	      var mobileField = form.down("#cellNumber");
		                                 	      mobileField.isValid();
		                         			      form.getForm().checkValidity();
		                                      }
		                        		 },
			                        	 'enquiryformrevamp customcombobox#alternatePhoneCountryCode': { 
			                        		 select: function(obj, record){
		                        				  var form = obj.up('form');
		                                      	  var countryCodeField = form.down("#alternatePhoneCountryCode");
		                                       	  var mobileField = form.down("#alternateCellNumber");
		                                      	  this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
		                        			  }
		                        		 },
				                         'enquiryformrevamp customcombobox#alternateCellNumber': { 
				                        	  change: function(record){
		                                 	      var form = this.getEnquiryformrevamp();
		                                  	      var mobileField = form.down("#alternateCellNumber");
		                                 	      mobileField.isValid();
		                         			      form.getForm().checkValidity();
		                                      }
		                        		 },
		                        		 'enquiryformrevampstructure': {
		                         			render:function(structure){
		                         				var $this = this		                         				
		                         				structure.body.on('click', function() {
		                         					var filter = structure.down('enquiryformrevamp');
		                         					$this.hideInvalidIconFromField(filter);
		                         			       });
		                         			}
		                         		},
		                         		/* 'enquirymulprogramform': {
			                         			render:function(Window){
			                         				var $this = this		                         				
			                         				Window.body.on('click', function() {
			                         					//var filter = Window.down('enquirymulprogramform');
			                         					$this.hideInvalidIconFromField(Window);
			                         			       });
			                         			}
			                         		}*/
	                        	  });
	                        	  this.callParent(arguments);
	                          },
	                          showEnquiryForm: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                        	  var grid = grid.ownerCt;
	                        	  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
	                        	  if(e.target.tagName=="A"){
	                        		  if(columnName==getEnquiryTranslation('TRACK_ENQUIRY_NO')){
	                        			  this.getTrackEnquiryController().linkClicked(0,0,grid,'Edit');
	                        		  }
	                        	  }
	                        	  e.stopEvent();
	                        	  e.stopPropagation();
	                        	  return false;
	                          },
	                          getSearchClosureReason:function(){
	                        	  var $this=this;
	                        	  var closureReasonFilter=$this.getClosurereasondashboardfilter();
	                        	  var structure = closureReasonFilter.up('closurereasonstructure');
	                        	  var closureReasonExtraBtns = structure.down('#closureReasonExtraBtns');
	                        	  var chartforclosurereason=$this.getDashboardchartforclosurereason();
	                        	  var getClosureReasonFilter=closureReasonFilter.getForm();
	                        	  var formValues=getClosureReasonFilter.getValues();

	                        	  var organizationForm=$this.getOrganizationunit().getForm();
	                        	  var academyLocation=organizationForm.findField('academyLocation');
	                        	  var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
	                        	  var acdemyLocationArray=[];
	                        	  if(!academyLocation.isHidden()){
	                        		  Ext.Array.each(academyLocation.getValue(),function(value){
	                        			  if(Ext.isObject(value)){
	                        				  acdemyLocationArray.push(value.data.id);
	                        			  }else{
	                        				  acdemyLocationArray.push(value);	
	                        			  }
	                        		  });
	                        	  }
	                        	  if(!multiselectAcademyLocation.isHidden()){
	                        		  Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
	                        			  if(Ext.isObject(value)){
	                        				  acdemyLocationArray.push(value.data.id);
	                        			  }else{
	                        				  acdemyLocationArray.push(value);	
	                        			  }
	                        		  });
	                        	  }
	                        	  var chartforclosurereasonstore=chartforclosurereason.down("#enqbarchartreportId").getStore();
	                        	  chartforclosurereasonstore.getProxy().extraParams={
	                        		  "startDate":formValues.startDate,
	                        		  "endDate":formValues.endDate,
	                        		  "academyLocations": acdemyLocationArray.join()
	                        	  };
	                        	  chartforclosurereasonstore.load();
	                        	  closureReasonExtraBtns.setVisible(true);
	                        	  $this.addExportToPngForDashboard(closureReasonExtraBtns.menu,chartforclosurereason.down('#enqbarchartreportId'));
	                          },
	                          checkUniqRecords: function(submitUrl) {
	                        	  var form = this.getEnquiryformrevamp();
	                        	  Ext.Ajax.request({
	                        		  type: 'rest',
	                        		  url: submitUrl,
	                        		  method: 'GET',
	                        		  success: function(response, action) {
	                        			  var MSSG = response.responseText;
	                        			  if (MSSG == "CELLNO_BLOCKED") {
	                        				  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BLACKLISTED_CELLNO')); //Please select a record
	                        				  form.down("#cellNumber").reset();
	                        			  }
	                        			  if (MSSG == "PHONENO_BLOCKED") {
	                        				  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BLACKLISTED_PHONE')); //Please select a record
	                        				  form.down("#regdPhoneNo").reset();
	                        			  }
	                        			  if (MSSG == "EMAIL_BLOCKED") {
	                        				  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BLACKLISTED_EMAIL')); //Please select a record
	                        				  form.down("#regdEmail").reset();
	                        			  }
	                        		  }
	                        	  });
	                          },
	                          viewPastRecord: function() {
	                        	  var contentpanel = this.getContentpanel();
	                        	  var viewPastRecords = Ext.widget('viewpastrecordsstructure');
	                        	  var tabName = getCommonTranslation('VIEW_PAST_RECORDS');
	                        	  openTab(contentpanel, tabName, viewPastRecords, CONSTANTS.MENU_COLOR_ONE);
	                          },
	                          retainForm: function() {
	                        	  var $this = this;
	                        	  var form = this.getEnquiryform().getForm();
	                        	  var radio = form.findField("retainEnquiryInformation");
	                        	  var YES = radio.items.items[0].checked;
	                        	  var NO = radio.items.items[1].checked;
	                        	  var proxyStore = $this.getStore('enquiry.ProxyMemoryStore');
	                          },
	                          addEnqMulProgGrid: function(f) {
	                        	  var form = this.getEnquirymulprogramform().down('form').getForm();
	                        	  var values = form.getValues();
	                        	  var grid = this.getEnquirygrid();
	                        	  var store = grid.getStore();
	                        	  var salutation = form.findField('salutation').getValue();
	                        	  var studentFname = form.findField('studentFname').getValue();
	                        	  var studentMname = form.findField('studentMname').getValue();
	                        	  var studentLname = form.findField('studentLname').getValue();
	                        	  var academyId = form.findField('academyLocation').getValue();
	                        	  var academyName = form.findField('academyLocation').getRawValue();
	                        	  var programGroup = form.findField('programGroup').getValue();
	                        	  var programGroupName = form.findField('programGroup').getRawValue();
	                        	  var programName = form.findField('programId').getRawValue();
	                        	  var programId = form.findField('programId').getValue();
	                        	  var batchName = form.findField('batchId').getRawValue();
	                        	  var batchId = form.findField('batchId').getValue();
	                        	  var seatTypeName = form.findField('seatTypeId').getRawValue();
	                        	  var seatTypeId = form.findField('seatTypeId').getValue();
	                        	  var studentDob = form.findField('studentDateOfBirth').getValue();

	                        	  var location = academyName.split('-');
	                        	  var data = {
	                        			  studentName: studentFname + " " + studentMname + " " + studentLname,
	                        			  studentFname: studentFname,
	                        			  studentMname: studentMname,
	                        			  studentLname: studentLname,
	                        			  academy: academyName,
	                        			  academyId: academyId,
	                        			  location: location[1],
	                        			  programGroupName: programGroupName,
	                        			  programGroup:programGroup,
	                        			  program: programName,
	                        			  programId: programId,
	                        			  batchId: batchId,
	                        			  batchName: batchName,
	                        			  seatType: seatTypeName,
	                        			  seatTypeId: seatTypeId,
	                        			  salutation:salutation,
	                        			  studentDateOfBirth:studentDob
	                        	  };
	                        	  var records = grid.getSelectionModel().getSelection();
	                        	  var rowIndex = store.indexOf(records[0]);
	                        	  if (rowIndex >= 0) {
	                        		  store.remove(records[0]);
	                        	  }
	                        	  store.loadRawData(data, true);
	                        	  this.getEnquirymulprogramform().close();
	                          },
	                          /*getIdValueJson: function(id, value) {
            	  if (id) return {
            		  id: id,
            		  value: value
            	  };
              },*/
	                          resetComponent: function(component) {
	                        	  Ext.suspendLayouts();
	                        	  component.getFields().each(function(field) {
	                        		  field.reset();
	                        	  });
	                        	  Ext.resumeLayouts();
	                          },
	                          addEnquiry: function(model, records) {
	                        	  var $this = this;
	                        	  var form = this.getEnquiryformrevamp().getForm();
	                        	  var grid = $this.getSearchresultgrid();
	                        	  var contentpanel = this.getContentpanel();
	                        	  var values = form.getValues();
	                        	  var grid = $this.getEnquirygrid();
	                        	  var store = grid.getStore();
	                        	  var myItems = store.getRange();
	                        	  var cellCountryCodeval = values.cellCountrycode;
	                        	  var enqTypeId = form.findField("enquiryType").getValue();
	                        	  var schoolPriorityVal=null;
	                        	  //var enqTypeName = form.findField("enquiryType").getRawValue();
	                              var form = this.getEnquiryformrevamp().getForm();
	                              var id = form.findField("enquiryType").getStore().findRecord('id',enqTypeId);
	                              var enqTypeName = id.data.code;
	                        	  
	                        	  var referId = values.referredType;
	                        	  var followUpUserField = form.findField('followUpUser');
	                        	  var currentLoggedUser=this.getCurrentlyLoggedInUser();
	                        	  var userData={
	                        			  "id":currentLoggedUser.id,
	                        			  "value":currentLoggedUser.value,
	                        			  "code":currentLoggedUser.code
	                        	  };
	                        	  var enquiryModel = new Academia.model.enquiry.EnquiryModel();

	                        	  var enqType = {
	                        			  "id": enqTypeId,
	                        			  "value": enqTypeName
	                        	  };
	                        	  
	                        	  if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
	                        		  enqType = {
		                        			  "id": 1,
		                        			  "value": 'Admission'
		                        	  };
	                        	  }
	                        	  
	                        	  var stopContiner = $this.getEnquiryformrevamp().down('#studentDetailsContainerId');
	                        	  var panelItem = new Array();
	                        	  var endJson=null;

	                        	  var myJson = new Array();
	                        	  for (var i = 0; i < myItems.length; i++) {
	                        		  var obj = new Object();
	                        		  
	                        		  var enquiryStudentSchoolSubjectArr = [];
	                        		  var schoolSubjArr = new Array();
                    				  schoolSubjArr = myItems[i].get('enquiryStudentSchoolSubject');
                    				  
                    				  if(!isNullOrEmpty(schoolSubjArr)){
                    					  if(schoolSubjArr.length > 0){
                    						  for( var p in schoolSubjArr ){
                    							  var schoolSubj = {};
                    							  var subject = {};
                    							  if(!isNullOrEmpty(schoolSubjArr[p])){
		                        					  subject.id = schoolSubjArr[p].data.id;;
		                        					  schoolSubj.subject = subject;
                    								  schoolSubj.enquiryStudentDetail = {"id":""};
                    								  enquiryStudentSchoolSubjectArr.push(schoolSubj);
                    							  }
                    						  }
                    					  }
                    				  }

	                        		  obj.salutation=$this.getIdValueJson(myItems[i].get('salutation'));
	                        		  obj.studentFirstName = myItems[i].get('studentFname');
	                        		  obj.studentMiddleName = myItems[i].get('studentMname');
	                        		  obj.studentLastName = myItems[i].get('studentLname');
	                        		  if (!isNullOrEmpty(myItems[i].get('studentDateOfBirth'))) {
	                        			  obj.studentDateOfBirth = Ext.Date.format(myItems[i].get('studentDateOfBirth'), CONSTANTS.SUBMIT_DATE_FORMAT);
	                        		  }
	                        		  
	                        		  obj.mobileCountryCode = myItems[i].get('mobileCountryCode');
	                        		  obj.mobileNumber = myItems[i].get('mobileNumber');
	                        		  obj.alternateMobileCountryCode = myItems[i].get('alternateMobileCountryCode');
	                        		  obj.alternateMobileNo = myItems[i].get('alternateMobileNo');
	                        		  obj.emailId = myItems[i].get('emailId');
	                        		  obj.isLearnerSACitizen = myItems[i].get('isLearnerSACitizen');
	                        		  obj.nationalId = myItems[i].get('nationalId');
	                        			
	                        		  obj.whetherDeleted = false;
	                        		  obj.fatherEmployed = false;
	                        		  obj.motherEmployed = false;
	                        		  obj.whetherDeleted = false;
	                        		  obj.whetherSiblingStudying = false;
	                        		  
	                        		  if( !isNullOrEmpty(myItems[i].get('currentGradeId')) ){
	                        			  obj.currentGrade = {
	                        					  "id": myItems[i].get('currentGradeId')
	                        			  };
	                        		  }
	                        		  
	                        		  if( !isNullOrEmpty(myItems[i].get('examBoard')) ){
	                        			  obj.examBoard = {
	                        					  "id": myItems[i].get('examBoard')
	                        			  };
	                        		  }
	                        		  
	                        		  if( !isNullOrEmpty(myItems[i].get('country')) ){
	                        			  obj.country = {
	                        					  "id": myItems[i].get('country')
	                        			  };
	                        		  }
	                        		  
	                        		  if( !isNullOrEmpty(myItems[i].get('nationality')) ){
	                        			  obj.nationality = {
	                        					  "id": myItems[i].get('nationality')
	                        			  };
	                        		  }
	                        		  
	                        		  obj.enquiryStudentExamBoardSubject = enquiryStudentSchoolSubjectArr;
                					  obj.gradeElevenAverage = myItems[i].get('gradeElevenAverage');
                					  obj.gradeTwelveAverage = myItems[i].get('gradeTwelveAverage');
	                        		  obj.studentFirstNameOtherLanguage = myItems[i].get('studentFirstNameOtherLanguage');
	                        		  obj.studentMiddleNameOtherLanguage = myItems[i].get('studentMiddleNameOtherLanguage');
                					  obj.studentLastNameOtherLanguage = myItems[i].get('studentLastNameOtherLanguage');
                					  
                					  if(values.registeredBy=='PARENT_GUARDIAN')
                					  {
                						  if(!isNullOrEmpty(values.regdEmail)){
                							  obj.fatherEmailId=values.regdEmail;
                						  }

                						  if(!isNullOrEmpty(values.cellNumber)){
                							  obj.fatherPhoneNo=values.cellNumber;
                						  }

                						  if(!isNullOrEmpty(values.phoneCountryCode)){
                							  obj.fatherPhoneCountryCode=values.phoneCountryCode;
                						  }

                					  }
                					  
	                        		  var admDetails=new Object(), admissionDetails=[];
	                        		  admDetails.academyLocation =$this.getIdValueJson(myItems[i].get('academyId'));

	                        		  admDetails.program = $this.getIdValueJson(myItems[i].get('programId'));
	                        		  if( myItems[i].get('programId') == 0 ){
	                        			  admDetails.program = {"id":""}; 
	                        		  }
	                        		  
	                        		  admDetails.batch = {
	                        				  "id":myItems[i].get('batchId'),
	                        		  };
	                        		  admDetails.programBatchSeatConfiguration = {
	                        				  "id":myItems[i].get('seatTypeId'),
	                        		  };
	                        		  admDetails.whetherDeleted = false;
	                        		  
	                        		  admDetails.modeOfDeliveryCSM =$this.getIdValueJson(myItems[i].get('modeofDelivery'));
	                        		  admDetails.registrationTypeCSM = $this.getIdValueJson(myItems[i].get('registrationType'));
	                        		  admDetails.fieldOfInterest = myItems[i].get('fieldOfInterest');
	                        		  admDetails.whetherProgramOtherSelected = myItems[i].get('whetherProgramOtherSelected');
	                        		  
	                        		  if( !isNullOrEmpty(admDetails.whetherProgramOtherSelected) && admDetails.whetherProgramOtherSelected == true ){
	                        			  delete admDetails.program;
	                        			  delete admDetails.batch;
	                        			  delete admDetails.programBatchSeatConfiguration;
	                        			  if(isNullOrEmpty(myItems[i].get('modeofDelivery'))){
	                        				  delete admDetails.modeOfDeliveryCSM;	                
	                        			  }
	                        			  if(!isNullOrEmpty(myItems[i].get('registrationType'))){
	                        				  if(admDetails.registrationTypeCSM.id=='FULL_TIME'){
	                        					  admDetails.batchPartTime = false;
	                        				  }else if(admDetails.registrationTypeCSM.id=='PART_TIME'){
	                        					  admDetails.batchPartTime = true;
	                        				  }
	                        			  }else{
	                        				  delete admDetails.registrationTypeCSM;
	                        			  }

	                        		  }else{
	                        			  if(isNullOrEmpty(myItems[i].get('modeofDelivery'))){
	                        				  delete admDetails.modeOfDeliveryCSM;	                
	                        			  }
	                        			  if(!isNullOrEmpty(myItems[i].get('registrationType'))){
	                        				  if(admDetails.registrationTypeCSM.id=='FULL_TIME'){
	                        					  admDetails.batchPartTime = false;
	                        					  delete admDetails.registrationTypeCSM;
	                        				  }else if(admDetails.registrationTypeCSM.id=='PART_TIME'){
	                        					  admDetails.batchPartTime = true;
	                        					  delete admDetails.registrationTypeCSM;
	                        				  }
	                        			  }else{
	                        				  delete admDetails.registrationTypeCSM;
	                        			  }           
	                        		  }
	                        		  delete admDetails.registrationTypeCSM;
	                        		  admissionDetails.push(admDetails);
	                        		  obj.admissionEnquiryDetails=admissionDetails;
	                        		  myJson.push(obj);
	                        	  }
	                        	  if(enqTypeId==1) {
	                        		  if(myJson.length==0) {
	                        			  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getCommonTranslation('ENQUIRY_MESSAGE'));
	                        			  return;
	                        		  }
	                        	  }
	                        	  /*else{
				var obj = new Object();
				obj.studentFirstName = values.studentFname;
				obj.whetherDeleted = false;
				obj.fatherEmployed = false;
				obj.motherEmployed = false;
				obj.whetherDeleted = false;
				obj.whetherSiblingStudying = false;
				var admDetails=new Object(), admissionDetails=[];
				admDetails.academyLocation ={
						"id":values.academyLocation
				};

				admDetails.program ={
						"id":values.programId
				};

				admDetails.batch = {
						"id":values.batchId,
				};
				admDetails.programBatchSeatConfiguration = {
						"id":values.seatTypeId,
				};
				admissionDetails.push(admDetails);
				obj.admissionEnquiryDetails=admissionDetails;
				obj.whetherDeleted = false;
				myJson.push(obj);
			}*/
	                        	  var currentLoggedUser=this.getCurrentlyLoggedInUser();
	                        	  var userData={
	                        			  "id":currentLoggedUser.id,
	                        			  "value":currentLoggedUser.value,
	                        			  "code":currentLoggedUser.code
	                        	  };
	                        	  var userssss = this.getIdValueJson(followUpUserField.getValue());
	                        	  var salutation={
	                        			 "id":form.findField("raiseEnquirySalutation").getValue()
	                        	  }
	                        	  var campaign={
	                        			  "id":form.findField("campaign").getValue()
	                        	  }
	                        	  var campaignNew={
	                        			  "id":form.findField("campaignNew").getValue()  
	                        	  }
	                        	  var campaignSchool={
	                        			  "id":form.findField("campaignSchool").getValue()  
	                        	  }
	                        	  var alternateCountryCode;
	                        	  if(!isNullOrEmpty(values.alternateCellNumber)){
	                        		  alternateCountryCode=form.findField('alternatePhoneCountryCode').getRawValue();
	                        	  }
	                        	  if(isNullOrEmpty(form.findField("campaignNew").getValue()) && !isNullOrEmpty(form.findField("campaignSchool").getValue())){
	                        		  schoolPriorityVal = values.schoolPriorityNew;
	                        	  }
	                        	  var linkStudentId={
	                        			 "id":form.findField("enqRegByStudent").getValue()
	                        	  }
	                        	  
	                        	  var educationDepartmentId = values.educationDepartment;
	                        	  var programCategoryId = values.programCategory;
	                        	  
	                        	  var address = [];
	              	        	    address.push({
	              	        		  "id": "",
	              	        		  "enquiry": {
	              	        			  "id":""
	              	        		  },
	              	        		  "address": {
	              	        			"id": "",
	              	        			"country": this.getIdValueJson(form.findField("countryCombo").getValue()),
	              	        			"parentCountryRegion": this.getIdValueJson(form.findField("countryRegionCombo").getValue()),
	              	        			"city": this.getIdValueJson(form.findField("cityCombo").getValue()),
	              	        			"cellCountryCode": form.findField("phoneCountryCode").getValue(),
	              	        			"cellNo": form.findField("cellNumber").getValue(),
	              	        			"primaryeEmailId": form.findField("regdEmail").getValue(),
	              	        			"version": ""
	              	        		}
	              	        	  });

	                        	  var saveDate = {
	                        			  "enquiryType":enqType,
	                        			  "enquiryStudentDetails":myJson,
	                        			  "firstName":values.enquirerFirstName,
	                        			  "lastName":values.enquirerLastName,
	                        			  "middleName":values.enquirerMiddleName,
	                        			  "followUpUser":this.getIdValueJson(followUpUserField.getValue()),
	                        			  "enquiryDate":values.enquiryDate,
	                        			  "enquirySource":this.getIdValueJson(values.enquirySource),
	                        			  "enquirySourceOther":values.enquirySourceOther,
	                        			  "registeredByType":values.registeredBy,
	                        			  "status":"O",
	                        			  "whetherDeleted":false,
	                        			  "academyLocation":this.getIdValueJson(this.getCurrentAcademyLocation()),
	                        			  "user":userssss,
	                        			  "followUpUser":userssss,
	                        			  "primaryeEmailId":values.regdEmail,
	                        			  "phoneNo" : values.cellNumber,
	                        			  "phoneCountryCode" : form.findField('phoneCountryCode').getRawValue(),
	                        			  "followUpDate" : values.enquiryDate,
	                        			  "customData" :values.customData,
	                        			  "salutation":salutation,
	                        			  "campaign":campaign,
	                        			  "alternatePhoneNo" : values.alternateCellNumber, 
	                        			  "alternateCountryCode" : alternateCountryCode ,
	                        			  "campaignNew":campaignNew,
	                        			  "campaignSchool":campaignSchool,
	                        			  "whetherCompanySponsored":values.whetherCompanySponsored,
	                        			  "enquiryMultipleMode": values.enquiryMultipleMode,
	                        			  "schoolPriority":schoolPriorityVal,
	                        			  "educationDepartment" : this.getIdValueJson(educationDepartmentId),
	                        			  "enquiryAddresses" : address,
			                 			  "programCategory" : this.getIdValueJson(programCategoryId),
			                 			  "intakeYear":this.getIdValueJson(values.enqIntakeYear),
			                 			  "linkStudentId":linkStudentId,
			                 			  "whetherReceiveCommunication":values.whetherReceiveCommunication,
	                        	  };
	                        	  
	                        	  if( isNullOrEmpty(form.findField("campaign").getValue()) ){
	                        		  delete saveDate.campaign;
	                        	  }
	                        	  if( isNullOrEmpty(form.findField("campaignNew").getValue()) ){
	                        		  delete saveDate.campaignNew;
	                        	  }
	                        	  if( isNullOrEmpty(form.findField("campaignSchool").getValue()) ){
	                        		  delete saveDate.campaignSchool;
	                        	  }
	                        	  if( isNullOrEmpty(form.findField("enqRegByStudent").getValue()) ){
	                        		  delete saveDate.linkStudentId;
	                        	  }
	                        	  
	                        	  var enqModeMultiple = [];
	                        	  var enqModeArray = values.enquiryMode;
	                        	  for(i in enqModeArray){
	                        		  var recordEnqMode = enqModeArray[i];
	                        		  if(recordEnqMode.data != undefined)
	                        		  {
	                        			  enqModeId = recordEnqMode.data.id;
	                        			  enqObj = {
	                        					  "enquiryMode": {
	                        						  "id": enqModeId
	                        					  }
	                        			  };
	                        			  enqModeMultiple.push(enqObj);
	                        		  }
	                        	  }
	                        	  saveDate.enquiryMultipleMode=enqModeMultiple;
	                        	
	                        	  
//	                        	  enquiryModel.set("enquiryType", enqType);

//	                        	  enquiryModel.set("user", null);
//	                        	  enquiryModel.set("campaign", null);
//	                        	  enquiryModel.set("admissionEnquiryDetails", myJson);
//	                        	  enquiryModel.set("firstName", values.enquirerFirstName);
//	                        	  enquiryModel.set("lastName", values.enquirerLastName);
//	                        	  enquiryModel.set("middleName", values.enquirerMiddleName);
//	                        	  enquiryModel.set("followUpUser", this.getIdValueJson(followUpUserField.getValue()));
//	                        	  enquiryModel.set("enquiryDate", values.enquiryDate);
//	                        	  enquiryModel.set("enquirySource", this.getIdValueJson(values.enquirySource));
//	                        	  enquiryModel.set("registeredByType", values.registeredBy);
//	                        	  enquiryModel.set("academyLocation", this.getIdValueJson(this.getCurrentAcademyLocation()));

	                        	  var formData = Ext.encode(enquiryModel.data);
	                        	  var submitUrl;
	                        	  if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
	                        		  submitUrl = SERVERURL.ENQUIRY_SAVE_URL;
	                        	  } else {
	                        		  submitUrl = SERVERURL.ENQUIRY_UPDATE;
	                        	  }
	                        	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                        	  Ext.Ajax.request({
	                        		  type: 'rest',
	                        		  url: submitUrl,
	                        		  jsonData: saveDate,
	                        		  method: 'POST',
	                        		  success: function(response, action) {
	                        			  Ext.getBody().unmask();
	                        			  grid.getStore().removeAll();
	                        			  var dataEnquiry = response.responseText;
	                        			  var EId = response.responseText;
	                        			  var responseMsgStr;
	                        			  var responseMsg = "";
	                        			  var responseCode = 1;
	                        			  if(dataEnquiry.includes("@")){
	                        				  var resArr = dataEnquiry.split("@");
	                        				  EId = resArr[0];
	                        				  responseMsgStr = resArr[1];
	                        				  if(responseMsgStr.includes("*")){
	                        					  var resArr2 = responseMsgStr.split("*");
	                        					  responseMsg = resArr2[0];
	                        					  responseCode = resArr2[1];
	                        				  }
	                        			  }
	                        			  
	                        			  if (EId != '' && EId == 'SUCCESS') {
	                        				  //form.reset();
	                        				  //store.removeAll();
	                        				  // To close the current panel
	                        				  var tabName = getEnquiryTranslation('CREATE_ENQUIRY');
	                        				  var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                        				  var getTab=getcontroller.getTab(tabName);
	                        				  if( responseCode == 1 ){
	                        					 var enquiryMsg = getEnquiryTranslation('ENQUIRY_ID_IS')+" "+responseMsgStr;
	                        					 if(responseMsgStr!=null){
	                        					  showSuccessMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getCommonTranslation('SUCCESS')+" "+enquiryMsg);
	                        					 }else{
	                        						 showSuccessMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getCommonTranslation('SUCCESS'));
	                        					 }
	                        					  if(getTab!=null){
    	                        					  contentpanel.remove(getTab, true);
    	                        				  }
	                        				  }
	                        				 
	                        				  if( responseCode == 2 ){
	                        					  //showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), responseMsg);
	                        					  var endUserMessage = "";
	                        					  if( responseMsgStr.includes("ALL_DUPLICATE_ENQUIRY_ERROR") ){
	                        						  endUserMessage = getEnquiryTranslation('ALL_DUPLICATE_ENQUIRY_ERROR');
	                        						  if( !isNullOrEmpty(endUserMessage) ){
	                        							  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), responseMsg.replace("ALL_DUPLICATE_ENQUIRY_ERROR",endUserMessage));
	                        						  } else{
	                        							  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), responseMsg);
	                        						  }
	                        					  }
	                        				  }
	                        				  if( responseCode == 3 ){
	                        					  var endUserMessage = "";
	                        					  if( responseMsgStr.includes("DUPLICATE_ENQUIRY_SINGULAR_ERROR") ){
	                        						  endUserMessage = getEnquiryTranslation('DUPLICATE_ENQUIRY_SINGULAR_ERROR');
	                        						  if( !isNullOrEmpty(endUserMessage) ){
	                        							  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), responseMsg.replace("DUPLICATE_ENQUIRY_SINGULAR_ERROR",endUserMessage));
	                        						  } else{
	                        							  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), responseMsg);
	                        						  }
	                        					  }
	                        					  if( responseMsgStr.includes("DUPLICATE_ENQUIRY_PLURAL_ERROR") ){
	                        						  endUserMessage = getEnquiryTranslation('DUPLICATE_ENQUIRY_PLURAL_ERROR');
	                        						  if( !isNullOrEmpty(endUserMessage) ){
	                        							  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), responseMsg.replace("DUPLICATE_ENQUIRY_PLURAL_ERROR",endUserMessage));
	                        						  } else{
	                        							  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), responseMsg);
	                        						  }
	                        					  }
	                        					  if(getTab!=null){
    	                        					  contentpanel.remove(getTab, true);
    	                        				  }
	                        				  }
	                        				  
	                        			  } else if (EId != '' && EId == 'STAGE_NOT_FOUND') {
	                        				  Ext.getBody().unmask();
	                        				  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getEnquiryTranslation('ENQUIRY_STAGE_NOT_FOUND'));
	                        			  } else if (EId != '' && EId == 'NO_DEFAULT_STAGE') {
	                        				  Ext.getBody().unmask();
	                        				  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getEnquiryTranslation('ENQUIRY_NO_DEFAULT_STAGE'));
	                        			  } else if (EId != '' && EId == 'PRIORITY_NOT_FOUND') {
	                        				  Ext.getBody().unmask();
	                        				  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getEnquiryTranslation('ENQUIRY_PRIORITY_NOT_FOUND'));
	                        			  } else if (EId != '' && EId == 'NO_DEFAULT_PRIORITY') {
	                        				  Ext.getBody().unmask();
	                        				  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getEnquiryTranslation('ENQUIRY_NO_DEFAULT_PRIORITY'));
	                        			  }
	                        			  
	                        			  
	                        			  /*Code for check the campaign grid and refresh*/
	                        			  var campaignTabName = getMegaMenuTranslation('CE_TERTIARY_MANAGE_VIEW_COMPAIGNS');
	                        			  var coreErpController=$this.getController('menu.CoreERPNavigationController');
	                        			  var getCampaignTabName = coreErpController.getTab(campaignTabName);
	                        			  if (getCampaignTabName != null) {
	                        				  contentpanel.setActiveTab(getCampaignTabName);
	                        				  var gridCampaign = getCampaignTabName.down('grid');
	                        				  if(gridCampaign != undefined) {
	                        					  var grdStore = gridCampaign.getStore();
	                        					  gridCampaign.getSelectionModel().deselectAll();
	                        					  grdStore.reload();
	                        				  }
	                        			  }
	                        		  }
	                        	  });
	                        	  if(records.stopEvent && records.stopPropagation){
	                        		  records.stopEvent();
	                        		  records.stopPropagation();
	                        		  return false;
	                        	  }
	                          },
	                          /**
	                           * Add multiple add students details filters in panel
	                           */
	                          addMultipleStudentDetailsfilter:function(obj){
	                        	  var $this = this;
	                        	  var stopContiner = $this.getEnquiryformrevamp().down('#studentDetailsContainerId');
	                        	  // var timeFieldsCount = stopContiner.items.length;
	                        	  var panelItem = new Array();
	                        	  var fieldContainer=obj.up('fieldcontainer');
	                        	  var newcont=stopContiner.items.items.length;
	                        	  var insertPosition=newcont+1;
	                        	  panelItem.push({
	                        		  xtype: 'fieldcontainer',
//	                        		  itemId:'studentDetailsContainerId',
	                        		  width: '100%',
	                        		  layout: {
	                        			  type: 'vbox'
	                        		  },
	                        		  defaults: {
	                        			  //width: 226,
	                        			  labelAlign:'top'
	                        		  },
	                        		  items:[ {
	                        			  xtype: 'fieldcontainer',
	                        			  width: '100%',
	                        			  layout: {
	                        				  type: 'vbox'
	                        			  },
	                        			  defaults: {
	                        				  width: 226,
	                        				  labelAlign:'top'
	                        			  },
	                        			  items:[{
	                        				  xtype: 'fieldcontainer',
	                        				  width: '100%',
	                        				  layout: {
	                        					  type: 'hbox'
	                        				  },
	                        				  defaults: {
	                        					  width: 226,
	                        					  labelAlign:'top'
	                        				  },
	                        				  items:[{
	                        					  xtype: 'textfield',
	                        					  name: 'studentFname',
	                        					  fieldLabel: getCommonTranslation('PROSPECTIVE_STUDENT'),
	                        					  allowBlank:false,
	                        					  hidden:false,
	                        					  itemId: 'studentFname'+insertPosition,
	                        				  }, {
	                        					  xtype : 'customcombobox',
	                        					  name : 'academyLocation',
	                        					  itemId:'academyLocationId'+insertPosition,
	                        					  fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
	                        					  store:'common.AcademyLocationNameSeparated',
	                        					  valueField : 'id',
	                        					  displayField : 'value',
	                        					  allowBlank : false,
	                        					  listeners: {
	                        						  select:function(obj,record){
	                        							  $this.setMoreProgramDetails(obj,record);
	                        						  }
	                        					  }
	                        				  }]
	                        			  },{
	                        				  xtype: 'fieldcontainer',
	                        				  width: '100%',
	                        				  layout: {
	                        					  type: 'hbox'
	                        				  },
	                        				  defaults: {
	                        					  width: 226,
	                        					  labelAlign:'top'
	                        				  },
	                        				  items : [{
	                        					  xtype: 'customcombobox',
	                        					  name: 'programId',
	                        					  itemId:'programId'+insertPosition,
	                        					  emptyText: getCommonTranslation('SELECT_COMBOBOX_EMPTY_TEXT'),
	                        					  fieldLabel: getEnquiryTranslation('PROGRAM'),
	                        					  store:'common.ProgramByAcAndLoIdStore',
	                        					  editable: true,
	                        					  valueField: 'id',
	                        					  displayField: 'value',
	                        					  allowBlank : false,
	                        					  listeners: {
	                        						  render: function(combo) {
	                        							  var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
	                        							  combo.bindStore(store);
	                        						  },
	                        						  select:function(obj,record){

	                        							  var programId = record[0].get("id");
	                        							  var  batch = obj.nextSibling();
	                        							  var seatType = batch.nextSibling();
	                        							  batch.reset();
	                        							  seatType.reset();

	                        							  var store = batch.getStore();
	                        							  store.proxy.extraParams = {
	                        									  id : programId
	                        							  };
	                        							  store.load();
	                        						  }
	                        					  }
	                        				  },{
	                        					  xtype: 'customcombobox',
	                        					  name: 'batchId',
	                        					  itemId:'batchId'+insertPosition,
	                        					  emptyText: getCommonTranslation('SELECT_COMBOBOX_EMPTY_TEXT'),
	                        					  fieldLabel: getEnquiryTranslation('ACADEMIC_BATCH'),
	                        					  disabled:false,
	                        					  editable: true,
	                        					  queryMode: 'local',
	                        					  displayField: 'value',
	                        					  valueField: 'id',
	                        					  allowBlank : false,
	                        					  listeners: {
	                        						  render: function(combo) {
	                        							  var store = Ext.create('Academia.store.enquiry.AcademicBatchStore');
	                        							  combo.bindStore(store);
	                        						  },
	                        						  select:function(obj,record){
	                        							  var batchId = record[0].get("id");
	                        							  var  seatType = obj.nextSibling();
	                        							  seatType.reset();
	                        							  var store = seatType.getStore();
	                        							  store.proxy.extraParams = {
	                        									  id : batchId
	                        							  };
	                        							  store.load();
	                        						  }
	                        					  }
	                        				  },{
	                        					  xtype: 'customcombobox',
	                        					  name: 'seatTypeId',
	                        					  itemId:'seatTypeId'+insertPosition,
	                        					  emptyText: getCommonTranslation('SELECT_COMBOBOX_EMPTY_TEXT'),
	                        					  fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
	                        					  store: 'enquiry.ProgramBatchSeatTypeStore',
	                        					  valueField: 'id',
	                        					  displayField: 'value',
	                        					  allowBlank:false,
	                        					  typeAhead:true,
	                        					  forceSelection:true,
	                        					  listeners: {
	                        						  render: function(combo) {
	                        							  var store = Ext.create('Academia.store.enquiry.ProgramBatchSeatTypeStore');
	                        							  combo.bindStore(store);
	                        						  }
	                        					  }
	                        				  },{
	                        					  xtype: 'button',
	                        					  itemId: 'delFilterBtn',
	                        					  cls: 'CustomBodyBtnReject',
	                        					  glyph: ICONGLYPH.DELETEGLYPH,
	                        					  tooltip: getCommonTranslation('DELETE'),
	                        					  style:{
	                        						  marginTop:'30px',
	                        						  //marginLeft: '710px !important'
	                        					  },
	                        					  listeners:{
	                        						  click:function(obj){
	                        							  var container = obj.up('fieldcontainer').up('fieldcontainer').up('fieldcontainer');
	                        							  var panelContiner = $this.getEnquiryformrevamp().down('#studentDetailsContainerId');
	                        							  panelContiner.remove(container);
	                        						  }}
	                        				  }]
	                        			  }]
	                        		  },]
	                        	  });
	                        	  stopContiner.insert(insertPosition,panelItem);
	                        	  stopContiner.doLayout();
	                          },
	                          closeFormWindow: function() {
	                        	  this.getEnquirymulprogramform().close();
	                          },
	                          setMoreStudentDetails: function(obj,records){
	                        	  var this$ = this;
	                        	  var student = obj.up('fieldcontainer').items.items[0];
//	                        	  var program =container1.items.items[0];
	                        	  var academyLocId = $this.getCurrentAcademyLocation();
	                        	  var arr=[];
	                        	  arr.push(academyLocId);
	                        	  var store = student.getStore();
	                        	  store.getProxy().extraParams={
	                        		  academyLocationIds : arr
	                        	  };
	                        	  store.load();
	                          },

	                          setMoreProgramDetails : function(obj,records){
	                        	  var this$ = this;
	                        	  var container1 = obj.up('fieldcontainer').nextSibling();
	                        	  var program =container1.items.items[0];
	                        	  var academyLocId = records[0].get("id");
	                        	  var store = program.getStore();
	                        	  store.getProxy().extraParams={
	                        		  academyLocationId : academyLocId
	                        	  };
	                        	  store.load();


	                        	  /*	if (!isNullOrEmpty(academyLocId)) {
    		var params = {
          			academyLocationId : academyLocId
				};
    		this$.sendGetAjaxRequest(SERVERURL.PROGRAMS_FIND_BY_ACADMY_LOCATION_ID, 'GET', params, function(option, success, response) {
    			if(success){
    				var data = Ext.decode(response.responseText);
            		if (!isEmpty(data)) {
            			var  program = obj.up("fieldcontainer").nextSibling();
                    	program.reset();
            		}
    			}
    		});
    	}*/
	                          },

	                          setMoreBatchDetails : function(obj,records){
	                        	  var this$ = this;
	                        	  var academyLocId = record[0].get("id");
	                        	  var studentCode = records[0].get('studentCode');
	                        	  if (!isNullOrEmpty(academyLocId)) {
	                        		  var params = {
	                        				  academyLocationId : academyLocId
	                        		  };
	                        		  this$.sendGetAjaxRequest(SERVERURL.VALIDATE_SIBLING_STUDENT_ID, 'GET', params, function(option, success, response) {
	                        			  if(success){

	                        			  }
	                        		  });
	                        	  }
	                          },

	                          assignHoursRender: function() {
	                        	  var store = this.getStore('enquiry.assignhours.AssignHoursStore');
	                        	  store.load();
	                          },
	                          openAssignHoursWin: function() {
	                        	  var frmWin = this.getEnquiryassignhours();
	                        	  if (!frmWin) {
	                        		  Ext.widget('enquiryassignhours');
	                        		  frmWin = this.getEnquiryassignhours();
	                        	  }
	                        	  frmWin.show();
	                          },
	                          editAssignHoursWin: function() {
	                        	  var $this = this;
	                        	  var grid = $this.getEnquiryassignhoursgrid();
	                        	  if (grid.getSelectionModel().getCount() > 0) {
	                        		  $this.openAssignHoursWin();
	                        		  var form = this.getEnquiryassignHours();
	                        		  var store = this.getStore('enquiry.assignhours.AssignHoursStore');
	                        		  var selectedRecord = grid.getSelectionModel().getSelection()[0];
	                        		  var row = store.indexOf(selectedRecord);
	                        		  var records = store.getAt(row);
	                        		  if (records != undefined && records != "" && records != null) {
	                        			  if(!(isNullOrEmpty(records.data.workingFromTime)))
	                        				  records.data.workingFromTime = new Date(records.data.workingFromTime);
	                        			  if(!(isNullOrEmpty(records.data.workingToTime)))
	                        				  records.data.workingToTime = new Date(records.data.workingToTime);
	                        			  form.loadRecord(records);
	                        			  var academyId = records.data.academyLocation.id;
	                        			  if (academyId) {
	                        				  var academyCombo = form.down('#academyLocationId');
	                        				  var academyStore = form.down('#academyLocationId').getStore();
	                        				  academyStore.load({
	                        					  callback: function(record, operation, success) {
	                        						  if (success) {
	                        							  academyCombo.setValue(academyId);
	                        						  }
	                        					  }
	                        				  });
	                        			  }
	                        		  }
	                        	  } else {
	                        		  showWarningMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	                        	  }
	                          },
	                          viewAssignHoursWin: function() {
	                        	  this.editAssignHoursWin();
	                        	  var form = this.getEnquiryassignHours();
	                        	  if (form) {
	                        		  form.down('#SubmitBtn').setVisible(false);
	                        		  form = form.getForm();
	                        		  toggleReadOnlyFormItems(form, true);
	                        	  }
	                          },
	                          cancleEnquiryAssignHours: function() {
	                        	  this.getEnquiryassignhours().close();
	                          },
	                          addEnquiryAssignHours: function() {
	                        	  var $this = this;
	                        	  var grid = $this.getEnquiryassignhoursgrid();
	                        	  var grdStore = grid.getStore();
	                        	  var frm = $this.getEnquiryassignHours();
	                        	  var form = frm.getForm();
	                        	  var value = form.getValues();
	                        	  var acadmylocationId = value.academyLocation;
	                        	  var assignHoursModel = new Academia.model.enquiry.assignhours.AssignHoursSubmitModel();
	                        	  assignHoursModel.set("academyLocation", $this.getIdValueJson(acadmylocationId));
	                        	  assignHoursModel.set("workingFromTime", value.workingFromTime);
	                        	  assignHoursModel.set("workingToTime", value.workingToTime);
	                        	  var submitUrl;
	                        	  if (form.findField('id').getSubmitValue() == null || form.findField('id').getSubmitValue() == "") {
	                        		  submitUrl = SERVERURL.ENQ_ASSIGN_HOURS_CREATE;
	                        	  } else {
	                        		  assignHoursModel.set("id", value.id);
	                        		  submitUrl = SERVERURL.ENQ_ASSIGN_HOURS_UPDATE;
	                        	  }
	                        	  var submitData = Ext.encode(assignHoursModel.data);
	                        	  $this.applyWindowMask(); 
	                        	  Ext.Ajax.request({
	                        		  type: 'rest',
	                        		  url: submitUrl,
	                        		  jsonData: submitData,
	                        		  method: 'POST',
	                        		  success: function(response, action) {
	                        			  $this.hideWindowMask();
	                        			  var msg = response.responseText;
	                        			  if (msg != '' && msg == 'DUPLICATE') {
	                        				  showSuccessMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getCommonTranslation('MSG_DUPLICATE_ASSIGNMENT_HOURS'));
	                        			  } else if (msg != '' && msg == 'SUCCESS') {
	                        				  showSuccessMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getCommonTranslation('SUCCESS'));
	                        				  grdStore.reload();
	                        				  $this.cancleEnquiryAssignHours();
	                        			  }
	                        		  }
	                        	  });
	                          },
	                          deleteAssignHoursWin: function() {
	                        	  var $this = this;
	                        	  var grid = $this.getEnquiryassignhoursgrid();
	                        	  var grdStore = grid.getStore();
	                        	  if (grid.getSelectionModel().getCount() > 0) {
	                        		  showConfirmMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                        			  if (btn == 'yes') {
	                        				  var records = grid.getSelectionModel().getSelection();
	                        				  var id = records[0].get("id");
	                        				  Ext.Ajax.request({
	                        					  method: "POST",
	                        					  type: 'rest',
	                        					  url: SERVERURL.ENQ_ASSIGN_HOURS_DELETE + '?id=' + id,
	                        					  headers: {
	                        						  'Content-Type': 'application/json'
	                        					  },
	                        					  success: function(form, action) {
	                        						  grdStore.reload();
	                        						  showSuccessMessage(getEnquiryTranslation('ENQUIRY_TITLE'), getCommonTranslation('SUCCESS'));
	                        					  }
	                        				  });
	                        			  }
	                        		  });
	                        	  } else {
	                        		  showWarningMessage(getEnquiryTranslation('ENQUIRY'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	                        	  }
	                          },
	                          getIdValueJson: function(id, value) {
	                        	  if (id) return {
	                        		  id: id,
	                        		  value: value
	                        	  };
	                          },
	                          loadPendingEnquiryData:function(){
	                        	  var $this=this;
	                        	  var organizationForm=$this.getOrganizationunit().getForm();
	                        	  var multiselectAcademyLocation = organizationForm.findField('multiselectAcademyLocation');
	                        	  var academyLocationIds = [];
	                        	  if(!multiselectAcademyLocation.isHidden()){
	                        		  Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
	                        			  if(Ext.isObject(value)){
	                        				  academyLocationIds.push(value.data.id);	
	                        			  }else {
	                        				  academyLocationIds.push(value);
	                        			  }
	                        		  });
	                        	  }

	                        	  var tabPanel =  $this.getEnquiryReportTabPanel();
	                        	  var tabItems = tabPanel.items.items;

	                        	  for(var i in tabItems){
	                        		  if(tabItems[i].title==getEnquiryTranslation('PENDING_ENQUIRIES')){
	                        			  var pendingEnqFormGrid=$this.getPendingEnquiryFormGrid();
	                        			  pendingEnqFormGrid.getStore().getProxy().extraParams={
	                        				  academyLocationIds: academyLocationIds.join()
	                        			  };
	                        			  pendingEnqFormGrid.getStore().load({
	                        				  callback: function(record, result){
	                        					  $this.getPendingenquirygrid().getStore().removeAll();
	                        				  }
	                        			  });
	                        		  }
	                        		  else if(tabItems[i].title==getEnquiryTranslation('COUNT_OF_ENQUIRIES')){
	                        			  var countcfenquiriesfilter=$this.getCountcfenquiriesfilter().getForm();
	                        			  var programField=countcfenquiriesfilter.findField('program');
	                        			  var porgramStore=programField.getStore();
	                        			  porgramStore.getProxy().extraParams={
	                        				  academyLocationIds:academyLocationIds.join()
	                        			  };
	                        			  programField.reset();
	                        			  porgramStore.load();
	                        			  
	                        			  var programCategoryField=countcfenquiriesfilter.findField('programCategory');
	                        			  var pcStore=programCategoryField.getStore();
	                        			  pcStore.getProxy().extraParams={
	                        				  academyLocationIds:academyLocationIds.join()
	                        			  };
	                        			  programCategoryField.reset();
	                        			  pcStore.load();
	                        			  
	                        			var batchField = countcfenquiriesfilter.findField('batch');
	                  					batchField.disable();
	                  					batchField.reset();
	                  					var seatTypeField = countcfenquiriesfilter.findField('seatType');
	                           		    seatTypeField.disable();
	                           		    seatTypeField.reset();
	                        		  }
	                        	  }
	                          },
	                          /**
	                           * open tab for pending enquiry grids in dashboard for 1. Admission 2. corporate 3. non admission 4. pending
	                           * And this is also called from enquiry reports controller also.  
	                           */
	                          openEnquiryMasterGridsTab: function(enquiryType,enquiryIds, viewTitle) {
	                        	  var contentpanel = this.getContentpanel();
	                        	  var trackEnquiry = Ext.widget('enquirygridsforpendingenquirydashboard');
	                        	  var tabName = getEnquiryTranslation('MANAGE_ENQUIRIES_DASHBOARD');
	                        	  /**
	                        	   * This is to remove tab from content panel and open same tab again 
	                        	   */
	                        	  var getcontroller=this.getController('menu.CoreERPNavigationController');
	                        	  var getTab=getcontroller.getTab(tabName);
	                        	  if(getTab!=null){
	                        		  contentpanel.remove(getTab, true);
	                        	  }
	                        	  openTab(contentpanel, tabName, trackEnquiry, CONSTANTS.MENU_COLOR_ONE);
	                        	  this.loadEnquiryGridFromEnqDashboard(enquiryType,enquiryIds, viewTitle);
	                          },
	                          /**
	                           * load grid for pending enquiry grids in dashboard for 1. Admission 2. corporate 3. non admission 4. pending 
	                           */
	                          loadEnquiryGridFromEnqDashboard:function(enquiryType,enquiryIds, viewTitle){
	                        	  var $this=this;
	                        	  var jsonFormatFormData = $this.createJsonEnquiryGridFormat(enquiryType,enquiryIds);
	                        	  var searchResultGrid = '';
	                        	  /**
	                        	   * Show grid on the bases of enquiry type
	                        	   */
	                        	  var trackEnqDasboardGrid=$this.getTrackEnquiryGridDashBoard();
	                        	  var corporateEnqDasboardGrid=$this.getCorprorateGridDashBoard();
	                        	  var nonAdmissionDashboardGrid=$this.getNonAdmissionGridDashBoard();
	                        	  var pendingCountDashboardGrid=$this.getPendignCountGridDashBoard();

	                        	  trackEnqDasboardGrid.setVisible(false);
	                        	  corporateEnqDasboardGrid.setVisible(false);
	                        	  nonAdmissionDashboardGrid.setVisible(false);
	                        	  pendingCountDashboardGrid.setVisible(false);
	                        	  if(enquiryType == getCommonTranslation('CNTRL_CORPORATE')){
	                        		  searchResultGrid = corporateEnqDasboardGrid;
	                        	  }else if(enquiryType == getCommonTranslation('CNTRL_ADMISSION')){
	                        		  searchResultGrid = trackEnqDasboardGrid;
	                        	  }else if(enquiryType =='pendingCount'){
	                        		  searchResultGrid = pendingCountDashboardGrid;
	                        	  }else {
	                        		  searchResultGrid = nonAdmissionDashboardGrid;
	                        	  }
	                        	  searchResultGrid.setTitle(viewTitle);
	                        	  searchResultGrid.setVisible(true);
	                        	  searchResultGrid.addButtonToolbar();
	                        	  this.genericCBGridAccessControlValidation(searchResultGrid,this.getFOLLOWUPSCHEDULED_PERMISSIONS());
	                        	  var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                        	  /**
	                        	   *  we have three xml for enquiry grid 1.Admission 2. Coorporate 3.Non Admission 4. pending
	                        	   */
	                        	  if(enquiryType == getCommonTranslation('CNTRL_CORPORATE')){
	                        		  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.CORPORATE_ENQUIRY_LIST_VIEWCODE);
	                        	  } else if((enquiryType == getCommonTranslation('CNTRL_ADMISSION'))){
	                        		  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TRACK_ENQUIRY_LIST_VIEWCODE);
	                        	  }else if(enquiryType =='pendingCount'){
	                        		  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PENDING_ENQUIRY_GRID_VIEWCODE);
	                        	  }else{
	                        		  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TRACK_ENQUIRY_NON_ADMISSION_VIEWCODE);
	                        	  } 
	                        	  searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                          },
	                          createJsonEnquiryGridFormat:function(enquiryType,enquiryIds){
	                        	  var values = new Object();
	                        	  /**
	                        	   *  we have three xml for enquiry grid 1.Admission 2. Coorporate 3.Non Admission
	                        	   */
	                        	  if(enquiryType == getCommonTranslation('CNTRL_CORPORATE')){	
	                        		  values.configCode = CONSTANTS.CB.CORPORATE_ENQUIRY_LIST_CONFIGCODE;
	                        	  }
	                        	  else if(enquiryType == getCommonTranslation('CNTRL_ADMISSION')){
	                        		  values.configCode = CONSTANTS.CB.TRACK_ENQUIRY_LIST_CONFIGCODE;
	                        	  }else if(enquiryType =='pendingCount'){
	                        		  values.configCode = CONSTANTS.CB.PENDING_ENQUIRY_GRID_CONFIGCODE;
	                        	  } else {
	                        		  values.configCode = CONSTANTS.CB.TRACK_ENQUIRY_NON_ADMISSION_CONFIGCODE;
	                        	  } 
	                        	  var searchcriteria = new Array();
	                        	  /**
	                        	   * This param is used to send multiple enquiry ids.
	                        	   */
	                        	  if(enquiryIds != "" && enquiryIds != null){
	                        		  searchcriteria.push({paramCode:"ENQUIRY_IDS", paramValues:[enquiryIds]});
	                        	  }
	                        	  values.searchCriterias=searchcriteria;
	                        	  return values;
	                          },
	                          loadViewPastRecordGrid: function(model, records) {
	                        	  var quickSearchForm = this.getViewpastsearchform();
	                        	  var jsonFormatFormData = this.createJsonFormat(quickSearchForm, records);
	                        	  var searchResultGrid = this.getSearchresultgrid();
	                        	  var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                        	  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TRACK_ENQUIRY_LIST_VIEWCODE_VIEW_PAST);
	                        	  searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                          },
	                          createJsonFormat: function(quickSearchForm, record) {
	                        	  var enquiryFirstName = quickSearchForm.down('#trackEnquiry_enquiryFirstName');
	                        	  var enquiryMiddleName = quickSearchForm.down('#trackEnquiry_enquiryMiddleName');
	                        	  var enquiryLastName = quickSearchForm.down('#trackEnquiry_enquiryLastName');
	                        	  var email = quickSearchForm.down('#trackEnquiry_email');
	                        	  var mobileNo = quickSearchForm.down('#trackEnquiry_mobileNo');
	                        	  var phoneNo = quickSearchForm.down('#trackEnquiry_phoneNo');
	                        	  var values = new Object();
	                        	  values.configCode = CONSTANTS.CB.TRACK_ENQUIRY_LIST_CONFIGCODE_VIEW_PAST;
	                        	  var searchcriteria = new Array();
	                        	  if (enquiryFirstName.getValue() != "") {
	                        		  searchcriteria.push({
	                        			  paramCode: "ENQUIRER_FIRST_NAME",
	                        			  paramValues: [enquiryFirstName.getValue()]
	                        		  });
	                        	  }
	                        	  if (enquiryMiddleName.getValue() != "" && enquiryMiddleName.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "ENQUIRER_MIDDLE_NAME",
	                        			  paramValues: [enquiryMiddleName.getValue()]
	                        		  });
	                        	  }
	                        	  if (enquiryLastName.getValue() != "" && enquiryLastName.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "ENQUIRER_LAST_NAME",
	                        			  paramValues: [enquiryLastName.getValue()]
	                        		  });
	                        	  }
	                        	  if (email.getValue() != "" && email.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "PRIMARY_EMAIL_ID",
	                        			  paramValues: [email.getValue()]
	                        		  });
	                        	  }
	                        	  if (mobileNo.getValue() != "" && mobileNo.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "CELL_NO",
	                        			  paramValues: [mobileNo.getValue()]
	                        		  });
	                        	  }
	                        	  if (phoneNo.getValue() != "" && phoneNo.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "PHONE_NO",
	                        			  paramValues: [phoneNo.getValue()]
	                        		  });
	                        	  }
	                        	  values.searchCriterias = searchcriteria;
	                        	  return values;
	                          },
	                          gridRenderFunction: function(grid) {
	                        	  grid.addDocked(
	                        			  {
	                        				  xtype: 'toolbar',
	                        				  dock: 'top',
	                        				  items: [{
	                        					  xtype: 'button',
	                        					  itemId: 'btnAdd',
	                        					  tooltip: getCommonTranslation('ADD'),
	                        					  glyph: ICONGLYPH.ADDGLYPH
	                        				  }]
	                        			  });
	                          },
	                          loadFollowUpGrid: function(model, records) {
	                        	  var quickSearchForm = this.getFollowupscheduledform();
	                        	  var jsonFormatFormData = this.createJsonFormat(quickSearchForm, records);
	                        	  var searchResultGrid = this.getFollowupscheduledgrid();
	                        	  var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
	                        	  var followUpForm = quickSearchForm.getForm();
	                        	  var enquiryTypeName = followUpForm.findField('enquiryType');
	                        	  if(enquiryTypeName.getRawValue() === "Admission"){
	                        		  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FOLLOWUP_REPORT_LISTING_ADMISSION_VIEWCODE);
	                        	  }
	                        	  else{
	                        		  resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FOLLOWUP_REPORT_LISTING_VIEWCODE);
	                        	  }
	                        	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                        	  searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	                        	  Ext.getBody().unmask();
	                          },
	                          createJsonFormat: function(quickSearchForm, record) {
	                        	  var followUpForm = quickSearchForm.getForm();
	                        	  var enquiryTypeName = followUpForm.findField('enquiryType');
	                        	  var fromDate = followUpForm.findField('fromDate');
	                        	  var toDate = followUpForm.findField('toDate');
	                        	  //var enquiryNo = followUpForm.findField('enquiryNo');
	                        	  var organizationForm=this.getOrganizationunit().getForm();
	                        	  var academyLocation=organizationForm.findField('academyLocation');
	                        	  var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
	                        	  var department = followUpForm.findField('department');
	                        	  var assignTo = followUpForm.findField('assignTo');
	                        	  var acdemyLocationArray=[];
	                        	  if(!academyLocation.isHidden()){
	                        		  Ext.Array.each(academyLocation.getValue(),function(value){
	                        			  if(Ext.isObject(value)){
	                        				  acdemyLocationArray.push(value.data.id);
	                        			  }else{
	                        				  acdemyLocationArray.push(value);	
	                        			  }
	                        		  });
	                        	  }
	                        	  if(!multiselectAcademyLocation.isHidden()){
	                        		  Ext.Array.each(multiselectAcademyLocation.getValue(),function(value){
	                        			  if(Ext.isObject(value)){
	                        				  acdemyLocationArray.push(value.data.id);
	                        			  }else{
	                        				  acdemyLocationArray.push(value);	
	                        			  }
	                        		  });
	                        	  }
	                        	  var values = new Object();
	                        	  //values.configCode = CONSTANTS.CB.FOLLOWUP_REPORT_LISTING_CONFIGCODE;
	                        	  if(enquiryTypeName.getRawValue() === "Admission"){
	                        		  values.configCode = CONSTANTS.CB.FOLLOWUP_REPORT_LISTING_ADMISSION_CONFIGCODE;
	                        	  }
	                        	  else{
	                        		  values.configCode = CONSTANTS.CB.FOLLOWUP_REPORT_LISTING_CONFIGCODE;
	                        	  }
	                        	  var searchcriteria = new Array();
	                        	  if (enquiryTypeName.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "ENQUIRY_TYPE_ID",
	                        			  paramValues: [enquiryTypeName.getValue()]
	                        		  });
	                        	  }
	                        	  if (toDate.getValue() != null && fromDate.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "FOLLOW_UP_DATE_BETWEEN",
	                        			  paramValues: [fromDate.getValue(), toDate.getValue()]
	                        		  });
	                        	  }
	                        	  /*if (fromDate.getValue() != null) {
			searchcriteria.push({
				paramCode: "FOLLOW_UP_DATE_AFTER",
				paramValues: [fromDate.getValue()]
			});
		}
		if (enquiryNo.getValue() != "") {
			searchcriteria.push({
				paramCode: "ENQUIRY_NO",
				paramValues: [enquiryNo.getValue()]
			});
		}*/
	                        	  if (acdemyLocationArray.length>0) {
	                        		  searchcriteria.push({
	                        			  paramCode: "ACADEMY_LOCATION_IDS",
	                        			  paramValues: acdemyLocationArray
	                        		  });
	                        	  }
	                        	  if (department.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "DEPARTMENT_ID",
	                        			  paramValues: [department.getValue()]
	                        		  });
	                        	  }
	                        	  if (assignTo.getValue() != null) {
	                        		  searchcriteria.push({
	                        			  paramCode: "ENQUIRY_ASSIGN_TO",
	                        			  paramValues: [assignTo.getValue()]
	                        		  });
	                        	  }
	                        	  values.searchCriterias = searchcriteria;
	                        	  return values;
	                          },
	                          //
	                          exportUserList : function(exportUrl,filetype,whetherAll) {
	                        	  var quickSearchForm=this.getFollowupscheduledform(); 
	                        	  var searchResultGrid = this.getFollowupscheduledgrid();
	                        	  var pagingtoolbaroptions = this.getFollowupscheduledgrid().down('pagingtoolbar').getStore().lastOptions;
	                        	  var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	                        	  var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	                        	  var visibleColumns=this.getVisibleColumns(searchResultGrid);
	                        	  var reportTitle=getCommonTranslation('ENQUIRY_DASHBOARD_LIST');
	                        	  if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	                        		  jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	                        	  }
	                        	  searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

	                          },

	                          createSearchCriteriaString: function(searchForm) {
	                        	  var me=this;
	                        	  var formValues = new Array();
	                        	  formValues = searchForm.getValues();        
	                        	  var searchCriteriaString="";
	                        	  for (var key in formValues) {
	                        		  var value = formValues[key];            
	                        		  if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	                        			  var keyValueJsonObject = me.getJsonObject( key , value);
	                        			  searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	                        		  }
	                        	  }
	                        	  searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	                        	  return searchCriteriaString;
	                          },

	                          getJsonObject : function(key, value) {
	                        	  if (value != '' && value != null ) {
	                        		  return {
	                        			  "paramCode" : key,
	                        			  "paramValues" : [ value ]
	                        		  };
	                        	  } 
	                          },
	                          getTrackEnquiryController:function(){
	                        	  return this.getController('enquiry.TrackEnquiryController');
	                          },
//	                          ***********************create Json Format for Pending Enq**************************************************************
	                          createJsonFormatPendingEnq:function(searchResultGrid,configCode){		
	                        	  var values = new Object();
	                        	  values.configCode = configCode;
	                        	  var searchcriteria = new Array();
	                        	  var data="";
	                        	  var store = searchResultGrid.getStore();
	                        	  var dataLength = searchResultGrid.getStore().data.length;
	                        	  var enqIds = new Array();
	                        	  for(var i=0; i< dataLength; i++){
	                        		  enqIds.push(store.data.items[i].data.ID);
	                        	  }
	                        	  searchcriteria.push({paramCode:"ENQUIRY_IDS", paramValues:enqIds});
	                        	  values.searchCriterias=searchcriteria;
	                        	  return values;
	                          },

//	                          ***********************Export functionality for Pending Enquiry******************************************************
	                          exportPnedingEnqDashboardList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode) {
	                        	  var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
	                        	  var searchCriteriaString=this.createSearchCriteriaStringDashboard(quickSearchForm);
	                        	  var jsonFormatFormData=this.createJsonFormatPendingEnq(searchResultGrid,configCode);
	                        	  var reportTitle;
	                        	  var visibleColumns=this.getVisibleColumns(searchResultGrid);
	                        	  if(searchResultGrid.itemId=='trackEnquiryGridDashBoardItemId'){
	                        		  var reportTitle=getCommonTranslation('ENQUIRY_SUMMARY_REPORT');
	                        	  }else{
	                        		  var reportTitle=getCommonTranslation('PENDING_ENQUIRY_LIST');
	                        	  }// dynamic change title nme

	                        	  if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
	                        		  jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	                        	  }
	                        	  searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	                          },
	                          createSearchCriteriaStringDashboard: function(searchForm) { 
	                        	  var me=this;
	                        	  var formValues = new Array();
	                        	  /*formValues = searchForm.getValues();        
		var searchCriteriaString="";
		for (var key in formValues) {
			  var value = formValues[key];            
			  if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
				  var keyValueJsonObject = me.getJsonObject( key , value);
				  searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
			  }
	}*/
	                        	  searchCriteriaString="";
	                        	  searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	                        	  return searchCriteriaString;
	                          },
	                          /**
	                           * load data in address fields while selecting student in create enquiry form.
	                           */
	                          loadDataInAddressFieldsInCreateEnquiryForm:function(data,form){
	                        	  var fname = form.findField('enquirerFirstName');
	                        	  var mname = form.findField('enquirerMiddleName');
	                        	  var lname = form.findField('enquirerLastName');
	                        	  var regByField=form.findField('registeredBy');
	                        	  var regByRaw = regByField.getValue();
//	                        	  var cellCountrycodeField = form.findField('cellCountrycode');
	                        	  var cellNumberField = form.findField('cellNumber');
	                        	  var regdEmailField = form.findField('regdEmail');
	                        	  var phoneCountryCodeField = form.findField('phoneCountryCode');
//	                        	  cellCountrycodeField.reset();
	                        	  var salutation=form.findField('raiseEnquirySalutation');
	                        	  cellNumberField.reset();
	                        	  //regdEmailField.reset();
	                        	  //phoneCountryCodeField.reset();

	                        	  if((regByRaw == 'STUDENT'||regByRaw == "INTERNAL_USERS") && data!=null){
	                        		  fname.setValue(data.firstName);
	                        		  mname.setValue(data.middleName);
	                        		  lname.setValue(data.lastName);
	                        		  regdEmailField.setValue(data.emailId);
	                        		  cellNumberField.setValue(data.phoneNo);
//	                        		  phoneCountryCodeField.setValue(data.mobileCountryCode); comment out because we are unable to set value
	                        		  if(data.mobileNumber!=null && data.mobileNumber!=""){
	                        			  cellNumberField.setValue(data.mobileNumber);
	                        		  }
	                        		  phoneCountryCodeField.getStore().load({
	                        			  callback: function(records, operation, success) {
	                        				  if(success && data.mobileCountryCode!=null){
	                        					  for(i in records){
	                        						  if(records[i].data.isdCode==data.mobileCountryCode){
	                        							  phoneCountryCodeField.setValue(records[i].data.isdCode);  
	                        						  }
	                        					  }
	                        					  
	                        				  }
	                        			  }	
	                        		  });
	                        		  
	                        		  salutation.getStore().load({
	                        			  callback: function(records, operation, success) {
	                        				  if(success && data.salutationId!=null){
	                        					  for(i in records){
	                        						  if(records[i].data.id==data.salutationId){
	                        							  salutation.setValue(records[i].data.id);  
	                        						  }
	                        					  }
	                        					  
	                        				  }
	                        			  }	
	                        		  });
	                        		  /**
	                        		   * Load data on the bases of rest call.
	                        		   */
	                        		  var submitUrl = SERVERURL.FETCH_DATA_OF_STUDENT_USER_ID;
	                        		  Ext.Ajax.request({
	                        			  type:'rest',
	                        			  url:submitUrl,
	                        			  method:'GET',
	                        			  params:{
	                        				  userId: data.studentId
	                        			  },
	                        			  success: function(response, action) {
	                        				  Ext.apply(form,{
	                        					  code:null,
	                        					  setCode : function(code){
	                        						  form.code = code;
	                        					  },
	                        					  getCode:function(){
	                        						  return form.code;
	                        					  }
	                        				  });
	                        				  var addresData;
	                        				  if(!isNullOrEmpty(response.responseText) && response.responseText != "") {
	                        					  var jdata =Ext.decode(response.responseText);
	                        					  form.setCode(jdata);
	                        					  addresData=jdata.address;
	                        				  }

	                        				  if(!isNullOrEmpty(addresData)){

//	                        					  cellCountrycodeField.getStore().load({
//	                        					  callback:function(){
//	                        					  cellCountrycodeField.setValue(addresData.cellCountryCode);		
//	                        					  }
//	                        					  });

	                        					  addresData.cellNo &&  cellNumberField.setValue(addresData.cellNo);
	                        					  addresData.primaryeEmailId && regdEmailField.setValue(addresData.primaryeEmailId);
	                        					  addresData.country.code && phoneCountryCodeField.setValue(addresData.country.code);
	                        					  /*phoneCountryCodeField.getStore().load({
						callback:function(){
							phoneCountryCodeField.setValue(addresData.phoneCountryCode);		
						}
					});*/

	                        				  }
	                        			  }
	                        		  });
	                        	  }	
	                          },
	                          //******************Disable disable EnquiryDashboardWidget Pivileges************************************************************
	                          disableCountOfEnquiryDashboardWidgetPivileges: function(gridReference,permissionsMap) {
	                        	  var associatedAcadLocationIds = new Array();
	                        	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                        	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	                        	  var countcfenquirypanel = gridReference.down('#countcfenquirypanel');
	                        	  countcfenquirypanel.setVisible(false);

	                        	  Ext.each(permissionList, function(privilege) {
	                        		  if (privilege === 'VIEW') {
	                        			  if(!isNullOrEmpty(countcfenquirypanel)){
	                        				  countcfenquirypanel.setVisible(true);
	                        			  }        		
	                        		  }

	                        	  });
	                          },   
	                          //******************Disable disable EnquiryDashboardWidget Pivileges************************************************************
	                          disableClosureRateEnquiryDashboardWidgetPivileges: function(gridReference,permissionsMap) {
	                        	  var associatedAcadLocationIds = new Array();
	                        	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                        	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	                        	  var closurerateItemId = gridReference.down('#closurerateItemId');
	                        	  closurerateItemId.setVisible(false);

	                        	  Ext.each(permissionList, function(privilege) {
	                        		  if (privilege === 'VIEW') {
	                        			  if(!isNullOrEmpty(closurerateItemId)){
	                        				  closurerateItemId.setVisible(true);
	                        			  }        		
	                        		  }

	                        	  });
	                          }, 
	                          //******************Disable disable EnquiryDashboardWidget Pivileges************************************************************
	                          disableClosureReasonEnquiryDashboardWidgetPivileges: function(gridReference,permissionsMap) {
	                        	  var associatedAcadLocationIds = new Array();
	                        	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                        	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	                        	  var closurereasonItemId = gridReference.down('#closurereasonItemId');
	                        	  closurereasonItemId.setVisible(false);

	                        	  Ext.each(permissionList, function(privilege) {
	                        		  if (privilege === 'VIEW') {
	                        			  if(!isNullOrEmpty(closurereasonItemId)){
	                        				  closurereasonItemId.setVisible(true);
	                        			  }        		
	                        		  }

	                        	  });
	                          },  
	                          //******************Disable disableEnquiryFollowupScheduledDashboardWidgetPivileges Pivileges************************************************************
	                          disableEnquiryFollowupScheduledDashboardWidgetPivileges: function(gridReference,permissionsMap) {
	                        	  var associatedAcadLocationIds = new Array();
	                        	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                        	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	                        	  var followupscheduledItemId = gridReference.down('#followupscheduledItemId');
	                        	  followupscheduledItemId.setVisible(false);

	                        	  Ext.each(permissionList, function(privilege) {
	                        		  if (privilege === 'VIEW') {
	                        			  if(!isNullOrEmpty(followupscheduledItemId)){
	                        				  followupscheduledItemId.setVisible(true);
	                        			  }        		
	                        		  }

	                        	  });
	                          },  
	                          //******************Disable disable EnquiryDashboardWidget Pivileges************************************************************
	                          disablePendingEnquiryDashboardWidgetPivileges: function(gridReference,permissionsMap) {
	                        	  var associatedAcadLocationIds = new Array();
	                        	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                        	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	                        	  var pendinenquiryItemId = gridReference.down('#pendinenquiryItemId');
	                        	  pendinenquiryItemId.setVisible(false);
	                        	  console.log('Dashboard')
	                        	  Ext.each(permissionList, function(privilege) {
	                        		  if (privilege === 'VIEW') {
	                        			  if(!isNullOrEmpty(pendinenquiryItemId)){
	                        				  pendinenquiryItemId.setVisible(true);
	                        			  }        		
	                        		  }

	                        	  });
	                          },

	                          addNameUtil : function(form) {
	                        	  var perespective = form.findField('studentFname');
	                        	  var fname = form.findField('enquirerFirstName').getRawValue();
	                        	  var lname = form.findField('enquirerLastName').getRawValue();
	                        	  var mname = form.findField('enquirerMiddleName').getRawValue();
	                        	  if(!isNullOrEmpty(mname)) {
	                        		  if(!isNullOrEmpty(lname)) {
	                        			  perespective.setValue(fname+" "+mname+" "+lname);
	                        		  } else {
	                        			  perespective.setValue(fname+" "+mname);
	                        		  }
	                        	  } else {
	                        		  if(!isNullOrEmpty(lname)) {
	                        			  perespective.setValue(fname+" "+lname);
	                        		  } else {
	                        			  perespective.setValue(fname);
	                        		  }
	                        	  }

	                          },    
	                          checkNationalId: function(nationId){
		                          	var $this = this;
		                          	var result = false;
		                        	Ext.Ajax.request({
		                        		type: 'rest',
		                        		async: false,
		                        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		                        		params: {
		                        			screenName: 'enquiryformrevamp',
		                        			academyLocationId: this.getCurrentAcademyLocation(),
		                        			languageCode:'en'
		                        		},
		                        		method: 'GET',
		                        		success: function(res, action) {
		                        			var response = Ext.decode(res.responseText);
		                        			if( Object.keys(response).length > 0 ){
		                        				var records=response.enquiryformrevamp;
		                        				for(i in records){
		                        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='nationalId' && records[i].isMandatory==true){
		                        						nationId.allowBlank = false;
		                        						result = true;
		                        					}else{
		                        						if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='nationalId' && records[i].isMandatory==false){
		                        							nationId.allowBlank = true;
		                        							result = true;
		                        						}
		                        						
		                        					}
		                        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='nationalId' && records[i].isVisible==true){
		                        						nationId.setVisible(true);
		                        						result = true;
		                        					}else{
		                        						if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='nationalId' && records[i].isVisible==false){
		                        							nationId.setVisible(false);
		                        							result = true;
		                        						}
		                        					}
		                        				}
		                        			}else{
		                        				result = false;
		                        			}
		                        		}
		                        		
		                        	});
		                        	return result;
		                        },
		                        checkAreYouSouthAfrStudent: function(areYouSouthAfrStudent){
		                          	var $this = this;
		                          	var result = false;
		                        	Ext.Ajax.request({
		                        		type: 'rest',
		                        		async: false,
		                        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		                        		params: {
		                        			screenName: 'enquiryformrevamp',
		                        			academyLocationId: this.getCurrentAcademyLocation(),
		                        			languageCode:'en'
		                        		},
		                        		method: 'GET',
		                        		success: function(res, action) {
		                        			var response = Ext.decode(res.responseText);
		                        			if( Object.keys(response).length > 0 ){
		                        				var records=response.enquiryformrevamp;
		                        				for(i in records){
		                        					if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='isLearnerSACitizenItemId' && records[i].isVisible==true){
		                        						areYouSouthAfrStudent.setVisible(true);
		                        						result = true;
		                        					}else{
		                        						if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='isLearnerSACitizenItemId' && records[i].isVisible==false){
		                        							areYouSouthAfrStudent.setVisible(false);
		                        							result = true;
		                        						}
		                        					}
		                        				}
		                        			}else{
		                        				result = false;
		                        			}
		                        		}
		                        		
		                        	});
		                        	return result;
		                        },  
		                        loadDFRForSchoolPriority: function(schoolPriorityField){
		                        	var $this = this;
		                        	Ext.Ajax.request({
		                        		type: 'rest',
		                        		async: false,
		                        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		                        		params: {
		                        			screenName: 'enquiryformrevamp',
		                        			academyLocationId: this.getCurrentAcademyLocation(),
		                        			languageCode:'en'
		                        		},
		                        		method: 'GET',
		                        		success: function(res, action) {
		                        			var response = Ext.decode(res.responseText);
		                        			if( Object.keys(response).length > 0 ){
		                        				var records=response.enquiryformrevamp;
		                        				for(i in records){
		                        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='schoolPriority' && records[i].isVisible==false){
		                        						schoolPriorityField.setVisible(false);
		                        					}
		                        					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='schoolPriorityNew' && records[i].isVisible==true){
		                           						schoolPriorityField.setVisible(true);
		                           					}
		                        				}
		                        			}else{
		                           				schoolPriorityField.setVisible(true);
		                           			}
		                        		}
		                        		
		                        	});
		                        	
		                        },
		                        checkProgramCategoryDfr: function(form){
		                          	var $this = this;
		                          	var flag=0;
		                          	var programCategoryField = form.findField('programCategory');
		                        	Ext.Ajax.request({
		                        		type: 'rest',
		                        		async: false,
		                        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		                        		params: {
		                        			screenName: 'enquiryformrevamp',
		                        			academyLocationId: this.getCurrentAcademyLocation(),
		                        			languageCode:'en'
		                        		},
		                        		method: 'GET',
		                        		success: function(res, action) {
		                        			var response = Ext.decode(res.responseText);
		                        			if( Object.keys(response).length > 0 ){
		                        				var records=response.enquiryformrevamp;
		                        				for(i in records){
		                        					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='programCategoryId' && records[i].isVisible==true){
		                        						programCategoryField.setVisible(true);
		                        						if(records[i].isMandatory==true) {
		                        							programCategoryField.allowBlank = false;
		                        						}
		                        						else{
		                        							programCategoryField.allowBlank = true;
		                        						}
		                        						flag=1;
		                        					}else{
		                        						if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='programCategoryId' && records[i].isVisible==false){
		                        							programCategoryField.setVisible(false);
		                        							programCategoryField.allowBlank = true;
		                        							flag=1;
		                        						}
		                        					}
		                        				}
		                        			}if(flag==0){
		                        				programCategoryField.setVisible(true);
		                        			}
		                        			var checkFormValidity = $this.getEnquiryformrevamp();
		                        			checkFormValidity.getForm().checkValidity();
		                        		}
		                        		
		                        	});
		                        },
		                        
		                         loadDFRForsourceOther: function(sourceOther){
		                        	var $this = this;
		                        	Ext.Ajax.request({
		                        		type: 'rest',
		                        		async: false,
		                        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		                        		params: {
		                        			screenName: 'enquiryformrevamp',
		                        			academyLocationId: this.getCurrentAcademyLocation(),
		                        			languageCode:'en'
		                        		},
		                        		method: 'GET',
		                        		success: function(res, action) {
		                        			var response = Ext.decode(res.responseText);
		                        			if( Object.keys(response).length > 0 ){
		                        				var records=response.enquiryformrevamp;
		                        				var k=false;
		                        				for(i in records){
		                        					if(records[i].formFieldInputType=='textfield' && records[i].formFieldName=='enquirySourceOther' && records[i].isVisible==true){
		                        						sourceOther.setVisible(true);
		                        						k=true;
		                        						break;
		                        					}
		                        				}
		                        				if(k==false){
		                        					sourceOther.setVisible(false);
		                        				}
		                        		   } 
		                        		}
		                        		
		                        	});
		                        	
		                        }
	                          
});
