/**
 * @author Abhishek Chouhan
 * 
 */
Ext.define('Academia.controller.examinationcenters.marksheet.FacultyMarksheetGenerationController', {
	//xtend : 'Ext.app.Controller',
	extend : 'Academia.controller.base.BaseController',
	stores : ['examinationcenters.marksheet.Jobstatus','examinationcenters.marksheet.MarksheetGenerationStore',
	          'examinationcenters.marksheet.StudentMarksheetStore','common.ProgramStore','common.BatchesByProgramId','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.SectionAndFacultyByPeriodID','examinationcenters.marksheet.MarksheetTemplateStore',
	          'examinationcenters.marksheet.MarksheetLevelsCombo','examinationcenters.marksheet.EvaluationLevelType','examinationcenters.marksheet.EvaluationLevelName',
	          'examinationcenters.YesNo', 'examinationcenters.marksheet.MarksheetEvaluationType','examinationcenters.marksheet.MarksheetJobIdCombo','Academia.store.common.ProgramsByAcademyLocationsIds',
	          'examinationcenters.reports.ExaminationReportProgramStore','examinationcenters.marksheet.MarksheetJobProgramListStore',
	          'examinationcenters.marksheet.MarksheetFilePatternStore','common.CurrentBatchStore','examinationcenters.marksheet.FacultyMarksheetReportGridStore','common.picklist.StudentActiveInactiveStatusStore'],
	views : ['examinationcenters.marksheet.FacultyMarksheetReportStructure','examinationcenters.marksheet.FacultyMarksheetReportFilter','examinationcenters.marksheet.FacultyMarksheetReportGrid',
			'Academia.view.examinationcenters.marksheet.FacultyMarksheetReportSearchTab'
		],
	 config:{
		 FACULTY_MARKSHEET_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MARKSHEET_REPORT_PRIVILEGES'),
	 },	         
          refs : [{
	        	  ref:'contentPanel',
                  selector:'contentPanel'
               },{
	        	  ref:'facultymarksheetreportfilter',
                  selector:'facultymarksheetreportfilter'
               },{
	        	  ref:'facultymarksheetreportgrid',
                  selector:'facultymarksheetreportgrid'
               }, {
            	   ref: 'facultymarksheetreportsearchtab',
            	   selector: 'facultymarksheetreportsearchtab'
               }],
	          init : function() {
	        	  this.control({
	        		
	        		  'facultymarksheetreportfilter' : {
	        			  	render : function(obj){
	        			  		var $this=this;
	        			  		var filterForm=obj.up('form').getForm();
	        			  		var alinfomodel = Academia.model.authentication.ALInfoModel;
	        			  		var wheatherSchool = alinfomodel.get('wheatherSchool');
	        			  		var program=filterForm.findField('programId');
	        			  		var facultyId = this.getCurrentlyLoggedInUser().id;
	        			  		var academyLocationIds=[];
		        				var academyLocationId=$this.getCurrentAcademyLocation();
		        				var status  = filterForm.findField('studentStatus').getValue();
		        				academyLocationIds.push(academyLocationId);
	        			  		if(wheatherSchool) {
	        			  			obj.up('form').down('#periodItemId').setVisible(false);
	        			  			filterForm.findField('consolidatedField').setVisible(false);
	        			  		}
	        			  		var marksheetJobName = filterForm.findField("marksheetJobName");
	        			  		marksheetJobName.getStore().getProxy().extraParams = {
	        			  			academyLocationIds:academyLocationIds.join()
		     					};
	        			  		marksheetJobName.getStore().load();
	        			  		
	        			  		var programByAcademyLocationStore = program.getStore();
 								programByAcademyLocationStore.getProxy().extraParams = {
 									facultyId: facultyId,
 									academyLocationIds: academyLocationId
 								};
 								programByAcademyLocationStore.load();
							 }
	        		  },
	        		 
					 'facultymarksheetreportfilter customcombobox[itemId=marksheetJobItemId]' : {
						 select : function(obj,rec){
		        			/* var data=rec[0].data.marksheetLevelName;
							 var filterForm=obj.up('form').getForm();
							 var sectionIdField=filterForm.findField('sectionId');
								sectionIdField.enable();
								sectionIdField.getStore().getProxy().extraParams={
									periodId:filterForm.findField('periodId').getValue()
		        				};*/
							/*var marksheetJobNameField=filterForm.findField('marksheetJobName');
							if(!isNullOrEmpty(marksheetJobNameField.getValue())){
								var store = marksheetJobNameField.getStore();
								store.getProxy().extraParams = {
									jobNameId: rec[0].data.marksheetJobName
		     					};
								  store.load({
	        	            		   callback: function(records, operation, success) {
	        	            			   if (success) {
	        	            				   if(records.length > 0){
	        	            					   marksheetJobNameField.setValue(records[0].data.id);
	        	            				   }		 
	        	            			   }
	        	            		   }	   
	        	            	   });	
								
							}*/
							/* if(!isNullOrEmpty(obj.getValue())){
								 Ext.Ajax.request({
										type : 'rest',
										url : SERVERURL.MARKSHEET_JOB_ID_FIND_PBPS_URL,
										params:{
											jobId:rec[0].data.marksheetJobId
										},
										method : 'GET',
										success : function(resp, action) {
											var respData = resp.responseText;
											var encodedData=Ext.JSON.decode(respData);
										if(!isNullOrEmpty(encodedData)){
											var jData=encodedData[0];
											var sectionIdField=filterForm.findField('sectionId');
											sectionIdField.enable();
											sectionIdField.getStore().getProxy().extraParams={
												periodId:jData.periodId
					        				};
											var marksheetJobNameField=filterForm.findField('marksheetJobName');
											marksheetJobNameField.setValue(jData.marksheetJobId);
											sectionIdField.getStore().load({
												callback:function(){
													var sectionArray=[];
													for(var i=0;i<jData.sectionIds.length;i++){
								        					sectionArray.push(jData.sectionIds[i].id);
							        				}
													sectionIdField.setValue(sectionArray);
												}
											});											
										}	
				     	                }
				     	    	    });
							  }*/
						 }
					  },
						 'facultymarksheetreportfilter customcombobox[itemId=marksheetJobNameItemId]' : {
							 select : function(obj,rec) {
								 var $this=this;
								 var alinfomodel = Academia.model.authentication.ALInfoModel;
								 var whetherSchool = alinfomodel.get('wheatherSchool');
								 var filterForm=obj.up('form').getForm();
								 var data;
								 var facultyId = this.getCurrentlyLoggedInUser().id;
								 if(!isNullOrEmpty(obj.getValue())){
									 Ext.Ajax.request({
										  type : 'rest',
											url : SERVERURL.MARKSHEET_JOB_ID_FIND_PBPS_URL,
											params:{
												jobId:obj.getValue()
											},
											method : 'GET',
											success : function(resp, action) {
												var respData = resp.responseText;
												var encodedData=Ext.JSON.decode(respData);
												
											if(!isNullOrEmpty(encodedData)){
												var jData=encodedData[0];
												//console.log('jData',jData);
												
												
												var programField=filterForm.findField('programId');
												var marksheetJobId=filterForm.findField('marksheetJobId');
												marksheetJobId.setDisabled(false);
												//programField.setReadOnly(true);
												programField.getStore('Academia.store.common.ProgramsByAcademyLocationsIds').load({
													callback:function(){
														programField.setValue(jData.programId);
													}
												});
												
												var batchField=filterForm.findField('batchId');
												batchField.enable();
												//batchField.setReadOnly(true);
												batchField.getStore().getProxy().extraParams={
						        					programId:jData.programId
						        				};
												batchField.getStore().load({
													callback:function(){
														batchField.setValue(jData.batchId);
													}
												});
												var consolidatedField=filterForm.findField('consolidatedField');
												var periodIdField=filterForm.findField('periodId');
												var considerProgramTransfer=filterForm.findField('isConsiderProgramTransfer');
												var considerProgramTransferField=$this.getFacultymarksheetreportfilter().down('#considerProgramTransferField');
												consolidatedField.enable();
												consolidatedField.setReadOnly(true);
												consolidatedField.getStore().getProxy().extraParams={
						        					id:jData.programId
						        				};
												consolidatedField.getStore().load({
													callback:function(res){
														if(jData.isConsolidated == true){
															consolidatedField.setValue(res[0]);
															periodIdField.reset();
															periodIdField.setDisabled(true);
															periodIdField.setVisible(false);
															//considerProgramTransferField.setVisible(true);
															if(jData.isConsiderProgramTransfer){
																considerProgramTransfer.items.items[0].setValue(true);
																considerProgramTransfer.items.items[1].setValue(false);
															}else{
																considerProgramTransfer.items.items[0].setValue(false);
																considerProgramTransfer.items.items[1].setValue(true);
															}
															considerProgramTransfer.setReadOnly(true);
															considerProgramTransfer.disable();
														}
														else{
															periodIdField.reset();
															periodIdField.setDisabled(false);
															consolidatedField.setValue(res[1]);
															periodIdField.enable();
															//periodIdField.setReadOnly(true);
								        			  		if(!whetherSchool) {
								        			  			periodIdField.setVisible(true);
								        			  		} else {
								        			  			periodIdField.setVisible(false);
								        			  		}
															periodIdField.getStore().getProxy().extraParams={
									        					id:jData.batchId
									        				};
															periodIdField.getStore().load({
																callback:function(){
																	periodIdField.setValue(jData.periodId);
																}
															});
															//considerProgramTransferField.setVisible(false);
														}
														var sectionIdField=filterForm.findField('sectionId');
														sectionIdField.setDisabled(false);
														sectionIdField.getStore().getProxy().extraParams={
								        					periodId:jData.periodId,
								        					facultyId: facultyId,
								        				};
														sectionIdField.getStore().load();
													}
												});
											}
											}
									});
											
								 
									var marksheetJobId = filterForm.findField('marksheetJobId');
									 marksheetJobId.reset();
									 marksheetJobId.setDisabled(false);
									 marksheetJobId.getStore().getProxy().extraParams = {
										 marksheetJobId:filterForm.findField('marksheetJobName').getValue()
				     					};
									 marksheetJobId.getStore().load({
											callback:function(records){
												records && marksheetJobId.setValue(records[0].data.marksheetJobId);
											}
										});	
								 } 
							 }
						  },
					
	        		  'facultymarksheetreportfilter button[itemId=searchBtn]':{
	        			  click:function(obj){
	        				var $this = this; 
	        				var filterForm=obj.up('form');
	        				var studentGrid=this.getFacultymarksheetreportgrid();  
	        				var formValues=filterForm.getForm().getValues();
	        				var alinfomodel = Academia.model.authentication.ALInfoModel;
        			  		var whetherSchool = alinfomodel.get('wheatherSchool');
        			  		var studentStatus =formValues.studentStatus;
        			  		var sectionArray=[];
	        				var records;
	        				if(!isNullOrEmpty(formValues.sectionId)){
	        				for(var i=0;i<formValues.sectionId.length;i++){
	        					var sectionValue=formValues.sectionId[i];
	        					if(Ext.isObject(sectionValue)){
	        						sectionArray.push(sectionValue.data.sectionId);
		        				}else{
		        					sectionArray.push(sectionValue);
		        				}	
	        				}
	        				}
	        				studentGrid.getStore().getProxy().extraParams={
	        					jobId:formValues.marksheetJobName,
	        					programId:formValues.programId,
	        					batchId:formValues.batchId,
	        					periodId:formValues.periodId,
	        					sectionIds:sectionArray.join(),
	        					marksheetLevelId:formValues.marksheetJobId,
	        					isConsiderProgramTransfer:formValues.isConsiderProgramTransfer,
	        					studentStatus:formValues.studentStatus,
	        					
	        				};
	        				var gridColumns = studentGrid.columns;
	        				var len = gridColumns.length;
	        				if(formValues.consolidatedField=="YES"){
	        					 for (var j = 0; j < len; j++) {
	 	        			        var gridColumn = gridColumns[j];
	 	        			            if (gridColumn.dataIndex == "sectionName") {
	 	        			                    gridColumn.hide();
	 	        			            }
	 	        			            if (gridColumn.dataIndex == "periodName") {
	         			                    gridColumn.hide();
	         			            }
	 	        			    }
	        				}else{
	        					 for (var j = 0; j < len; j++) {
		 	        			        var gridColumn = gridColumns[j];
		 	        			            if (gridColumn.dataIndex == "sectionName") {
		 	        			                    gridColumn.show();
		 	        			            }
		 	        			            if (gridColumn.dataIndex == "periodName") {
		 	        			            	if(whetherSchool){
		 	        			            		gridColumn.hide();
		 	        			            	} else{
		 	        			            		gridColumn.show();
		 	        			            	}
		         			            }
		 	        			    }
	        				}
	        				studentGrid.getStore().load({
	        					callback:function(record){
	        						studentGrid.getSelectionModel().deselectAll();
	        						for(var i=0;i<record.length;i++){
	        							var rec=record[i];
	        						  if(!isNullOrEmpty(rec.data.marksheetPath)){
	        							 studentGrid.getSelectionModel().select(rec,true);  
	        						  }
	        						}
	        						$this.enableDisablePublishBtn(studentGrid,record);
	        						$this.enableDisableDownloadAllBtn(studentGrid,record);
	        					}
	        				});
	        				if(!isNullOrEmpty(formValues.marksheetJobId)){
	        					  var buttonsToolBar = studentGrid.query('toolbar')[0];
	        					  var button = buttonsToolBar.query('#btnGenerateMarksheet')[0];
	        					  button.enable();
	        				}	
	        				filterForm.focus();
	        			}
	        		  },
	        		  'facultymarksheetreportfilter button[itemId=resetBtn]':{
	        			  click:function(obj){
	        				var $this=this;
	        				var filterForm=obj.up('form');
	        				var getForm=filterForm.getForm();
	        				var program = getForm.findField('programId');
	        				var alinfomodel = Academia.model.authentication.ALInfoModel;
        			  		var wheatherSchool = alinfomodel.get('wheatherSchool');
        			  		var academyLocationIds=[];
	        				var academyLocationId=$this.getCurrentAcademyLocation();
	        				academyLocationIds.push(academyLocationId);
	        				var facultyId = $this.getCurrentlyLoggedInUser().id;
	        				program.setDisabled(false);
	        				program.setReadOnly(false);
	        				getForm.findField('batchId').setDisabled(true);
	        				getForm.findField('batchId').setReadOnly(false);
	        				getForm.findField('periodId').setDisabled(true);
	        				getForm.findField('periodId').setReadOnly(false);
	        				if(wheatherSchool) {
	        					getForm.findField('periodId').setVisible(false);
	        					getForm.findField('consolidatedField').setVisible(false);
        			  		}
	        				getForm.findField('sectionId').setDisabled(true);
	        				getForm.findField('marksheetJobId').setDisabled(true);
	        				filterForm.down('#considerProgramTransferField').setVisible(false);
	        				getForm.findField('isConsiderProgramTransfer').setDisabled(true);
	        				var jobName = getForm.findField('marksheetJobName');
	        				jobName.reset();
	        				jobName.setDisabled(true);
	        				getForm.findField('consolidatedField').setReadOnly(false);
	        				getForm.findField('consolidatedField').setDisabled(true);
	        				getForm.reset();
	        				var studentGrid=this.getFacultymarksheetreportgrid();  
	        				var buttonsToolBar = studentGrid.query('toolbar')[0];
      					    var button = buttonsToolBar.query('#btnGenerateMarksheet')[0];
      					    button.disable();
      					    var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
      					    publishButton.disable();
      					    var downloadButton = buttonsToolBar.query('#btnDownloadAllMarksheet')[0];
							downloadButton.disable();
							jobName.getStore().getProxy().extraParams ={
								academyLocationIds:academyLocationIds.join()
							};
							jobName.getStore().load();
							program.reset();
							program.getStore().getProxy().extraParams= {
								facultyId: facultyId,
								academyLocationIds: academyLocationId
							};
							program.getStore().load();
							
	        			}
	        		  },
	        		  'facultymarksheetreportfilter customcombobox[itemId=programItemId]':{
	        			  select:function(obj,rec){
	        				var $this=this;
	        				var data=rec[0].data.id;  
	        				var filterForm=obj.up('form');
	        				var alinfomodel = Academia.model.authentication.ALInfoModel;
	        				var academyLocationIds=[];
	        				var academyLocationId=$this.getCurrentAcademyLocation();
	        				academyLocationIds.push(academyLocationId);
	        				var getForm=filterForm.getForm();
	        				var marksheetJobIdField=getForm.findField('marksheetJobName');
							marksheetJobIdField.reset();
							marksheetJobIdField.enable();
							var marksheetJobId =getForm.findField("marksheetJobId");
							marksheetJobId.reset();
        			  		var wheatherSchool = alinfomodel.get('wheatherSchool');
        			  		if(wheatherSchool) {
        			  			obj.up('form').down('#periodItemId').setVisible(false);
        			  			obj.up('form').down('#consolidatedItemId').setVisible(false);
        			  		}
	        				
	        				var consolidatedField=getForm.findField('consolidatedField');
	        				consolidatedField.reset();
	        				getForm.findField('sectionId').setDisabled(true);
	        				getForm.findField('marksheetJobName').reset();
	        				var batchField=getForm.findField('batchId');
                            var periodField=getForm.findField('periodId');
	        				batchField.enable();
	        				batchField.reset();
                            periodField.reset();
	        				batchField.getStore().getProxy().extraParams={
	        					programId:data
	        				};
	        				batchField.getStore().load({
	        					callback: function(records, operation, success) {
	        						if (success) {
	        							var batchId = 0;
	        							for(var i=0,j=0; i<records.length; i++){
	        								if (records.length == 1) {
	        									batchId = records[i].data.id;
	        								} else if(records[i].data.isCurrentPeriodOfProgram){
	        									if(j==0){
	        										batchId = records[i].data.id;
	        										j++;
	        									} else {
	        										batchId = 0;
	        										return;
	        									}
	        								}
	        							}
	        						}
	        						if(batchId > 0) {
	        							batchField.setValue(batchId);
	        							var marksheetJobIdField=getForm.findField('marksheetJobName');
	        							marksheetJobIdField.getStore().getProxy().extraParams={
	        								//periodId:records[0].data.id,
	        								programId:getForm.findField('programId').getValue(),
	        								batchId:getForm.findField('batchId').getValue(),
	        								//isConsolidated:false,
	        								academyLocationIds:academyLocationIds.join()
	        							};
	        							marksheetJobIdField.getStore().load({
	        								callback:function(record){
	        									marksheetJobId.setDisabled(true);
	        									marksheetJobId.reset();
	        									marksheetJobId.getStore().getProxy().extraParams = {
	        										marksheetJobId:marksheetJobIdField.getValue()
	        									};
	        									marksheetJobId.getStore().load({
	        										callback:function(records){
	        										}
	        									});
	        								}
	        							});
	        							var consolidatedField=getForm.findField('consolidatedField');
	        	        				consolidatedField.enable();
	        	        				var periodField=getForm.findField('periodId');
	        	        				var sectionIdField=getForm.findField('sectionId');
	        	        				var marksheetJobId =getForm.findField("marksheetJobId");
	        	        				
	        	        				var isConsiderProgramTransferField=filterForm.down('#considerProgramTransferField');
	        	        				var isConsiderProgramTransfer=getForm.findField('isConsiderProgramTransfer');
	        	        				sectionIdField.setDisabled(true);
	        	        				var consolidatedField=getForm.findField('consolidatedField');
	        	        				getForm.findField('sectionId').setDisabled(true);
	        	        				consolidatedField.getStore().load({
	        	        					callback: function(records, operation, success) {
	        	        						if (success) {
	        	        							for(var i = 0; i<records.length;i++){
	        	        								if(records[i].data.id == "NO"){
	        	        									consolidatedField.setValue(records[i].data.id)
	        	    	        							if(!wheatherSchool) {
	        	    	                						periodField.setVisible(true);
	        	    	                			  		}
	        	    	                					marksheetJobIdField.reset();
	        	    	        	        				marksheetJobId.reset();
	        	    	        	        				marksheetJobId.setDisabled(true);
	        	    	        	        				periodField.enable();
	        	    	        	        				periodField.reset();
	        	    	        	        				periodField.getStore().getProxy().extraParams={
	        	    	        	        					id:batchId
	        	    	        	        				};
	        	    	        	        				periodField.getStore().load({
	        	    	        	        					callback: function(records, operation, success) {
	        	    	        	        						if (success) {
	        	    	        	        							if(records.length == 0){
	        	    	        	        								if(wheatherSchool) {
	        	    	        	        									showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	        	    	        	        								}
	        	    	        	        							} else if(records.length == 1){
	        	    	        	        								periodField.setValue(records[0].data.id);
	        	    	        	        								if(wheatherSchool) {
	        	    	        	        									periodField.setVisible(false);
	        	    	        	        								}
	        	    	        	        								var sectionField=getForm.findField('sectionId');
	        	    	        	        								sectionField.enable();
	        	    	        	        								sectionField.reset();
	        	    	        	        								sectionField.getStore().getProxy().extraParams={
	        	    	        	        									periodId:records[0].data.id,
	        	    	        	        									facultyId:$this.getCurrentlyLoggedInUser().id
	        	    	        	        								};
	        	    	        	        								sectionField.getStore().load();
	        	    	        	        								
	        	    	        	        							} else {
	        	    	        	        								//periodField.setVisible(true);
	        	    	        	        								periodField.setValue(records[0].data.id);
	        	    	        	        								if(wheatherSchool) {
	        	    	        	        									periodField.setVisible(false);
	        	    	        	        								}
	        	    	        	        								var sectionField=getForm.findField('sectionId');
	        	    	        	        								sectionField.enable();
	        	    	        	        								sectionField.reset();
	        	    	        	        								sectionField.getStore().getProxy().extraParams={
	        	    	        	        									periodId:records[0].data.id,
	        	    	        	        									facultyId:$this.getCurrentlyLoggedInUser().id
	        	    	        	        								};
	        	    	        	        								sectionField.getStore().load();
	        	    	        	        							}
	        	    	        	        						}
	        	    	        	        					}
	        	    	        	        				});
	        	    	        	        				sectionIdField.setVisible(true);
	        	    	        	        				isConsiderProgramTransferField.setVisible(false);
	        	        								}
	        	        							}
	        	        						}
	        	        					}
	        	        				});
	        						}
	        					}
	        				});
	        				
	        				marksheetJobIdField.getStore().getProxy().extraParams={
								//periodId:records[0].data.id,
								programId:getForm.findField('programId').getValue(),
								batchId:getForm.findField('batchId').getValue(),
								//isConsolidated:false,
								academyLocationIds:academyLocationIds.join()
							};
							marksheetJobIdField.getStore().load({
								callback:function(record){
									marksheetJobId.setDisabled(true);
									marksheetJobId.reset();
									marksheetJobId.getStore().getProxy().extraParams = {
										marksheetJobId:marksheetJobIdField.getValue()
									};
									marksheetJobId.getStore().load({
										callback:function(records){
										}
									});
								}
							});
	        			}
	        		  },
	        		  'facultymarksheetreportfilter customcombobox[itemId=batchItemId]':{
	        			  select:function(obj,rec){
	        				var $this=this;
	        				var data=rec[0].data.id;
	        				var alinfomodel = Academia.model.authentication.ALInfoModel;
        			  		var wheatherSchool = alinfomodel.get('wheatherSchool');
        			  		if(wheatherSchool) {
        			  			obj.up('form').down('#periodItemId').setVisible(false);
        			  		}
	        				var filterForm=obj.up('form');
	        				var getForm=filterForm.getForm();
	        				var periodField=getForm.findField('periodId');
	        				var sectionIdField=getForm.findField('sectionId');
	        				var marksheetJobId =getForm.findField("marksheetJobId");
	        				var marksheetJobIdField=getForm.findField('marksheetJobName');
	        				var isConsiderProgramTransferField=filterForm.down('#considerProgramTransferField');
	        				var isConsiderProgramTransfer=getForm.findField('isConsiderProgramTransfer');
	        				sectionIdField.setDisabled(true);
	        				var consolidatedField=getForm.findField('consolidatedField');
	        				consolidatedField.enable();
	        				getForm.findField('sectionId').setDisabled(true);
	        				var facultyId = this.getCurrentlyLoggedInUser().id;
	        				consolidatedField.getStore().load({
	        					callback: function(records, operation, success) {
	        						if (success) {
	        							for(var i = 0; i<records.length;i++){
	        								if(records[i].data.id == "NO"){
	        									consolidatedField.setValue(records[i].data.id)
	    	        							if(!wheatherSchool) {
	    	                						periodField.setVisible(true);
	    	                			  		}
	    	                					marksheetJobIdField.reset();
	    	        	        				marksheetJobId.reset();
	    	        	        				marksheetJobId.setDisabled(true);
	    	        	        				periodField.enable();
	    	        	        				periodField.reset();
	    	        	        				periodField.getStore().getProxy().extraParams={
	    	        	        					id:data
	    	        	        				};
	    	        	        				periodField.getStore().load({
	    	        	        					callback: function(records, operation, success) {
	    	        	        						if (success) {
	    	        	        							if(records.length == 0){
	    	        	        								if(wheatherSchool) {
	    	        	        									showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	    	        	        								}
	    	        	        							} else if(records.length == 1){
	    	        	        								periodField.setValue(records[0].data.id);
	    	        	        								if(wheatherSchool) {
	    	        	        									periodField.setVisible(false);
	    	        	        								}
	    	        	        								var sectionField=getForm.findField('sectionId');
	    	        	        								sectionField.enable();
	    	        	        								sectionField.reset();
	    	        	        								sectionField.getStore().getProxy().extraParams={
	    	        	        									periodId:records[0].data.id,
	    	        	        									facultyId:facultyId
	    	        	        								};
	    	        	        								sectionField.getStore().load();
	    	        	        								var marksheetJobIdField=getForm.findField('marksheetJobName');
	    	        	        								marksheetJobIdField.reset();
	    	        	        								var marksheetJobId =getForm.findField("marksheetJobId");
	    	        	        								marksheetJobId.reset();
	    	        	        								marksheetJobIdField.getStore().getProxy().extraParams={
	    	        	        									periodId:records[0].data.id,
	    	        	        									programId:getForm.findField('programId').getValue(),
	    	        	        									batchId:data,
	    	        	        									isConsolidated:false
	    	        	        								};
	    	        	        								marksheetJobIdField.getStore().load({
	    	        	        									callback:function(record){
	    	        	        										marksheetJobId.setDisabled(true);
	    	        	        										marksheetJobId.reset();
	    	        	        										marksheetJobId.getStore().getProxy().extraParams = {
	    	        	        											marksheetJobId:marksheetJobIdField.getValue()
	    	        	        										};
	    	        	        										marksheetJobId.getStore().load({
	    	        	        											callback:function(records){
	    	        	        											}
	    	        	        										});
	    	        	        									}
	    	        	        								});
	    	        	        							} else {
	    	        	        								periodField.setVisible(true);
	    	        	        							}
	    	        	        						}
	    	        	        					}
	    	        	        				});
	    	        	        				sectionIdField.setVisible(true);
	    	        	        				isConsiderProgramTransferField.setVisible(false);
	        								}
	        							}
	        						}
	        					}
	        				});
	        			}
	        		  },
	        		  'facultymarksheetreportfilter customcombobox[itemId=consolidatedItemId]':{
	        			  select:function(obj,rec){
	        				var data=rec[0].data.id;  
	        				var filterForm=obj.up('form');
	        				var alinfomodel = Academia.model.authentication.ALInfoModel;
        			  		var wheatherSchool = alinfomodel.get('wheatherSchool');
        			  		if(wheatherSchool) {
        			  			filterForm.down('#periodItemId').setVisible(false);
        			  		}
	        				var getForm=filterForm.getForm();
	        				var periodField=getForm.findField('periodId');
	        				var sectionIdField=getForm.findField('sectionId');
	        				var marksheetJobId =getForm.findField("marksheetJobId");
	        				var marksheetJobIdField=getForm.findField('marksheetJobName');
	        				var isConsiderProgramTransferField=filterForm.down('#considerProgramTransferField');
	        				var isConsiderProgramTransfer=getForm.findField('isConsiderProgramTransfer');
	        				var facultyId = this.getCurrentlyLoggedInUser().id;
	        				sectionIdField.setDisabled(true);
	        				if(data == "NO") {
	        					if(!wheatherSchool) {
	        						periodField.setVisible(true);
	        			  		}
	        					marksheetJobIdField.reset();
		        				marksheetJobId.reset();
		        				marksheetJobId.setDisabled(true);
		        				periodField.enable();
		        				periodField.reset();
		        				periodField.getStore().getProxy().extraParams={
		        					id:getForm.findField('batchId').getValue()
		        				};
		        				periodField.getStore().load({
		        					callback: function(records, operation, success) {
		        						if (success) {
		        							if(records.length == 0){
		        								if(wheatherSchool) {
		        									showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
		        								}
		        							} else if(records.length == 1){
		        								periodField.setValue(records[0].data.id);
		        								if(wheatherSchool) {
		        									periodField.setVisible(false);
		        								}
		        								var sectionField=getForm.findField('sectionId');
		        								sectionField.enable();
		        								sectionField.reset();
		        								sectionField.getStore().getProxy().extraParams={
		        									periodId:records[0].data.id,
		        									facultyId:facultyId
		        								};
		        								sectionField.getStore().load();
		        								var marksheetJobIdField=getForm.findField('marksheetJobName');
		        								marksheetJobIdField.reset();
		        								var marksheetJobId =getForm.findField("marksheetJobId");
		        								marksheetJobId.reset();
		        								marksheetJobIdField.getStore().getProxy().extraParams={
		        									periodId:records[0].data.id,
		        									programId:getForm.findField('programId').getValue(),
		        									batchId:getForm.findField('batchId').getValue(),
		        									isConsolidated:false
		        								};
		        								marksheetJobIdField.getStore().load({
		        									callback:function(record){
		        										marksheetJobId.setDisabled(true);
		        										marksheetJobId.reset();
		        										marksheetJobId.getStore().getProxy().extraParams = {
		        											marksheetJobId:marksheetJobIdField.getValue()
		        										};
		        										marksheetJobId.getStore().load({
		        											callback:function(records){
		        											}
		        										});
		        									}
		        								});
		        							} else {
		        								periodField.setVisible(true);
		        							}
		        						}
		        					}
		        				});
		        				sectionIdField.setVisible(true);
		        				isConsiderProgramTransferField.setVisible(false);
	        				} else{
	        					periodField.reset();
	        					periodField.setDisabled(true);
	        					periodField.setVisible(false);
		        				marksheetJobIdField.reset();
		        				marksheetJobId.reset();
		        				sectionIdField.setVisible(false);
		        				marksheetJobIdField.getStore().getProxy().extraParams={
		        					batchId:getForm.findField('batchId').getValue(),
		        					programId:getForm.findField('programId').getValue(),
		        					isConsolidated:true
		        				};
		        				marksheetJobIdField.getStore().load({
		        						callback:function(record){
		        							/*marksheetJobIdField.setValue(record[0]);
		        							marksheetJobId.setDisabled(false);*/
											 marksheetJobId.reset();
											 marksheetJobId.getStore().getProxy().extraParams = {
												 marksheetJobId:marksheetJobIdField.getValue()
						     					};
											 marksheetJobId.getStore().load({
													callback:function(records){
													}
												});
			        					}
		        				});
		        				isConsiderProgramTransferField.setVisible(true);
		        				isConsiderProgramTransfer.enable();
		        				isConsiderProgramTransfer.setReadOnly(false);;
	        				}
	        				getForm.isValid();
	        			}
	        		  },
	        		  'facultymarksheetreportfilter customcombobox[itemId=periodItemId]':{
	        			  select:function(obj,rec){
	        				var $this=this;
	        				var data=rec[0].data.id;  
	        				var filterForm=obj.up('form');
	        				var getForm=filterForm.getForm();
	        				var sectionField=getForm.findField('sectionId');
	        				var facultyId = this.getCurrentlyLoggedInUser().id;
	        				sectionField.enable();
	        				sectionField.reset();
	        				sectionField.getStore().getProxy().extraParams={
	        					periodId:data,
	        					facultyId:facultyId
	        				};
	        				sectionField.getStore().load();
	        				var marksheetJobIdField=getForm.findField('marksheetJobName');
	        				marksheetJobIdField.reset();
	        				var marksheetJobId =getForm.findField("marksheetJobId");
	        				marksheetJobId.reset();
	        				marksheetJobIdField.getStore().getProxy().extraParams={
	        					periodId:data,
	        					programId:getForm.findField('programId').getValue(),
	        					batchId:getForm.findField('batchId').getValue(),
	        					isConsolidated:false
	        				};
	        				marksheetJobIdField.getStore().load({
	        						callback:function(record){
	        							//marksheetJobIdField.setValue(record[0]);
	        							marksheetJobId.setDisabled(true);
										 marksheetJobId.reset();
										 marksheetJobId.getStore().getProxy().extraParams = {
											 marksheetJobId:marksheetJobIdField.getValue()
					     					};
										 marksheetJobId.getStore().load({
												callback:function(records){
												}
											});
		        					}
	        				});
	        			}
	        		  },
	        		 
	        		  'facultymarksheetreportgrid button[itemId=btnPublishMarksheet]':{
	        			  click:function(obj){
	        				  this.savePublshMarksheet();
	        			}
	        		  },
	        		  
	        		  'facultymarksheetreportgrid button[itemId=btnDownloadAllMarksheet]':{
	        			  click:function(obj){
	        				  this.downloadAllMarksheetZip();
	        			}
	        		  },
	        		  'facultymarksheetreportgrid button[itemId=btnUncheckedAll]':{
	        			  click:function(obj){
	        				  var $this=this;
	        				  $this.uncheckedAllrecords();
	        			}
	        		  },
	        		 
	        		  
	        		  'facultymarksheetreportgrid button[itemId=btnSetupMarksheetJob]':{
	        			  click:function(obj){
	        				  var $this=this;
	            	    	  var grid=$this.getFacultymarksheetreportgrid();
	            	    	  var filterForm=$this.getFacultymarksheetreportfilter().getForm();
	            	    	  var consolidateFieldVal = filterForm.findField("consolidatedField").getRawValue();
	            	    	  var isConsiderProgramTransfer = filterForm.findField("isConsiderProgramTransfer").getValue();
	            	    	  filterForm.findField("isConsiderProgramTransfer").getValue();
	            	    	   if (grid.getSelectionModel().getCount() > 0) {
	            	    		   $this.showStudentMarksheet();
	            	    			var record = grid.getSelectionModel().getSelection()[0];
	            	    			var studentRecords=grid.getSelectionModel().getSelection();
	            	    			var consolidateValue;
	            	    			if(consolidateFieldVal=="No"){
	            	    				consolidateValue=false;
	            	    			}else{
	            	    				consolidateValue=true;
	            	    			}
	            	    			var allUser=[];
	            	    			for(var i=0;i<studentRecords.length;i++){
	            	    				allUser.push(studentRecords[i].data.studentId);
	            	    			}
	            	    			//if(!isNullOrEmpty($this.getFacultymarksheetreportfilter().getForm().findField('marksheetJobName').getRawValue())){
	            	    				var filterForm=$this.getMarksheetgenerationfilter().getForm();
	            	    				
	            	    				filterForm.findField('marksheetJobId').setValue(record.data.marksheetJobName);
	            	    				var marksheetFilePatternField=filterForm.findField('marksheetFilePattern');
	            	    				 marksheetFilePatternField.getStore().load({
	            	    					 callback: function(records, operation, success) {
	            	    						 for(var i in records){
	            	    							 if(records[i].data.id==record.data.marksheetFilePattern){
	            	    								 marksheetFilePatternField.setValue(records[i].data.id);
	            	    								 break;
	            	    							 }
	            	    						 }
	            	    					 }	   
	            	    				 });  
		            	    			var jobIdField=filterForm.findField('jobId');
		            	    			if(!isEmpty($this.getFacultymarksheetreportfilter().getForm().findField('marksheetJobId').getRawValue())){
		            	    				 jobIdField.setValue($this.getFacultymarksheetreportfilter().getForm().findField('marksheetJobId').getRawValue());
			            	    			 //jobIdField.disable();
		            	    			}
		            	    			var jobNameField=filterForm.findField('jobName');
			            	    			jobNameField.setValue($this.getFacultymarksheetreportfilter().getForm().findField('marksheetJobName').getRawValue());
			            	    			//jobNameField.disable();
			            	    	    var reportTemplateConfigurationIdField=filterForm.findField('reportTemplateConfigurationId');
			            	    	    var academyLocationId=$this.getCurrentAcademyLocation();
			            	    	    reportTemplateConfigurationIdField.getStore().getProxy().extraParams={
			            	    	    	academyLocationId:academyLocationId
				        				};
			            	    	    reportTemplateConfigurationIdField.getStore().load({
			            	    	    	callback:function(records){
			            	    	    		for(var i in records) {
			            	    	    			if(record.data.templateId == records[i].data.id) {
			        	        						var planLevel = filterForm.findField('evaluationLevel');
			        	        						var evalLevelNameField=filterForm.findField('evalLevelName');
			        	        						var data=records[i].data.templateType;
			        	        						planLevel.reset();
			        	        						if(!isNullOrEmpty(data)) {
			        	        							planLevel.getStore().load({
			        	        								callback:function(rec) {
			        	        									for(var i in rec) {
			        	        										if(rec[i].data.id == data) {
			        	        											planLevel.setValue(rec[i].data.id);
			        	        											planLevel.setReadOnly(true);
			        	        											var marksheetStdFilterForm=$this.getFacultymarksheetreportfilter();
			        	        											var filterFormValues=marksheetStdFilterForm.getForm().getValues();
			        	        											var sectionArray=[];
			        	        											if(!isNullOrEmpty(filterFormValues.sectionId)){
			        	        												for(var i=0;i<filterFormValues.sectionId.length;i++){
			        	        													var sectionValue=filterFormValues.sectionId[i];
			        	        													if(Ext.isObject(sectionValue)){
			        	        														sectionArray.push(sectionValue.data.sectionId);
			        	        													}else{
			        	        														sectionArray.push(sectionValue);
			        	        													}	
			        	        												}
			        	        											}
			        	        											var academyLocationId=$this.getCurrentAcademyLocation();
			        	        											evalLevelNameField.enable();
			        	        											evalLevelNameField.reset();
			        	        											evalLevelNameField.getStore().getProxy().extraParams={
			        	        												academyLocationIds:academyLocationId,
			        	        												sectionIds:sectionArray.join(),
			        	        												periodId:filterFormValues.periodId,
			        	        												batchId:filterFormValues.batchId,
			        	        												evaluationLevel:data,
			        	        												isConsiderProgramTransfer:isConsiderProgramTransfer.isConsiderProgramTransfer,
				        	        											isConsolidated:consolidateValue,
				        	        											studentIds:allUser.join(),
			        	        											};
			        	        											evalLevelNameField.getStore().load();
			        	        											
			        	        											
			        	        										}
			        	        									}
			        	        								}
			        	        							});
			        	        						} else {
			        	        							evalLevelNameField.setDisabled(true);
			        	        							planLevel.setReadOnly(false);
			        	        							evalLevelNameField.reset();
			        	        							planLevel.reset();
			        	        						}
			            	    	    				reportTemplateConfigurationIdField.setValue(record.data.templateId)
			            	    	    			}
			            	    	    		}
			            	    	    	}
			            	    	    });
			            	    	    
			            	    	    //--- added
			            	    	    var whetherFixedDateTrue = $this.getMarksheetgenerationfilter().down('[inputValue=whetherFixedDateTrue]');
			            	    	    var whetherFixedDateFalse = $this.getMarksheetgenerationfilter().down('[inputValue=whetherFixedDateFalse]');
			            	    	    if(isNullOrEmpty(record.data.whetherFixedDate) || record.data.whetherFixedDate==true){
			            	    	    	whetherFixedDateTrue.setValue(true);
			            	    	    }
			            	    	    else{
			            	    	    	whetherFixedDateFalse.setValue(true)
			            	    	    }
			            	    	    
			            	    	   var consolidatedField=filterForm.findField('consolidatedField');
			            	    	   consolidatedField.setDisabled(true);
			            	    	   if(consolidateFieldVal == "Yes"){
			            	    		   consolidatedField.getStore().load({
			            	    				callback:function(resp){
			            	    						consolidatedField.setValue(resp[0]);
			            	    				}
			            	    			});
			            	    	   }else if(consolidateFieldVal == "No"){
			            	    		   consolidatedField.getStore().load({
			            	    				callback:function(resp){
			            	    						consolidatedField.setValue(resp[1]);
			            	    				}
			            	    			});
			            	    	   }
			            	    	   if(!isEmpty($this.getFacultymarksheetreportfilter().getForm().findField('marksheetJobId').getRawValue())){
				            	    	   var courseMarksheetGrid=$this.getCoursemarksheetgrid();     
				            	    	   courseMarksheetGrid.getStore().getProxy().extraParams={
				            	    		   marksheetJobLevelId:record.data.marksheetLevelId,
					        					jobName:record.data.jobName
						        			   };
				            	    	   courseMarksheetGrid.getStore().load();
			            	    	   }
			            	    	   if(!isNullOrEmpty(record.data.publishDate)) {
			            	    		   filterForm.findField('publishDate').setValue(dateRender(record.data.publishDate));
			            	    	   }
			            	    	   if(!isNullOrEmpty(record.data.examResultDate)) {
			            	    		   filterForm.findField('resultDate').setValue(dateRender(record.data.examResultDate));
			            	    	   }
	            	    			//}
	            	    	   }else {
	       						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	       				    }       
	        			}
	        		  },
	        		 
	        		  'facultymarksheetreportgrid ':{
	        			  select:function(obj, record,rowIndex, e){
	        				 var studentGrid=this.getFacultymarksheetreportgrid();
	        				 
	        				 /**
	        		        	 * this condition is for student's can't selected with students whose marksheet already created.   
	        		        	 */
	        		        	if(obj.selected.items.length>1){
	        		        		var newLength=obj.selected.items.length-2;
	        		        		if((!obj.selected.items[newLength].data.marksheetPath && record.data.marksheetPath) ||
	        		        		    (!record.data.marksheetPath && obj.selected.items[newLength].data.marksheetPath)){
	        	                            obj.deselect(record);
	        			  	    	  showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('STUDENT_MARKSHEET_WITHOUT_MARKSHEET_CANNOT_BE_SELECTED_TOGETHER'));
	        		        	   }
	        		        	}	        				 
	        				 
	        				 if (studentGrid.getSelectionModel().getCount() > 0) {
	      				  		 var records = studentGrid.getSelectionModel().getSelection();
	      				  		 this.enableDisablePublishBtn(studentGrid,records);
	      				  		 this.enableDisableDownloadAllBtn(studentGrid,records);
	      				  		 var buttonsToolBar = studentGrid.query('toolbar')[0];
	      				  		 var deselectAllButton = buttonsToolBar.query('#btnUncheckedAll')[0];
	      				  		 deselectAllButton.enable();
	      				  		 
	      				  	 } else {
	      				  		var buttonsToolBar = studentGrid.query('toolbar')[0];
	    						var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
	    						publishButton.disable();
	    						var downloadAllButton = buttonsToolBar.query('#btnDownloadAllMarksheet')[0];
	    						downloadAllButton.disable();
	      				  	 }
	        		   },
	        		   deselect:function(obj, record, rowIndex, e){
	        			     var studentGrid=this.getFacultymarksheetreportgrid();
	      				  	 if (studentGrid.getSelectionModel().getCount() > 0) {
	      				  		 var records = studentGrid.getSelectionModel().getSelection();
	      				  		 this.enableDisablePublishBtn(studentGrid,records);
	      				  		this.enableDisableDownloadAllBtn(studentGrid,records);
	      				  	 } else {
		      				  		var buttonsToolBar = studentGrid.query('toolbar')[0];
		    						var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
		    						publishButton.disable();
		    						var downloadAllButton = buttonsToolBar.query('#btnDownloadAllMarksheet')[0];
		    						downloadAllButton.disable();
		 	        		       	var deselectAllButton = buttonsToolBar.query('#btnUncheckedAll')[0]; 
		    						deselectAllButton.disable();
		      				 }
	        			}
	        		   },
	        		   
	        		  'facultymarksheetreportgrid':{ 
	        			  render:function(grid){
		        				//this.gridRenderFunction(grid);
		        				this.doAccessControlValidation(grid, this.getFACULTY_MARKSHEET_REPORT_PERMISSION() );
		        				//this.disableMoreActionPivilegesforStudentmarksheet(grid,this.getEXAM_MARKSHEET_PERMISSION());
		        				this.disableMoreActionPivileges(grid,this.getFACULTY_MARKSHEET_REPORT_PERMISSION());
		        			},
						  beforerender: function(grid) {
							  grid.getStore().removeAll();
						  },
	        			cellclick:function(view, td, colIndex, record, event,target,pop){
	        				if(pop.target.tagName=='A'){
	        					var submitUrl= SERVERURL.MARKSHEET_DOWNLOAD_URL;
	        					var csvForm = Ext.create('Ext.form.Panel'); 
	        					var filePath = window.btoa(unescape(encodeURIComponent(record.data.marksheetPath)));
	        			    	csvForm.getForm().submit({
	        						url : submitUrl+"?filePath="+filePath,
	        						method : 'POST',
	        						target: '_blank',
	        						params :{
	        				    		access_token : Ext.Ajax.defaultHeaders.access_token
	        				    	},
	        				    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        				    	standardSubmit :true
	        			    	});
                            }
                        }
	        		  }
	        	  });
	          },
	          /**
	           * Enable disable check for publish button.
	           */
	          enableDisablePublishBtn : function(grid,records) {
	        	  var studentGrid=this.getFacultymarksheetreportgrid();
				  if (studentGrid.getSelectionModel().getCount() > 0) {
					  //studentGrid.getSelectionModel().deselectAll();
	     	    	var records = studentGrid.getSelectionModel().getSelection();
	        	  	var marksheetPublishFlag = false; 
	        	  	for(var i in records){
	     	    		if(!records[i].get('isPublishMarksheet')) {
							 if(isNullOrEmpty(records[i].get('marksheetPath'))){
								 marksheetPublishFlag = false;
								 break;
							 } else {
								 marksheetPublishFlag = true;
							 }		 
						}
	     	    	 }
	     	    	 
	     	    	if(marksheetPublishFlag){
	     	    		var buttonsToolBar = grid.query('toolbar')[0];
						var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
						publishButton.enable();
	     	    	} else {
	     	    		var buttonsToolBar = grid.query('toolbar')[0];
						var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
						publishButton.disable();
	     	    	}
  				}  
	          },
	          
	          /**
	           * Enable disable check for download all button.
	           */
	          enableDisableDownloadAllBtn : function(grid,records) {
	        	  var studentGrid=this.getFacultymarksheetreportgrid();
				  if (studentGrid.getSelectionModel().getCount() > 0) {
					  //studentGrid.getSelectionModel().deselectAll();
	     	    	var records = studentGrid.getSelectionModel().getSelection();
	        	  	var marksheetPublishFlag = false; 
	        	  	for(var i in records){
	     	    		if(!isNullOrEmpty(records[i].get('marksheetPath'))){
								 var buttonsToolBar = grid.query('toolbar')[0];
								 var downloadButton = buttonsToolBar.query('#btnDownloadAllMarksheet')[0];
								 downloadButton.enable();
							 }
	     	    	 }
	     	    	 
	     	    	/*if(marksheetPublishFlag){
	     	    		var buttonsToolBar = grid.query('toolbar')[0];
						var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
						publishButton.enable();
	     	    	} else {
	     	    		var buttonsToolBar = grid.query('toolbar')[0];
						var publishButton = buttonsToolBar.query('#btnPublishMarksheet')[0];
						publishButton.disable();
	     	    	}*/
  				}  
	          },
	          
	          
	          
	          /**
	           * Unchecked All selected records button.
	           */
	          uncheckedAllrecords : function() {
	        	  var studentGrid=this.getFacultymarksheetreportgrid();
				  if (studentGrid.getSelectionModel().getCount() > 0) {
					  studentGrid.getSelectionModel().deselectAll();
  				}  
	          },
	          
	          
	          /**
	           * Open window for marksheet generation.
	           */
	          openMarksheetGenerationWindow:function(){
	        	  var $this=this;
     	    	 var formWindow = $this.getMarksheetgenerationwin();
     	         if (!formWindow) {
     	             Ext.widget('marksheetgenerationwin');
     	             formWindow = $this.getMarksheetgenerationwin();
     	         }
     	         formWindow.show();
     	         
     	         var winForm=$this.getMarksheetGenerationWinForm().getForm();
     	         var idField=winForm.findField('id').getValue();
     	         var academyLocationId=$this.getCurrentAcademyLocation();
     	         /**
     	          * At the time of create, status must be pending and load store for template on bases of id field is their or not.
     	          */
     	        var statusField=winForm.findField('jobStatus');
     	         if(isNullOrEmpty(idField)){
     	        	statusField.getStore().load({
     	        		callback:function(rec){
     	        			statusField.setValue(rec[0].data.id);
     	        		}
     	        	});
     	        	
     	        var reportTemplateConfigurationIdField=winForm.findField('reportTemplateConfigurationId');	
     	         reportTemplateConfigurationIdField.getStore().getProxy().extraParams={
     	        		academyLocationId:academyLocationId
    				};
     	         reportTemplateConfigurationIdField.getStore().load();
     	         }
     	       },
     	       /**
     	        * show Marksheet student tab 
     	        */
     	      showStudentMarksheet: function() {
					var me = this;
					var contentpanel = me.getContentPanel();
					var examinationStructure = Ext.widget('marksheetstudentstructure');
					var tabName = getExaminationTranslation('SETUP_MARKSHEET_JOB');
					 /**
	              	   * This is to remove tab from content panel and open same tab again 
	              	   */
	              	  var getcontroller=this.getController('menu.CoreERPNavigationController');
	              	  var getTab=getcontroller.getTab(tabName);
	              	   if(getTab!=null){
	              		 contentpanel.remove(getTab, true);
	              	   }
					openTab(contentpanel, tabName, examinationStructure);
				},
				
				
			   getDocumentController : function() {
				   var this$ = this;
				   return this$.getController('Academia.controller.document.DocumentController');
			   },
			   
			   /**
     	        * Download all Marksheet generation
     	        */
			   downloadAllMarksheetZip:function(){
				   var $this=this;
				   var studentGrid=$this.getFacultymarksheetreportgrid();
				   if (studentGrid.getSelectionModel().getCount() > 0) {
					   //studentGrid.getSelectionModel().deselectAll();
					   var records = studentGrid.getSelectionModel().getSelection();
					   var saveModel=[];  

					   var marksheetZipName = records[0].get('marksheetJobName')+'_'+records[0].get('marksheetLevelName');
					   for(var i in records){
						   if(!isNullOrEmpty(records[i].get('marksheetPath'))) {
							   var filePath = window.btoa(unescape(encodeURIComponent(records[i].get('marksheetPath'))));
							   saveModel.push(filePath);
						   }
					   }
					   showConfirmMessage(getExaminationTranslation('MARKSHEET'),getExaminationTranslation('DOWNLOAD_ALL_MARKSHEET_MSG'),function(btn, text) {
						   if (btn == 'yes') {
							   var directoryType = CONSTANTS.DIRECTORY_TYPE_MARKSHEET;
							   $this.getDocumentController().downloadMultipleDocumentFile(saveModel, marksheetZipName, directoryType);
						   }});
				   }else {
					   $this.hideWindowMask();
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }
			   },
			   
	 //***********************Disable MoreAction Privileges*********************************************************		   
			   disableMoreActionPivileges: function(gridReference,permissionsMap) {
				   var associatedAcadLocationIds = new Array();
				   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				   buttonsToolBar = gridReference.query('toolbar')[0];
				   /*var splitbuttons = buttonsToolBar.query('splitbutton')[0];
			    	//splitbuttons.setVisible(false);
			    	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
						menuItems.setVisible(false);
			    	});*/
				   Ext.each(permissionList, function(privilege) {

					   if (privilege === 'DOWNLOADMARKSHEETS') {
						   var button = buttonsToolBar.query('#btnDownloadAllMarksheet')[0];
						   if(!isNullOrEmpty(button)){
							   button.setVisible(true); 
						   }        		
					   }
					   var button = buttonsToolBar.query('#btnUncheckedAll')[0];
					   
					   button.setVisible(true);			    	
				   });
			   },	
			  
});
