/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.controller.examinationcenters.reports.faculty.FacultyPendingMarksController',{
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['common.AssignedProgramStore','common.BatchesByProgramId','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'
	          ,'attendance.SectionAndFacultyByPeriodID','examinationcenters.reports.ExaminationReportCourseStore','examinationcenters.reports.PendingRemarksStore',
	          'examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId','examinationcenters.reports.PendingMarksStore','common.AcademicTermStore','common.IntakeYearStore',
	          'attendance.VariantMappedToPlan','examCenter.AssignSequence.EvaluationType','examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo',
	          'examinationcenters.reports.MarksheetJobIdReportCombo','examinationcenters.marksheet.MarksheetLevelsCombo','examinationcenters.reports.PendingMarksRemarksStudentListStore',
	          'examinationcenters.reports.PendingMarksRemarksCourseStore','facilitiesresources.resourcebooking.CourseVariantsListStore','examinationcenters.reports.ExaminationPlanStore',
	          'common.CurrentBatchStore','common.AcademicTermStoreForIntakeYearId','examinationcenters.reports.ExaminationReportProgramStore'],

	          views : ['examinationcenters.reports.faculty.FacultyPendingMarkentryStructure','examinationcenters.reports.faculty.FacultyPendingRemarksGrid',
	                   'examinationcenters.reports.faculty.FacultyPendingMarksFilter','examinationcenters.reports.faculty.PendingFacultyMarksGrid'],
	                   config:{
	                	   FACULTY_PENDING_MARKS_REMARKS_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PENDING_MARKS_REMARKS_PRIVILEGES')
	                   },    
	                   refs : [{
	                	   ref: 'contentPanel',
	                	   selector: 'contentPanel'
	                   },{
	                	   ref: 'facultypendingmarkentrystructure',
	                	   selector: 'facultypendingmarkentrystructure'
	                   },{
	                	   ref: 'facultypendingmarksfilter',
	                	   selector: 'facultypendingmarksfilter'
	                   },{
	                	   ref: 'pendingfacultymarksgrid',
	                	   selector: 'pendingfacultymarksgrid'
	                   },{
	                	   ref: 'facultypendingremarksgrid',
	                	   selector: 'facultypendingremarksgrid'
	                   }],
	                   init : function(application) {
	                	   this.control({
	                		   'facultypendingmarksfilter':{
	                			   render : function(obj){
	                				   var $this = this;
	                				   var form = obj;
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var program = form.down('#programItemId');
	                				   var batch = form.down('#batchItemId');
	                				   var periodId = form.down('#periodItemId');
	                				   var courseItemId = form.down('#courseItemId');
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var marksheetJobId = form.down('#marksheetJobNameId');
	                				   var studentList = form.down("#admissionItemId");
	                				   var radioButton = form.down('#radiogroupItemId');
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var evaluationPlanItemId = form.down('#evaluationPlanItemId');
	                				   var studentStatus = form.down('#studentStatusId');
	                				   var academicTerm = form.down('#academicTerm');
	                				   var evaluationLevelItemId = form.down('#evaluationLevelId');
	                				   evaluationLevelItemId.getStore().getProxy().extraParams={
	                				   };
	                				   evaluationLevelItemId.getStore().load();
	                				   /*V2D-17057*/
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   
	                				   academicTerm.getStore().on('beforeload',function(){
	                					   try{
		                					   academicTerm.getStore().getProxy().extraParams={
	    	                					   academyLocationIds:academyLocationIds
	    	                				   };
	                					   }
	                					   catch(e){
	                						   return false;
	                					   }
	                				   });
	                				   
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   program.reset();
	                				   marksheetJobId.reset();
	                				   program.getStore().getProxy().extraParams={
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                					   whetherMarksheet:true,
	                					   academyLocationIds:academyLocationIds
	                				   };
	                				   
	                				   courseItemId.getStore().getProxy().extraParams={
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                					   academyLocationId: academyLocationIds,
	                					   whetherMarksheet:true
	                				   };
	                				   courseItemId.getStore().load();
	                				   
	                				   marksheetJobId.getStore().getProxy().extraParams={
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                					   academyLocationIds: academyLocationIds
	                				   };
	                				   marksheetJobId.getStore().load();
	                				   
	                				   var studentListStore=studentList.getStore();
	                				   studentListStore.getProxy().extraParams={
	                					   acultyId: $this.getCurrentlyLoggedInUser().id,
	                					   academyLocationIds:academyLocationIds,
	                					   isMarkEntry:isMarkEntry,
	                				   };
	                				   studentListStore.load();

	                				  
	                				   program.getStore().load({
	                					   callback:function(record) {
	                						   
	                						   academicTerm.reset();
	    	                				   academicTerm.getStore().getProxy().extraParams={
	    	                					   academyLocationIds:academyLocationIds,
	    	                				   };
	    	                				   academicTerm.getStore().load();
	                						   
	                						   if(record.length==1) {
	                							   program.setValue(record[0].data.id);
	                							   batch.setDisabled(false);
	                							   batch.reset();
	                							   batch.getStore().getProxy().extraParams={
	                								   programId: record[0].data.id
	                							   };
	        	                				   studentList.reset();
	        	                				   var studentListStore=studentList.getStore();
	        	                				   studentListStore.getProxy().extraParams={
	        	                					   academyLocationIds:academyLocationIds,
	        	                					   programId:program.getValue(),
	        	                					   batchId:batch.getValue(),
	        	                					   periodId:periodId.getValue(),
	        	                					   isMarkEntry:isMarkEntry,
	        	                					   
	        	                				   };
	        	                				   studentListStore.load();
	                							   batch.getStore().load({
	                								   callback:function(records) {
	                									   if(records.length==1) {
	                										   batch.setValue(records[0].data.id);
	                										   periodId.setDisabled(false);
	                										   periodId.reset();
	                										   periodId.getStore().getProxy().extraParams={
	        	                								   id: records[0].data.id
	        	                							   };
	                										   studentList.reset();
	        	        	                				   var studentListStore=studentList.getStore();
	        	        	                				   studentListStore.getProxy().extraParams={
	        	        	                					   academyLocationIds:academyLocationIds,
	        	        	                					   programId:record[0].data.id,
	        	        	                					   batchId:batch.getValue(),
	        	        	                					   periodId:periodId.getValue(),
	        	        	                					   isMarkEntry:isMarkEntry,
	        	        	                				   };
	        	        	                				   studentListStore.load();
	                										   periodId.getStore().load({
	        	                								   callback:function(records) {
	        	                									   if(records.length==1) {
	        	                										   periodId.setValue(records[0].data.id);
	        	                										   studentList.reset();
	        	        	        	                				   var studentListStore=studentList.getStore();
	        	        	        	                				   studentListStore.getProxy().extraParams={
	        	        	        	                					   academyLocationIds:academyLocationIds,
	        	        	        	                					   programId:record[0].data.id,
	        	        	        	                					   batchId:batch.getValue(),
	        	        	        	                					   periodId:periodId.getValue(),
	        	        	        	                					   isMarkEntry:isMarkEntry
	        	        	        	                				   };
	        	        	        	                				   evaluationPlanItemId.reset();
	        	        	        	                				   evaluationPlanItemId.getStore().getProxy().extraParams={
	        	        	        	                					   academyLocationIds:academyLocationIds,
	        	        	        	                					   programId:record[0].data.id,
	        	        	        	                					   batchId:batch.getValue(),
	        	        	        	                					   periodId:records[0].data.id,
	        	        	        	                					   whetherMarksheet:true,
	        	        	        	                					   evaluationType:evaluationType.getValue(),
	        	        	        	                					   facultyId: $this.getCurrentlyLoggedInUser().id
	        	        	        	                				   };
	        	        	        	                				   evaluationPlanItemId.getStore().load();
	        	        	        	                				   
	        	                									   }
	        	                									   else{
	        	                										   evaluationPlanItemId.getStore().getProxy().extraParams={
	        	        	        	                					   academyLocationIds:academyLocationIds,
	        	        	        	                					   whetherMarksheet:true,
	        	        	        	                					   evaluationType:evaluationType.getValue(),
	        	        	        	                					   programId: program.getValue(),
	        	        	        	                					   facultyId: $this.getCurrentlyLoggedInUser().id
	        	        	        	                				   };
	        	        	        	                				   evaluationPlanItemId.getStore().load();
	        	                									   }
	        	                								   }
	        	                							   });
	                									   }
	                									   else{
	                										   evaluationPlanItemId.getStore().getProxy().extraParams={
	        	        	                					   academyLocationIds:academyLocationIds,
	        	        	                					   whetherMarksheet:true,
	        	        	                					   evaluationType:evaluationType.getValue(),
	        	        	                					   programId: program.getValue(),
	        	        	                					   facultyId: $this.getCurrentlyLoggedInUser().id
	        	        	                				   };
	        	        	                				   evaluationPlanItemId.getStore().load();
	                									   }
	                								   }
	                							   });
	                						   }else{
	                							   evaluationPlanItemId.getStore().getProxy().extraParams={
	        	                					   academyLocationIds:academyLocationIds,
	        	                					   whetherMarksheet:true,
	        	                					   evaluationType:evaluationType.getValue(),
	        	                					   facultyId: $this.getCurrentlyLoggedInUser().id
	        	                				   };
	        	                				   evaluationPlanItemId.getStore().load();
	                						   }
	                					   }
	                				   });
	                				   
	                				   evaluationType.getStore().load({
	                					   callback:function(record){
	                						   evaluationType.setValue(record[0].data.id);
	                					   }
	                				   });
	                				   
	                				   setTimeout(function(){
	                					   if(wheatherSchool) {
		                					   form.down('#academicTerm').setVisible(false);
		                					   periodId.setVisible(false);
		                					   $this.setAllowBlank(program,false);
		                					   $this.setAllowBlank(form.down("#academicTerm"),true);
		                				   } else{
		                					   form.down('#academicTerm').setVisible(true);
		                					   periodId.setVisible(true);
		                					   $this.setAllowBlank(program,true);
		                					   $this.setAllowBlank(form.down("#academicTerm"),false);
		                				   }
	                				   },300);
	                			   }
	                		   },
	                		   'facultypendingmarksfilter radiogroup[itemId=radiogroupItemId]':{
	                			   change:function(obj) {
	                				   var $this=this;
	                				   var marksGrid = $this.getPendingfacultymarksgrid();
	                				   var remarksGrid = $this.getFacultypendingremarksgrid();
	                				   var frm = $this.getFacultypendingmarksfilter().getForm();
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var radioButton = frm.findField('radiogroupId');
	                				   var form = $this.getFacultypendingmarksfilter();
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var courseVariant = form.down('#courseVariantItemId');
	                				   var course = form.down('#courseItemId');
	                				   var evalPlanLevelItemId = form.down('#evalPlanLevelItemId');
	                				   var studentList = form.down('#admissionItemId');
	                				   var studentStatus = form.down('#studentStatusId');
	                				   studentStatus.reset();
	                				   studentList.reset();
	                				   var evaluationLevelIdField = form.down('#evaluationLevelId');
                					   evaluationLevelIdField.clearValue();
                					   evaluationLevelIdField.setReadOnly(false);
	                				   var evalPlanLevelNameIdField = form.down('#evalPlanLevelNameItemId');
	                				   evalPlanLevelNameIdField.clearValue();
	                				   evalPlanLevelNameIdField.setDisabled(true);
	                				   $this.pendingMarkRemarkFacultyFormReset(frm);
	                				   if(radioButton.getChecked()[0].getGroupValue()){
	                					   $this.getContentPanel().getActiveTab().scrollBy(0,1);
                						   $this.getContentPanel().getActiveTab().scrollBy(0,-1);
	                					   remarksGrid.setVisible(false);
	                					   $this.resetGridSetting(marksGrid);
	                					   $this.resetPageSetting(marksGrid.getStore(), marksGrid);
	                					   marksGrid.setVisible(true);
	                				   }else{
	                					   marksGrid.setVisible(false);
	                					   $this.resetGridSetting(remarksGrid);
	                					   $this.resetPageSetting(remarksGrid.getStore(), remarksGrid);
	                					   remarksGrid.setVisible(true);
	                				   }
	                			   }
	                		   },

	                        	  'facultypendingmarksfilter combo[itemId=admissionItemId]':{
		                        	  select:function(obj,record){
		                        	   $this=this;
	 	                			   var form = obj.up('form');
		                        	  var id = record[0].get("id");
		                        	  var form = $this.getFacultypendingmarksfilter();
		                        	  var studentList = form.down('#admissionItemId');
		                        	  var studentStatus = form.down('#studentStatusId');
		                        	  var courseVariantId = form.down('#courseVariantItemId').getValue();
		                        	  var radioButton = form.down('#radiogroupItemId');
		                        	  var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
		                        	  var studentListStore=studentList.getStore();
		                        	  var activeStatus = studentListStore.data.items[0].data.activeStatus;
		                        	  var selectedRecord = obj.findRecord(obj.valueField || obj.displayField, obj.getValue());
		           				   		{
		           					     studentStatus.setValue(selectedRecord.data.activeStatus);
		           				         } 
		                        	  }
		                        	  },
	                		   'facultypendingmarksfilter customcombobox[itemId=programItemId]':{
	                			   select : function(obj, record){
	                				   var $this = this;
	                				   var data = record[0].data.id;
	                				   var form = obj.up('form');
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var courseVariant = form.down('#courseVariantItemId');
	                				   var period = form.down('#periodItemId');
	                				   var section = form.down('#sectionItemId');
	                				   var course = form.down('#courseItemId');
	                				   var evalPlanLevelItemId = form.down('#evalPlanLevelItemId');
	                				   var batch = form.down('#batchItemId');
	                				   var plan = form.down('#evaluationPlanItemId');
	                				   var section = form.down('#sectionItemId');
	                				   var studentList = form.down("#admissionItemId");
	                				   var programId = form.down("#programItemId");
	                				   var radioButton = form.down('#radiogroupItemId');
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var studentStatus = form.down('#studentStatusId');
	                				   var academicTerm = form.down('#academicTerm');
	                				   var intakeYear = form.down('#intakeYear');
	                				   
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   courseVariant.reset();
	                				   period.reset();
	                				   section.reset();
	                				   course.reset();
	                				   courseVariant.setDisabled(true);
	                				   period.setDisabled(true);
	                				   section.setDisabled(true);
	                				  
	                				   batch.setDisabled(false);
	                				   batch.reset();
	                				   batch.getStore().getProxy().extraParams={
	                					   	 programId: data
	                				   };
	                				   batch.getStore().load({
	                					   callback:function(records) {
	                						   if(records.length==1) {
	                							   batch.setValue(records[0].data.id);
	                							   period.setDisabled(false);
	                							   period.reset();
	                							   period.getStore().getProxy().extraParams={
	                								   id: records[0].data.id
	                							   };
        										   period.getStore().load({
	                								   callback:function(records) {
	                									   if(records.length==1) {
	                										   period.setValue(records[0].data.id);
	                										   section.setDisabled(false);
	                		                				   section.reset();
	                		                				   section.getStore().getProxy().extraParams={
	                		                					   periodId: records[0].data.id
	                		                				   };
	                		                				   section.getStore().load();
	                									   }
	                								   }
	                							   });
	                						   }
	                					   }
	                				   });
	                				   var courseStore=course.getStore();
	                				   courseStore.getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   programId:data,
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                				   };
	                				   courseStore.load();
	                				   plan.setDisabled(false);
	                				   plan.reset();
	                				   plan.getStore().getProxy().extraParams={
	                					   programId:data,
	                					   evaluationType: evaluationType.getValue(),
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                					   whetherMarksheet:true,
	                				   };
	                				   plan.getStore().load();
	                				   
	                				   studentList.reset();
	                				   var studentListStore=studentList.getStore();
	                				  
	                				   studentListStore.getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   programId:data,
	                					   isMarkEntry:isMarkEntry,
	                					   intakeYeadId:intakeYear.getValue(),
	                					   academicTermId:academicTerm.getValue(),
	                					   
	                				   };
	                				   studentListStore.load();
		                			   
	                			   }
	                		   },
	                		   'facultypendingmarksfilter customcombobox[itemId=batchItemId]':{
	                			   select : function(obj, record){
	                				   var $this = this;
	                				   var form = obj.up('form');
	                				   var data = 	record[0].data.id;                				  
	                				   var programItemId = form.down('#programItemId');
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var courseVariant = form.down('#courseVariantItemId');
	                				   var period = form.down('#periodItemId');
	                				   var section = form.down('#sectionItemId');
	                				   var course = form.down('#courseItemId');
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var batch = form.down('#batchItemId');
	                				   var radioButton = form.getForm().findField('radiogroupId');
	                				   var studentList = form.down("#admissionItemId");
	                				   var academicTerm = form.down('#academicTerm');
	                				   var intakeYear = form.down('#intakeYear');
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   
	                				   period.reset();
	                				   period.setDisabled(false);
	                				   period.getStore().getProxy().extraParams={
	                					   id:data
	                				   };
	                				   period.getStore().load({
	                					   callback:function(record) {
	                						   if(record.length>0) {
		    	                				   section.setDisabled(false);
		    	                				   section.enable();
		    	                				   section.reset();
		    	                				   var sectionStore = section.getStore();
			                					   if(radioButton.getChecked()[0].getGroupValue()){
			                						   sectionStore.getProxy().api.read=SERVERURL.FIND_SECTIONS_FACULTY_BY_PERIOD_ID
			                					   }else{
			                						   if(evaluationType.getValue()=='ACADEMICS'){
			                							   sectionStore.getProxy().api.read=SERVERURL.FIND_SECTIONS_FACULTY_BY_PERIOD_ID
			                						   }else{
			                							   sectionStore.getProxy().api.read=SERVERURL.FIND_REMARK_SECTION_BY_FACULTY_AND_PERIODID;
			                						   }
			                					   }
			                					   sectionStore.getProxy().extraParams={
		    	                					   periodId: record[0].data.id,
		    	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
		    	                				   };
			                					   sectionStore.load();
	                					   	    }
	                					   }
	                				   });
	                				 
	                				   studentList.reset();
	                				   var studentListStore=studentList.getStore();
	                				  
	                				   studentListStore.getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   programId:programItemId.getValue(),
	                					   batchId:data,
	                					   isMarkEntry:isMarkEntry,
	                					   intakeYeadId:intakeYear.getValue(),
	                					   academicTermId:academicTerm.getValue(),
	                					   
	                				   };
	                				   studentListStore.load();
	                				   courseVariant.reset();
	                				   section.reset();
	                				   course.reset();
	                				   courseVariant.setDisabled(true);
	                				   section.setDisabled(true);
	                			   }
	                		   },
	                		   'facultypendingmarksfilter customcombobox[itemId=courseItemId]':{
	                			   select : function(obj, record){
	                				   var $this = this;
	                				   var data = record[0].data.id;
	                				   var form = obj.up('form');
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var courseVariant = form.down('#courseVariantItemId');
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var evalPlanLevelItemId = form.down('#evalPlanLevelItemId');
	                				   var evaluationPlan = form.down('#evaluationPlanItemId');
	                				   var programItemId = form.down('#programItemId');
	                				   var batchItemId = form.down('#batchItemId');
	                				   var studentList = form.down("#admissionItemId");
	                				   var academicTerm = form.down('#academicTerm');
	                				   var intakeYear = form.down('#intakeYear');
	                				   var radioButton = form.getForm().findField('radiogroupId');
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   

	                				   courseVariant.setDisabled(false);
	                				   courseVariant.reset();
	                				   courseVariant.getStore().getProxy().extraParams={
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                					   academyLocationId: academyLocationIds,
	                					   programId : programItemId.getValue(),
	                					   batchId :batchItemId.getValue(),
	                					   courseId:data,
	                					   evaluationPlanId:evaluationPlan.getValue()
	                				   };
	                				   courseVariant.getStore().load();
	                				   
	                				   studentList.reset();
	                				   var studentListStore=studentList.getStore();
	                				  
	                				   studentListStore.getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   programId : programItemId.getValue(),
	                					   batchId :batchItemId.getValue(),
	                					   courseId:data,
	                					   isMarkEntry:isMarkEntry,
	                					   intakeYeadId:intakeYear.getValue(),
	                					   academicTermId:academicTerm.getValue(),
	                					   
	                				   };
	                				   studentListStore.load();
	                				  
	                			   }
	                		   },

	                		   'facultypendingmarksfilter customcombobox[itemId=sectionItemId]':{
	                			   select : function(obj, record){
	                				   var $this = this;
	                				   var data = record[0].data.sectionId;
	                				   var form = obj.up('form');
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var radioButton = form.getForm().findField('radiogroupId');

	                				   var evalPlanLevelItemId = form.down('#evalPlanLevelItemId');
	                				   var programItemId = form.down('#programItemId');
	                				   var batchItemId = form.down('#batchItemId');
	                				   var period = form.down('#periodItemId');

   	                				   var courseVariant = form.down('#courseVariantItemId');
	                				   var course = form.down('#courseItemId');
	                				   var planStore;
	                				 
	                			   }
	                		   },

	                		   'facultypendingmarksfilter customcombobox[itemId=courseVariantItemId]':{
	                			   select : function(obj, record){
	                				   var $this = this;
	                				   var data = record[0].data.id;
	                				   var form = obj.up('form');
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var courseVariant = form.down('#courseVariantItemId');
	                				   var evalPlanLevelItemId = form.down('#evalPlanLevelItemId');
	                				   var programItemId = form.down('#programItemId');
	                				   var batchItemId = form.down('#batchItemId');
	                				   var section = form.down('#sectionItemId');
	                				   var course = form.down('#courseItemId');
	                				   var radioButton = form.getForm().findField('radiogroupId');
	                				   var studentList = form.down("#admissionItemId");
	                				   var academicTerm = form.down('#academicTerm');
	                				   var intakeYear = form.down('#intakeYear');
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   studentList.reset();
	                				   var studentListStore=studentList.getStore();
	                				   studentListStore.getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   programId : programItemId.getValue(),
	                					   batchId :batchItemId.getValue(),
	                					   courseId:course.getValue(),
	                					   courseVariantId:data,
	                					   isMarkEntry:isMarkEntry,
	                					   intakeYeadId:intakeYear.getValue(),
	                					   academicTermId:academicTerm.getValue(),
	                					   
	                				   };
	                				   studentListStore.load();
	                			   }
	                		   },

	                		   'facultypendingmarksfilter customcombobox[itemId=periodItemId]':{
	                			   select : function(obj, record){
	                				   var $this = this;
	                				   var data = record[0].data.id;
	                				   var form = obj.up('form');
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var marksheetJobId = form.down('#marksheetJobNameId');
	                				   var section = form.down('#sectionItemId');
	                				   var programItemId = form.down('#programItemId');
	                				   var courseVariant = form.down('#courseVariantItemId');
	                				   var evalPlanLevelItemId = form.down('#evalPlanLevelItemId');
	                				   var period = form.down('#periodItemId');
	                				   var course = form.down('#courseItemId');
	                				   var evaluationType = form.down('#evaluationTypeItemId');
	                				   var batchItemId = form.down('#batchItemId');
	                				   var radioButton = form.getForm().findField('radiogroupId');
	                				   var studentList = form.down("#admissionItemId");
	                				   var academicTerm = form.down('#academicTerm');
	                				   var intakeYear = form.down('#intakeYear');
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   var evalPlanLevelNameItemIdField = form.down('#evalPlanLevelNameItemId');
	                				   var evaluationPlanField = form.down('#evaluationPlanItemId');

	                				   section.setDisabled(false);
	                				   section.reset();
	                				   section.getStore().getProxy().extraParams={
	                					   periodId: data,
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                				   };
	                				   section.getStore().load();
	                				   
	                				   courseVariant.reset();
	                				   //section.reset();
	                				   course.reset();
	                				   courseVariant.setDisabled(true);
	                				   
	                				   var studentList = form.down("#admissionItemId");
	                				   studentList.reset();
	                				   var studentListStore=studentList.getStore();
	                				   studentListStore.getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   marksheetJobId:marksheetJobId.getValue(),
	                					   intakeYeadId:intakeYear.getValue(),
	                					   academicTermId:academicTerm.getValue(),
	                					   programId:programItemId.getValue(),
	                					   batchId:batchItemId.getValue(),
	                					   periodId:data,
	                					   isMarkEntry:isMarkEntry,
	                				   };
	                				   studentListStore.load();
	                				   
	                				   evalPlanLevelNameItemIdField.enable();
	                				   evalPlanLevelNameItemIdField.getStore().getProxy().extraParams={
	                					   evaluationPlanId:evaluationPlanField.getValue(),
	                					   whetherRemark: !isMarkEntry,
	                					   levelName : evalPlanLevelNameItemIdField.getValue(),
	                					   periodId: data,
		                			   };
	                				   evalPlanLevelNameItemIdField.getStore().load();
	                			   }
	                		   },
	                		   
	                		   'facultypendingmarksfilter customcombobox[itemId=evaluationTypeItemId]':{
	                			   select : function(obj, record){
	                				   var $this = this;
	                				   var portalId = $this.getCurrentLoggedPortalId();
  								 	   var facultyId = $this.getCurrentlyLoggedInUser();
	                				   var data = record[0].data.id;
	                				   var form = obj.up('form');
	                				   var courseItemId = form.down('#courseItemId');
	                				   var programItemId = form.down('#programItemId');
	                				   var batchItemId = form.down('#batchItemId');
	                				   var period = form.down('#periodItemId');
	                				   var courseVariantItemId = form.down('#courseVariantItemId');
	                				   var evaluationPlanItemId = form.down('#evaluationPlanItemId');
	                				   var marksheetJob = form.down('#marksheetJobNameId');
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var intakeYear = form.down('#intakeYear');
	                				   var programStore=programItemId.getStore();
	                				   programStore.getProxy().api.read=SERVERURL.EXAM_REPORT_COMMON_FILTER_URL+"?filterType=PROGRAM";
	                				   programItemId.reset();
	                				   batchItemId.reset();
                					   period.reset();
	                				   if(data=="ACADEMICS"){
	                					   courseItemId.show();
		                				   courseVariantItemId.show();
    	                				   if(isNullOrEmpty(marksheetJob.getValue())){
    	                					   programItemId.getStore().getProxy().extraParams = {
    	                						   facultyId: $this.getCurrentlyLoggedInUser().id,
    	                						   evaluationType:data,
    	                						   whetherMarksheet:true,
    	                						   academyLocationIds: academyLocationIds,
    	                						   intakeYearId:intakeYear.getValue()
    											};
    	                					   programItemId.getStore().load();
    	                				   }
	                				   } else{
	                					   var radioButton = form.getForm().findField('radiogroupId')
	                					   if(!radioButton.getChecked()[0].getGroupValue()){
	                						   programStore.getProxy().api.read=SERVERURL.EVALUATION_PROGRAM_BY_EVALUATION_PLAN_ID;
	                						   var arr = [];
	                						   arr.push($this.getCurrentAcademyLocation());
	         	             				   if(portalId == 2) {
	         	             					   	programStore.getProxy().extraParams = {
	         	  	             						academyLocationIds:arr.join(),
	         	  	             						facultyId: facultyId.id,
	         	             						};
	         	             				   }else{
	         	             					   programStore.getProxy().extraParams = {
	         	             						 academyLocationIds:arr.join()
	                						      };

	         	             				   }
	         	             				   programItemId.getStore().load();
	                					   }else{
	                						   if(isNullOrEmpty(marksheetJob.getValue())){
	    	                					   
	    	                					   programStore.getProxy().extraParams = {
	    	                						   facultyId: $this.getCurrentlyLoggedInUser().id,
	    	                						   evaluationType:data,
	    	                						   whetherMarksheet:true,
	    	                						   academyLocationIds: academyLocationIds,
	    	                						   intakeYearId:intakeYear.getValue()
	    											};
	    	                					   programItemId.getStore().load();
	    	                				   } 
	                					   }
	                					   courseItemId.hide();
		                				   courseVariantItemId.hide();
	                				   }
	                			   }
	                		   },
	                		   
	                		   'facultypendingmarksfilter button[itemId=resetBtn]':{
	                			   click : function(obj){
	                				   var $this = this;
	                				   var form = obj.up('form').getForm();
	                				   form.reset();
	                				   $this.pendingMarkRemarkFacultyFormReset(form);
	                				   var portalId = $this.getCurrentLoggedPortalId();
  								 	   var facultyId = $this.getCurrentlyLoggedInUser();
	                				   var academyLocationIds = $this.getCurrentAcademyLocation();
	                				   var student= form.findField('admissionItemId');
	                				   var program = form.findField('programId');
	                				   var course=form.findField('courseId');
	                				   var studentStatus =form.findField('studentStatusId');
	                				   course.reset();
	                				   var courseStore = course.getStore();
	                				   courseStore.getProxy().extraParams={
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                					   academyLocationId: academyLocationIds,
	                					   whetherMarksheet:true
	                				   };
	                				   courseStore.load();
	                				   form.findField('batchId').setDisabled(true);
	                				   form.findField('courseVariantId').setDisabled(true);
	                				   form.findField('courseVariantId').setVisible(true);
	                				   form.findField('periodId').setDisabled(true);
	                				   form.findField('sectionId').setDisabled(true);
	                				   form.findField('programId').setReadOnly(false);
	                				   var evaluationType=form.findField('evaluationType');
	                				   var marksheetJobId = form.findField('marksheetJobLevel');
                					   marksheetJobId.setDisabled(true);
                					   form.findField('courseId').setVisible(true);
                					   var evaluationLevelIdField = form.findField('evaluationLevel');
                					   evaluationLevelIdField.clearValue();
                					   evaluationLevelIdField.setReadOnly(false);
                					   
                					   var marksheetJobId = form.findField('marksheetJob');
                					   marksheetJobId.getStore().getProxy().extraParams={
	                					   facultyId: $this.getCurrentlyLoggedInUser().id,
	                				   };

	                				   marksheetJobId.getStore().load();
	                				   evaluationType.getStore().load({
	                					   callback:function(record){
	                						   evaluationType.setValue(record[0].data.id);
	                						  
	                						   var programItemId=form.findField('programId');
	                						   var programStore=programItemId.getStore();
	                    					   programStore.getProxy().api.read=SERVERURL.EXAM_REPORT_COMMON_FILTER_URL+"?filterType=PROGRAM";
	                    					   programItemId.reset();
	                    					   programStore.getProxy().extraParams = {
	                    						   facultyId: $this.getCurrentlyLoggedInUser().id,
	                    						   evaluationType:record[0].data.id,
	                    						   whetherMarksheet:true,
	                    						   academyLocationIds: academyLocationIds,
	                    					   };
	                    					   programItemId.getStore().load();
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'facultypendingmarksfilter button[itemId=searchBtn]':{
	                			   click : function(obj){
	                				   var $this = this;
	                				   var form = obj.up('form');
	                				   $this.loadPendingMarksEntry(form);
	                			   }
	                		   },
	                		   
	                		   'facultypendingmarksfilter customcombobox#intakeYear' : {
	                			   select : function(obj, record) {
	                				   var $this = this;
	                				   var id = record[0].get("id");
	                				   var form = $this.getFacultypendingmarksfilter();
	                				   var program = form.down('#programItemId');
	                				   var batch = form.down('#batchItemId');
	                				   var period = form.down('#periodItemId');
	                				   var assesmentType = form.down('#evaluationTypeItemId');
	                				   var marksheetJob = form.down('#marksheetJobNameId');
	                				   var academicTerm = form.down('#academicTerm');
	                				   var intakeYear = form.down('#intakeYear');
	                				   var studentStatus = form.down('#studentStatusId');
	                				   var academyLocationIds = this.getCurrentAcademyLocation();
	                				   if(assesmentType.lastValue == "OTHER")
	                					   {
	                					   program.getStore().getProxy().extraParams = {
	                						   facultyId: $this.getCurrentlyLoggedInUser().id,
	                						   academyLocationIds: academyLocationIds,
	                						   evaluationType:assesmentType.getValue(),
	                						   whetherMarksheet: true,
	                						   intakeYearId:intakeYear.getValue()
											};
	                					   program.getStore().load();
	                					   }
	                				   else{  if(isNullOrEmpty(marksheetJob.getValue())){
	                					   program.reset();
	                					   program.getStore().getProxy().extraParams = {
	                						   facultyId: $this.getCurrentlyLoggedInUser().id,
	                						   academyLocationIds: academyLocationIds,
	                						   evaluationType:assesmentType.getValue(),
	                						   whetherMarksheet: true,
	                						   intakeYearId:intakeYear.getValue()
											};
	                					   program.getStore().load();
	                					   batch.reset();
		                				   period.reset();
	                				   }
	                				   }
	                				   var studentList = form.down("#admissionItemId");
	                				   var radioButton = form.down('#radiogroupItemId');
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   studentList.reset();
	                				   var studentListStore=studentList.getStore();
	                				   studentListStore.getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   marksheetJobId:marksheetJob.getValue(),
	                					   intakeYeadId:id,
	                					   isMarkEntry:isMarkEntry,
	                					  
	                				   };
	                				   studentListStore.load();
	                				   
	                				   academicTerm.reset();
	                				   academicTerm.getStore().getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   intakeYearId:id,
	                				   };
	                				   academicTerm.getStore().load();
	                			   }
	                		   },
	                		   
	                		   'facultypendingmarksfilter customcombobox#academicTerm' : {
	                			   select : function(obj, record) {
	                				   var $this = this;
	                				   var id = record[0].get("id");
	                				   var form = $this.getFacultypendingmarksfilter();
	                				   var academyLocationIds = this.getCurrentAcademyLocation();
	                				   var batch = form.down('#batchItemId');
	                				   var program = form.down('#programItemId');
	                				   var period = form.down('#periodItemId');
	                				   var intakeYear = form.down('#intakeYear');
	                				   var academicTerm = form.down('#academicTerm');
	                				   var marksheetJob = form.down('#marksheetJobNameId');
	                				   var radioButton = form.down('#radiogroupItemId');
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   var studentStatus = form.down('#studentStatusId');
	                				   var assesmentType = form.down('#evaluationTypeItemId');
	                				   if(isNullOrEmpty(marksheetJob.getValue())){
	                					   program.reset();
	                					   batch.reset();
	                					   period.reset();
	                					   program.getStore().getProxy().extraParams={
	                						   academyLocationIds: academyLocationIds,
	                						   intakeYearId : intakeYear.getValue(),
	                						   //academicTermId:academicTerm.getValue(),
	                						   evaluationType:assesmentType.getValue(),
	                						   facultyId: $this.getCurrentlyLoggedInUser().id,
		                					   whetherMarksheet:true
	                					   };
	                					   program.getStore().load();
	                					   batch.reset();
		                				   period.reset();
	                				   }
	                				   var studentList = form.down("#admissionItemId");
	                				   studentList.reset();
	                				   var studentListStore=studentList.getStore();
	                				   studentListStore.getProxy().extraParams={
	                					   academyLocationIds:academyLocationIds,
	                					   marksheetJobId:marksheetJob.getValue(),
	                					   intakeYeadId:intakeYear.getValue(),
	                					   academicTermId:id,
	                					   isMarkEntry:isMarkEntry,
	                					  
	                				   };
	                				   studentListStore.load();
	                			   }
	                		   },
	                		   
	                		   'facultypendingmarksfilter customcombobox[itemId=evaluationPlanItemId]':{
	                			   select : function(obj, record){
	                				   var $this = this;
	                				   var data = record[0].data.id;
	                				   var evaluationPlanType=record[0].data.code;
	                				   var form = $this.getFacultypendingmarksfilter();
	                				   var academyLocationIds = this.getCurrentAcademyLocation();
	                				   var course = form.down('#courseItemId');
	                				   var evalplanLevel = form.down('#evalPlanLevelItemId');
	                				   var marksheetJobId = form.down('#marksheetJobNameId');
	                				   var marksheetJobLevelId = form.down('#marksheetJobLevelId');
	                				   var intakeYear = form.down('#intakeYear');
	                				   var academicTerm = form.down('#academicTerm');
	                				   var programId = form.down('#programItemId');
	                				   var batchId = form.down('#batchItemId');
	                				   var periodId = form.down('#periodItemId');
	                				   var sectionId = form.down("#sectionItemId");
	                				   var studentList = form.down("#admissionItemId");
	                				   var radioButton = form.down('#radiogroupItemId');
	                				   var courseVariant = form.down('#courseVariantItemId');
	                				   var evaluationLevelIdField = form.down('#evaluationLevelId');
	                				   var studentStatus = form.down('#studentStatusId').getValue();
	                				   var evalPlanLevelNameItemIdField = form.down('#evalPlanLevelNameItemId');
	                				   evalPlanLevelNameItemIdField.reset();
	                				   evalPlanLevelNameItemIdField.setDisabled(false);
	                				   evalPlanLevelNameItemIdField.getStore().getProxy().extraParams={
	                					   evaluationPlanId:data,
	                					   whetherRemark: !isMarkEntry,
	                					   levelName : evaluationLevelIdField.getValue()
		                			   };
	                				   evalPlanLevelNameItemIdField.getStore().load();
	                				   if(evaluationPlanType == "ACADEMICS"){
	                					   course.setVisible(true);
	                					   courseVariant.setVisible(true);
	                					   course.setDisabled(false);
		                				   course.reset();
		                				   course.getStore().getProxy().extraParams={
		                					   evaluationPlanId: data,
		                					   academyLocationIds:academyLocationIds,
		                					   programId:programId.getValue(),
		                					   batchId:batchId.getValue(),
		                					   periodId:periodId.getValue(),
		                					   marksheetJobId:marksheetJobId.getValue(),
		                					   marksheetJobLevelId:marksheetJobLevelId.getValue(),
		                					   facultyId: $this.getCurrentlyLoggedInUser().id

		                				   };
		                				   course.getStore().load();
		                			   } else {
		                				   course.setVisible(false);
		                				   courseVariant.setVisible(false);
		                			   }
	                				 
	                				   studentList.reset();
		                			   var studentListStore=studentList.getStore();
		                			   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
		                			   studentListStore.getProxy().extraParams={
		                					   academyLocationIds:academyLocationIds,
		                					   marksheetJobId:marksheetJobId.getValue(),
		                					   intakeYeadId:intakeYear.getValue(),
		                					   academicTermId:academicTerm.getValue(),
		                					   programId:programId.getValue(),
		                					   batchId:batchId.getValue(),
		                					   periodId:periodId.getValue(),
		                					   sectionId:sectionId.getValue(),
		                					   assessmentSchemeId:data,
		                					   isMarkEntry:isMarkEntry,
		                					   studentStatus:studentStatus
		                			   };
		                			   studentListStore.load();
	                				   
	                			   }
	                		   },
	                		   
	                		   'facultypendingremarksgrid': {
	                			   render:function(grid){
	                				   this.doAccessControlValidation(grid, this.getFACULTY_PENDING_MARKS_REMARKS_PERMISSION());
	                			   }, 
	                			   afterrender:function(grid){
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   if(wheatherSchool) {
	                					   grid.columns[2].hide();
	                				   }else{
	                					   grid.columns[2].show();
	                				   }
	                			   },
	                			   cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	                				   if(e.target.tagName == 'A') {
	                					   var $this = Academia.app.getController('Academia.controller.examinationcenters.remark.EvaluationRemarkController');
	                					   var grid=this.getFacultypendingremarksgrid();
	                					   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                					   var structure = Ext.widget('evaluationremarkmasterstructure');
	                					   var tabName = getExaminationTranslation('ASSIGN_REMARKS');
	                					   /**
	                					    * This is to remove tab from content panel and open same tab again 
	                					    */
	                					   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                					   var getTab=getcontroller.getTab(tabName);
	                					   if(getTab!=null){
	                						   contentPanel.remove(getTab, true);
	                					   }
	                					   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_FOUR);


	                					   var data=record.data;
	                					   var isLongDistance=null;
	                					   var evalRemarkFilter=$this.getEvaluationremarkquickfilter();
	                					   var evalRemarkFilterForm=evalRemarkFilter.getForm();
	                					   var academyLocationIds = $this.getCurrentAcademyLocation();
	                					   var evaluationType=evalRemarkFilterForm.findField('evaluationplantype');
	                					   evaluationType.getStore().load({
	                						   callback:function(){
	                							   evaluationType.setValue(data.evalPlanType);
	                						   }
	                					   });
	                					   evalRemarkFilterForm.isValid();

	                					   var evaluationStageField=evalRemarkFilterForm.findField('evaluationStage');
	                					   evaluationStageField.getStore().load({
	                						   callback:function(){
	                							   evaluationStageField.setValue(data.evalPlanStage);
	                						   }
	                					   });
	                					   evalRemarkFilterForm.isValid();

	                					   var academyLocationId=$this.getCurrentAcademyLocation();	  
	                					   var loggedInUserInfo=$this.getCurrentlyLoggedInUser();

	                					   var courseField=evalRemarkFilterForm.findField('courseId');
	                					   var courseVariantField=evalRemarkFilterForm.findField('courseVariant');
	                					   //var externalCourseField=evalPlanFilterForm.findField('externalCourseMaster');
	                					   var categoryField=evalRemarkFilterForm.findField('category');

	                					   /*   courseField.setVisible(true);
	                  						   courseField.setDisabled(true);
	                  						   courseField.reset();
	                  						   courseField.allowBlank=true;	      

	                  						   externalCourseField.setVisible(false);
	          				        				externalCourseField.setDisabled(true);
	          				        				externalCourseField.reset();
	          				        				externalCourseField.allowBlank=true;

	                  						   categoryField.setVisible(false);
	                  						   categoryField.setDisabled(true);
	                  						   categoryField.reset();
	                  						   categoryField.allowBlank=true;*/

	                					   if(data.evalPlanType==getExaminationTranslation('CNTRL_ACADEMICS')){
	                						   //courseField.allowBlank=false;
	                						   //   courseField.setVisible(true);
	                						   //courseField.setFieldLabel(getExaminationTranslation('COURSE')+'<span class="required" style="color:red"> *</span>');
	                						   // courseField.enable();
	                						   courseVariantField.setVisible(true);
	                						   courseVariantField.setFieldLabel('Course Variant');


	                						   var academyLocationId = this.getCurrentAcademyLocation();
	                						   if(!isNullOrEmpty(data.courseId) && !isNullOrEmpty(data.evaluationPlanId)){
	                							   courseVariantField.enable();
	                							   courseVariantField.reset();
	                							   courseVariantField.getStore().getProxy().extraParams = {
	                								   courseId: data.courseId,
	                								   academyLocationId:academyLocationId,
	                								   facultyId:loggedInUserInfo.id
	                							   };
	                							   courseVariantField.getStore().load({
	                								   callback:function(records, operation, success){
	                									   courseVariantField.setValue(data.courseVariantId);
	                								   }
	                							   });
	                							   evalRemarkFilterForm.isValid();
	                						   }


	                						   /**
	                						    * Load course on the bases of logged in user and current academy location.
	                						    */
	                						   var courseStore=courseField.getStore();
	                						   courseStore.getProxy().extraParams = {
	                							   evaluationPlantype:data.evalPlanType,
	                							   academyLocationIds:academyLocationIds,
	                							   facultyId:loggedInUserInfo.id
	                						   };
	                						   courseStore.load({
	                							   callback:function(rec){
	                								   for(var i in rec){
	                									   if(rec[i].data.id==data.courseId){
	                										   courseField.setValue(rec[i].data.id);
	                										   break;
	                									   }
	                								   }
	                							   }
	                						   });
	                						   evalRemarkFilterForm.isValid();

	                						   var evalautionPlanNoField=evalRemarkFilterForm.findField('evaluationPlan');
	                						   evalautionPlanNoField.setVisible(true);
	                						   evalautionPlanNoField.enable();

	                						   if(!isNullOrEmpty(data.evalPlanStage) && (!isNullOrEmpty(data.courseId) || !isNullOrEmpty(data.otherCategoryId))){
	                							   var store=evalautionPlanNoField.getStore();
	                							   store.getProxy().extraParams = {
	                								   evaluationPlantype : getExaminationTranslation('CNTRL_ACADEMICS') ,
	                								   evaluationStage : 'COURSE_EXECUTION',
	                								   academyLocationIds : academyLocationIds
	                							   };
	                							   //evalPlanFilterForm.findField('evalautionPlanNo').setVisible(false);
	                							   store.load({
	                								   callback:function(records){
	                									   for(var i=0;i<records.length;i++){
	                										   if(records[i].data.id==data.evaluationPlanId){
	                											   evalautionPlanNoField.setValue(records[i].data.id);
	                										   }
	                									   }

	                								   }
	                							   });

//	                							   evalRemarkFilterForm.findField('evaluationPlan').setVisible(false);
	                							   evalRemarkFilterForm.findField('sectionId').setVisible(false);
	                							   var section = evalRemarkFilterForm.findField('sectionId')
	                							   var cvIds=[];
	                							   cvIds.push(data.courseVariantId);
	                							   section.reset();
	                							   section.setDisabled(false);
	                							   section.getStore().getProxy().extraParams = {
	                								   courseVariantIds:data.courseVariantId
	                							   };
	                							   section.getStore().load({
	                								   callback: function(records, operation, success) {
	                									   var arr=[];
	                									   for(var i in records){
	                										   arr.push(records[i].data.id);
	                									   }
	                									   section.setValue(arr);
	                								   }
	                							   });

	                							   evalRemarkFilterForm.isValid();
	                						   }
	                					   }/*else if(data.evalPlanType==getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){
	      				        					//externalCourseField.allowBlank=false;
	      				        					externalCourseField.setVisible(true);
	      				        					externalCourseField.enable();
	      				        					externalCourseField.setFieldLabel(getExaminationTranslation('EXTERNAL_COURSE')+'<span class="required" style="color:red"> *</span>');

	      				        					externalCourseField.getStore().load({
	      					        					callback:function(){
	      					        						externalCourseField.setValue(data.extrenalCourseId );
	      					        					}
	      					        				}); 

	      				        				}*/else if(data.evalPlanType==getExaminationTranslation('CNTRL_OTHER')){
	      				        					//categoryField.allowBlank=false;
	      				        					var academyLocationId = this.getCurrentAcademyLocation();
	      				        					courseField.setVisible(false);
	      				        					courseField.setDisabled(true);
	      				        					courseField.reset();
//	      				        					courseField.allowBlank=false;
	      				        					courseVariantField.setVisible(false);
	      				        					courseVariantField.setDisabled(true);
	      				        					courseVariantField.reset();
	      				        					courseVariantField.allowBlank=true;
	      				        					categoryField.setVisible(true);
	      				        					evalRemarkFilterForm.findField('evaluationPlan').setVisible(true);
	      				        					evalRemarkFilterForm.findField('sectionId').setVisible(false);
	      				        					categoryField.enable();
	      				        					categoryField.setFieldLabel(getExaminationTranslation('CATEGORY')+'<span class="required" style="color:red"> *</span>');

	      				        					categoryField.getStore().load({
	      				        						callback:function(){
	      				        							categoryField.setValue(data.otherCategoryId);
	      				        						}
	      				        					});
	      				        					/**
	      				        					 * Load program
	      				        					 * */
	      				        					evalRemarkFilterForm.isValid();
	      				        					var programIdField=evalRemarkFilterForm.findField('programId');
	      				        					programIdField.enable();
	      				        					programIdField.setVisible(true);
	      				        					var store=programIdField.getStore();
	      				        					store.getProxy().extraParams = {
	      				        						academyLocationId:academyLocationId
	      				        					};
	      				        					store.load({
	      				        						callback:function(records){
	      				        							programIdField.setValue(data.programId);
	      				        						}
	      				        					});
	      				        					evalRemarkFilterForm.isValid();
	      				        					/**
	      				        					 * Load batch
	      				        					 * */
	      				        					var batchIdField=evalRemarkFilterForm.findField('batchId');
	      				        					//batchIdField.enable();
	      				        					batchIdField.setVisible(true);
	      				        					var store=batchIdField.getStore();
	      				        					store.getProxy().extraParams = {
	      				        						id:data.programId
	      				        					};
	      				        					store.load({
	      				        						callback:function(records){
	      				        							batchIdField.setValue(data.batchId);
	      				        						}
	      				        					});
	      				        					evalRemarkFilterForm.isValid();

	      				        					/**
	      				        					 * Load period
	      				        					 * */
	      				        					var periodIdField=evalRemarkFilterForm.findField('periodId');
	      				        					//periodIdField.enable();
	      				        					periodIdField.setVisible(true);
	      				        					var store=periodIdField.getStore();
	      				        					store.getProxy().extraParams = {
	      				        						id:data.batchId
	      				        					};
	      				        					store.load({
	      				        						callback:function(records){
	      				        							for (var i in records){
	      				        								if(records[0].data.id = data.batchId){
	      				        									periodIdField.setValue(records[i].data.id);
	      				        								}else{
	      				        									periodIdField.setValue(records[0].data.id);
	      				        								}
	      				        							}
	      				        						}
	      				        					});
	      				        					evalRemarkFilterForm.isValid(); 
	      				        					/**
	      				        					 * Load section
	      				        					 * */
	      				        					var sectionIdField=evalRemarkFilterForm.findField('sectionId');
	      				        					//sectionIdField.enable();
	      				        					sectionIdField.setVisible(true);
	      				        					var store=sectionIdField.getStore();
	      				        					store.getProxy().extraParams = {
	      				        						periodId:data.periodId
	      				        					};
	      				        					store.load({
	      				        						callback:function(records){
	      				        							sectionIdField.setValue(data.sectionId);
	      				        						}
	      				        					});
	      				        					evalRemarkFilterForm.isValid();
	      				        					/**
	      				        					 * Load category
	      				        					 * */
//	      				        					var categoryField=evalPlanFilterForm.findField('category');
//	      				        					var thisForm = this.getEvaluationstatusquickfilter().getForm();
//	      				        					categoryField.enable();
//	      				        					categoryField.setVisible(true);
//	      				        					var store=categoryField.getStore();
//	      				        					store.getProxy().extraParams = {
//	      				        					};
//	      				        					store.load({
//	      				        					callback:function(records){
//	      				        					categoryField.setValue(thisForm.findField('category').getValue());
//	      				        					}
//	      				        					});
	      				        					evalRemarkFilterForm.isValid(); 	
	      				        					var evalautionPlanNoField=evalRemarkFilterForm.findField('evaluationPlan');
	      				        					evalautionPlanNoField.enable();
	      				        					evalautionPlanNoField.setVisible(true);
	      				        					var store=evalautionPlanNoField.getStore();
	      				        					store.getProxy().extraParams = {
	      				        						evaluationStage: data.evalPlanStage,
	      				        						evaluationPlanType:data.evalPlanType,
	      				        						courseId: data.courseId>0?data.courseId:null,
	      				        								//externalCourseId:data.externalCourseId>0?data.externalCourseId:0,
//	      				        								otherCategoryId:data.otherCategoryId>0?data.otherCategoryId:null,
	      				        								programId:data.programId,
	      				        								batchId:data.batchId,
	      				        								periodId:data.periodId,
	      				        								sectionId:data.sectionId
	      				        					};
	      				        					store.load({
	      				        						callback:function(records){
	      				        							evalautionPlanNoField.setValue(data.evaluationPlanId);
	      				        							/*for(var i=0;i<records.length;i++){
	      				        								if(records[i].data.id==data.evaluationPlanId){
	                  												evalPlanFilterForm.setLongDistance(records[i].data.isLongDistanceProgram);
	      				        									if(records[i].data.isLongDistanceProgram == "true"){
	      				        										grid.down('#btnApprove').setVisible(false);
	      				        									}
	      				        									else{
	      				        										grid.down('#btnApprove').setVisible(true);
	      				        									}
	      				        								}
	      				        							}*/
	      				        						}
	      				        					});
	      				        					evalRemarkFilterForm.isValid();
	      				        				}

	                					   var evalPlanLevelType = evalRemarkFilterForm.findField('evalPlanLevelType');
	                					   var evalPlanLevelField=evalRemarkFilterForm.findField('evalPlanLevelId');
	                					   evalPlanLevelField.enable();
	                					   evalPlanLevelField.reset();
	                					   evalPlanLevelField.getStore().getProxy().extraParams = {
	                						   evaluationPlanId:data.evaluationPlanId
	                					   };
	                					   evalPlanLevelField.getStore().load({
	                						   callback:function(records){
	                							   evalPlanLevelType.setValue("Assessment "+data.levelName)
	                							   if(data.levelName=="Method"){
	                								   var recordToSelect = evalPlanLevelField.getStore().findRecord('levelId',data.evaluationSequenceId);
	                								   //evalPlanLevelField.setValue(data.evaluationSequenceId);
	                							   }else if(data.levelName=="Sub Type"){
	                								   var recordToSelect = evalPlanLevelField.getStore().findRecord('levelId',data.evaluationPlanLevelTwoId);
	                								   //evalPlanLevelField.setValue(data.evaluationPlanLevelTwoId);
	                							   }else if(data.levelName=="Type"){
	                								   var recordToSelect = evalPlanLevelField.getStore().findRecord('levelId',data.evaluationPlanLevelOneId);
	                								   //evalPlanLevelField.setValue(data.evaluationPlanLevelOneId);
	                							   }
	                							   if(Ext.isDefined(recordToSelect) && !isNullOrEmpty(recordToSelect)){
	                								   evalPlanLevelField.select(recordToSelect);
	                							   }
	                						   }
	                					   });
	                					   evalRemarkFilterForm.isValid();

	                					   var courseVariantField=evalRemarkFilterForm.findField('courseVariant');
	                					   courseVariantField.enable();
	                					   var academyLocationId = this.getCurrentAcademyLocation();
	                					   if(!isNullOrEmpty(data.courseId) && !isNullOrEmpty(data.evaluationPlanId)){
	                						   courseVariantField.enable();
	                						   courseVariantField.reset();
	                						   courseVariantField.getStore().getProxy().extraParams = {
	                							   courseId: data.courseId,
	                							   academyLocationId:this.getCurrentAcademyLocation(),
	                							   facultyId:loggedInUserInfo.id
	                						   };
	                						   courseVariantField.getStore().load({
	                							   callback:function(records, operation, success){
	                								   courseVariantField.setValue(data.courseVariantId);
	        	                					   var genericRemarkButtonId = evalRemarkFilter.down('#genericRemarkButtonId');
	        	                					   genericRemarkButtonId.setDisabled(false);
	        	                					   var searchBtn = evalRemarkFilter.down('#searchBtn');
	        	                					   searchBtn.setDisabled(false); 
	                							   }
	                						   });
	                						   evalRemarkFilterForm.isValid();
	                					   }

	                					   if(!isNullOrEmpty(data.eventId)){
	                						   var grid=$this.getEvaluationremarkgrid();
	                						   grid.getSelectionModel().deselectAll();
	                						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                						   var store=grid.getStore();
	                						   store.getProxy().extraParams = {
//	                							   evalSeqDetailId: data.eventId,
	                							   courseVariantId:data.courseVariantId,
	                							   programId:data.programId,
	                							   batchId:data.batchId,
	                							   periodId:data.periodId,
	                							   sectionId:data.sectionId,
	                							   evaluationPlanId:data.evaluationPlanId,
	                							   evaluationPlanLevelOneId:data.evaluationPlanLevelOneId,
	                							   evaluationPlanLevelTwoId:data.evaluationPlanLevelTwoId,
	                							   evaluationSequenceId:data.evaluationSequenceId,
//	                							   admissionId:data.admissionId
	                						   };
	                						   store.load();
	                						   Ext.getBody().unmask();
	                					   }
	                					   evalRemarkFilterForm.isValid();
	                				   }
	                			   },
	                		   },
	                		   'pendingfacultymarksgrid': {
	                			   render:function(grid){
	                				   this.doAccessControlValidation(grid, this.getFACULTY_PENDING_MARKS_REMARKS_PERMISSION());
	                			   },
	                			   beforerender: function(grid) {
	                     				grid.getStore().removeAll();
	                			   },
	                			   afterrender:function(grid){
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   if(wheatherSchool) {
	                					   grid.columns[2].hide();
	                				   }else{
	                					   grid.columns[2].show();
	                				   }
	                				     var me = this;
	       	    	       			    setTimeout(function(){
	       	    	        		       	me.addDataGridConfigButton(grid,me.getFACULTY_PENDING_MARKS_REMARKS_PERMISSION());
	       	    	        		        },1500);
	                			   },
	                			   cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
	                				   if(e.target.tagName == 'A') {
	                					   var $this = this;
	                					   var this$ = Academia.app.getController('Academia.controller.examinationcenters.manageEvaluation.ManageEvalResultSearchController');
	                					   var grid=$this.getPendingfacultymarksgrid();
	                					   var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                					   var structure = Ext.widget('manageevalresultmasterstructure');
	                					   var tabName = getExaminationTranslation('MANAGE_MARKS_ENTRY');
	                					   
        								   var alinfomodel = Academia.model.authentication.ALInfoModel;
        								   var wheatherSchool = alinfomodel.get('wheatherSchool');
        								    
	                					   /**
	                					    * This is to remove tab from content panel and open same tab again 
	                					    */
	                					   var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                					   var getTab=getcontroller.getTab(tabName);
	                					   if(getTab!=null){
	                						   contentPanel.remove(getTab, true);
	                					   }
	                					   
	                					   if(portalId==2){
	                						   //--checking for manage marks entry tab with same name
	                						   var tabName = getMegaMenuTranslation('MARK_ENTRY');
	                						   var getTab=getcontroller.getTab(tabName);
	                						   if(getTab!=null){
	                							   contentPanel.remove(getTab, true);
	                						   }
	                					   }
	                					   
	                					   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_FOUR);
	                					   var evalPlanFilter;
	                					   var data=record.data;
		                					  
	                					   if(portalId == 2) {
	                						   this$ = Academia.app.getController('Academia.controller.examinationcenters.manageEvaluation.FacultyManageEvalResultSearchController');
	                						   evalPlanFilter=this$.getFacultyevaluationplanfilter();
	                						   evalPlanFilter.down('#HiddenEvnt').setValue(data.eventId);
               					    		   evalPlanFilter.down('#anonymousEvnt').setValue(data.whetherEvalAnonymous);
	                					   } else {
	                						   evalPlanFilter=this$.getEvaluationplanfilter();
	                					   }
	                					   var isLongDistance=null;

	                					   var evalPlanFilterForm=evalPlanFilter.getForm();
	                					   var academyLocationIds = $this.getCurrentAcademyLocation();
	                					   
	                					   // 1st Field -- Start Here
	                					   var evaluationType=evalPlanFilterForm.findField('evaluationType');
	                					  var courseVariantField = evalPlanFilterForm.findField('courseVariant');
	                					  var facultyId = this.getCurrentlyLoggedInUser();
	                					  var pendingMarkRemarkGrid =this.getPendingfacultymarksgrid();
	                					  var recordOfPendingMarkRemark = pendingMarkRemarkGrid.getSelectionModel().getSelection()[0];
	                						
	                					 
	                					   evaluationType.getStore().load({
	                						   callback:function(){
	                							   evaluationType.setValue(data.evalPlanType);
	    	                					   evalPlanFilterForm.isValid();
	    	                					   
	    	                					   // 2nd Field -- Start Here
	    	                					   var evaluationStageField=evalPlanFilterForm.findField('evaluationStage');
	    	                					   evaluationStageField.getStore().load({
	    	                						   callback:function(){
	    	                							   evaluationStageField.setValue(data.evalPlanStage);
	    	    	                					   evaluationStageField.hide();
	    	    	                					   evalPlanFilterForm.isValid();
	    	    	                					   var academyLocationId=$this.getCurrentAcademyLocation();	  
	    	    	                					   var loggedInUserInfo=$this.getCurrentlyLoggedInUser();
	    	    	                					   var academicTermField;
	    	    	                					   if(portalId == 2) {
	    	    	                						   academicTermField=evalPlanFilterForm.findField('academicTerm');
	    	    	                					   }else{
	    	    	                						   academicTermField=evalPlanFilterForm.findField('markEntryAcademicTerm');
	    	    	                					   }
	    	    	                					   
	    	    	                					   //var courseField=evalPlanFilterForm.findField('course_name');
	    	    	                					   var courseVariantField=evalPlanFilterForm.findField('courseVariant');
	    	    	                					   
	    	    	                					   if(data.evalPlanType==getExaminationTranslation('CNTRL_ACADEMICS')){
	    	    	                						   /*courseField.setVisible(true);
	    	    	                						   courseField.enable();*/
	    	    	                						   var courseVariantId = evalPlanFilter.down('#courseVariantItemId');
	    	    	                						   courseVariantField.setVisible(true);
	    	    	                						   courseVariantField.setFieldLabel('Course Variant');
	    	    	                						   $this.setAllowBlank(courseVariantId,false);
	    	    	                						   var ALArray=[];
	    		    	        			        		   ALArray.push(academyLocationId);
	    		    	        			        		   
	    		    	                					   academicTermField.reset();
	    		    	                					   var courseVR;
	    		    	                					   var academicTermStore = academicTermField.getStore();
	    		    	                    				   academicTermStore.getProxy().extraParams = {
	    		    	                    					   academyLocationIds:ALArray.join()
	    		    	                    				   };
	    		    	               	            			academicTermStore.load({
	    		    	               	            			callback: function(record, operation, success) {
	    		    	               	            				if (success) {
	    		    	               	            					if(record.length>0){
	    		    	               	            						setTimeout(function(){
	    		    	               	            						Ext.each(record, function(value) {
	    		    		               										if(value.data.id == data.academicTermId){
	    		    		               											academicTermField.setValue(data.academicTermId);
	    			    	               	            							if(portalId == 2) {
	    			    	               	            								this$.facultyMarkEntryAcademicTermChange(evalPlanFilter, data.academicTermId,data.courseVariantId);
	    			    	               	            								this$.facultyEvaluationCourseVariantChange(evalPlanFilter,	data.courseVariantId);
	    			    	               	            								
	    			    	               	            							   courseVariantField.getProxy().extraParams = {
	    			    		    	    	   	              							facultyId: facultyId.id,
	    			    		    	    	   	              							courseId:recordOfPendingMarkRemark.get('courseId'),
	    			    		    	    	   	              							//evaluationPlanId:records[0].data.id,
	    			    		    	    	   	              							courseVariantId:recordOfPendingMarkRemark.get('courseVariantId')
	    			    		    	    	   	              						};
	    			    		    	    	   	                					  courseVariantField.getStore().load({
	    			    		    	    	   	                						  callback:function(records){
	    			    		    	    	   	                							  if(records.length>0){
	    			    		    	    	   	                								  courseVariantField.setValue(data.courseVariantId);
	    			    		    	    	   	                							  }
	    			    		    	    	   	                							 
	    			    		    	    	   	                						  }
	    			    		    	    	   	                					  });
	    			    	               	            								/*setTimeout(function(){
	    			    	               	            									this$.facultyEvaluationCourseVariantChange(evalPlanFilter,	data.courseVariantId);
    			    	               	            									},500);
	    			    	               	            								
	    			    	               	            								setTimeout(function(){
	    			    	               	            									this$.facultyEvaluationPlanChange(evalPlanFilter, data.evaluationPlanId, false, false, data.eventId);
    			    	               	            									},500);*/
	    			    	               	            								
	    			    	               	            							}else{
	    			    	               	            									setTimeout(function(){
	    			    	               	            										this$.manageMarkEntryAcademicTermChange(evalPlanFilter, data.academicTermId, data.courseId);
	    			    	               	            										//this$.manageMarkEntryCourseChange(evalPlanFilter,data.courseId,data.courseVariantId,false);
	    			    	               	            									},100);
	    			    	               	            									
	    			    	               	            									setTimeout(function(){
	    			    	               	            										this$.manageMarkEntryCourseChange(evalPlanFilter,data.courseId,data.courseVariantId,false);
	    			    	               	            									},200);
	    			    	               	            									
	    			    	               	            									setTimeout(function(){
	    			    	               	            										this$.manageMarkEntryCourseVariantChange(evalPlanFilter, data.courseVariantId, data.evalPlanId);
	    			    	               	            									},800);
	    			    	               	            									
	    			    	               	            									setTimeout(function(){
	    			    	               	            										this$.manageMarkEntryEvaluationPlanChange(evalPlanFilter, data.evaluationPlanId, false ,false, data.eventId);
	    			    	               	            									},1000);
	    			    	               	            							}
	    		    		               										}
	    		    		               									});
	    		    	               	            					 },500);
	    		    	               	            					}
	    		    	               	            				}
	    		    	               	            			}
	    		    	               	            		});
	    	    	                						   // 3rd Field -- Start Here
	    	    	                						   /*   var courseStore=courseField.getStore();
	    	    	                						   courseStore.getProxy().extraParams = {
	    	    	                							   academyLocationId:academyLocationId,
	    	    	                							   facultyId: $this.getCurrentlyLoggedInUser().id
	    	    	                						   };
	    	    	                						   courseStore.load({
	    	    	                							   callback:function(rec){
	    	    	                								   for(var i in rec){
	    	    	                									   if(rec[i].data.id==data.courseId){
	    	    	                										   courseField.setValue(rec[i].data.id);
	    	    	                										   break;
	    	    	                									   }
	    	    	                								   }
	    	    	    	                						   evalPlanFilterForm.isValid();
	    	    	    	                						   
	    	    	    	                						   // 4th Field -- Start Here
	    	    	    	                						   var evalautionPlanNoField=evalPlanFilterForm.findField('evalautionPlan');
	    	    	    	                						   evalautionPlanNoField.enable();
	    	    	    	                						   if(!isNullOrEmpty(data.evalPlanStage) && (!isNullOrEmpty(data.courseId) || !isNullOrEmpty(data.otherCategoryId))){
	    	    	    	                							   var store=evalautionPlanNoField.getStore();
	    	    	    	                							   store.getProxy().extraParams = {
	    	    	    	                								   evaluationPlantype : getExaminationTranslation('CNTRL_ACADEMICS') ,
	    	    	    	                								   evaluationStage : 'COURSE_EXECUTION',
	    	    	    	                								   academyLocationId : academyLocationId,
	    	    	    	                								   courseId: data.courseId,
	    	    	    	                								   facultyId: $this.getCurrentlyLoggedInUser().id
	    	    	    	                							   };
	    	    	    	                							   store.load({
	    	    	    	                								   callback:function(records){
	    	    	    	                									   for(var i=0;i<records.length;i++){
	    	    	    	                										   if(records[i].data.id==data.evaluationPlanId){
	    	    	    	                											   evalautionPlanNoField.setValue(records[i].data.id);
	    	    	    	                											   var facManEvalResController=  Academia.app.getController('Academia.controller.examinationcenters.manageEvaluation.FacultyManageEvalResultSearchController');
	    	    	    	                											   if(records[i].data.secondCheck){
	    	    	    	                												   facManEvalResController.permissionManagementForEvaluaionPlanFilterOnlyForAnonymousEventForFaculty(facManEvalResController.getFacultyevaluationplanfilter(), facManEvalResController.getFACULTY_MARK_ENTRY_PERMISSION());
	    	    	    	                											   } else {
	    	    	    	                												   facManEvalResController.getFacultyevaluationplanfilter().down('#anonymousEvent').
	    	    	    	                												   setVisible(false);
	    	    	    	                											   }
	    	    	    	                										   }
	    	    	    	                									   }
	    	    	    	                									   
	    	    	    	                									   evalPlanFilterForm.findField('isDynamicScheme').setValue(data.whetherDynamicScheme);
	    	    	    	    	                							   evalPlanFilterForm.findField('evalautionPlan').setVisible(true);
	    	    	    	    	                							   evalPlanFilterForm.findField('sectionsId').setVisible(true);
	    	    	    	    	                							   
	    	    	    	    	                							   // 5th Field -- Start Here
	    	    	    	    	                							  var courseVariantField=evalPlanFilterForm.findField('courseVariant');
	    	    	    	    	    	                					   courseVariantField.enable();
	    	    	    	    	    	                					   var academyLocationId = this$.getCurrentAcademyLocation();
	    	    	    	    	    	                					   if(!isNullOrEmpty(data.courseId) && !isNullOrEmpty(data.evaluationPlanId)){
	    	    	    	    	    	                						   courseVariantField.reset();
	    	    	    	    	    	                						   courseVariantField.getStore().getProxy().extraParams = {
	    	    	    	    	    	                							   evaluationPlanId:data.evaluationPlanId,
	    	    	    	    	    	                							   courseId:data.courseId,
	    	    	    	    	    	                							   facultyId:$this.getCurrentlyLoggedInUser().id
	    	    	    	    	    	                						   };
	    	    	    	    	    	                						   courseVariantField.getStore().load({
	    	    	    	    	    	                							   callback:function(records, operation, success){
	    	    	    	    	    	                								   courseVariantField.setValue(data.courseVariantId);
	    	    	    	    	    	    	                						   evalPlanFilterForm.isValid();
	    	    	    	    	    	    	                						   
	    	    	    	    	    	    	                						   // 6th Field -- Start Here
	    	    	    	    	    	    	                						   var section = evalPlanFilterForm.findField('sectionsId')
	    	    		    	    	    	                							   var cvIds=[];
	    	    		    	    	    	                							   cvIds.push(data.courseVariantId);
	    	    		    	    	    	                							   section.reset();
	    	    		    	    	    	                							   section.setDisabled(false);
	    	    		    	    	    	                							   section.getStore().getProxy().extraParams = {
	    	    		    	    	    	                								   courseVariantIds:data.courseVariantId
	    	    		    	    	    	                							   };
	    	    		    	    	    	                							   section.getStore().load({
	    	    		    	    	    	                								   callback: function(records, operation, success) {
	    	    		    	    	    	                									   var arr=[];
	    	    		    	    	    	                									   for(var i in records){
	    	    		    	    	    	                										   arr.push(records[i].data.id);
	    	    		    	    	    	                									   }
	    	    		    	    	    	                									   section.setValue(arr);
	    	    		    	    	    	                									   evalPlanFilterForm.isValid();
	    	    		    	    	    	                									   
	    	    		    	    	    	                									   // 7th Field -- Start Here
	    	    		    	    	    	                									   var evalPlanLevelField=evalPlanFilterForm.findField('evalPlanLevelId');
	    	    		    	    	    	            										   evalPlanLevelField.enable();
	    	    		    	    	    	            										   evalPlanLevelField.reset();
	    	    		    	    	    	            										   evalPlanLevelField.getStore().getProxy().extraParams = {
	    	    		    	    	    	            										    	evaluationPlanId:data.evaluationPlanId,
	    	    		    	    	    	            												isStatus:false
	    	    		    	    	    	            						   				   };
	    	    		    	    	    	            										   evalPlanLevelField.getStore().load({
		    	    	    	    	    	        	                							   callback:function(){
		    	    	    	    	    	        	                								   // 8th Field -- Start Here
		    	    	    	    	    	        	                								   var detailSequenceField=evalPlanFilterForm.findField('detailSequence');
		    	    	    	    	    	        	        	                					   detailSequenceField.enable();
		    	    	    	    	    	        	        	                					   if(!isNullOrEmpty(data.eventId) && !isNullOrEmpty(data.evaluationPlanId)){
		    	    	    	    	    	        	        	                						   detailSequenceField.reset();
		    	    	    	    	    	        	        	                						   detailSequenceField.getStore().getProxy().extraParams = {
		    	    	    	    	    	        	        	                							   evalPlanId: data.evaluationPlanId,
		    	    	    	    	    	        	        	                							   rmAnonEvent: data.whetherEvalAnonymous,
		    	    	    	    	    	        	                        								   isDynamicScheme:data.whetherDynamicScheme,
		    	    	    	    	    	        	                        								   courseVariantId:data.courseVariantId
		    	    	    	    	    	        	        	                						   };
		    	    	    	    	    	        	        	                						   detailSequenceField.getStore().load({
		    	    	    	    	    	        	        	                							   callback:function(){
		    	    	    	    	    	        	        	                								   detailSequenceField.setValue(data.eventId);
		    	    	    	    	    	        	        	                								   
				    	    	    	    	    	        	        	                						   var formIsValid = evalPlanFilterForm.isValid();
		    		    	    	    	    	    	    	        	                						   if(formIsValid){
		    		    	    	    	    	    	    	        	                							   try{
				    		    	    	    	    	    	    	        	                						   Ext.ComponentQuery.query('#generateFoils')[0].setDisabled(false);
		    		    	    	    	    	    	    	        	                							   }
		    		    	    	    	    	    	    	        	                							   catch(e){
		    		    	    	    	    	    	    	        	                								   
		    		    	    	    	    	    	    	        	                							   }
		    		    	    	    	    	    	    	        	                							   var searchBtn = detailSequenceField.up('form').down('#searchBtn');
		    		    	    	    	    	    	    	        	                							   searchBtn.fireEvent('click',searchBtn);
		    		    	    	    	    	    	    	        	                						   }
		    	    	    	    	    	        	        	                							   }
		    	    	    	    	    	        	        	                						   });
		    	    	    	    	    	        	        	                					   }
		    	    	    	    	    	        	                								   // 8th Field -- End Here
		    	    	    	    	    	        	                							   }
	    	    		    	    	    	            										   });
	    	    		    	    	    	                									   // 7th Field -- End Here
	    	    		    	    	    	                								   }
	    	    		    	    	    	                							   });
	    	    	    	    	    	    	                						   // 6th Field -- End Here
	    	    	    	    	    	                							   }
	    	    	    	    	    	                						   });
	    	    	    	    	    	                					   }
	    	    	    	    	                							   // 5th Field -- End Here
	    	    	    	                								   }
	    	    	    	                							   });
	    	    	    	                						   }
	    	    	    	                						   // 4th Field -- End Here
	    	    	                							   }
	    	    	                						   });*/
	    	    	                						   // 3rd Field -- End Here
	    	    	                					   }else if(data.evalPlanType==getExaminationTranslation('CNTRL_OTHER')){
	    	    	                						   courseField.setVisible(false);
	    	    	                						   courseField.setDisabled(true);
	    	    	                						   courseField.reset();
	    	    	                						   courseField.allowBlank=true;
	    	    	                						   courseVariantField.setVisible(false);
	    	    	                						   courseVariantField.setDisabled(true);
	    	    	                						   courseVariantField.reset();
	    	    	                						   courseVariantField.allowBlank=true;
	    	    	                						   evalPlanFilterForm.findField('evalautionPlan').setVisible(false);
	    	    	                						   evalPlanFilterForm.findField('sectionsId').setVisible(false);
	    	    	                						   evalPlanFilterForm.isValid();
	    	    	                						   
	    	    	                						   // 3rd Field -- Start Here
	    	    	                						   var evalautionPlanNoField=evalPlanFilterForm.findField('evalautionPlanNo');
	    	    	                						   evalautionPlanNoField.enable();
	    	    	                						   evalautionPlanNoField.setVisible(true);
	    	    	                						   var academyLocationId=$this.getCurrentAcademyLocation();
	    	    	                						   
	    	    	                						   var store=evalautionPlanNoField.getStore();

	    		    	                					   if(portalId==2){
	    		    	                						   store.getProxy().extraParams = {
		    	    	                							   evaluationPlanType:data.evalPlanType,
		    	    	                							   evaluationStage: data.evalPlanStage,
		    	    	                							   academyLocationId: academyLocationId,
		    	    	                							   facultyId: $this.getCurrentlyLoggedInUser().id
		    	    	                						   };
	    		    	                					   }
	    		    	                					   else{
		    	    	                						   store.getProxy().extraParams = {
		    	    	                							   evaluationStage: data.evalPlanStage,
		    	    	                							   academyLocationId: academyLocationId,
		    	    	                							   evaluationPlantype:data.evalPlanType,
		    	    	                							   courseId: null,//data.courseId>0?data.courseId:null,
		    	    	                							   programId: null, //data.programId,
		                											   batchId: null, //data.batchId,
		                											   periodId: null, //data.periodId,
		                											   sectionId: null, //data.sectionId
		    	    	                							   otherCategoryId: null //data.otherCategoryId>0?data.otherCategoryId:null,
		    	    	                						   };
	    		    	                					   }
	    	    	                						   store.load({
	    	    	                							   callback:function(records){
	    	    	                								   evalautionPlanNoField.setValue(data.evaluationPlanId);
	    	    	    	                						   evalPlanFilterForm.isValid();
	    	    	    	                						   
	    	    	    	                						   // 4th Field -- Start Here
	    	    	    	                						   var programIdField=evalPlanFilterForm.findField('programId');
	    	    	    	                						   programIdField.enable();
	    	    	    	                						   programIdField.setVisible(true);
	    	    	    	                						   var store=programIdField.getStore();
	    	    	    	                						   store.getProxy().extraParams = {
	    	    	    	                							   evaluationPlanId: data.evaluationPlanId,
	    	    	                									   programName: null
	    	    	    	                						   };
	    	    	    	                						   store.load({
	    	    	    	                							   callback:function(records){
	    	    	    	                								   programIdField.setValue(data.programId);
	    	    	    	    	                						   evalPlanFilterForm.isValid();
	    	    	    	    	                						   
	    	    	    	    	                						   // 5th Field -- Start Here
	    	    	    	    	                						   var batchIdField=evalPlanFilterForm.findField('batchId');
	    	    	    	    	                						   batchIdField.enable();
	    	    	    	    	                						   batchIdField.setVisible(true);
	    	    	    	    	                						   var store=batchIdField.getStore();
	    	    	    	    	                						   store.getProxy().extraParams = {
	    	    	    	    	                							   evaluationPlanId: data.evaluationPlanId,
	    	    	                											   programId:data.programId
	    	    	    	    	                						   };
	    	    	    	    	                						   store.load({
	    	    	    	    	                							   callback:function(records){
	    	    	    	    	                								   batchIdField.setValue(data.batchId);
	    	    	    	    	    	                						   evalPlanFilterForm.isValid();
	    	    	    	    	    	                						   
	    	    	    	    	    	                						   // 6th Field -- Start Here
	    	    	    	    	    	                						   var periodIdField=evalPlanFilterForm.findField('periodId');
	    	    	    	    	    	                						   periodIdField.enable();
	    	    	    	    	    	                						   if(wheatherSchool){
		    	    	    	    	    	                						   periodIdField.setVisible(false);
	    	    	    	    	    	                						   }
	    	    	    	    	    	                						   else{
		    	    	    	    	    	                						   periodIdField.setVisible(true);
	    	    	    	    	    	                						   }
	    	    	    	    	    	                						   var store=periodIdField.getStore();
	    	    	    	    	    	                						   store.getProxy().extraParams = {
	    	    	    	    	    	                							   evaluationPlanId: data.evaluationPlanId,
	    	    	                													   programId: data.programId,
	    	    	                													   batchId:data.batchId
	    	    	    	    	    	                						   };
	    	    	    	    	    	                						   store.load({
	    	    	    	    	    	                							   callback:function(records){
	    	    	    	    	    	                								   for (var i in records){
	    	    	    	    	    	                									   if(records[0].data.id == data.batchId){
	    	    	    	    	    	                										   periodIdField.setValue(records[i].data.id);
	    	    	    	    	    	                									   } else {
	    	    	    	    	    	                										   periodIdField.setValue(records[0].data.id);
	    	    	    	    	    	                									   }
	    	    	    	    	    	                								   }
	    	    	    	    	    	    	                						   evalPlanFilterForm.isValid(); 
	    	    	    	    	    	    	                						   
	    	    	    	    	    	    	                						   // 7th Field -- Start Here
	    	    	    	    	    	    	                						   var sectionIdField=evalPlanFilterForm.findField('sectionId');
	    	    	    	    	    	    	                						   sectionIdField.enable();
	    	    	    	    	    	    	                						   sectionIdField.setVisible(true);
	    	    	    	    	    	    	                						   var store=sectionIdField.getStore();
	    	    	    	    	    	    	                						   store.getProxy().extraParams = {
	    	    	    	    	    	    	                							   evaluationPlanId: data.evaluationPlanId,
	    	    	                															   programId: data.programId,
	    	    	                															   batchId: data.batchId,
	    	    	                															   periodId:data.periodId,
	    	    	    	    	    	    	                							   facultyId: $this.getCurrentlyLoggedInUser().id
	    	    	    	    	    	    	                						   };
	    	    	    	    	    	    	                						   store.load({
	    	    	    	    	    	    	                							   callback:function(records){
	    	    	    	    	    	    	                								   sectionIdField.setValue(data.sectionId);
	    	    	    	    	    	    	    	                						   evalPlanFilterForm.isValid();
	    	    	    	    	    	    	    	                						   
	    	    	    	    	    	    	    	                						   // 8th Field -- Start Here
	    	    	    	    	    	    	    	                						   var evalPlanLevelField=evalPlanFilterForm.findField('evalPlanLevelId');
	    	    		    	    	    	            										   evalPlanLevelField.enable();
	    	    		    	    	    	            										   evalPlanLevelField.reset();
	    	    		    	    	    	            										   evalPlanLevelField.getStore().getProxy().extraParams = {
	    	    		    	    	    	            										    	evaluationPlanId:data.evaluationPlanId,
	    	    		    	    	    	            												isStatus:false
	    	    		    	    	    	            						   				   };
	    	    		    	    	    	            										   evalPlanLevelField.getStore().load({
		    	    	    	    	    	        	                							   callback:function(){
		    	    	    	    	    	        	                								   // 9th Field -- Start Here
		    	    	    	    	    	        	                								   var detailSequenceField=evalPlanFilterForm.findField('detailSequence');
		    	    	    	    	    	        	        	                					   detailSequenceField.enable();
		    	    	    	    	    	        	        	                					   if(!isNullOrEmpty(data.eventId) && !isNullOrEmpty(data.evaluationPlanId)){
		    	    	    	    	    	        	        	                						   detailSequenceField.reset();
		    	    	    	    	    	        	        	                						   detailSequenceField.getStore().getProxy().extraParams = {
		    	    	    	    	    	        	        	                							   evalPlanId: data.evaluationPlanId,
		    	    	    	    	    	        	        	                							   programId: data.programId,
		    		    	    	    	    	    	        	                							   batchId: data.batchId,
		    		    	    	    	    	    	        	                							   periodId: data.periodId
		    	    	    	    	    	        	        	                						   };
		    	    	    	    	    	        	        	                						   detailSequenceField.getStore().load({
		    	    	    	    	    	        	        	                							   callback:function(){
		    	    	    	    	    	        	        	                								   detailSequenceField.setValue(data.eventId);
		    	    	    	    	    	        	        	                								   
				    	    	    	    	    	        	        	                						   var formIsValid = evalPlanFilterForm.isValid();
		    		    	    	    	    	    	    	        	                						   if(formIsValid){
		    		    	    	    	    	    	    	        	                							   try{
				    		    	    	    	    	    	    	        	                						   Ext.ComponentQuery.query('#generateFoils')[0].setDisabled(false);
		    		    	    	    	    	    	    	        	                							   }
		    		    	    	    	    	    	    	        	                							   catch(e){
		    		    	    	    	    	    	    	        	                								   
		    		    	    	    	    	    	    	        	                							   }
		    		    	    	    	    	    	    	        	                							   var searchBtn = detailSequenceField.up('form').down('#searchBtn');
		    		    	    	    	    	    	    	        	                							   searchBtn.fireEvent('click',searchBtn);
		    		    	    	    	    	    	    	        	                						   }
		    	    	    	    	    	        	        	                							   }
		    	    	    	    	    	        	        	                						   });
		    	    	    	    	    	        	        	                					   }
		    	    	    	    	    	        	                								   // 9th Field -- End Here
		    	    	    	    	    	        	                							   }
	    	    		    	    	    	            										   });
	    	    	    	    	    	    	    	                						   // 8th Field -- End Here
	    	    	    	    	    	    	                							   }
	    	    	    	    	    	    	                						   });
	    	    	    	    	    	    	                						   // 7th Field -- End Here
	    	    	    	    	    	                							   }
	    	    	    	    	    	                						   });
	    	    	    	    	    	                						   // 6th Field -- End Here
	    	    	    	    	                							   }
	    	    	    	    	                						   });
	    	    	    	    	                						   // 5th Field -- End Here
	    	    	    	                							   }
	    	    	    	                						   });
	    	    	    	                						   // 4th Field -- End Here
	    	    	                							   }
	    	    	                						   });
	    	    	                						   // 3rd Field -- End Here
	    	    	                					   }
	    	                						   }
	    	                					   });
	    	                					   // 2nd Field -- End Here
	                						   }
	                					   });
	                					   // 1st Field -- End Here
	                					   
										   var anonymousEventCheckField=evalPlanFilterForm.findField('anonymousEvent');
										   if(!isNullOrEmpty(data.whetherEvalAnonymous)){
                							   if(!data.whetherEvalAnonymous) {
	                							   anonymousEventCheckField.up().setVisible(false);
                							   } else {
	                							   anonymousEventCheckField.up().setVisible(true);
                								   anonymousEventCheckField.setValue(data.whetherEvalAnonymous);
	                							   anonymousEventCheckField.isValid();
                							   }
                						   }

	                					   if(!isNullOrEmpty(data.eventId)){
	                						   var grid=this$.getFacultymangeevalresultmastergrid();
	                						   grid.getSelectionModel().deselectAll();
	                						   if(data.whetherDynamicScheme && (data.status!=getExaminationTranslation('CNTRL_CONDUCTED') ||
                									   (data.examEventStatus!=getExaminationTranslation('CNTRL_MARK_ENTRY_PENDING')))){
                				        		  grid.down('#btnEdit').setVisible(false);
                				        		  grid.down('#btnDelete').setVisible(false);
            				        		   } else if(!(data.whetherDynamicScheme) && data.status!=getExaminationTranslation('CNTRL_CONDUCTED')) {
            				        			  grid.down('#btnEdit').setVisible(false);
            				        			  grid.down('#btnDelete').setVisible(false);
            				        		   }
	                						   /*Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                						   var store=grid.getStore();
	                						   store.getProxy().extraParams = {
	                							   evalSeqDetailId: data.eventId,
	                							   courseVariantId:data.courseVariantId,
	                							   programId:data.programId,
	                							   batchId:data.batchId,
	                							   periodId:data.periodId,
	                							   sectionId:data.sectionId,
	                							   whetherExamAttended:true
	                						   };
	                						   store.load();
	                						   Ext.getBody().unmask();*/
	                					   }
	                					   evalPlanFilterForm.isValid();
	                				   }
	                			   }
	                		   },
	                		   
	                		   'facultypendingmarksfilter customcombobox[itemId=marksheetJobNameId]' : {
	                			   select : function(obj,rec) {
	                				   var $this=this;
	                				   var filterForm=obj.up('form').getForm();
	                				   var data;
	                				   var fieldsData;
	                				   var academyLocationIds = this.getCurrentAcademyLocation();
	                				   var evalPlanLevelNameItemIdField = filterForm.findField('evalPlanLevelNameId');
	                				   evalPlanLevelNameItemIdField.reset();
	                				   var evaluationLevelField = filterForm.findField('evaluationLevel');
	                				   evaluationLevelField.reset();
	                				   if(!isNullOrEmpty(obj.getValue())){
	                					   Ext.Ajax.request({
	                						   type : 'rest',
	                						   url : SERVERURL.MARKSHEET_JOB_ID_FIND_PBPS_URL,
	                						   params:{
	                							   jobId:obj.getValue()
	                						   },
	                						   method : 'GET',
	                						   success : function(resp, action) {
	                							   var respData = resp.responseText;
	                							   var encodedData=Ext.JSON.decode(respData);

	                							   if(!isNullOrEmpty(encodedData)){
	                								   var jData=encodedData[0];
	                								   fieldsData=jData;
	                								   var programField=filterForm.findField('programId');
	                								   var evaluationPlanId=filterForm.findField('evaluationPlanId');
	                								   var marksheetJobId=filterForm.findField('marksheetJob');
	                								   var evaluationTypeField=filterForm.findField('evaluationType');
	                								   marksheetJobId.setDisabled(false);
	                								   programField.setReadOnly(true);
	                								   evaluationPlanId.setDisabled(false);
	                								   evaluationPlanId.reset();
	                								   evaluationPlanId.getStore().getProxy().extraParams={
	            	                					   programId:jData.programId,
	            	                					   batchId:jData.batchId
	            	                				   };
	                								   evaluationPlanId.getStore().load();
	                								   
	                								   
	                								   programField.getStore('Academia.store.examinationcenters.reports.ExaminationReportProgramStore').getProxy().extraParams={
	                									   academyLocationIds:academyLocationIds
	                								   };
	                								   
	                								   programField.getStore('Academia.store.examinationcenters.reports.ExaminationReportProgramStore').load({
	                									   callback:function(){
	                										   programField.setValue(jData.programId);
	                									   }
	                								   });

	                								   var batchField=filterForm.findField('batchId');
	                								   var intakeYear=filterForm.findField('intakeYear');
	                								   var academicTerm=filterForm.findField('academicTerm');
	                								   batchField.enable();
	                								   batchField.setReadOnly(true);
	                								   batchField.getStore().getProxy().extraParams={
	                									   id:jData.programId,
	                								   };
	                								   batchField.getStore('Academia.store.feeandpayment.BatchSmartSearchStore').load({
	                									   callback:function(){
	                										   batchField.setValue(jData.batchId);
	                									   }
	                								   });
	                								   
	                								   var intakeYearField= filterForm.findField('intakeYear');
	                								   var academicTermField= filterForm.findField('academicTerm');
	                								   intakeYearField.getStore().load({
	                									   callback:function(){
	                										   intakeYearField.setValue(jData.intakeYearId);
	                									   }
	                								   });
	                								   academicTermField.getStore().load({
	                									   callback:function(){
	                										   academicTermField.setValue(jData.academicTermId);
	                									   }
	                								   });
	                								   var isConsolidated=null;
	                								   for(var i in marksheetJobId.getStore().data.items){
	                									   if(marksheetJobId.getStore().data.items[i].data.id==marksheetJobId.getValue()){
	                										   isConsolidated= marksheetJobId.getStore().data.items[i].data.code;
	                									   }
	                								   }
	                								   var periodIdField=filterForm.findField('periodId');
	                								   var academicTerm=filterForm.findField('academicTerm');
	                								   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                								   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                								   
	                								   if(isConsolidated=="true"){
	                									   periodIdField.reset();
	                									   periodIdField.setDisabled(true);
	                									   periodIdField.setVisible(false);
	                									   setTimeout(function(){
	                	                					   if(wheatherSchool) {
	                	                						   academicTerm.reset();
	                	                						   academicTerm.setVisible(false);
	                		                					   $this.setAllowBlank(academicTerm,true);
	                		                				   } else{
	                		                					   academicTerm.reset();
	                		                					   academicTerm.setVisible(true);
	                		                					   $this.setAllowBlank(academicTerm,false);
	                		                				   }
	                	                				   },300);
	                								   
	                								   }
	                								   else{
	                									   periodIdField.reset();
	                									   if(wheatherSchool){
	                										   periodIdField.setDisabled(true);
		                									   periodIdField.setVisible(false);
	                									   }else{
	                										   periodIdField.setDisabled(false);
		                									   periodIdField.setVisible(true);
	                									   }
	                									   periodIdField.enable();
	                									   periodIdField.setReadOnly(true);
	                									   periodIdField.getStore().getProxy().extraParams={
	                										   id:jData.batchId
	                									   };
	                									   periodIdField.getStore().load({
	                										   callback:function(){
	                											   periodIdField.setValue(jData.periodId);
	                										   }
	                									   });
	                									   
	                									   setTimeout(function(){
	                	                					   if(wheatherSchool) {
	                	                						   academicTerm.reset();
	                	                						   academicTerm.setVisible(false);
	                		                					   $this.setAllowBlank(academicTerm,true);
	                		                				   } else{
	                		                					   academicTerm.reset();
	                		                					   academicTerm.setVisible(true);
	                		                					   $this.setAllowBlank(academicTerm,false);
	                		                				   }
	                	                				   },300);
	                									   
	                									   var radioButton = obj.up('form').down('#radiogroupItemId');
	                									   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                	                				
	                									   var evalPlanLevelNameItemIdField = obj.up('form').down('#evalPlanLevelNameItemId');
	                									   evalPlanLevelNameItemIdField.reset();
	                									   evalPlanLevelNameItemIdField.setDisabled(false);
	                									   evalPlanLevelNameItemIdField.getStore().getProxy().extraParams={
	                										   whetherRemark: !isMarkEntry,
	                										   periodId : jData.periodId
	                									   };
	                									   evalPlanLevelNameItemIdField.getStore().load();
	        		                					 
	                								   }
	                								   var sectionIdField=filterForm.findField('sectionId');
	                								   sectionIdField.setDisabled(false);
	                								   sectionIdField.getStore().getProxy().extraParams={
	                									   periodId:jData.periodId
	                								   };
	                								   sectionIdField.getStore().load();
	                								   var radioButton = filterForm.findField('radiogroupId');
	                								   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                								   var studentList = filterForm.findField("admissionId");
	                								   var studentStatus = filterForm.findField("studentStatus");
	                								   studentList.reset();
		    		                				   var studentListStore=studentList.getStore();
		    		                				   studentListStore.getProxy().extraParams={
		    		                					   academyLocationIds:academyLocationIds,
		    		                					   marksheetJobId:marksheetJobId.getValue(),
		    		                					   programId:jData.programId,
		    		                					   batchId:jData.batchId,
		    		                					   periodId:jData.periodId,
		    		                					   isMarkEntry:isMarkEntry,
		    		                					   studentStatus:studentStatus.getValue()
		    		                				   };
		    		                				   studentListStore.load();
		    		                				   var courseId = filterForm.findField("courseId");
		    		                				   courseId.reset();
		    		                				   var courseListStore=courseId.getStore();
		    		                				   courseListStore.getProxy().extraParams={
		    		                					   academyLocationIds:academyLocationIds,
		    		                					   marksheetJobId:marksheetJobId.getValue(),
		    		                					   programId:jData.programId,
		    		                					   batchId:jData.batchId,
		    		                					   periodId:jData.periodId,
		    		                					   isMarkEntry:isMarkEntry
		    		                				   };
		    		                				   courseListStore.load();
	                							   }
	                						   }
	                					   });
	                					   var marksheetJobId = filterForm.findField('marksheetJobLevel');
	                					   marksheetJobId.setDisabled(false);
	                					   marksheetJobId.reset();
	                					   marksheetJobId.getStore().getProxy().extraParams = {
	                						   marksheetJobId:filterForm.findField('marksheetJob').getValue()
	                					   };
	                					   marksheetJobId.getStore().load({
	                						   callback:function(records){
	                							   marksheetJobId.setValue(records[0].data.marksheetJobId);
	                						   }
	                					   });	
	                				   } 
	                			   }
	                		   },'facultypendingmarksfilter combo[itemId=marksheetJobLevelId]':{
	                			   select:function(obj, record){
	                				   var $this = this;
	                				   var form = obj.up('form');
	                				   var academyLocationIds = this.getCurrentAcademyLocation();
	                				   var evaluationLevelIdField = form.down('#evaluationLevelId');
	                				   var evalPlanLevelNameItemIdField = form.down('#evalPlanLevelNameItemId');
	                				   var periodIdField=form.down('#periodItemId');
	                				   var evaluationPlanItemId=form.down('#evaluationPlanItemId'); 
	                				   evalPlanLevelNameItemIdField.reset();
	                				   var radioButton = form.down('#radiogroupItemId');
	                				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
									   evalPlanLevelNameItemIdField.getStore().getProxy().extraParams={
										   whetherRemark: !isMarkEntry,
										   levelName : record[0].data.code,
										   periodId:periodIdField.getValue(),
										   evaluationPlanId:evaluationPlanItemId.getValue()
									   };
									   evalPlanLevelNameItemIdField.getStore().load();
	                				   evaluationLevelIdField.clearValue();
	                				   evaluationLevelIdField.getStore().getProxy().extraParams = {
                					   };
	                				   evaluationLevelIdField.getStore().load({
                						   callback:function(records){
                							   evaluationLevelIdField.setValue(record[0].data.code);
                							   evaluationLevelIdField.setReadOnly(true);
                						   }
                					   });
	                			   }
	                		   },
	                		   'facultypendingmarksfilter combo[itemId=evaluationLevelId]':{
	                			   select:function(obj, record){
	                				   var $this = this;
	                				   var data = record[0].data.id;
	                				   var form = obj.up('form');
	                				   var academyLocationIds = this.getCurrentAcademyLocation();
	                				   var evaluationPlanField = form.down('#evaluationPlanItemId');
	                				   var evalPlanLevelNameItemIdField = form.down('#evalPlanLevelNameItemId');
		                			   var radioButton = form.down('#radiogroupItemId');
	                				   var periodId = form.down('#periodItemId');
		                			   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                				   evalPlanLevelNameItemIdField.reset();
	                				   evalPlanLevelNameItemIdField.enable();
		                				   evalPlanLevelNameItemIdField.getStore().getProxy().extraParams={
		                					   evaluationPlanId:evaluationPlanField.getValue(),
		                					   whetherRemark: !isMarkEntry,
		                					   levelName : data,
		                					   periodId: periodId.getValue(),
			                			   };
		                				   evalPlanLevelNameItemIdField.getStore().load();
	                			   }
	                		   },
	                		   
	                		   
	                	   })
	                   },
	                   loadPendingMarksEntry:function(form) {
	                	   var form = form.getForm();
	                	   var $this = this;
	                	   var marksGrid = $this.getPendingfacultymarksgrid();
	                	   var remarksGrid = $this.getFacultypendingremarksgrid();
	                	   var values = form.getValues();
	                	   var levelId = form.findField('evalPlanLevelId');
	                	   var levelOneId=null;
	                	   var levelTwoId=null;
	                	   var levelThreeId=null;
	                	   var acadLoc = Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getValue();
	                	  /* if(levelId.valueModels[0] != undefined && levelId.valueModels[0].data != undefined && !isNullOrEmpty(levelId.valueModels[0].data.code)){
	                		   if(levelId.valueModels[0].data.code==getExaminationTranslation("EVALUATION_SEQUENCE")){
	                			   levelOneId=levelId.valueModels[0].data.levelId;
	                		   }else if(levelId.valueModels[0].data.code==getExaminationTranslation("EVALUATION_SUB_TYPE")){
	                			   levelTwoId=levelId.valueModels[0].data.levelId;
	                		   }else if(levelId.valueModels[0].data.code==getExaminationTranslation("EVALUATION_TYPE")){
	                			   levelThreeId=levelId.valueModels[0].data.levelId;
	                		   }
	                	   }*/
	                	   var radioButton = form.findField('radiogroupId');
	                	   if(radioButton.getValue().isMarkEntry) {
	                		   marksGrid.getStore().getProxy().extraParams = {
	                			   evaluationPlanId:values.evaluationPlanId,
	                			   courseId:values.courseId,
	                			   programId:values.programId,
	                			   batchId:values.batchId,
	                			   periodId:values.periodId,
	                			   sectionId:values.sectionId,
	                			   isMarkEntry:true,
	                			   evaluationPlanLevelOneId: levelThreeId,
	                			   evaluationPlanLevelTwoId: levelTwoId,
	                			   evaluationSequenceId: levelOneId,
	                			   courseVariantId:values.courseVariant,
	                			   facultyId: $this.getCurrentlyLoggedInUser().id,
	                			   evaluationPlanType: values.evaluationType,
	                			   intakeYearId : values.intakeYear,
	                			   academicTermId : values.academicTerm,
	                			   marksheetJobId:values.marksheetJob,
	                			   marksheetJobLevelId:values.marksheetJobLevel,
	                			   courseVariantId:values.courseVariantId,
	                			   admissionId:values.admissionId,
	                			   evaluationPlanType:values.evaluationType,
	                			   status:values.studentStatus,
	                			   evaluationLevel : values.evaluationLevel,
	                			   evaluationLevelName : values.evalPlanLevelNameId,
	                			   academyLocationIds:acadLoc,
	                		   };
	                		   marksGrid.getStore().loadRawData(null);
	                		   $this.resetGridSetting(marksGrid);
	                		   marksGrid.getStore().load();
	                	   } else {
	                		   remarksGrid.getStore().getProxy().extraParams = {
	                			   evaluationPlanId:values.evaluationPlanId,
	                			   courseId:values.courseId,
	                			   programId:values.programId,
	                			   batchId:values.batchId,
	                			   periodId:values.periodId,
	                			   sectionId:values.sectionId,
	                			   isMarkEntry:false,
	                			   evaluationPlanLevelOneId: levelThreeId,
	                			   evaluationPlanLevelTwoId: levelTwoId,
	                			   evaluationSequenceId: levelOneId,
	                			   courseVariantId:values.courseVariant,
	                			   facultyId: $this.getCurrentlyLoggedInUser().id,
	                			   evaluationPlanType: values.evaluationType,
	                			   intakeYearId : values.intakeYear,
	                			   academicTermId : values.academicTerm,
	                			   marksheetJobId:values.marksheetJob,
	                			   marksheetJobLevelId:values.marksheetJobLevel,
	                			   courseVariantId:values.courseVariantId,
	                			   admissionId:values.admissionId,
	                			   evaluationPlanType:values.evaluationType,
	                			   status:values.studentStatus,
	                			   evaluationLevel : values.evaluationLevel,
	                			   evaluationLevelName : values.evalPlanLevelNameId,
	                			   academyLocationIds:acadLoc,
	                		   };
	                		   remarksGrid.getStore().loadRawData(null);
	                		   $this.resetGridSetting(remarksGrid);
	                		   remarksGrid.getStore().load();
	                	   }
	                   },
	                   
	                   pendingMarkRemarkFacultyFormReset : function(form){
	                	   var $this=this;
	                	   var program = form.findField("programId");
	                	   var batch = form.findField("batchId");
	                	   var period = form.findField("periodId");
	                	   var section = form.findField("sectionId");
	                	   var course = form.findField("courseId");
	                	   var evalPlan = form.findField("evaluationPlanId");
	                	   var evalplanLevel = form.findField('evalPlanLevelId');
	                	   var evalPlanLevelType = form.findField('evalPlanLevelType');
	                	   var intakeYear = form.findField('intakeYear');
	                	   var academicTerm = form.findField('academicTerm');
	                	   var marksheetJob = form.findField('marksheetJob');
	                	   var marksheetJobLevel = form.findField('marksheetJobLevel');
	                	   var courseVariantId = form.findField('courseVariantId'); 
	                	   var studentList = form.findField("admissionId");
	                	   var radioButton = form.findField('radiogroupId');
	                	   var evaluationType = form.findField('evaluationType');
	                	   
        				   var isMarkEntry=radioButton.getChecked()[0].getGroupValue();
	                	   var academyLocationIds = $this.getCurrentAcademyLocation();
	                	   
	                	   var radioButton = form.findField('radiogroupId');
	                	   var isRemarkOther = false;
	                	   program.setDisabled(false);
	                	   program.setReadOnly(false);
	                	   program.reset();
	                	   var studentList = form.findField("admissionId");
    					   var studentListStore=studentList.getStore();
        				   studentListStore.getProxy().extraParams={
        					   acultyId: $this.getCurrentlyLoggedInUser().id,
        					   academyLocationIds:academyLocationIds,
        					   isMarkEntry:isMarkEntry,
        				   };
        				   studentListStore.load();
	                	   var programStore=program.getStore();
    					   if(radioButton.getChecked()[0].getGroupValue()){
    						   programStore.getProxy().api.read=SERVERURL.EXAM_REPORT_COMMON_FILTER_URL+"?filterType=PROGRAM";
    					   }else{
    						   if(evaluationType.getValue()=='ACADEMICS'){
    							   programStore.getProxy().api.read=SERVERURL.EXAM_REPORT_COMMON_FILTER_URL+"?filterType=PROGRAM";
    						   }else{
    							   programStore.getProxy().api.read=SERVERURL.EVALUATION_PROGRAM_BY_EVALUATION_PLAN_ID;
    							   isRemarkOther= true;
    						   }
    					   }  
	                	   if(isRemarkOther){
	                		   var arr = [];
    						   arr.push(academyLocationIds);
    						   programStore.getProxy().extraParams = {
	         						academyLocationIds:arr.join(),
	         						facultyId: $this.getCurrentlyLoggedInUser().id,
	     					   };
	                	   }else{
	                		   programStore.getProxy().extraParams={
	        					   facultyId: $this.getCurrentlyLoggedInUser().id,
	        					   academyLocationIds: academyLocationIds,
	        					   whetherMarksheet:true,
	        					   evaluationType:evaluationType.getValue()
	        				   };
	                	   }
	                	   
	                	   program.getStore().load();
	                	   batch.setDisabled(true);
	                	   batch.setReadOnly(false);
	                	   batch.reset();
	                	   period.setDisabled(true);
	                	   period.setReadOnly(false);
	                	   period.reset();
	                	   section.setDisabled(true);
	                	   section.reset();
	                	   evalPlan.reset();
	                	   evalPlan.setDisabled(true);
	                	   course.reset();
	                	   intakeYear.reset();
	                	   academicTerm.reset();
	                	   marksheetJob.reset();
	                	   marksheetJobLevel.reset();
	                	   marksheetJobLevel.setDisabled(true);
	                	   courseVariantId.reset();
	                	   course.getStore().getProxy().extraParams={
        					   facultyId: $this.getCurrentlyLoggedInUser().id,
        					   academyLocationId: academyLocationIds,
        					   whetherMarksheet:true
        				   }
	                   },
	                   manageMarkEntryCourseChange : function(){
    	                	   course.getStore().load();
            				   studentList.reset();
            				   var studentListStore=studentList.getStore();
            				   studentListStore.getProxy().extraParams={
            					   academyLocationIds:academyLocationIds,
            					   isMarkEntry:isMarkEntry
            				   };
            				   marksheetJobLevel.setDisabled(true);
            				   
            				   academicTerm.reset();
            				   academicTerm.getStore().getProxy().extraParams={
            					   academyLocationIds:academyLocationIds,
            				   };
            				   academicTerm.getStore().load();
    	                   },
});