/*
 * @author Deepak.Nigam
 * 
 * This controller is used for to perform all actions related to Events Awards.    
 */
Ext.define('Academia.controller.facilitiesresources.eventAwards.EventAwardsController', {
   
	extend: 'Academia.controller.base.BaseController',
	
    models: ['facilitiesresources.resourcebooking.ResourceBookingModel', 'facilitiesresources.resourcebooking.FacilityTreeModel'],

    stores: ['personinfo.common.services.CommunityNameStore','personinfo.common.pasthistory.ActivityTypeStore',
             'facilitiesresources.resourcebooking.AllExtraCarricularActivityStore',
             'admission.manageForm.StudentWithOutAL','facilitiesresources.resourcebooking.EventNameListStore', 'feeandpayment.managebill.Student'],
    
    views: ['baselayout.contentarea.ContentPanel', 'facilitiesresources.eventAwards.EventAwardsStructure','facilitiesresources.eventAwards.EventAwardsTabStructure',
    'facilitiesresources.eventAwards.eventAwardsFilter','facilitiesresources.eventAwards.EventAwardsGrid','facilitiesresources.eventAwards.EventAwardsFormWindow',
    ],

    alias: 'widget.resourcebookingcontroller',

    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    },{
        ref: 'eventawardsgrid',
        selector: 'eventawardsgrid'
    },{
        ref: 'eventawardsformwindow',
        selector: 'eventawardsformwindow'
    },{
        ref: 'eventawardsfilter',
        selector: 'eventawardsfilter'
    }],
    config: {
    	EVENT_AWARDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EVENT_AWARDS_PRIVILEGES')
    },
    init: function(application) {
    	       
        this.control({
        	
        	'eventawardsgrid': {
            	render:function(grid) {
            		this.doAccessControlValidation(grid, this.getEVENT_AWARDS_PERMISSIONS());
            	}
        	},
        	
        	'eventawardsfilter': {
            	render:function() {
            		var eventAwardfilter = this.getEventawardsfilter();
            		var eventName = eventAwardfilter.down("#eventNameId");
                	var academyLocationId = this.getCurrentAcademyLocation();
                	var eventNameStore = eventName.getStore();
                	eventNameStore.getProxy().extraParams = {
                		acdemyLocationId:academyLocationId
                	}
                	eventNameStore.load();
            	}
            },
        	'eventawardsgrid button[itemId=btnAdd]': {
                click: function(obj){
                	var eventawardsformwindow = Ext.widget('eventawardsformwindow');
                	eventawardsformwindow.show();
                }
            },
            'eventawardsgrid button[itemId=btnEdit]': {
                click: function(obj){
                	this.editEventAwardFormWindow();
                }
            },
            'eventawardsgrid button[itemId=btnView]': {
                click: function(obj){
                	this.viewEventAwardFormWindow();
                }
            },
            'eventawardsgrid button[itemId=btnDelete]': {
                click: function(obj){
                	this.deleteEventAwardRecord();
                }
            },
            'eventawardsformwindow button[itemId=cancelButtonId]': {
            	click: function(obj){
                	eventAwardWin = this.getEventawardsformwindow();
                	eventAwardWin.close();
                }
            },
            'eventawardsformwindow': {
            	render:function() {
            		var eventAwardWin = this.getEventawardsformwindow();
            		var eventName = eventAwardWin.down("#eventNameId");
                	var academyLocationId = this.getCurrentAcademyLocation();
                	var eventNameStore = eventName.getStore();
                	eventNameStore.getProxy().extraParams = {
                		acdemyLocationId:academyLocationId
                	}
                	eventNameStore.load();
            	}
            },
            'eventawardsformwindow button[itemId=saveButtonId]': {
            	click: function(obj){
                	this.saveUpdateEventAward();
                	
                }
            },
            'eventawardsfilter button[itemId=searchBtn]': {
            	click: function(obj){
                	this.searchEventGrid();
                }
            },
            'eventawardsfilter button[itemId=resetBtn]': {
            	click: function(obj){
            		var this$ = this;
            		var formFilter = this$.getEventawardsfilter().getForm();
            		formFilter.reset();
                }
            },
            'eventawardsformwindow customcombobox[itemId=eventNameId]': {
                change: function(cmp, currentValue, oldValue, eOpts) {
                	var eventAwardId = currentValue;
    			 	this.setFromDateToDateByEventAward(cmp,eventAwardId);
                }
            }
            
        });
    },
    
    saveUpdateEventAward: function() {

    	var this$ = this;
        var form = this$.getEventawardsformwindow().down('#eventAwardsFormId');
        var grid = this$.getEventawardsgrid();
        var submitUrl = SERVERURL.EXTRA_CURRICULAR_ADD;
        
        var id = form.down('#eventAward_hidden_field').getValue();
        var version = form.down('#eventAward_version_field').getValue();
        var jsonFormatFormData = form.getForm().getValues();        
        var mainObj = new Object();
        
        if (isNullOrEmpty(id)) {
            submitUrl = SERVERURL.EXTRA_CURRICULAR_ADD;
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.EXTRA_CURRICULAR_UPDATE;
            isUpdate = true;
            mainObj.id = parseInt(id);
            mainObj.version = version;
        }
        
        var personbj = new Object();
        personbj.id = jsonFormatFormData.STUDENT_ID;
        
        var eventNamebj = new Object();
        eventNamebj.id = jsonFormatFormData.eventName;
        
        mainObj.eventId = eventNamebj;
        mainObj.community = jsonFormatFormData.community;
        mainObj.person = personbj;
        mainObj.activityType = jsonFormatFormData.activityType;
        mainObj.remarks = jsonFormatFormData.remarks;
        
        mainObj.awardDate = jsonFormatFormData.awardDate;
        mainObj.performance = jsonFormatFormData.awardReceived;
        mainObj.activityName = jsonFormatFormData.activityName;
        mainObj.isCurrentOrganization = true;
        mainObj.organization = '';
        
        var pushArray=new Array();
        pushArray.push(
        		mainObj
		);
        var encodedObj;
        
        if(isUpdate){
        	 encodedObj = Ext.encode(mainObj);
       }else{
    	    encodedObj = Ext.encode(pushArray);
       }
        
        this$.applyWindowMask(); 
        
        this$.sendSaveAjaxRequest(submitUrl, 'POST', encodedObj, function(option, success, response) {
        	this$.hideWindowMask();
        	if(success){
        		this$.getEventawardsformwindow().close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getServiceRequestTranslation('EVENT_AWARD'), getServiceRequestTranslation('EVENT_AWARD_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getServiceRequestTranslation('EVENT_AWARD'), getServiceRequestTranslation('EVENT_AWARD_ADD_SUCCESS'));
                }
    		}else{
    			this$.getEventawardsformwindow().close();
                
    			var academyLocationId = this$.getCurrentAcademyLocation();
    	    	var gridStore = grid.getStore();
    	    	
    	    	gridStore.getProxy().extraParams = {
    	    		academyLocationId:academyLocationId
    	    	}
    	    	
    	    	gridStore.load()
    			
    			//grid.getStore().reload();
    		}
        });
    },
    
    searchEventGrid: function() {
    	
    	var this$ = this;
    	
    	var formFilter = this$.getEventawardsfilter();    	
    	var grid = this$.getEventawardsgrid();
    	
    	var values = formFilter.getValues();
    	var eventName = formFilter.down('#eventNameId').getValue();
    	var personId = formFilter.down('#studentId').getValue();
    	var activityType = formFilter.down('#activityTypeId').getValue();
    	var fromDate = formFilter.down('#fromDateId').getValue();
    	var toDate = formFilter.down('#toDateId').getValue();
    	var academyLocationId = this$.getCurrentAcademyLocation();
    	var gridStore = grid.getStore();
    	
    	gridStore.getProxy().extraParams = {
    		eventNameId : eventName,
    		personId : personId,
    		activityTypeId : activityType,
    		fromDate : fromDate,
    		toDate : toDate,
    		academyLocationId:academyLocationId
    	}
    	
    	gridStore.load(); 
    	/*pdf & excel report header filter*/
    	grid.config.searchFilterForm = formFilter;
    },
    
    deleteEventAwardRecord: function() {

       var this$ = this;
       var grid = this$.getEventawardsgrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getServiceRequestTranslation('EVENT_AWARD'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.EXTRA_CURRICULAR_DELETE + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getServiceRequestTranslation('EVENT_AWARD_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getServiceRequestTranslation('EVENT_AWARD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    viewEventAwardFormWindow: function() {
    	var this$ = this;
        this$.editEventAwardFormWindow();
        var form = this$.getEventawardsformwindow().down('#eventAwardsFormId');
        form.down('#saveButtonId').setVisible(false);
        form = form.getForm();
        toggleReadOnlyFormItems(form, true);
    },
    
    editEventAwardFormWindow: function() {

        var this$ = this;
        var grid = this$.getEventawardsgrid();

        if (grid.getSelectionModel().getCount() > 0) {
        	var eventawardsformwindow = Ext.widget('eventawardsformwindow');
        	eventawardsformwindow.show();
        	var form = eventawardsformwindow.down('#eventAwardsFormId');
        	var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                
            	form.down('#eventAward_hidden_field').setValue(records.data.id);
            	form.down('#eventAward_version_field').setValue(records.data.version);
            	form.down('#activityNameId').setValue(records.data.activityName);
                
                form.down('#awardReceivedId').setValue(records.data.performance);
                if(records.data.remarks!="null"){
                	form.down('#remarksId').setValue(records.data.remarks);
                }else{
                	form.down('#remarksId').setValue("");
                }
                
                form.down('#awardDateId').setValue(dateRender(records.data.awardDate));
                
                var eventName = form.down('#eventNameId');
                eventName.getStore().load({
					  callback:function(){
						  eventName.setValue(records.data.eventId);
					  }
				  });
                
                var activityType = form.down('#activityTypeId');
                activityType.getStore().load({
					  callback:function(){
						  activityType.setValue(records.data.activityTypeId);
					  }
				  });
                
                var communityId = form.down('#communityId');
                communityId.getStore().load({
					  callback:function(){
						  communityId.setValue(records.data.communityId);
					  }
				  });
                
                var studentId = form.down('#studentId');
                studentId.getStore().getProxy().extraParams={
                	studentNameOrCode:records.data.studentName
                }
                studentId.getStore().load({
					  callback:function(){
						  studentId.setValue(records.data.studentId);
					  }
				  });
            }
        } else {
            showWarningMessage(getServiceRequestTranslation('EVENT_AWARD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    setFromDateToDateByEventAward:function(obj,eventAwardId){
		var resultViewUrl = SERVERURL.RESOURCE_BOOKING_FINDBYID;
		var form = obj.up('form');
		var awardDate = form.down('#awardDateId');
		Ext.Ajax.request({
			type: 'rest',
			url: resultViewUrl + '?id='+eventAwardId,
			method: 'GET',
			headers: {
				'Content-Type': 'application/json'
			},
			success: function(response) {
				data = Ext.decode(response.responseText);
				if(!isNullOrEmpty(data.eventDate)) {
					awardDate.setMinValue(dateRender(data.eventDate));
				} else {
					awardDate.setMinValue(new Date());
				}
			}
		});
	},
});