/*
 *  @author Akshay.Sharma
 * 
 */
Ext.define('Academia.controller.facultyportal.FacultyHomeworkAssignmentController', {
	extend: 'Academia.controller.coursetransaction.homework.HomeworkAssignmentController',
	models : ['common.IdValueCodeDataModel','genericmodels.dropdowns.EnumCombo','coursetransaction.homework.assignmentdetails.AssignmentIndividualGrid',
		'coursetransaction.homework.assignmentdetails.AssignmentDetails','coursetransaction.homework.assignmentdetails.AssignmentIndividualGrid'
		],
		stores : [],
		views : ['facultyPortal.FacultyHomeworkListStructure','facultyPortal.FacultyHomeworkAssignmentSearch'],	           

		config: {

			/* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.

			 *//**
			 * @cfg {Array} HOMEWORK_ASSIGNMENT_PERMISSIONS array (required)
			 * The array of permissions to use for Access control wise enabling and disabling buttons.
			 * @accessor
			 */
			HOMEWORK_ASSIGNMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_PRIVILEGES') ,
			STUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES') ,
			HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_DETAIL_PRIVILEGES'),
			FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PRIVILEGES'),
			PARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PRIVILEGES'),
			HOMEWORK_ASSIGNMENT_DETAIL_FORM_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_DETAIL_FORM_PRIVILEGES'),
			FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_FORM_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_FORM_PRIVILEGES')
		},

		refs : [{
			ref : 'facultyhomeworkliststructure',
			selector : 'facultyhomeworkliststructure'
		},{
			ref : 'facultyhomeworkassignmentsearch',
			selector : 'facultyhomeworkassignmentsearch'
		},{
			ref : 'evaluationdetailsgrid',
			selector : 'evaluationdetailsgrid'
		},{
			ref : 'submissiondetailsgrid',
			selector : 'submissiondetailsgrid'
		},{
			ref : 'assigndetailsallgrid',
			selector : 'assigndetailsallgrid'
		},{
			ref : 'groupsassignmentgrid',
			selector : 'groupsassignmentgrid'
		},{
			ref : 'groupsassignmentGrid',
			selector : 'groupsassignmentgrid grid'
		},{
			ref : 'assigndetailsindividualgrid',
			selector : 'assigndetailsindividualgrid'
		},{
			ref : 'uploadfile',
			selector : 'uploadfile'
		},{
			ref : 'idividualassignmentgrid',
			selector : 'idividualassignmentgrid'
		},{
			ref : 'idividualassignmentGrid',
			selector : 'idividualassignmentgrid grid'
		},{
			ref : 'assignmentdetails',
			selector : 'assignmentdetails'
		},{
			ref: 'assigndetailsgroupgrid',
			selector: 'assigndetailsgroupgrid'
		},{
			ref: 'contentPanel',
			selector: 'contentPanel'
		},{
			ref: 'evaluationDetails',
			selector: 'evaluationdetails form'
		},{
			ref: 'homeworkstructure',
			selector: 'homeworkstructure'
		}, {
			ref: 'searchresultgrid',
			selector: 'searchresultgrid[itemId=homeworklistId]'
		}, {
			ref: 'homeworkadvlisting',
			selector: 'homeworkadvlisting'
		}, {
			ref: 'homeworksearch',
			selector: 'homeworksearch'
		},{
			ref: 'homeworkassignmentsearch',
			selector: 'homeworkassignmentsearch'
		},{
			ref: 'hwstudentwise',
			selector: 'hwstudentwise'
		},{
			ref: 'hwtopicwise',
			selector: 'hwtopicwise'
		},{
			ref: 'hwsectionwise',
			selector: 'hwsectionwise'
		},{
			ref: 'homeworkliststructure',
			selector: 'homeworkliststructure'
		},{
			ref: 'uploadstudenthomeworkassignmentdocument',
			selector: 'uploadstudenthomeworkassignmentdocument'
		},{
			ref: 'homeworkassignmentdocumentgrid',
			selector: 'homeworkassignmentdocumentgrid'
		},
		{
			ref: 'bulkdocumentdownloadwindow',
			selector: 'bulkdocumentdownloadwindow'
		},{
			ref: 'evaluationdetailsgridstructure',
			selector: 'evaluationdetailsgridstructure'
		},{
			ref: 'submissiondetailsgridstructure',
			selector: 'submissiondetailsgridstructure'
		},{
			ref: 'submissiondetailsgridnew',
			selector: 'submissiondetailsgridnew'
		},{
       	 ref: 'hwassignmentgridnew',
    	 selector: 'hwassignmentgridnew'
        },{
           	 ref: 'hwassignmentgrid',
        	 selector: 'hwassignmentgrid'
        },{
			ref: 'evaluationdetailsgridnew',
			selector: 'evaluationdetailsgridnew'
		},{
			ref : 'facultyhomeworkliststructure',
			selector : 'facultyhomeworkliststructure'
		},{
			ref : 'facultyhomeworkassignmentsearch',
			selector : 'facultyhomeworkassignmentsearch'
		}],

		init : function() {
			this.control({
				'facultyhomeworkliststructure':{
					afterrender: function(structure){
						var grid = structure.down('#homeworklistId');
						var newStructure = structure.up('personinfofacultyportal');
						if(newStructure!=undefined && !isNullOrEmpty(newStructure)){
							this.getCBGridHeaderFreeze(grid,newStructure, false);
						}
					}
				},
				'facultyhomeworkassignmentsearch button[itemId=searchBtn]': {
					click: function(btn){
						var me = this;
						me.getSearchresultgrid().show();
						me.loadHomeWork(btn);
						if(Ext.isDefined(btn.up('homeworkliststructure'))){
							btn.up('homeworkliststructure').scrollBy(0,1);
							btn.up('homeworkliststructure').scrollBy(0,-1);
						}
					}
				},
				'facultyhomeworkassignmentsearch button[itemId=resetBtn]': {
					click: function(btn){
						var me = this;
						var homeworkassignmentsearch =btn.up('facultyhomeworkassignmentsearch');
						var homeworkassignmentsearchpanel = homeworkassignmentsearch.up('panel');
						homeworkassignmentsearch.destroy();
						homeworkassignmentsearchpanel.insert(0,{xtype:'facultyhomeworkassignmentsearch'});
					}
				},
				'facultyhomeworkassignmentsearch': {
					render: function(btn){
						var me = this;
						var form  = me.getFacultyhomeworkassignmentsearch();
						var academyLocationId = this.getCurrentAcademyLocation();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						var periodField = form.down('#facultyperiodId');
						var courseCombo = form.down('#faculty_course_Id');
						var courseComboStore = courseCombo.getStore();
						courseComboStore.removeAll();
						var academicTermId=null;
						if(wheatherSchool){
							periodField.hide();
						}
						courseComboStore.getProxy().extraParams = {
							academyLocationId: academyLocationId,
							facultyId: facultyId,
							//sectionType: "ALL",
							isCurrentPeriod:false,
							academicTermId:academicTermId
						};
						courseComboStore.load();
						var acdemicTerm = form.down('#facultyacademicTerm');
						var academicTermStore = acdemicTerm.getStore();
						academicTermStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for(var i in records){
										if(records[i].data.whetherCurrentAcademicTerm == 'true' || records[i].data.whetherCurrentAcademicTerm) {
											acdemicTerm.setValue(records[i].data.id);
											academicTermId=records[i].data.id ;
										}
									}
								}
							}
						});
						var assignmentName = form.down('#facultyassignment_ItemId');
						var assignmentNameStore = assignmentName.getStore();
						assignmentNameStore.getProxy().extraParams = {
							academyLocationId:academyLocationId,
							facultyId:facultyId,
							academicTermId:academicTermId
						}
						assignmentNameStore.load();
					}
				},
				'facultyhomeworkassignmentsearch customcombobox[itemId=facultyacademicTerm]': {
					change: function(obj, record){
						var me = this;
						var form = obj.up('form');
						var academicTermId = obj.getValue();
						if(academicTermId > 0) {
							this.academicTermSelection(form, academicTermId);
						}
					}
				},
				'facultyhomeworkassignmentsearch customcombobox[itemId=faculty_course_Id]': {
					change: function(obj, record){
						var me = this;
						var form = obj.up('form');
						var courseId = obj.getValue();
						if(courseId > 0) {
							var assignSectionType = obj.getStore().findRecord('courseId', courseId).data.sectionType;
							this.courseSelection(form, courseId, assignSectionType);
						}
					}
				},
				'facultyhomeworkassignmentsearch customcombobox[itemId=facultycourseVarient_Id]': {
					change: function(obj, record){
						var me = this;
						var form = obj.up('form');
						var courseVariantId = obj.getValue();
						if(courseVariantId > 0) {
							var assignSectionType = obj.getStore().findRecord('id', courseVariantId).data.sectionType;
							this.courseVariantSelection(form, courseVariantId, assignSectionType);
						}
					}
				},
				'facultyhomeworkassignmentsearch customcombobox[itemId=facultyprogramId]': {
					change: function(obj, record){
						var me = this;
						var form = obj.up('form');
						var programId = obj.getValue();
						if(programId > 0) {
							this.programSelection(form, programId);
						}
					}
				},
				'facultyhomeworkassignmentsearch customcombobox[itemId=facultybatchId]': {
					change: function(obj, record){
						var me = this;
						var form = obj.up('form');
						var batchId = obj.getValue();
						if(batchId > 0) {
							this.batchSelection(form, batchId);
						}
					}
				},
				'facultyhomeworkassignmentsearch customcombobox[itemId=facultyperiodId]': {
					change: function(obj, record){
						var me = this;
						var form = obj.up('form');
						var periodId = obj.getValue();
						if(periodId > 0) {
							this.periodSelection(form, periodId);
						}
					}
				},
				'facultyhomeworkassignmentsearch customcombobox[itemId=facultySection_ID]': {
					change: function(obj, record){
						var me = this;
						var form = obj.up('form');
						var sectionId = obj.getValue();
						if(sectionId > 0) {
							this.pbsSectionSelection(form, sectionId);
						}
					}
				},
				'facultyhomeworkassignmentsearch customcombobox#facultyassignmentType_Id': {
					select:function(obj,record){
						var me = this;
						var form = obj.up('form');
						var assignmentType = record[0].get("value");
						var courseVariantId = form.down('#facultycourseVarient_Id').getValue();
						var courseId = form.down('#faculty_course_Id').getValue();
						var academyLocationId = this.getCurrentAcademyLocation();
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var academicTermId = form.down('#facultyacademicTerm').getValue();
						var assignmentStore = this.getStore('coursetransaction.homework.AssignmentNameDropDown');
						assignmentStore.getProxy().extraParams = {	
							courseId: courseId,
							courseVariantId:courseVariantId,
							assignmentType:assignmentType,
							academicTermId:academicTermId,
							facultyId:facultyId,
							academyLocationIds:academyLocationId
						};
						assignmentStore.load();
					}
				}
			});
		},
		academicTermSelection : function(form, academicTermId) {
			var $this = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var academyLocationId = this.getCurrentAcademyLocation();
			var programField = form.down('#facultyprogramId');
			var batchField = form.down('#facultybatchId');
			var periodField = form.down('#facultyperiodId');
			var pbsSectionField = form.down('#facultySection_ID');

			var courseField = form.down('#faculty_course_Id');
			var courseVariantField = form.down('#facultycourseVarient_Id');

			var studentField = form.down('#facultystudentNameNew_ID');

			var topicTypeField = form.down('#facultytopicType_Id');
			var topicNameField = form.down('#facultytopicName_Id');

			var assignmentTypeField = form.down('#facultyassignmentType_Id');
			var assignmentNameField = form.down('#facultyassignment_ItemId');
			var assessmentTypeField = form.down('#facultyassessmentTypeItemId_topicWise');

			programField.clearValue();
			batchField.clearValue();
			periodField.clearValue();
			pbsSectionField.clearValue();

			courseField.clearValue();
			courseVariantField.clearValue();

			studentField.clearValue();

			topicTypeField.clearValue();
			topicNameField.clearValue();

			assignmentTypeField.clearValue();
			assignmentNameField.clearValue();
			assessmentTypeField.clearValue();

			programField.setDisabled(false);
			batchField.setDisabled(true);
			periodField.setDisabled(true);
			pbsSectionField.setDisabled(true);
			courseVariantField.setDisabled(true);
			topicNameField.setDisabled(true);
			

			var courseStore = courseField.getStore();
			courseStore.getProxy().extraParams = {
				academyLocationId: academyLocationId,
				facultyId: facultyId,
				//sectionType: "ALL",
				isCurrentPeriod:false,
				academicTermId:academicTermId
			};
			courseStore.load();

			var programStore = programField.getStore();
			programStore.getProxy().extraParams = {
				academyLocationIds:academyLocationId,
				academicTermId:academicTermId,
				facultyId: facultyId,
				isAllProgram:true
			}
			programStore.load();

			var studentStore = studentField.getStore();
			studentStore.getProxy().extraParams = {
				academicTermId:academicTermId,
				facultyId: facultyId,
				academyLocationId:academyLocationId
			}
			studentStore.load();
			
			var topicStore = topicNameField.getStore();
			topicStore.getProxy().extraParams = null;
			topicStore.load();

			var assignmentStore = assignmentNameField.getStore();
			 assignmentStore.getProxy().extraParams = {
				 academyLocationIds:academyLocationId,
			    facultyId: facultyId,
			    academicTermId:academicTermId
			}
			assignmentStore.load();

		},
		courseSelection : function(form, courseId, assignSectionType) {
			var $this = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var academyLocationId = this.getCurrentAcademyLocation();
			var academicTermField = form.down('#facultyacademicTerm');
			var programField = form.down('#facultyprogramId');
			var batchField = form.down('#facultybatchId');
			var periodField = form.down('#facultyperiodId');
			var pbsSectionField = form.down('#facultySection_ID');

			var courseVariantField = form.down('#facultycourseVarient_Id');

			var studentField = form.down('#facultystudentNameNew_ID');

			var topicTypeField = form.down('#facultytopicType_Id');
			var topicNameField = form.down('#facultytopicName_Id');

			var assignmentTypeField = form.down('#facultyassignmentType_Id');
			var assignmentNameField = form.down('#facultyassignment_ItemId');
			var assessmentTypeField = form.down('#facultyassessmentTypeItemId_topicWise');

			programField.clearValue();
			batchField.clearValue();
			periodField.clearValue();
			pbsSectionField.clearValue();

			courseVariantField.clearValue();

			studentField.clearValue();

			topicTypeField.clearValue();
			topicNameField.clearValue();

			assignmentTypeField.clearValue();
			assignmentNameField.clearValue();
			assessmentTypeField.clearValue();

			if(assignSectionType == 'CourseSection') {
				programField.setDisabled(true);
				batchField.setDisabled(true);
				periodField.setDisabled(true);
				pbsSectionField.setDisabled(true);
				topicNameField.setDisabled(false);
			} else {
				programField.setDisabled(false);
				batchField.setDisabled(true);
				periodField.setDisabled(true);
				pbsSectionField.setDisabled(true);
				topicNameField.setDisabled(false);
				var programStore = programField.getStore();
				programStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					academicTermId:academicTermId,
					facultyId: facultyId,
					isAllProgram:true,
					courseId:courseId
				}
				programStore.load();
			}
			courseVariantField.setDisabled(false);
			var academicTermId = academicTermField.getValue();

			var courseVariantStore = courseVariantField.getStore();
			courseVariantStore.getProxy().extraParams = {
				academyLocationId: academyLocationId,
				facultyId: facultyId,
				isCurrentPeriod:false,
				academicTermId:academicTermId,
				courseId:courseId
			};
			courseVariantStore.load({
				callback: function(records, operation, success) {
					if (success) {
						if(records.length == 1){
							courseVariantField.setValue(records[0].data.id);
						} else {
							var studentStore = studentField.getStore();
							studentStore.getProxy().extraParams = {
								academicTermId:academicTermId,
								facultyId: facultyId,
								academyLocationId:academyLocationId,
								courseId:courseId
							}
							studentStore.load();
						}
					}
				}
			});
			var topicStore = topicNameField.getStore();
			topicStore.getProxy().extraParams = {	
				courseId:courseId
			};
			topicStore.load();

			var assignmentStore = assignmentNameField.getStore();
			assignmentStore.getProxy().extraParams = {	
				courseId: courseId,
				facultyId: facultyId,
				academyLocationIds:academyLocationId,
				academicTermId:academicTermId
			};
			assignmentStore.load();
		},
		courseVariantSelection : function(form, courseVariantId, assignSectionType) {
			var $this = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var academyLocationId = this.getCurrentAcademyLocation();
			var academicTermField = form.down('#facultyacademicTerm');
			var programField = form.down('#facultyprogramId');
			var batchField = form.down('#facultybatchId');
			var periodField = form.down('#facultyperiodId');
			var pbsSectionField = form.down('#facultySection_ID');

			var courseVariantField = form.down('#facultycourseVarient_Id');

			var studentField = form.down('#facultystudentNameNew_ID');

			var topicTypeField = form.down('#facultytopicType_Id');
			var topicNameField = form.down('#facultytopicName_Id');

			var assignmentTypeField = form.down('#facultyassignmentType_Id');
			var assignmentNameField = form.down('#facultyassignment_ItemId');
			var assessmentTypeField = form.down('#facultyassessmentTypeItemId_topicWise');

			programField.clearValue();
			batchField.clearValue();
			periodField.clearValue();
			pbsSectionField.clearValue();

			studentField.clearValue();

			topicTypeField.clearValue();
			topicNameField.clearValue();

			assignmentTypeField.clearValue();
			assignmentNameField.clearValue();
			assessmentTypeField.clearValue();

			if(assignSectionType == 'CourseSection') {
				programField.setDisabled(true);
				batchField.setDisabled(true);
				periodField.setDisabled(true);
				pbsSectionField.setDisabled(true);

				var studentStore = studentField.getStore();
				studentStore.getProxy().extraParams = {
					academicTermId:academicTermId,
					facultyId: facultyId,
					academyLocationId:academyLocationId,
					courseVariantId:courseVariantId
				}
				studentStore.load();
			} else {
				programField.setDisabled(false);
				batchField.setDisabled(true);
				periodField.setDisabled(true);
				pbsSectionField.setDisabled(true);
				var academicTermId = academicTermField.getValue();
				var programStore = programField.getStore();
				programStore.getProxy().extraParams = {
					academyLocationIds:academyLocationId,
					academicTermId:academicTermId,
					facultyId: facultyId,
					isAllProgram:true,
					courseVariantId:courseVariantId
				}
				programStore.load({
					callback: function(records, operation, success) {
						if (success) {
							if(records.length == 1){
								programField.setValue(records[0].data.id);
							} else {
								var studentStore = studentField.getStore();
								studentStore.getProxy().extraParams = {
									academicTermId:academicTermId,
									facultyId: facultyId,
									academyLocationId:academyLocationId,
									courseVariantId:courseVariantId
								}
								studentStore.load();
							}
						}
					}
				});
				var assignmentStore = assignmentNameField.getStore();
				assignmentStore.getProxy().extraParams = {	
					courseVariantId: courseVariantId,
					facultyId: facultyId,
					academyLocationIds:academyLocationId,
					academicTermId:academicTermId
				};
				assignmentStore.load();
			}
		},
		programSelection : function(form, programId) {
			var $this = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var academyLocationId = this.getCurrentAcademyLocation();
			var academicTermField = form.down('#facultyacademicTerm');
			var programField = form.down('#facultyprogramId');
			var batchField = form.down('#facultybatchId');
			var periodField = form.down('#facultyperiodId');
			var pbsSectionField = form.down('#facultySection_ID');

			var courseVariantField = form.down('#facultycourseVarient_Id');

			var studentField = form.down('#facultystudentNameNew_ID');

			var topicTypeField = form.down('#facultytopicType_Id');
			var topicNameField = form.down('#facultytopicName_Id');

			var assignmentTypeField = form.down('#facultyassignmentType_Id');
			var assignmentNameField = form.down('#facultyassignment_ItemId');
			var assessmentTypeField = form.down('#facultyassessmentTypeItemId_topicWise');

			batchField.clearValue();
			periodField.clearValue();
			pbsSectionField.clearValue();

			studentField.clearValue();

			topicTypeField.clearValue();
			topicNameField.clearValue();

			assignmentTypeField.clearValue();
			assignmentNameField.clearValue();
			assessmentTypeField.clearValue();

			batchField.setDisabled(false);
			periodField.setDisabled(true);
			pbsSectionField.setDisabled(true);

			var academicTermId = academicTermField.getValue();
			var courseVariantId = courseVariantField.getValue();
			var batchStore = batchField.getStore();
			batchStore.getProxy().extraParams = {
				academicTermId:academicTermId,
				facultyId: facultyId,
				isAllProgram:true,
				courseVariantId:courseVariantId,
				programId:programId
			}
			batchStore.load({
				callback: function(records, operation, success) {
					if (success) {
						if(records.length == 1){
							batchField.setValue(records[0].data.id);
						} else {
							var studentStore = studentField.getStore();
							studentStore.getProxy().extraParams = {
								academicTermId:academicTermId,
								facultyId: facultyId,
								academyLocationId:academyLocationId,
								courseVariantId:courseVariantId,
								programId:programId
							}
							studentStore.load();
						}
					}
				}
			});
		},
		batchSelection : function(form, batchId) {
			var $this = this;
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var academyLocationId = this.getCurrentAcademyLocation();
			var academicTermField = form.down('#facultyacademicTerm');
			var programField = form.down('#facultyprogramId');
			var batchField = form.down('#facultybatchId');
			var periodField = form.down('#facultyperiodId');
			var pbsSectionField = form.down('#facultySection_ID');

			var courseVariantField = form.down('#facultycourseVarient_Id');

			var studentField = form.down('#facultystudentNameNew_ID');

			var topicTypeField = form.down('#facultytopicType_Id');
			var topicNameField = form.down('#facultytopicName_Id');

			var assignmentTypeField = form.down('#facultyassignmentType_Id');
			var assignmentNameField = form.down('#facultyassignment_ItemId');
			var assessmentTypeField = form.down('#facultyassessmentTypeItemId_topicWise');

			periodField.clearValue();
			pbsSectionField.clearValue();

			studentField.clearValue();

			topicTypeField.clearValue();
			topicNameField.clearValue();

			assignmentTypeField.clearValue();
			assignmentNameField.clearValue();
			assessmentTypeField.clearValue();

			periodField.setDisabled(false);
			pbsSectionField.setDisabled(true);

			var academicTermId = academicTermField.getValue();
			var courseVariantId = courseVariantField.getValue();
			var periodStore = periodField.getStore();
			periodStore.getProxy().extraParams = {
				academicTermId:academicTermId,
				facultyId: facultyId,
				isAllProgram:true,
				batchId:batchId
			}
			periodStore.load({
				callback: function(records, operation, success) {
					if (success) {
						if(records.length == 0){
							if(wheatherSchool) {
								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
							}
						} else if(records.length == 1){
							periodField.setValue(records[0].data.id);
							if(wheatherSchool) {
								periodField.setVisible(false);
							}
						} else {
							periodField.setVisible(true);
							var studentStore = studentField.getStore();
							studentStore.getProxy().extraParams = {
								academicTermId:academicTermId,
								facultyId: facultyId,
								academyLocationId:academyLocationId,
								courseVariantId:courseVariantId,
								batchId:batchId
							}
							studentStore.load();
						}
					}
				}
			});
		},
		periodSelection : function(form, periodId) {
			var $this = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var academyLocationId = this.getCurrentAcademyLocation();
			var academicTermField = form.down('#facultyacademicTerm');
			var programField = form.down('#facultyprogramId');
			var batchField = form.down('#facultybatchId');
			var periodField = form.down('#facultyperiodId');
			var pbsSectionField = form.down('#facultySection_ID');

			var courseVariantField = form.down('#facultycourseVarient_Id');

			var studentField = form.down('#facultystudentNameNew_ID');

			var topicTypeField = form.down('#facultytopicType_Id');
			var topicNameField = form.down('#facultytopicName_Id');

			var assignmentTypeField = form.down('#facultyassignmentType_Id');
			var assignmentNameField = form.down('#facultyassignment_ItemId');
			var assessmentTypeField = form.down('#facultyassessmentTypeItemId_topicWise');

			pbsSectionField.clearValue();

			studentField.clearValue();

			topicTypeField.clearValue();
			topicNameField.clearValue();

			assignmentTypeField.clearValue();
			assignmentNameField.clearValue();
			assessmentTypeField.clearValue();

			pbsSectionField.setDisabled(false);
			var courseVariantId = courseVariantField.getValue();
			var academicTermId = academicTermField.getValue();
			var courseVariantId = courseVariantField.getValue();
			var sectionStore = pbsSectionField.getStore();
			sectionStore.getProxy().extraParams = {
				academicTermId:academicTermId,
				facultyId: facultyId,
				isAllProgram:true,
				periodId:periodId,
				courseVariantId:courseVariantId
			}
			sectionStore.load({
				callback: function(records, operation, success) {
					if (success) {
						if(records.length == 1 && !isNullOrEmpty(courseVariantId)) {
							pbsSectionField.setValue(records[0].data.id)
						}
					}
				}
			});
			var studentStore = studentField.getStore();
			studentStore.getProxy().extraParams = {
				academicTermId:academicTermId,
				facultyId: facultyId,
				academyLocationId:academyLocationId,
				courseVariantId:courseVariantId,
				periodId:periodId
			}
			studentStore.load();
		},
		pbsSectionSelection : function(form, sectionId) {
			var $this = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var academyLocationId = this.getCurrentAcademyLocation();
			var academicTermField = form.down('#facultyacademicTerm');
			var programField = form.down('#facultyprogramId');
			var batchField = form.down('#facultybatchId');
			var periodField = form.down('#facultyperiodId');
			var pbsSectionField = form.down('#facultySection_ID');

			var courseVariantField = form.down('#facultycourseVarient_Id');

			var studentField = form.down('#facultystudentNameNew_ID');

			var topicTypeField = form.down('#facultytopicType_Id');
			var topicNameField = form.down('#facultytopicName_Id');

			var assignmentTypeField = form.down('#facultyassignmentType_Id');
			var assignmentNameField = form.down('#facultyassignment_ItemId');
			var assessmentTypeField = form.down('#facultyassessmentTypeItemId_topicWise');
			
			studentField.clearValue();

			topicTypeField.clearValue();
			topicNameField.clearValue();

			assignmentTypeField.clearValue();
			assignmentNameField.clearValue();
			assessmentTypeField.clearValue();

			pbsSectionField.setDisabled(false);
			var courseVariantId = courseVariantField.getValue();
			var academicTermId = academicTermField.getValue();
			var courseVariantId = courseVariantField.getValue();
			
			var studentStore = studentField.getStore();
			studentStore.getProxy().extraParams = {
				academicTermId:academicTermId,
				facultyId: facultyId,
				academyLocationId:academyLocationId,
				courseVariantId:courseVariantId,
				sectionId:sectionId
			}
			studentStore.load();
		}
});
