/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.hostel.managerestrictiontype.ManageRestrictionTypeController', {
	extend : 'Academia.controller.base.BaseController',

	models : [],
	
	stores : ['attendance.UserGroup','enquiry.studentDetail.GenderStore','scholarships.Status',
	          'hostel.managerestrictiontype.ManageRestrictionTypeGrid',
	          'Academia.store.common.GenderTypeStore','admission.applicationFormSale.ProgramGroupComboStore'],
	          
	views : ['hostel.managerestrictiontype.ManageRestrictionTypeStructure','hostel.managerestrictiontype.ManageRestrictionTypeSearch',
	         'hostel.managerestrictiontype.ManageRestrictionTypeGrid','hostel.managerestrictiontype.AddRestrictionType'],	           
	         
	         config: {
	        	 MANAGE_RESTRICTION_TYPE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_MANAGE_RESTRICTION_TYPE_PRIVILEGES'),
	         },
               
               refs :[{
            	   ref : 'managerestrictiontypesearch',
            	   selector : 'managerestrictiontypesearch'
               },{
            	   ref : 'managerestrictiontypegrid',
            	   selector : 'managerestrictiontypegrid'
               },{
            	   ref : 'addrestrictiontype',
            	   selector : 'addrestrictiontype'
               },{
            	   ref : 'addRestrictiontype',
            	   selector : 'addrestrictiontype form'
               },{
            	   ref : 'contentPanel',
            	   selector : 'contentPanel'
               }],

	init : function() {
		this.control({

			'managerestrictiontypegrid':{
				render:function(grid){
					this.doAccessControlValidation(grid, this.getMANAGE_RESTRICTION_TYPE_PRIVILEGES());
				}
			},

			'managerestrictiontypesearch button[itemId=searchBtn]':{
				click:function(obj){
					var form = obj.up('form');
					var values = form.getValues();
					var gender = values.gender;
					var userType = values.userType;

					var grid = this.getManagerestrictiontypegrid();
					var store = grid.getStore();

					store.getProxy().extraParams = {
						gender:gender,
						userType:userType
					};
					store.load();
				}
			},
			'managerestrictiontypesearch button[itemId=resetBtn]':{
				click:function(obj){
					var form = obj.up('form');
					form.getForm().reset();
				}
			},
			'managerestrictiontypegrid button[itemId=btnAdd]':{
				click:function(){
					this.addRestrictionType();
				}
			},
			'managerestrictiontypegrid button[itemId=btnEdit]':{
				click:function(obj){
					this.editRestrictionType(obj);
				}
			},
			'managerestrictiontypegrid button[itemId=btnView]':{
				click:function(obj){
					this.viewRestrictionType(obj);
				}
			},
			'managerestrictiontypegrid button[itemId=btnDelete]':{
				click:function(obj){
					this.deleteRestrictionType(obj);
				}
			},
			'addrestrictiontype button[itemId=saveBtn]':{
				click: function(obj){
					this.saveRestrictionType(obj);
				}
			},
			'addrestrictiontype button[itemId=cancelBtn]':{
				click: function(){
					this.resetRestrictionType();
				}
			},
	        
	        'addrestrictiontype customcombobox#usersGroup' : {
	        	  select: function(obj, record) {
	        		    var userGroupName = record[0].get("userGroupName");
	        		    this.hideOrShowWeatherFaculty(userGroupName);
	        	  }
	        }
		});
	},
	
	addRestrictionType:function(whetherEdit){
 	   /*var $this = this;
 	   var contentpanel = $this.getContentPanel();
 	   var structure = Ext.widget('addrestrictiontype');
 	   var tabName = getHostelTranslation('RESTRICTION_TYPE');
 	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
 	   var getTab=getcontroller.getTab(tabName);
 	   if(getTab!=null){
 		   contentpanel.remove(getTab, true);
 	   }
 	   openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);*/
		var $this = this;
	   	 var formWindow = $this.getAddrestrictiontype();
	   	 if (!formWindow) {
	   		 Ext.widget('addrestrictiontype');
	   		 formWindow = $this.getAddrestrictiontype();
	   	 }
	   	 if(whetherEdit == 'editMode'){
	   		formWindow.down('#restrictionTypeId').setReadOnly(true);
	   		formWindow.down('#usersGroup').setReadOnly(true);
	   		formWindow.down('#genderId').setReadOnly(true);
	   		
	   }
	   	
	   	 formWindow.show();
	},
	saveRestrictionType:function(obj){	
 	   var $this = this;
 	   var form = obj.up('form').getForm();
 	   var values = form.getValues();

 	   var manageRestrictionType = new Academia.model.hostel.managerestrictiontype.ManageRestrictionType();
 	   manageRestrictionType.set("status", values.status);
 	  /*manageRestrictionType.set("usersGroup",$this.getIdValueJson(values.usersGroup));
 	   manageRestrictionType.set("restrictionType", values.restrictionType);
 	   manageRestrictionType.set("status", values.status);
 	   manageRestrictionType.set("gender", values.gender);*/

 	   var submitUrl;
 	   if (form.findField('id').getSubmitValue() == null
 			   || form.findField('id').getSubmitValue() == "") {
 		   submitUrl = SERVERURL.RESTRICTION_TYPE_CREATE;
 	   } else {
 		  manageRestrictionType.set("id", values.id);
 		   submitUrl = SERVERURL.RESTRICTION_TYPE_UPDATE;
 	   }
 	   /*delete manageRoomType.data.feePlanRule;
 	   delete manageRoomType.data.feePlanType;
 	   delete manageRoomType.data.feePlanName;
 	   delete manageRoomType.data.feePlanStage;
 	   delete manageRoomType.data.feePlanRuleId;
 	   delete manageRoomType.data.feePlanId;*/
 	   var frm = {};
 	   if (!isNullOrEmpty(form.findField('id').getSubmitValue())) {
 		  frm.id = form.findField('id').getSubmitValue();
 	   }
 	   frm.restrictionType = values.restrictionType;
 	   frm.status = values.status;
 	   frm.gender = values.gender;
 	   frm.usersGroup = {
		   id:obj.up('form').down('customcombobox[itemId=usersGroup]').getStore().findRecord('id',values.usersGroup).data.id,
		   value:obj.up('form').down('customcombobox[itemId=usersGroup]').getStore().findRecord('id',values.usersGroup).data.userGroupName,
		   code:obj.up('form').down('customcombobox[itemId=usersGroup]').getStore().findRecord('id',values.usersGroup).data.userGroupName
 	   }; 
 	  frm.programGroup = values.programGroup;
 		   //obj.up('form').down('customcombobox[itemId=usersGroup]').getStore().findRecord('id',values.usersGroup).data;
 	   
 	   
 	   var formData = Ext.encode(frm);

 	   Ext.Ajax.request({
 		   type : 'rest',
 		   url : submitUrl,
 		   jsonData : formData,
 		   method : 'POST',
 		   success : function(form1, action) {
 			   showSuccessMessage(getHostelTranslation('ADD_RESTRICTION_TYPE'),getCommonTranslation('SUCCESS'));
 			   $this.resetRestrictionType();
 			   var grid = $this.getManagerestrictiontypegrid();
 			   grid.getSelectionModel().deselectAll(true);
 			   grid.getStore().reload();
 		   }
 	   });
	},
	editRestrictionType:function(obj){
 	   var $this = this;
 	   var grid = this.getManagerestrictiontypegrid();
 	   if (grid.getSelectionModel().getCount() > 0) {
 		   var records = grid.getSelectionModel().getSelection();
 		   var whetherEdit = 'editMode';
 		   this.addRestrictionType(whetherEdit);
 		   if (records != undefined && records != ""&& records != null) {
 			   var id = records[0].data.id;
 			   Ext.Ajax.request({
 				   type : 'rest',
 				   url : SERVERURL.RESTRICTION_TYPE_FIND_BY_ID,
 				   params : {
 					   id : id
 				   },
 				   method : 'GET',
 				   success : function(response) {
 					   var form = $this.getAddRestrictiontype();
 					   var roomRestrictionTypeForm = form.getForm();
 					   var data = Ext.decode(response.responseText);
 					   var manageRestrictionType = new Academia.model.hostel.managerestrictiontype.ManageRestrictionType(data);
 					   form.loadRecord(manageRestrictionType);
 					  if(whetherEdit=="editMode"){
 						  if(data!= undefined && data != null){
 							  if(data.usersGroup!= undefined && data.usersGroup != null){
 								  if(data.usersGroup.value==getCommonTranslation('STUDENT')){
 									  //form.down('#programGroup').setVisible(true);
 									 $this.hideOrShowWeatherFaculty(data.usersGroup.value);
 								  }
 							  }
 						  }
					   }
 					   var  usersGroup = roomRestrictionTypeForm.findField('usersGroup');
 					   var userGroupStore =  usersGroup.getStore();
 					   userGroupStore.load({
 						   callback: function(records, operation, success) {
 							   if (success) {
 								   usersGroup.setValue(data.usersGroup.id);
 							   }
 						   }
 					   });
 					   
 					  var  gender = roomRestrictionTypeForm.findField('gender');
					   var genderStore =  gender.getStore();
					   genderStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   gender.setValue(data.gender);
							   }
						   }
					   });
					   
					   var  status = roomRestrictionTypeForm.findField('status');
					   var statusStore =  status.getStore();
					   statusStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   status.setValue(data.status);
							   }
						   }
					   });
					   var  programGroup = roomRestrictionTypeForm.findField('programGroup');
					   var programGroupStore =  programGroup.getStore();
					   programGroupStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   programGroup.setValue(data.programGroup);
							   }
						   }
					   });

 				   }
 			   });
 		   }
 	   } else {
 		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	   }
	},
	viewRestrictionType:function(){
 	   this.editRestrictionType();
 	   var forms = this.getAddRestrictiontype();
 	   var form = forms.getForm();
 	   if (form) {
 		   forms.down('#saveBtn').hide();
// 		   forms.down('#cancelBtn').hide();
 		  toggleReadOnlyFormItems(form, true);
 	   }
	},
	deleteRestrictionType:function(){
		var grid = this.getManagerestrictiontypegrid();
     	 if (grid.getSelectionModel().getCount() > 0) {
     		showConfirmMessage(getHostelTranslation('MANAGE_RESTRICTION_TYPE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
     				 function(btn, text) {
     					 if (btn == 'yes') {
     						 var records = grid.getSelectionModel().getSelection()[0];
     						 var id = records.data.id;
     						 Ext.Ajax.request({
     							 method : "DELETE",
     							 type : 'rest',
     							 url : SERVERURL.RESTRICTION_TYPE_DELETE + '?id=' + id,
     							 headers : {
     								 'Content-Type' : 'application/json'
     							 },
     							 success : function(form, action) {
     								 showSuccessMessage(getHostelTranslation('MANAGE_RESTRICTION_TYPE'), getCommonTranslation('SUCCESS'));
     								 grid.getStore().reload();

     							 }
     						 });
     					 }
     				 });
     	 } else {
     		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     	 }
	},
	getIdValueJson: function(id, value,code) {
		if (id) return {
			id: id,
			value: value,
			code: code
		};
	},
	hideOrShowWeatherFaculty:function(userGroupName) {

		var academyLocationId = this.getCurrentAcademyLocation();
		var form=this.getAddRestrictiontype();
		var params = {};
		if(userGroupName == getCommonTranslation('STUDENT')){
			params.academyLocationId = academyLocationId;
			params.screenName = 'Add Restriction Type';
			params.screenMode = 'Create, Edit, and View';
			params.languageId = '1';
			var programGroupVisibility = false;
			Ext.Ajax.request({
				method : "GET",
				type : 'rest',
				url : SERVERURL.CONFIGURE_SCREEN_GRID,
				headers : {
					'Content-Type' : 'application/json'
				},
				params: params,
				success : function(f,action) {
					var dynamicProgramGroupData = Ext.JSON.decode(f.responseText);
					var field = form.down('#programGroup');
					if( !isNullOrEmpty(dynamicProgramGroupData) && dynamicProgramGroupData.length > 0 ){
						var DFRSetting = dynamicProgramGroupData[0];
						var formFieldLabel = DFRSetting.defaultLabel;
						if(!isNullOrEmpty(DFRSetting.newLabel)){
							field.setFieldLabel(DFRSetting.newLabel);
							formFieldLabel = DFRSetting.newLabel;
						}
						else{
							field.setFieldLabel(DFRSetting.defaultLabel);
						}
						
						if(DFRSetting.isVisible == true){
							programGroupVisibility = true;
							if(!isNullOrEmpty(DFRSetting.defaultValue)){
								if(field.getStore().getProxy().api != undefined && field.getStore().getProxy().api  !=null){
									field.getStore().load({
										callback : function(records, operation, success) {
											if (success) {
												var indx= this.find('id',DFRSetting.defaultValue);
												if(indx != -1){
													var id = this.getAt(indx).get('id');
													field.setValue(id);
												}
											}
										}
									});
								}
							}
							
							if(DFRSetting.isMandatory == true){
								field.labelSeparator = '';
								field.setFieldLabel(formFieldLabel+':<span class="required" style="color:red"> *</span>');
								field.allowBlank=false;
							} else {
								field.allowBlank = true;
							}
						}
						if(DFRSetting.isVisible == false){
							if(!isNullOrEmpty(DFRSetting.defaultValue)){
								field.setValue(DFRSetting.defaultValue);
							}
							if(DFRSetting.isMandatory == true){
								field.allowBlank=true;
							}
						}
					}
					if(programGroupVisibility) {
						field.setVisible(true);
					}else{
						field.setVisible(false);
					}
					form.getForm().checkValidity();
				}
			});
		}
		else{
			form.down('#programGroup').allowBlank=true;
			form.down('#programGroup').setVisible(false);
			form.down('#programGroup').reset();
			form.getForm().checkValidity();
		}
	},
	resetRestrictionType:function(){
		this.getAddrestrictiontype().close();
	}
});
