Ext.define('Academia.controller.organization.LocationStructureController', {
	extend : 'Academia.controller.base.BaseController',

	models : [ 'organization.LocationStructure', 
	           'organization.LocationAddress',
	           'organization.Address'],
	stores : [ 'organization.LocationStructureStore','Academia.store.organization.AddressTypeStore' ],
	views : [ 'organization.locations.LocationStructure',
	          'organization.locations.LocationForm',
			'organization.locations.LocationGrid',
			'organization.locations.LocationFormWindow'],

	alias : "widget.LocationController",

	refs : [ {
		ref:'grdLocationGrid',
		selector:'LocationGrid'
	},{
		ref : 'LocationForm',
		selector : 'locationform'
	},{
		ref : 'winLocationFormWindow',
		selector : 'locationformwindow'
	},{
		ref : 'LocationStructure',
		selector : 'locationformwindow form[itemId=locationAddressCombinedForm]'
	}/*,{
		ref : 'frmAddressForm',
		selector : 'locationformwindow #locationAddressCombinedForm form[itemId=addressfieldsfrm]'
	},{
		ref : 'frmLocaionForm',
		selector : 'locationformwindow #locationAddressCombinedForm form[itemId=locationfieldsfrm]'
	}*/],
	config: {
    	ORGANIZATION_STRUCTURE_LOCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_LOCATION_PRIVILEGES')
    },
	init : function(application) {
		this.control({
			
			'LocationGrid':{
				/*
				 * This function is used for load store after grid render 				 
				 */
				render:function(component,options){
					component.getStore().load();
				}
			},
			'LocationGrid[itemId=LocationGrid]': {
				render: function(grid) {
                    //this.doAccessControlValidation(grid, this.getORGANIZATION_STRUCTURE_LOCATION_PERMISSIONS());
                }
			},
			'LocationGrid button[itemId=btnAdd]' : {
				click : this.addLocation
			},
			'LocationGrid button[itemId=btnEdit]' : {
				click : Ext.bind(this.editLocation, this, [false])
			},
			'LocationGrid button[itemId=btnView]' : {
				click : Ext.bind(this.editLocation, this, [true])
			},
			'LocationGrid button[itemId=btnDelete]' : {
				click : this.deleteLocation
			},			
			'locationformwindow button[itemId=btnCancelLocationForm]' : {
				click : this.cancelLocationForm
			},
			'locationformwindow  customcombobox#genericFieldId1':{
				select : function(obj1,record){
					
					var winLocationFormWindow = this.getWinLocationFormWindow();
					var genericField2ComboBox= winLocationFormWindow.down('customcombobox#genericFieldId2');
					genericField2ComboBox.reset();

					var countryRegion1=record[0].get("id");
					var store=this.getStore('organization.CountryRegionStore1');
					store.getProxy().api.read='rest/countryRegionResource/findAllCountryRegions?pid='+countryRegion1;
					store.reload();
					
					}
				},
				'LocationForm':{
					afterrender : function(obj) {
	            		var $this = this;
	            		var winLocationFormWindow = this.getWinLocationFormWindow();
	            		//var locationForm = this.getFrmLocaionForm().getForm();
	            		var statusVal = winLocationFormWindow.down('#status');
	            		var comboStore = statusVal.getStore();
	            		comboStore.load({
	            			callback:function(record) {
	            					statusVal.setRawValue(record[0].data.name);  
	            			}
	            		});
	            	}
				},
			'locationformwindow customcombobox#countryId':{
					select : function(obj,record){
						var winLocationFormWindow = this.getWinLocationFormWindow();
					var cityComboBox= winLocationFormWindow.down('customcombobox#cityId');
					cityComboBox.reset();
					
					/*var genericField1ComboBox= this.getFrmAddressForm().down('customcombobox#cityId');
					genericField1ComboBox.reset();*/
					
					var genericField1ComboBox= winLocationFormWindow.down('customcombobox#parentCountryRegionId');
					genericField1ComboBox.reset();
					
					/*var genericField2ComboBox= this.getFrmAddressForm().down('customcombobox#genericFieldId2');
					genericField2ComboBox.reset();*/
						
					var countryId=record[0].get("id");
					 var cityStore = cityComboBox.getStore();
	                    cityStore.getProxy().extraParams = {
	                        id: countryId
	                    };
	                cityStore.load();
	                
	                var countryRegionStore = genericField1ComboBox.getStore();
                    countryRegionStore.getProxy().extraParams = {
                        cid: countryId
                    };
                    countryRegionStore.load();
                   // var form = this.getFrmAddressForm();
                	var countryCodeField = winLocationFormWindow.down("#cellCountryCode");
                	var mobileField = winLocationFormWindow.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(winLocationFormWindow.down('form'), countryCodeField, mobileField, null);
                
                    
                    /*var countryRegion2Store = genericField2ComboBox.getStore();
                    countryRegion2Store.removeAll();*/
				},
				 change: function(obj, newValue) {
					 var winLocationFormWindow = this.getWinLocationFormWindow();
	             	   var phoneCountryCode = winLocationFormWindow.down('customcombobox#phoneCountryCode');
	             	   var cellCountryCode = winLocationFormWindow.down('customcombobox#cellCountryCode');
	             	   var countryStore = winLocationFormWindow.down('customcombobox#countryId').getStore();
	             	   var val=  countryStore.getById(newValue);
	             	   phoneCountryCode.setValue(val);
	             	   cellCountryCode.setValue(val);
	             }
			},
			'locationformwindow customcombobox#parentCountryRegionId':{
	                select: function(obj1, record) {
	                	var winLocationFormWindow = this.getWinLocationFormWindow();
	                    var cityComboBox = winLocationFormWindow.down('customcombobox#cityId');
	                    cityComboBox.reset();

	                    var countryRegion1 = record[0].get("id");
//	                    var store = this.getStore('organization.CountryRegionStore1');
	                    var store = this.getStore('organization.CityByCountryRegion');
//	                    store.getProxy().api.read = SERVERURL.COUNTRY_FINDALL;
	                    store.getProxy().extraParams = {
	                        id: countryRegion1
	                    };
	                    store.reload();
	                    //var form = this.getFrmAddressForm();

	                    var countryCodeField = winLocationFormWindow.down("#cellCountryCode");
	                	var mobileField = winLocationFormWindow.down("#cellNo");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(winLocationFormWindow.down('form'), countryCodeField, mobileField, null);
	               
	                }
	            },
	            'locationformwindow customcombobox[itemId=cellCountryCode]': {
	                select: function(rowModel, record) {
	                	var winLocationFormWindow = this.getWinLocationFormWindow();
	                	//var form = this.getFrmAddressForm();
	                	var countryCodeField = winLocationFormWindow.down("#cellCountryCode");
	                	var mobileField = winLocationFormWindow.down("#cellNo");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(winLocationFormWindow.down('form'), countryCodeField, mobileField, record);
	                }
	            },
	            'locationformwindow numberfield[itemId=cellNo]': {
	                change: function(record) {
	                	var winLocationFormWindow = this.getWinLocationFormWindow();
	                	//var form = this.getFrmAddressForm();
	                	var mobileField = winLocationFormWindow.down("#cellNo");
	                	mobileField.isValid();
	                	winLocationFormWindow.down('form').getForm().checkValidity();
	                }
	            },
			'button#saveLocationButtonId' : {
				click : this.updateUser
			}
		});
	},
	

	/*
	 * This function is used for to Add/update location Details Dialog box after clicking on submit button   
	 */
			updateUser : function(model, records) {

					var winLocationFormWindow = this.getWinLocationFormWindow();
					var locationGrid = this.getGrdLocationGrid();
					//var addressFrom = this.getFrmAddressForm().getForm();
					//var locationForm = this.getFrmLocaionForm().getForm();
					
					var form = winLocationFormWindow.down('form').getForm();
					var formData = form.getValues();

					var organization= Academia.model.singleton.Organization;
					//locationForm.setValues({organizationId:organization.id});
					form.setValues({organizationId:organization.id});
					
					var submitUrl, isUpdate = false;
					
					if(form.getValues().status=='Active'||form.getValues().status) {
						form.findField('status').setValue(true);
			    	}else{
			    		form.findField('status').setValue(false);
			    	}
					
					var address = new Academia.model.organization.Address();
					form.updateRecord(address);
					//var addressValues = addressFrom.getValues();
//					if(this.validatePhone(addressValues))
//		           {
						address.set('country', this.getIdValueJson(formData.country));
						address.set('parentCountryRegion',this.getIdValueJson(formData.parentCountryRegion));
						address.set('countryRegion', this.getIdValueJson(formData.countryRegion));
						address.set('city', this.getIdValueJson(formData.city));
						address.set('addressType',this.getIdValueJson(3));
						address.set('customData',formData.customData);
						address.set('id',formData.addressPrimaryId);
						address.set('version',formData.addressVersion);
						
						
						var locationFormFieldsData = {
							"locationCode":form.getValues().locationCode,
							"name":form.getValues().name,
							"startDate":form.getValues().startDate,
							"tillDate":form.getValues().tillDate,
							"status":form.getValues().status,
							"otherLanguageName":form.getValues().otherLanguageName,
							"organizationId":form.getValues().organizationId,
							"id":form.getValues().id,
							"version":form.getValues().version
						};
						
						
						var locationAddress = new Academia.model.organization.LocationAddress();
	
						locationAddress.set("address", address.data);
						locationAddress.set("location", locationFormFieldsData);
	
						var id = form.findField('id').getSubmitValue();
						if (id == null || id == "") {
							submitUrl = SERVERURL.LOCATION_CREATE;//URL-rest/location/create
							isUpdate = false;
						} else {
							submitUrl = SERVERURL.LOCATION_UPDATE;//URL-rest/location/update
							isUpdate = true;
						}
						delete locationAddress.data.address.pincodeNew;
						var formData = Ext.encode(locationAddress.data);
				    	
						Ext.Ajax.request({
								type : 'rest',
								url : submitUrl,
								jsonData : formData,
								method : 'POST',
								success : function(form, action) {
									winLocationFormWindow.close();
									locationGrid.getSelectionModel().deselectAll();
									locationGrid.getStore().reload();
									if (isUpdate) {
										showSuccessMessage(getCommonTranslation('LOCATIONSTABTEXT'),getCommonTranslation('UPDATE_LOCATION_MSG'));//'Location updated successfully'
									} else {
										showSuccessMessage(getCommonTranslation('LOCATIONSTABTEXT'),getCommonTranslation('ADD_LOCATION_MSG'));//'Location added successfully'
									}
								}
							});
//			}
				},
	
	/*
	 * This function is used for to show Location Details Dialog box after clicking on Add Location button   
	 */
	addLocation:function(){
		this.getGrdLocationGrid().showLocationForm();
	},


	/*
	 * This function is used for to close location Details Dialog box after clicking on cancel button   
	 */
	cancelLocationForm:function(){
		this.getWinLocationFormWindow().close();
	},
	
	/*
	 * This function is used for to show location Details Dialog box with values of selected record after clicking on edit button   
	 */
	editLocation:function(isView){
						var me = this;
						var grid = me.getGrdLocationGrid();
						if (grid.getSelectionModel().getCount() > 0) {
							var AddressController = me.getController('Academia.controller.organization.AddressController');
							this.getGrdLocationGrid().showLocationForm();
							var cmpLocationStructure = me.getLocationStructure();
							var form = cmpLocationStructure.getForm();
							var winLocationFormWindow = me.getWinLocationFormWindow();
							if (isView) {
								winLocationFormWindow.down('#saveLocationButtonId').setVisible(false);
								toggleReadOnlyFormItems(form, true);
							}
							var records = grid.getSelectionModel().getSelection();
							if (records != "" && records != null && records != undefined) {
								var id = records[0].data.id;
								Ext.Ajax.request({
											type : 'rest',
											url : SERVERURL.LOCATION_FIND_BY_LOCATION_ID,//URL-rest/location/findByLocationId
											params : {
												id : id
											},
											method : 'GET',
											success : function(response) {
												
												//var addressFrom = me.getFrmAddressForm();
												//var locationForm = me.getFrmLocaionForm();
												var data = Ext.decode(response.responseText);
												var address = new Academia.model.organization.Address(data);
												winLocationFormWindow.down('form').loadRecord(address);
												winLocationFormWindow.down('#addressVersion').setValue(address.data.version);
												winLocationFormWindow.down('form').loadRecord(records[0]);
												winLocationFormWindow.down('#addressPrimaryId').setValue(address.data.id);
												//addressFrom.loadRecord(address);
												//locationForm.loadRecord(records[0]);
												winLocationFormWindow.down("#startDate").setValue(dateRender(records[0].data.startDate));
												winLocationFormWindow.down("#tillDate").setValue(dateRender(records[0].data.tillDate));

												AddressController.setAddressTypeDropDown(3,cmpLocationStructure);
												AddressController.setCountryDropDown(address.data.country.id,cmpLocationStructure);
												
												var parentCountryRegion = cmpLocationStructure.down('#parentCountryRegionId');
												var city = cmpLocationStructure.down('#cityId');
												var CountryRegionStore = parentCountryRegion.getStore();
												var cityStore = city.getStore();
												//var form = this.getFrmAddressForm();
												var countryCodeField = winLocationFormWindow.down("#cellCountryCode");
								                var mobileField = winLocationFormWindow.down("#cellNo");
								                	me.setMaximumMinimumDigitsForMobileNoValidation(winLocationFormWindow.down('form'), countryCodeField, mobileField, null);
								               
												CountryRegionStore.getProxy().extraParams = {
													cid:address.data.country.id
												};
												CountryRegionStore.load({
													callback : function(rec){
														parentCountryRegion.setValue(address.data.parentCountryRegion.id);
													}
												});
												
												cityStore.getProxy().extraParams = {
													id:address.data.parentCountryRegion.id
												};
												cityStore.load({
													callback : function(recs){
														city.setValue(address.data.city.id);
													}
												});
												
												
												
												
												//
												//AddressController.setRegion1DropDown(address.data.country.id,address.data.parentCountryRegion.id,cmpLocationStructure);
											//AddressController.setCityropDown(address.data.country.id,address.data.city.id,cmpLocationStructure);
												if(address.data.countryRegion){
													AddressController.setRegion2DropDown(address.data.parentCountryRegion.id,address.data.countryRegion.id,cmpLocationStructure);
												}
												}
										});
							}
						} else {
							showWarningMessage(getCommonTranslation('LOCATIONSTABTEXT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record.
						}
	},
	
	/*
	 * This function is used for to delete location after clicking on delete button   
	 */
	deleteLocation : function() {
		var grid=this.getGrdLocationGrid();
		var grdStore=grid.getStore();
		if(grid.getSelectionModel().getCount()>0){
			showConfirmMessage(getCommonTranslation('LOCATIONSTABTEXT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
		    	if(grid.getSelectionModel().getCount()>0){
		    		  var records=grid.getSelectionModel().getSelection();						        
				        for(var count=0;count<records.length;count++){
				        	var id="";
				        	if(records[count].get("id")!="" && records[count].get("id")!=undefined && records[count].get("id")!=null){
				        		id=records[count].get("id");
				        	}
				        	Ext.Ajax.request({
								 type: 'rest',
								 url : SERVERURL.LOCATION_DELETE,//URL-rest/location/delete						 
								 method:'DELETE',
								 headers: {
			                            'Content-Type': 'application/json'
			                        },
								 params:{
									 id:id
								 },
									success:function(form, action){
										grdStore.reload();
										showSuccessMessage(getCommonTranslation('LOCATIONSTABTEXT'),getCommonTranslation('DELETE_LOCATION_MSG'));//Location deleted successfully
									}
								});
				        }
		    	}						      
		    }
		});
		  } else {
	        	showWarningMessage(getCommonTranslation('LOCATIONSTABTEXT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	        }
	},
	 validatePhone:function(data){
	    	var isValid;
	    	if(!data.phoneNo && !data.cellNo){
	    		showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO'));
	    		isValid= false;
	    	}
	    	else{
	    		isValid=true;
	    	}
	    	return isValid;
	    },
	
	getIdValueJson:function(id,value){		
		 if (id) return {
	            id: id,
	            value: value
	        };
	},       
	setMaximumMinimumDigitsForMobileNoValidation:function(addressFrom, countryCodeField, mobileField, record){
    	var countryInfo = null;
    	if(!isNullOrEmpty(record)) {
    		countryInfo=record[0].data;
    		mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : mobileField.maxLength;
    		mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : mobileField.minLength;
    		if(!isNullOrEmpty(mobileField.getValue())) {
    			mobileField.isValid();
    			try{
    				form.getForm().checkValidity();
    	 		}
    	 		catch(e){}
    		}
    	}
    	else {
    		countryCodeField.getStore().load({
    			callback: function(records, operation, success) {
    				if (success) {
    					setTimeout(function(){
    						var countryCode=countryCodeField.getValue();
        					for(var i in records){
        						if(records[i].data.isdCode == countryCode){
    								countryInfo = records[i].data;
    								mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : mobileField.maxLength;
    								mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : mobileField.minLength;
    								if(!isNullOrEmpty(mobileField.getValue())) {
    									mobileField.isValid();
    									try{
    				        				form.getForm().checkValidity();
    				        	 		}
    				        	 		catch(e){}
    								}
    								break;
    							}
        					}
		            	},1000);
    				}
    			}
    		});
    	}
    }
});
