/*
 * Controller of the statutory accounting which handles the update, add functions
 * @Author Akshay.Kalbhor
 */
Ext.define('Academia.controller.organization.StatutoryAccounting', {
    extend: 'Academia.controller.base.BaseController',
    requires: ['Academia.utilities.date.DateHelper'],
    views: ['organization.statutoryAccounting.StatutoryAccountingStructure',
            'organization.statutoryAccounting.StatutoryAccountingTree',
            'organization.statutoryAccounting.StatutoryAccountingForm',
            'organization.statutoryAccounting.LinkedALPGridSA',
            'organization.statutoryAccounting.LinkedALPStructureWindowSA',
            'organization.statutoryAccounting.ALPToChildGridSA',
            'common.NestedJsonCombo'
           ],
    models: ['organization.OrganizationUnit'],
    stores: ['common.UsersComboStore', 'organization.StructureTreeStore','organization.AllocatedALPs','feeandpayment.FeeCurrencyStore'],

    refs: [{
        ref: 'stataccformwindow',
        selector: 'stataccformwindow'
    },{
        ref: 'stataccform',
        selector: 'stataccformwindow form'
    }, {
        ref: 'statacctree',
        selector: 'statacctree'
    }, {
        ref: 'stataccstructure',
        selector: 'stataccstructure'
    },
    /*
     * references for the popup
     */
    {
    	ref: 'linkedALPWindow',
    	selector: 'linkedalpstructurewindowsa'
    }, {
    	ref: 'linkedALPGrid',
    	selector: 'linkedalpgridsa'
    }, {
    	ref: 'alpToChildGrid',
    	selector: 'alptochildgridsa'
    }],
    config: {
    	ORGANIZATION_STRUCTURE_STATUTORY_ACCOUNTING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_STATUTORY_ACCOUNTING_PRIVILEGES')
    },
    init: function() {
        this.control({
        	'statacctree[itemId=statacctree]':{
        		render: function(tree){
        			this.doAccessControlValidation(tree, this.getORGANIZATION_STRUCTURE_STATUTORY_ACCOUNTING_PERMISSIONS());
        			this.disableMoreActionPivileges(tree,this.getORGANIZATION_STRUCTURE_STATUTORY_ACCOUNTING_PERMISSIONS());
        		}
        	},
        	'statacctree': {
        		render : this.renderTreeStructure
        	},
            'stataccformwindow form button[itemId=statAccSaveButton]': {
                click: this.saveISU
            },
            'stataccformwindow form button[itemId=statAccCancelButton]': {
                click: function () {
                    this.closeTreeFormWindow();
                }
            },
            'stataccTree [panel=treePanel]': {
                nodedragover: function(targetNode, position, dragData) {
                }
            },
            'statacctree button[itemId=btnAdd]': {
        	click: this.addChild
            },
            'statacctree button[itemId=btnEdit]': {
        	click: this.updateNode
            },
            'statacctree button[itemId=btnView]': {
        	click: this.viewFormWindow
            },
            'stataccformwindow datefield[itemId=tillDate]': {
        	change: function( this$, newValue, oldValue, eOpts) {
        	    if(oldValue !== undefined)
        		this.validateDate( this$, newValue, oldValue, eOpts);
                }
            },
            'stataccformwindow form customcombobox#currencyCombo' : {
				render : function(component, options) {
		    		if(!component.store.items){
		    			component.store.load();
		            }
				}
			},
            /*
             * Listening to the application level event which is fired from the tree drag and drop 
             * event of the StatutoryAccountingTree.js.
             * 
             * @event: statutoryAccountingTreeDrag
             * @param: node is the selected node.
             * @param: data {refer the documentation of drag drop of tree}
             * @param: overModel{refer the documentation of drag drop of tree}
             * @param: dropPosition{refer the documentation of drag drop of tree}
             * @param: dropPosition{refer the documentation of drag drop of tree}
             */
            '*': {
            	statutoryAccountingTreeDrag:function(node, data, overModel, dropPosition, dropHandlers) {
            		this.moveNode(node, data, overModel, dropPosition, dropHandlers);
            	}
            },
            'statacctree #spBtnMoreActionssa menuitem[itemId=viewLinkedALPsa]': {
                click: function() {
                    this.showLinkedAlpWindowSA();
                }
            },
            'linkedalpstructurewindowsa linkedalpgridsa' : {
            	render: function(this$, eOpts) {
            		this.loadGridOnTreeSelection(this$);   
            	}
            }
        
        });
	this.callParent(arguments);
    },
    
    renderTreeStructure:function(){
    	var tree=this.getStatacctree();
    	var form=this.getStataccstructure().getForm();
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.ORG_SUP_UNIT_FIND_SAUID,
             method: 'GET',
             success: function(response) {
            	 form.setValues({organizationSupervisoryUnit:response.responseText});
            	 var store=tree.getStore();
         			store.getProxy().extraParams = {
                       id: response.responseText
                   };
         		  store.reload();
             }
         });
    	 
    },
    validateDate: function( this$, newValue, oldValue, eOpts) {
	
	var tree=this.getStatacctree();
	var fieldName = this$.name;
	var changedValue = Ext.Date.format(newValue, CONSTANTS.DATE_FORMAT);
	var originalValue = Ext.Date.format(oldValue, CONSTANTS.DATE_FORMAT);
	if(tree.getSelectionModel().getCount()>0){
    	var statAccRecord=tree.getSelectionModel().getSelection();
    		if(statAccRecord[0].hasChildNodes()) {
    		    if(Academia.utilities.date.DateHelper.validateParentDateWithChildDates(statAccRecord[0].childNodes, changedValue, fieldName)) {
    			this.getStataccform().down('#tillDate').setValue(originalValue);
    		    }
    		}
	}
    },
          
    closeTreeFormWindow: function() {
	this.getStataccformwindow().un(this);
        this.getStataccformwindow().close();
    },
    
    /*
     * @method: method to Show the linkedAlpStructure grids
     * if there are any selected record in the tree.
     */
    showLinkedAlpWindowSA: function() {
    	var tree=this.getStatacctree();
		if(tree.getSelectionModel().getCount()>0){
		    var linkedAlpWindow = this.getLinkedALPWindow();
			if(!linkedAlpWindow) {
			    Ext.widget('linkedalpstructurewindowsa');
			    linkedAlpWindow = this.getLinkedALPWindow();
			}
			linkedAlpWindow.show();
		}
		else {
			showWarningMessage(getCommonTranslation('STATACCMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
 
    showFormWindow: function() {
        var formWindow = this.getStataccformwindow();
        if (!formWindow) {
            Ext.widget('stataccformwindow');
            formWindow = this.getStataccformwindow();
        }
        formWindow.show();
        var value=this.getUserId();
        this.getStataccform().getForm().setValues({organizationSupervisoryUnit: value});
    },
    
    getUserId : function(){
    	var form=this.getStataccstructure().getForm();
	return form.findField('organizationSupervisoryUnit').getSubmitValue();
	},
    viewFormWindow:function(){
	this.updateNode(true);
    },
    
    setReadOnlyForAll: function(form,readOnly) {
        Ext.suspendLayouts();
        form.getFields().each(function(field) {
          field.setReadOnly(readOnly);
        });
        Ext.resumeLayouts();
      },
      
      /*
       * @method: method to load the data into the grids on basis of the selected record from the tree.
       */
     loadGridOnTreeSelection: function(this$) {
    	var tree=this.getStatacctree();
    	/*
    	 * Load the records only if any record is selected.
    	 */
    		if(tree.getSelectionModel().getCount()>0) {
    		    var record=tree.getSelectionModel().getSelection()[0];
    		    var orgUnitId = record.data.id;
    		    var allocatedALPToOthersStore = this$.items.items[0].getStore();
    		    var alpToChildrenStore = this.getAlpToChildGrid().items.items[0].getStore();
    		    allocatedALPToOthersStore.getProxy().extraParams = {
    		           organizationUnitId: orgUnitId
    		    };
    		    allocatedALPToOthersStore.load();
    		    alpToChildrenStore.getProxy().extraParams = {
    		           organizationUnitId: orgUnitId
    		    };
    		    alpToChildrenStore.load();
    		} 
    },

    addChild: function() {
	var tree=this.getStatacctree();
	if(tree.getSelectionModel().getCount()>0){
	    this.showFormWindow();
	    var statAccRecord=tree.getSelectionModel().getSelection();
            var stataccformwindow = this.getStataccformwindow();
            if (statAccRecord[0].parentNode != null) {
                stataccformwindow.down('#parentOrganizationHiddenId').setValue(statAccRecord[0].getId());
            }
            var parentOrganization = statAccRecord[0].getData().text;
            stataccformwindow.down('#parentISU').setValue(parentOrganization);
            stataccformwindow.down('#parentItemId').setValue(statAccRecord[0].getId());
	} else {
		showWarningMessage(getCommonTranslation('STATACCMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
    },

    /*
     * Function to update the tree data into the window form.
     */
    updateNode: function(isViewOnly) {
	
	var this$ = this;
	var tree=this.getStatacctree();
	if(tree.getSelectionModel().getCount()>0){
        	var statAccRecord=tree.getSelectionModel().getSelection()[0];
        	/*
                 * check for restricting the user from doing edit operation on the root node 
                 */
                if( statAccRecord.data.text !== getCommonTranslation('ROOTNODEFORTREE')) {
                
                    var id = statAccRecord.getId();
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.MGMTACCOUNTINGFINDBYID,
                        method:'GET', //the method HTTP to use for the request
                    	params:{
                        	id: id
                        },
                        success: function(response) {
	                    	this$.showFormWindow();
	                            var data = JSON.parse(response.responseText);
	                            var organizationUnit = new Academia.model.organization.OrganizationUnit(data);
	                            var parent = organizationUnit.get('parentOrganizationUnit');
	                            this$.getStataccform().getForm().loadRecord(organizationUnit);
	                            this$.getStataccform().down("#startDate").setValue(dateRender(data.startDate));
	                            this$.getStataccform().down("#tillDate").setValue(dateRender(data.tillDate));
	                            
	                            if (parent != null) {
	                                this$.getStataccform().down('#parentISU').setValue(organizationUnit.get('parentOrganizationUnit').value);
	                            } else {
	                                this$.getStataccform().down('#parentISU').setValue(getCommonTranslation('ROOTNODEFORTREE'));
	                            }
	                            
	                         //   this$.getStataccform().down('#ownerId').setValue(organizationUnit.get('owner').value);
	                            this$.getStataccform().down('#parentItemId').setValue(statAccRecord.parentNode.data.id);
	                            if(isViewOnly===true) {
	                    	    this$.getStataccformwindow().down('#statAccSaveButton').setVisible(false);
	                    	    var form = this$.getStataccform();
	                    	    form=form.getForm();
	                    	    this$.setReadOnlyForAll(form,true);
	                    	} else{
	                    	    this$.getStataccformwindow().down('#startDate').setReadOnly(true);
	                    	}
	                            
                        }
                    });
                } else {
                	tree.getSelectionModel().deselectAll(true);
                	showWarningMessage(getCommonTranslation('STATACCMESSAGEBOXTITLE'), getCommonTranslation('NOOPERATIONSONROOT'));
                    }
	} else {
		showWarningMessage(getCommonTranslation('STATACCMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
    },

    /*
     * Function to save the edited data.
     */
    saveISU: function() {
	this$ = this;
        var stataccform = this.getStataccform();
        var tree=this.getStatacctree();
        var statAccRecord=tree.getSelectionModel().getSelection()[0];
        var parentStartDate = '';
        var parentTillDate = '';
        var submitUrl = '';
        var parent = false;
        var organizationUnit = new Academia.model.organization.OrganizationUnit();
        var id = stataccform.getForm().findField('id').getSubmitValue();
        if (id == null || id == "") {
            submitUrl = SERVERURL.MGMTACCOUNTINGCREATE;
            if(statAccRecord.raw.model) {
        	parentStartDate = statAccRecord.raw.model.startDate;
        	parentTillDate = statAccRecord.raw.model.tillDate;
            }else {
        	/*
        	 * set parent as true if the node to be added is below root node
        	 */
        	parent = true;
            }
            
        } else {
            parentStartDate = statAccRecord.raw.model.startDate;
            parentTillDate = statAccRecord.raw.model.tillDate;
            submitUrl = SERVERURL.MGMTACCOUNTINGUPDATENODE;
        }
        var childStartDate = stataccform.getForm().findField('startDate').getValue();
        var childTillDate = stataccform.getForm().findField('tillDate').getValue();
        var parentId = stataccform.getForm().findField('parentId').getSubmitValue();
        var parentValue = stataccform.getForm().findField('parentOrganizationUnit').getSubmitValue();
        var parentOrganizationUnit = {
            id: parentId,
            value: parentValue
        };

        if (parent || Academia.utilities.date.DateHelper.validateDateForISU(parentStartDate, parentTillDate, childStartDate, childTillDate)) {
            /*
             * Code to load the form data into organizationUnit model.
             */
            stataccform.updateRecord(organizationUnit);
            /*
             * If the node to be added is below the "root" then do not set a parentOrganizationUnit
             */
            if(parent) {
        	delete organizationUnit.data.parentOrganizationUnit;
            }
            if(!parent) {
        	organizationUnit.set('parentOrganizationUnit', parentOrganizationUnit);
            }
            /*
             * Code to format the dates according to the dmy format and set it back in the obj.
             */ 
            organizationUnit.set('owner', {
                id: organizationUnit.get('owner')
            });
         //   var startdt = Ext.Date.format(organizationUnit.data.startDate, CONSTANTS.DATE_FORMAT);
            organizationUnit.data.startDate = organizationUnit.data.startDate;
        //    var tilldt = Ext.Date.format(organizationUnit.data.tillDate, CONSTANTS.DATE_FORMAT);
            organizationUnit.data.tillDate = organizationUnit.data.tillDate;
            var statAccValues = Ext.encode(organizationUnit.data);
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: statAccValues,
                method: 'POST',
                success: function() {
                    this$.closeTreeFormWindow();
                    tree.getStore().load();
                    tree.getSelectionModel().deselectAll(true);
                    showSuccessMessage(getCommonTranslation('STATACCMESSAGEBOXTITLE'), getCommonTranslation('SAVEDSUCCESSFULLY'));
                }
            });
        }
    },
    
    moveNode: function(node, data, overModel, dropPosition, dropHandlers) {
        var orgUnit = data.records[0].raw.model;
        var childStartDate = orgUnit.startDate;
        var childTillDate = orgUnit.tillDate;
        
        var parentStartDate = '';
        var parentTillDate = '';
        var parent = false;
        if(overModel.raw.model) {
            parentStartDate = overModel.raw.model.startDate;
            parentTillDate = overModel.raw.model.tillDate;
        }else {
    	
    	 /* set parent as true if the node to be added is below root node*/
    	 
    	parent = true;
        }
        
        var tree=this.getStatacctree();
        dropHandlers.wait = true;
        if (parent || Academia.utilities.date.DateHelper.validateDate(parentStartDate, parentTillDate, childStartDate, childTillDate)) {
            var parentOrganizationUnit = {
                id: overModel.data.id,
                value: overModel.data.text
            };
            orgUnit.parentOrganizationUnit = parentOrganizationUnit;
            var values = Ext.encode(orgUnit);
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.MGMTACCOUNTINGUPDATENODE,
                jsonData: values,
                success: function() {
                    dropHandlers.processDrop();
                    var store=tree.getStore();
        		     store.reload();
        		  
                },
                failure: function() {

                }
            });
        } else {
            dropHandlers.cancelDrop();
        }
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var tree = this.getStatacctree();
   		var Button = tree.down("#spBtnMoreActionssa");//itemId of split button
       	
   		Button.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MOREACTIONS') {
           		if(!isNullOrEmpty(Button)){
           			Button.setVisible(true);//enable more action button
           		}        		
           	}
       	});
       }
});
