/**
 * @author trupti.paoneker
 * 
 * This controller is used for Bank Master related Actions. 
 */
Ext.define('Academia.controller.othermasters.bankmaster.BankMasterController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['othermasters.bankmaster.BankMasterStore', 'common.AcademyStore', 
             'common.AcademyLocationByAcademyId', 'organization.CityStore',
             'organization.CountryRegionStore', 'organization.CountryRegionStore1',
             'common.CountryStore', 'othermasters.bankmaster.AddNewContactPersonStore'],

    views: ['othermasters.bankmaster.BankMaster', 'othermasters.bankmaster.BankMasterGrid', 
            'othermasters.bankmaster.BankMasterFormWindow', 'othermasters.bankmaster.AddNewContactPersonFormWindow', 
            'othermasters.bankmaster.AddNewContactPersonGrid'],

    alias: "widget.bankMastercontroller",

    refs: [{
        ref: 'bankmasterGrid',
        selector: 'bankmastergrid'
    }, {
        ref: 'winbankmasterformwindow',
        selector: 'bankmasterformwindow'
    }, {
        ref: 'frmbankmasterformwindow',
        selector: 'bankmasterformwindow form[itemId=bankMasterForm]'
    }, {
        ref: 'bankMaster',
        selector: 'bankmaster'
    }, {
        ref: 'bankmasterformwindow',
        selector: 'bankmasterformwindow'
    }, {
        ref: 'contactpersonGrid',
        selector: 'contactpersongrid'
    }, {
        ref: 'wincontactpersonformwindow',
        selector: 'contactpersonformwindow'
    }, {
        ref: 'contactPersonForm',
        selector: 'contactpersonformwindow form[itemId=addbankContactform]'
    }],
    config: {
        BANK_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('BANK_MASTER_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	'bankmasterformwindow': {
        		render: function(component, option){
        			component.down('#locationId').getStore().getProxy().extraParams = {
        				id:this.academicLocationId
        			};
        		}
        	},
            'bankmastergrid': {
                render: function(component, options) {
                    component.getStore().load();
                }
            },
            'bankmastergrid button[itemId=btnAdd]': {
                click: this.addBankMaster
            },
            'bankmastergrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editBankMaster,
                this, [false])
            },
            'bankmastergrid button[itemId=btnView]': {
                click: Ext.bind(this.editBankMaster,
                this, [true])
            },
            'bankmastergrid[itemId=bankMasterGrid]':{
            	 render: function(grid) {
                     this.doAccessControlValidation(grid, this.getBANK_MASTER_PERMISSIONS());
                 }
            },

            'bankmasterformwindow button[itemId=btnSaveBankMasterForm]': {
                click: this.CheckDefaultBank
            },
            'bankmasterformwindow button[itemId=btnCancelBankMasterForm]': {
                click: this.cancelBankMasterForm
            },
            'contactpersonformwindow button[itemId=btnSaveContactForm]': {
                click: this.SaveContactDetailsForm
            },
            'contactpersonformwindow button[itemId=btnCancelContactForm]': {
                click: this.cancelContactDetailsForm
            },
            'contactpersongrid button[itemId=btnAdd]': {
                click: this.addContact
            },
            'contactpersongrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editContact,
                this, [false])
            },
            'contactpersongrid button[itemId=btnDelete]': {
                click: this.deleteContactPersonDetails
            },
            'contactpersongrid button[itemId=btnView]': {
                click: Ext.bind(this.editContact,
                this, [true])
            },
            "contactpersongrid[itemId=contactPersonGrid]":{
            	render: function(grid) {
                    //this.doAccessControlValidation(grid, this.getBANK_MASTER_PERMISSIONS());
                }
            },
            /**
             * ** Load store when render combos on
             * dialog box****
             */
            'contactpersonformwindow combo': {
                render: function(component, options) {
                    component.getStore().load();
                }
            },
            'bankmasterformwindow combo': {
                render: this.loadCombo
            },
            'contactpersonformwindow form[itemId=addbankContactform] combo[itemId=country]': {
                select: function(combo, records, eOpts) {
                    this.loadcityParentRegionStore(
                    combo, records, eOpts);
                }
            },
            'contactpersonformwindow combo[itemId=genericFieldId1]': {
                select: function() {
                    this.loadCountryRegionStore;
                }
            },
            'bankmaster grid[itemId=bankMasterGrid]': {
                select: this.loadContactGrid
            },
            'bankmasterformwindow combo[itemId=academyId]': {
                select: function(obj, record) {
                    var academyId = record[0].get("id");
                    obj.nextSibling().clearValue();
                    var store = this.getStore('common.AcademyLocationByAcademyId');
                    store.getProxy().extraParams = {
                        id: academyId
                    };
                    store.load();
                },


            }
        });
    },

    /**
     * This function is used for to show Bank Master Details Dialog box after clicking on Add button 
     */
    addBankMaster: function() {
        var winBankMasterFormWindow = Ext.widget('bankmasterformwindow');
        winBankMasterFormWindow.show();
    },

    /** 
     * This function is used for to show contact Details Dialog box after clicking on Add button
     */
    addContact: function() {
        var grid = this.getBankmasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            this.getContactpersonGrid().showContactPersonDetailsForm();
            if (records != "" && records != null && records != undefined) {}
        } else {
        	showWarningMessage(getCommonTranslation('BANK'),
            getCommonTranslation('PLEASE_SELECT_BANK'));
        }

    },

    loadContactGrid: function(grid, rec) {

        var this$$ = this;
        var bankId = rec.data.id;
        var grid = this$$.getContactpersonGrid();
        var store = grid.getStore();

        store.getProxy().extraParams = {
            bankId: bankId
        };
        store.load();

    },

    /**
     * This function is used for to cancel contact Details Dialog box after clicking on Cancel button
     */
    cancelContactDetailsForm: function() {
        this.getWincontactpersonformwindow().close();

    },

    editContact: function(isView) {
        var this$$ = this;
        var grid = this$$.getContactpersonGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            this$$.showContactDetailForm();
            var record = grid.getSelectionModel().getSelection()[0];
            if (record != "" && record != null && record != undefined) {
                var data = record.data;
                var contactPersonForm = this$$.getContactPersonForm();
                var rec = new Academia.model.othermasters.bankmaster.AddNewContactPersonModel(
                data);
                contactPersonForm.loadRecord(rec);
                var id = data.id;
                var bankId = data.bankId;

                this$$.getContactPersonForm().getForm().setValues({
                    bankId: bankId
                });
                this$$.getContactPersonForm().getForm().setValues({
                    contactPersonId: id
                });

                var form = this$$.getContactPersonForm().getForm();

                var countryRef = this$$.getContactPersonForm().down('combo#country');
                var cityRef = this$$.getContactPersonForm().down('combo#cityId');
                var parentRegionRef = this$$.getContactPersonForm().down('combo#genericFieldId1');
                var countryRegionRef = this$$.getContactPersonForm().down('combo#genericFieldId2');

                var countryValue = data.address.country.id;
                var cityValue = data.address.city.id;
                var parentId = data.address.parentCountryRegion.id;
                // if(!isNullOrEmpty(countryRegionRef)){
                // var countryRegionId =
                // data.address.countryRegion.id;

                countryRef.setValue(countryValue);
                this$$.loadComboValue(countryRef, countryValue);
                this$$.loadComboValue(cityRef, cityValue,
                new Object({
                    id: countryValue
                }));
                this$$.loadComboValue(parentRegionRef,
                parentId, new Object({
                    cid: countryValue
                }));
                // this$$.loadComboValue(countryRegionRef,countryRegionId,new
                // Object({pid:parentId}));

                form.setValues(data);
                form.setValues(data.address);

                if (isView) {
                    contactPersonForm.down('#btnSaveContactForm').setVisible(
                    false);
                    toggleReadOnlyFormItems(contactPersonForm.getForm(), true);
                }
            }

        } else {
        	showWarningMessage(
            getCommonTranslation('CONTACT_PERSON'),
            getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * This function is used for to save contact form Details after clicking on save button
     * 
     */
    SaveContactDetailsForm: function() {
        var this$ = this;
        var refAddContactForm = this$.getContactPersonForm();
        var formData = refAddContactForm.getValues();

        var address = new Academia.model.organization.Address(formData);
        var grid = this$.getContactpersonGrid();
        var bankGrid = this$.getBankmasterGrid();
        var record = bankGrid.getSelectionModel().getSelection();
        var id = record[0].data.id;
        var arr=[];
        var finalData = new Object();
        finalData.address = address.data;
        finalData.contactName = formData.contactName;
        finalData.designation = formData.designation;
        finalData.personName = formData.personName;
        formData.bankId = id;
        finalData.bankId = formData.bankId;
        finalData.id = formData.contactPersonId;
    	if (!isNullOrEmpty(finalData.address.customData)) {
      	   	 address.set('customData', finalData.address.customData);
      	   	
      	   	}else
      	   	address.set('customData', arr);
    	
        delete finalData.address.addressType;
        delete finalData.address.countryRegion;
        delete finalData.address.pincodeNew;

        if (this$.validatePhone(formData)) {

            var submitUrl, isUpdate = false;
            var addContactField = refAddContactForm.down('#AddContact_hiddenfield');

            if (addContactField.getSubmitValue() == null || addContactField.getSubmitValue() == "" || addContactField.getSubmitValue() === undefined) {
                submitUrl = SERVERURL.BANK_CONTACT_CREATE,
                isUpdate = false;
            } else {
                submitUrl = SERVERURL.BANK_CONTACT_UPDATE,
                isUpdate = true;
            };

            var methodName = '';
            if (isUpdate) {
                methodName = 'PUT';
            } else {
                methodName = 'POST';
            }

            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: finalData,
                method: methodName,

                success: function(form, action) {
                    this$.cancelContactDetailsForm();
                    grid.getStore().reload();

                    grid.getSelectionModel().deselectAll();

                    if (isUpdate) {
                    	showSuccessMessage(
                        getCommonTranslation('CONTACT_PERSON'),
                        getCommonTranslation('UPDATE_BANK_CONTACT_MSG'));
                        
                    } else {
                    	showSuccessMessage(
                        getCommonTranslation('CONTACT_PERSON'),
                        getCommonTranslation('ADD_BANK_CONTACT_MSG'));
                       
                    }
                }

            });
        }
    },

    loadCombo: function(combo) {
        var store = combo.getStore();
        store.load();
    },

    loadContactCombo: function(combo) {
        var store = combo.getStore();
        store.load();
    },

    loadcityParentRegionStore: function(combo, records, eOpts) {

        var this$$ = this;
        var id = records[0].data.id;
        var comboref = this$$.getContactPersonForm().down("#cityId");
        var parentcombo = this$$.getContactPersonForm().down("#genericFieldId1");
        var store = comboref.getStore();
        var parentStore = parentcombo.getStore();

        store.load({
            params: {
                id: id
            }

        });
        parentStore.load({
            params: {
                cid: id
            }

        });
    },

    loadCountryRegionStore: function(combo, records, eOpts) {
        var id = records[0].data.id;
        var countryRef = this.getContactPersonForm().down("#genericFieldId2");
        var coutryStore = countryRef.getStore();
        coutryStore.load({
            params: {
                pid: id
            }
        });
    },

    /**
     * This function is used to load dependent combo
     */

    loadComboValue: function(combo, value, param) {

        var store = combo.getStore();
        if (!store.items) {
            store.load({
                params: param,
                callback: function(records, operation,
                success) {
                    if (success) {
                        combo.setValue(value);
                    }
                }
            });
        }
    },
    /**
     * this function is used to get id of combo
     */
    getComboId: function(combo) {

        var id = combo.getValue();
        var obj = new Object();
        obj.id = id;
        return obj;
    },
    /**
     * this function is used to set values in form data
     */
    getObj: function(ref) {
        var obj = new Object();
        for (var i = 0; i < 4; i++) {
            obj = this.getComboId(ref);
        }
        return obj;
    },
    /**
     * This function is used to validate phone number
     * 
     * @param data
     * @returns {Boolean}
     */
    validatePhone: function(data) {
        var isValid;
        if (!data.phoneNo && !data.cellNo) {
            showErrorMessage(
            getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),
            getCommonTranslation('ADD_PHONE_NO'));
            isValid = false;
        } else {
            isValid = true;
        }
        return isValid;
    },

    /** 
     * This function is used for to show Bank Master Details Dialog box with values of selected record after clicking on edit button
     * 
     */
    editBankMaster: function(isView) {
        var me = this;
        var grid = me.getBankmasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            this.academicLocationId = records[0].data.academy.id;
            me.showBankMasterForm();
            if (records != "" && records != null && records != undefined) {
                var frmbankmasterformwindow = me.getFrmbankmasterformwindow();
				
				var bnkForm = frmbankmasterformwindow.getForm()
				var merchantId = bnkForm.findField('merchantId');
				if(records[0].data.merchantId!=null){
					merchantId.setDisabled(true);	
				}
				
                var rec = new Academia.model.othermasters.bankmaster.BankMasterModel(
                records[0].data);
                frmbankmasterformwindow.loadRecord(rec);
                grid.getStore().reload();
                if (isView) {
                    var winbankmasterformwindow = me.getWinbankmasterformwindow();
                    winbankmasterformwindow.down('#btnSaveBankMasterForm').setVisible(false);
                    toggleReadOnlyFormItems(
                    frmbankmasterformwindow.getForm(),
                    true);
                }
            }
        } else {
        	showWarningMessage(
            getCommonTranslation('BANK'),
            getCommonTranslation('PLEASE_SELECT_RECORD')); 
        }
    },

   /*
    * 
    * This function is used to check the validation for the bank default master
    * 
    * 
    * 
    */
    
    CheckDefaultBank:function(){

        var this$ = this;
        var winbankmasterformwindow = this$.getWinbankmasterformwindow();
        var grid = this$.getBankmasterGrid();
        winbankmasterformwindow.down("#btnSaveBankMasterForm").setDisabled(true);
        var frmbankmasterformwindow = this$.getFrmbankmasterformwindow();
        var submitUrl, isUpdate = false;
        var bankmaster = frmbankmasterformwindow.down('#bankMaster_hidden_field');
       
        	/*V2D-276845  - check for online bank account*/
        if(frmbankmasterformwindow.getValues().isOnlineBankAccount==true){
        	 if (bankmaster.getSubmitValue() == null || bankmaster.getSubmitValue() == "" || bankmaster.getSubmitValue() === undefined) {
                 submitUrl = SERVERURL.CHECK_WHETHER_ONLINE_BANK_ACCOUNT, // URL-rest/bank/create
                 isUpdate = false;
             } else {
                 submitUrl = SERVERURL.CHECK_WHETHER_ONLINE_BANK_ACCOUNT, // URL-rest/bank/update
                 isUpdate = true;
             }
             var jsonFormatFormData = Ext.encode(frmbankmasterformwindow.getValues());

           	Ext.Ajax.request({
                   type: 'rest',
                   url: submitUrl,
                   jsonData: jsonFormatFormData,
                   method: 'POST',
                   success: function(response) {
                   	if(response.responseText=="0"){
                   		  showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('DEFAULT_BANK_ACCOUNT_FOR_ONLINE_PAYMENT'), function(btn, text) {
                   	            if (btn == 'yes') {
                   	            	this$.SaveBankMasterForm();
                   	            }
                   	        });
                   		}else{
                   			this$.SaveBankMasterForm();
                   			}
                   }
               });
           	
        }else  if(frmbankmasterformwindow.getValues().defaultBank==true){
      	  if (bankmaster.getSubmitValue() == null || bankmaster.getSubmitValue() == "" || bankmaster.getSubmitValue() === undefined) {
              submitUrl = SERVERURL.CHECK_WHETHER_DEFAULT_BANK, // URL-rest/bank/create
              isUpdate = false;
          } else {
              submitUrl = SERVERURL.CHECK_WHETHER_DEFAULT_BANK, // URL-rest/bank/update
              isUpdate = true;
          }
          var jsonFormatFormData = Ext.encode(frmbankmasterformwindow.getValues());
          if(frmbankmasterformwindow.getValues().defaultBank==true && frmbankmasterformwindow.getValues().bankStatus=="off")
          	{
          	 if (isUpdate) {
          	        var grid = this$.getBankmasterGrid();
          	        if (grid.getSelectionModel().getCount() > 0) {
          	            var records = grid.getSelectionModel().getSelection();
          	             var isActiveBank= records[0].data.bankStatus;
          	            if(isActiveBank=="off")
          	            	{
          	            	  showWarningMessage(
          	                          getCommonTranslation('ALERT'),
          	                          getCommonTranslation('ADD_INACTIVE_BANK_DEFAULT_BANK'));
          	            	}
          	            else
          	            	{
          	         		 showWarningMessage(
          	                         getCommonTranslation('ALERT'),
          	                         getCommonTranslation('UPDATE_INACTIVE_BANK_DEFAULT_BANK'));
          	            	}
          	           
          	        }
                } else {
              	  showWarningMessage(
                    getCommonTranslation('ALERT'),
                    getCommonTranslation('ADD_INACTIVE_BANK_DEFAULT_BANK'));
                }
          	}
          else{
          	Ext.Ajax.request({
                  type: 'rest',
                  url: submitUrl,
                  jsonData: jsonFormatFormData,
                  method: 'POST',
                  success: function(response) {
                  	if(response.responseText=="0"){
                  		  showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('DEFAULT_CONFIRM_MESSAGE'), function(btn, text) {
                  	            if (btn == 'yes') {
                  	            	this$.SaveBankMasterForm();
                  	            }
                  	        });
                  		}else{
                  			this$.SaveBankMasterForm();
                  			}
                  }
              });
          	}
    }else{
        	if (bankmaster.getSubmitValue() == null || bankmaster.getSubmitValue() == "" || bankmaster.getSubmitValue() === undefined) {
                submitUrl = SERVERURL.CHECK_WHETHER_ONLINE_BANK_ACCOUNT, // URL-rest/bank/create
                isUpdate = false;
            } else {
                submitUrl = SERVERURL.CHECK_WHETHER_ONLINE_BANK_ACCOUNT, // URL-rest/bank/update
                isUpdate = true;
            }
            var jsonFormatFormData = Ext.encode(frmbankmasterformwindow.getValues());
          	Ext.Ajax.request({
                  type: 'rest',
                  url: submitUrl,
                  jsonData: jsonFormatFormData,
                  method: 'POST',
                  success: function(response) {
                  
                  			this$.SaveBankMasterForm();
                  			
                  }
              });
          	
        }
        },
    
    /**
     *  This function is used for to save Bank Master Details after clicking on save button 
     */
    
    
    
    SaveBankMasterForm: function() {
        var this$ = this;
        var winbankmasterformwindow = this$.getWinbankmasterformwindow();
        var grid = this$.getBankmasterGrid();
        var frmbankmasterformwindow = this$.getFrmbankmasterformwindow();
        var submitUrl, isUpdate = false;
        var bankmaster = frmbankmasterformwindow.down('#bankMaster_hidden_field');
        if (bankmaster.getSubmitValue() == null || bankmaster.getSubmitValue() == "" || bankmaster.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.BANK_MASTER_CREATE, // URL-rest/bank/create
            isUpdate = false;
            
        } else {
            submitUrl = SERVERURL.BANK_MASTER_UPDATE, // URL-rest/bank/update
            isUpdate = true;
        }
        var jsonFormatFormData = Ext.encode(frmbankmasterformwindow.getValues());
        	
        	Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: jsonFormatFormData,
                method: 'POST',
                success: function(form, action) {
					if(form.responseText=='-1'){
						showWarningMessage(getCommonTranslation('BANK'),getCommonTranslation('DUPLICATE_MERCHANT_ID'));
					}
					else{
						winbankmasterformwindow.close();
                    grid.getStore().reload();
                    //this$.resetPageSetting(grid.getStore());
                    grid.getSelectionModel().deselectAll();
                    
                    var contactpersonGrid = this$.getContactpersonGrid();
                    var store = contactpersonGrid.getStore();
                    store.removeAll();

                    if (isUpdate) {
                    	showSuccessMessage(
                        getCommonTranslation('BANK'),
                        getCommonTranslation('UPDATE_BANK_MASTER_MSG'));
                    } else {
                    	showSuccessMessage(
                        getCommonTranslation('BANK'),
                        getCommonTranslation('ADD_BANK_MASTER_MSG'));
                    }
					}
                }

            });

        
    },

    /**
     * This function is used for to close bank master Details Dialog box after clicking on cancel button 
     */
    cancelBankMasterForm: function() {
        this.getWinbankmasterformwindow().close();
    },

    showBankMasterForm: function() {
        var bankmasterformwindow = this.getBankmasterformwindow();
        if (isEmpty(bankmasterformwindow)) {
            bankmasterformwindow = Ext.widget('bankmasterformwindow');
        }
        bankmasterformwindow.show();
    },
    showContactDetailForm: function() {
        var contactpersonformwindow = this.getContactPersonForm();
        if (isEmpty(contactpersonformwindow)) {
            contactpersonformwindow = Ext.widget('contactpersonformwindow');
        }
        contactpersonformwindow.show();
    },
    deleteContactPersonDetails: function() {
        var grid = this.getContactpersonGrid();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('DELETE_CONTACT_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                        if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                    id = records[count].get("id");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    method: 'DELETE',
                                    url: SERVERURL.BANK_CONTACT_DETAILS_DELETE + '?id=' + id,
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                       showWarningMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_CONTACT_DEATILS_MSG'));
                                       grdStore.reload();
                                       subGrid.getStore().reload();
                                    },
                                    failure: function(form, action) {
                                        showWarningMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
                                    }
                                });
                            }
                        }
                    }
        	});
        } else {
        	showWarningMessage(getCommonTranslation('CONTACT_PERSON'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    }
});
