/**
 * @author trupti.paoneker
 * 
 * This controller is used for Certificate Master related Actions.   
 */
Ext.define('Academia.controller.othermasters.certificatemaster.CertificateMasterController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['othermasters.certificatemaster.CertificateMasterStore', 'othermasters.certificatemaster.CertificateTypeComboStore',
             'othermasters.certificatemaster.DynamicDocumentTypes', 'othermasters.certificatemaster.CertificateApplicableToStore'],

    views: ['othermasters.certificatemaster.CertificateMaster', 'othermasters.certificatemaster.CertificateMasterGrid', 
            'othermasters.certificatemaster.CertificateMasterFormWindow'],

    alias: "widget.certificateMastercontroller",

    refs: [{
        ref: 'certificatemasterGrid',
        selector: 'certificatemastergrid'
    }, {
        ref: 'wincertificatemasterformwindow',
        selector: 'certificatemasterformwindow'
    }, {
        ref: 'frmcertificatemasterformwindow',
        selector: 'certificatemasterformwindow form[itemId=certificateMasterForm]'
    }, {
        ref: 'certificateMaster',
        selector: 'certificatemaster'
    }, {
        ref: 'certificatemasterformwindow',
        selector: 'certificatemasterformwindow'
    }],
    config: {
    	CERTIFICATE_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CERTIFICATE_MASTER_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'certificatemastergrid': {
                render: function(component, options) {
                    component.getStore().load();
                }
            },
            'certificatemastergrid button[itemId=btnAdd]': {
                click: this.addCertificateMaster
            },
            'certificatemastergrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editCertificateMaster, this, [false])
            },
            'certificatemastergrid button[itemId=btnView]': {
                click: Ext.bind(this.editCertificateMaster, this, [true])
            },
            'certificatemasterformwindow button[itemId=btnSaveCertificateMasterForm]': {
                click: this.saveCertificateMasterForm
            },
            'certificatemasterformwindow button[itemId=btnCancelCertificateMasterForm]': {
                click: this.cancelCertificateMasterForm
            },
            'certificatemastergrid[itemId=certificateMasterGrid]': {
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getCERTIFICATE_MASTER_PERMISSIONS());
                }
            },
            'certificatemasterformwindow checkbox[itemId=isAppliableForFaculty]': {
                change: this.loadCertificateTypeCombo
            },
            'certificatemasterformwindow combo[itemId=certificateApplicableTo]':{
            	select: function(combo, records, eOpts){
            		var certificateCategoryId = combo.up('form').down('#certificateCategoryId');
            		var dynamicDocTypeId = combo.up('form').down('#dynamicDocTypeId');
                    certificateCategoryId.reset();
                    
            	},
                change :function(combo, records, eOpts){
                	var certificateApplicableTo = combo.getValue();
                  var certificateCategoryId = combo.up('form').down('#certificateCategoryId');
                  certificateCategoryId.store.clearFilter(true);
                  certificateCategoryId.store.filter({
                      filterFn: function(record) {
                          var flag = true;
                          if ((certificateApplicableTo == 'FACULTY' || certificateApplicableTo == 'ALL') && record.get('name') == 'PROGRAM') {
                              flag = false;
                          } else {
                              flag = true;
                          }
                          return flag;
                      }
                  });
                  
                }
            },
           'certificatemasterformwindow combo[itemId=certificateCategoryId]':{
        	   change :function(combo){
        		   var dynamicDocCombo = combo.up('form').down('#dynamicDocTypeId');
        		   var configLevel= null ;
        		   var cmbValue = combo.getValue();
        		   dynamicDocCombo.reset();
        		   if(cmbValue === 'PROGRAM'){
        			   configLevel = 'PROGRAM_BATCH_SEAT_TYPE_LEVEL' ;
        		   }else if(cmbValue === 'COURSES'){
        			   configLevel ='COURSE_LEVEL' ;
        		   }else if(cmbValue === 'COMMUNITY'){
        			   configLevel ='COMMUNITY_LEVEL' ;
        		   }else if(cmbValue === 'OTHER'){
        			   configLevel ='ACADEMY_LOCATION_LEVEL' ;
        		   }else if(cmbValue === 'HOSTEL_LEAVE'){
        			   configLevel ='ACADEMY_LOCATION_LEVEL' ;
        		   }
        		   if(!isNullOrEmpty(cmbValue)){
        			   dynamicDocCombo.getStore().load({
        				   params :{
        					   configLevel : configLevel
        				   }
        			   }); 
        		   }else{
        			   dynamicDocCombo.getStore().removeAll();
        		   }
        	   }
              }
        });
    },

    /*
     * This function is used for to show certificate Master Details Dialog box after clicking on 
     */
    addCertificateMaster: function() {
        var winCertificateMasterFormWindow = Ext.widget('certificatemasterformwindow');
        winCertificateMasterFormWindow.show();
        var store = winCertificateMasterFormWindow.down("#certificateCategoryId").getStore();
        store.reload();        
        
    },

    /*
     * This function is used for to show Service Master Details Dialog box with values of selected record after clicking on edit button   
     */
    editCertificateMaster: function(isView) {
        var me = this;
        var grid = me.getCertificatemasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            me.showCertificateMasterForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var frmcertificatemasterformwindow = me.getFrmcertificatemasterformwindow();
               var isSequenceRequired=  records[0].raw.isSequenceRequired;
                sequenceCheckbox = frmcertificatemasterformwindow.down('#isSequenceRequired');
                 if(isSequenceRequired==true){
             sequenceCheckbox.setValue(isSequenceRequired);
            }else{
	          sequenceCheckbox.setValue(isSequenceRequired);
           }

                var rec = new Academia.model.othermasters.certificatemaster.CertificateMasterModel(records[0].data);
                frmcertificatemasterformwindow.down('#certificateCode').setReadOnly(true);
                frmcertificatemasterformwindow.loadRecord(rec);
                var roleField = frmcertificatemasterformwindow.down('#roleIdsItemId');
                var roleStore = roleField.getStore();
                roleStore.load({
        			callback: function(records, operation, success) {

        				
        				if (success && !isNullOrEmpty(rec.data.roleIds)) {
    						var rolesArray= [];
    						if(records.length > 0){
    							rec.data.roleIds.forEach(function(role){
    								var result = records.filter(function (obj) {
    									  return obj.data.id === role.id;
    									})[0];
    								rolesArray.push(result);
    							});
    							roleField.setValue(rolesArray);
    						}
    					}
        			}
        		});
//                grid.getStore().reload();
                if (isView) {
                    var wincertificatemasterformwindow = me.getWincertificatemasterformwindow();
                    wincertificatemasterformwindow.down('#btnSaveCertificateMasterForm').setVisible(false);
                    toggleReadOnlyFormItems(frmcertificatemasterformwindow.getForm(), true);
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*     * This function is used for to save Certificate Master Details after clicking on save button    
     */
    saveCertificateMasterForm: function() {
        var this$ = this;
        var wincertificatemasterformwindow = this$.getWincertificatemasterformwindow();
        var saveBtn = wincertificatemasterformwindow.down('#btnSaveCertificateMasterForm');
        saveBtn.disable();
        var grid = this$.getCertificatemasterGrid();
        var frmcertificatemasterformwindow = this$.getFrmcertificatemasterformwindow();
        var submitUrl, isUpdate = false;
        var certificatemaster = frmcertificatemasterformwindow.down('#certificateMaster_hidden_field');
        if (certificatemaster.getSubmitValue() == null || certificatemaster.getSubmitValue() == "" || certificatemaster.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.CERTIFICATE_MASTER_CREATE,
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.CERTIFICATE_MASTER_UPDATE,
            isUpdate = true;
        }
        var formData = frmcertificatemasterformwindow.getValues();
        var roleIds=[];
        
        if(!isNullOrEmpty(formData.roles) && formData.roles.length > 0) {
        	for(var i=0;i<formData.roles.length; i++) {
        		if(!isNullOrEmpty(formData.roles[i])) {
        			roleIds.push({id: formData.roles[i].data.id});        			
        		}
        	}
        }
        formData.roleIds = roleIds;
        delete formData.roles
        var jsonFormatFormData = Ext.encode(formData);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
                wincertificatemasterformwindow.close();
                Ext.getBody().unmask();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();

                if (isUpdate) {
                	showSuccessMessage(getCommonTranslation('UPDATE_CERTIFICATE_MASTER_MSG'), getCommonTranslation('UPDATE_CERTIFICATE_MASTER_MSG'));
                } else {
                	showSuccessMessage(getCommonTranslation('ADD_CERTIFICATE_MASTER_MSG'), getCommonTranslation('ADD_CERTIFICATE_MASTER_MSG'));
                }
            }

        });
    },

    /*
     * This function is used for to close Certificate master Details Dialog box after clicking on cancel button   
     */
    cancelCertificateMasterForm: function() {
        this.getCertificatemasterformwindow().close();
    },

    showCertificateMasterForm: function() {
        var certificatemasterformwindow = this.getCertificatemasterformwindow();
        if (isEmpty(certificatemasterformwindow)) {
            certificatemasterformwindow = Ext.widget('certificatemasterformwindow');
        }
        certificatemasterformwindow.show();
    },
    
    loadCertificateTypeCombo:function(checkbox,newValue,oldValue) {
    	var combo= checkbox.up('form').down('#certificateCategoryId');
    	var store=combo.getStore();
    	if(newValue) {
    		store.each(function(record) {
    			if(record !=undefined) {
                    if(record.get("name") ==='PROGRAM') {
                            store.remove(record);
                    }
            }      
    		});
    	} else {
    	    store.load();
    	}
    	combo.reset();
    }

});
