/**
 * This controller is used for the student, faculty feedback & survey functionality.
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.common.PersonFeedbackSurveyController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    stores: ['personinfo.common.feedback.FeedbackReceiveStore', 'personinfo.common.feedback.FeedbackGivenStore',
             'personinfo.common.feedback.ActiveSurveyStore'],

    views: ['personinfo.common.feedback.FeedbackReceivedGrid', 'personinfo.common.feedback.FeedbackReceiveForm', 
            'personinfo.common.feedback.FeedbackGivenGrid', 'personinfo.common.feedback.FeedbackGivenForm',
            'personinfo.common.feedback.SurveyQuickSearchPanel', 'personinfo.common.feedback.SurveyHistory',
            'personinfo.common.feedback.ActiveSurveyGrid','personinfo.common.feedback.ActiveSurveyForm'],


    /**
     *  Load store after grid renderer
     *  @param gridItemId
     *  @param url
     */

    loadGridStore: function(gridItemId, url) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var personObj = this$.getPersonObj();
        var grid = personProfile.down(gridItemId);
        if (grid) {
            var personId = personObj["id"];
            var store = grid.getStore();
            store.getProxy().api.read = url;
            store.load({
                params: {
                    personId: personId
                }
            });

            store.on('beforeload', function(store, operation) {
                var personObj = this$.getPersonObj();
                var personId = personObj["id"];
                store.proxy.extraParams = {
                    personId: personId
                };
            });
        }
    },

    /**
     * show person common window
     * @param informationType
     * @param formItemId
     */
    showPersonCommonWindow: function(informationType, formItemId) {
        var this$ = this;
        var title = null,
            xtypeForm = null;
        var formWindow = this$.getPersonCommonWindow();
        if (!formWindow) {
            switch (informationType) {

            case 'FEEDBACK_GIVEN':
                { //Feedback Given
                    title = getPersonModuleTranslation('FEEDBACK_GIVEN_DETAILS');
                    xtypeForm = 'feedbackgivenform';
                    break;
                }
            case 'FEEDBACK_RECEIVE':
                { //Feedback Received
                    title = getPersonModuleTranslation('FEEDBACK_RECEIVED_DETAILS');
                    xtypeForm = 'feedbackreceiveform';
                    break;
                }
            case 'ACTIVE_SURVEY':
            { //Feedback Received
                title = getPersonModuleTranslation('ACTIVE_SURVEY');
                xtypeForm = 'activesurveyform';
                break;
            }
            default:
                {
                    break;
                }
            }

            formWindow = Ext.widget('personcommonwindow', {
                title: title,
                itemId: 'personCommonWindow',
                items: [{
                    xtype: xtypeForm,
                    itemId: formItemId
                }]
            });
        }

        formWindow.show();
    },
    /**
     * view person common window
     */
    viewPersonCommonWindow: function(form) {

        if (form) {
            form.down('#submitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },

    /**
     * Close person common window
     */
    closePersonCommonWindow: function() {
        var this$ = this;
        this$.getPersonCommonWindow().close();
    },

    /**
     * View feedback given history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewFeedbackGiven: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonFeedbackGivenForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('FEEDBACK_GIVEN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * View feedback received history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewFeedbackReceived: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonFeedbackReceiveForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('FEEDBACK_RECEIVED_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /*
     * This function is used for to load data in Survey History grid
     */
    loadGridAndSearchUsers: function(searchForm) {
        var jsonFormatFormData = this.createJsonFormat(searchForm);
        var ResultGrid = this.getSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.SURVEY_HISTORY_VIEW);
        ResultGrid.initialize(SERVERURL.EXECUTEQUICKSEARCH, resultViewUrl, jsonFormatFormData);
    },
    /*
     * This function is used for to create json for loading data in Survey History grid
     */
    createJsonFormat: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.SURVEY_HISTORY_BASIC_CONFIGCODE;

        formValues = searchForm.getValues();        
        
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }

        values.searchCriterias = searchcriteria;
        return values;
    },
    /**
     * View Active Survey
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewActiveSurvey: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonActiveSurveyForm();
            this$.viewPersonCommonWindow(form);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('ACTIVE_SURVEY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    }
});