/**
 * This controller is used for the student, faculty Payment & Refund functionality.
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.common.PersonPaymentRefundController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    stores: ['personinfo.common.paymentandrefund.PendingBillStore', 'personinfo.common.paymentandrefund.PaymentReceivedHistoryStore', 
             'personinfo.common.paymentandrefund.PostDatedChequeStore', 'personinfo.common.paymentandrefund.RefundablePaymentStore', 
             'personinfo.common.paymentandrefund.RefundHistoryStore', 'personinfo.common.paymentandrefund.PaymentMadeHistoryStore',
             'feeandpayment.managebill.billview.BillViewForPC','feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetails',
             'feeandpayment.payment.BillHeaderAdjustmentDetails','feeandpayment.adjustment.BillReceivable',
             'examinationcenters.IsTemplateMappedStore','feeandpayment.adjustment.BillReceivableOnline','personinfo.common.paymentandrefund.PendingCreditStore',
             'feeandpayment.adjustment.OnlinePaymentBillLevelGridStore','feeandpayment.managebill.BillTypeForBill','feeandpayment.managebill.BillFeeStatusStore',
             'personinfo.common.paymentandrefund.PendingAllBillStore','Academia.store.feeandpayment.receipts.ReceiptHeaderForApplicant', 'feeandpayment.adjustment.BillReceivableApplicant',
             'feeandpayment.adjustment.BillReceivableApplicantHead','feeandpayment.managebill.BillTypeForCredit','feeandpayment.managebill.CreditSettlementStatusStore',
             'personinfo.common.paymentandrefund.FundingAndMonitoringProgramStore','personinfo.common.paymentandrefund.FundingBodyStore',
             'personinfo.common.paymentandrefund.NonRegulatedFeeFlagStore','personinfo.common.paymentandrefund.FundingLengthStore','personinfo.common.paymentandrefund.FundingCompletionStore',
             'personinfo.common.paymentandrefund.EquOrLowerQualificationStore','personinfo.common.paymentandrefund.FinancialSupportProgramStore',
             'personinfo.common.paymentandrefund.FinancialSupportBatchStore','personinfo.common.paymentandrefund.FinancialSupportPeriodStore','personinfo.common.paymentandrefund.AccessAndParticipationFlagStore',
             'personinfo.common.paymentandrefund.FinancialSupportTypeStore'],

    views: ['personinfo.common.PersonCommonWindow', 'personinfo.common.paymentandrefund.PendingBillsGrid','personinfo.common.paymentandrefund.CreditNoteGridForStudentPortal', 
            'feeandpayment.payment.BillHeaderAdjustmentDetailsGridWindow', 'personinfo.common.paymentandrefund.PaymentReceivedHistoryGrid', 
            'personinfo.common.paymentandrefund.RefundablePaymentGrid', 'personinfo.common.paymentandrefund.RefundHistoryGrid',
            'personinfo.common.paymentandrefund.PostDatedChequeGrid', 'personinfo.common.paymentandrefund.PaymentMadeHistoryGrid',
            'feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetailsGridWindow','feeandpayment.payment.StudentPaymentHeaderInstrumentAdjustmentDetailsGridWindow',
            'feeandpayment.managebill.billview.BillViewForPCStructure', 'feeandpayment.managebill.billview.BillViewForPCGrid',
            'personinfo.common.paymentandrefund.OnlinePaymentGrid','studentPortal.OnlinePaymentStructureForPortal',
            'studentPortal.OnlinePaymentGridForPortal','studentPortal.OnlinePaymentBillLevelGridForPortal',
            'personinfo.common.paymentandrefund.PendingBillStructure','personinfo.common.paymentandrefund.PendingBillsFilter',
            'personinfo.common.paymentandrefund.ReceiptGridForApplicant',
			'personinfo.common.paymentandrefund.OnlinePaymentBillLevelApplicant',
			'personinfo.common.paymentandrefund.OnlinePaymentApplicantStructure',
			'feeandpayment.payment.ReceiptSettlementHeadWindow','personinfo.common.paymentandrefund.PendingBillsGridForStudentPortal','personinfo.common.paymentandrefund.FundingAndMonitoringGrid',
			'personinfo.common.paymentandrefund.FundingAndMonitoringDetailsWin','personinfo.common.paymentandrefund.FinancialSupportGrid','personinfo.common.paymentandrefund.FinancialSupportDetailsWin'
            ],
     config:{
        MANAGE_BILL_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_BILL_PRIVILEGES'),
     },
          /*  refs: [{
                ref: 'pendingbillsfilter',
                selector: 'pendingbillsfilter'
            }],*/
            
          /*  init: function(application) {
            	var this$ = this;
            	this$.callParent(arguments); 
            	this.control({
            		
            		'pendingbillsfilter button[itemId=searchBtn]':{
            			click:this.loadPendingBillGrid
            		},
            		
            	});
            },*/
            
            /*loadPendingBillGrid : function(obj,records){
           	 var $this=this;
           	 var pendingBillsFilter=$this.getPendingbillsfilter();
           	 var formValues = pendingBillsFilter.getValues();
           	 var grid=$this.getPendingbillsgrid();
           	 //var gridStore=grid.getStore();
           	 var billType=pendingBillsFilter.down("#billTypes");
           	 var billStatus=pendingBillsFilter.down("#billStatus");
           	 var portalId = $this.getCurrentLoggedPortalId();
           	 var logInUser = $this.getCurrentlyLoggedInUser();
           	 var StudentId= null;
           	 var userType = null;           	 
           	 if(portalId == 3){
           		userType = 'STUDENT',
           		StudentId =logInUser.id;
           	 }
           	 var store = $this.getStore('personinfo.common.paymentandrefund.PendingAllBillStore');
           	 store.getProxy().extraParams={
           		billedUserType:userType,
           		raiseBillType:billType.value,
           		billStatus:billStatus.value,
           		//academyLocationId:formValues.fileStatus,
           		id:StudentId,
           		whetherDeleted:false
           	 }
           	 $this.resetPageSetting(store);
           	 store.load();
            },*/
    /**
     *  Load store after grid renderer
     *  @param gridItemId
     *  @param url
     */

    loadGridStore: function(gridItemId, url, params) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
		// toggleReadOnlyFormItems(grid, true);
        if(this.getCurrentLoggedPortalId()==2 || grid.itemId == "pendingBillsGridId"){
        	grid.columns[3].hidden = true;
        }
        if (grid) {
            var store = grid.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = params;
            store.load({ 
        		callback: function(record, operation, success) {
			 if (record.length > 0) {
				 //this$.toggleGridSummaryRow(grid,true);
				 }else{
					 this$.toggleGridSummaryRow(grid,false);
				 }
			 }
		});
        }
    },

    /**
     * show person common window
     * @param informationType
     * @param formItemId
     */
    showPersonCommonWindow: function(informationType, formItemId) {
        var this$ = this;
        var title = null,
            xtypeForm = null;
        var formWindow = this$.getPersonCommonWindow();
        if (!formWindow) {
            switch (informationType) {

            case 'PENDING_BILL':
                { //Pending bills
                    title = getPersonModuleTranslation('BILL_DETAILS');
                    xtypeForm = 'billviewforpcstructure';
                    break;
                }
            case 'REFUNDABLE_PAYMENT':
                { //Refundable Payment
            		title = getPersonModuleTranslation('BILL_DETAILS');
            		xtypeForm = 'billviewforpcstructure';
                    break;
                }
            default:
                {
                    break;
                }
            }

            formWindow = Ext.widget('personcommonwindow', {
                title: title,
                itemId: 'personCommonWindow',
                items: [{
                    xtype: xtypeForm,
                    itemId: formItemId
                }]
            });
        }

        formWindow.show();
    },
    /**
     * view person common window
     */
    viewPersonCommonWindow: function(form) {

        if (form) {
            form.down('#submitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },

    /**
     * Close person common window
     */
    closePersonCommonWindow: function() {
        var this$ = this;
        this$.getPersonCommonWindow().close();
    },

    /**
     * View pending bill form window
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     *  @param url
     */
    viewPendingBill: function(informationType, formItemId, grid, url) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        //var grid = personProfile.down(gridItemId);

        var associatedAcadLocationIds = new Array();
	    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getMANAGE_BILL_PERMISSION());
        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	this$.showPersonCommonWindow(informationType, formItemId);
        	var params = {
        			billId : record.get('billId'),
        			portalId : this.getCurrentLoggedPortalId()
        	};
        	var form = this$.getPersonPendingBillsForm();
        	var formGrid = form.down('#billViewForPcGridId');
        	if(!isEmpty(record)){
        		var formData = {
        				billNo : record.get('billNo'),
        				billAmount: currencyRenderer(record.get('feeAmount'),record.get("currencyId")),
        				billingDate: dateRender(record.get('billDate')),
        				currency: record.get('currencyName'),
						courseName:record.get('courseName')
            	};
            	form.getForm().setValues(formData);
            	if(portalId == "3"){
            		if(isNullOrEmpty(record.get('courseName'))){
                		form.down('#courseName').hide();
                	}else{
                		form.down('#courseName').show();
                	}
            	}
            	if(grid.itemId == "creditNoteGridForErp" || grid.itemId == "studentPortalCreditNoteGrid" || grid.itemId == "creditNoteGridForParentPortal") {
            		form.down('#billNo').setFieldLabel(getCommonTranslation("CREDIT_NOTE_NO"));
            		  form.down('#billAmount').setFieldLabel(getCommonTranslation("CREDIT_NOTE_AMOUNT"));
            		 form.down('#billingDate').setFieldLabel(getCommonTranslation("CREDIT_NOTE_DATE"));
            		 form.down('#currency').setFieldLabel(getCommonTranslation("CREDIT_NOTE_CURRENCY"));
            		 form.up('window').setTitle(getCommonTranslation("CREDIT_NOTE_DETAILS"));
            	}
            	if(grid.itemId == "studentPortalPendingBillsGrid"){
            		formGrid.columns[7].setText(getFeeAndPaymentCommonTranslation('BILLABLE_AMOUNT'))
            	}
        	}
        	
        	
        	
        	Ext.defer(function() {
        	var portalId = this.getCurrentLoggedPortalId();
				var getBillStatus = null;
				if(record.get("billStatus") == 'REVERSED'){
					getBillStatus = 'Reversed';
				}else if(record.get("billStatus") == 'SETTLED'){
					getBillStatus = 'Settled';
				}else if(record.get("billStatus") == 'PARTLY_SETTLED'){
					getBillStatus = 'Partly Settled';
				}else if(record.get("billStatus") == 'FULLY_PENDING'){
					getBillStatus = 'Fully Pending';
				}else if(record.get("billStatus") == 'CANCELLED'){
					getBillStatus = 'Cancelled';
				}else if(record.get("billStatus") == 'PENDING'){
					getBillStatus = 'Pending';
				}
				form.down('#settlementStatus').setValue(getBillStatus);
				if(portalId == 3 || portalId == 7) {
				for(var i=formGrid.columnManager.columns.length-1;i>=0;i--) {
					var column = formGrid.columnManager.columns[i];
					if(column.dataIndex == 'feePlan' || column.dataIndex =='stageName'){
						column.hide();
					}
				}
		   } }, 50, this);
        	
        	var store = formGrid.getStore();
        	store.getProxy().api.read = url;
        	formGrid.bindStore(store);
        	store.getProxy().extraParams = params;
            store.load();

            Ext.Ajax.request({
            							method : "GET",
            							type : 'rest',
            							url: SERVERURL.PATH_GET_BILL_VIEW_DATES,
            							params: {
            								billId : record.get("billId"),
            							},
            							headers : {
            								'Content-Type' : 'application/json'
            							},
            							success: function(response) {
            								var data = response.responseText && Ext.decode(response.responseText);
            								if(data){
            									Ext.each(permissionList, function(privilege) {
            										if (privilege === 'BILLING_START_DATE' && data.billingStartDate) {
            											form.down("#billingStartDate").setVisible(true);
            											form.down("#billingStartDate").setValue(dateRender(data.billingStartDate));
            										}
            										if (privilege === 'BILLING_END_DATE' && data.billingEndDate) {
            											form.down("#billingEndDate").setVisible(true);
                                                        var dateObj = Ext.Date.parse(data.billingEndDate, "Y-m-d");
                                                        var formattedDate = Ext.Date.format(dateObj, "d/m/Y");
            											form.down("#billingEndDate").setValue(formattedDate);
            										}
            										if (privilege === 'ATTENDANCE_START_DATE' && data.attendanceStartDate) {
            											form.down("#attendanceStartDate").setVisible(true);
                                                        var obj = Ext.Date.parse(data.attendanceStartDate, "Y-m-d");
                                                        var formattedAttendanceDate = Ext.Date.format(obj, "d/m/Y");
            											form.down("#attendanceStartDate").setValue(formattedAttendanceDate);
            										}
            										if (privilege === 'SCHOOL_LEAVING_DATE' && data.schoolLeavingDate) {
            											form.down("#schoolLeavingDate").setVisible(true);
            											form.down("#schoolLeavingDate").setValue(dateRender(data.schoolLeavingDate));
            										}
            									});
            								}
            							}
            						});
            
        } else {
            showWarningMessage(getPersonModuleTranslation('PENDING_BILLS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * View faculty pending bill form window
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     *  @param url
     */
    viewFacultyPendingBill: function(informationType, formItemId, gridItemId, url) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	this$.showPersonCommonWindow(informationType, formItemId);
        	var params = {
        			billId : record.get('id')
        	};
        	var form = this$.getPersonPendingBillsForm();
        	if(!isEmpty(record)){
        		var formData = {
        				billNo : record.get('billNo'),
        				billAmount: currencyRenderer(record.get('billAmount'),record.get("currencyId")),
        				billingDate: dateRender(record.get('billDate')),
        				currency: record.get('billCurrency'),
        				settlementStatus : record.get('billStatus')
            	};
        		if(formData.settlementStatus!=null && formData.settlementStatus=='FULLY_PENDING')
        		{
        			formData.settlementStatus='Fully Pending';
        		}else if(formData.settlementStatus!=null && formData.settlementStatus=='PARTLY_SETTLED')
        		{
        			formData.settlementStatus='Partly Settled';
        		}else if(formData.settlementStatus!=null && formData.settlementStatus=='SETTLED')
        		{
        			formData.settlementStatus='Settled';
        		}
        				
            	form.getForm().setValues(formData);
        	}
        	
        	var formGrid = form.down('#billViewForPcGridId');
        	var store = formGrid.getStore();
        	store.getProxy().api.read = url;
        	formGrid.bindStore(store);
        	store.getProxy().extraParams = params;
            store.load();
        } else {
            showWarningMessage(getPersonModuleTranslation('PENDING_BILLS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * View payment recieved history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     *  @param url
     */
    viewPaymentRecievedHistory: function(informationType, windowXType, gridItemId, url,record) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        //if (grid.getSelectionModel().getCount() > 0) { V2D-484297
        	//var record = grid.getSelectionModel().getSelection()[0];
        	var formWindow = Ext.widget(windowXType);
        	formWindow.show();
        	var params = {
        			receiptHeaderId : record.get('receiptHeaderId')
        	};
        	var gridWindow = formWindow.down('grid');
        	
        	var portalId = this.getCurrentLoggedPortalId();
    			 setTimeout(function(){
    			 var gridColumns=gridWindow.columns;
	 				 var length = gridColumns.length;
	 				 if(length != null && length != ""){
	 					 for(var i = 0; i < length; i++){
	 						 if(portalId!=1 || personProfile.xtype == "studentprofile")
	 						 {
	 							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
	 								 gridColumns[i].setVisible(false);
	 								 gridColumns[i].destroy();

	 							 }
	 						 }else
	 						 {
	 							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
	 								 gridColumns[i].setVisible(true);
	 							 }
	 						 }
	 					 }
	 				 } 
    			 },300);
        	var store = gridWindow.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = params;
            
            store.load();
            
        /*} else {
            showWarningMessage(getPersonModuleTranslation('PAYMENT_RECEIVED_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }*/
    },
    
    /**
     * View payment recieved history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     *  @param url
     */
    viewFacultyPaymentRecievedHistory: function(informationType, windowXType, gridItemId, url) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	var formWindow = Ext.widget(windowXType);
        	formWindow.show();
        	var params = {
        			receiptHeaderId : record.get('id')
        	};
        	var gridWindow = formWindow.down('grid');
        	var portalId = this.getCurrentLoggedPortalId();
			 setTimeout(function(){
			 var gridColumns=gridWindow.columns;
				 var length = gridColumns.length;
				 if(length != null && length != ""){
					 for(var i = 0; i < length; i++){
						 if(portalId!=1)
						 {
							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
								 gridColumns[i].setVisible(false);
								 gridColumns[i].destroy();

							 }
						 }else
						 {
							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
								 gridColumns[i].setVisible(true);
							 }
						 }
					 }
				 } 
			 },300);
        	var store = gridWindow.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = params;
            store.load();
            
        } else {
            showWarningMessage(getPersonModuleTranslation('PAYMENT_RECEIVED_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * View Payment made history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    viewPaymentMadeHistory: function(informationType, windowXType, gridItemId, url) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	var formWindow = Ext.widget(windowXType);
        	formWindow.show();
        	var params = {
        			paymentHeaderId : record.get('id')
        	};
        	var gridWindow = formWindow.down('grid');
        	var store = gridWindow.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = params;
            store.load();
            
        } else {
            showWarningMessage(getPersonModuleTranslation('PAYMENT_MADE_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * View refunds history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     *  @param url
     */
    viewRefundHistory: function(informationType, windowXType, gridItemId, url) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	var formWindow = Ext.widget(windowXType);
        	formWindow.show();
        	var params = {
        			paymentHeaderId : record.get('paymentHeaderId')
        	};
        	var gridWindow = formWindow.down('grid');
        	var portalId = this.getCurrentLoggedPortalId();
			 setTimeout(function(){
			 var gridColumns=gridWindow.columns;
				 var length = gridColumns.length;
				 if(length != null && length != ""){
					 for(var i = 0; i < length; i++){
						 if(portalId!=1 ||  personProfile.xtype=="studentprofile")
						 {
							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
								 gridColumns[i].setVisible(false);
								 gridColumns[i].destroy();

							 }
						 }else
						 {
							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
								 gridColumns[i].setVisible(true);
							 }
						 }
					 }
				 } 
			 },300);
        	
        	
        	
        	var store = gridWindow.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = params;
            store.load();
            
        } else {
            showWarningMessage(getPersonModuleTranslation('REFUND_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * View refundable payment history
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     *  @param url
     */
    viewRefundablePaymentHistory: function(informationType, formItemId, gridItemId, url) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	this$.showPersonCommonWindow(informationType, formItemId);
        	var params = {
        			billId : record.get('billId'),
        			portalId : this.getCurrentLoggedPortalId()
        	};
        	var form = this$.getPersonRefundablePaymentForm();
        	if(!isEmpty(record)){
        		var formData = {
        				billNo : record.get('billNo'),
        				billAmount: currencyRenderer(record.get('feeAmount'),record.get("currencyId")),
        				billingDate: dateRender(record.get('billDate')),
        				currency: record.get('currencyName'),
        				settlementStatus : record.get('settlementStatus')
            	};
            	form.getForm().setValues(formData);
        	}
        	
        	var formGrid = form.down('#billViewForPcGridId');
        	var store = formGrid.getStore();
        	store.getProxy().api.read = url;
        	formGrid.bindStore(store);
        	store.getProxy().extraParams = params;
            store.load();
            //this$.showPersonCommonWindow(informationType, formItemId);
        } else {
            showWarningMessage(getPersonModuleTranslation('PAYMENT_RECEIVED_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    exportJRXMLForStudent: function(fileType,gridType,grid) {
    	// code to get selected row
    	var $this = this;
    	var SettledReceiptId = [];
    	var PendingReceiptId = [];
    	var studentId = [];
    	var code;
    	var exportUrl;
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection();
    		for(var i in record) {
    		 if(record[i].get('receiptStatus') == "PARTLY_SETTLED" || record[i].get('receiptStatus') == "SETTLED") {
    			 SettledReceiptId.push(record[i].get('receiptHeaderId'));
   			   }  if(record[i].get('receiptStatus') == "FULLY_PENDING") {
   				PendingReceiptId.push(record[i].get('receiptHeaderId'));
   			   } 
   		    	if(record[i].get('studentId') !=null){
					 studentId.push(record[i].get('studentId'));
				   }
    		}
    		var user=$this.getCurrentlyLoggedInUser();
    		var reportTitle=null;
    		if(PendingReceiptId.length!=0)
    		{
    			code ="MANAGE_RECEIPT_STUDENT_CODE";
    			reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
    			
    		}else
    		{
    			code = 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE';
    			reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_SETTLEMENT_JASPER_TITLE');
    		}
    		/*exportUrl = SERVERURL.MANAGE_RECEIPT_SETTLEMENT_PDF;*/
    		exportUrl = SERVERURL.PATH_MANAGE_RECEIPT_ZIP_FROM_PORTAL;
    		var reportParams =new Object();
    		reportParams.academyLocationIds=academyLocationId;
			 reportParams.ids=String(SettledReceiptId,PendingReceiptId); // convert int into string
    		reportParams.userId=user.code;
    		reportParams.SettledReceiptId=String(SettledReceiptId); // convert int into string
    		reportParams.PendingReceiptId=String(PendingReceiptId); // convert int into string
    		reportParams.studentIds=String(studentId);
    		
    		var store=$this.getStore('examinationcenters.IsTemplateMappedStore');
    		store.getProxy().extraParams={
    			code:code
    		};
    		store.load({
    			callback:function(rec,obj,success){
    				if(obj.response.responseText=="true"){
    					$this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl); //'examinationcenters.IsTemplateMappedStore'
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
    				}
    			}
    		});
    	}
    },
    exportJRXMLForPendingBill : function(fileType,gridType,grid) {

    	var $this = this;
    	var code;
    	var selectedId = [];
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection();
    		for(var i in record)
    		{
    			selectedId.push(record[i].get('billId'));
    		}
    		user=this.getCurrentlyLoggedInUser();
    		if(grid.xtype=='pendingbillsgrid'){
    			code ="MANAGE_BILLS_CODE";
    		}else{
    			code ="MANAGE_BILLS_STUDENT_CODE";
    		}
    		
    		var reportParams =new Object();
    		reportParams.userId=user.code;
    		reportParams.ids=String(selectedId); // convert int into string
    		if(record[i].raw.raiseBillCategory!='BILL_PAYABLE')
    			var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_BILL_JASPER_TITLE');
    		else
    			var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_CREDIT_NOTE_JASPER_TITLE');
    		var exportUrl = SERVERURL.MANAGE_BILL_PDF;

    		this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
    	}
    },
    exportJRXMLForPendingBillVoucher : function(fileType,gridType,grid){
    	var $this = this;
    	var code;
    	var selectedId = [];
    	if (grid.getSelectionModel().getCount() > 0){
    		var record = grid.getSelectionModel().getSelection();
    		for(var i in record)
    		{
    			selectedId.push(record[i].get('billId'));
    		}
    		if(grid.xtype == 'pendingbillsgridforstudentportal'){
    			code ="OUTSTANDING_VOUCHER";
        	}
    		//var grid = this.getStudentpaymentplaninstalmentconfiggrid();
    		var reportTitle = 'Consolidate Outstanding Voucher- OUM';
    		var fileType = 'pdf';
     	    var user=this.getCurrentlyLoggedInUser(); 
    		var studentDetail = this.getCurrentlyLoggedInUserWithPersonId();
			var reportParams =new Object();
    		reportParams.userId=user.code;
    		reportParams.billIds= selectedId.join();
    		reportParams.personId=studentDetail.personId;
     	    reportParams.portalId=this.getCurrentLoggedPortalId();
			var exportUrl = SERVERURL.BILL_VOUCHER_PDF;
    		this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl);
    	}
    	
    },
    
  //************ disableExportPrintPivileges****************  
    disableExportPrintPivileges: function(gridReference,permissionsMap) {

 	   var associatedAcadLocationIds = new Array();
 	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
 	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
 	   var buttonsToolBar = gridReference.query('toolbar')[0];
 	   var splitbuttons = buttonsToolBar.query('splitbutton')[0];
 	   
 	   Ext.each(permissionList, function(privilege) {	
 		   if (privilege === 'PRINT') {
 			   var button = buttonsToolBar.query('#btnPrint')[0];
 			   if(!isNullOrEmpty(button)){
 				   button.setVisible(true);
 			   }        		
 		   }

 	   });
    },

    /**
     * View payment recieved history for profile
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     *  @param url
     */
    viewPaymentRecievedHistoryForProfile: function(informationType, windowXType, gridItemId, url, record) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        	//var record = grid.getSelectionModel().getSelection()[0];
        	var formWindow = Ext.widget(windowXType);
        	formWindow.show();
        	var params = {
        			receiptHeaderId : record.get('receiptHeaderId'),
        			screen:'profile',
        			portalId : this.getCurrentLoggedPortalId()
        	};
        	var gridWindow = formWindow.down('grid');
        	var portalId = this.getCurrentLoggedPortalId();
			 setTimeout(function(){
			 var gridColumns=gridWindow.columns;
				 var length = gridColumns.length;
				 if(length != null && length != ""){
					 for(var i = 0; i < length; i++){
						 if(portalId!=1)
						 {
							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
								 gridColumns[i].setVisible(false);
								 gridColumns[i].destroy();

							 }
						 }else
						 {
							 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
								 gridColumns[i].setVisible(true);
							 }
						 }
					 }
				 } 
			 },300);
        	var store = gridWindow.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = params;
            store.load();
    }
});