/**
 * This controller is used for faculty course execution information actions.
 * @author Sachin.Bangar   
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyCourseExecutionController', {
    extend: 'Academia.controller.personinfo.common.PersonCourseExecutionController',

    alias: "widget.facultycourseexecutioncontroller",

    refs: [{
    	ref : 'contentPanel',
    	selector:'contentpanel'
    },{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personDevelopmentPlanForm',
        selector: 'developmentplanform[itemId=facultyDevelopmentPlanForm]'
    }, {
        ref: 'personProgramCourseForm',
        selector: 'programandcourseform[itemId=facultyProgramCourseForm]'
    }, {
        ref: 'personProgramCourseWindow',
        selector: 'programcoursesearchpanel[itemId=facultyProgramCourseSearchPanel] form[itemId=programCourseSearchForm]'
    }, {
        ref: 'facultywisedetaildata',
        selector: 'facultywisedetaildata'
    }, {
        ref: 'facultywiseDetaildata',
        selector: 'facultywisedetaildata form'
    },{
        ref: 'attendanceQuickSearchGrid',
        selector: 'attendanceQuickSearchGrid[itemId=facultyAttendanceSearchResultGrid]'
    },{
        ref: 'programandcoursetopicwin',
        selector: 'programandcoursetopicwin'
    },{
        ref: 'programandcoursetopicgrid',
        selector: 'programandcoursetopicgrid'
    },{
        ref: 'facultycourseinterestgrid',
        selector: 'facultycourseinterestgrid'
    },{
        ref: 'facultycourseinterestform',
        selector: 'facultycourseinterestform'
    },{
    	ref: 'facultynoofvariantgridwindow',
    	selector: 'facultynoofvariantgridwindow'
    },{
    	ref: 'facultydutytabform',
    	selector: 'facultydutytabform'
    },{
    	ref: 'facultydutyfilter',
    	selector: 'facultydutyfilter[itemId=facultydutyformId]'
    },{
    	ref: 'examinationdutygrid',
    	selector: 'examinationdutygrid[itemId=examinationDutyGridItemId]'
    },{
    	ref: 'examinationdutysupervisorgrid',
    	selector: 'examinationdutysupervisorgrid[itemId=examinationdutysupervisorgridItemId]'
    },{
    	ref: 'examinationdutyexaminergrid',
    	selector: 'examinationdutyexaminergrid[itemId=examinationdutyexaminergridItemId]'
    },{
    	ref: 'examinationdutypapersattergrid',
    	selector: 'examinationdutypapersattergrid[itemId=examinationdutypapersattergridItemId]'
    },{
    	ref: 'courseexecutionreportstructure',
    	selector: 'courseexecutionreportstructure'
    },{
	   ref : 'courseexecutionreportstructureGrIdPBS',
	   selector:'searchresultgrid[itemId=facultydelayedCourseSearchGrIdPBS]'
   },{
	   ref : 'courseexecutionreportstructureGrIdCBS',
	   selector:'searchresultgrid[itemId=facultydelayedCourseSearchGrIdCBS]'
   },{
	   ref : 'programcoursesearchwindow',
	   selector:'programcoursesearchwindow'
   },{
 	   ref:'coursedocumentlist',
	   selector:'coursedocumentlist[itemId=facultyCourseDocumentList]'
   },{
 	   ref:'facultyprogramassociatedwindow',
	   selector:'facultyprogramassociatedwindow'
   },{
 	   ref:'facultyprogramassociateddetailsgrid',
	   selector:'facultyprogramassociateddetailsgrid'
   },{
 	   ref:'programandcoursegrid',
	   selector:'programandcoursegrid'
   },{
 	   ref:'programandcoursetreegrid',
	   selector:'programandcoursetreegrid'
   },{
	   ref:'programcoursefacultysearchpanel',
	   selector:'programcoursefacultysearchpanel'
   },{
	   ref:'programcoursefacultysearchwindow',
	   selector:'programcoursefacultysearchwindow'
   },{
       ref: 'facutltyTeachingHourGrid',
       selector: 'facutltyteachinghourgrid[itemId=facutltyTeachingHourGrid]'
   }],
    config: {
        FACULTY_ATTENDANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_ATTENDANCE_PRIVILEGES'),
        FACULTY_PROGRAM_COURSE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROGRAM_COURSE_PRIVILEGES'),
        FACULTY_EVALUATION_PLANS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EVALUATION_PLANS_PRIVILEGES'),
        FACULTY_DEVELOPMENT_GOAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_DEVELOPMENT_GOAL_PRIVILEGES'),
        FACULTY_COURSE_INTEREST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_COURSE_INTEREST_PRIVILEGES'),
        FACULTY_COURSE_EXECUTION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_COURSE_EXECUTION_PRIVILEGES'),
        FACULTY_PORTAL_DEVELOPMENT_GOAL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_DEVELOPMENT_GOAL_PRIVILEGES'),
        FACULTY_PROFILE_SCHEDULE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_SCHEDULE_PRIVILEGES'),
        FACULTY_PROFILE_ATTENDANCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_ATTENDANCE_PRIVILEGES'),
        FACULTY_PROFILE_PROGRAM_COURSE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_PROGRAM_COURSE_PRIVILEGES'),
        FACULTY_PORTAL_COURSE_INTEREST_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_COURSE_INTEREST_INFORMATION_PRIVILEGES'),
        FACULTY_PORTAL_TEACHING_HOUR_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_TEACHING_HOUR_PRIVILEGES'),
        FACULTY_PROFILE_TEACHING_HOUR_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_TEACHING_HOUR_PRIVILEGES'),
    },
    init: function(application) {
        this.control({

            /**
             * Faculty schedule calender
             */
            'scheduledetails[itemId=facultyScheduleDetails] calendarpanel[itemId=personViewCalendar]': {
                render: function(calender) {
                    this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.FACULTY_SCHEDULE_DETAILS_WITH_DATE);
                
                },
                afterrender:function(calender){
                	var me=this;
                	var portalId = this.getCurrentLoggedPortalId();
                	if(portalId==1){
                		var buttonContainer = calender.getDockedItems('toolbar')[0];
                		var exportToPngBtn=buttonContainer.down("#exportToPngBtn");
                		exportToPngBtn.setVisible(false);
                		var permissionsMap=this.getFACULTY_PROFILE_SCHEDULE_PERMISSIONS();
                		var associatedAcadLocationIds = new Array();
                		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
                		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                		var exportToPngIsVisible = false;
                		if(Ext.Array.contains(permissionList, 'EXPORT_TO_PNG')){
                			exportToPngBtn.setVisible(true);
                			exportToPngIsVisible = true;
                		}
                	}
                	
                	setTimeout(function(){
                    	var personProfile = me.getContentPanelActiveTab();
                    	var structure = personProfile.down('scheduledetails');
                    	var structureBody = structure.body;
                        var currentTimeHour = 8;//new Date().getHours();
                    	structureBody.setScrollTop();
                    	structureBody.scrollBy(0,151);
                   		structureBody.scrollBy(0,((75*currentTimeHour)));
                	},500);
                }
            },
            'scheduledetails[itemId=facultyScheduleDetails] radiogroup[itemId=viewCalendarId]': {
            	change: function(obj,rec) {
            		if(rec.isViewCalendar){
            			this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.FACULTY_SCHEDULE_DETAILS);	
            		}else{
            			this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.FACULTY_EVENT_DETAILS_PROFILE);

            		} 
            		var this$ = this;
            		var contentPanel = this$.getContentPanel();
            		var structure = contentPanel.down('scheduledetails');
            		var structureBody = structure.body;
            		var currentTimeHour = 8;//new Date().getHours();
            		structureBody.setScrollTop();
            		structureBody.scrollBy(0,151);
            		setTimeout(function(){
            			structureBody.scrollBy(0,((75*currentTimeHour)));
            		},100);

            	}
            },
           
            'scheduledetails[itemId=facultyScheduleDetails] #viewDatePicker':{
				 'select': {
	                   fn: function(dp, dt){
	                	   var this$ = this;
	                	   var personProfile = this$.getContentPanelActiveTab();
	                	   var viewCalendarForm = personProfile.down('#facultyScheduleDetails');
	                	   viewCalendarForm.down('#personViewCalendar').setStartDate(dt);
	                	   viewCalendarForm.down('#viewCalendarButton').toggle(false,false);
	                	   viewCalendarForm.down('#viewCalendarButton').hideMenu();
	                   },scope: this
	               }
			},
			'scheduledetails[itemId=facultyScheduleDetails] #viewCalendarButton':{
				click: function(cmp, e, eOpts){
					 var this$ = this;
					var personProfile = this$.getContentPanelActiveTab();
            	   	var viewCalendarForm = personProfile.down('#facultyScheduleDetails');
					cmp.showMenu();
					viewCalendarForm.down('#viewDatePicker').setVisible(true);
				}
			},
			/*'scheduledetails[itemId=facultyScheduleDetails] #app-center':{
	           afterrender: function(cmp){
	        	   var this$ = this;
	        	   var personProfile = this$.getContentPanelActiveTab();
           	   var viewCalendarForm = personProfile.down('#facultyScheduleDetails');
           	   viewCalendarForm.down('#app-center').header.addCls('app-center-header');
	            }
		   	},*/
		   	'scheduledetails[itemId=facultyScheduleDetails] ':{
					 afterrender:function(cmp){	
						 var width = cmp.getWidth();
						 var height = cmp.getHeight();
						 cmp.down('#personViewCalendar').setWidth(width);
						 cmp.down('#personViewCalendar').setHeight(height-40);
					 }
				},
		   	/*'scheduledetails[itemId=facultyScheduleDetails] #personViewCalendar':{
		   		'viewchange' : this.updateViewCalendarTitle
			},*/
				
				
			/*Development Plan*/
			'developmentplangrid[itemId=developmentplangridId]': {
				render: function(grid) {
 					this.loadGridStore('#developmentplangridId',SERVERURL.DEVELOPMENT_GOAL_FINE_BY_PERSON_ID);
 					var portalId = this.getCurrentLoggedPortalId();
 					if (portalId == 1){
 						this.doAccessControlValidation(grid, this.getFACULTY_DEVELOPMENT_GOAL_PERMISSIONS());	
 					} else if (portalId == 2){
 						this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_DEVELOPMENT_GOAL_PERMISSIONS());
 					}
				}
			},
			'facultyteachinghourdetails': {
				render: function(grid) {
					 var $this = this;
				        var personProfile = $this.getContentPanelActiveTab();
				        var grid = personProfile.down("#facutltyTeachingHourGrid");
 					var portalId = this.getCurrentLoggedPortalId();
 					if (portalId == 1){
 						this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_TEACHING_HOUR_PERMISSIONS());	
 					} else if (portalId == 2){
 						this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_TEACHING_HOUR_PERMISSIONS());
 					}
				},
				
			},
			'developmentplangrid[itemId=developmentplangridId] button[itemId=btnAdd]': {
                click: function() {
                    this.showPersonCommonWindow('DEVELOPMENT_PLAN', 'facultyDevelopmentPlanForm');
                }
            },
            'developmentplangrid[itemId=developmentplangridId] button[itemId=btnEdit]': {
                click: function() {
                    this.editDevelopmentGoal('DEVELOPMENT_PLAN', 'facultyDevelopmentPlanForm', '#developmentplangridId');
                }
            },
            'developmentplangrid[itemId=developmentplangridId] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteDevelopmentGoal('#developmentplangridId', SERVERURL.DEVELOPMENT_GOAL_DELETE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] developmentplanform[itemId=facultyDevelopmentPlanForm] button[itemId=submitButtonId]': {
                click: function() {
                    this.saveDevelopmentGoal('#developmentplangridId', SERVERURL.DEVELOPMENT_GOAL_CREATE, SERVERURL.DEVELOPMENT_GOAL_UPDATE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] developmentplanform[itemId=facultyDevelopmentPlanForm] radiogroup[itemId=isAchievedId]': {
                change: function(obj,rec) {
                	this.onChangeAchieved(obj,rec);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] developmentplanform[itemId=facultyDevelopmentPlanForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },		
            /*Program Course*/
            'programandcoursegrid[itemId=facultyProgramCourseGrid]': {
                render: function(grid) {
                    //this.loadGridStore('#facultyProgramCourseGrid',SERVERURL.BILL_ADJUSTMENT_GRID);
                	 var grid = this.getProgramandcoursegrid();
                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
          		     var wheatherSchool = alinfomodel.get('wheatherSchool');
          		    if(!wheatherSchool){
          			   grid.columns[3].setVisible(true);
          		   }	
                    var portalId = this.getCurrentLoggedPortalId();
            		if (portalId == 1){
            			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_PROGRAM_COURSE_PERMISSIONS());
            		} else if (portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PROGRAM_COURSE_PERMISSIONS());
            		}
            		
                    if(this.getCurrentLoggedPortalId()==2){
                    	var store = grid.getStore();
                		store.getProxy().api.read = SERVERURL.PATH_GET_FACULTY_PROGRAM_COURSE_GRID_DATA;// url
                		store.getProxy().extraParams = {
                			facultyId: this.getCurrentlyLoggedInUser().id,
                			academyLocationId : this.getCurrentAcademyLocation()
                		};
//                		store.load();
                    }
                },
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                	var searchResultGrid = grid.ownerCt;
                	var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
                	if(columnName=='totalTopic'){
                		if (e.target.tagName == 'A') {
                			this.openTopicWin(grid, rowIndex, record, 'TOTAL_TOPIC'); 
                		}
                	}
                	if(columnName=='assignedTopic'){
                		if (e.target.tagName == 'A') {
                			this.openTopicWin(grid, rowIndex, record, 'ASSIGNED_TOPIC'); 
                		}
                	}
                	if(columnName=='programAssociated'){
                		if (e.target.tagName == 'A') {
                			this.linkNoProgramCourseAssociated(grid, rowIndex, record);
                		}
                	}
                	if(columnName=='documents' && record.data.documents >0){
                		if (e.target.tagName == 'A') {
                			this.linkCoursesNoOfDocuments(grid, rowIndex, record);
                		}
                	}
                }
            },
            'programandcoursetreegrid[itemId=facultyProgramCourseTreeGrid]': {
                cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                	var searchResultGrid = grid.ownerCt;
                	var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
                	if(columnName=='totalTopic'){
                		if (e.target.tagName == 'A') {
                			this.openTopicWin(grid, rowIndex, record, 'TOTAL_TOPIC'); 
                		}
                	}
                	if(columnName=='assignedTopic'){
                		if (e.target.tagName == 'A') {
                			this.openTopicWin(grid, rowIndex, record, 'ASSIGNED_TOPIC'); 
                		}
                	}
                	if(columnName=='programAssociated'){
                		if (e.target.tagName == 'A') {
                			this.linkNoProgramCourseAssociated(grid, rowIndex, record);
                		}
                	}
                	if(columnName=='documents' && record.data.documents >0){
                		if (e.target.tagName == 'A') {
                			this.linkCoursesNoOfDocuments(grid, rowIndex, record);
                		}
                	}
                },
                beforerender: function(treepanel) {
                	var store = treepanel.getStore();
                	if(store.getRootNode().childNodes) {
  	    			   store.getRootNode().removeAll();
  	    		   }
                }
            },
            'programandcoursegrid[itemId=facultyProgramCourseGrid] button[itemId=btnAdd]': {
                click: function() {
                    this.showPersonCommonWindow('PROGRAM_COURSES', 'facultyProgramCourseForm');
                }
            },
            'programandcoursegrid[itemId=facultyProgramCourseGrid] button[itemId=btnEdit]': {
                click: function() {
                    this.editProgramCourse('PROGRAM_COURSES', 'facultyProgramCourseForm', '#facultyProgramCourseGrid');
                }
            },
            'programandcoursegrid[itemId=facultyProgramCourseGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewProgramCourse('PROGRAM_COURSES', 'facultyProgramCourseForm', '#facultyProgramCourseGrid');
                }
            },
            'programandcoursegrid[itemId=facultyProgramCourseGrid] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteProgramCourse('#facultyProgramCourseGrid', SERVERURL.PROGRAM_COURSES_DELETE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] programandcourseform[itemId=facultyProgramCourseForm] button[itemId=submitButtonId]': {
                click: function() {
                    this.saveProgramCourse('#facultyProgramCourseGrid', SERVERURL.PROGRAM_COURSES_ADD, SERVERURL.PROGRAM_COURSES_UPDATE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] programandcourseform[itemId=facultyProgramCourseForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },

            'attendanceQuickSearchGrid[itemId=facultyAttendanceSearchResultGrid]': {
            	render: function(grid) {
            		//this.loadGridStore('#attendanceSearchResultGrid',SERVERURL.BILL_ADJUSTMENT_GRID);
            		var portalId = this.getCurrentLoggedPortalId();
            		if (portalId == 1){
            			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_ATTENDANCE_PERMISSIONS());	
            		} else if (portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_ATTENDANCE_PERMISSIONS());
            		}
            	}
            },
            'facultyevaluationdetails grid[itemId=facultyEvaluationSearchResultGrid]': {
                afterrender: function(grid) {
                    this.genericCBGridAccessControlValidation(grid, this.getFACULTY_EVALUATION_PLANS_PERMISSIONS());
                }
            },
            'attendanceQuickSearchGrid[itemId=facultyAttendanceSearchResultGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewDetails('#facultyAttendanceSearchResultGrid', '#facultyAttendanceQuickSearchForm');
                }
            },
            'facultyattendancequicksearchform[itemId=facultyAttendanceQuickSearchForm]': {
                render: function(form) {
                	var detailsLinkPanel = this.getContentPanelActiveTab().down('#facultyPersonDetailsLinkPanel');
                	var personType = '';
                	if(!isNullOrEmpty(detailsLinkPanel)) {
                		personType = detailsLinkPanel.personType;
                	}                	
                	if(personType == 'OTHER_EMPLOYEE') {
                		form.down('#facultyAttendance_hidden_type').setValue('COMPLETE_DAY');
                		form.down('#programBatchPeriodContainer').setDisabled(true);
                        form.down('#programBatchPeriodContainer').setVisible(false);
                        form.down('#sectionCourseContainer').setDisabled(true);
                        form.down('#sectionCourseContainer').setVisible(false);                        
                	} else {
                		this.showHideSearchFormFieldOnAttedanceType(form);
                	}
                },
            	afterrender: function(form) {
            		var detailsLinkPanel = this.getContentPanelActiveTab().down('#facultyPersonDetailsLinkPanel');
                	var personType = '';
                	if(!isNullOrEmpty(detailsLinkPanel)) {
                		personType = detailsLinkPanel.personType;
                	}
            		//var personType = this.getContentPanelActiveTab().down('#facultyPersonDetailsLinkPanel').personType;
            		var attendanceResultGrid = form.up('facultyattendancedetails').down('#facultyAttendanceSearchResultGrid');
            		this.showHideSearchGridFieldOnAttedanceType(attendanceResultGrid, personType);
            	} 
            },
            'facultyattendancequicksearchform[itemId=facultyAttendanceQuickSearchForm] button[itemId=attendanceSearchButtonId]': {
                click: function() {
                    this.loadFacultySearchGrid('#facultyAttendanceQuickSearchForm', '#facultyAttendanceSearchResultGrid');
                }
            },
            'facultyteachinghourquicksearchform[itemId=facultyTeachingHourQuickSearchForm] button[itemId=attendanceSearchButtonId]': {
                click: function() {
                    this.loadFacultyTeachingHoursSearchGrid('#facultyTeachingHourQuickSearchForm', '#facutltyTeachingHourGrid');
                }
            },
            'facultyattendancequicksearchform[itemId=facultyAttendanceQuickSearchForm] button[itemId=clearSearch]': {
                click: this.clearSearchForm
            },
            'evaluationquicksearchform[itemId=facultyQuickSearchForm] button[itemId=clearSearch]': {
                click: this.clearSearchForm
            },
            'facultyattendancequicksearchform[itemId=facultyAttendanceQuickSearchForm] combo[itemId=attendanceProgram]': {
                afterrender: function(program, records, eOpts) {
                    var academyLocationIds = this.getCurrentAcademyLocation();
                    this.loadAttendanceDependentCombo(program, academyLocationIds, 'academyLocationId');
                },
                select: function(combo, records, eOpts) {
                    var batchCombo = combo.up('form').down('#batch');
                    var comboValue = combo.getValue();
                    this.loadAttendanceDependentCombo(batchCombo, comboValue, 'id');
                }
            },
            'facultyattendancequicksearchform[itemId=facultyAttendanceQuickSearchForm] combo[itemId=batch]': {
                select: function(combo, records, eOpts) {
                    var periodCombo = combo.up('form').down('#period');
                    var comboValue = combo.getValue();
                    this.loadAttendanceDependentCombo(periodCombo, comboValue, 'batchId');
                }
            },
            'facultyattendancequicksearchform[itemId=facultyAttendanceQuickSearchForm] combo[itemId=period]': {
                select: function(combo, records, eOpts) {
                    var sectionCombo = combo.up('form').down('#section');
                    var comboValue = combo.getValue();
                    this.loadAttendanceDependentCombo(sectionCombo, comboValue, 'periodId');
                }
            },
            'facultyattendancequicksearchform[itemId=facultyAttendanceQuickSearchForm] combo[itemId=section]': {
                select: function(combo, records, eOpts) {
                    var courseCombo = combo.up('form').down('#course');
                    var comboValue = combo.getValue();
                    this.loadAttendanceDependentCombo(courseCombo, comboValue, 'periodId');
                }
            },
            'facultyattendancequicksearchform[itemId=facultyAttendanceQuickSearchForm] combo[itemId=course]': {
                select: function(combo, records, eOpts) {
                    var courseComponentCombo = combo.up('form').down('#courseComponent');
                    var comboValue = combo.getValue();
                    this.loadAttendanceDependentCombo(courseComponentCombo, comboValue, 'id');
                }
            },
            'programcoursefacultysearchwindow': {
            	afterrender: function(obj) {					
            		var programcourseForm =  this.getProgramcoursefacultysearchwindow();
            		var academicTerm = programcourseForm.down('#academicTerm');
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
            		var wheatherSchool = alinfomodel.get('wheatherSchool');
            		if(wheatherSchool){
            			programcourseForm.down("#periodItemId").hide();
            		}else{
            			programcourseForm.down("#periodItemId").setVisible(true);
            		}
            		var academicTermStore = academicTerm.getStore();
            		var currentAcademicTermDefine=false;
            		academicTermStore.load({
            			callback: function(record, operation, success) {
            				if (success) {
            					if(record.length>0){
            						Ext.each(record, function(value) {
            							if(value.get('whetherCurrentAcademicTerm')){
            								programcourseForm.down("#academicTerm").setValue(value.get('id'));
            								currentAcademicTermDefine=true;
            							}
            						});
            					}
            				}
            			}
            		});
            		if(!currentAcademicTermDefine){
            			var academyLocationIds = this.getCurrentAcademyLocation();
            			var facultyId=this.getCurrentlyLoggedInUser().id;
            			var programField=programcourseForm.down("#programItemId");
            			var programStore = programField.getStore();
            			programStore.getProxy().extraParams = {
            				academyLocationIds:academyLocationIds,
            				facultyId: facultyId,
            				isAllProgram:true,
            			}
            			var courseVariantField=programcourseForm.down("#courseVariantId");
            			var courseVariantStore = courseVariantField.getStore();
            			courseVariantStore.getProxy().extraParams = {
            				academyLocationIds: academyLocationIds,
            				facultyId: facultyId,
            				isCurrentPeriod:false
            			};
            		}
            		var alternateFacultyStore = programcourseForm.down('#alternateFaculty').getStore();
            		alternateFacultyStore.getProxy().extraParams = {
            			facultyId : facultyId
            		};
            	}
            },
            'programcoursefacultysearchwindow customcombobox[itemId=academicTerm]' : {
 			   change: function(obj, records){
 				   var me = this;
 					var form = obj.up('form');
 					var academicTermId = obj.getValue();
 					if(academicTermId > 0) {
 						this.onChangeAcademictermOfProgramCourseFacultySearch(form, academicTermId);
 					}
 			   }
 		   },
 		  'programcoursefacultysearchwindow customcombobox[itemId=courseVariantId]' : {
				change: function(obj, record){
					var me = this;
					var form = obj.up('form');
					var courseVariantId = obj.getValue();
					if(courseVariantId > 0) {
						var assignSectionType = obj.getStore().findRecord('id', courseVariantId).data.sectionType;
						this.courseVariantSelectionOfProgramCourseFacultySearch(form, courseVariantId, assignSectionType);
					}
				}
			},
			'programcoursefacultysearchwindow customcombobox[itemId=programItemId]' : {
				change:function(obj,records) {
					var me = this;
					var form = obj.up('form');
					var programId = obj.getValue();
					if(programId > 0) {
						this.programCourseFacultyProgramChange(form, programId);
					}
				}
			},
			'programcoursefacultysearchwindow customcombobox[itemId=batchItemId]' : {
				change:function(obj, record) {
					var me = this;
					var form = obj.up('form');
					var batchId = obj.getValue();
					if(batchId > 0) {
						this.programCourseFacultyBatchChange(form, batchId);
					}
				}
			},
			'programcoursefacultysearchwindow customcombobox[itemId=periodItemId]' : {
				change: function(obj, record){
					var me = this;
					var form = obj.up('form');
					var periodId = obj.getValue();
					if(periodId > 0) {
						this.programCourseFacultyPeriodSelection(form, periodId);
					}
				}
			},
			'programcoursefacultysearchwindow button[itemId=searchButtonId]': {
                click: function(button) {
                	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                	//this.loadFacultyProgCoursesTreeGrid(button);
                    //this.loadFacultyProgCoursesGrid(button);
                	this.loadProgramCoursesFacultyTreeGrid(button);
                    this.loadProgramCoursesFacultyGrid(button);
                }
            },
            'programcoursefacultysearchwindow button[itemId=clearSearch]': {
    				click:function(obj, rec){
    					var form = this.getProgramcoursefacultysearchwindow();
    					var academicTermField = form.down("#academicTerm");
    					var courseVarientField = form.down("#courseVariantId");
    					var programField = form.down("#programItemId");
    					var batchField = form.down("#batchItemId");
    					var periodField = form.down("#periodItemId");
    					var sectionField = form.down("#sectionItemId");
    					var alternateFacultyField =  form.down("#alternateFaculty");

    					academicTermField.clearValue();
    					courseVarientField.clearValue();
    					programField.clearValue();
    					batchField.clearValue();
    					periodField.clearValue();
    					sectionField.clearValue();
    					alternateFacultyField.clearValue();

    					courseVarientField.setDisabled(false);
    					programField.setDisabled(false);
    					batchField.setDisabled(true);
    					periodField.setDisabled(true);
    					sectionField.setDisabled(true);
    					
    					var academicTermStore = academicTermField.getStore();
    					var currentAcademicTermDefine=false;
                		academicTermStore.load({
                			callback: function(record, operation, success) {
                				if (success) {
                					if(record.length>0){
                						Ext.each(record, function(value) {
                							if(value.get('whetherCurrentAcademicTerm')){
                								form.down("#academicTerm").setValue(value.get('id'));
                								currentAcademicTermDefine=true;
                							}
                						});
                					}
                				}
                			}
                		});
                		if(!currentAcademicTermDefine){
                			var academyLocationIds = this.getCurrentAcademyLocation();
                			var facultyId=this.getCurrentlyLoggedInUser().id;
                			var programStore = programField.getStore();
                			programStore.getProxy().extraParams = {
                				academyLocationIds:academyLocationIds,
                				facultyId: facultyId,
                				isAllProgram:true,
                			}
                			programStore.load();
                			var courseVariantStore = courseVarientField.getStore();
                			courseVariantStore.getProxy().extraParams = {
                				academyLocationIds: academyLocationIds,
                				facultyId: facultyId,
                				isCurrentPeriod:false
                			};
                			courseVariantStore.load();
                		}
                		var alternateFacultyStore = alternateFacultyField.getStore();
                		alternateFacultyStore.getProxy().extraParams = {
                			facultyId : facultyId
                		};
                		alternateFacultyStore.load();
    				}
            },
            /**
             * Program Course
             */
            'programcoursesearchwindow': {
                render: function(form) {
                	var this$ = this;                	
                	if(this.getCurrentLoggedPortalId()==2){
                		var alinfomodel = Academia.model.authentication.ALInfoModel;
                    	var wheatherSchool = alinfomodel.get('wheatherSchool');
                    	if(wheatherSchool) {
                    		this$.getProgramcoursesearchwindow().down('#period').setVisible(false);
                    	}
//                   		var courseStore = this$.getStore('course.AssignedPeriodCoursesFacultyStore');
                   		var programStore = form.down('#programComboField').getStore();
                   		var alternateFacultyStore = form.down('#alternateFaculty').getStore();
                   		var facultyId = this.getCurrentlyLoggedInUser().id;
                   		var academyLocationId = this.getCurrentAcademyLocation();
                   		/*var store = this$.getStore('common.AcademicTermStore');
                   		var academicTermId;
                  		store.load({
                  			callback: function(records, operation, success) {
                  				for(var i=0;i<store.data.items.length;i++){
                        			if(store.data.items[i].data.whetherCurrentAcademicTerm) {
                        				 form.down('#academicTerm').setValue(store.data.items[i].data.id);
                        				 academicTermId=store.data.items[i].data.id;
                        			}
                        		 }
                  				
                  			}
                  		});*/
//                  		var courseVariantStore = this$.getStore('course.coursevariants.ParameterCourseVariantStore');
                  		var courseVariantStore = form.down('#courseVariantId').getStore();
                  		courseVariantStore.getProxy().extraParams = {
                        	facultyId : facultyId,
//                        	academicTermId:academicTermId,
                        	academyLocationIds : academyLocationId,
                        	isCurrentPeriod : true
                        };
                  		courseVariantStore.load();
                  		
                		/*courseStore.getProxy().extraParams = {
                			facultyId : this.getCurrentlyLoggedInUser().id,
                			academyLocationId : academyLocationId,
                			sectionType:'ALL'
                		};
                		courseStore.load();*/
                		alternateFacultyStore.getProxy().extraParams = {
                			facultyId : facultyId
                		};
                		alternateFacultyStore.load();
                		programStore.getProxy().extraParams = {
                			facultyId : facultyId,
                			academyLocationIds : academyLocationId,
                			whetherSchool : false
                		};
                		programStore.load();
                	}else if(this.getCurrentLoggedPortalId()==1){
                		var personProfile = this$.getContentPanelActiveTab();
                		var facultyId = personProfile.getUserId();
                		var courseStore = this$.getStore('course.AssignedPeriodCoursesFacultyStore');
                		var programStore = form.down('#programComboField').getStore();
                		var alternateFacultyStore = form.down('#alternateFaculty').getStore();
                		var academyLocationId = this.getCurrentAcademyLocation();
                		courseStore.getProxy().extraParams = {
                			facultyId : facultyId,
                			academyLocationId : academyLocationId,
                			sectionType:'ALL'
                		};
                		courseStore.load();
                		alternateFacultyStore.getProxy().extraParams = {
                			facultyId : facultyId
                		};
                		alternateFacultyStore.load();
                		programStore.getProxy().extraParams = {
                			facultyId : facultyId,
                			academyLocationIds : academyLocationId
                		};
                		programStore.load();
                	}
                }
            },
            
            'programcoursesearchwindow customcombobox[itemId=academicTerm]': {
            	change:function(obj, record){
            		var this$ = this;
            		var form = this$.getProgramcoursesearchwindow();
            		var academicTermId = record;
            		var programcombo = this$.getProgramcoursesearchwindow().down('#programComboField');
            		var periodcombo = this$.getProgramcoursesearchwindow().down('#period');
	   				var batchcombo = this$.getProgramcoursesearchwindow().down('#batch');
	   				var sectioncombo = this$.getProgramcoursesearchwindow().down('#section');
	   				periodcombo.reset();
	   				batchcombo.reset();
	   				sectioncombo.reset();
	   				programcombo.reset();
	   				periodcombo.setDisabled(true);
	   				batchcombo.setDisabled(true);
	   				sectioncombo.setDisabled(true);
            		var facultyId = this.getCurrentlyLoggedInUser().id;
//            		var courseVariantStore = this$.getStore('course.coursevariants.ParameterCourseVariantStore');
            		var courseVariantStore = form.down('#courseVariantId').getStore();
              		courseVariantStore.getProxy().extraParams = {
              			facultyId : facultyId,
//                    	academicTermId:academicTermId,
                    	academyLocationIds : this$.getCurrentAcademyLocation(),
                    	isCurrentPeriod : true
                    };
              		courseVariantStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==1){
									   this$.getProgramcoursesearchwindow().down('#courseVariantId').reset();
									   this$.getProgramcoursesearchwindow().down('#courseVariantId').setValue(records[0].get('id'));
								   }
							   }
						   }
            		});
              		
              		var programStore = form.down('#programComboField').getStore();
					   programStore.getProxy().extraParams = {
            			facultyId : facultyId,
            			academyLocationIds : this$.getCurrentAcademyLocation(),
            			whetherSchool : false
            		};
            		programStore.load();
            	}
            },
            'programcoursesearchwindow button[itemId=searchButtonId]': {
                click: function(button) {
                    this.loadFacultyProgCoursesTreeGrid(button);
                    this.loadFacultyProgCoursesGrid(button);
                }
            },
            'programcoursesearchwindow button[itemId=clearSearch]': {
                click: function(button) {
                	var this$ = this;
                    this.clearSearchForm(button);
                    var form = this$.getProgramcoursesearchwindow();
                    form.down('#courseVariantId').clearValue();
                    form.down('#programComboField').setDisabled(false);
                    form.down('#batch').setDisabled(true);
                    form.down('#period').setDisabled(true);
                    form.down('#section').setDisabled(true);
                    var whetherSchoolStatus;
//                    form.down('#courseVariantId').setDisabled(true);
//                    var PbsCourse = form.down('#course')
                    var facultyId = null;
                    if(this.getCurrentLoggedPortalId()==1){
                    	var personProfile = this$.getContentPanelActiveTab();
                    	facultyId = personProfile.getUserId();
                    }else if(this.getCurrentLoggedPortalId()==2){
                    	facultyId = this.getCurrentlyLoggedInUser().id;
                    	whetherSchoolStatus=false;
                    }
                    /*var PbsCourseStore = PbsCourse.getStore();
					   PbsCourseStore.getProxy().extraParams = {
						   sectionType:'ALL',
						   facultyId : facultyId,
						   academyLocationId : this$.getCurrentAcademyLocation()
					   };
					   PbsCourseStore.load();*/
//					   var courseVariantStore = this$.getStore('course.coursevariants.ParameterCourseVariantStore');
					   var courseVariantStore = form.down('#courseVariantId').getStore();
	              		courseVariantStore.getProxy().extraParams = {
	              			facultyId : facultyId,
//                        	academicTermId:academicTermId,
                        	academyLocationIds : this$.getCurrentAcademyLocation(),
                        	isCurrentPeriod : true
	                    };
	              		courseVariantStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										   this$.getProgramcoursesearchwindow().down('#courseVariantId').reset();
										   this$.getProgramcoursesearchwindow().down('#courseVariantId').setValue(records[0].get('id'));
									   }
								   }
							   }
	            		});
					   var programStore = form.down('#programComboField').getStore();
					   programStore.getProxy().extraParams = {
               			facultyId : facultyId,
               			academyLocationIds : this$.getCurrentAcademyLocation(),
               			whetherSchool : whetherSchoolStatus
               		};
               		programStore.load();
                }
            },
            'programcoursesearchwindow customcombobox[itemId=programComboField]': {
            	 select: function(obj, record) {
    				 var $this = this;
    				 var periodcombo = $this.getProgramcoursesearchwindow().down('#period');
    				 var batchcombo = $this.getProgramcoursesearchwindow().down('#batch');
    				 var sectioncombo = $this.getProgramcoursesearchwindow().down('#section');
    				 periodcombo.reset();
    				 batchcombo.reset();
    				 sectioncombo.reset();
    				 periodcombo.setDisabled(true);
    				 sectioncombo.setDisabled(true);
    				 var alinfomodel = Academia.model.authentication.ALInfoModel;
                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
                	 if(wheatherSchool) {
                		 $this.getProgramcoursesearchwindow().down('#period').setVisible(false);
                	 }
    				 var programId = record[0].get("id");
    				 if(programId > 0){
    					 var store = this.getStore('common.CurrentBatchStore');

    					 store.getProxy().extraParams = {
    						 programId: programId
    					 };
    					 store.load({
    						 callback: function(records, operation, success) {
    							 if (success) {
    								 var batchId = 0;
    								 periodcombo.setDisabled(false);
    								 $this.getProgramcoursesearchwindow().down('#batch').setDisabled(false);
    								 for(var i=0,j=0; i<records.length; i++){
    									 if (records.length == 1) {
    										 batchId = records[i].data.id;
    									 } else if(records[i].data.isCurrentPeriodOfProgram){
    										 if(j==0){
    											 batchId = records[i].data.id;
    											 j++;
    										 } else {
    											 batchId = 0;
    											 return;
    										 }
    									 }
    								 }
    							 }
    							 if(batchId > 0){
    								 periodcombo.setDisabled(false);
    								 $this.getProgramcoursesearchwindow().down('#batch').setValue(batchId);
    								 var store = $this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
    								 store.getProxy().extraParams = {
    									 id : batchId
    								 };
    								 store.load({
    									 callback: function(records, operation, success) {
    										 if (success) {
    											 if(records.length == 0){
    												 if(wheatherSchool) {
    												 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
    												 }
    											 } else if(records.length == 1){
    												 var periodId = records[0].data.id;
    												 $this.getProgramcoursesearchwindow().down('#period').setValue(periodId);
    												 if(wheatherSchool) {
    													 $this.getProgramcoursesearchwindow().down('#period').setVisible(false);
    												 }else {
    													 $this.getProgramcoursesearchwindow().down('#period').setDisabled(false);
    												 }
    												 $this.getProgramcoursesearchwindow().down('#section').setDisabled(false);
    		    									 var storeSection = $this.getStore('attendance.SectionAndFacultyByPeriodIDInPC');
    		    									 storeSection.getProxy().extraParams = {
    		    										 periodId:periodId
    		    									 };
    		    									 storeSection.load({
    		  										   callback: function(records, operation, success) {
    													   if (success) {
    														   if(records.length==1){
    															   sectioncombo.setValue(records[0].get("sectionId"));
    														   }
    													   }
    												   
    												   }
    											   });
    											 } else {
    												 $this.getProgramcoursesearchwindow().down('#period').setVisible(true);
    											 }
    										 }
    									 }
    								 });
    							 }
    						 }
    					 });
    				 }
    			 }
            },
            'programcoursesearchwindow customcombobox[itemId=batch]': {
                select: function(combo, records, eOpts) {
                	var this$ =  this;
                    var periodCombo = combo.up('form').down('#period');
                    periodCombo.setDisabled(false);
                    var comboValue = combo.getValue();
                    var section = this$.getProgramcoursesearchwindow().down('#section');
                    section.reset();
                    section.setDisabled(true);
                    //this.loadAttendanceDependentCombo(periodCombo, comboValue, 'batchId');
                    //this.loadAttendanceDependentCombo(periodCombo, comboValue, 'id');
                       periodCombo.reset();
					   var periodStore = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					   periodStore.getProxy().extraParams = {
						   id: records[0].get("id")
					   };
					   periodStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==1){
									   var periodId = records[0].get("id");
									   periodCombo.setValue(periodId);									   
									   section.setDisabled(false);
									   var storeSection = this$.getStore('attendance.SectionAndFacultyByPeriodIDInPC');
									   storeSection.getProxy().extraParams = {
										   periodId:periodId
									   };
									   storeSection.load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length==1){
													   section.setValue(records[0].get("sectionId"));
												   }
											   }
										   
										   }
									   });

								   }
							   }
						   }
					   });
                }
            },
            'programcoursesearchwindow customcombobox[itemId=period]': {
                select: function(combo, records, eOpts) {
                	var this$ = this;
                	var facultyId = null;
                    var sectionCombo = combo.up('form').down('#section');
                    var courseCombo = combo.up('form').down('#course');
                    if(this.getCurrentLoggedPortalId()==1){
                    	var personProfile = this$.getContentPanelActiveTab();
                    	facultyId = personProfile.getUserId();
                    }else if(this.getCurrentLoggedPortalId()==2){
                    	facultyId = this.getCurrentlyLoggedInUser().id;
                    }
                    var alternateFacultyStore = combo.up('form').down('#alternateFaculty').getStore();
               		alternateFacultyStore.getProxy().extraParams = {
            			facultyId : facultyId,
            			periodId : combo.getValue()
            		};
               		alternateFacultyStore.load();
                    sectionCombo.setDisabled(false);
                    var periodId = combo.getValue();
                    //this.loadAttendanceDependentCombo(sectionCombo, comboValue, 'periodId');
                   // this.loadAttendanceDependentCombo(courseCombo, comboValue, 'periodId', 'facultyId', facultyId);
                    
					   // load section on the basis of period ID
                    var section = this$.getProgramcoursesearchwindow().down('#section');
                    section.setDisabled(false);
					   var storeSection = this$.getStore('attendance.SectionAndFacultyByPeriodIDInPC');
					   storeSection.getProxy().extraParams = {
						   periodId:periodId
					   };
					   storeSection.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==1){
									   section.setValue(records[0].get("sectionId"));
								   }
							   }
						   
						   }
					   });
                }
            },
            'programcoursesearchwindow customcombobox[itemId=section]': {
                select: function(combo, records, eOpts) {
//                    var courseCombo = combo.up('form').down('#course');
                    var comboValue = combo.getValue();
                    var facultyId = null;
                    var portalId = this.getCurrentLoggedPortalId();
                    if(this.getCurrentLoggedPortalId()==1){
                    	var personProfile = this$.getContentPanelActiveTab();
                    	facultyId = personProfile.getUserId();
                    }else if(this.getCurrentLoggedPortalId()==2){
                    	facultyId = this.getCurrentlyLoggedInUser().id;
                    }
                    
                    var periodeCombo = combo.up('form').down('#period');
                    var periodeValue = periodeCombo.getValue();
                   /* if(portalId == 2) {
                    	this.loadAttendanceDependentCombo(courseCombo, periodeValue, 'periodId', 'facultyId', facultyId);
                    } else {
                    	this.loadAttendanceDependentCombo(courseCombo, periodeValue, 'periodId');
                    }*/
                }
            },
            'programcoursesearchwindow customcombobox[itemId=course]': {
                select: function(combo, records, eOpts) {
                	var this$ =  this;
                    var courseVariantCombo = combo.up('form').down('#courseVariantId');
                    courseVariantCombo.setDisabled(false);
                    courseVariantCombo.reset();
                    var comboValue = combo.getValue();
                    var sectionType = records[0].get('sectionType');
                    var facultyId = null;
                    if(this.getCurrentLoggedPortalId()==1){
                    	var personProfile = this$.getContentPanelActiveTab();
                    	facultyId = personProfile.getUserId();
                    }else if(this.getCurrentLoggedPortalId()==2){
                    	facultyId = this.getCurrentlyLoggedInUser().id;
                    }
                    var facultyCombo = combo.up('form').down('#alternateFaculty');
                    facultyCombo.reset();
                    var alternateFacultyStore = combo.up('form').down('#alternateFaculty').getStore();
               		alternateFacultyStore.getProxy().extraParams = {
            			facultyId : facultyId,
            			courseId : comboValue
            		};
               		alternateFacultyStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==1){
									   this$.getProgramcoursesearchwindow().down('#alternateFaculty').reset();
									   this$.getProgramcoursesearchwindow().down('#alternateFaculty').setValue(records[0].get('id'));
								   }
							   }
						   }
            		});
                    var store = courseVariantCombo.getStore();
                    store.getProxy().extraParams = {
                    	courseId : comboValue,
                    	facultyId : facultyId,
                    	sectionAtComponentLevel:false
                    };
                    store.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==1){
									   courseVariantCombo.setValue(records[0].get('id'));
								   }
							   }
						   }
            		});
                    if(sectionType == "ProgramBatchSection"){
                    	this$.getProgramcoursesearchwindow().down('#programComboField').setDisabled(false);
                    	var programStore = this$.getProgramcoursesearchwindow().down('#programComboField').getStore();
                    	programStore.getProxy().extraParams = {
                    		facultyId : facultyId,
                    		academyLocationIds : academyLocationId,
                    		courseId : comboValue
                    	};
                    	programStore.load({
                    		callback: function(records, operation, success) {
                    			if (success) {
                    				if(records.length==1){
                    					this$.getProgramcoursesearchwindow().down('#programComboField').setValue(records[0].get('id'));
                    					var batchCombo = this$.getProgramcoursesearchwindow().down('#batch');
                    					batchCombo.setDisabled(false);
                    					var comboValue = combo.getValue();
                    					var batchStore = this$.getStore('common.BatchesByProgramId');
                    					batchStore.getProxy().extraParams = {
                    						id: records[0].get('id')
                    					};
                    					batchStore.load({
                    						callback: function(records, operation, success) {
                    							if (success) {
                    								if(records.length==1){
                    									batchCombo.setValue(records[0].get('id'));
                    									var period = this$.getProgramcoursesearchwindow().down('#period');
                    									period.reset();
                    									period.setDisabled(false);
                    									var periodStore = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                    									periodStore.getProxy().extraParams = {
                    										id: records[0].get("id")
                    									};
                    									periodStore.load({
                    										callback: function(records, operation, success) {
                    											if (success) {
                    												if(records.length==1){
                    													var periodId = records[0].get("id")
                    													period.setValue(periodId);
                    													this$.getProgramcoursesearchwindow().down('#section').setDisabled(false);
                    													// load section on the basis of period ID
                    													var storeSection = this$.getStore('attendance.SectionAndFacultyByPeriodIDInPC');
                    													storeSection.getProxy().extraParams = {
                    														periodId:periodId
                    													};
                    													storeSection.load({
                    														callback: function(records, operation, success) {
                    															if (success) {
                    																if(records.length==1){
                    																	this$.getProgramcoursesearchwindow().down('#section').setValue(records[0].get("sectionId"));
                    																}
                    															}
                    														}
                    													});

                    												}
                    											}
                    										}
                    									});
                    								}
                    							}
                    						}
                    					});
                    				}
                    			}
                    		}
                    	});
                    }else if(sectionType == "CourseSection"){
                    	this$.getProgramcoursesearchwindow().down('#programComboField').reset();
                    	this$.getProgramcoursesearchwindow().down('#batch').reset();
                    	this$.getProgramcoursesearchwindow().down('#period').reset();
                    	this$.getProgramcoursesearchwindow().down('#section').reset();
                    	this$.getProgramcoursesearchwindow().down('#programComboField').setDisabled(true);
                    	this$.getProgramcoursesearchwindow().down('#batch').setDisabled(true);
                    	this$.getProgramcoursesearchwindow().down('#period').setDisabled(true);
                    	this$.getProgramcoursesearchwindow().down('#section').setDisabled(true);
                    }

                }
            },
            
            'programcoursesearchwindow customcombobox[itemId=courseVariantId]': {
                select: function(combo, records, eOpts) {
                	var this$ =  this;
                	var facultyId = null;
                	var comboValue = combo.getValue();
                	var academyLocationId = this$.getCurrentAcademyLocation();
                	var sectionType = records[0].get('sectionType');
                	this$.getProgramcoursesearchwindow().down('#programComboField').reset();
                	this$.getProgramcoursesearchwindow().down('#batch').reset();
                	this$.getProgramcoursesearchwindow().down('#period').reset();
                	this$.getProgramcoursesearchwindow().down('#section').reset();
                	this$.getProgramcoursesearchwindow().down('#batch').setDisabled(true);
                	this$.getProgramcoursesearchwindow().down('#period').setDisabled(true);
                	this$.getProgramcoursesearchwindow().down('#section').setDisabled(true);
                	var whetherSchoolStatus;
                    if(this.getCurrentLoggedPortalId()==1){
                    	var personProfile = this$.getContentPanelActiveTab();
                    	facultyId = personProfile.getUserId();
                    }else if(this.getCurrentLoggedPortalId()==2){
                    	facultyId = this.getCurrentlyLoggedInUser().id;
                    	whetherSchoolStatus=false;
                    }
                    var facultyCombo = combo.up('form').down('#alternateFaculty');
                    facultyCombo.reset();
                    var alternateFacultyStore = combo.up('form').down('#alternateFaculty').getStore();
               		alternateFacultyStore.getProxy().extraParams = {
            			facultyId : facultyId,
            			courseVariantId : comboValue
            		};
               		alternateFacultyStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==1){
									   this$.getProgramcoursesearchwindow().down('#alternateFaculty').reset();
									   this$.getProgramcoursesearchwindow().down('#alternateFaculty').setValue(records[0].get('id'));
								   }
							   }
						   }
            		});
               		if(sectionType == "ProgramBatchSection"){
               		this$.getProgramcoursesearchwindow().down('#programComboField').setDisabled(false);
                	var programStore = this$.getProgramcoursesearchwindow().down('#programComboField').getStore();
                	programStore.getProxy().extraParams = {
                		facultyId : facultyId,
                		academyLocationIds : academyLocationId,
                		courseVariantId : comboValue,
                		whetherSchool : whetherSchoolStatus
                	};
                	programStore.load({
                		callback: function(records, operation, success) {
                			if (success) {
                				if(records.length==1){
                					this$.getProgramcoursesearchwindow().down('#programComboField').setValue(records[0].get('id'));
                					var batchCombo = this$.getProgramcoursesearchwindow().down('#batch');
                					batchCombo.setDisabled(false);
                					var comboValue = combo.getValue();
                					var batchStore = this$.getProgramcoursesearchwindow().down('#batch').getStore();;
                					batchStore.getProxy().extraParams = {
                						id: records[0].get('id')
                					};
                					batchStore.load({
                						callback: function(records, operation, success) {
                							if (success) {
                								if(records.length==1){
                									batchCombo.setValue(records[0].get('id'));
                									var period = this$.getProgramcoursesearchwindow().down('#period');
                									period.reset();
                									period.setDisabled(false);
                									var periodStore = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                									periodStore.getProxy().extraParams = {
                										id: records[0].get("id")
                									};
                									periodStore.load({
                										callback: function(records, operation, success) {
                											if (success) {
                												if(records.length==1){
                													var periodId = records[0].get("id")
                													period.setValue(periodId);
                													this$.getProgramcoursesearchwindow().down('#section').setDisabled(false);
                													// load section on the basis of period ID
                													var storeSection = this$.getStore('attendance.SectionAndFacultyByPeriodIDInPC');
                													storeSection.getProxy().extraParams = {
                														periodId:periodId
                													};
                													storeSection.load({
                														callback: function(records, operation, success) {
                															if (success) {
                																if(records.length==1){
                																	this$.getProgramcoursesearchwindow().down('#section').setValue(records[0].get("sectionId"));
                																}
                															}
                														}
                													});

                												}
                											}
                										}
                									});
                								}
                							}
                						}
                					});
                				}
                			}
                		}
                	});
                }else if(sectionType == "CourseSection"){
                	this$.getProgramcoursesearchwindow().down('#programComboField').reset();
                	this$.getProgramcoursesearchwindow().down('#batch').reset();
                	this$.getProgramcoursesearchwindow().down('#period').reset();
                	this$.getProgramcoursesearchwindow().down('#section').reset();
                	this$.getProgramcoursesearchwindow().down('#programComboField').setDisabled(true);
                	this$.getProgramcoursesearchwindow().down('#batch').setDisabled(true);
                	this$.getProgramcoursesearchwindow().down('#period').setDisabled(true);
                	this$.getProgramcoursesearchwindow().down('#section').setDisabled(true);
                }
                }
            },
            'facultycourseinterestgrid[itemId=facultycourseinterestgridId]': {
				render: function(grid) {
 					this.loadGridStore('#facultycourseinterestgridId',SERVERURL.FIND_FACULTY_COURSE_INTEREST_FACULTYID);
 					var portalId = this.getCurrentLoggedPortalId();
 					if (portalId == 1){
 						this.doAccessControlValidation(grid, this.getFACULTY_COURSE_INTEREST_PERMISSIONS());
 						this.addDataGridConfigButton(grid,this.getFACULTY_COURSE_INTEREST_PERMISSIONS());
 					} else if (portalId == 2){
 						this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_COURSE_INTEREST_INFORMATION_PERMISSIONS());
 					}
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var mainGrid = this.getFacultycourseinterestgrid();
					var columnName = mainGrid.columnManager.columns[cellIndex].dataIndex;
					if (columnName == "courseVariantCount") {
						if (e.target.tagName == 'A') {
	                   		if(record.data.courseVariantCount>0){
								this.linkNoOfVariants(grid, rowIndex, record);
							}
						}
					}
				}
			},
			'facultycourseinterestgrid button[itemId=btnAdd]': {
				click: function() {
					this.showPersonCommonWindow('FACULTY_COURSE_INTEREST', 'facultycourseinterestform');
					
					var this$ = this;
					
					var form = this$.getFacultycourseinterestform();
					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down("#facultycourseinterestgridId");
					var gridData = grid.getStore();
					var courseIds = [];
					if(!isNullOrEmpty(gridData.getRange())) {
		        		for(var i=0; i<gridData.getRange().length;i++) {
		        			if(isNullOrEmpty(gridData.getRange()[i].data.courseComponentId)) {
		        				courseIds.push(gridData.getRange()[i].data.courseId);
		        			}	
		        		}
		        	}
					
					var form = this$.getFacultycourseinterestform();
					
					var courseId = form.down("#courseId");
					courseId.clearValue();
					courseId.getStore().getProxy().extraParams = {
						courseIds:courseIds.join()
					}
					courseId.getStore().load();
					var courseCESMCodeCombo = form.down('#courseCESMCodeId');
					courseCESMCodeCombo.getStore().getProxy().extraParams = {
					}
					courseCESMCodeCombo.getStore().load();
				}
			},
			'facultycourseinterestgrid button[itemId=btnEdit]': {
				click: function() {
					this.editFacultyCourseInterest('FACULTY_COURSE_INTEREST','facultycourseinterestform','#facultycourseinterestgridId',false);
				}
			},
			'facultycourseinterestgrid button[itemId=btnDelete]': {
				click: function() {
					this.deleteEditFacultyCourseInterest('#facultycourseinterestgridId');
				}
			},
			
			'facultycourseinterestgrid button[itemId=btnView]': {
				click: function() {
					this.editFacultyCourseInterest('FACULTY_COURSE_INTEREST', 'facultycourseinterestform','#facultycourseinterestgridId',true);
					//this.doAccessControlValidation(grid, this.facultycourseinterestform());
				}
			},
			'facultycourseinterestform customcombobox#programCESMCodeId': {
				 select: function(obj, record) {
					 var form = this.getFacultycourseinterestform();
					 var programCESMId = form.down("#programCESMCodeId").getValue();
					 var courseCESMCodeId = form.down("#courseCESMCodeId");
					 var courseId = form.down("#courseId");
					 var personProfile = this.getContentPanelActiveTab();
					 var grid = personProfile.down("#facultycourseinterestgridId");
					 var gridData = grid.getStore();
					 courseCESMCodeId.reset();
					 courseId.reset();
					 var store = courseCESMCodeId.getStore();
					 store.getProxy().extraParams = {
						 programCESMId: programCESMId
					 };
					 store.load(); 
					 var courseInterestRoleId = form.down("#courseInterestRoleId");
						courseInterestRoleId.reset();
						courseInterestRoleId.setDisabled(true);
						var courseIds = [];
						if(!isNullOrEmpty(gridData.getRange())) {
			        		for(var i=0; i<gridData.getRange().length;i++) {
			        			if(isNullOrEmpty(gridData.getRange()[i].data.courseComponentId)) {
			        				courseIds.push(gridData.getRange()[i].data.courseId);
			        			}	
			        		}
			        	}
						
						courseId.clearValue();
						 var courseCompIds = [];
							if(!isNullOrEmpty(gridData.getRange())) {
				        		for(var i=0; i<gridData.getRange().length;i++) {
				        			if(!isNullOrEmpty(gridData.getRange()[i].data.courseComponentId)) {
				        				courseCompIds.push(gridData.getRange()[i].data.courseComponentId);
				        			}	
				        		}
				        	}
						courseId.getStore().getProxy().extraParams = {
							courseIds:courseIds.join(),
							courseCompIds:courseCompIds.join(),
							programCesmId:programCESMId
						}
						courseId.getStore().load();
				 }
			 },
			'facultycourseinterestform customcombobox[itemId=courseCESMCodeId]': {
				select: function(combo, records, eOpts) {
					var this$ = this;
					var form = this.getFacultycourseinterestform();
					var courseId = form.down("#courseId");
					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down("#facultycourseinterestgridId");
					var gridData = grid.getStore();
					var courseIds = [];
					if(!isNullOrEmpty(gridData.getRange())) {
		        		for(var i=0; i<gridData.getRange().length;i++) {
		        			if(isNullOrEmpty(gridData.getRange()[i].data.courseComponentId)) {
		        				courseIds.push(gridData.getRange()[i].data.courseId);
		        			}	
		        		}
		        	}
					var courseId = form.down("#courseId");
					courseId.clearValue();
					 var courseCompIds = [];
						if(!isNullOrEmpty(gridData.getRange())) {
			        		for(var i=0; i<gridData.getRange().length;i++) {
			        			if(!isNullOrEmpty(gridData.getRange()[i].data.courseComponentId) && (!isNullOrEmpty(gridData.getRange()[i].data.actionStatus) && gridData.getRange()[i].data.actionStatus!="Declined")) {
			        				courseCompIds.push(gridData.getRange()[i].data.courseComponentId);
			        			}	
			        		}
			        	}
					var facultyId = grid.up('contentpanel').down('#facultyProfileView').getStore().getRange()[0].data.id;
					courseId.getStore().getProxy().extraParams = {
						courseCESMCode:records[0].data.id,
						courseIds:courseIds.join(),
						courseCompIds:courseCompIds.join(),
						facultyId : facultyId
					}
					courseId.getStore().load({
							   callback: function(records, operation, success) {
								   if (success) {
									var courseComponent = form.down("#courseComponent");
									   if(records.length>0){
									        courseId.setValue(records);
										   
										}else {
										   courseId.clearValue();
									}
								   }
							   }
						   });
					var courseInterestRoleId = form.down("#courseInterestRoleId");
					courseInterestRoleId.clearValue();
					courseInterestRoleId.getStore().getProxy().extraParams = {
						courseCESMId:records[0].data.id
					}
					courseInterestRoleId.getStore().load();
					courseInterestRoleId.setDisabled(false);
			}
			},
			'facultycourseinterestform customcombobox[itemId=courseId]': {
				select: function(combo, records, eOpts) {
					
					var this$ = this;
					var personProfile = this$.getContentPanelActiveTab();
					var grid = personProfile.down("#facultycourseinterestgridId");
					var gridData = grid.getStore();
					var courseCompIds = [];
					if(!isNullOrEmpty(gridData.getRange())) {
		        		for(var i=0; i<gridData.getRange().length;i++) {
		        			if(!isNullOrEmpty(gridData.getRange()[i].data.courseComponentId)) {
		        				courseCompIds.push(gridData.getRange()[i].data.courseComponentId);
		        			}	
		        		}
		        	}
					
					var form = this.getFacultycourseinterestform();
					
					var courseComponent = form.down("#courseComponent");
					 var formidId = form.down('#facultycourseinterest_hidden_field');
					var courseCESMCodeId = form.down('#courseCESMCodeId');
					if(!isNullOrEmpty(records[0].data.scholarshipAmount) && !isNullOrEmpty(formidId.getValue())){
						courseCESMCodeId.setValue(records[0].data.scholarshipAmount);
					}else if(!isNullOrEmpty(formidId.getValue())){
						courseCESMCodeId.setValue(null);
					}
					courseComponent.setDisabled(false);
					courseComponent.clearValue();
					courseComponent.getStore().getProxy().extraParams = {
						courseId:records[0].data.id,
						courseComponentIds:courseCompIds.join()
					}
					courseComponent.getStore().load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										courseComponent.setValue(records[0].get("id"));
									   }
								   }
							   }
						   });
				}
			},
			
			'facultycourseinterestform button[itemId=submitButtonId]': {
				click: function() {
					this.saveEditFacultyCourseInterest("#facultycourseinterestgridId");
				}
			},
			'facultycourseinterestform button[itemId=cancelButtonId]': {
				click: function() {
					this.closePersonCommonWindow();
				}
			},

			'facultydutyfilter customcombobox[itemId=roleItemId]': {
				select: function(combo, records, eOpts) {
					var $this=this;
					var form = combo.up('form').getForm();
					var userId = $this.getUserInfo();
					var data = records[0].data;
					var group = form.findField('evaluationGroupId');
					group.reset();
					group.getStore().getProxy().extraParams={
						usersId:userId,
						roleName:data.value
					};
					group.getStore().load();
					group.setDisabled(false);
					var programId = form.findField('programId');
					var batchId = form.findField('batchId');
					var periodId = form.findField('periodId');
					var courseId = form.findField('courseId');
					var centerName = form.findField('centerName');
					var dateTill = form.findField('dateTill');
					var periodFrom = form.findField('periodFrom');
					periodFrom.reset();
					dateTill.reset();
					programId.setDisabled(true);
					batchId.setDisabled(true);
					periodId.setDisabled(true);
					courseId.setDisabled(true);
					programId.reset();
					batchId.reset();
					periodId.reset();
					courseId.reset();
					centerName.reset();
					if(data.value=='PAPER_SETTER') {
						courseId.setVisible(true);
						periodId.setVisible(true);
						batchId.setVisible(true);
						programId.setVisible(true);
						centerName.setVisible(false);
					} else {
						courseId.setVisible(false);
						periodId.setVisible(false);
						batchId.setVisible(false);
						programId.setVisible(false);
						centerName.setVisible(true);
						centerName.setDisabled(true);
					}
				}
			},
			
			'facultydutyfilter customcombobox[itemId=evaluationGroupItemId]': {
				select: function(combo, records, eOpts) {
					var $this=this;
					var form = combo.up('form').getForm();
					var userId = $this.getUserInfo();
					var data = records[0].data;
					var centerName = form.findField('centerName');
					centerName.reset();
					var role = form.findField('role');
					if(role.getRawValue()=='PAPER_SETTER') {
						var programId = form.findField('programId');
						var batchId = form.findField('batchId');
						var periodId = form.findField('periodId');
						var courseId = form.findField('courseId');
						programId.setDisabled(false);
						batchId.setDisabled(true);
						periodId.setDisabled(true);
						courseId.setDisabled(true);
						programId.reset();
						batchId.reset();
						periodId.reset();
						courseId.reset();
						programId.getStore().getProxy().extraParams={
							evaluationGroupId:data.id
						};
						programId.getStore().load();
						programId.setDisabled(false);
					} else {
						centerName.getStore().getProxy().extraParams={
							usersId:userId,
							roleName:role.getRawValue(),
							evaluationGroupId:data.id
						};
						centerName.getStore().load();
						centerName.setDisabled(false);
					}
				}
			},
			'facultydutyfilter customcombobox[itemId=programIdItemId]': {
				select: function(combo, records, eOpts) {
					var $this=this;
					var form = combo.up('form').getForm();
					var userId = $this.getUserInfo();
					var data = records[0].data;
					var role = form.findField('role');
					var programId = form.findField('programId');
					var batchId = form.findField('batchId');
					var periodId = form.findField('periodId');
					var courseId = form.findField('courseId');
					periodId.setDisabled(true);
					courseId.setDisabled(true);
					batchId.reset();
					periodId.reset();
					courseId.reset();
					batchId.getStore().getProxy().extraParams={
						programId:data.id
					};
					batchId.getStore().load();
					batchId.setDisabled(false);
				}
			},
			'facultydutyfilter customcombobox[itemId=batchIdItemId]': {
				select: function(combo, records, eOpts) {
					var $this=this;
					var form = combo.up('form').getForm();
					var userId = $this.getUserInfo();
					var data = records[0].data;
					var role = form.findField('role');
					var programId = form.findField('programId');
					var evaluationGroupId = form.findField('evaluationGroupId');
					var batchId = form.findField('batchId');
					var periodId = form.findField('periodId');
					var courseId = form.findField('courseId');
					courseId.setDisabled(true);
					periodId.reset();
					courseId.reset();
					periodId.getStore().getProxy().extraParams={
						batchId:data.id,
						programId:programId.getValue(),
						evaluationGroupId:evaluationGroupId.getValue()
					};
					periodId.getStore().load();
					periodId.setDisabled(false);
				}
			},
			'facultydutyfilter customcombobox[itemId=periodItemId]': {
				select: function(combo, records, eOpts) {
					var $this=this;
					var form = combo.up('form').getForm();
					var userId = $this.getUserInfo();
					var data = records[0].data;
					var role = form.findField('role');
					var programId = form.findField('programId');
					var evaluationGroupId = form.findField('evaluationGroupId');
					var batchId = form.findField('batchId');
					var periodId = form.findField('periodId');
					var courseId = form.findField('courseId');
					courseId.reset();
					courseId.getStore().getProxy().extraParams={
						batchId:batchId.getValue(),
						programId:programId.getValue(),
						periodId:data.id,
						evaluationGroupId:evaluationGroupId.getValue()
					};
					courseId.getStore().load();
					courseId.setDisabled(false);
				}
			},
			
			'facultydutyfilter button[itemId=resetBtn]': {
				click: function(combo) {
					var $this=this;
					var form = combo.up('form').getForm();
					form.reset();
					var programId = form.findField('programId');
					var batchId = form.findField('batchId');
					var periodId = form.findField('periodId');
					var courseId = form.findField('courseId');
					var centerName = form.findField('centerName');
					var evaluationGroupId = form.findField('evaluationGroupId');
					var dateTill = form.findField('dateTill');
					var periodFrom = form.findField('periodFrom');
					periodFrom.reset();
					dateTill.reset();
					evaluationGroupId.setDisabled(true);
					programId.setDisabled(true);
					batchId.setDisabled(true);
					periodId.setDisabled(true);
					courseId.setDisabled(true);
					programId.reset();
					batchId.reset();
					periodId.reset();
					courseId.reset();
					centerName.reset();
					centerName.setDisabled(true);
					courseId.setVisible(false);
					periodId.setVisible(false);
					batchId.setVisible(false);
					programId.setVisible(false);
					centerName.setVisible(true);
				}
			},
			
			'facultydutyfilter button[itemId=searchBtn]': {
				click: function(combo) {
					var $this=this;
					var form = combo.up('form').getForm();
					var formValue = form.getValues();
					var userId = $this.getUserInfo();
					var centerName = form.findField('centerName');
					var role = form.findField('role');
					var evaluationGroupId = form.findField('evaluationGroupId');
					var grid= $this.getExaminationdutypapersattergrid();
					if(role.getRawValue()=='INVIGILATOR'){
					    grid= $this.getExaminationdutygrid();
					    $this.getExaminationdutysupervisorgrid().setVisible(false);
					    $this.getExaminationdutyexaminergrid().setVisible(false);
					    $this.getExaminationdutypapersattergrid().setVisible(false);
					} else if(role.getRawValue()=='PAPER_SETTER'){
					    grid= $this.getExaminationdutypapersattergrid();
					    $this.getExaminationdutygrid().setVisible(false);
					    $this.getExaminationdutysupervisorgrid().setVisible(false);
					    $this.getExaminationdutyexaminergrid().setVisible(false);
					} else if(role.getRawValue()=='EXAMINER'){
					    grid= $this.getExaminationdutyexaminergrid();
					    $this.getExaminationdutygrid().setVisible(false);
					    $this.getExaminationdutysupervisorgrid().setVisible(false);
					    $this.getExaminationdutypapersattergrid().setVisible(false);
					} else if(role.getRawValue()=='CENTER_SUPERVISOR') {
						grid= $this.getExaminationdutysupervisorgrid();
						$this.getExaminationdutypapersattergrid().setVisible(false);
					    $this.getExaminationdutysupervisorgrid().setVisible(false);
					    $this.getExaminationdutyexaminergrid().setVisible(false);
					}
					$this.getExaminationdutygrid().setVisible(false);
					$this.getExaminationdutysupervisorgrid().setVisible(false);
					$this.getExaminationdutyexaminergrid().setVisible(false);
					grid.setVisible(true);
					var type = !isNullOrEmpty(centerName)?
							(!isNullOrEmpty(centerName.valueModels[0])?(!isNullOrEmpty(centerName.valueModels[0].data.code)?
									centerName.valueModels[0].data.code:null):null):null;
					grid.getStore().getProxy().extraParams={
						usersId:userId,
						roleName:role.getRawValue(),
						evaluationGroupId:formValue.evaluationGroupId,
						centerType:type,
						examCenterId:centerName.getValue(),
						programId:formValue.programId,
						batchId:formValue.batchId,
						periodId:formValue.periodId,
						courseId:formValue.courseId,
						startDate:formValue.periodFrom,
						endDate:formValue.dateTill
					};
					grid.getStore().load();
				}
			},
			'courseexecutionreportstructure combo#programId': {
				   select: function(obj, record) {
					   var this$ = this;
					   var programId = record[0].get("id");
					   var form = this.getCourseexecutionreportstructure();
					   var batch = form.down('#batchId');
					   batch.reset();
					   form.down('#periodId').reset();
					   form.down('#courseIdPBS').reset();
					   form.down('#programSectionId').reset;
					   if(programId > 0){
						   var batchStore = this.getStore('enquiry.AcademicBatchStore');
						   batchStore.getProxy().extraParams = {
							   id: programId
						   };
						   batchStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										   batch.setValue(records[0].get("id"));
										   var period = this$.getCourseexecutionreportstructure().down('#periodId');
										   period.reset();
										   var periodStore = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
										   periodStore.getProxy().extraParams = {
											   id: records[0].get("id")
										   };
										   periodStore.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   if(records.length==1){
														   var periodId = records[0].get("id")
														   period.setValue(periodId);
														   var PbsCourse = this$.getCourseexecutionreportstructure().down('#courseIdPBS');
														   PbsCourse.reset();
														   var PbsCourseStore = PbsCourse.getStore();
														   PbsCourseStore.getProxy().extraParams = {
															   periodId:periodId,
															   sectionType:'ProgramBatchSection',
															   facultyId : this$.getCurrentlyLoggedInUser().id,
															   academyLocationId : this$.getCurrentAcademyLocation()
														   };
														   PbsCourseStore.load({
															   callback: function(records, operation, success) {
																   if (success) {
																	   if(records.length==1){
																		   PbsCourse.setValue(records[0].get('courseId'));
																	   }
																   }
															   }
														   });
														   // load section on the basis of period ID
														   var storeSection = this$.getStore('coursetransaction.sectionmanagement.SectionsStore');
														   storeSection.getProxy().extraParams = {
															   periodId:periodId
														   };
														   storeSection.load({
															   callback: function(records, operation, success) {
																   if (success) {
																	   if(records.length==1){
																		   this$.getCourseexecutionreportstructure().down('#programSectionId').setValue(records[0].get("id"));
																	   }
																   }
															   }
														   });

													   }
												   }
											   }
										   });
									   }
								   }
							   }
						   });
					   }
				   }
			},
			   'courseexecutionreportstructure': {
				   render: function(obj) {
					   var this$ = this;
					   var academyLocationId = this$.getCurrentAcademyLocation();
					   var form = this$.getCourseexecutionreportstructure();
					   var programStore = form.down('#programId').getStore();
					   var courseIdPbsStore = form.down('#courseIdPBS').getStore();
					   courseIdPbsStore.getProxy().extraParams = {
						   academyLocationId: academyLocationId,
						   facultyId : this.getCurrentlyLoggedInUser().id,
						   sectionType : "ProgramBatchSection"
					   };
					   courseIdPbsStore.load();
					   programStore.getProxy().extraParams = {
						   academyLocationIds: academyLocationId,
						   facultyId : this$.getCurrentlyLoggedInUser().id
					   };
					   programStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==1){
									   form.down('#programId').setValue(records[0].get("id"));
									   var batch = this$.getCourseexecutionreportstructure().down('#batchId');
									   batch.reset();
									   var batchStore = this$.getStore('enquiry.AcademicBatchStore');
									   batchStore.getProxy().extraParams = {
										   id: records[0].get("id")
									   };
									   batchStore.load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length==1){
													   batch.setValue(records[0].get("id"));
													   var period = this$.getCourseexecutionreportstructure().down('#periodId');
													   period.reset();
													   var periodStore = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
													   periodStore.getProxy().extraParams = {
														   id: records[0].get("id")
													   };
													   periodStore.load({
														   callback: function(records, operation, success) {
															   if (success) {
																   if(records.length==1){
																	   var periodId = records[0].get("id");
																	   period.setValue(periodId);
																	   var PbsCourse = this$.getCourseexecutionreportstructure().down('#courseIdPBS');
																	   PbsCourse.reset();
																	   var PbsCourseStore = PbsCourse.getStore();
																	   PbsCourseStore.getProxy().extraParams = {
																		   periodId:periodId,
																		   sectionType:'ProgramBatchSection',
																		   facultyId : this$.getCurrentlyLoggedInUser().id,
																		   academyLocationId : this$.getCurrentAcademyLocation()
																	   };
																	   PbsCourseStore.load({
																		   callback: function(records, operation, success) {
																			   if (success) {
																				   if(records.length==1){
																					   PbsCourse.setValue(records[0].get('courseId'));
																				   }
																			   }
																		   }
																	   });
																	   // load section on the basis of period ID
																	   var storeSection = this$.getStore('coursetransaction.sectionmanagement.SectionsStore');
																	   storeSection.getProxy().extraParams = {
																		   periodId:periodId
																	   };
																	   storeSection.load({
																		   callback: function(records, operation, success) {
																			   if (success) {
																				   if(records.length==1){
																					   this$.getCourseexecutionreportstructure().down('#programSectionId').setValue(records[0].get("id"));
																				   }
																			   }
																		   }
																	   });

																   }
															   }
														   }
													   });
												   }
											   }
										   }
									   });
								   }
							   }
						   }
					   });
				   },
				   afterrender : function(){
					   var this$ = this;
					   var form = this$.getCourseexecutionreportstructure();
					   var value = form.down('#selectionTypeId').getValue();

					   if(value.selectionType =='PROGRAM_BATCH_SECTION'){
						   var values = new Object();  
						   values.configCode = CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_PBS_VIEWCODE;
						   var jsonFormatFormData = this$.createJsonCourseExecutionPBS(form,null);
						   var searchResultGrid = this$.getCourseexecutionreportstructureGrIdPBS();
						   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
						   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_PBS_VIEWCODE);
						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
						   Ext.getBody().unmask();
					   } else if(value.selectionType =='COURSE_SECTION'){
						   var values = new Object();  
						   values.configCode = CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_CBS_VIEWCODE;
						   var jsonFormatFormData = this$.createJsonCourseExecutionCBS(form,null);
						   var searchResultGrid = this$.getCourseexecutionreportstructureGrIdCBS();
						   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
						   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_CBS_VIEWCODE);
						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);	
						   Ext.getBody().unmask();
					   }
					   
					   this$.setTabPbsCbsPermission("courseExecutionReportFaculty");
				   }
			   },
			   'courseexecutionreportstructure combo#courseIdCBS': {
				   select: function(obj, record) {
					   var this$ = this;
					   var form = this.getCourseexecutionreportstructure();
					   var courseId = form.down('#courseIdCBS').getValue();
					   var academicTermId = form.down('#academicTermId').getValue();
					   //var courseId = record[0].get("id");
					   var courseVariantId = form.down('#courseVariantId');
					   courseVariantId.reset();
					   courseVariantId.setDisabled(false);
					   if(courseId > 0){
						   var courseVariantStore = courseVariantId.getStore();
						   courseVariantStore.getProxy().extraParams = {
							   courseId:courseId,
							   facultyId : this.getCurrentlyLoggedInUser().id,
							   academicTermId:academicTermId
						   };
						   courseVariantStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										   courseVariantId.setValue(records[0].get('id'));
									   }
								   }
							   }
						   });
					   }
				   }
			   },
			   'courseexecutionreportstructure combo#academicTermId': {
				   select: function(obj, record) {
					   var this$ = this;
					   var form = this.getCourseexecutionreportstructure();
					   var courseCBS = form.down('#courseIdCBS');
					   var courseId = form.down('#courseIdCBS').getValue();
					   var academicTermId = form.down('#academicTermId').getValue();
					   //var courseId = record[0].get("id");
					   var courseVariantId = form.down('#courseVariantId');
					   courseVariantId.reset();
					   courseVariantId.setDisabled(true);
					   var academyLocationId=this.getCurrentAcademyLocation();
					   var courseIdCbsStore = courseCBS.getStore();
					   courseIdCbsStore.getProxy().extraParams = {
						   academyLocationIds: academyLocationId,
						   facultyId : this$.getCurrentlyLoggedInUser().id,
						   sectionType : "CourseSection",
						   academicTermId:academicTermId
					   };
					   courseIdCbsStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   var sectionId = form.down('#courseSectionId');		    												   
								   if(records.length==1){
									   courseCBS.setValue(records[0].get('courseId'));
									   courseVariantId.reset();
									   courseVariantId.setDisabled(false);
									   var courseVariantStore = courseVariantId.getStore();
									   courseVariantStore.getProxy().extraParams = {
										   academyLocationIds: academyLocationId,
										   courseId:records[0].get('courseId'),
										   facultyId : this$.getCurrentlyLoggedInUser().id,
										   academicTermId:academicTermId
									   };
									   courseVariantStore.load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length==1){
													   courseVariantId.setValue(records[0].get('id'));
												   }
											   }
										   }
									   });
								   }
							   }
						   }
					   });
				   }
			   },
			   
			   'courseexecutionreportstructure combo#periodId': {
				   select: function(obj, record) {
					   var this$ = this;
					   var periodId = record[0].get("id");
					   var form = this.getCourseexecutionreportstructure();
					   var PbsCourse = form.down('#courseIdPBS');
					   PbsCourse.reset();	    	        				   
					   if(periodId > 0){
						   var PbsCourseStore = PbsCourse.getStore();
						   PbsCourseStore.getProxy().extraParams = {
							   periodId:periodId,
							   sectionType:'ProgramBatchSection',
							   facultyId : this.getCurrentlyLoggedInUser().id,
							   academyLocationId : this.getCurrentAcademyLocation()
						   };
						   PbsCourseStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										   PbsCourse.setValue(records[0].get('courseId'));
									   }
								   }
							   }
						   });
						   
						   // load section on the basis of period ID
						   var storeSection = this.getStore('coursetransaction.sectionmanagement.SectionsStore');
						   storeSection.getProxy().extraParams = {
							   periodId:periodId
						   };
						   storeSection.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										   this$.getCourseexecutionreportstructure().down('#programSectionId').setValue(records[0].get("id"));
									   }
								   }
							   }
						   });
					   }
				   }
			   },
			   'courseexecutionreportstructure combo#batchId':{
				   select:function(obj, record){
					   var this$ = this;
					   var form = this.getCourseexecutionreportstructure();
					   var period = form.down('#periodId');
					   period.reset();
					   var batchId = record[0].get("id");
					   if(batchId !=''){	    	        					  
						   var periodStore = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
						   periodStore.getProxy().extraParams = {
							   id: batchId
						   };
						   periodStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										   var periodId = records[0].get("id")
										   period.setValue(periodId);
										   var PbsCourse = this$.getCourseexecutionreportstructure().down('#courseIdPBS');
										   PbsCourse.reset();
										   var PbsCourseStore = PbsCourse.getStore();
										   PbsCourseStore.getProxy().extraParams = {
											   periodId:periodId,
											   sectionType:'ProgramBatchSection',
											   facultyId : this$.getCurrentlyLoggedInUser().id,
											   academyLocationId : this$.getCurrentAcademyLocation()
										   };
										   PbsCourseStore.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   if(records.length==1){
														   PbsCourse.setValue(records[0].get('courseId'));
													   }
												   }
											   }
										   });
										   // load section on the basis of period ID
										   var storeSection = this$.getStore('coursetransaction.sectionmanagement.SectionsStore');
										   storeSection.getProxy().extraParams = {
											   periodId:periodId
										   };
										   storeSection.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   if(records.length==1){
														   this$.getCourseexecutionreportstructure().down('#programSectionId').setValue(records[0].get("id"));
													   }
												   }
											   }
										   });

									   }
								   }
							   }
						   });
					   }
				   }
			   },
			   'courseexecutionreportstructure radiogroup#selectionTypeId':{
				   change : function(obj,val){
					   var this$ =  this;
					   var form = this.getCourseexecutionreportstructure();
					   var value = form.down('#selectionTypeId').getValue();
					   var program = form.down('#programId');
					   var batch = form.down('#batchId');
					   var period = form.down('#periodId');
					   var coursePBS = form.down('#courseIdPBS');
					   var courseCBS = form.down('#courseIdCBS');
					   var academicTermId = form.down('#academicTermId');
					   var courseVariantId = form.down('#courseVariantId');
					   var programSectionId = form.down('#programSectionId');
					  
					   var delayedCourseSearchGrIdPBS = form.down('#facultydelayedCourseSearchGrIdPBS');
					   var delayedCourseSearchGrIdCBS = form.down('#facultydelayedCourseSearchGrIdCBS');
					   if(value.selectionType =='COURSE_SECTION'){
						   program.setVisible(false);
						   batch.setVisible(false);
						   period.setVisible(false);
						   coursePBS.setVisible(false);
						   courseCBS.setVisible(true);
						   programSectionId.setVisible(false);	                					   
						   academicTermId.setVisible(true);
						   academicTermId.reset();
						   courseVariantId.setVisible(true);
						   courseVariantId.setDisabled(true);
						   courseVariantId.reset();
						   delayedCourseSearchGrIdCBS.setVisible(true);
						   delayedCourseSearchGrIdPBS.setVisible(false);
						   var academyLocationId=this.getCurrentAcademyLocation();
						   var courseIdCbsStore = courseCBS.getStore();
						   var academicTermComboStore = academicTermId.getStore();
		    				   academicTermComboStore.getProxy().extraParams = {
		    					  academyLocationIds : academyLocationId
		    				   };
		    				   academicTermComboStore.load({

		    					  callback: function(rec, success) {
		    						  if (success) {
		    							  for(var i in rec){
		    								  if(rec[i].get('sequence')==1){
		    									  this$.getCourseexecutionreportstructure().down('#academicTermId').setValue(rec[i].get('id'));
		    									  var academicTermId = rec[i].get('id');
		    									  courseIdCbsStore.getProxy().extraParams = {
		    										   academyLocationIds: academyLocationId,
		    										   facultyId : this$.getCurrentlyLoggedInUser().id,
		    										   sectionType : "CourseSection",
		    										   academicTermId:academicTermId
		    									   };
		    									   courseIdCbsStore.load({
		    										   callback: function(records, operation, success) {
		    											   if (success) {
		    												   var sectionId = form.down('#courseSectionId');		    												   
		    												   if(records.length==1){
		    													   courseCBS.setValue(records[0].get('courseId'));
		    													   courseVariantId.reset();
		    													   courseVariantId.setDisabled(false);
		    													   var courseVariantStore = courseVariantId.getStore();
		    													   courseVariantStore.getProxy().extraParams = {
		    														   academyLocationIds: academyLocationId,
		    														   courseId:records[0].get('courseId'),
		    														   facultyId : this$.getCurrentlyLoggedInUser().id,
		    			    										   academicTermId:academicTermId
		    													   };
		    													   courseVariantStore.load({
		    														   callback: function(records, operation, success) {
		    															   if (success) {
		    																   if(records.length==1){
		    																	   courseVariantId.setValue(records[0].get('id'));
		    																   }
		    															   }
		    														   }
		    													   });
		    												   }
		    											   }
		    										   }
		    									   });
		    								  }
		    							  }
		    							  var values = new Object();  
		    							   values.configCode = CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_CBS_VIEWCODE;
		    							   var jsonFormatFormData = this$.createJsonCourseExecutionCBS(form,null);
		    							   var searchResultGrid = this$.getCourseexecutionreportstructureGrIdCBS();
		    							   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
		    							   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_CBS_VIEWCODE);
		    							   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		    							   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);	
		    							   Ext.getBody().unmask();
		    						  }
		    					  }
		    				   });
						   
						   
					   }  else if(value.selectionType=='PROGRAM_BATCH_SECTION'){
						   program.setVisible(true);
						   batch.setVisible(true);
						   period.setVisible(true);
						   coursePBS.setVisible(true);
						   courseCBS.setVisible(false);
						   courseCBS.clearValue();
						   academicTermId.setVisible(false);
						   academicTermId.reset();
						   courseVariantId.setVisible(false);
						   courseVariantId.setDisabled(true);
						   courseVariantId.reset();
						   programSectionId.setVisible(true);
						   var programStore = program.getStore();
						   delayedCourseSearchGrIdCBS.setVisible(false);
						   delayedCourseSearchGrIdPBS.setVisible(true);
						   var courseIdPbsStore = coursePBS.getStore();
						   courseIdPbsStore.getProxy().extraParams = {
							   academyLocationId: this$.getCurrentAcademyLocation(),
							   facultyId : this.getCurrentlyLoggedInUser().id,
							   sectionType : "ProgramBatchSection"
						   };
						   courseIdPbsStore.load();
						   programStore.getProxy().extraParams = {
							   academyLocationIds: this$.getCurrentAcademyLocation(),
							   facultyId : this$.getCurrentlyLoggedInUser().id
						   };
						   programStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==1){
										   form.down('#programId').setValue(records[0].get("id"));
										   var batch = this$.getCourseexecutionreportstructure().down('#batchId');
										   batch.reset();
										   var batchStore = this$.getStore('enquiry.AcademicBatchStore');
										   batchStore.getProxy().extraParams = {
											   id: records[0].get("id")
										   };
										   batchStore.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   if(records.length==1){
														   batch.setValue(records[0].get("id"));
														   var period = this$.getCourseexecutionreportstructure().down('#periodId');
														   period.reset();
														   var periodStore = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
														   periodStore.getProxy().extraParams = {
															   id: records[0].get("id")
														   };
														   periodStore.load({
															   callback: function(records, operation, success) {
																   if (success) {
																	   if(records.length==1){
																		   var periodId = records[0].get("id");
																		   period.setValue(periodId);
																		   var PbsCourse = this$.getCourseexecutionreportstructure().down('#courseIdPBS');
																		   PbsCourse.reset();
																		   var PbsCourseStore = PbsCourse.getStore();
																		   PbsCourseStore.getProxy().extraParams = {
																			   periodId:periodId,
																			   sectionType:'ProgramBatchSection',
																			   facultyId : this$.getCurrentlyLoggedInUser().id,
																			   academyLocationId : this$.getCurrentAcademyLocation()
																		   };
																		   PbsCourseStore.load({
																			   callback: function(records, operation, success) {
																				   if (success) {
																					   if(records.length==1){
																						   PbsCourse.setValue(records[0].get('courseId'));
																					   }
																				   }
																			   }
																		   });
																		   // load section on the basis of period ID
																		   var storeSection = this$.getStore('coursetransaction.sectionmanagement.SectionsStore');
																		   storeSection.getProxy().extraParams = {
																			   periodId:periodId
																		   };
																		   storeSection.load({
																			   callback: function(records, operation, success) {
																				   if (success) {
																					   if(records.length==1){
																						   this$.getCourseexecutionreportstructure().down('#programSectionId').setValue(records[0].get("id"));
																					   }
																				   }
																			   }
																		   });

																	   }
																   }
															   }
														   });
													   }
												   }
											   }
										   });
									   }
								   }
							   }
						   });
					   }
					   
				   }
			   },
			   
			   'courseexecutionreportstructure button[itemId=btnSearch]':{
				   click : function(model,records){
					   var form = this.getCourseexecutionreportstructure();
					   var value = form.down('#selectionTypeId').getValue();
					   
					   if(value.selectionType =='PROGRAM_BATCH_SECTION'){
						   var values = new Object();  
						   values.configCode = CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_PBS_VIEWCODE;
						   var jsonFormatFormData = this.createJsonCourseExecutionPBS(form,records);
						   var searchResultGrid = this.getCourseexecutionreportstructureGrIdPBS();
						   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
						   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_PBS_VIEWCODE);
						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
						   Ext.getBody().unmask();
					   } else if(value.selectionType =='COURSE_SECTION'){
						   
						   var values = new Object();  
						   values.configCode = CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_CBS_VIEWCODE;
						   var jsonFormatFormData = this.createJsonCourseExecutionCBS(form,records);
						   var searchResultGrid = this.getCourseexecutionreportstructureGrIdCBS();
						   var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
						   resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_CBS_VIEWCODE);
						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						   searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);	
						   Ext.getBody().unmask();
					   }
				   }
			   },
			   
			   'courseexecutionreportstructure button[itemId=btnReset]':{
				  click : function(){
					    var formPbs = this.getCourseexecutionreportstructure().getForm();
			            var formCbs = this.getCourseexecutionreportstructure();
			            var value = formCbs.down('#selectionTypeId').getValue();
				        if(value.selectionType =='COURSE_SECTION')
	                   {
		              formCbs.down('#courseIdCBS').clearValue();
					  formCbs.down('#academicTermId').clearValue();
					  formCbs.down('#courseVariantId').clearValue();
					  formCbs.down('#courseVariantId').setDisabled(true);
                       }
                     else
                        { 
	                      formPbs.reset();
                        }
					  var courseIdPbsStore = this.getCourseexecutionreportstructure().down('#courseIdPBS').getStore();
					   courseIdPbsStore.getProxy().extraParams = {
						   academyLocationId:this.getCurrentAcademyLocation(),
						   facultyId : this.getCurrentlyLoggedInUser().id,
						   sectionType : "ProgramBatchSection"
					   };
					   courseIdPbsStore.load();
					   
				//	   this.setTabPbsCbsPermission("courseExecutionReportFaculty");
				  }   
			   },
			   'coursedocumentlist[itemId=facultyCourseDocumentList] grid[itemId=coursedocumentlistId]':{
					  cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
						  if (e.target.tagName == 'A') {
							  var documentId = record.get("documentId");
							  if (!isNullOrEmpty(documentId)) {
								  this.getDownloadFileForCourseDocument(documentId);
							  }
						  }
					  }  
				  },
				  'facultyprogramassociatedwindow' :{
					  afterrender : function(){
						  var formWindow = this.getFacultyprogramassociatedwindow();
						  var programGrid = formWindow.down('grid');
						  var grid1 = this.getProgramandcoursegrid();
						  var programcoursesearchpanel = grid1.up('tabpanel');
						  
						  if(programcoursesearchpanel.getActiveTab().title == getCommonTranslation('DETAIL_VIEW_REPORT')){
							  var grid = this.getProgramandcoursetreegrid();
						  }
						  else{
							  var grid = this.getProgramandcoursegrid();
						  }
						  
						  var record = grid.getSelectionModel().getSelection();
						  var courseVariantId = record[0].data.variantId;
						  var facultyId = record[0].data.alternateFacultyId2;
						  var submitURL = SERVERURL.PATH_GET_FACULTY_ASSCIATED_PROGRAM;
						  var store = programGrid.getStore();
						  store.getProxy().api.read=submitURL;
						  store.getProxy().extraParams = {
							  courseVariantId: courseVariantId,
							  academyLocationId:this.getCurrentAcademyLocation(),
							  facultyId:facultyId
						  };
						  store.load();
					  }
				  },
				  'facultynoofvariantgridwindow' :{
					  afterrender : function(){
						  var facultyGrid = this.getFacultycourseinterestgrid();
						  var window = this.getFacultynoofvariantgridwindow();
						  var grid = window.down('grid');
						  var records = facultyGrid.getSelectionModel().getSelection();
						  if(records[0].data.assignSectionType == "CourseSection" || records[0].data.assignSectionType == "COURSE_SECTION"){
							  for(var i=0;i<grid.columns.length;i++){
								  if(grid.columns[i].dataIndex == 'programName' || grid.columns[i].dataIndex == 'batch' || grid.columns[i].dataIndex == 'programPeriod'){
									  grid.columns[i].hide();
									  grid.columns[i].hidden = true;
								  }
							  }
						  }
						  var courseId = records[0].data.courseId;
						  var store = grid.getStore();
						  store.getProxy().extraParams = {
							  courseId: courseId
						  };
						  store.loadPage(1);
					  }
				  },
				  
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdPBS]': {
					  render : function(grid) {
						  this.gridRenderFunction(grid);
						  this.genericCBGridAccessControlValidation(grid, this.getFACULTY_COURSE_EXECUTION_REPORT_PERMISSIONS());  
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdCBS]': {
					  render : function(grid) {
						  this.gridRenderFunction(grid);
						  this.genericCBGridAccessControlValidation(grid, this.getFACULTY_COURSE_EXECUTION_REPORT_PERMISSIONS());  
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdPBS] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
					  click: function() {
						  this.exportCourseExecutionReport(SERVERURL.PDFEXPORT,'pdf',false);
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdPBS] splitbutton[itemId=exportToPdfBtn] #exportAll': {
					  click: function() {
						  this.exportCourseExecutionReport(SERVERURL.PDFEXPORT,'pdf',true);
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdPBS] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
					  click: function() {
						  this.exportCourseExecutionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdPBS] splitbutton[itemId=exportToXcelBtn] #exportAll': {
					  click: function() {
						  this.exportCourseExecutionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdCBS] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
					  click: function() {
						  this.exportCourseExecutionReport(SERVERURL.PDFEXPORT,'pdf',false);
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdCBS] splitbutton[itemId=exportToPdfBtn] #exportAll': {
					  click: function() {
						  this.exportCourseExecutionReport(SERVERURL.PDFEXPORT,'pdf',true);
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdCBS] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
					  click: function() {
						  this.exportCourseExecutionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
					  }
				  },
				  'searchresultgrid[itemId=facultydelayedCourseSearchGrIdCBS] splitbutton[itemId=exportToXcelBtn] #exportAll': {
					  click: function() {
						  this.exportCourseExecutionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
					  }
				  },
				  'coursedocumentlist[itemId=facultyCourseDocumentList]' :{
					  afterrender:function() {
						  var grid1 = this.getProgramandcoursegrid();
						  var programcoursesearchpanel = grid1.up('tabpanel');
						  
						  if(programcoursesearchpanel.getActiveTab().title == getCommonTranslation('DETAIL_VIEW_REPORT')){
							  var pncGrid = this.getProgramandcoursetreegrid();
						  }
						  else{
							  var pncGrid = this.getProgramandcoursegrid();
						  }
						  
						  var record = pncGrid.getSelectionModel().getSelection();
						  var courseID = record[0].data.courseId;
						  var grid = this.getCoursedocumentlist().down('grid');
						  var btnDelete = grid.down('#btnDelete');
						  btnDelete.setVisible(false);
					        var store = grid.getStore();
						    store.getProxy().extraParams = {
						    	courseId: courseID
						    };
						    store.load();
					  }  
				  },
				   'facultyteachinghourdetails button[itemId=btnSaveItemId]': {
					   click: function() {
							  this.saveEmployeeTeachingHours()
						  }
					  
		            },
               'facultyteachinghourquicksearchform[itemId=facultyTeachingHourQuickSearchForm]':{
		            	 render: function(form) {
		            		 var this$ = this;
		            		 var personProfile = this.getContentPanelActiveTab();
		            	        var form = personProfile.down("#facultyTeachingHourQuickSearchForm");
		            	        var academicTermComb = form.down('customcombobox#academicTerm');
		            		 var academyLocationId = this.getCurrentAcademyLocation();
	        				 var academicTermId = 0;
	    				     var academicTermComboStore = academicTermComb.getStore();
		    					 academicTermComboStore.getProxy().extraParams = {
		    						 academyLocationIds : academyLocationId
		    					 };
		    					 academicTermComboStore.load({
		    						 callback: function(rec, success) {
		    							 if (success) {
		    								 for(var i in rec){
		    									 if(rec[i].get('sequence')==1){
		    										academicTermId = rec[i].get('id');
		    										 academicTermComb.setValue(academicTermId);
		    									 }
		    								 }
		    								 
		    							 }
		    						 }
		    					 });
		    		},
	    			 afterrender:function() {
	    				 var this$ = this;
	    				 var personProfile = this.getContentPanelActiveTab();
	            	        var form = personProfile.down("#facultyTeachingHourQuickSearchForm");
	            	        var  academyLocationIds=  this$.getCurrentAcademyLocation();
	            	        var academicTermComb = form.down('customcombobox#academicTerm');
	            	        var grid = personProfile.down("#facutltyTeachingHourGrid");
	            	        var values = form.getValues();
	            	        var academicTermId=values.ACADEMIC_TERM;
	            	       var params = new Object();
	            	       var userId = personProfile.getUserId();
	            	       params = {
	            	    		   academyLocationIds: academyLocationIds,
	            	    		   academicTermId:academicTermId,
	            	    		   facultyId: userId,
	            	            };
	            	     if (grid) {
	            	         
	            	    	 var store =  grid.getStore().getProxy().extraParams = {
	            	   			academicTerm:academicTermId,
	            	   			 facultyId:userId,
	            	   		 };
	            	    	 grid.getStore().load();
	            	     
	            	     }
	            	     }  
		            },
        });
    },
    updateViewCalendarTitle: function(p, vw, dateInfo){
   	 var this$ = this;
   	 var personProfile = this$.getContentPanelActiveTab();
   	 var viewCalendarForm = personProfile.down('#facultyScheduleDetails');
		 var startDt= new Date(),endDt= new Date();      
		 if(dateInfo){
              // will be null when switching to the event edit form so ignore
             // Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
              //this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
        	  startDt = dateInfo.viewStart;
			  endDt =dateInfo.viewEnd;
           }
			 //console.log(startDt)
	        var p = viewCalendarForm.down('#app-center'),//Ext.getCmp('app-center'),
	            fmt = Ext.Date.format;
	        
	        if(Ext.Date.clearTime(startDt).getTime() == Ext.Date.clearTime(endDt).getTime()){
	            p.setTitle(fmt(startDt, 'F j, Y'));
	        }
	        else if(startDt.getFullYear() == endDt.getFullYear()){
	            if(startDt.getMonth() == endDt.getMonth()){
	                p.setTitle(fmt(startDt, 'F j') + ' - ' + fmt(endDt, 'j, Y'));
	            }
	            else{
	                p.setTitle(fmt(startDt, 'F j') + ' - ' + fmt(endDt, 'F j, Y'));
	            }
	        }
	        else{
	            p.setTitle(fmt(startDt, 'F j, Y') + ' - ' + fmt(endDt, 'F j, Y'));
	        }
	  },

    /**
     * Show hide search form field on attedancetype
     * @param form
     */
    showHideSearchFormFieldOnAttedanceType: function(form) {
        if (form) {
            var academyLocationId = this.getCurrentAcademyLocation();
            Ext.Ajax.request({
                type: 'rest',
                async:false,
                url: SERVERURL.GET_ATTENDANCE_TYPE_BY_ACADEMYLOCATION_ID,
                params: {
                    academyLocatonId: academyLocationId
                },
                method: 'GET',
                success: function(response, action) {
                	if(isNullOrEmpty(response.responseText)){
    					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
    				} else if (response.responseText != 'ENTRY_NOT_FOUND'){
                		var data = Ext.decode(response.responseText);
                        if (!isEmpty(data)) {
                            form.down('#facultyAttendance_hidden_type').setValue(data.facultyAttendanceType);
                            if (data.facultyAttendanceType == 'COURSE_LEVEL') {
                                form.down('#programBatchPeriodContainer').setDisabled(false);
                                form.down('#programBatchPeriodContainer').setVisible(true);
                                form.down('#sectionCourseContainer').setDisabled(false);
                                form.down('#sectionCourseContainer').setVisible(true);
                            } else {
                                form.down('#programBatchPeriodContainer').setDisabled(true);
                                form.down('#programBatchPeriodContainer').setVisible(false);
                                form.down('#sectionCourseContainer').setDisabled(true);
                                form.down('#sectionCourseContainer').setVisible(false);
                            }
                        }else{
                        	form.down('#facultyAttendance_hidden_type').setValue('COURSE_LEVEL');
                        }
                	}else{
                    	form.down('#facultyAttendance_hidden_type').setValue('COURSE_LEVEL');
                    }
                    

                }
            });
        }

    },

    /**
     * This is used to remove Section type combo 
     */
    hideSectionType: function(formRef) {

        var sectionCmb = formRef.down('#sectionTypeId');
        var topicCmb = formRef.down('#topicTypeId');
        sectionCmb.setVisible(false);
        sectionCmb.setDisabled(true);
        topicCmb.setVisible(false);
        topicCmb.setDisabled(true);
    },
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadAttendanceDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
        var this$ = this;
        this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if (!isNullOrEmpty(id)) {
            var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.load();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.name) {
        case 'programId':
            this.clearCombo(combo);
            batchCombo = container.down('combo[name=batch]');
            this.clearCombo(batchCombo);
            break;
        case 'batch':
            this.clearCombo(combo);
            periodCombo = container.down('combo[name=period]');
            this.clearCombo(periodCombo);
            break;
        case 'period':
            this.clearCombo(combo);
            sectionCombo = container.down('combo[name=section]');
            this.clearCombo(sectionCombo);
            break;
        case 'section':
            this.clearCombo(combo);
            courseCombo = container.down('combo[name=COURSE_NAME]');
            this.clearCombo(courseCombo);
            break;
        case 'course':
            this.clearCombo(combo);
            courseVariantCombo = container.down('combo[name=courseVariant]');
            this.clearCombo(courseVariantCombo);
            break;
        case 'courseComponent':
            this.clearCombo(combo);
            break;
        }
    },

    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    /**
     * View attendance details
     * @param gridItemId
     * @param formItemId
     */
    viewDetails: function(gridItemId, formItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var form = personProfile.down(formItemId);
        var userId = personProfile.getUserId();

        if (grid.getSelectionModel().getCount() > 0) {

            var records = grid.getSelectionModel().getSelection();
            var courseName = records[0].data.courseName;

            var formWindow = this$.getFacultywisedetaildata();
            if (!formWindow) {
                Ext.widget('facultywisedetaildata');
                formWindow = this$.getFacultywisedetaildata();
            }
            formWindow.show();

            var values = form.getValues();
            var sectionId = values.section;
            var courseId = values.course;

            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.FACULTY_ATTENDANCE_DETAILS_DATA,
                params: {
                    facultyId: userId,
                    courseId: courseId,
                    sectionId: sectionId
                },
                method: 'GET',
                success: function(form, action) {
                    var data = Ext.JSON.decode(form.responseText);

                    var facultyForm = this$.getFacultywiseDetaildata().getForm();

                    facultyForm.findField('courseName').setValue(courseName);
                    facultyForm.findField('planned').setValue(data.planned);
                    facultyForm.findField('conducted').setValue(data.conducted);
                    facultyForm.findField('attended').setValue(data.attended);
                    facultyForm.findField('notAttended').setValue(data.notAttended);

                    var store = this$.getStore('personinfo.common.course.FacultyWiseDetails');
                    store.getProxy().extraParams = {
                        facultyId: userId,
                        courseId: courseId,
                        sectionId: sectionId
                    };
                    store.load();

                }
            });

        } else {
        	showWarningMessage(getPersonModuleTranslation('ATTENDANCE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * @Author Surendra Jha
     * Show hide search Grid field on attendance type
     * @param grid
     */
    showHideSearchGridFieldOnAttedanceType: function(grid, personType) {
    	var $this = this;
    	if (grid) {
    		var academyLocationId = this.getCurrentAcademyLocation();
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.GET_ATTENDANCE_TYPE_BY_ACADEMYLOCATION_ID,
    			params: {
    				academyLocatonId: academyLocationId
    			},
    			method: 'GET',
    			success: function(response, action) {
    				if(isNullOrEmpty(response.responseText)){
    					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
    				}else{
    					var data = Ext.decode(response.responseText);
    					if (!isEmpty(data)) {
    						var gridColumns = grid.columns;
    						var len = gridColumns.length;
    						if (data.facultyAttendanceType == 'COMPLETE_DAY') {
    							for (var j = 0; j < len; j++) {
    								var gridColumn = gridColumns[j];
    								gridColumn.hide();
    								if (gridColumn.dataIndex == "totalRecords") {
    									gridColumn.show();
    								}
    								else if (gridColumn.dataIndex == "presentRecords") {
    									gridColumn.show();
    								}
    								else if(gridColumn.dataIndex == "attendancePercentage") {
    									gridColumn.show();
    								}
    							}
    						}
    					} if(personType == 'OTHER_EMPLOYEE') {
    						$this.showHideSearchGridFieldForOtherEmp(grid);
    					} 
    				}
    			}
    		});
    		
    		
    	}
    },
    
    showHideSearchGridFieldForOtherEmp: function(grid) {
    	if (grid) {
	    var gridColumns = grid.columns;
		var len = gridColumns.length;
		for (var j = 0; j < len; j++) {
				var gridColumn = gridColumns[j];
				gridColumn.hide();
				if (gridColumn.dataIndex == "totalRecords") {
					gridColumn.show();
				}
				else if (gridColumn.dataIndex == "presentRecords") {
					gridColumn.show();
				}
				else if(gridColumn.dataIndex == "attendancePercentage") {
					gridColumn.show();
				}
			}
		}
     },

     openTopicWin:function(grid, rowIndex, record, topicType){
    	 var $this = this;
    	 var formWindow = $this.getProgramandcoursetopicwin();
    	 if (!formWindow) {
    		 Ext.widget('programandcoursetopicwin');
    		 formWindow = $this.getProgramandcoursetopicwin();
    	 }
    	 formWindow.show();

    	 var store = $this.getProgramandcoursetopicgrid().getStore();

    	 var personProfile = $this.getContentPanelActiveTab();
    	 var userId = personProfile.getUserId();

    	 if(topicType == 'TOTAL_TOPIC') {
    		 store.getProxy().extraParams = {
    			 courseId:record.data.courseId
    		 };
    	 }else{
    		 store.getProxy().extraParams = {
    			 facultyId:userId,
    			 sectionId:record.data.sectionId,
    			 variantId:record.data.variantId
    		 };
    	 }
    	 store.load();
     },
     
     /**
      * Faculty Course Interest Save/Edit   
      */
     saveEditFacultyCourseInterest:function(gridItemId){
         var this$ = this;
         var form = this$.getFacultycourseinterestform();
		 var formData = form.getValues();
         var personProfile = this$.getContentPanelActiveTab();
         var grid = personProfile.down(gridItemId);
         /*if(isNullOrEmpty(formData.courseComponent)){
			showWarningMessage(getPersonModuleTranslation('COURSE_INTERESTS'), getCommonTranslation('COURSE_INTREST_SELECT_COURSE_COMPONENT'));
		 	return;
		}*/
         var submitUrl, isUpdate = false;
         var id = form.down('#facultycourseinterest_hidden_field');
         if (isNullOrEmpty(id.getSubmitValue())) {
             submitUrl = SERVERURL.PATH_SAVE_FACULTY_COURSE_INTEREST,
             isUpdate = false;
         } else {
             submitUrl = SERVERURL.PATH_UPDATE_FACULTY_COURSE_INTEREST,
             isUpdate = true;
         }
         var jsonFormatFormData;
         if(!isUpdate){
          jsonFormatFormData = this$.getJsonFacultyCourseInterestData(form);
         }
         else{
        	 var this$ = this;
             var jsonFormFieldData = new Object();
             var formData = form.getValues();
             var courseId=form.down('#courseId').getValue();
             var facultyCourseIntrestGrid = this$.getFacultycourseinterestgrid();
             var gridSelectedData = facultyCourseIntrestGrid.getSelectionModel().getSelection()[0]; 
             var facultyIntrestArr=[];
             var academyLocationId = (gridSelectedData.data.academyLocationId && gridSelectedData.data.academyLocationId.id)
             ? gridSelectedData.data.academyLocationId.id : null;
            	 facultyIntrestArr.push({
     				course:{id:gridSelectedData.data.courseId},
     				userId:this$.getUserInfo(),
     				faculty:this$.getPersonObj(),
     				courseCESMCode:{id:formData.courseCESMCode},
     				programCESMCode:{id:formData.programCESMCode},
     				courseInterestRole:{id:formData.courseInterestRole},
     				initiatorComment:formData.initiatorComment,
     				courseComponent:{id:gridSelectedData.data.courseComponentId},
     				academyLocationId:{id:academyLocationId},
     				id:formData.id
     			});
            	 jsonFormatFormData = Ext.encode(facultyIntrestArr);
         }
         this$.applyWindowMask(); 
         
         this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
         	this$.hideWindowMask();
         	if(success){
         		this$.closePersonCommonWindow();
                 grid.getStore().load();
                 grid.getSelectionModel().deselectAll();
				 if(!isNullOrEmpty(response.responseText) && response.responseText == "INTEREST_EXISTS"){
					showWarningMessage(getPersonModuleTranslation('COURSE_INTERESTS'), getCommonTranslation('COURSE_ALREADY_INTEREST_EXISTS'));
		 			return;
				 }
                 if (isUpdate) {
                     showSuccessMessage(getPersonModuleTranslation('COURSE_INTERESTS'), getPersonModuleTranslation('COURSE_INTERESTS_UPDATE_SUCCESS'));
                 } else {
                     showSuccessMessage(getPersonModuleTranslation('COURSE_INTERESTS'), getPersonModuleTranslation('COURSE_INTERESTS_ADD_SUCCESS'));
                 }
     		}else{
     			this$.closePersonCommonWindow();
                 grid.getStore().load();
     		}
         });
     },
     
     editFacultyCourseInterest: function(informationType,formItemId, gridItemId, isView) {

         var this$ = this;
         var personProfile = this$.getContentPanelActiveTab();
         var grid = personProfile.down(gridItemId);

         if (grid.getSelectionModel().getCount() > 0) {
         	this.showPersonCommonWindow(informationType, formItemId);
             var form = this$.getFacultycourseinterestform();
             var records = grid.getSelectionModel().getSelection()[0];
             if (!isEmpty(records)) {
                 //form.loadRecord(records);
                 
            	 var gridData = grid.getStore();
				 var courseIds = [];
				 var courseCompIds = []; 
				 if(!isNullOrEmpty(gridData.getRange())) {
		        		for(var i=0; i<gridData.getRange().length;i++) {
		        			if(records.data.courseId != gridData.getRange()[i].data.courseId) {
		        				courseIds.push(gridData.getRange()[i].data.courseId);
		        			}
		        			if(!isNullOrEmpty(gridData.getRange()[i].data.courseComponentId)) {
		        					if(records.data.courseComponentId != gridData.getRange()[i].data.courseComponentId) {
		        						courseCompIds.push(gridData.getRange()[i].data.courseComponentId);
		        				}		
		        			}
		        		}
		        	}
				
            	 
                 var formId = form.down('#facultycourseinterest_hidden_field');
                 var courseId = form.down('#courseId');
                 var courseComponentId = form.down('#courseComponent');
                 var courseCESMCodeId = form.down('#courseCESMCodeId');
                 var programCESMCodeId = form.down('#programCESMCodeId');
                 var courseInterestRoleId = form.down('#courseInterestRoleId');
                 var initiatorComment = form.down('#initiatorCommentId');
                 initiatorComment.setValue(records.data.intiatorComment);
                 formId.setValue(records.data.id);
                 courseComponentId.setDisabled(false);
                 courseId.setReadOnly(true);
            	 courseCESMCodeId.setReadOnly(true);
            	 programCESMCodeId.setReadOnly(true);
                 var courseCESMId=null;
                 if(records.data.courseCESMCodeId){
                	 courseCESMId=records.data.courseCESMCodeId;
                 }
                 courseId.getStore().getProxy().extraParams = {
						courseIds:courseIds.join(),
						courseCESMCode:courseCESMId,
						courseCompIds:courseCompIds.join()
             	 }
                 
                 courseId.getStore().load({
                 	 callback: function(){
                 		courseId.setValue(records.data.courseComponentId);
                 	 }
                  });
                 /*courseId.getStore().load({
                	 callback: function(rec, operation, success) {
                		 if (success) {
                			 if(rec.length>0){
                				 rec.forEach(function(obj){
                				 if(!isNullOrEmpty(obj.data.id) && obj.data.id==records.data.courseComponentId)
                					 courseId.setValue(obj);
                				 });
                			 }
                		 }
                	 }
                 });*/
                  
                  courseComponentId.getStore().getProxy().extraParams = {
                 	 	courseId:records.data.courseId,
 						courseComponentIds:courseCompIds.join()
 				 }
                  courseComponentId.getStore().load({
                 	 callback: function(){
                          courseComponentId.setValue(records.data.courseComponentId);
                 	 }
                  });
                  
                  programCESMCodeId.getStore().load({
                   	 callback: function(){
                   		programCESMCodeId.setValue(records.data.programCESMCodeId);
                   	 }
                    });
                  
                  if(records.data.programCESMCodeId){
                	  courseCESMCodeId.getStore().getProxy().extraParams = {
                		  programCESMId:records.data.programCESMCodeId
                	  }
                  }
                  
                  courseCESMCodeId.getStore().load({
                 	 callback: function(){
                          courseCESMCodeId.setValue(records.data.courseCESMCodeId);
                 	 }
                  });
                  
                  if(records.data.courseCESMCodeId)
                  {
                	  	courseInterestRoleId.setDisabled(false);
                	  	courseInterestRoleId.getStore().getProxy().extraParams = {
                	  		courseCESMId:records.data.courseCESMCodeId
                  	  }
                  }
                  courseInterestRoleId.getStore().load({
                   	 callback: function(){
                   		courseInterestRoleId.setValue(records.data.courseInterestRoleId);
                   	 }
                    });
 
                 if(isView) {
                	 courseComponentId.setReadOnly(true);
                	 courseId.setReadOnly(true);
                	 courseCESMCodeId.setReadOnly(true);
                	 programCESMCodeId.setReadOnly(true);
                	 courseInterestRoleId.setReadOnly(true);
                	 initiatorComment.setReadOnly(true);
                	 form.down("#submitButtonId").setVisible(false);
                	 courseId.setValue(records.data.courseId);
                	 courseComponentId.setValue(records.data.courseComponentName);
 					 courseCESMCodeId.setValue(records.data.courseCESMCodeId);
 					 programCESMCodeId.setValue(records.data.programCESMCodeId);
 					courseInterestRoleId.setValue(records.data.courseInterestRoleId);
 					initiatorComment.setValue(records.data.initiatorComment);
                 } 
             }
         } else {
             showWarningMessage(getPersonModuleTranslation('COURSE_INTERESTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
     },
     
     deleteEditFacultyCourseInterest:function(gridItemId){
    	 
    	 var this$ = this;
         var personProfile = this$.getContentPanelActiveTab();
         var grid = personProfile.down(gridItemId);

         var deleteUrl = SERVERURL.PATH_DELETE_FACULTY_COURSE_INTEREST;
         
         if (grid.getSelectionModel().getCount() > 0) {
             showConfirmMessage(getPersonModuleTranslation('COURSE_INTERESTS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                 if (btn == 'yes') {
                     if (grid.getSelectionModel().getCount() > 0) {
                         var records = grid.getSelectionModel().getSelection();
                         for (var count = 0; count < records.length; count++) {
                             var id = "";
                             if (!isNullOrEmpty(records[count].get("id"))) {
                                 id = records[count].get("id");
                             }
                             Ext.Ajax.request({
                                 type: 'rest',
                                 url: deleteUrl+'?id='+id,
                                 method: 'DELETE',
                                 headers: {
                                     'Content-Type': 'application/json'
                                 },
                                 params: {
                                     id: id
                                 },
                                 success: function(form, action) {
                                     grid.getStore().load();
                                     showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('COURSE_INTERESTS_DELETE_SUCCESS'));
                                 }
                             });
                         }
                     }
                 }
             });
         } else {
             showWarningMessage(getPersonModuleTranslation('COURSE_INTERESTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
     },
     
     linkNoOfVariants: function(view, rowIndex, record) {
     	
    	 var formWindow = this.getFacultynoofvariantgridwindow();
	        if (!formWindow) {
	            Ext.widget('facultynoofvariantgridwindow');
	            formWindow = this.getFacultynoofvariantgridwindow();
	        }
	        formWindow.show();
     },
     
     getJsonFacultyCourseInterestData: function(form) {

     	var this$ = this;
         var jsonFormFieldData = new Object();
         var formData = form.getValues();
         var courseId=form.down('#courseId').getValue();
         
         var mainObj = new Object();
         if (!isEmpty(formData)) {
         	var personObj = this$.getPersonObj();
         	mainObj.faculty = personObj;
            
         	var userObj =  this$.getUserInfo();
         	mainObj.userId = userObj;
            
            var courseObj = new Object();
            courseObj.id = formData.course;
            mainObj.course = courseObj;
            
            if(!isNullOrEmpty(formData.courseComponent)) {
            	var courseComponentObj = new Object();
            	courseComponentObj.id = formData.courseComponent;
            	mainObj.courseComponent = courseComponentObj;
            }
			if(!isNullOrEmpty(formData.courseCESMCode)) {
            	var courseCESMCodeObj = new Object();
				courseCESMCodeObj.id=formData.courseCESMCode
				mainObj.courseCESMCode = courseCESMCodeObj;
            }else{
				mainObj.courseCESMCode=null;
			}
            if(!isNullOrEmpty(formData.id)) {
            	mainObj.id = formData.id;
            }
            
            if(!isNullOrEmpty(formData.programCESMCode)) {
            	var programCESMCodeObj = new Object();
            	programCESMCodeObj.id = formData.programCESMCode;
            	mainObj.programCESMCode = programCESMCodeObj;
            }
            
            if(!isNullOrEmpty(formData.courseInterestRole)) {
            	var courseInterestRoleObj = new Object();
            	courseInterestRoleObj.id = formData.courseInterestRole;
            	mainObj.courseInterestRole = courseInterestRoleObj;
            }
            if(!isNullOrEmpty(formData.initiatorComment)) {
            	mainObj.initiatorComment = formData.initiatorComment;
            }
         }
         var facultyIntrestArr=[];
         
         courseId.forEach(function(obj){
        	 facultyIntrestArr.push({
 				course:{id:obj.data.categoryId},
 				userId:this$.getUserInfo(),
 				faculty:this$.getPersonObj(),
 				courseCESMCode:{id:formData.courseCESMCode},
 				programCESMCode:{id:formData.programCESMCode},
 				courseInterestRole:{id:formData.courseInterestRole},
 				initiatorComment:formData.initiatorComment,
 				courseComponent:{id:obj.data.id},
 				id:formData.id
 			});
 		});
         jsonFormFieldData = Ext.encode(facultyIntrestArr);
         return jsonFormFieldData;
     },
  // Create JSON for Delayed Course PBS Search 
     createJsonCourseExecutionPBS:function(quickSearchForm, record){			
       
    	var alArray=[];
    	alArray.push(this.getCurrentAcademyLocation());
  	    var acadLocationIdsCommaSepeated = alArray.join();
  	  var accCourseIds = [];
		 Ext.Ajax.request({
				type : 'rest',
				url :SERVERURL.FIND_ALL_ACCESSIBLE_COURSES,
				params : {
					academyLocationId : this.getCurrentAcademyLocation()
				},
				method : 'GET',
				async: false,
				success : function(response) {
					var data = Ext.decode(response.responseText);
					for(var i=0; i< data.length ;i++){
						if(!isNullOrEmpty(data[i])){
							accCourseIds.push(data[i]);
						}
          	   }
				}
			});
	   var accessibleCourseIds =accCourseIds.join();
  	   var programId = quickSearchForm.down('#programId');
  	   var batchId = quickSearchForm.down('#batchId');
  	   var periodId = quickSearchForm.down('#periodId');  
  	   var courseIdPBS = quickSearchForm.down('#courseIdPBS');
  	   var programSectionId = quickSearchForm.down('#programSectionId');
  	   var facultyId = this.getCurrentlyLoggedInUser().id;

  	   var values = new Object();
  	   values.configCode = CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_PBS_CONFIGCODE;

  	   var searchcriteria = new Array();

  	   if(programId.getValue() != "" && programId.getValue() != null){
  		   searchcriteria.push({paramCode:"PROGRAM_ID", paramValues:[programId.getValue()]});
  	   }
  	   if(batchId.getValue() != "" && batchId.getValue() != null){
  		   searchcriteria.push({paramCode:"PROGRAM_BATCH_ID", paramValues:[batchId.getValue()]});
  	   }
  	   if(periodId.getValue() != "" && periodId.getValue() != null){
  		   searchcriteria.push({paramCode:"PERIOD_ID", paramValues:[periodId.getValue()]});
  	   }
  	   if(courseIdPBS.getValue() != "" && courseIdPBS.getValue() != null){
  		   searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseIdPBS.getValue()]});
  	   }
  	   if(programSectionId.getValue() != "" && programSectionId.getValue() != null){
  		   searchcriteria.push({paramCode:"SECTION_ID", paramValues:[programSectionId.getValue()]});
  	   }
  	   searchcriteria.push({paramCode:"FACULTY_ID", paramValues:[facultyId]});
  	   
  	   // code for multiple academy location id comma seperated
  	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
  		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
  	   }
  	 if(accessibleCourseIds != "" && accessibleCourseIds != null){
  	 //searchcriteria.push({paramCode:"ACCESSIBLE_PARENT_COURSE_ID", paramValues:[accessibleCourseIds]});
  	 searchcriteria.push({paramCode:"ACCESSIBLE_COURSE_ID", paramValues:[accessibleCourseIds]});
  	 searchcriteria.push({paramCode:"ACCESSIBLE_PARENT_COURSE_ID", paramValues:[accessibleCourseIds]});
  	 }
  	   values.searchCriterias=searchcriteria;
  	   return values;
     },
     createJsonCourseExecutionCBS:function(quickSearchForm, record){			
  	   var this$= this;
    	 var alArray=[];
     	alArray.push(this$.getCurrentAcademyLocation());
   	    var acadLocationIdsCommaSepeated = alArray.join();
  	   var courseIdCBS = quickSearchForm.down('#courseIdCBS');
  	   var courseValue = courseIdCBS.getValue();
  	   var academicTermId = quickSearchForm.down('#academicTermId');
  	   var cbsCourseVariant = quickSearchForm.down('#courseVariantId');
  	   var facultyId = this.getCurrentlyLoggedInUser().id;
  	  /*if(!isNullOrEmpty(courseValue)){
		 Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.GET_PARENT_COURSE_ID,
				params : {
					courseId : courseValue
				},
				method : 'GET',
				async: false,
				success : function(response) {
					if(!isNullOrEmpty(response.responseText)){
					data = Ext.decode(response.responseText);
					courseValue = data.courseId;
					}
				}
			});
	 }*/
  	   var values = new Object();
  	   values.configCode = CONSTANTS.CB.FACULTY_COURSE_EXECUTION_REPORT_CBS_CONFIGCODE;

  	   var searchcriteria = new Array();

  	   if(courseIdCBS.getValue() != "" && courseIdCBS.getValue() != null){
  		   searchcriteria.push({paramCode:"COURSE_ID", paramValues:[courseValue]});
  	   }
  	   if(academicTermId.getValue() != "" && academicTermId.getValue() != null){
  		   searchcriteria.push({paramCode:"ACADEMIC_TERM_ID", paramValues:[academicTermId.getValue()]});
  	   }
  	   if(cbsCourseVariant.getValue() != "" && cbsCourseVariant.getValue() != null){
		   searchcriteria.push({paramCode:"COURSE_VARIANT_ID", paramValues:[cbsCourseVariant.getValue()]});
	   }
  	   if(acadLocationIdsCommaSepeated != "" && acadLocationIdsCommaSepeated != null){
  		   searchcriteria.push({paramCode:"ACADEMYLOCATION_ID", paramValues:[acadLocationIdsCommaSepeated]});
  	   }
  	   searchcriteria.push({paramCode:"FACULTY_ID", paramValues:[facultyId]});
  	   values.searchCriterias=searchcriteria;
  	   return values;
     },
     linkCoursesNoOfDocuments: function(view, rowIndex, record) {
     	
    	 var docWindow = this.getCoursedocumentlist();
    	 //var courseID = record.data.courseId;
	        if (!docWindow) {
	        	docWindow =  Ext.widget('coursedocumentlist',{
           			itemId:'facultyCourseDocumentList'
           		});
	        }
	        docWindow.show();
    },
	  getDownloadFileForCourseDocument : function(documentId){

	    	if(!isNullOrEmpty(documentId)){
	    		var csvForm = Ext.create('Ext.form.Panel'); 
	    		csvForm.getForm().submit({
	    			target: '_blank',
	    			method:'GET',
	    			params :{
	    				access_token : Ext.Ajax.defaultHeaders.access_token
	    			},
	    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	    			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
	    			standardSubmit :true
	    		});
	    	}
	    },
	    linkNoProgramCourseAssociated: function(view, rowIndex, record) {
	    	
	    	if(record.data.programAssociated>0){
	        var formWindow = this.getFacultyprogramassociatedwindow();
	        if (!formWindow) {
	            Ext.widget('facultyprogramassociatedwindow');
	            formWindow = this.getFacultyprogramassociatedwindow();
	        }
	        formWindow.show();
	    	}
	    },
	    gridRenderFunction:function(grid){
			grid.addExportButtonToolbar();
	    },
	    exportCourseExecutionReport : function(exportUrl,filetype,whetherAll) {
	    	var this$ = this;
	    	var quickSearchForm=this$.getCourseexecutionreportstructure();
	    	var value = quickSearchForm.down('#selectionTypeId').getValue();
	    	if(value.selectionType =='PROGRAM_BATCH_SECTION'){
	    		var searchResultGrid = this.getCourseexecutionreportstructureGrIdPBS();
	    		var pagingtoolbaroptions = this.getCourseexecutionreportstructureGrIdPBS().down('pagingtoolbar').getStore().lastOptions;
	    		var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	    		var jsonFormatFormData=this.createJsonCourseExecutionPBS(quickSearchForm);
	    		var visibleColumns=this.getVisibleColumns(searchResultGrid);
	    		var reportTitle=getCommonTranslation('COURSE_EXECUTION_REPORT');
	    		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
	    			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	    		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	    	}else if(value.selectionType =='COURSE_SECTION'){
	    		var searchResultGrid = this.getCourseexecutionreportstructureGrIdCBS();
	    		var pagingtoolbaroptions = this.getCourseexecutionreportstructureGrIdCBS().down('pagingtoolbar').getStore().lastOptions;
	    		var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	    		var jsonFormatFormData=this.createJsonCourseExecutionCBS(quickSearchForm);
	    		var visibleColumns=this.getVisibleColumns(searchResultGrid);
	    		var reportTitle=getCommonTranslation('COURSE_EXECUTION_REPORT');
	    		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
	    			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
	    		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	    	}
	    },
	    createSearchCriteriaString: function(searchForm) {
	    	var me=this;
	    	var formValues = new Array();
	    	formValues = searchForm.getValues();        
	    	var searchCriteriaString="";
	    	for (var key in formValues) {
	    		var value = formValues[key];            
	    		if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	    			/* var keyValueJsonObject = me.getJsonObject( key , value);
		searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";*/
	    		}
	    	}
	    	searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	    	return searchCriteriaString;
	    }, 
	    onChangeAcademictermOfProgramCourseFacultySearch: function(form, academicTermId){
	    	   var this$=this;
 	    	   var courseVariantField = form.down("#courseVariantId");
 	    	   var programField = form.down("#programItemId");
 	    	   var batchField = form.down("#batchItemId");
 	    	   var periodField = form.down("#periodItemId");
 	    	   var sectionField = form.down("#sectionItemId");

 	    	   courseVariantField.reset();
 	    	   programField.reset();
 	    	   batchField.reset();
 	    	   periodField.reset();
 	    	   sectionField.reset();

 	    	   courseVariantField.setDisabled(false);
 	    	   programField.setDisabled(false);
 	    	   batchField.setDisabled(true);
 	    	   periodField.setDisabled(true);
 	    	   sectionField.setDisabled(true);

 	    	   
 	    	  var academyLocationIds = this.getCurrentAcademyLocation();
 	    	  var facultyId=this.getCurrentlyLoggedInUser().id;
 	    		  
 	    	   var courseVariantStore = courseVariantField.getStore();
 	    	  courseVariantStore.getProxy().extraParams = {
	    		   academyLocationIds: academyLocationIds,
	    		   facultyId: facultyId,
	    		   isCurrentPeriod:false,
	    		   academicTermId:academicTermId
	    	   };
	    	   courseVariantStore.load({
	    		   callback: function(records, operation, success) {
	    			   if (success) {
	    				   if(records.length == 1){
	    					   courseVariantField.setValue(records[0].data.id);
	    				   }
	    			   }
	    		   }
	    	   });
 	    	   var programStore = programField.getStore();
 	    	   programStore.getProxy().extraParams = {
 	    		   academyLocationIds:academyLocationIds,
 	    		   academicTermId:academicTermId,
 	    		   facultyId: facultyId,
 	    		   isAllProgram:true
 	    	   }
 	    	   programStore.load();

 	    	   
 	    	   
 	       },
 	       courseVariantSelectionOfProgramCourseFacultySearch:function(form, courseVariantId, assignSectionType) {
 	    	   var $this = this;
 	    	   var academicTermField = form.down('#academicTerm');
 	    	   var courseVariantField = form.down("#courseVariantId");
 	    	   var programField = form.down("#programItemId");
 	    	   var batchField = form.down("#batchItemId");
 	    	   var periodField = form.down("#periodItemId");
 	    	   var sectionField = form.down("#sectionItemId");
 	    	   var alternateFacultyField = form.down("#alternateFaculty");

 	    	   programField.reset();
 	    	   batchField.reset();
 	    	   periodField.reset();
 	    	   sectionField.reset();
 	    	   alternateFacultyField.reset();
 	    	   var academicTermId = academicTermField.getValue();
 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
 	    	   var facultyId=this.getCurrentlyLoggedInUser().id;


 	    	   if(assignSectionType == 'CourseSection') {
 	    		   programField.setDisabled(true);
 	    		   batchField.setDisabled(true);
 	    		   periodField.setDisabled(true);
 	    		   sectionField.setDisabled(true);
 	    		   var alternateFacultyStore = alternateFacultyField.getStore();
 	    		   alternateFacultyStore.getProxy().extraParams = {
 	    			   facultyId : facultyId,
 	    			   courseVariantId : courseVariantId
 	    		   };
 	    		  alternateFacultyStore.load();

 	    	   } else {
 	    		   programField.setDisabled(false);
 	    		   batchField.setDisabled(true);
 	    		   periodField.setDisabled(true);
 	    		   sectionField.setDisabled(true);
 	    		   var programStore = programField.getStore();
 	    		   programStore.getProxy().extraParams = {
 	    			   academyLocationIds:academyLocationIds,
 	    			   academicTermId:academicTermId,
 	    			   facultyId: facultyId,
 	    			   isAllProgram:true,
 	    			   courseVariantId:courseVariantId
 	    		   }
 	    		   programStore.load({
 	    			   callback: function(records, operation, success) {
 	    				   if (success) {
 	    					   if(records.length == 1){
 	    						   programField.setValue(records[0].data.id);
 	    					   } 
 	    				   }
 	    			   }
 	    		   });
 	    	   }
 	       },
 	       programCourseFacultyProgramChange: function(form, programId){
 	    	   var $this=this;
 	    	   var academicTermField = form.down('#academicTerm');
 	    	   var courseVariantField = form.down("#courseVariantId");
 	    	   var programField = form.down("#programItemId");
 	    	   var batchField = form.down("#batchItemId");
 	    	   var periodField = form.down("#periodItemId");
 	    	   var sectionField = form.down("#sectionItemId");

 	    	   batchField.reset();
 	    	   periodField.reset();
 	    	   sectionField.reset();

 	    	   batchField.setDisabled(false);
 	    	   periodField.setDisabled(true);
 	    	   sectionField.setDisabled(true);


 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
 	    	   var facultyId=this.getCurrentlyLoggedInUser().id;


 	    	   var academicTermId = academicTermField.getValue();
 	    	   var courseVariantId = courseVariantField.getValue();
 	    	   var batchStore = batchField.getStore();
 	    	   batchStore.getProxy().extraParams = {
 	    		   academicTermId:academicTermId,
 	    		   facultyId: facultyId,
 	    		   isAllProgram:true,
 	    		   courseVariantId:courseVariantId,
 	    		   programId:programId,
 	    	   }
 	    	   batchStore.load({
 	    		   callback: function(records, operation, success) {
 	    			   if (success) {
 	    				   if(records.length == 1){
 	    					   batchField.setValue(records[0].data.id);
 	    				   }
 	    			   }
 	    		   }
 	    	   });
 	       },
 	       programCourseFacultyBatchChange: function(form, batchId){
 	    	   var $this=this;
 	    	   var alinfomodel = Academia.model.authentication.ALInfoModel;
 	    	   var wheatherSchool = alinfomodel.get('wheatherSchool');
 	    	   var academicTermField = form.down('#academicTerm');
 	    	   var courseVariantField = form.down("#courseVariantId");
 	    	   var programField = form.down("#programItemId");
 	    	   var batchField = form.down("#batchItemId");
 	    	   var periodField = form.down("#periodItemId");
 	    	   var sectionField = form.down("#sectionItemId");

 	    	   periodField.reset();
 	    	   sectionField.reset();

 	    	   periodField.setDisabled(false);
 	    	   sectionField.setDisabled(true);
 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
 	    	   var facultyId=this.getCurrentlyLoggedInUser().id;

 	    	   var academicTermId = academicTermField.getValue();
 	    	   var courseVariantId = courseVariantField.getValue();
 	    	   var periodStore = periodField.getStore();
 	    	   periodStore.getProxy().extraParams = {
 	    		   academicTermId:academicTermId,
 	    		   facultyId: facultyId,
 	    		   isAllProgram:true,
 	    		   batchId:batchId,
 	    	   }
 	    	   periodStore.load({
 	    		   callback: function(records, operation, success) {
 	    			   if (success) {
 	    				   if(records.length == 0){
 	    					   if(wheatherSchool) {
 	    						   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
 	    					   }
 	    				   } else if(records.length == 1){
 	    					   periodField.setValue(records[0].data.id);
 	    					   if(wheatherSchool) {
 	    						   periodField.setVisible(false);
 	    					   }
 	    				   } 
 	    			   }
 	    		   }
 	    	   });
 	       },
 	       programCourseFacultyPeriodSelection : function(form, periodId) {
 	    	   var $this = this;
 	    	   var academicTermField = form.down('#academicTerm');
 	    	   var courseVariantField = form.down("#courseVariantId");
 	    	   var programField = form.down("#programItemId");
 	    	   var batchField = form.down("#batchItemId");
 	    	   var periodField = form.down("#periodItemId");
 	    	   var sectionField = form.down("#sectionItemId");
 	    	   var alternateFacultyField = form.down("#alternateFaculty");

 	    	   sectionField.reset();
 	    	   alternateFacultyField.reset();
 	    	   sectionField.setDisabled(false);

 	    	   var  academyLocationIds = this.getCurrentAcademyLocation();
 	    	   var facultyId=this.getCurrentlyLoggedInUser().id;

 	    	   var academicTermId = academicTermField.getValue();
 	    	   var courseVariantId = courseVariantField.getValue();
 	    	   var alternateFacultyStore = alternateFacultyField.getStore();
 	    	   alternateFacultyStore.getProxy().extraParams = {
 	    		   facultyId : facultyId,
 	    		   periodId : periodId
 	    	   };
 	    	   alternateFacultyStore.load();
 	    	   var sectionStore = sectionField.getStore();
 	    	   sectionStore.getProxy().extraParams = {
 	    		   academicTermId:academicTermId,
 	    		   facultyId: facultyId,
 	    		   isAllProgram:true,
 	    		   periodId:periodId,
 	    		   courseVariantId:courseVariantId
 	    	   }
 	    	   sectionStore.load({
 	    		   callback: function(records, operation, success) {
 	    			   if (success) {
 	    				   if(records.length == 1 && !isNullOrEmpty(courseVariantId)) {
 	    					   sectionField.setValue(records[0].data.id)
 	    				   }
 	    			   }
 	    		   }
 	    	   });
 	       },
 	      loadProgramCoursesFacultyTreeGrid:function(button){
 	    	   var this$ = this;
 	    	   var personProfile = this$.getContentPanelActiveTab();
 	    	   var userId = personProfile.getUserId();
 	    	   var grid = personProfile.down('#facultyProgramCourseTreeGrid');
 	    	   var alinfomodel = Academia.model.authentication.ALInfoModel;
 	    	   var wheatherSchool = alinfomodel.get('wheatherSchool');
 	    	   if(wheatherSchool){
 	    		   grid.columns[3].setVisible(false);
 	    	   }
 	    	   var form = this.getProgramcoursefacultysearchwindow();
 	    	   var values = form.getValues();
 	    	   var programId = values.programId;
 	    	   var batchId = values.batchId;
 	    	   var periodId = values.periodId;
 	    	   var sectionId = values.sectionId;
 	    	   var courseVariantId = values.courseVariant;
 	    	   var academicTermId = values.academicTerm;
 	    	   var alternateFacultyId = values.alternateFaculty;
 	    	   var url = SERVERURL.PATH_FIND_FACULTY_DETAIL_VIEW_REPORT;
 	    	   if (grid) {
 	    		   var store = grid.getStore();
 	    		   store.getProxy().api.read = url;
 	    		   var params = {
 	    				   facultyId: userId,
 	    				   programId: programId,
 	    				   batchId: batchId,
 	    				   periodId: periodId,
 	    				   sectionId: sectionId,
 	    				   academicTermId:academicTermId,
 	    				   courseVariantId: courseVariantId,
 	    				   alternateFacultyId: alternateFacultyId,
 	    				   academyLocationId : this.getCurrentAcademyLocation()
 	    		   };
 	    		   store.getProxy().extraParams = params;
 	    		   if(store.getRootNode().childNodes) {
 	    			   store.getRootNode().removeAll();
 	    		   }
 	    		   store.load({
 	    			   callback: function() {
 	    				  Ext.getBody().unmask();
 	    			   }
 	    		   });
 	    	   }

 	       },
 	       loadProgramCoursesFacultyGrid:function(button){
 	    	   var this$ = this;
 	    	   var personProfile = this$.getContentPanelActiveTab();
 	    	   var userId = personProfile.getUserId();
 	    	   var grid = personProfile.down('grid[itemId=facultyProgramCourseGrid]');
 	    	   var alinfomodel = Academia.model.authentication.ALInfoModel;
 	    	   var wheatherSchool = alinfomodel.get('wheatherSchool');
 	    	   if(wheatherSchool){
 	    		   grid.columns[3].setVisible(false);
 	    	   }
 	    	   var form = this.getProgramcoursefacultysearchwindow();
 	    	   var values = form.getValues();
 	    	   var programId = values.programId;
 	    	   var batchId = values.batchId;
 	    	   var periodId = values.periodId;
 	    	   var sectionId = values.sectionId;
 	    	   var courseVariantId = values.courseVariant;
 	    	   var academicTermId = values.academicTerm;
 	    	   var alternateFacultyId = values.alternateFaculty;
 	    	   var url = SERVERURL.PATH_GET_FACULTY_PROGRAM_COURSE_GRID_DATA;
 	    	   if (grid) {
 	    		   var store = grid.getStore();
 	    		   store.getProxy().api.read = url;
 	    		   var params = {
 	    				   facultyId: userId,
 	    				   programId: programId,
 	    				   batchId: batchId,
 	    				   periodId: periodId,
 	    				   sectionId: sectionId,
 	    				   academicTermId:academicTermId,
 	    				   courseVariantId: courseVariantId,
 	    				   alternateFacultyId: alternateFacultyId,
 	    				   academyLocationId : this.getCurrentAcademyLocation()
 	    		   };
 	    		   store.getProxy().extraParams = params;
 	    		   store.load();
 	    	   }

 	       }
 	      
});