/**
 * This controller is used for Faculty document information actions.   
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyDocumentController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    models: ['personinfo.common.documents.DocumentModel'],

    stores: ['personinfo.common.documents.DocumentStore','common.DocumentTypeStore',
             'examinationcenters.evaluationgrouplisting.documentsubmit.DocumentNameByEvalGroup',
             'common.LiveSearchCombos','document.DocumentModeSubmissionStore','document.DocumentModeSubmissionStore',
             'document.DocumentStatusStore', 'personinfo.common.documents.OnlineDocumentStore', 'personinfo.common.documents.PhysicalDocumentStore',
             'common.DocumentStatusCSMStore'],

    views: ['personinfo.common.documents.DocumentGrid', 'document.DocumentFormWindow', 
            'document.SimpleDocumentForm', 'document.ExtendedDocumentForm','common.NestedJsonCombo',
            'common.LiveSearchCombo', 'personinfo.common.documents.OnlineDocumentGrid', 
            'personinfo.common.documents.PhysicalDocumentGrid', 'personinfo.common.documents.OnlineDocumentFormWin','personinfo.common.documents.DocumentRemarkFormWin',
            'personinfo.common.documents.PhysicalDocumentFormWin'],

    alias: "widget.facultydocumentcontroller",

    refs: [{
        ref: 'facultyDocumentGrid',
        selector: 'documentgrid[itemId=facultyDocumentGrid]'
    },{
        ref: 'facultyOnlineDocumentGrid',
        selector: 'onlinedocumentgrid[itemId=facultyOnlineDocumentGridItemId]'
    },{
        ref: 'facultyPhysicalDocumentGrid',
        selector: 'physicaldocumentgrid[itemId=facultyPhysicalDocumentGridItemId]'
    },{
        ref: 'facultyonlinedocumentformwin',
        selector: 'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin]'
    },{
        ref: 'documentremarkformwin',
        selector: 'documentremarkformwin'
    },{
        ref: 'facultyphysicaldocumentformwin',
        selector: 'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin]'
    },],
    config: {
    	FACULTY_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_DOCUMENTS_PRIVILEGES'),
    	FACULTY_ONLINE_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_ONLINE_DOCUMENTS_PRIVILEGES'),
    	FACULTY_PHYSICAL_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PHYSICAL_DOCUMENTS_PRIVILEGES'),
    	FACULTY_PORTAL_ONLINE_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_ONLINE_DOCUMENTS_PRIVILEGES'),
    	FACULTY_PORTAL_PHYSICAL_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_PHYSICAL_DOCUMENTS_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            /*Documents Details*/
        	'documentgrid[itemId=facultyDocumentGrid]': {
                render: function(grid) {
                    this.loadGridStore('#facultyDocumentGrid', SERVERURL.FACULTY_DOCUMENT_GRID_DATA);
                    this.doAccessControlValidation(grid, this.getFACULTY_DOCUMENTS_PERMISSIONS());
                    var portalId = this.getCurrentLoggedPortalId();
    				if(portalId == 2){
    					grid.down('toolbar').down('#btnAdd').setVisible(true);
    					grid.down('toolbar').down('#btnEdit').setVisible(true);
    				}
    				grid.columns[7].setVisible(false);//destroy();//programName
                    grid.columns[8].setVisible(false);//.destroy();//BatchName
                    grid.columns[9].setVisible(false);//.destroy();//SeatType
    				grid.down('toolbar').down('#uploadDocumentBtn').setVisible(false);
                },
                cellclick: this.cellClickFacultyDocumentGrid
            },
            'documentgrid[itemId=facultyDocumentGrid] button[itemId=btnAdd]': {
                click: function(){
                	var personProfile = this.getContentPanelActiveTab();
                    var grid = personProfile.down('#facultyDocumentGrid');
                    grid.getSelectionModel().deselectAll();
                	this.showDocumentFormWindow();
                }
            },
            'documentgrid[itemId=facultyDocumentGrid] button[itemId=btnEdit]': {
                click: function(){
                	var isView = false;
            		this.editDocumentFormWindow(isView);
                }
            },
            'documentgrid[itemId=facultyDocumentGrid] button[itemId=btnView]': {
                click: function(){
                	var isView = true;
            		this.editDocumentFormWindow(isView);
                }
            },
            'documentgrid[itemId=facultyDocumentGrid] button[itemId=btnDelete]': {
                click: function(){
                	this.deleteDocumentRecord();
                }
            },
            'documentformwindow[itemId=facultyDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                click: function(){
                	this.saveFacultyDocumentForm();
                }
            },
            'documentformwindow[itemId=facultyDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentCancelButtonId]': {
                click: function(){
                	this.closeDocumentFormWindow();
                }
            },
            'documentformwindow[itemId=facultyDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] #fileDisplayField': {
                render: function(component) {
                	var me = this;
                
	                component.getEl().on('click', function(e) {
	                	me.downloadFacultyDocumentFile();
	                });
                }
            },
            'documentformwindow[itemId=facultyDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] filefield[itemId=uploadFileField]': {
                change: function(button, e, value) {
                    var extension = e.substring(e.lastIndexOf('.') + 1).toLowerCase();
                    var file = button.fileInputEl.dom.files[0];                    
                    var form = button.up().up();
                    var fileInfoContainer = form.down('#fileInfoContainer');
                    var docDetails = form.down('#docDetails');
                    var docType = form.down('#documentTypeCombo');
                    if (docType.getRawValue() == 'Signature') {
                        if (!isNullOrEmpty(extension)) {
                            if (!((extension == "png" || extension == "jpeg" || extension == "jpg") && (file.size / 1024) <= 50)) {
                                button.reset();
                                showWarningMessage(getCommonTranslation("ALERT"), getPersonModuleTranslation('SIGNATURE_IMAGE_ALERT_MESSAGE'));
                            }                            
                            fileInfoContainer.setVisible(true);
                            docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
                        }
                    } else {
                        fileInfoContainer.setVisible(true);
                        docDetails.setValue("Type: "+extension + " Size: " + (file.size/1024).toFixed(2) + ' KBs');
                    }
                }
            },
              'documentformwindow[itemId=facultyDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] nestedJsonCombo#documentTypeCombo': {
            	    select: function(obj, record) {
            	        var form = obj.up().up();
            	        var uploadBtn = form.down('#uploadFileField');
            	        var docType = form.down('#documentTypeCombo');
            	        var docDetails = form.down('#docDetails');
            	        if (docType.getRawValue() == 'Signature') {
            	            var fileInfoContainer = form.down('#fileInfoContainer');
            	            fileInfoContainer.setVisible(true);
            	            docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
            	        } else {
            	            docDetails.reset();
            	        }
            	        uploadBtn.reset();
            	    }
            	},
            	'onlinedocumentgrid[itemId= facultyOnlineDocumentGridItemId]': {
            	    render: function(grid) {
            	    	this.loadDocumentGridStore(grid, true);
            	    	var portalId = this.getCurrentLoggedPortalId();
        				if(portalId == 2){
        					this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_ONLINE_DOCUMENTS_PERMISSIONS());
        				}else {
        					 this.doAccessControlValidation(grid, this.getFACULTY_ONLINE_DOCUMENTS_PERMISSIONS());
        				}
            	    },
            	},
            	'physicaldocumentgrid[itemId= facultyPhysicalDocumentGridItemId]': {
            	    render: function(grid) {
            	        this.loadDocumentGridStore(grid, false);
            	        var portalId = this.getCurrentLoggedPortalId();
        				if(portalId == 2){
        					this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_PHYSICAL_DOCUMENTS_PERMISSIONS());
        				}else {
        					 this.doAccessControlValidation(grid, this.getFACULTY_PHYSICAL_DOCUMENTS_PERMISSIONS());
        				}
            	    },
            	},
            	'onlinedocumentgrid[itemId=facultyOnlineDocumentGridItemId] button[itemId=btnAdd]': {
            	    click: function() {
            	        var grid = this.getFacultyOnlineDocumentGrid();
            	        grid.getSelectionModel().deselectAll();
            	        this.showOnlineDocumentFormWindow();
            	    }
            	},
            	'physicaldocumentgrid[itemId=facultyPhysicalDocumentGridItemId] button[itemId=btnAdd]': {
            	    click: function() {
            	    	
            	        var grid = this.getFacultyPhysicalDocumentGrid();
            	        grid.getSelectionModel().deselectAll();
            	        this.showPhysicalDocumentFormWindow();
            	    }
            	},
            	'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin]': {
            	    render: function(formWin) {
            	    	   var this$ = this;
            	    	 
            	    	   var formPnl = formWin.down('form');
            	    	   if(portalId == 2){
                           var itemIdPrivilegeNameArray = [{"#predifinedocument" : "PREDEFINED_DOCUMENTS" , "#othersItemId" : "OTHERS", "radioGroupItemId" : "#documentType", "defaultButtonItemId" : "#predifinedocument" }];
         	    		   this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getFACULTY_PORTAL_ONLINE_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
         	    		 }else if(portalId ==1){
            	    		   var itemIdPrivilegeNameArray = [{"#predifinedocument" : "PREDEFINED_DOCUMENTS" , "#othersItemId" : "OTHERS", "radioGroupItemId" : "#documentType", "defaultButtonItemId" : "#predifinedocument" }];
             	    		   this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getFACULTY_ONLINE_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
             	    		}
            	    	   formWin.down('#documentNameItemId').allowBlank = true;
            	        }
            	},
            	'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin]': {
            	    render: function(formWin) {
            	    formWin.down('#documentNameItemId').allowBlank = true;
            	       var this$ = this;
            	       var formPnl = formWin.down('form');
         	    	   if(portalId == 2){
                        var itemIdPrivilegeNameArray = [{"#preDefined" : "PREDEFINED_DOCUMENTS" , "#otherItemId" : "OTHERS", "radioGroupItemId" : "#documentType", "defaultButtonItemId" : "#preDefined" }];
      	    		  this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getFACULTY_PORTAL_PHYSICAL_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
         	    	  }
         	    	   else if(portalId ==1){
         	    		   var itemIdPrivilegeNameArray = [{"#preDefined" : "PREDEFINED_DOCUMENTS" , "#otherItemId" : "OTHERS", "radioGroupItemId" : "#documentType", "defaultButtonItemId" : "#preDefined" }];
          	    		 this$.disableRadioGroupAndOtherPivileges(formPnl, this$.getFACULTY_PHYSICAL_DOCUMENTS_PERMISSIONS(), itemIdPrivilegeNameArray);
            	    	}
         	    	 /* if(portalId ==1 ||portalId==2){
            	   var documentStatusCSM = formWin.down('#documentStatus');
            	   documentStatusCSM.getStore().load({
           		   callback: function(records, operation, success) {
           			  for(var i in records){
           				  if(records[i].data.code =="Submitted"){
           					documentStatusCSM.setValue(records[i].data.id);
           				  }
           			  }
           		  } 
   			  });
           }*/
            	   }
            	},
            	'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin] button[itemId=documentFormSubmitButtonId]': {
            	    click: function() {
            	        this.saveOnlineFacultyDocumentFormData();
            	    }
            	},
            	'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin] button[itemId=documentFormSubmitButtonId]': {
            	    click: function() {
            	        this.savePhysicalFacultyDocumentFormData();
            	    }
            	},
            	'onlinedocumentgrid[itemId=facultyOnlineDocumentGridItemId] button[itemId=btnEdit]': {
            	    click: function() {
            	        var formWin = this.getFacultyonlinedocumentformwin();
            	        if (!formWin) {
            	            Ext.widget('onlinedocumentformwin', {
            	                itemId: 'facultyOnlineDocumentFormWin'
            	            });
            	            formWin = this.getFacultyonlinedocumentformwin();
            	        }

            	        formWin.down('#uploadFileField').allowBlank = true;
            	        this.editFacultyOnlineDocumentFormWindow();
            	    }
            	},
            	'onlinedocumentgrid[itemId=facultyOnlineDocumentGridItemId] button[itemId=btnDelete]': {
            		 click: function() {
            			 this.deleteFacultyDocument(true);
             	    }
            	},
            	'physicaldocumentgrid[itemId=facultyPhysicalDocumentGridItemId] button[itemId=btnDelete]': {
            		click: function() {
            			this.deleteFacultyDocument(false);
            		}
            	},
            	'physicaldocumentgrid[itemId=facultyPhysicalDocumentGridItemId] button[itemId=btnEdit]': {
            	    click: function() {
            	        var formWin = this.getFacultyphysicaldocumentformwin();
            	        if (!formWin) {
            	            Ext.widget('physicaldocumentformwin', {
            	                itemId: 'facultyPhysicalDocumentFormWin'
            	            });
            	            formWin = this.getFacultyphysicaldocumentformwin();
            	        }
            	        this.editFacultyPhysicalDocumentFormWindow();
            	    }
            	},
            	'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin] radiogroup[itemId=documentType]': {
            	    change: function(radioField, newValue, oldValue, eOpts) {
            	        var formWin = this.getFacultyonlinedocumentformwin();
            	        this.onChangePredefinedRadioGroup(formWin, newValue, 'ONLINE');
            	    }
            	},
            	'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin] radiogroup[itemId=documentType]': {
            	    change: function(radioField, newValue, oldValue, eOpts) {
            	        var formWin = this.getFacultyphysicaldocumentformwin();
            	        this.onChangePredefinedRadioGroup(formWin, newValue, 'PHYSICAL');
            	    }
            	},
            	'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin] filefield[itemId=uploadFileField]': {
            	    change: function(fileField, value, eOpts) {
            	        this.onSelectUploadFileField(fileField, value, eOpts);
            	    }
            	},
            	'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin] filefield[itemId=uploadFileField]': {
            	    change: function(fileField, value, eOpts) {
            	        this.onSelectUploadFileField(fileField, value, eOpts);
            	    }
            	},
            	'documentremarkformwin button[itemId=cancelBtnRemarkItemId]': {
            	    click: function() {
            	        var formWindow = this.getDocumentremarkformwin();
            	        formWindow.close();
            	    }
            	},
            	'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin] radiogroup[itemId=inspectionDoneRadioGroupField]': {
            	    change: function(radioField, newValue, oldValue, eOpts) {
            	        var formWindow = this.getFacultyonlinedocumentformwin();
            	        var form = formWindow.down('#onlineDocumentFormItemId');
            	        this.onSelectionIsInspectionDone(form);
            	    }
            	},
            	'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin] radiogroup[itemId=inspectionDoneRadioGroupField]': {
            	    change: function(radioField, newValue, oldValue, eOpts) {
            	        var formWindow = this.getFacultyphysicaldocumentformwin();
            	        var form = formWindow.down('#physicalDocumentFormItemId');
            	        this.onSelectionIsInspectionDone(form);
            	    }
            	},
            	'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin] button[itemId=documentCancelButtonId]': {
            	    click: function() {
            	        var formWindow = this.getFacultyonlinedocumentformwin();
            	        formWindow.close();
            	    }
            	},
            	'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin] button[itemId=documentCancelButtonId]': {
            	    click: function() {
            	        var formWindow = this.getFacultyphysicaldocumentformwin();
            	        formWindow.close();
            	    }
            	},
            	'onlinedocumentgrid[itemId=facultyOnlineDocumentGridItemId]': {
            	    cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
            	        if (e.target.tagName == 'A') {
            	            var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
            	            var $this = this;
            	            var grid = $this.getFacultyOnlineDocumentGrid();
            	            var record = grid.getSelectionModel().getSelection()[0];
            	            if (columnName == 'remark') {
            	                var formWindow = $this.getDocumentremarkformwin();
            	                if (!formWindow) {
            	                    Ext.widget('documentremarkformwin');
            	                    formWindow = $this.getDocumentremarkformwin();
            	                }

            	                formWindow.show();
            	                var remark = record.get("remark");
            	                var documentRemarkArea = formWindow.down('#documentRemarkItemId');
            	                documentRemarkArea.setValue(remark);

            	            } else if (columnName == "documentType" && record.get('isElectronic')) {
            	                var this$ = this;
            	                var documentId = record.get("documentId");
            	                if (!isNullOrEmpty(documentId)) {
            	                    if (e.target.tagName == 'A') {
            	                        this$.getDocumentController().downloadDocumentFile(documentId);
            	                    }
            	                }

            	            }
            	        }
            	    }
            	},
            	'physicaldocumentgrid[itemId=facultyPhysicalDocumentGridItemId]': {
            	    cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
            	        if (e.target.tagName == 'A') {
            	            var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
            	            var $this = this;
            	            var grid = $this.getFacultyPhysicalDocumentGrid();
            	            var record = grid.getSelectionModel().getSelection()[0];
            	            if (columnName == 'remark') {
            	                var formWindow = $this.getDocumentremarkformwin();
            	                if (!formWindow) {
            	                    Ext.widget('documentremarkformwin');
            	                    formWindow = $this.getDocumentremarkformwin();
            	                }

            	                formWindow.show();
            	                var remark = record.get("remark");
            	                var documentRemarkArea = formWindow.down('#documentRemarkItemId');
            	                documentRemarkArea.setValue(remark);

            	            }
            	        }
            	    }
            	},
            	'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin] radiogroup[itemId=returnableRadioGroup]': {
            	    change: function(radioField, newValue, oldValue, eOpts) {
            	        var this$ = this;
            	        var formWindow = this.getFacultyphysicaldocumentformwin();
            	        var form = formWindow.down('#physicalDocumentFormItemId');
            	        var isReturnableYesField = form.down('#isReturnableYesField');
            	        var returnDateField = form.down('#returnDateField');
            	        var returnByField = form.down('#returnByField');
            	        if (isReturnableYesField.getValue() == true) {
            	            returnDateField.setDisabled(false);
            	            returnByField.setDisabled(false);
            	        } else {
            	            returnDateField.setValue('');
            	            returnByField.clearValue();
            	            returnDateField.setDisabled(true);
            	            returnByField.setDisabled(true);
            	        }
            	        this$.changeStatus(form);
            	    }
            	},
            	'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin] nestedJsonCombo[itemId=documentTypeCombo]': {
            		render: function(combo) {
            			var store = combo.getStore();
            			store.getProxy().extraParams = {
            				 isApplicableForEmployee: true
            			 };
            			 store.load();
            		}
            	},
            	'onlinedocumentformwin[itemId=facultyOnlineDocumentFormWin] nestedJsonCombo[itemId=documentStatus]': {
            		render: function(combo) {
            			var store = combo.getStore();
            			store.getProxy().extraParams = {
            				 
            			 };
            			 store.load();
            		}
            	},
            	'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin] nestedJsonCombo[itemId=documentTypeCombo]': {
            		render: function(combo) {
            			var store = combo.getStore();
            			store.getProxy().extraParams = {
            				 isApplicableForEmployee: true 
            			 };
            			 store.load();
            		}
            	},'physicaldocumentformwin[itemId=facultyPhysicalDocumentFormWin] nestedJsonCombo[itemId=documentStatus]': {
            		render: function(combo) {
            			var store = combo.getStore();
            			store.getProxy().extraParams = {
            				 
            			 };
            			 store.load();
            		}
            	}
        });
    },
    /**
     * load faculty document grid
     * @param gridItemId
     * @param url
     */
    loadGridStore: function(gridItemId, url) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var facultyId = personProfile.getUserId();
        var grid = personProfile.down(gridItemId);
        if (grid) {
            var params = {
                facultyId: facultyId
            };
            var store = grid.getStore();
            store.getProxy().api.read = url;
            store.load({
                params: params
            });

            store.on('beforeload', function(store, operation) {
                store.proxy.extraParams = params;
            });
        }
        var portalId = this$.getCurrentLoggedPortalId();
        if(portalId == 2){
        	grid.down('#inspectionDateItem').setVisible(true);
        }else{
        	grid.down('#inspectionDateItem').setVisible(true);
            grid.down('#returnedDateItem').setVisible(true);
        }
        
    },
    /**
     * Get document controller
     */
    getDocumentController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },
    /**
     * Cell click download file
     * @param grid
     * @param td
     * @param cellIndex
     * @param record
     * @param tr
     * @param rowIndex
     * @param e
     * @param eOpts
     */
    cellClickFacultyDocumentGrid : function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var documentGrid = this.getFacultyDocumentGrid();
        var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

        if (columnName == "documentType" && record.get('isElectronic')) {
            var this$ = this;
            var documentId = record.get("documentId");
            if(!isNullOrEmpty(documentId)){
            	if (e.target.tagName == 'A') {
            	this$.getDocumentController().downloadDocumentFile(documentId);
            	}
            }
            
        }
    },
    /** 
     * Download faculty doc file 
     */
    downloadFacultyDocumentFile : function(){
    	var this$ = this;
    	var documentGrid = this$.getFacultyDocumentGrid();
    	var record = documentGrid.getSelectionModel().getSelection()[0];
    	var docId = record.get("documentId");
    	if(!isNullOrEmpty(docId)){
        	this$.getDocumentController().downloadDocumentFile(docId);
        }
    },
    /**
     * Show document form 
     */
    showDocumentFormWindow : function(){
    	var this$ = this;
    	this$.getDocumentController().showDocumentFormWindow('facultyDocumentForm', 'EXT_DOCUMENT');
    	form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    	var modeSubmissionStore=form.down('#modeOfSubmission').getStore();
		modeSubmissionStore.on('load', function(){
			for(var i=0; i< modeSubmissionStore.data.items.length;i++){
				if(modeSubmissionStore.data.items[i].data.value == 'Online'){
					modeSubmissionStore.removeAt(i);
				} 
			}
		});
    	var portalId = this$.getCurrentLoggedPortalId()
    	form.down('#modeOfSubmission').setDisabled(true);
    	form.down('#documentTypeRadioGroup').setVisible(true);
    	form.down('#responsibleUserField').setDisabled(true);
    	form.down('#uploadFileField').setDisabled(false);
    	form.down('#uploadFileField').setVisible(true);
    	form.down('#inspectionRequiredRadioGroupField').setDisabled(true);
    	form.down('#inspectionRequiredRadioGroupField').setVisible(false);
    	form.down('#inspectionDoneRadioGroupField').setDisabled(true);
    	form.down('#inspectionDoneRadioGroupField').setVisible(false);
    	form.down('#inspectionDateField').setVisible(false);
    	form.down('#inspectionDoneByField').setVisible(false);
    	form.down('#returnableRadioGroup').setVisible(false);
    	form.down('#returnDateField').setVisible(false);
    	form.down('#returnByField').setVisible(false);
    	form.down('#modeOfReturnField').setVisible(false);
    	form.down('#returnedToUserField').setVisible(false);
    	form.down('#lastDateSubmissionId').setVisible(false);
    	if(portalId == 2) {
	    	/*var physicalField = form.down('#physicalField');
	    	var electonicField = form.down('#electonicField');
	    	physicalField.setVisible(false);
	    	electonicField.setVisible(false);
	    	var responsibleUserField = form.down('#responsibleUserField');
	    	responsibleUserField.setVisible(false);
	    	var uploadFileField = form.down('#uploadFileField');
	    	uploadFileField.style = "marginTop: '5px'";
	    	var modeOfSubmission = form.down('#modeOfSubmission');
	    	modeOfSubmission.setVisible(false);*/
	    	form.down('#physicalField').setDisabled(true);
    		form.down('#lastDateSubmissionId').setVisible(false);
    	}
    	form.down('#inspectionDateField').setMaxValue(new Date());
		form.down('#returnDateField').setMaxValue(new Date());
		form.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
		form.down('#returnByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
		form.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
    	Ext.apply(form, {
			isEditable: false
		});
    },
    /**
     * Close document form 
     */
    closeDocumentFormWindow : function(){
    	var this$ = this;
    	this$.getDocumentController().closeDocumentFormWindow();
    },
    /**
     * Edit document form
     * @param isView
     */
    editDocumentFormWindow : function(isView){
    	var this$ = this;
    	var form = null;
    	var personProfile = this$.getContentPanelActiveTab();
    	var grid = personProfile.down('#facultyDocumentGrid');
    	var portalId = this.getCurrentLoggedPortalId();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection()[0];
    		if(!isEmpty(records)){
    			if(portalId != 2 || (portalId == 2 && records.get('isElectronic'))){
    				var documentId = records.get("documentId");
    				if (isNullOrEmpty(documentId)) {
    					this$.getDocumentController().showDocumentFormWindow('facultyDocumentForm', 'EXT_DOCUMENT');
    					form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    					form.down('#documentTypeCombo').setValue(records.get('documentType'));
    				}else {
    					this$.getDocumentController().editDocumentFormWindow('facultyDocumentForm', 'EXT_DOCUMENT', documentId,isView);
    					form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    					form.down('#documentTypeRadioGroup').setReadOnly(true);
    				}
    				Ext.apply(form, {
    					isEditable: true
    				});

    				if (isView) {
    					form.down('#documentFormSubmitButtonId').setVisible(false);
    					form = form.getForm();
    					toggleReadOnlyFormItems(form, true);
    				}else{
    					form.down('#documentTypeCombo').setReadOnly(true);
    				}
    				form.down('#lastDateSubmissionId').setVisible(false)
    				if(records.get('isElectronic')){
    					form.down('#modeOfSubmission').setDisabled(false);
    					form.down('#modeOfSubmission').setReadOnly(true);
    					form.down('#modeOfSubmission').setValue('ONLINE');
    					form.down('#modeOfSubmission').allowBlank=true;
    					form.down('#documentTypeRadioGroup').setVisible(false);
    					form.down('#responsibleUserField').setVisible(false);
    					form.down('#uploadFileField').setDisabled(false);
    					form.down('#uploadFileField').setVisible(true);
    					form.down('#uploadFileField').allowBlank=true;
    					form.down('#inspectionRequiredRadioGroupField').setDisabled(true);
    					form.down('#inspectionRequiredRadioGroupField').setVisible(false);
    					form.down('#inspectionDoneRadioGroupField').setDisabled(false);
    					form.down('#inspectionDoneRadioGroupField').setVisible(true);
    					form.down('#inspectionDateField').setVisible(true);
    					form.down('#inspectionDoneByField').setVisible(true);
    					form.down('#returnableRadioGroup').setVisible(false);
    					form.down('#returnDateField').setVisible(false);
    					form.down('#returnByField').setVisible(false);
    					form.down('#modeOfReturnField').setVisible(false);
    					form.down('#returnedToUserField').setVisible(false);
    					form.down('#lastDateSubmissionId').setVisible(false);
    					if(portalId==2){
    						form.down('#inspectionDoneRadioGroupField').setVisible(false);
    						form.down('#inspectionDateField').setVisible(false);
    						form.down('#inspectionDoneByField').setVisible(false);
    					}
    				}else{
    					form.down('#modeOfSubmission').setDisabled(false);
    					var modeSubmissionStore=form.down('#modeOfSubmission').getStore();
    					modeSubmissionStore.on('load', function(){
    						for(var i=0; i< modeSubmissionStore.data.items.length;i++){
    							if(modeSubmissionStore.data.items[i].data.value == 'Online'){
    								modeSubmissionStore.removeAt(i);
    							} 
    						}
    					});
    					form.down('#documentTypeRadioGroup').setVisible(false);
    					form.down('#responsibleUserField').setDisabled(false);
    					form.down('#responsibleUserField').setVisible(true);
    					form.down('#uploadFileField').setDisabled(true);
    					form.down('#uploadFileField').setVisible(false);
    					form.down('#inspectionRequiredRadioGroupField').setDisabled(true);
    					form.down('#inspectionRequiredRadioGroupField').setVisible(false);
    					form.down('#inspectionDoneRadioGroupField').setDisabled(false);
    					form.down('#inspectionDoneRadioGroupField').setVisible(true);
    					form.down('#inspectionDateField').setVisible(true);
    					form.down('#inspectionDoneByField').setVisible(true);
    					form.down('#returnableRadioGroup').setDisabled(false);
    					form.down('#returnableRadioGroup').setVisible(true);
    					form.down('#returnDateField').setVisible(true);
    					form.down('#returnByField').setVisible(true);
    					form.down('#modeOfReturnField').setDisabled(true);
    					form.down('#returnedToUserField').setDisabled(true);
    					form.down('#modeOfReturnField').allowBlank=true;
    					form.down('#returnedToUserField').allowBlank=true;
    					form.down('#modeOfReturnField').setVisible(false);
    					form.down('#returnedToUserField').setVisible(false);
    					form.down('#lastDateSubmissionId').setVisible(false);
    				}
    				if(portalId == 1){
        				form.down('#documentStatus').setReadOnly(false);
        			}
    				form.down('#inspectionDateField').setMaxValue(new Date());
    				form.down('#returnDateField').setMaxValue(new Date());
    				form.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
    				form.down('#returnByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
    				form.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
    			}else{
    				showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getPersonModuleTranslation('PHYSICALLY_DOCUMENT_NOT_UPDATED'));
    			}
    		}
    	} else {
    		showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}

    },
    /**
     * Delete document form
     */
    deleteDocumentRecord : function(){
    	var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down('#facultyDocumentGrid');

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection()[0];
                        var id = "";
                        if (!isNullOrEmpty(records.get("id"))) {
                        	id = records.get("id");
                        	documentId = records.get("documentId");
                        	Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.FACULTY_DOCUMENT_DELETE,
                                method: 'DELETE',
                                params: {
                                    id: id
                                },
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                	grid.getStore().reload();
                                    showSuccessMessage(getPersonModuleTranslation('SUCCESS'), getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));
                                    
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * Save document form
     */
    saveFacultyDocumentForm: function(){
    	var this$ = this;
    	var successMsg, submitUrl;
    	var personProfile = this$.getContentPanelActiveTab();
    	var grid = personProfile.down('#facultyDocumentGrid');
    	var facultyId = personProfile.getUserId();
    	var isTransient = false;
    	var module = 'faculty';
    	var entityId = facultyId;
    	var entityType = 'faculty';
    	var form=this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    	var uploadBtn=form.down('#uploadFileField');
    	var records =grid.getSelectionModel().getSelection()[0];
    	if(!isNullOrEmpty(records)){
    		if(!uploadBtn.isVisible() && !records.get('isElectronic')){
    			var isPhysicalFile=form.down('#physicalField');
    			isPhysicalFile.setValue(true);
    		}
    		form.down('#modeOfReturnField').setDisabled(true);
    		form.down('#returnedToUserField').setDisabled(true);
    		form.down('#modeOfReturnField').allowBlank=true;
    		form.down('#returnedToUserField').allowBlank=true;
    		form.down('#modeOfReturnField').setVisible(false);
    		form.down('#returnedToUserField').setVisible(false);
    		if(records.get('isElectronic')){
    			var formData = null;
    			var editedPath=form.down('#uploadFileField');
    			var path=null;
    			var fileField = form.down('#fileDisplayField');
    			formData = form.getValues();
    			if(isNullOrEmpty(editedPath.getValue())){
    				Ext.Ajax.request({
    					type: 'rest',
    					url: SERVERURL.DOCUMENT_FORM_FIND_BY + records.get("documentId"),
    					method: 'GET',
    					success: function(res, action) {
    						var data = Ext.decode(res.responseText);
    						if(!isEmpty(data)){
    							if(!isNullOrEmpty(data.path)){
    								path=data.path;
    							}
    						}
    					}
    				});
    				this$.getDocumentController().saveDocumentFormValue(isTransient, 'EXT_DOCUMENT', true, formData, path, function(success, response, isCallBackTransient){
    					this$.hideWindowMask();
    					if(success){
    						var documentJson = new Object();
    						if(isCallBackTransient == false){
    							var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    							var id = form.down('#document_hidden_field');
    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    								submitUrl = SERVERURL.FACULTY_DOCUMENT_SAVE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    							}else{
    								submitUrl = SERVERURL.FACULTY_DOCUMENT_UPDATE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    								if (grid.getSelectionModel().getCount() > 0) {
    									var records = grid.getSelectionModel().getSelection()[0];
    									documentJson.id = records.get("id");
    								}

    							}
    							var documentId = Ext.JSON.decode(response.responseText);
    							var faculty = new Object();
    							var document = new Object();

    							faculty.id = facultyId;
    							document.id = documentId;
    							documentJson.faculty = faculty;
    							documentJson.document = document;
    							var docType = form.down('#documentTypeCombo').getValue();
    							var documentStatus = form.down('#documentStatus').getValue();
    							documentJson.documentType = {
    									id: docType
    							};
    							documentJson.documentStatusCSM = {
    									id: documentStatus
    							};
    							documentJson.status = documentStatus;
    							Ext.Ajax.request({
    								type: 'rest',
    								url: submitUrl,
    								jsonData: documentJson,
    								method: 'POST',
    								success : function(){
    									this$.getDocumentController().closeDocumentFormWindow();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll();
    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    								}
    							});


    						}
    					}

    				}, isTransient);

    			}else{//edit document with file
    				this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){

    					if(success){
    						var documentJson = new Object();
    						if(isCallBackTransient == false){
    							var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    							var id = form.down('#document_hidden_field');
    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    								submitUrl = SERVERURL.FACULTY_DOCUMENT_SAVE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    							}else{
    								submitUrl = SERVERURL.FACULTY_DOCUMENT_UPDATE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    								if (grid.getSelectionModel().getCount() > 0) {
    									var records = grid.getSelectionModel().getSelection()[0];
    									documentJson.id = records.get("id");
    								}

    							}
    							var documentId = Ext.JSON.decode(response.responseText);
    							var faculty = new Object();
    							var document = new Object();

    							faculty.id = facultyId;
    							document.id = documentId;
    							documentJson.faculty = faculty;
    							documentJson.document = document;
    							var docType = form.down('#documentTypeCombo').getValue();
    							var documentStatus = form.down('#documentStatus').getValue();
    							documentJson.documentType = {
    									id: docType
    							};
    							documentJson.documentStatusCSM = {
    									id: documentStatus
    							};
    						documentJson.status = documentStatus;
    							Ext.Ajax.request({
    								type: 'rest',
    								url: submitUrl,
    								jsonData: documentJson,
    								method: 'POST',
    								success : function(){
    									this$.getDocumentController().closeDocumentFormWindow();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll();
    									showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    								}
    							});
    						}
    					}
    				}, isTransient);
    			}
    		}else{//edit off line Document
    			this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){

    				if(success){
    					var documentJson = new Object();
    					if(isCallBackTransient == false){
    						var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    						var id = form.down('#document_hidden_field');
    						if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    							submitUrl = SERVERURL.FACULTY_DOCUMENT_SAVE;
    							successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    						}else{
    							submitUrl = SERVERURL.FACULTY_DOCUMENT_UPDATE;
    							successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    							if (grid.getSelectionModel().getCount() > 0) {
    								var records = grid.getSelectionModel().getSelection()[0];
    								documentJson.id = records.get("id");
    							}

    						}
    						var documentId = Ext.JSON.decode(response.responseText);
    						var faculty = new Object();
    						var document = new Object();

    						faculty.id = facultyId;
    						document.id = documentId;
    						documentJson.faculty = faculty;
    						documentJson.document = document;
    						var docType = form.down('#documentTypeCombo').getValue();
    						var documentStatus = form.down('#documentStatus').getValue();
    						documentJson.documentType = {
    								id: docType
    						};
    						documentJson.documentStatusCSM = {
    								id: documentStatus
    						};
    						//documentJson.status = documentStatus;
    						Ext.Ajax.request({
    							type: 'rest',
    							url: submitUrl,
    							jsonData: documentJson,
    							method: 'POST',
    							success : function(){
    								this$.getDocumentController().closeDocumentFormWindow();
    								grid.getStore().reload();
    								grid.getSelectionModel().deselectAll();
    								showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    							}
    						});
    					}
    				}

    			}, isTransient);
    		}
    	}else{//add document
    		if(!uploadBtn.isDisabled()){
    			form.down('#modeOfSubmission').setDisabled(false);
    			form.down('#modeOfSubmission').setVisible(true);
    			form.down('#modeOfSubmission').setValue('ONLINE');
    		}
    		this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){

    			if(success){
    				var documentJson = new Object();
    				if(isCallBackTransient == false){
    					var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
    					var id = form.down('#document_hidden_field');
    					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    						submitUrl = SERVERURL.FACULTY_DOCUMENT_SAVE;
    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    					}else{
    						submitUrl = SERVERURL.FACULTY_DOCUMENT_UPDATE;
    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    						if (grid.getSelectionModel().getCount() > 0) {
    							var records = grid.getSelectionModel().getSelection()[0];
    							documentJson.id = records.get("id");
    						}

    					}
    					var documentId = Ext.JSON.decode(response.responseText);
    					var faculty = new Object();
    					var document = new Object();

    					faculty.id = facultyId;
    					document.id = documentId;
    					documentJson.faculty = faculty;
    					documentJson.document = document;
    					var docType = form.down('#documentTypeCombo').getValue();
    					var documentStatus = form.down('#documentStatus').getValue();
    					documentJson.documentType = {
    							id: docType
    					};
    					documentJson.documentStatusCSM = {
								id: documentStatus
						};
    					//documentJson.status = documentStatus;
    					Ext.Ajax.request({
    						type: 'rest',
    						url: submitUrl,
    						jsonData: documentJson,
    						method: 'POST',
    						success : function(){
    							this$.getDocumentController().closeDocumentFormWindow();
    							grid.getStore().reload();
    							grid.getSelectionModel().deselectAll();
    							showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
    						}
    					});
    				}
    			}

    		}, isTransient);
    	}},
    	
    	saveOnlineFacultyDocumentFormData: function(){
		    var this$ = this;
	    	var successMsg, submitUrl;
	    	var personProfile = this$.getContentPanelActiveTab();
	    	var facultyId = personProfile.getUserId();
	    	var grid = this$.getFacultyOnlineDocumentGrid();
	    	var isTransient = false;
	    	var module = 'faculty';
	    	var entityId = facultyId;
	    	var entityType = 'faculty';
	    	var formWin = this$.getFacultyonlinedocumentformwin();
	    	var form = formWin.down('#onlineDocumentFormItemId');
	    	var uploadBtn=formWin.down('#uploadFileField');
	    	var records =grid.getSelectionModel().getSelection()[0];
	    	if(!isNullOrEmpty(records)){
	    		var formData = null;
    			var editedPath=form.down('#uploadFileField');
    			var path=null;
    			var fileField = form.down('#fileDisplayField');
    			formData = form.getValues();    
    			if(isNullOrEmpty(editedPath.getValue())){
    				Ext.Ajax.request({
    					type: 'rest',
    					url: SERVERURL.DOCUMENT_FORM_FIND_BY + records.get("documentId"),
    					method: 'GET',
    					success: function(res, action) {
    						var data = Ext.decode(res.responseText);
    						if(!isEmpty(data)){
    							if(!isNullOrEmpty(data.path)){
    								path=data.path;
    							}
    						}
    					}
    				});
    				this$.getDocumentController().saveDocumentFormValue(isTransient, 'ONLINE_DOC_FORM', true, formData, path, function(success, response, isCallBackTransient){
    					this$.hideWindowMask();
    					if(success){
    						var documentJson = new Object();
    						if(isCallBackTransient == false){
    							var formWin = this$.getFacultyonlinedocumentformwin();
    			    	    	var form = formWin.down('#onlineDocumentFormItemId');
    							var id = form.down('#document_hidden_field');
    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    								submitUrl = SERVERURL.FACULTY_DOCUMENT_SAVE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    							}else{
    								submitUrl = SERVERURL.FACULTY_DOCUMENT_UPDATE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    								if (grid.getSelectionModel().getCount() > 0) {
    									var records = grid.getSelectionModel().getSelection()[0];
    									documentJson.id = records.get("id");
    								}

    							}
    							var documentId = Ext.JSON.decode(response.responseText);
    							var faculty = new Object();
    							var document = new Object();

    							faculty.id = facultyId;
    							document.id = documentId;
    							documentJson.faculty = faculty;
    							documentJson.document = document;
    							var docType = form.down('#documentTypeCombo').getValue();
    							var documentStatus = form.down('#documentStatus').getValue();
    							if(!isNullOrEmpty(docType)){
    								documentJson.documentType = {
        									id: docType
        							};
    							}
    							if(!isNullOrEmpty(documentStatus)) {
    	    						documentJson.documentStatusCSM = {
    	    								id: documentStatus
    	    						};
    	    					}
//    							documentJson.status = documentStatus;
    							Ext.Ajax.request({
    								type: 'rest',
    								url: submitUrl,
    								jsonData: documentJson,
    								method: 'POST',
    								success : function(){
    									this$.getFacultyonlinedocumentformwin().close();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll();
    									showSuccessMessage(getPersonModuleTranslation('DOC_ONLINE_DOCUMENT'), successMsg);
    								}
    							});


    						}
    					}

    				}, isTransient);

    			} else {
    				//edit document with file
    				this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'ONLINE_DOC_FORM', function(success, response, isCallBackTransient){

    					if(success){
    						var documentJson = new Object();
    						if(isCallBackTransient == false){
    							var formWin = this$.getFacultyonlinedocumentformwin();
    			    	    	var form = formWin.down('#onlineDocumentFormItemId');
    			    	    	var id = form.down('#document_hidden_field');
    							if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    								submitUrl = SERVERURL.FACULTY_DOCUMENT_SAVE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    							}else{
    								submitUrl = SERVERURL.FACULTY_DOCUMENT_UPDATE;
    								successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    								if (grid.getSelectionModel().getCount() > 0) {
    									var records = grid.getSelectionModel().getSelection()[0];
    									documentJson.id = records.get("id");
    								}

    							}
    							var documentId = Ext.JSON.decode(response.responseText);
    							var faculty = new Object();
    							var document = new Object();

    							faculty.id = facultyId;
    							document.id = documentId;
    							documentJson.faculty = faculty;
    							documentJson.document = document;
    							var docType = form.down('#documentTypeCombo').getValue();
    							var documentStatus = form.down('#documentStatus').getValue();
    							if(!isNullOrEmpty(docType)){
    								documentJson.documentType = {
        									id: docType
        							};
    							}
    							
    							if(!isNullOrEmpty(documentStatus)) {
    	    						documentJson.documentStatusCSM = {
    	    								id: documentStatus
    	    						};
    	    					}
//    							documentJson.status = documentStatus;
    							Ext.Ajax.request({
    								type: 'rest',
    								url: submitUrl,
    								jsonData: documentJson,
    								method: 'POST',
    								success : function(){
    									this$.getFacultyonlinedocumentformwin().close();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll();
    									showSuccessMessage(getPersonModuleTranslation('DOC_ONLINE_DOCUMENT'), successMsg);
    								}
    							});
    						}
    					}
    				}, isTransient);
    			
    			}
	    	}else {
	    	this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'ONLINE_DOC_FORM', function(success, response, isCallBackTransient){
    			if(success){
    				var documentJson = new Object();
    				if(isCallBackTransient == false){
    					var formWin = this$.getFacultyonlinedocumentformwin();
    	    	    	var form = formWin.down('#onlineDocumentFormItemId');
    					var id = form.down('#document_hidden_field');
    					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
    						submitUrl = SERVERURL.FACULTY_DOCUMENT_SAVE;
    						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
    					}else{
    						submitUrl = SERVERURL.FACULTY_DOCUMENT_UPDATE;
    						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
    						if (grid.getSelectionModel().getCount() > 0) {
    							var records = grid.getSelectionModel().getSelection()[0];
    							documentJson.id = records.get("id");
    						}

    					}
    					var documentId = Ext.JSON.decode(response.responseText);
    					var faculty = new Object();
    					var document = new Object();

    					faculty.id = facultyId;
    					document.id = documentId;
    					documentJson.faculty = faculty;
    					documentJson.document = document;
     					documentJson.isElectronic = true;
    					var docType = form.down('#documentTypeCombo').getValue();
    					var documentStatus = form.down('#documentStatus').getValue();
    					if(!isNullOrEmpty(docType)) {
    						documentJson.documentType = {
    								id: docType
    						};
    					}
    					if(!isNullOrEmpty(documentStatus)) {
    						documentJson.documentStatusCSM = {
    								id: documentStatus
    						};
    					}
//    					documentJson.status = documentStatus;
    					Ext.Ajax.request({
    						type: 'rest',
    						url: submitUrl,
    						jsonData: documentJson,
    						method: 'POST',
    						success : function(response, action) {
    							if (response.responseText == '0') {
    								form.down('#docDetails').setValue('');
    								showWarningMessage(getPersonModuleTranslation('DOC_ONLINE_DOCUMENT'), getPersonModuleTranslation('DOCUMENT_ALREADY_EXISTS'));
    							} else {
    								this$.getFacultyonlinedocumentformwin().close();
        							grid.getStore().reload();
        							grid.getSelectionModel().deselectAll();
        							showSuccessMessage(getPersonModuleTranslation('DOC_ONLINE_DOCUMENT'), successMsg);
    							}
    						}
    					});
    				}
    			}
    		}, isTransient);
	    	}
	 },
	 
	 editFacultyOnlineDocumentFormWindow : function() {
		 var this$ = this;
		 var form = null;
		 var personProfile = this$.getContentPanelActiveTab();
		 var grid=this.getFacultyOnlineDocumentGrid();
		 if (grid.getSelectionModel().getCount() > 0) {
			 var records = grid.getSelectionModel().getSelection()[0];
			 if(!isEmpty(records)){
				 var documentId = records.get("documentId");
				 var isPreDefined = records.get("isPreDefined");
				 var formWindow = this$.getFacultyonlinedocumentformwin();
	             if (!formWindow) {
	            	  Ext.widget('onlinedocumentformwin',{
	                   	itemId : 'facultyOnlineDocumentFormWin'
	                   });
	                 formWindow = this$.getFacultyonlinedocumentformwin();
	             }
	             if (isNullOrEmpty(documentId)) {
	            	 formWindow.down('#documentTypeCombo').setValue(records.get('documentType'));
	             }else {
	            	 Ext.Ajax.request({
	                     type: 'rest',
	                     url: SERVERURL.DOCUMENT_FORM_FIND_BY + documentId,
	                     method: 'GET',
	                     success: function(res, action) {
	                     	var data = Ext.decode(res.responseText);
	                     	if(!isEmpty(data)){
	                     		var form = formWindow.down('#onlineDocumentFormItemId');
	                     		this$.setOPDocumentFormValue(form, data);
	                     	}
	                     }
	                     
	                 });
	             }
	             formWindow.show();
				 if(isPreDefined){
					 /*formWindow.down('#documentType').setValue(records.get('isPreDefined'));*/
				     formWindow.down('#documentType').setReadOnly(true);
					/* formWindow.down('#documentTypeCombo').setValue(records.get('documentType'));*/
					 formWindow.down('#documentTypeCombo').setReadOnly(true);
				 }else{
					 formWindow.down('#documentType').setValue({isPreDefined:records.get('isPreDefined')});
				     formWindow.down('#documentType').setReadOnly(true);
					 var documentName = formWindow.down('#documentNameItemId');
					 documentName.setVisible(true);
					 documentName.setValue(records.get('documentName'));
					// documentName.setReadOnly(false);
					 var documentTypeCombo = formWindow.down('#documentTypeCombo');
					 documentTypeCombo.setVisible(false);
					 formWindow.down('#documentType').setValue({isPreDefined:records.get('isPreDefined')});
				     formWindow.down('#documentType').setReadOnly(true);
				 } 
				/* formWindow.down('#remarkItemId').setValue(records.get('remark'));*/
				
 				 formWindow.down('#inspectionDoneByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
			 }
		 }else {
			 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		 }

	 },
	
	 loadDocumentGridStore:function(grid, isElectronic) {
		 var this$ = this;
		 var personProfile = this$.getContentPanelActiveTab();
		 var facultyId = personProfile.getUserId();
		 var store = grid.getStore();
		 this$.resetPageSetting(store);
		 store.getProxy().extraParams = {
			 facultyId: facultyId,
			 isElectronic: isElectronic
		 };
		 store.load();
	 },
	
	 showOnlineDocumentFormWindow : function(){
		 var $this = this;
		 var formWindow = $this.getFacultyonlinedocumentformwin();
		 if (!formWindow) {
			 Ext.widget('onlinedocumentformwin',{
				 itemId : 'facultyOnlineDocumentFormWin'
			 });
			 formWindow = $this.getFacultyonlinedocumentformwin();
		 }
		 var documentStatusCSM = formWindow.down('#documentStatus');
    	   documentStatusCSM.getStore().load({
	   		   callback: function(records, operation, success) {
	   			  for(var i in records){
	   				  if(records[i].data.code =="SUBMITTED"){
	   					documentStatusCSM.setValue(records[i].data.id);
	   				  }
	   			  }
	   		  } 
		  });
		 formWindow.show();
	 },
	
	 showPhysicalDocumentFormWindow : function(){
		 var $this = this;
		 var formWindow = $this.getFacultyphysicaldocumentformwin();
		 if (!formWindow) {
			 Ext.widget('physicaldocumentformwin',{
				 itemId : 'facultyPhysicalDocumentFormWin'
			 });
			 var formWindow = $this.getFacultyphysicaldocumentformwin();
		 }
		 var modeSubmissionStore=formWindow.down('#modeOfSubmission').getStore();
		 modeSubmissionStore.on('load', function(){
			 for(var i=0; i< modeSubmissionStore.data.items.length;i++){
				 if(modeSubmissionStore.data.items[i].data.value == 'Online'){
					 modeSubmissionStore.removeAt(i);
				 } 
			 }
		 });
		 
		// if(portalId ==1 ||portalId==2){
      	   var documentStatusCSM = formWindow.down('#documentStatus');
      	   documentStatusCSM.getStore().load({
     		   callback: function(records, operation, success) {
     			  for(var i in records){
     				  if(records[i].data.code =="SUBMITTED"){
     					documentStatusCSM.setValue(records[i].data.id);
     				  }
     			  }
     		  } 
			  });
    // }
		 formWindow.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
		 var form = formWindow.down('#physicalDocumentFormItemId');
		 Ext.apply(form, {
			 isEditable: false
		 });
		 formWindow.show();
		 var documentNote = formWindow.down('#documentNoteId');
		 documentNote.setVisible(false);
	 },
	
	/*
	 * On change of radio button Inspection Done  
	 */
	onSelectionIsInspectionDone : function(form){
		var this$ = this;
		var isInspectionDoneYesField = form.down('#isInspectionDoneYesField');
		if(isInspectionDoneYesField.getValue() == true){
			this$.showHideInspectedField(false, form);
		}else{
			this$.showHideInspectedField(true, form);
		}
		this$.changeStatus(form);
    },
    showHideInspectedField : function(isDisabled, form){
    	var this$ = this;
    	var inspectionDateField = form.down('#inspectionDateField'); 
        var inspectionDoneByField = form.down('#inspectionDoneByField');
        if(isDisabled){
        	inspectionDateField.setValue('');
        	inspectionDoneByField.clearValue();
        }
        inspectionDateField.setDisabled(isDisabled);
        inspectionDoneByField.setDisabled(isDisabled);
    },
    changeStatus:function(form){
    	var values=form.getForm().getValues();
    	var documentStatusCSM = form.down('#documentStatus');
    	 var values=form.getForm().getValues();
    	if(values.isReturnable==true){
			documentStatusCSM.getStore().load({
 			   callback: function(records, operation, success) {
 				  for(var i in records){
 					  if(records[i].data.code =="RETURNED"){
 						documentStatusCSM.setValue(records[i].data.id);
 					  }
 				  }
 			  } 
 		  });
			//form.down("#documentStatus").setValue('RETURNED');
		}else if(values.isInspectionRequired==true && values.isInspectionDone==false){
			//form.down("#documentStatus").setValue('INSPECTED_PENDING');
			documentStatusCSM.getStore().load({
	 			   callback: function(records, operation, success) {
	 				  for(var i in records){
	 					  if(records[i].data.code =="INSPECTED_PENDING"){
	 						documentStatusCSM.setValue(records[i].data.id);
	 					  }
	 				  }
	 			  } 
	 		  });
		}else{
			documentStatusCSM.getStore().load({
	 			   callback: function(records, operation, success) {
	 				  for(var i in records){
	 					  if(records[i].data.code =="SUBMITTED"){
	 						documentStatusCSM.setValue(records[i].data.id);
	 					  }
	 				  }
	 			  } 
	 		  });
		}
		form.getForm().checkValidity();
	},
	 setOPDocumentFormValue : function(form, data){
	    	var this$ = this;
	    	var filePath = '';
	    	var uploadFileField = form.down('#uploadFileField');
	    	if(!isNullOrEmpty(data.path)){
	    		filePath = data.path;
	    		var filePathArray = new Array();
	    		if(filePath.indexOf('/') !=-1){
	    			filePathArray = filePath.split("/");
	    		}else if(filePath.indexOf('\\')){
	    			filePathArray = filePath.split("\\");
	    		}
	    		var length = filePathArray.length;
	    		if(length > 0){
	    			var fileName = "";
	    			filePath = filePathArray[length - 1];
	    			fileName = filePath;
	    			if(filePath.length > 30) {
	    				filePath = filePath.substring(0,29)+"...";
	    			}else{
	    				fileName = filePath;
	    			}
	    			filePath = '<a href="#" title="'+fileName+'">'+filePath+'</a>';
	    			
	    		}else{
	    			filePath = '';
	    		}
	    	}
	    	var fileDisplayField = Ext.create('Ext.Component',{
	            itemId: 'fileDisplayField',
	            width : 226,
	            autoEl: {
	                tag: 'a',
	                href: '#',
	                html: filePath
	            }
	        });
	    	
	    		form.getForm().setValues(data);
	    		
	    		var documentTyps=	form.down('#documentTypeCombo');
	    		if(!isNullOrEmpty(data.documentType)) {
	    			documentTyps.getStore().load({
	    				callback: function(records, operation, success) {
	    					for(var i in records){
	    						if(records[i].data.id ==data.documentType.id){
	    							documentTyps.setValue(records[i].data.id);
	    						}
	    					}
	    				} 
	    			});
	    		}
	    		
	    		var documentStatusCSM = form.down('#documentStatus');
	    		if(!isNullOrEmpty(data.documentStatusCSM)) {
	    			documentStatusCSM.getStore().load({
	    				callback: function(records, operation, success) {
	    					for(var i in records){
	    						if(records[i].data.id ==data.documentStatusCSM.id){
	    							documentStatusCSM.setValue(records[i].data.id);
	    						}
	    					}
	    				} 
	    			});
	    		}
	    		if(!isNullOrEmpty(data.returnedDate)){
	    			form.getForm().findField('returnedDate').setValue(dateRender(data.returnedDate));
	    		}
	    		form.getForm().findField('submissionDate').setValue(dateRender(data.submissionDate));
	    		form.getForm().findField('inspectionDate').setValue(dateRender(data.inspectionDate));
	    		form.getForm().findField('isInspectionDone').setValue({isInspectionDone:data.isInspectionDone});
	    		form.down('#inspectionDoneRadioGroupField').setVisible(true);
	    		form.down('#inspectionDateField').setVisible(true);
	    		form.down('#inspectionDoneByField').setVisible(true);
	    		form.down('#inspectionDateField').setMaxValue(new Date());
	    		if(data.isInspectionDone){
	    			form.down('#inspectionDoneRadioGroupField').setDisabled(false);
	    			form.down('#inspectionDateField').setDisabled(false);
	    			form.down('#inspectionDoneByField').setDisabled(false);
	    		}
	 },
	 onSelectUploadFileField : function(fileField, value, eOpts){
         if (!isNullOrEmpty(value)) {
             var $this = this;
             value = value.replace('C:\\fakepath\\', '');
             var newValue = value.replace(/ +/g, " ").split(' ').join('_');
             fileField.setRawValue(newValue);
             var file = fileField.fileInputEl.dom.files[0];
             var form = fileField.up().up();
             var fileInfoContainer = form.down('#fileInfoContainer');
             var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
             var docDetails = form.down('#docDetails');
             var docType = form.down('#documentTypeCombo');
             if (!isNullOrEmpty(docType) && docType.getRawValue() == 'Signature') {
                 if (!isNullOrEmpty(extension)) {
                     if (!((extension == "png" || extension == "jpeg" || extension == "jpg") && (file.size / 1024) <= 50)) {
                         fileField.reset();
                         showWarningMessage(getCommonTranslation("ALERT"), getPersonModuleTranslation('SIGNATURE_IMAGE_ALERT_MESSAGE'));
                     }
                     var fileInfoContainer = form.down('#fileInfoContainer');
                     fileInfoContainer.setVisible(true);
                     docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
                 }
             } else {
                 if ($this.isValidFileExtension(extension)) {
                     if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                         fileInfoContainer.setVisible(false);
                         fileField.reset();
                         showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                     } else {
                         var form = fileField.up().up();
                         var fileInfoContainer = form.down('#fileInfoContainer');
                         fileInfoContainer.setVisible(true);
                         var docDetails = form.down('#docDetails');
                         docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
                     }
                 } else {
                     fileInfoContainer.setVisible(false);
                     fileField.reset();
                     showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                 }
             }
         }
     
	 },
     editFacultyPhysicalDocumentFormWindow : function() {
     var this$ = this;
     var form = null;
     var personProfile = this$.getContentPanelActiveTab();
     var grid=this.getFacultyPhysicalDocumentGrid();
     if (grid.getSelectionModel().getCount() > 0) {
    	 var records = grid.getSelectionModel().getSelection()[0];
    	 if(!isEmpty(records)){
    		 var documentId = records.get("documentId");
    		 var isPreDefined = records.get("isPreDefined");
    		 var formWindow = this$.getFacultyphysicaldocumentformwin();
    		 var form = formWindow.down('#physicalDocumentFormItemId');
    		 if (!formWindow) {
    			 Ext.widget('physicaldocumentformwin',{
    				 itemId : 'facultyPhysicalDocumentFormWin'
    			 });
    			 formWindow = this$.getFacultyphysicaldocumentformwin();
    		 }
    		 if (isNullOrEmpty(documentId)) {
    			 formWindow.down('#documentTypeCombo').setValue(records.get('documentType'));
    		 }else {
    			 Ext.Ajax.request({
    				 type: 'rest',
    				 url: SERVERURL.DOCUMENT_FORM_FIND_BY + documentId,
    				 method: 'GET',
    				 success: function(res, action) {
    					 var data = Ext.decode(res.responseText);
    					 if(!isEmpty(data)){
    						 var form = formWindow.down('#physicalDocumentFormItemId');
    						 this$.setOPDocumentFormValue(form, data);
    					 }
    				 }

    			 });
    		 }
				var modeSubmissionStore=formWindow.down('#modeOfSubmission').getStore();
				modeSubmissionStore.on('load', function(){
					for(var i=0; i< modeSubmissionStore.data.items.length;i++){
						if(modeSubmissionStore.data.items[i].data.value == 'Online'){
							modeSubmissionStore.removeAt(i);
						} 
					}
				});
			 formWindow.show();
    		 if(isPreDefined){
				 /*formWindow.down('#documentType').setValue(records.get('isPreDefined'));*/
			     formWindow.down('#documentType').setReadOnly(true);
				/* formWindow.down('#documentTypeCombo').setValue(records.get('documentType'));*/
				 formWindow.down('#documentTypeCombo').setReadOnly(true);
			 }else{
				 formWindow.down('#documentType').setValue({isPreDefined:records.get('isPreDefined')});
			     formWindow.down('#documentType').setReadOnly(true);
				 var documentName = formWindow.down('#documentNameItemId');
				 documentName.setVisible(true);
				 documentName.setValue(records.get('documentName'));
				// documentName.setReadOnly(true);
				 var documentTypeCombo = formWindow.down('#documentTypeCombo');
				 documentTypeCombo.setVisible(false);
				 formWindow.down('#documentType').setValue({isPreDefined:records.get('isPreDefined')});
			     formWindow.down('#documentType').setReadOnly(true);
			 } 
				form.down('#returnByField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
				form.down('#responsibleUserField').getStore().getProxy().api.read=SERVERURL.PATH_FIND_ALL_FACULTY_SMART_SEARCH_BY_DOCUMENT;
	    		
				 var documentNote = formWindow.down('#documentNoteId');
				 documentNote.setVisible(false);
				 
				form.down('#documentStatus').setReadOnly(false);
				form.down('#returnableRadioGroup').setVisible(true);
	    		form.down('#returnDateField').setVisible(true);
	    		form.down('#returnByField').setVisible(true);
	    		form.down('#returnDateField').setMaxValue(new Date());
	    		form.getForm().findField('isReturnable').setValue({isReturnable:records.get('isReturnable')});
	    		if(records.get('isReturnable')){
	    			form.down('#returnableRadioGroup').setDisabled(false);
	    			form.down('#returnDateField').setDisabled(false);
	    			form.down('#returnByField').setDisabled(false);
	    		}
    	 }
     }else {
    	 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     }
     },
     savePhysicalFacultyDocumentFormData: function(){  
		var this$ = this;
    	var successMsg, submitUrl;
    	var personProfile = this$.getContentPanelActiveTab();
    	var facultyId = personProfile.getUserId();
    	var grid = this$.getFacultyPhysicalDocumentGrid();
    	var isTransient = false;
    	var module = 'faculty';
    	var entityId = facultyId;
    	var entityType = 'faculty';
    	var formWin = this$.getFacultyPhysicalDocumentGrid();
    	var form = formWin.down('#physicalDocumentFormItemId');
    	var records =grid.getSelectionModel().getSelection()[0];
	    	this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'PHYSICAL_DOC_FORM', function(success, response, isCallBackTransient){
 			if(success){
 				var documentJson = new Object();
 				if(isCallBackTransient == false){
 					var formWin = this$.getFacultyphysicaldocumentformwin();
 	    	    	var form = formWin.down('#physicalDocumentFormItemId');
 					var id = form.down('#document_hidden_field');
 					if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
 						submitUrl = SERVERURL.FACULTY_DOCUMENT_SAVE;
 						successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
 					}else{
 						submitUrl = SERVERURL.FACULTY_DOCUMENT_UPDATE;
 						successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
 						if (grid.getSelectionModel().getCount() > 0) {
 							var records = grid.getSelectionModel().getSelection()[0];
 							documentJson.id = records.get("id");
 						}

 					}
 					var documentId = Ext.JSON.decode(response.responseText);
 					var faculty = new Object();
 					var document = new Object();

 					faculty.id = facultyId;
 					document.id = documentId;
 					documentJson.faculty = faculty;
 					documentJson.document = document;
 					documentJson.isElectronic = false;
 					var docType = form.down('#documentTypeCombo').getValue();
 					var documentStatus = form.down('#documentStatus').getValue();
 					if(!isNullOrEmpty(docType)) {
 						documentJson.documentType = {
 								id: docType
 						};
 					}
 					var otherRadioBtn=form.down("#otherItemId").getValue();
 					if(!isNullOrEmpty(docType)||otherRadioBtn) {
 					documentJson.documentStatusCSM = {
							id: documentStatus
					};
 					}
 				//	documentJson.status = documentStatus;
 					Ext.Ajax.request({
 						type: 'rest',
 						url: submitUrl,
 						jsonData: documentJson,
 						method: 'POST',
 						success : function(response, action){
 							if (response.responseText == '0') {
								showWarningMessage(getPersonModuleTranslation('DOC_PHYSICAL_DOCUMENT'), getPersonModuleTranslation('DOCUMENT_ALREADY_EXISTS'));
							} else {
								this$.getFacultyphysicaldocumentformwin().close();
	 							grid.getStore().reload();
	 							grid.getSelectionModel().deselectAll();
	 							showSuccessMessage(getPersonModuleTranslation('DOC_PHYSICAL_DOCUMENT'), successMsg);
							}
 						}
 					});
 				}
 			}
 		}, isTransient);
	 },
	 
	 onChangePredefinedRadioGroup : function(formWin, newValue, formType) { // formType(ONLINE, PHYSICAL)
		 
     	var store = formWin.down('#documentTypeCombo').getStore();
     	var documentTypeCombo = formWin.down('#documentTypeCombo');
     	var documentName = formWin.down('#documentNameItemId');
     	var remarkItemId = formWin.down('#remarkItemId');
     	if (formType == 'ONLINE') {
     		formWin.down('#uploadFileField').reset();
     		formWin.down('#docDetails').setValue('');
     	}
     	if (formType == 'PHYSICAL') {
     		formWin.down('#responsibleUserField').reset();
         	formWin.down('#modeOfSubmission').reset();
     	}
     	if(newValue.isPreDefined == false){
     		documentTypeCombo.reset();
     		documentName.reset();
     		store.removeAll();
     		documentTypeCombo.setVisible(false);
     		documentName.setVisible(true);
     		documentTypeCombo.allowBlank = true;
     		documentName.allowBlank = false;
     	} else {
     		documentTypeCombo.reset();
     		documentName.reset();
     		store.load();
     		documentTypeCombo.setVisible(true);
     		documentName.setVisible(false);
     		documentTypeCombo.allowBlank = false;
     		documentName.allowBlank = true;
     	}
     	remarkItemId.reset();
	 },
	 deleteFacultyDocument : function(isOnline) {
		 var $this = this;
		 var grid;
		 var winTitle;
		 if(isOnline == true) {
			 winTitle =  getPersonModuleTranslation('DOC_ONLINE_DOCUMENT');
			 grid = $this.getFacultyOnlineDocumentGrid();
		 } else {
			 winTitle =  getPersonModuleTranslation('DOC_PHYSICAL_DOCUMENT');
			 grid = $this.getFacultyPhysicalDocumentGrid();
		 }
		 var records =grid.getSelectionModel().getSelection()[0];
		 
		 if(!isNullOrEmpty(records)) {
			 showConfirmMessage(winTitle, getPersonModuleTranslation('DOC_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				 if (btn == 'yes') {
				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_DELETE_FACULTY_DOCUMENT,
					params: {
                        id: records.raw.id
                    },
					method: 'DELETE',
					success: function(res, action) {
						 Ext.getBody().unmask();
						 $this.loadDocumentGridStore(grid, isOnline);
						 showSuccessMessage(winTitle, getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));
					}
				});
			 }
			 });
		 } else {
			 showWarningMessage(getPersonModuleTranslation('winTitle'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		 }
	 }
});
