/*
 * This controller is used for student track request actions.   
 */
Ext.define('Academia.controller.personinfo.student.StudentTrackRequestController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['personinfo.student.StudentRequestView', 'personinfo.student.StudentRequestQuickSearch'],

    alias: "widget.studenttrackrequestcontroller",

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'studentRequestView',
        selector: 'studentrequestview'
    }, {
        ref: 'studentRequestQuickSearch',
        selector: 'studentrequestquicksearch'
    },{
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=studentRequestGrid]'
    }],
    config: {
    	STUDENT_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_REQUEST_PRIVILEGES'),
    	PARENT_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_REQUEST_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            // "studentsearchresultgrid": {
            // studentIdClicked: function(dataIndex, record) {
            // var tabTitle = record.get(dataIndex);
            // var menuController = this.getMenuController();
            // menuController.addTab(tabTitle, 'studenttrackrequest',
            // CONSTANTS.MENU_COLOR_THREE);
            // }
            //
            // }
        	'studentrequestquicksearch form[itemId=resultGridForm] grid[itemId=studentRequestGrid]' :  {
  	      	   afterrender : function(grid){
  	      		   if(portalId==7){
  	      			this.genericCBGridAccessControlValidation(grid, this.getPARENT_REQUEST_PERMISSIONS());
  	      		   }else{
  	      			this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_REQUEST_PERMISSIONS());   
  	      		   }
  					var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
  			   		viewButton.setVisible(false);
  				}	
  	          },
  		      'studentrequestquicksearch[itemId=studentRequestQuickSearchId] searchresultgrid[itemId=studentRequestGrid]': {
  		    	 render: function(grid) {
  		    		 alert("Hi")
  					this.gridRenderFunction(grid);
  				}
  		      },
  		      'searchresultgrid[itemId=studentRequestGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
  		            click: function() {
  		                this.exportStudentRequest(SERVERURL.PDFEXPORT,'pdf',false);
  		            }
 		        },
 		        'searchresultgrid[itemId=studentRequestGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
 		            click: function() {
 		                this.exportStudentRequest(SERVERURL.PDFEXPORT,'pdf',true);
 		            }
 		        },
 		        'searchresultgrid[itemId=studentRequestGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
 		            click: function() {
 		                this.exportStudentRequest(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
 		            }
 		        },
 		        'searchresultgrid[itemId=studentRequestGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
 		            click: function() {
 		                this.exportStudentRequest(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
 		            }
 		        }
        });
    },
    
    /*
     * This function is to export pdf and xcel
     */
    exportStudentDebarment : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getStudentRequestQuickSearch();	
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation('STUDENT_DEBARMENT');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    gridRenderFunction:function(grid){
		grid.addButtonToolbar();
    },
    
    getMenuController: function() {
        return Academia.app.getController('menu.CoreERPNavigationController');
    }
});