/**
 * @author Priyanshi Sharma
 * 
 */
Ext.define('Academia.controller.placement.placementReport.PlacementDetailReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['placement.placementcampus.PlacementCampusStore','placement.placementjobapplication.PlacementJobApplicationROStore',
		        'placement.placementcampus.placementCampusCoordinatorStore','placement.placementcampus.PlacementCampusRecOrgALStore',
		        'placement.placementcampus.placementCampusOrgAlStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		        'placement.PlacementDetailReport.PlacementDetailReportGridStore','common.BatchesByProgramId','common.ProgramByAcademyLocationStore',
		        'placement.PlacementTypeStore'],
	views : ['placement.PlacementDetailReport.PlacementDetailReportStructure','placement.PlacementDetailReport.PlacementDetailReportFilters',
		'placement.PlacementDetailReport.PlacementDetailReportTabStructure',
		'placement.PlacementDetailReport.PlacementDetailReportGrid'],
	models:[ ]  ,
	config:{
	        PLACEMENT_DETAIL_REPORT_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PLACEMENT__DETAIL_REPORT_PRIVILEGES')	
	   },
	   refs : [{
    	   ref : 'placementdetailreportgrid',
    	   selector : 'placementdetailreportgrid'
	   },{
		   ref:'placementdetailreportfilters',
		   selector:'placementdetailreportfilters'
	   }],
	   init : function() {
    	   this.control({    
    		   
    		   'placementdetailreportfilters button[itemId=searchBtnPlcItemId]': {
    			   click: this.loadPlacementDetailReportGrid
    		   },
    		   'placementdetailreportfilters button[itemId=resetBtnPlcItemId]': {
    			   click: this.resetPlacementDetailReportFilter
    		   },
    		   'placementdetailreportfilters nestedJsonCombo[itemId=organizingAcademyLocationPlcItemId]':{
    			   select:function(obj,rec){
    				   var data=rec[0].data.id;  
    				   var filterForm=obj.up('form');
    				   var progamField=filterForm.down('#programPlcItemId');
    				   progamField.setDisabled(false);
    				   progamField.reset();
    				   progamField.getStore().getProxy().extraParams={
    					   academyLocationId:data
    				   };
    				   progamField.getStore().load();
    			   }
    		   },
    		   'placementdetailreportfilters nestedJsonCombo[itemId=campusCoordinatorPlcItemId]':{
    			   render: function(obj) {
    				   var $this = this;
    				   var locations = [];
    				   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
    				   for(var i=0; i<academyLocationList.length; i++){
    				   locations.push(academyLocationList[i].id);
    				   }
    				   var store = obj.getStore();
    				   store.getProxy().extraParams={
    					   roleName:'FACULTY',
    					   academyLocationIds:locations.join()
    				   }
    			   }
    		   },
    		   'placementdetailreportfilters nestedJsonCombo[itemId=programPlcItemId]':{
    			   select:function(obj,rec){
    				   var data=rec[0].data.id;  
    				   var filterForm=obj.up('form');
    				   var batchField=filterForm.down('#batchPlcItemId');
    				   batchField.setDisabled(false);
    				   batchField.reset();
    				   batchField.getStore().getProxy().extraParams={
    					   id:data
    				   };
    				   batchField.getStore().load();
    			   }
    		   },
    		   'placementdetailreportfilters nestedJsonCombo[itemId=batchPlcItemId]':{
    			   select:function(obj,rec){
    				   var data=rec[0].data.id;  
    				   var filterForm=obj.up('form');
    				   var periodField=filterForm.down('#periodIdPlcItemId');
    				   periodField.setDisabled(false);

    				   periodField.reset();
    				   periodField.getStore().getProxy().extraParams={
    					   id:data
    				   };
    				   periodField.getStore().load();
    			   }
    		   },
    	   });
	   },
	   loadPlacementDetailReportGrid:function(){
    	   var $this=this;
    	   var form = $this.getPlacementdetailreportfilters();
    	   var intakeYearId = form.down("#intakeYearPlcDetailItemId").getValue();
    	   var placementTypeId = form.down("#placementTypeItemId").getValue();
    	   var placementDriveId = form.down("#placementcampusPlcDetailItemId").getValue();
    	   var coordinatorId = form.down('#campusCoordinatorPlcItemId').getValue();
    	   var recruitingOrganizationId = form.down('#academyLocationPlcItemId').getValue();
    	   var campusLocationId = form.down('#organizingAcademyLocationPlcItemId').getValue();
    	   var programId = form.down("#programPlcItemId").getValue();
    	   var batchId = form.down("#batchPlcItemId").getValue();
    	   var periodId = form.down("#periodIdPlcItemId").getValue();
    	   var startDate = form.down("#startDatePlcItemId").getValue();
    	   var endDate = form.down("#endDatePlcItemId").getValue();
    	   var placementdetailreportgrid = this.getPlacementdetailreportgrid();
    	   var grid = $this.getPlacementdetailreportgrid();
    	   var values = form.getForm().getValues();
    	   var store =  grid.getStore();
    	   store.getProxy().extraParams = {
    		   intakeYearId: intakeYearId,
    		   placementTypeId: placementTypeId,
    		   placementDriveId: placementDriveId,
    		   coordinatorId: coordinatorId,
    		   recruitingOrganizationId:recruitingOrganizationId,
    		   campusLocationId: campusLocationId,
    		   programId:programId,
    		   batchId: batchId,
    		   periodId: periodId,
    		   startDate: values.startDateId,
    		   endDate: values.endDateId
    	   };
    	   $this.resetPageSetting(store);
    	   store.load();
    	   placementdetailreportgrid.config.searchFilterForm = form;
       },
       resetPlacementDetailReportFilter:function(){
    	   this.getPlacementdetailreportfilters().getForm().reset();
    	   var form = this.getPlacementdetailreportfilters();
    	   var progamField=form.down('#programPlcItemId');
		   progamField.setDisabled(true);
		   var batchField=form.down('#batchPlcItemId');
		   batchField.setDisabled(true);
		   var periodField=form.down('#periodIdPlcItemId');
		   periodField.setDisabled(true);
       }
});

