Ext.define('Academia.controller.program.ProgramCourseSpecializationController', {
    extend: 'Academia.controller.base.BaseController',
    stores: [
             'program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationStoreGrid',
             'program.programDetails.programBatches.courseSpecialization.ProgramSpecializationCodeStore'
             ],
    models: [
             'program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationModelGrid',
             'program.programDetails.programBatches.courseSpecialization.ProgramSpecializationCodeModel'
             ],
    views: [
            'baselayout.contentarea.ContentPanel',
            'program.programDetails.programBatchDetails.courseSpecialization.ProgramCourseSpecializationForm',
            'program.programDetails.programBatchDetails.courseSpecialization.ProgramCourseSpecializationGrid',
            'program.programDetails.programBatchDetails.courseSpecialization.ProgramCourseSpecializationStructure',
            'program.programDetails.BatchDetailsTabStructure'
        	],
    config:{
    	   /* * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
        
    	    *//**
    	    * @cfg {Array} PROGRAMCOURSESPECIALIZATION_PERMISSIONS array (required)
    	    * The array of permissions to use for Access control wise enabling and disabling buttons.
    	    * @accessor
    	    */
    		PROGRAMCOURSESPECIALIZATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAMCOURSESPECIALIZATION_PRIVILEGES')  		  
    },      	
    
    refs: [{
        ref: 'programcoursespecializationgrid',
        selector: 'programcoursesspecializationgrid'
    },{
        ref: 'programcoursespecializationformwindow',
        selector: 'programcoursespecializationformwindow'
    },{
        ref: 'programcourseSpecializationformwindow',
        selector: 'programcoursespecializationformwindow form'
    },{
	    ref: 'contentPanel',
	    selector: 'contentPanel'
	},{
	    ref: 'programbatchdetailstabstructure',
	    selector: 'programbatchdetailstabstructure'
	},{
	    ref: 'batchdetailstabstructure',
	    selector: 'batchdetailstabstructure'
	}],


    init: function(application) {
        this.control({
        	'programcoursespecializationgrid':{
        		render:function(grid){
        			 var $this = this;
        			this.doAccessControlValidation(grid, this.getPROGRAMCOURSESPECIALIZATION_PERMISSIONS());
  				  var programStructure = this.getBatchdetailstabstructure();
  				  var batchId = programStructure.down("#batchId").getValue();
  				  var store = grid.getStore();
  				  store.getProxy().extraParams = {
  					  batchId : batchId
  				  };
  				  store.load();
        		}
        	},
        	
        	'programcoursespecializationgrid button[itemId=btnAdd]':{
            	click: function() {
                	this.showProgramCourseSpecializationFormWindow();
                }
            },'programcoursespecializationformwindow button[itemId=programCourseSpecializationCancel]':{
            	click: function() {
                	this.closeProgramCourseSpecializationFormCancel();
                }
            },
            'programbatchdetailstabstructure combo[itemId=batchId]':{
            	select: function(c,r) {
            		var batchId = "";
            		if(Ext.isObject(r) || Ext.isArray(r)){
            			batchId=r[0].data.id;
					  }else{
						  batchId=r;
					  }
            		var $this=this;
            		var store = $this.getStore('program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationStoreGrid');
            		if(batchId!=null){
	            		store.getProxy().extraParams = {
	            			batchId: batchId
	    				};
	    				store.load();
	    			 }	
                }
            },
            'programcoursespecializationformwindow':{
            	show: function() {
            	    var $this=this;
            	    var store=$this.getStore('program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationStoreGrid');
            	    store.load();
                }
            },'programcoursespecializationformwindow combo[itemId=specializationIdItemId]':{
            	select: function(c,r) {
            		var windowform= Ext.ComponentQuery.query('form#programCourseSpecializationFormWindow')[0];
                    var form=windowform.getForm();
                    form.findField('specializationName').setValue(r[0].data.specializationName);
                    form.findField('specializationDescription').setValue(r[0].data.specializationDescription);
                }
            },'programcoursespecializationformwindow button[itemId=programCourseSpecializationFormSubmit]':{
            	click: function() {
                	this.saveCourseSpecialization();
                }
            },'programcoursespecializationgrid button[itemId=btnEdit]':{
            	click: function(obj) {
            		var grid=obj.ownerCt.ownerCt;
                	this.editCourseSpecializationWindow(grid);
                }
            },'programcoursespecializationgrid button[itemId=btnDelete]':{
            	click: function(obj, e, eOpts) {
            		var grid=obj.ownerCt.ownerCt;
                  this.deleteCourseSpecializationData(grid);
                }
            },'programcoursespecializationgrid button[itemId=btnView]':{
            	click: function(obj) {
            		var grid=obj.ownerCt.ownerCt;
                    this.viewCourseSpecializationData(grid);
                  }
              }
        });
    },
           
        showProgramCourseSpecializationFormWindow: function() {
        	//TODO
        	var $this = this;
        	var tabStructure = $this.getProgrambatchdetailstabstructure();
	    	var batchId = tabStructure.getForm().findField('batch').getValue();
        	Ext.Ajax.request({
       		  type : 'rest',
       		  url : SERVERURL.PROGRAM_BATCH_FIND_BY_ID,
       		  params : {
       			  id : batchId
       		  },
       		  method : 'GET',
       		  success : function(response) {
       			  var data = Ext.decode(response.responseText);
       			  if(data.specializationPossible){
       				  	var formWindow = $this.getProgramcoursespecializationformwindow();
	       		        if (!formWindow) {
	       		            Ext.widget('programcoursespecializationformwindow');
	       		            formWindow = $this.getProgramcoursespecializationformwindow();
	       		        }
	       		        formWindow.show();
       			  }else{
       				showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('NO_SPEC_CAN_BE_ADDED')); 
       			  }
       		  }
       	    });
	       
	    },
	    closeProgramCourseSpecializationFormCancel: function() {
	        this.getProgramcoursespecializationformwindow().close();
	    },
	    saveCourseSpecialization:function(){
	        var $this=this;
	    	var tabStructure=$this.getProgrambatchdetailstabstructure();
	    	var grid=$this.getStore('program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationStoreGrid');
	    	var batchId=tabStructure.getForm().findField('batch').getValue();
	    	var courseSpecializationCenter=Ext.ComponentQuery.query('form#programCourseSpecializationFormWindow')[0];
	    	var form=courseSpecializationCenter.getForm();
	    	var values=form.getFieldValues();
	    	var submitData=new Academia.model.program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationModelGrid();
	    	    submitData.set('specializationId',values.specializationId);
	    	    submitData.set('batchId',batchId);
	    	var fData = Ext.encode(submitData.data);
	    	var submitUrl = SERVERURL.PROGRAM_BATCH_DETAIL_SPECIALIZATION_CREATE_URL;
	    	 $this.applyWindowMask();
    			Ext.Ajax.request({
    				type: 'rest',
    				url: submitUrl,
    				jsonData: fData,
    				method: 'POST',
    				headers: {
						'Content-Type': 'application/json'
					},
    				success: function(f, action) {
    					var ALcheck = f.responseText.match("_NOT_AVAILABLE_IN_ACADEMY_LOCATION"
    							+"$") == "_NOT_AVAILABLE_IN_ACADEMY_LOCATION";
	    				if(f.responseText==0){
	    					 $this.hideWindowMask();
	    					 showWarningMessage(getCommonTranslation('COURSE_SPECILAIZATION_TITLE_INFO'), getProgramandcourseTranslation('SPECIALIZATION_DUPLICATE_DATA'));
	    				    //showSuccessMessage(getCommonTranslation('COURSE_SPECILAIZATION_TITLE_INFO'), getCommonTranslation('SUCCESS'));
	    					form.reset();
	    					grid.reload();
	    					$this.closeProgramCourseSpecializationFormCancel();
	    				}else if(f.responseText == 'Conflicting Course'){
	    					$this.hideWindowMask();
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_CONFLICT')); 
    					}else if(f.responseText == 'This program can contain only single course'){
    						$this.hideWindowMask();
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PROGRAM_CONTAIN_SINGLE_COURSE')); 
    					}else if(f.responseText == 'NO_MORE_MANDATORY_COURSES_CAN_BE_MAPPED_TO_BATCH'){
    						$this.hideWindowMask();
    						showWarningMessage(getCommonTranslation('ALERT'), 
    								getProgramandcourseTranslation('NO_MORE_MANDATORY_COURSES_CAN_BE_MAPPED_TO_BATCH')); 
    					}else if(f.responseText == 'COURSE_WITH_M_CANT_BE_ADDED'){
    						$this.hideWindowMask();
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_WITH_M_CANT_BE_ADDED_COURSE_GROUP'));
    					}else if(f.responseText == 'COURSE_WITH_G_CANT_BE_ADDED'){
    						$this.hideWindowMask();
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_WITH_G_CANT_BE_ADDED_COURSE_GROUP'));
    					}else if(ALcheck){
	    					 $this.hideWindowMask();
	    					var courseCodeName = f.responseText.split("_")[0];
    						showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('SPECIALIZATION_CONTAINS') + 
    								" course " + " " + courseCodeName + ", " +
    								getProgramandcourseTranslation('WHICH_IS_NOT_AVAILABLE_IN_ACADEMY_LOCATION'));
	    				} else if (f.responseText == 'Course_Group_Associated_Zero_Course'){
	    					$this.hideWindowMask();
    						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('COURSE_GROUP_ASSOCIATED_ZERO_COURSE')); 
    					} else {
	    					 $this.hideWindowMask();
	    					showSuccessMessage(getCommonTranslation('COURSE_SPECILAIZATION_TITLE_INFO'), getCommonTranslation('SUCCESS'));
	    					form.reset();
	    					grid.reload();
	    					$this.closeProgramCourseSpecializationFormCancel();
	    				}
	    				$this.hideWindowMask();
	    			}
    			});
	    },
	    deleteCourseSpecializationData:function(grid){
	    	// var grid= Ext.getCmp('programCourseSpecializationGridId');
	         if (grid.getSelectionModel().getCount() > 0) {
	         var records = grid.getSelectionModel().getSelection()[0];  
	         var id=records.data.id;
	         showConfirmMessage(getCommonTranslation('COURSE_SPECILAIZATION_TITLE_INFO'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				 function(btn, text) {
    			 if (btn == 'yes'){
	        	 Ext.Ajax.request({
	    				type: 'rest',
	    				url: SERVERURL.PROGRAM_BATCH_DETAIL_SPECIALIZATION_DELETE_URL+'?id='+id,
	    				method: 'DELETE',
	    				params:{
	    					id:id
	    				},
	    				headers: {
						'Content-Type': 'application/json'
					    },
	    				success: function(f, action) {
	    					showSuccessMessage(getCommonTranslation('COURSE_SPECILAIZATION_TITLE_INFO'), getCommonTranslation('SUCCESS'));
	    					grid.getStore().reload();
	    				  }
	    			   });
	    			 }
	 			});
	    		}else{
	    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	    		}
	    },
	    editCourseSpecializationWindow:function(grid){
	        var $this=this;
	        var courseSpecialization= Ext.widget('programcoursespecializationformwindow');
	        var courseSpecializationForm=courseSpecialization.items.items[0];
	      //  var grid= Ext.getCmp('programCourseSpecializationGridId');
	        var button= Ext.ComponentQuery.query('button#programCourseSpecializationFormSubmit')[0];
	            button.setText('Edit');
	        var specializationCombo= Ext.ComponentQuery.query('combo#specializationIdItemId')[0];
	        if (grid.getSelectionModel().getCount() > 0) {
	        var records = grid.getSelectionModel().getSelection()[0];  
	         $this.showProgramCourseSpecializationFormWindow();
	         courseSpecializationForm.loadRecord(records);
	              specializationCombo.store.load({
	                    callback: function(rec, operation, success) {
	                        if (success) {
	                        	specializationCombo.setValue(records.data.specializationId);
	                        }
	                    }
	                });
	        	
	    		}else{
	    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	    		}
	         
	    },
	    viewCourseSpecializationData:function(grid){
	    	var $this=this; 
	        Ext.widget('programcoursespecializationformwindow');
	      //  var grid= Ext.getCmp('programCourseSpecializationGridId');
	        var formWindow= Ext.ComponentQuery.query('form#programCourseSpecializationFormWindow')[0];
	       	var form=formWindow.getForm();
	       	 if (grid.getSelectionModel().getCount() > 0) {
	       		$this.editCourseSpecializationWindow(grid);
	       		toggleReadOnlyFormItems(form,true);
	       		$this.getProgramcourseSpecializationformwindow().down('#programCourseSpecializationFormSubmit').setVisible(false);
	       		$this.getProgramcourseSpecializationformwindow().down('#specializationIdItemId').setReadOnly(true);
	       	 } else {
	       		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	       	 }
	    	
	    }
});