/**
 * @Author Akshay Sharma
 */
Ext.define('Academia.controller.program.SpecializationEnollmentController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['enquiry.AcademicBatchStore','common.AssignedProgramStore','program.SpecialiazedPeriodStore','program.SpecializationEnrollmentGridStore',
	         'program.SpecializationListStore','course.coursespecialization.CourseSpecializationCourseGroup',
	         'course.coursespecialization.SpecializationCourseGroupCoursesStore','coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameStudentIdBySmartSearch',
	         'program.SpecializationStore'],
	         models: ['program.SpecializationEnrollmentGridModel','feeandpayment.StudentDetailsByStudentId'],

	         views: ['program.SpecializationEnrollmentStructure','program.StudentSpecialEnrollmentFilter',
	                 'program.StudentSpecialEnrollmentGrid','program.SpecializationDetailsStructure','program.SpecializationList',
	                 'program.SpecializationDetails','course.coursespecialization.CourseSpecializationCourseGroup',
	                 'course.coursespecialization.CourseAssociatedToSpecailizationCourseGroups','course.CourseLinkDetails','course.coursespecialization.CourseSpecializationCourseGroupGrid',
	                 'program.SpecializationChangeWin'],
	                 config: {
	                	 /*
	                	  * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	                	  */
	                	 /**
	                	  * @cfg {Array} PROGRAM_PERMISSIONS array (required)
	                	  * The array of permissions to use for Access control wise enabling and disabling buttons.
	                	  * @accessor
	                	  */
	                	 SPECIALIZATION_ENROLLMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPECIALIZATION_ENROLLMENT')  		  
	                 },	                 

	                 refs: [{
	                	 ref: 'specializationenrollmentstructure',
	                	 selector: 'specializationenrollmentstructure'
	                 },{
	                	 ref: 'studentspecialenrollmentfilter',
	                	 selector: 'studentspecialenrollmentfilter'
	                 },{
	                	 ref: 'studentspecialenrollmentgrid',
	                	 selector: 'studentspecialenrollmentgrid'
	                 },{
	                	 ref: 'specializationdetailsstructure',
	                	 selector: 'specializationdetailsstructure'
	                 },{
	                	 ref: 'specializationlist',
	                	 selector: 'specializationlist'
	                 },{
	                	 ref: 'contentPanel',
	                	 selector: 'contentPanel'
	                 },{
	                	 ref: 'specializationdetails',
	                	 selector: 'specializationdetails'
	                 },{
	                	 ref: 'specializationchangewin',
	                	 selector: 'specializationchangewin'
	                 },{
	                	 ref: 'coursespecializationcoursegroup',
	                	 selector: 'coursespecializationcoursegroup[itemId = "specializationcoursegroupItemId"]'
	                 }],
	                 init: function(application) {
	                	 this.control({
	                		 'studentspecialenrollmentfilter customcombobox[itemId=spclProgramId]': {
	                			 beforerender: function(obj, record) {
	                				 var form = this.getStudentspecialenrollmentfilter();
	                				 var portalId = this.getCurrentLoggedPortalId();
	                				 var facultyId = null;
	                				 if(portalId==2){
	                					 facultyId = this.getCurrentlyLoggedInUser().id;
	                				 }
	                				 var store = form.down("#spclProgramId").getStore();
	                				 store.getProxy().extraParams = {	
	                					 facultyId : facultyId,
	                					 academyLocationIds:this.getCurrentAcademyLocation()
	                				 };
	                				 store.load();

	                			 },
	                			 select: function(obj, record) {
	                				 var this$ = this;
	                				 var programId = record[0].get("id");
	                				 var portalId = this.getCurrentLoggedPortalId();
	                				 var facultyId = null;
	                				 var form = this.getStudentspecialenrollmentfilter();
	                				 var batchCombo = form.down("#spclBatchId");
                					 batchCombo.reset();
                					 var periodCombo = form.down("#spclPeriodId");
									 periodCombo.reset();
	                				 if(portalId==2){
	                					 facultyId = this.getCurrentlyLoggedInUser().id;
	                				 }
	                				 if(programId > 0){
	                					 batchCombo.setDisabled(false);
	                					 var store = this$.getStore('enquiry.AcademicBatchStore');
	                					 store.getProxy().extraParams = {
	                						 id: programId,
	                						 isActive:true
	                					 };
	                					 store.load({
	                						 callback: function(records, operation, success) {
	                							 if (success) {
	                								 if(records.length==1){
	                									 form.down("#spclBatchId").setValue(records[0].get('id'));
	                									 periodCombo.setDisabled(false);
	                									 var store = this$.getStore('program.SpecialiazedPeriodStore');
	                									 var batchId=records[0].get('id');
	                									 store.getProxy().extraParams = {
	                										 batchId: records[0].get('id')
	                									 };
	                									 store.load({
	                										 callback: function(records, operation, success) {
	                											 if (success) {
	                												 if(records.length==1){
	                													 form.down("#spclPeriodId").setValue(records[0].get('id'));
	                													 var specialization=form.down("#specializationId");
	                													 specialization.setDisabled(false);
	                													 var specializationStore=specialization.getStore();
	                													 specializationStore.getProxy().extraParams = {
	                														 batchId: batchId,
	            	                									 };
	                													 specializationStore.load();
	                													 form.down("#statusId").setDisabled(false);
	                													 var studentNameSearch=form.down("#studentNameSearchId");
	                													 studentNameSearch.setDisabled(false);
	                													 var studentNameSearchStore = studentNameSearch.getStore();
	                													 studentNameSearchStore.getProxy().extraParams = {
	            	                										 periodId: records[0].get('id'),
	            	                										 restrictToAL:true
	            	                									 };
	                													 studentNameSearchStore.load();
	                												 }else{
	                													 form.down("#specializationId").setDisabled(true);
	            	                									 form.down("#statusId").setDisabled(true);
	            	                									 form.down("#studentNameSearchId").setDisabled(true);
	                												 }
	                											 }
	                										 }
	                									 });
	                								 }
	                								 else{
	                									 form.isValid();
	                								 }
	                							 }
	                						 }
	                					 });
	                				 }
	                			 }
	                		 },
	                		 'studentspecialenrollmentfilter customcombobox[itemId=spclBatchId]': {
	                			 select: function(obj, record) {
	                				 var this$ = this;
	                				 var batchId = record[0].get("id");
	                				 var form = this.getStudentspecialenrollmentfilter();
	                				 if(batchId > 0){
	                					 form.down("#spclPeriodId").setDisabled(false);
	                					 var periodStore = form.down("#spclPeriodId").getStore();
	                					 periodStore.getProxy().extraParams = {
	                						 batchId: record[0].get('id')
	                					 };
	                					 periodStore.load({
	                						 callback: function(records, operation, success) {
	                							 if (success) {
	                								 if(records.length==1){
	                									 form.down("#spclPeriodId").setValue(records[0].get('id'));
	                									 var specialization=form.down("#specializationId");
    													 specialization.setDisabled(false);
    													 var specializationStore=specialization.getStore();
    													 specializationStore.getProxy().extraParams = {
    														 batchId: batchId,
	                									 };
    													 specializationStore.load();
    													 form.down("#statusId").setDisabled(false);
    													 var studentNameSearch=form.down("#studentNameSearchId");
    													 studentNameSearch.setDisabled(false);
    													 var studentNameSearchStore = studentNameSearch.getStore();
    													 studentNameSearchStore.getProxy().extraParams = {
	                										 periodId: records[0].get('id'),
	                										 restrictToAL:true
	                									 };
    													 studentNameSearchStore.load();
	                								 }else{
	                									 form.down("#specializationId").setDisabled(true);
	                									 form.down("#statusId").setDisabled(true);
	                									 form.down("#studentNameSearchId").setDisabled(true);
	                								 }
	                							 }
	                						 }
	                					 });
	                				 }
									 form.isValid();
	                			 }
	                		 },
	                		 'studentspecialenrollmentfilter customcombobox[itemId=spclPeriodId]': {
	                			 select: function(obj, record) {
	                				 var this$ = this;
	                				 var periodId = record[0].get("id");
	                				 if(periodId > 0){
	                				 var form = this.getStudentspecialenrollmentfilter();
	                				 var batchId=form.down("#studentNameSearchId").getValue();
	                				 var specialization=form.down("#specializationId");
									 specialization.setDisabled(false);
									 var specializationStore=specialization.getStore();
									 specializationStore.getProxy().extraParams = {
										 batchId: batchId,
									 };
									 specializationStore.load();
									 form.down("#statusId").setDisabled(false);
									 var studentNameSearch=form.down("#studentNameSearchId");
									 studentNameSearch.setDisabled(false);
									 var studentNameSearchStore = studentNameSearch.getStore();
									 studentNameSearchStore.getProxy().extraParams = {
										 periodId: periodId,
										 restrictToAL:true
									 };
									 studentNameSearchStore.load();
	                				 }
	                			 }
	                		 },
	                		 'studentspecialenrollmentfilter button[itemId=spclSearchBtn]':{
	                			 click: function() {
	                				 var $this = this;
	                				 $this.loadSpecializedStudentGrid()
	                			 }
	                		 },
	                		 'studentspecialenrollmentfilter button[itemId=spclResetBtn]':{
	                			 click: function(obj,record) {
	                				 var this$ = this;
	                				 var form = this$.getStudentspecialenrollmentfilter();
	                				 form.getForm().reset();
	                				 form.down('#spclBatchId').setDisabled(true);
	                				 form.down('#spclPeriodId').setDisabled(true);
	                				 form.down('#specializationId').setDisabled(true);
	                				 form.down('#statusId').setDisabled(true);
	                				 form.down('#studentNameSearchId').setDisabled(true);
	                			 }
	                		 },
	                		 'studentspecialenrollmentgrid button[itemId=enrollSpecializationBtn]':{
	                			 click: function() {
	                				 var $this = this;
	                				 $this.openSpecializationScreen()
	                			 }
	                		 },
							/*'studentspecialenrollmentfilter' :{
	                			 afterrender : function(){
	                				 var me = this;
									 var form = me.getStudentspecialenrollmentfilter().getForm();
	                	 			 var batchValue = form.findField('spclBatch');
									 batchValue.getStore().load();
							}},*/
	                		 'specializationdetails' :{
	                			 afterrender : function(){
	                				 var this$ = this;
	                				 var form = this$.getSpecializationdetails();
	                				 var spclGrid = this$.getSpecializationlist();
	                				 if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
	                					 spclGrid.columns[4].setVisible(true);
	                					 var studentId =  this$.getCurrentlyLoggedInUserInfoForPortal().student.id;
	                					 var admissionId = this$.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
	                					 var studentProgramStore = this$.getStore('feeandpayment.StudentDetailsByStudentId');
	                					 var submitURL=SERVERURL.PLACEMENT_PROGRAM_STORE;
	                					 studentProgramStore.getProxy().api.read=submitURL;
	                					 studentProgramStore.getProxy().extraParams = {
	                						 studentId: studentId,
	                						 admissionId : admissionId,
	                						 onlyCurrentRecords : true
	                					 };
	                					 studentProgramStore.load({
	                						 callback: function(records, operation, success) {
	                							 if (success) {
	                								 var studentDetails = Ext.JSON.decode(operation.response.responseText);
	                								 form.down('#programName').setValue(studentDetails[0].programCode+" / "+studentDetails[0].programName);
	                								 form.down('#batchName').setValue(studentDetails[0].batchName);
	                								 form.down('#periodIdItemId').setValue(studentDetails[0].periodName);
	                								 var specialGridStore = this$.getSpecializationlist().getStore();
	                								 specialGridStore.getProxy().extraParams = {
	                									 batchId:studentDetails[0].batchId,
 									  					 studentId: studentId,
				                						 admissionId : admissionId,
														 periodId:studentDetails[0].periodId,
	                								 };
	                								 specialGridStore.load({
	                									 callback: function(records, operation, success) {
	                										 if (success) {
	                											 var store = this$.getStore('program.SpecializationEnrollmentGridStore');
	                											 store.getProxy().extraParams = {
	                												 periodId:studentDetails[0].periodId,
	                												 admissionId : admissionId,
	                												 studentId: studentId
	                											 };
	                											 store.load({
	                												 callback: function(records, operation, success) {
	                													 if (success) {
	                														 if(!isNullOrEmpty(records[0].data.status)){
	                															 var specializationModel = specialGridStore.getRange();
	                															 if(!isNullOrEmpty(records[0].data.specializationCode)){
	                																 for(var i=0;i<specializationModel.length;i++){
	                																	 if(specializationModel[i].data.specializationCode == records[0].data.specializationCode){
	                																		 if(records[0].data.status == "Approved"){
	                																			 this$.getSpecializationdetailsstructure().down('#submitSpecializationBtn').setVisible(false);
	                																			 specializationModel[i].set("status",records[0].data.status);
	                																		 }else if(records[0].data.status == "Auto-Approved"){
	                																			 specializationModel[i].set("status",records[0].data.status);
	                																			 this$.getSpecializationdetailsstructure().down('#submitSpecializationBtn').setVisible(false);
	                																		 }
	                																		 else{
	                																			 specializationModel[i].set("status","Requested");
	                																		 }
	                																	 }
	                																 }
	                															 }
	                														 }
	                													 }
	                												 }
	                											 });
	                										 }
	                									 }
	                								 });
	                							 }
	                						 }
	                					 });
	                				 }else
	                				 {
	                					 var grid = this$.getStudentspecialenrollmentgrid();
	                					 var specialTemp = this$.getStudentspecialenrollmentgrid().temp;
	                					 form.down('#programName').setValue(specialTemp[0].programCode+" / "+specialTemp[0].programName);
	                					 form.down('#batchName').setValue(specialTemp[0].batchValue);
	                					 form.down('#periodIdItemId').setValue(specialTemp[0].periodValue);
	                					 var specialGridStore = this$.getSpecializationlist().getStore();
	                					 specialGridStore.getProxy().extraParams = {
	                						 batchId:specialTemp[0].batchId
	                					 };
	                					 specialGridStore.load();
	                				 }
	                			 }
	                		 },
	                		 'specializationlist':{
	                			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                				 var $this=this;
	                				 var specialTemp = null;
	                				 var grid = $this.getSpecializationlist();
	                				 if($this.getCurrentLoggedPortalId() == 3 || $this.getCurrentLoggedPortalId() == 7){
	                					 var studentId =  $this.getCurrentlyLoggedInUserInfoForPortal().student.id;
	                					 var admissionId = $this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
	                					 var studentProgramStore = $this.getStore('feeandpayment.StudentDetailsByStudentId');
	                					 var submitURL=SERVERURL.PLACEMENT_PROGRAM_STORE;
	                					 studentProgramStore.getProxy().api.read=submitURL;
	                					 studentProgramStore.getProxy().extraParams = {
	                						 studentId: studentId,
	                						 admissionId : admissionId,
	                						 onlyCurrentRecords : true
	                					 };
	                					 studentProgramStore.load({
	                						 callback: function(records, operation, success) {
	                							 if (success) {
	                								 specialTemp = Ext.JSON.decode(operation.response.responseText);
	                								 var columnName=grid.columnManager.columns[cellIndex].dataIndex;
	                								 if(columnName=='noOfAssociatedCourseGroups' &&  record.data.noOfAssociatedCourseGroups > 0){ // checked

	                									 var store=$this.getStore('course.coursespecialization.CourseSpecializationCourseGroup');
	                									 var submitURL=SERVERURL.FIND_ASSOCIATED_SPECIALIZED_COURSE_GROUP;
	                									 store.getProxy().api.read=submitURL;
	                									 store.getProxy().extraParams = {
	                										 specializationId: record.data.specializationId
	                									 };
	                									 store.load();
	                									 var formWindow = $this.getCoursespecializationcoursegroup();
	                									 if (!formWindow) {
	                										 formWindow = Ext.widget('coursespecializationcoursegroup',{
	                											 itemId:'specializationcoursegroupItemId'
	                										 });
	                									 }
	                									 formWindow.setTitle(getProgramandcourseTranslation('COURSE_GROUP_ASSOCIATED'));
	                									 formWindow.down('#courseGroup').setValue(record.data.specializationName);
	                									 formWindow.show();
	                									 var courseGroupGrid = formWindow.down('#coursespecializationcoursegroupgrid');
	                									 courseGroupGrid.setVisible(true);
	                									 var courseGroupCoursesGrid = formWindow.down('#courseassociatedtospecailizationcoursegroups');
	                									 courseGroupCoursesGrid.setVisible(false);
	                								 }
	                								 if(columnName == 'noofAssociatedCourses' &&  record.data.noofAssociatedCourses > 0){ // checked

	                									 var store = $this.getStore('course.coursespecialization.SpecializationCourseGroupCoursesStore');
//	                									 var submitURL = SERVERURL.PATH_FIND_ALL_ASSIGN_COURSES_BY_COURSE_GROUPS;
//	                									 store.getProxy().api.read = submitURL;
	                									 var courseGrpIds = record.data.courseGroupIds;
	                									 var courseGroups=[];
	                									 var courseGroupsIds;
	                									 if(courseGrpIds != undefined && courseGrpIds.length > 0){
	                										 for(var i in courseGrpIds){
	                											 courseGroups.push(courseGrpIds[i]);
	                										 }
	                										 courseGroupsIds = courseGroups.join();
	                									 }
	                									 store.getProxy().extraParams = {
	                										 courseGroupIds : courseGroupsIds,
	                										 batchId : specialTemp[0].batchId
	                									 };
														 $this.resetPageSetting(store);
	                									 store.load();
	                									 var formWindow = $this.getCoursespecializationcoursegroup();
	                									 if (!formWindow) {
	                										 formWindow = Ext.widget('coursespecializationcoursegroup',{
	                											 itemId:'specializationcoursegroupItemId'
	                										 });
	                									 }
	                									 formWindow.setTitle(getProgramandcourseTranslation('COURSES_ASSOCIATED'));
	                									 formWindow.down('#courseGroup').setValue(record.data.specializationName);
	                									 formWindow.show();
	                									 var courseGroupGrid = formWindow.down('#coursespecializationcoursegroupgrid');
	                									 courseGroupGrid.setVisible(false);
	                									 var courseGroupCoursesGrid = formWindow.down('#courseassociatedtospecailizationcoursegroups');
	                									 courseGroupCoursesGrid.setVisible(true);
	                									 courseGroupCoursesGrid.columns[2].setVisible(false);
	                								 }
	                							 }
	                						 }
	                					 });
	                				 }else{
	                					 specialTemp  = $this.getStudentspecialenrollmentgrid().temp;
	                					 var columnName=grid.columnManager.columns[cellIndex].dataIndex;
	                					 if(columnName=='noOfAssociatedCourseGroups' &&  record.data.noOfAssociatedCourseGroups > 0){ // checked

	                						 var store=$this.getStore('course.coursespecialization.CourseSpecializationCourseGroup');
	                						 var submitURL=SERVERURL.FIND_ASSOCIATED_SPECIALIZED_COURSE_GROUP;
	                						 store.getProxy().api.read=submitURL;
	                						 store.getProxy().extraParams = {
	                							 specializationId: record.data.specializationId
	                						 };
	                						 store.load();
	                						 var formWindow = this.getCoursespecializationcoursegroup();
	                						 if (!formWindow) {
	                							 formWindow = Ext.widget('coursespecializationcoursegroup',{
	                								 itemId:'specializationcoursegroupItemId'
	                							 });
	                						 }
	                						 formWindow.setTitle(getProgramandcourseTranslation('COURSE_GROUP_ASSOCIATED'));
	                						 formWindow.down('#courseGroup').setValue(record.data.specializationName);
	                						 formWindow.show();
	                				 
        									 var courseGroupGrid = formWindow.down('#coursespecializationcoursegroupgrid');
        									 courseGroupGrid.setVisible(true);
        									 var courseGroupCoursesGrid = formWindow.down('#courseassociatedtospecailizationcoursegroups');
        									 courseGroupCoursesGrid.setVisible(false);
	                						 /*var courseGroupGrid = formWindow.down('grid');
	                						 courseGroupGrid.columns[3].setVisible(false);
	                						 courseGroupGrid.columns[4].setVisible(false);
	                						 courseGroupGrid.columns[5].setVisible(false);
	                						 courseGroupGrid.columns[6].setVisible(false);*/
	                					 }
	                					 if(columnName=='noofAssociatedCourses' &&  record.data.noofAssociatedCourses > 0){ // checked

	                						 var store=$this.getStore('course.coursespecialization.SpecializationCourseGroupCoursesStore');
//	                						 var submitURL=SERVERURL.PATH_FIND_ALL_ASSIGN_COURSES_BY_COURSE_GROUPS;
//	                						 store.getProxy().api.read=submitURL;
	                						 var courseGrpIds = record.data.courseGroupIds;
	                						 var courseGroups=[];
	                						 var courseGroupsIds;
	                						 if(courseGrpIds !=undefined && courseGrpIds.length > 0){
	                							 for(var i in courseGrpIds){
	                								 courseGroups.push(courseGrpIds[i]);
	                							 }
	                							 courseGroupsIds = courseGroups.join();
	                						 }
	                						 store.getProxy().extraParams = {
	                							 courseGroupIds : courseGroupsIds,
	                							 batchId : specialTemp[0].batchId
	                						 };
											 $this.resetPageSetting(store);
	                						 store.load();
	                						 var formWindow = $this.getCoursespecializationcoursegroup();
	                						 if (!formWindow) {
	                							 formWindow = Ext.widget('coursespecializationcoursegroup',{
	                								 itemId:'specializationcoursegroupItemId'
	                							 });
	                						 }
	                						 formWindow.setTitle(getProgramandcourseTranslation('COURSES_ASSOCIATED'));
	                						 formWindow.down('#courseGroup').setValue(record.data.specializationName);
	                						 formWindow.show();
        									 var courseGroupGrid = formWindow.down('#coursespecializationcoursegroupgrid');
        									 courseGroupGrid.setVisible(false);
        									 var courseGroupCoursesGrid = formWindow.down('#courseassociatedtospecailizationcoursegroups');
        									 courseGroupCoursesGrid.setVisible(true);
        									 courseGroupCoursesGrid.columns[2].setVisible(false);
	                					 }
	                				 }
	                			 }

	                		 },
	                		 'specializationdetailsstructure button[itemId=submitSpecializationBtn]':{
	                			 click: function() {
	                				 var $this = this;
	                				 $this.saveStudentSpecialization();
	                			 }
	                		 },
	                		 'studentspecialenrollmentgrid button[itemId=spclApproveBtn]':{
	                			 click: function() {
	                				 var $this = this;
	                				 $this.updateStautsStudentSpecialization();
	                			 }
	                		 },
	                		 'studentspecialenrollmentgrid button[itemId=spclChangeBtn]':{
	                			 click:this.showSpclChangeFormWindow 
	                		 },
	                		 'studentspecialenrollmentgrid' :{
								 cellclick: this.cellClickSpecializationEnrollmentGrid,
	                			 beforerender:function(){
	                				 this.getStore('program.SpecializationEnrollmentGridStore').removeAll();
	                			 },
	                			 render:function(grid){
	                				 var permissionsMap=this.getSPECIALIZATION_ENROLLMENT_PERMISSIONS()
	                				 this.addDataGridConfigButton(grid,this.getSPECIALIZATION_ENROLLMENT_PERMISSIONS());
	                				 var associatedAcadLocationIds = new Array();
	                            	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	                            	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                            	 var spclChangeBtn = grid.down('#spclChangeBtn');
	                            	 var enrollSpecializationBtn = grid.down('#enrollSpecializationBtn');
	                            	 var spclApproveBtn = grid.down('#spclApproveBtn');
	                            	 spclChangeBtn.setVisible(false);
	                            	 enrollSpecializationBtn.setVisible(false);
	                            	 spclApproveBtn.setVisible(false);
	                            	 if(Ext.Array.contains(permissionList, 'CHANGE_SPECIALIZATION')){
	                            		 spclChangeBtn.setVisible(true);
	                            	 }
	                            	 if(Ext.Array.contains(permissionList, 'ENROLL_SPECIALIZATION')){
	                            		 enrollSpecializationBtn.setVisible(true);
	                            	 }
	                            	 if(Ext.Array.contains(permissionList, 'APPROVE')){
	                            		 spclApproveBtn.setVisible(true);
	                            	 }
	                			 },
	                			 selectionchange:function(view, record){
	                				 var grid = this.getStudentspecialenrollmentgrid();
	                				 var approveBtn =grid.down('#spclApproveBtn');
	                				 if (record.length > 0) {
	                					 var allPending = Ext.Array.every(record, function (rec) {
	                						 return rec.get('status') == 'Pending';
	                					 });

	                					 if (allPending) {
	                						 approveBtn.enable();
	                						 approveBtn.setTooltip(getProgramandcourseTranslation('APPROVE'));
	                					 } else {
	                						 approveBtn.disable();
	                						 approveBtn.setTooltip(getProgramandcourseTranslation('APPROV_BTN_TOOLTIP'));
	                					 }
	                				 } else {
	                					 approveBtn.disable();
	                					 approveBtn.setTooltip(getProgramandcourseTranslation('APPROVE'));
	                				 }
	                			 }
	                		 },
	                		 'specializationchangewin button[itemId=specializationSaveBtn]':{
	                			 click: function() {
	                				 var $this = this;
	                				 $this.updateStudentSpecialization();
	                			 }
	                		 },
	                		 'specializationchangewin button[itemId=specializationCancelBtn]':{
	                			 click: function() {
	                				 var $this = this;
	                				 var frmWin = $this.getSpecializationchangewin();
	                				 frmWin.close();
	                			 }
	                		 }
	                	 });
	                 },
	                 loadSpecializedStudentGrid:function(){
	                	 var this$ = this;
	                	 var form = this$.getStudentspecialenrollmentfilter();
	                	 var periodId = form.down('#spclPeriodId').getValue();
	                	 var specializationId = form.down('#specializationId').getValue();
	                	 var status = form.down('#statusId').getValue();
	                	 var studentId = form.down('#studentNameSearchId').getValue();
	                	 var grid = this$.getStudentspecialenrollmentgrid();
	                	 var store = grid.getStore();
	                	 store.getProxy().extraParams = {
	                		 periodId:periodId,
	                		 specializationId:specializationId,
	                		 status:status,
	                		 studentId:studentId
	                	 };
	                	 this.resetPageSetting(store);
	                	 store.load();
	                	 grid.getSelectionModel().deselectAll();
	                	 grid.config.searchFilterForm = form;
	                 },
	                 openSpecializationScreen:function(){
	                	 var this$ = this;
	                	 var form = this$.getStudentspecialenrollmentfilter().getForm();
	                	 var programValue = form.findField('spclProgram').getRawValue();
	                	 var batchValue = form.findField('spclBatch').getRawValue();
	                	 var periodValue = form.findField('spclPeriod').getRawValue();
	                	 var grid = this$.getStudentspecialenrollmentgrid();
	                	 grid.temp = [];
	                	 if(grid.temp.length > 0){
	                		 grid.temp.pop();
	                	 }
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var selectedRecord = grid.getSelectionModel().getSelection();
	                		 var admissionIds = new Array();
	                		 for(var i = 0;i < selectedRecord.length;i++){
	                			 if(selectedRecord[i].data.status != 'Approved') {
	                				 admissionIds.push(selectedRecord[i].data.admissionId);
	                			 }
	                		 }
	                		 if(admissionIds.length > 0 ) {
	                			 grid.temp.push({
	                				 programId : form.getValues().spclProgram,
	                				 batchId : form.getValues().spclBatch,
	                				 periodId : form.getValues().spclPeriod,
	                				 programName : programValue,
	                				 batchValue : batchValue,
	                				 periodValue : periodValue,
	                				 admissionIds : admissionIds
	                			 })
	                			 var contentPanel = grid.up().up(); //get hold of the content panel where we are adding all the tabs
	                			 var structure = Ext.widget('specializationdetailsstructure');
	                			 var tabName = getProgramandcourseTranslation('SPECIALIZATION_LIST');
	                			 /**
	                			  * This is to remove tab from content panel and open same tab again
	                			  */
	                			 var getcontroller=this.getController('menu.CoreERPNavigationController');
	                			 var getTab=getcontroller.getTab(tabName);
	                			 if(getTab!=null){
	                				 contentPanel.remove(getTab, true);
	                			 }
	                			 openTab(contentPanel, tabName, structure);
	                		 } else  {
	                			 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ENROLL_SPECIAL_ALERT'));
	                		 }
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('STUDENT_LIST'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
	                	 }
	                 },
	                 saveStudentSpecialization : function(){
	                	 var $this = this;
	                	 var grid = $this.getSpecializationlist();
	                	 var specializationdetailsstructure = this.getSpecializationdetailsstructure();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                		 specializationdetailsstructure.down('#submitSpecializationBtn').setDisabled(true);
	                		 if($this.getCurrentLoggedPortalId() == 3 || $this.getCurrentLoggedPortalId() == 7){
	                			 var modelList = [];
	                			 var admissionId = $this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
	                			 var studentId =  $this.getCurrentlyLoggedInUserInfoForPortal().student.id;
								 var batchId =$this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].batch.id;
	                			 var store = $this.getStore('program.SpecializationEnrollmentGridStore');
	                			 store.getProxy().extraParams = {
	                				 admissionId : admissionId,
	                				 studentId : studentId
	                			 };
	                			 store.load({
	                				 callback: function(records, operation, success) {
	                					 if (success) {
	                						 var csModel = new Academia.model.program.SpecializationEnrollmentGridModel();
	                						 var record = $this.getSpecializationlist().getSelectionModel().getSelection();
	                						 delete csModel.data.admissionIds;
	                						 delete csModel.data.specialCode;
	                						 delete csModel.data.studentCode;
	                						 delete csModel.data.studentId;
	                						 delete csModel.data.studentName;
	                						 delete csModel.data.admissionCode;
	                						 csModel.set("programBatchSpecialId",record[0].data.id);
	                						 csModel.set("admissionId",admissionId);
	                						 csModel.set("courseGroupIds",record[0].data.courseGroupIds);
												var validation =true;
												if(records[0].data.id !=null){
													if(records.length>1){
													   for (var i = 0; i < records.length; i++) {
															if(records[i].data.programBatchSpecialId == record[0].data.id){
																validation = false;
																showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("YOU_ALREADY_HAVE_SPECIALIZATION_ENROLLMENT_REQUEST"));
															}     
												        }
													}else{
														if(records[0].data.programBatchSpecialId == record[0].data.id){
																validation = false;
																showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("YOU_ALREADY_HAVE_SPECIALIZATION_ENROLLMENT_REQUEST"));
															}
													}
												}
	                						 if(record[0].data.status !=null){
	                							 csModel.set("status","Pending");
	                							 csModel.set("autoApprove",false);
	                						 }else if(!isNullOrEmpty(record[0].data.autoApprove) && record[0].data.autoApprove){
												 csModel.set("status","Auto-Approved");
												 csModel.set("autoApprove",record[0].data.autoApprove);
											 }else{
	                							 delete csModel.data.status;
	                							 csModel.set("autoApprove",false);
	                						 }
	                						 modelList.push(csModel.data);
	                						 submitUrl = SERVERURL.STUDENT_SPECIALIZATION_ENROLLMENT_SAVE;
											if(validation){
	                						 Ext.Ajax.request({
	                							 type: 'rest',
	                							 url: submitUrl,
	                							 jsonData: modelList,
	                							 method: 'POST',
	                							 success: function(form, action) {
	                								 Ext.getBody().unmask();
	                								 var studentGrid = $this.getSpecializationlist();
													 var gridSore = studentGrid.getStore();
													 gridSore.getProxy().extraParams = {
	                		 									 admissionId : admissionId,
	                											 studentId:studentId, batchId: batchId
	                	 								};
	                								 specializationdetailsstructure.down('#submitSpecializationBtn').setDisabled(false);
													
	                								 gridSore.reload();
	                								 studentGrid.getSelectionModel().deselectAll(true);
	                								 var msg = form.responseText;
	                								 if(msg == "Success"){
	                									 showSuccessMessage(getProgramandcourseTranslation('SPECIALIZATION_LIST'), getCommonTranslation('SUCCESS'));
	                								 }else if(msg == "YOUALREADYHAVESPECIALIZATIONENROLLMENTREQUEST"){
                                                      	showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("YOU_ALREADY_HAVE_SPECIALIZATION_ENROLLMENT_REQUEST"));
	                								 }else if(msg == "ENROLLEDINSPECIALIZATIONCOURSES"){
	                									 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("ENROLLED_IN_SPECIALIZATION_COURSES"));
	                								 }else if(msg == "STUDENTSENROLLEDINSPECIALIZATIONCOURSES"){
	                									 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("STUDENTS_ENROLLED_IN_SPECIALIZATION_COURSES"));
	                								 }
	                							 }
	                						 });
											}else{ Ext.getBody().unmask();}
	                					 }
	                				 }

	                			 });

	                		 }else{
	                			 var studentGrid = $this.getStudentspecialenrollmentgrid();
	                			 var studentRecord = $this.getStudentspecialenrollmentgrid().getSelectionModel().getSelection();
	                			 var modelList = [];
	                			 var n = 0;
	                			 for(var i=0;i<studentGrid.getSelectionModel().getCount();i++){
	                				 if(studentRecord[i].data.status != 'Approved') {
	                					 n++;
	                					 var csModel = new Academia.model.program.SpecializationEnrollmentGridModel();
		                				 var record = $this.getSpecializationlist().getSelectionModel().getSelection();
		                				 delete csModel.data.admissionIds;
		                				 delete csModel.data.specialCode;
		                				 delete csModel.data.studentCode;
		                				 delete csModel.data.studentId;
		                				 delete csModel.data.studentName;
		                				 delete csModel.data.status;
		                				 delete csModel.data.admissionCode;
		                				 csModel.set("programBatchSpecialId",record[0].data.id);
		                				 csModel.set("admissionId",studentRecord[i].data.admissionId);
		                				 csModel.set("id",studentRecord[i].data.id);
		                				 csModel.set("courseGroupIds",record[0].data.courseGroupIds);
		                				 modelList.push(csModel.data);
	                				 }
	                			 }
	                			 submitUrl = SERVERURL.STUDENT_SPECIALIZATION_ENROLLMENT_SAVE;
	                			 Ext.Ajax.request({
	                				 type: 'rest',
	                				 url: submitUrl,
	                				 jsonData: modelList,
	                				 method: 'POST',
	                				 success: function(form, action) {
	                					 var contentPanel = $this.getSpecializationdetailsstructure().up().up(); //get hold of the content panel where we are adding all the tabs
	                					 /**
	                					  * This is to remove tab from content panel and open same tab again
	                					  */
	                					 Ext.getBody().unmask();
	                					 specializationdetailsstructure.down('#submitSpecializationBtn').setDisabled(false);
	                					 contentPanel.getActiveTab().close();
	                					 var studentGrid = $this.getStudentspecialenrollmentgrid();
	                					 $this.resetPageSetting(studentGrid.getStore());
	                					 studentGrid.getStore().reload();
	                					 studentGrid.getSelectionModel().deselectAll(true);
	                					 var msg = form.responseText;
	                					 if(msg == "Success"){
	                						 showSuccessMessage(getProgramandcourseTranslation('SPECIALIZATION_LIST'), getProgramandcourseTranslation('ENROLL_SPECIAL_SUCCESS'));
	                					 }else if(msg == "YOUALREADYHAVESPECIALIZATIONENROLLMENTREQUEST"){
                                             showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("YOU_ALREADY_HAVE_SPECIALIZATION_ENROLLMENT_REQUEST"));
                                         }else if(msg == "ENROLLEDINSPECIALIZATIONCOURSES"){
        									 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("ENROLLED_IN_SPECIALIZATION_COURSES"));
        								 }else if(msg == "STUDENTSENROLLEDINSPECIALIZATIONCOURSES"){
        									 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("STUDENTS_ENROLLED_IN_SPECIALIZATION_COURSES"));
        								 }
	                				 }
	                			 });
	                		 }
	                	 }else{
	                		 showWarningMessage(getProgramandcourseTranslation('SPECIALIZATION_LIST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	 }
	                 },
	                 updateStautsStudentSpecialization : function(){
	                	 var $this = this;
	                	 var studentGrid = $this.getStudentspecialenrollmentgrid();
	                	 var modelList = [];
	                	 if (studentGrid.getSelectionModel().getCount() > 0) {
	                		 var n = 0;
	                		 for(var i=0;i<studentGrid.getSelectionModel().getCount();i++){
	                			 var record = studentGrid.getSelectionModel().getSelection();
	                			 if(record[i].data.status == 'Pending') {
	                				 n++;
	                				 var csModel = new Academia.model.program.SpecializationEnrollmentGridModel();
	                				 delete csModel.data.admissionIds;
	                				 delete csModel.data.specialCode;
	                				 delete csModel.data.studentCode;
	                				 delete csModel.data.studentId;
	                				 delete csModel.data.studentName;
	                				 delete csModel.data.admissionCode;
	                				 csModel.set("id",record[i].data.id);
	                				 csModel.set("admissionId",record[i].data.admissionId);
	                				 csModel.set("programBatchSpecialId",record[i].data.programBatchSpecialId);
	                				 csModel.set("courseGroupIds",record[i].data.courseGroupIds);
	                				 if(record[i].data.status !=null){
	                					 csModel.set("status","Approved");
	                				 }
	                				 modelList.push(csModel.data);
	                			 }
	                		 }
	                		 if(n > 0) {
	                			 submitUrl = SERVERURL.STUDENT_SPECIALIZATION_ENROLLMENT_SAVE;
	                			 Ext.Ajax.request({
	                				 type: 'rest',
	                				 url: submitUrl,
	                				 jsonData: modelList,
	                				 method: 'POST',
	                				 success: function(form, action) {
	                					 var studentGrid = $this.getStudentspecialenrollmentgrid();
	                					 $this.resetPageSetting(studentGrid.getStore());
	                					 studentGrid.getStore().reload();
	                					 studentGrid.getSelectionModel().deselectAll(true);
	                					 var msg = form.responseText;
	                					 if(msg == "Success"){
	                						 showSuccessMessage(getCommonTranslation('STUDENT_LIST'), getProgramandcourseTranslation('SPECIAL_FOR')+" "+getProgramandcourseTranslation('APPROVE_SPECIAL_SUCCESS'));
	                					 }else if(msg == "ENROLLEDINSPECIALIZATIONCOURSES"){
        									 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("ENROLLED_IN_SPECIALIZATION_COURSES"));
        								 }else if(msg == "STUDENTSENROLLEDINSPECIALIZATIONCOURSES"){
        									 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("STUDENTS_ENROLLED_IN_SPECIALIZATION_COURSES"));
        								 }
	                				 }
	                			 });
	                		 } else {
								 if(record[0].data.status == 'Approved'){  
									 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("STUDENT_SPECIALIZATION_ALREADY_APPROVED_MSG"));
								 }
								 else{
									 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation("STILL_NOT_ENROLLEND_IN_ANY_SPECIALIZATION"));
								 }
	                			 
	                		 }
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('STUDENT_LIST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	 }
	                 },
	                 showSpclChangeFormWindow:function(){
	                	 var $this = this;
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var whetherSchool = alinfomodel.get('wheatherSchool');
	                	 var form = $this.getStudentspecialenrollmentfilter().getForm();
	                	 var programValue = form.findField('spclProgram').getRawValue();
	                	 var batchValue = form.findField('spclBatch').getRawValue();
	                	 var periodValue = form.findField('spclPeriod').getRawValue();
	                	 var batchId=form.findField("spclBatch").getValue();
	                	 var grid = $this.getStudentspecialenrollmentgrid();
	                	 if (grid.getSelectionModel().getCount() > 0) {
	                		 var frmWin = this.getSpecializationchangewin();
	                		 if (!frmWin) {
	                			 Ext.widget('specializationchangewin');
	                			 frmWin = this.getSpecializationchangewin();
	                		 }
	                		 var selectedRecord = grid.getSelectionModel().getSelection();
	                		 var admissionIds = new Array();
	                		 for(var i = 0;i < selectedRecord.length;i++){
	                			 if(selectedRecord[i].data.status == 'Approved' || selectedRecord[i].data.status == 'Auto-Approved') {
	                				 admissionIds.push(selectedRecord[i].data.admissionId);
	                			 }
	                		 }
	                		 if(admissionIds.length > 0 ) {
	                			 frmWin.down('#programNameId').setValue(programValue);
	                			 frmWin.down('#batchNameId').setValue(batchValue);
	                			 frmWin.down('#periodNameId').setValue(periodValue);
	                			 frmWin.down('#studentBatchId').setValue(batchId);
	                			 frmWin.down('#studentCountItemId').setValue(grid.getSelectionModel().getCount());
	                			 var specialization=frmWin.down("#specializationId");
	                			 var specializationStore=specialization.getStore();
	                			 specializationStore.getProxy().extraParams = {
	                				 batchId: batchId
	                			 };
	                			 specializationStore.load();
	                			 frmWin.show();
	                		 } else {
	                			 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('CHANGE_SPECIAL_ALERT'));
	                		 }
	                	 }else{
	                		 showWarningMessage(getCommonTranslation('STUDENT_LIST'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
	                	 }
	                 },
	                 updateStudentSpecialization : function() {
	                	 var $this = this;
	                	 var frmWin = $this.getSpecializationchangewin();
	                	 var grid = $this.getContentPanel().getActiveTab().down('grid');
	                	 var gridRecord = grid.getSelectionModel().getSelection();
	                	 var batchId = frmWin.down('#studentBatchId').getValue();
	                	 var specializationId = frmWin.down('#specializationId').getValue();
	                	 var retainEnrollments = frmWin.down('#checkFieldConfirmItemId').getValue();
	                	 var admissionIds=[];
	                	 var n = 0;
	                	 var successMsg = getProgramandcourseTranslation('CHANGE_SPECIAL_DEENROLL_CONFIRM_MESSAGE');
	                	 Ext.Array.each(gridRecord, function(record, index) {
	                		 if((record.data.status == 'Approved' || record.data.status == 'Auto-Approved')  && record.data.specializationId != specializationId) {
	                			 n++
	                			 admissionIds.push(record.data.admissionId);
	                		 }
	                	 });
	                	 var csModel = new Academia.model.program.SpecializationEnrollmentGridModel();
	                	 csModel.set("admissionIds",admissionIds);
	                	 csModel.set("batchId",batchId);
	                	 csModel.set("specializationId",specializationId);
	                	 csModel.set("retainEnrollments",retainEnrollments);
	                	 if(retainEnrollments) {
	                		 successMsg = getProgramandcourseTranslation('CHANGE_SPECIAL_UNENROLL_CONFIRM_MESSAGE');
	                	 }
	                	 delete csModel.data.admissionId;
	                	 delete csModel.data.studentCode;
	                	 delete csModel.data.studentId;
	                	 delete csModel.data.studentName;
	                	 delete csModel.data.admissionCode;
	                	 delete csModel.data.id;
	                	 delete csModel.data.programBatchSpecialId;
	                	 delete csModel.data.status;
	                	 delete csModel.data.specializationCode;
	                	 var formData = Ext.encode(csModel.data);
	                	 showConfirmMessage(getProgramandcourseTranslation('CHANGE_SPECIALIZATION'),successMsg,
	                			 function(btn, text) {
	                		 if (btn == 'yes') {
	                			 Ext.Ajax.request({
	                				 type: 'rest',
	                				 url: SERVERURL.STUDENT_SPECIALIZATION_ENROLLMENT_UPDATE,
	                				 jsonData : formData,
	                				 method : 'POST',
	                				 success: function(f, action) {
	                					 var data = f.responseText;
	                					 if(data == "SUCCESS")
	                						 showSuccessMessage(getProgramandcourseTranslation('CHANGE_SPECIALIZATION'), getProgramandcourseTranslation('CHANGE_SPECIAL_SUCCESS')+n+" "+getCommonTranslation('STUDENTS'));
	                					 grid.getStore().reload();
	                					 grid.getSelectionModel().deselectAll();
	                					 frmWin.close();
	                				 },
	                				 failure: function(result, request) {
	                					 showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
	                					 return false;
	                				 }
	                			 });
	                		 }
	                	 });
	                 },
					 
		cellClickSpecializationEnrollmentGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					     	var this$ = this;
					         //var searchResultGrid = this$.getSearchResultGrid();
					         var columnName = view.getGridColumns()[cellIndex].dataIndex;
					 		var academyLocationId = this$.getCurrentAcademyLocation();
					         if (columnName == "studentCode") {
					         	if (e.target.tagName == 'A'){
					             var tabTitle = record.get('studentCode');
					             var personId = record.get('studentId');
					             var userId = record.get('studentId');
					 			var admissionId = record.get('admissionId');
					             var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
								 var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
								 								var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
								 // this$.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId);
					 			
					 				Ext.Ajax.request({
					 					type: 'rest',
					 					url: SERVERURL.PATH_FIND_STUDENT_JOURNEY_DASHBOARD_SETTING_BY_AL_ID,
					 					method: 'GET',
					 					params: {
					 						academyLocationId: academyLocationId,
					 					},
					 					success: function(f, action) {
					 						var data = f.responseText;
					 						if (data == "true") {
					 							personController.addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
					 						} else {
					 							personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
					 						}
					 					},
					 					failure: function(result, request) {
					 						showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
					 						return false;
					 					}
					 				});
									
									var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
																	if(!isNullOrEmpty(studentProfile)){
																		var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
																		if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
																			var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
																			studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
																		}
																	}
					         }
					         }
					         
					         
					     },
});