/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.controller.program.sessionReport.SessionReportController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['coursetransaction.sectionmanagement.SectionGroup','coursetransaction.coursereading.CourseByPeriod','course.coursevariants.CourseVariantStore',
	          'common.ActiveUserStore','common.AccessibleProgByCourseAndALsIdStore','enquiry.AcademicBatchStore',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','coursetransaction.sectionmanagement.SectionsStore',
	          'examinationcenters.remark.CourseEvaluationRemark','programCourseDashboard.DailyLogOrSessionReportGridStore',
	          'common.ProgramsByAcademyLocationsIds','programCourseDashboard.PendingSessionReportGridStore',
	          'course.AssignedPeriodCoursesFacultyStore', 'coursesessiondiary.CourseSessionDiaryDocument',
	          'programCourseDashboard.ScheduleGridStore','attendance.attendancereport.CourseByStudentId',
	          'common.AcademicTermByPeriodIdsStore','attendance.AssignedSectionByCourseNComponent',
	          'coursetransaction.sectionmanagement.CoruseVariantSectionStore','student.studentprofile.StudentProgramStore',
	          'common.AssignedProgramStore','attendance.SectionAndFacultyByPeriodID','common.ParameterizedProgramBatchPeriodStore',
	          'common.MappedFacultyStore','coursesessiondiary.CourseSessionDescriptionStore'],

	          views : ['baselayout.contentarea.ContentPanel','programCourseDashboard.DailyLogOrSessionReportStructure',
	                   'programCourseDashboard.DailyLogOrSessionPBSReportFilter','programCourseDashboard.PendingSessionReportStructure',
	                   'programCourseDashboard.DailyLogOrSessionReportGrid','programCourseDashboard.DailyLogOrSessionCBSReportFilter',
	                   'programCourseDashboard.PendingSessionReportGrid', 'coursesessiondiary.CourseSessionDiaryDocumentList',
	                   'coursesessiondiary.CourseSessionDiaryDocumentGrid','programCourseDashboard.NewSessionReportFilter',
	                   'programCourseDashboard.StudentNewSessionReportFilter','coursesessiondiary.CourseSessionDocumentLinkWin'],	           
	                   config: {
	                	   MASTER_TIME_TABLE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MASTER_TIME_TABLE_PRIVILEGES'),
	                	   SESSION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SESSION_REPORT_PRIVILEGES'),
	                	   STUDENT_SESSION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SESSION_REPORT_PRIVILEGES'),
	                	   PARENT_SESSION_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_SESSION_REPORT_PRIVILEGES')
	                   },
	                   refs : [{
	                	   ref: 'contentpanel',
	                	   selector: 'contentpanel'
	                   },{
	                	   ref: 'dailylogorsessionreportstructure',
	                	   selector: 'dailylogorsessionreportstructure'
	                   },{
	                	   ref: 'dailylogorsessionpbsreportfilter',
	                	   selector: 'dailylogorsessionpbsreportfilter[itemId=dailylogorsessionpbsreportfilter]'
	                   },{
	                	   ref: 'dailylogorsessionreportgrid',
	                	   selector: 'dailylogorsessionreportgrid'
	                   },{
	                	   ref: 'dailylogorsessioncbsreportfilter',
	                	   selector: 'dailylogorsessioncbsreportfilter[itemId=dailylogorsessioncbsreportfilter]'
	                   },{
	                	   ref: 'pendingsessionpbsreportfilter',
	                	   selector: 'dailylogorsessionpbsreportfilter[itemId=pendingsessionpbsreportfilter]'
	                   },{
	                	   ref: 'pendingsessioncbsreportfilter',
	                	   selector: 'dailylogorsessioncbsreportfilter[itemId=pendingsessioncbsreportfilter]'
	                   },{
	                	   ref: 'pendingsessionreportstructure',
	                	   selector: 'pendingsessionreportstructure'
	                   },{
	                	   ref: 'pendingsessionreportgrid',
	                	   selector: 'pendingsessionreportgrid'
	                   },{
	                	   ref: 'coursesessiondiarydocumentlist',
	                	   selector: 'coursesessiondiarydocumentlist[itemId=sessionReportDocument]'
	                   },{
	                	   ref: 'coursesessiondiarydocumentgrid',
	                	   selector: 'coursesessiondiarydocumentgrid'
	                   },{
	                	   ref: 'newsessionreportfilter',
	                	   selector: 'newsessionreportfilter'
	                   },{
	                	   ref: 'studentnewsessionreportfilter',
	                	   selector: 'studentnewsessionreportfilter'
	                   },{
	                	   ref:'coursesessiondocumentlinkwin',
	                	   selector:'coursesessiondocumentlinkwin'
	                   }],
	                   init : function() {
	                	   this.control({
	                		   'pendingsessionreportstructure radiogroup[itemId=sectionTypeId]':{
	                			   change : function(value,newValue,oldValue){
	                				   this.showHideSessionReportSectionType(value, newValue, oldValue, true);
	                			   }
	                		   },
	                		   'pendingsessionreportstructure':{
	                			   afterrender: function(){
	                				   this.setTabPbsCbsPermission("pendingSessionReport");
	                			   }
	                		   },
	                		   'dailylogorsessionreportgrid':{
	                			   render : function(grid){
	                				   /**
	                				    * for student portal, portal Id is 3
	                				    * and for parent portal, portal Id is 7
	                				    */
	                				   if(this.getCurrentLoggedPortalId() == 7){
		                				   this.doAccessControlValidation(grid, this.getPARENT_SESSION_REPORT_PERMISSIONS());
	                				   }else if(this.getCurrentLoggedPortalId() == 3){
		                				   this.doAccessControlValidation(grid, this.getSTUDENT_SESSION_REPORT_PERMISSIONS());
	                				   } else {
		                				   this.doAccessControlValidation(grid, this.getSESSION_REPORT_PERMISSIONS());
	                				   }
	                			   },
	       						afterrender: function(grid) {
            						var me = this;
									setTimeout(function(){
    									me.addDataGridConfigButton(grid,me.getSESSION_REPORT_PERMISSIONS());
									},3000);
					},
	                			   
	                			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
	                				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
//	                				   var documentId = record.data.document.id;
	                				   if(columnName=='description'){
	                					   if(e.target.tagName=='A'){
	                					   this.openDescriptionLinkWindow(record);
	                					   }
	                				   }
	                				   if(columnName == "documents"){
	                         			   if(e.target.tagName=='A'){
	                         				  if(record.data.documents.length == 1){
	                   						   var csvForm = Ext.create('Ext.form.Panel'); 
	                   						   csvForm.getForm().submit({
	                   							   target: '_blank',
	                   							   method:'GET',
	                   							   params :{
	                   								   access_token : Ext.Ajax.defaultHeaders.access_token
	                   							   },
	                   							   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	                   							   url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + record.data.documents["0"].code,
	                   							   standardSubmit :true
	                   						   });
	                   					   } else if(record.data.documents.length > 1){
	                   						   var docWindow = this.getCoursesessiondiarydocumentlist();
	                   						   var ID = record.data.id;
	                   						   if (!docWindow) {
//	                   							   Ext.widget('coursesessiondiarydocumentlist');
	                   							   docWindow = Ext.widget('coursesessiondiarydocumentlist',{
	                   								   itemId:'sessionReportDocument'
	                   							   });
//	                   							   docWindow = this.getCoursesessiondiarydocumentlist();
	                   						   }
	                   						   docWindow.show();
	                   						   docWindow.down('form').down('#sessionDate').setValue(dateRender(record.data.date));
	                   						   docWindow.down('form').down('#courseVariantName').setValue(record.data.courseVariant);
	                   						   docWindow.down('form').down('#topicName').setValue(record.data.topic);
	                   						   var grid = docWindow.down('#coursesessiondiarydocumentgridItemId');
	                   						   grid.setTitle(getProgramandcourseTranslation('DAILY_SESSION_REPORT'));
	                   						   var store = grid.getStore();
	                   						   store.getProxy().extraParams = {
	                   		       		    		ID: record.data.id
	                   		       		    	};
	                   		       		    	store.load();
	                   					   }
	                         			   }
	                				   }
	                				   
	                			   }
	                		   },
	                		   'dailylogorsessionpbsreportfilter[itemId=pendingsessionpbsreportfilter]': {
	                			   render: function(obj){
	                				   this.sessionReportPBSRender(obj)
	                			   },
	                			   afterrender : function(obj) {
	                				   if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3){
	                					   this.setValuesSessionReportFilters(obj);
	                				   }
	                			   }
	                		   },
	                		   'dailylogorsessionpbsreportfilter[itemId=pendingsessionpbsreportfilter] combo#programId': {
	                			   select: function(obj, record){
	                				   this.sessionReportPBSProgCombo(obj, record)
	                			   },
	                			   render : function(obj) {
	                				   var store = obj.getStore();
	        	                	   var academyLocationId=this.getCurrentAcademyLocation();
	    	                		   store.getProxy().extraParams = {
	    	                			   academyLocationId: academyLocationId
	    	                		   };
	    	                		   store.load();
	                			   }
	                		   },
	                		   'dailylogorsessionpbsreportfilter[itemId=pendingsessionpbsreportfilter] combo#batchId':{
	                			   select: function(obj, record){
	                				   this.sessionReportPBSBatchCombo(obj, record)
	                			   }
	                		   },
	                		   'dailylogorsessionpbsreportfilter[itemId=pendingsessionpbsreportfilter] combo#periodId': {
	                			   select: function(obj, record){
	                				   this.sessionReportPBSPeriodCombo(obj, record)
	                			   }
	                		   },
	                		   'dailylogorsessioncbsreportfilter[itemId=pendingsessioncbsreportfilter] combo#courseCBSId': {
	                			   render: function(obj, record){
	                				   this.sessionReportCBSCourseRender(obj, record)
	                			   },
	                			   select: function(obj, record){
	                				   this.sessionReportCBSCourseSelect(obj, record)
	                			   }
	                		   },   
	                		   'dailylogorsessionpbsreportfilter[itemId=pendingsessionpbsreportfilter] button#btnReset': {
	                			   click: function(obj){
	                				   this.sessionReportPBSReset(obj)
	                			   }
	                		   },
	                		   'dailylogorsessioncbsreportfilter[itemId=pendingsessioncbsreportfilter] button#btnReset': {
	                			   click: function(obj){
	                				   this.sessionReportCBSReset(obj)
	                			   }
	                		   },
	                		   'dailylogorsessionpbsreportfilter[itemId=pendingsessionpbsreportfilter] button#btnSearch': {
	                			   click: function(obj) {
	                				   var form = this.getPendingsessionpbsreportfilter();
	                				   this.loadDailyLogOrSessionReport(form, true, this.getPendingsessionreportgrid());
	                			   }
	                		   },
	                		   'dailylogorsessioncbsreportfilter[itemId=pendingsessioncbsreportfilter] button#btnSearch': {
	                			   click: function(obj) {
	                				   var form = this.getPendingsessioncbsreportfilter();
	                				   this.loadDailyLogOrSessionReport(form, false, this.getPendingsessionreportgrid());
	                			   }
	                		   },
	                		   'coursesessiondiarydocumentgrid button[itemId=downloadDocumentItemId]':{
	                			   click:function(obj){
	                				   this.sessionReportDocumentZip();
	                			   }
	                		   },
	                		   'dailylogorsessionreportstructure':{
	                			   afterrender : function(obj) {
	                				   var $this = this;
	                				   if($this.getCurrentLoggedPortalId()==3 || $this.getCurrentLoggedPortalId()==7) {
	                					   var dailylogorsessionGrid = obj.down('dailylogorsessionreportgrid');
	                					   var newStructure=obj.up('personinfostudentportal');
		                				   this.getGridHeaderFreeze(dailylogorsessionGrid,newStructure,false);
	                					   this.getDailylogorsessionreportstructure().down('#studentnewsessionreportfilterItemId').setVisible(true);
	                					   this.getDailylogorsessionreportstructure().down('#newSessionReportFilterItemId').setVisible(false);
	                					   if(localStorage.getItem('wheatherSchool')){
	                						   this.getDailylogorsessionreportstructure().down('#studentnewsessionreportfilterItemId').down('#periodId_student_New').setVisible(false);
	                					   }
	                					   studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                					   var academyLocationId = this.getCurrentAcademyLocation();
	                					   var studentId = studentPortalInfo.student.id;
	                					   var programId = studentPortalInfo.programBatchDetails.programId;
	                					   var batchId = studentPortalInfo.programBatchDetails.batchId;
	                					   var periodId = studentPortalInfo.programBatchDetails.periodId;
	                					   var sectionId = studentPortalInfo.programBatchDetails.sectionId;
	                					   this.setPreFilledValues(academyLocationId, studentId, programId, batchId, periodId, sectionId);
	                					   var grid = this.getDailylogorsessionreportstructure().down('#dailylogorsessionreportgrid');
	                					   var gridStore = grid.getStore();

	                					   var academyLocationId=this.getCurrentAcademyLocation();
	                					   var portalId = this.getCurrentLoggedPortalId();

	                					   gridStore.getProxy().extraParams = {
	                						   academyLocationId:academyLocationId,
	                						   // facultyId:facultyId_New.getValue(),
	                						   sectionId:sectionId,
	                						   //  fromDate:fromDate_New.getValue(),
	                						   //toDate:toDate_New.getValue(),
	                						   //  courseId:courseCBSId_New.getValue(),
	                						   portalId:portalId,
	                						   academicTermId:academyLocationId,
	                						   programId:programId,
	                						   batchId:batchId,
	                						   periodId:periodId
	                					   };  
	                					   gridStore.loadPage(1);
	                					   var form = this.getDailylogorsessionreportstructure().down('#studentnewsessionreportfilterItemId');
	                					   var courseField = form.down('#courseCBSId1_New');
	                					   var programField = form.down('#student_programId_New');
	                					   var courseStore = courseField.getStore();
	                					   courseStore.getProxy().extraParams = {
	                						   academyLocationId:$this.getCurrentAcademyLocation(),
	                						   programId : programId,
	                						   isCurrentPeriod:false
	                					   }
	                					   courseStore.load();

	                				   } else {
	                					   var dailylogorsessionGrid = obj.down('dailylogorsessionreportgrid');
		                				   this.getGridHeaderFreeze(dailylogorsessionGrid,obj,false);
	                					   var form = this.getDailylogorsessionreportstructure().down('#newSessionReportFilterItemId');
	                					   form.setVisible(true);
	                					   this.getDailylogorsessionreportstructure().down('#studentnewsessionreportfilterItemId').setVisible(false);
	                					   if(localStorage.getItem('wheatherSchool')){
	                						   form.down('#periodId_New').setVisible(false);
	                					   }
	                					   var programField = form.down('#programId_New');
	                					   var courseField = form.down('#courseCBSId_New');
	                					   var facultyField = form.down('#facultyId_New');
	                					   var programStore = programField.getStore();
	                					   programStore.getProxy().extraParams = {
	                						   academyLocationIds:$this.getCurrentAcademyLocation(),
	                						   isAllProgram:true
	                					   }
	                					   programStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length == 1){
	                									   programField.setValue(records[0].data.id);
	                								   }
	                							   }
	                						   }
	                					   });

	                					   var courseStore = courseField.getStore();
	                					   courseStore.getProxy().extraParams = {
	                						   academyLocationId:$this.getCurrentAcademyLocation(),
	                						   isCurrentPeriod:false
	                					   }
	                					   courseStore.load();

	                					   var facultyStore = facultyField.getStore();
	                					   facultyStore.getProxy().extraParams = {
	                						   academyLocationId:$this.getCurrentAcademyLocation()
	                					   }
	                					   facultyStore.load();
	                				   }
	                			   }
	                		   },
	                		   'newsessionreportfilter customcombobox[itemId=academicTerm_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var academicTermId = obj.getValue();
	                				   if(academicTermId > 0) {
	                					   this.academicTermSelection(form, academicTermId);
	                				   }
	                			   }
	                		   },
	                		   'newsessionreportfilter customcombobox[itemId=programId_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var programId = obj.getValue();
	                				   //  var programId = Ext.String.trim(obj.getValue());
	                				     if(isNullOrEmpty(programId)){
	                				    	 programId = form.down('#programId_New').getValue();
	                				     }
	                				   if(programId > 0) {
	                					   this.programSelection(form, programId);
	                				   }
	                			   }
	                		   },
	                		   'newsessionreportfilter customcombobox[itemId=batchId_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var batchId = obj.getValue();
	                				   if(batchId > 0) {
	                					   this.batchSelection(form, batchId);
	                				   }
	                			   }
	                		   },
	                		   'newsessionreportfilter customcombobox[itemId=periodId_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var periodId = obj.getValue();
	                				   if(periodId > 0) {
	                					   this.periodSelection(form, periodId);
	                				   }
	                			   }
	                		   },
	                		   'newsessionreportfilter customcombobox[itemId=courseCBSId_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var courseId = obj.getValue();
	                				   if(courseId > 0) {
	                					   this.courseSelection(form, courseId);
	                				   }
	                			   }
	                		   },
	                		   'newsessionreportfilter customcombobox[itemId=programSectionId_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var sectionId = obj.getValue();
	                				   if(sectionId > 0) {
	                					   this.sectionSelection(form, sectionId);
	                				   }
	                			   }
	                		   },
	                		   'newsessionreportfilter customcombobox[itemId=courseSectionId_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var sectionId = obj.getValue();
	                				   if(sectionId > 0) {
	                					   this.sectionSelection(form, sectionId);
	                				   }
	                			   }
	                		   },
	                		   'studentnewsessionreportfilter customcombobox[itemId=student_programId_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				  // var programId = obj.getValue();
	                				   var programId = Ext.String.trim(obj.getValue());
	                				   if(programId > 0) {
	                					   this.studentProgramSelection(form, programId);
	                				   }
	                			   }
	                		   },
	                		   
	                		   'studentnewsessionreportfilter customcombobox[itemId=student_programId_New]':{
	                			   select: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var programId = form.down('#student_programId_New').getValue();
	                				   var batchField = form.down('#student_batchId_New');
	                				   batchField.store.getProxy().extraParams={
	               			    		programId: programId
	               			    	  },
	               			    	   batchField.store.load({
	               			    		callback : function(records, operation, success) {
	               			    			if (success) {
	               			    				for(var i in records) {
	               			    					if(records.length==1) {
	               			    						batchField.setValue(records[i].data.id);
	               			    					}
	               			    				}
	               			    			}
	               			    		}
	               			    	});
	               			    	
	                				   if(programId > 0) {
	                					   this.studentProgramSelection(form, programId);
	                				   }
	                			   }
	                		   },
	                		   'studentnewsessionreportfilter customcombobox[itemId=student_batchId_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var batchId = obj.getValue();
	                				   if(batchId > 0) {
	                					   this.studentBatchSelection(form, batchId);
	                				   }
	                			   }
	                		   },
	                		   'studentnewsessionreportfilter customcombobox[itemId=periodId_student_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var periodId = obj.getValue();
	                				   if(periodId > 0) {
	                					   this.studentPeriodSelection(form, periodId);
	                				   }
	                			   }
	                		   },
	                		   'studentnewsessionreportfilter customcombobox[itemId=courseCBSId1_New]':{
	                			   change: function(obj, record){
	                				   var me = this;
	                				   var form = obj.up('form');
	                				   var courseId = obj.getValue();
	                				   if(courseId > 0) {
	                					   this.studentCourseSelection(form, courseId);
	                				   }
	                			   }
	                		   },
	                		   'newsessionreportfilter button[itemId=btnSearch_New]':{
	                			   click: function(btn){
	                				   var newsessionreportfilterform =btn.up('#newsessionreportfilter');
	                				   newsessionreportfilterform.down('#btnSearch_New').setDisabled(true);
	                				   var academicTerm_New = newsessionreportfilterform.down('#academicTerm_New');
	                				   var programId_New = newsessionreportfilterform.down('#programId_New');
	                				   var batchId_New = newsessionreportfilterform.down('#batchId_New');
	                				   var periodId_student_New = newsessionreportfilterform.down('#periodId_student_New');
	                				   var periodId_New = newsessionreportfilterform.down('#periodId_New');
	                				   var courseCBSId_New = newsessionreportfilterform.down('#courseCBSId_New');
	                				   var courseCBSId1_New = newsessionreportfilterform.down('#courseCBSId1_New');
	                				   var programSectionId_New = newsessionreportfilterform.down('#programSectionId_New');
	                				   var courseSectionId_New = newsessionreportfilterform.down('#courseSectionId_New');
	                				   var facultyId_student_New = newsessionreportfilterform.down('#facultyId_student_New');
	                				   var facultyId_New = newsessionreportfilterform.down('#facultyId_New');
	                				   var fromDate_New = newsessionreportfilterform.down('#fromDate_New');
	                				   var toDate_New = newsessionreportfilterform.down('#toDate_New');
	                				   var sectionId = '';
	                				   if(!isNullOrEmpty(programSectionId_New.getValue())) {
	                					   sectionId = programSectionId_New.getValue();
	                				   } else if (!isNullOrEmpty(courseSectionId_New.getValue())){
	                					   sectionId = courseSectionId_New.getValue();
	                				   }
	                				   var grid = btn.up('dailylogorsessionreportstructure').down('#dailylogorsessionreportgrid');
	                				   var gridStore = grid.getStore();

	                				   var academyLocationId=this.getCurrentAcademyLocation();
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   
	                				   gridStore.getProxy().extraParams = {
	                					   academyLocationId:academyLocationId,
	                					   facultyId:facultyId_New.getValue(),
	                					   sectionId:sectionId,
	                					   fromDate:fromDate_New.getValue(),
	                					   toDate:toDate_New.getValue(),
	                					   courseId:courseCBSId_New.getValue(),
	                					   portalId:portalId,
	                					   academicTermId:academicTerm_New.getValue(),
	                					   programId:programId_New.getValue(),
	                					   batchId:batchId_New.getValue(),
	                					   periodId:periodId_New.getValue()
	                				   };  
	                				   this.resetPageSetting(gridStore);
	                				   gridStore.load({
	                					   callback: function(records, operation, success) {
	                    					   if (success) {
	                    						   newsessionreportfilterform.down('#btnSearch_New').setDisabled(false);  
	                    					   }
	                    				   }
	                				   });
	                				   grid.config.searchFilterForm = newsessionreportfilterform;
	                			   }
	                		   },
	                		   'studentnewsessionreportfilter button[itemId=btnSearch_New]':{
	                			   click: function(btn){
	                				   var form =btn.up('studentnewsessionreportfilter');
	                				   var programId_New = form.down('#student_programId_New');
	                				   var batchId_New = form.down('#student_batchId_New');
	                				   var periodId_student_New = form.down('#periodId_student_New');
	                				   var courseCBSId1_New = form.down('#courseCBSId1_New');
	                				   var programSectionId_New = form.down('#student_programSectionId_New');
	                				   var courseSectionId_New = form.down('#student_courseSectionId_New');
	                				   var facultyId_student_New = form.down('#facultyId_student_New');
	                				   var fromDate_New = form.down('#fromDate_New');
	                				   var toDate_New = form.down('#toDate_New');
	                				   var sectionId = '';
	                				   if(!isNullOrEmpty(programSectionId_New.getValue())) {
	                					   sectionId = programSectionId_New.getValue();
	                				   } else {
	                					   sectionId = courseSectionId_New.getValue();
	                				   }
	                				   var grid = btn.up('dailylogorsessionreportstructure').down('#dailylogorsessionreportgrid');
	                				   var gridStore = grid.getStore();

	                				   var studentIds = [];
	                				   var academyLocationId=this.getCurrentAcademyLocation();
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                				   studentIds.push(studentPortalInfo.student.id);
	                				   
	                				   gridStore.getProxy().extraParams = {
	                					   academyLocationId:academyLocationId,
	                					   facultyId:facultyId_student_New.getValue(),
	                					   sectionId:sectionId,
	                					   fromDate:fromDate_New.getValue(),
	                					   toDate:toDate_New.getValue(),
	                					   courseId:courseCBSId1_New.getValue(),
	                					   studentIds:studentIds,
	                					   portalId:portalId,
	                					   programId:programId_New.getValue(),
	                					   batchId:batchId_New.getValue(),
	                					   periodId:periodId_student_New.getValue()
	                				   };  
	                				   gridStore.loadPage(1);
	                			   }
	                		   },
	                		   'newsessionreportfilter button[itemId=btnReset_New]':{
	                			   click: function(btn){
	                				   var $this = this;
	                				   var form = this.getNewsessionreportfilter();
	                				   var academicTermFiled = form.down('#academicTerm_New');
	                				   var programField = form.down('#programId_New');
	                				   var batchField = form.down('#batchId_New');
	                				   var periodField = form.down('#periodId_New');
	                				   var courseField = form.down('#courseCBSId_New');
	                				   var pbsSectionField = form.down('#programSectionId_New');
	                				   var cbsSectionField = form.down('#courseSectionId_New');
	                				   var facultyField = form.down('#facultyId_New');
	                				   var fromDateField = form.down('#fromDate_New');
	                				   var tofateField = form.down('#toDate_New');

	                				   academicTermFiled.clearValue();
	                				   batchField.clearValue();
	                				   periodField.clearValue();
	                				   pbsSectionField.clearValue();
	                				   cbsSectionField.clearValue();
	                				   programField.clearValue();
	                				   courseField.clearValue();
	                				   facultyField.clearValue();
	                				   fromDateField.reset();
	                				   tofateField.reset();
	                				   
	                				   fromDateField.setMinValue(false);
	                				   tofateField.setMinValue(false);
	                				   fromDateField.setMaxValue(false);
	                				   tofateField.setMaxValue(false);
	                				   
	                				   batchField.setDisabled(true);
	                				   periodField.setDisabled(true);
	                				   pbsSectionField.setDisabled(true);
	                				   cbsSectionField.setDisabled(true);
	                				   
	                				   pbsSectionField.setVisible(true);
	                				   cbsSectionField.setVisible(false);
	                				   
	                				   var programStore = programField.getStore();
	                				   programStore.getProxy().extraParams = {
	                						   academyLocationIds:$this.getCurrentAcademyLocation(),
	                						   isAllProgram:true
	                				   }
	                				   programStore.load({
	                					   callback: function(records, operation, success) {
	                    					   if (success) {
	                    						   if(records.length == 1){
	                    							   programField.setValue(records[0].data.id);
	                    						   }
	                    					   }
	                    				   }
	                				   });
	                				   
	                				   var courseStore = courseField.getStore();
	                				   courseStore.getProxy().extraParams = {
	                						   academyLocationId:$this.getCurrentAcademyLocation(),
	                						   isCurrentPeriod:false
	                				   }
	                				   courseStore.load();
	                				   
	                				   var facultyStore = facultyField.getStore();
	                				   facultyStore.getProxy().extraParams = {
	                						   academyLocationId:$this.getCurrentAcademyLocation(),
	                				   }
	                				   facultyStore.load();
	                			   }
	                		   },
	                		   'studentnewsessionreportfilter button[itemId=btnReset_New]':{
	                			   click: function(btn){
	                				   var $this = this;
	                				   var form =  this.getStudentnewsessionreportfilter();
	                				   var fromDateField = form.down('#fromDate_New');
	                				   var tofateField = form.down('#toDate_New');
	                				   fromDateField.reset();
	                				   tofateField.reset();
	                				   fromDateField.setMinValue(false);
	                				   tofateField.setMinValue(false);
	                				   fromDateField.setMaxValue(false);
	                				   tofateField.setMaxValue(false);
	                				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
                					   var academyLocationId = this.getCurrentAcademyLocation();
                					   var studentId = studentPortalInfo.student.id;
                					   var programId = studentPortalInfo.programBatchDetails.programId;
                					   var batchId = studentPortalInfo.programBatchDetails.batchId;
                					   var periodId = studentPortalInfo.programBatchDetails.periodId;
                					   var sectionId = studentPortalInfo.programBatchDetails.sectionId;
                					   this.setPreFilledValues(academyLocationId, studentId, programId, batchId, periodId, sectionId);
	                			   }
	                		   }
	                	   });
	                   },
	                   

	                   loadDailyLogOrSessionReport : function(form, isPBSForm, grid){
//	                	   var grid=this.getDailylogorsessionreportgrid();
	                	   form.down('#btnSearch').setDisabled(true);
	                	   var formValues=form.getValues();
	                	   var academyLocationId=this.getCurrentAcademyLocation();
	                	   var admissionIds=[];
	                	   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                	   var admissionDetails = studentPortalInfo.admissionDetails;
	                	   for(var i in admissionDetails){
	                		   admissionIds.push(admissionDetails[i].id)
	                	   }
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   if(portalId == 1 ) {
	                		   admissionIds=[];
	                		   portalId=1;
	                	   }
	                	   var store=grid.getStore();
//	                	   var whetherPBS=this.getDailylogorsessionreportstructure().down("#sectionTypeId");
	                	   if(isPBSForm){
	                		   store.getProxy().extraParams = {
	                			   academyLocationId:academyLocationId,
	                			   programId:formValues.programId,
	                			   batchId:formValues.batchId,
	                			   periodId:formValues.periodId,
	                			   sectionId:formValues.programSectionId,
	                			   fromDate:formValues.fromDate,
	                			   toDate:formValues.toDateId,
	                			   courseVariantId:formValues.courseVariantPBSId,
	                			   facultyId:formValues.facultyPBSId,
	                			   whetherPBS:isPBSForm,
	                			   admissionIds:admissionIds,
	                			   portalId:portalId
	                		   };
	                	   } else {
	                		   if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3){
	                			   store.getProxy().extraParams = {
		                			   academyLocationId:academyLocationId,
		                			   sectionId:formValues.sectionGroupId,
		                			   courseId:formValues.courseCBSId1,
		                			   fromDate:formValues.fromDate,
		                			   toDate:formValues.toDateId,
		                			   courseVariantId:formValues.courseVariantCBSId,
		                			   facultyId:formValues.facultyCBSId,
		                			   whetherPBS:isPBSForm,
		                			   admissionIds:admissionIds,
		                			   portalId:portalId
		                		   };  
	                		   }else{
	                		   store.getProxy().extraParams = {
	                			   academyLocationId:academyLocationId,
	                			   sectionId:formValues.sectionGroupId,
	                			   courseId:formValues.courseCBSId,
	                			   fromDate:formValues.fromDate,
	                			   toDate:formValues.toDateId,
	                			   courseVariantId:formValues.courseVariantCBSId,
	                			   facultyId:formValues.facultyCBSId,
	                			   whetherPBS:isPBSForm,
	                			   admissionIds:admissionIds,
	                			   portalId:portalId
	                		   };
	                		   }
	                	   }
	        			   this.resetPageSetting(store);
	                	   store.load({
            				   callback: function(records, operation, success) {
            					   if (success) {
            						   form.down('#btnSearch').setDisabled(false);
            					   }
            				   }
            			   });
						   grid.config.searchFilterForm = form;
	                	   if(grid.down('#dockedItemId') != null)
	                		   grid.down('#dockedItemId').setVisible(true);
	                   },

	                   showHideSessionReportSectionType : function(value, newValue, oldValue, isPending){
	                	   var $this = this;
	                	   var structure;
	                	   var grid;
	                	   var pbsForm;
	                	   var cbsForm;
	                	   var alinfomodel = Academia.model.authentication.ALInfoModel;
						   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                	   if(isPending) {
	                		   structure = this.getPendingsessionreportstructure();
		                	   grid =  structure.down("#pendingsessionreportgrid");
		                	   if(!wheatherSchool){
		                		   grid.columns[2].setVisible(true);
		                	      }
		                	   pbsForm = structure.down("#pendingsessionpbsreportfilter");
		                	   cbsForm = structure.down("#pendingsessioncbsreportfilter");
	                	   }
	                	   cbsForm.getForm().reset();
	                	   pbsForm.getForm().reset();
//	                	   grid.getStore().removeAll();
	                	   grid.getStore().loadRawData([]);
//	                	   grid.removeDocked=true;
//	                	   grid.getStore().getProxy().setExtraParam('limit', -1);
	                	   grid.getStore().loadRawData([]);
	                	   if(grid.down('#dockedItemId') != null)
	                		   grid.down('#dockedItemId').setVisible(false);
//	                	   Ext.suspendLayouts();
//	                	   grid.removeDocked(grid.down('#dockedItemId'));
//	                	   Ext.resumeLayouts()
//	                	   Ext.suspendLayouts();
//	                	   grid.addDocked(grid.down('#dockedItemId'));
//	                	   Ext.resumeLayouts()
	                	   if(grid.down('#dockedItemId') != null)
	                        	  grid.down('#dockedItemId').setVisible(false);
	                	   if(newValue.whetherPBSorCBS==true){
	                		   var batch=pbsForm.down("#batchId");
	                		   batch.setDisabled(true);
	                		   var period=pbsForm.down("#periodId");
	                		   period.setDisabled(true);
	                		   var programSectionId=pbsForm.down("#programSectionId");
	                		   programSectionId.setDisabled(true);
	                		   pbsForm.setVisible(true);
	                		   var alinfomodel = Academia.model.authentication.ALInfoModel;
	            			   var wheatherSchool = alinfomodel.get('wheatherSchool');
	            			   if(wheatherSchool){
	                		   var period=pbsForm.down("#periodId").setVisible(false);
	                	      }
	                		   cbsForm.setVisible(false);
	                		   var programSectionId=pbsForm.down("#programSectionId");
	                		   programSectionId.setDisabled(true);
//	                		   grid.columns[1].show();
//	                		   grid.columns[6].hide();
//	                		   this.showHideSessionReportGridClms(true, null);
	                		   if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3){
            					   this.setValuesSessionReportFilters(pbsForm);
            				   }
	                	   } else {
	                		   pbsForm.setVisible(false);
	                		   cbsForm.setVisible(true);
	                		   if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3){
	                			   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                			   var admissionId = studentPortalInfo.admissionDetails[0].id;
	                			   var studentId = studentPortalInfo.student.id;
	                			   var academicTermId=studentPortalInfo.programBatchDetails.academicTermId
	                			   var periodIds = "";
	                			   var periodType=[];
	                			   periodType.push(studentPortalInfo.programBatchDetails.periodId);
	                			   Ext.each(studentPortalInfo.pastProgramBatchDetails, function(data) {
	                				   periodType.push(data.periodId);
	                			   });
	                			   if (!isNullOrEmpty(periodType)) {
	                				   if (periodType.constructor === Array) {
	                					   periodIds = periodType.join();
	                				   } else {
	                					   periodIds = periodType;
	                				   }
	                			   }
	                			   cbsForm.down("#courseCBSId1").setVisible(true);
	                			   cbsForm.down("#courseCBSId").setVisible(false);
	                			   var academicTermCombo = cbsForm.down('#academicTerm');
	                			   var academicTermStore=academicTermCombo.getStore();
	                			   academicTermStore.getProxy().extraParams = {
	                				   periodIds:periodIds  
	                			   };
	                			   academicTermStore.load({
	                				   callback: function(records, operation, success) {
	                					   if (success) {
	                						   academicTermCombo.setValue(academicTermId);
	                					   }
	                				   }
	                			   });
	                			   var courseCBSId1=cbsForm.down("#courseCBSId1");
	                			   courseCBSId1.getStore().getProxy().extraParams  = {
	                				   studentId : studentId,
	                				   isCurrentPeriod:false,
	                				   academicTermId:academicTermId
	                			   };
	                			   courseCBSId1.getStore().load();
	                		   }else{
            					   cbsForm.down("#courseCBSId1").setVisible(false);
            				   }
	                		   var courseVariantCBSId=cbsForm.down("#courseVariantCBSId");
	                		   courseVariantCBSId.setDisabled(true);
//	                		   this.showHideSessionReportGridClms(false, null);
	                		   var courseVariantCBSId=cbsForm.down("#courseVariantCBSId");
	                		   courseVariantCBSId.setDisabled(true);
//	                		   grid.columns[1].hide();
//	                		   grid.columns[6].show();
	                	   }
	                   },
	                   
	                   setValuesSessionReportFilters: function(form){
	                	   var this$ = this;
	                	   var program = form.down('#programId');
        				   var batch = form.down('#batchId');
        				   var period = form.down('#periodId');
	                	   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                	   var admissionId = studentPortalInfo.admissionDetails[0].id;
	                	   var studentId = studentPortalInfo.student.id;
	                	   var date = new Date();
	                	   var fromdate = new Date(date.setMonth(date.getMonth() - 1));
		    			   form.down('#fromDate').setValue(fromdate);
//	                	   var program = studentPortalInfo.admissionDetails[0].program.code;
	                	   var batchId = studentPortalInfo.programBatchDetails.batchId;
	                	   program.getStore().getProxy().extraParams  = {
	                		   academyLocationId : this$.getCurrentAcademyLocation(),
	                		   studentId: studentId,
	                		   admissionId : admissionId
	                	   };
	                	   program.getStore().load({
	                		   callback:function(record, success) {
	                			   if(success){
	                				   for(var i in record){
	                					   if(record[i].data.id == studentPortalInfo.programBatchDetails.programId){
	                						   program.setValue(record[i].data.id);
	                						   batch.getStore().getProxy().extraParams = {
	                							   id:record[0].data.id,
	                							   admissionId : studentPortalInfo.admissionDetails[0].id,
	                							   isActive: true
	                						   };
	                						   batch.getStore().load({
	                							   callback:function(record, success) {
	                								   if(success){
	                									   for(var i in record){
	                										   if(record[i].data.id == studentPortalInfo.programBatchDetails.batchId){
	                											   batch.setValue(record[i].data.id);
	                											   batch.setDisabled(false);
	                											   period.setDisabled(false);
	                											   form.down('#programSectionId').setDisabled(true);
	                											   period.getStore().getProxy().extraParams = {
	                												   id: record[i].data.id,
	                												   isCurrentPeriod:true
	                											   };
	                											   period.getStore().load({
	                												   callback:function(records, success) {
	                													   if(success){
	                														   if(records.length==1){
	                															   this$.getDailylogorsessionpbsreportfilter().down('#programSectionId').setDisabled(false);
	                															   period.setValue(studentPortalInfo.programBatchDetails.periodId);
	                															   var courseVariantPBSId = this$.getDailylogorsessionpbsreportfilter().down('#courseVariantPBSId');
	                															   var batch = this$.getDailylogorsessionpbsreportfilter().down('#batchId');
	                															   var academyLocationId=this$.getCurrentAcademyLocation();
	                															   courseVariantPBSId.reset();
	                															   var coursestore = courseVariantPBSId.getStore();
	                															   coursestore.getProxy().extraParams = {
	                																   batchId:batch.value,
	                																   periodId:records[0].get('id')
	                															   };
	                															   coursestore.load();
	                															   var sectionId = this$.getDailylogorsessionpbsreportfilter().down('#programSectionId');
	                															   sectionId.reset();
	                															   sectionId.setDisabled(false);
	                															   var storeSection = sectionId.getStore();
	                															   var submitURL=SERVERURL.GET_CURRENT_SECTION_OF_STUDENT;
	                															   storeSection.getProxy().api.read=submitURL;
	                															   storeSection.getProxy().extraParams = {
	                																   periodId:records[0].get('id'),
	                																   admissionId: studentPortalInfo.admissionDetails[0].id

	                															   };
	                															   storeSection.load({
	                																   callback:function(records, success) {
	                																	   if(success){
	                																		   if(records.length==1){
	                																			   this$.getDailylogorsessionpbsreportfilter().down('#programSectionId').setValue(records[0].get('id'));
	                																			   var form = this$.getDailylogorsessionpbsreportfilter();
	                																			   this$.loadDailyLogOrSessionReport(form, true, this$.getDailylogorsessionreportgrid());
	                																		   }	            	                					   	            	                					   
	                																	   }
	                																   }
	                															   });
	                														   }
	                													   }
	                												   }
	                											   });
	                										   }
	                									   }
	                								   }
	                							   }
	                						   });
	                					   }
	                				   }
	                			   }
	                		   }
	                	   });
	                   },
	                   sessionReportPBSRender : function(form) {
	                	   var program = form.down('#programId');
	                	   var grid=null;
	                	   var structure=null;
	                	   var alinfomodel = Academia.model.authentication.ALInfoModel;
						   var wheatherSchool = alinfomodel.get('wheatherSchool');
						   structure = this.getPendingsessionreportstructure();
						   if(wheatherSchool){
								  var periode = form.down('#periodId').hide();
								  }
						   else if(Ext.isDefined(structure)){
							   structure.down('grid').columns[2].show();
						   }
	                	   var courseVariantPBSId = form.down('#courseVariantPBSId');
	                	   var academyLocationId=this.getCurrentAcademyLocation();
	                	   program.reset();
	                	   if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3){
	                		   this.setValuesSessionReportFilters(form);
	                	   }else{
//	                		   form.reset();
	                		   var store = program.getStore();
	                		   store.getProxy().extraParams = {
	                			   academyLocationId: academyLocationId
	                		   };
	                		   store.load();
	                	   }
	                	   courseVariantPBSId.reset();
	                	   var coursestore = courseVariantPBSId.getStore();
	                	   coursestore.getProxy().extraParams = {
	                		   batchId: form.down('#batchId').getValue()
	                	   };
	                	   coursestore.load();
	                   },
	                   sessionReportPBSProgCombo : function(obj, record) {
	                	   var programId = record[0].get("id");
	                	   var form = obj.up('form');
	                	   var batch = form.down('#batchId');
	                	   var periodIds = form.down('#periodId');
	                	   	batch.reset();
							periodIds.reset();
	                	   batch.setDisabled(false);
	                	   if(programId > 0){
	                		   var store = batch.getStore();
	                		   store.getProxy().extraParams = {
	                			   id: programId,
	                			   isActive:true
	                		   };
	                		   store.load({

    							   callback: function(record, operation, success) {
    								   if (success) {
    									   if(record.length==0){
											   form.down("#programSectionId").setDisabled(true);
											   form.down("#programSectionId").clearValue();
										   }
    									   if(record.length==1){
    										   form.down("#batchId").setValue(record[0].get('id'));
    										   form.down("#periodId").setDisabled(false);
    										   var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
    										   store.getProxy().extraParams = {
    											   id: record[0].get('id'),
    											   isCurrentPeriod:true
    										   };
    										   store.load({
    											   callback: function(record, operation, success) {
    												   if (success) {
    													   if(record.length==0){
    														   if(wheatherSchool) {
    															   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

    														   } 
    													   }
    													   else if(record.length==1){
    														   form.down("#periodId").setValue(record[0].get('id'));
    														   form.down("#programSectionId").setDisabled(false);
    														   var store = this$.getStore('coursetransaction.sectionmanagement.SectionsStore');
    														   store.getProxy().extraParams = {
    															   periodId: record[0].get('id')
    														   };
    														   store.load({
    															   callback: function(record, operation, success) {
    																   if (success) {
    																	   if(record.length==1){
    																		   form.down("#programSectionId").setValue(record[0].data.id);
    																		   var courseVariantPBSId = form.down('#courseVariantPBSId');
    												                		   var coursestore = courseVariantPBSId.getStore();
    												                		   coursestore.getProxy().extraParams = {
    												                			   programId: programId
    												                		   };
    												                		   coursestore.load();
    																	   }
    																   }
    															   }
    														   });

    													   }else{
    														   form.down('#periodId').setVisible(true); 
    													   }
    												   }
    											   }
    										   });
    									   }
    								   }
    							   }
    						   
	                		   });
	                		   var courseVariantPBSId = form.down('#courseVariantPBSId');
	                		   var coursestore = courseVariantPBSId.getStore();
	                		   coursestore.getProxy().extraParams = {
	                			   programId: programId
	                		   };
	                		   coursestore.load();
	                	   }
	                   },
        			   sessionReportPBSBatchCombo : function(obj, record){
        				   this$=this;
	                	   var form = obj.up('form');
        				   var period = form.down('#periodId');
        				   period.reset();
        				   period.setDisabled(false);
        				   var batchId = record[0].get("id");
        				   if(batchId > 0){	    	        					  
        					   var store = period.getStore();
        					   store.getProxy().extraParams = {
        						   id: batchId
        					   };
        					   store.load({

								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length==0){
											   if(wheatherSchool) {
												   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

											   } 
										   }
										   else if(records.length==1){
											   form.down("#periodId").setValue(records[0].get('id'))
											   form.down("#programSectionId").setDisabled(false);
											   var store = this$.getStore('coursetransaction.sectionmanagement.SectionsStore');
											   var courseVariantPBSId = form.down('#courseVariantPBSId');
				            				   var coursestore = courseVariantPBSId.getStore();
				            				   coursestore.getProxy().extraParams = {
				            					   batchId: batchId
				            				   };
				            				   coursestore.load();
				            				   var courseVariantPBSId = form.down('#courseVariantPBSId');
				        					   var batch = form.down('#batchId');
				        					   courseVariantPBSId.reset();
				        					   var coursestore = courseVariantPBSId.getStore();
				        					   coursestore.getProxy().extraParams = {
				        						   batchId:batch.value,
				        						   periodId:periodId
				        					   };
				        					   coursestore.load();
				        					   var sectionId = form.down('#programSectionId');
				        					   sectionId.reset();
				        					   sectionId.setDisabled(false);
				        					   var storeSection = sectionId.getStore();
				        					   storeSection.getProxy().extraParams = {
				        						   periodId:periodId
				        					   };
				        					   storeSection.load();
											   store.getProxy().extraParams = {
												   periodId: records[0].get('id')
											   };
											   store.load({
												   callback: function(records, operation, success) {
													   if (success) {
														   if(records.length==1){
															   form.down("#programSectionId").setValue(record[0].data.id);
														   }
													   }
												   }
											   });

										   }else{
											   form.down('#periodId').setVisible(true); 
										   }
									   }
								   }
							   
        					   });
        					   var courseVariantPBSId = form.down('#courseVariantPBSId');
            				   var coursestore = courseVariantPBSId.getStore();
            				   coursestore.getProxy().extraParams = {
            					   batchId: batchId
            				   };
            				   coursestore.load();
        				   }
        			   },
        			   sessionReportPBSPeriodCombo : function(obj, record) {
        				   var periodId = record[0].get("id");
	                	   var form = obj.up('form');
        				   if(periodId > 0){
        					   var courseVariantPBSId = form.down('#courseVariantPBSId');
        					   var batch = form.down('#batchId');
        					   var academyLocationId=this.getCurrentAcademyLocation();
        					   courseVariantPBSId.reset();
        					   var coursestore = courseVariantPBSId.getStore();
        					   coursestore.getProxy().extraParams = {
        						   batchId:batch.value,
        						   periodId:periodId
        					   };
        					   coursestore.load();
        					   var sectionId = form.down('#programSectionId');
        					   sectionId.reset();
        					   sectionId.setDisabled(false);
        					   var storeSection = sectionId.getStore();
        					   storeSection.getProxy().extraParams = {
        						   periodId:periodId
        					   };
        					   storeSection.load();
        				   }
        			   },
        			   sessionReportCBSCourseRender : function(obj, record){
	                	   var form = obj.up('form');
        				   var courseId = form.down('#courseCBSId');
        				   var store = courseId.getStore();
        				   var courseVariantCBSId = form.down('#courseVariantCBSId');
        				   courseVariantCBSId.setDisabled(true);
    					   store.getProxy().extraParams = {
    						   academyLocationId:this.getCurrentAcademyLocation(),
    						   sectionType : "CourseSection",
    						   isCurrentPeriod:false
    					   };
    					   store.load();
        			   },
        			   sessionReportCBSCourseSelect : function(obj, record) {
	                	   var form = obj.up('form');
	                	   if(isNullOrEmpty(record[0].get("id"))) 
	                			   {
	                		   var courseId = record[0].get("courseId");
	                	   }
	                	   else{
	                		   var courseId = record[0].get("id");
	                	   }
	                	   var academyLocationId=this.getCurrentAcademyLocation();
	                	   var studentId=null;
	                	   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	        					 studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	        					 studentId = studentPortalInfo.student.id;
	        				 }
	                	   var academicTermId=form.down('#academicTerm').getValue();
        				   var courseVariantCBSId = form.down('#courseVariantCBSId');
        				   courseVariantCBSId.reset();
        				   courseVariantCBSId.setDisabled(false);
        				   if(courseId > 0){
        					   var store = courseVariantCBSId.getStore();
        					   store.getProxy().extraParams = {
        						   courseId:courseId,
        						   sectionAtComponentLevel:record[0].get("code"),
        						   studentId:studentId,
        						   academicTermId:academicTermId,
        						   academyLocationId:academyLocationId
        					   };
        					   store.load();
        				   }
        			   },
        			   sessionReportPBSReset : function(obj) {
	                	   var form = obj.up('form');
        				   form.getForm().reset();
        				   if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3){
        					   this.setValuesSessionReportFilters(form);
        				   }else{
        					   var batch = form.down('#batchId');
        					   var period = form.down('#periodId');
        					   var section = form.down('#programSectionId');
        					   batch.setDisabled(true);
        					   period.setDisabled(true);
        					   section.setDisabled(true);
        				   }
        				   var courseVariantPBSId = form.down('#courseVariantPBSId');
        				   courseVariantPBSId.getStore().removeAll();
        			   },
        			   sessionReportCBSReset : function(obj) {
	                	   var form = obj.up('form');
        				   form.getForm().reset();
        				   var courseVariantCBSId = form.down('#courseVariantCBSId');
        				   courseVariantCBSId.reset();
        				   courseVariantCBSId.setDisabled(true);
        				   var academyLocationId=this.getCurrentAcademyLocation();
        				   var store = courseVariantCBSId.getStore();
        				   store.getProxy().extraParams = {
        					   courseId:null,
        					   sectionAtComponentLevel:null,
        					   academyLocationId:academyLocationId
        				   };
        				   store.load();
        				   if(this.getCurrentLoggedPortalId() == 1 || this.getCurrentLoggedPortalId() == 2){
        					   var courseCBSId = form.down('#courseCBSId');
        					   courseCBSId.reset();
        					    var courseCBSStore = courseCBSId.getStore();
        					    courseCBSStore.getProxy().extraParams = {
        						   academyLocationId:this.getCurrentAcademyLocation(),
        						   sectionType : "CourseSection",
        						   isCurrentPeriod:false
        					   };
        					    courseCBSStore.load();
        					   
        				   }else{
        					   var courseCBSId1 = form.down('#courseCBSId1');
        					   courseCBSId1.reset();
        					   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        					   var studentId = studentPortalInfo.student.id;
        					   var courseCBS1Store = courseCBSId1.getStore();
        					   courseCBS1Store.getProxy().extraParams = {
        						   studentId: studentId,
        						   isCurrentPeriod:false
        					   };
        					   courseCBS1Store.load(); 
        				   }
        				   form.down('#fromDate').setMaxValue(false);
        				   form.down('#fromDate').setMinValue(false);
        				   form.down('#toDateId').setMaxValue(false);
        				   form.down('#toDateId').setMinValue(false);
        			   },
        			   sessionReportDocumentZip : function() {
        				   var $this = this;
        				   var grid = $this.getCoursesessiondiarydocumentgrid();
        				   var records = grid.getStore().data.items;
        				   var saveModel = [];
        				   var dispatchZipName = "Course Session Dairy Documnet";
        				   for ( var i in records) {
        					   if (!isNullOrEmpty(records[i].get('path'))) {
        						   saveModel.push(records[i].get('path'));
        					   }
        				   }
        				   showConfirmMessage(getProgramandcourseTranslation('COURSE_SESSION_DIARY_DOCUMENTS'),
        						   getProgramandcourseTranslation('COURSE_SESSION_DIARY_DOCUMENTS_ALERT'),
        						   function(btn, text) {
        					   if (btn == 'yes') {
        						   var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
        						   $this.getController('Academia.controller.document.DocumentController')
        						   .downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
        					   }
        				   });

        			   },
        			   academicTermSelection : function(form, academicTermId) {
        				   var $this = this;
        				   var programField = form.down('#programId_New');
        				   var batchField = form.down('#batchId_New');
        				   var periodField = form.down('#periodId_New');
        				   var courseField = form.down('#courseCBSId_New');
        				   var pbsSectionField = form.down('#programSectionId_New');
        				   var cbsSectionField = form.down('#courseSectionId_New');
        				   var facultyField = form.down('#facultyId_New');
        				   
        				   programField.clearValue();
        				   courseField.clearValue();
        				   batchField.clearValue();
        				   periodField.clearValue();
        				   pbsSectionField.clearValue();
        				   cbsSectionField.clearValue();
        				   facultyField.clearValue();
        				   
        				   batchField.setDisabled(true);
        				   periodField.setDisabled(true);
        				   pbsSectionField.setDisabled(true);
        				   cbsSectionField.setDisabled(true);
        				   
        				   pbsSectionField.setVisible(true);
        				   cbsSectionField.setVisible(false);
        				   
        				   var programStore = programField.getStore();
        				   programStore.getProxy().extraParams = {
        						   academyLocationIds:$this.getCurrentAcademyLocation(),
        						   academicTermId:academicTermId,
        						   isAllProgram:true
        				   }
        				   programStore.load();
        				   
        				   var courseStore = courseField.getStore();
        				   courseStore.getProxy().extraParams = {
        						   academyLocationId:$this.getCurrentAcademyLocation(),
        						   academicTermId:academicTermId,
        						   isCurrentPeriod:false
        				   }
        				   courseStore.load();
        				   
        				   var facultyStore = facultyField.getStore();
        				   facultyStore.getProxy().extraParams = {
        						   academyLocationId:$this.getCurrentAcademyLocation(),
        						   academicTermId:academicTermId
        				   }
        				   facultyStore.load();
        				   
        			   },
        			   programSelection : function(form, programId) {
        				   var $this = this;
        				   var academicTermFiled = form.down('#academicTerm_New');
        				   var programField = form.down('#programId_New');
        				   var batchField = form.down('#batchId_New');
        				   var periodField = form.down('#periodId_New');
        				   var courseField = form.down('#courseCBSId_New');
        				   var pbsSectionField = form.down('#programSectionId_New');
        				   var cbsSectionField = form.down('#courseSectionId_New');
        				   var facultyField = form.down('#facultyId_New');

        				   courseField.clearValue();
        				   batchField.clearValue();
        				   periodField.clearValue();
        				   pbsSectionField.clearValue();
        				   cbsSectionField.clearValue();
        				   facultyField.clearValue();

        				   batchField.setDisabled(false);
        				   periodField.setDisabled(true);
        				   pbsSectionField.setDisabled(true);
        				   cbsSectionField.setDisabled(true);

        				   pbsSectionField.setVisible(true);
        				   cbsSectionField.setVisible(false);

        				   var batchStore = batchField.getStore();
        				   batchStore.getProxy().extraParams = {
        					   programId:programId,
        					   academicTermId:academicTermFiled.getValue(),
        					   isAllProgram:true
        				   }
        				   batchStore.load({
        					   callback: function(records, operation, success) {
        						   if (success) {
        							   if(records.length == 1){
        								   batchField.setValue(records[0].data.id);
        							   } else {
        								   var courseStore = courseField.getStore();
        		        				   courseStore.getProxy().extraParams = {
        		        					   academyLocationId:$this.getCurrentAcademyLocation(),
        		        					   programId:programId,
        		        					   academicTermId:academicTermFiled.getValue(),
        		        					   isCurrentPeriod:false
        		        				   }
        		        				   courseStore.load();
        		        				   
        		        				   var facultyStore = facultyField.getStore();
        		        				   facultyStore.getProxy().extraParams = {
        		        						   academyLocationId:$this.getCurrentAcademyLocation(),
        		        						   academicTermId:academicTermFiled.getValue(),
        		        						   programId:programId
        		        				   }
        		        				   facultyStore.load();
        							   }
        						   }
        					   }
        				   });

        			   },
        			   batchSelection : function(form, batchId) {
        				   var $this = this;
        				   var academicTermFiled = form.down('#academicTerm_New');
        				   var programField = form.down('#programId_New');
        				   var batchField = form.down('#batchId_New');
        				   var periodField = form.down('#periodId_New');
        				   var courseField = form.down('#courseCBSId_New');
        				   var pbsSectionField = form.down('#programSectionId_New');
        				   var cbsSectionField = form.down('#courseSectionId_New');
        				   var facultyField = form.down('#facultyId_New');

        				   courseField.clearValue();
        				   periodField.clearValue();
        				   pbsSectionField.clearValue();
        				   cbsSectionField.clearValue();
        				   facultyField.clearValue();

        				   periodField.setDisabled(false);
        				   pbsSectionField.setDisabled(true);
        				   cbsSectionField.setDisabled(true);

        				   pbsSectionField.setVisible(true);
        				   cbsSectionField.setVisible(false);

        				   var periodStore = periodField.getStore();
        				   periodStore.getProxy().extraParams = {
        					   batchId:batchId,
        					   academicTermId:academicTermFiled.getValue(),
        					   isAllProgram:true
        				   }
        				   periodStore.load({
        					   callback: function(records, operation, success) {
        						   if (success) {
        							   if(records.length == 1){
        								   periodField.setValue(records[0].data.id);
        							   } else {
        								   var courseStore = courseField.getStore();
        		        				   courseStore.getProxy().extraParams = {
        		        					   academyLocationId:$this.getCurrentAcademyLocation(),
        		        					   batchId:batchId,
        		        					   academicTermId:academicTermFiled.getValue(),
        		        					   isCurrentPeriod:false
        		        				   }
        		        				   courseStore.load();
        		        				   
        		        				   var facultyStore = facultyField.getStore();
        		        				   facultyStore.getProxy().extraParams = {
        		        						   academyLocationId:$this.getCurrentAcademyLocation(),
        		        						   academicTermId:academicTermFiled.getValue(),
        		        						   batchId:batchId
        		        				   }
        		        				   facultyStore.load();
        							   }
        						   }
        					   }
        				   });
        			   },
        			   periodSelection : function(form, periodId) {
        				   var $this = this;
        				   var academicTermFiled = form.down('#academicTerm_New');
        				   var programField = form.down('#programId_New');
        				   var batchField = form.down('#batchId_New');
        				   var periodField = form.down('#periodId_New');
        				   var courseField = form.down('#courseCBSId_New');
        				   var pbsSectionField = form.down('#programSectionId_New');
        				   var cbsSectionField = form.down('#courseSectionId_New');
        				   var facultyField = form.down('#facultyId_New');

        				   courseField.clearValue();
        				   pbsSectionField.clearValue();
        				   cbsSectionField.clearValue();
        				   facultyField.clearValue();

        				   pbsSectionField.setDisabled(false);
        				   cbsSectionField.setDisabled(true);

        				   pbsSectionField.setVisible(true);
        				   cbsSectionField.setVisible(false);

        				   var pbsSectionStore = pbsSectionField.getStore();
        				   pbsSectionStore.getProxy().extraParams = {
        					   periodId:periodId
        				   }
        				   pbsSectionStore.load();
        				   
        				   var courseStore = courseField.getStore();
        				   courseStore.getProxy().extraParams = {
        					   academyLocationId:$this.getCurrentAcademyLocation(),
        					   periodId:periodId,
        					   academicTermId:academicTermFiled.getValue(),
        					   isCurrentPeriod:false
        				   }
        				   courseStore.load();
        				   
        				   var facultyStore = facultyField.getStore();
        				   facultyStore.getProxy().extraParams = {
        						   academyLocationId:$this.getCurrentAcademyLocation(),
        						   academicTermId:academicTermFiled.getValue(),
        						   periodId:periodId
        				   }
        				   facultyStore.load();
        			   },
        			   courseSelection : function(form, courseId) {
        				   var $this = this;
        				   var academicTermFiled = form.down('#academicTerm_New');
        				   var programField = form.down('#programId_New');
        				   var batchField = form.down('#batchId_New');
        				   var periodField = form.down('#periodId_New');
        				   var courseField = form.down('#courseCBSId_New');
        				   var pbsSectionField = form.down('#programSectionId_New');
        				   var cbsSectionField = form.down('#courseSectionId_New');
        				   var facultyField = form.down('#facultyId_New');

        				   pbsSectionField.clearValue();
        				   cbsSectionField.clearValue();
        				   facultyField.clearValue();

        				   pbsSectionField.setDisabled(true);
        				   cbsSectionField.setDisabled(false);

        				   pbsSectionField.setVisible(false);
        				   cbsSectionField.setVisible(true);

        				   var cbsSectionStore = cbsSectionField.getStore();
        				   cbsSectionStore.getProxy().extraParams = {
        					   periodId:periodField.getValue(),
        					   academicTermId:academicTermFiled.getValue(),
        					   academyLocationId:$this.getCurrentAcademyLocation(),
        					   courseId:courseId
        				   }
        				   cbsSectionStore.load();
        				   
        				   var facultyStore = facultyField.getStore();
        				   facultyStore.getProxy().extraParams = {
        						   academyLocationId:$this.getCurrentAcademyLocation(),
        						   academicTermId:academicTermFiled.getValue(),
        						   periodId:periodField.getValue(),
        						   courseId:courseId
        				   }
        				   facultyStore.load();
        			   },
        			   sectionSelection : function(form, sectionId) {
        				   var $this = this;
        				   var academicTermFiled = form.down('#academicTerm_New');
        				   var programField = form.down('#programId_New');
        				   var batchField = form.down('#batchId_New');
        				   var periodField = form.down('#periodId_New');
        				   var courseField = form.down('#courseCBSId_New');
        				   var facultyField = form.down('#facultyId_New');

        				   facultyField.clearValue();
        				   
        				   var facultyStore = facultyField.getStore();
        				   facultyStore.getProxy().extraParams = {
        						   academyLocationId:$this.getCurrentAcademyLocation(),
        						   academicTermId:academicTermFiled.getValue(),
        						   periodId:periodField.getValue(),
        						   courseId:courseField.getValue(),
        						   sectionId:sectionId
        				   }
        				   facultyStore.load();
        			   },
        			   setPreFilledValues:function(academyLocationId, studentId, programId, batchId, periodId, sectionId){
        			    	var $this=this;
        			    	var form =  this.getStudentnewsessionreportfilter();
        			    	var alinfomodel = Academia.model.authentication.ALInfoModel;
        			    	var wheatherSchool = alinfomodel.get('wheatherSchool');
        			    	if(wheatherSchool) {
        			    		form.down('#periodId_student_New').setVisible(false);
        			    	} else {
        			    		form.down('#periodId_student_New').setVisible(true);
        			    	}
        			    	var programField = form.down('#student_programId_New');
        			    	var batchField = form.down('#student_batchId_New');
        			    	form.down('#student_programId_New').clearValue();
        			    	form.down('#student_batchId_New').clearValue();
        			    	form.down('#periodId_student_New').clearValue();
        			    	form.down('#student_programSectionId_New').clearValue();
        			    	form.down('#courseCBSId1_New').clearValue();
        			    	form.down('#student_courseSectionId_New').clearValue();
        			    	form.down('#facultyId_student_New').clearValue();
        			    	
        			    	programField.store.getProxy().extraParams={
        			    		studentId: studentId,
        			    		academyLocationId : academyLocationId,
        			    		onlyCurrentRecord:false
        			    	},
        			    	programField.store.load({
        			    		callback : function(records, operation, success) {
        			    			if (success) {
        			    				for(var i in records) {
        			    					if(records[i].data.id == programId) {
        			    						programField.setValue(records[i].data.id);
        			    					}
        			    				}
        			    			}
        			    		}
        			    	});
        			    	
        			    	batchField.store.getProxy().extraParams={
        			    		programId: programId
        			    	},
        			    	batchField.store.load({
        			    		callback : function(records, operation, success) {
        			    			if (success) {
        			    				for(var i in records) {
        			    					if(records.length==1) {
        			    						batchField.setValue(records[i].data.id);
        			    					}
        			    				}
        			    			}
        			    		}
        			    	});
        			    	
        			    	
        			    },
        			    studentProgramSelection : function(form, programId) {
         				   var $this = this;
         				  var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
         				  var academyLocationId = this.getCurrentAcademyLocation();
         				  var studentId = studentPortalInfo.student.id;
         				  var batchId = studentPortalInfo.programBatchDetails.batchId;
         				   var programField = form.down('#student_programId_New');
         				   var batchField = form.down('#student_batchId_New');
         				   var periodField = form.down('#periodId_student_New');
         				   var courseField = form.down('#courseCBSId1_New');
         				   var pbsSectionField = form.down('#student_programSectionId_New');
         				   var cbsSectionField = form.down('#student_courseSectionId_New');
         				   var facultyField = form.down('#facultyId_student_New');

         				   courseField.clearValue();
         				   batchField.clearValue();
         				   periodField.clearValue();
         				   pbsSectionField.clearValue();
         				   cbsSectionField.clearValue();
         				   facultyField.clearValue();

         				   batchField.setDisabled(false);
         				   periodField.setDisabled(true);
         				   pbsSectionField.setDisabled(true);
         				   cbsSectionField.setDisabled(true);

         				   pbsSectionField.setVisible(true);
         				   cbsSectionField.setVisible(false);

         				   var batchStore = batchField.getStore();
         				   batchStore.getProxy().extraParams = {
         					  studentId: studentId,
         					   programId:programId,
         					   onlyCurrentRecord:false
         				   }
         				   batchStore.load({
         					   callback: function(records, operation, success) {
         						   if (success) {
         							   for(var i in records) {
         								   if(records[i].data.id == batchId) {
         									  batchField.setValue(records[i].data.id);
         								   } else if(records.length == 1){
         									  batchField.setValue(records[0].data.id);
         								   } 
         							   }
         							   if(isNullOrEmpty(batchField.getValue())) {
         								  var courseStore = courseField.getStore();
    									   courseStore.getProxy().extraParams = {
    										   studentId: studentId,
    										   programId:programId,
    										   isCurrentPeriod:false
    									   }
    									   courseStore.load();
    									   var facultyStore = facultyField.getStore();
    									   facultyStore.getProxy().extraParams = {
    										  programId:programId
    									   }
    									   facultyStore.load();
         							   }
         						   }
         					   }
         				   });
         			   },
         			  studentBatchSelection : function(form, batchId) {
        				   var $this = this;
        				  var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        				  var academyLocationId = this.getCurrentAcademyLocation();
        				  var studentId = studentPortalInfo.student.id;
        				  var periodId = studentPortalInfo.programBatchDetails.periodId;
        				   var programField = form.down('#student_programId_New');
        				   var batchField = form.down('#student_batchId_New');
        				   var periodField = form.down('#periodId_student_New');
        				   var courseField = form.down('#courseCBSId1_New');
        				   var pbsSectionField = form.down('#student_programSectionId_New');
        				   var cbsSectionField = form.down('#student_courseSectionId_New');
        				   var facultyField = form.down('#facultyId_student_New');

        				   courseField.clearValue();
        				   periodField.clearValue();
        				   pbsSectionField.clearValue();
        				   cbsSectionField.clearValue();
        				   facultyField.clearValue();

        				   periodField.setDisabled(false);
        				   pbsSectionField.setDisabled(true);
        				   cbsSectionField.setDisabled(true);

        				   pbsSectionField.setVisible(true);
        				   cbsSectionField.setVisible(false);

        				   var periodStore = periodField.getStore();
        				   periodStore.getProxy().extraParams = {
        					   studentId: studentId,
        					   batchId:batchId,
         					   onlyCurrentRecord:false
        				   }
        				   periodStore.load({
        					   callback: function(records, operation, success) {
        						   if (success) {
        							   for(var i in records) {
        								   if(records[i].data.id == periodId) {
        									   periodField.setValue(records[i].data.id);
        								   } else if(records.length == 1){
        									   periodField.setValue(records[0].data.id);
        								   } else{
        									   var courseStore = courseField.getStore();
        									   courseStore.getProxy().extraParams = {
        										   studentId: studentId,
        										   batchId:batchId,
        										   isCurrentPeriod:false
        									   }
        									   courseStore.load();

        									   var facultyStore = facultyField.getStore();
        									   facultyStore.getProxy().extraParams = {
        										   batchId:batchId
        									   }
        									   facultyStore.load();
        								   }
        							   }
        							   if(isNullOrEmpty(periodField.getValue())) {
    									   var courseStore = courseField.getStore();
    									   courseStore.getProxy().extraParams = {
    										   studentId: studentId,
    										   batchId:batchId,
    										   isCurrentPeriod:false
    									   }
    									   courseStore.load();

    									   var facultyStore = facultyField.getStore();
    									   facultyStore.getProxy().extraParams = {
    										   batchId:batchId
    									   }
    									   facultyStore.load();
    								   }
        						   }
        					   }
        				   });
        			   },
        			   studentPeriodSelection : function(form, periodId) {
        				   var $this = this;
        				  var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        				  var academyLocationId = this.getCurrentAcademyLocation();
        				  var studentId = studentPortalInfo.student.id;
        				  
        				   var programField = form.down('#student_programId_New');
        				   var batchField = form.down('#student_batchId_New');
        				   var periodField = form.down('#periodId_student_New');
        				   var courseField = form.down('#courseCBSId1_New');
        				   var pbsSectionField = form.down('#student_programSectionId_New');
        				   var cbsSectionField = form.down('#student_courseSectionId_New');
        				   var facultyField = form.down('#facultyId_student_New');

        				   courseField.clearValue();
        				   pbsSectionField.clearValue();
        				   cbsSectionField.clearValue();
        				   facultyField.clearValue();

        				   pbsSectionField.setDisabled(false);
        				   cbsSectionField.setDisabled(true);

        				   pbsSectionField.setVisible(true);
        				   cbsSectionField.setVisible(false);

        				   var pbsSectionStore = pbsSectionField.getStore();
        				   pbsSectionStore.getProxy().extraParams = {
        					   studentId: studentId,
        					   periodId:periodId,
        					   onlyCurrentRecord:false
        				   }
        				   pbsSectionStore.load();
        				   
        				   var courseStore = courseField.getStore();
         				   courseStore.getProxy().extraParams = {
         					   studentId: studentId,
         					   periodId:periodId,
         					   isCurrentPeriod:false
         				   }
         				  courseField.lastQuery = null;
         				   
         				   var facultyStore = facultyField.getStore();
         				   facultyStore.getProxy().extraParams = {
         					   periodId:periodId
         				   }
         				   facultyStore.load();
        			   },
        			   studentCourseSelection : function(form, courseId) {
        				   var $this = this;
        				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        				   var academyLocationId = this.getCurrentAcademyLocation();
        				   var studentId = studentPortalInfo.student.id;

        				   var programField = form.down('#student_programId_New');
        				   var batchField = form.down('#student_batchId_New');
        				   var periodField = form.down('#periodId_student_New');
        				   var courseField = form.down('#courseCBSId1_New');
        				   var pbsSectionField = form.down('#student_programSectionId_New');
        				   var cbsSectionField = form.down('#student_courseSectionId_New');
        				   var facultyField = form.down('#facultyId_student_New');

        				   pbsSectionField.clearValue();
        				   cbsSectionField.clearValue();
        				   facultyField.clearValue();

        				   pbsSectionField.setDisabled(true);
        				   cbsSectionField.setDisabled(false);

        				   pbsSectionField.setVisible(false);
        				   cbsSectionField.setVisible(true);

        				   var cbsSectionStore = cbsSectionField.getStore();
        				   cbsSectionStore.getProxy().extraParams = {
        					   courseId:courseId,
        					   studentId: studentId,
        					   periodId:periodField.getValue(),
        					   programId:programField.getValue(),
        					   batchId:batchField.getValue(),
        					   isCurrentPeriod:false
        				   }
        				   cbsSectionField.lastQuery = null;
        				   
        				   var facultyStore = facultyField.getStore();
         				   facultyStore.getProxy().extraParams = {
         					   periodId:periodField.getValue(),
         					   courseId:courseId
         				   }
         				   facultyStore.load();
        			   },
        			   openDescriptionLinkWindow: function(record){
        				   var formWindow = this.getCoursesessiondocumentlinkwin();
        				   if (!formWindow) {
        					   formWindow =  Ext.widget('coursesessiondocumentlinkwin');
        					   //formWindow = this.getAssignedtopicdetailwindow();
        				   }
        				   formWindow.show();
        				   var grid = formWindow.down('#courseSessionDocumentlinkGrid');
        				   grid.getStore().removeAll();
        				   grid.getStore().add(record.data)

        			   }
});