/**
 * @author Dharmendra.p
 */
Ext.define('Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController', {
	extend: 'Academia.controller.base.BaseController',
    stores: ['programCourseDashboard.ManagementAccountingUnitsStore','programCourseDashboard.GetOrganizationUnits',
             'programCourseDashboard.GetOrganizationUnitALP','common.AcademyLocationNameSeparated'],
    //model: [],
    views: ['programCourseDashboard.organizationUnit.OrganizationUnit','baselayout.contentarea.ContentPanel'],
    
    refs: [{
        ref: 'organizationunit',
        selector: 'organizationunit'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    }],
    


    init: function(application) {
    	this.control({
    		/*'organizationunit radiogroup[itemId=organizationRadioUnitId]':{
    			change:function(obj,record){ 
    				this.organizationUnitChange(obj,record);
    			}
    		},
    		'organizationunit button[itemId=resetBtn]':{
    			click:function(obj,record){ 
    				this.resetOrganizationunit();
    			}
    		},*/
    	
    		'organizationunit customcombobox#mauId': {
    			select: function(obj, record) {
    				var mauId = record[0].get("id");
    				if(mauId > 0){
    					var form = this.getOrganizationunit();
    					form.down("#ouId").setVisible(true);
    					var store = this.getStore('programCourseDashboard.GetOrganizationUnits');
    					store.getProxy().extraParams = {
    						supervisoryUnitId: mauId,
    						onlyAccessible : true
    					};
    					store.load();
    				}
    			}
    		},
    		   'organizationunit customcombobox#ouId': {
    			   select: function(obj, record) {
    				   var ouId = record[0].get("id");
    				   if(ouId > 0){
    					   var form = this.getOrganizationunit();
    					   form.down("#academyLocationId").setDisabled(false);
    					   var academyLocationCombo = form.down("#academyLocationId");
    					   academyLocationCombo.store.load({
    						   params:{
    							   organizationUnitId: ouId,
    							   onlyAccessible : true
    						   },
    						   callback : function(records, operation, success) {
    							   if (success) {
    								   var academyLocationArray= [];
    								   if(records.length > 0){
    									   for (var i in records){
    										   academyLocationArray.push(records[i].data.id);
    									   }
    								   }
    								   academyLocationCombo.setValue(academyLocationArray);
    							   }
    						   }
    					   });
    				   }
    			   }
    		   }
    	});
    },
    organizationUnitChange:function(obj,record,permission){
    	var orgform = obj.up('form');
    	var organizationRadio =	orgform.getForm().findField('organizationRadioUnit');
        //var organizationRadioValue =	orgform.getForm().findField('organizationRadioUnit').getValue();
        
        var organizationRadioUnit;
        if(record != undefined  && record != null){
        	organizationRadioUnit = record.organizationRadioUnit;
        }else{
        	organizationRadioUnit = organizationRadio.inputValue;
        }
        
        
    	if(organizationRadioUnit == 'SU'){
    		orgform.down('#ouId').setVisible(true);
    		orgform.down('#mauId').setVisible(false);
    		orgform.down('#mauId').reset();
    		orgform.down('#academyLocationId').reset();
    		orgform.down('#academyLocationId').setValue(null);
    		orgform.down('#academyLocationId').setVisible(true);
    		orgform.down('#multiselectAcademyLocationId').setVisible(false);
    		orgform.down('#multiselectAcademyLocationId').reset();
    		orgform.down('#multiselectAcademyLocationId').setValue(null);
    		this.getSupervisionUnitId();
    	}else if(organizationRadioUnit == 'SAU'){
    		orgform.down('#ouId').setVisible(true);
    		orgform.down('#mauId').setVisible(false);
    		orgform.down('#ouId').reset();
    		orgform.down('#mauId').reset();
    		orgform.down('#academyLocationId').reset();
    		orgform.down('#academyLocationId').setValue(null);
    		orgform.down('#academyLocationId').setVisible(true);
    		orgform.down('#multiselectAcademyLocationId').setVisible(false);
    		orgform.down('#multiselectAcademyLocationId').reset();
    		orgform.down('#multiselectAcademyLocationId').setValue(null);
    		this.getStatutoryAccountingUnitId();
    	}else if(organizationRadioUnit == 'MU'){
    		orgform.down('#mauId').setVisible(true);
    		
    		var field = orgform.getForm().findField("mau");
    		var store = field.getStore();
    		store.getProxy().extraParams = {
			   onlyAccessible : true
		    };
		    store.load();
    		orgform.down('#ouId').setVisible(false);
    		orgform.down('#ouId').reset();
    		orgform.down('#academyLocationId').reset();
    		orgform.down('#academyLocationId').setValue(null);
    		orgform.down('#academyLocationId').setVisible(true);
    		orgform.down('#multiselectAcademyLocationId').setVisible(false);
    		orgform.down('#multiselectAcademyLocationId').reset();
    		orgform.down('#multiselectAcademyLocationId').setValue(null);
    	}else if(organizationRadioUnit == 'AL'){
    		orgform.down('#ouId').setVisible(false);
    		orgform.down('#mauId').setVisible(false);
    		orgform.down('#ouId').reset();
    		orgform.down('#mauId').reset();
    		orgform.down('#academyLocationId').setVisible(false);
    		orgform.down('#multiselectAcademyLocationId').setVisible(true);
    		orgform.down('#academyLocationId').setValue(null);
    		this.setAllAlIds(orgform,permission);
    	}
    },
    getSupervisionUnitId:function(){
    	var $this = this;
    	Ext.Ajax.request({
         type: 'rest',
         url: SERVERURL.ORG_SUP_UNIT_FIND_SUID,
         method: 'GET',
         success: function(form,action) {
        	 var suId = Ext.JSON.decode(form.responseText);
        	 var store = $this.getStore('programCourseDashboard.GetOrganizationUnits');
			   store.getProxy().extraParams = {
				   supervisoryUnitId: suId,
				   onlyAccessible : true
			   };
			   store.load();
         }
     });
    },
    getStatutoryAccountingUnitId:function(){
    	var $this = this;
    	Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.ORG_SUP_UNIT_FIND_SAUID,
            method: 'GET',
            success: function(form,action) {
           	 var sauId = Ext.JSON.decode(form.responseText);
            	var store = $this.getStore('programCourseDashboard.GetOrganizationUnits');
			   store.getProxy().extraParams = {
				   supervisoryUnitId: sauId,
				   onlyAccessible : true
			   };
			   store.load();
            }
        });
    },
    setAllAlIds:function(form,permission){
    	//var form = this.getOrganizationunit();
    	var $this = this;
		   var academyLocationCombo = form.down("#multiselectAcademyLocationId");
		   
		   academyLocationCombo.store.load({
  		   callback : function(records, operation, success) {
  			  if (success) {
  				  var academyLocationArray= [];
  				  
  				 var map;
  				 if(permission != undefined && permission != null){
  					 map = permission.map;

  					 var keys = [];
  					 for(var k in map) keys.push(k);
  					
  					 var academyLocationPrivilegeList = Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges();

  					 /*var data=parseInt(keys.join());
  					 for(var i in academyLocationPrivilegeList){
  						 var arrrray=Ext.Array.contains(academyLocationPrivilegeList[i].featurePrivileges,parseInt(data));
  						 if(arrrray){
  							 academyLocationArray.push(academyLocationPrivilegeList[i].accessibleAcademyLocation.academyLocationId);
  						 }
  					 }*/

  					 for(var i in academyLocationPrivilegeList){
  						 academyLocationArray.push(academyLocationPrivilegeList[i].accessibleAcademyLocation.academyLocationId);
  					 }

  					 /*for(var i in records){
  						 var arrrray=Ext.Array.contains(academyLocationArray,parseInt(records[i].data.id));
  						 if(!arrrray){
  							 academyLocationCombo.store.remove(records[i]);
  						 }
  					 }*/
  				 }

  				 try{
  					 if(this$.getActiveTabfromContentPanel().xtype!="dashboardmainstructure"){
  		 				academyLocationCombo.setValue(academyLocationArray);
  		 				academyLocationCombo.defaultValueBeforeReset = academyLocationArray;
  					 }
  					 if(this$.getActiveTabfromContentPanel().xtype=="examinationreports"){
	                    academyLocationCombo.expand();	
  						academyLocationCombo.setValue($this.getCurrentAcademyLocation());
				        academyLocationCombo.collapse();
  					 }
  				 }
  				 catch(e){
  	 				academyLocationCombo.setValue(academyLocationArray);
  				 }
  			  }
  			  
  		  }
  	  });  	
    },
    //V2D-469835
    resetOrganizationunitForDashborad:function(obj){
    	var form = obj.up('form');
    	var multiSelectAL = form.down('#multiselectAcademyLocationId');
    	form.getForm().reset();
    	form.down('#ouId').setValue(null);
    	form.down('#mauId').setValue(null);
    	form.down('#academyLocationId').setValue(null);
    	multiSelectAL.setValue(null);
    	form.down('#academyLocationId').setDisabled(true);    	
    	form.getForm().findField('multiselectAcademyLocation').onTrigger1Click();
    	if(!isNullOrEmpty(multiSelectAL.defaultValueBeforeReset)) {
    		multiSelectAL.setValue(multiSelectAL.defaultValueBeforeReset);
    	}
    	obj.blur();
    },
    resetOrganizationunit:function(obj){
    	var form = obj.up('form');
    	var multiSelectAL = form.down('#multiselectAcademyLocationId');
    	form.getForm().reset();
    	form.down('#ouId').setValue(null);
    	form.down('#mauId').setValue(null);
    	form.down('#academyLocationId').setValue(null);
    	multiSelectAL.setValue(null);
    	form.down('#academyLocationId').setDisabled(true);    	
    	form.getForm().findField('multiselectAcademyLocation').onTrigger1Click();
    	if(!isNullOrEmpty(multiSelectAL.defaultValueBeforeReset) && form.xtype != 'organizationunit') {
    		multiSelectAL.setValue(multiSelectAL.defaultValueBeforeReset);
    	}
    	obj.blur();
    },
    getAcademyLocationIds: function(){
    	var organizationUnitController =  Academia.app.getController('programCourseDashboard.organizationUnit.organizationUnitController');
    	if(organizationUnitController.getOrganizationunit()){
    		var organizationUnitForm = organizationUnitController.getOrganizationunit().getForm();
    		var academyLocation;
    		var values = organizationUnitForm.getValues();
    		var aL = values.academyLocation;
    		var mAL = values.multiselectAcademyLocation;

    		var alArray=[];
    		var mALArray=[];

    		if(aL !=undefined && aL.length > 0 && aL!=""){
    			for(var i in aL){
    				if(Ext.isObject(aL[0])){
    					alArray.push(aL[i].get("id"));
    				}else{
    					alArray.push(aL[i]);
    				}
    			}
    			academyLocation= alArray.join();

    		}else if(mAL !=undefined && mAL.length > 0 && mAL!=""){
    			for(var i in mAL){
    				if(Ext.isObject(mAL[0])){
    					mALArray.push(mAL[i].get("id"));
    				}else{
    					mALArray.push(mAL[i]);
    				}
    			}
    			academyLocation= mALArray.join();
    		}else{
    			academyLocation = this.getCurrentAcademyLocation();
    		}
    		return academyLocation;
    	}
    },
    
    getOrganizationUnitIds : function(){
    	   var object  = new Object();
    	   var organizationUnitForm = this.getOrganizationunit().getForm();
     	   var values = organizationUnitForm.getValues();
     	   if(values.organizationRadioUnit === 'SU'|| values.organizationRadioUnit === 'SAU'){
     		  object.ou = values.ou ;
     	   }
     	   if(values.organizationRadioUnit === 'MU'){
     		  object.mau = values.mau ;
     	   }
     	   return object;
    }
});