/**
 * 
 */
Ext.define('Academia.controller.registrationsetup.RegistrationTermSetupController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['common.AcademyLocationNameSeparated','common.AcademicTermStoreForIntakeYearId','registrationsetup.CourseRegistrationGridStore',
			'registrationsetup.RegistrationSetupNameComboStore','registrationsetup.RegistrationTermComboStore',
			'registrationsetup.RegistrationTermGridComboStore','registrationsetup.RegistrationSetupGridStore',
			'registrationsetup.RegistrationSetupProfileUpdateGridStore','documentmanagement.DocumentMasterStore','registrationsetup.RegistrationSetupMappedProgramPeriodStore',
			'registrationsetup.RegistrationSetupProgramComboStore','registrationsetup.RegistrationSetupBatchComboStore',
			'registrationsetup.RegistrationSetupPeriodComboStore','registrationsetup.RegistrationSetupRulesGridStore','registrationsetup.FeePlanNameStoreForRegistration','registrationsetup.FeePlanRuleStoreForRegistration',
			'registrationsetup.FeePlanTypeStoreForRegistration','registrationsetup.FeePlanStageStoreForRegistration'],
	views : ['baselayout.contentarea.ContentPanel','registrationsetup.RegistrationSetupStructure',
		'registrationsetup.RegistrationSetupTabStructure',
		'registrationsetup.RegistrationSetupFilter','registrationsetup.RegistrationSetupGrid',
		'registrationsetup.RegistrationSetupDetails','feeandpayment.adjustment.AdjustmentProgressTracker',
		'registrationsetup.RegistrationSetupDetailsTabPanel','registrationsetup.CourseRegistrationEditableGrid',
		'registrationsetup.RegistrationSetupProfileUpdateGrid','registrationsetup.RegistrationSetupDocumentGrid','registrationsetup.RegistrationSetupMappedProgramPeriodDetailsGrid',
		'registrationsetup.RegistrationSetupMappedProgramPeriodGrid','registrationsetup.RegistrationSetupCopyWindow',
		'registrationsetup.PreRegTabRegistrationSetupDetails',
		'registrationsetup.RegistrationContractTabRegistrationSetupDetails',
		'registrationsetup.RegistrationSetupConfigureAddressWindow',
		'registrationsetup.RegistrationSetupConfigureParentDetailsWindow',
		'registrationsetup.RegistrationRulesTabRegistrationSetupDetails',
		'registrationsetup.RegistrationGuidelinesRegSetup','registrationsetup.LateFeeConfigForm',
		'registrationsetup.RegistrationValidations'],
		config:{
			REGISTRATION_SETUP_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REGISTRATION_SETUP_PRIVILEGES')
		},	         
		refs : [
			{
				ref : 'registrationsetupstructure',
				selector : 'registrationsetupstructure'
			},{
				ref : 'registrationsetuptabstructure',
				selector : 'registrationsetuptabstructure'
			},{
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
				ref: 'registrationsetupfilter',
				selector: 'registrationsetupfilter'
			},{
				ref: 'registrationsetupgrid',
				selector: 'registrationsetupgrid'
			},{
				ref: 'registrationsetupdetails',
				selector: 'registrationsetupdetails'
			},{
				ref:'adjustmentprogresstracker',
				selector:'adjustmentprogresstracker'
			},{
				ref:'registrationsetupdetailstabpanel',
				selector:'registrationsetupdetailstabpanel'
			},{
				ref:'courseregistrationeditablegrid',
				selector:'courseregistrationeditablegrid'
			},{
				ref:'registrationsetupprofileupdategrid',
				selector:'registrationsetupprofileupdategrid'
			},{
				ref:'registrationsetupdocumentgrid',
				selector:'registrationsetupdocumentgrid'
			},{
				ref : 'registrationsetupmappedprogramperioddetailsgrid',
				selector : 'registrationsetupmappedprogramperioddetailsgrid'
			},{
				ref : 'registrationsetupmappedprogramperiodgrid',
				selector : 'registrationsetupmappedprogramperiodgrid'
			},{
				ref : 'registrationsetupcopywindow',
				selector : 'registrationsetupcopywindow'
			},{
				ref: 'preregtabregistrationsetupdetails',
				selector: 'preregtabregistrationsetupdetails'
			},{
				ref: 'registrationcontracttabregistrationsetupdetails',
				selector: 'registrationcontracttabregistrationsetupdetails'
			},{
				ref: 'registrationsetupconfigureaddresswindow',
				selector: 'registrationsetupconfigureaddresswindow'
			},{
				ref: 'registrationsetupconfigureparentdetailswindow',
				selector: 'registrationsetupconfigureparentdetailswindow'
			},{
				ref: 'registrationrulestabregistrationsetupdetails',
				selector: 'registrationrulestabregistrationsetupdetails'
			},{
				ref: 'registrationguidelinesregsetup',
				selector: 'registrationguidelinesregsetup'
			},{
				ref:'latefeeconfigform',
				selector:'latefeeconfigform'
			},{
				ref:'registrationvalidations',
				selector:'registrationvalidations'
			}],
			init : function() {
				this.control({
				 'registrationsetuptabstructure':{
						afterrender:function(structure){
							  var grid = structure.down('registrationsetupgrid');
				   				 this.getGridHeaderFreeze(grid,structure,true);
							
						}
					},
					'registrationsetupfilter' : {
						render : function(form) {
							var $this = this;
							var multiselectAcademyLocationId = form.down("#multiselectAcademyLocationId");
							var academicTerm = form.down("#academicTerm");
							var alIds=[];
							alIds.push(this.getCurrentAcademyLocation());
							var multiselectAcademyLocationStore=multiselectAcademyLocationId.getStore();
							multiselectAcademyLocationStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length > 0){
											multiselectAcademyLocationId.setValue(alIds);
										}		 
									}
								}
							});
							academicTerm.getStore().load({});
						}
					},
					'registrationsetupfilter multiselectcombofield#multiselectAcademyLocationId' : {
						change : function(obj, record) {
							var $this = this;
							var form=this.getRegistrationsetupfilter();
							var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
							var academicTermId = obj.up('form').down('#academicTerm').getValue();
							var programCombo = obj.up('form').down('#programId');				
							var batchComboBox = obj.up('form').down('#batchId');
							var periodComboBox = obj.up('form').down('#periodId');
							programCombo.reset();
							batchComboBox.reset();
							batchComboBox.setDisabled(true);
							periodComboBox.reset();
							periodComboBox.setDisabled(true);
							var alids=[];
							var academyLocationIds = null;

							if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
								for (var i in academyLocationId) {
									if (Ext.isObject(academyLocationId[0])) {
										alids.push(academyLocationId[i].get("id"));
									} else {
										alids.push(academyLocationId[i]);
									}
								}
								academyLocationIds = alids.join();
							}
							else if(!isNullOrEmpty(academyLocationId)){
								academyLocationIds = academyLocationId;
							}
							var programComboStore = programCombo.getStore();
							programComboStore.getProxy().extraParams = {
								academyLocationIds : academyLocationIds,
								academicTermId : academicTermId
							};
							//programComboStore.load();
						}
					},
					'registrationsetupfilter customcombobox#programId' : {
		     			select : function(obj, record) {
		     				var $this = this;
		     				var form=this.getRegistrationsetupfilter();
		     				var academicTermId = obj.up('form').down('#academicTerm').getValue();
		     				var programId = obj.up('form').down('#programId').getValue();				
		     				var batchComboBox = obj.up('form').down('#batchId');
		     				var periodComboBox = obj.up('form').down('#periodId');
		     				var registrationSetupCombo = obj.up('form').down('#registrationSetupNameId');
		     				var registrationTermCombo = obj.up('form').down('#registrationTermId');
		     				batchComboBox.reset();
		     				batchComboBox.setDisabled(false);
		     				periodComboBox.reset();
		     				periodComboBox.setDisabled(true);
		     				registrationSetupCombo.reset();
		     				registrationTermCombo.reset();
		     				var batchStore = batchComboBox.getStore();
		     				batchStore.getProxy().extraParams = {
		     					academicTermId : academicTermId,
		     					programId : programId
		     				};
		     				batchStore.load();
		     				var registrationSetupStore = registrationSetupCombo.getStore();
							registrationSetupStore.getProxy().extraParams = {
								academicTerm:academicTermId,
								programId:programId
							};
							registrationSetupStore.load();	
							
							var registrationTermStore = registrationTermCombo.getStore();
							registrationTermStore.getProxy().extraParams = {
								academicTerm:academicTermId,
								programId:programId
							};
							registrationTermStore.load();
		     			}
					},
					'registrationsetupfilter customcombobox#batchId' : {
		     			select : function(obj, record) {
		     				var $this = this;
		     				var form=this.getRegistrationsetupfilter();
		     				var academicTermId = obj.up('form').down('#academicTerm').getValue();
		     				var programId = obj.up('form').down('#programId').getValue();	
		     				var batchId = obj.up('form').down('#batchId').getValue();				
		     				var periodComboBox = obj.up('form').down('#periodId');
		     				var registrationSetupCombo = obj.up('form').down('#registrationSetupNameId');
		     				var registrationTermCombo = obj.up('form').down('#registrationTermId');
		     				periodComboBox.reset();
		     				periodComboBox.setDisabled(false);
		     				registrationSetupCombo.reset();
		     				registrationTermCombo.reset();
		     				var periodStore = periodComboBox.getStore();
		     				periodStore.getProxy().extraParams = {
		     					academicTermId : academicTermId,
		     					batchId : batchId
		     				};
		     				periodStore.load();
		     				var registrationSetupStore = registrationSetupCombo.getStore();
							registrationSetupStore.getProxy().extraParams = {
								academicTerm:academicTermId,
								programId:programId,
								batchId : batchId
							};
							registrationSetupStore.load();	
							
							var registrationTermStore = registrationTermCombo.getStore();
							registrationTermStore.getProxy().extraParams = {
								academicTerm:academicTermId,
								programId:programId,
								batchId : batchId
							};
							registrationTermStore.load();
		     			}
					},
					'registrationsetupfilter customcombobox#periodId' : {
		     			select : function(obj, record) {
		     				var $this = this;
		     				var form=this.getRegistrationsetupfilter();
		     				var academicTermId = obj.up('form').down('#academicTerm').getValue();
		     				var programId = obj.up('form').down('#programId').getValue();	
		     				var batchId = obj.up('form').down('#batchId').getValue();
		     				var periodId = obj.up('form').down('#periodId').getValue();
		     				var registrationSetupCombo = obj.up('form').down('#registrationSetupNameId');
		     				var registrationTermCombo = obj.up('form').down('#registrationTermId');
		     				registrationSetupCombo.reset();
		     				registrationTermCombo.reset();
		     				var registrationSetupStore = registrationSetupCombo.getStore();
							registrationSetupStore.getProxy().extraParams = {
								academicTerm:academicTermId,
								programId:programId,
								batchId : batchId,
								periodId : periodId
							};
							registrationSetupStore.load();	
							
							var registrationTermStore = registrationTermCombo.getStore();
							registrationTermStore.getProxy().extraParams = {
								academicTerm:academicTermId,
								programId:programId,
								batchId : batchId,
								periodId : periodId
							};
							registrationTermStore.load();
		     			}
					},
					'registrationsetupfilter button[itemId=resetBtn]' : {
						click : function(){
							this.resetRegistrationSetupFilter();
						}
					},
					'registrationsetupfilter button[itemId=searchBtn]' : {
						click : function(){
							this.loadRegistrationSetupGrid();
						}
					},
					'registrationsetupgrid button[itemId=btnAdd]':{
						click: function(button){
							this.addRegistrationSetupScreen('Add');
						}
					},
					'registrationsetupgrid button[itemId=btnEdit]':{
		    			click: this.editRegistrationSetupRecord
		    		},
					'registrationsetupgrid button[itemId=btnDelete]':{
		    			click: this.deleteRegistrationSetupRecord
		    		},
		    		'registrationsetupgrid button[itemId=btnCopySetup]':{
		    			click:function(obj){
           				 this.openRegistrationSetupCopyWindow();
           			 }
		    		},
		    		'registrationsetupcopywindow button[itemId=btnCancel]':{
		    			click : function() {
							this.getRegistrationsetupcopywindow().close();
						}
		    		},
		    		'registrationsetupcopywindow button[itemId=btnSubmit]':{
		    			click:function(){
		    				var $this = this;
           				    var copyForm = $this.getRegistrationsetupcopywindow();
           				    var mainJsonObj = new Object();
           				    var id = copyForm.down('#id').getValue();
           				    var academicTermId = copyForm.down('#academicTerm').getValue();
           				    var registrationSetupName = copyForm.down('#registrationSetupName').getValue();
           				    //var formValues = copyForm.getForm().getValues();
           				    var flag = true;
           				    if(!isNullOrEmpty(id) && !isNullOrEmpty(academicTermId)&& !isNullOrEmpty(registrationSetupName))
           				    {
           				    	academicTerm = {
           				    			id:academicTermId
           				    	},
           				    	mainJsonObj = {
           				    			id: id,
           				    			academicTerm:academicTerm,
           				    			registrationSetupName: registrationSetupName
           				    	}
           				    }
           				    else{
           				    	flag = false;
           				    }
           				 if(flag){
                 			var submitUrl = SERVERURL.PATH_COPY_REGISTRATION_TERM_SETUP_DETAIL;
                 			mainJsonObj = Ext.encode(mainJsonObj);
                     		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                     		Ext.Ajax.request({
                     			type : 'rest',
                     			url : submitUrl,
                     			jsonData : mainJsonObj,
                     			method : 'POST',
                     			success : function(form, action) {
                     				Ext.getBody().unmask();
                     				
                     				if(!isNullOrEmpty(form.responseText) && form.responseText == "Duplicate"){
                     					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REGISTRATION_SETUP_DUPLICATE_MSG'));
                     					$this.getRegistrationsetupcopywindow().close();
                     				}else{
                     					//var resData = Ext.JSON.decode(form.responseText);
                         				showSuccessMessage(getCommonTranslation('REGISTRATION_SETUP_DETAILS'),getCommonTranslation('SUCCESS'));
                         				$this.getRegistrationsetupcopywindow().close();
                         				$this.loadRegistrationSetupGrid();
                     				}
                     			},
                     			failure: function(form, action) {
                     				Ext.getBody().unmask();
                 					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
                     			}
                     		});
                 		}
                 		else{
                 			showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
                 		}
		    			}
		    		},
					'registrationsetupgrid':{
						render: function(grid){
		    				var $this = this;
		    				this.doAccessControlValidation(grid, this.getREGISTRATION_SETUP_PRIVILEGES_PERMISSIONS());
		    			},
		    			cellclick: function(View, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		    				var $this = this;
		    				var grid = $this.getRegistrationsetupgrid();
		    				var columnName = grid.columnManager.columns[cellIndex].dataIndex;

		    				if (e.target.tagName == 'A') {
		    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
		    					if(dataIndex == 'setupDetails'){
		    						$this.viewRegistrationSetupRecord(grid, "registrationTerm");
		    					}
		    				}
		    				
		    				if (e.target.tagName == 'A') {
		    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
		    					if(dataIndex == 'mappingDetails'){
		    						this.viewMappedProgramPeriodDetail(record, grid);
		    					}
		    				}
		    			},
						selectionchange: function(column, selected) {
		            		var grid = this.getRegistrationsetupgrid();
		            		if(selected.length== 1){ 
		            			grid.down('#btnEdit').setDisabled(false);
		            			grid.down('#btnDelete').setDisabled(false);
		            			grid.down('#btnCopySetup').setDisabled(false);
		            		}
		            		else{
		            			grid.down('#btnEdit').setDisabled(true);
		            			grid.down('#btnDelete').setDisabled(true);
		            			grid.down('#btnCopySetup').setDisabled(true);
		            		}
		            	}
					},
					
					'registrationsetupdetailstabpanel ckeditor#registrationCkEditorItemId':{
						afterrender: function(registrationEditor){
							var tabPanel = this.getRegistrationsetupdetailstabpanel();
						    var additionalSetupMsg = tabPanel.config.additionalSetupMsgString;
						    var tabPanelMode = tabPanel.down('#additionalSetupMode').getValue()
						    registrationEditor.on('instanceReady',function(edit){
						    	if(additionalSetupMsg && tabPanelMode== "edit_mode"){
						    		edit.editor.insertHtml(additionalSetupMsg);
						    	   }
						    	else if(additionalSetupMsg && tabPanelMode== "view_mode"){
						    		edit.editor.insertHtml(additionalSetupMsg);
						    		edit.editor.setReadOnly(true);
						    	}
						    });
						}
					},
					'registrationsetupdetailstabpanel ckeditor#registrationContractCkEditorItemId':{
						afterrender: function(registrationEditor){
							var tabPanel = this.getRegistrationsetupdetailstabpanel();
						    var additionalSetupMsg = tabPanel.config.registrationContractMsgContent;
						    var tabPanelMode = tabPanel.down('#additionalSetupMode').getValue()
						    registrationEditor.on('instanceReady',function(edit){
						    	if(additionalSetupMsg && tabPanelMode== "edit_mode"){
						    		edit.editor.insertHtml(additionalSetupMsg);
						    	   }
						    	else if(additionalSetupMsg && tabPanelMode== "view_mode"){
						    		edit.editor.insertHtml(additionalSetupMsg);
						    		edit.editor.setReadOnly(true);
						    	}
						    });
						}
					},
					'registrationsetupdetailstabpanel ckeditor#regGuidelineInstruction':{
						afterrender: function(registrationEditor){
							var tabPanel = this.getRegistrationsetupdetailstabpanel();
						    var tabPanelMode = tabPanel.down('#additionalSetupMode').getValue()
						    registrationEditor.on('instanceReady',function(edit){
						    	if(tabPanelMode== "view_mode"){
						    		edit.editor.setReadOnly(true);
						    	}
						    });
						}
					},
					'registrationsetupdetailstabpanel':{
						tabchange:function(tabPanel, newCard, oldCard, eOpts){
							var $this = this;
							var structure = this.getRegistrationsetupdetails();
							var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

							var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
							var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
							var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
							var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
							
							if(newCard.itemId == "courseRegistrationItemId"){
								var courseregistrationeditablegrid = $this.getCourseregistrationeditablegrid();
								if(oldCard.itemId != "profileUpdateItemId"){
									var profileUpdateTab = newCard.nextSibling();
									if(profileUpdateTab.isDisabled()){
										
										if(!isNullOrEmpty(periodRegVal)){
										}
									}
									else{
										
									}
								}
								if(courseregistrationeditablegrid.config.isView){
									courseregistrationeditablegrid.down('[dataIndex=addButton]').hide();
									courseregistrationeditablegrid.down('[dataIndex=deleteButton]').hide();
								}else{
									courseregistrationeditablegrid.down('[dataIndex=addButton]').show();
									courseregistrationeditablegrid.down('[dataIndex=deleteButton]').show();
								}
								
								if(!structure.config.isAddForm){
									progresstracker2.reset();
									progresstracker2.updateText('');
									progresstracker3.reset();
									progresstracker3.updateText('');
									progresstracker4.reset();
									progresstracker4.updateText('');
									
									progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker1.textEl.addCls("inProgressCss-progress-text");
									progresstracker1.updateText("Step 1 In Progress");
									
								}
							}
							else if(newCard.itemId == "profileUpdateItemId"){
								var hidProfileUpdateId = newCard.down('#hidProfileUpdateId').getValue();
								var registrationsetupprofileupdategrid = this.getRegistrationsetupprofileupdategrid();
								if(!isNullOrEmpty(hidProfileUpdateId)){
									var profileUpdateRecordVal = newCard.config.profileUpdateRecord;
									
									if(!isNullOrEmpty(profileUpdateRecordVal)){
										var profileUpdateApplicableId = newCard.down('#profileUpdateApplicableId');
										profileUpdateApplicableId.setValue(profileUpdateRecordVal.isProfileUpdateApplicable);
										
										var startDate = profileUpdateRecordVal.startDate;
										var endDate = profileUpdateRecordVal.endDate;
										
										var store = registrationsetupprofileupdategrid.getStore(); 
										if(store.data.items.length>0){
											store.data.items.forEach(function(storeItem){
												var index = store.find('sequenceNo',storeItem.data.sequenceNo);
												if(storeItem.data.isSelected) {
													registrationsetupprofileupdategrid.getSelectionModel().select(index,true);
												}
											});
										}
									}
								}
								if(!structure.config.isAddForm){
									progresstracker3.reset();
									progresstracker3.updateText('');
									progresstracker4.reset();
									progresstracker4.updateText('');
									
									for(var i = 0; i < 11; i ++ ){
										progresstracker1.updateProgress((i * 0.1), '');
									}
									progresstracker1.textEl.addCls("custom-progress-text");
									progresstracker1.textEl.removeCls("inProgressCss-progress-text");
									progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker2.textEl.addCls("inProgressCss-progress-text");
									progresstracker2.updateText("Step 2 In Progress");
									progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
									
								}
							}
							else if(newCard.itemId == "registrationDocumentItemId"){
								var hidregistrationDocumentId = newCard.down('#hidregistrationDocumentId').getValue();
								var registrationsetupdocumentgrid = $this.getRegistrationsetupdocumentgrid();
								if(!isNullOrEmpty(hidregistrationDocumentId)){
									if(!isNullOrEmpty(newCard.config.registrationDocumentRecord)){
										var termWiseRegistrationDocuments = newCard.config.registrationDocumentRecord.termWiseRegistrationDocuments;
										if(termWiseRegistrationDocuments.length>0){
											var ObjModel = [];
											var store = registrationsetupdocumentgrid.getStore();
											store.getProxy().extraParams = {
												isApplicableForStudent:true
											};
											store.removeAll();
											store.on('beforeload', function(st){
												st.getProxy().extraParams.limit = -1;
											});
											store.load({
												callback: function(records, operation, success) {
													if (success) {
														if(records.length > 0){
															termWiseRegistrationDocuments.forEach(function(docArry){
							            						var idVal = docArry.documentType.id;
							            						var recrd = store.findRecord('id',idVal);
							            						recrd.set('mandatory',docArry.isMandatory);
							            						recrd.set('value',docArry.documentType.value);
							            						var index = store.find('id',idVal);
							            						registrationsetupdocumentgrid.getSelectionModel().select(index,true);
							            					});
															registrationsetupdocumentgrid.bindStore(store);
														}		 
													}
												}
											});
										}
									}
								}else{
									var store = registrationsetupdocumentgrid.getStore();
									store.getProxy().extraParams = {
										isApplicableForStudent:true
									};
									store.removeAll();
									store.load();
								}
								
								if(!structure.config.isAddForm){
									progresstracker4.reset();
									progresstracker4.updateText('');
									for(var i = 0; i < 11; i ++ ){
										progresstracker2.updateProgress((i * 0.1), '');
										progresstracker1.updateProgress((i * 0.1), '');
									}
									progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker3.textEl.addCls("inProgressCss-progress-text");
									progresstracker3.updateText("Step 3 In Progress");
									progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker2.textEl.removeCls("inProgressCss-progress-text");
									progresstracker2.textEl.addCls("custom-progress-text");
									progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
									
									progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker1.textEl.removeCls("inProgressCss-progress-text");
									progresstracker1.textEl.addCls("custom-progress-text");
									progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
									
								}
							}
							else if(newCard.itemId == "additionalSetupItemId"){

								var hidregistrationDocumentId = newCard.down('#hidregistrationDocumentId').getValue();
								var registrationsetupdocumentgrid = $this.getRegistrationsetupdocumentgrid();
								
								
								if(!structure.config.isAddForm){
									for(var i = 0; i < 11; i ++ ){
										progresstracker3.updateProgress((i * 0.1), '');
										progresstracker2.updateProgress((i * 0.1), '');
										progresstracker1.updateProgress((i * 0.1), '');
									}
									progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker4.textEl.addCls("inProgressCss-progress-text");
									progresstracker4.updateText("Step 4 In Progress");
									
									progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker3.textEl.removeCls("inProgressCss-progress-text");
									progresstracker3.textEl.addCls("custom-progress-text");
									progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
									
									progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker2.textEl.removeCls("inProgressCss-progress-text");
									progresstracker2.textEl.addCls("custom-progress-text");
									progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
									
									progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
									progresstracker1.textEl.removeCls("inProgressCss-progress-text");
									progresstracker1.textEl.addCls("custom-progress-text");
									progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
									
								}
							
							}
						},
						render: function(window){
		    				var $this = this;
		    				var courseregistrationeditablegrid = $this.getCourseregistrationeditablegrid();
							courseregistrationeditablegrid.getStore().removeAll();
							$this.addPeriodRegistrationGridRecord(1);
		    				window.body.on('click', function() {
		    	    			//var filter = window.down('manageSchoolForm');
		    	    			//$this.hideInvalidIconFromField($this.getRegistrationsetupdetailstabpanel());
		    	    	       });
		    			}
					},
					'registrationsetupdetailstabpanel panel#periodRegistrationFormItemId button[itemId=periodRegistrationNextBtnId]':{
						click: function(button){
							this.nextBtnPeriodRegistration();
						}
					},
					'registrationsetupdetailstabpanel panel#periodRegistrationFormItemId button[itemId=updateCourseRegistrationBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('PERIOD_TAB');
						}
					},
					'registrationsetupdetailstabpanel panel#periodRegistrationFormItemId button[itemId=resetPeriodRegistrationBtn]':{
						click: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							var panel = btn.up('panel#periodRegistrationFormItemId');
							var periodStartDateId = panel.down('#periodStartDateId');
							var periodEndDateId = panel.down('#periodEndDateId');
							var whetherAutoApproved = panel.down('#whetherAutoApproved');
							var studentPeriodStartDateId = panel.down('#studentPeriodStartDateId');
							var studentPeriodEndDateId = panel.down('#studentPeriodEndDateId');
							var lateFeeApplicableId = panel.down('#whetherLateFeeApplicableId');
							periodStartDateId.reset();
							periodEndDateId.reset();
							whetherAutoApproved.reset();
							lateFeeApplicableId.reset();
							periodEndDateId.setMinValue(null);
							studentPeriodStartDateId.reset();
							studentPeriodEndDateId.reset();
							studentPeriodEndDateId.setMinValue(null);
							var tabItems = registrationsetupdetailstabpanel.items.items;
							if(tabItems.length>0){
								tabItems.forEach(function(obj){
									if(obj.itemId != "periodRegistrationItemId"){
										obj.setDisabled(true);
									}
								});
							}
							/*var courseRegistrationItemId = registrationsetupdetailstabpanel.down('#courseRegistrationItemId');
							courseRegistrationItemId.setDisabled(true);*/
							var registrationSetupDetails = this.getRegistrationsetupdetails();
							this.resetProgressTracker();
							var adjustmentprogresstracker = registrationSetupDetails.down("#adjustmentprogresstracker");
							var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
							progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
							progresstracker1.textEl.addCls("inProgressCss-progress-text");
							progresstracker1.updateText("Step 1 In Progress");
						}
					},
					 'courseregistrationeditablegrid':{
		 				 afterrender:function(grid){
		 					lateFeeArrayOfMultipleReg=[];
		 					var storeItems = grid.getStore().data.items;
		 	        		if(storeItems.length>0){
		 					Ext.each(storeItems, function(obj,indx) {
		 						lateFeeArrayOfMultipleReg[indx]=obj.data.lateFeeConfigurationSetUp[0];
		        			});
		 	        	 }
		 				 },
		 				 cellclick: function(grid1, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		 					 var $this = this;
		 					 var grid = $this.getCourseregistrationeditablegrid();
		 					 var columnName = grid.columnManager.columns[cellIndex].dataIndex;

		 					 if (e.target.tagName == 'DIV') {
		 						 if (columnName == "addButton") {
		 							 if (e.target.className == "addButtonClsForGridActionCls") {
		 								 if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
		 									 var serialNo;
		 									 if (grid.getStore() != null)
		 										 serialNo = grid.getStore().getCount();
		 									 this.addPeriodRegistrationGridRecord(serialNo + 1, record);
		 									 grid.store.totalCount=grid.store.count();
		 									 grid.getView().refresh();
		 								 }
		 							 }
		 						 } else if (columnName == "deleteButton") {
		 							 if (e.target.className == "deleteButtonClsForGridActionCls") {
		 								 if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
		 									lateFeeArrayOfMultipleReg.pop(rowIndex);
		 									 grid.getStore().removeAt(rowIndex);
		 									 var models = grid.getStore().getRange();
		 									 for (var i = 0; i < models.length; i++) {
		 										 models[i].data.serialNo = i + 1;
		 									 }
		 									 grid.getStore().loadRawData(models, true);
		 									 if(models.length == 0){
		 										 grid.down('#btnAdd').show();
		 										 grid.down('#fldContSaveItemId').hide();
		 									 }
		 								 }
		 							 }
		 						 }
		 					 }
		 					 else if (e.target.tagName == 'INPUT') {
		 						var dataIndex = grid1.getHeaderAtIndex(cellIndex).dataIndex;
		 						var checked = e.target.checked;
		 						 record.set(dataIndex,checked);
		 					 }else if(e.target.tagName == 'A'){
		 						 var regSetupPanel = this.getRegistrationsetupdetailstabpanel();
		 						 var storeItems = grid.getStore().data.items;
		 						 doResetFeeRuleCombo=true;
		 						 var tab = regSetupPanel.items.findBy(function(tab) {
		 							 return tab.title === getCommonTranslation('LATE_FEE_CONFIGURATION');
		 						 });
		 						 if(tab==null){
		 							 regSetupPanel.insert(1,{
		 								 xtype:'container',
		 								 itemId:'lateFeeConfigureId',
		 								 title: getCommonTranslation('LATE_FEE_CONFIGURATION'),
		 								 items:[{
		 									 xtype: 'latefeeconfigform',
		 									 border: false
		 								 }]
		 							 });
		 						 }else{
		 							var form = $this.getLatefeeconfigform();
		 							form.getForm().reset();
		 						 }
		 						 regSetupPanel.setActiveTab(1);
		 						 grid.config.rowIndex = rowIndex;
		 						 
		 						/*Code start to set data on late fee config form in edit mode*/
					        		if(storeItems.length>0){
					        			Ext.each(storeItems, function(obj,indx) {
					        				if(rowIndex==indx){
					        					 var form = $this.getLatefeeconfigform();
					        					if(obj.data.lateFeeConfigurationSetUp.length>0){
							        			      var data = obj.data.lateFeeConfigurationSetUp[0];
							        			      if(data != undefined){
							        			    	  form.down('#feePlanTypeId').setValue(data.feePlanType.id);
								        				  form.down('#feePlanNameId').getStore().load();
								        				  form.down('#feePlanRuleId').getStore().getProxy().extraParams={
															   "feePlanId":data.feePlan.id
														   };
								        				  form.down('#feePlanRuleId').getStore().load();
								        				  form.down('#feePlanNameId').setValue(data.feePlan.id);
								        				  form.down('#stageId').setValue(data.feeStageMaster.id);
								   						  form.down('#feePlanRuleId').setValue(data.feePlanRule.id);
								   						  doResetFeeRuleCombo=false;
								   						  form.down('#amountToBePaidId').setValue(data.amount);
								   						  form.down('#statusId').setValue(data.whetherActive);
								   						  form.down('#recordId').setValue(data.id);
								   						 if(!isNullOrEmpty(data.termwiseCourseRegistration)){
							 								 form.down('#termwiseCourseRegistrationId').setValue(data.termwiseCourseRegistration.id);
							 							 }
							        			      }
							        				}
					        				}
					        			});
					        		}
		 					 }
		 				 }
		 			 },
		 			'registrationsetupdetailstabpanel panel#courseRegistrationPnlItemId button[itemId=resetCourseRegistrationBtn]':{
						click: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							var courseregistrationeditablegrid = this.getCourseregistrationeditablegrid();
		            		var storeItems = courseregistrationeditablegrid.getStore().data.items;
		            		if(storeItems.length>0){
		            			storeItems.forEach(function(obj){
		            				obj.set("registrationTerm", '');
		            				obj.set("adminStartDate", '');
		            				obj.set("adminStartTime", '');
		            				obj.set("adminEndDate", '');
		            				obj.set("adminEndTime", '');
		            				obj.set("studentStartDate", '');
		            				obj.set("studentStartTime", '');
		            				obj.set("studentEndDate", '');
		            				obj.set("studentEndTime", '');
		            				obj.set("whetherAllowAdd", '');
		            				obj.set("whetherAllowDrop", '');
		            				obj.set("whetherAllowLateFee", '');
								});
		            		}
		            		courseregistrationeditablegrid.getView().refresh();
		            		
		            		var profileUpdateItemId = registrationsetupdetailstabpanel.down('#profileUpdateItemId');
		            		profileUpdateItemId.setDisabled(true);
		            		var registrationDocumentItemId = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
		            		registrationDocumentItemId.setDisabled(true);
							var registrationSetupDetails = this.getRegistrationsetupdetails();
							this.resetProgressTracker();
							this.setProgressTracker(0);
						}
					},
					'registrationsetupdetailstabpanel panel#courseRegistrationPnlItemId button[itemId=courseRegistrationNextBtnId]':{
						click: function(btn){
							this.nextBtnCourseRegistration();
						}
					},
					'registrationsetupdetailstabpanel panel#courseRegistrationPnlItemId button[itemId=submitCourseRegistrationBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('COURSE_TAB');
						}
					},
					'registrationsetupfilter combo#academicTerm':{
						select : function(obj,record){
							var this$ = this;
							var academyLocationVal = obj.up('form').down('#multiselectAcademyLocationId').getValue();
							var academicTermId = record[0].get('id');
							var form = this$.getRegistrationsetupfilter();
							var registrationSetupCombo=form.down("#registrationSetupNameId");
							var registrationTermCombo=form.down("#registrationTermId");
							var programCombo = obj.up('form').down('#programId');				
							var batchComboBox = obj.up('form').down('#batchId');
							var periodComboBox = obj.up('form').down('#periodId');
							programCombo.reset();
							batchComboBox.reset();
							batchComboBox.setDisabled(true);
							periodComboBox.reset();
							periodComboBox.setDisabled(true);
							registrationSetupCombo.reset();
							registrationSetupCombo.setDisabled(false);
							registrationTermCombo.reset();
							registrationTermCombo.setDisabled(false);
							var academyLocationIds = [];
							if(!isNullOrEmpty(academyLocationVal)) {
								Ext.each(academyLocationVal,function(locationId){
									if(typeof locationId=="number"){
										academyLocationIds.push(locationId);
									}else if(!isNullOrEmpty(locationId.data)){
										academyLocationIds.push(locationId.data.id);
									}
								});
							}
							var programComboStore = programCombo.getStore();
							programComboStore.getProxy().extraParams = {
								academyLocationIds : academyLocationIds,
								academicTermId : academicTermId
							};
							programComboStore.load();

							var registrationSetupStore = registrationSetupCombo.getStore();
							registrationSetupStore.getProxy().extraParams = {
								academicTerm:academicTermId
							};
							registrationSetupStore.load();	
							
							var registrationTermStore = registrationTermCombo.getStore();
							registrationTermStore.getProxy().extraParams = {
								academicTerm:academicTermId
							};
							registrationTermStore.load();	
							
						}
					},
					'registrationsetupfilter combo#registrationSetupNameId':{
						select : function(obj,record){
							var this$ = this;
							var registrationSetupNameId = record[0].get('id');
							var form = this$.getRegistrationsetupfilter();
							var registrationTermCombo=form.down("#registrationTermId");
							var academicTermId=form.down('#academicTerm').getValue();

							registrationTermCombo.reset();
							registrationTermCombo.setDisabled(false);

							var registrationTermStore = registrationTermCombo.getStore();
							registrationTermStore.getProxy().extraParams = {
								academicTerm:academicTermId,
								registrationSetupId:registrationSetupNameId
							};
							registrationTermStore.load();	
							
						}
					},
					'registrationsetupdetailstabpanel panel#profileUpdateFormItemId':{
						afterrender: function(pnl){
							this.disableProfileUpdateBtns(pnl,this.getREGISTRATION_SETUP_PRIVILEGES_PERMISSIONS());
						}
					},
					'registrationsetupdetailstabpanel panel#profileUpdateFormItemId button#configureAddressBtn' :{
						click: function(button) {
							var me = this;
							var win =  this.getRegistrationsetupconfigureaddresswindow();
			         		if (!win) {
			         			Ext.widget('registrationsetupconfigureaddresswindow');
			         			win = this.getRegistrationsetupconfigureaddresswindow();
			         		}
			         		win.show();
						}
					},
					'registrationsetupdetailstabpanel panel#profileUpdateFormItemId button#configureParentDetailsBtn' :{
						click: function(button) {
							var me = this;
							var win =  this.getRegistrationsetupconfigureparentdetailswindow();
			         		if (!win) {
			         			Ext.widget('registrationsetupconfigureparentdetailswindow');
			         			win = this.getRegistrationsetupconfigureparentdetailswindow();
			         		}
			         		win.show();
						}
					},
					'registrationsetupconfigureaddresswindow':{
						afterrender: function(win){
							var me = this;
							var grid = win.down('grid');
							var gridStore = grid.getStore();
							
							var registrationsetupdetails = me.getRegistrationsetupdetails();
							
							gridStore.getAt(0).set({
							    whetherMandatory: registrationsetupdetails.configureAddressData.CRNT['whetherMandatory'],
							    whetherVisible: registrationsetupdetails.configureAddressData.CRNT['whetherVisible']
							});
							gridStore.getAt(1).set({
							    whetherMandatory: registrationsetupdetails.configureAddressData.CRSPDNC['whetherMandatory'],
							    whetherVisible: registrationsetupdetails.configureAddressData.CRSPDNC['whetherVisible']
							});
							gridStore.getAt(2).set({
								whetherMandatory: registrationsetupdetails.configureAddressData.PRMNT['whetherMandatory'],
								whetherVisible: registrationsetupdetails.configureAddressData.PRMNT['whetherVisible']
							});
							gridStore.getAt(3).set({
								whetherMandatory: registrationsetupdetails.configureAddressData.OFC['whetherMandatory'],
								whetherVisible: registrationsetupdetails.configureAddressData.OFC['whetherVisible']
							});
							gridStore.getAt(4).set({
								whetherMandatory: registrationsetupdetails.configureAddressData.GOOGLE['whetherMandatory'],
								whetherVisible: registrationsetupdetails.configureAddressData.GOOGLE['whetherVisible']
							});
							
							for (var i = 0; i < gridStore.getCount(); i++) {
							    gridStore.getAt(i).commit();
							}
							
						}
					},
					'registrationsetupconfigureaddresswindow button[itemId=btnSubmit]':{
						click: function(btn){
							var me = this;
							var win = btn.up('window');
							var grid = win.down('grid');
							var gridStore = grid.getStore();
							var storeRecords = grid.getStore().getRange();
							
							var registrationsetupdetails = me.getRegistrationsetupdetails();
							
							registrationsetupdetails.configureAddressData = {
									'CRNT': {'whetherMandatory': gridStore.getAt(0).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(0).get('whetherVisible')},
									'CRSPDNC': {'whetherMandatory': gridStore.getAt(1).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(1).get('whetherVisible')},
									'PRMNT': {'whetherMandatory': gridStore.getAt(2).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(2).get('whetherVisible')},
									'OFC': {'whetherMandatory': gridStore.getAt(3).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(3).get('whetherVisible')},
									'GOOGLE': {'whetherMandatory': gridStore.getAt(4).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(4).get('whetherVisible')}
							};
							
							win.close();
						}
					},
					'registrationsetupconfigureparentdetailswindow':{
						afterrender: function(win){
							var me = this;
							var grid = win.down('grid');
							var gridStore = grid.getStore();
							
							var registrationsetupdetails = me.getRegistrationsetupdetails();
							
							gridStore.getAt(0).set({
							    whetherMandatory: registrationsetupdetails.configureParentData.PG1['whetherMandatory'],
							    whetherVisible: registrationsetupdetails.configureParentData.PG1['whetherVisible']
							});
							gridStore.getAt(1).set({
							    whetherMandatory: registrationsetupdetails.configureParentData.PG2['whetherMandatory'],
							    whetherVisible: registrationsetupdetails.configureParentData.PG2['whetherVisible']
							});
							gridStore.getAt(2).set({
								whetherMandatory: registrationsetupdetails.configureParentData.G['whetherMandatory'],
								whetherVisible: registrationsetupdetails.configureParentData.G['whetherVisible']
							});
							gridStore.getAt(3).set({
								whetherMandatory: registrationsetupdetails.configureParentData.LG['whetherMandatory'],
								whetherVisible: registrationsetupdetails.configureParentData.LG['whetherVisible']
							});
							gridStore.getAt(4).set({
								whetherMandatory: registrationsetupdetails.configureParentData.V1['whetherMandatory'],
								whetherVisible: registrationsetupdetails.configureParentData.V1['whetherVisible']
							});
							gridStore.getAt(5).set({
								whetherMandatory: registrationsetupdetails.configureParentData.V2['whetherMandatory'],
								whetherVisible: registrationsetupdetails.configureParentData.V2['whetherVisible']
							});
							
							for (var i = 0; i < gridStore.getCount(); i++) {
							    gridStore.getAt(i).commit();
							}
						}
					},
					'registrationsetupconfigureparentdetailswindow button[itemId=btnSubmit]':{
						click: function(btn){
							var me = this;
							var win = btn.up('window');
							var grid = win.down('grid');
							var gridStore = grid.getStore();
							var storeRecords = grid.getStore().getRange();
							
							var registrationsetupdetails = me.getRegistrationsetupdetails();
							
							registrationsetupdetails.configureParentData = {
									'PG1': {'whetherMandatory': gridStore.getAt(0).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(0).get('whetherVisible')},
									'PG2': {'whetherMandatory': gridStore.getAt(1).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(1).get('whetherVisible')},
									'G': {'whetherMandatory': gridStore.getAt(2).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(2).get('whetherVisible')},
									'LG': {'whetherMandatory': gridStore.getAt(3).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(3).get('whetherVisible')},
									'V1': {'whetherMandatory': gridStore.getAt(4).get('whetherMandatory'),
										'whetherVisible': gridStore.getAt(4).get('whetherVisible')},
										'V2': {'whetherMandatory': gridStore.getAt(5).get('whetherMandatory'),
											'whetherVisible': gridStore.getAt(5).get('whetherVisible')}
							};
							
							win.close();
						}
					},
					'registrationsetupdetailstabpanel panel#profileUpdateFormItemId checkbox#profileUpdateApplicableId' :{
						change: function(checkbox, newValue, oldValue) {
							var $this = this;
							var registrationsetupdetails = this.getRegistrationsetupdetails();
							var registrationsetupprofileupdategrid = this.getRegistrationsetupprofileupdategrid();
							var pnl = checkbox.up('#profileUpdateFormItemId');
							var configureAddressBtn = pnl.down('#configureAddressBtn');
							if (newValue) {
								pnl.down('#fldConProfileUpdate').setVisible(true);
								var updateProfileGrid = pnl.down('registrationsetupprofileupdategrid');
								var uPGSelectedRec = updateProfileGrid.getSelectionModel().getSelection();
								if(uPGSelectedRec.length){
									var linkNameArray = Ext.Array.pluck(Ext.Array.pluck(uPGSelectedRec,'data'),'linkName');
									if(linkNameArray.indexOf("Address") != -1){
										configureAddressBtn.setDisabled(false);
									}
									else{
										configureAddressBtn.setDisabled(true);
									}
								}
								else{
									configureAddressBtn.setDisabled(true);
								}
							}else{
								pnl.down('#fldConProfileUpdate').setVisible(false);
								configureAddressBtn.setDisabled(true);
							}
							var index = registrationsetupprofileupdategrid.getStore().find('sequenceNo',1);
		            		registrationsetupprofileupdategrid.getSelectionModel().select(index,true);
							registrationsetupdetails.getForm().checkValidity();
						}
					},
					'registrationsetupdetailstabpanel panel#profileUpdateFormItemId button[itemId=resetProfileUpdateBtn]':{
						click: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							var registrationSetupDetails = this.getRegistrationsetupdetails();
							var registrationsetupprofileupdategrid = this.getRegistrationsetupprofileupdategrid();
							var panel = btn.up('panel#profileUpdateFormItemId');
						//	var profileUpdateStartDateId = panel.down('#profileUpdateStartDateId');
						//	var profileUpdateEndDateId = panel.down('#profileUpdateEndDateId');
							//profileUpdateStartDateId.reset();
							//profileUpdateEndDateId.reset();
						//	profileUpdateEndDateId.setMinValue(null);
							var profileUpdateApplicableId = panel.down('#profileUpdateApplicableId');
							profileUpdateApplicableId.setValue(false);
							var tabItems = registrationsetupdetailstabpanel.items.items;
							if(tabItems.length>0){
								tabItems.forEach(function(obj){
									if(obj.itemId == "registrationDocumentItemId"){
										obj.setDisabled(true);
									}
								});
							}
							
							Ext.Ajax.request({
								method : "GET",
								type : 'rest',
								url : SERVERURL.PATH_GET_PROFILE_LINK_GRID_DATA,
								success : function(form,action) {
									if(!isNullOrEmpty(form.responseText)){
										var data = Ext.JSON.decode(form.responseText);
										if(data.length>0){
											var ObjModel = [];
											registrationsetupprofileupdategrid.getStore().removeAll();
											data.forEach(function(obj){
												var registrationSetupProfileUpdateGridModel = new Academia.model.registrationsetup.RegistrationSetupProfileUpdateGridModel();
												registrationSetupProfileUpdateGridModel.set("id", obj.id);
												registrationSetupProfileUpdateGridModel.set("linkName", obj.value);
												registrationSetupProfileUpdateGridModel.set("sequenceNo", obj.sequence);
												registrationSetupProfileUpdateGridModel.commit();
							            		ObjModel.push(registrationSetupProfileUpdateGridModel);
											});
						            		registrationsetupprofileupdategrid.getStore().loadRawData(ObjModel, true);
						            		registrationsetupprofileupdategrid.getView().refresh();
						            		
						            		
										}
									}
								}
							});
							
							//this.resetProgressTracker();
							//this.setProgressTracker(2);
							registrationSetupDetails.getForm().checkValidity();
						}
					},
					'registrationsetupdetailstabpanel panel#profileUpdateFormItemId button[itemId=submitProfileUpdateBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('PROFILE_TAB');
						}
					},
					'registrationsetupdetailstabpanel panel#profileUpdateFormItemId button[itemId=profileUpdateNextBtnId]':{
						click: function(btn){
							this.nextBtnProfileUpdate();
						}
					},
					'registrationsetupdetailstabpanel panel#registrationDocumentFormItemId checkbox#registrationDocumentApplicableId' :{
						change: function(checkbox, newValue, oldValue) {
							var $this = this;
							var registrationsetupdetails = this.getRegistrationsetupdetails();
							var pnl = checkbox.up('#registrationDocumentFormItemId');
						
							if (newValue) {
								pnl.down('#fldConRegDocument').setVisible(true);
								
							}else{
								pnl.down('#fldConRegDocument').setVisible(false);
							}
							//registrationsetupdetails.getForm().checkValidity();
						}
					},
					'registrationsetupdetailstabpanel panel#registrationDocumentFormItemId button[itemId=registrationDocumentNextBtnId]':{
						click: function(btn){
							this.nextBtnRegistrationDocument(btn);
						}
					},
					'registrationsetupdetailstabpanel panel#registrationDocumentFormItemId button[itemId=submitRegistrationDocumentBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('DOCUMENT_TAB');
						}
					},
					'registrationsetupdetailstabpanel panel#registrationDocumentFormItemId button[itemId=resetRegistrationDocumentBtn]':{
						click: function(btn){
							var panel = btn.up('panel#registrationDocumentFormItemId');
							var registrationDocumentApplicableId = panel.down('#registrationDocumentApplicableId');
							registrationDocumentApplicableId.setValue(false);
							var registrationsetupdocumentgrid = this.getRegistrationsetupdocumentgrid();
							registrationsetupdocumentgrid.getStore().getProxy().extraParams = {
								isApplicableForStudent:true
							};
							registrationsetupdocumentgrid.getStore().removeAll();
							registrationsetupdocumentgrid.getStore().load();
						}
					},
					'registrationsetupdetailstabpanel container#additionalSetupItemId tabpanel[itemId=additionalSetupTabPanelItemId]':{
						tabchange:function(tabPanel, newCard, oldCard, eOpts){
							var $this = this;
							if(newCard.xtype == "registrationrulestabregistrationsetupdetails"){
								newCard.isOpened = true;
							}
						}
					},
					'registrationsetupdetailstabpanel container#additionalSetupItemId':{
						afterrender: function(pnl){
							var me = this;
							
							var associatedAcadLocationIds = new Array();
							associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
							var privilegeList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getREGISTRATION_SETUP_PRIVILEGES_PERMISSIONS());
							
							var additionalSetupTabPanel = pnl.down('tabpanel'); 
							Ext.each(privilegeList, function(privilege) {
								if (privilege === 'REGISTRATION_RULES') {
									additionalSetupTabPanel.add(Ext.widget('registrationrulestabregistrationsetupdetails',{
										itemId: 'registrationRulesAdditionalSetupTab',
										title: getCommonTranslation('REGISTRATION_RULES')
									}));
								} 
					    	});
							additionalSetupTabPanel.down('#nextRegistrationContractAdditionalSetupBtn').setVisible(true);
							additionalSetupTabPanel.add(Ext.widget('registrationvalidations',{
								itemId: 'registrationvalidationsItemId',
								title: getCommonTranslation('REGISTRATION_VALIDATIONS')
							}));
							additionalSetupTabPanel.add(Ext.widget('registrationguidelinesregsetup',{
								itemId: 'registrationguidelinesregsetupItemId',
								title: getCommonTranslation('REGISTRATION_GUIDELINE')
							}));
						}
					},
					'registrationrulestabregistrationsetupdetails':{
						afterrender: function(pnl){
							var me = this;
							var registrationRulesGrid = pnl.down('grid');
							var registrationRulesGridStore = registrationRulesGrid.getStore();
							var yearlyRecord=registrationRulesGridStore.findRecord('code','YEARLY_REGISTRATIONS_APPLICABLE');
							registrationRulesGridStore.removeAt(yearlyRecord.index);
							registrationRulesGridStore.insert(0,yearlyRecord.data);
							
							var registrationsetupdetails = this.getRegistrationsetupdetails();
							var registrationRules = registrationsetupdetails.registrationRules;
							var gridSelection = [];
							Ext.each(registrationRules, function(currentRule){
								if(currentRule.whetherMandatory == true){
									var ruleRecord = registrationRulesGrid.store.findRecord('value',currentRule.registrationRule);
									if(ruleRecord){
										gridSelection.push(ruleRecord);
									}
								}
							});
							if(gridSelection.length){
								registrationRulesGrid.getSelectionModel().select(gridSelection);
							}
						}
					},
					'registrationvalidations':{
						afterrender: function(pnl){
							var me = this;

							var registrationsetupdetails = this.getRegistrationsetupdetails();
							var registrationValidations = registrationsetupdetails.registrationValidations;
							
							var mandatoryChecksBypassValue = false;
							var minCoursesCourseGroupChecksBypassValue = false;
							var yearlyMinCreditChecksBypassValue  = false;
							var minCreditChecksForCourseGroupBypassValue = false;
							var minCourseGroupChecksBypassValue = false;
							var moduleGroupChecksBypassValue = false;

							///----
							if(Ext.isDefined(registrationValidations)){
								for (var i = 0; i < registrationValidations.length; i++) {
									if (registrationValidations[i].registrationValidation === "mandatoryChecksBypass") {
										mandatoryChecksBypassValue = registrationValidations[i].whetherMandatory;
										break;
									}
								}

								for (var i = 0; i < registrationValidations.length; i++) {
									if (registrationValidations[i].registrationValidation === "minCoursesCourseGroupChecksBypass") {
										minCoursesCourseGroupChecksBypassValue = registrationValidations[i].whetherMandatory;
										break;
									}
								}

								for (var i = 0; i < registrationValidations.length; i++) {
									if (registrationValidations[i].registrationValidation === "yearlyMinCreditChecksBypass") {
										yearlyMinCreditChecksBypassValue = registrationValidations[i].whetherMandatory;
										break;
									}
								}

								for (var i = 0; i < registrationValidations.length; i++) {
									if (registrationValidations[i].registrationValidation === "minCreditChecksForCourseGroupBypass") {
										minCreditChecksForCourseGroupBypassValue = registrationValidations[i].whetherMandatory;
										break;
									}
								}
								
								for (var i = 0; i < registrationValidations.length; i++) {
									if (registrationValidations[i].registrationValidation === "minCourseGroupChecksBypass") {
										minCourseGroupChecksBypassValue = registrationValidations[i].whetherMandatory;
										break;
									}
								}
								
								for (var i = 0; i < registrationValidations.length; i++) {
									if (registrationValidations[i].registrationValidation === "moduleGroupChecksBypass") {
										moduleGroupChecksBypassValue = registrationValidations[i].whetherMandatory;
										break;
									}
								}
							}
							else{
								registrationsetupdetails.registrationValidations = [{
			        	            "id": "",
			        	            "whetherMandatory": false,
			        	            "registrationValidation": "mandatoryChecksBypass"
			        	        },
			        	        {
			        	            "id": "",
			        	            "whetherMandatory": false,
			        	            "registrationValidation": "minCoursesCourseGroupChecksBypass"
			        	        },
			        	        {
			        	            "id": "",
			        	            "whetherMandatory": false,
			        	            "registrationValidation": "yearlyMinCreditChecksBypass"
			        	        },
			        	        {
			        	            "id": "",
			        	            "whetherMandatory": false,
			        	            "registrationValidation": "minCreditChecksForCourseGroupBypass"
			        	        },
			        	        {
			        	            "id": "",
			        	            "whetherMandatory": false,
			        	            "registrationValidation": "minCourseGroupChecksBypass"
			        	        },
			        	        {
			        	            "id": "",
			        	            "whetherMandatory": false,
			        	            "registrationValidation": "moduleGroupChecksBypass"
			        	        }];
							}
							
							var mandatoryChecksBypass = pnl.down('#mandatoryChecksBypass');
							var minCoursesCourseGroupChecksBypass = pnl.down('#minCoursesCourseGroupChecksBypass');
							var yearlyMinCreditChecksBypass = pnl.down('#yearlyMinCreditChecksBypass');
							var minCreditChecksForCourseGroupBypass = pnl.down('#minCreditChecksForCourseGroupBypass');
							var minCourseGroupChecksBypass = pnl.down('#minCourseGroupChecksBypass');
							var moduleGroupChecksBypass = pnl.down('#moduleGroupChecksBypass');
							
							mandatoryChecksBypass.setValue(mandatoryChecksBypassValue);
							minCoursesCourseGroupChecksBypass.setValue(minCoursesCourseGroupChecksBypassValue);
							yearlyMinCreditChecksBypass.setValue(yearlyMinCreditChecksBypassValue);
							minCreditChecksForCourseGroupBypass.setValue(minCreditChecksForCourseGroupBypassValue);
							minCourseGroupChecksBypass.setValue(minCourseGroupChecksBypassValue);
							moduleGroupChecksBypass.setValue(moduleGroupChecksBypassValue);
						}
					}, 
					'registrationvalidations checkboxfield[itemId=mandatoryChecksBypass]':{
						change: function(checkbox, newValue, oldValue) {
							this.updateValidationsValues();
						}
					},
					'registrationvalidations checkboxfield[itemId=minCoursesCourseGroupChecksBypass]':{
						change: function(checkbox, newValue, oldValue) {
							this.updateValidationsValues();
						}
					},
					'registrationvalidations checkboxfield[itemId=yearlyMinCreditChecksBypass]':{
						change: function(checkbox, newValue, oldValue) {
							this.updateValidationsValues();
						}
					},
					'registrationvalidations checkboxfield[itemId=minCreditChecksForCourseGroupBypass]':{
						change: function(checkbox, newValue, oldValue) {
							this.updateValidationsValues();
						}
					},
					'registrationvalidations checkboxfield[itemId=minCourseGroupChecksBypass]':{
						change: function(checkbox, newValue, oldValue) {
							this.updateValidationsValues();
						}
					},
					'registrationvalidations checkboxfield[itemId=moduleGroupChecksBypass]':{
						change: function(checkbox, newValue, oldValue) {
							this.updateValidationsValues();
						}
					},
					'registrationrulestabregistrationsetupdetails grid':{
						selectionchange: function(column, selected) {
		            		var grid = column.view.up('grid');
		            		var yearlyFieldsPanel = (Ext.ComponentQuery.query('#yearlyFieldsPanel').length) ? Ext.ComponentQuery.query('#yearlyFieldsPanel')[Ext.ComponentQuery.query('#yearlyFieldsPanel').length-1] : null;
		            		var yearlyGroupPanel = (Ext.ComponentQuery.query('#yearlyGroupPanel').length) ? Ext.ComponentQuery.query('#yearlyGroupPanel')[Ext.ComponentQuery.query('#yearlyGroupPanel').length-1] : null;
		            		
		            		var registrationrulestabregistrationsetupdetails = this.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							if(!isNullOrEmpty(yearlyFieldsPanel) && selected.length && Ext.Array.contains(Ext.Array.pluck(Ext.Array.pluck(selected,'data'),'code'),'YEARLY_REGISTRATIONS_APPLICABLE')){
								yearlyFieldsPanel.setVisible(true);
		            			//this.setAllowBlank(maxAdditionalCCNumberField, false);
		            			/*if(isNullOrEmpty(maxAdditionalCCNumberField.getValue())){
									submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
		            			}*/
		            		}
		            		else if(!isNullOrEmpty(yearlyFieldsPanel)){
		            			yearlyFieldsPanel.setVisible(false);
		            			/*this.setAllowBlank(maxAdditionalCCNumberField, true);
		            			submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);*/
		            		}
							
							if(!isNullOrEmpty(yearlyGroupPanel) && selected.length && Ext.Array.contains(Ext.Array.pluck(Ext.Array.pluck(selected,'data'),'code'),'COURSE_GROUP')){
								yearlyGroupPanel.setVisible(true);
		            		}
		            		else if(!isNullOrEmpty(yearlyGroupPanel)){
		            			yearlyGroupPanel.setVisible(false);
		            		}
		            	}
					},
					'container[itemId=yearlyFieldsPanel]':{
						afterrender: function(panel){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var grid = registrationrulestabregistrationsetupdetails.down('grid');
							var selectedRecords = grid.getSelectionModel().getSelection();
							var registrationrulestabregistrationsetupdetails = this.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var registrationsetupdetails = this.getRegistrationsetupdetails();
							var registrationRules = registrationsetupdetails.registrationRules;
							
							var minimumCreditNumberField = panel.down('#minNumberOfCreditYearly');
							var maximumCreditNumberField = panel.down('#maxNumberOfCreditYearly');
							
							var maxRegularCourseCreditYearlyField = panel.down('#maxRegularCourseCreditYearly');
							var maxOtherCourseCreditYearlyField = panel.down('#maxOtherCourseCreditYearly');
							
							if(selectedRecords.length && Ext.Array.contains(Ext.Array.pluck(Ext.Array.pluck(selectedRecords,'data'),'code'),'YEARLY_REGISTRATIONS_APPLICABLE')){
								panel.setVisible(true);
								Ext.each(registrationRules, function(currentRule){
									if(currentRule.whetherMandatory == true && currentRule.registrationRule == "Yearly Registrations Applicable"){
										maximumCreditNumberField.setValue(currentRule.maximumCredit);
										minimumCreditNumberField.setValue(currentRule.minimumCredit);
										
										maxRegularCourseCreditYearlyField.setValue(currentRule.maxCreditForRegularCourses);
										maxOtherCourseCreditYearlyField.setValue(currentRule.maxCreditForABRCourses);
									}
								});
							}
							else{
								panel.setVisible(false);
							}
						}
					},
					'container[itemId=yearlyGroupPanel]':{
						afterrender: function(panel){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var grid = registrationrulestabregistrationsetupdetails.down('grid');
							var selectedRecords = grid.getSelectionModel().getSelection();
							var registrationrulestabregistrationsetupdetails = this.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var registrationsetupdetails = this.getRegistrationsetupdetails();
							var registrationRules = registrationsetupdetails.registrationRules;
							
							var minNumberCourseGroupField = panel.down('#minNumberCourseGroupField');
							var maxNumberCourseGroupField = panel.down('#maxNumberCourseGroupField');
							
							if(selectedRecords.length && Ext.Array.contains(Ext.Array.pluck(Ext.Array.pluck(selectedRecords,'data'),'code'),'COURSE_GROUP')){
								panel.setVisible(true);
								Ext.each(registrationRules, function(currentRule){
									if(currentRule.whetherMandatory == true && currentRule.registrationRule == "Course Group"){
										minNumberCourseGroupField.setValue(currentRule.minimumModuleGroup);
										maxNumberCourseGroupField.setValue(currentRule.maximumModuleGroup);
									}
								});
							}
							else{
								panel.setVisible(false);
							}
						}
					},
					'numberfield[itemId=minNumberCourseGroupField]':{
						change: function(numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var minNumberCourseGroupField = (Ext.ComponentQuery.query("#minNumberCourseGroupField").length) ? Ext.ComponentQuery.query("#minNumberCourseGroupField")[Ext.ComponentQuery.query("#minNumberCourseGroupField").length-1] : null;
							var maxNumberCourseGroupField = (Ext.ComponentQuery.query("#maxNumberCourseGroupField").length) ? Ext.ComponentQuery.query("#maxNumberCourseGroupField")[Ext.ComponentQuery.query("#maxNumberCourseGroupField").length-1] : null;
							
							if(!isNullOrEmpty(minNumberCourseGroupField) && !isNullOrEmpty(maxNumberCourseGroupField)){
								var minNumberCourseGroupFieldVal = minNumberCourseGroupField.getValue();
								var maxNumberCourseGroupFieldVal = maxNumberCourseGroupField.getValue();
								
									if(!isNullOrEmpty(minNumberCourseGroupFieldVal) &&	isNullOrEmpty(maxNumberCourseGroupFieldVal)){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(isNullOrEmpty(minNumberCourseGroupFieldVal) &&	!isNullOrEmpty(maxNumberCourseGroupFieldVal)){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(!minNumberCourseGroupField.isValid() || !maxNumberCourseGroupField.isValid()){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(!isNullOrEmpty(minNumberCourseGroupFieldVal) &&	!isNullOrEmpty(maxNumberCourseGroupFieldVal) && minNumberCourseGroupFieldVal>maxNumberCourseGroupFieldVal){
										//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Min Course group cannot be greater than max course group'));
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else{
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
									}
								}
							
							else{
								submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
							}
						}
					},
					'numberfield[itemId=maxNumberCourseGroupField]':{
						change: function(numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var minNumberCourseGroupField = (Ext.ComponentQuery.query("#minNumberCourseGroupField").length) ? Ext.ComponentQuery.query("#minNumberCourseGroupField")[Ext.ComponentQuery.query("#minNumberCourseGroupField").length-1] : null;
							var maxNumberCourseGroupField = (Ext.ComponentQuery.query("#maxNumberCourseGroupField").length) ? Ext.ComponentQuery.query("#maxNumberCourseGroupField")[Ext.ComponentQuery.query("#maxNumberCourseGroupField").length-1] : null;
							
							if(!isNullOrEmpty(minNumberCourseGroupField) && !isNullOrEmpty(maxNumberCourseGroupField)){
								var minNumberCourseGroupFieldVal = minNumberCourseGroupField.getValue();
								var maxNumberCourseGroupFieldVal = maxNumberCourseGroupField.getValue();
								
									if(!isNullOrEmpty(minNumberCourseGroupFieldVal) &&	isNullOrEmpty(maxNumberCourseGroupFieldVal)){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(isNullOrEmpty(minNumberCourseGroupFieldVal) &&	!isNullOrEmpty(maxNumberCourseGroupFieldVal)){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(!minNumberCourseGroupField.isValid() || !maxNumberCourseGroupField.isValid()){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(!isNullOrEmpty(minNumberCourseGroupFieldVal) &&	!isNullOrEmpty(maxNumberCourseGroupFieldVal) && minNumberCourseGroupFieldVal>maxNumberCourseGroupFieldVal){
										//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Min Course group cannot be greater than max course group'));
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else{
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
									}
								
							}
							else{
								submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
							}
						}
					},
					'numberfield[itemId=minNumberOfCreditYearly]':{
						change: function(numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var minimumCredit = (Ext.ComponentQuery.query("#minNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#minNumberOfCreditYearly")[Ext.ComponentQuery.query("#minNumberOfCreditYearly").length-1] : null;
							var maximumCredit = (Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#maxNumberOfCreditYearly")[Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length-1] : null;
							
							if(!isNullOrEmpty(minimumCredit) && !isNullOrEmpty(maximumCredit)){
								var minimumCreditVal = minimumCredit.getValue();
								var maximumCreditVal = maximumCredit.getValue();
								if(isNullOrEmpty(minimumCreditVal) && isNullOrEmpty(maximumCreditVal)){
									submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
									me.setAllowBlank(minimumCredit, true);
									me.setAllowBlank(maximumCredit, true);
								}
								else{
									me.setAllowBlank(minimumCredit, false);
									me.setAllowBlank(maximumCredit, false);
									if(!isNullOrEmpty(minimumCreditVal) &&	isNullOrEmpty(maximumCreditVal)){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(isNullOrEmpty(minimumCreditVal) &&	!isNullOrEmpty(maximumCreditVal)){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(!minimumCredit.isValid() || !maximumCredit.isValid()){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(!isNullOrEmpty(minimumCreditVal) &&	!isNullOrEmpty(maximumCreditVal) && minimumCreditVal>maximumCreditVal){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else{
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
									}
								}
							}
							else{
								submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
							}
						}
					},
					'numberfield[itemId=maxNumberOfCreditYearly]':{
						change: function(numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var minimumCredit = (Ext.ComponentQuery.query("#minNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#minNumberOfCreditYearly")[Ext.ComponentQuery.query("#minNumberOfCreditYearly").length-1] : null;
							var maximumCredit = (Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#maxNumberOfCreditYearly")[Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length-1] : null;
							var maxRegularCredit = (Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxRegularCourseCreditYearly")[Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length-1] : null;
							var maxOtherCredit = (Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxOtherCourseCreditYearly")[Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length-1] : null;
						
							
							if(!isNullOrEmpty(minimumCredit) && !isNullOrEmpty(maximumCredit)){
								var minimumCreditVal = minimumCredit.getValue();
								var maximumCreditVal = maximumCredit.getValue();
								if(isNullOrEmpty(minimumCreditVal) && isNullOrEmpty(maximumCreditVal)){
									submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
									me.setAllowBlank(minimumCredit, true);
									me.setAllowBlank(maximumCredit, true);
								}
								else{
									me.setAllowBlank(minimumCredit, false);
									me.setAllowBlank(maximumCredit, false);
									if(!isNullOrEmpty(minimumCreditVal) &&	isNullOrEmpty(maximumCreditVal)){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(isNullOrEmpty(minimumCreditVal) &&	!isNullOrEmpty(maximumCreditVal)){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(!minimumCredit.isValid() || !maximumCredit.isValid()){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else if(!isNullOrEmpty(minimumCreditVal) &&	!isNullOrEmpty(maximumCreditVal) && minimumCreditVal>maximumCreditVal){
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
									}
									else{
										submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
									}
								}
							}
							else{
								submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
							}
							
							if(numberfield.hasFocus && !isNullOrEmpty(maxRegularCredit) && !isNullOrEmpty(maxOtherCredit)){
								maxRegularCredit.suspendEvents();
								maxOtherCredit.suspendEvents();
								
								maxRegularCredit.reset();
								maxOtherCredit.reset();
								
								maxRegularCredit.resumeEvents();
								maxOtherCredit.resumeEvents();
							}
						}
					},
					'numberfield[itemId=maxRegularCourseCreditYearly]':{
						change: function(numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var minimumCredit = (Ext.ComponentQuery.query("#minNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#minNumberOfCreditYearly")[Ext.ComponentQuery.query("#minNumberOfCreditYearly").length-1] : null;
							var maximumCredit = (Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#maxNumberOfCreditYearly")[Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length-1] : null;
							var maxRegularCredit = (Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxRegularCourseCreditYearly")[Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length-1] : null;
							var maxOtherCredit = (Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxOtherCourseCreditYearly")[Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length-1] : null;
						
							if(numberfield.hasFocus && !isNullOrEmpty(maximumCredit) && !isNullOrEmpty(maxRegularCredit) && !isNullOrEmpty(maxOtherCredit)){
								var maxRegularCreditVal = maxRegularCredit.getValue();
								var maxOtherCreditVal = maxOtherCredit.getValue();
								
								maximumCredit.setValue(maxRegularCreditVal+maxOtherCreditVal);
							}
						}
					},
					'numberfield[itemId=maxOtherCourseCreditYearly]':{
						change: function(numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var minimumCredit = (Ext.ComponentQuery.query("#minNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#minNumberOfCreditYearly")[Ext.ComponentQuery.query("#minNumberOfCreditYearly").length-1] : null;
							var maximumCredit = (Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#maxNumberOfCreditYearly")[Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length-1] : null;
							var maxRegularCredit = (Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxRegularCourseCreditYearly")[Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length-1] : null;
							var maxOtherCredit = (Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxOtherCourseCreditYearly")[Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length-1] : null;
						
							if(numberfield.hasFocus && !isNullOrEmpty(maximumCredit) && !isNullOrEmpty(maxRegularCredit) && !isNullOrEmpty(maxOtherCredit)){
								var maxRegularCreditVal = maxRegularCredit.getValue();
								var maxOtherCreditVal = maxOtherCredit.getValue();
								
								maximumCredit.setValue(maxRegularCreditVal+maxOtherCreditVal);
							}
						}
					},
					'numberfield[itemId=maxOtherCourseCreditYearly]':{
						change: function(numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var minimumCredit = (Ext.ComponentQuery.query("#minNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#minNumberOfCreditYearly")[Ext.ComponentQuery.query("#minNumberOfCreditYearly").length-1] : null;
							var maximumCredit = (Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#maxNumberOfCreditYearly")[Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length-1] : null;
							var maxRegularCredit = (Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxRegularCourseCreditYearly")[Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length-1] : null;
							var maxOtherCredit = (Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxOtherCourseCreditYearly")[Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length-1] : null;
						
							if(numberfield.hasFocus && !isNullOrEmpty(maximumCredit) && !isNullOrEmpty(maxRegularCredit) && !isNullOrEmpty(maxOtherCredit)){
								var maxRegularCreditVal = maxRegularCredit.getValue();
								var maxOtherCreditVal = maxOtherCredit.getValue();
								
								maximumCredit.setValue(maxRegularCreditVal+maxOtherCreditVal);
							}
						}
					},
					/*'numberfield[itemId=maxAdditionalCCNumberField]':{
						afterrender: function(numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var grid = registrationrulestabregistrationsetupdetails.down('grid');
							var selectedRecords = grid.getSelectionModel().getSelection();
							var registrationrulestabregistrationsetupdetails = this.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							
							var registrationsetupdetails = this.getRegistrationsetupdetails();
							var registrationRules = registrationsetupdetails.registrationRules;
							
							if(selectedRecords.length && Ext.Array.contains(Ext.Array.pluck(Ext.Array.pluck(selectedRecords,'data'),'code'),'ADDITIONAL_MODULES_APPLICABLE')){
								numberfield.setVisible(true);
								this.setAllowBlank(numberfield, false);
								if(isNullOrEmpty(numberfield.getValue())){
									submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
		            			}
								
								Ext.each(registrationRules, function(currentRule){
									if(currentRule.whetherMandatory == true && currentRule.registrationRule == "Additional Modules Applicable"){
										numberfield.setValue(currentRule.courseCredit);
									}
								});
							}
							else{
								numberfield.setVisible(false);
								this.setAllowBlank(numberfield, true);
								submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
							}
							
							
							
						},
						change: function( numberfield){
							var me = this;
							var registrationrulestabregistrationsetupdetails = me.getRegistrationrulestabregistrationsetupdetails();
							var submitRegistrationRulesAdditionalSetupBtn = registrationrulestabregistrationsetupdetails.down('#submitRegistrationRulesAdditionalSetupBtn');
							if(!isNullOrEmpty(numberfield.getValue()) && numberfield.isValid()){
								submitRegistrationRulesAdditionalSetupBtn.setDisabled(false);
							}
							else{
								submitRegistrationRulesAdditionalSetupBtn.setDisabled(true);
							}
						}
					},*/
					'registrationsetupprofileupdategrid':{
						beforedeselect: function(grid, record) {
		            		if(record.data.sequenceNo == 1){
		            			//grid.select(record);
		            			record.set('isSelected',true);
		            			return false;
		            		} else {
		            			record.set('isSelected',false);
		            		}
		            	},
		            	select: function(grid, record) {
							record.set('isSelected',true);
		            	},
		            	selectionchange: function(column, selected) {
		            		var pnl = column.view.up('#profileUpdateFormItemId');
							var configureAddressBtn = pnl.down('#configureAddressBtn');
							var configureParentDetailsBtn = pnl.down('#configureParentDetailsBtn');
		            		if(selected.length){ 
		            			var linkNameArray = Ext.Array.pluck(Ext.Array.pluck(selected,'data'),'linkName');
		            			var hasAddress = linkNameArray.includes("Address");
		            	        var hasParent = linkNameArray.includes("Parents");
		            	     // Enable/disable buttons accordingly
		            	        configureAddressBtn.setDisabled(!hasAddress);
		            	        configureParentDetailsBtn.setDisabled(!hasParent);
		            		}
		            		else{
		            			configureAddressBtn.setDisabled(true);
		            			configureParentDetailsBtn.setDisabled(true);
		            		}
		            	}
					},
					'registrationsetupdocumentgrid':{
						select: function(grid, record) {
							if(isNullOrEmpty(record.data.mandatory) || record.data.mandatory == undefined || record.data.mandatory == "undefined"){
								record.set('mandatory',true);
							}
							else{
								record.set('mandatory',record.data.mandatory);
							}
						},
						deselect: function(grid, record) {
							record.set('mandatory',null);
						}
					},
					
					'preregtabregistrationsetupdetails displayfield[itemId=availableDocumentLabelItemId]': {
		            	  render: function(component) {
		            		  var $this = this;
		            		  component.getEl().on('click', function(e) {
		            				  var getForm = $this.getRegistrationsetupdetailstabpanel();
		            				  if (getForm) {
		            					  var documentId = getForm.down('#encryptedDocId').getValue();
		            					  if (!isNullOrEmpty(documentId)) {
		            						  $this.getDocumentController().downloadDocumentFile(documentId);
		            					  }
		            				  }
		            		  });
		            	  }
		              },
					
					'preregtabregistrationsetupdetails filefield[itemId=staticUploadFileField]':{
						change: function(fileField, value, eOpts){
							 var $this = this;
							 var registrationSetupPanel = this.getPreregtabregistrationsetupdetails();
							 var uploadFileFieldPath =   registrationSetupPanel.down('#uploadFileFieldPath');
							 var hiddenFilePath =  registrationSetupPanel.down('#hiddenFilePath');
							 var type = fileField.fileInputEl.dom.files[0].type;
		                      value = value.replace('C:\\fakepath\\', '');
		                      var newValue = value.replace(/ +/g, " ").split(' ').join('_');
		                      var additionalSetupItemId = registrationSetupPanel.up('#additionalSetupItemId');
		                      
		                      var registrationSetupPanel1 = this.getRegistrationcontracttabregistrationsetupdetails();
		                      var filefield1 = registrationSetupPanel1.down('#staticUploadFileFieldRegContract');
		                      var uploadFileFieldPath1 =   registrationSetupPanel1.down('#uploadFileFieldPathRegContract');
		                      var hiddenFilePath1 =  registrationSetupPanel1.down('#hiddenRegContractFilePath');
		                      var fileField1RawValue = filefield1.getRawValue();
		                      var uploadFileField1PathConfigData = uploadFileFieldPath1.config.document;
		                      
		                       if (!isNullOrEmpty(newValue)) {
		                          var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
		                          if (extension == "gif" || extension == "png" || extension == "pdf" || extension == "doc" || extension == "docx"
		          	                || extension == "jpeg" || extension == "jpg") {
		                              var file = fileField.fileInputEl.dom.files[0];
		                              if (file.size / 1000000 > CONSTANTS.UPLOAD_REGISTRATION_SETUP_FILE_SIZE_LIMIT) {
		                                  fileField.reset();
		                                  registrationSetupPanel.down('#availableDocumentLabelItemId').setVisible(false);
		                                  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_CANNOT_MORE_THAN_20_MB'));
		                              }
		                              else{  
		                            	 var form =  this.getRegistrationsetupdetails();
			                             var registrationSetupPanel = this.getPreregtabregistrationsetupdetails();
				                          	if(!isNullOrEmpty(form)){
				                    			form.getForm().submit({
				                    				method : 'POST',
				                    				url : SERVERURL.DOCUMENT_FILE_ADD,
				                    				success : function(form1, action){
				                    					var responseData = Ext.decode(action.response.responseText);
				                    					
				                    					var path = responseData.path;
				                    					//fileField.setRawValue(path);
				                    					/*registrationSetupPanel.config.referenceDocument = value;
				                    					registrationSetupPanel.config.refDocumentPath=path;
				                    					registrationSetupPanel.config.refDocumentType=type;*/
				                    					var formData = new Object();
										    			 var isUpdate=false;
										    			 formData.type ='DOCUMENT';
										    			 formData.name = newValue.substring(0, (newValue.lastIndexOf('.')));;
										    			 formData.id =null;
				                    					 $this.getDocumentController().saveDocumentFormValue(false, 'DOCUMENT', false, formData, path, function(success, response, isCallBackTransient){
				                    						 if(success){
				                    							 fileField.setRawValue(newValue);
				                    							 uploadFileFieldPath.config.document = formData;
				                    							 hiddenFilePath.setValue(true);
				                    							 registrationSetupPanel.down('#hideAdditionalSetupItemId').setValue(null);
				                    							 try{
					                    							 additionalSetupItemId.config.additionalSetupRecord.document = formData;
				                    							 }
				                    							 catch(e){
				                    								 additionalSetupItemId.config.additionalSetupRecord = {};
				                    								 additionalSetupItemId.config.additionalSetupRecord.document = formData;
				                    							 }
				                    							 if(!isNullOrEmpty(additionalSetupItemId.config.additionalSetupRecord.id)){
					                    							 registrationSetupPanel.down('#hideAdditionalSetupItemId').setValue(additionalSetupItemId.config.additionalSetupRecord.id);
				                    							 }
				                    						 }
				                    					 });
				                    					 
				                    					 if(!isNullOrEmpty(fileField1RawValue)){
				                    						 filefield1.setRawValue(fileField1RawValue);
			                    							 uploadFileFieldPath1.config.document = uploadFileField1PathConfigData;
			                    							 hiddenFilePath1.setValue(true);
				                    					 }
				                    					
				                    				},
				                    				failure:function(){
				                    					console.log('failure');
				                    				}
				                    			});
				                    		}
				      	    			
				                           }
		                          
		                          } else {
		                              fileField.reset();
		                              registrationSetupPanel.down('#availableDocumentLabelItemId').setVisible(false);
		                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('REGISTRATION_INVALID_FILE_FORMAT'));
		                          }
		                      } 
						}
					},
					'registrationcontracttabregistrationsetupdetails displayfield[itemId=availableRegContractDocumentLabelItemId]': {
		            	  render: function(component) {
		            		  var $this = this;
		            		  component.getEl().on('click', function(e) {
		            				  var getForm = $this.getRegistrationsetupdetailstabpanel();
		            				  if (getForm) {
		            					  var documentId = getForm.down('#encryptedRegContractDocId').getValue();
		            					  if (!isNullOrEmpty(documentId)) {
		            						  $this.getDocumentController().downloadDocumentFile(documentId);
		            					  }
		            				  }
		            		  });
		            	  }
		              },
					
					'registrationcontracttabregistrationsetupdetails filefield[itemId=staticUploadFileFieldRegContract]':{
						change: function(fileField, value, eOpts){
							 var $this = this;
							 var registrationSetupPanel = this.getRegistrationcontracttabregistrationsetupdetails();
							 var uploadFileFieldPath =   registrationSetupPanel.down('#uploadFileFieldPathRegContract');
							 var hiddenFilePath =  registrationSetupPanel.down('#hiddenRegContractFilePath');
							 var type = fileField.fileInputEl.dom.files[0].type;

		                      var additionalSetupItemId = registrationSetupPanel.up('#additionalSetupItemId');
							 
		                      value = value.replace('C:\\fakepath\\', '');
		                      var newValue = value.replace(/ +/g, " ").split(' ').join('_');
		                      

		                      var registrationSetupPanel1 = this.getPreregtabregistrationsetupdetails();
		                      var filefield1 = registrationSetupPanel1.down('#staticUploadFileField');
		                      var uploadFileFieldPath1 =   registrationSetupPanel1.down('#uploadFileFieldPath');
		                      var hiddenFilePath1 =  registrationSetupPanel1.down('#hiddenFilePath');
		                      var fileField1RawValue = filefield1.getRawValue();
		                      var uploadFileField1PathConfigData = uploadFileFieldPath1.config.document;
		                      
		                       if (!isNullOrEmpty(newValue)) {
		                          var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
		                          if (extension == "gif" || extension == "png" || extension == "pdf" || extension == "doc" || extension == "docx"
		          	                || extension == "jpeg" || extension == "jpg") {
		                              var file = fileField.fileInputEl.dom.files[0];
		                              if (file.size / 1000000 > CONSTANTS.UPLOAD_REGISTRATION_SETUP_FILE_SIZE_LIMIT) {
		                                  fileField.reset();
		                                  registrationSetupPanel.down('#availableRegContractDocumentLabelItemId').setVisible(false);
		                                  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_CANNOT_MORE_THAN_20_MB'));
		                              }
		                              else{  
		                            	 var form =  this.getRegistrationsetupdetails();
			                             var registrationSetupPanel = this.getRegistrationcontracttabregistrationsetupdetails();
				                          	if(!isNullOrEmpty(form)){
				                    			form.getForm().submit({
				                    				method : 'POST',
				                    				url : SERVERURL.DOCUMENT_FILE_ADD,
				                    				success : function(form1, action){
				                    					var responseData = Ext.decode(action.response.responseText);
				                    					
				                    					var path = responseData.path;
				                    					//fileField.setRawValue(path);
				                    					/*registrationSetupPanel.config.referenceDocument = value;
				                    					registrationSetupPanel.config.refDocumentPath=path;
				                    					registrationSetupPanel.config.refDocumentType=type;*/
				                    					var formData = new Object();
										    			 var isUpdate=false;
										    			 formData.type ='DOCUMENT';
										    			 formData.name = 'registration';
										    			 formData.id =null;
				                    					 $this.getDocumentController().saveDocumentFormValue(false, 'DOCUMENT', false, formData, path, function(success, response, isCallBackTransient){
				                    						 if(success){
				                    							 fileField.setRawValue(newValue);
				                    							 uploadFileFieldPath.config.document = formData;
				                    							 hiddenFilePath.setValue(true);
				                    							 registrationSetupPanel.down('#hideRegContractAdditionalSetupItemId').setValue(null);
				                    							 
				                    							 
				                    							 try{
				                    								 additionalSetupItemId.config.registrationContractRecord.document = formData;
				                    							 }
				                    							 catch(e){
				                    								 additionalSetupItemId.config.registrationContractRecord = {};
				                    								 additionalSetupItemId.config.registrationContractRecord.document = formData;
				                    							 }
				                    							 if(!isNullOrEmpty(additionalSetupItemId.config.registrationContractRecord.id)){
				                    								 registrationSetupPanel.down('#hideRegContractAdditionalSetupItemId').setValue(additionalSetupItemId.config.registrationContractRecord.id);
				                    							 }
				                    						 }
				                    					 });
				                    					 
				                    					 if(!isNullOrEmpty(fileField1RawValue)){
				                    						 filefield1.setRawValue(fileField1RawValue);
			                    							 uploadFileFieldPath1.config.document = uploadFileField1PathConfigData;
			                    							 hiddenFilePath1.setValue(true);
				                    					 }
				                    					
				                    				},
				                    				failure:function(){
				                    					console.log('failure');
				                    				}
				                    			});
				                    		}
				      	    			
				                           }
		                          
		                          } else {
		                              fileField.reset();
		                              registrationSetupPanel.down('#availableRegContractDocumentLabelItemId').setVisible(false);
		                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('REGISTRATION_INVALID_FILE_FORMAT'));
		                          }
		                      } 
						}
					},
					'preregtabregistrationsetupdetails button[itemId=preRegistraionAdditionalSetupNextBtnId]':{
						click: function(btn){
							this.nextBtnPreRegistrationAdditionalSetup(btn);
						}
					},
					'registrationcontracttabregistrationsetupdetails button[itemId=nextRegistrationContractAdditionalSetupBtn]':{
						click: function(btn){
							this.nextBtnRegistrationContractAdditionalSetup(btn);
						},
						afterrender: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							if(registrationsetupdetailstabpanel.down('#submitRegistrationContractAdditionalSetupBtn').isHidden()){
								btn.hide();
							}
						},
						show: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							if(registrationsetupdetailstabpanel.down('#submitRegistrationContractAdditionalSetupBtn').isHidden()){
								btn.hide();
							}
						}
					},
					'preregtabregistrationsetupdetails button[itemId=submitAdditionalSetupBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('ADDITIONAL_TAB');
						}
					},
					'registrationrulestabregistrationsetupdetails button[itemId=nextRegistrationRulesAdditionalSetupBtn]':{
						click: function(btn){
							this.nextBtnPreRegistrationAdditionalSetupRegistrationRules(btn);
						}
					},
					'registrationvalidations button[itemId=nextRegistrationValidationsAdditionalSetupBtn]':{
						click: function(btn){
							this.nextBtnPreRegistrationAdditionalSetupRegistrationValidations(btn);
						},
						afterrender: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							var registrationvalidations = btn.up('registrationvalidations');
							if(registrationsetupdetailstabpanel.down('#submitRegistrationContractAdditionalSetupBtn').isHidden()){
								btn.hide();
							}
						}
					},
					'registrationguidelinesregsetup':{
						afterrender: function(tab){
							var additionalSetupItemId = tab.up('#additionalSetupItemId');
							var guidelineConfig = additionalSetupItemId.config.registrationGuidelineRecord;
							
							var tabPanel = this.getRegistrationsetupdetailstabpanel();
						    var additionalSetupMsg = tabPanel.config.registrationContractMsgContent;
						    
							if(guidelineConfig && guidelineConfig.id){
								setTimeout(function(){
									tab.down('#registrationGuidelinesApplicable').setValue(guidelineConfig.isRegistrationGuideline);
									tab.down('#regGuidelineId').setValue(guidelineConfig.id);
									tab.down('#regGuidelineInstruction').setValue(guidelineConfig.ckeditorData);
									
									var tabPanelMode = tabPanel.down('#additionalSetupMode').getValue();
									if(tabPanelMode== "view_mode"){
										tab.down('#registrationGuidelinesApplicable').setReadOnly(true);
										tab.down('#submitRegistrationGuidelinesAdditionalSetupBtn').hide();
									}
									else{
										tab.down('#registrationGuidelinesApplicable').setReadOnly(false);
										tab.down('#submitRegistrationGuidelinesAdditionalSetupBtn').show();
									}
								},300);
							}
							
						}
					},
					'registrationguidelinesregsetup button[itemId=regSaveTemplateButton]':{
						click: function(btn){
							var this$ = this;
					    	var templateForm= btn.up('registrationguidelinesregsetup');
					    	if(templateForm){
					    		var propertyCombo=templateForm.down("#regTemplatePropertyCombo");
					    		if(propertyCombo){    			   			
					      		  	  var ckeditor=templateForm.down('ckeditor');
					                  var propertyValue=propertyCombo.getValue();
					                  if(ckeditor && !isNullOrEmpty(propertyValue)){
					                	  ckeditor.editor.insertText("propertyValue");
										  var re = /propertyValue/gi;
										  var templateString = ckeditor.getValue();
										  templateString = templateString.replace(re, propertyValue);
					                	  ckeditor.setValue(templateString);
					                  }                  
					    		}
					    	}
						}
					},
					'registrationguidelinesregsetup button[itemId=submitRegistrationGuidelinesAdditionalSetupBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('ADDITIONAL_TAB');
						}
					},
					'preregtabregistrationsetupdetails button[itemId=resetAdditionalSetupBtn]':{
						click: function(btn){
							var registrationSetupPanel = this.getRegistrationsetupdetailstabpanel();
							var preRegistrationTermConditionApplicable = registrationSetupPanel.down('#preRegistrationTermConditionApplicable');
							var uploadFileField = registrationSetupPanel.down('#staticUploadFileField');
							var textEditor = registrationSetupPanel.down('#registrationCkEditorItemId');
							var downloadBtn = registrationSetupPanel.down('#availableDocumentLabelItemId');
							var termandconditionLink = registrationSetupPanel.down('#termandconditionLinkItemId');
							preRegistrationTermConditionApplicable.reset();
							uploadFileField.reset();
							textEditor.reset();
							downloadBtn.setVisible(false);
							termandconditionLink.reset();
						}
					},
					'registrationcontracttabregistrationsetupdetails button[itemId=submitRegistrationContractAdditionalSetupBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('ADDITIONAL_TAB');
						}
					},
					'registrationrulestabregistrationsetupdetails button[itemId=submitRegistrationRulesAdditionalSetupBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('ADDITIONAL_TAB');
						},
						afterrender: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							if(registrationsetupdetailstabpanel.down('#submitRegistrationContractAdditionalSetupBtn').isHidden()){
								btn.hide();
							}
						}
					},
					'registrationvalidations button[itemId=submitRegistrationValidationsAdditionalSetupBtn]':{
						click: function(btn){
							this.submitCourseRegistrationData('ADDITIONAL_TAB');
						},
						afterrender: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							if(registrationsetupdetailstabpanel.down('#submitRegistrationContractAdditionalSetupBtn').isHidden()){
								btn.hide();
							}
						}
					},
					'registrationcontracttabregistrationsetupdetails button[itemId=resetRegistrationContractAdditionalSetupBtn]':{
						click: function(btn){
							var registrationSetupPanel = this.getRegistrationsetupdetailstabpanel();
							var registraionContractApplicable = registrationSetupPanel.down('#registraionContractApplicable');
							var uploadFileField = registrationSetupPanel.down('#staticUploadFileFieldRegContract');
							var textEditor = registrationSetupPanel.down('#registrationContractCkEditorItemId');
							var downloadBtn = registrationSetupPanel.down('#availableRegContractDocumentLabelItemId');
							var tncLink = registrationSetupPanel.down('#termandconditionLinkRegistraionItemId');
							var check1Field = registrationSetupPanel.down('#check1TextField');
							var check2Field = registrationSetupPanel.down('#check2TextField');
							var check3Field = registrationSetupPanel.down('#check3TextField');
							uploadFileField.reset();
							textEditor.reset();
							downloadBtn.setVisible(false);
							registraionContractApplicable.reset();
							tncLink.reset();
							check1Field.reset();
							check2Field.reset();
							check3Field.reset();
						}
					},
					'registrationvalidations button[itemId=resetRegistrationValidationsAdditionalSetupBtn]':{
						click: function(btn){
							var registrationSetupPanel = this.getRegistrationsetupdetailstabpanel();
							
							var mandatoryChecksBypass = registrationSetupPanel.down('#mandatoryChecksBypass');
							var minCoursesCourseGroupChecksBypass = registrationSetupPanel.down('#minCoursesCourseGroupChecksBypass');
							var yearlyMinCreditChecksBypass = registrationSetupPanel.down('#yearlyMinCreditChecksBypass');
							var minCreditChecksForCourseGroupBypass = registrationSetupPanel.down('#minCreditChecksForCourseGroupBypass');
							var minCourseGroupChecksBypass = registrationSetupPanel.down('#minCourseGroupChecksBypass');
							var moduleGroupChecksBypass = registrationSetupPanel.down('#moduleGroupChecksBypass');

							mandatoryChecksBypass.reset();
							minCoursesCourseGroupChecksBypass.reset();
							yearlyMinCreditChecksBypass.reset();
							minCreditChecksForCourseGroupBypass.reset();
							minCourseGroupChecksBypass.reset();
							moduleGroupChecksBypass.reset();
							
							this.updateValidationsValues();
						},
						afterrender: function(btn){
							var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
							var registrationvalidations = btn.up('registrationvalidations');
							if(registrationsetupdetailstabpanel.down('#submitRegistrationContractAdditionalSetupBtn').isHidden()){
								btn.hide();
								registrationvalidations.down('#mandatoryChecksBypass').setReadOnly(true);
								registrationvalidations.down('#minCoursesCourseGroupChecksBypass').setReadOnly(true);
								registrationvalidations.down('#yearlyMinCreditChecksBypass').setReadOnly(true);
								registrationvalidations.down('#minCreditChecksForCourseGroupBypass').setReadOnly(true);
								registrationvalidations.down('#minCourseGroupChecksBypass').setReadOnly(true);
								registrationvalidations.down('#moduleGroupChecksBypass').setReadOnly(true);
							}
						}
					},
					'registrationsetupdetails':{
						render: function(window){
		    				var $this = this;
		    				window.body.on('click', function() {
		    	    			//$this.hideInvalidIconFromField($this.getRegistrationsetupdetails());
		    	    	       });
		    			},
		    			afterrender: function(panel){
		    				var $this = this;
		    				var grid = $this.getRegistrationsetupgrid();
		    				var record = grid.getSelectionModel().getSelection()[0];
		    				var defaultConfigureAddressData = {
		    						'CRNT'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'CRSPDNC'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'PRMNT'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'OFC'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'GOOGLE'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    				};
		    				
		    				var defaultConfigureParentData = {
		    						'PG1'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'PG2'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'G'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'LG' :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'V1'  :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    						'V2' :{
		    							'whetherMandatory': false,
		    							'whetherVisible': false
		    						} ,
		    				};
		    				
		    				panel.configureAddressData = defaultConfigureAddressData;
		    				panel.configureParentData = defaultConfigureParentData;
							if(panel.btnType == "Add"){
								panel.configureAddressData = defaultConfigureAddressData;
								
								var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
								var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
								additionalSetupItemId.config.registrationGuidelineRecord = {};
							}
							else{
								
								Ext.Ajax.request({
									method : "GET",
									type : 'rest',
									url : SERVERURL.PATH_GET_REGISTRATION_SETUP_ADDRESSES+"?registrationSetupId="+record.data.registrationSetupId,
									success : function(form,action) {
										if(!isNullOrEmpty(form.responseText)){
											var data = Ext.JSON.decode(form.responseText);
											if(data.length == 0){
												panel.configureAddressData = defaultConfigureAddressData;
											}
											else{
												Ext.each(data, function(currentAdrsConfig){
													defaultConfigureAddressData[currentAdrsConfig.addressCode] = currentAdrsConfig;
												});
												panel.configureAddressData = defaultConfigureAddressData;
											}
										}
									}
								});
								
								Ext.Ajax.request({
									method : "GET",
									type : 'rest',
									url : SERVERURL.PATH_GET_REGISTRATION_PARENT_DETAILS+"?registrationSetupId="+record.data.registrationSetupId,
									success : function(form,action) {
										if(!isNullOrEmpty(form.responseText)){
											var data = Ext.JSON.decode(form.responseText);
											if(data.length == 0){
												panel.configureParentData = defaultConfigureParentData;
											}
											else{
												Ext.each(data, function(currentParentConfig){
													defaultConfigureParentData[currentParentConfig.parentCode] = currentParentConfig;
												});
												panel.configureParentData = defaultConfigureParentData;
											}
										}
									}
								});
							}
		    			}
					},
					'preregtabregistrationsetupdetails checkboxfield[itemId=preRegistrationTermConditionApplicable]':{
						change: function(checkbox, newValue, oldValue) {
							var $this = this;
							var preregtabregistrationsetupdetails = checkbox.up('preregtabregistrationsetupdetails');
							var preRegFieldContainer1 = preregtabregistrationsetupdetails.down('#preRegFieldContainer1');
							var preRegFieldContainer2 = preregtabregistrationsetupdetails.down('#preRegFieldContainer2');
							var preRegFieldContainer3 = preregtabregistrationsetupdetails.down('#preRegFieldContainer3');
							var preRegFieldContainer4 = preregtabregistrationsetupdetails.down('#preRegFieldContainer4');
							
							if(newValue){
								preRegFieldContainer1.setVisible(true);
								preRegFieldContainer2.setVisible(true);
								preRegFieldContainer3.setVisible(true);
								preRegFieldContainer4.setVisible(true);
							}
							else{
								preRegFieldContainer1.setVisible(false);
								preRegFieldContainer2.setVisible(false);
								preRegFieldContainer3.setVisible(false);
								preRegFieldContainer4.setVisible(false);
							}
						}
					},
					'registrationguidelinesregsetup checkboxfield[itemId=registrationGuidelinesApplicable]':{
						change: function(checkbox, newValue, oldValue) {
							var $this = this;
							var registrationguidelinesregsetup = checkbox.up('registrationguidelinesregsetup');
							var preRegFieldContainer1 = registrationguidelinesregsetup.down('#regGuidelineInstructionContainerItemId1');
							var preRegFieldContainer2 = registrationguidelinesregsetup.down('#regGuidelineInstructionContainerItemId2');
							var regGuidelineInstruction = registrationguidelinesregsetup.down('#regGuidelineInstruction');
							
							if(newValue){
								preRegFieldContainer1.setVisible(true);
								preRegFieldContainer2.setVisible(true);
								this.setAllowBlank(regGuidelineInstruction, false);
							}
							else{
								preRegFieldContainer1.setVisible(false);
								preRegFieldContainer2.setVisible(false);
								this.setAllowBlank(regGuidelineInstruction, true);
							}
						}
					},
					'registrationcontracttabregistrationsetupdetails checkboxfield[itemId=registraionContractApplicable]':{
						change: function(checkbox, newValue, oldValue) {
							var $this = this;
							var registrationcontracttabregistrationsetupdetails = checkbox.up('registrationcontracttabregistrationsetupdetails');
							var regContractFieldContainer1 = registrationcontracttabregistrationsetupdetails.down('#regContractFieldContainer1');
							var regContractFieldContainer2 = registrationcontracttabregistrationsetupdetails.down('#regContractFieldContainer2');
							var regContractFieldContainer4 = registrationcontracttabregistrationsetupdetails.down('#regContractFieldContainer4');
							
							if(newValue){
								regContractFieldContainer1.setVisible(true);
								regContractFieldContainer2.setVisible(true);
								regContractFieldContainer4.setVisible(true);
							}
							else{
								regContractFieldContainer1.setVisible(false);
								regContractFieldContainer2.setVisible(false);
								regContractFieldContainer4.setVisible(false);
							}
						}
					},
					'latefeeconfigform button[itemId=submitLateFeeConfig]':{
						click:function(obj){
							this.getSubmitLateFeeFormData();
					}
					},
					'latefeeconfigform customcombobox[itemId=feePlanNameId]':{
						change:function(){
							var form = this.getLatefeeconfigform();
							var feePlanNameCombo = form.down('#feePlanNameId');
							var feePlanRuleCombo = form.down('#feePlanRuleId');
							var amountToBePaid = form.down('#amountToBePaidId');
							if(doResetFeeRuleCombo){
								feePlanRuleCombo.reset();
								amountToBePaid.reset();
							}
							var feePlanRuleStore = feePlanRuleCombo.getStore();
							feePlanRuleStore.getProxy().extraParams={
								"feePlanId":feePlanNameCombo.getValue()
							};
							feePlanRuleStore.load();
							doResetFeeRuleCombo=true;
						}	
					},
					'latefeeconfigform customcombobox[itemId=feePlanRuleId]':{
						   change:function(){
							   var form = this.getLatefeeconfigform();
							   var amountToBePaid = form.down('#amountToBePaidId');
							   var feePlanRuleCombo = form.down('#feePlanRuleId');
							   var feePlanRuleValue = feePlanRuleCombo.getValue();
							   var feePlanRuleStore = feePlanRuleCombo.getStore();
							   feePlanRuleStore.load({
			     					 callback: function(records, operation, success) {
			     						 for(var i in records){
			     							 if(records[i].data.id == feePlanRuleValue){
			     								amountToBePaid.setValue(records[i].data.doubleValue);
			     								amountToBePaid.setReadOnly(true);
			     							 }
			     						 }
			     					 }	   
				});
						   }	
			},
					'latefeeconfigform button[itemId=cancelLateFeeConfig]':{
						click:function(obj){
							var regSetupPanel = this.getRegistrationsetupdetailstabpanel();
							var regPanel = this.getRegistrationsetupdetails().getForm();
							regSetupPanel.remove(1);
							regPanel.checkValidity();
						}
					}
				});
			},
			loadRegistrationSetupGrid: function(){
				var $this = this;
				var form = $this.getRegistrationsetupfilter();
				var formValue = form.getValues();
				var grid = $this.getRegistrationsetupgrid();
				
		    	var alids=[];
				var academyLocationId = formValue.multiselectAcademyLocation;
				var academyLocationIds = null;

				if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
					for (var i in academyLocationId) {
						if (Ext.isObject(academyLocationId[0])) {
							alids.push(academyLocationId[i].get("id"));
						} else {
							alids.push(academyLocationId[i]);
						}
					}
					academyLocationIds = alids.join();
				}
				else if(!isNullOrEmpty(academyLocationId)){
					academyLocationIds = academyLocationId;
				}
				
		    	grid.getStore().getProxy().extraParams= {
		    		academyLocationIds:academyLocationIds,
		    		academicTerm:formValue.academicTerm,
		    		registrationSetupNameId:formValue.registrationSetupName,
		    		registrationTermId:formValue.registrationTerm,
		    		programId:formValue.programId,
		    		batchId:formValue.batchId,
		    		periodId:formValue.periodId
		    		
		    	};
		    	grid.getSelectionModel().deselectAll();
		    	$this.resetGridSetting(grid);
		    	grid.getStore().load();
		    	grid.config.searchFilterForm = form;
			},
			resetRegistrationSetupFilter:function(){
				var $this = this;
				var form = $this.getRegistrationsetupfilter();
				form.getForm().reset();
				var registrationTermId = form.down("#registrationTermId");
				var registrationSetupNameId = form.down("#registrationSetupNameId");
				var programId = form.down("#programId");
				var batchId = form.down("#batchId");
				var periodId = form.down("#periodId");
				registrationTermId.lastQuery=null;
				registrationSetupNameId.lastQuery=null;
				programId.reset();
				batchId.reset();
				periodId.reset();
				batchId.setDisabled(true);
				periodId.setDisabled(true);
				var multiselectAcademyLocationId = form.down("#multiselectAcademyLocationId");
				var alIds=[];
				alIds.push(this.getCurrentAcademyLocation());
				var multiselectAcademyLocationStore=multiselectAcademyLocationId.getStore();
				multiselectAcademyLocationStore.load({
					callback: function(records, operation, success) {
						if (success) {
							if(records.length > 0){
								multiselectAcademyLocationId.setValue(alIds);
							}		 
						}
					}
				});

				var registrationSetupCombo=form.down("#registrationSetupNameId");
				var registrationTermCombo=form.down("#registrationTermId");

				var registrationSetupStore = registrationSetupCombo.getStore();
				registrationSetupStore.getProxy().extraParams = {
					academicTerm:null
				};
				registrationSetupStore.load();	

				var registrationTermStore = registrationTermCombo.getStore();
				registrationTermStore.getProxy().extraParams = {
					academicTerm:null,
					registrationSetupId:null
				};
				registrationTermStore.load();	
			},
			addRegistrationSetupScreen: function(sType){
				var contentpanel = this.getContentPanel();
				var registrationSetupDetails = Ext.widget('registrationsetupdetails');
				var tabName = getCommonTranslation('REGISTRATION_SETUP_DETAILS');
				var grid = this.getRegistrationsetupgrid();
				var getcontroller=this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentpanel.remove(getTab, true);
				}
				var courseregistrationeditablegrid = this.getCourseregistrationeditablegrid();
				courseregistrationeditablegrid.config.isView=false;
				registrationSetupDetails.btnType = sType;
				if(contentpanel!=undefined){
					        	var getTab =Ext.create('Academia.view.course.CourseParentPanel',{
						        		title: tabName,
						        		closable:true,
						        		autoScroll:true,
						        		itemId:'addRegistrationDetailsPnl',
						        		menuColorCls: CONSTANTS.MENU_COLOR_THREE,
						        		items:[registrationSetupDetails]
					        	}); 
					        	contentpanel.add(getTab);																	
					        	contentpanel.setActiveTab(getTab);
					        	contentpanel.doLayout();		
					        }
				 
				//openTab(contentpanel, tabName, registrationSetupDetails,CONSTANTS.MENU_COLOR_THREE);
				/*var academylocationgrid = this.getServicemasteralmappinggrid();
				var servicemasterprogrambatchseatstructure = this.getServicemasterprogrambatchseatstructure();
				academylocationgrid.getStore().clearFilter();
				academylocationgrid.getStore().load();*/
				this.getAdjustmentprogresstracker().setVisible(true);
				registrationSetupDetails.config.isAddForm = true;
				this.resetProgressTracker();
				var adjustmentprogresstracker = registrationSetupDetails.down("#adjustmentprogresstracker");
				var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
				progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
				progresstracker1.textEl.addCls("inProgressCss-progress-text");
				progresstracker1.updateText("Step 1 In Progress");

				/*var servicemasterapplytotabstructure = this.getServicemasterapplytotabstructure();
				var serviceMasterGridRecord = servicemasterapplytotabstructure.config.serviceMasterGridRecord;
				if(!isNullOrEmpty(serviceMasterGridRecord)){
					registrationSetupDetails.down('#registrationSetupId').setValue(serviceMasterGridRecord.get('serviceName'));
				}*/
			},
			nextBtnPeriodRegistration: function(){
				var me = this;
				var grid = this.getRegistrationsetupgrid();
				var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
				
				var registrationsetupdetails = this.getRegistrationsetupdetails();
				var registrationSetupId = registrationsetupdetails.down('#registrationSetupId');
				var registrationSetupNameId = registrationsetupdetails.down('#registrationSetupNameId');
				var param = new Object();
				param.registrationSetupName = registrationSetupNameId.getValue();
				param.id = registrationSetupId.getValue();
				
				Ext.Ajax.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.PATH_CHECK_DUPLICACY_REGISTRATION_SETUP_NAME,
					params : param,
					success : function(form,action) {
						//var data = Ext.JSON.decode(form.responseText);
						if(!isNullOrEmpty(form.responseText) && form.responseText == "true"){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REGISTRATION_SETUP_DUPLICATE_MSG'));
						}else{
							var courseRegistration = registrationsetupdetailstabpanel.down('#courseRegistrationItemId');
							var registrationsetupdetails = me.getRegistrationsetupdetails();
							var formValues = registrationsetupdetails.getValues();
							
							if(courseRegistration.isDisabled()){
								courseRegistration.setDisabled(false);
								registrationsetupdetailstabpanel.setActiveTab(courseRegistration);
								me.setProgressTracker(1);
								if(isNullOrEmpty(registrationSetupId.getValue())){
									var courseregistrationeditablegrid = me.getCourseregistrationeditablegrid();
									courseregistrationeditablegrid.getStore().removeAll();
									me.addPeriodRegistrationGridRecord(1);
									/*var isEditCourseReg = courseregistrationeditablegrid.down('#isEditCourseRegId');
									isEditCourseReg.reset();*/
									var storeItems = courseregistrationeditablegrid.getStore().data.items;
				            		if(storeItems.length>0){
				            			storeItems.forEach(function(obj){
				            				obj.set("adminStartDate",new Date(formValues.periodStartDate));
				            				obj.set("adminEndDate",new Date(formValues.periodEndDate));
				            				obj.set("studentStartDate",new Date(formValues.studentPeriodStartDate));
				            				obj.set("studentEndDate",new Date(formValues.studentPeriodEndDate));
				            				obj.set("isEditCourseReg",false)
				            				obj.set("periodStartDate", new Date(formValues.periodStartDate));
				            				obj.set("periodEndDate", new Date(formValues.periodEndDate));
				            				obj.set("studentPeriodStartDate", new Date(formValues.studentPeriodStartDate));
				            				obj.set("studentPeriodEndDate", new Date(formValues.studentPeriodEndDate));
										});
				            		}
								}
							}
							else{
								var courseregistrationeditablegrid = me.getCourseregistrationeditablegrid();
								var storeItems = courseregistrationeditablegrid.getStore().data.items;
			            		if(storeItems.length>0){
			            			storeItems.forEach(function(obj){
			            				obj.set("periodStartDate", new Date(formValues.periodStartDate));
			            				obj.set("periodEndDate", new Date(formValues.periodEndDate));
			            				obj.set("studentPeriodStartDate", new Date(formValues.studentPeriodStartDate));
			            				obj.set("studentPeriodEndDate", new Date(formValues.studentPeriodEndDate));
									});
			            		}
								registrationsetupdetailstabpanel.setActiveTab(courseRegistration);
							}
						}
					}
				});
			},
			nextBtnCourseRegistration: function(){
				var me = this;
				var grid = this.getRegistrationsetupgrid();
				var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
				var registrationsetupdetails = this.getRegistrationsetupdetails();
				var registrationSetupId = registrationsetupdetails.down('#registrationSetupId');

				var registrationsetupdetails = me.getRegistrationsetupdetails();
				var formValues = registrationsetupdetails.getValues();
				
				var registrationsetupprofileupdategrid = this.getRegistrationsetupprofileupdategrid();
				var courseregistrationeditablegrid = this.getCourseregistrationeditablegrid();
				
				var whetherDateValidate = true;
				var adminStartDateAlertMessage = "";
				var adminEndDateAlertMessage = "";
				var studentStartDateAlertMessage = "";
				var studentEndDateAlertMessage = "";
				
				var storeItems = courseregistrationeditablegrid.getStore().data.items;
				if(storeItems.length>0){
					var flag = true;
					storeItems.forEach(function(obj){
						if(!isNullOrEmpty(obj.data.adminStartDate) && !isNullOrEmpty(obj.data.adminStartTime) && 
								!isNullOrEmpty(obj.data.adminEndDate) && !isNullOrEmpty(obj.data.adminEndTime) &&
								!isNullOrEmpty(obj.data.studentStartDate) && !isNullOrEmpty(obj.data.studentStartTime) &&
								!isNullOrEmpty(obj.data.studentEndDate) && !isNullOrEmpty(obj.data.studentEndTime)){
						}
						else{
							flag = false;
						}
					});
				}
				if(flag && whetherDateValidate){
					var profileUpdate = registrationsetupdetailstabpanel.down('#profileUpdateItemId');
					var periodRegistration = registrationsetupdetailstabpanel.down('#periodRegistrationItemId');
					profileUpdate.setDisabled(false);
					registrationsetupdetailstabpanel.setActiveTab(profileUpdate);
					//registrationsetupprofileupdategrid.getStore().load();
					me.setProgressTracker(1);
					if(isNullOrEmpty(registrationSetupId.getValue())){
						Ext.Ajax.request({
							method : "GET",
							type : 'rest',
							url : SERVERURL.PATH_GET_PROFILE_LINK_GRID_DATA,
							success : function(form,action) {
								if(!isNullOrEmpty(form.responseText)){
									var data = Ext.JSON.decode(form.responseText);
									if(data.length>0){
										var ObjModel = [];
										registrationsetupprofileupdategrid.getStore().removeAll();
										data.forEach(function(obj){
											var registrationSetupProfileUpdateGridModel = new Academia.model.registrationsetup.RegistrationSetupProfileUpdateGridModel();
											registrationSetupProfileUpdateGridModel.set("id", obj.id);
											registrationSetupProfileUpdateGridModel.set("linkName", obj.value);
											registrationSetupProfileUpdateGridModel.set("sequenceNo", obj.sequence);
											registrationSetupProfileUpdateGridModel.commit();
						            		ObjModel.push(registrationSetupProfileUpdateGridModel);
										});
					            		registrationsetupprofileupdategrid.getStore().loadRawData(ObjModel, true);
									}
								}
							}
						});
					}
					else{
					}
				} else if(!whetherDateValidate){
        			var alertMessage = "";
        			if(adminStartDateAlertMessage != ""){
        				alertMessage += adminStartDateAlertMessage;
        			}
        			if(adminEndDateAlertMessage != ""){
        				alertMessage += alertMessage != "" ? "<br/>"+adminEndDateAlertMessage : adminEndDateAlertMessage;
        			}
        			if(studentStartDateAlertMessage != ""){
        				alertMessage += alertMessage != "" ? "<br/>"+studentStartDateAlertMessage : studentStartDateAlertMessage;
        			}
        			if(studentEndDateAlertMessage != ""){
        				alertMessage += alertMessage != "" ? "<br/>"+studentEndDateAlertMessage : studentEndDateAlertMessage;
        			}
        			if(alertMessage != ""){
        				showWarningMessage(getCommonTranslation('ALERT'),alertMessage);
        			}
        		} else{
					showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
				}
			},
			nextBtnProfileUpdate: function(){
				var me = this;
				var profileUpdateStartDate = "";
				var profileUpdateEndDate = "";
				var grid = this.getRegistrationsetupgrid();
				var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
				var registrationsetupdetails = this.getRegistrationsetupdetails();
				var registrationDocument = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
				var registrationSetupId = registrationsetupdetails.down('#registrationSetupId');
				var whetherDateValidate = true;
				if(!whetherDateValidate){
        			var alertMessage = "";
        			if(profileUpdateStartDate!= ""){
        				alertMessage += profileUpdateStartDate;
        			}
        			if(profileUpdateEndDate!= ""){
        				alertMessage += alertMessage != "" ? "<br/>"+profileUpdateEndDate : profileUpdateEndDate;
        			}
        			if(alertMessage != ""){
        				showWarningMessage(getCommonTranslation('ALERT'),alertMessage);
        			}
        		}else{
        			var registrationsetupdocumentgrid = this.getRegistrationsetupdocumentgrid();
    				registrationDocument.setDisabled(false);
    				registrationsetupdetailstabpanel.setActiveTab(registrationDocument);
    				me.setProgressTracker(2);
    				
    				if(isNullOrEmpty(registrationSetupId.getValue())){
    					registrationsetupdocumentgrid.getStore().getProxy().extraParams = {
    						isApplicableForStudent:true
    					};
    					registrationsetupdocumentgrid.getStore().removeAll();
    					registrationsetupdocumentgrid.getStore().load();
    				}
    				else{
    					if(isNullOrEmpty(registrationDocument.config.registrationDocumentRecord)){
    						registrationsetupdocumentgrid.getStore().getProxy().extraParams = {
    							isApplicableForStudent:true
    						};
    						registrationsetupdocumentgrid.getStore().removeAll();
    						registrationsetupdocumentgrid.getStore().load();
    					}
    				}	
        		}
				
			},
			nextBtnRegistrationContractAdditionalSetup: function(){
				var me = this;
				var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
				var additionalSetup = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
				
				var registraionRulesAdditionalSetup = additionalSetup.down('#registrationRulesAdditionalSetupTab');
				if(registraionRulesAdditionalSetup){
					additionalSetup.down('tabpanel').setActiveTab(registraionRulesAdditionalSetup);
				}
				else{
					var registrationguidelinesregsetupItemId = additionalSetup.down('#registrationguidelinesregsetupItemId')
					additionalSetup.down('tabpanel').setActiveTab(registrationguidelinesregsetupItemId);
				}
			},
			nextBtnPreRegistrationAdditionalSetup:function(){
				var me = this;
				var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
				var additionalSetup = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
				var registraionContractAdditionalSetup = additionalSetup.down('#registrationContractTab')
				additionalSetup.down('tabpanel').setActiveTab(registraionContractAdditionalSetup);
			},
			nextBtnPreRegistrationAdditionalSetupRegistrationRules: function(){
				var me = this;
				var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
				var additionalSetup = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
				var registrationvalidationsItemId = additionalSetup.down('#registrationvalidationsItemId')
				additionalSetup.down('tabpanel').setActiveTab(registrationvalidationsItemId);
			},
			nextBtnPreRegistrationAdditionalSetupRegistrationValidations: function(){
				var me = this;
				var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
				var additionalSetup = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
				var registrationguidelinesregsetupItemId = additionalSetup.down('#registrationguidelinesregsetupItemId')
				additionalSetup.down('tabpanel').setActiveTab(registrationguidelinesregsetupItemId);
			},
			nextBtnRegistrationDocument:function(){

				var me = this;
				var grid = this.getRegistrationsetupgrid();
				var registrationsetupdetailstabpanel = this.getRegistrationsetupdetailstabpanel();
				var registrationsetupdetails = this.getRegistrationsetupdetails();
				var additionalSetup = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
				var registrationSetupId = registrationsetupdetails.down('#registrationSetupId');
				var registrationDocument = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
				var registrationsetupdocumentgrid = this.getRegistrationsetupdocumentgrid();
				var formValues = registrationsetupdetails.getValues();
				var registrationDocumentApplicable = formValues.registrationDocumentApplicable;
				if(registrationDocumentApplicable&&!registrationsetupdocumentgrid.getSelectionModel().getCount()>0) {
				showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('PLEASE_SELECT_DOCUMENTS'));
				}else{
				
				additionalSetup.setDisabled(false);
				registrationsetupdetailstabpanel.setActiveTab(additionalSetup);
				me.setProgressTracker(3);
				}
				
				
			
			},
			addPeriodRegistrationGridRecord: function(serialNo,record){
				var me = this;
            	var courseregistrationeditablegrid = me.getCourseregistrationeditablegrid();
            	var ObjModel = [];
            	if(serialNo == 1){
            		var courseRegistrationGridModel = new Academia.model.registrationsetup.CourseRegistrationGridModel();
            		courseRegistrationGridModel.set("serialNo", serialNo);
            		courseRegistrationGridModel.set("registrationTerm", '');
            		courseRegistrationGridModel.set("adminStartDate", '');
            		courseRegistrationGridModel.set("isAddDeleteRow", true);
					courseRegistrationGridModel.set("whetherAllowAdd", true);
            		courseRegistrationGridModel.set("whetherAllowDrop", true);
            		courseRegistrationGridModel.commit();
            		ObjModel.push(courseRegistrationGridModel);
            		courseregistrationeditablegrid.getStore().loadRawData(ObjModel, true);
            	}
            	else if(serialNo>1){
            		var registrationTerm = record.get('registrationTerm');
            		var courseRegistrationGridModel = new Academia.model.registrationsetup.CourseRegistrationGridModel();
            		courseRegistrationGridModel.set("serialNo", serialNo);
            		courseRegistrationGridModel.set("registrationTerm", '');
            		courseRegistrationGridModel.set("adminStartDate", '');
            		courseRegistrationGridModel.set("isAddDeleteRow", true);
            		courseRegistrationGridModel.set("whetherAllowAdd", true);
            		courseRegistrationGridModel.set("whetherAllowDrop", true);
            		ObjModel.push(courseRegistrationGridModel);
            		courseregistrationeditablegrid.getStore().loadRawData(ObjModel, true);
            		courseregistrationeditablegrid.getStore().sort([
            		    {
            		        property : 'serialNo',
            		        direction: 'ASC'
            		    }
            		]);
            	}
			},
			submitCourseRegistrationData: function(TabName){
				var $this = this;
				//
				var registrationSetupDetailsPnl = $this.getRegistrationsetupdetailstabpanel()
				var registrationsetupdetails = $this.getRegistrationsetupdetails();
				var courseregistrationeditablegrid = $this.getCourseregistrationeditablegrid();
				var submitBtn = registrationsetupdetails.down('#submitCourseRegistrationBtn');
				
				if(TabName == "COURSE_TAB" && submitBtn && !submitBtn.isValid){
					submitBtn.isValid=true;
					return false;
				}
				
				var registrationSetupId = registrationsetupdetails.down('#registrationSetupId');
				var academicTerm = registrationsetupdetails.down('#academicTerm');
				var registrationSetupNameId = registrationsetupdetails.down('#registrationSetupNameId');
				var whetherAutoApproved=registrationsetupdetails.down('#whetherAutoApproved').getValue();

				var mainJsonObj = new Object();
				var termwisePeriodRegistrationsArr=[];
				var termwiseCourseRegistrationsArr=[];
				var termWiseProfileUpdatesArr=[];
				var termWiseRegistrationDocumentSetupsArry=[];
				var termWiseAdditionalSetupsArrayObj={};
				var termWiseRegistrationContractArrayObj={};
				var termWiseRegistrationRulesArrayObj=[];
				var registrationGuidelinesArrayObj = [];
				var termWiseRegistrationValidationArrayObj=[];
				var flag = true;
				var whetherDateValidate = true;
				var adminStartDateAlertMessage = "";
				var adminEndDateAlertMessage = "";
				var studentStartDateAlertMessage = "";
				var studentEndDateAlertMessage = "";
				var profileUpdateStartDateMSG = "";
				var profileUpdateEndDateMSG = "";
				var formValues = registrationsetupdetails.getValues();
				
				
				mainJsonObj.id=registrationSetupId.getValue();
				mainJsonObj.registrationSetupName = formValues.registrationSetupName;
				mainJsonObj.whetherAutoApproved = isNullOrEmpty(formValues.whetherAutoApproved) ? false : true;
				mainJsonObj.academicTerm = {
						id:formValues.academicTerm,
						value:academicTerm.getRawValue(),
				};
				
				/*****************Period Registration Tab******************/
				
				mainJsonObj.termwisePeriodRegistrations=termwisePeriodRegistrationsArr;
				
				/*****************End Period Registration Tab******************/
				

				/*****************Course Registration Tab******************/
				
				var storeItems = courseregistrationeditablegrid.getStore().data.items;
        		if(storeItems.length>0){
        			storeItems.forEach(function(obj){
        				var obj1 = new Object(); 
        				obj1.id=obj.data.id;
        				obj1.registrationTerm={
        						id:obj.data.registrationTerm
        				};
        				
        				if(!isNullOrEmpty(obj.data.adminStartDate) && !isNullOrEmpty(obj.data.adminStartTime)){
        					var dateString="";
        					var adminStartDate= Ext.Date.format(obj.data.adminStartDate,'Y-m-d');
        					var adminStartTime = $this.formatAMPM(obj.data.adminStartTime);
        					dateString=adminStartDate+" "+adminStartTime;
        					obj1.adminStartDateTime=dateString;
        				}
        				else{
        					flag = false;
        				}
        				
        				if(!isNullOrEmpty(obj.data.adminEndDate) && !isNullOrEmpty(obj.data.adminEndTime)){
        					var dateString="";
        					var adminEndDate= Ext.Date.format(obj.data.adminEndDate,'Y-m-d');
        					var adminEndTime = $this.formatAMPM(obj.data.adminEndTime);
        					dateString=adminEndDate+" "+adminEndTime;
        					obj1.adminEndDateTime=dateString;
        				}
        				else{
        					flag = false;
        				}
        				
        				if(!isNullOrEmpty(obj.data.studentStartDate) && !isNullOrEmpty(obj.data.studentStartTime)){
        					var dateString="";
        					var studentStartDate= Ext.Date.format(obj.data.studentStartDate,'Y-m-d');
        					var studentStartTime = $this.formatAMPM(obj.data.studentStartTime);
        					dateString=studentStartDate+" "+studentStartTime;
        					obj1.studentStartDateTime=dateString;
        				}
        				else{
        					flag = false;
        				}
        				
        				if(!isNullOrEmpty(obj.data.studentEndDate) && !isNullOrEmpty(obj.data.studentEndTime)){
        					var dateString="";
        					var studentEndDate= Ext.Date.format(obj.data.studentEndDate,'Y-m-d');
        					var studentEndTime = $this.formatAMPM(obj.data.studentEndTime);
        					dateString=studentEndDate+" "+studentEndTime;
        					obj1.studentEndDateTime=dateString;
        				}
        				else{
        					flag = false;
        				}
        				
        				if(!isNullOrEmpty(obj.data.id)){
        					if(obj.data.lateFeeConfigurationSetUp.length>0){
        						var data = obj.data.lateFeeConfigurationSetUp[0];
        						var json;
        						var lateFeeData=[];
        						if(data != undefined){
        							var feePlanType={
            								"id":data.feePlanType.id	
            							};
            							var feePlan={
            								"id":data.feePlan.id,
            							};
            							var feeStageMaster={
            									"id":data.feeStageMaster.id
            							}
            							var feePlanRule={
            								"id":data.feePlanRule.id
            							};
            							var termwiseCourseRegistration;
            							if(!isNullOrEmpty(data.termwiseCourseRegistration)){
            								 termwiseCourseRegistration={
                    								"id": parseInt(data.termwiseCourseRegistration.id)
                    							};
            							}
        						}
        							
            					json={
    									"id":parseInt(data.id),
    									"feePlanType":feePlanType,
    									"feePlan":feePlan,
    									"feeStageMaster":feeStageMaster,
    									"feePlanRule":feePlanRule,
    									"amount": data.amount,
    									"whetherActive":data.whetherActive,
    									"termwiseCourseRegistration":termwiseCourseRegistration
    								};
            					lateFeeData.push(json);
            					obj1.lateFeeConfigurationSetUp=lateFeeData;
        					}
        				}else if(!isNullOrEmpty(obj.data.lateFeeConfigurationSetUp)){
        					obj1.lateFeeConfigurationSetUp=obj.data.lateFeeConfigurationSetUp;
        				}
        				obj1.whetherAllowAdd=(obj.data.whetherAllowAdd ? true : false) ;
        				obj1.whetherAllowDrop=(obj.data.whetherAllowDrop ? true : false);
        				obj1.whetherAllowLateFee=(obj.data.whetherAllowLateFee ? true : false);
        				termwiseCourseRegistrationsArr.push(obj1);
					});
        		}
        		/*****************End Course Registration Tab******************/
        		
        		/*****************Profile Update Tab******************/
        		var profileUpdateApplicable = formValues.profileUpdateApplicable;
        		var registrationsetupprofileupdategrid = $this.getRegistrationsetupprofileupdategrid();
        		if(profileUpdateApplicable){
        			var profileUpdateStartDate= new Date();
    				var profileUpdateEndDate= new Date();
        			if(registrationsetupprofileupdategrid.getSelectionModel().getCount()>0) {
	    				var termWiseProfileLinks=[];
    					var records = registrationsetupprofileupdategrid.getStore().data.items;
    					
    					records.forEach(function(obj){
    						var obj1 = new Object(); 
    						obj1.isSelected=isNullOrEmpty(obj.data.isSelected)?false:obj.data.isSelected;
    						obj1.linkName=obj.data.linkName;
            				obj1.sequenceNo=obj.data.sequenceNo;
            				
            				if(obj1.linkName == "Address" && obj1.isSelected == true){
            					obj1.registrationSetupAddress = [];
            					obj1.registrationSetupAddress.push({
            						"addressCode": "CRNT",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.CRNT['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.CRNT['whetherVisible']
            					});
            					obj1.registrationSetupAddress.push({
            						"addressCode": "CRSPDNC",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.CRSPDNC['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.CRSPDNC['whetherVisible']
            					});
            					obj1.registrationSetupAddress.push({
            						"addressCode": "PRMNT",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.PRMNT['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.PRMNT['whetherVisible']
            					});
            					obj1.registrationSetupAddress.push({
            						"addressCode": "OFC",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.OFC['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.OFC['whetherVisible']
            					});
            					obj1.registrationSetupAddress.push({
            						"addressCode": "GOOGLE",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.GOOGLE['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.GOOGLE['whetherVisible']
            					});
            				}
            				
            				if(obj1.linkName == "Parents" && obj1.isSelected == true){
            					obj1.registrationSetupParentDetails = [];
            					obj1.registrationSetupParentDetails.push({
            						"parentCode": "PG1",
            						"whetherMandatory": registrationsetupdetails.configureParentData.PG1['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.PG1['whetherVisible']
            					});
            					obj1.registrationSetupParentDetails.push({
            						"parentCode": "PG2",
            						"whetherMandatory": registrationsetupdetails.configureParentData.PG2['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.PG2['whetherVisible']
            					});
            					obj1.registrationSetupParentDetails.push({
            						"parentCode": "G",
            						"whetherMandatory": registrationsetupdetails.configureParentData.G['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.G['whetherVisible']
            					});
            					obj1.registrationSetupParentDetails.push({
            						"parentCode": "LG",
            						"whetherMandatory": registrationsetupdetails.configureParentData.LG['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.LG['whetherVisible']
            					});
                               obj1.registrationSetupParentDetails.push({
            						"parentCode": "V1",
            						"whetherMandatory": registrationsetupdetails.configureParentData.V1['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.V1['whetherVisible']
            					});
                               obj1.registrationSetupParentDetails.push({
            						"parentCode": "V2",
            						"whetherMandatory": registrationsetupdetails.configureParentData.V2['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.V2['whetherVisible']
            					});
            				}
            				termWiseProfileLinks.push(obj1);
            				
            			});
    				termWiseProfileUpdatesArr.push({
    					id:formValues.hidProfileUpdate,
    					startDate:profileUpdateStartDate,
    					endDate:profileUpdateEndDate,
    					isProfileUpdateApplicable:profileUpdateApplicable,
    					termWiseProfileLinks:termWiseProfileLinks
    				});
    				
        		}
        		else{
        			if(!isNullOrEmpty(formValues.hidProfileUpdate)){
        				var profileUpdateItemId = registrationSetupDetailsPnl.down('#profileUpdateItemId');
        				var termWiseProfileUpdates = profileUpdateItemId.config.profileUpdateRecord;
        				
        				
        				var termWiseProfileLinks=[];
    					var records = termWiseProfileUpdates.termWiseProfileLinks;
    					
    					records.forEach(function(obj){
    						var obj1 = new Object(); 
    						obj1.isSelected=isNullOrEmpty(obj.isSelected)?false:obj.isSelected;
    						obj1.linkName=obj.linkName;
            				obj1.sequenceNo=obj.sequenceNo;
            				
            				if(obj1.linkName == "Address" && obj1.isSelected == true){
            					obj1.registrationSetupAddress = [];
            					obj1.registrationSetupAddress.push({
            						"addressCode": "CRNT",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.CRNT['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.CRNT['whetherVisible']
            					});
            					obj1.registrationSetupAddress.push({
            						"addressCode": "CRSPDNC",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.CRSPDNC['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.CRSPDNC['whetherVisible']
            					});
            					obj1.registrationSetupAddress.push({
            						"addressCode": "PRMNT",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.PRMNT['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.PRMNT['whetherVisible']
            					});
            					obj1.registrationSetupAddress.push({
            						"addressCode": "OFC",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.OFC['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.OFC['whetherVisible']
            					});
            					obj1.registrationSetupAddress.push({
            						"addressCode": "GOOGLE",
            						"whetherMandatory": registrationsetupdetails.configureAddressData.GOOGLE['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureAddressData.GOOGLE['whetherVisible']
            					});
            				}
            				
            				if(obj1.linkName == "Parents" && obj1.isSelected == true){
            					obj1.registrationSetupParentDetails = [];
            					obj1.registrationSetupParentDetails.push({
            						"parentCode": "PG1",
            						"whetherMandatory": registrationsetupdetails.configureParentData.PG1['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.PG1['whetherVisible']
            					});
            					obj1.registrationSetupParentDetails.push({
            						"parentCode": "PG2",
            						"whetherMandatory": registrationsetupdetails.configureParentData.PG2['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.PG2['whetherVisible']
            					});
            					obj1.registrationSetupParentDetails.push({
            						"parentCode": "G",
            						"whetherMandatory": registrationsetupdetails.configureParentData.G['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.G['whetherVisible']
            					});
            					obj1.registrationSetupParentDetails.push({
            						"parentCode": "LG",
            						"whetherMandatory": registrationsetupdetails.configureParentData.LG['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.LG['whetherVisible']
            					});
                               obj1.registrationSetupParentDetails.push({
            						"parentCode": "V1",
            						"whetherMandatory": registrationsetupdetails.configureParentData.V1['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.V1['whetherVisible']
            					});
                               obj1.registrationSetupParentDetails.push({
            						"parentCode": "V2",
            						"whetherMandatory": registrationsetupdetails.configureParentData.V2['whetherMandatory'],
                                    "whetherVisible": registrationsetupdetails.configureParentData.V2['whetherVisible']
            					});
            				}
            				
            				termWiseProfileLinks.push(obj1);
            			});
    					
        				termWiseProfileUpdatesArr.push({
        					id:formValues.hidProfileUpdate,
        					startDate:Ext.Date.format(new Date(termWiseProfileUpdates.startDate),'Y-m-d'),
        					endDate:Ext.Date.format(new Date(termWiseProfileUpdates.endDate),'Y-m-d'),
        					isProfileUpdateApplicable:termWiseProfileUpdates.isProfileUpdateApplicable,
        					termWiseProfileLinks:termWiseProfileLinks
        				});
        			}
        		}
              }
        		
        		/*****************End Profile Update Tab******************/
        		
        		/*****************Document Registration Tab******************/
        		
        		var registrationDocumentApplicable = formValues.registrationDocumentApplicable;
        		var registrationsetupdocumentgrid = $this.getRegistrationsetupdocumentgrid();
        		var termWiseRegistrationDocuments=[];
        		var hidregistrationDocumentId = registrationSetupDetailsPnl.down('#hidregistrationDocumentId').getValue();
        		if(registrationDocumentApplicable){
        			if(registrationsetupdocumentgrid.getSelectionModel().getCount()>0) {
        				var records = registrationsetupdocumentgrid.getSelectionModel().getSelection();

        				records.forEach(function(obj){
        					var obj1 = new Object(); 
        					obj1.isMandatory=obj.data.mandatory;
        					obj1.documentType={
        							"id":obj.data.id
        					};
        					termWiseRegistrationDocuments.push(obj1);
        				});
        				termWiseRegistrationDocumentSetupsArry.push({
        					id:hidregistrationDocumentId,
        					isDocumentApplicable:registrationDocumentApplicable,
        					termWiseRegistrationDocuments:termWiseRegistrationDocuments
        				});
        			}
        			else{
        				if(TabName == "DOCUMENT_TAB"){
        					flag = false;
        					showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('PLEASE_SELECT_DOCUMENTS'));
            				return false;
            			}
        				else{
        					var hidregistrationDocumentId = registrationSetupDetailsPnl.down('#hidregistrationDocumentId').getValue();
        					if(!isNullOrEmpty(hidregistrationDocumentId)){
        						var registrationDocumentItemId = registrationSetupDetailsPnl.down('#registrationDocumentItemId');
                				var termWiseRegistrationDocumentSetups = registrationDocumentItemId.config.registrationDocumentRecord;
                				
                				var records = termWiseRegistrationDocumentSetups.termWiseRegistrationDocuments;
                				var termWiseRegistrationDocuments=[];
                				records.forEach(function(obj){
                					var obj1 = new Object(); 
                					obj1.isMandatory=obj.isMandatory;
                					obj1.documentType={
                							"id":obj.documentType.id
                					};
                					termWiseRegistrationDocuments.push(obj1);
                				});
                				
                				termWiseRegistrationDocumentSetupsArry.push({
                					id:hidregistrationDocumentId,
                					isDocumentApplicable:termWiseRegistrationDocumentSetups.isDocumentApplicable,
                					termWiseRegistrationDocuments:termWiseRegistrationDocuments
                				});
        					}
        				}
        			}
        		}
        		/*****************End Document Registration Tab******************/
        		
        		
               /*****************Additional Setup Tab******************/
        		
        		var registrationsetupdocumentgrid = $this.getRegistrationsetupdocumentgrid();
        		var uploadFileFieldPath= registrationSetupDetailsPnl.down('#uploadFileFieldPath');
        		var hiddenFilePath = registrationSetupDetailsPnl.down('#hiddenFilePath').getValue();
        		var fileValue = registrationSetupDetailsPnl.down('#staticUploadFileField').getValue();
        		var whetherAdditionalSetupApplicable = registrationSetupDetailsPnl.down('#preRegistrationTermConditionApplicable').getValue();
        		var termAndConditionLink = registrationSetupDetailsPnl.down('#termandconditionLinkItemId').getValue();
        		var whetherRegistrationContractApplicable = registrationSetupDetailsPnl.down('#registraionContractApplicable').getValue();
        		
        		var uploadFileFieldPathRegContract= registrationSetupDetailsPnl.down('#uploadFileFieldPathRegContract');
        		var hiddenRegContractFilePath = registrationSetupDetailsPnl.down('#hiddenRegContractFilePath').getValue();
        		var fileValueRegContract = registrationSetupDetailsPnl.down('#staticUploadFileFieldRegContract').getValue();
        		
        		var additionalSetupItemId = registrationSetupDetailsPnl.down('#additionalSetupItemId');
        		
        		
        		try{
        			var additionalSetupRecordDocument = additionalSetupItemId.config.additionalSetupRecord.document;
        		}
        		catch(e){
        			additionalSetupItemId.config.additionalSetupRecord = {};
        			additionalSetupItemId.config.additionalSetupRecord.document = null;
        			var additionalSetupRecordDocument = null;
        		}
        		
        		try{
        			var registrationContractRecordDocument = additionalSetupItemId.config.registrationContractRecord.document;
        		}
        		catch(e){
        			additionalSetupItemId.config.registrationContractRecord = {};
        			additionalSetupItemId.config.registrationContractRecord.document = null;
        			var registrationContractRecordDocument = null;
        		}
        		

        		
        		if(!isNullOrEmpty(formValues.hideAdditionalSetup)){
        			var msgContentVal = "";
        			if(TabName != "ADDITIONAL_TAB"){
        				var additionalSetupItemId = registrationSetupDetailsPnl.down('#additionalSetupItemId');
        				msgContentVal = !isNullOrEmpty(formValues.registrationCkEditor) ? formValues.registrationCkEditor : additionalSetupItemId.config.additionalSetupRecord.msgContent;
        			} else{
        				msgContentVal = formValues.registrationCkEditor;
        			}
        			 if (!isNullOrEmpty(formValues.AdditionalUploadedDocument) && !isNullOrEmpty(fileValue)&& !isNullOrEmpty(uploadFileFieldPath.config.document)){
							uploadFileFieldPath.config.document.id = formValues.AdditionalUploadedDocument;
							termWiseAdditionalSetupsArrayObj ={
     						    id:formValues.hideAdditionalSetup,
     							msgContent:msgContentVal,
     							document: additionalSetupRecordDocument, // uploadFileFieldPath.config.document,
     							whetherAdditionalSetupApplicable: whetherAdditionalSetupApplicable,
     							termAndConditionLink:termAndConditionLink
     					} 
        			 }	
        			 else if(!isNullOrEmpty(fileValue)){
        				 termWiseAdditionalSetupsArrayObj ={
     						    id:formValues.hideAdditionalSetup,
     							msgContent:msgContentVal,
     							document: additionalSetupRecordDocument, //uploadFileFieldPath.config.document,
     							whetherAdditionalSetupApplicable: whetherAdditionalSetupApplicable,
     							termAndConditionLink:termAndConditionLink
     					} 
        			 }else{
							var termWiseAdditionalSetupsArrayObj ={
									id:formValues.hideAdditionalSetup,
        							msgContent:msgContentVal,
        							document: null,
        							whetherAdditionalSetupApplicable: whetherAdditionalSetupApplicable,
         							termAndConditionLink:termAndConditionLink
        					} 
						}
        			 if (!isNullOrEmpty(formValues.RegContractUploadedDocument) && !isNullOrEmpty(fileValueRegContract)&& !isNullOrEmpty(uploadFileFieldPathRegContract.config.document)){
        				 uploadFileFieldPathRegContract.config.document.id = formValues.RegContractUploadedDocument;
        				 termWiseRegistrationContractArrayObj={
            					 id:formValues.hideRegContractAdditionalSetup,
            					 registrationContractMsgContent:formValues.registrationContractCkEditor,
            					 termAndConditionLink:formValues.termandconditionLinkRegistraion,
            					 termAndConditionOne:formValues.check1TextField,
            					 termAndConditionTwo:formValues.check2TextField,
            					 termAndConditionThree:formValues.check3TextField,
            					 document:null,//registrationContractRecordDocument, //uploadFileFieldPathRegContract.config.document,
            					 whetherRegistrationContractApplicable: whetherRegistrationContractApplicable
            			 }
        			 }else if(!isNullOrEmpty(fileValueRegContract)){
        				 termWiseRegistrationContractArrayObj={
            					 id:formValues.hideRegContractAdditionalSetup,
            					 registrationContractMsgContent:formValues.registrationContractCkEditor,
            					 termAndConditionLink:formValues.termandconditionLinkRegistraion,
            					 termAndConditionOne:formValues.check1TextField,
            					 termAndConditionTwo:formValues.check2TextField,
            					 termAndConditionThree:formValues.check3TextField,
            					 document: null, //registrationContractRecordDocument, //uploadFileFieldPathRegContract.config.document,
            					 whetherRegistrationContractApplicable: whetherRegistrationContractApplicable
            			 }
        			 }else{
        				 termWiseRegistrationContractArrayObj={
            					 id:formValues.hideRegContractAdditionalSetup,
            					 registrationContractMsgContent:formValues.registrationContractCkEditor,
            					 termAndConditionLink:formValues.termandconditionLinkRegistraion,
            					 termAndConditionOne:formValues.check1TextField,
            					 termAndConditionTwo:formValues.check2TextField,
            					 termAndConditionThree:formValues.check3TextField,
            					 document:null,
            					 whetherRegistrationContractApplicable: whetherRegistrationContractApplicable
            			 }
        			 }
        			 
        			 registrationGuidelinesArrayObj={
     						id:formValues.regGuidelineId,
     						ckeditorData:formValues.regGuidelineCkEditor,
     						isRegistrationGuideline:(formValues.registrationGuidelinesApplicable == 'on') ? true : false
     				}
        		}
        		
        		else if(TabName == "ADDITIONAL_TAB"){
        			var registrationDocumentItemId = registrationSetupDetailsPnl.down('#registrationDocumentItemId');
        			if(hiddenFilePath == "true") {
        				var termWiseAdditionalSetupsArrayObj ={
        						id:formValues.hideAdditionalSetup,
        						msgContent:formValues.registrationCkEditor,
        						document: additionalSetupRecordDocument, //uploadFileFieldPath.config.document,
        						whetherAdditionalSetupApplicable: whetherAdditionalSetupApplicable,
        						termAndConditionLink:termAndConditionLink
        				} 

        			}
        			else if (!isNullOrEmpty(formValues.AdditionalUploadedDocument) && !isNullOrEmpty(fileValue)){
        				uploadFileFieldPath.config.document.id = formValues.AdditionalUploadedDocument;
        				var termWiseAdditionalSetupsArrayObj ={
        						id:formValues.hideAdditionalSetup,
        						msgContent:formValues.registrationCkEditor,
        						document: additionalSetupRecordDocument, //uploadFileFieldPath.config.document,
        						whetherAdditionalSetupApplicable: whetherAdditionalSetupApplicable,
        						termAndConditionLink:termAndConditionLink
        				} 
        			}
        			else{
        				var termWiseAdditionalSetupsArrayObj ={
        						msgContent:formValues.registrationCkEditor,
        						document: null,
        						whetherAdditionalSetupApplicable: whetherAdditionalSetupApplicable,
        						termAndConditionLink:termAndConditionLink
        				} 
        			}
        			if(hiddenRegContractFilePath == "true") {
        				termWiseRegistrationContractArrayObj={
        						id:formValues.hideRegContractAdditionalSetup,
        						registrationContractMsgContent:formValues.registrationContractCkEditor,
        						termAndConditionLink:formValues.termandconditionLinkRegistraion,
        						termAndConditionOne:formValues.check1TextField,
        						termAndConditionTwo:formValues.check2TextField,
        						termAndConditionThree:formValues.check3TextField,
        						document: null,//registrationContractRecordDocument, //uploadFileFieldPathRegContract.config.document,
        						whetherRegistrationContractApplicable: whetherRegistrationContractApplicable
        				}
        			}else if(!isNullOrEmpty(formValues.RegContractUploadedDocument) && !isNullOrEmpty(fileValueRegContract)){
        				uploadFileFieldPathRegContract.config.document.id = formValues.RegContractUploadedDocument;
        				termWiseRegistrationContractArrayObj={
        						id:formValues.hideRegContractAdditionalSetup,
        						registrationContractMsgContent:formValues.registrationContractCkEditor,
        						termAndConditionLink:formValues.termandconditionLinkRegistraion,
        						termAndConditionOne:formValues.check1TextField,
        						termAndConditionTwo:formValues.check2TextField,
        						termAndConditionThree:formValues.check3TextField,
        						document: null, //registrationContractRecordDocument, //uploadFileFieldPathRegContract.config.document,
        						whetherRegistrationContractApplicable: whetherRegistrationContractApplicable
        				}
        			}else{
        				termWiseRegistrationContractArrayObj={
        						id:formValues.hideRegContractAdditionalSetup,
        						registrationContractMsgContent:formValues.registrationContractCkEditor,
        						termAndConditionLink:formValues.termandconditionLinkRegistraion,
        						termAndConditionOne:formValues.check1TextField,
        						termAndConditionTwo:formValues.check2TextField,
        						termAndConditionThree:formValues.check3TextField,
        						document:null,
        						whetherRegistrationContractApplicable: whetherRegistrationContractApplicable
        				}
        			}
        			
        			registrationGuidelinesArrayObj={
    						id:formValues.regGuidelineId,
    						ckeditorData:formValues.regGuidelineCkEditor,
    						isRegistrationGuideline:(formValues.registrationGuidelinesApplicable == 'on') ? true : false
    				}
        		}
        		/*****************End Additional setup Tab******************/
        		
        		if(flag && whetherDateValidate){
        			
        			//--check registration rules permission
        			var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
					var privilegeList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getREGISTRATION_SETUP_PRIVILEGES_PERMISSIONS());
					
					var isCreditValuesValidFlag = true;
					
					if(Ext.Array.contains(privilegeList,"REGISTRATION_RULES")){
						var registrationrulestabregistrationsetupdetails = $this.getRegistrationrulestabregistrationsetupdetails();
						var loadedRegistrationRules = registrationsetupdetails.registrationRules;
						if(!isNullOrEmpty(registrationrulestabregistrationsetupdetails)){
							var registrationrulesgrid = registrationrulestabregistrationsetupdetails.down('grid');
							
							if(registrationrulesgrid.store.data.items.length){
								var allRules = Ext.Array.pluck(Ext.Array.pluck(registrationrulesgrid.store.data.items,'data'),'value');
								var selectedRules = registrationrulesgrid.getSelectionModel().getSelection();
								var selectedRulesArray = [];
								if(selectedRules.length){
									var selectedRulesArray = Ext.Array.pluck(Ext.Array.pluck(registrationrulesgrid.getSelectionModel().getSelection(),'data'),'value');
								}
								Ext.each(allRules, function(currentRule){
									var registrationRuleId = '';
									if(loadedRegistrationRules && loadedRegistrationRules.length){
										var loadedRegistrationRuleRec = loadedRegistrationRules.find(function(rec){
										    return rec.registrationRule == currentRule;
										});
										if(!isNullOrEmpty(loadedRegistrationRuleRec)){
											registrationRuleId = loadedRegistrationRuleRec.id;
										}
									}
									if(Ext.Array.contains(selectedRulesArray,currentRule)){
										var maximumCredit = null;
										var minimumCredit = null;
										var maxCreditForRegularCourses = null;
										var maxCreditForABRCourses = null;
										
										var minNumberCourseGroupField = null;
										var maxNumberCourseGroupField = null;
										if(currentRule == "Yearly Registrations Applicable"){
											minimumCredit = (Ext.ComponentQuery.query("#minNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#minNumberOfCreditYearly")[Ext.ComponentQuery.query("#minNumberOfCreditYearly").length-1].getValue() : null;
											maximumCredit = (Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length) ? Ext.ComponentQuery.query("#maxNumberOfCreditYearly")[Ext.ComponentQuery.query("#maxNumberOfCreditYearly").length-1].getValue() : null;
											maxCreditForRegularCourses = (Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxRegularCourseCreditYearly")[Ext.ComponentQuery.query("#maxRegularCourseCreditYearly").length-1].getValue() : null;
											maxCreditForABRCourses = (Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length) ? Ext.ComponentQuery.query("#maxOtherCourseCreditYearly")[Ext.ComponentQuery.query("#maxOtherCourseCreditYearly").length-1].getValue() : null;
										
											if(minimumCredit<1 || minimumCredit>9999 || maxCreditForRegularCourses<0 || maxCreditForRegularCourses>999 || maxCreditForABRCourses<0 || maxCreditForABRCourses>999 || maximumCredit<1 || maximumCredit>9999 || maximumCredit<minimumCredit){
												isCreditValuesValidFlag = false;
											}
										
										}
										else if(currentRule == "Course Group"){
											minNumberCourseGroupField = (Ext.ComponentQuery.query("#minNumberCourseGroupField").length) ? Ext.ComponentQuery.query("#minNumberCourseGroupField")[Ext.ComponentQuery.query("#minNumberCourseGroupField").length-1].getValue() : null;
											maxNumberCourseGroupField = (Ext.ComponentQuery.query("#maxNumberCourseGroupField").length) ? Ext.ComponentQuery.query("#maxNumberCourseGroupField")[Ext.ComponentQuery.query("#maxNumberCourseGroupField").length-1].getValue() : null;
										}
										termWiseRegistrationRulesArrayObj.push({
								            "id":registrationRuleId,
								            "whetherMandatory": true,
								            "registrationRule": currentRule,
								            "minimumCredit": minimumCredit,
								            "maximumCredit": maximumCredit,
								            "maximumModuleGroup": maxNumberCourseGroupField,
								            "minimumModuleGroup": minNumberCourseGroupField,
								            "maxCreditForRegularCourses": maxCreditForRegularCourses,
								            "maxCreditForABRCourses":maxCreditForABRCourses
								        });
									}
									else{
										if(!registrationrulestabregistrationsetupdetails.isOpened && Array.isArray(loadedRegistrationRules) && loadedRegistrationRules.length > 0){
											Ext.each(loadedRegistrationRules, function(currentLoadedRule){
												if(currentLoadedRule.registrationRule == currentRule){
													termWiseRegistrationRulesArrayObj.push({
											            "id":currentLoadedRule.id,
											            "whetherMandatory": currentLoadedRule.whetherMandatory,
											            "registrationRule": currentLoadedRule.registrationRule,
											            "minimumCredit": currentLoadedRule.minimumCredit,
											            "maximumCredit": currentLoadedRule.maximumCredit,
											            "maximumModuleGroup": currentLoadedRule.maximumModuleGroup,
											            "minimumModuleGroup": currentLoadedRule.minimumModuleGroup
											        });
												}
											});
										}
										else {
											termWiseRegistrationRulesArrayObj.push({
									            "id":registrationRuleId,
									            "whetherMandatory": false,
									            "registrationRule": currentRule,
									            "minimumCredit": null,
									            "maximumCredit": null,
									            "maximumModuleGroup": null,
									            "minimumModuleGroup": null
									        });
										}
									}
								});
								
								if(termWiseRegistrationRulesArrayObj.length == 0 && loadedRegistrationRules.length>0){
									//--direct values here
									Ext.each(loadedRegistrationRules, function(currentLoadedRule){
										termWiseRegistrationRulesArrayObj.push({
								            "id":currentLoadedRule.id,
								            "whetherMandatory": currentLoadedRule.whetherMandatory,
								            "registrationRule": currentLoadedRule.registrationRule,
								            "minimumCredit": currentLoadedRule.minimumCredit,
								            "maximumCredit": currentLoadedRule.maximumCredit,
								            "maximumModuleGroup": currentLoadedRule.maximumModuleGroup,
								            "minimumModuleGroup": currentLoadedRule.minimumModuleGroup,
								            "maxCreditForRegularCourses": currentLoadedRule.maxCreditForRegularCourses,
								            "maxCreditForABRCourses":currentLoadedRule.maxCreditForABRCourses
								        });
									});
								}
							}
						}
						else{
							//--direct values here
							Ext.each(loadedRegistrationRules, function(currentLoadedRule){
								termWiseRegistrationRulesArrayObj.push({
						            "id":currentLoadedRule.id,
						            "whetherMandatory": currentLoadedRule.whetherMandatory,
						            "registrationRule": currentLoadedRule.registrationRule,
						            "minimumCredit": currentLoadedRule.minimumCredit,
						            "maximumCredit": currentLoadedRule.maximumCredit,
						            "maximumModuleGroup": currentLoadedRule.maximumModuleGroup,
						            "minimumModuleGroup": currentLoadedRule.minimumModuleGroup,
						            "maxCreditForRegularCourses": currentLoadedRule.maxCreditForRegularCourses,
						            "maxCreditForABRCourses":currentLoadedRule.maxCreditForABRCourses
						        });
							});
						}
					}
					
					if((!Ext.isDefined(registrationGuidelinesArrayObj.id) || isNullOrEmpty(registrationGuidelinesArrayObj.id)) && Ext.isDefined(additionalSetupItemId) && additionalSetupItemId.config.registrationGuidelineRecord && additionalSetupItemId.config.registrationGuidelineRecord.id){
						registrationGuidelinesArrayObj={
	    						id:additionalSetupItemId.config.registrationGuidelineRecord.id,
	    						ckeditorData:additionalSetupItemId.config.registrationGuidelineRecord.ckeditorData,
	    						isRegistrationGuideline:additionalSetupItemId.config.registrationGuidelineRecord.isRegistrationGuideline
	    				}
					}
					else if(isNullOrEmpty(registrationGuidelinesArrayObj.ckeditorData) && isNullOrEmpty(registrationGuidelinesArrayObj.id)){
						registrationGuidelinesArrayObj={
	    						id:null,
	    						ckeditorData:null,
	    						isRegistrationGuideline:null
	    				}
					}
					
					if(registrationGuidelinesArrayObj.isRegistrationGuideline == true){
						if(registrationGuidelinesArrayObj.ckeditorData == "<html>\n<head>\n\t<title></title>\n</head>\n<body></body>\n</html>\n" || isNullOrEmpty(registrationGuidelinesArrayObj.ckeditorData)){
							showErrorMessage(getCommonTranslation('FAILURE'), getPersonModuleTranslation("MANDATORY_FIELDS_NOT_FILLED"));
							return false;
						}
					}
					
					if(isCreditValuesValidFlag == false){
						showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation("CREDIT_VALUE_INVALID_MSG"));
						return false;
					}
					
					if(registrationsetupdetails.registrationValidations && registrationsetupdetails.registrationValidations.length){
						Ext.each(registrationsetupdetails.registrationValidations, function(rv){
							termWiseRegistrationValidationArrayObj.push({
								"id": rv.id,
		        	            "whetherMandatory": rv.whetherMandatory,
		        	            "registrationValidation": rv.registrationValidation
							});
						});
					}
					else{
						termWiseRegistrationValidationArrayObj = [{
	        	            "id": "",
	        	            "whetherMandatory": false,
	        	            "registrationValidation": "mandatoryChecksBypass"
	        	        },
	        	        {
	        	            "id": "",
	        	            "whetherMandatory": false,
	        	            "registrationValidation": "minCoursesCourseGroupChecksBypass"
	        	        },
	        	        {
	        	            "id": "",
	        	            "whetherMandatory": false,
	        	            "registrationValidation": "yearlyMinCreditChecksBypass"
	        	        },
	        	        {
	        	            "id": "",
	        	            "whetherMandatory": false,
	        	            "registrationValidation": "minCreditChecksForCourseGroupBypass"
	        	        },
	        	        {
	        	            "id": "",
	        	            "whetherMandatory": false,
	        	            "registrationValidation": "minCourseGroupChecksBypass"
	        	        },
	        	        {
	        	            "id": "",
	        	            "whetherMandatory": false,
	        	            "registrationValidation": "moduleGroupChecksBypass"
	        	        }];
					}
        			
        			mainJsonObj.termwiseCourseRegistrations=termwiseCourseRegistrationsArr;
        			mainJsonObj.termWiseProfileUpdates=termWiseProfileUpdatesArr;
        			mainJsonObj.termWiseRegistrationDocumentSetups=termWiseRegistrationDocumentSetupsArry;
        			mainJsonObj.termWiseAdditionalSetup = termWiseAdditionalSetupsArrayObj;
        			mainJsonObj.termWiseRegistrationContract = termWiseRegistrationContractArrayObj;
        			mainJsonObj.termWiseRegistrationRules = termWiseRegistrationRulesArrayObj;
        			mainJsonObj.termWiseRegistrationValidations = termWiseRegistrationValidationArrayObj;
        			mainJsonObj.registrationGuidelines = registrationGuidelinesArrayObj;
        			if(mainJsonObj && mainJsonObj.termWiseRegistrationContract && isNullOrEmpty(mainJsonObj.termWiseRegistrationContract.registrationContractMsgContent) && !isNullOrEmpty(additionalSetupItemId.config.registrationContractRecord.registrationContractMsgContent)){
                        mainJsonObj.termWiseRegistrationContract.registrationContractMsgContent = additionalSetupItemId.config.registrationContractRecord.registrationContractMsgContent;
                    }
        			var submitUrl = SERVERURL.PATH_SAVE_REGISTRATION_TERM_SETUP_DETAIL;
        			if(!isNullOrEmpty(mainJsonObj.id)){
        				submitUrl = SERVERURL.PATH_UPDATE_REGISTRATION_TERM_SETUP_DETAIL;
        			}
        			mainJsonObj = Ext.encode(mainJsonObj);
            		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		Ext.Ajax.request({
            			type : 'rest',
            			url : submitUrl,
            			jsonData : mainJsonObj,
            			method : 'POST',
            			success : function(form, action) {
            				Ext.getBody().unmask();
            				
            				if(!isNullOrEmpty(form.responseText) && form.responseText == "Duplicate"){
            					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REGISTRATION_SETUP_DUPLICATE_MSG'));
            				}else{
            					var resData = Ext.JSON.decode(form.responseText);
                				showSuccessMessage(getCommonTranslation('REGISTRATION_SETUP_DETAILS'),getCommonTranslation('SUCCESS'));
                				$this.getContentPanel().getActiveTab().close();
                				$this.loadRegistrationSetupGrid();
            				}
            			},
            			failure: function(form, action) {
            				Ext.getBody().unmask();
        					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
            			}
            		});
        		} else if(!whetherDateValidate){
        			var alertMessage = "";
        			if(adminStartDateAlertMessage != ""){
        				alertMessage += adminStartDateAlertMessage;
        			}
        			if(adminEndDateAlertMessage != ""){
        				alertMessage += alertMessage != "" ? "<br/>"+adminEndDateAlertMessage : adminEndDateAlertMessage;
        			}
        			if(studentStartDateAlertMessage != ""){
        				alertMessage += alertMessage != "" ? "<br/>"+studentStartDateAlertMessage : studentStartDateAlertMessage;
        			}
        			if(studentEndDateAlertMessage != ""){
        				alertMessage += alertMessage != "" ? "<br/>"+studentEndDateAlertMessage : studentEndDateAlertMessage;
        			}
        			if(profileUpdateStartDateMSG != ""){
        				alertMessage += alertMessage != "" ? "<br/>"+profileUpdateStartDateMSG : profileUpdateStartDateMSG;
        			}
        			if(profileUpdateEndDateMSG != ""){
        				alertMessage += alertMessage != "" ? "<br/>"+profileUpdateEndDateMSG : profileUpdateEndDateMSG;
        			}
        			if(alertMessage != ""){
        				showWarningMessage(getCommonTranslation('ALERT'),alertMessage);
        			}
        		}
        		else{
        			showWarningMessage(getCommonTranslation('ALERT'),getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
        		}
				
			},
			editRegistrationSetupRecord:function(){
				var $this = this;
				var grid = $this.getRegistrationsetupgrid();
				if(grid.getSelectionModel().getCount()>0) {
					$this.addRegistrationSetupScreen('edit');
					var structure = this.getRegistrationsetupdetails();
					var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

					var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
					var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
					var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
					var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
					//var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");
					
					progresstracker1.hide();
					progresstracker2.hide();
					progresstracker3.hide();
					progresstracker4.hide();
					//progresstracker5.hide();
					
					var record = grid.getSelectionModel().getSelection()[0];
					var registrationsetupdetails = $this.getRegistrationsetupdetails();
					var registrationsetupdetailstabpanel = $this.getRegistrationsetupdetailstabpanel();
					var courseregistrationeditablegrid = $this.getCourseregistrationeditablegrid();
					
					var profileUpdateItemId = registrationsetupdetailstabpanel.down('#profileUpdateItemId');
					var registrationDocumentItemId = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
					registrationsetupdetails.config.isAddForm = false;
					registrationDocumentItemId.config.registrationDocumentRecord = null;
					profileUpdateItemId.config.profileUpdateRecord = null;
					var submitUrl = SERVERURL.PATH_FINDBYID_REGISTRATION_TERM_SETUP_DETAIL;
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl+"?id="+record.data.registrationSetupId,
						method : 'GET',
						success : function(resp, action) {
							Ext.getBody().unmask();
							var data = Ext.decode(resp.responseText);
							if(!isNullOrEmpty(data)){
								registrationsetupdetails.registrationRules = data.termWiseRegistrationRules;
								registrationsetupdetails.registrationValidations = data.termWiseRegistrationValidations;
								
								var academicTerm = registrationsetupdetails.down('#academicTerm');
								//registrationsetupdetails.down('#updateCourseRegistrationBtn').show();
								var registrationSetupNameId = registrationsetupdetails.down('#registrationSetupNameId');
								var registrationSetupId = registrationsetupdetails.down('#registrationSetupId');
								//var hidPeriodRegistrationId = registrationsetupdetailstabpanel.down('#hidPeriodRegistrationId');
								registrationSetupId.setValue(data.id);
								
								academicTerm.getStore().load({
									callback:function(record) {
										academicTerm.setValue(data.academicTerm.id);
									}
								});
								var whetherAutoApproved = registrationsetupdetails.down('#whetherAutoApproved');
								whetherAutoApproved.setValue(data.whetherAutoApproved);
								Ext.Ajax.request({
								type : 'rest',
								url : SERVERURL.PATH_MAPPED_PERIOD_STUDENT_COUNT+"?registrationSetupId="+record.data.registrationSetupId,
								method : 'GET',
								success : function(resp, action) {
									var count = Ext.decode(resp.responseText);
									if(count>0){
										whetherAutoApproved.setReadOnly(true);
									  }
									}
								});
								
								var RegistrationTermGridComboStore = Ext.getStore('registrationsetup.RegistrationTermGridComboStore');
								RegistrationTermGridComboStore.load();
								registrationSetupNameId.setValue(data.registrationSetupName);
								
								if(data.termwiseCourseRegistrations.length>0){
									var courseRegistrationItemId = registrationsetupdetailstabpanel.down('#courseRegistrationItemId');
									courseRegistrationItemId.setDisabled(false);
									var serialNo = 0;
									var ObjModel = [];
									courseregistrationeditablegrid.getStore().removeAll();
									data.termwiseCourseRegistrations.forEach(function(obj){
										
										serialNo = serialNo + 1;
										var courseRegistrationGridModel = new Academia.model.registrationsetup.CourseRegistrationGridModel();
										courseRegistrationGridModel.set("serialNo", serialNo);
										courseRegistrationGridModel.set("id", obj.id);
										courseRegistrationGridModel.set("registrationTerm", obj.registrationTerm.id);
										if(!isNullOrEmpty(obj.adminStartDateTime)){
											//var date = Ext.Date.format(new Date(obj.stringAdminStartDate),'d-m-Y');
											courseRegistrationGridModel.set("adminStartDate",  new Date(obj.adminStartDateTime));
										}
										
										courseRegistrationGridModel.set("adminStartTime", moment(obj.stringAdminStartTime, 'HH:mm A')._d);
										
										if(!isNullOrEmpty(obj.adminEndDateTime)){
											//var date = Ext.Date.format(new Date(obj.stringAdminEndDate),'d-m-Y');
											//courseRegistrationGridModel.set("adminEndDate", Ext.Date.parse(date,'d-m-Y'));
											courseRegistrationGridModel.set("adminEndDate",new Date(obj.adminEndDateTime));
										}
										
										courseRegistrationGridModel.set("adminEndTime", moment(obj.stringAdminEndTime, 'HH:mm A')._d);
										
										if(!isNullOrEmpty(obj.studentStartDateTime)){
											//var date = Ext.Date.format(new Date(obj.stringStudentStartDate),'d-m-Y');
											//courseRegistrationGridModel.set("studentStartDate", Ext.Date.parse(date,'d-m-Y'));
											courseRegistrationGridModel.set("studentStartDate",new Date(obj.studentStartDateTime));
										}
										courseRegistrationGridModel.set("studentStartTime", moment(obj.stringStudentStartTime, 'HH:mm A')._d);
										
										if(!isNullOrEmpty(obj.studentEndDateTime)){
											//var date = Ext.Date.format(new Date(obj.stringStudentEndDate),'d-m-Y');
											//courseRegistrationGridModel.set("studentEndDate", Ext.Date.parse(date,'d-m-Y'));
											courseRegistrationGridModel.set("studentEndDate",new Date(obj.studentEndDateTime));
										}
										courseRegistrationGridModel.set("studentEndTime", moment(obj.stringStudentEndTime, 'HH:mm A')._d);
										courseRegistrationGridModel.set("whetherAllowAdd", obj.whetherAllowAdd);
										courseRegistrationGridModel.set("whetherAllowDrop", obj.whetherAllowDrop);
										courseRegistrationGridModel.set("whetherAllowLateFee", obj.whetherAllowLateFee);
										courseRegistrationGridModel.set("isAddDeleteRow", true);
										courseRegistrationGridModel.set("isEditCourseReg", true);
										courseRegistrationGridModel.set("lateFeeConfigurationSetUp", obj.lateFeeConfigurationSetUp);
										/*courseRegistrationGridModel.set("periodStartDate", new Date(data.termwisePeriodRegistrations[0].periodStartDate));
										courseRegistrationGridModel.set("periodEndDate", new Date(data.termwisePeriodRegistrations[0].periodEndDate));
										courseRegistrationGridModel.set("studentPeriodStartDate", new Date(data.termwisePeriodRegistrations[0].studentPeriodStartDate));
										courseRegistrationGridModel.set("studentPeriodEndDate", new Date(data.termwisePeriodRegistrations[0].studentPeriodEndDate));*/
										courseRegistrationGridModel.commit();
										ObjModel.push(courseRegistrationGridModel);
										
					 					lateFeeArrayOfMultipleReg[serialNo-1]=obj.lateFeeConfigurationSetUp[0];
									});
									
									courseregistrationeditablegrid.getStore().loadRawData(ObjModel, true);
									
									courseregistrationeditablegrid.config.isView=false;
									
								}
								
								if(data.termWiseProfileUpdates.length>0){
									var profileUpdateItemId = registrationsetupdetailstabpanel.down('#profileUpdateItemId');
									profileUpdateItemId.setDisabled(false);
									profileUpdateItemId.config.profileUpdateRecord = data.termWiseProfileUpdates[0];
									var hidProfileUpdateId = registrationsetupdetailstabpanel.down('#hidProfileUpdateId');
									hidProfileUpdateId.setValue(data.termWiseProfileUpdates[0].id);
									
									var registrationsetupprofileupdategrid = $this.getRegistrationsetupprofileupdategrid();
									
									registrationsetupdetails.down('[name=profileUpdateApplicable]').setValue(data.termWiseProfileUpdates[0].isProfileUpdateApplicable);
									
									var termWiseProfileLinks = data.termWiseProfileUpdates[0].termWiseProfileLinks;
									if(termWiseProfileLinks.length>0){
										var ObjModel = [];
										registrationsetupprofileupdategrid.getStore().removeAll();
										termWiseProfileLinks.forEach(function(obj){
											var registrationSetupProfileUpdateGridModel = new Academia.model.registrationsetup.RegistrationSetupProfileUpdateGridModel();
											registrationSetupProfileUpdateGridModel.set("id", obj.id);
											registrationSetupProfileUpdateGridModel.set("linkName", obj.linkName);
											registrationSetupProfileUpdateGridModel.set("sequenceNo", obj.sequenceNo);
											registrationSetupProfileUpdateGridModel.set("isSelected", obj.isSelected);
											registrationSetupProfileUpdateGridModel.commit();
						            		ObjModel.push(registrationSetupProfileUpdateGridModel);
										});
					            		registrationsetupprofileupdategrid.getStore().loadRawData(ObjModel, true);
									}
									
									
								}else{
									var profileUpdateItemId = registrationsetupdetailstabpanel.down('#profileUpdateItemId');
									profileUpdateItemId.setDisabled(false);
									var registrationsetupprofileupdategrid = $this.getRegistrationsetupprofileupdategrid();
									Ext.Ajax.request({
										method : "GET",
										type : 'rest',
										url : SERVERURL.PATH_GET_PROFILE_LINK_GRID_DATA,
										success : function(form,action) {
											if(!isNullOrEmpty(form.responseText)){
												var data = Ext.JSON.decode(form.responseText);
												if(data.length>0){
													var ObjModel = [];
													registrationsetupprofileupdategrid.getStore().removeAll();
													data.forEach(function(obj){
														var registrationSetupProfileUpdateGridModel = new Academia.model.registrationsetup.RegistrationSetupProfileUpdateGridModel();
														registrationSetupProfileUpdateGridModel.set("id", obj.id);
														registrationSetupProfileUpdateGridModel.set("linkName", obj.value);
														registrationSetupProfileUpdateGridModel.set("sequenceNo", obj.sequence);
														registrationSetupProfileUpdateGridModel.commit();
									            		ObjModel.push(registrationSetupProfileUpdateGridModel);
													});
								            		registrationsetupprofileupdategrid.getStore().loadRawData(ObjModel, true);
												}
											}
										}
									});
								}
								
								if(data.termWiseRegistrationDocumentSetups.length>0){
									var registrationDocumentItemId = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
									registrationDocumentItemId.setDisabled(false);
									
									registrationDocumentItemId.config.registrationDocumentRecord = data.termWiseRegistrationDocumentSetups[0];
									
									var hidregistrationDocumentId = registrationsetupdetailstabpanel.down('#hidregistrationDocumentId');
									hidregistrationDocumentId.setValue(data.termWiseRegistrationDocumentSetups[0].id);
									
									var registrationDocumentApplicableId = registrationsetupdetailstabpanel.down('#registrationDocumentApplicableId');
									registrationDocumentApplicableId.setValue(data.termWiseRegistrationDocumentSetups[0].isDocumentApplicable);
									
									var registrationsetupdocumentgrid = registrationsetupdetailstabpanel.down('#registrationsetupdocumentgridItemId') //$this.getRegistrationsetupdocumentgrid();
									
								}
								
								if(data.termWiseAdditionalSetup  && data.termWiseAdditionalSetup.id){
									var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
									additionalSetupItemId.setDisabled(false);
									additionalSetupItemId.config.additionalSetupRecord = data.termWiseAdditionalSetup;
									registrationsetupdetailstabpanel.down('#hideAdditionalSetupItemId').setValue(data.termWiseAdditionalSetup.id);
									if(data.termWiseAdditionalSetup.document){
										registrationsetupdetailstabpanel.down('#AdditionalUploadedDocumentItemId').setValue(data.termWiseAdditionalSetup.document.id);
										registrationsetupdetailstabpanel.down('#encryptedDocId').setValue(data.termWiseAdditionalSetup.document.encryptedDocId);
										registrationsetupdetailstabpanel.down('#staticUploadFileField').setRawValue(data.termWiseAdditionalSetup.document.path);
										registrationsetupdetailstabpanel.down('#availableDocumentLabelItemId').setVisible(true);
									}
									registrationsetupdetailstabpanel.down('#termandconditionLinkItemId').setValue(data.termWiseAdditionalSetup.termAndConditionLink);
									if(data.termWiseAdditionalSetup.whetherAdditionalSetupApplicable){
										registrationsetupdetailstabpanel.down('#preRegistrationTermConditionApplicable').setValue(true);
									}
									else{
										registrationsetupdetailstabpanel.down('#preRegistrationTermConditionApplicable').setValue(false);
										var preRegFieldContainer1 = registrationsetupdetailstabpanel.down('#preRegFieldContainer1');
										var preRegFieldContainer2 = registrationsetupdetailstabpanel.down('#preRegFieldContainer2');
										var preRegFieldContainer3 = registrationsetupdetailstabpanel.down('#preRegFieldContainer3');
										var preRegFieldContainer4 = registrationsetupdetailstabpanel.down('#preRegFieldContainer4');
										preRegFieldContainer1.setVisible(false);
										preRegFieldContainer2.setVisible(false);
										preRegFieldContainer3.setVisible(false);
										preRegFieldContainer4.setVisible(false);
									}
									registrationsetupdetailstabpanel.config.additionalSetupMsgString = data.termWiseAdditionalSetup.msgContent;
									registrationsetupdetailstabpanel.down('#additionalSetupMode').setValue('edit_mode');
									//registrationsetupdetailstabpanel.config.Mode = "edit_mode";
								}
								else{
									var registrationDocumentItemId = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
									registrationDocumentItemId.setDisabled(false);
									
									var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
									additionalSetupItemId.setDisabled(false);
								}
								
								if(data.termWiseRegistrationContract  && data.termWiseRegistrationContract.id){
									var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
									additionalSetupItemId.setDisabled(false);
									additionalSetupItemId.config.registrationContractRecord = data.termWiseRegistrationContract;
									
									registrationsetupdetailstabpanel.down('#hideRegContractAdditionalSetupItemId').setValue(data.termWiseRegistrationContract.id);
									registrationsetupdetailstabpanel.down('#termandconditionLinkRegistraionItemId').setValue(data.termWiseRegistrationContract.termAndConditionLink);
									registrationsetupdetailstabpanel.down('#check1TextField').setValue(data.termWiseRegistrationContract.termAndConditionOne);
									registrationsetupdetailstabpanel.down('#check2TextField').setValue(data.termWiseRegistrationContract.termAndConditionTwo);
									registrationsetupdetailstabpanel.down('#check3TextField').setValue(data.termWiseRegistrationContract.termAndConditionThree);
									if(data.termWiseRegistrationContract.document){
										registrationsetupdetailstabpanel.down('#RegContractUploadedDocumentItemId').setValue(data.termWiseRegistrationContract.document.id);
										registrationsetupdetailstabpanel.down('#encryptedRegContractDocId').setValue(data.termWiseRegistrationContract.document.encryptedDocId);
										registrationsetupdetailstabpanel.down('#staticUploadFileFieldRegContract').setRawValue(data.termWiseRegistrationContract.document.path);
										registrationsetupdetailstabpanel.down('#availableRegContractDocumentLabelItemId').setVisible(true);
									}
									
									if(data.termWiseRegistrationContract.whetherRegistrationContractApplicable){
										registrationsetupdetailstabpanel.down('#registraionContractApplicable').setValue(true);
									}
									else{
										registrationsetupdetailstabpanel.down('#registraionContractApplicable').setValue(false);
										var regContractFieldContainer1 = registrationsetupdetailstabpanel.down('#regContractFieldContainer1');
										var regContractFieldContainer2 = registrationsetupdetailstabpanel.down('#regContractFieldContainer2');
										var regContractFieldContainer4 = registrationsetupdetailstabpanel.down('#regContractFieldContainer4');
										regContractFieldContainer1.setVisible(false);
										regContractFieldContainer2.setVisible(false);
										regContractFieldContainer4.setVisible(false);
									}
									registrationsetupdetailstabpanel.config.registrationContractMsgContent = data.termWiseRegistrationContract.registrationContractMsgContent;
								}
								
								if(data.registrationGuidelines  && data.registrationGuidelines.id){
									var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
									additionalSetupItemId.setDisabled(false);
									additionalSetupItemId.config.registrationGuidelineRecord = data.registrationGuidelines;
								}
								else{
									var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
									additionalSetupItemId.setDisabled(false);
									additionalSetupItemId.config.registrationGuidelineRecord = {}
								}
								
								var registrationDocumentItemId = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
								registrationDocumentItemId.setDisabled(false);
								
								var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
								additionalSetupItemId.setDisabled(false);
							}
						}
					});
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			
			viewRegistrationSetupRecord:function(grid, flag){
				var $this = this;
				if(grid.getSelectionModel().getCount()>0) {
					$this.addRegistrationSetupScreen('view');
					
					var structure = this.getRegistrationsetupdetails();
					var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

					var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
					var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
					var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
					var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
					//var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");
					
					progresstracker1.hide();
					progresstracker2.hide();
					progresstracker3.hide();
					progresstracker4.hide();
					//progresstracker5.hide();
					var record = grid.getSelectionModel().getSelection()[0];
					var registrationSetupTermId=null;
					if(flag=="period"){
						registrationSetupTermId=record.data.registrationTermSetupDetailId;
						if(isNullOrEmpty(registrationSetupTermId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.PATH_FIND_REGISTRATION_SETUP_DETAIL_BY_PERIOD,
								method: 'GET',
								params:{
									periodId:record.data.id,
								},
								success: function(f, action) {
									if (!isNullOrEmpty(f.responseText)) {
										var responseTextData = f.responseText;
										var jsonData=Ext.JSON.decode(responseTextData);
										registrationSetupTermId=jsonData.registrationTermSetupDetailId;
										$this.viewRegistrationDetailsOfSetup(registrationSetupTermId);
									}
								}
							});
						}else{
							$this.viewRegistrationDetailsOfSetup(registrationSetupTermId);
						}
					}
					else{
						registrationSetupTermId=record.data.registrationSetupId;
						$this.viewRegistrationDetailsOfSetup(registrationSetupTermId);
					}
					
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			viewRegistrationDetailsOfSetup:function(registrationSetupTermId){
				var $this = this;
				var form=$this.getRegistrationsetupdetails();
				var getForm=form.getForm();


				var registrationsetupdetails = $this.getRegistrationsetupdetails();
				var registrationsetupdetailstabpanel = $this.getRegistrationsetupdetailstabpanel();
				var courseregistrationeditablegrid = $this.getCourseregistrationeditablegrid();

				var profileUpdateItemId = registrationsetupdetailstabpanel.down('#profileUpdateItemId');
				var registrationDocumentItemId = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
				registrationsetupdetails.config.isAddForm = false;
				registrationDocumentItemId.config.registrationDocumentRecord = null;
				profileUpdateItemId.config.profileUpdateRecord = null;
				var submitUrl = SERVERURL.PATH_FINDBYID_REGISTRATION_TERM_SETUP_DETAIL;
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl+"?id="+registrationSetupTermId,
					method : 'GET',
					success : function(resp, action) {
						Ext.getBody().unmask();
						var data = Ext.decode(resp.responseText);
						if(!isNullOrEmpty(data)){
							registrationsetupdetails.registrationRules = data.termWiseRegistrationRules;
							registrationsetupdetails.registrationValidations = data.termWiseRegistrationValidations;
							
							var academicTerm = registrationsetupdetails.down('#academicTerm');
							var registrationSetupNameId = registrationsetupdetails.down('#registrationSetupNameId');
							var registrationSetupId = registrationsetupdetails.down('#registrationSetupId');
							var whetherAutoApproved = registrationsetupdetails.down('#whetherAutoApproved');
							registrationSetupId.setValue(data.id);
							whetherAutoApproved.setValue(data.whetherAutoApproved);

							academicTerm.getStore().load({
								callback:function(record) {
									academicTerm.setValue(data.academicTerm.id);
								}
							});

							var RegistrationTermGridComboStore = Ext.getStore('registrationsetup.RegistrationTermGridComboStore');
							RegistrationTermGridComboStore.load();
							registrationSetupNameId.setValue(data.registrationSetupName);

							/*hidPeriodRegistrationId.setValue(data.termwisePeriodRegistrations[0].id);

							var periodStartDateId = registrationsetupdetailstabpanel.down('#periodStartDateId');
							periodStartDateId.setValue(dateRender(data.termwisePeriodRegistrations[0].periodStartDate));
							var periodEndDateId = registrationsetupdetailstabpanel.down('#periodEndDateId');
							periodEndDateId.setValue(dateRender(data.termwisePeriodRegistrations[0].periodEndDate));
							var whetherAutoApproved = registrationsetupdetailstabpanel.down('#whetherAutoApproved');
							whetherAutoApproved.setValue(data.termwisePeriodRegistrations[0].whetherAutoApproved);
							var studentPeriodStartDateId = registrationsetupdetailstabpanel.down('#studentPeriodStartDateId');
							studentPeriodStartDateId.setValue(dateRender(data.termwisePeriodRegistrations[0].studentPeriodStartDate));
							var studentPeriodEndDateId = registrationsetupdetailstabpanel.down('#studentPeriodEndDateId');
							studentPeriodEndDateId.setValue(dateRender(data.termwisePeriodRegistrations[0].studentPeriodEndDate));*/

							if(data.termwiseCourseRegistrations.length>0){
								var courseRegistrationItemId = registrationsetupdetailstabpanel.down('#courseRegistrationItemId');
								courseRegistrationItemId.setDisabled(false);
								var serialNo = 0;
								var ObjModel = [];
								courseregistrationeditablegrid.getStore().removeAll();
								data.termwiseCourseRegistrations.forEach(function(obj){

									serialNo = serialNo + 1;
									var courseRegistrationGridModel = new Academia.model.registrationsetup.CourseRegistrationGridModel();
									courseRegistrationGridModel.set("serialNo", serialNo);
									courseRegistrationGridModel.set("id", obj.id);
									courseRegistrationGridModel.set("registrationTerm", obj.registrationTerm.id);
									if(!isNullOrEmpty(obj.adminStartDateTime)){
										courseRegistrationGridModel.set("adminStartDate",  new Date(obj.adminStartDateTime));
									}

									courseRegistrationGridModel.set("adminStartTime", moment(obj.stringAdminStartTime, 'HH:mm A')._d);

									if(!isNullOrEmpty(obj.adminEndDateTime)){
										courseRegistrationGridModel.set("adminEndDate",new Date(obj.adminEndDateTime));
									}

									courseRegistrationGridModel.set("adminEndTime", moment(obj.stringAdminEndTime, 'HH:mm A')._d);

									if(!isNullOrEmpty(obj.studentStartDateTime)){
										courseRegistrationGridModel.set("studentStartDate",new Date(obj.studentStartDateTime));
									}
									courseRegistrationGridModel.set("studentStartTime", moment(obj.stringStudentStartTime, 'HH:mm A')._d);

									if(!isNullOrEmpty(obj.studentEndDateTime)){
										courseRegistrationGridModel.set("studentEndDate",new Date(obj.studentEndDateTime));
									}
									courseRegistrationGridModel.set("studentEndTime", moment(obj.stringStudentEndTime, 'HH:mm A')._d);
									courseRegistrationGridModel.set("whetherAllowAdd", obj.whetherAllowAdd);
									courseRegistrationGridModel.set("whetherAllowDrop", obj.whetherAllowDrop);
									courseRegistrationGridModel.set("whetherAllowLateFee", obj.whetherAllowLateFee);
									courseRegistrationGridModel.set("isAddDeleteRow", true);
									courseRegistrationGridModel.commit();
									ObjModel.push(courseRegistrationGridModel);
								});

								courseregistrationeditablegrid.getStore().loadRawData(ObjModel, true);

								courseregistrationeditablegrid.config.isView=true;

								if (registrationsetupdetailstabpanel) {
									/*registrationsetupdetailstabpanel.down('#periodRegistrationNextBtnId').hide();
									registrationsetupdetailstabpanel.down('#resetPeriodRegistrationBtn').hide();*/
									registrationsetupdetailstabpanel.down('#courseRegistrationNextBtnId').hide();
									registrationsetupdetailstabpanel.down('#submitCourseRegistrationBtn').hide();
									registrationsetupdetailstabpanel.down('#resetCourseRegistrationBtn').hide();

									registrationsetupdetailstabpanel.down('#profileUpdateNextBtnId').hide();
									registrationsetupdetailstabpanel.down('#submitProfileUpdateBtn').hide();
									registrationsetupdetailstabpanel.down('#resetProfileUpdateBtn').hide();

									registrationsetupdetailstabpanel.down('#submitRegistrationDocumentBtn').hide();
									registrationsetupdetailstabpanel.down('#registrationDocumentNextBtnId').hide();
									registrationsetupdetailstabpanel.down('#resetRegistrationDocumentBtn').hide();

									registrationsetupdetailstabpanel.down('#submitAdditionalSetupBtn').hide();
									registrationsetupdetailstabpanel.down('#resetAdditionalSetupBtn').hide();
									registrationsetupdetailstabpanel.down('#preRegistraionAdditionalSetupNextBtnId').hide();
									
									registrationsetupdetailstabpanel.down('#submitRegistrationContractAdditionalSetupBtn').hide();
									registrationsetupdetailstabpanel.down('#resetRegistrationContractAdditionalSetupBtn').hide();

									//registrationsetupdetailstabpanel.down('#submitRegistrationValidationsAdditionalSetupBtn').hide();
									//registrationsetupdetailstabpanel.down('#resetRegistrationValidationsAdditionalSetupBtn').hide();
									
									var registrationsetupdetailsGrid = registrationsetupdetailstabpanel.down('#courseregistrationeditablegridItemId');
									registrationsetupdetailsGrid.setDisabled(true);

									var registrationsetupprofileupdategridItemId = registrationsetupdetailstabpanel.down('#registrationsetupprofileupdategridItemId');
									registrationsetupprofileupdategridItemId.setDisabled(true);

									var registrationsetupdocumentgridItemId = registrationsetupdetailstabpanel.down('#registrationsetupdocumentgridItemId');
									registrationsetupdocumentgridItemId.setDisabled(true);

									var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
									additionalSetupItemId.setDisabled(false);


									toggleReadOnlyFormItems(getForm, true);
									form.doLayout();
								}
							}
							if(data.termWiseProfileUpdates.length>0){
								var profileUpdateItemId = registrationsetupdetailstabpanel.down('#profileUpdateItemId');
								profileUpdateItemId.setDisabled(false);
								profileUpdateItemId.config.profileUpdateRecord = data.termWiseProfileUpdates[0];
								var hidProfileUpdateId = registrationsetupdetailstabpanel.down('#hidProfileUpdateId');
								hidProfileUpdateId.setValue(data.termWiseProfileUpdates[0].id);

								var registrationsetupprofileupdategrid = $this.getRegistrationsetupprofileupdategrid();

								var termWiseProfileLinks = data.termWiseProfileUpdates[0].termWiseProfileLinks;
								if(termWiseProfileLinks.length>0){
									var ObjModel = [];
									registrationsetupprofileupdategrid.getStore().removeAll();
									termWiseProfileLinks.forEach(function(obj){
										var registrationSetupProfileUpdateGridModel = new Academia.model.registrationsetup.RegistrationSetupProfileUpdateGridModel();
										registrationSetupProfileUpdateGridModel.set("id", obj.id);
										registrationSetupProfileUpdateGridModel.set("linkName", obj.linkName);
										registrationSetupProfileUpdateGridModel.set("sequenceNo", obj.sequenceNo);
										registrationSetupProfileUpdateGridModel.set("isSelected", obj.isSelected);
										registrationSetupProfileUpdateGridModel.commit();
										ObjModel.push(registrationSetupProfileUpdateGridModel);
									});
									registrationsetupprofileupdategrid.getStore().loadRawData(ObjModel, true);
								}


							}else{
								var registrationsetupprofileupdategrid = $this.getRegistrationsetupprofileupdategrid();
								Ext.Ajax.request({
									method : "GET",
									type : 'rest',
									url : SERVERURL.PATH_GET_PROFILE_LINK_GRID_DATA,
									success : function(form,action) {
										if(!isNullOrEmpty(form.responseText)){
											var data = Ext.JSON.decode(form.responseText);
											if(data.length>0){
												var ObjModel = [];
												registrationsetupprofileupdategrid.getStore().removeAll();
												data.forEach(function(obj){
													var registrationSetupProfileUpdateGridModel = new Academia.model.registrationsetup.RegistrationSetupProfileUpdateGridModel();
													registrationSetupProfileUpdateGridModel.set("id", obj.id);
													registrationSetupProfileUpdateGridModel.set("linkName", obj.value);
													registrationSetupProfileUpdateGridModel.set("sequenceNo", obj.sequence);
													registrationSetupProfileUpdateGridModel.commit();
													ObjModel.push(registrationSetupProfileUpdateGridModel);
												});
												registrationsetupprofileupdategrid.getStore().loadRawData(ObjModel, true);
											}
										}
									}
								});
							}

							if(data.termWiseRegistrationDocumentSetups.length>0){
								var registrationDocumentItemId = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
								registrationDocumentItemId.setDisabled(false);

								registrationDocumentItemId.config.registrationDocumentRecord = data.termWiseRegistrationDocumentSetups[0];

								var hidregistrationDocumentId = registrationsetupdetailstabpanel.down('#hidregistrationDocumentId');
								hidregistrationDocumentId.setValue(data.termWiseRegistrationDocumentSetups[0].id);

								var registrationDocumentApplicableId = registrationsetupdetailstabpanel.down('#registrationDocumentApplicableId');
								registrationDocumentApplicableId.setValue(data.termWiseRegistrationDocumentSetups[0].isDocumentApplicable);

								var registrationsetupdocumentgrid = registrationsetupdetailstabpanel.down('#registrationsetupdocumentgridItemId') //$this.getRegistrationsetupdocumentgrid();

							}
							if(data.termWiseAdditionalSetup && data.termWiseAdditionalSetup.id){
								var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
								additionalSetupItemId.setDisabled(false);

								registrationsetupdetailstabpanel.down('#hideAdditionalSetupItemId').setValue(data.termWiseAdditionalSetup.id);
								if(data.termWiseAdditionalSetup.document){
									registrationsetupdetailstabpanel.down('#AdditionalUploadedDocumentItemId').setValue(data.termWiseAdditionalSetup.document.id);
									registrationsetupdetailstabpanel.down('#encryptedDocId').setValue(data.termWiseAdditionalSetup.document.encryptedDocId);
									registrationsetupdetailstabpanel.down('#staticUploadFileField').setRawValue(data.termWiseAdditionalSetup.document.path);
									registrationsetupdetailstabpanel.down('#availableDocumentLabelItemId').setVisible(true);

								}
								registrationsetupdetailstabpanel.down('#termandconditionLinkItemId').setValue(data.termWiseAdditionalSetup.termAndConditionLink);
								if(data.termWiseAdditionalSetup.whetherAdditionalSetupApplicable){
									registrationsetupdetailstabpanel.down('#preRegistrationTermConditionApplicable').setValue(true);
								}
								else{
									registrationsetupdetailstabpanel.down('#preRegistrationTermConditionApplicable').setValue(false);
									var preRegFieldContainer1 = registrationsetupdetailstabpanel.down('#preRegFieldContainer1');
									var preRegFieldContainer2 = registrationsetupdetailstabpanel.down('#preRegFieldContainer2');
									var preRegFieldContainer3 = registrationsetupdetailstabpanel.down('#preRegFieldContainer3');
									var preRegFieldContainer4 = registrationsetupdetailstabpanel.down('#preRegFieldContainer4');
									preRegFieldContainer1.setVisible(false);
									preRegFieldContainer2.setVisible(false);
									preRegFieldContainer3.setVisible(false);
									preRegFieldContainer4.setVisible(false);
								}
								registrationsetupdetailstabpanel.config.additionalSetupMsgString = data.termWiseAdditionalSetup.msgContent;
								registrationsetupdetailstabpanel.down('#additionalSetupMode').setValue('view_mode');
								//registrationsetupdetailstabpanel.config.Mode = "edit_mode";
								
							}

							if(data.termWiseRegistrationContract && data.termWiseRegistrationContract.id){
								var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
								additionalSetupItemId.setDisabled(false);
								additionalSetupItemId.config.registrationContractRecord = data.termWiseRegistrationContract;

								registrationsetupdetailstabpanel.down('#hideRegContractAdditionalSetupItemId').setValue(data.termWiseRegistrationContract.id);
								registrationsetupdetailstabpanel.down('#termandconditionLinkRegistraionItemId').setValue(data.termWiseRegistrationContract.termAndConditionLink);
								registrationsetupdetailstabpanel.down('#check1TextField').setValue(data.termWiseRegistrationContract.termAndConditionOne);
								registrationsetupdetailstabpanel.down('#check2TextField').setValue(data.termWiseRegistrationContract.termAndConditionTwo);
								registrationsetupdetailstabpanel.down('#check3TextField').setValue(data.termWiseRegistrationContract.termAndConditionThree);
								if(data.termWiseRegistrationContract.document){
									registrationsetupdetailstabpanel.down('#RegContractUploadedDocumentItemId').setValue(data.termWiseRegistrationContract.document.id);
									registrationsetupdetailstabpanel.down('#encryptedRegContractDocId').setValue(data.termWiseRegistrationContract.document.encryptedDocId);
									registrationsetupdetailstabpanel.down('#staticUploadFileFieldRegContract').setRawValue(data.termWiseRegistrationContract.document.path);
									registrationsetupdetailstabpanel.down('#availableRegContractDocumentLabelItemId').setVisible(true);

								}
								if(data.termWiseRegistrationContract.whetherRegistrationContractApplicable){
									registrationsetupdetailstabpanel.down('#registraionContractApplicable').setValue(true);
								}
								else{
									registrationsetupdetailstabpanel.down('#registraionContractApplicable').setValue(false);
									var regContractFieldContainer1 = registrationsetupdetailstabpanel.down('#regContractFieldContainer1');
									var regContractFieldContainer2 = registrationsetupdetailstabpanel.down('#regContractFieldContainer2');
									var regContractFieldContainer4 = registrationsetupdetailstabpanel.down('#regContractFieldContainer4');
									regContractFieldContainer1.setVisible(false);
									regContractFieldContainer2.setVisible(false);
									regContractFieldContainer4.setVisible(false);
								}
								registrationsetupdetailstabpanel.config.registrationContractMsgContent = data.termWiseRegistrationContract.registrationContractMsgContent;
								registrationsetupdetailstabpanel.down('#regContractSetupMode').setValue('view_mode');
								//registrationsetupdetailstabpanel.config.Mode = "edit_mode";
							}
							
							if(data.registrationGuidelines  && data.registrationGuidelines.id){
								var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
								additionalSetupItemId.setDisabled(false);
								additionalSetupItemId.config.registrationGuidelineRecord = data.registrationGuidelines;
							}
							else{
								var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
								additionalSetupItemId.setDisabled(false);
								additionalSetupItemId.config.registrationGuidelineRecord = {}
							}
							
							var profileUpdateItemId = registrationsetupdetailstabpanel.down('#profileUpdateItemId');
							profileUpdateItemId.setDisabled(false);

							var registrationDocumentItemId = registrationsetupdetailstabpanel.down('#registrationDocumentItemId');
							registrationDocumentItemId.setDisabled(false);

							var additionalSetupItemId = registrationsetupdetailstabpanel.down('#additionalSetupItemId');
							additionalSetupItemId.setDisabled(false);
						}
					}
				});
			},
			deleteRegistrationSetupRecord:function(){
				var $this=this;
				var grid = $this.getRegistrationsetupgrid();
				if (grid.getSelectionModel().getCount() > 0) {
					var records = grid.getSelectionModel().getSelection();
					showConfirmMessage(getCommonTranslation('REGISTRATION_SETUP_DETAILS'),getCommonTranslation('DELETE_CONFIRM_REGISTRATION_SETUP_MESSAGE'),function(btn,text){
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								var id = records[0].get("registrationSetupId");
								Ext.Ajax.request({
									method : "DELETE",
									type : 'rest',
									url : SERVERURL.PATH_DELETE_REGISTRATION_TERM_SETUP_DETAIL+'?id='+ id,
									headers : {
										'Content-Type' : 'application/json'
									},
									success : function(form,action) {
										Ext.getBody().unmask();
										if(!isNullOrEmpty(form.responseText) && form.responseText == "DEPENDENCY_EXISTS"){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MAPPED_REGISTRATION_SETUP_MESSAGE'));
										}
										else{
											showSuccessMessage(getCommonTranslation('REGISTRATION_SETUP_DETAILS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
											$this.loadRegistrationSetupGrid();
										}
									}
								});
							}
						});
					
				}else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			setProgressTracker : function(progresstracker){
				var structure = this.getRegistrationsetupdetails();
				var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

				var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
				var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
				var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
				var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
				//var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");
				
				if(progresstracker==0){
					for(var i = 0; i < 11; i ++ ){
						progresstracker1.updateProgress((i * 0.1), '');
					}
					progresstracker1.textEl.addCls("custom-progress-text");
					progresstracker1.textEl.removeCls("inProgressCss-progress-text");
					progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker1.textEl.addCls("inProgressCss-progress-text");
					progresstracker1.updateText("Step 1 In Progress");
					
				}
				if(progresstracker==1){
					for(var i = 0; i < 11; i ++ ){
						progresstracker1.updateProgress((i * 0.1), '');
					}
					progresstracker1.textEl.addCls("custom-progress-text");
					progresstracker1.textEl.removeCls("inProgressCss-progress-text");
					progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker2.textEl.addCls("inProgressCss-progress-text");
					progresstracker2.updateText("Step 2 In Progress");
					progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
				}
				if(progresstracker==2){
					for(var i = 0; i < 11; i ++ ){
						progresstracker2.updateProgress((i * 0.1), '');
					}
					progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker3.textEl.addCls("inProgressCss-progress-text");
					progresstracker3.updateText("Step 3 In Progress");
					progresstracker2.textEl.removeCls("inProgressCss-progress-text");
					progresstracker2.textEl.addCls("custom-progress-text");
					progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
				}
				if(progresstracker==3){
					for(var i = 0; i < 11; i ++ ){
						progresstracker3.updateProgress((i * 0.1), '');
					}
					progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
					progresstracker4.textEl.addCls("inProgressCss-progress-text");
					progresstracker4.updateText("Step 4 In Progress");
					progresstracker3.textEl.removeCls("inProgressCss-progress-text");
					progresstracker3.textEl.addCls("custom-progress-text");
					progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
				}
				if(progresstracker==4){
					for(var i = 0; i < 11; i ++ ){
						progresstracker4.updateProgress((i * 0.1), '');
					}
					progresstracker4.textEl.removeCls("inProgressCss-progress-text");
					progresstracker4.textEl.addCls("custom-progress-text");
					progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
				}
			},
			resetProgressTracker : function(){
				var structure = this.getRegistrationsetupdetails();
				var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
				var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
				var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
				var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
				var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
				progresstracker1.reset();
				progresstracker1.updateText('');
				progresstracker2.reset();
				progresstracker2.updateText('');
				progresstracker3.reset();
				progresstracker3.updateText('');
				progresstracker4.reset();
				progresstracker4.updateText('');
			},

			formatAMPM: function(date) {
			  var hours = date.getHours();
			  var minutes = date.getMinutes();
			  var ampm = hours >= 12 ? 'PM' : 'AM';
			  hours = hours % 12;
			  hours = hours ? hours : 12; // the hour '0' should be '12'
			  minutes = minutes < 10 ? '0'+minutes : minutes;
			  var strTime = hours + ':' + minutes + ' ' + ampm;
			  return strTime;
			},
            CombineDateAndTime: function(date, time) {
            	if(!isNullOrEmpty(date) && !isNullOrEmpty(time)){
            		var currentHours = ("0" + time.getHours()).slice(-2);
                	var currentMinutes = ("0" + time.getMinutes()).slice(-2);
                    var timeString = currentHours + ':' + currentMinutes + ':00';
                    var ampm = time.getHours() >= 12 ? 'PM' : 'AM';
                    var year = date.getFullYear();
                    var month = ("0" + (date.getMonth() + 1)).slice(-2); // Jan is 0, dec is 11
                    var day = ("0" + date.getDate()).slice(-2);
                    var dateString = '' + year + '-' + month + '-' + day;
                    dateString = Ext.Date.format(new Date(dateString),'Y-m-d');
                    var datec = dateString + 'T' + timeString;
                    var combined = new Date(datec);
                    return combined;
            	}
            },
            viewMappedProgramPeriodDetail : function(record, grid){
            	var $this = this;
            	var form = $this.getRegistrationsetupfilter();
				var formValue = form.getValues();
            	
				var alids=[];
				var academyLocationId = formValue.multiselectAcademyLocation;
				var academyLocationIds = null;

				if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
					for (var i in academyLocationId) {
						if (Ext.isObject(academyLocationId[0])) {
							alids.push(academyLocationId[i].get("id"));
						} else {
							alids.push(academyLocationId[i]);
						}
					}
					academyLocationIds = alids.join();
				}
				else if(!isNullOrEmpty(academyLocationId)){
					academyLocationIds = academyLocationId;
				}
				
         		var window =  this.getRegistrationsetupmappedprogramperioddetailsgrid();
         		if (!window) {
         			Ext.widget('registrationsetupmappedprogramperioddetailsgrid');
         			window = this.getRegistrationsetupmappedprogramperioddetailsgrid();
         		}
         		window.show();
         		var grid = window.down('grid');
         		if(!isNullOrEmpty(record)){
         			var store = grid.getStore();
         			store.getProxy().extraParams = {
         				academyLocationIds:academyLocationIds,
    		    		academicTerm:formValue.academicTerm,
         				registrationSetupId: record.data.registrationSetupId,
         				registrationTermId:formValue.registrationTerm,
         				programId:formValue.programId,
         				batchId:formValue.batchId,
         				periodId:formValue.periodId
         			};
         			this.resetPageSetting(store);
         			store.load({
         				callback: function(){
         	         		window.center();
         				}
         			});
         		}
         	},
        	getDocumentController : function() {
		    	var this$ = this;
		    	return this$.getController('Academia.controller.document.DocumentController');
            },
            openRegistrationSetupCopyWindow:function(obj){
         		var $this = this;
         		var grid = $this.getRegistrationsetupgrid();
	    	  if (grid.getSelectionModel().getCount() == 1 ) {
	    		  var record = grid.getSelectionModel().getSelection();
	    		  var formWindow = $this.getRegistrationsetupcopywindow();
	    		  if (!formWindow) {
	    			  Ext.widget('registrationsetupcopywindow');
	    			  formWindow = $this.getRegistrationsetupcopywindow();
	    			  formWindow.down('#id').setValue(record[0].data.registrationSetupId);
	    		  }
	    		  formWindow.show();
	    		  //this.getSessionDetails(record);
	    	  } else if (grid.getSelectionModel().getCount() > 1) {
	    		  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); //Please select a record.
	    	  } else{
	    		  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
	    	  }

	      },
	      disableProfileUpdateBtns: function(panelReference,permissionsMap) {
	    	  var associatedAcadLocationIds = new Array();
	    	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	    	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	  var configureAddressBtn = panelReference.down('#configureAddressBtn');
	    	  var configureParentDetailsBtn = panelReference.down('#configureParentDetailsBtn');
	    	  configureAddressBtn.setVisible(false);
	    	  configureParentDetailsBtn.setVisible(false);
	    	  Ext.each(permissionList, function(privilege) {
	    		  if (privilege === 'CONFIGURE_ADDRESS') {
	    			  if(!isNullOrEmpty(configureAddressBtn)){
	    				  configureAddressBtn.setVisible(true);
	    			  }        		
	    		  }
	    		  if (privilege === 'CONFIGURE_PARENT_DETAILS') {
	    			  if(!isNullOrEmpty(configureParentDetailsBtn)){
	    				  configureParentDetailsBtn.setVisible(true);
	    			  }        		
	    		  }
	    	  });
	      },
	      
	      /*To Save Late Fee Form Data Temporary on UI*/
	      getSubmitLateFeeFormData:function(){
	    		var form = this.getLatefeeconfigform();
	    		var grid = this.getCourseregistrationeditablegrid();
	    		var regSetupPanel = this.getRegistrationsetupdetailstabpanel();
				var formData =  form.getForm().getValues();
				var configureLinkRowIndex = grid.config.rowIndex;
				var feePlanType={
					"id":2	
				};
				var feePlan={
					"id":formData.feePlanName,
				};
				var feeStageMaster={
						"id":6
				}
				var feePlanRule={
					"id":formData.feePlanRule	
				};
				var termwiseCourseRegistration={
					"id": parseInt(formData.termwiseCourseRegistration)
				};
				var json;
				var id = form.down('#recordId').getValue();
				if(formData.status=='Active'){
					formData.status=true;
				}
				if(isNullOrEmpty(id)){
					json={
							"feePlanType":feePlanType,
							"feePlan":feePlan,
							"feeStageMaster":feeStageMaster,
							"feePlanRule":feePlanRule,
							"amount": formData.amountToBePaid,
							"whetherActive":formData.status,
						};
				}else{
					json={
							"id":parseInt(id),
							"feePlanType":feePlanType,
							"feePlan":feePlan,
							"feeStageMaster":feeStageMaster,
							"feePlanRule":feePlanRule,
							"amount": formData.amountToBePaid,
							"whetherActive":formData.status,
							"termwiseCourseRegistration":termwiseCourseRegistration
						};
				}
				/*code start to store data temporary on grid store for late fee config form*/
				
				if(!isNullOrEmpty(lateFeeArrayOfMultipleReg[configureLinkRowIndex])){
					lateFeeArrayOfMultipleReg[configureLinkRowIndex]=json;
				}else{
					lateFeeArrayOfMultipleReg.splice(configureLinkRowIndex, 0, json);
				}
				
				var storeItems = grid.getStore().data.items;
        		if(storeItems.length>0){
        			Ext.each(storeItems, function(obj,indx) {
        				if(indx==configureLinkRowIndex){
        				 var arry=[];
        				 arry.push(lateFeeArrayOfMultipleReg[configureLinkRowIndex]);
        				 obj.data.lateFeeConfigurationSetUp=arry;
        				}
        			});
        			Ext.each(storeItems, function(obj,indx) {
        				if(indx==configureLinkRowIndex){
        					if(!isNullOrEmpty(lateFeeArrayOfMultipleReg[indx].whetherActive)){
        						obj.set('whetherAllowLateFee',lateFeeArrayOfMultipleReg[indx].whetherActive);
        					}
        				}
        			});
        		}
        		regSetupPanel.remove(1);
	      },
	      
	      updateValidationsValues: function(){
	    	  var me = this;

	    	  var registrationsetupdetails = this.getRegistrationsetupdetails();
	    	  var registrationValidations = registrationsetupdetails.registrationValidations;

	    	  var mandatoryChecksBypass = registrationsetupdetails.down('#mandatoryChecksBypass');
	    	  var minCoursesCourseGroupChecksBypass = registrationsetupdetails.down('#minCoursesCourseGroupChecksBypass');
	    	  var yearlyMinCreditChecksBypass = registrationsetupdetails.down('#yearlyMinCreditChecksBypass');
	    	  var minCreditChecksForCourseGroupBypass = registrationsetupdetails.down('#minCreditChecksForCourseGroupBypass');
	    	  var minCourseGroupChecksBypass = registrationsetupdetails.down('#minCourseGroupChecksBypass');
	    	  var moduleGroupChecksBypass = registrationsetupdetails.down('#moduleGroupChecksBypass');
	    	  
	    	  if(mandatoryChecksBypass && minCoursesCourseGroupChecksBypass && yearlyMinCreditChecksBypass && minCreditChecksForCourseGroupBypass && minCourseGroupChecksBypass){
	    		  var index = -1; // Default value if not found
	    		  for (var i = 0; i < registrationValidations.length; i++) {
	    		      if (registrationValidations[i].registrationValidation === "mandatoryChecksBypass") {
	    		          index = i;
	    		          break;
	    		      }
	    		  }
	    		  if(index != -1){
		    		  registrationValidations[index].whetherMandatory = mandatoryChecksBypass.getValue();
	    		  }
	    		  else{
	    			  registrationsetupdetails.registrationValidations.push({
	    				  "id": "",
	    				  "whetherMandatory": false,
	    				  "registrationValidation": "mandatoryChecksBypass"
	    			  });
	    		  }
	    		  
	    		  var index = -1; // Default value if not found
	    		  for (var i = 0; i < registrationValidations.length; i++) {
	    		      if (registrationValidations[i].registrationValidation === "minCoursesCourseGroupChecksBypass") {
	    		          index = i;
	    		          break;
	    		      }
	    		  }
	    		  if(index != -1){
	    			  registrationValidations[index].whetherMandatory = minCoursesCourseGroupChecksBypass.getValue();
	    		  }
	    		  else{
	    			  registrationsetupdetails.registrationValidations.push({
	    				  "id": "",
	    				  "whetherMandatory": false,
	    				  "registrationValidation": "minCoursesCourseGroupChecksBypass"
	    			  });
	    		  }
	    		  
	    		  var index = -1; // Default value if not found
	    		  for (var i = 0; i < registrationValidations.length; i++) {
	    		      if (registrationValidations[i].registrationValidation === "yearlyMinCreditChecksBypass") {
	    		          index = i;
	    		          break;
	    		      }
	    		  }
	    		  if(index != -1){
	    			  registrationValidations[index].whetherMandatory = yearlyMinCreditChecksBypass.getValue();
	    		  }
	    		  else{
	    			  registrationsetupdetails.registrationValidations.push({
	    				  "id": "",
	    				  "whetherMandatory": false,
	    				  "registrationValidation": "yearlyMinCreditChecksBypass"
	    			  });
	    		  }
	    		  
	    		  var index = -1; // Default value if not found
	    		  for (var i = 0; i < registrationValidations.length; i++) {
	    		      if (registrationValidations[i].registrationValidation === "minCreditChecksForCourseGroupBypass") {
	    		          index = i;
	    		          break;
	    		      }
	    		  }
	    		  if(index != -1){
	    			  registrationValidations[index].whetherMandatory = minCreditChecksForCourseGroupBypass.getValue();
	    		  }
	    		  else{
	    			  registrationsetupdetails.registrationValidations.push({
	    				  "id": "",
	    				  "whetherMandatory": false,
	    				  "registrationValidation": "minCreditChecksForCourseGroupBypass"
	    			  });
	    		  }
	    		  
	    		  var index = -1; // Default value if not found
	    		  for (var i = 0; i < registrationValidations.length; i++) {
	    		      if (registrationValidations[i].registrationValidation === "minCourseGroupChecksBypass") {
	    		          index = i;
	    		          break;
	    		      }
	    		  }
	    		  if(index != -1){
	    			  registrationValidations[index].whetherMandatory = minCourseGroupChecksBypass.getValue();
	    		  }
	    		  else{
	    			  registrationsetupdetails.registrationValidations.push({
	    				  "id": "",
	    				  "whetherMandatory": false,
	    				  "registrationValidation": "minCourseGroupChecksBypass"
	    			  });
	    		  }
	    	  }
	    	  
	    	  index = -1;
	          for (var i = 0; i < registrationValidations.length; i++) {
	              if (registrationValidations[i].registrationValidation === "moduleGroupChecksBypass") {
	                  index = i; break;
	              }
	          }
	          if (index != -1) {
	              registrationValidations[index].whetherMandatory = moduleGroupChecksBypass.getValue();
	          } else {
	              registrationsetupdetails.registrationValidations.push({
	                  "id": "",
	                  "whetherMandatory": false,
	                  "registrationValidation": "moduleGroupChecksBypass"
	              });
	          }
	    	  registrationsetupdetails.registrationValidations = registrationValidations;
	      }
});

