/**
 * This controller is used for admission report controller
 * @author Pravin.Surve
 */
Ext.define('Academia.controller.reports.admission.AdmissionReportController', {
    extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    stores: ['common.AcademyStore', 'common.AcademyStore', 'common.ProgramsByAcademyIdLocationId',
             'common.BatchesByProgramId', 'Academia.store.common.SeatTypesByBatchId',
             'admission.selectionProcess.QuotaTypes', 'admission.quotas.QuotaLists',
             'admission.selectionStage.SelectionStageFromSeatType','admission.selectionStage.StageStatistics',
             'admission.admissionCycle.QuotaTypePickList','reports.admission.QuotaViolationGridStore',
             'reports.admission.AdmissionDemographicsAcademyStore','admission.admissionCommon.SeatTypesByBatchIdsStore',
             'reports.admission.AdmissionDemographicsStore','reports.admission.AdmissionDemographicsLocationStore',
             'reports.admission.AdmissionDemographicsAcadLocStore','Academia.store.common.CountryStore',
             'Academia.store.common.ReligionStore','admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
             'admission.applications.applicantProfileBase.DeleteApplicationsCodeNameStore',
             'admission.applications.applicantProfileBase.DeleteApplicationsGridStore','admission.admissionActivityReport.AdmissionActivityReportListStore',
             'admission.admissionActivityReport.UserWiseActivityReportStore','admission.admissionActivityReport.EnquiryCountGroupBySourceTypeGridStore',
             'admission.admissionActivityReport.AdmissionEnrolAcademyFullSummaryAdmGridStore','admission.admissionActivityReport.AdmissionEnrolALFullSummaryAdmGridStore',
             'admission.admissionActivityReport.AdmissionEnrolALOverviewAdmGridStore','admission.admissionActivityReport.AdmissionEnrolALByDayAdmGridStore',
             'admission.admissionActivityReport.AdmissionEnrolAcademyByDayAdmGridStore','admission.admissionActivityReport.AdmissionEnrolAcademyOverviewAdmGridStore',
             'admission.admissionActivityReport.AdmissionEnrolPGByDayAdmGridStore','admission.admissionActivityReport.AdmissionEnrolPGOverviewAdmGridStore',
             'admission.admissionActivityReport.AdmissionEnrolPGFullSummaryAdmGridStore','admission.admissionActivityReport.AdmissionEnrolProgramByDayAdmGridStore','admission.admissionActivityReport.AdmissionEnrolProgramOverviewAdmGridStore',
             'admission.admissionActivityReport.AdmissionEnrolProgramFullSummaryAdmGridStore',
             'coursetransaction.studentenrollment.studentenrollmentdetail.ApplicantFieldPaginationStore',
             'enquiry.FollowUpUserWithDepartment','common.AcademyLocationNameSeparated','program.ProgramByGroupIdStore','enquiry.AcademicBatchStore','Academia.store.common.BatchIntakeYearStore','reports.applicationreport.ApplicationFollowupListStore',
             'enquiry.SeatTypeStore'],

    views: ['reports.admission.ProvisionalAndTrialAdmissionReportPanel','reports.admission.ProvisionalAdmissionReportPanel',
            'reports.admission.ProvisionalAndTrialAdmissionReportSearchForm','reports.admission.TrialAdmissionReportPanel',
            'reports.admission.ProvisionalTrialAdmissionReportPanel','personinfo.student.StudentProfile',
            'personinfo.common.PersonInfoPanel','reports.admission.QuotaReportPanel',
            'reports.admission.QuotaReportTabPanel','reports.admission.QuotaReportSearchPanel',
            'reports.admission.QuotaReportSearchForm','admission.selectionStage.StageStatasticsGrid',
            'Academia.view.criteriabuilder.grid.SearchResultGrid', 'reports.admission.QuotaOverridesReportQuickSearchForm', 
            'reports.admission.QuotaOverridesReportQuickSearchView','reports.admission.QuotaVoilationReportSearchView',
            'reports.admission.QuotaVoilationReportQuickSearchForm','reports.admission.QuotaViolationReportGrid',
            'Academia.view.criteriabuilder.grid.SearchResultGrid','reports.admission.admissionDemographics.AdmissionDemographicsView',
            'reports.admission.admissionDemographics.AdmissionDemographicsSearchForm','reports.common.PieChartReport',
            'reports.admission.admissionDemographics.AdmissionDemographicsReportView',
            'reports.admission.admissionDemographics.AdmissionDemographicsWithoutBreakup',
            'reports.admission.admissionDemographics.AdmissionDemographicsWithBreakup',
            'admission.deletedApplicantsReport.DeletedApplicantsReportTabStructure',
            'admission.deletedApplicantsReport.DeletedApplicantsReportStructure',
            'admission.deletedApplicantsReport.DeletedApplicantsReportFilter',
            'admission.deletedApplicantsReport.DeletedApplicantsReportGrid','admission.admissionActivityReport.AdmissionActivityReportStructure',
            'admission.admissionActivityReport.AdmissionActivityReportForm','admission.admissionActivityReport.AdmissionActivityReportFilter',
            'admission.admissionActivityReport.AdmissionActivityReportGrid','admission.admissionActivityReport.SourceWiseCountOfEnquiries',
            'admission.admissionActivityReport.SaleAndAdmissionEnrolReportAdmGridStructure','admission.admissionActivityReport.SaleAdmissionEnrolAcademyFullSummaryAdmGrid',
            'admission.admissionActivityReport.SaleAdmissionEnrolAcademyOverviewAdmGrid','admission.admissionActivityReport.SaleAdmissionEnrolAcademyByDayAdmGrid',
            'admission.admissionActivityReport.SaleAndAdmissionEnrolReportALAdmGridStructure','admission.admissionActivityReport.SaleAndAdmissionEnrolReportPGAdmGridStructure',
            'admission.admissionActivityReport.SaleAndAdmissionEnrolReportProgramAdmGridStructure','admission.admissionActivityReport.SaleAdmissionEnrolALFullSummaryAdmGrid',
            'admission.admissionActivityReport.SaleAdmissionEnrolALOverviewAdmGrid','admission.admissionActivityReport.SaleAdmissionEnrolALByDayAdmGrid',
            'admission.admissionActivityReport.SaleAdmissionEnrolPGFullSummaryAdmGrid','admission.admissionActivityReport.SaleAdmissionEnrolPGOverviewAdmGrid',
            'admission.admissionActivityReport.SaleAdmissionEnrolPGByDayAdmGrid','admission.admissionActivityReport.SaleAdmissionEnrolProgramFullSummaryAdmGrid',
            'admission.admissionActivityReport.SaleAdmissionEnrolProgramOverviewAdmGrid','admission.admissionActivityReport.SaleAdmissionEnrolProgramByDayAdmGrid',
            'admission.applicationFollowUpReport.ApplicationFollowUpTabStructure','admission.applicationFollowUpReport.ApplicationFollowUpDashboardForm',
            'admission.applicationFollowUpReport.ApplicationFollowUpDashboardFilter','admission.applicationFollowUpReport.ApplicationFollowUpDashboardGrid'],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
        ref: 'organizationunit',
        selector: 'organizationunit'
    },{
    	ref: 'provisionalAdmissionSearchForm',
    	selector: 'provisionalandtrialadmissionreportsearchform[itemId=provisionalAdmissionReportSearchForm]'
    },{
    	ref: 'trialAdmissionSearchForm',
    	selector: 'provisionalandtrialadmissionreportsearchform[itemId=trialAdmissionReportSearchForm]'
    },{
    	ref: 'provisionalAdmissionSearchGrid',
    	selector: 'searchresultgrid[itemId=provisionalAdmissionReportSearchGrid]'
    },{
    	ref: 'trialAdmissionSearchGrid',
    	selector: 'searchresultgrid[itemId=trialAdmissionReportSearchGrid]'
    },{
    	ref: 'quotaReportSearchForm',
    	selector: 'quotareportsearchform[itemId=quotaReportSearchForm]'
    },{
    	ref: 'quotaReportSearchGrid',
    	selector: 'stagestatasticsgrid[itemId=quotaReportSearchGrid]'
    },{
        ref: 'quotaOverridesReportQuickSearch',
        selector: 'quotaoverridesreportquicksearchform'
    }, {
        ref: 'quotaOverridesReportResultGrid',
        selector: 'searchresultgrid[itemId=quotaOverridesReportResultGrid]'
    },{
    	ref: 'quotaVoilationReportQuickSearchForm',
    	selector: 'quotavoilationreportquicksearchform'
    },{
    	ref: 'quotaVoilationReportResultGrid',
    	selector: 'quotaviolationreportgrid[itemId=quotaVoilationReportResultGrid]'
    },{
    	ref: 'admissionReportOrganizationUnit',
    	selector: 'organizationunit[itemId=admissionReportOrganizationUnit]'
    },{
    	ref: 'admissionDemographicsSearchForm',
    	selector: 'admissiondemographicssearchform[itemId=admissionDemographicsSearchForm]'
    },{
    	ref: 'maleFemaleChartForm',
    	selector: 'piechartreport[itemId=maleFemaleChart]'
    },{
    	ref: 'ageRangeChartForm',
    	selector: 'piechartreport[itemId=ageRangeChart]'
    },{
    	ref: 'marriedUnmarriedChartForm',
    	selector: 'piechartreport[itemId=marriedUnmarriedChart]'
    },{
    	ref: 'incomeRangeChartForm',
    	selector: 'piechartreport[itemId=incomeRangeChart]'
    },{
    	ref: 'countryChartForm',
    	selector: 'piechartreport[itemId=countryChart]'
    },{
    	ref: 'categoriesChartForm',
    	selector: 'piechartreport[itemId=categoriesChart]'
    },{
    	ref: 'bloodGroupChartForm',
    	selector: 'piechartreport[itemId=bloodGroupChart]'
    },{
    	ref: 'religionChartForm',
    	selector: 'piechartreport[itemId=religionChart]'
    },{
    	ref: 'maleFemaleWithChartForm',
    	selector: 'piechartreport[itemId=maleFemaleWithChart]'
    },{
    	ref: 'ageRangeWithChartForm',
    	selector: 'piechartreport[itemId=ageRangeWithChart]'
    },{
    	ref: 'marriedUnmarriedWithChartForm',
    	selector: 'piechartreport[itemId=marriedUnmarriedWithChart]'
    },{
    	ref: 'incomeRangeWithChartForm',
    	selector: 'piechartreport[itemId=incomeRangeWithChart]'
    },{
    	ref: 'countryWithChartForm',
    	selector: 'piechartreport[itemId=countryWithChart]'
    },{
    	ref: 'categoriesWithChartForm',
    	selector: 'piechartreport[itemId=categoriesWithChart]'
    },{
    	ref: 'bloodGroupWithChartForm',
    	selector: 'piechartreport[itemId=bloodGroupWithChart]'
    },{
    	ref: 'religionWithChartForm',
    	selector: 'piechartreport[itemId=religionWithChart]'
    },{
    	ref: 'admissionDemographicsOrganizationUnit',
    	selector: 'organizationunit[itemId=admissionDemographicsOrganizationUnit]'
    },{
    	ref: 'admissionDemographicsWithoutBreakup',
    	selector: 'admissiondemographicswithoutbreakup[itemId=admissionDemographicsWithoutBreakup]'
    },{
    	ref: 'admissionDemographicsWithBreakup',
    	selector: 'admissiondemographicswithbreakup[itemId=admissionDemographicsWithBreakup]'
    },{
    	ref: 'deletedapplicantsreportgrid',
    	selecter: 'deletedapplicantsreportgrid'
    },{
		ref:'admissionactivityreportform',
		selector:'admissionactivityreportform'
	},{
		ref:'admissionactivityreportfilter',
		selector:'admissionactivityreportfilter'
	},{
		ref:'admissionactivityreportgrid',
		selector:'admissionactivityreportgrid'
	},{
		ref:'sourcewisecountofenquiries',
		selector:'sourcewisecountofenquiries'
	},{
		ref:'saleandadmissionenrolreportadmgridstructure',
		selector:'saleandadmissionenrolreportadmgridstructure'
	},{
		ref:'saleadmissionenrolacademyfullsummaryadmgrid',
		selector:'saleadmissionenrolacademyfullsummaryadmgrid'
	},{
		ref:'saleadmissionenrolacademyoverviewadmgrid',
		selector:'saleadmissionenrolacademyoverviewadmgrid'
	},{
		ref:'saleadmissionenrolacademybydayadmgrid',
		selector:'saleadmissionenrolacademybydayadmgrid'
	},{
		ref:'saleandadmissionenrolreportaladmgridstructure',
		selector:'saleandadmissionenrolreportaladmgridstructure'
	},{
		ref:'saleandadmissionenrolreportpgadmgridstructure',
		selector:'saleandadmissionenrolreportpgadmgridstructure'
	},{
		ref:'saleandadmissionenrolreportprogramadmgridstructure',
		selector:'saleandadmissionenrolreportprogramadmgridstructure'
	},{
		ref:'saleadmissionenrolalfullsummaryadmgrid',
		selector:'saleadmissionenrolalfullsummaryadmgrid'
	},{
		ref:'saleadmissionenrolaloverviewadmgrid',
		selector:'saleadmissionenrolaloverviewadmgrid'
	},{
		ref:'saleadmissionenrolalbydayadmgrid',
		selector:'saleadmissionenrolalbydayadmgrid'
	},{
		ref:'saleadmissionenrolpgfullsummaryadmgrid',
		selector:'saleadmissionenrolpgfullsummaryadmgrid'
	},{
		ref:'saleadmissionenrolpgoverviewadmgrid',
		selector:'saleadmissionenrolpgoverviewadmgrid'
	},{
		ref:'saleadmissionenrolpgbydayadmgrid',
		selector:'saleadmissionenrolpgbydayadmgrid'
	},{
		ref:'saleadmissionenrolprogramfullsummaryadmgrid',
		selector:'saleadmissionenrolprogramfullsummaryadmgrid'
	},{
		ref:'saleadmissionenrolprogramoverviewadmgrid',
		selector:'saleadmissionenrolprogramoverviewadmgrid'
	},{
		ref:'saleadmissionenrolprogrambydayadmgrid',
		selector:'saleadmissionenrolprogrambydayadmgrid'
	},{
		ref:'applicationfollowupdashboardfilter',
		selector:'applicationfollowupdashboardfilter'
	},{
        ref:'applicationfollowuptabstructure',
  	  	selector:'applicationfollowuptabstructure' 
  	  },
  	  {
  		ref:'applicationfollowupdashboardgrid',
  		selector:'applicationfollowupdashboardgrid' 
  	  }
	],
    
    config: {
    	programSelectionProcessStageId: null,
  	    PROVOSIONALANDTRIAL_DASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROVOSIONALANDTRIAL_DASHBOARD_PRIVILEGES'),
  	    ADMISSION_DEMOGRAPHICSREPORT_DASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_DEMOGRAPHICSREPORT_DASHBOARD_PRIVILEGES'),
        PROVISIONAL_TRIAL_ADMISSION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROVISIONAL_TRIAL_ADMISSION_PRIVILEGES'),
       // QUATO_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('QUATO_REPORT_PRIVILEGES'),
        APPLICANTS_DELETED_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_DELETED_REPORT_PRIVILEGES'),
        ADMISSION_ACTIVITY_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_ACTIVITY_REPORT_PRIVILEGES'),
        APPLICATION_FOLLOWUP_DASHBOARD_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_FOLLOWUP_DASHBOARD_PRIVILEGES')
    },
    
    init: function(application) {
        this.control({
        	
        	'organizationunit[itemId=admissionReportOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getPROVOSIONALANDTRIAL_DASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=admissionReportOrganizationUnit] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    			}
    		},
    		
        	'fieldcontainer[itemId=admissionReportprogrmBatchSeatTypeContainer] combo[itemId=programId]': {
        		render: function(programComboField, records, eOpts) {
        			var $this = this;
        			setTimeout(function(){
        				$this.loadProgramComboByApplyingMAUFilter(programComboField,records, eOpts);
            		},600);
        		},
        		select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( batchComboField, comboValue, 'id');
                }
        	},
        	
        	'fieldcontainer[itemId=admissionReportprogrmBatchSeatTypeContainer] combo[itemId=batchId]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#seatTypeId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(sectionComboField, comboValue, 'batchId');
                }
        	},
        	
        	'fieldcontainer[itemId=admissionReportQuotaTypeContainer] combo[itemId=quotaTypeId]': {
        		select : function(combo,records, eOpts){
        			var quotaComboField = combo.up('form').down('#quotaId');
        			var comboValue = combo.getValue();
        			this.loadDependentCombo(quotaComboField, comboValue, 'quotaTypeId');
        		}
        	},
        	
        	'provisionalandtrialadmissionreportsearchform[itemId=provisionalAdmissionReportSearchForm] combo[itemId=intakeYear]' : {
        		select : function(combo){
        			var programComboField = combo.up('form').down('#programId');
        			var comboValue = combo.getValue();
        			var academyLocationIds = this.getAcademyLocationIds();
        			var store = programComboField.getStore();
        			  store.getProxy().extraParams = {
        			    academyLocationIds : academyLocationIds,
        			    intakeYearId : comboValue
        			   };
        			store.load();
        		}
        	},
        	
        	'provisionalandtrialadmissionreportsearchform[itemId=trialAdmissionReportSearchForm] combo[itemId=intakeYear]' : {
        		select : function(combo){
        			var programComboField = combo.up('form').down('#programId');
        			var comboValue = combo.getValue();
        			var academyLocationIds = this.getAcademyLocationIds();
        			var store = programComboField.getStore();
        			  store.getProxy().extraParams = {
        			    academyLocationIds : academyLocationIds,
        			    intakeYearId : comboValue
        			   };
        			store.load();
        		}
        	},
        	
        	'provisionalandtrialadmissionreportsearchform[itemId=provisionalAdmissionReportSearchForm] button[itemId=provisionalTrialFindButtonId]': {
        		click: function(button){
        			this.loadProvisionalAdmissionReportGrid(button,true);
        		},
        		render: function(button){
        			var $this = this;
        			setTimeout(function(){
        				$this.loadTrialProvisionalAdmissionform(button,false,true);
            			$this.loadProvisionalAdmissionReportGrid(button,false);
            		},600);
        			
        		}
        	},
        	
        	'provisionalandtrialadmissionreportsearchform[itemId=trialAdmissionReportSearchForm] button[itemId=provisionalTrialFindButtonId]': {
        		click: function(button){
        			this.loadTrialAdmissionReportGrid(button,true);
        		},
        		render: function(button){
        			this.loadTrialProvisionalAdmissionform(button,true,false);
        			this.loadTrialAdmissionReportGrid(button,false);
        		}
        	},
        	
        	'provisionalandtrialadmissionreportsearchform[itemId=provisionalAdmissionReportSearchForm] button[itemId=provisionalTrialClearSearch]': {
        		click: this.clearSearchForm
        	},
        	
        	'provisionalandtrialadmissionreportsearchform[itemId=trialAdmissionReportSearchForm] button[itemId=provisionalTrialClearSearch]': {
        		click: this.clearSearchForm
        	},
        	
        	'admissiondemographicssearchform[itemId=admissionDemographicsSearchForm] button[itemId=admissionDemographicsResetButtonId]' : {
        		click : function(obj) {
        			var form = obj.up('form');
        			form.getForm().reset();
        			var program = form.down('#programIds');
        			program.reset();
        			//program.setHeight(40);
        			program.clearAllDataFn();
        			if (!isNullOrEmpty(program)) {
        				var academyLocationIds = this.getAcademyLocationFilterIds();
        				program.getStore().getProxy().extraParams = {
        					academyLocationIds : academyLocationIds
        				};
        				program.getStore().load();
        			}
        			var batchComboField = form.down('#batchIds');
        			batchComboField.setDisabled(true);
        			batchComboField.clearValue();
        			batchComboField.store.removeAll();
        			//batchComboField.setHeight(40);
        			batchComboField.clearAllDataFn();
        			var seatTypeComboField = form.down('#seatTypeIds');
        			seatTypeComboField.setDisabled(true);
        			seatTypeComboField.clearValue();
        			seatTypeComboField.store.removeAll();
        			//seatTypeComboField.setHeight(40);
        		}
        	},
        	'admissiondemographicssearchform[itemId=admissionDemographicsSearchForm] multiselectcombofield[itemId=multiselectAcademyLocationId]':{
        		change:function(obj,record){ 
    				var form = this.getAdmissionDemographicsSearchForm();
    				var programComboField  = form.down('#programIds');
    				this.loadProgramDemographicsByApplyingMAUFilter(programComboField,null);
    			},
    			render:function(obj){
    				var permission = this.getADMISSION_DEMOGRAPHICSREPORT_DASHBOARD_PERMISSIONS();
  		  			this.organizationDemographicsUnitChange(obj,null,permission);
    			}
        	},
        	
            /**
             * For Quota Report
             */
            'fieldcontainer[itemId=quotaReportprogrmBatchSeatTypeContainer] combo[itemId=programId]': {
        		focus : function(programComboField, records, eOpts) {
        			this.loadProgramComboByApplyingMAUFilter(programComboField, null);
        		},
        		select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( batchComboField, comboValue, 'id');
                }
        	},
        	
        	'fieldcontainer[itemId=quotaReportprogrmBatchSeatTypeContainer] combo[itemId=batchId]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#seatTypeId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(sectionComboField, comboValue, 'batchId');
                }
        	},
        	
        	'fieldcontainer[itemId=quotaReportprogrmBatchSeatTypeContainer] combo[itemId=seatTypeId]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#selectionStageCombo');
                    var comboValue = records[0].get('id');
                    this.loadDependentCombo(sectionComboField, comboValue, 'programBatchSeatConfigId');
                }
        	},
        	
        	'fieldcontainer[itemId=selectionComboContainer] combo[itemId=selectionStageCombo]': {
        		select: function(selectionStageCombo) {
        			this.setProgramSelectionProcessStageId(selectionStageCombo.getValue());
        			this.loadStage(selectionStageCombo);
        			var grid = this.getQuotaReportSearchGrid();
                    var quotaTypeCombo = grid.down('#quotaTypesCombo');
                    this.loadComponentStore(quotaTypeCombo, 'programSelectionProcessId', this.getProgramSelectionProcessId());
                }
        	},
        	
        	'quotareportsearchform[itemId=quotaReportSearchForm] button[itemId=quotaReportFindButtonId]': {
        		click : function(){
        			this.loadGrids();
        		}
        	},
        	
        	'quotareportsearchform[itemId=quotaReportSearchForm] button[itemId=quotaReportClearSearch]': {
        		click : this.clearSearchForm
        	},
        	
        	/*'stagestatasticsgrid[itemId=quotaReportSearchGrid]': {
        		render: function(grid){
        			var overrideQuotaLimits = grid.down('#overrideQuotaLimits');
        			overrideQuotaLimits.setVisible(false);
        			var transferSeatBtn = grid.down('#transferSeatBtn');
        			transferSeatBtn.setVisible(false);
        		}
        	},	*/
        	
        	'stagestatasticsgrid[itemId=quotaReportSearchGrid] multiselectcombofield': {
            	change: function(combo, newValue, oldValue, eOpts ) {
					var grid = combo.up('grid');
					var store = grid.getStore();
					store.filterGrid(newValue);
            	}
            },
            
            /**
             * This event is for quota override report
             */
            'fieldcontainer[itemId=quotaOverrideprogrmBatchSeatTypeContainer] combo[itemId=programId]': {
        		focus : function(programComboField, records, eOpts) {
        			this.loadProgramComboByApplyingMAUFilter(programComboField, null);
        		},
        		select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( batchComboField, comboValue, 'id');
                }
        	},
        	
        	'fieldcontainer[itemId=quotaOverrideprogrmBatchSeatTypeContainer] combo[itemId=batchId]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#seatTypeId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(sectionComboField, comboValue, 'batchId');
                }
        	},
        	
        	'fieldcontainer[itemId=quotaOverrideprogrmBatchSeatTypeContainer] combo[itemId=seatTypeId]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#selectionStageCombo');
                    var comboValue = records[0].get('id');
                    this.loadDependentCombo(sectionComboField, comboValue, 'programBatchSeatConfigId');
                }
        	},
        	
            'quotaoverridesreportquicksearchform button[itemId=quotaOverridesReportSearchButtonId]': {
            	click: function(){
        			this.loadQuotaOverrideGrid();
        		}
            },
            
            'quotaoverridesreportquicksearchform button[itemId=quotaOverridesReportClearSearch]': {
            	click : this.clearSearchForm
            },
            
            /**
             * This event is for quota violation report
             */
            'fieldcontainer[itemId=quotaVoilationprogrmBatchSeatTypeContainer] combo[itemId=programId]': {
        		focus : function(programComboField, records, eOpts) {
        			this.loadProgramComboByApplyingMAUFilter(programComboField,null);
        		},
        		select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( batchComboField, comboValue, 'id');
                }
        	},
        	
        	'fieldcontainer[itemId=quotaVoilationprogrmBatchSeatTypeContainer] combo[itemId=batchId]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#seatTypeId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(sectionComboField, comboValue, 'batchId');
                }
        	},
        	
        	'fieldcontainer[itemId=quotaVoilationprogrmBatchSeatTypeContainer] combo[itemId=seatTypeId]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#selectionStageCombo');
                    var comboValue = records[0].get('id');
                    this.loadDependentCombo(sectionComboField, comboValue, 'programBatchSeatConfigId');
                }
        	},
        	
        	'quotavoilationreportquicksearchform button[itemId=quotaViolationReportSearchButtonId]': {
            	click: function(){
        			this.loadQuotaViolationGrid();
        		}
            },
            
            'quotavoilationreportquicksearchform button[itemId=quotaViolationReportClearSearch]': {
            	click : this.clearSearchForm
            },
            
            /**
             * Export function for provisional admission report
             */
            'searchresultgrid[itemId=provisionalAdmissionReportSearchGrid]': {
            	cellclick: this.cellClickStudentSearchResultGrid,
            	 afterrender: function(grid) {
                 	this.gridRenderFunction(grid);
                 	this.genericCBGridAccessControlValidation(grid, this.getPROVISIONAL_TRIAL_ADMISSION_PERMISSIONS());
                 	var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
 			   		viewButton.setVisible(false);
                 }
            },
            'searchresultgrid[itemId=provisionalAdmissionReportSearchGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.PDFEXPORT,'pdf',false,'PROVISIONAL');
	            }
	        },
	        'searchresultgrid[itemId=provisionalAdmissionReportSearchGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.PDFEXPORT,'pdf',true,'PROVISIONAL');
	            }
	        },
	        'searchresultgrid[itemId=provisionalAdmissionReportSearchGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'PROVISIONAL');
	            }
	        },
	        'searchresultgrid[itemId=provisionalAdmissionReportSearchGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'PROVISIONAL');
	            }
	        }, 
	        
	        /**
             * Export function for trial admission report
             */
	        'searchresultgrid[itemId=trialAdmissionReportSearchGrid]': {
	        	cellclick: this.cellClickStudentSearchResultGrid,
	        	 afterrender: function(grid) {
	                	this.gridRenderFunction(grid);
	                	this.genericCBGridAccessControlValidation(grid, this.getPROVISIONAL_TRIAL_ADMISSION_PERMISSIONS());
	                	var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
	 			   		viewButton.setVisible(false);
	                }
	        },
            'searchresultgrid[itemId=trialAdmissionReportSearchGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.PDFEXPORT,'pdf',false,'TRIAL');
	            }
	        },
	        'searchresultgrid[itemId=trialAdmissionReportSearchGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.PDFEXPORT,'pdf',true,'TRIAL');
	            }
	        },
	        'searchresultgrid[itemId=trialAdmissionReportSearchGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'TRIAL');
	            }
	        },
	        'searchresultgrid[itemId=trialAdmissionReportSearchGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'TRIAL');
	            }
	        },
	        
	        /**
             * Export function for quota override report
             */
	        'searchresultgrid[itemId=quotaOverridesReportResultGrid]': {
	        	 afterrender: function(grid) {
	                	grid.addExportButtonToolbar();
	                	//this.genericCBGridAccessControlValidation(grid, this.getQUATO_REPORT_PERMISSIONS());
	                	//var viewButton = grid.down("#searchResultGridBtnView");//itemId of split button
	 			   		//viewButton.setVisible(false);
	                }
	        },
            'searchresultgrid[itemId=quotaOverridesReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.PDFEXPORT,'pdf',false,'QUOTA_OVERRIDE');
	            }
	        },
	        'searchresultgrid[itemId=quotaOverridesReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.PDFEXPORT,'pdf',true,'QUOTA_OVERRIDE');
	            }
	        },
	        'searchresultgrid[itemId=quotaOverridesReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'QUOTA_OVERRIDE');
	            }
	        },
	        'searchresultgrid[itemId=quotaOverridesReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportProvisionalTrialQuotaOverrideAdmissionReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'QUOTA_OVERRIDE');
	            }
	        } ,
	        
	        /**
	         * Admission demographics report starts
	         */
	        'organizationunit[itemId=admissionDemographicsOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getADMISSION_DEMOGRAPHICSREPORT_DASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=admissionDemographicsOrganizationUnit] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    			}
    		},
    		
    		'organizationunit[itemId=admissionDemographicsOrganizationUnit] multiselectcombofield[itemId=multiselectAcademyLocationId]': {
    			change:function(obj,record){ 
    				var form = this.getAdmissionDemographicsSearchForm();
    				var programComboField  = form.down('#programIds');
    				this.loadProgramComboByApplyingMAUFilter(programComboField,null);
    			}
    		},
    		
	        /**
        	 * This events are for admission demographics reports
        	 */
        	'fieldcontainer[itemId=checkboxFieldContainer] checkbox[itemId=selectCountry]': {
        		change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkExtraComboItems(checkbox,newValue,oldValue);
                }
        	},
        	
        	'fieldcontainer[itemId=checkboxFieldContainer] checkbox[itemId=selectReligion]': {
        		change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkExtraComboItems(checkbox,newValue,oldValue);
                }
        	},
        	
        	'fieldcontainer[itemId=checkboxFieldContainer] checkbox[itemId=ageRange]': {
        		change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkExtraComboItems(checkbox,newValue,oldValue);
                }
        	},
        	
        	'fieldcontainer[itemId=checkboxFieldContainer] checkbox[itemId=incomeRange]': {
        		change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkExtraComboItems(checkbox,newValue,oldValue);
                }
        	},
        	
        	'admissiondemographicssearchform[itemId=admissionDemographicsSearchForm] combo[itemId=intakeYear]' : {
        		select : function(combo){
        			var programComboField = combo.up('form').down('#programIds');
        			var comboValue = combo.getValue();
        			var academyLocationIds = this.getAcademyLocationFilterIds();
        			programComboField.reset();
        			
        			var form = this.getAdmissionDemographicsSearchForm();
        			var batchComboField = form.down('#batchIds');
        			batchComboField.setDisabled(true);
        			batchComboField.clearValue();
        			batchComboField.store.removeAll();
        			var seatTypeComboField = form.down('#seatTypeIds');
        			seatTypeComboField.setDisabled(true);
        			seatTypeComboField.clearValue();
        			seatTypeComboField.store.removeAll();
        			
        			programComboField.clearValue();
        			programComboField.store.removeAll();
        			var store = programComboField.getStore();
        			  store.getProxy().extraParams = {
        			    academyLocationIds : academyLocationIds,
        			    intakeYearId : comboValue
        			   };
        			store.load();
        		}
        	},
        	
        	/**
        	 * this is to load prog batch seatType combo
        	 */
        	'fieldcontainer[itemId=admissionDemographicsProgrmBatchSeatTypeContainer] multiselectcombofield[itemId=programIds]': {
        		render : function(programComboField, records, eOpts) {
        			var $this = this;
        			setTimeout(function(){
        				$this.loadProgramDemographicsByApplyingMAUFilter(programComboField,null);
            		},500)
        		},
        		
        		select: function(){
        			var form = this.getAdmissionDemographicsSearchForm();
        			var batchComboField = form.down('#batchIds');
        			batchComboField.setDisabled(false);
        			batchComboField.clearValue();
        			batchComboField.store.removeAll();
        			var seatTypeComboField = form.down('#seatTypeIds');
        			seatTypeComboField.setDisabled(true);
        			seatTypeComboField.clearValue();
        			seatTypeComboField.store.removeAll();
        		},
        		blur: function(){
        			var form = this.getAdmissionDemographicsSearchForm();
        			var programComboField = form.down('#programIds');
        			var value = programComboField.getValue();
        			if(!isNullOrEmpty(value) && value.length > 0){
        				var batchComboField = form.down('#batchIds');
        				var seatTypeComboField = form.down('#seatTypeIds');
        				if(value.length == 1 && value[0] == ""){
        					batchComboField.setDisabled(true);
        					batchComboField.clearValue();
        					batchComboField.store.removeAll();        					
        					seatTypeComboField.setDisabled(true);
        					seatTypeComboField.clearValue();
        					seatTypeComboField.store.removeAll();
        					//batchComboField.setHeight(40);
        					batchComboField.clearAllDataFn();
        				}
        				else{        					
        					batchComboField.setDisabled(false);
        					batchComboField.clearValue();
        					batchComboField.store.removeAll();        					
        					seatTypeComboField.setDisabled(true);
        					seatTypeComboField.clearValue();
        					seatTypeComboField.store.removeAll();
        				}
        			}        			
        		}
        	},
        	
        	'fieldcontainer[itemId=admissionDemographicsProgrmBatchSeatTypeContainer] multiselectcombofield[itemId=batchIds]': {
        		focus : function(){
        			var form = this.getAdmissionDemographicsSearchForm();
        			var programComboField = form.down('#programIds');
        			var batchComboField = form.down('#batchIds');
        			var seatTypeComboField = form.down('#seatTypeIds');
        			var value = programComboField.getValue();
        			var programIds = new Array();
        			
        			if(!isNullOrEmpty(value) && value.length > 0){
        				Ext.each(value, function(values) {
        					if(values instanceof Object){
        						programIds.push(values.get('id'));
        					}else{
        						programIds.push(values);
        					}
            			});
            			programIds = programIds.toString();
            			if(!isNullOrEmpty(programIds)) {
            				this.loadBatchComboByApplyingMAUFilter(batchComboField,programIds,seatTypeComboField);
            			}
        			}
        		},
        		select: function(){
        			var form = this.getAdmissionDemographicsSearchForm();
        			var seatTypeComboField = form.down('#seatTypeIds');
        			seatTypeComboField.setDisabled(false);
        			seatTypeComboField.clearValue();
        			seatTypeComboField.store.removeAll();
        		},
        		blur: function(){
        			var form = this.getAdmissionDemographicsSearchForm();
        			var batchComboField = form.down('#batchIds');
        			var value = batchComboField.getValue();
        			if(!isNullOrEmpty(value) && value.length > 0){
        				var seatTypeComboField = form.down('#seatTypeIds');
        				if(value.length == 1 && value[0] == ""){
        					seatTypeComboField.setDisabled(true);
                			seatTypeComboField.clearValue();
                			seatTypeComboField.store.removeAll();
        				}
        				else{
        					seatTypeComboField.setDisabled(false);
                			seatTypeComboField.clearValue();
                			seatTypeComboField.store.removeAll();
        				}            			        				
        			}
        		}
        	},
        	'fieldcontainer[itemId=admissionDemographicsProgrmBatchSeatTypeContainer] multiselectcombofield[itemId=seatTypeIds]': {
        		focus : function(){
        			var form = this.getAdmissionDemographicsSearchForm();
        			var seatTypeComboField = form.down('#seatTypeIds');
        			var batchComboField = form.down('#batchIds');
        			var value = batchComboField.getValue();
        			var batchIds = new Array();
        			if(!isNullOrEmpty(value) && value.length > 0) {
        				Ext.each(value, function(values) {
        					if(values instanceof Object){
        						batchIds.push(values.get('id'));
        					}else{
        						batchIds.push(values);
        					}
        				});
            			batchIds = batchIds.toString();
            			if(!isNullOrEmpty(batchIds)) {
            				this.loadSeatTypeComboByApplyingMAUFilter(seatTypeComboField,batchIds);
            			}
        			}
        		}
        	},
        	
        	/**
        	 * This is to load without breakup pie chart on click of search button
        	 */
        	'admissiondemographicssearchform[itemId=admissionDemographicsSearchForm] button[itemId=admissionDemographicsSearchButtonId]': {
        		click: function(){
        			this.loadAdmissionDemographicsWithoutBreakup();
        		}
        	},
        	
        	/**
        	 * This is to load with breakup pie chart on combo selection
        	 */
        	'fieldcontainer[itemId=showBreakupFieldContainerId] combo[itemId=acadLocId]': {
        		select: function(combo){
        			this.enableAcademyLocationCombo(combo);
        		}
        	},
        	
        	/**
        	 * 
        	 */
        	'fieldcontainer[itemId=showBreakupFieldContainerId] combo[itemId=academyId]':{
        		focus: function(combo){
        			this.loadAcademyLocationCombo(combo);
        		},
        		select : function(combo){
        			this.loadAdmissionDemographicsWithBreakup(combo,'ACADEMY');
        		}
        	},
        	
        	/**
        	 * 
        	 */
        	'fieldcontainer[itemId=showBreakupFieldContainerId] combo[itemId=locationId]':{
        		focus : function(combo){
        			this.loadAcademyLocationCombo(combo);
        		},
        		select : function(combo){
        			this.loadAdmissionDemographicsWithBreakup(combo,'LOCATION');
        		}
        	},
        	
        	/**
        	 * This is to hide show without breakup chart
        	 */
        	'admissiondemographicswithoutbreakup[itemId=admissionDemographicsWithoutBreakup] panel[itemId=admissiondemographicswithoutbreakupPanel]':{
        		render: function(panel){
        			panel.setVisible(false);
        		}
        	},
        	
        	/**
        	 * this is to hide show with breakup chart
        	 */
        	'admissiondemographicswithbreakup[itemId=admissionDemographicsWithBreakup] panel[itemId=admissionDemographicsWithBreakupPanel]':{
        		render : function(panel){
        			panel.setVisible(false);
        		}
        	},
        	'deletedapplicantsreportfilter button[itemId=searchFilterBtn]': {
            	click: function(btn){
        			this.loadDeleteApplicantGrid(btn);
        		}
            },
            
            'deletedapplicantsreportfilter button[itemId=resetBtn]': {
            	click: function(btn){
        			var form = btn.up('form');
        			form.getForm().reset();
        		}
            },
        	'deletedapplicantsreportfilter customcombobox[itemId=applicantName]': {
            	render: function(combo){
            		var appCombostore = combo.getStore();
            		appCombostore.getProxy().extraParams = {
            			academyLocationId: this.getCurrentAcademyLocation(),
            			isApplicationGrid:true
            		};
            	}
            },
            'deletedapplicantsreportgrid ': {
   			   render: function(grid){
   				 this.doAccessControlValidation(grid, this.getAPPLICANTS_DELETED_REPORT_PERMISSIONS());
   				 var buttonsToolBar = grid.query('toolbar')[0];
       		     var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
            	 var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
            	 pdftoolbar.setDisabled(true);
            	 exceltoolbar.setDisabled(true);
   			   }
            },
     		'admissionactivityreportgrid':{
				render : function(grid){
					this.doAccessControlValidation(grid, this.getADMISSION_ACTIVITY_REPORT_PERMISSIONS());
					var buttonsToolBar = grid.query('toolbar')[0];
           		    var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
                	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
                	pdftoolbar.setDisabled(true);
                	exceltoolbar.setDisabled(true);
				},
				cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					   if (e.target.tagName == 'A') {
						   var $this = this;
						   var formWindow = $this.getSourcewisecountofenquiries();
						   if (formWindow) {
							   formWindow.destroy();
						   }
						   Ext.widget('sourcewisecountofenquiries');
						   var formWindow = $this.getSourcewisecountofenquiries();
						   formWindow.down('#academyLocation').setValue(record.data.academyLocationName);
						   formWindow.down('#userName').setValue(record.data.userName);
						   formWindow.show();
						   if(!isNullOrEmpty(record.data.startDate))
							{	
							   startDate = Ext.Date.format(new Date(record.data.startDate), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);//records[i].data.fromDate;
								if(startDate==="0NaN-NaN-NaN"){
									startDate= record.data.startDate;
								}
							}
							if(!isNullOrEmpty(record.data.endDate))
							{
								endDate = Ext.Date.format(new Date(record.data.endDate), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);//records[i].data.toDate;
								if(endDate==="0NaN-NaN-NaN"){
									endDate= record.data.endDate;
								}
							}
						   var intakeYearId = record.data.intakeYearId;
						   var seatType = record.data.seatTypeIds;
						   
						   var seatTypeIdsValue =null;
						   if (!isNullOrEmpty(seatType)&& !isNullOrEmpty(seatType[0])) {
	    	 	 			     var seatTypeIdsArray=[];
	    	 	 			    seatTypeIdsValue = [];
	    	 	 			     for(var i in seatType) {
	    	 	 			     	if(typeof seatType[i] == "object") {
	    	 	 			     	seatTypeIdsArray.push(seatType[i].data.id);
	    	 	 			     	} else {
	    	 	 			     		seatTypeIdsArray.push(seatType[i]);
	    	 	 			      	}
	    	 	 			     }
	    	 	 			     var seatTypeIdsString = seatTypeIdsArray.join();
	    	 	 			   seatTypeIdsString = seatTypeIdsString.toString();
	    	 	 			   var seatTypeCommaIndex = seatTypeIdsString.indexOf(",");
	    	 	 			   if (seatTypeCommaIndex != 0) {
	    	 	 			   		var seatTypeIdsArray = seatTypeIdsString.split(",");
	    	 	 			   		seatTypeIdsValue = seatTypeIdsArray.join();
	    	 	 			   } else {
	    	 	 			   		seatTypeIdsValue = [seatTypeIdsString];	    	 	 				   	    	 	 				   
	    	 	 			   }
	    	 	 			 }
						   
						   var innerGrid = formWindow.down('grid');
						   innerGridStore = innerGrid.getStore();
						   innerGridStore.getProxy().extraParams = {
							   ownerId: record.data.userId,
							   academyLocationId:record.data.academyLocationId,
							   startDate:startDate ,
							   endDate:endDate,
							   intakeYearId:intakeYearId,
							   seatTypeIds:seatTypeIdsValue
				            };
						   $this.resetPageSetting(innerGridStore);
						   innerGridStore.load({
							   callback: function(record,grid, operation, success) {
								   if (record.length > 0) {
									   this$.toggleGridSummaryRow(innerGrid,true);
								   }else{
									   this$.toggleGridSummaryRow(innerGrid,false);
								   }
							   }
						   });
					   }
				   }
     		},
    		'admissionactivityreportfilter multiselectcombofield[itemId=multiselectAcademyId]':{
    			afterrender:function(obj, record){
					var $this = this;
  				   var academyLocationStore =  obj.getStore();
  				   var academyLocation = $this.getCurrentAcademyLocation();
  				   academyLocationStore.load({
  					   callback: function(records, operation, success) {
  						   for(var i in records){
  							   if(records[i].data.id==academyLocation){
  								 obj.setValue(records[i].data.id);
  							   }
  						   }
  					   }
  				   });
				},
				change:function(obj,record){
					var $this = this;
					var value = obj.getValue();
					var form = $this.getAdmissionactivityreportfilter();
					var radioGroupSelectedvalue = form.down('#admissionActivityReportRadiogroupUnitId').getValue();
					if(radioGroupSelectedvalue.admissionActivityReportRadioUnit==true){
						form.down("#usersId").reset();
						form.down("#usersId").clearAllDataFn();
						form.down("#usersId").setDisabled(true);
						if(value.length>0){
							form.down("#usersId").setDisabled(false);
							if(!Ext.isObject(record[0])){
								var academyLocationId = record.join();
								var store = form.down("#usersId").getStore();
								store.getProxy().extraParams = {
									academyLocationIds: academyLocationId
								},
								store.load(); 
							}
						}  
					}else{
						setTimeout(function(){
							$this.loadDataChangedByAcademyLocationAdm(obj);
						},300);
					}
					//form.isValid(); 
				}
    		},
    		'admissionactivityreportfilter button[itemId=searchBtn]': {
                click: function(btn) {
                 	$this=this;
                 	var form = btn.up('admissionactivityreportfilter');
                 	var radioGroupSelectedvalue = form.down('#admissionActivityReportRadiogroupUnitId').getValue();
					if(radioGroupSelectedvalue.admissionActivityReportRadioUnit==true){
						$this.loadAdmissionActivityReportGrid(btn);
					}else{
						var viewTargetByAdm = form.down('#viewTargetByAdm').getValue();
						$this.loadAdmissionEnrolmentSummaryReportGrid(viewTargetByAdm);
					}
                }
    		},
    		'admissionactivityreportfilter button[itemId=resetBtn]':{
				click:function(obj, record){
					var $this = this;
					$this.resetFormByButtonAndRadioClickEvent($this,obj);
				}
    		},
    		'admissionactivityreportfilter radiogroup[itemId=admissionActivityReportRadiogroupUnitId]':{
    			change: function(radioField, newValue, oldValue, eOpts) {
    				var $this =this;
            		var formWin = $this.getAdmissionactivityreportfilter();
            		$this.onChangeAdmissionActivityReportRadioGroup(formWin, newValue);
            		$this.resetFormByButtonAndRadioClickEvent($this,radioField);
            	}
    		},
            'admissionactivityreportfilter multiselectcombofield[itemId=multiselectAcademyWiseAdmId]':{
    			render:function(obj, record){
					var $this = this;
					obj.getStore().load({
						callback: function(record){
							obj.select(obj.getStore().collect(obj.valueField));
						}
					});
				}
    		},
            'admissionactivityreportfilter [itemId=viewTargetByAdm]': {
                render:function(combo){
    				   combo.getStore().load({
    					   callback: function(records, operation, success) {
    						   for(var i in records){
    							   if(records[i].data.id=='ACADEMY'){
    								   combo.setValue(records[i].data.id);
    							   }
    						   }
    					   }	   
    				   });
                },
                change: function(obj, record) {
                	var form = this.getAdmissionactivityreportfilter();
					var radioGroupSelectedvalue = form.down('#admissionActivityReportRadiogroupUnitId').getValue();
					if(radioGroupSelectedvalue.admissionActivityReportRadioUnit==false){
						this.getShowAndHideAdmissionActivityReportFilter(); 
					}
                }
            },
            'admissionactivityreportfilter': {
        	    render: function(formWin) {
        	        var this$ = this;
        	        var itemIdPrivilegeNameArray = [{"#admissionUserActivityReportRadioUnitId": "USER_ACTIVITY_REPORT","#admissionSaleActivityReportRadioUnitId": "SALE_ADMISSION_ENROLMENT_SUMMARY_REPORT","radioGroupItemId": "#admissionActivityReportRadiogroupUnitId","defaultButtonItemId": "#admissionUserActivityReportRadioUnitId"}];
        	            this$.disableRadioGroupAndOtherPivileges(formWin, this$.getADMISSION_ACTIVITY_REPORT_PERMISSIONS(), itemIdPrivilegeNameArray);
        	            var associatedAcadLocationIds = new Array();
        	    		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
        	    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this$.getADMISSION_ACTIVITY_REPORT_PERMISSIONS());
        	    		Ext.each(permissionList, function(privilege) {
        	        		if (privilege === 'USER_ACTIVITY_REPORT') {
        	        			this$.setAllowBlank (formWin.down('#saleIntakeYearAdmItemId'),true); 
        	        			this$.setAllowBlank (formWin.down('#multiselectAcademyWiseAdmId'),true); 
        	        			this$.setAllowBlank (formWin.down('#programGroupWiseAdmId'),true); 
        	        			this$.setAllowBlank (formWin.down('#viewTargetByAdm'),true); 
        	        			this$.setAllowBlank (formWin.down('#startDate'),false);
        	        			this$.setAllowBlank (formWin.down('#endDate'),false);
        	            	}
        	        	});
        	           
        	    }
        	},
            'admissionactivityreportfilter customcombobox#programGroupAdmItemId': {
                select: function(obj, record) {
                    this.loadProgramComboAdm();
                }
            },
            'admissionactivityreportfilter combo[itemId=programAdmItemId]': {
                select: function(obj, record) {
                	var $this =this;
                    var programId = record[0].get("id");
                    if (programId > 0) {
                        var filter = $this.getAdmissionactivityreportfilter();

                        var batchItemId = filter.down("#batchAdmItemId");
                        var seatTypeAdmItemId = filter.down("#seatTypeAdmItemId");
                        batchItemId.setDisabled(false);
                        seatTypeAdmItemId.setDisabled(true);
                        batchItemId.reset();
                        seatTypeAdmItemId.reset();

                        var batchStore = batchItemId.getStore();
                        batchStore.proxy.extraParams = {
                            id: programId
                        };
                        batchStore.load();
                    }
                }
            },
            'admissionactivityreportfilter combo[itemId=batchAdmItemId]': {
                select: function(obj, record) {
                	var $this =this;
                    var batchId = record[0].get("id");
                    if (batchId > 0) {
                        var filter = $this.getAdmissionactivityreportfilter();

                        var seatTypeAdmItemId = filter.down("#seatTypeAdmItemId");
                        seatTypeAdmItemId.setDisabled(false);
                        seatTypeAdmItemId.reset();

                        var seatTypeStore = seatTypeAdmItemId.getStore();
                        seatTypeStore.proxy.extraParams = {
                            batchId: batchId
                        };
                        seatTypeStore.load();
                    }
                }
            },
            
            'applicationfollowupdashboardfilter multiselectcombofield#academyLocationId':{
            	render: function(obj) {
            		var form = this.getApplicationfollowupdashboardfilter().getForm();
            		var userId = this.getCurrentlyLoggedInUser().id;
            		var academyLocationfield = form.findField('multiselectAcademyLocation');
            		var currentAcademyLocation=this.getCurrentAcademyLocation();
            		var store = obj.getStore();

            		store.getProxy().extraParams = {
            			id: userId
            		};
            		store.load({
            			callback: function(record){
            				academyLocationfield.setValue(currentAcademyLocation);
            			}
            		});
            	},
            	change: function(ob, rec) {
            		var form = this.getApplicationfollowupdashboardfilter().getForm();
            		var academyLocationId = ob.up('form').down('#academyLocationId').getValue();
            		var alIds = [];
            		var academyLocationIds;
            		if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
            			for (var i in academyLocationId) {
            				if (Ext.isObject(academyLocationId[0])) {
            					alIds.push(academyLocationId[i].get("id"));
            				} else {
            					alIds.push(academyLocationId[i]);
            				}
            			}
            			academyLocationIds = alIds.join();
            		} else {
            			alIds.push(this.getCurrentAcademyLocation());
            			academyLocationIds = alIds.join();
            		}
            		
            		var programId = ob.up('form').down('#programId');
            		programId.reset();
            		
                    var programStore = programId.getStore();
            		programStore.getProxy().extraParams = {
            			academyLocationIds: academyLocationIds
            		};
            		programStore.load();
            
            		var batchId = ob.up('form').down('#batchId');
            		batchId.reset();
            		batchId.setDisabled(true);
            		
            		var intakeId = ob.up('form').down('#intakeYear');
            		intakeId.reset();
            		var intakeStore = intakeId.getStore();
            		intakeStore.getProxy().extraParams = {
            			academyLocationIds: academyLocationIds
            		};
            		intakeStore.load();		
            		
            		var applicantId = ob.up('form').down('#applicantId');
            		applicantId.reset();
            		var applicationStore = applicantId.getStore();
            		applicationStore.getProxy().extraParams = {
            			academyLocationIds: academyLocationIds
            		};
            		applicationStore.load();
            		
            		var applicationOwnerId = ob.up('form').down('#applicationOwnerId');
            		applicationOwnerId.reset();
            		var applicationOwnerStore = applicationOwnerId.getStore();
            		applicationOwnerStore.getProxy().extraParams = {
            			academyLocationIds: academyLocationIds
            		};
            	    //applicationOwnerStore.load();
            		
            		var followUpUserId = ob.up('form').down('#followUpUserId');
            		followUpUserId.reset();
            		var followUpUserStore = followUpUserId.getStore();
            		followUpUserStore.getProxy().extraParams = {
            			academyLocationIds: academyLocationIds
            		};
            		//followUpUserStore.load();
            	}
            },

            'applicationfollowupdashboardfilter customcombobox[itemId=intakeYear]': {
            	select: function(obj, record) {
            		var form = this.getApplicationfollowupdashboardfilter(); 
            		
            		var programId = obj.up('form').down('#programId');
            		programId.reset();

            		form.down("#batchId").setDisabled(true);
            		form.down("#batchId").reset();

            		var intakeYearId = record[0].get("id");

            		if (intakeYearId > 0) {
            			var programStore = programId.getStore();
            			programStore.getProxy().extraParams = {
            				intakeYearId: intakeYearId
            			};
            			programStore.load();
            		}
            	},
            },

            
            'applicationfollowupdashboardfilter customcombobox[itemId=programId]': {
            	select: function(obj, record) {
            		var form = this.getApplicationfollowupdashboardfilter(); 
            		var x=form.down("#batchId").setDisabled(false);
            		var programId = record[0].get("id");
            		form.down("#batchId").reset();
            		
            		var batchId = obj.up('form').down('#batchId');
            		if (programId > 0) {
            			var store = batchId.getStore();
            			store.getProxy().extraParams = {
            				programIds : programId
            			};
            			store.load();
            		}
            	},
            },
        
            
            'applicationfollowupdashboardgrid' : {
            	afterrender: function(grid) {
            		var me = this;
            		me.addDataGridConfigButton(grid,me.getAPPLICATION_FOLLOWUP_DASHBOARD_PERMISSIONS());
            		 var buttonsToolBar = grid.query('toolbar')[0];
           		     var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
                	 var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
                	 pdftoolbar.setDisabled(true);
                	 exceltoolbar.setDisabled(true);
            	}
            },

            'applicationfollowupdashboardfilter button[itemId=resetBtn]' : {
            	click : function(ob, rec){
            		var $this=this;
            		var form=$this.getApplicationfollowupdashboardfilter().getForm();

            		ob.up('form').down('#fromdate').setMaxValue(null);
            		ob.up('form').down('#fromdate').setMinValue(null);
            		ob.up('form').down('#todate').setMaxValue(null);
            		ob.up('form').down('#todate').setMinValue(null);
            		
            		ob.up('form').down('#scheduleFromDate').setMaxValue(null);
            		ob.up('form').down('#scheduleFromDate').setMinValue(null);
            		ob.up('form').down('#scheduleToDate').setMaxValue(null);
            		ob.up('form').down('#scheduleToDate').setMinValue(null);
            		
            		var programId = ob.up('form').down('#programId');
            		programId.reset();
            		form.reset();
            	
            		var academyLocationfield = form.findField('multiselectAcademyLocation');
            		var currentAcademyLocation=$this.getCurrentAcademyLocation();
            				academyLocationfield.setValue(currentAcademyLocation);            		
            	}
            },
            
      	  'applicationfollowupdashboardfilter button[itemId=searchBtn]' : {
			    click: function(){
			    	var formLayout = this.getApplicationfollowupdashboardfilter();
			    	this.showInvalidIconOnField(formLayout);
			    	var form = this.getApplicationfollowupdashboardfilter().getForm();
			    	var grid = this.getApplicationfollowupdashboardgrid();
			    	var buttonsToolBar = grid.query('toolbar')[0];
			    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
			    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
			    	pdftoolbar.setDisabled(true);
			    	exceltoolbar.setDisabled(true);
			    	var values = form.getValues();
			    	var $this=this;
			    	var applicantId = values.applicantId;
			    	var academyLocationIds = values.multiselectAcademyLocation;
			    	
			    	var alIds = [];
            		var academyLocationAllIds;
            		if (academyLocationIds != undefined && academyLocationIds.length > 0 && academyLocationIds[0] != "") {
            			for (var i in academyLocationIds) {
            				if (Ext.isObject(academyLocationIds[0])) {
            					alIds.push(academyLocationIds[i].get("id"));
            				} else {
            					alIds.push(academyLocationIds[i]);
            				}
            			}
            			academyLocationAllIds = alIds.join();
            		}
            		else
            			{
            			academyLocationAllIds=this.getCurrentAcademyLocation();
            			}
            		
			    	var intakeYearId = values.intakeYear;
			    	var applicationOwner = values.applicationOwner;
			    	var programId = values.programId;
			    	var batchId = values.batch;
			    	var fromDateString = values.fromdate;
			    	var toDateString = values.todate;
			    	var followUpUser=values.followUpUser;
			    	var scheduleToDate=values.scheduleToDate;
			    	var scheduleFromDate=values.scheduleFromDate;
			    	
			    	var store=grid.getStore();
			    	$this.resetPageSetting(store);
			    	store.getProxy().extraParams = {
			    		academyLocationIds: academyLocationAllIds,
			    		applicationId  :applicantId,
			    		intakeYearId:intakeYearId,
			    		program :programId,
			    		batchId :batchId,
			    		fromDate :fromDateString,
			    		toDate:toDateString,
			    		owner:applicationOwner,
			    		followUpUser:followUpUser,
			    		scheduleFromDate:scheduleFromDate,
			    		scheduleToDate:scheduleToDate
			       };
			       store.load({
			    	   callback: function(records, operation, success) {
			    		   if(records.length>0){
			    			   pdftoolbar.setDisabled(false);
			    			   exceltoolbar.setDisabled(false);
			    		   }
			    	   }
			       });

			      /***************Start Code added for show filter data on PDF/Excel Export Report **************/
			    	
			    	grid.config.searchFilterForm = this.getApplicationfollowupdashboardfilter();
			    	
			    	/***************End Code added for show filter data on PDF/Excel Export Report **************/
			      }      
		  },
              
            'applicationfollowupdashboardgrid':{
            	 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 					var $this =this;
 					if(columnName == "applicantCode"){
 		    			  var applicantId = record.get('applicantCode'); 
 							$this.openApplicantProfileFromApplicantFollowUpReport(applicantId, true,grid,record);
 		    		  }
 				},
 				 afterrender : function(grid){
      				var me = this;
      				me.addDataGridConfigButton(grid,me.getAPPLICATION_FOLLOWUP_DASHBOARD_PERMISSIONS());
      			}
            }
        });

    },
    
    /**
     * This is for export function provisional and trial admission report
     */
    openApplicantProfileFromApplicantFollowUpReport:function(applicationId,isView,searchResultGrid,record){
	  	  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
		  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
		  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
		  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyListController');
		  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
		  Academia.app.getController('Academia.controller.admission.admissionCommon.AdmissionFormCommonController');
		  Academia.app.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
		  Academia.app.getController('Academia.controller.admission.directSubmission.DirectSubmissionController');
		  Academia.app.getController('Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController');
		  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration');
		  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration');
		  Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
		  Academia.app.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
		  Academia.app.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');
		  if(searchResultGrid){
			  var store=searchResultGrid.getStore();
			  var tabTitle = null;
			  var personId = null;
			  var applicationId = null;
			  var admissionId = null;
			  var record = record;
			  tabTitle = record.get('applicantCode');
			  applicationId = record.get('applicationId');
			  admissionId = record.get('applicantCode');
			  var applicationBaseController =Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
			  var me=applicationBaseController;
			  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
			  if(applicantProfile){
				  me.getContentPanel().setActiveTab(applicantProfile);
				  Ext.getBody().unmask();
			  }else{
				  me.addContentPanelTab(tabTitle, 'applicantprofile', null, null,applicationId,admissionId);
				  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
				  if (applicantProfile) {            	
					  me.setParameterForApplicantProfile(applicantProfile,record,'',isView);
					  me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
					  me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);    			
					  var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
					  var applicantPortalController  = me.getController('Academia.controller.portal.ApplicantPortalController');
     	        	   applicantPortalController.loadPanellinkForApplicant(applicantProfile, applicantLinkPanelObject);
					  me.gettingDataInSummaryGrid(applicantProfile);    
					  //me.getApplicantProfileInformation(applicantProfile);
					  if(!isEmpty(applicantLinkPanelObject)){

						  var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];    				
						  me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);

						  var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
						  me.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);

						  var personInfoPanel=applicantProfile.down("#personInfoPanel");
						  var saveBtn = applicantProfile.down('#personalInfoSaveButtonId');
				    	  saveBtn.setVisible(false);
						  if(personInfoPanel){
							  var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
							  if(applicantPersonalDetails){
								  var applicantProfileItems = applicantProfile.down('actionbuttonpanel').items.items;
								  if(applicantProfileItems != undefined && applicantProfileItems.length > 0){
									  applicantProfileItems.forEach(function(buttons) {
						    			    	buttons.hide();
						    			});
						    		}
								  personInfoPanel.setActiveTab(applicantPersonalDetails);
							  }        						
						  }

					  }

				  }
			  }    	        
		  }                	
	},
    
    exportProvisionalTrialQuotaOverrideAdmissionReport : function(exportUrl,filetype,whetherAll,requestType) {
    	var quickSearchForm=null;	
    	var searchResultGrid= null;
    	var pagingtoolbaroptions = null;
    	var reportTitle = null;
    	var jsonFormatFormData = null;
    	if(requestType == 'PROVISIONAL'){
    	 quickSearchForm=this.getProvisionalAdmissionSearchForm();
    	 searchResultGrid = this.getProvisionalAdmissionSearchGrid();
    	 pagingtoolbaroptions = this.getProvisionalAdmissionSearchGrid().down('pagingtoolbar').getStore().lastOptions;
    	 jsonFormatFormData=this.createProvisionalTrialJsonFormat(quickSearchForm,'PROVISIONAL');
       	var reportTitle=getCommonTranslation('PROVISIONAL_ADMISSION_REPORT');
    	}
    	if(requestType == 'TRIAL'){
    	 quickSearchForm=this.getTrialAdmissionSearchForm();
    	 searchResultGrid = this.getTrialAdmissionSearchGrid();	
    	 pagingtoolbaroptions = this.getTrialAdmissionSearchGrid().down('pagingtoolbar').getStore().lastOptions;
    	 jsonFormatFormData=this.createProvisionalTrialJsonFormat(quickSearchForm,'TRIAL');
        	var reportTitle=getCommonTranslation('TRIAL_ADMISSION_REPORT');
    	}
    	if(requestType == 'QUOTA_OVERRIDE'){
    	 quickSearchForm=this.getQuotaOverridesReportQuickSearch();
       	 searchResultGrid = this.getQuotaOverridesReportResultGrid();	
       	 pagingtoolbaroptions = this.getQuotaOverridesReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
       	 jsonFormatFormData=this.createProvisionalTrialJsonFormat(quickSearchForm,'TRIAL');
     	var reportTitle=getCommonTranslation('QUOTA_OVERRIDE_REPORT');
    	}
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	
	/**
	 * This function is to get the search criteria string
	 */
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        /**
    	 * This is to get MAU filter academy location search string
    	 * @author pravin.surve
    	 */
        var academyLocationIds = this.getAcademyLocationIds();
    	if(!isNullOrEmpty(academyLocationIds)){
    		academyLocationIds = academyLocationIds.toString();
    		var commaIndex = academyLocationIds.indexOf(",");
    		if(commaIndex != -1){    			
            	formValues= academyLocationIds.split(",");
    		}else{
    			formValues = [academyLocationIds];
    		}        	
    	}
		var academyForm = this.getOrganizationunit();
		var multiAcademyLocationCombo = academyForm.down('#multiselectAcademyLocationId');
		var academyLocationCombo = academyForm.down('#academyLocationId');
		var academyLocationValue = academyLocationCombo.getValue();
		var multiAcademyLocationValue = multiAcademyLocationCombo.getValue();
		if(!isNullOrEmpty(multiAcademyLocationValue)){
		var rawValue = this.getMultiselectRawValue(academyForm, 'multiselectAcademyLocation');
		var keyValueJsonObject = me.getJsonObject(getCommonTranslation('ACADEMY_LOCATION_NAME'), formValues, null);
		searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+rawValue+ " ,";
		}else if(isNullOrEmpty(multiAcademyLocationValue) && isNullOrEmpty(academyLocationValue)){
			var rawValue = Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].rawValue;
			var keyValueJsonObject = getCommonTranslation('ACADEMY_LOCATION_NAME');
			searchCriteriaString=searchCriteriaString+keyValueJsonObject+"  : "+rawValue+ " ,";
		}else if(isNullOrEmpty(academyLocationValue)){
			var rawValue = this.getMultiselectRawValue(academyForm, 'academyLocation');
			var keyValueJsonObject = me.getJsonObject(getCommonTranslation('ACADEMY_LOCATION_NAME'), formValues, null);
			searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+rawValue+ " ,";
		}
		
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    
    /**
     * This function is to get value of academyLocation of MAU filter
     */
    getMultiselectRawValue : function(form, name){
    	var rawValue = '';
    	var formValues = form.getValues();
    	if(!isNullOrEmpty(name)){
    		var array = formValues[name];
    		for(var i = 0; i < array.length; i++){
    			var multiSelectCombo = form.down('multiselectcombofield[name='+name+']');
    			var store = multiSelectCombo.getStore();
    			var record = store.findRecord('id', array[i]);
    			if( record == null ){
    				record = store.findRecord('id', array[i].data.id);
    			}
    			rawValue += record.get('value');
    			if(i < array.length-1){
    				rawValue += ', ';
    			}
    		}
    		return rawValue;
    	}
    	
    },
    
    /**
     * This function is to get export buttons on grid
     */
    gridRenderFunction:function(grid){
		grid.addButtonToolbar();
    },
    
    
    loadTrialProvisionalAdmissionform: function(button, whetherTrialAdmission,whetherProvisionalAdmission) {
    	var form= button.up('provisionalandtrialadmissionreportsearchform');
    	var trialEndDateSelector=form.down('#trialEndDateSelector');
    	var provisionalEndDateSelector=form.down('#provisionalEndDateSelector');
    	trialEndDateSelector.setVisible(whetherTrialAdmission);
    	provisionalEndDateSelector.setVisible(whetherProvisionalAdmission);

    	var admissionStatus=form.down('#admissionStatus');
    	if(whetherTrialAdmission){
	    	
	        var store=Ext.create('Ext.data.Store', {
	            fields: ['value', 'display'],
	            data: [{
	                	 "display": getAdmissionTranslation('ADMITTED_ON_TRIAL_BASIS'),
	                     "value": 'ADMITTED_ON_TRIAL_BASIS'
	                },{
	               	 	"display": getAdmissionTranslation('WITHDRAW_AFTER_TRIAL'),
	                    "value": 'WITHDRAW_AFTER_TRIAL'
	                },{
	               	 	"display": getAdmissionTranslation('ADMISSION_CONFIRMED'),
	                    "value": 'ADMISSION_CONFIRMED'
	                }]
	        });
	        admissionStatus.bindStore( store );
    	}else{
           var store=Ext.create('Ext.data.Store', {
               fields: ['value', 'display'],
               data: [{
                       "display": getAdmissionTranslation('PROVISIONAL_ADMISSION_REJECTED'),
                       "value": 'PROVISIONAL_ADMISSION_REJECTED'
                   },{
                   		 "display": getAdmissionTranslation('ADMITTED_PROVISIONALLY'),
                         "value": 'ADMITTED_PROVISIONALLY'
                   },{
                  		 "display": getAdmissionTranslation('WITHDRAW_AFTER_PROVISION'),
                       	 "value": 'WITHDRAW_AFTER_PROVISION'
                   },{
                  		 "display": getAdmissionTranslation('ADMISSION_CONFIRMED'),
                      	 "value": 'ADMISSION_CONFIRMED'
                   }]
           });
	        admissionStatus.bindStore( store );
    	}
        
    },
    
    
    /**
     *This is to load provisional admission report grid 
     */
    loadProvisionalAdmissionReportGrid: function(button,isClicked) {
	    var AL= this.getAdmissionReportOrganizationUnit().down('#multiselectAcademyLocationId');
        if(isClicked) {
        if(AL.value != undefined && AL.value[0] != "" ){
    	var SearchForm= button.up('provisionalandtrialadmissionreportsearchform');
        var jsonFormatFormData = this.createProvisionalTrialJsonFormat(SearchForm,'PROVISIONAL');
        var ResultGrid = this.getProvisionalAdmissionSearchGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PROVISIONAL_ADMISSION_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
        }
        else {
	       showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECT_ACADEMY_LOCATION')); 
        }
        }
        else {
	        var SearchForm= button.up('provisionalandtrialadmissionreportsearchform');
        var jsonFormatFormData = this.createProvisionalTrialJsonFormat(SearchForm,'PROVISIONAL');
        var ResultGrid = this.getProvisionalAdmissionSearchGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.PROVISIONAL_ADMISSION_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
        }
    },
    
    /**
     *This is to load trial admission report grid 
     */
    loadTrialAdmissionReportGrid: function(button,isClicked) {
	    var AL= this.getAdmissionReportOrganizationUnit().down('#multiselectAcademyLocationId');
        if(isClicked) {
        if(AL.value != undefined && AL.value[0] != "" ){ 
    	var SearchForm= button.up('provisionalandtrialadmissionreportsearchform');
        var jsonFormatFormData = this.createProvisionalTrialJsonFormat(SearchForm,'TRIAL');
        var ResultGrid = this.getTrialAdmissionSearchGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TRIAL_ADMISSION_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
        }
         else {
	       showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECT_ACADEMY_LOCATION')); 
        } 
        }
        else {
	        var SearchForm= button.up('provisionalandtrialadmissionreportsearchform');
        var jsonFormatFormData = this.createProvisionalTrialJsonFormat(SearchForm,'TRIAL');
        var ResultGrid = this.getTrialAdmissionSearchGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.TRIAL_ADMISSION_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
        }
        
    },
    
    /**
     * Create provisional report search criteria json
     * @params searchCriteriaForm
     */
    createProvisionalTrialJsonFormat: function(searchForm,requestType){
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        
        if(requestType == 'PROVISIONAL'){
        	 values.configCode = CONSTANTS.CB.PROVISIONAL_ADMISSION_REPORT_BASIC_CONFIGCODE;
        }
        if(requestType == 'TRIAL'){
        	 values.configCode = CONSTANTS.CB.TRIAL_ADMISSION_REPORT_BASIC_CONFIGCODE;
        }

        var REQUEST_DATE = this.getJsonObject('REQUEST_DATE', formValues.fromDate, formValues.toDate);
        this.pushJsonObjectInArray(REQUEST_DATE, searchcriteria);
        
        formValues = searchForm.getValues();        
        
        var START_DATE = this.getJsonObject('START_DATE', formValues.START_DATE, formValues.END_DATE);
        this.pushJsonObjectInArray(START_DATE, searchcriteria);
        delete formValues.START_DATE;
        delete formValues.END_DATE;
        
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = this$.getJsonObject( key , value);
                this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        
        var multiselectAcademyLocation = this.getAcademyLocationIds();
    	if(!isNullOrEmpty(multiselectAcademyLocation)){
    		multiselectAcademyLocation = multiselectAcademyLocation.toString();
    		var commaIndex = multiselectAcademyLocation.indexOf(",");
    		if(commaIndex != -1){    			
            	formValues= multiselectAcademyLocation.split(",");
    		}else{
    			formValues = [multiselectAcademyLocation];
    		}        	
    	}
    	
    	 var obj =this. getOrganizationUnitIds();
         if(obj.ou){
         	formValues.ou = obj.ou;
         }else if(obj.mau){
         	formValues.mau = obj.mau;
         }
         
    	if(formValues.length>0){
    		var keyValueJsonObject = this$.getJsonObject('multiselectAcademyLocation', formValues, null, true);
            this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);                		
    	}
    	        
    	values.searchCriterias = searchcriteria;
        return values;
    },
    
    
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue,extraParam) {
    	if(extraParam){
      		 if (value != '' && additionalValue == undefined) {
      	            return {
      	                "paramCode": key,
      	                "paramValues": value
      	            };
      	        }
      	}
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    
    /**
     * This method is used to clear fields on search Form
     * @param button which is reference of button
     */
    clearSearchForm: function(button) {
        
        var form=button.up('form');        
        if(form){
        	var basicForm = form.getForm();
            var provisionalEndDate = basicForm.findField('END_DATE');
            var provisionalStartDate = basicForm.findField('START_DATE');
            provisionalEndDate.setMaxValue(null);
            provisionalEndDate.setMinValue(null);
            provisionalStartDate.setMaxValue(null);
            provisionalStartDate.setMinValue(null);
            
            var trialEndDate = basicForm.findField('TRIAL_END_DATE');
            var trialStartDate = basicForm.findField('TRIAL_START_DATE');
            
            trialEndDate.setMaxValue(null);
            trialEndDate.setMinValue(null);
            trialStartDate.setMaxValue(null);
            trialStartDate.setMinValue(null);
        	
        	basicForm.getFields().each(function(field) {
                field.reset();
            });
        
        }  
        var program = form.down('#programId');
        if(!isNullOrEmpty(program)) {
        	var academyLocationIds = this.getAcademyLocationIds();
			program.getStore().getProxy().extraParams={
				academyLocationIds : academyLocationIds
			};
			program.getStore().load();
        }
    },
    
    /**
     *This function is to open student profile 
     */
    cellClickStudentSearchResultGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var columnName = view.getGridColumns()[cellIndex].dataIndex;

        if (columnName == "STUDENT_CODE") {
            var tabTitle = record.get('STUDENT_CODE');
            var personId = record.get('PERSON_ID');
            var userId = record.get('ID');
            var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
            var personController = this.getController('Academia.controller.personinfo.common.PersonCommonController');
            personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId);
        }
        
        return false; 
    },
    
    /**
     * On focus program combo load data according with MAU filter's
     * @param programComboField
     * @param records
     * @param eOpts
     */
    
    loadProgramComboByApplyingMAUFilter: function(programComboField,form){
    	if(form){
    		var batchCombo = form.down('#batchIds');
        	batchCombo.setDisabled(false);
    	}
		var academyLocationIds = this.getAcademyLocationIds();
		var store = programComboField.getStore();
		  store.getProxy().extraParams = {
		    academyLocationIds : academyLocationIds   
		   };
		store.load();
		
	},
	loadProgramDemographicsByApplyingMAUFilter: function(programComboField,form){
    	if(form){
    		var batchCombo = form.down('#batchIds');
        	batchCombo.setDisabled(false);
    	}
		var academyLocationIds = this.getAcademyLocationFilterIds();
		var store = programComboField.getStore();
		  store.getProxy().extraParams = {
		    academyLocationIds : academyLocationIds   
		   };
		store.load();
		
	},
    
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.setDisabled(false);
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.itemId) {
        case 'programId':
            this.clearCombo(combo);
            batchCombo = container.down('combo[itemId=batchId]');
            this.clearCombo(batchCombo);
            sectionCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(sectionCombo);
            selectionCombo = container.down('combo[itemId=selectionStageCombo]');
            if(selectionCombo)
            	this.clearCombo(selectionCombo);
            break;
        case 'batchId':
            this.clearCombo(combo);
            sectionCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(sectionCombo);
            selectionCombo = container.down('combo[itemId=selectionStageCombo]');
            if(selectionCombo)
            	this.clearCombo(selectionCombo);
            break;
        case 'seatTypeId':
            this.clearCombo(combo);
            selectionCombo = container.down('combo[itemId=selectionStageCombo]');
            if(selectionCombo)
            	this.clearCombo(selectionCombo);
            break;
        case 'quotaTypeId':
        	this.clearCombo(combo);
        	quotaCombo = container.down('combo[itemId=quotaId]');
        	this.clearCombo(quotaCombo);
        	break;
        case 'quotaId':
        	this.clearCombo(combo);
        }
    },

    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
   /**
    * Set Program Selection Process Stage ID
    */ 
    setProgramSelectionProcessStageId: function(id) {
    	this.programSelectionProcessStageId = id;
    },
    
    getProgramSelectionProcessStageObject: function() {
        var quotaReportSearchForm = this.getQuotaReportSearchForm().getForm();
        var stageObjectData = quotaReportSearchForm.findField('stageObject').getSubmitValue();
        return Ext.decode(stageObjectData);
    },
    /**
     * This function is to find programSelectionProcessId
     */
    getProgramSelectionProcessId: function() {
        return this.getProgramSelectionProcessStageObject().programSelectionProcessId;
    },
    /**
     * This function is to load data to get programSelectionProcessId
     */
    loadStage: function(selectionStageCombo) {
        var this$ = this;
        var url = SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND;
        var selectionStageId = selectionStageCombo.getValue();
        url = url.concat('/'+selectionStageId);
        Ext.Ajax.request({
            type: 'rest',
            url: url,
            method: 'GET',
            async: false,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(response) {
            	data = Ext.decode(response.responseText);
            	var form = this$.getQuotaReportSearchForm().getForm();
                form.setValues({
                    'stageObject': response.responseText
                });
                form.setValues(data);
            }
        });
    },
    
    /**
     * This function is to load quota report grid
     */
    loadGrids: function() {
    	var criteria = new Object();
    	var programSelectionProcessStageIds = new Array();
    	criteria.whetherLatest = true;
    	programSelectionProcessStageIds.push(this.getProgramSelectionProcessStageId());
    	var grid = this.getQuotaReportSearchGrid();
    	criteria.programSelectionProcessStageId = programSelectionProcessStageIds;
		var store= grid.getStore();
		store.getProxy().extraParams = {
//			params:criteria
			whetherLatest: true,
			programSelectionProcessStageId:programSelectionProcessStageIds
		};
		store.load(/*{
			params:criteria	
		}*/);
    },
    
    /**
     * This function is to load quota override grid
     */
    loadQuotaOverrideGrid: function(model, records) {
        var masterForm = this.getQuotaOverridesReportQuickSearch();
        var jsonFormatFormData = this.createJsonFormat(masterForm, records);
        var resultGrid = this.getQuotaOverridesReportResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.QUOTA_OVERRIDE_REPORT_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        Ext.getBody().unmask();
    },
    
    /**
     * Create json for quota override grid
     */
    createJsonFormat: function(MasterForm) {
        var me = this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.QUOTA_OVERRIDE_REPORT_BASIC_CONFIGCODE;
        formValues = MasterForm.getValues();

        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
            }
        }
        var academyLocationIds = this.getAcademyLocationIds();
    	if(!isNullOrEmpty(academyLocationIds)){
    		academyLocationIds = academyLocationIds.toString();
    		var commaIndex = academyLocationIds.indexOf(",");
    		if(commaIndex != -1){    			
            	formValues= academyLocationIds.split(",");
    		}else{
    			formValues = [academyLocationIds];
    		}        	
    	}
    	if(formValues.length>0){
    		var keyValueJsonObject = this.getJsonObject('academyLocationIds', formValues, null, true);
            this.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);                		
    	}
    	
        delete formValues.multiselectAcademyLocation;
        delete formValues.organizationRadioUnit;
        
        values.searchCriterias = searchcriteria;
        return values;

    },
    
    /**
     * This function is to load quota violation grid
     */
    loadQuotaViolationGrid: function(model, records) {
    	var this$= this;
    	var searchCriteriaForm = this$.getQuotaVoilationReportQuickSearchForm();
    	var resultGrid = this$.getQuotaVoilationReportResultGrid();
    	var formValues = this$.createQuotaViolationReportJsonFormat(searchCriteriaForm);
    	var store = resultGrid.getStore();
    	store.getProxy().extraParams = formValues;
    	resultGrid.down('custompagingtoolbar').moveFirst();
    },
    
    /**
     * Create quota violation report search criteria json
     * @params searchCriteriaForm
     */
    createQuotaViolationReportJsonFormat: function(searchCriteriaForm){
    	var formValues = null;
    	if(searchCriteriaForm){
    		formValues = searchCriteriaForm.getValues();
        	for (var key in formValues) {
            	var value = formValues[key];            
                if(isNullOrEmpty(value) || value =='All' || key == 'selectedNameField'){
                	delete formValues[key];
                }
            }
        	var academyLocationIds = this.getAcademyLocationIds();
        	if(!isNullOrEmpty(academyLocationIds)){
        		academyLocationIds = academyLocationIds.toString();
        		var commaIndex = academyLocationIds.indexOf(",");
        		if(commaIndex != -1){
        			var academyLocationArray = academyLocationIds.split(",");
                	formValues.academyLocationIds = academyLocationArray;
        		}else{
        			formValues.academyLocationIds = [academyLocationIds];
        		}
            	
        	}
    	}
    	return formValues;
    },
    
    /**
     * Admission demographic report
     */
    /***
     * This is to disable select template combo on check
     * @param checkbox - checkbox reference     
     * @param newValue - checkbox's new value
     * @param oldValue - checkbox's old value 
     */
    checkExtraComboItems : function(checkbox,newValue,oldValue){
    	var form=checkbox.up('form');  
    	if(form){
    		var countryCombo=form.down('#countryId');
    		var religionCombo = form.down('#religionId');
    		var ageRangeLessField = form.down('#ageRangeLess');
    		var ageRangeGreaterField = form.down('#ageRangeGreater');
    		var incomeRangeLessField = form.down('#incomeRangeLess');
    		var incomeRangeGreaterField = form.down('#incomeRangeGreater');
    		//var ageRangeCombo = from.down('#')
    		if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='selectCountry' && newValue==true){  
    			countryCombo.setVisible(true);
    			countryCombo.setDisabled(false);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='selectCountry' && newValue==false){  
        		countryCombo.setVisible(false);
        		countryCombo.setDisabled(true);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='selectReligion' && newValue==true){  
        		religionCombo.setVisible(true);
        		religionCombo.setDisabled(false);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='selectReligion' && newValue==false){  
        		religionCombo.setVisible(false);
        		religionCombo.setDisabled(true);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='ageRange' && newValue==true){  
        		ageRangeLessField.setVisible(true);
        		ageRangeLessField.setDisabled(false);
        		ageRangeGreaterField.setVisible(true);
        		ageRangeGreaterField.setDisabled(false);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='ageRange' && newValue==false){ 
        		ageRangeLessField.setVisible(false);
        		ageRangeLessField.setDisabled(true);
        		ageRangeGreaterField.setVisible(false);
        		ageRangeGreaterField.setDisabled(true);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='incomeRange' && newValue==true){  
        		incomeRangeGreaterField.setVisible(true);
        		incomeRangeGreaterField.setDisabled(false);
        		incomeRangeLessField.setVisible(true);
        		incomeRangeLessField.setDisabled(false);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='incomeRange' && newValue==false){  
        		incomeRangeGreaterField.setVisible(false);
        		incomeRangeGreaterField.setDisabled(true);
        		incomeRangeLessField.setVisible(false);
        		incomeRangeLessField.setDisabled(true);
        	}
    	}
    	
    },
    
    /**
     * This function is to load batch combo
     */
    loadBatchComboByApplyingMAUFilter: function(batchComboField, programIds, seatTypeComboField){
		var store = batchComboField.getStore();
		//seatTypeComboField.setDisabled(false);
		store.load({
			params: {
				programIds: programIds
			}
		});
	},
	
	/**
     * This function is to load seatType combo
     */
    loadSeatTypeComboByApplyingMAUFilter: function(seatTypeComboField, batchIds, eOpts){
		var store = seatTypeComboField.getStore();
		store.load({
			params: {
				batchIds: batchIds
			}
		});
	},
	
	/**
	 * This is to load without breakup pie chart
	 */
	loadAdmissionDemographicsWithoutBreakup : function(){
		var admissionDemographicsSearchForm= this.getAdmissionDemographicsSearchForm();
		//var form=Ext.ComponentQuery.query('organizationunit')[0];
    	var alFiled=admissionDemographicsSearchForm.down('#multiselectAcademyLocationId').getValue();
    	if(alFiled!=''){
		var panel = this.getAdmissionDemographicsWithoutBreakup().down('#admissiondemographicswithoutbreakupPanel');
		panel.setVisible(true);
		var formValues = this.createSearchCriteriaWithoutBreakupJsonFormat(admissionDemographicsSearchForm);
		var chartArray = ['GENDER', 'BIRTHDATE', 'MARITAL_STATUS','COUNTRY','CASTE_CATEGORY','BLOOD_GROUP','RELIGION','PERSONAL_INCOME'];
		for(var i=0; i < chartArray.length;i++){
			this.loadWithOutBreakupChart(chartArray[i],formValues);
		}
    	}else{
 	       showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECT_ACADEMY_LOCATION')); 
    	}
	},
	
	/**
	 * To load without breakup chart 
	 * @ajax call
	 */
	loadWithOutBreakupChart : function(value,formValues){
		
		var form = null;
		var url = null;
		var itemId =null;
		if(value != 'BIRTHDATE' && value != 'PERSONAL_INCOME'){
			url =SERVERURL.ADMISSION_DEMOGRAPHICS_WITH_OUT_BREAKUP;
		}
		
		formValues.groupProperty = value;
		switch(value){
		
		case 'GENDER':
			form = this.getMaleFemaleChartForm();
			itemId = 'maleFemaleChartPanel';
			break;
			
		case 'BIRTHDATE':
			form = this.getAgeRangeChartForm();
			url = SERVERURL.ADMISSION_DEMOGRAPHICS_AGE_INCOME;
			itemId = 'ageRangeChartPanel';
			break;
				
		case 'MARITAL_STATUS':
			form = this.getMarriedUnmarriedChartForm();
			itemId = 'marriedUnmarriedChartPanel';
			break;
			
		case 'COUNTRY':
			form = this.getCountryChartForm();
			itemId = 'countryChartPanel';
			break;
			
		case 'CASTE_CATEGORY':
			form = this.getCategoriesChartForm();
			itemId = 'categoriesChartPanel';
			break;
			
		case 'BLOOD_GROUP':
			form = this.getBloodGroupChartForm();
			itemId = 'bloodGroupChartPanel';
			break;
			
		case 'RELIGION': 
			form = this.getReligionChartForm();
			itemId = 'religionChartPanel';
			break;
			
		case 'PERSONAL_INCOME':
			form = this.getIncomeRangeChartForm();
			itemId = 'incomeRangeChartPanel';
			url = SERVERURL.ADMISSION_DEMOGRAPHICS_AGE_INCOME;
			break;
		}
		Ext.Ajax.request({
            type: 'rest',
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: formValues,
            success: function(response) {
            	var isAllZero = true;
            	if(!isNullOrEmpty(response.responseText)){
            		data = Ext.decode(response.responseText);
                	var counts = new Array();
                	Ext.each(data, function(value) {
                		if(!isNullOrEmpty(value.count)){
                			counts.push(value.count);
                		}
            		});
                	Ext.each(counts, function(value) {
                		if(value != 0){
                			isAllZero = false;
                			return false;
                		}
            		});
            	}
            	if(isAllZero){
            		form.nextSibling().setVisible(true);
            		if(form){
            			form.setVisible(false);
            		}
            	}else{
            		form.setVisible(true);
            		if(form.nextSibling()){
            			form.nextSibling().setVisible(false);
            		}
            		form.getStore().loadData(data);
            	}
            }
        });
	},
	
	/**
     * Create report search criteria json
     * @params searchCriteriaForm
     */
	createSearchCriteriaWithoutBreakupJsonFormat: function(searchCriteriaForm){
    	var formValues = null;
    	if(searchCriteriaForm){
    		formValues = searchCriteriaForm.getValues();
        	var academyLocationIds = this.getAcademyLocationFilterIds();
        	if(!isNullOrEmpty(academyLocationIds)){
        		academyLocationIds = academyLocationIds.toString();
        		var commaIndex = academyLocationIds.indexOf(",");
        		if(commaIndex != -1){
        			var academyLocationArray = academyLocationIds.split(",");
                	formValues.academyLocationIds = academyLocationArray;
        		}else{
        			formValues.academyLocationIds = [academyLocationIds];
        		}
            	
        	}
    	}
    	var programIds = new Array();
    	var batchIds = new Array();
    	var seatTypeIds = new Array();
    	var countryIds = new Array();
    	var religionIds = new Array();
    	var programId = new Array();
    	var batchId = new Array();
    	var seatTypeId = new Array();
    	var countryId = new Array();
    	var religionId = new Array();
    	if(!isNullOrEmpty(formValues.programId)){
    		programId = formValues.programId;
    		Ext.each(programId, function(value) {
    			if(value instanceof Object){
    				programIds.push(value.get('id'));
    			}else{
    				if(!isNullOrEmpty(value)) {
        				programIds.push(value);
    				}
    			}
    		});
    		if(programIds.length > 0) {
    			formValues.programIds = programIds;
    		}
    	}
    	if(!isNullOrEmpty(formValues.batchId)){
    		batchId = formValues.batchId;
    		Ext.each(batchId, function(value) {
    			if(value instanceof Object){
    				batchIds.push(value.get('id'));
    			}else{
    				if(!isNullOrEmpty(value)) {
    					batchIds.push(value);
    				}
    			}
    		});
    		if(batchIds.length > 0) {
            	formValues.batchIds = batchIds;
    		}
    	}
    	if(!isNullOrEmpty(formValues.seatTypeId)){
    		seatTypeId = formValues.seatTypeId;
    		Ext.each(seatTypeId, function(value) {
    			if(value instanceof Object){
    				seatTypeIds.push(value.get('id'));
    			}else{
    	    		if(!isNullOrEmpty(value)) {
        				seatTypeIds.push(value);
    				}
    			}
    		});
    		if(seatTypeIds.length > 0) {
    			formValues.seatTypeIds = seatTypeIds;
    		}
    	}
    	if(!isNullOrEmpty(formValues.countryId)){
    		countryId = formValues.countryId;
    		Ext.each(countryId, function(value) {
    			if(value instanceof Object){
    				countryIds.push(value.get('id'));
    			}else{
    				countryIds.push(value);
    			}
    		});
    		formValues.countryIds = countryIds;
    	}
    	if(!isNullOrEmpty(formValues.religionId)){
    		religionId = formValues.religionId;
    		Ext.each(religionId, function(value) {
    			if(value instanceof Object){
    				religionIds.push(value.get('id'));
    			}else{
    				religionIds.push(value);
    			}
    		});
    		formValues.religionIds = religionIds;
    	}
    	
    	delete formValues.SELECT_COUNTRY;
    	delete formValues.SELECT_RELIGION;
    	delete formValues.DEFINE_AGE_RANGE;
    	delete formValues.DEFINE_INCOME_RANCE;
    	delete formValues.programId;
    	delete formValues.batchId;
    	delete formValues.seatTypeId;
    	delete formValues.countryId;
    	delete formValues.religionId;
        delete formValues.multiselectAcademyLocation;
        delete formValues.organizationRadioUnit;
    	return formValues;
    },
    
	/**
	 * This is to load with breakup pie chart
	 */
	loadAdmissionDemographicsWithBreakup :  function(combo,value){
		var panel = this.getAdmissionDemographicsWithBreakup().down('#admissionDemographicsWithBreakupPanel');
		panel.setVisible(true);
		var admissionDemographicsSearchForm= this.getAdmissionDemographicsSearchForm();
		var formValues = this.createSearchCriteriaWithoutBreakupJsonFormat(admissionDemographicsSearchForm);
		var comboValue = combo.getValue();
		var showBreakupCombo = combo.up('form').down('#acadLocId');
		var breakUpValue = showBreakupCombo.getValue();
		if(breakUpValue == 'Academy'){
			formValues.breakupShownBy = 'ACADEMY';
		}else if(breakUpValue == 'Location'){
			formValues.breakupShownBy = 'LOCATION';
		}
		var academyId= null;
		var locationId =null;
		if(value == 'ACADEMY'){
			academyId = comboValue;
		}
		if(value == 'LOCATION'){
			locationId = comboValue;
		}
		
		var chartArray = ['GENDER', 'BIRTHDATE', 'MARITAL_STATUS','COUNTRY','CASTE_CATEGORY','BLOOD_GROUP','RELIGION','PERSONAL_INCOME'];
		for(var i=0; i < chartArray.length;i++){
			this.loadWithBreakupChart(chartArray[i],academyId,locationId,formValues);
		}
	},
	
	/**
	 * To load with breakup chart 
	 * @ajax call
	 */
	loadWithBreakupChart : function(value,academyId,locationId,formValues){
		
		var form =null;
		var url = null;
		var itemId =null;
		formValues.groupProperty = value;
		if(value != 'BIRTHDATE' && value != 'PERSONAL_INCOME'){
			url =SERVERURL.ADMISSION_DEMOGRAPHICS_WITH_OUT_BREAKUP;
		}
		if(academyId){
			formValues.academyIds = [academyId];
		}
		if(locationId){
			formValues.locationIds = [locationId];
		}
		
		switch(value){
		
		case 'GENDER':
			form = this.getMaleFemaleWithChartForm();
			itemId = 'maleFemaleWithChartPanel';
			break;
			
		case 'BIRTHDATE':
			form = this.getAgeRangeWithChartForm();
			itemId = 'ageRangeWithChartPanel';
			url = SERVERURL.ADMISSION_DEMOGRAPHICS_AGE_INCOME;
			break;
				
		case 'MARITAL_STATUS':
			form = this.getMarriedUnmarriedWithChartForm();
			itemId = 'marriedUnmarriedWithChartPanel';
			break;
			
		case 'COUNTRY':
			form = this.getCountryWithChartForm();
			itemId = 'countryWithChartPanel';
			break;
			
		case 'CASTE_CATEGORY':
			form = this.getCategoriesWithChartForm();
			itemId = 'categoriesWithChartPanel';
			break;
			
		case 'BLOOD_GROUP':
			form = this.getBloodGroupWithChartForm();
			itemId = 'bloodGroupWithChartPanel';
			break;
			
		case 'RELIGION': 
			form = this.getReligionWithChartForm();
			itemId = 'religionWithChartPanel';
			break;
			
		case 'PERSONAL_INCOME':
			form = this.getIncomeRangeWithChartForm();
			url = SERVERURL.ADMISSION_DEMOGRAPHICS_AGE_INCOME;
			itemId = 'incomeRangeWithChartPanel';
			break;
		}
		Ext.Ajax.request({
            type: 'rest',
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: formValues,
            success: function(response) {
            	var isAllZero = true;
            	if(!isNullOrEmpty(response.responseText)){
            		data = Ext.decode(response.responseText);
                	var counts = new Array();
                	Ext.each(data, function(value) {
                		if(!isNullOrEmpty(value.count)){
                			counts.push(value.count);
                		}
            		});
                	Ext.each(counts, function(value) {
                		if(value != 0){
                			isAllZero = false;
                			return false;
                		}
            		});
            	}
            	if(isAllZero){
            		form.nextSibling().setVisible(true);
            		if(form){
            			form.setVisible(false);
            		}
            	}else{
            		form.setVisible(true);
            		if(form.nextSibling()){
            			form.nextSibling().setVisible(false);
            		}
            		form.getStore().loadData(data);
            	}
            }
        });
	},
	
    
    /**
     *This is to enable academy location combo 
     */
    enableAcademyLocationCombo : function(combo){
    	var value = combo.getValue();
    	var academyCombo = combo.up('form').down('#academyId');
    	var locationCombo = combo.up('form').down('#locationId');
    	if(value == 'Academy'){
    		academyCombo.setVisible(true);
    		locationCombo.setVisible(false);
    	}
    	if(value == 'Location'){
    		academyCombo.setVisible(false);
    		locationCombo.setVisible(true);
    	}
    },
    
    /**
     * This is to load academy location combo values
     */
    loadAcademyLocationCombo : function(combo){
    	
    	var academyLocationIds = this.getAcademyLocationFilterIds();
    	var store = combo.getStore();
    		store.load({
    			params: {
    				academyLocationIds: academyLocationIds
    			}
    		});
    },
    
    loadDeleteApplicantGrid : function(btn){
    	var form = btn.up('form');
    	var deletedApplicationCombo = form.down('#deletedApplicantId');
    	var deletedApplicationId = deletedApplicationCombo.getValue();
    	var structure = form.up('panel');
    	var grid = structure.down('deletedapplicantsreportgrid');
    	var buttonsToolBar = grid.query('toolbar')[0];
        var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
        var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
        grid.getStore().getProxy().extraParams = {
            id: deletedApplicationId,
            academyLocationId: this.getCurrentAcademyLocation()
        };
    	grid.getStore().load({
			  callback: function(records, operation, success) {
	 				if(records.length>0){
	 				    	pdftoolbar.setDisabled(false);
						    	exceltoolbar.setDisabled(false);
	 					}
				 }
		});
    	
    	 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
    	   	
    	    	grid.config.searchFilterForm = btn.up('form');
         	
    	        /***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    loadAdmissionActivityReportGrid: function(btn){
    	var me = this;
    	var form = me.getAdmissionactivityreportfilter();
    	var multiselectAcademyIdField = me.getAdmissionactivityreportfilter().down('#multiselectAcademyId');
    	var usersIdField = me.getAdmissionactivityreportfilter().down('#usersId');
    	var intakeYearField = me.getAdmissionactivityreportfilter().down('#intakeYear');
    	var startDateField = me.getAdmissionactivityreportfilter().down('#startDate');
    	var endDateField = me.getAdmissionactivityreportfilter().down('#endDate');
    	var seatTypeIdField = me.getAdmissionactivityreportfilter().down('#seatType');
    	
    	var intakeYearId = intakeYearField.getValue();
    	var academyIdsArray = multiselectAcademyIdField.getValue();
    	var startDate = Ext.Date.format(new Date(startDateField.getValue()), 'Y-m-d H:i:s');
    	var endDate = Ext.Date.format(new Date(endDateField.getValue()), 'Y-m-d H:i:s');
    	var usersIdsArray = usersIdField.getValue();
    	var seatTypeIds = seatTypeIdField.getValue();
    	
    	var grid = me.getAdmissionactivityreportgrid();
    	var buttonsToolBar = grid.query('toolbar')[0];
        var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
        var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	
    	if(typeof academyIdsArray[0]!="object"){
    		var academyIds = academyIdsArray;
    	}
    	else {
    		var academyIdsTempArray = [];
    		Ext.each(academyIdsArray,function(currentAcademyId){
    			if(!isNullOrEmpty(currentAcademyId)){
    			academyIdsTempArray.push(currentAcademyId.data.id);
    			}
    		});
    		var academyIds = academyIdsTempArray.join(',');
    	}
    	if(!isNullOrEmpty(usersIdsArray)){
    		if(typeof usersIdsArray[0]!="object"){
        		var usersIds = usersIdsArray;
        	}
        	else {
        		var usersIdsTempArray = [];
        		Ext.each(usersIdsArray,function(currentUserId){
        				if(!isNullOrEmpty(currentUserId)){
        				usersIdsTempArray.push(currentUserId.data.id);
        				}
        		});
        		var usersIds = usersIdsTempArray.join(',');
        	}
    	}
    	 if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
			     var seatTypeIdsArray=[];
			     for(var i in seatTypeIds) {
			     	if(typeof seatTypeIds[i] == "object") {
			     	seatTypeIdsArray.push(seatTypeIds[i].data.id);
			     	} else {
			     		seatTypeIdsArray.push(seatTypeIds[i]);
			      	}
			     }
			     var seatTypeIdsString = seatTypeIdsArray.join();
			     }
    	
    	grid.getStore().getProxy().extraParams = {
    		intakeYearId:intakeYearId,
			academyLocationIds:academyIds,
			startDate:startDate,
			endDate:endDate,
			userIds:usersIds,
			seatTypeIds:seatTypeIdsString
		};
    	grid.getStore().load({
	    	  callback: function(records, operation, success) {
	 				if(records.length>0){
	 				    	pdftoolbar.setDisabled(false);
						    	exceltoolbar.setDisabled(false);
	 					} else {
	 						pdftoolbar.setDisabled(true);
					    	exceltoolbar.setDisabled(true);
	 					}
						  }
	 				});
    	 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
    	    	
    	   	grid.config.searchFilterForm = me.getAdmissionactivityreportfilter();
         	
            /***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    onChangeAdmissionActivityReportRadioGroup : function(formWin, newValue) {
    	    var $this =this;
	     	var viewTargetByAdmCombo = formWin.down('#viewTargetByAdm');
	     	var saleIntakeYearAdmCombo = formWin.down('#saleIntakeYearAdmItemId');
	    	var multiselectAcademyWiseAdmCombo = formWin.down('#multiselectAcademyWiseAdmId');
	    	var multiselectAcademyLocationAdmCombo = formWin.down('#multiselectAcademyId');
	    	var programGroupWiseAdmCombo = formWin.down('#programGroupWiseAdmId');
	    	var programGroupAdmItemCombo = formWin.down('#programGroupAdmItemId');
	    	var programAdmItemCombo = formWin.down('#programAdmItemId');
	    	var batchAdmItemCombo = formWin.down('#batchAdmItemId');
	    	var intakeYearCombo = formWin.down('#intakeYear');
	     	var usersItemCombo = formWin.down('#usersId');
	    	var startDateCombo = formWin.down('#startDate');
	    	var endDateCombo = formWin.down('#endDate');
	    	programGroupAdmItemCombo.setVisible(false);
	    	this.setAllowBlank (programGroupAdmItemCombo,true);
	    	programGroupWiseAdmCombo.setVisible(false);
	    	this.setAllowBlank (programGroupWiseAdmCombo,true);
	    	var admissionActivityReportFormStruc = $this.getAdmissionactivityreportform();
	    	var saleAcademySummaryGridStruc = admissionActivityReportFormStruc.down('#saleandadmissionenrolreportadmgridstructure');
	    	var saleAcademyLocationSummaryGridStruc = admissionActivityReportFormStruc.down('#saleandadmissionenrolreportaladmgridstructure');
	    	var salePGSummaryGridStruc = admissionActivityReportFormStruc.down('#saleandadmissionenrolreportpgadmgridstructure');
	    	var saleProgramSummaryGridStruc = admissionActivityReportFormStruc.down('#saleandadmissionenrolreportprogramadmgridstructure');
	    	var admissionactivityreportgridId = admissionActivityReportFormStruc.down('#admissionactivityreportgridId');
	     	if(newValue.admissionActivityReportRadioUnit == true){
	     		startDateCombo.setValue(Ext.Date.add (new Date(),Ext.Date.DAY,-6))
				endDateCombo.setValue(new Date());
	     		saleAcademySummaryGridStruc.setVisible(false);
	     		saleAcademyLocationSummaryGridStruc.setVisible(false);
	     		salePGSummaryGridStruc.setVisible(false);
	     		saleProgramSummaryGridStruc.setVisible(false);
	     		admissionactivityreportgridId.setVisible(true);
	     		viewTargetByAdmCombo.setVisible(false);
	     		saleIntakeYearAdmCombo.setVisible(false);
	     		multiselectAcademyLocationAdmCombo.setVisible(true);
	     		this.setAllowBlank (multiselectAcademyLocationAdmCombo,false);
	     		multiselectAcademyWiseAdmCombo.setVisible(false);
	     		intakeYearCombo.setVisible(true);
	     		usersItemCombo.setVisible(true);
	     		programAdmItemCombo.setVisible(false);
	     		batchAdmItemCombo.setVisible(false);
	     		programGroupWiseAdmCombo.setVisible(false);
	     		startDateCombo.setFieldLabel(getCommonTranslation('START_DATE'));
	     		this.setAllowBlank (startDateCombo,false);
	     		endDateCombo.setFieldLabel(getCommonTranslation('END_DATE'));
	     		this.setAllowBlank (endDateCombo,false);
	     		this.setAllowBlank (viewTargetByAdmCombo,true);
	     		this.setAllowBlank (saleIntakeYearAdmCombo,true);
	     		this.setAllowBlank (multiselectAcademyWiseAdmCombo,true);
	     		this.setAllowBlank (programGroupWiseAdmCombo,true);
	     		
	     	} else {
	     		saleAcademySummaryGridStruc.setVisible(true);
	     		admissionactivityreportgridId.setVisible(false);
	     		viewTargetByAdmCombo.setVisible(true);
	     		saleIntakeYearAdmCombo.setVisible(true);
	     		multiselectAcademyLocationAdmCombo.setVisible(false);
	     		this.setAllowBlank (multiselectAcademyLocationAdmCombo,true);
	     		multiselectAcademyWiseAdmCombo.setVisible(true);
	     		intakeYearCombo.setVisible(false);
	     		usersItemCombo.setVisible(false);
	     		startDateCombo.setFieldLabel(getCommonTranslation('FROM_DATE'));
	     		this.setAllowBlank (startDateCombo,true);
	     		endDateCombo.setFieldLabel(getCommonTranslation('TO_DATE'));
	     		this.setAllowBlank (endDateCombo,true);
	     		this.setAllowBlank (viewTargetByAdmCombo,false);
	     		this.setAllowBlank (saleIntakeYearAdmCombo,false);
	     		this.setAllowBlank (multiselectAcademyWiseAdmCombo,false);
	     		startDateCombo.setMaxValue(false);
	     		startDateCombo.setMinValue(false);
	     		endDateCombo.setMaxValue(false);
	     		endDateCombo.setMinValue(false);
	     		startDateCombo.reset();
				endDateCombo.reset();
				
				var academyViewByTabStructure = $this.getSaleandadmissionenrolreportadmgridstructure();
				var academyLocationViewByTabStructure = $this.getSaleandadmissionenrolreportaladmgridstructure();
				var programViewByTabStructure = $this.getSaleandadmissionenrolreportpgadmgridstructure();
				var programGroupViewByTabStructure = $this.getSaleandadmissionenrolreportprogramadmgridstructure();
				
				$this.resetViewByGridsAndHideExpAll(academyViewByTabStructure.down("#saleadmissionenrolacademyfullsummaryadmgrid"));
				$this.resetViewByGridsAndHideExpAll(academyViewByTabStructure.down("#saleadmissionenrolacademyoverviewadmgrid"));
				$this.resetViewByGridsAndHideExpAll(academyViewByTabStructure.down("#saleadmissionenrolacademybydayadmgrid"));
				
				$this.resetViewByGridsAndHideExpAll(academyLocationViewByTabStructure.down("#saleadmissionenrolalfullsummaryadmgrid"));
				$this.resetViewByGridsAndHideExpAll(academyLocationViewByTabStructure.down("#saleadmissionenrolaloverviewadmgrid"));
				$this.resetViewByGridsAndHideExpAll(academyLocationViewByTabStructure.down("#saleadmissionenrolalbydayadmgrid"));
				
				$this.resetViewByGridsAndHideExpAll(programViewByTabStructure.down("#saleadmissionenrolpgfullsummaryadmgrid"));
				$this.resetViewByGridsAndHideExpAll(programViewByTabStructure.down("#saleadmissionenrolpgoverviewadmgrid"));
				$this.resetViewByGridsAndHideExpAll(programViewByTabStructure.down("#saleadmissionenrolpgbydayadmgrid"));
				
				$this.resetViewByGridsAndHideExpAll(programGroupViewByTabStructure.down("#saleadmissionenrolprogramfullsummaryadmgrid"));
				$this.resetViewByGridsAndHideExpAll(programGroupViewByTabStructure.down("#saleadmissionenrolprogramoverviewadmgrid"));
				$this.resetViewByGridsAndHideExpAll(programGroupViewByTabStructure.down("#saleadmissionenrolprogrambydayadmgrid"));
	     	}
	     	formWin.isValid();
    },//*********************** Admission Activity Report ******************************
    getShowAndHideAdmissionActivityReportFilter : function(){
    	var $this = this;
    	var form = this.getAdmissionactivityreportfilter();
    	var viewTargetBy = form.down('#viewTargetByAdm').getValue();
    	var programGroupItemId = form.down('#programGroupAdmItemId');
    	var programGroupWiseId = form.down('#programGroupWiseAdmId');
    	var programItemId = form.down('#programAdmItemId');
    	var batchItemId = form.down('#batchAdmItemId');
    	var multiselectAcademyLocationAdm = form.down('#multiselectAcademyId');
    	var multiselectAcademyWiseAdmId = form.down('#multiselectAcademyWiseAdmId');
    	var seatTypeAdmItemId = form.down('#seatTypeAdmItemId');
    	var seatType = form.down('#seatType');
    	
    	var admissionActivityReportFormStruc = $this.getAdmissionactivityreportform();
    	var admissionactivityreportgridId = admissionActivityReportFormStruc.down('#admissionactivityreportgridId');
    	var saleAcademySummaryGridStruc = admissionActivityReportFormStruc.down('#saleandadmissionenrolreportadmgridstructure');
    	var saleAcademySummaryALGridStruc = admissionActivityReportFormStruc.down('#saleandadmissionenrolreportaladmgridstructure');
    	var saleAcademySummaryPGGridStruc = admissionActivityReportFormStruc.down('#saleandadmissionenrolreportpgadmgridstructure');
    	var saleAcademySummaryProgramGridStruc = admissionActivityReportFormStruc.down('#saleandadmissionenrolreportprogramadmgridstructure');
    	var academyLocation = $this.getCurrentAcademyLocation();

    	if(viewTargetBy=="ACADEMY_WISE"){
    		saleAcademySummaryGridStruc.setVisible(true);
    		saleAcademySummaryALGridStruc.setVisible(false);
    		saleAcademySummaryPGGridStruc.setVisible(false);
    		saleAcademySummaryProgramGridStruc.setVisible(false);
    		multiselectAcademyLocationAdm.setVisible(false);
    		multiselectAcademyWiseAdmId.setVisible(true);
    		this.setAllowBlank (multiselectAcademyLocationAdm,true);
    		this.setAllowBlank (multiselectAcademyWiseAdmId,false);
    		programGroupItemId.setVisible(false);
    		programGroupWiseId.setVisible(false);
    		this.setAllowBlank (programGroupWiseId,true);
    		programItemId.setVisible(false);
    		batchItemId.setVisible(false);
    	}
    	if(viewTargetBy=="ACADEMY_LOCATION_WISE"){
    		saleAcademySummaryGridStruc.setVisible(false);
    		saleAcademySummaryALGridStruc.setVisible(true);
    		saleAcademySummaryPGGridStruc.setVisible(false);
    		saleAcademySummaryProgramGridStruc.setVisible(false);
    		multiselectAcademyLocationAdm.setVisible(true);
    		multiselectAcademyWiseAdmId.setVisible(false);
    		this.setAllowBlank (multiselectAcademyLocationAdm,false);
    		this.setAllowBlank (multiselectAcademyWiseAdmId,true);
    		programGroupItemId.setVisible(false);
    		programGroupWiseId.setVisible(false);
    		this.setAllowBlank (programGroupWiseId,true);
    		programItemId.setVisible(false);
    		batchItemId.setVisible(false);
    		multiselectAcademyLocationAdm.getStore().load({
				   callback: function(records, operation, success) {
					   for(var i in records){
						   if(records[i].data.id==academyLocation){
							   multiselectAcademyLocationAdm.setValue(records[i].data.id);
						   }
					   }
				   }
			   });
    		
    	}
    	if(viewTargetBy=="PROGRAM_GROUP_WISE"){
    		saleAcademySummaryGridStruc.setVisible(false);
    		saleAcademySummaryALGridStruc.setVisible(false);
    		saleAcademySummaryPGGridStruc.setVisible(true);
    		saleAcademySummaryProgramGridStruc.setVisible(false);
    		multiselectAcademyLocationAdm.setVisible(true);
    		multiselectAcademyWiseAdmId.setVisible(false);
    		this.setAllowBlank (multiselectAcademyLocationAdm,false);
    		this.setAllowBlank (multiselectAcademyWiseAdmId,true);
    		programGroupItemId.setVisible(false);
    		programGroupWiseId.setVisible(true);
    		this.setAllowBlank (programGroupWiseId,false);
    		programItemId.setVisible(false);
    		batchItemId.setVisible(false);
    		$this.loadDataChangedByAcademyLocationAdm();
    		multiselectAcademyLocationAdm.getStore().load({
				   callback: function(records, operation, success) {
					   for(var i in records){
						   if(records[i].data.id==academyLocation){
							   multiselectAcademyLocationAdm.setValue(records[i].data.id);
						   }
					   }
				   }
			   });
    	}
    	if(viewTargetBy=="PROGRAM_WISE"){
    		saleAcademySummaryGridStruc.setVisible(false);
    		saleAcademySummaryALGridStruc.setVisible(false);
    		saleAcademySummaryPGGridStruc.setVisible(false);
    		saleAcademySummaryProgramGridStruc.setVisible(true);
    		multiselectAcademyLocationAdm.setVisible(true);
    		multiselectAcademyWiseAdmId.setVisible(false);
    		this.setAllowBlank (multiselectAcademyLocationAdm,false);
    		this.setAllowBlank (multiselectAcademyWiseAdmId,true);
    		programGroupItemId.setVisible(true);
    		programGroupWiseId.setVisible(false);
    		this.setAllowBlank (programGroupWiseId,true);
    		programItemId.setVisible(true);
    		batchItemId.setVisible(true);
    		seatTypeAdmItemId.setVisible(true);
    		seatType.setVisible(false);
    		multiselectAcademyLocationAdm.getStore().load({
				   callback: function(records, operation, success) {
					   for(var i in records){
						   if(records[i].data.id==academyLocation){
							   multiselectAcademyLocationAdm.setValue(records[i].data.id);
						   }
					   }
				   }
			   });
    	}
    	//form.isValid();

    },
    loadDataChangedByAcademyLocationAdm:function(obj){
    	var getForm = this.getAdmissionactivityreportfilter();
    	var form = getForm.getForm();
    	getForm.down('#programGroupAdmItemId').reset();
    	getForm.down('#programGroupWiseAdmId').reset();
    	getForm.down('#programGroupWiseAdmId').clearValue();
    	getForm.down('#programGroupAdmItemId').reset();
    	getForm.down('#programAdmItemId').reset();
    	getForm.down('#programAdmItemId').setDisabled(true);
    	form.findField('batchAdmId').reset();
    	form.findField('batchAdmId').setDisabled(true);
    	var multiselectAcademyIdField = getForm.down('#multiselectAcademyId');
    	var intakeYearItemIdField = getForm.down('#saleIntakeYearAdmItemId');
    	var academyIdsArray = multiselectAcademyIdField.getValue();
    	if(Ext.isDefined(academyIdsArray) && academyIdsArray.length>0){
    		if((Ext.isDefined(academyIdsArray.length)) && typeof academyIdsArray[0]!="object"){
    			var academyIds = academyIdsArray.join(',');
    			}else {
    			var academyIdsTempArray = [];
    			Ext.each(academyIdsArray,function(currentAcademyId){
    				if(!isNullOrEmpty(currentAcademyId)){
    				academyIdsTempArray.push(currentAcademyId.data.id);
    				}
    			});
    			var academyIds = academyIdsTempArray.join(',');
    		}
    	}else{
    		var academyIds = academyIdsArray;
    	}
    	var programStore = getForm.down('#programGroupAdmItemId').getStore();

    	programStore.getProxy().extraParams ={
    		academyLocationIds : academyIds
    	}
    	programStore.load();

    	if(!isNullOrEmpty(academyIds) && academyIdsArray.length!=0){
    		var programWiseGroup = getForm.down('#programGroupWiseAdmId');
    		var programGroupStore = programWiseGroup.getStore();

    		programGroupStore.getProxy().extraParams ={
    			academyLocationIds : academyIds
    		}
    		programGroupStore.load({
    			callback: function(record){
    				programWiseGroup.select(programWiseGroup.getStore().collect(programWiseGroup.valueField));
    			}
    		});	
    	}
    },
    loadProgramComboAdm: function() {
        var $this = this;
        var filter = $this.getAdmissionactivityreportfilter();

        var multiselectAcademyIdField = filter.down('#multiselectAcademyId');
        var academyIdsArray = multiselectAcademyIdField.getValue();
    	
    	if(typeof academyIdsArray[0]!="object"){
    		var academyIds = academyIdsArray;
    	}
    	else {
    		var academyIdsTempArray = [];
    		Ext.each(academyIdsArray,function(currentAcademyId){
    			if(!isNullOrEmpty(currentAcademyId)){
    			academyIdsTempArray.push(currentAcademyId.data.id);
    			}
    		});
    		var academyIds = academyIdsTempArray.join(',');
    	}
        
        
        var programGroupItemId = filter.down('#programGroupAdmItemId');
        var intakeYearItemId = filter.down('#saleIntakeYearAdmItemId');
        var intakeYearIdArray = intakeYearItemId.getValue();
        if(!isNullOrEmpty(intakeYearIdArray)){
        	if(typeof intakeYearIdArray[0]!="object"){
        		var intakeIds = intakeYearIdArray;
        	}
        	else {
        		var intakeYearIdTempArray = [];
        		Ext.each(intakeYearIdArray,function(currentAcademyId){
        			intakeYearIdTempArray.push(currentAcademyId.data.id);
        		});
        		var intakeIds = intakeYearIdTempArray.join(',');
        	}	
        }
        var programItemId = filter.down('#programAdmItemId');
        programItemId.reset();
        var programStore = programItemId.getStore();
        programStore.getProxy().extraParams = {
            academyLocationIds: academyIds,
            programGroupId: programGroupItemId.getValue()/*,
            intakeYearId: intakeIds*/
        };
        programStore.load();

        if (!isNullOrEmpty(academyIdsArray)) {
            programItemId.setDisabled(false);
        }
        programItemId.reset();
       
        var batchItemId = filter.down("#batchAdmItemId");
        batchItemId.setDisabled(true);
        batchItemId.reset();
        
        var seatTypeAdmItemId = filter.down("#seatTypeAdmItemId");
        seatTypeAdmItemId.setDisabled(true);
        seatTypeAdmItemId.reset();
    },
    resetFormByButtonAndRadioClickEvent:function($this,action){
    	var form = $this.getAdmissionactivityreportfilter()
		var getForm = form.getForm();
		var radioGroupSelectedvalue = form.down('#admissionActivityReportRadiogroupUnitId').getValue();
		var startDate = getForm.findField("startDate");
		var endDate = getForm.findField("endDate");
		var seatType = getForm.findField("seatType");
		if(radioGroupSelectedvalue.admissionActivityReportRadioUnit==true){
			var multiselectAcademy = getForm.findField("multiselectAcademy");
			var intakeYear = getForm.findField("intakeYear");
			form.down('#startDate').setValue(Ext.Date.add (new Date(),Ext.Date.DAY,-6))
			form.down('#endDate').setValue(new Date());
			multiselectAcademy.reset();
			multiselectAcademy.clearAllDataFn();
			var academyLocation = $this.getCurrentAcademyLocation();
			intakeYear.reset();
			seatType.reset();
			multiselectAcademy.getStore().load({
					   callback: function(records, operation, success) {
						   for(var i in records){
							   if(records[i].data.id==academyLocation){
								 multiselectAcademy.setValue(records[i].data.id);
							   }
						   }
					   }
				   });
		}else{
			var multiselectAcademyAdm = getForm.findField("multiselectAcademyWiseAdm");
			var viewTargetBy = form.down('#viewTargetByAdm');
			viewTargetBy.getStore().load({
				callback: function(records, operation, success) {
					for(var i in records){
						if(records[i].data.id=='ACADEMY_WISE'){
							viewTargetBy.setValue(records[i].data.id);
						}
					}
				}	   
			});
			multiselectAcademyAdm.getStore().load({
				callback: function(record){
					multiselectAcademyAdm.select(multiselectAcademyAdm.getStore().collect(multiselectAcademyAdm.valueField));
				}
			});
			startDate.setMaxValue(false);
			startDate.setMinValue(false);
			endDate.setMaxValue(false);
			endDate.setMinValue(false);
			startDate.reset();
			endDate.reset();
			seatType.reset();
			seatType.setVisible(true);
			form.down('#seatTypeAdmItemId').setVisible(false);	
			form.down('#saleIntakeYearAdmItemId').reset();
			if(action.itemId =='resetBtn'){
				form.down('#multiselectAcademyId').reset();
				form.down('#programGroupAdmItemId').reset();
				form.down('#programGroupWiseAdmId').reset();
				form.down('#programAdmItemId').reset();
				form.down('#batchAdmItemId').reset();
				form.down('#seatTypeAdmItemId').reset();	
			}
			
		}
    },
    loadAdmissionEnrolmentSummaryReportGrid: function(viewTargetByAdm,activeTabTitle) {
    	var $this = this;
    	var filter = $this.getAdmissionactivityreportfilter();
    	var intakeYearIdField = filter.down('#saleIntakeYearAdmItemId');
    	var intakeYearIdsArray = intakeYearIdField.getValue();
    	if(typeof intakeYearIdsArray[0]!="object"){
    		var intakeYearIds = intakeYearIdsArray;
    	}else{
    		var intakeYearIdsTempArray = [];
    		Ext.each(intakeYearIdsArray,function(currentIntakeYearId){
    			intakeYearIdsTempArray.push(currentIntakeYearId.data.id);
    		});
    		var intakeYearIds = intakeYearIdsTempArray.join(',');
    	}
    	var seatTypeField = filter.down('#seatType');
    	var seatTypeId = seatTypeField.getValue();
    	if (!isNullOrEmpty(seatTypeId) && !isNullOrEmpty(seatTypeId[0])) {
		     var seatTypeIdsArray=[];
		     for(var i in seatTypeId) {
		     	if(typeof seatTypeId[i] == "object") {
		     	seatTypeIdsArray.push(seatTypeId[i].data.id);
		     	} else {
		     		seatTypeIdsArray.push(seatTypeId[i]);
		      	}
		     }
		     var seatTypeIds = seatTypeIdsArray.join();
		     }
    	
    	var startDateField = filter.down('#startDate');
    	var endDateField = filter.down('#endDate');
    	var sDateValue = Ext.Date.format(startDateField.getValue(), 'Y-m-d H:i:s');
    	var eDateValue = Ext.Date.format(endDateField.getValue(), 'Y-m-d H:i:s');
    	var grid =null;
    	
    	if(viewTargetByAdm=="ACADEMY_WISE"){
    		
    		var academyFullSummaryGrid = $this.getSaleadmissionenrolacademyfullsummaryadmgrid();
    		/*var buttonsToolBar = academyFullSummaryGrid.query('toolbar')[0];
            var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
            var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];*/
    		var academyOverviewGrid = $this.getSaleadmissionenrolacademyoverviewadmgrid();
    		var academyByDayGrid = $this.getSaleadmissionenrolacademybydayadmgrid();

    		var multiselectAcademyWiseAdmField = filter.down('#multiselectAcademyWiseAdmId');
    		var academyWiseIdsArray = multiselectAcademyWiseAdmField.getValue();
    		if(typeof academyWiseIdsArray[0]!="object"){
    			var academyWiseIds = academyWiseIdsArray.join(',');
    		}else {
    			var academyWiseIdsTempArray = [];
    			Ext.each(academyWiseIdsArray,function(currentAcademyWiseId){
    				if(!isNullOrEmpty(currentAcademyWiseId)){
    				academyWiseIdsTempArray.push(currentAcademyWiseId.data.id);
    				}
    			});
    			var academyWiseIds = academyWiseIdsTempArray.join(',');
    		}
    		$this.academyGridByReportSummary(academyFullSummaryGrid,academyWiseIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,seatTypeIds);
        	$this.academyGridByReportSummary(academyOverviewGrid,academyWiseIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,seatTypeIds);
        	$this.academyGridByReportSummary(academyByDayGrid,academyWiseIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,seatTypeIds);
        	academyFullSummaryGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
        	academyOverviewGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
        	academyByDayGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
    	}else if(viewTargetByAdm=="ACADEMY_LOCATION_WISE"){
    		
    		var alFullSummaryGrid = $this.getSaleadmissionenrolalfullsummaryadmgrid();
    		var alOverviewGrid = $this.getSaleadmissionenrolaloverviewadmgrid();
    		var alByDayGrid = $this.getSaleadmissionenrolalbydayadmgrid();
    		
        	var multiselectAcademyIdAdmField = filter.down('#multiselectAcademyId');
        	var academyIdsArray = multiselectAcademyIdAdmField.getValue();
        	if(typeof academyIdsArray[0]!="object"){
        		var academyIds = academyIdsArray;
        	}else {
        		var academyIdsTempArray = [];
        		Ext.each(academyIdsArray,function(currentAcademyId){
        			if(!isNullOrEmpty(currentAcademyId)){
        			academyIdsTempArray.push(currentAcademyId.data.id);
        			}
        		});
        		var academyIds = academyIdsTempArray.join(',');
        	}
        	$this.academyLiocationGridByReportSummary(alFullSummaryGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,seatTypeIds);
        	$this.academyLiocationGridByReportSummary(alOverviewGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,seatTypeIds);
        	$this.academyLiocationGridByReportSummary(alByDayGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,seatTypeIds);
        	alFullSummaryGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
        	alOverviewGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
        	alByDayGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
     	}else if(viewTargetByAdm=="PROGRAM_GROUP_WISE"){
    		var alFullSummaryGrid = $this.getSaleadmissionenrolpgfullsummaryadmgrid();
    		var alOverviewGrid = $this.getSaleadmissionenrolpgoverviewadmgrid();
    		var alByDayGrid = $this.getSaleadmissionenrolpgbydayadmgrid();
    		
        	var multiselectAcademyIdAdmField = filter.down('#multiselectAcademyId');
        	var academyIdsArray = multiselectAcademyIdAdmField.getValue();
        	if(typeof academyIdsArray[0]!="object"){
        		var academyIds = academyIdsArray;
        	}else {
        		var academyIdsTempArray = [];
        		Ext.each(academyIdsArray,function(currentAcademyId){
        			if(!isNullOrEmpty(currentAcademyId)){
        			academyIdsTempArray.push(currentAcademyId.data.id);
        			}
        		});
        		var academyIds = academyIdsTempArray.join(',');
        	}
        	
        	var programGroupWiseAdmIdAdmField = filter.down('#programGroupWiseAdmId');
        	var programGroupIdsArray = programGroupWiseAdmIdAdmField.getValue();
        	if(typeof programGroupIdsArray[0]!="object"){
        		var  programGroupIds = programGroupIdsArray.join(',');
        	}else {
        		var  programGroupIdsTempArray = [];
        		Ext.each(programGroupIdsArray,function(currentProgramGroupId){
        			if(!isNullOrEmpty(currentProgramGroupId)){
        			programGroupIdsTempArray.push(currentProgramGroupId.data.id);
        			}
        		});
        		var programGroupIds = programGroupIdsTempArray.join(',');
        	}
        	
        	$this.academyLiocationGridByProgramGroupSummary(alFullSummaryGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,programGroupIds,seatTypeIds);
        	$this.academyLiocationGridByProgramGroupSummary(alOverviewGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,programGroupIds,seatTypeIds);
        	$this.academyLiocationGridByProgramGroupSummary(alByDayGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,programGroupIds,seatTypeIds);
        	alFullSummaryGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
        	alOverviewGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
        	alByDayGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
     	}else if(viewTargetByAdm=="PROGRAM_WISE"){
    		var alFullSummaryGrid = $this.getSaleadmissionenrolprogramfullsummaryadmgrid();
    		var alOverviewGrid = $this.getSaleadmissionenrolprogramoverviewadmgrid();
    		var alByDayGrid = $this.getSaleadmissionenrolprogrambydayadmgrid();
    		
        	var multiselectAcademyIdAdmField = filter.down('#multiselectAcademyId');
        	var academyIdsArray = multiselectAcademyIdAdmField.getValue();
        	if(typeof academyIdsArray[0]!="object"){
        		var academyIds = academyIdsArray;
        	}else {
        		var academyIdsTempArray = [];
        		Ext.each(academyIdsArray,function(currentAcademyId){
        			if(!isNullOrEmpty(currentAcademyId)){
        			academyIdsTempArray.push(currentAcademyId.data.id);
        			}
        		});
        		var academyIds = academyIdsTempArray.join(',');
        	}
        	
        	var programGroupAdmIdAdmField = filter.down('#programGroupAdmItemId');
        	var programGroupIdsArray = programGroupAdmIdAdmField.getValue();
        	if(!isNullOrEmpty(programGroupIdsArray)){
        		if(typeof programGroupIdsArray[0]!="object"){
            		var  programGroupIds = programGroupIdsArray;
            	}else {
            		var  programGroupIdsTempArray = [];
            		Ext.each(programGroupIdsArray,function(currentProgramGroupId){
            			if(!isNullOrEmpty(currentProgramGroupId)){
            			programGroupIdsTempArray.push(currentProgramGroupId.data.id);
            			}
            		});
            		var programGroupIds = programGroupIdsTempArray.join(',');
            	}
        	}
        	var programAdmItemIdField = filter.down('#programAdmItemId');
        	var programAdmItemValue = programAdmItemIdField.getValue();
        	var batchAdmItemIdField = filter.down('#batchAdmItemId');
        	var batchAdmItemValue = batchAdmItemIdField.getValue();
        	
        	
        	var seatTypeAdmItemIdField = filter.down('#seatTypeAdmItemId');
        	var seatTypeId = seatTypeAdmItemIdField.getValue();
        	if (!isNullOrEmpty(seatTypeId) && !isNullOrEmpty(seatTypeId[0])) {
    		     var seatTypeIdsArray=[];
    		     for(var i in seatTypeId) {
    		     	if(typeof seatTypeId[i] == "object") {
    		     	seatTypeIdsArray.push(seatTypeId[i].data.id);
    		     	} else {
    		     		seatTypeIdsArray.push(seatTypeId[i]);
    		      	}
    		     }
    		     var seatTypeIds = seatTypeIdsArray.join();
    		     }
        	
        	$this.academyLiocationGridByProgramSummary(alFullSummaryGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,programGroupIds,programAdmItemValue,batchAdmItemValue,seatTypeIds);
        	$this.academyLiocationGridByProgramSummary(alOverviewGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,programGroupIds,programAdmItemValue,batchAdmItemValue,seatTypeIds);
        	$this.academyLiocationGridByProgramSummary(alByDayGrid,academyIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,programGroupIds,programAdmItemValue,batchAdmItemValue,seatTypeIds);
        	alFullSummaryGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
        	alOverviewGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
        	alByDayGrid.config.searchFilterForm = $this.getAdmissionactivityreportfilter();
     	}
    },
    academyGridByReportSummary:function(grid,academyWiseIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,seatTypeIds){
    	var buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
		if(sDateValue != null){
		                startDate= new Date(sDateValue);
		                startDate = Ext.Date.format(startDate, 'Y-m-d');
		                  }
		            
		            if(eDateValue != null){
		                endDate= new Date(eDateValue);
		                endDate = Ext.Date.format(endDate, 'Y-m-d');
		                  }

    	grid.getStore().getProxy().extraParams = {
			academyIds: academyWiseIds,
			intakeYearIds: intakeYearIds,
			viewTargetByAdm:viewTargetByAdm,
			fromDate:startDate,
			endDate:endDate,
			seatTypeIds:seatTypeIds
		};
    	grid.getStore().load({
	    	  callback: function(records, operation, success) {
	 				if(records.length>0){
	 				    	pdftoolbar.setDisabled(false);
						    	exceltoolbar.setDisabled(false);
	 					}
						  }
	 				});
    },
    academyLiocationGridByReportSummary:function(grid,academyWiseIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,seatTypeIds){
    	var buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	grid.getStore().getProxy().extraParams = {
			academyLocationIds: academyWiseIds,
			intakeYearIds: intakeYearIds,
			viewTargetByAdm:viewTargetByAdm,
			fromDate:sDateValue,
			endDate:eDateValue,
			seatTypeIds:seatTypeIds

		};
    	grid.getStore().load({
	    	  callback: function(records, operation, success) {
	 				if(records.length>0){
	 				    	pdftoolbar.setDisabled(false);
						    	exceltoolbar.setDisabled(false);
	 					}
						  }
	 				});
    },
    academyLiocationGridByProgramGroupSummary:function(grid,academyWiseIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,programGroupIds,seatTypeIds){
    	var buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	grid.getStore().getProxy().extraParams = {
			academyLocationIds: academyWiseIds,
			intakeYearIds: intakeYearIds,
			viewTargetByAdm:viewTargetByAdm,
			fromDate:sDateValue,
			endDate:eDateValue,
			programGroupIds:programGroupIds,
			seatTypeIds:seatTypeIds

		};
    	grid.getStore().load({
	    	  callback: function(records, operation, success) {
	 				if(records.length>0){
	 				    	pdftoolbar.setDisabled(false);
						    	exceltoolbar.setDisabled(false);
	 					}
						  }
	 				});
    },
    academyLiocationGridByProgramSummary:function(grid,academyWiseIds,intakeYearIds,viewTargetByAdm,sDateValue,eDateValue,programGroupIds,programAdmItemValue,batchAdmItemValue,seatTypeIds){
    	var buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	grid.getStore().getProxy().extraParams = {
			academyLocationIds: academyWiseIds,
			intakeYearIds: intakeYearIds,
			viewTargetByAdm:viewTargetByAdm,
			fromDate:sDateValue,
			endDate:eDateValue,
			programGroupIds:programGroupIds,
			programId:programAdmItemValue,
			batchId:batchAdmItemValue,
			seatTypeIds:seatTypeIds

		};
    	grid.getStore().load({
	    	  callback: function(records, operation, success) {
	 				if(records.length>0){
	 				    	pdftoolbar.setDisabled(false);
						    	exceltoolbar.setDisabled(false);
	 					}
						  }
	 				});
    },
    resetViewByGridsAndHideExpAll:function(grid){
    	grid.getStore().removeAll();	
    	var buttonsToolBar = grid.query('toolbar')[0];
    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];

    	var pdfAllBtn = pdftoolbar.menu.down('#exportPDFAll');
    	var excelAllBtn = exceltoolbar.menu.down('#exportExcelAll');
    	pdfAllBtn.setVisible(false);
    	excelAllBtn.setVisible(false);
    },
    getAcademyLocationFilterIds: function(){
    	var getForm = this.getAdmissionDemographicsSearchForm().getForm();
    	var academyLocation;
    	var values = getForm.getValues();
    	var mAL = values.multiselectAcademyLocation;
    	var mALArray=[];
    	if(mAL !=undefined && mAL.length > 0 && mAL!=""){
    		for(var i in mAL){
    			if(Ext.isObject(mAL[0])){
    				mALArray.push(mAL[i].get("id"));
    			}else{
    				mALArray.push(mAL[i]);
    			}
    		}
    		academyLocation= mALArray.join();
    	}else{
    		academyLocation = this.getCurrentAcademyLocation();
    	}
    	return academyLocation;
    },
    organizationDemographicsUnitChange:function(obj,record,permission){
    	this.setAllDemoAlIds(obj,permission);
    },
    setAllDemoAlIds:function(field,permission){
    	this.setAllowBlank (field,false); 
    	var $this = this;
		   field.store.load({
  		   callback : function(records, operation, success) {
  			  if (success) {
  				  var academyLocationArray= [];
  				  
  				 var map;
  				 if(permission != undefined && permission != null){
  					 map = permission.map;

  					 var keys = [];
  					 for(var k in map) keys.push(k);
  					
  					 var academyLocationPrivilegeList = Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges();
  					 for(var i in academyLocationPrivilegeList){
  						 academyLocationArray.push(academyLocationPrivilegeList[i].accessibleAcademyLocation.academyLocationId);
  					 }
  				 }
  				 try{
  					 if(this$.getActiveTabfromContentPanel().xtype!="dashboardmainstructure"){
  						field.setValue(academyLocationArray);
  						field.defaultValueBeforeReset = academyLocationArray;
  					 }
  					 if(this$.getActiveTabfromContentPanel().xtype=="examinationreports"){
  						field.setValue($this.getCurrentAcademyLocation());
  					 }
  				 }
  				 catch(e){
  					field.setValue(academyLocationArray);
  				 }
  			  }
  			  
  		  }
  	  });  	
    },
});