/**
 * This controller is used for student faculty dashboard controller
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.reports.student.StudentDashboardController', {
    extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    stores: ['common.SelectNameComboStore','reports.servicerequest.StudentRequestReportTreeStore', 'reports.servicerequest.CertificateSubCategoryStore', 'reports.servicerequest.FreeFormCategoryStore', 
             'reports.servicerequest.FreeFormSubCategoryStore', 'reports.servicerequest.ServiceRequestSubCategoryStore', 'reports.servicerequest.SystemUsersByAcademyLocationIds',            
             'reports.servicerequest.ClosureReasonGraphStore', 'reports.servicerequest.CountOfRequestStore', 'reports.servicerequest.ServiceLevelGraphStore', 
             'reports.servicerequest.RequestClosureRateStore', 'common.ProgramByAcAndLoIdStore', 'program.programbatchdetail.BatchStore', 
             'organization.academylocations.AcademyStore', 'organization.academylocations.LocationStore', 'common.ProgramsByAcademyLocationsIds',
             'reports.servicerequest.UnassignedRequestStore', 'reports.servicerequest.FollowupRequestStore',
             
             'reports.student.TypeOfExits','reports.student.ReasonForExits','reports.student.ByAcademies','reports.student.ByLocations',
             'reports.student.ByBatches','reports.student.BySections','common.LiveSearchCombos',
             'common.ProgramsByAcademyIdLocationId','common.BatchesByProgramId','coursetransaction.sectionmanagement.SectionMultiSelect',
            'reports.student.ExitAcademyStore','reports.student.ExitLocationStore','reports.student.ByTypeOfExits','reports.student.ByPrograms',
            'servicerequest.studentservicerequest.StudentRequestStore', 'reports.servicerequest.ServiceDetailReportStore'],

    views: ['reports.common.DashboardReportTabStructure', 'reports.student.RequestClosureRateSearchForm', 'reports.common.ColumnChartReport',
            'reports.common.BarChartReport', 'reports.common.GroupedBarChart', 'reports.common.PieChartReport',
            'reports.student.StudentRequestClosureRateView', 'reports.student.StudentClosureReasonView', 'reports.student.StudentCountOfRequestView', 
            'reports.student.StudentServiceLevelView', 'reports.student.ServiceLevelSearch',
            'reports.student.StudentDashboardView', 'Academia.view.criteriabuilder.grid.SearchResultGrid',
            'reports.student.FollowUpScheduledReportQuickSearchView', 'reports.student.FollowUpScheduledReportQuickSearchForm', 'reports.servicerequest.FollowupRequestReportGrid',
            'reports.student.UnassignedRequestReportQuickSearchForm', 'reports.student.UnassignedRequestReportQuickSearchView','reports.servicerequest.UnassignedRequestReportGrid',
            'reports.student.RequestSubRequestTypeFieldContainer', 'reports.servicerequest.RequestAssignedWindow',
            'reports.student.personaldetail.StudentExitView','reports.student.personaldetail.StudentExitSearchForm', 'reports.student.StudentSavedAdvanceSearchCriteriaReport', 'reports.student.serviceDetailReportformQuickSearchform', 'reports.servicerequest.serviceDetailReportResultGrid',
            'reports.student.serviceDetailReportview','reports.student.serviceDetailReportRequestCategoryFieldContainer'
            ],


    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'studentDashboardView',
        selector: 'studentdashboardview'
    }, {
    	ref: 'studentDashboardReportTabStructure',
    	selector: 'dashboardreporttabstructure[itemId=studentDashboardReportTabStructure]'
    }, {
        ref: 'organizationunit',
        selector: 'organizationunit'
    }, {
        ref: 'studentRequestClosureRateSearch',
        selector: 'requestclosureratesearchform[itemId=studentRequestClosureRateSearch]'
    }, {
        ref: 'studentRequestClosureRateChart',
        selector: 'columnchartreport[itemId=studentRequestClosureRateChart]'
    }, {
        ref: 'studentCountOfRequestSearch',
        selector: 'requestclosureratesearchform[itemId=studentCountOfRequestSearch]'
    }, {
        ref: 'studentCountOfRequestChart',
        selector: 'columnchartreport[itemId=studentCountOfRequestChart]'
    }, {
        ref: 'studentServiceLevelSearch',
        selector: 'servicelevelsearch[itemId=studentServiceLevelSearch]'
    }, {
        ref: 'studentServiceLevelChart',
        selector: 'groupedbarchart[itemId=studentServiceLevelChart]'
    }, {
        ref: 'studentClosureReasonSearch',
        selector: 'requestclosureratesearchform[itemId=studentClosureReasonSearch]'
    }, {
        ref: 'studentClosureReasonChart',
        selector: 'barchartreport[itemId=studentClosureReasonChart]'
    }, {
        ref: 'followUpScheduledReportQuickSearch',
        selector: 'followupscheduledreportquicksearchform'
    }, {
        ref: 'followUpScheduledReportResultGrid',
        selector: 'followuprequestreportgrid[itemId=followUpScheduledReportResultGrid]'
    }, {
        ref: 'unassignedRequestReportQuickSearch',
        selector: 'unassignedrequestreportquicksearchform'
    }, {
        ref: 'unassignedRequestReportResultGrid',
        selector: 'unassignedrequestreportgrid[itemId=unassignedRequestReportResultGrid]'
    },{
 	   ref: 'studentDashboardOrganizationUnit',
 	   selector: 'organizationunit[itemId=studentDashboardOrganizationUnit]'
    }, {
    	ref: 'requestAssignedWindow',
    	selector: 'requestassignedwindow'
    }, {
    	ref: 'assignRequestForm',
    	selector: 'requestassignedwindow form[itemId=assignRequestForm]'
    }, {
    	ref: 'studentExitSearchForm',
    	selector: 'studentexitsearchform[itemId=studentExitSearchFormId]'
    },{
    	ref: 'studentExitView',
    	selector : 'studentexitview'
    },{
    	ref: 'studentsavedadvancesearchcriteriareport',
    	selector : 'studentsavedadvancesearchcriteriareport'
    },{
    	ref: 'savedadvancesearchtab',
    	selector : 'savedadvancesearchtab'
    	
    },{
    	ref: 'serviceDetailReportformQuickSearch',
    	selector : 'serviceDetailReportformQuickSearchform'
    	
    },{
    	ref: 'serviceDetailReportResultGrid',
    	selector: 'serviceDetailReportResultGrid[itemId=serviceDetailReportResultGrid]'
    }],
    config: {
    	STUDENT_UNASSIGNEDREQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_UNASSIGNEDREQUEST_PRIVILEGES'),
    	STUDENT_FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FOLLOWUPSCHEDULED_PRIVILEGES'),
    	STUDENTDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENTDASHBOARD_PRIVILEGES')

    },
    init: function(application) {
        this.control({
        	
        	'organizationunit[itemId=studentDashboardOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getSTUDENTDASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=studentDashboardOrganizationUnit] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    			}
    		},
        	'studentdashboardview panel[itemId=studentReportView] treepanel[itemId=studentReportTreePanelItemId]': {
        		itemclick : function( treePanel, record, item, index, e, eOpts ) {
					var $this = this;
					var studentDashboardView = $this.getStudentDashboardView();
					var treeTab = studentDashboardView.down('#studentReportTreePanelItemId');
					var tabDetail = record.data;
					if(!isNullOrEmpty(tabDetail.text) && !isNullOrEmpty(tabDetail.reportXtype) && !isNullOrEmpty(tabDetail.reportXtypeItemId)){
						treeTab.toggleCollapse();
						var studentDashboardReportTabStructure = $this.getStudentDashboardReportTabStructure();
						studentDashboardReportTabStructure.removeAll();
						
						if (studentDashboardReportTabStructure) {
							studentDashboardReportTabStructure.add({
										xtype : tabDetail.reportXtype,
										itemId: tabDetail.reportXtypeItemId,
										title: tabDetail.text,
										frame: true
							});
							studentDashboardReportTabStructure.show();
							studentDashboardReportTabStructure.setActiveTab(0);
						} 
						treePanel.getSelectionModel().deselectAll();
					}
					
				}
       	     },
        	/**
        	 * Academy, Location, Program, Batch, Section combo event handling
        	 */
        	'fieldcontainer[itemId=progrmBatchSectionContainer] combo[itemId=academyComboField]': {
        		select: function(combo, records, eOpts) {
                    var locationComboField = combo.up('form').down('#locationComboField');
                    this.loadDependentCombo(locationComboField, records, 'academyId');
                }
        	},
        	'fieldcontainer[itemId=progrmBatchSectionContainer] combo[itemId=locationComboField]': {
        		select: function(combo, records, eOpts) {
                    var academyId = combo.up('form').down('#academyComboField').getValue();
                    var programComboField = combo.up('form').down('#programComboField');
                    this.loadDependentCombo(programComboField, records, 'locationId', 'academyLocationIds', academyId);
                }
        	},
        	'fieldcontainer[itemId=progrmBatchSectionContainer] combo[itemId=programComboField]': {
        		focus : function(programComboField, records, eOpts) {
        			this.loadProgramComboByApplyingMAUFilter(programComboField, records, eOpts);
        		},
        		select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchComboField');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( batchComboField, comboValue, 'id');
                }
        	},
        	'fieldcontainer[itemId=progrmBatchSectionContainer] combo[itemId=batchComboField]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#sectionComboField');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(sectionComboField, comboValue, 'batchIds');
                }
        	},
        	/**
        	 * Assign To combo load
        	 */
        	
        	'nestedJsonCombo[itemId=assigneeCombo]':{
        		render: function(combo){
        			var store = combo.getStore();
        			me = this;
        			store.on('beforeload',function(){
        				var academyLocationId = null;
            			//var academyLocationIds = this.getAcademyLocationIds();
        				var academyLocationIds = Academia.app.getController('reports.student.StudentDashboardController').getAcademyLocationIds();
            	    	if(!isNullOrEmpty(academyLocationIds)){
            	    		academyLocationIds = academyLocationIds.toString();
            	    		var commaIndex = academyLocationIds.indexOf(",");
            	    		if(commaIndex != -1){
            	    			var academyLocationArray = academyLocationIds.split(",");
            	    			academyLocationId = academyLocationArray;
            	    		}else{
            	    			academyLocationId = [academyLocationIds];
            	    		}
            	        	
            	    	}
            	    	store.getProxy().extraParams = {
            	    		academyLocationId:academyLocationId
            	        };    
        		    },this);
        			
        			
        			
        		}
        	},
        	/**
        	 * request and request sub type combo event handling
        	 */
        	
        	'fieldcontainer[itemId=requestTypeFieldContainer] combo[itemId=requestTypeField]':{
            	select:function(combo,records,value) {
            		this.onRequestTypeSelectionDropdown(combo);
                }
            },
            'fieldcontainer[itemId=requestTypeFieldContainer] combo[itemId=certificateCategoryField]':{
            	select :function(combo,records, value) {
            		this.onCategorySelectionDropdown(combo);
                }
            },
            'fieldcontainer[itemId=requestTypeFieldContainer] combo[itemId=freeFormCategoryField]':{
            	select :function(combo,records, value) {
            		this.onCategorySelectionDropdown(combo);
                }
            },
            
            
            /**
             * On search button click event handling for all dashboard tab
             */
            
        	'requestclosureratesearchform[itemId=studentRequestClosureRateSearch] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadServiceRequestClosureRateChart();
        		}
        	},
        	'requestclosureratesearchform[itemId=studentCountOfRequestSearch]': {
        		beforerender: function(form){
        			form.down('#assigneeCombo').setVisible(true);
        		}
        	},
        	'requestclosureratesearchform[itemId=studentCountOfRequestSearch] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadCountOfRequestChart();
        		}
        	},
        	'requestclosureratesearchform[itemId=studentCountOfRequestSearch] fieldcontainer[itemId=executionDateFieldContainer]': {
        		beforerender: function(container){
        			container.down('#startDate').setFieldLabel(getServiceRequestTranslation('RAISED_START_DATE'));
        			container.down('#endDate').setFieldLabel(getServiceRequestTranslation('RAISED_UP_END_DATE'));
        		}
        	},
        	'servicelevelsearch[itemId=studentServiceLevelSearch] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadServiceLevelChart();
        		}
        	},
        	'requestclosureratesearchform[itemId=studentClosureReasonSearch] button[itemId=searchButtonId]': {
        		click: function(){
        			this.loadClosureReasonChart();
        		}
        	},
        	/**
             * On reset button click event handling for all dashboard tab
             */
        	'requestclosureratesearchform[itemId=studentRequestClosureRateSearch] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getStudentRequestClosureRateSearch();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
        	'requestclosureratesearchform[itemId=studentCountOfRequestSearch] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getStudentCountOfRequestSearch();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
        	'servicelevelsearch[itemId=studentServiceLevelSearch] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getStudentServiceLevelSearch();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
        	'requestclosureratesearchform[itemId=studentClosureReasonSearch] button[itemId=resetButtonId]': {
        		click: function(){
        			var form = this.getStudentClosureReasonSearch();
        			this.resetDashboardSearchCriteriaForm(form);
        		}
        	},
            'followupscheduledreportquicksearchform[itemId=followUpScheduledReportQuicksearchform] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadFollowUpScheduleGridResults();
                }
            },
            'followuprequestreportgrid[itemId=followUpScheduledReportResultGrid]': {
        		cellclick: function(grid, td, cellIndex, record){
               	 	var searchResultGrid = this.getFollowUpScheduledReportResultGrid();
               	 	this.cellclickTrackRequestGrid(searchResultGrid,cellIndex,record);            		
               	 }
        	},
            'followupscheduledreportquicksearchform[itemId=followUpScheduledReportQuicksearchform] button[itemId=resetButtonId]': {
            	click: function(){
            		var form = this.getFollowUpScheduledReportQuickSearch();
        			this.resetDashboardSearchCriteriaForm(form);
                }
            },
            'followupscheduledreportquicksearchform[itemId=followUpScheduledReportQuicksearchform] combo[itemId=selectedNameField]': {
            	change: function(combo, records, value){
                	this.changeNameFieldConfig(combo);
                }
            },
            
            'unassignedrequestreportquicksearchform[itemId=unassignedRequestReportQuickSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadUnAssignedRequestGridResults();
                }
            },
            'unassignedrequestreportquicksearchform[itemId=unassignedRequestReportQuickSearchForm]': {
                render: function(){
                	var form =this.getUnassignedRequestReportQuickSearch();
                	form.down("#assigneeCombo").setVisible(false)
                }
            },
            'unassignedrequestreportgrid[itemId=unassignedRequestReportResultGrid]': {
        		cellclick: function(grid, td, cellIndex, record){
               	 	var searchResultGrid = this.getUnassignedRequestReportResultGrid();
               	 	this.cellclickTrackRequestGrid(searchResultGrid,cellIndex,record);            		
               	 }
        	},
            'unassignedrequestreportquicksearchform[itemId=unassignedRequestReportQuickSearchForm] button[itemId=resetButtonId]': {
            	click: function(){
            		var form = this.getUnassignedRequestReportQuickSearch();
        			this.resetDashboardSearchCriteriaForm(form);
                }
            },
            'unassignedrequestreportquicksearchform[itemId=unassignedRequestReportQuickSearchForm] combo[itemId=selectedNameField]': {
            	change: function(combo, records, value){
                	this.changeNameFieldConfig(combo);
                }
            },
            'requestassignedwindow[itemId=studentAssignToWindow] form[itemId=assignRequestForm] button[itemId=cancelButtonId]': {
            	click: function(){
            		this.getRequestAssignedWindow().close();
            	}
            },
            'requestassignedwindow[itemId=studentAssignToWindow] form[itemId=assignRequestForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.submitAssignRequest();
            	}
            },
            'requestassignedwindow[itemId=studentAssignToWindow] form[itemId=assignRequestForm] combo[itemId=requestAssigneeCombo]': {
            	afterrender: function(combo){
            		this.loadAssigneeCombo(combo);
            	}
            },
            'serviceDetailReportformQuickSearchform[itemId=serviceDetailReportformQuickSearchform] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadServiceDetailReportGridResults();
                }
            },
            'serviceDetailReportResultGrid[itemId=serviceDetailReportResultGrid]': {
        		cellclick: function(grid, td, cellIndex, record){
               	 	var searchResultGrid = this.getServiceDetailReportResultGrid();
               	 	this.cellclickTrackRequestGrid(searchResultGrid,cellIndex,record);            		
               	 }
        	},
            'serviceDetailReportformQuickSearchform[itemId=serviceDetailReportformQuickSearchform] button[itemId=resetButtonId]': {
            	click: function(){
            		var form = this.getServiceDetailReportformQuickSearch();
        			this.resetDashboardSearchCriteriaForm(form);
                }
            },
            'serviceDetailReportformQuickSearchform[itemId=serviceDetailReportformQuickSearchform] combo[itemId=selectedNameField]': {
            	change: function(combo, records, value){
                	this.changeNameFieldConfig(combo);
                }
            },
            /*'searchresultgrid[itemId=unassignedRequestReportResultGrid]':{
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'searchresultgrid[itemId=followUpScheduledReportResultGrid]': {
            	render: function(grid) {
 					this.gridRenderFunction(grid);
 				}
            },
            'searchresultgrid[itemId=unassignedRequestReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'UNASSIGNEDREQUEST');
		            }
	        },
	        'searchresultgrid[itemId=unassignedRequestReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'UNASSIGNEDREQUEST');
	            }
	        },
	        'searchresultgrid[itemId=unassignedRequestReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'UNASSIGNEDREQUEST');
	            }
	        },
	        'searchresultgrid[itemId=unassignedRequestReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'UNASSIGNEDREQUEST');
	            }
	        },
	        'searchresultgrid[itemId=followUpScheduledReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
		            click: function() {
		                this.exportReport(SERVERURL.PDFEXPORT,'pdf',false,'FOLLOWUPSCHEDULED');
		            }
	        },
	        'searchresultgrid[itemId=followUpScheduledReportResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.PDFEXPORT,'pdf',true,'FOLLOWUPSCHEDULED');
	            }
	        },
	        'searchresultgrid[itemId=followUpScheduledReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'FOLLOWUPSCHEDULED');
	            }
	        },
	        'searchresultgrid[itemId=followUpScheduledReportResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
	            click: function() {
	                this.exportReport(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'FOLLOWUPSCHEDULED');
	            }
	        }*/
            
            /*student exit tab*/
            
            'studentexitsearchform[itemId=studentExitSearchFormId] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadStudentExitCharts();
                }
            },
            
            'studentexitsearchform combo[itemId=programComboField]': {
        		focus : function(programComboField, records, eOpts) {
        			this.loadProgramComboByApplyingMAUFilter(programComboField, records, eOpts);
        		},
        		change: function(combo, newValue, oldValue,eOpts) {
                    var batchComboField = combo.up('form').down('#batchComboField');
                    var sectionComboField = combo.up('form').down('#sectionComboField');
                    var cmblength = combo.getValue().length;
                    if(cmblength >1 || cmblength === 0){
                    	batchComboField.setDisabled(true);
                    	sectionComboField.setDisabled(true);
                    }else if(cmblength === 1){
                    	batchComboField.setDisabled(false);
                    }
					var comboValue = new Array();
					for (var i = 0;i< cmblength;i++){
						comboValue.push(combo.getValue()[i]);
					}
                    this.loadDependentCombo( batchComboField, comboValue, 'programIds');
                }
        	},
        	
        	'studentexitsearchform combo[itemId=batchComboField]': {
        		change: function(combo, newValue, oldValue,eOpts) {
                    var sectionComboField = combo.up('form').down('#sectionComboField');
                    var cmblength = combo.getValue().length;
                    
                    if(cmblength >1 || cmblength === 0){
                    	sectionComboField.setDisabled(true);
                    }else if(cmblength === 1){
                    	sectionComboField.setDisabled(false);
                    }
					var comboValue = new Array();
					for (var i = 0;i< cmblength;i++){
						comboValue.push(combo.getValue()[i]);
					}
                    this.loadDependentCombo(sectionComboField, comboValue, 'batchIds');
                }
        	},
        	
        	'studentexitsearchform combo[itemId=academyCombo]': {
	        	focus : function(academyComboField, records, eOpts) {
	    			this.loadAcademyLocationComboByApplyingMAUFilter(academyComboField, records, eOpts);
	    		}
            },
            
            'studentexitsearchform combo[itemId=locationCombo]': {
	            focus : function(locationComboField, records, eOpts) {
	    			this.loadAcademyLocationComboByApplyingMAUFilter(locationComboField, records, eOpts);
	    		}
            },
            
            'studentexitsearchform combo[itemId=typeOfExitId]': {
                select : this.loadReasonForCombo
            },
            
            'studentexitsearchform button[itemId=resetButtonId]': {
                click : this.resetChart
            },
            'studentexitsearchform combo[itemId=reasonForExitId]': {
                select : function(combo){
                	combo.up('form').down('#searchButtonId').setDisabled(false);
                }
            },
            'studentsavedadvancesearchcriteriareport':{
            	afterrender:function(structure){
            		var $this = this;
            		structure.body.on('scroll', function(e, target) {
            			var Savedadvancesearchtab = structure.down('savedadvancesearchtab');
            			var getActiveTab = Savedadvancesearchtab.getActiveTab();
            			if(!isNullOrEmpty(getActiveTab))
            			{
            				var grid = getActiveTab.down('searchresultgrid');
            				$this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,false);

            			}
            			
            		});
            	}
            },
            'studentdashboardview':{
            	afterrender:function(structure)
            	{
            		var $this=this;
            		structure.body.on('scroll',function(e,target){
            			var dashboardtab=structure.down('dashboardreporttabstructure');
            			//var getActiveTab=dashboardtab.getActiveTab();
            				var grid = structure.down('followuprequestreportgrid');
            				$this.getMultipleGridHeaderFreeze(grid,structure,true);
            		});
            	}
            },
            'studentdashboardview':{
            	afterrender:function(structure)
            	{
            		var $this=this;
            		structure.body.on('scroll',function(e,target){
            			var dashboardtab=structure.down('dashboardreporttabstructure');
            			//var getActiveTab=dashboardtab.getActiveTab();
            				var grid = structure.down('serviceDetailReportResultGrid');
            				$this.getMultipleGridHeaderFreeze(grid,structure,true);
            		});
            	}
            }
            
        });

    },
    
    /***
	  * This function is to export pdf and xcel
	  *//*
	    
    exportReport : function(exportUrl,filetype,whetherAll,requestType) {
	    	var quickSearchForm=null;	
	    	var searchResultGrid= null;
	    	var pagingtoolbaroptions = null;
	    	var reportTitle = null;
	    	if(requestType == 'UNASSIGNEDREQUEST'){
	    	 quickSearchForm=this.getUnassignedRequestReportQuickSearch();
	    	 searchResultGrid = this.getUnassignedRequestReportResultGrid();
	    	 pagingtoolbaroptions = this.getUnassignedRequestReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 reportTitle=getCommonTranslation("STUDENT_UNASSIGNEDREQUEST");
	    	}
	    	if(requestType == 'FOLLOWUPSCHEDULED'){
	    	 quickSearchForm=this.getFollowUpScheduledReportQuickSearch();
	    	 searchResultGrid = this.getFollowUpScheduledReportResultGrid();	
	    	 pagingtoolbaroptions = this.getFollowUpScheduledReportResultGrid().down('pagingtoolbar').getStore().lastOptions;
	    	 reportTitle=getCommonTranslation("STUDENT_FOLLOWUPSCHEDULED");
	    	}
	    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
	    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
	    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
			if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
				jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
		},
		
		createSearchCriteriaString: function(searchForm) {
	    	var me=this;
	        var formValues = new Array();
	        formValues = searchForm.getValues();        
	        var searchCriteriaString="";
	        for (var key in formValues) {
	        	var value = formValues[key];            
	            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	                var keyValueJsonObject = me.getJsonObject( key , value);
	    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
	            }
	        }
	        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	        return searchCriteriaString;
	    },
	    
	    gridRenderFunction:function(grid){
			grid.addButtonToolbar();
	    },*/
	    
    /**
     * Reset dashboard search criteria
     * @parms form search criteria search form
     */
    resetDashboardSearchCriteriaForm: function(form) {
    	
    	form.getForm().reset();
    	var comboToBeResetArray = new Array();
    	comboToBeResetArray.push(form.down('#requestSubCategoryField'));
    	comboToBeResetArray.push(form.down('#certificateSubCategoryField'));
    	comboToBeResetArray.push(form.down('#freeFormCategoryField'));
    	comboToBeResetArray.push(form.down('#freeFormSubCategoryField'));
    	comboToBeResetArray.push(form.down('#batchComboField'));
    	comboToBeResetArray.push(form.down('#sectionComboField'));
        
        for(var i= 0; i < comboToBeResetArray.length; i++){
        	if(!isEmpty(comboToBeResetArray[i])){
        		this.clearCombo(comboToBeResetArray[i]);
        	}
        }
        form.down('#requestSubCategoryField').setVisible(true);
    	form.down('#certificateCategoryField').setVisible(false);
    	form.down('#certificateSubCategoryField').setVisible(false);
    	form.down('#freeFormCategoryField').setVisible(false);
    	form.down('#freeFormSubCategoryField').setVisible(false);
    },
    /**
     * On selection request type drop down
     * @params combo request type drop down
     */
    onRequestTypeSelectionDropdown : function(combo){
    	var $this = this;
        var form = combo.up('form');  
        var value = combo.getValue();
        var requestSubCategoryField = form.down('#requestSubCategoryField');
        var certificateCategoryField = form.down('#certificateCategoryField');
        var certificateSubCategoryField = form.down('#certificateSubCategoryField');
        var freeFormCategoryField = form.down('#freeFormCategoryField');
        var freeFormSubCategoryField = form.down('#freeFormSubCategoryField');
        
        requestSubCategoryField.clearValue();
        certificateCategoryField.clearValue();
        certificateSubCategoryField.clearValue();
        freeFormCategoryField.clearValue();
        freeFormSubCategoryField.clearValue();
        
        switch (value) {
    	
        case 'CERTIFICATE':
        	
        	certificateCategoryField.setVisible(true);
        	certificateSubCategoryField.setVisible(true);
        	requestSubCategoryField.setVisible(false);
        	freeFormCategoryField.setVisible(false);
        	freeFormSubCategoryField.setVisible(false);
        	
            break;
            
        case 'FREE_FORM':
        	
        	freeFormCategoryField.setVisible(true);
        	freeFormSubCategoryField.setVisible(true);
        	requestSubCategoryField.setVisible(false);
        	certificateCategoryField.setVisible(false);
        	certificateSubCategoryField.setVisible(false);
        	var store = freeFormCategoryField.getStore();
        	store.reload();
        	break;
        	 
        case 'OTHER':
        case 'PERSONAL_DATA_CHANGE':
        case 'EXAM_RELATED':
    	default : {
    		
    		requestSubCategoryField.setVisible(true);
        	freeFormCategoryField.setVisible(false);
        	freeFormSubCategoryField.setVisible(false);
        	certificateCategoryField.setVisible(false);
        	certificateSubCategoryField.setVisible(false);
        	var store = requestSubCategoryField.getStore();
        	 var requestCategory = null;
                    if(value=='DEBARMENT'){
	                    requestCategory=form.xtype == 'facultyfindrequestform' ? "FACULTY_REQUEST" : "DEBRAMENT_REQUEST";
                     }else if(value=='TERMINATION'){
	                    requestCategory = form.xtype == 'facultyfindrequestform' ? "FACULTY_REQUEST" : "TERMINATION_REQUEST";
                         }else{
	                  requestCategory = form.xtype == 'facultyfindrequestform' ? "FACULTY_REQUEST" : "STUDENT_REQUEST"
                  }
        	store.proxy.extraParams = {
    			serviceRequestGroup : value,
    			academyLocationId: $this.getCurrentAcademyLocation(),
                serviceRequestCategory: requestCategory
			};
        	store.reload();
        	break;	
    	}
        		
        }
    },
    /**
     * On selection category combo
     * @params combo category combo 
     */
    onCategorySelectionDropdown : function(combo){
    	var value = combo.getValue();
        var form = combo.up('form');
        var requestTypeField = form.down('#requestTypeField');
        var requestTypeValue = requestTypeField.getValue();
        var certificateSubCategoryField = form.down('#certificateSubCategoryField');
        var freeFormSubCategoryField = form.down('#freeFormSubCategoryField');
        switch (requestTypeValue) {
        case 'CERTIFICATE':
        	this.clearCombo(certificateSubCategoryField);
        	var store = certificateSubCategoryField.getStore();
        	store.proxy.extraParams = {
        			certificateCategory: value
            };
        	store.reload();
        	break;
        	
        case 'FREE_FORM':
        	this.clearCombo(freeFormSubCategoryField);
        	var store = freeFormSubCategoryField.getStore();
        	store.proxy.extraParams = {
        			categoryId: value
            };
        	store.reload();
        	break;
        	
        }
    },
    /**
     * On focus program combo load data according with MAU filter's
     * @param programComboField
     * @param records
     * @param eOpts
     */
    
    loadProgramComboByApplyingMAUFilter: function(programComboField, records, eOpts){
		var academyLocationIds = this.getAcademyLocationIds();
		var store = programComboField.getStore();
		store.getProxy().extraParams = {
			academyLocationIds: academyLocationIds
			       }; 
		store.load();
	},
    
    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.name) {
        case 'academy':
            break;
        case 'location':
            this.clearCombo(combo);
            programCombo = container.down('combo[name=programId]');
            this.clearCombo(programCombo);
            batchCombo = container.down('combo[name=batchId]');
            this.clearCombo(batchCombo);
            sectionCombo = container.down('combo[name=sectionId]');
            this.clearCombo(sectionCombo);
            break;
        case 'programId':
            this.clearCombo(combo);
            batchCombo = container.down('combo[name=batchId]');
            this.clearCombo(batchCombo);
            sectionCombo = container.down('combo[name=sectionId]');
            this.clearCombo(sectionCombo);
            break;
        case 'batchId':
            this.clearCombo(combo);
            sectionCombo = container.down('combo[name=sectionId]');
            this.clearCombo(sectionCombo);
            break;
        case 'sectionId':
            this.clearCombo(combo);
            break;
        }
    },

    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    
    /**
     * Follow up schedule search result
     */
    loadFollowUpScheduleGridResults: function() {
    	var this$= this;
    	var contentPanel = this$.getContentPanel();
    	var stdOrganizationUnit =  contentPanel.down('#studentDashboardOrganizationUnit');
    	var values = stdOrganizationUnit.getValues();
    	if(values.multiselectAcademyLocation == undefined || values.multiselectAcademyLocation[0] ==""){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    		return;
    	}

    	var searchCriteriaForm = this$.getFollowUpScheduledReportQuickSearch();
    	var resultGrid = this$.getFollowUpScheduledReportResultGrid();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(searchCriteriaForm);
    	var submitData = this.getSearchFormValue(formValues);
    	var store = resultGrid.getStore();

//  	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    	store.getProxy().extraParams = submitData;
    	resultGrid.down('custompagingtoolbar').moveFirst();

    	var taskDelay = new Ext.util.DelayedTask(function(){
//  		Ext.getBody().unmask();
    	});
    	taskDelay.delay(1000);
    	//store.load();
    	resultGrid.config.searchFilterForm = this$.getFollowUpScheduledReportQuickSearch()  && this$.getStudentDashboardView();
    },
    /**
     * Unassigned request search result
     */
    loadUnAssignedRequestGridResults: function() {
    	var this$= this;
    	var contentPanel = this$.getContentPanel();
    	var studentDashboardView = this$.getStudentDashboardView();
    	var stdOrganizationUnit =  contentPanel.down('#studentDashboardOrganizationUnit');
    	var values = stdOrganizationUnit.getValues();
    	if(values.multiselectAcademyLocation == undefined || values.multiselectAcademyLocation[0] ==""){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    		return;
    	}
    	var searchCriteriaForm = this$.getUnassignedRequestReportQuickSearch();
    	var resultGrid = this$.getUnassignedRequestReportResultGrid();
    	
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(searchCriteriaForm);
    	var submitData = this.getSearchFormValue(formValues);
    	var store = resultGrid.getStore();

    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	    
    	store.getProxy().extraParams = submitData;
    	resultGrid.down('custompagingtoolbar').moveFirst();
    	var taskDelay = new Ext.util.DelayedTask(function(){
    		Ext.getBody().unmask();
    	  });
    	taskDelay.delay(1000);
    	//store.load();
 	 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
     	
    	resultGrid.config.searchFilterForm = this$.getUnassignedRequestReportQuickSearch() && this$.getStudentDashboardView();
     	
        /***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    /**
     * load student service request closure graph store
     */
    loadServiceRequestClosureRateChart : function(){
    	var this$= this;
    	var contentPanel = this$.getContentPanel();
    	var stdOrganizationUnit =  contentPanel.down('#studentDashboardOrganizationUnit');
    	var values = stdOrganizationUnit.getValues();
    	if(values.multiselectAcademyLocation == undefined || values.multiselectAcademyLocation[0] ==""){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    		return;
    	}
    	var studentRequestClosureRateSearch = this$.getStudentRequestClosureRateSearch();
    	var studentRequestClosureRateChart = this$.getStudentRequestClosureRateChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(studentRequestClosureRateSearch);
    	var submitData = this.getSearchFormValue(formValues);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SERVICE_REQUEST_CLOSUTRE_RATE,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: submitData,
            success: function(response) {
            	Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
        		studentRequestClosureRateChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load student count of request graph store
     */
    loadCountOfRequestChart : function(){
    	var this$= this;
    	var contentPanel = this$.getContentPanel();
    	var stdOrganizationUnit =  contentPanel.down('#studentDashboardOrganizationUnit');
    	var values = stdOrganizationUnit.getValues();
    	if(values.multiselectAcademyLocation == undefined || values.multiselectAcademyLocation[0] ==""){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    		return;
    	}
    	var studentCountOfRequestSearch = this$.getStudentCountOfRequestSearch();
    	var studentCountOfRequestChart = this$.getStudentCountOfRequestChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(studentCountOfRequestSearch);
    	var submitData = this.getSearchFormValue(formValues);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SERVICE_REQUEST_COUNT_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: submitData,
            success: function(response) {
            	 Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
        		studentCountOfRequestChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load student service level Chart store
     */
    loadServiceLevelChart : function(){
    	var this$= this;
    	var contentPanel = this$.getContentPanel();
    	var stdOrganizationUnit =  contentPanel.down('#studentDashboardOrganizationUnit');
    	var values = stdOrganizationUnit.getValues();
    	if(values.multiselectAcademyLocation == undefined || values.multiselectAcademyLocation[0] ==""){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    		return;
    	}
    	var studentServiceLevelSearch = this$.getStudentServiceLevelSearch();
    	var studentServiceLevelChart = this$.getStudentServiceLevelChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(studentServiceLevelSearch);
    	var submitData = this.getSearchFormValue(formValues);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SERVICE_LEVEL_GRAPH_REPORT,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData:submitData,
            success: function(response) {
            	 Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
        		studentServiceLevelChart.getStore().loadData(data);
            }
        });
    },
    /**
     * load student closure reason graph store
     */
    loadClosureReasonChart : function(){
    	var this$= this;
    	var contentPanel = this$.getContentPanel();
    	var stdOrganizationUnit =  contentPanel.down('#studentDashboardOrganizationUnit');
    	var values = stdOrganizationUnit.getValues();
    	if(values.multiselectAcademyLocation == undefined || values.multiselectAcademyLocation[0] ==""){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    		return;
    	}
    	var studentClosureReasonSearch = this$.getStudentClosureReasonSearch();
    	var studentClosureReasonChart = this$.getStudentClosureReasonChart();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(studentClosureReasonSearch);
    	var submitData = this.getSearchFormValue(formValues);
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SERVICE_REQUEST_CLOSUTRE_REASON,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: submitData,
            success: function(response) {
            	 Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
        		studentClosureReasonChart.getStore().loadData(data);
            }
        });
    },
    
     /**
     * load service detail report 
     */
     loadServiceDetailReportGridResults: function() {
    	var this$= this;
    	var contentPanel = this$.getContentPanel();
    	var stdOrganizationUnit =  contentPanel.down('#studentDashboardOrganizationUnit');
    	var values = stdOrganizationUnit.getValues();
    	if(values.multiselectAcademyLocation == undefined || values.multiselectAcademyLocation[0] ==""){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    		return;
    	}
    	/*var alIds;
		if(values.multiselectAcademyLocation && values.multiselectAcademyLocation.length){
			if(typeof values.multiselectAcademyLocation[0] == "object"){
				alIds = Ext.Array.pluck(Ext.Array.pluck(values.multiselectAcademyLocation,'data'),'id').join();
			}
		}
*/
    	var searchCriteriaForm = this$.getServiceDetailReportformQuickSearch();
    	var resultGrid = this$.getServiceDetailReportResultGrid();
    	var formValues1 = searchCriteriaForm.getValues();
    	var formValues = this$.createSeachCriteriaDashboardJsonFormat(searchCriteriaForm);
    	var submitData = this.getSearchFormValue(formValues);
    	var requestTypeId = formValues.requestTypeId;
    	var serviceRequestCategory = formValues.serviceRequestGroup;
    	var academyLocationIds = this.getAcademyLocationIds();
    	if(formValues.certificateCategory!= undefined)
    	var certificateCategory = formValues.certificateCategory
    	else
    	certificateCategory = null;
    	if(formValues.certificateId!= undefined)
    	var certificateId = formValues.certificateId
    	else
    	certificateId = null;
    	
    	
		
    	if(!isNullOrEmpty(academyLocationIds)){
    		academyLocationIds = academyLocationIds.toString();
    		var commaIndex = academyLocationIds.indexOf(",");
    		if(commaIndex != 0){
    			var academyLocationArray = academyLocationIds.split(",");
            	var alIds=[];
			    alIds=academyLocationArray.join();
    		}else{
    			formValues.academyLocationIds = [academyLocationIds];
    		}
    	}
    	var batchId = null;
    	var programId = null;
    	var sectionId = null;
    	var requestId = null;
    	var startDate = null;
    	var endDate = null;
    	
    	if(!isNullOrEmpty(formValues.batchId)){
    		batchId = formValues.batchId;
	     }
    	if(!isNullOrEmpty(formValues.programId)){
    		programId = formValues.programId;
	     }
    	if(!isNullOrEmpty(formValues.sectionId)){
    		sectionId = formValues.sectionId;
	     }
    	if(!isNullOrEmpty(formValues.requestId)){
    		requestId = formValues.requestId;
	     }
    	if(!isNullOrEmpty(formValues.startDate)){
    		startDate = formValues.startDate;
	     }
    	if(!isNullOrEmpty(formValues.endDate)){
    		endDate = formValues.endDate;
	     }
    	var store = resultGrid.getStore();
    	

//  	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

    	//store.getProxy().extraParams = submitData;
    	
    	store.getProxy().extraParams = {
    		requestTypeId : requestTypeId,
    		serviceRequestCategory : serviceRequestCategory,
    		certificateCategory : certificateCategory,
    		certificateId : certificateId,
    		sectionId : sectionId,
    		programId : programId,
    		batchId : batchId,
    		requestId: requestId,
    		fromDate : startDate, 
    		toDate : endDate,
    		academyLocationIds : alIds
    	}
    	resultGrid.down('custompagingtoolbar').moveFirst();

    	var taskDelay = new Ext.util.DelayedTask(function(){
//  		Ext.getBody().unmask();
    	});
    	taskDelay.delay(1000);
    	//store.load();
    	resultGrid.config.searchFilterForm = this$.getServiceDetailReportformQuickSearch()  && this$.getStudentDashboardView();
    },
    	
    /**
     * Create dashboard search criteria json
     * @params searchCriteriaForm
     */
    createSeachCriteriaDashboardJsonFormat: function(searchCriteriaForm){
    	var formValues = null;
    	if(searchCriteriaForm){
    		formValues = searchCriteriaForm.getValues();
    	for (var key in formValues) {
        	var value = formValues[key];            
            if(isNullOrEmpty(value) || value =='All' || key == 'selectedNameField'){
            	delete formValues[key];
            }
        }
    	var academyLocationIds = this.getAcademyLocationIds();
    	if(!isNullOrEmpty(academyLocationIds)){
    		academyLocationIds = academyLocationIds.toString();
    		var commaIndex = academyLocationIds.indexOf(",");
    		if(commaIndex != -1){
    			var academyLocationArray = academyLocationIds.split(",");
            	formValues.academyLocationIds = academyLocationArray;
    		}else{
    			formValues.academyLocationIds = [academyLocationIds];
    		}
        	
    	}
        	if(!isEmpty(formValues.assignTo)){
        		formValues.assignTo = formValues.assignTo.id;
    	}
    	
    	delete formValues['requestType'];
    	delete formValues['certificateCategory'];
    	delete formValues['freeFormCategory'];
    	formValues.requesterType = 'STUDENT';
        }
    	return formValues;
    },
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(key) && !isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(key) && !isNullOrEmpty(value) && !isNullOrEmpty(additionalValue)) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    /**
     * selected name field changes name config of related textfield
     */
    changeNameFieldConfig: function(combo) {

        var nameField = combo.up('form').down('#selectedName');

        if (nameField != undefined) { 

            nameField.setFieldLabel(combo.getRawValue());
            var name = combo.getValue();
            if(name == 'FIRST_NAME'){
            	nameField.name = 'firstName';
            }else if(name == 'MIDDLE_NAME'){
            	nameField.name = 'middleName';
            }else if(name == 'LAST_NAME'){
            	nameField.name = 'lastName';
            }

            nameField.emptyText = combo.getRawValue();
            nameField.applyEmptyText();
        }
    },
    /**
     * Get Service Request controller
     */
    getServiceRequestController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.servicerequest.ServiceRequestController');
    },
    /**
	  * This method is used to open tab after click of RequestId Cell of student track request grid
	  * Required :
	  * @param grid
	  * @param cellIndex
	  * @param record
	  */
  cellclickTrackRequestGrid: function(grid, cellIndex, record) {
	   var this$ = this;
	   isStdDetailReport = true;    ////for student detail report's req bifurcation
	   var cellDataIndex = grid.columnManager.columns[cellIndex].dataIndex;
	   if (cellDataIndex == "requestId") {
		   var requestId = record.get('serviceRequestId');
		   if(requestId==''){
		    var requestId = record.get('id');
		   }
		   var requestType = record.get('serviceRequestType');
		   if(requestType==""){
		   requestType = record.get('requestType');
		   }
		   if(isNullOrEmpty(requestId))
		   {
			 requestId  =record.get('id');
		   }
		   record.data.ID  = record.get('serviceRequestId');
		   if(record.data.ID==""){
		   record.data.ID  = record.get('id');
		   }
		   record.data.REQUEST_ID  = record.get('requestId');
		   record.data.SERVICE_REQUEST_GROUP  = record.get('serviceRequestGroup');
		   record.data.REQUEST_TYPE_ID  = record.get('requestTypeId');
		   record.data.SERVICE_REQUEST_TYPE  = record.get('serviceRequestType');
		   record.data.REQUEST_TYPE = record.get('requestType');
		   switch(record.get('requestType')){
		   case "Withdraw From Program":
		   requestType = "PROGRAM_WITHDRAWAL";
		   break;
		   case "Exchange Semester":
		   requestType = "EXCHANGE_SEMESTER";
		   break;
		   case "Leave of Absence":
		   requestType = "LEAVE_OF_ABSENCE";
		   break;
		   case "School Leaving":
		   requestType = "SCHOOL_LEAVING";
		   break;
		   case "Section Transfer":
		   requestType = "SECTION_TRANSFER";
		   break;
		   case "Student Transfer":
		   requestType = "STUDENT_TRANSFER";
		   break;
		   case "Course Transfer" :
		   requestType = "COURSE_TRANSFER";
		   break;
		   case "Withdraw From Course" :
		   requestType = "COURSE_WITHDRAWAL";
		   break;
		   case "COURSES" :
		   case "PROGRAM" :
		   requestType = "CERTIFICATE";
		   break;
		   case "Personal Detail Change":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   case "Stake Holder Request":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   case "Medical History":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   case "Previous Education Detail":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   case "Vaccination Detail":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   case "Sibling Detail":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   case "Address Detail":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   case "work Experience":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   case "Extra Curricular Detail":
		   requestType = "PERSONAL_DATA_CHANGE";
		   break;
		   
		   }
		  
		   record.data.SUBREQUEST_TYPE = record.get('subRequestType');
		   record.data.REQUESTER  = record.get('requester');
		   if(record.data.REQUESTER==""){
		   record.data.REQUESTER  = record.get('personId');
		   }
		   record.data.PERSON_ID  = record.get('personId');
		   record.data.PROGRAM_BATCH_ID  = null;
		   record.data.PROGRAM_BATCH_SEAT_CONFIG_ID  = null;
		   record.data.SERVICE_REQUEST_STAGE = record.get('serviceRequestStage');
		   record.data.REQUEST_ASSIGNED_TO= record.get('requestAssignedTo');
		   if(record.data.REQUEST_ASSIGNED_TO == ""){
		   record.data.REQUEST_ASSIGNED_TO = record.get('assigneeName');
		   }
		   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		   this$.getServiceRequestController().setRequestData(requestId,record,requestType); 
	   }else if(cellDataIndex == "assignRequest"){
		   
		   if (grid.getSelectionModel().getCount() > 0) {
			   var formWindow = this$.getRequestAssignedWindow();
			   if(!formWindow){
				   formWindow = Ext.widget('requestassignedwindow',{
					   itemId:'studentAssignToWindow'
				   });  
			   }
			   formWindow.show();
			   Ext.getBody().unmask();
		   }else{
			   showWarningMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			   Ext.getBody().unmask();
		   }
		 
	   }
  },
  loadAssigneeCombo: function(combo){
	  var this$ = this;
	  var contentPanel = this$.getContentPanel();
	  var dashboardReportTab = contentPanel.down('#studentDashboardReportTabStructure');
	  var grid = dashboardReportTab.down('grid');
	  if (grid.getSelectionModel().getCount() > 0) {
		  var records = grid.getSelectionModel().getSelection()[0];
		  var academyLocationId =records.get('academyLocationId');
		  combo.getStore().getProxy().extraParams = {
	    		academyLocationId:academyLocationId
	      };    
	  }
  },
  /**
   * assign request to users
   */
  submitAssignRequest: function(){
	  var this$ = this;
	  var contentPanel = this$.getContentPanel();
	  var dashboardReportTab = contentPanel.down('#studentDashboardReportTabStructure');
	  var grid = dashboardReportTab.down('grid');
	  var assignRequestForm = this.getAssignRequestForm();
	  var formvalues = assignRequestForm.getValues();
	  var assigneeId = formvalues.assigneeId;
	  if (grid.getSelectionModel().getCount() > 0) {
		  if(!isNullOrEmpty(assigneeId)){
			  var records = grid.getSelectionModel().getSelection()[0];
			  var serviceRequestId =records.get('serviceRequestId');
			  formvalues.id = serviceRequestId;
	        	  
			  var jsonFormFieldData = Ext.encode(formvalues);
			  Ext.Ajax.request({
                  type: 'rest',
                  url: SERVERURL.COMPLAINT_ASSIGN_SERVICE_REQUEST,
                  method: 'POST',
                  jsonData: jsonFormFieldData,
                  headers: {
                      'Content-Type': 'application/json'
                  },
                  success: function(form, action) {
                	  this$.getRequestAssignedWindow().close();
                      grid.getStore().reload();
                      showSuccessMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getServiceRequestTranslation('REQUEST_ASSIGN_SUCCESS'));
                  }
              });
		  }else{
			   showWarningMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getServiceRequestTranslation('PLEASE_SELECT_ASSIGNEE'));
		   }
		  
	   }else{
		   showWarningMessage(getServiceRequestTranslation('ASSIGN_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	   }
	  
    },
    
    /**
     * This method is used get Search Form Value 
     * @param formValues
     * @author Pritam Patil
     */
    getSearchFormValue : function(formValues){
    	
    	if(formValues.SERVICE_REQUEST_GROUP){
    		formValues.serviceRequestGroup = formValues.SERVICE_REQUEST_GROUP ;
    		delete formValues.SERVICE_REQUEST_GROUP;
    	}
    	if(formValues.CERTIFICATE_ID){
    		formValues.certificateId = formValues.CERTIFICATE_ID ;
    		delete formValues.CERTIFICATE_ID;
    	}
    	if(formValues.CERTIFICATE_CATEGORY){
    		formValues.certificateCategory = formValues.CERTIFICATE_CATEGORY ;
    		delete formValues.CERTIFICATE_CATEGORY;
    	}
    	if(formValues.REQUEST_TYPE_ID){
    		formValues.requestTypeId = formValues.REQUEST_TYPE_ID ;
    		delete formValues.REQUEST_TYPE_ID;
    	}
    	if(formValues.FREE_FORM_REQUEST_CATEGORY){
    		formValues.freeFormRequestCategoryId = formValues.FREE_FORM_REQUEST_CATEGORY ;
    		delete formValues.FREE_FORM_REQUEST_CATEGORY;
    	}
    	if(formValues.FREE_FORM_REQUEST_ID){
    		formValues.freeFormRequestId = formValues.FREE_FORM_REQUEST_ID ;
    		delete formValues.FREE_FORM_REQUEST_ID;
    	}
    	return formValues ;
    },
   
    /**
     * this method is used to load student exits
     */
    loadStudentExitCharts : function (){
    	var this$ = this;
    	var contentPanel = this$.getContentPanel();
    	var stdOrganizationUnit =  contentPanel.down('#studentDashboardOrganizationUnit');
    	var values = stdOrganizationUnit.getValues();
    	if(values.multiselectAcademyLocation == undefined || values.multiselectAcademyLocation[0] ==""){
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
    		return;
    	}
    	var searchCriteriaForm = this$.getStudentExitSearchForm();
    	var values = searchCriteriaForm.getValues();
    	
    	var obj = this.getExitJsonObject(values);
    	console.log(obj)
    	this.displayChart(obj,values);
    	
    },
    
    /**
     * This method is used to get requested JSon as per search criteria
     * @param values
     */
    getExitJsonObject : function(values){
    
    	var obj = new Object();
    	if(values.academyIds){
    		if(values.academyIds.length > 1){
				var academyIds = new Array();
				Ext.each(values.academyIds,function(academy){
					if(academy instanceof Object ) {
						academyIds.push(academy.get("id"));
					} else {
						academyIds.push(academy);
					}						
				});				
				obj.academyIds = academyIds;
			
		}else{
			if(!isNullOrEmpty(values.academyIds)){				
				obj.academyIds = values.academyIds[0];
			}
		}
    	}
    		if(values.locationsId){
    			if(values.locationsId.length > 1){
					var locationsId = new Array();
					Ext.each(values.locationsId,function(location){
						if(location instanceof Object ) {
							locationsId.push(location.get("id"));
						} else {
							locationsId.push(location);
						}						
					});	
					obj.locationsId = locationsId;
    			
    		}else{
    			if(!isNullOrEmpty(values.locationsId)){
					obj.locationsId = values.locationsId[0];
				}
    		
    		}
    		}
    		if(values.programs){
    		if(values.programs.length > 1){
					var programs = new Array();
					Ext.each(values.programs,function(program){
						if(program instanceof Object ) {
							programs.push(program.get("id"));
						} else {
							programs.push(program);
						}						
					});	
					obj.programs = programs;
    			
    		}else{
    			if(!isNullOrEmpty(values.programs)){
					obj.programs = values.programs;
				}
    		}
    		}
    		if(values.batches){
    			if(values.batches.length > 1){
        			
					var batches = new Array();
					Ext.each(values.batches,function(batch){
						if(batch instanceof Object ) {
							batches.push(batch.get("id"));
						} else {
							batches.push(batch);
						}						
					});	
					obj.batches = batches;
    			
    		}else{
    			if(!isNullOrEmpty(values.batches)){
					obj.batches = values.batches;
				}
    		}
    		}
    		if(values.sections){
    		if(values.sections.length > 1){
					var sections = new Array();
					Ext.each(values.sections,function(section){
						if(batch instanceof Object ) {
							sections.push(section.get("id"));
						} else {
							sections.push(section);
						}						
					});	
					obj.sections = sections;
    			
    		}else{
    			if(!isNullOrEmpty(values.sections)){
					obj.sections = values.sections[0];
				}
    		}
    		}
    		
    	return obj ;
    },
    
    /**
     * This is used for different AJAX call
     * @param url 
     * @param store
     * @param submitData
     */
    
    getAjaxCall: function(url, store,submitData) {
    	var me = this;
    	 Ext.Ajax.request({
             type: 'rest',
             url: url,
             method: 'POST',
             headers: {
                 'Content-Type': 'application/json'
             },
             //async : false,
             jsonData: submitData,
             success: function(response) {
             	data = Ext.decode(response.responseText);
             	if(data.length !== 0){
					store.loadData(data);
					me.visibleChart();
				}else{
					me.resetChartAfterLoad();
				}
             }
         });
    },
    
    
    visibleChart : function(){
    	var studentExitView = this.getStudentExitView();
    	if(studentExitView.down('#academyPanel')){
    		studentExitView.down('#academyChartField').setVisible(false);
			studentExitView.down('#academiesChart').setVisible(true);
			studentExitView.down('#academyLabel').setVisible(true);
		}if(studentExitView.down('#locationPanel')){
			studentExitView.down('#locationChartFieldId').setVisible(false);
			studentExitView.down('#locationChart').setVisible(true);
			studentExitView.down('#locationLabel').setVisible(true);
		}if(studentExitView.down('#batchPanel')){
			studentExitView.down('#bacthChartFieldId').setVisible(false);
			studentExitView.down('#batchChart').setVisible(true);
			studentExitView.down('#batchLabel').setVisible(true);
		}if(studentExitView.down('#sectionPanel')){
			studentExitView.down('#sectionChartFieldId').setVisible(false);
			studentExitView.down('#sectionChart').setVisible(true);
			studentExitView.down('#sectionLabel').setVisible(true);
		}if(studentExitView.down('#programsPanel')){
			studentExitView.down('#programChartFieldId').setVisible(false);
			studentExitView.down('#admissionStatisticsByProgramBarChart').setVisible(true);
			studentExitView.down('#programLabel').setVisible(true);
		}
    },
    
    resetChartAfterLoad : function(){
    	
    	var studentExitView = this.getStudentExitView();
    	if(studentExitView.down('#academyPanel')){
    		studentExitView.down('#academyChartField').setVisible(true);
			studentExitView.down('#academiesChart').setVisible(false);
			studentExitView.down('#academyLabel').setVisible(false);
		}if(studentExitView.down('#locationPanel')){
			studentExitView.down('#locationChartFieldId').setVisible(true);
			studentExitView.down('#locationChart').setVisible(false);
			studentExitView.down('#locationLabel').setVisible(false);
		}if(studentExitView.down('#batchPanel')){
			studentExitView.down('#bacthChartFieldId').setVisible(true);
			studentExitView.down('#batchChart').setVisible(false);
			studentExitView.down('#batchLabel').setVisible(false);
		}if(studentExitView.down('#sectionPanel')){
			studentExitView.down('#sectionChartFieldId').setVisible(true);
			studentExitView.down('#sectionChart').setVisible(false);
			studentExitView.down('#sectionLabel').setVisible(false);
		}if(studentExitView.down('#programsPanel')){
			studentExitView.down('#programChartFieldId').setVisible(true);
			studentExitView.down('#admissionStatisticsByProgramBarChart').setVisible(false);
			studentExitView.down('#programLabel').setVisible(false);
		}
    },
    /**
     * This method is used to display charts as per search criteria 
     * @param obj
     */
    
    displayChart : function(obj,values){
    	var this$ = this;
    	var studentExitView = this$.getStudentExitView();
    	var studentDashboardView = this$.getStudentDashboardView();
    	var url = null;
    	var store = null;
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	    	
    		if(obj.academyIds){
    			if(obj.academyIds.length > 1){
            		studentExitView.down('#academyPanel').setVisible(true);
            		if(values.entityName === 'ALL_EXITS'){
            			url = SERVERURL.GET_ALL_EXIT_REPORT ;
            		}else{
            			url = SERVERURL.GET_TERMINATION_REPORT ;
            		}
            		store = studentExitView.down('#academiesChart').getStore();
            		var object = new Object();
            		var data =this.createSubmitData(object,values);
            		delete data.isAllExitReport ;
            		data.academyIds = obj.academyIds;
            		data.isAllExitReport = false;
            		this$.getAjaxCall(url,store,data);
            		
            	}else{
            		if(studentExitView.down('#academyPanel')){
            			studentExitView.down('#academyPanel').setVisible(false);
            		}
            		
            	}
    		}
    		if(obj.locationsId){
    			if(obj.locationsId.length > 1){
        		studentExitView.down('#locationPanel').setVisible(true);
        		if(values.entityName === 'ALL_EXITS'){
        			url = SERVERURL.GET_ALL_EXIT_REPORT ;
        		}else{
        			url = SERVERURL.GET_TERMINATION_REPORT ;
        		}
        		store = studentExitView.down('#locationChart').getStore();
        		var object = new Object();
        		var data =this.createSubmitData(object,values);
        		data.locationsId = obj.locationsId;
        		delete data.isAllExitReport ;
        		data.isAllExitReport = false;
        		this$.getAjaxCall(url,store,data);
    			}
    			else{
            		if(studentExitView.down('#locationPanel')){
            			studentExitView.down('#locationPanel').setVisible(false);
            		}
            		
            	}
    		}
    		if(obj.batches){
    			if(obj.batches.length > 1){
        		studentExitView.down('#batchPanel').setVisible(true);
        		if(values.entityName === 'ALL_EXITS'){
        			url = SERVERURL.GET_ALL_EXIT_REPORT ;
        		}else{
        			url = SERVERURL.GET_TERMINATION_REPORT ;
        		}
        		store = studentExitView.down('#batchChart').getStore();
        		var object = new Object();
        		var data =this.createSubmitData(object,values);
        		data.batches = obj.batches;
        		delete data.isAllExitReport ;
        		data.isAllExitReport = false;
        		this$.getAjaxCall(url,store,data);
        		
    			}else{
            		if(studentExitView.down('#batchPanel')){
            			studentExitView.down('#batchPanel').setVisible(false);
            		}
            		
            	}
    		}
    		if(obj.sections){
    			if(obj.sections.length > 1){
        		studentExitView.down('#sectionPanel').setVisible(true);
        		if(values.entityName === 'ALL_EXITS'){
        			url = SERVERURL.GET_ALL_EXIT_REPORT ;
        		}else{
        			url = SERVERURL.GET_TERMINATION_REPORT ;
        		}
        		store = studentExitView.down('#sectionChart').getStore();
        		var object = new Object();
        		var data =this.createSubmitData(object,values);
        		data.sections = obj.sections;
        		delete data.isAllExitReport ;
        		data.isAllExitReport = false;
        		this$.getAjaxCall(url,store,data);
        		studentDashboardView.scrollBy(0,700,true);
    			}else{
            		if(studentExitView.down('#sectionPanel')){
            			studentExitView.down('#sectionPanel').setVisible(false);
            		}
            		
            	}
        	}
    		if(obj.programs){
        		if(obj.programs.length > 1){
        		studentExitView.down('#programsPanel').setVisible(true);
        		if(values.entityName === 'ALL_EXITS'){
        			url = SERVERURL.GET_ALL_EXIT_REPORT ;
        		}else{
        			url = SERVERURL.GET_TERMINATION_REPORT ;
        		}
        		store = studentExitView.down('#admissionStatisticsByProgramBarChart').getStore();
        		var object = new Object();
        		var data =this.createSubmitData(object,values);
        		data.programs = obj.programs;
        		delete data.isAllExitReport ;
        		data.isAllExitReport = false;
        		this$.getAjaxCall(url,store,data);
        		studentDashboardView.scrollBy(0,700,true);
        		}else{
            		if(studentExitView.down('#programsPanel')){
            			studentExitView.down('#programsPanel').setVisible(false);
            		}
            		
            	}
    		}
    		if(values.entityName === 'ALL_EXITS'){
	    		
	    		studentExitView.down('#typeOfExitPanel').setVisible(true);
	    		url = SERVERURL.GET_ALL_EXIT_REPORT ;
	    		store = studentExitView.down('#typeOfExitChart').getStore();
	    		var object = new Object();
	    		var data =this.createSubmitData(object,values);
	    		this$.getAjaxCall(url,store,data);
	    		studentDashboardView.scrollBy(0,700,true);
	    		
	    	}
    		var taskDelay = new Ext.util.DelayedTask(function(){
	    		Ext.getBody().unmask();
	    	  });
    		taskDelay.delay(1000);
    	
    },
    
    
    /**
     * On focus academy location combo load data according with MAU filter's
     * @param comboField
     * @param records
     * @param eOpts
     */
    
    loadAcademyLocationComboByApplyingMAUFilter: function(comboField, records, eOpts){
		var academyLocationIds = this.getAcademyLocationIds();
		var store = comboField.getStore();
		store.load({
			params: {
				academyLocationIds: academyLocationIds
			}
		});
	},
	
	/**
	 * this is used to load reason for combo as per type of exit combo value
	 */
	loadReasonForCombo : function(cmb){
		
		cmb.up('form').down('#searchButtonId').setDisabled(false);
		
    	var reasonCmb = cmb.up('form').down('#reasonForExitId');
    	var typeOfExitCmb = cmb.getValue();
    	this.clearChart(cmb.up('form'));
    	var store ;
    	if (typeOfExitCmb === 'Termination'){
    		reasonCmb.setVisible(true);
    		reasonCmb.setDisabled(false);
    		reasonCmb.reset();
    	    store = reasonCmb.getStore();
    		store.getProxy().api.read = SERVERURL.TERMINATION_REASON_COMBO; 
    		store.load();
    	}else if (typeOfExitCmb === 'Transfer'){
    		reasonCmb.setVisible(true);
    		reasonCmb.setDisabled(false);
    		reasonCmb.reset();
    	    store = reasonCmb.getStore();
    		store.getProxy().api.read = SERVERURL.TRANSFER_REASON_COMBO;
    		store.load();
    	}else if (typeOfExitCmb === 'ProgramWithdrawal'){
    		reasonCmb.setVisible(true);
    		reasonCmb.setDisabled(false);
    		reasonCmb.reset();
    	    store = reasonCmb.getStore();
    		store.getProxy().api.read = SERVERURL.WITHDRAW_REASON_COMBO;
    		store.load();
    	}else if (typeOfExitCmb === 'ALL_EXITS' || typeOfExitCmb === 'ApplicationProgram' ){
    		reasonCmb.setVisible(false);
    		reasonCmb.setDisabled(true);
    	}
    	
	},
	
	/**
	 * This is used to reset form & charts 
	 */
	resetChart : function(button){
		
		var form = button.up('form');
		form.down('#searchButtonId').setDisabled(true);
		form.getForm().reset();
		this.clearChart(form);
	
	},
	
	clearChart : function(form){
		
		form.up('form').down('#academyPanel').setVisible(false);
		form.up('form').down('#locationPanel').setVisible(false);
		form.up('form').down('#batchPanel').setVisible(false);
		form.up('form').down('#sectionPanel').setVisible(false);
		form.up('form').down('#programsPanel').setVisible(false);
		form.up('form').down('#typeOfExitPanel').setVisible(false);
	},
	
	/**
	 * this method is used to create Object
	 */
	createSubmitData : function(obj,values){
		
		obj.entityName = values.entityName;
    	if(values.startDate){
    		obj.startDate = values.startDate;
    	}
    	if(values.endDate){
    		obj.endDate = values.endDate;
    	}
    	if(values.isReasonFilter){
    		obj.isReasonFilter = true ;
    		obj.reasonId = values.isReasonFilter;
    	}else{
    		obj.isReasonFilter = false ;
    	}
    	
    	if(values.entityName === 'ALL_EXITS'){
    		obj.isAllExitReport = true ;
    	}
    	return obj;
	}
});
