/**
 * @author rupesh.agrawal
 * This controller is use to handle functionality for InactiveUserReport 
 */
Ext.define('Academia.controller.reports.systemutilization.inactiveusers.InactiveUserByTimeReportController', {
    extend: 'Academia.controller.base.BaseController',

    stores: ['reports.systemutilization.inactiveusers.InactiveUserGroupwiseandMonthwiseSummaryStore', 
             'common.AcademyLocationByAcademyId', 'common.ProgramByAcademyLocationStore','common.UserGroupTypeStore',
             'common.AcademyStore','reports.systemutilization.inactiveusers.InactiveUserByUsageMonthwiseSummaryStore',
             'reports.systemutilization.inactiveusers.InactiveUserByUsageGridStore','common.AllActiveAcademyLocationStore'],

    views: ['reports.systemutilization.inactiveusers.InactiveByTimeUserReport', 
            'reports.systemutilization.inactiveusers.InactiveUserReportQuickSearchForm',
            'reports.systemutilization.inactiveusers.InactiveByUsageGrid'
            ],

    alias: "widget.inactiveuserbytimereportcontroller",

    refs: [{
        ref: 'inactivebytimeuserreport',
        selector: 'inactivebytimeuserreport'
    }, {
        ref: 'inactiveUserReportQuickSearch',
        selector: 'inactivebytimeuserreport inactiveuserreportquicksearchform'
    },{
    	ref: 'inactivebyusagegrid',
    	selector: 'inactivebyusagegrid'
    }],
    init: function(application) {
        this.control({ 
        	'inactivebyusagegrid' : {
        		afterrender : function(grid) {
        			var me = this;
        			var structure = grid.up('inactivebytimeuserreport');

					if (structure.items.items[1].activeTab.title == getCommonTranslation('INACTIVE_BY_TIME_USER_REPORT')) {
						me.getGridHeaderFreeze(grid, structure, false);
					}
				}
			},
        	'inactivebytimeuserreport inactiveuserreportquicksearchform#inactiveUserByTimeSearch button#inactiveUserReportListSearchButtonId': {
                  click: this.loadGridAndSearchUsers,
                  render: this.loadGridAndSearchUsers
              },
	        'inactivebytimeuserreport':{
	        	render: function(panel, eOpts) {
	        		var searchPanel=panel.down('inactiveuserreportquicksearchform#inactiveUserByTimeSearch');
	        		var notLogedInSince=searchPanel.down('textfield#notLogedInSince');
	        		notLogedInSince.allowBlank=true;
	        		notLogedInSince.setVisible(false);
	        		
	        	}
	        },
            'inactivebytimeuserreport groupedbarchart#inactiveusergroupwiseandmonthwisesummary' : {
	           	 afterrender: function(chart,a) {
	           		 this.addColumListener(chart);
	       		 }
           },
           'inactivebytimeuserreport columnchartreport#groupwisesummaryChart' : {
	           	 afterrender: function(chart,a) {
	           		 this.addGroupColumListener(chart);
	           	 }
           },
	       'inactivebytimeuserreport inactiveuserreportquicksearchform#inactiveUserByTimeSearch button#resetBtn': {
                click: this.clearSearchData
           }
        });

    },

    addColumListener:function(chart){
    	var this$ = this;
    	   chart.series.items[0].listeners={
               	itemclick: function(item,a) {
                    this$.barClickUserFrequencyModule(this,item);
                   }
               };
    },
    
    barClickUserFrequencyModule:function(this$,item){
    	var month= item.storeItem.get('MONTH'),quickSearchForm=this.getInactiveUserReportQuickSearch(),date = Ext.Date.parse(month, 'F-Y'),
    	USER_GROUP_NAME = this.getUserGroupName(item.yField);;
    	var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
    	var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
    	quickSearchForm.getForm().setValues({'fromDate':firstDay,'toDate':lastDay,'USER_GROUP_NAME' :USER_GROUP_NAME});
    	quickSearchForm.nextSibling().setActiveTab(0);
    	this.loadGridAndSearchUsers(null,null,quickSearchForm);
    },
    

    addGroupColumListener:function(chart){
    	var this$ = this;
    	   chart.series.items[0].listeners={
               	itemclick: function(item,a) {
                    this$.barClickUserGroup(this,item);
                   }
               };
    },
    
    barClickUserGroup:function(this$,item){
    	var USER_GROUP_NAME = this.getUserGroupName(item.storeItem.get('property')), 
    		quickSearchForm=this.getInactiveUserReportQuickSearch();

    	quickSearchForm.getForm().setValues({'USER_GROUP_NAME' :USER_GROUP_NAME});
    	quickSearchForm.nextSibling().setActiveTab(0);
    	this.loadGridAndSearchUsers(null,null,quickSearchForm);
    },
    
    getUserGroupName:function(key){
    	var USER_GROUP_NAME = false;
    	switch(key){
	    	case 'Admin':
	    		USER_GROUP_NAME = 'ADMIN';
	    		break;
	    	case 'Faculty':
	    		USER_GROUP_NAME = 'FACULTY';
	    		break;
	    	case 'Student':
	    		USER_GROUP_NAME = 'STUDENT';
	    		break;
    	}
    	return USER_GROUP_NAME;
    },
    
    loadGridAndSearchUsers: function(button, records,masterForm) {

    	if(!masterForm)
        	masterForm = button.up('#inactiveUserByTimeSearch');
        var jsonFormatFormData =masterForm.getValues();
        
        jsonFormatFormData.academyLocationId=jsonFormatFormData.ACADEMY_LOCATION_ID;
        if( jsonFormatFormData.USER_GROUP_NAME != false){
        	  var serviceRequestConstants = this.getServiceRequestConstant();
        	  var userGroupStudentId= serviceRequestConstants.getRequestStatus('USER_GROUP_'+jsonFormatFormData.USER_GROUP_NAME +'_ID');
        	  console.log(userGroupStudentId);
        	  jsonFormatFormData.userGroupId = userGroupStudentId ;
        }
    	
        delete jsonFormatFormData.NOT_LOGGED_IN_SINCE_DAYS;
        delete jsonFormatFormData.ACADEMY_LOCATION_ID;
        delete jsonFormatFormData.USER_GROUP_NAME;
        
        var activeTab=masterForm.up('inactivebytimeuserreport').down('tabpanel').getActiveTab();
        if(activeTab.itemId== 'inactivebyusagetab' ){

        	var store=activeTab.down('grid').getStore();
        	store.getProxy().extraParams=jsonFormatFormData;
        	store.reload();
	        	
        }else if(activeTab.itemId== 'inactiveusergroupwiseandmonthwisesummary' ){
        	
	    	basicSearchUrl= SERVERURL.INACTIVE_USER_MOTH_WISE_REPORT;
        	var store=activeTab.getStore();
	    	this.loadChartData(basicSearchUrl,jsonFormatFormData,store);
        	
        }else if(activeTab.itemId== 'inactiveusergroupwisesummary' ){
        	 
        	basicSearchUrl= SERVERURL.INACTIVE_USER_Group_WISE_REPORT;
	    	var store=activeTab.down('#groupwisesummaryChart').getStore();
	    	this.loadChartData(basicSearchUrl,jsonFormatFormData,store);
    	}
    },
    
    loadChartData:function(viewUrl,jsonFormatFormData,store){
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.request({
            type: 'rest',
            url: viewUrl,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            jsonData: jsonFormatFormData,
            success: function(response) {
            	Ext.getBody().unmask();
            	data = Ext.decode(response.responseText);
	        	if(data.length !== 0){
	              	 store.loadData(data);
	            }
            }
        });
   },
    loadCombo: function(combo) {
        var store = combo.getStore();
        store.load();
    },
    createJsonFormat: function(MasterForm) {
        var me = this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        formValues = MasterForm.getValues();

        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
            }
        }

        values.searchCriterias = searchcriteria;
        return values;
    },
    
    clearSearchData : function(button){
    	 button.up('form').getForm().reset();
    	 var masterForm = button.up('#inactiveUserByTimeSearch');
    	 
    	 var InactiveByUsageGrid = masterForm.up('inactivebytimeuserreport').down('#InactiveByUsageGrid');
    	 var inactiveusergroupwiseandmonthwisesummary = masterForm.up('inactivebytimeuserreport').down('#inactiveusergroupwiseandmonthwisesummary');
    	 var inactiveusergroupwisesummary = masterForm.up('inactivebytimeuserreport').down('#groupwisesummaryChart');
    	 
    	 InactiveByUsageGrid.getStore().removeAll();
    	 inactiveusergroupwiseandmonthwisesummary.getStore().removeAll();
    	 inactiveusergroupwisesummary.getStore().removeAll();
    },
    
    /**
	  * This method is use to get the reference to the service request  constants file 
	  */
	 getServiceRequestConstant:function() {
		 var serviceRequestConstant = Academia.constants.ServiceRequestConstants;
		 return serviceRequestConstant;
	 }
	 
});