/**
 * @author Sandeep.Ladvikar
 * @author pritam.patil This controller is use to handle functionality for the
 *         service request
 */
Ext.define('Academia.controller.servicerequest.ServiceRequestController', {
    extend: 'Academia.controller.servicerequest.ServiceRequestBaseController',
    alias: 'widget.servicerequestcontroller',
    requires: ['Academia.constants.ServiceRequestConstants'],
    views: ['servicerequest.StudentTrackRequestTabPanel',
    	'servicerequest.common.FollowUpDetailsPanel', 
    	'servicerequest.common.FollowUpDetailsGrid', 
    	'servicerequest.common.FollowUpDetailsPopUp', 
    	'servicerequest.common.ApprovalDetailsPanel', 
    	'servicerequest.common.ApprovalDetailsGrid', 
    	'servicerequest.common.EscalateDetailsPopUp', 
    	'servicerequest.common.RefundDetailsGrid', 
    	'servicerequest.common.FeeDetailsGrid', 
    	'servicerequest.certificateissuerequest.CertificateRequestDetailsPanel',
    	'servicerequest.scholarshiprequest.RequestDetailsPanel',
    	'servicerequest.programcoursesectiontransferrequest.ProgramRequestDetailsPanel',
    	'servicerequest.programcoursesectiontransferrequest.CourseRequestDetailsPanel',
    	'servicerequest.programcoursesectiontransferrequest.SectionRequestDetailsPanel',
    	'servicerequest.withdrawfromcourseprogramservice.WithdrawFromProgramDetailsPanel',
    	'servicerequest.withdrawfromcourseprogramservice.WithdrawFromCourseDetailsPanel',
    	'servicerequest.withdrawfromcourseprogramservice.WithdrawFormServiceDetailsPanel', 
    	'servicerequest.leavefineapplyrelatedrequest.LeaveRequestDetailsPanel', 
    	'servicerequest.leavefineapplyrelatedrequest.EmployeeLeaveRequestDetailsPanel', 
    	'servicerequest.studentservicerequest.StudentTransferRequestDetailsPanel', 
    	'servicerequest.studentservicerequest.StudentTransferExecutionDetailsPanel',
    	'servicerequest.studentservicerequest.StudentTransferExecutionDocumentGrid',
    	'servicerequest.studentservicerequest.SchoolLeavingRequestDetailsPanel', 
    	'servicerequest.studentservicerequest.SchoolLeavingExecutionDetailsPanel',
    	'servicerequest.common.ExecutionDetailsPanel',
    	'servicerequest.common.BasicDetails',
    	'servicerequest.common.RequesterDetailsPanel',
    	'servicerequest.ServiceRequestPanel',
    	'servicerequest.FacultyTrackRequestTabPanel',
    	'servicerequest.StudentTrackRequestTabPanel',
    	'servicerequest.TrackRequestPanel', 
    	'servicerequest.FindFacultyPortalRequestForm',
    	'servicerequest.FacultyTrackRequestPanel', 
    	'servicerequest.FacultyFindRequestForm', 
    	'servicerequest.StudentTrackRequestTabPanel',
    	'servicerequest.certificateissuerequest.CertificateExecutionDetailsPanel', 
    	'servicerequest.ServiceRequestViewMap', 
    	'servicerequest.personaldatachangerequest.PersonRequestDetailsPanel', 
    	'servicerequest.facultyservicerequest.FreeFormRequestDetailsPanel',
    	'servicerequest.examrelatedrequest.ExamRequestDetailsPanel',
    	'servicerequest.terminations.TerminationForm',
    	'servicerequest.terminations.DebarmentForm', 
    	'servicerequest.terminations.TransferForm', 
    	'personinfo.student.StudentTransferView', 
    	'personinfo.student.StudentCommonQuickSearch', 
    	'personinfo.student.StudentDebarmentView', 
    	'personinfo.student.StudentTerminationView', 
    	'servicerequest.feeservicerequest.FeeRequestDetailsPanel', 
    	'servicerequest.feeservicerequest.FeeServiceRequestStructure', 
    	'servicerequest.feeservicerequest.FeeRequestService',
    	'servicerequest.feeservicerequest.FeeRelatedServiceRequestInstallmentWin', 
    	'servicerequest.feeservicerequest.FeeRelatedServiceRequestInstallmentGrid',
    	'servicerequest.complaintrequest.ComplaintView', 
    	'servicerequest.complaintrequest.ComplaintSearchForm', 
    	'servicerequest.complaintrequest.ComplaintDetailsForm', 
    	'servicerequest.complaintrequest.ComplaintFollowUpDetailsPanel', 
    	'servicerequest.complaintrequest.ComplaintFollowUpPopUp', 
    	'servicerequest.leavefineapplyrelatedrequest.ApplyForPlacementDetailsPanel', 
    	'servicerequest.documents.ServiceRequestMandatoryDocumentGrid', 
    	'servicerequest.documents.ServiceRequestVoluntaryDocumentsGrid', 
    	'servicerequest.documents.ServiceRequestDocumentPanel', 
    	'servicerequest.complaintrequest.StudentComplaintDetailsForm', 
    	'servicerequest.examrelatedrequest.examrequesttype.CommonFieldsForm',
    	'servicerequest.examrelatedrequest.examrequesttype.ChangeOfExamDateForm', 
    	'servicerequest.examrelatedrequest.examrequesttype.ChangeOfExamCenterForm',
    	'servicerequest.examrelatedrequest.examrequesttype.WithdrawalOfExam',
    	'servicerequest.examrelatedrequest.examrequesttype.LackOfOtherCriteriaForm',
    	'servicerequest.examrelatedrequest.examrequesttype.ExamLeaveRequestForm', 
    	'servicerequest.examrelatedrequest.examrequesttype.LackOfAttendanceForm', 
    	'servicerequest.examrelatedrequest.examrequesttype.LackOfAttendanceGrid', 
    	'servicerequest.examrelatedrequest.examrequesttype.RequestForReExaminationForm',
    	'servicerequest.examrelatedrequest.examrequesttype.ExamConcessionRequestForm',
    	'servicerequest.common.BillDetailsGrid', 
    	'servicerequest.common.ServiceRequestFeesPanel',
    	'common.NestedJsonCombo', 
    	'reports.student.RequestSubRequestTypeFieldContainer', 
    	'servicerequest.leavefineapplyrelatedrequest.EmployeeLeaveDetailGrid', 
    	'servicerequest.common.CommonRaiseServiceRequestWindow', 
    	'servicerequest.common.CommonRequestComboPanel', 
    	'servicerequest.studentservicerequest.StudentTransferFollwupDocumentGrid', 
    	'servicerequest.documents.ServiceRequestFollowUpDocumentsGrid', 
    	'servicerequest.studentservicerequest.SchoolLeavingExecutionDocumentGrid', 
    	'servicerequest.HostelServiceRequest.HostelLeaveRequestDetailsPanel', 
    	'servicerequest.HostelServiceRequest.PrintCertificateHostelWidow', 
    	'servicerequest.ServiceRequestUploadDocWin', 
    	'servicerequest.examrelatedrequest.examrequesttype.ExamConcessionFormWin',
    	'personinfo.common.request.RequestPendingDocumentWindow',
    	'personinfo.common.request.RequestPendingDocumentListGrid',
    	'personinfo.common.request.RequestPendingMandatoryDocumentWindow', 
    	'personinfo.common.request.RequestPendingMandatoryDocumentListGrid', 
    	'servicerequest.facultyservicerequest.ReasonForWithdrawalWindow', 
    	'servicerequest.ServiceRequestActionDetailsPanel', 
    	'servicerequest.RequestActionLevelWindow', 
    	'servicerequest.studentservicerequest.LeaveOfAbsenceRequestForm', 
    	'servicerequest.programcoursesectiontransferrequest.ExchangeSemesterRequestDetailsPanel', 'servicerequest.common.StdAndParentRaiseServiceRequestWindow',
    	'servicerequest.StudentRequestTransferInGrid',
    	'servicerequest.TerminationRequestClosureWin',
    	'servicerequest.StudentPortalStudentRequestGrid', 
    	'servicerequest.ReAssignRequestServiceRequestWin',
    	'servicerequest.RejectionRequestClosureWin',
    	'servicerequest.studentservicerequest.cancellationReasonPopupWindow',
    	'servicerequest.StudentTransferClosureWin',
    	'servicerequest.feeservicerequest.ReAddmissionServiceRequestWin',
    	'servicerequest.feeservicerequest.ReAddmissionFileUploadForm',
    	'servicerequest.feeservicerequest.SelectReasonReAddmissionForm',
    	'servicerequest.feeservicerequest.DeclarationReAddmissionForm',
    	'servicerequest.HostelServiceRequest.ReAddmissionServiceRequest',
    	'servicerequest.quickComment.QuickCommentWindow',
    	"servicerequest.quickComment.QuickCommentInput",
    	"servicerequest.quickComment.QuickCommentGrid",
    	"servicerequest.quickComment.QuickCommentWindowStructure",
    	"document.DocumentPreviewWindow"
    ],
    stores: ['servicerequest.common.FollowUpDetails', 
    	'servicerequest.common.DocumentProofs', 
    	'leavemanagement.LeaveTypeStore',
    	'servicerequest.common.ApprovalDetails',
    	'servicerequest.common.RequestBy', 
    	'servicerequest.FacultyServiceRequestCategory', 
    	'servicerequest.scholarshiprequest.Scholarships',
    	'servicerequest.servicerequestsettings.CertificateCategories',
    	'servicerequest.certificateissuerequest.CertificatesTypes',
    	'servicerequest.common.ClosureReasons', 
    	'servicerequest.certificateissuerequest.HandoverMode', 
    	'servicerequest.personaldatachangerequest.Details',
    	'servicerequest.personaldatachangerequest.StakeHolders', 
    	'servicerequest.common.FollowUpStatus', 
    	'servicerequest.servicerequestsettings.FreeFormCategories',
    	'servicerequest.servicerequestsettings.SubRequestTypes', 
    	'servicerequest.programcoursesectiontransfer.FromPrograms', 
    	'servicerequest.TransferReasons', 
    	'servicerequest.programcoursesectiontransfer.ToPrograms', 
    	'servicerequest.common.ServiceRequestStatus',
    	'servicerequest.withdrawfromcourseprogramservice.Courses',
    	'servicerequest.common.RequesterTypes', 
    	'servicerequest.TerminationReasons', 
    	'servicerequest.DebarmentReasons', 
    	'servicerequest.programcoursesectiontransfer.FromCourse',
    	'servicerequest.programcoursesectiontransfer.ToCourse', 
    	'servicerequest.feerequest.FeeServiceRequest', 
    	'servicerequest.complaintrequest.ComplaintTypes', 
    	'servicerequest.complaintrequest.ComplaintAgainsts',
    	'servicerequest.complaintrequest.Complaintant', 
    	'servicerequest.complaintrequest.ComplaintPersons', 
    	'servicerequest.complaintrequest.ComplaintBy', 
    	'servicerequest.complaintrequest.FacilityCodes', 
    	'servicerequest.examrelatedrequest.EvaluationPlans', 
    	'servicerequest.withdrawservice.OptedServices', 
    	'servicerequest.withdrawservice.UnOptServices', 
    	'servicerequest.withdrawservice.OptedServices', 
    	'servicerequest.servicerequestsettings.ComplaintStatusStore',
    	'servicerequest.placementrequest.PlacementPeriods', 
    	'servicerequest.placementrequest.PlacementPrograms',
    	'servicerequest.common.ServiceRequestDocuments', 
    	'servicerequest.examrelatedrequest.Courses', 
    	'servicerequest.examrelatedrequest.ExpectedExamBatchs', 
    	'servicerequest.examrelatedrequest.DetailEvaluationSequences', 
    	'student.studentprofile.AcademicTopicStore', 
    	'servicerequest.examrelatedrequest.ExpectedExamDates', 
    	'servicerequest.examrelatedrequest.ExpectedExamCenters', 
    	'servicerequest.examrelatedrequest.Attendance', 
    	'servicerequest.common.ServiceRequestVoluntaryDocuments', 
    	'servicerequest.examrelatedrequest.QuestionPaperCodes', 
    	'servicerequest.examrelatedrequest.QuestionNos',
    	'servicerequest.examrelatedrequest.QuestionNoParts', 
    	'servicerequest.examrelatedrequest.QuestionNoSubParts',
    	'servicerequest.common.BillDetailsGridStore', 
    	'servicerequest.common.RefundDetailsGridStore', 
    	'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
    	'servicerequest.programcoursesectiontransfer.CourseForSectionTransfer', 
    	'servicerequest.programcoursesectiontransfer.ToParameterizedSectionForSectionTransfer', 
    	'servicerequest.examrelatedrequest.CenterTypes', 
    	'servicerequest.complaintrequest.ComplaintStatus', 
    	'common.picklist.StudentSelectNameComboStore', 
    	'servicerequest.servicerequestsettings.CourseCertificates', 
    	'servicerequest.servicerequestsettings.CommunityCertificates', 
    	'servicerequest.programcoursesectiontransfer.ToBatches', 
    	'servicerequest.programcoursesectiontransfer.SeatTypes', 
    	'servicerequest.programcoursesectiontransfer.programTransferToPeriodStore',
    	'examinationcenters.IsTemplateMappedStore',
    	'servicerequest.programcoursesectiontransfer.ToSectionForBatch', 
    	'leavemanagement.EmployeeLeaveDetailStore',
    	'servicerequest.servicerequestsettings.RequestAssignedUserStore', 
    	'servicerequest.ServiceRequests',
    	'user.UserAcademyLocationStore', 
    	'servicerequest.studentservicerequest.StudentTransferFollwupDocumentStore',
    	'servicerequest.studentservicerequest.StudentTransferExecutionDocumentStore',
    	'servicerequest.common.ServiceRequestFollowUpDocumentsStore', 
    	'organization.academylocations.AcademyLocationStore', 
    	'servicerequest.common.ALOnFollowUpPopUp',
    	'servicerequest.studentservicerequest.SchoolLeavingPeriodTermDefByProgramIdStore',
    	'servicerequest.studentservicerequest.SchoolLeavingExecutionDocumentStore', 
    	'servicerequest.studentservicerequest.StudentRequestStore', 
    	'servicerequest.common.RequesterBy', 
    	'servicerequest.common.ServiceRequestStudentStore', 
    	'admission.admissionCommon.SeatTypesByBatchIdsStore', 
    	'servicerequest.servicerequestsettings.HostelLeaveCategories',
    	'reports.servicerequest.PrintHostelLeaveStore', 
    	'servicerequest.ServiceRequestConfiguredCategoryStore' 
    	,'common.StudentLeaveTypeStore', 
    	'servicerequest.studentservicerequest.ReasonForLeavingStore',
    	'personinfo.common.request.RequestPendingDocumentListGridStore', 
    	'personinfo.common.request.RequestPendingMandatoryDocumentListGridStore',
    	'program.programDetails.programBatches.programSeatType.LeaveOfAbsenceAcademyLocationStore', 
    	'common.AcademyLocationNameSeparated', 
    	'servicerequest.studentservicerequest.StudentRequestTransferInStore', 
    	'organization.academylocations.ActiveAcademyLocationStore', 
    	'program.ProgramGroupStore',
    	'servicerequest.studentservicerequest.LeaveOfAbsenceReasonStore', 
    	'user.UserAcademyTermsByALStore',
    	'servicerequest.studentservicerequest.StudentPortalStudentRequestStore',
    	'common.StudentJouneryAcademicTermStore',
    	'common.StudentJouneryAcademyLocationStore',
    	'servicerequest.programcoursesectiontransfer.FromStudentJouneryBatchStore',
    	'servicerequest.programcoursesectiontransfer.FromStudentJouneryPeriodStore',
    	'servicerequest.feerequest.ReasonServiceRequestStore',
    	'servicerequest.studentservicerequest.EnrolledOrOfferedCoursesStore',
		'servicerequest.feerequest.IntendedStudyStore',
		'servicerequest.feerequest.IntendedProgramStore',
		'servicerequest.feerequest.IntendedFacultyStudyStore',
		'servicerequest.feerequest.IntendedProgramStudyStore',
		'servicerequest.feerequest.FollowupAgendaNumberStore',
		'servicerequest.feerequest.ReadmissionOutcomeStore',
	    'servicerequest.QuickCommentGridStore',
	    'program.programDetails.programBatches.programSeatType.LeaveOfAbsenceAcademicTermStore',
	    'servicerequest.studentservicerequest.ReasonForStudentTransferStore',
	    'servicerequest.studentservicerequest.ReasonForProgramTransferStore',
	    'servicerequest.studentservicerequest.ReasonForWithdrawalFromProgram',
	    'personinfo.common.request.RequestPendingMandatoryDocumentListGridReadmissionStore'
    ],
    config: {
        requestType: null,
        requestGroup: null,
        personId: null,
        assignee: null,
        settingId: null,
        responseData: null,
        STUDENT_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_REQUEST_PRIVILEGES'),
        FACULTY_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_REQUEST_PRIVILEGES'),
        TOOLSERVICE_COMPLAINT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TOOLSERVICE_COMPLAINT_PRIVILEGES'),
        PARENT_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_REQUEST_PRIVILEGES'),
        COREERP_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COREERP_REQUEST_PRIVILEGES'),
		GRIEVANCE_RADIO_BUTTON_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('GRIEVANCE_RADIO_BUTTON_PRIVILEGES')
    },
    refs: [{
    	ref:'reAddmissionServiceRequestWin',
    	selector:'reAddmissionServiceRequestWin'
    },{
    	ref:'selectReasonReAddmissionForm',
    	selector:'selectReasonReAddmissionForm'
    },{
    	ref:'reAddmissionServiceRequest',
    	selector:'reAddmissionServiceRequest'
    },{
        ref: 'programrequestdetailspanel',
        selector: 'programrequestdetailspanel'
    }, {
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'followUpDetailsPopUpWindow',
        selector: 'followupdetailspopupwindow'
    }, {
        ref: 'complaintFollowUpPopUp',
        selector: 'complaintfollowuppopup'
    }, {
        ref: 'followUpDetailsPopUpForm',
        selector: 'followupdetailspopupwindow form[itemId=followUpDetailsForm]'
    }, {
        ref: 'complaintFollowUpDetailsPopUpForm',
        selector: 'complaintfollowuppopup form[itemId=complaintFollowUpDetailsForm]'
    }, {
        ref: 'escalateDetailsPopUpWindow',
        selector: 'escalatedetailspopupwindow'
    }, {
        ref: 'escalateDetailsPopUpForm',
        selector: 'escalatedetailspopupwindow form[itemId=escalateDetailsForm]'
    }, {
        ref: 'executionDetailsPanel',
        selector: 'executiondetailspanel'
    }, {
        ref: 'executionDetails',
        selector: 'certificateexecutiondetailspanel'
    }, {
        ref: 'studentTransferExecutionDetails',
        selector: 'studenttransferexecutiondetailspanel'
    }, {
        ref: 'findRequestForm',
        selector: 'findrequestform'
    }, {
        ref: 'facultyFindRequestForm',
        selector: 'facultyfindrequestform'
    }, {
        ref: 'studentSearchResultGrid',
        selector: 'searchresultgrid[itemId=trackRequestGrid]'
    }, {
        ref: 'facultySearchResultGrid',
        selector: 'searchresultgrid[itemId=facultytrackRequestGrid]'
    }, {
        ref: 'trackRequestPanel',
        selector: 'trackrequestpanel'
    }, {
        ref: 'findFacultyPortalRequestForm',
        selector: 'findfacultyportalrequestform'
    }, {
        ref: 'debarmentForm',
        selector: 'debarmentform'
    }, {
        ref: 'feerequestservice',
        selector: 'feerequestservice'
    }, {
        ref: 'feerelatedservicerequestinstallmentgrid',
        selector: 'feerelatedservicerequestinstallmentgrid'
    }, {
        ref: 'feerelatedservicerequestinstallmentwin',
        selector: 'feerelatedservicerequestinstallmentwin'
    }, {
        ref: 'approverFeeRequestDetailGrid',
        selector: 'approverfeerequestdetailgrid'
    }, {
        ref: 'complaintSearchForm',
        selector: 'complaintsearchform'
    }, {
        ref: 'complaintSearchResultGrid',
        selector: 'searchresultgrid[itemId=complaintSearchResultGrid]'
    }, {
        ref: 'serviceRequestMandatoryDocuments',
        selector: 'servicerequestmandatorydocuments'
    }, {
        ref: 'serviceRequestVoluntaryDocuments',
        selector: 'servicerequestvoluntarydocuments'
    }, {
        ref: 'complaintdetailsform',
        selector: 'complaintdetailsform'
    }, {
        ref: 'facultytrackrequestpanel',
        selector: 'facultytrackrequestpanel'
    }, {
        ref: 'employeeleaverequestdetailspanel',
        selector: 'employeeleaverequestdetailspanel'
    }, {
        ref: 'employeeleavedetailgrid',
        selector: 'employeeleavedetailgrid'
    }, {
        ref: 'studentcomplaintdetailsform',
        selector: 'studentcomplaintdetailsform'
    }, {
        ref: 'commonraiseservicerequestwindow',
        selector: 'commonraiseservicerequestwindow'
    }, {
        ref: 'commonrequestcombopanel',
        selector: 'commonrequestcombopanel'
    }, {
        ref: 'studenttransferrequestdetailspanel',
        selector: 'studenttransferrequestdetailspanel'
    }, {
        ref: 'studenttransferfollwupdocumentgrid',
        selector: 'studenttransferfollwupdocumentgrid'
    }, {
        ref: 'studenttransferexecutiondocumentgrid',
        selector: 'studenttransferexecutiondocumentgrid'
    }, {
        ref: 'servicerequestfollowupdocumentsgrid',
        selector: 'servicerequestfollowupdocumentsgrid'
    }, {
        ref: 'basicdetails',
        selector: 'basicdetails'
    }, {
        ref: 'schoolLeavingExecutionDetails',
        selector: 'schoolleavingexecutiondetailspanel'
    }, {
        ref: 'schoolleavingexecutiondocumentgrid',
        selector: 'schoolleavingexecutiondocumentgrid'
    }, {
        ref: 'sectionrequestdetailspanel',
        selector: 'sectionrequestdetailspanel'
    }, {
        ref: 'hostelleaverequestdetailspanel',
        selector: 'hostelleaverequestdetailspanel'
    }, {
        ref: 'printcertificatehostelwidow',
        selector: 'printcertificatehostelwidow'
    }, {
        ref: 'servicerequestuploaddocwin',
        selector: 'servicerequestuploaddocwin'
    }, {
        ref: 'examconcessionrequestform',
        selector: 'examconcessionrequestform'
    }, {
        ref: 'examconcessionformwin',
        selector: 'examconcessionformwin'
    }, {
        ref: 'requestpendingdocumentwindow',
        selector: 'requestpendingdocumentwindow'
    }, {
        ref: 'requestpendingdocumentlistgrid',
        selector: 'requestpendingdocumentlistgrid[itemId=requestpendingdocumentlistgridItemId]'
    }, {
        ref: 'requestpendingmandatorydocumentwindow',
        selector: 'requestpendingmandatorydocumentwindow'
    }, {
        ref: 'requestpendingmandatorydocumentlistgrid',
        selector: 'requestpendingmandatorydocumentlistgrid[itemId=requestpendingmandatorydocumentlistgridItemId]'
    }, {
        ref: 'reasonforwithdrawalwindow',
        selector: 'reasonforwithdrawalwindow'
    }, {
        ref: 'servicerequestactiondetailspanel',
        selector: 'servicerequestactiondetailspanel'
    }, {
        ref: 'requestactionlevelwindow',
        selector: 'requestactionlevelwindow'
    }, {
        ref: 'leaveofabsencerequestform',
        selector: 'leaveofabsencerequestform'
    },
    {
        ref: 'exchangesemesterrequestdetailspanel',
        selector: 'exchangesemesterrequestdetailspanel'
    }, {
        ref: 'stdandparentraiseservicerequestwindow',
        selector: 'stdandparentraiseservicerequestwindow'
    }, {
        ref: 'studentrequesttransferingrid',
        selector: 'studentrequesttransferingrid'
    }, {
        ref: 'terminationrequestclosurewin',
        selector: 'terminationrequestclosurewin'
    }, {
        ref: 'reassignrequestservicerequestwin',
        selector: 'reassignrequestservicerequestwin'
    }, {
        ref: 'terminationrequestclosurewin',
        selector: 'terminationrequestclosurewin'
    }, {
        ref: 'requesterdetailspanel',
        selector: 'requesterdetailspanel'
    }, {
        ref: 'studentListGrid',
        selector: 'searchresultgrid[itemId=StudentSearchResultGrid]'
    }, {
        ref: 'studentportalstudentrequestgrid',
        selector: 'studentportalstudentrequestgrid'
    }, {
        ref: 'rejectionrequestclosurewin',
        selector: 'rejectionrequestclosurewin'
    }, {
        ref: 'cancellationReasonPopupWindow',
        selector: 'cancellationReasonPopupWindow'
    },{
        ref: 'studenttransferclosurewin',
        selector: 'studenttransferclosurewin'
    },{
    	ref: 'quickcommentwindow',
        selector: 'quickcommentwindow'
    },{
    	ref: 'quickCommentWindowStructure',
        selector: 'quickCommentWindowStructure'
    },{
    	ref: 'quickCommentInput',
        selector: 'quickCommentInput'
    },{
    	ref: 'quickCommentGrid',
        selector: 'quickCommentGrid'
    },{
    	ref: 'documentpreviewwindow',
        selector: 'documentpreviewwindow'
    },{
    	ref: 'requestpendingactiongrid',
        selector: 'requestpendingactiongrid'
    	
    }],
    init: function () {
    	this.quickCommentDocPath = "";
    	this.quickCommentDocName = "";
    	this.quickCommentFileUploadBtnDisabled = false;
        this.control({
        	'contentpanel':{
        		beforeremove:function(ct, cmp){
        			if(cmp.xtype=='servicerequestpanel' && (cmp.title == 'Readmission'  || cmp.title =='Readmission Request')){
        				this.readdmmisonRequestJsonData=null;
        				this.EditDocumentFormDataNew=null;
        			}
        		}
        	},
        	'reAddmissionServiceRequestWin':{
        		afterrender:function(){
        			//this.readdmmisonRequestJsonData=null;
        		}
        	},
        	'reAddmissionServiceRequestWin checkboxfield[itemId=planningToChangeProgram]':{
        		change:function(cmp){
        			if(cmp.getValue()){
        				cmp.nextSibling().setDisabled(false);
        				cmp.nextSibling().setVisible(true);
        				cmp.nextSibling().nextSibling().setVisible(true);
        				cmp.up('form').down('#programChangeMotivation').setVisible(true);
    				}else{
    					cmp.nextSibling().setDisabled(true);
    					cmp.nextSibling().setVisible(false);
    					cmp.nextSibling().reset();
    					cmp.nextSibling().nextSibling().nextSibling().el.setHTML('');
    					cmp.nextSibling().nextSibling().setVisible(false);
    					cmp.up('form').down('#programChangeMotivation').setVisible(false);
    				}
        			cmp.up('form').fireEvent('fieldvaliditychange',cmp.up('form'));
        		}
        	},
        	'reAddmissionServiceRequestWin button[itemId=resetFileField]':{
        		click:this.resetUploadFileField
        		
        	},
        	'reAddmissionServiceRequestWin filefield[itemId=uploadProgramFile]':{
        		change:this.checkFileExtentionandSize
        		
        	},
        	'reAddmissionFileUploadForm filefield[itemId=studiesFutureUploadFileField]':{
        		change:this.checkFileExtentionandSize
        		
        	},
        	'reAddmissionFileUploadForm filefield[itemId=improveCourseUploadFileField]':{
        		change:this.checkFileExtentionandSize
        		
        	},
        	'reAddmissionFileUploadForm filefield[itemId=registeredStudentUploadFileField]':{
        		change:this.checkFileExtentionandSize
        		
        	},
        	'reAddmissionServiceRequestWin filefield[itemId=proofOfPaymnet]':{
        		change:this.checkFileExtentionandSize
        		
        	},
        	'reAddmissionServiceRequest':{
        		afterrender:function(cmp){
        			var me = this,
        			academyLocationId = this.getCurrentAcademyLocation(),
        			associatedAcadLocationIds = new Array();
        			associatedAcadLocationIds.push(academyLocationId);
        			cmp.down('#fillReaddmmisionBtn').setVisible(false);
        			cmp.down('#btnSaveRequestDetails').setVisible(false);
        			if(portalId == '3'){
        				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_REQUEST_PERMISSIONS());
        			}else{
        				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getCOREERP_REQUEST_PERMISSIONS());
        			}
        			
        			permissionList.forEach(function(rec){
        				if(rec=='READMISSION_FORM'){
        					cmp.down('#fillReaddmmisionBtn').setVisible(true);
        				}else if(rec=='UPLOAD_AND_SUBMIT'){
        					cmp.down('#btnSaveRequestDetails').setVisible(true);
        				}
        			})

        		}
        	},
        	'reAddmissionServiceRequest button[itemId=btnSaveRequestDetails]':{
        		click:this.reAddmissionUploadRequest
        		
        	},
        	'reAddmissionServiceRequest button[itemId=withdrawButtonId]':{
        		click:this.withdrawRequest
        		
        	},
        	'reAddmissionServiceRequestWin button[itemId=readdmissionCancelbtn]':{
        		click:function(winBtn){
        			var me = this,
        			win = me.getReAddmissionServiceRequestWin();
        			if(!win.down('form').isDirty()){
        				win.close();
        			}else{
        				if(win.down('#readdmissionSaveBtn').isVisible()){
        					showDraftConfirmMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('SAVE_AS_DRAFT_MESSAGE'),function(btn,text){
            					if (btn == 'yes') {
            						me.saveReAddmissionForm(winBtn);
            						
            					}else{
            						win.close();
            					}
            				});
        				}else{
        					win.close();
        				} 
        			}
        		}
        		
        	},
        	'reAddmissionServiceRequestWin button[itemId=readdmissionSaveBtn]':{
        		click:function(btn){
        			var me = this;
        			me.saveReAddmissionForm(btn);
        		}
        	},
        	'reAddmissionServiceRequestWin button[itemId=saveAsDraft]':{
        		click:function(btn){
        			var me = this;
        			me.saveReAddmissionFormDraft(btn,true);
        		}
        	},
        	'declarationReAddmissionForm checkboxfield[itemId=termsAndConditions]':{
        		change:function(cmp){
        			var me=this,
        			readdmissionwin = me.getReAddmissionServiceRequestWin(),
        			reAddmissionFormView = readdmissionwin.down('#reAddmissionFormView');
        		}
        	},
        	'reAddmissionServiceRequestWin form[itemId=reAddmissionFormView]':{
        		fieldvaliditychange:function(cmp, label, isValid){
        			var me=this,
        			readdmissionwin = me.getReAddmissionServiceRequestWin(),
    				termsAndConditions = readdmissionwin.down('#termsAndConditions');
        			cmp.getForm().clearInvalid();
        		}
        		
        	},
        	'selectReasonReAddmissionForm button[itemId=addSectionBtn]':{
        		click:function(btn){
        			this.addReasonSection(btn);
        			/*var me=this,
        			readdmissionwin = me.getReAddmissionServiceRequestWin(),
        			readdmissionForm= readdmissionwin.down('#reAddmissionFormView'),
        			items=readdmissionForm.items.items,
        			index = me.getPanelIndex(items);
        			readdmissionForm.insert(index,{
        				xtype:'selectReasonReAddmissionForm',
        					width: '97%',
        				margin:'40 0 10 5',
        					listeners:{
        						afterrender:function(cmp){
        							cmp.down('#deleteSectionBtn').setVisible(true);
        							cmp.down('#deleteLabel').setVisible(true);
        						}
        					}
        			});*/
        		}
        		
        	},
        	'selectReasonReAddmissionForm button[itemId=deleteSectionBtn]':{
        		click:function(btn){
        			var me = this,index=-1,
        			form = btn.up('selectReasonReAddmissionForm'),
        			tab = me.getActiveTabfromContentPanel(),
        			formView= this.getReAddmissionServiceRequestWin();
        			var addBtnForm= formView.down('form')
        			addBtnForm.query('#addSectionBtn')[0].setVisible(true);
        			addBtnForm.query('#addSectionBtn')[0].nextSibling().setVisible(true);
        			form.destroy();
        			formView.down('form').fireEvent('fieldvaliditychange',formView.down('form'));
        		}
        		
        	},
        	'selectReasonReAddmissionForm customcombobox[itemId=serviceReason]':{
        		select:this.addMoreReasonSection
        		
        	},
        	
        	 'debarmentform customcombobox[name=leavingReasonId]':{
        	    	select:function(cmp){
        	    		var me=this;
        	    		var store = cmp.getStore();
        	    		store.on('beforeload', function(store){
        	    			store.getProxy().extraParams = {
        	    				academyLocationId: me.getCurrentAcademyLocation()
        	    			}
        	    		});
        	    		store.load();
        	    	}
        	    } ,
        	    'terminationform customcombobox[name=terminationReasonId]':{
     	    	select:function(cmp){
     	    		var me=this;
     	    		var store = cmp.getStore();
     	    		store.on('beforeload', function(store){
     	    			store.getProxy().extraParams = {
     	    				academyLocationId: me.getCurrentAcademyLocation()
     	    			}
     	    		});
     	    		store.load();
     	    	}
     	    } ,
        	'reAddmissionServiceRequestWin customcombobox[itemId=intendedStudy]':{
        		select:function(cmp){
        			var programStudy = cmp.nextSibling();
        			programStudy.setDisabled(false);
        			programStudy.reset();
        			programStudy.getStore().removeAll();
        			programStudy.getStore().getProxy().extraParams={
        				academyLocationId:cmp.getValue()
        			}
        		}
        		
        	},
        	'reAddmissionServiceRequest button[itemId=fillReaddmmisionBtn]':{
        		click:function(btn){
        			var me = this,tempFormData,
        			tab=me.getActiveTabfromContentPanel();
        			var readmissionForm=Ext.widget('reAddmissionServiceRequestWin').show();
        			if(tab && tab.getResponseData()){
        				Ext.defer(function(){
        					me.setReadmissionFormRecord(tab,tab.getResponseData(),readmissionForm);
        				},100);

        			}/*else if(me.readdmmisonRequestJsonData){
        				Ext.defer(function(){
        					tempFormData = me.EditDocumentFormDataNew ? me.EditDocumentFormDataNew : me.readdmmisonRequestJsonData
        							me.setReadmissionFormRecord(tab,tempFormData,readmissionForm);
        				},100);
        			}*/
        			var admissionId = btn.up('servicerequestpanel').admissionId;
        			Ext.Ajax.request({
        				type: 'rest',
        				url: SERVERURL.PATH_FIND_READMISSION_REQUEST_TEMP_DATA,
        				params: {
        					admissionId : admissionId
        				},
        				method: 'GET',
        				success: function (response, action) {
        					if(response.responseText){
        						var resp = JSON.parse(response.responseText);
        						var tempArray=[];
        						if(resp.readmissionRequestParentDetail && resp.readmissionRequestParentDetail.length >1){
        							if(resp.readmissionRequestParentDetail[0].id > resp.readmissionRequestParentDetail[1].id){
        								tempArray.push(resp.readmissionRequestParentDetail[1]);
        								tempArray.push(resp.readmissionRequestParentDetail[0]);
        								resp.readmissionRequestParentDetail = tempArray;
        							}
        						}
        						

        						readmissionForm.savedDraftedId = resp.id;
        						me.setReadmissionFormRecord(tab,resp,readmissionForm);
        					}
        				},
        				failure: function (response) {
        					//
        				}
        			});

        		}

        	},
            'examconcessionrequestform button#examConcessionBtn': {
                click: function () {
                    var conWin = Ext.widget('examconcessionformwin');
                    conWin.show();
                }
            },
            'examconcessionformwin button#cancelBtn': {
                click: function () {
                    var formWin = this.getExamconcessionformwin();
                    formWin.close();
                }
            },
            'examconcessionformwin button#saveBtn': {
                click: function () {
                    var $this = this;
                    var formWin = this.getExamconcessionformwin();
                    formWin.down('#saveBtn').setDisabled(true);
                    var stdName = this.getExamconcessionrequestform().down('#studentName').getValue();
                    var stdCode = this.getExamconcessionrequestform().down('#studentCode').getValue();
                    var concessionFormBtn = this.getExamconcessionrequestform().down('#examConcessionBtn');
                    var formWinValue = formWin.down('form').getForm().getValues();
                    formWinValue.stdCode = stdCode;
                    formWinValue.stdName = stdName;
                    var submitData = Ext.encode(formWinValue);
                    var submitUrl = SERVERURL.GENERATE_EXAM_CONCESSION_FORM;
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: submitUrl,
                        jsonData: submitData,
                        method: 'POST',
                        success: function (response, action) {
                            Ext.getBody().unmask();
                            formWin.close();
                            var tab = $this.getContentPanelActiveTab();
                            tab.setSettingId(response.responseText);
                            concessionFormBtn.setText(getServiceRequestTranslation('EXAM_CONCESSION_FORM_SUBMITTED'));
                            concessionFormBtn.disable();
                            showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SUCCESS'));
                        },
                        failure: function (response) {
                            formWin.down('#saveBtn').setDisabled(false);
                        }
                    });
                }
            },
            'trackrequestpanel': {
                afterrender: function (structure) {
                    var grid = structure.down('searchresultgrid');
                    if (portalId == "3" || portalId == "7") {
                        var struct = structure.up();
                        this.getGridHeaderFreezeManageAssessmentEvents(grid, struct);
                    } else {
                        var newStruct = structure;
                        this.getGridHeaderFreezeRequest(grid, newStruct);
                    }
                    structure.setAutoScroll(true);
                }
            },
            'servicerequestpanel': {
                activate: function (panel) {
                    this.openServiceRequestPanel(this.getRequestGroup(), panel);
                    Ext.defer(function () {
                        var executiondetailspanel = panel.down('executiondetailspanel');
                        if (executiondetailspanel != undefined) {
                            executiondetailspanel.down('#isCalculateSeparateCGPAndSGPAId').setValue(panel.isCalculateSeparateCGPAndSGPA);
                        }
                    }, 1000);
                }
            },
            'basicdetails': {
                beforerender: this.toggleBasicDetailsFormItems,
                afterrender: function (frm) {
                    var me = this;
                    if (frm.up('withdrawfromprogramdetailspanel')) {
                        this.addLeavingReasonFields(1, frm, false);
                        Ext.defer(function () {
                            if (!frm.up().down('#authorizeDeclarationId').isVisible()) {
                                frm.up().down('#authorizeDeclarationDetails').setVisible(false);
                            }
                            if (frm.up().down('#studentApplyId').isHidden()) {
                                frm.up().down('#forStudentsApplyingDetails').setVisible(false);
                            }
                            if (frm.up().down('#studentDeclarationId').isHidden()) {
                                frm.up().down('#studentDeclarationDetails').setVisible(false);
                            }
                            if (me.getCurrentLoggedPortalId() == 1) frm.up().down('#studentHyperLink').setVisible(true);
                        }, 500)
						var isEditRequest = false;
						var activeTab = this.getContentPanelActiveTab();
						if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
							var serviceRequestId = activeTab.getServiceRequestId();
							if (!isNullOrEmpty(serviceRequestId)) {
								isEditRequest = true;
							}
						} 
                        var academicTermField=frm.up('withdrawfromprogramdetailspanel').down('#academicTermProgramWithdrwanId');
                       var academicTermFieldStore= academicTermField.getStore();
                        academicTermFieldStore.load({
        	              	params:{
        	              		studentId: me.getContentPanelActiveTab().getRequesterId(),
        	              		isEditRequest : isEditRequest
        	              	},
        	          
        	       });
                    } else if (frm.up('programrequestdetailspanel')) {
                        frm.down('#RequestReason').setVisible(false);
                        frm.down('#RequestReason').setDisabled(true);
                        var isMultipleReasonsRequired = me.getMultipleReasonsRequired();
						frm.down('#leavingReasonsFieldset').setVisible(false);
						frm.down('#leavingReasonSingleFieldset').setVisible(false);
						
						if(isMultipleReasonsRequired){
							frm.down('#leavingReasonsFieldset').setVisible(true);
							this.addLeavingReasonFields(1, frm, false);
						}
						else{
							frm.down('#leavingReasonSingleFieldset').setVisible(true);
							frm.down('#RequestReason').setVisible(true);
							frm.down('#RequestReason').setDisabled(false);
						}
						
                        Ext.defer(function () {
                            if (!frm.up().down('#authorizeDeclarationId').isVisible()) {
                                frm.up().down('#authorizeDeclarationDetails').setVisible(false);
                            }
                            if (!frm.up().down('#upToDateDetailsId').isVisible()) {
                                frm.up().down('#upToDateDetailsDetails').setVisible(false);
                            }
                            if (!frm.up().down('#studentApplyId').isVisible()) {
                                frm.up().down('#forStudentsApplyingDetails').setVisible(false);
                            }
                            if (!frm.up().down('#studentDeclarationId').isVisible()) {
                                frm.up().down('#studentDeclarationDetails').setVisible(false);
                            }
                            if (me.getCurrentLoggedPortalId() == '1') frm.up().down('#studentHyperLink').setVisible(true);
                            frm.up().down('#withdrawDateId').setVisible(false);
                        }, 500)
                    } else if (frm.up('leaveofabsencerequestform')) {
                        var me = this;
                        Ext.defer(function () {
                            if (me.getCurrentLoggedPortalId() == '1') frm.up().down('#studentHyperLink').setVisible(true);
                            frm.up().down('#withdrawDateId').setVisible(false);
                        }, 500);
                        this.addLeavingReasonFields(1, frm, false);
                    }else if (frm.up('studenttransferrequestdetailspanel')) {
                        var me = this;
                        frm.down('#RequestReason').setVisible(false);
                        frm.down('#RequestReason').setDisabled(true);
                        var isMultipleReasonsRequired = me.getMultipleReasonsRequired();
						frm.down('#leavingReasonsFieldset').setVisible(false);
						frm.down('#leavingReasonSingleFieldset').setVisible(false);
						
						if(isMultipleReasonsRequired){
							frm.down('#leavingReasonsFieldset').setVisible(true);
							frm.down('#reasonForLeavingItemId').setDisabled(true);
							frm.down('#reasonForLeavingItemId').setVisible(false);
							this.addLeavingReasonFields(1, frm, false);
						}
						else{
							frm.down('#leavingReasonSingleFieldset').setVisible(true);
							frm.down('#RequestReason').setVisible(true);
							frm.down('#RequestReason').setDisabled(false);
							frm.down('#reasonForLeavingItemId').setDisabled(false);
							frm.down('#reasonForLeavingItemId').setVisible(true);
							this.addReasonComboStore(frm);
						}
						Ext.defer(function () {
                            if (!frm.up().down('#authorizeDeclarationId').isVisible()) {
                                frm.up().down('#authorizeDeclarationDetails').setVisible(false);
                            }
                            if (!frm.up().down('#upToDateDetailsId').isVisible()) {
                                frm.up().down('#upToDateDetailsDetails').setVisible(false);
                            }
                            if (!frm.up().down('#studentApplyId').isVisible()) {
                                frm.up().down('#forStudentsApplyingDetails').setVisible(false);
                            }
                            if (!frm.up().down('#studentDeclarationId').isVisible()) {
                                frm.up().down('#studentDeclarationDetails').setVisible(false);
                            }
                            if (me.getCurrentLoggedPortalId() == '1') frm.up().down('#studentHyperLink').setVisible(true);
                        }, 500)
                        //this.addLeavingReasonFields(1, frm, false);
                    }else if (frm.up('exchangesemesterrequestdetailspanel')) {
                        var me = this;
                        Ext.defer(function () {
                            if (me.getCurrentLoggedPortalId() == '1') frm.up().down('#studentHyperLink').setVisible(true);
                        }, 500);
                        //this.addLeavingReasonFields(1, frm, false);
                    }
                    
                    else if (frm.up('exchangesemesterrequestdetailspanel')) {
                        var me = this;
                        Ext.defer(function () {
                        	if (!frm.up().down('#studentDeclarationId').isVisible()) {
                        		frm.up().down('#studentDeclarationDetails').setVisible(false);
                        	}

                        	if (!frm.up().down('#studentApplyId').isVisible()) {
                        		frm.up().down('#forStudentsApplyingDetails').setVisible(false);
                        	}
                        	if (!frm.up().down('#authorizeDeclarationId').isVisible()) {
                        		frm.up().down('#authorizeDeclarationDetails').setVisible(false);
                        	}
                        }, 500);
                    }
                }
            },
            'basicdetails button[action=addLeavingReason]': {
                click: function (btn) {
                    this.addLeavingReason(btn);
                }
            },
			'basicdetails datefield[itemId=RequestDate]': {
			    change: function (btn) {
					var me = this;
				    var serviceRequestForm = me.getContentPanelActiveTab();
					var requestDate=btn.getValue();
					var form = serviceRequestForm.down('form');
					var termEndDate = form.down('#termEndDateItemId');
					var dateOfTransfer = form.down('#dateOfTransferItemId');
					var newDate = Ext.Date.add(requestDate, Ext.Date.MONTH, 3);
					if(!isNullOrEmpty(dateOfTransfer)){
						dateOfTransfer.setValue(dateFormatRender(newDate));
					}
					setTimeout(function () {
						if(!isNullOrEmpty(termEndDate) && termEndDate.isVisible()){
							termEndDate.setValue(dateFormatRender(newDate));
						 }
					   }, 1000);
			     }
			 },
            'basicdetails button[action=deleteLeavingReason]': {
                click: function (btn) {
                    this.deleteLeavingReason(btn);
                }
            },
            'debarmentform button[action=addLeavingReason]': {
                click: function (btn) {
                    this.addLeavingReason(btn);
                }
            },
            'debarmentform button[action=deleteLeavingReason]': {
                click: function (btn) {
                    this.deleteLeavingReason(btn);
                }
            },
            'freeformrequestdetailspanel': {
                beforerender: this.toggleBasicDetailsFormItems
            },
            'applyforplacementdetailspanel': {
                beforerender: this.togglePlacementFormItems
            },
            'certificaterequestdetailspanel combo[itemId=certificateCategoryItemId]': {
                select: function (combo, newValue) {
                    this.loadCertificateType(combo, newValue[0].get('value'));
                }
            },
            'certificaterequestdetailspanel combo[itemId=certificateRequestCertificateTypesId]': {
                select: function (combo, records) {
                    this.getCertificateServiceRequestSettings(combo, records[0].get('id'));
                }
            },
            'certificaterequestdetailspanel #btnSaveRequestDetails': {
                click: this.saveCertificateRequest
            },
            'certificaterequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'employeeleaverequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'requestdetailspanel button[itemId=scholarshipSubmitBtn]': {
                click: this.saveScholarshipRequest
            },
            'requestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'requestdetailspanel #scholarshipId': {
                render: function (combo) {
                    combo.getStore().load();
                },
                select: function (combo) {
                    this.setAmount(combo);
                }
            },
            'freeformrequestdetailspanel #freeFormSubmitBtn': {
                click: this.saveFreeFormRequest
            },
            'leaverequestdetailspanel button[itemId=leaveSubmitBtn]': {
                click: this.saveLeaveServiceRequest
            },
            'leaverequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'programrequestdetailspanel button[itemId=programSubmitBtn]': {
                click: this.saveProgramTransferServiceRequest
            },
            'programrequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'withdrawfromprogramdetailspanel': {
                afterrender: this.setProgramAsReadOnly,
                validitychange: function (cmp, valid) {
                    if (valid) {
                    	var panel = cmp.owner;
                    	var cnfrmField = panel.down('#confirmationId');
                        var isMandatory1 = cnfrmField.isMandatory;
                        if (isMandatory1 == "true") {
                            if (cnfrmField.checked && panel.isValid() && cnfrmField.isVisible()) {
                            	panel.down('#programWithdrawSubmitBtn').setDisabled(false);
                            } else if(cnfrmField.isVisible()==false && panel.isValid()){
                            	panel.down('#programWithdrawSubmitBtn').setDisabled(false);
                            }
                            else
                            {
                            	panel.down('#programWithdrawSubmitBtn').setDisabled(true);
                           	}
                        }else if(panel.isValid()){
                        	panel.down('#programWithdrawSubmitBtn').setDisabled(false);
                        }
                        else{
                        	panel.down('#programWithdrawSubmitBtn').setDisabled(true);
                        }   
                        }
                     else {
                        return false;
                    }
                }
            },
            'withdrawfromprogramdetailspanel button[itemId=programWithdrawSubmitBtn]': {
                click: this.saveWithdrawProgramServiceRequest
            },
            'withdrawfromprogramdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'withdrawfromcoursedetailspanel button[itemId=withdrawFromCourseSubmitBtn]': {
                click: this.saveWithdrawCourseServiceRequest
            },
            'withdrawfromcoursedetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'courserequestdetailspanel button[itemId=courseSubmitBtn]': {
                click: this.saveCourseTransferServiceRequest
            },
            'courserequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'debarmentform button[itemId=btnSaveDebarment]': {
                click: this.saveStudentDebarmentServiceRequest
            },
            'debarmentform #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'terminationform': {
                afterrender: function (frm) {
                    this.addTerminationReasonFields(1, frm, false);
                    var terminationReason = frm.getForm().findField('terminationReasonId');
                    var terminationReasonStore = terminationReason.getStore();
                    var academyLocationId = this.getCurrentAcademyLocation();
                    terminationReasonStore.getProxy().extraParams = {
                    	academyLocationId: academyLocationId
                    };
                    terminationReasonStore.load();
                }
            },
            'terminationform button[action=addTerminationReason]': {
                click: function (btn) {
                    this.addTerminationReason(btn);
                }
            },
            'terminationform button[action=deleteTerminationReason]': {
                click: function (btn) {
                    this.deleteTerminationReason(btn);
                }
            },
            'terminationform button[itemId=terminationSubmitBtn]': {
                click: this.saveStudentTerminationServiceRequest
            },
            'terminationform combo[itemId=terminationProgramId]': {
                render: this.loadTerminationProgramCombo
            },
            'terminationform #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'transferform button[itemId=btnSaveTransfer]': {
                click: this.saveStudentTransferServiceRequest
            },
            'transferform #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'applyforplacementdetailspanel button[itemId=placementSubmitBtn]': {
                click: this.saveApplyForPlacementServiceRequest
            },
            'applyforplacementdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'complaintdetailsform #withdrawButtonId': {
                click: function (button) {
                    this.withdrawComplaintRequest(button);
                }
            },
            'findrequestform button[itemId=clearSearch]': {
                click: this.clearSearchForm
            },
            'hostelleaverequestdetailspanel #btnSaveRequestDetails': {
                click: this.saveHostelLeaveRequest
            },
            'hostelleaverequestdetailspanel #enddateItemId': {
                select: function (obj) {
                    var $this = this;
                    var activeTab = $this.getContentPanelActiveTab();
                    var hostelleaverequestdetailspanel = activeTab.down('hostelleaverequestdetailspanel');
                    var ToTimeItemId = hostelleaverequestdetailspanel.down('#toTimeItemId');
                    var fromTime = hostelleaverequestdetailspanel.down('#startTimeItemId');
                    var frm = this.getHostelleaverequestdetailspanel();
                    var startDate = dateRender(frm.down('#startDate').getValue());
                    var endDate = dateRender(frm.down('#enddateItemId').getValue());
                    if (!isNullOrEmpty(endDate) && !isNullOrEmpty(startDate) && startDate === endDate && !isNullOrEmpty(fromTime.getValue())) {
                        var newTime = Ext.Date.add(fromTime.getValue(), Ext.Date.MINUTE, 15);
                        ToTimeItemId.setMinValue(newTime);
                    } else {
                        ToTimeItemId.setMinValue(null);
                    }
                }
            },
            'hostelleaverequestdetailspanel #startDate': {
                change: function () {
                    var frm = this.getHostelleaverequestdetailspanel();
                    var startDate = frm.down('#startDate');
                    var enddateItemId = frm.down('#enddateItemId');
                    var endDate = dateRender(frm.down('#enddateItemId').getValue());
                    var startDateRendered = dateRender(frm.down('#startDate').getValue());
                    var leaveTypeItemId = frm.down('#leaveType');
                    leaveTypeItemId.reset();
                    var paramLeaveType = null;
                    var fromTime = frm.down('#startTimeItemId');
                    var ToTimeItemId = frm.down('#toTimeItemId');
                    if (!isNullOrEmpty(endDate) && !isNullOrEmpty(startDateRendered) && startDateRendered === endDate && !isNullOrEmpty(fromTime.getValue())) {
                        var newTime = Ext.Date.add(fromTime.getValue(), Ext.Date.MINUTE, 15);
                        ToTimeItemId.setMinValue(newTime);
                    } else {
                        ToTimeItemId.setMinValue(null);
                    }
                    if (!isNullOrEmpty(startDate.getValue())) {
                        var getBirthYear = startDate.getValue().getFullYear();
                        var enddate = new Date(startDate.getValue());
	  				  // joinDate.setFullYear(getBirthYear + 18);
                        enddateItemId.setMinValue(enddate);
                        enddateItemId.validate();
                        if (dateRender(startDate.getValue()) == dateRender(new Date())) {
                            paramLeaveType = true;
                        }
                        leaveTypeItemId.getStore().getProxy().extraParams = {
                            isEmergency: paramLeaveType
                        };
                        leaveTypeItemId.getStore().load();
                    }
                }
            },
            'hostelleaverequestdetailspanel #startTimeItemId': {
                select: function (obj) {
                    var frm = this.getHostelleaverequestdetailspanel();
                    var startDate = dateRender(frm.down('#startDate').getValue());
                    var startTime = frm.down('#startTimeItemId').getValue();
                    var leaveTypeItemId = frm.down('#leaveType');
                    var endDate = dateRender(frm.down('#enddateItemId').getValue());
                    var ToTimeItemId = frm.down('#toTimeItemId');
                    leaveTypeItemId.reset();
                    var paramLeaveType = null;
                    if (!isNullOrEmpty(endDate) && !isNullOrEmpty(startDate) && startDate === endDate && !isNullOrEmpty(startTime)) {
                        var newTime = Ext.Date.add(startTime, Ext.Date.MINUTE, 15);
                        ToTimeItemId.setMinValue(newTime);
                    }
                    var date = new Date();
                    var dateIncremented = dateRender(date.setDate(date.getDate() + 1));
                    var timeIncremented = timeRender(date.getTime() + 24);
                    if ((startDate == dateIncremented) || (startDate == dateRender(new Date()))) {
                        if ((startTime <= timeIncremented) || (startDate == dateRender(new Date()))) {
                            paramLeaveType = true;
                        }
                    }
                    leaveTypeItemId.getStore().getProxy().extraParams = {
                        isEmergency: paramLeaveType
                    };
                    leaveTypeItemId.getStore().load();
                }
            },
            'findrequestform radiogroup[itemId=requestFor]': {
                change: function (radioGroup) {
                    var this$ = this;
                    var form = this.getFindRequestForm();
                    var requestGroup = form.down('#requestFor');
                    var requestValue = requestGroup.getValue();
                    form.down('#request_id').reset();
                    form.down('#selectedNameField').reset();
                    form.down('#student_id').reset();
                    form.down('#requester_type').reset();
                    form.down('#assigneeId').reset();
                    form.down('#status').reset();
                    form.down('#selectedName').reset();
                    form.down('#beyond_SLA').reset();
                    form.down('#from_date').reset();
                    form.down('#till_date').reset();
                    var requestTypeField = form.down('#requestTypeFieldContainer');
                    var requestType = requestTypeField.down('#requestSubCategoryField');
                    var certificateCategory = requestTypeField.down('#certificateCategoryField');
                    var certificateType = requestTypeField.down('#certificateSubCategoryField');
                    var generalCategory = requestTypeField.down('#freeFormCategoryField');
                    var generalType = requestTypeField.down('#freeFormSubCategoryField');
                    form.down('#requestTypeField').reset();;
                    certificateCategory.setVisible(false);
                    certificateCategory.reset();
                    certificateType.setVisible(false);
                    certificateType.reset();
                    generalCategory.setVisible(false);
                    generalCategory.reset();
                    generalType.setVisible(false);
                    generalType.reset();
                    requestType.setVisible(false);
                    requestType.reset();
                    form.down('#autoFollowupCheck').reset();
                    form.down('#autoFollowupCheck').setVisible(true);
                    if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
                        form.down('#autoFollowupCheck').setVisible(false);
                    }
                    if (!isNullOrEmpty(requestValue) && requestValue.requestFor == 'MY_REQUESTS') {
                        var assignedTo = form.down('#assigneeId');
                        assignedTo.setDisabled(true);
                        assignedTo.getStore().load({
                            callback: function (records, operation, success) {
                                assignedTo.setValue(this$.getCurrentlyLoggedInUser().id)
                            }
                        })
                    } else {
                        form.down('#assigneeId').setDisabled(false);
                    }
                    if (!isNullOrEmpty(requestValue) && requestValue.requestFor == 'TRANSFER_IN_REQUESTS') {
                        form.down('#transferringOutAL').setVisible(true);
                        form.down('#transferringOutAL').getStore().load();
                        form.down('#autoFollowupCheck').setVisible(false);
                    } else {
                        form.down('#transferringOutAL').setVisible(false);
                    }
                    this.loadStudentGridAndSearchRequest();
                }
            },
            'facultyfindrequestform button[itemId= facultyClearSearch]': {
                click: this.clearSearchForm
            },
            'trackrequestpanel studentrequesttransferingrid': {
                cellclick: function (grid, td, cellIndex, record) {
                    var columnName = grid.up('grid').columnManager.columns[cellIndex].dataIndex;
                    if (columnName === "requestId") {
                        var me = this;
                        var requestId = record.get('id');
                        var requestType = record.data.SERVICE_REQUEST_TYPE;
                        me.setRequestData(requestId, record, requestType);
                    }
                }
            },
            'trackrequestpanel studentportalstudentrequestgrid': {
                cellclick: function (grid, td, cellIndex, record) {
                    var columnName = grid.up('grid').columnManager.columns[cellIndex].dataIndex;
                    if (columnName === "requestId") {
                        var me = this;
                        var requestId = record.get('id');
                        var requestType = record.data.SERVICE_REQUEST_TYPE;
                        me.setRequestData(requestId, record, requestType);
                    }
                    if (columnName === "applicationForm") {
                    	  var me = this;
                        var rec = record.get("documentStrId");
                        me.getDocumentController().downloadDocumentFile(rec)
                    }
                    if (columnName === "approvalLetter") {
                    	  var me = this;
                        var rec = record.get("approvalLetterStrId");
                        me.getDocumentController().downloadDocumentFile(rec)
                    }
                }
            },
            'trackrequestpanel searchresultgrid[itemId=trackRequestGrid]': {
                cellclick: function (grid, td, cellIndex, record) {
                    var searchResultGrid = this.getStudentSearchResultGrid();
                    this.cellclickTrackRequestGrid(searchResultGrid, cellIndex, record);
                },
                afterrender: function (grid) {
                	var me=this;
                    grid.setTitle(getServiceRequestTranslation('ALL_REQUEST'));
                    var viewButton = grid.down("#searchResultGridBtnView");
                    viewButton.setVisible(false);
                    me.addDataGridConfigButton(grid,this.getCOREERP_REQUEST_PERMISSIONS());
                    this.loadStudentGridAndSearchRequest();  //need to execute this method after customTopPagingToolBar has been added in grid othrewise more hyperlink will not show.
                },
                render: function (grid) {
					var form = grid.up().down('form');
                    this.gridRenderFunction(grid);
                    this.gridRenderFunctionForCancelRequest(grid);
                    this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_REQUEST_PERMISSIONS());
                    if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
                        this.gridRenderRaiseRequestBtn(grid);
                        this.disableMoreActionPivileges(grid, this.getSTUDENT_REQUEST_PERMISSIONS());
                        this.disableCancelBtnPivileges(grid, this.getSTUDENT_REQUEST_PERMISSIONS());
                    }
                    if (this.getCurrentLoggedPortalId() == 7) {
                        this.genericCBGridAccessControlValidation(grid, this.getPARENT_REQUEST_PERMISSIONS());
                        this.disableMoreActionPivileges(grid, this.getPARENT_REQUEST_PERMISSIONS());
                        this.disableCancelBtnPivileges(grid, this.getPARENT_REQUEST_PERMISSIONS());
                        grid.down('#uploadDocumentBtn').setVisible(true);
                    }
                    if (this.getCurrentLoggedPortalId() == 1) {
                        this.disableCancelBtnPivileges(grid, this.getCOREERP_REQUEST_PERMISSIONS());
                    }
                    if (this.getCurrentLoggedPortalId() == 1) {
                        this.disableQuickCommentBtnPivileges(grid, this.getCOREERP_REQUEST_PERMISSIONS());
                    }
                    setTimeout(function () {
                        if (portalId == 1) {
						var isAutoFollowUpChecked = form.down('#autoFollowupCheck').getValue();
							if(isAutoFollowUpChecked){
                            grid.down('#approveBtnRequestId').show();
                            grid.down('#rejectBtnRequestId').show();
                            grid.down('#moreActionBtnRequestId').show();
							}
						}
                    }, 200);
                },
                selectionchange: function (column, selected, eOpts) {
                    var grid = this.getStudentSearchResultGrid();
                    this.enableDisableCancelRequestBtn(column, selected, grid);
                    this.enableDisableOtherBtns(column, selected);
                    this.enableDisableReAssignRequestBtn(column, selected);
                    this.enableDisableQuickCommentBtn(column, selected,grid);
                }
            },
            'trackrequestpanel searchresultgrid[itemId=trackRequestGrid] button#quickCommentId': { 
            	 click: function (button) {
                    this.openQuickComment(button);
                }
            },
            'studentportalstudentrequestgrid': {
                selectionchange: function (column, selected, eOpts) {
                    var grid = this.getStudentportalstudentrequestgrid();
                    this.enableDisableCancelRequestBtn(column, selected, grid);
                    this.enableDisableQuickCommentToStudentBtn(column, selected,grid);
                },
                render: function (grid) {
                    if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
                        this.disableMoreActionPivileges(grid, this.getSTUDENT_REQUEST_PERMISSIONS());
                    }
                    if (this.getCurrentLoggedPortalId() == 3) {
                        this.disableQuickCommentBtnPivilegesToStudent(grid, this.getSTUDENT_REQUEST_PERMISSIONS());
                    }
                },
               /* afterrender:function(grid){
                	var me =this;
                	setTimeout(function(){
                		if (me.getCurrentLoggedPortalId() == 3) {
                			me.addDataGridConfigButton(grid,me.getSTUDENT_REQUEST_PERMISSIONS());
                		}
                	},1500);
                },*/
            },
            'studentportalstudentrequestgrid button#quickCommentToStudentId':{
            	click: function (button) {
                    this.openQuickComment(button); 
                }
            },
            'advancedsearchquerybuilder[itemId=advanceSearchStudentTrackRequest] searchresultgrid[itemId=userAdvSearchResultGrid]': {
                cellclick: function (grid, td, cellIndex, record) {
                    var searchResultGrid = this.getStudentSearchResultGrid();
                    this.cellclickTrackRequestGrid(searchResultGrid, cellIndex, record);
                },
                render: function (grid) {
                    this.gridRenderFunction(grid);
                    this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_REQUEST_PERMISSIONS());
                    var viewButton = grid.down("#searchResultGridBtnView");
                    if (!isNullOrEmpty(viewButton)) {
                        viewButton.setVisible(false);
                    }
                }
            },
//            'facultytrackrequestpanel searchresultgrid[itemId=facultytrackRequestGrid] button#quickCommentToStudentId': { 
//            	click: function (button) {
//                    this.openQuickComment(button);
//                }
//            },
            'facultytrackrequestpanel studentportalstudentrequestgrid button#quickCommentStudentId': { 
            	click: function (button) {
                    this.openQuickComment(button);
                }
            },
            'facultytrackrequestpanel searchresultgrid[itemId=facultytrackRequestGrid] button#quickCommentToFacultyId': { 
            	click: function (button) {
                    this.openQuickComment(button);
                }
            },
            'facultytrackrequestpanel searchresultgrid[itemId=facultytrackRequestGrid]': {
                cellclick: function (grid, td, cellIndex, record) {
                    var searchResultGrid = this.getFacultySearchResultGrid();
                    this.cellclickTrackRequestGrid(searchResultGrid, cellIndex, record);
                },
                afterrender: function (grid) {
                    var $this = this;
                    var viewButton = grid.down("#searchResultGridBtnView");
                    viewButton.setVisible(false);
                    if (this.getCurrentLoggedPortalId() == 2) {
                        this.getFacultytrackrequestpanel().setAutoScroll(false);
                    }
                    Ext.defer(function () {
                        var portalId = $this.getCurrentLoggedPortalId();
                        if (portalId == 2 && grid.columnManager.columns) {
                            for (var i = grid.columnManager.columns.length - 1; i >= 0; i--) {
                                var column = grid.columnManager.columns[i];
                                if (column.dataIndex == 'REQUEST_ASSIGNED_TO') {
                                    column.hide();
                                }
                            }
                        }
                    }, 1000, $this);
                    grid.up('facultytrackrequestpanel').setAutoScroll(true);
                    $this.loadFacultyGridAndSearchRequest();
                    $this.disableQuickCommentBtnPivilegesToFaculty(grid, $this.getFACULTY_REQUEST_PERMISSIONS());
                },
                render: function (grid) {
                    this.gridRenderFunction(grid);
                    this.genericCBGridAccessControlValidation(grid, this.getFACULTY_REQUEST_PERMISSIONS());
                    if (this.getCurrentLoggedPortalId() == 2) {
                        this.gridRenderRaiseRequestBtn(grid);
                        this.disableMoreActionPivileges(grid, this.getFACULTY_REQUEST_PERMISSIONS());                        
                        this.gridRenderQuickCommentBtn(grid);
                    }
                },
                selectionchange: function (column, selected, eOpts) {
                    this.enableDisableQuickCommentToFacultyBtn(column, selected,grid);
                }
            },
            /** Export Button for Student** */
            'searchresultgrid[itemId=trackRequestGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
                click: function () {
                    this.exportRequest(SERVERURL.PDFEXPORT, 'pdf', false, 'STUDENT');
                }
            },
            'searchresultgrid[itemId=trackRequestGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
                click: function () {
                    this.exportRequest(SERVERURL.PDFEXPORT, 'pdf', true, 'STUDENT');
                }
            },
            'searchresultgrid[itemId=trackRequestGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
                click: function () {
                    this.exportRequest(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', false, 'STUDENT');
                }
            },
            'searchresultgrid[itemId=trackRequestGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
                click: function () {
                    this.exportRequest(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', true, 'STUDENT');
                }
            },
            /** Export Button for Faculty** */
            'searchresultgrid[itemId=facultytrackRequestGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
                click: function () {
                    this.exportRequest(SERVERURL.PDFEXPORT, 'pdf', false, 'FACULTY');
                }
            },
            'searchresultgrid[itemId=facultytrackRequestGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
                click: function () {
                    this.exportRequest(SERVERURL.PDFEXPORT, 'pdf', true, 'FACULTY');
                }
            },
            'searchresultgrid[itemId=facultytrackRequestGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
                click: function () {
                    this.exportRequest(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', false, 'FACULTY');
                }
            },
            'searchresultgrid[itemId=facultytrackRequestGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
                click: function () {
                    this.exportRequest(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', true, 'FACULTY');
                }
            },
            /* follow up details */
            'followupdetailspanel button[itemId=followUpBtn]': {
                click: this.showFollowUpDetailsForm
            },
            'complaintfollowupdetailspanel button[itemId=ComplaintfollowUpBtn]': {
                click: this.showComplaintFollowUpDetailsForm
            },
            'followupdetailspopupwindow button[itemId=followUpDetailsSubmitButtonId]': {
                click: this.submitFollowUpDetailsForm
            },
            'followupdetailspopupwindow customcombobox[itemId=academyLocationItemId]': {
                select: this.blankAssignee
            },
            'complaintfollowuppopup button[itemId=complaintFollowUpDetailsSubmitButtonId]': {
                click: this.submitFollowUpDetailsForm
            },
            'followupdetailspopupwindow button[itemId=followUpDetailsCancelButtonId]': {
                click: this.cancelFollowUpDetailsForm
            },
            'complaintfollowuppopup button[itemId=followUpDetailsCancelButtonId]': {
                click: this.cancelComplaintFollowUpDetailsForm
            },
            'followupdetailspopupwindow #isOriginalRadio': {
                change: function (radio, newValue, oldValue) {
                    this.hideShowPanel(radio, newValue);
                }
            },
            'complaintfollowuppopup #isApprovalRadio': {
                change: function (radio, newValue, oldValue) {
                    this.hideShowFields(radio, newValue);
                }
            },
            'followupdetailspopupwindow combo[itemId=documentProof]': {
                select: this.hideRadioPanel
            },
            'followupdetailspopupwindow combo[itemId=followUpStatus]': {
                render: this.loadComboStore
            },
            'complaintfollowuppopup combo[itemId=complaintFollowUpStatus]': {
                render: this.loadComplaintComboStore
            },
            // Approval details
            'approvaldetailspanel button[itemId=escalateBtn]': {
                click: this.showEscalateDetailsForm
            },
            'approvaldetailspanel #approveBtn': {
                click: function (button) {
                    this.approveRequest(button);
                }
            },
            'approvaldetailspanel #rejectBtn': {
                click: function (button) {
                    this.rejectRequest(button);
                }
            },
            'escalatedetailspopupwindow button[itemId=approvalDetailsSubmitButtonId]': {
                click: function (button) {
                    this.EscalateRequest(button);
                }
            },
            'escalatedetailspopupwindow button[itemId=approvalDetailsCancelButtonId]': {
                click: this.cancelEscalateDetailsForm
            },
            'certificaterequestdetailspanel #isOriginalRadio': {
                change: function (radio, newValue, oldValue) {
                    this.toggleTextField(radio, newValue);
                }
            },
            /* Execution Details */
            'executiondetailspanel button[itemId=executionSubmitBtn]': {
                click: function (form) {
                    this.submitExecutionDetailsForm(form)
                }
            }, /* Execution Details */
            'executiondetailspanel multiselectcombofield[itemId=readmissionOutcomeIds]': {
                select: function (cmp) {
                   cmp.getStore().extraParams.readmissionOutcomeIds = Ext.Array.pluck(Ext.Array.pluck(cmp.getValue(), 'data'), 'id').join()
                   
                }
            },
            'certificateexecutiondetailspanel button[itemId=certificateSubmitBtn]': {
                click: function (form) {
                    this.submitExecutionDetailsForm(form)
                }
            },
            'certificateexecutiondetailspanel button[itemId=printSubmitBtn]': {
                click: this.printCertificate
            },
            'certificateexecutiondetailspanel datefield[itemId=executionDateId]': {
                focus: this.validateHandoverDate
            },
            /*
             * search result grid for student & faculty
             * Track REquest
             */
            'findrequestform button[itemId=findButtonId]': {
                click: this.loadStudentGridAndSearchRequest
            },
            'findrequestform': {
                render: function () {
                    var $this = this;
                    var form = $this.getFindRequestForm();
            		var itemIdPrivilegeNameArray = [{"#requestFor" : "ALL_REQUEST" }];
                    var academyLocationId = this.getCurrentAcademyLocation();
                    var associatedAcadLocationIds = new Array();
                    associatedAcadLocationIds.push(academyLocationId);
                    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_REQUEST_PERMISSIONS());
                    for (index in itemIdPrivilegeNameArray) {
                        var radioGroupItemId = itemIdPrivilegeNameArray[index].radioGroupItemId;
                        if (!isNullOrEmpty(radioGroupItemId)) {
                            var isRadioGroupHidden = false;
                            var isDefaultPrivilege = false;
                            form.down(radioGroupItemId).setVisible(false);
                            for (itemId in itemIdPrivilegeNameArray[index]) {
                                if (itemId != 'defaultButtonItemId' && itemId != 'radioGroupItemId') {
                                    if ((Ext.Array.contains(permissionList, itemIdPrivilegeNameArray[index][itemId]))) {
                                        if (itemIdPrivilegeNameArray[index].defaultButtonItemId == itemId) {
                                            form.down(itemId).setValue(true);
                                            isDefaultPrivilege = true;
                                        } else if (isDefaultPrivilege == false) {
                                            form.down(itemId).setValue(true);
                                        }
                                    } else {
                                        isRadioGroupHidden = true;
                                    }
                                }
                            }
                            if (isRadioGroupHidden == false) {
                                form.down(radioGroupItemId).setVisible(true);
                            }
                        } else {
                            for (itemId in itemIdPrivilegeNameArray[index]) {
                                form.down(itemId).setVisible(false);
                                if ((Ext.Array.contains(permissionList, itemIdPrivilegeNameArray[index][itemId]))) {
                                    form.down(itemId).setVisible(true);
                                }
                            }
                        }
                    }
                    var requestRadioField = form.down("#requestFor");
                    form.config.isPermissionGiven = false;
                    form.config.isTransferInRequestPermissionGiven = false;
                    Ext.each(permissionList, function (privilege) {
                        if (privilege === 'ALL_REQUEST') {
                            form.config.isPermissionGiven = true;
                        }
                        if (privilege === "TRANSFER_IN_REQUESTS") {
                            form.config.isTransferInRequestPermissionGiven = true;
                        }
                    });
                },
                afterrender: function (form) {
                    if (!form.config.isPermissionGiven) {
                        var this$ = this;
                        var form = this.getFindRequestForm();
                        var requestGroup = form.down('#requestFor');
                        var requestValue = requestGroup.setValue('MY_REQUESTS');
                        form.down('#request_id').reset();
                        form.down('#selectedNameField').reset();
                        form.down('#student_id').reset();
                        form.down('#requester_type').reset();
                        form.down('#assigneeId').reset();
                        form.down('#status').reset();
                        form.down('#selectedName').reset();
                        form.down('#beyond_SLA').reset();
                        form.down('#from_date').reset();
                        form.down('#till_date').reset();
                        var requestTypeField = form.down('#requestTypeFieldContainer');
                        var requestType = requestTypeField.down('#requestSubCategoryField');
                        var certificateCategory = requestTypeField.down('#certificateCategoryField');
                        var certificateType = requestTypeField.down('#certificateSubCategoryField');
                        var generalCategory = requestTypeField.down('#freeFormCategoryField');
                        var generalType = requestTypeField.down('#freeFormSubCategoryField');
                        form.down('#requestTypeField').reset();;
                        certificateCategory.setVisible(false);
                        certificateCategory.reset();
                        certificateType.setVisible(false);
                        certificateType.reset();
                        generalCategory.setVisible(false);
                        generalCategory.reset();
                        generalType.setVisible(false);
                        generalType.reset();
                        requestType.setVisible(false);
                        requestType.reset();
                        var assignedTo = form.down('#assigneeId');
                        assignedTo.setDisabled(true);
                        assignedTo.getStore().load({
                            callback: function (records, operation, success) {
                                assignedTo.setValue(this$.getCurrentlyLoggedInUser().id)
                            }
                        })
                    }
                    if (form.config.isTransferInRequestPermissionGiven && form.config.isTransferInRequestPermissionGiven == true) {
                        form.down('#transferInRequests').setVisible(true);
                    } else {
                        form.down('#transferInRequests').setVisible(false);
                    }
                   this.loadStudentGridAndSearchRequest();
            		/**
            		 * Load by default request name and
            		 * first name at the time of student
            		 * logged in
            		 */
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_AUTO_FOLLOW_SETTING_DROP_DOWN,
                        params: {
                         
                        },
                        method: 'GET',
                        success: function (response) {
                        	if(!isNullOrEmpty(response.responseText)){
                        		var data = Ext.decode(response.responseText);
                        		if(data && data.length){
                        			if (data[0].value !=undefined && data[0].value=="Yes"){
                        				form.down('#autoFollowupCheck').setValue(true) ;
                        			}else{
                        				form.down('#autoFollowupCheck').setValue(false) ;
                        			}
                        		}
                        	}
                        	 
                        
                        }
                    });
                    
                    if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
                        this.getTrackRequestPanel().setAutoScroll(false);
                        var student = this.getCurrentlyLoggedInUserInfoForPortal().student;
                        var form = this.getFindRequestForm();
                        var getForm = form.getForm();
                        getForm.findField('selectedNameField').setReadOnly(true);
                        getForm.findField('REQUEST_ID').setReadOnly(false);
                        var REQUESTER_FIRSTNAMEField = getForm.findField('REQUESTER_FIRSTNAME');
                        REQUESTER_FIRSTNAMEField.setValue(student.firstName);
                        REQUESTER_FIRSTNAMEField.setReadOnly(true);
                        var requestField = form.down("#requester_type");
                        var selectName = form.down("#selectedName").setVisible(false);
                        var firstName = form.down("#selectedNameField").setVisible(false);
                        form.down("#beyond_SLA").setVisible(false);
                        var reuestFieldStore = form.down("#requester_type").getStore();
                        selectName.setVisible(false);
                        firstName.setVisible(false);
                        form.down('#assigneeId').setVisible(false);
                        form.down('#request_id').setVisible(true);
                        form.down('#student_id').setVisible(false);
                        form.down('#status').setVisible(true);
                        form.down('#autoFollowupCheck').setVisible(false);
                        requestField.store.load({
                            callback: function (records, operation, success) {
                                if (success) {
                                    requestField.setValue(reuestFieldStore.data.items[1].data.id);
                                    requestField.setVisible(false);
                                }
                            }
                        });
                    }
                }
            },
            'requestsubrequesttypefieldcontainer': {
                beforerender: this.changeServiceRequestStore
            },
            'facultyfindrequestform button[itemId=facultyFindButtonId]': {
                click: this.loadFacultyGridAndSearchRequest
            },
            /* Free Form ServiceREquest Details */
            'freeformrequestdetailspanel combo[itemId=subRequestType]': {
                select: this.getFreeFormRequestSettings
            },
            'freeformrequestdetailspanel combo[itemId=freeFormRequestType]': {
                select: this.loadSubRequestComboStore,
                afterrender: function(freeFormRequestType){
                	var me = this;
                	
                	var subRequestTypeField = freeFormRequestType.up().down('#subRequestType');
                	if(this.getContentPanelActiveTab().getResponseData() && this.getContentPanelActiveTab().getResponseData().detail){
                		var recordsData =this.getContentPanelActiveTab().getResponseData();
                		var categoryId = recordsData.detail.freeFormRequestCategoryId;
                    	var subcategoryId = recordsData.detail.freeFormRequestTypeId;
                    	if(recordsData.serviceRequestSetting.serviceRequestProgramGroupConfig && recordsData.serviceRequestSetting.serviceRequestProgramGroupConfig[0] && recordsData.serviceRequestSetting.serviceRequestProgramGroupConfig[0].program && recordsData.serviceRequestSetting.serviceRequestProgramGroupConfig[0].program.id){
                    		this.getActiveTabfromContentPanel().setProgram(recordsData.serviceRequestSetting.serviceRequestProgramGroupConfig[0].program.id);
                    	}
                    	
                	}else{
                		var categoryId = this.getContentPanelActiveTab().config.categoryId;
                    	var subcategoryId = this.getContentPanelActiveTab().config.subcategoryId;
                	}
                	if(categoryId){
                		freeFormRequestType.getStore().load({
                    		callback: function(){
                    			if(freeFormRequestType.getStore().getCount()){
                    				freeFormRequestType.setValue(categoryId);
                    				me.loadSubRequestComboStore(freeFormRequestType);
                    				setTimeout(function(){
                        				subRequestTypeField.setValue(subcategoryId);
                        				me.getFreeFormRequestSettings(subRequestTypeField);
                    				},300);
                    			}
                    		}
                    	});
                	}
                	
                }
            },
            'programrequestdetailspanel combo[itemId=fromProgramId]': {
                render: this.loadFromProgramComboStore,
                select: this.loadFromBatchProgram
            },
            'programrequestdetailspanel combo[itemId=academicTermId]': {
                render: this.loadToProgramComboStore,
                select: this.loadBatchComboStoreForProgramTransfer
            },
            'programrequestdetailspanel combo[itemId=programGroupId]': {
                select: this.loadFromProgramByProgramGroupId
            },
            'programrequestdetailspanel combo[itemId=toProgramId]': {
                render: this.loadToProgramComboStore,
                select: this.loadBatchComboStore
            },
            'programrequestdetailspanel combo[itemId=toBatchId]': {
                select: this.loadSeatTypeComboStore
            },
            'courserequestdetailspanel combo[itemId=fromCourseId]': {
                select: this.loadToCourseComboStore
            },
            'courserequestdetailspanel combo[itemId=fromProgramId]': {
                render: this.loadFromProgramComboStore,
                select: this.loadFromCourseComboStore
            },
            'withdrawfromcoursedetailspanel combo[itemId=withdrawCourseprogramId]': {
                render: this.loadFromProgramComboStore,
                select: this.loadWithdrawCourseComboStore
            },
            'withdrawfromprogramdetailspanel combo[itemId=fromProgramId]': {
                render: this.loadFromProgramComboStore
            },
            'withdrawfromprogramdetailspanel checkboxfield[itemId=confirmationId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	/* if (cmp.up().up().down('#confirmationId').checked || !cmp.up().up().down('#confirmationId').isVisible()) {
                		 cmp.up().up().up().down('#programWithdrawSubmitBtn').setDisabled(false);
                     } else {
                    	 cmp.up().up().up().down('#programWithdrawSubmitBtn').setDisabled(true);
                     }*/
                	 

                 	var panel = cmp.up().up().up();
                 	var cnfrmField = panel.down('#confirmationId');
                     var isMandatory1 = cnfrmField.isMandatory;
                     if (isMandatory1 == "true") {
                         if (cnfrmField.checked && panel.isValid() && cnfrmField.isVisible()) {
                         	panel.down('#programWithdrawSubmitBtn').setDisabled(false);
                         } else if(cnfrmField.isVisible()==false && panel.isValid()){
                         	panel.down('#programWithdrawSubmitBtn').setDisabled(false);
                         }
                         else
                         {
                         	panel.down('#programWithdrawSubmitBtn').setDisabled(true);
                        	}
                     }else if(panel.isValid()){
                     	panel.down('#programWithdrawSubmitBtn').setDisabled(false);
                     }
                     else{
                     	panel.down('#programWithdrawSubmitBtn').setDisabled(true);
                     }   
                     
                }
            },
            'debarmentform': {
                afterrender: function (form) {
                    var me = this;
                    var debarmentForm = form;
                    var academicTermform = debarmentForm.down('#academicTermId');
                    var programField = debarmentForm.down('#programDebarmentId');
                    var academyLocationId = this.getCurrentAcademyLocation();
                    var academicFormStore = academicTermform.getStore();
                    var isServiceRequestForInActiveStudent = me.getInActiveStudentServiceRequestRequired();
					
                   
                    this.addLeavingReasonFields(1, debarmentForm, false);
                    var debarmentReason = debarmentForm.getForm().findField('leavingReasonId');
                    var debarmentReasonStore = debarmentReason.getStore();
                    debarmentReasonStore.getProxy().extraParams = {
                    	academyLocationId: academyLocationId
                    };
                  debarmentReasonStore.load();
                    
                }
            },
            'leaveofabsencerequestform combo[itemId=startAcademicTermCombo]': {
                select: this.loaAcademicTermByAcademyLocationId
            },
            'debarmentform combo[itemId=academicTermId]': {
                select: this.loaAcademicTermByPeriodDate
            },
            'debarmentform combo[itemId=programDebarmentId]': {
                render: this.loadFromProgramComboStore,
                select: this.loadDebarmentCourseComboStore
            },
            'terminationform combo[itemId=terminationProgramId]': {
                render: this.loadFromProgramComboStore
            },
            'transferform combo[itemId=transferProgramId]': {
                render: this.loadFromProgramComboStore
            },
            'studenttransferrequestdetailspanel combo[itemId=fromProgramId]': {
                render: this.loadFromProgramComboStore
            },
            'studenttransferrequestdetailspanel': {
                render: function () {
                    var basicDetailPnl = this.getBasicdetails();
                    var reasonForLeavingField = basicDetailPnl.down('#reasonForLeavingItemId');
                    var schoolLeavingToIdField = basicDetailPnl.down('#schoolLeavingToId');
                    var leavingToItemIdField = basicDetailPnl.down('#leavingToItemId');
                    
                    var studTransferPanel = this.getStudenttransferrequestdetailspanel();
                    var acadLocationTo = studTransferPanel.down('#toAcademyLocationItemId').getValue(); 
                    var academicTermField = studTransferPanel.down('#academicTermId');
                    var fromAcademicLocationField = studTransferPanel.down('#fromAcademicLocationId')
                    
                    academicTermField.reset();
                    fromAcademicLocationField.reset();
                    
                    if(this.getCurrentLoggedPortalId()==3){
                    	Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.FIND_ALL_DROPDOWN,
                            method: 'GET',
                            async: false,
                            success: function (response, action) {
                            	if(response != undefined && response.responseText !=null && !isEmpty(response.responseText)){
                            	var responseTxt = Ext.decode(response.responseText);
                            	if (responseTxt!=undefined && responseTxt.type=="IsStudentJourneyImplemented" && responseTxt.name=="true"){
                            		studTransferPanel.down('#toSeatTypeId1').setReadOnly(true);	  
                            	}else {
                            		studTransferPanel.down('#toSeatTypeId1').setReadOnly(false);
                            	}
                              }
                            }
                        });
                    }
                    
                    setTimeout(function () {
                        //reasonForLeavingField.setVisible(true);
                        reasonForLeavingField.allowBlank = true;
                        reasonForLeavingField.setFieldLabel(getServiceRequestTranslation('REASON_FOR_STUDENT_TRANSFER') + ': <span style="color:red">*</span>');
                        leavingToItemIdField.setVisible(false);
                        schoolLeavingToIdField.setVisible(false);
                        schoolLeavingToIdField.allowBlank = true;
                    }, 500);
                    
                    var isMultipleReasonsRequired = this.getMultipleReasonsRequired();
                    var isEditRequest = false;
					var activeTab = this.getContentPanelActiveTab();

					if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
						var serviceRequestId = activeTab.getServiceRequestId();
						if (!isNullOrEmpty(serviceRequestId)) {
							isEditRequest = true;
						}
					}
                  if(isMultipleReasonsRequired){
                	  var academicTermStore = academicTermField.getStore();
                      academicTermStore.getProxy().extraParams = {
                      	studentId: this.getContentPanelActiveTab().getRequesterId(),
                      	isEditRequest : isEditRequest
                      };
                      academicTermStore.load({
              			   callback: function(rec, success){
              				   if (success) {
              					   if(rec.length==1){
              						   fromAcademicLocationField.setDisabled(false);
              						   academicTermField.setValue(rec[0].get('id'));
              					   }
              				   }
              			   }
              		   });
                  }
           		 
                   
                },
                validitychange: function (cmp, valid) {
                    if (valid) {
                    	this.onStudentTransferFieldCheck();
                        /*if (this.getStudenttransferrequestdetailspanel().down('#confirmationId').checked || !this.getStudenttransferrequestdetailspanel().down('#confirmationId').isVisible()) {
                            this.getStudenttransferrequestdetailspanel().down('#studentTransferSubmitBtn').setDisabled(false);
                        } else {
                            this.getStudenttransferrequestdetailspanel().down('#studentTransferSubmitBtn').setDisabled(true);
                        }*/
                        
                    } else {
                        return false;
                    }
                }
            },
            'studenttransferrequestdetailspanel checkboxfield[itemId=confirmationId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                    /*if (this.getStudenttransferrequestdetailspanel().isValid() && newValue) {
                        this.getStudenttransferrequestdetailspanel().down('#studentTransferSubmitBtn').setDisabled(false);
                    } else {
                        this.getStudenttransferrequestdetailspanel().down('#studentTransferSubmitBtn').setDisabled(true);
                    }*/
                    this.onStudentTransferFieldCheck();
                }
            },
            
            'studenttransferrequestdetailspanel checkboxfield[itemId=authorizeDeclarationId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onStudentTransferFieldCheck();   
                }
            },
            
            'studenttransferrequestdetailspanel checkboxfield[itemId=upToDateDetailsId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onStudentTransferFieldCheck();   
                }
            },
            
            'studenttransferrequestdetailspanel checkboxfield[itemId=visaRefusalCheck]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onStudentTransferFieldCheck();   
                }
            },
            
            'studenttransferrequestdetailspanel checkboxfield[itemId=studiedInUkCheck]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onStudentTransferFieldCheck();   
                }
            },
            
            'studenttransferrequestdetailspanel checkboxfield[itemId=healthInsuranceCheckId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onStudentTransferFieldCheck();   
                }
            },
            
            'studenttransferrequestdetailspanel checkboxfield[itemId=scholarshipCheckId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onStudentTransferFieldCheck();   
                }
            },
            
            'studenttransferrequestdetailspanel checkboxfield[itemId=medicalIssuesCheckId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onStudentTransferFieldCheck();   
                }
            },
            'studenttransferrequestdetailspanel combo[itemId=academicTermId]': {
            	change: function (combo) {
            		 var studentTransferRequestPanel = combo.up('studenttransferrequestdetailspanel');
            		 var idField = studentTransferRequestPanel.down('[name=id]');
            		 var idValue= idField.getValue();
                     var fromAcademicLocationField = studentTransferRequestPanel.down('#fromAcademicLocationId');
                     var academicTermId = studentTransferRequestPanel.down('#academicTermId').getValue();
                     var fromProgramField = studentTransferRequestPanel.down('#fromProgramId');
                     var fromBatchField = studentTransferRequestPanel.down('#fromBatchId')
                     var fromPeriodField = studentTransferRequestPanel.down('#fromPeriodId')
                     var studentId = this.getContentPanelActiveTab().getRequesterId();
                     var programId= null;
                     var batchId = null;
                     var academyLocationId = null;
                     fromAcademicLocationField.reset();
                     fromProgramField.reset();
                     fromBatchField.reset();
                     fromPeriodField.reset();
                     fromAcademicLocationField.setDisabled(false);
                     
                     var fromAcademicLocationStore = fromAcademicLocationField.getStore();
                     if(isNullOrEmpty(idValue)){
                         fromAcademicLocationStore.getProxy().extraParams = {
                        	 serviceRequestId: null,
                        	 academicTermId: academicTermId,
                        	 studentId : studentId
                         };
                     }
                     else{
                         fromAcademicLocationStore.getProxy().extraParams = {
                        	 serviceRequestId: idValue,
                        	 academicTermId: academicTermId,
                        	 studentId : studentId
                         };
                     }
                     fromAcademicLocationStore.load({
 						   callback: function(rec, success){
 								   if (success) {
 									   if(rec.length==1){
 										   fromAcademicLocationField.setValue(rec[0].get('id'))
 										   academyLocationId = rec[0].get('id');
 									   }
 								   }
 							   }
 						   });
                                        
                     
                }
            },
            
            'studenttransferrequestdetailspanel combo[itemId=fromAcademicLocationId]': {
            	change: function (combo) {
           		 var studentTransferRequestPanel = combo.up('studenttransferrequestdetailspanel');
           		 var idField = studentTransferRequestPanel.down('[name=id]');
        		 var idValue= idField.getValue();
                    var academyLocationId = studentTransferRequestPanel.down('#fromAcademicLocationId').getValue();
                    
                    if(isNullOrEmpty(academyLocationId)){
                    	return;
                    }
                    
                    var academicTermId = studentTransferRequestPanel.down('#academicTermId').getValue();
                    var fromProgramField = studentTransferRequestPanel.down('#fromProgramId');
                    var fromBatchField = studentTransferRequestPanel.down('#fromBatchId')
                    var fromPeriodField = studentTransferRequestPanel.down('#fromPeriodId')
                    var studentId = this.getContentPanelActiveTab().getRequesterId();
                    var programId= null;
                    var batchId = null;
                    fromProgramField.reset();
                    fromBatchField.reset();
                    fromPeriodField.reset();
                    
                    var fromProgramStore = fromProgramField.getStore();
                    fromProgramStore.getProxy().api.read=SERVERURL.PATH_STUDENT_JOUNERY_FROM_PROGRAM;
                    
                    if(isNullOrEmpty(idValue)){
                    	fromProgramStore.getProxy().extraParams = {
       						academicTermId : academicTermId,
       						academyLocationId : academyLocationId,
       						studentId : this.getContentPanelActiveTab().getRequesterId(),
       						serviceRequestId: null
       						
       					};
                    }else{
                    	fromProgramStore.getProxy().extraParams = {
       						academicTermId : academicTermId,
       						academyLocationId : academyLocationId,
       						studentId : this.getContentPanelActiveTab().getRequesterId(),
       						serviceRequestId:idValue
       						
       					};
                    }
                    
                    
                    fromProgramStore.load({
						   callback: function(rec, success){
								   if (success) {
									   if(rec.length==1){
										   fromProgramField.setValue(rec[0].get('id'))
										   
										   programId = rec[0].get('id');
										   
	 										  fromBatchField.setDisabled(false);
	 										  var fromBatchStore = fromBatchField.getStore();
	 										  
	 										 if(isNullOrEmpty(idValue)){
	 											fromBatchStore.getProxy().extraParams = {
	 						                    	studentId: studentId,
	 						                    	programId : programId,
	 						                    	academicTermId: academicTermId,
	 						                    	serviceRequestId:null
	 						                    };
	 										 }else{
	 											fromBatchStore.getProxy().extraParams = {
	 						                    	studentId: studentId,
	 						                    	programId : programId,
	 						                    	academicTermId: academicTermId,
	 						                    	serviceRequestId:idValue
	 						                    };
	 										 }
	 						                    
	 						                    fromBatchStore.load({
	 												   callback: function(rec, success){
	 														   if (success) {
	 															   if(rec.length==1){
	 																   fromBatchField.setValue(rec[0].get('id'))
	 																   batchId = rec[0].get('id');
	 																   
	 																  fromPeriodField.setDisabled(false);
	 																  var fromPeriodStore = fromPeriodField.getStore();
	 																 if(isNullOrEmpty(idValue)){
	 																	fromPeriodStore.getProxy().extraParams = {
	 						 						                    	studentId: studentId,
	 						 						                    	programId : programId,
	 						 						                    	academicTermId: academicTermId,
	 						 						                    	batchId : batchId,
	 						 						                    	serviceRequestId:null
	 						 						                    };
	 																 }else{
	 																	fromPeriodStore.getProxy().extraParams = {
	 						 						                    	studentId: studentId,
	 						 						                    	programId : programId,
	 						 						                    	academicTermId: academicTermId,
	 						 						                    	batchId : batchId,
	 						 						                    	serviceRequestId:idValue
	 						 						                    };
	 																 }
	 																  
	 																 fromPeriodStore.load({
	 						 												   callback: function(rec, success){
	 						 														   if (success) {
	 						 															   if(rec.length==1){
	 						 																 fromPeriodField.setValue(rec[0].get('id'))
	 						 															   }
	 						 														   }
	 						 													   }
	 						 												   });
	 															   }
	 														   }
	 													   }
	 												   });
									   }
								   }
							   }
						   });
                    
               }
                
            },
            
            'studenttransferrequestdetailspanel combo[itemId=toBatchId]': {
                select: this.loadAllPeriodComboStore,
                select: this.loadSeatTypeCombo
            },
            'studenttransferrequestdetailspanel combo[itemId=toProgramId]': {
                render: this.loadStudentTransferToProgramComboStore,
                select: this.loadBatchComboStore
            },
            'studenttransferrequestdetailspanel combo[itemId=toAcademyLocationItemId]': {
                render: function (obj) {
                    var $this = this;
                    var store = obj.getStore();
                    var studTransferPanel = this.getStudenttransferrequestdetailspanel();
                    var toProgramId = studTransferPanel.down('#toProgramId');
                    var periodId = this.getContentPanelActiveTab().getPeriodId();
                    var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
                  //  store.load();
                    store.load({
                        params: {
                        	periodId: periodId,
                        	requestTypeCode: requestTypeCode
                        }});
                },
                select: this.loadToProgramComboByAL
            },
            'studenttransferrequestdetailspanel button[itemId=studentTransferSubmitBtn]': {
                click: this.submitStudentTransferServiceRequest
            },
            'studenttransferrequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            /**
             * School leaving request
             */
            'schoolleavingrequestdetailspanel': {
                render: function (pnl) {
                    var basicDetailPnl = this.getBasicdetails();
                    var reasonForLeavingField = basicDetailPnl.down('#reasonForLeavingItemId');
                    var schoolLeavingToIdField = basicDetailPnl.down('#schoolLeavingToId');
                    var leavingToItemIdField = basicDetailPnl.down('#leavingToItemId');
                    var withdrawDate = basicDetailPnl.down("#withdrawDateId");
					var noticeTerm = pnl.down("#noticeTermItemId");
					var termEnddate = pnl.down("#termEndDateItemId");
                    withdrawDate.setVisible(false);
                    reasonForLeavingField.setVisible(true);
                    leavingToItemIdField.setVisible(true);
                    schoolLeavingToIdField.setVisible(true);
					if(!noticeTerm.isVisible()){
						this.setAllowBlank(noticeTerm, true);
					}
					if(!termEnddate.isVisible()){
						this.setAllowBlank(termEnddate, true);				
					}
                    setTimeout(function () {
                        reasonForLeavingField.allowBlank = false;
                        reasonForLeavingField.labelSeparator = '';
                        reasonForLeavingField.setFieldLabel(getCommonTranslation('REASON_FOR_LEAVING') + ': <span style="color:red">*</span>');
                        schoolLeavingToIdField.allowBlank = false;
                        schoolLeavingToIdField.labelSeparator = '';
                        schoolLeavingToIdField.setFieldLabel(getCommonTranslation('SCHOOL_LEAVING_TO') + ': <span style="color:red">*</span>');
                    }, 500);
                }
            },
            'schoolleavingrequestdetailspanel combo[itemId=fromProgramId]': {
                render: this.loadFromProgramComboStore,
                select: function (combo) {
                    var studentTransferRequestPanel = combo.up('studenttransferrequestdetailspanel');
                    var fromProgramId = studentTransferRequestPanel.down('#fromProgramId').getValue();
                    var academicTermId = studentTransferRequestPanel.down('#academicTermId').getValue();
                    var fromBatchField = studentTransferRequestPanel.down('#fromBatchId');
                    var fromPeriodField = studentTransferRequestPanel.down('#fromBatchId');
                    var fromBatchId = null;
                    fromBatchField.reset();
                    fromPeriodField.reset();
                    fromBatchField.setDisabled(false);
                    var fromBatchStore = fromBatchField.getStore();
                    fromBatchStore.getProxy().extraParams = {
                    	studentId: this.getContentPanelActiveTab().getRequesterId(),
                    	programId : fromProgramId,
                    	academicTermId: academicTermId
                    };
                    fromBatchStore.load({
						   callback: function(rec, success){
								   if (success) {
									   if(rec.length==1){
										   fromBatchField.setValue(rec[0].get('id'))
										   
										   fromPeriodField.setDisabled(false);
										   var fromPeriodStore = fromPeriodField.getStore();
											  fromPeriodStore.getProxy().extraParams = {
	 						                    	studentId: this.getContentPanelActiveTab().getRequesterId(),
	 						                    	programId : programId,
	 						                    	academicTermId: academicTermId,
	 						                    	batchId : rec[0].get('id')
	 						                    };
											 fromPeriodStore.load({
	 												   callback: function(rec, success){
	 														   if (success) {
	 															   if(rec.length==1){
	 																 fromPeriodField.setValue(rec[0].get('id'))
	 															   }
	 														   }
	 													   }
	 												   });
									   }
								   }
							   }
						   });
                }
            },
            'schoolleavingrequestdetailspanel combo[itemId=noticeTermItemId]': {
                select: this.selectNoticeTerm
            },
            'schoolleavingrequestdetailspanel button[itemId=schoolLeavingSubmitBtn]': {
                click: this.submitSchoolLeavingServiceRequest
            },
            'schoolleavingrequestdetailspanel button[itemId=schoolLeavingSaveBtn]': {
                click: this.updateSchoolLeaveTermEndDate
            },
            'schoolleavingrequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'schoolleavingrequestdetailspanel button[itemId=remarkSubmitButtonId]': {
                click: this.updateSchoolLeaveingReasonRemark
            },
            'studenttransferrequestdetailspanel button[itemId=remarkSubmitButtonId]': {
                click: this.submitStudentTransferStudentTransferSR
            },
            'leaveofabsencerequestform': {
                afterrender: function (pnl) {
                    var me = this;
                    var basicDetailPnl = me.getBasicdetails();
                    var studentGrid = Ext.ComponentQuery.query('#StudentSearchResultGrid')[0];
                    var programId;
                    var batchId;
                    var periodId;
                    var seatTypeId;
                    var academicTermId;
                    if (studentGrid != undefined) {
                        var studentRecord = studentGrid.getSelectionModel();
                        if (studentRecord.selected.items[0] != undefined) {
                            programId = studentRecord.selected.items[0].data.PROGRAM_ID;
                            batchId = studentRecord.selected.items[0].data.PROGRAM_BATCH_ID;
                        }
                    }
                    var programField = pnl.down('#programCombo');
                    var withdrawDate = basicDetailPnl.down('#withdrawDateId');
                    var batchField = pnl.down('#batchCombo');
                    var periodField = pnl.down('#periodCombo');
                    var seatTypeField = pnl.down('#seatTypeCombo');
                    var programFieldStore = programField.getStore();
                    var batchFieldStore = batchField.getStore();
                    var periodFieldStore = periodField.getStore();
                    var seatTypeFieldStore = seatTypeField.getStore();
                    var academyLocationField = pnl.down('#academyLocationCombo');
                    var academicTermField = pnl.down('#academicTermCombo');
                    var startAcademicTermField = pnl.down('#startAcademicTermCombo');
                    var startDateField = pnl.down('#startDate');
                    
					var requestReasonField = basicDetailPnl.down('#RequestReason');
					if (requestReasonField && requestReasonField.isHidden()) {
						requestReasonField.allowBlank = true;
					}
                    
                    
                    
                    var academicTermFieldStore = academicTermField.getStore();
                    var startAcademicFieldStore = startAcademicTermField.getStore();
                    var portalId = me.getCurrentLoggedPortalId();
                    var academyLocationFieldStore = academyLocationField.getStore();
                    var isEditRequest = false;
                    var activeTab = me.getContentPanelActiveTab();

					if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
						var serviceRequestId = activeTab.getServiceRequestId();
						if (!isNullOrEmpty(serviceRequestId)) {
							isEditRequest = true;
						}
					}

                    startDateField.reset();
                    var admissionId = me.getContentPanelActiveTab().admissionId;
                    withdrawDate.setVisible(false);
                    if (portalId == 1) {
                        var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
                        var admissionDetails = portalInfo.admissionDetails;
                    } else {
                        var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
                        var admissionDetails = portalInfo.admissionDetails;
                    }
                    var admissionIds = Ext.Array.pluck(admissionDetails, 'id').join();
                    academyLocationFieldStore.load({
                        params: {
                            admissionIds: admissionIds,
                            portalId: portalId
                        },
                        callback: function (records, opt, success) {
                            if (success) {
                                if (!isNullOrEmpty(records)) {
                                    academyLocationId = records[0].data.id;
                                    academyLocationField.setValue(academyLocationId);
                                    academyLocationField.setReadOnly(true);
                                }
                            }
                        }
                    });
                    academicTermFieldStore.load({
                        params: {
                            studentId: me.getContentPanelActiveTab().getRequesterId(),
                            admissionId : me.getContentPanelActiveTab().admissionId,
                            isEditRequest : isEditRequest
                            
                        },
                        callback: function (records, opt, success) {
                            if (success) {
                                programField.setDisabled(false);
                                if (!isNullOrEmpty(academicTermId) || records.length == 1) {
                                    if (records.length == 1) {
                                        academicTermId = records[0].data.id;
                                        academicTermField.setValue(academicTermId);
                                        academicTermField.setReadOnly(true);
                                    }
                                    programFieldStore.load({
                                        params: {
                                            studentId: me.getContentPanelActiveTab().getRequesterId(),
                                            academicTermId: academicTermId,
                                        },
                                        callback: function (records, opt, success) {
                                            if (success) {
                                                batchField.setDisabled(false);
                                                if (!isNullOrEmpty(programId) || records.length == 1) {
                                                    if (records.length == 1) {
                                                        programId = records[0].data.programId;
                                                    }
                                                    programField.setValue(programId);
                                                    programField.setReadOnly(true);
                                                    batchFieldStore.load({
                                                        params: {
                                                            studentId: me.getContentPanelActiveTab().getRequesterId(),
                    										academicTermId:academicTermId,
                    										//admissionId:admissionId
                                                        },
                                                        callback: function (records1, opt1, success1) {
                                                            if (success) {
                                                                periodField.setDisabled(false);
                                                                if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                                    if (records1.length == 1) {
                                                                        batchId = records1[0].data.batchId;
                                                                    }
                                                                    batchField.setValue(batchId);
                                                                    batchField.setReadOnly(true);
                                                                    periodFieldStore.load({
                                                                        params: {
                                                                            studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                            academicTermId: academicTermId,
                                                                            batchId: batchId,
                    														//admissionId:admissionId
                                                                        },
                                                                        callback: function (records1, opt1, success1) {
                                                                            if (success) {
                                                                                if (!isNullOrEmpty(periodId) || records1.length == 1) {
                                                                                    seatTypeField.setDisabled(false);
                                                                                    if (records1.length == 1) {
                                                                                        periodId = records1[0].data.periodId;
                                                                                    }
                                                                                    periodField.setValue(periodId);
                                                                                    periodField.setReadOnly(true);
                                                                                    Ext.Ajax.request({
                                                                                        type: 'rest',
                                                                                        url: SERVERURL.PERIOD_FIND_BY_ID,
                                                                                        params: {
                                                                                            id: periodId
                                                                                        },
                                                                                        method: 'GET',
                                                                                        success: function (response) {
                                                                                            var data = Ext.decode(response.responseText);
                                                                                            if (data.isCurrentPeriodOfProgram) {
                                                                                                startDateField.setValue(new Date());
                                                                                                startDateField.setMinValue(new Date());
                                                                                                startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                                                                                            } else {
                                                                                                startDateField.setValue(dateRender(data.programPeriodStart));
                                                                                                startDateField.setMinValue(dateRender(data.programPeriodStart));
                                                                                                startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                                                                                            }
                                                                                        }
                                                                                    });
                                                                                    seatTypeFieldStore.load({
                                                                                        params: {
                                                                                            studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                                            academicTermId: academicTermId,
                    																		//admissionId:admissionId
                                                                                        },
                                                                                        callback: function (records1, opt1, success1) {
                                                                                            if (success) {
                                                                                                if (!isNullOrEmpty(seatTypeId) || records1.length == 1) {
                                                                                                    if (records1.length == 1) {
                                                                                                        seatTypeId = records1[0].data.seatTypeId;
                                                                                                    }
                                                                                                    seatTypeField.setValue(seatTypeId);
                                                                                                    seatTypeField.setReadOnly(true);
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    });
                                                                                }
                                                                            }
                                                                        }
                                                                    });
                                                                } else {
                                                                    periodField.setDisabled(true);
                                                                    seatTypeField.setDisabled(true);
                                                                }
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    programField.setDisabled(true);
                                    batchField.setDisabled(true);
                                    periodField.setDisabled(true);
                                    seatTypeField.setDisabled(true);
                                }
                            }
                        }
                    });
                    startAcademicFieldStore.load();
                },
                validitychange: function (cmp, valid) {
                    if (valid) {
                        this.onLeaveOfAbsenceFieldCheck();
                    } else {
                        return false;
                    }
                }
            },
            'leaveofabsencerequestform combo#programCombo': {
                select: function (combo) {
                    var me = this;
                    var pnl = combo.up('leaveofabsencerequestform');
                    var academicTermId = pnl.down('#academicTermCombo').getValue();
                    var batchCombo = pnl.down('#batchCombo');
                    var periodField = pnl.down('#periodCombo');
                    var seatTypeField = pnl.down('#seatTypeCombo');
                    var startDateField = pnl.down('#startDate');
                    batchCombo.setReadOnly(false);
                    periodField.setReadOnly(false);
                    seatTypeField.setReadOnly(false);
                    batchCombo.reset();
                    batchCombo.clearValue();
                    periodField.reset();
                    periodField.clearValue();
                    seatTypeField.reset();
                    seatTypeField.clearValue();
                    startDateField.reset();
                    var programId = combo.getValue();
                    if (programId) {
                        batchCombo.setDisabled(false);
                        batchCombo.getStore().load({
                            params: {
                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                programId: programId,
                                academicTermId: academicTermId,
                            },
                            callback: function (records1, opt1, success1) {
                                if (success1) {
                                    if (records1.length == 1) {
                                        if (records1.length == 1) {
                                            batchId = records1[0].data.batchId;
                                            batchCombo.setReadOnly(true);
                                            periodField.setDisabled(false);
                                            seatTypeField.setDisabled(false);
                                        }
                                        batchCombo.setValue(batchId);
                                        periodField.getStore().load({
                                            params: {
                                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                batchId: batchId,
                                                academicTermId: academicTermId,
                                            },
                                            callback: function (records1, opt1, success1) {
                                                if (success1) {
                                                    if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                        if (records1.length == 1) {
                                                            periodId = records1[0].data.periodId;
                                                        }
                                                        periodField.setValue(periodId);
                                                        periodField.setReadOnly(true);
                                                        Ext.Ajax.request({
                                                            type: 'rest',
                                                            url: SERVERURL.PERIOD_FIND_BY_ID,
                                                            params: {
                                                                id: periodId
                                                            },
                                                            method: 'GET',
                                                            success: function (response) {
                                                                var data = Ext.decode(response.responseText);
                                                                if (data.isCurrentPeriodOfProgram) {
                                                                    startDateField.setValue(new Date());
                                                                    startDateField.setMinValue(new Date());
                                                                    startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                                                                } else {
                                                                    startDateField.setValue(dateRender(data.programPeriodStart));
                                                                    startDateField.setMinValue(dateRender(data.programPeriodStart));
                                                                    startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                                                                }
                                                            }
                                                        })
                                                    }
                                                }
                                            }
                                        });
                                        seatTypeField.getStore().load({
                                            params: {
                                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                batchId: batchId,
                                                academicTermId: academicTermId,
                                            },
                                            callback: function (records1, opt1, success1) {
                                                if (success1) {
                                                    if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                        if (records1.length == 1) {
                                                            seatTypeId = records1[0].data.seatTypeId;
                                                        }
                                                        seatTypeField.setValue(seatTypeId);
                                                        seatTypeField.setReadOnly(true);
                                                    }
                                                }
                                            }
                                        });
                                    } else {
                                        periodField.setDisabled(true);
                                        seatTypeField.setDisabled(true);
                                    }
                                }
                            }
                        });
                    }
                }
            },
            'leaveofabsencerequestform combo#batchCombo': {
                select: function (combo) {
                    var me = this;
                    var pnl = combo.up('leaveofabsencerequestform');
                    var periodField = pnl.down('#periodCombo');
                    var academicTermId = pnl.down('#academicTermCombo').getValue();
                    var seatTypeField = pnl.down('#seatTypeCombo');
                    var startDateField = pnl.down('#startDate');
                    periodField.setReadOnly(false);
                    periodField.reset();
                    periodField.clearValue();
                    seatTypeField.setReadOnly(false);
                    seatTypeField.reset();
                    seatTypeField.clearValue();
                    startDateField.reset();
                    var batchId = combo.getValue();
                    if (batchId) {
                        periodField.setDisabled(false);
                        seatTypeField.setDisabled(false);
                        periodField.getStore().getProxy().extraParams = {
                            studentId: me.getContentPanelActiveTab().getRequesterId(),
                            batchId: batchId,
                            academicTermId: academicTermId,
                        }
                        periodField.getStore().load({
                            callback: function (records1, opt1, success1) {
                                if (success1) {
                                    if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                        if (records1.length == 1) {
                                            periodId = records1[0].data.periodId;
                                            Ext.Ajax.request({
                                                type: 'rest',
                                                url: SERVERURL.PERIOD_FIND_BY_ID,
                                                params: {
                                                    id: periodId
                                                },
                                                method: 'GET',
                                                success: function (response) {
                                                    var data = Ext.decode(response.responseText);
                                                    if (data.isCurrentPeriodOfProgram) {
                                                        startDateField.setValue(new Date());
                                                        startDateField.setMinValue(new Date());
                                                        startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                                                    } else {
                                                        startDateField.setValue(dateRender(data.programPeriodStart));
                                                        startDateField.setMinValue(dateRender(data.programPeriodStart));
                                                        startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                                                    }
                                                }
                                            })
                                        }
                                    }
                                }
                            }
                        });
                        seatTypeField.getStore().getProxy().extraParams = {
                            studentId: me.getContentPanelActiveTab().getRequesterId(),
                            batchId: batchId,
                            academicTermId: academicTermId,
                        }
                        seatTypeField.getStore().load({
                            callback: function (records1, opt1, success1) {
                                if (success) {
                                    if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                        if (records1.length == 1) {
                                            seatTypeId = records1[0].data.seatTypeId;
                                        }
                                        seatTypeField.setValue(seatTypeId);
                                        seatTypeField.setReadOnly(true);
                                    }
                                }
                            }
                        });
                    }
                }
            },
            'leaveofabsencerequestform combo#periodCombo': {
                select: function (combo) {
                    var me = this;
                    var pnl = combo.up('leaveofabsencerequestform');
                    var startDateField = pnl.down('#startDate');
                    var periodId = combo.getValue();
                    startDateField.reset();
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PERIOD_FIND_BY_ID,
                        params: {
                            id: periodId
                        },
                        method: 'GET',
                        success: function (response) {
                            var data = Ext.decode(response.responseText);
                            if (data.isCurrentPeriodOfProgram) {
                                startDateField.setValue(new Date());
                                startDateField.setMinValue(new Date());
                                startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                            } else {
                                startDateField.setValue(dateRender(data.programPeriodStart));
                                startDateField.setMinValue(dateRender(data.programPeriodStart));
                                startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                            }
                        }
                    })
                }
            },
            'leaveofabsencerequestform combo#academicTermCombo': {
                select: function (combo) {
                    var me = this;
                    var formValues = me.getLeaveofabsencerequestform().getValues();
                    var pnl = combo.up('leaveofabsencerequestform');
                    var programField = pnl.down('#programCombo');
                    var batchField = pnl.down('#batchCombo');
                    var periodField = pnl.down('#periodCombo');
                    var seatTypeField = pnl.down('#seatTypeCombo');
                    var programFieldStore = programField.getStore();
                    var batchFieldStore = batchField.getStore();
                    var periodFieldStore = periodField.getStore();
                    var seatTypeFieldStore = seatTypeField.getStore();
                    var startDateField = pnl.down('#startDate');
                    programField.setReadOnly(false);
                    batchField.setReadOnly(false);
                    periodField.setReadOnly(false);
                    seatTypeField.setReadOnly(false);
                    programField.reset();
                    programField.clearValue();
                    batchField.reset();
                    batchField.clearValue();
                    periodField.reset();
                    periodField.clearValue();
                    seatTypeField.reset();
                    seatTypeField.clearValue();
                    startDateField.reset();
                    if (portalId == 1) {
                        var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
                        var admissionDetails = portalInfo.admissionDetails;
                    } else {
                        var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
                        var admissionDetails = portalInfo.admissionDetails;
                    }
                    var admissionIds = Ext.Array.pluck(admissionDetails, 'id').join();
                  //  var admissionId = me.getContentPanelActiveTab().admissionId;
            		
                    var programId;
                    var batchId;
                    var periodId;
                    var seatTypeId;
                    var academicTermId;
                    var academicTermId = combo.getValue();
                    if (academicTermId) {
                        programField.setDisabled(false);
                        programFieldStore.load({
                            params: {
                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                admissionId : me.getContentPanelActiveTab().getAdmissionId(),
                                academicTermId: academicTermId,
                         		//admissionId:admissionIds
                            },
                            callback: function (records, opt, success) {
                                if (success) {
                                    batchField.setDisabled(false);
                                    if (!isNullOrEmpty(programId) || records.length == 1) {
                                        if (records.length == 1) {
                                            programId = records[0].data.programId;
                                        }
                                        programField.setValue(programId);
                                        programField.setReadOnly(true);
                                        batchFieldStore.load({
                                            params: {
                                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                admissionId : me.getContentPanelActiveTab().getAdmissionId(),
                                                academicTermId: academicTermId,
                                                programId:programId,
                                         		//admissionId:admissionIds
                                            },
                                            callback: function (records1, opt1, success1) {
                                                if (success) {
                                                    if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                        periodField.setDisabled(false);
                                                        if (records1.length == 1) {
                                                            batchId = records1[0].data.batchId;
                                                        }
                                                        batchField.setValue(batchId);
                                                        batchField.setReadOnly(true);
                                                        periodFieldStore.getProxy().extraParams={
                                                        	 studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                             admissionId : me.getContentPanelActiveTab().getAdmissionId(),
                                                             academicTermId: academicTermId,
                                                             batchId: batchId,
                                                      		//admissionId:admissionIds
                                                        }
                                                        periodFieldStore.load({
                                                           /* params: {
                                                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                admissionId : me.getContentPanelActiveTab().getAdmissionId(),
                                                                academicTermId: academicTermId,
                                                                batchId: batchId,
                                                         		//admissionId:admissionIds
                                                            },*/
                                                            callback: function (records1, opt1, success1) {
                                                                if (success) {
                                                                    if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                                        seatTypeField.setDisabled(false);
                                                                        if (records1.length == 1) {
                                                                            periodId = records1[0].data.periodId;
                                                                        }
                                                                        periodField.setValue(periodId);
                                                                        periodField.setReadOnly(true);
                                                                        Ext.Ajax.request({
                                                                            type: 'rest',
                                                                            url: SERVERURL.PERIOD_FIND_BY_ID,
                                                                            params: {
                                                                                id: periodId
                                                                            },
                                                                            method: 'GET',
                                                                            success: function (response) {
                                                                                var data = Ext.decode(response.responseText);
                                                                                if (data.isCurrentPeriodOfProgram) {
                                                                                    startDateField.setMinValue(new Date());
                                                                                    startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                                                                                    startDateField.setValue(new Date());
                                                                                } else {
                                                                                    startDateField.setMinValue(dateRender(data.programPeriodStart));
                                                                                    startDateField.setMaxValue(dateRender(data.programPeriodEnd));
                                                                                    startDateField.setValue(dateRender(data.programPeriodStart));
                                                                                }
                                                                            }
                                                                        });
                                                                        seatTypeFieldStore.getProxy().extraParams = {
                                                                            studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                            admissionId : me.getContentPanelActiveTab().getAdmissionId(),
                                                                            academicTermId: academicTermId,
                                                                            batchId: batchId,
                                                                        };
                                                                        seatTypeFieldStore.load({
                                                                            params: {
                                                                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                                admissionId : me.getContentPanelActiveTab().getAdmissionId(),
                                                                                academicTermId: academicTermId,
                                                                                batchId: batchId,
                                                                         		//admissionId:admissionIds
                                                                            },
                                                                            callback: function (records1, opt1, success1) {
                                                                                if (success) {
                                                                                    if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                                                        if (records1.length == 1) {
                                                                                            seatTypeId = records1[0].data.seatTypeId;
                                                                                        }
                                                                                        seatTypeField.setValue(seatTypeId);
                                                                                        seatTypeField.setReadOnly(true);
                                                                                    }
                                                                                }
                                                                            }
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        });
                                                    } else {
                                                        periodField.setDisabled(true);
                                                        seatTypeField.setDisabled(true);
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        });
                    }
                }
            },
            'leaveofabsencerequestform button[itemId=leaveOfAbsenceReqUploadSubmitBtn]': {
                click: this.submitStudentLeaveOfAbsenceRequestUploadServiceRequest
            },
            'exchangesemesterrequestdetailspanel': {
                afterrender: function (pnl) {
                    var me = this;
                    var basicDetailPnl = me.getBasicdetails();
                    var studentGrid = Ext.ComponentQuery.query('#StudentSearchResultGrid')[0];
                    var programId;
                    var batchId;
                    var periodId;
                    var admissionId;
                    var academicTermId;
                    if (studentGrid != undefined) {
                        var studentRecord = studentGrid.getSelectionModel();
                        if (studentRecord.selected.items[0] != undefined) {
                            programId = studentRecord.selected.items[0].data.PROGRAM_ID;
                            batchId = studentRecord.selected.items[0].data.PROGRAM_BATCH_ID;
                            admissionId = studentRecord.selected.items[0].data.ADMISSION_ID;
                        }
                    }
                    var academyLocationField = pnl.down('#fromAcademyLocationId');
                    var programField = pnl.down('#fromProgramId');
                    var fromBatchField = pnl.down('#fromBatchId');
                    var fromPeriodField = pnl.down('#fromPeriodId');
                    var academicTermField = pnl.down('#academicTermCombo');
                    var toAcademyLocationField = pnl.down('#toAcademyLocationItemId');
                    var admissionId = me.getContentPanelActiveTab().admissionId;
                    var academyLocationStore = academyLocationField.getStore();
                    var programFieldStore = programField.getStore();
                    var fromBatchFieldStore = fromBatchField.getStore();
                    var fromPeriodFieldStore = fromPeriodField.getStore();
                    var academicTermFieldStore = academicTermField.getStore();
                    academyLocationStore.load({
            			params: {
            			},
                        callback: function (records, opt, success) {
                            if (success) {
                                academyLocationField.setValue(records[0].data.id);
                                academicTermFieldStore.load({
                                    params: {
                                        studentId: me.getContentPanelActiveTab().getRequesterId(),
                                        admissionId: admissionId
                                    },
                                    callback: function (records, opt, success) {
                                        if (success) {
                                            programField.setDisabled(false);
                                            if (!isNullOrEmpty(academicTermId) || records.length == 1) {
                                                if (records.length == 1) {
                                                    academicTermId = records[0].data.id;
                                                    academicTermField.setValue(academicTermId);
                                                    academicTermField.setReadOnly(true);
                                                    toAcademyLocationField.setDisabled(false);
                                                }
                                                programFieldStore.load({
                                                    params: {
                                                        studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                        academicTermId: academicTermId,
                                                        admissionId: admissionId
                                                    },
                                                    callback: function (records, opt, success) {
                                                        if (success) {
                                                            fromBatchField.setDisabled(false);
                                                            if (!isNullOrEmpty(programId) || records.length == 1) {
                                                                if (records.length == 1) {
                                                                    programId = records[0].data.programId;
                                                                }
                                                                programField.setValue(programId);
                                                                programField.setReadOnly(true);
                                                                fromBatchFieldStore.load({
                                                                    params: {
                                                                        studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                        academicTermId: academicTermId,
                                                                        admissionId: admissionId
                                                                    },
                                                                    callback: function (records1, opt1, success1) {
                                                                        if (success) {
                                                                            if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                                                fromPeriodField.setDisabled(false);
                                                                                if (records1.length == 1) {
                                                                                    batchId = records1[0].data.batchId;
                                                                                }
                                                                                fromBatchField.setValue(batchId);
                                                                                fromBatchField.setReadOnly(true);
                                                                                fromPeriodFieldStore.load({
                                                                                    params: {
                                                                                        studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                                        academicTermId: academicTermId,
                                                                                        admissionId: admissionId
                                                                                    },
                                                                                    callback: function (records1, opt1, success1) {
                                                                                        if (success) {
                                                                                            if (!isNullOrEmpty(periodId) || records1.length == 1) {
                                                                                                if (records1.length == 1) {
                                                                                                    periodId = records1[0].data.periodId;
                                                                                                }
                                                                                                fromPeriodField.setValue(periodId);
                                                                                                fromPeriodField.setReadOnly(true);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                });
                                                                            } else {
                                                                                fromPeriodField.setDisabled(true);
                                                                            }
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    }
                                                });
                                            } else {
                                                programField.setDisabled(true);
                                                fromBatchField.setDisabled(true);
                                                fromPeriodField.setDisabled(true);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                }, 
                validitychange: function (cmp, valid) {
                    if (valid) {/*
                        if (this.getExchangesemesterrequestdetailspanel().down('#confirmationId').checked || !this.getExchangesemesterrequestdetailspanel().down('#confirmationId').isVisible()) {
                            this.getExchangesemesterrequestdetailspanel().down('#exchangeSemesterreqUploadSubmitBtn').setDisabled(false);
                        } else {
                            this.getExchangesemesterrequestdetailspanel().down('#exchangeSemesterreqUploadSubmitBtn').setDisabled(true);
                        }*/
                    	this.onExchangeSemesterFieldCheck();
                    } else {
                        return false;
                    }
                }
                
            },
            'leaveofabsencerequestform button[itemId=leaveOfAbsenceReqUploadSubmitBtn]': {
                click: this.submitStudentLeaveOfAbsenceRequestUploadServiceRequest
            },
            'exchangesemesterrequestdetailspanel': {
                afterrender: function (pnl) {
                    var me = this;
                    var basicDetailPnl = me.getBasicdetails();
                    var studentGrid = Ext.ComponentQuery.query('#StudentSearchResultGrid')[0];
                    var programId;
                    var batchId;
                    var periodId;
                    var admissionId;
                    var academicTermId;
                    if (studentGrid != undefined) {
                        var studentRecord = studentGrid.getSelectionModel();
                        if (studentRecord.selected.items[0] != undefined) {
                            programId = studentRecord.selected.items[0].data.PROGRAM_ID;
                            batchId = studentRecord.selected.items[0].data.PROGRAM_BATCH_ID;
                            admissionId = studentRecord.selected.items[0].data.ADMISSION_ID;
                        }
                    }
                    var academyLocationField = pnl.down('#fromAcademyLocationId');
                    var programField = pnl.down('#fromProgramId');
                    var fromBatchField = pnl.down('#fromBatchId');
                    var fromPeriodField = pnl.down('#fromPeriodId');
                    var academicTermField = pnl.down('#academicTermCombo');
                    var withdrawDate = pnl.down('#withdrawDateId');
                    var toAcademyLocationField = pnl.down('#toAcademyLocationItemId');
                    var admissionId = me.getContentPanelActiveTab().admissionId;
                    var academyLocationStore = academyLocationField.getStore();
                    var programFieldStore = programField.getStore();
                    var fromBatchFieldStore = fromBatchField.getStore();
                    var fromPeriodFieldStore = fromPeriodField.getStore();
                    var academicTermFieldStore = academicTermField.getStore();
                    var isEditRequest = false;
                    var serviceRequestId = null;
					var activeTab = me.getContentPanelActiveTab();
					if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
						serviceRequestId = activeTab.getServiceRequestId();
						if (!isNullOrEmpty(serviceRequestId)) {
							isEditRequest = true;
						}
					} 
                    withdrawDate.allowBlank = true;
                    withdrawDate.setVisible(false);
                    academyLocationStore.load({
                        params: {
							studentId: me.getContentPanelActiveTab().getRequesterId(),
							isEditRequest : isEditRequest,
							serviceRequestId : serviceRequestId
							
						},
                        callback: function (records, opt, success) {
                            if (success) {
                                academyLocationField.setValue(records[0].data.id);
                                academicTermFieldStore.load({
                                    params: {
                                        studentId: me.getContentPanelActiveTab().getRequesterId(),
                                        admissionId: admissionId,
                                        isEditRequest : isEditRequest
                                    },
                                    callback: function (records, opt, success) {
                                        if (success) {
                                            programField.setDisabled(false);
                                            if (!isNullOrEmpty(academicTermId) || records.length == 1) {
                                                if (records.length == 1) {
                                                    academicTermId = records[0].data.id;
                                                    academicTermField.setValue(academicTermId);
                                                    academicTermField.setReadOnly(true);
                                                    toAcademyLocationField.setDisabled(false);
                                                }
                                                programFieldStore.load({
                                                    params: {
                                                        studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                        academicTermId: academicTermId,
                                                        admissionId: admissionId
                                                    },
                                                    callback: function (records, opt, success) {
                                                        if (success) {
                                                            fromBatchField.setDisabled(false);
                                                            if (!isNullOrEmpty(programId) || records.length == 1) {
                                                                if (records.length == 1) {
                                                                    programId = records[0].data.programId;
                                                                }
                                                                programField.setValue(programId);
                                                                programField.setReadOnly(true);
                                                                fromBatchFieldStore.load({
                                                                    params: {
                                                                        studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                        academicTermId: academicTermId,
                                                                        admissionId: admissionId
                                                                    },
                                                                    callback: function (records1, opt1, success1) {
                                                                        if (success) {
                                                                            if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                                                fromPeriodField.setDisabled(false);
                                                                                if (records1.length == 1) {
                                                                                    batchId = records1[0].data.batchId;
                                                                                }
                                                                                fromBatchField.setValue(batchId);
                                                                                fromBatchField.setReadOnly(true);
                                                                                fromPeriodFieldStore.load({
                                                                                    params: {
                                                                                        studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                                                        academicTermId: academicTermId,
                                                                                        admissionId: admissionId
                                                                                    },
                                                                                    callback: function (records1, opt1, success1) {
                                                                                        if (success) {
                                                                                            if (!isNullOrEmpty(periodId) || records1.length == 1) {
                                                                                                if (records1.length == 1) {
                                                                                                    periodId = records1[0].data.periodId;
                                                                                                }
                                                                                                fromPeriodField.setValue(periodId);
                                                                                                fromPeriodField.setReadOnly(true);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                });
                                                                            } else {
                                                                                fromPeriodField.setDisabled(true);
                                                                            }
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    }
                                                });
                                            } else {
                                                programField.setDisabled(true);
                                                fromBatchField.setDisabled(true);
                                                fromPeriodField.setDisabled(true);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                },validitychange: function (cmp, valid) {
                    if (valid) {
                        /*if (this.getExchangesemesterrequestdetailspanel().down('#confirmationId').checked || !this.getExchangesemesterrequestdetailspanel().down('#confirmationId').isVisible()) {
                            this.getExchangesemesterrequestdetailspanel().down('#exchangeSemesterreqUploadSubmitBtn').setDisabled(false);
                        } else {
                            this.getExchangesemesterrequestdetailspanel().down('#exchangeSemesterreqUploadSubmitBtn').setDisabled(true);
                        }*/
                    	this.onExchangeSemesterFieldCheck();
                    } else {
                        return false;
                    }
                }
            },
            'exchangesemesterrequestdetailspanel combo#academicTermCombo': {
                select: function (combo) {
                    var me = this;
                    var pnl = combo.up('exchangesemesterrequestdetailspanel');
                    var programField = pnl.down('#fromProgramId');
                    var batchField = pnl.down('#fromBatchId');
                    var periodField = pnl.down('#fromPeriodId');
                    var academicTermField = pnl.down('#academicTermCombo');
                    var toAcademyLocationField = pnl.down('#toAcademyLocationItemId');
                    var programFieldStore = programField.getStore();
                    var batchFieldStore = batchField.getStore();
                    var periodFieldStore = periodField.getStore();
                    var admissionId = me.getContentPanelActiveTab().admissionId;
                    var programId;
                    var batchId;
                    var periodId;
                    var seatTypeId;
                    var academicTermId;
                    var academicTermId = combo.getValue();
                    programField.reset();
                    programField.setDisabled(true);
                    if (academicTermId) {
                        programField.setDisabled(false);
                        toAcademyLocationField.setDisabled(false);
                        programFieldStore.getProxy().extraParams = {
                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                academicTermId: academicTermId,
                                admissionId: admissionId
                        };
                        programFieldStore.load({
                            callback: function (records, opt, success) {
                                if (success) {
                                    batchField.setDisabled(false);
                                    if (!isNullOrEmpty(programId) || records.length == 1) {
                                        if (records.length == 1) {
                                            programId = records[0].data.programId;
                                        }
                                        programField.setValue(programId);
                                        programField.setReadOnly(true);
                                        batchFieldStore.getProxy().extraParams = {
                                                studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                academicTermId: academicTermId,
                                                admissionId: admissionId
                                        };
                                        batchFieldStore.load({
                                            callback: function (records1, opt1, success1) {
                                                if (success1) {
                                                    if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                                        periodField.setDisabled(false);
                                                        if (records1.length == 1) {
                                                            batchId = records1[0].data.batchId;
                                                        }
                                                        batchField.setValue(batchId);
                                                        batchField.setReadOnly(true);
                                             			 
                                                        periodFieldStore.getProxy().extraParams = {
                                             				studentId: me.getContentPanelActiveTab().getRequesterId(),
                                                     		academicTermId:academicTermId,
                                                     		admissionId:admissionId
                                                        };
                                                        periodFieldStore.load({
                                                            callback: function (records1, opt1, success1) {
                                                                if (success) {
                                                                    if (!isNullOrEmpty(periodId) || records1.length == 1) {
                                                                        if (records1.length == 1) {
                                                                            periodId = records1[0].data.periodId;
                                                                        }
                                                                        periodField.setValue(periodId);
                                                                        periodField.setReadOnly(true);
                                                                    }
                                                                }
                                                            }
                                                        });
                                             		 }
                                             		 else{
                                                        periodField.setDisabled(true);
                                                        seatTypeField.setDisabled(true);
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        });
                    }
                }
            },
            'exchangesemesterrequestdetailspanel combo[itemId=fromProgramId]': {
                change: function (combo) {
                    var exchangeSemesterPanel = combo.up('exchangesemesterrequestdetailspanel');
                    var toAcademyLocation = exchangeSemesterPanel.down('#toAcademyLocationItemId');
                    var periodId = this.getContentPanelActiveTab().getPeriodId();
                    var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
                 	toAcademyLocation.getStore().getProxy().extraParams = {
            			periodId : periodId,
        				requestTypeCode:requestTypeCode
            		}
            		toAcademyLocation.getStore().load();
            	}
            },
            
            'exchangesemesterrequestdetailspanel combo[itemId=toAcademyLocationItemId]': {
                select: function (combo) {
                    var exchangeSemesterPanel = this.getExchangesemesterrequestdetailspanel();
                    var toAcademyLocationId = exchangeSemesterPanel.down('#toAcademyLocationItemId').getValue();
                    var fromProgramId = exchangeSemesterPanel.down('#fromProgramId').getValue();
               //     var toCampusField = exchangeSemesterPanel.down('#toCampusId');
                    var toProgramField = exchangeSemesterPanel.down('#toProgramId');
                    var toBatchIdField = exchangeSemesterPanel.down('#toBatchId');
                    var toPeriodField = exchangeSemesterPanel.down('#toPeriodId');
                    var periodId = this.getContentPanelActiveTab().getPeriodId();
            		var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
              //      var toSeatTypeField = exchangeSemesterPanel.down('#toSeatTypeId');
              //      toCampusField.setDisabled(false);
                    toProgramField.setDisabled(false);
              //      toCampusField.reset();
              //      toCampusField.clearValue();
                    toProgramField.reset();
                    toProgramField.clearValue();
                    toBatchIdField.reset();
                    toBatchIdField.clearValue();
                    toPeriodField.reset();
                    toPeriodField.clearValue();
                 //   toSeatTypeField.reset();
                  //  toSeatTypeField.clearValue();
                 //   var toCampusFieldStore=toCampusField.getStore();
                    var toProgramFieldStore = toProgramField.getStore();
                    
                    /*toCampusFieldStore.getProxy().extraParams = {
                       academyLocationId: toAcademyLocationId
                   };
                   toCampusFieldStore.load();*/
                   
                    toProgramFieldStore.getProxy().extraParams = {
                        academyLocationIds: toAcademyLocationId,
                        periodId : periodId,
        				requestTypeCode:requestTypeCode
                    };
                    toProgramFieldStore.load();
                },
                afterrender: function (combo) {
                    var toStore = combo.getStore();
                    toStore.on('load', function () {
                        var exchangeSemesterPanel = combo.up('exchangesemesterrequestdetailspanel');
                        if (!exchangeSemesterPanel) {
                            exchangeSemesterPanel = Ext.ComponentQuery.query('exchangesemesterrequestdetailspanel')[Ext.ComponentQuery.query('exchangesemesterrequestdetailspanel').length - 1];
                        }
                        var fromAcademyLocationId = exchangeSemesterPanel.down('#fromAcademyLocationId').getValue();
                        var idx = toStore.findExact('id', fromAcademyLocationId);
                        toStore.removeAt(idx);
                    });
                }
            },
            'exchangesemesterrequestdetailspanel combo[itemId=toProgramId]': {
                select: function (combo) {
                    var exchangeSemesterPanel = this.getExchangesemesterrequestdetailspanel();
                    var toAcademyLocationCombo = exchangeSemesterPanel.down('#toAcademyLocationItemId');
                    var academicTermCombo = exchangeSemesterPanel.down('#academicTermCombo');
                    var toProgramField = exchangeSemesterPanel.down('#toProgramId');
                    var toBatchIdField = exchangeSemesterPanel.down('#toBatchId');
                    var toPeriodField = exchangeSemesterPanel.down('#toPeriodId');
                    var fromPeriodField = exchangeSemesterPanel.down('#fromPeriodId');
                    var periodId = this.getContentPanelActiveTab().getPeriodId();
            		var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
                 //   var toSeatTypeField = exchangeSemesterPanel.down('#toSeatTypeId');
                    toBatchIdField.setDisabled(false);
                    toBatchIdField.reset();
                    toBatchIdField.clearValue();
                    toPeriodField.reset();
                    toPeriodField.clearValue();
                 //   toSeatTypeField.reset();
                 //   toSeatTypeField.clearValue();
                    var academicTermId = academicTermCombo.getValue();
                    var academyLocationId = null;
                    if(toAcademyLocationCombo != undefined) {
                    	academyLocationId = toAcademyLocationCombo.getValue();
                    }
                    var toProgramId = toProgramField.getValue();
                    var toBatchFieldStore = toBatchIdField.getStore();
                    var toPeriodFieldStore = toPeriodField.getStore();
                    var fromPeriodStore = fromPeriodField.getStore();
                    var periodSequence = fromPeriodField.getStore().data.items[0].raw.programPeriodSeq;
                   // var periodSeq = fromPeriodStore.
                    var batchId;
                    var periodId;
                    toBatchFieldStore.getProxy().extraParams = {
                    	programId: toProgramId,
                        academicTermId: academicTermId,
                        periodSequence: periodSequence,
                        periodId : periodId,
        				requestTypeCode:requestTypeCode,
        				academyLocationId : academyLocationId
                   };
                    toBatchFieldStore.load({
                        /*params: {
                            programId: toProgramId,
                            academicTermId: academicTermId,
                            periodSequence: periodSequence,
                            periodId : periodId,
            				requestTypeCode:requestTypeCode
                        },*/
                        callback: function (records1, opt1, success1) {
                            if (success1) {
                                if (!isNullOrEmpty(batchId) || records1.length == 1) {
                                    if (records1.length == 1) {
                                        batchId = records1[0].data.batchId;
                                    }
                                    toBatchIdField.setValue(batchId);
                                    toBatchIdField.setReadOnly(true);
                                    toPeriodField.setDisabled(false);
                                    toPeriodFieldStore.getProxy().extraParams = {
                                    	programId: toProgramId,
                                        academicTermId: academicTermId,
                                        periodSequence: periodSequence,
                                        periodId : periodId,
                        				requestTypeCode:requestTypeCode,
                        				academyLocationId : academyLocationId
                                   };
                                    toPeriodFieldStore.load({
                                       /* params: {
                                            programId: toProgramId,
                                            academicTermId: academicTermId,
                                            periodSequence: periodSequence
                                        },*/
                                        callback: function (records1, opt1, success1) {
                                            if (success1) {
                                                if (!isNullOrEmpty(periodId) || records1.length == 1) {
                                                    if (records1.length == 1) {
                                                        periodId = records1[0].data.periodId;
                                                    }
                                                    toPeriodField.setValue(periodId);
                                                    toPeriodField.setReadOnly(true);
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            },
            'exchangesemesterrequestdetailspanel combo[itemId=toBatchId]': {
                select: function (combo) {
                    var exchangeSemesterPanel = this.getExchangesemesterrequestdetailspanel();
                    var academicTermCombo = exchangeSemesterPanel.down('#academicTermCombo');
                    var toProgramField = exchangeSemesterPanel.down('#toProgramId');
                    var toBatchIdField = exchangeSemesterPanel.down('#toBatchId');
                    var toPeriodField = exchangeSemesterPanel.down('#toPeriodId');
                 //   var toSeatTypeField = exchangeSemesterPanel.down('#toSeatTypeId');
                    toPeriodField.setDisabled(false);
                 //   toSeatTypeField.setDisabled(false);
                    toPeriodField.reset();
                    toPeriodField.clearValue();
                //    toSeatTypeField.reset();
                 //   toSeatTypeField.clearValue();
                    var periodId;
                    var academicTermId = academicTermCombo.getValue();
                    var toProgramId = toProgramField.getValue();
                    var toBatchId = toBatchIdField.getValue();
                    var toPeriodFieldStore = toPeriodField.getStore();
               //     var toSeatTypeStore=toSeatTypeField.getStore();
                   /* toPeriodFieldStore.getProxy().extraParams = {
                    	programId:toProgramId,
                    	academicTermId:academicTermId
                   };*/
                    toPeriodFieldStore.load({
                        params: {
                            programId: toProgramId,
                            academicTermId: academicTermId
                        },
                        callback: function (records1, opt1, success1) {
                            if (success1) {
                                if (!isNullOrEmpty(periodId) || records1.length == 1) {
                                    if (records1.length == 1) {
                                        periodId = records1[0].data.periodId;
                                    }
                                    toPeriodField.setValue(periodId);
                                    toPeriodField.setReadOnly(true);
                                }
                            }
                        }
                    });
                }
            },
            
            /*'exchangesemesterrequestdetailspanel combo[itemId=toPeriodId]': {
                select: function(combo){
                	var exchangeSemesterPanel =this.getExchangesemesterrequestdetailspanel();
                    var toSeatTypeField = exchangeSemesterPanel.down('#toSeatTypeId');
                    toSeatTypeField.reset();
                    toSeatTypeField.clearValue();
                }
            },*/
            
            'exchangesemesterrequestdetailspanel button[itemId=exchangeSemesterreqUploadSubmitBtn]': {
                click: this.submitExchangeSemesterRequestUploadServiceRequest
            },
            
            
            
            /* Fee Related Request Functions */
            'feerequestservice': {
                cellclick: function (grid, td, cellIndex, record) {
                    var feeGrid = this.getFeerequestservice();
                    this.getOpenFeeInstallment(feeGrid, cellIndex, record);
                },
                select: function (grid, record, index) {
                    var category = record.get("category");
                    if (category === 'INSTALLMENT') {
                        var grid = this.getFeerequestservice();
                        grid.getSelectionModel().setLocked(true);
                    }
                }
            },
            'feerequestservice combo#discountType': {
                select: function (obj, record) {
                    var discountType = record[0].get("value");
                    var store = this.getStore('feeandpayment.DiscountCode');
                    store.getProxy().extraParams = {
                        discountType: discountType
                    };
                    store.load();
                }
            },
            'feerelatedservicerequestinstallmentgrid button[itemId=btnAdd]': {
                click: function () {
                    var grid = this.getFeerelatedservicerequestinstallmentgrid();
                    var store = this.getStore('feeandpayment.feerequest.TempInstallmentStore');
                    store.loadRawData(grid.getStore().getRange(), true);
                    this.getFeerelatedservicerequestinstallmentwin().close();
                }
            },
            'feerequestservice numberfield[itemId=waiverAmountApproved]': {
                blur: function (obj) {
                    var grid = this.getFeerequestservice();
                    var record = grid.getSelectionModel().getSelection()[0];
                    var form = this.getExecutionDetailsPanel();
                    var button = form.down("#executionSubmitBtn");
                    if (obj.getValue() <= record.get("waiverAmountRequested")) {
                        button.preventDefault = true;
                    } else {
                        button.preventDefault = false;
                        record.set("waiverAmountApproved", null);
                        showWarningMessage(getServiceRequestTranslation('EXECUTION_DETAILS'), getFeeAndPaymentCommonTranslation(
                            'AMOUNT_VIEWER_AND_AMOUNT_APPROVED_SHOULD_BE_EQUAL'));
                    }
                }
            },
            /* Complaint request related functions */
            'complaintsearchform button[itemId=complaintFindButtonId]': {
                click: this.loadComplaintGridAndSearchRequest
            },
            'complaintsearchform ': {
                afterrender: this.loadComplaintGridAndSearchRequest
            },
			
			'complaintsearchform radiogroup[itemId=complainFor]': {
			    change: this.loadComplaintGridAndSearchRequest
			 },
			
            'complaintsearchform button[itemId=complaintClearSearch]': {
                click: this.clearSearchFormManageComplaint
            },
            'complaintview searchresultgrid[itemId=complaintSearchResultGrid]': {
                cellclick: function (grid, td, cellIndex, record) {
                    var searchResultGrid = this.getComplaintSearchResultGrid();
                    this.cellclickComplaintTrackRequestGrid(searchResultGrid, cellIndex, record);
                },
                render: function (grid) {
                    this.gridRenderFunction(grid);
                },
                afterrender: function (grid) {
                    this.genericCBGridAccessControlValidation(grid, this.getTOOLSERVICE_COMPLAINT_PERMISSIONS());
                    var viewButton = grid.down("#searchResultGridBtnView");
                    viewButton.setVisible(false);
                }
            },
            'complaintview advancedsearchquerybuilder[itemId=complaintAdvanceSearch] searchresultgrid[itemId=userAdvSearchResultGrid]': {
                cellclick: function (view, td, cellIndex, record) {
                    var searchResultGrid = view.up('grid');
                    this.cellclickComplaintTrackRequestGrid(searchResultGrid, cellIndex, record);
                },
                render: function (grid) {
                    this.gridRenderFunction(grid);
                },
                afterrender: function (grid) {
                    this.genericCBGridAccessControlValidation(grid, this.getTOOLSERVICE_COMPLAINT_PERMISSIONS());
                    var viewButton = grid.down("#searchResultGridBtnView");
                    if (!isNullOrEmpty(viewButton) && viewButton != 'undefined') {
                        viewButton.setVisible(false);
                    }
                }
            },
            'complaintdetailsform button[itemId=btnSaveComplaint]': {
                click: this.saveComplaintServiceRequest
            },
            'complaintdetailsform combo[itemId=complaintAgainstId]': {
                select: this.changeSelectPersonComboName
            },
            'complaintdetailsform combo[itemId=selectPersonId]': {
                blur: this.validateComplaintAgainstValue
            },
            'complaintdetailsform combo[itemId=complaintTypeId]': {
                render: this.loadComplaintTypeCombo,
                select: this.getSettings
            },
            'complaintdetailsform': {
                afterrender: function (form) {
                    this.customzingViewForStudentPortalWhileRaiseComplaint();
                    var formFields = form.getForm().getFields().items;
                    form.body.on('scroll', function (e, target) {
                        Ext.each(formFields, function (field) {
                            if ((field.xtype == 'customcombobox' || field.xtype == 'livesearchcombo') && field.getPicker()) {
                                if (field.getPicker().isVisible()) {
                                    field.getPicker().hide();
                                }
                            }
                        });
                    });
                }
            },
            'complaintdetailsform combo[itemId=complaintById]': {
                select: this.changeSelectComplaintantComboName
            },
            /**
             * Export Button for Tools and Services Complaint**
             */
            'searchresultgrid[itemId=complaintSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
                click: function () {
                    this.exportRequest(SERVERURL.PDFEXPORT, 'pdf', false, 'TOOLSERVICECOMPLAINT');
                }
            },
            'searchresultgrid[itemId=complaintSearchResultGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
                click: function () {
                    this.exportRequest(SERVERURL.PDFEXPORT, 'pdf', true, 'TOOLSERVICECOMPLAINT');
                }
            },
            'searchresultgrid[itemId=complaintSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
                click: function () {
                    this.exportRequest(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', false, 'TOOLSERVICECOMPLAINT');
                }
            },
            'searchresultgrid[itemId=complaintSearchResultGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
                click: function () {
                    this.exportRequest(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', true, 'TOOLSERVICECOMPLAINT');
                }
            },
            // Exam Related Request
            'examrequestdetailspanel combo#evaluationPlanId': {
                render: function (combo) {
                    var store = combo.getStore();
                    store.load();
                },
                select: this.loadEvaluationSequenceCombo
            },
            'examrequestdetailspanel combo#evaluationTypeId': {
                render: function (combo) {
                    var store = combo.getStore();
                    store.load();
                }
            },
            'revaluationofexampaperform #isOriginalRadio': {
                change: this.toggleQuestionWiseSection
            },
            'examrequestdetailspanel #submitBtn': {
                click: this.saveExamRelatedRequest
            },
            'applyforplacementdetailspanel combo[itemId=programId]': {
                render: this.loadPlacementProgramComboStore,
                select: this.loadPeriodComboStore
            },
            // withdraw subscribe services request
            'withdrawformservicedetailspanel combo#servicesOpted': {
                render: this.loadServiceOptedCombo
            },
            'withdrawformservicedetailspanel combo#alreadySubscribedServices': {
                render: this.loadServiceWithdrawCombo
            },
            'withdrawformservicedetailspanel #subSubmitBtn': {
                click: this.saveWithdrawSubscribeServiceRequest
            },
            'withdrawformservicedetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'withdrawformservicedetailspanel #whetherSubscribed': {
                change: this.toggleServiceSubscribeCombo
            },
            /** Document Integration * */
            'servicerequestmandatorydocuments': {
                cellclick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    var $this = this;
                    if (columnName == "document") {
                        if (e.target.tagName == 'A') {
                            if (!isNullOrEmpty(record.data.documentRule) && !isNullOrEmpty(record.data.documentRule.document)) {
                                var documentId = record.data.documentRule.document.id;
                                if (!isNullOrEmpty(documentId)) {
                                    $this.getDocumentController().downloadDocumentFile(documentId);
                                }
                            }
                        }
                    }
                }
            },
            'servicerequestvoluntarydocuments': {
                cellclick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    var $this = this;
                    if (columnName == "name") {
                        if (e.target.tagName == 'A') {
                            if (!isNullOrEmpty(record.data)) {
                                var documentId = record.raw.encryptedDocId;
                                if (!isNullOrEmpty(documentId)) {
                                    $this.getDocumentController().downloadDocumentFile(documentId);
                                }
                            }
                        }
                    }
                },
                beforerender: function (cmp) {
                    Ext.defer(function () {
                    	if(cmp && cmp.el) {
                    		var style = document.createElement('style');
                    		style.type = 'text/css';
                    		var fullWidth = cmp.getWidth();
                    		style.innerHTML = '.small-grid .x-header-text-container { width: ' + fullWidth + 'px !important;left: 0px !important; } .small-grid .x-header-text { margin-left: 0px !important; }';
                    		document.getElementsByTagName('head')[0].appendChild(style);
                    		cmp.addCls('small-grid');
                    	}
                    }, 500);
                }
            },
            'servicerequestmandatorydocuments button[itemId=btnUploadDocument]': {
                click: function (button) {
                    //this.showServiceRequestDocumentForm(button);
                    this.showServiceRequestNewDocumentForm(button);
                }
            },
            'servicerequestmandatorydocuments button[itemId=btnEdit]': {
                click: this.EditDocumentForm
            },
            'servicerequestmandatorydocuments button[itemId=btnDownloadDocument]': {
                click: function (button) {
                    this.downloadServiceRequestMandatoryDocument(button);
                }
            },
            'documentformwindow[itemId=serviceRequestDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                //click: this.saveServiceRequestDocumentForm
            },
            'documentformwindow[itemId=serviceRequestNewDocumentForm] servicerequestnewdocform[itemId=servicerequestnewdocform] button[itemId=documentFormSubmitButtonId]': {
                click: this.saveServiceRequestDocumentNewForm
            },
            'documentformwindow[itemId=serviceRequestNewDocumentForm] servicerequestnewdocform[itemId=servicerequestnewdocform] button[itemId=documentCancelButtonId]': {
                click: function (button) {
                    this.getDocumentController().closeDocumentFormWindow();
                }
            },
            'documentformwindow[itemId=serviceRequestDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentCancelButtonId]': {
                click: function (btn) {
                    btn.up('window').close();
                }
            },
            'servicerequestdocumentspanel #btnSaveRequestWithDocuments': {
                click: this.saveServiceRequest
            },
            'servicerequestactiondetailspanel': {
                afterrender: function (pnl) {
                    var actionGrid = pnl.down('grid');
                    var gridStore = actionGrid.getStore();
                    gridStore.on('load', function () {
                        if (!isNullOrEmpty(actionGrid.down('#btnAdd'))) {
                            if (gridStore.getCount() >= 2) {
                                actionGrid.down('#btnAdd').hide();
                			}
                			else{
                                actionGrid.down('#btnAdd').show();
                            }
                            try {
                                if (portalId == 3) {
                                    actionGrid.down('#btnAdd').hide();
                                }
                        }
                			catch(e){
                				//--
                			}
            				
            			}
                    });
                    var serviceRequestId = this.getContentPanelActiveTab().getServiceRequestId();
                    var requestGroup = this.getContentPanelActiveTab().getRequestGroup();
                    gridStore.getProxy().extraParams = {
                        id: serviceRequestId
                    };
                    gridStore.load();
                    if(requestGroup == 'EXAM_CONCESSION'){
                    	pnl.setTitle(getServiceRequestTranslation('EXAM_CONCESSION_APPROVAL_DETAIL'))
                    }
                }
            },
            'servicerequestactiondetailspanel #btnAdd': {
                click: function (btn) {
                    var me = this;
                    var actionGrid = btn.up('grid');
                    var gridStore = actionGrid.getStore();
                    if (gridStore.getCount() == 0) {
                        me.openRequestActionWin(1);
            		}
            		else if(gridStore.getCount() == 1){
                        me.openRequestActionWin(2);
                    }
                }
            },
            'servicerequestactiondetailspanel #btnView': {
                click: function (btn) {
                    var me = this;
                    var actionGrid = btn.up('grid');
                    var gridStore = actionGrid.getStore();
                    var selection = actionGrid.getSelectionModel().getSelection();
                    btn.removeCls('x-btn-default-toolbar-small-focus');
                    if (selection.length) {
                        var requestactionlevelwindow = this.getRequestactionlevelwindow();
                        if (!requestactionlevelwindow) {
                            Ext.widget('requestactionlevelwindow', {
                                level: 2,
                                title: getCommonTranslation('REQUEST_ACTION_LEVEL') + ' 1'
                            });
                            requestactionlevelwindow = this.getRequestactionlevelwindow();
                        }
                        requestactionlevelwindow.btnView = 'btnView';
                        requestactionlevelwindow.show();
                        requestactionlevelwindow.down('#recommendedConcessionsAddBtn').hide();
                        requestactionlevelwindow.down('#requestActionFormSubmitBtn').hide();
                        Ext.defer(function () {
                            var initialFields = requestactionlevelwindow.query('field');
                            for (var i = 0; i < initialFields.length; i++) {
                                initialFields[i].setReadOnly(true);
                                if (initialFields[i].getItemId() == 'recommendedConcessions') {
                                    initialFields[i].el.dom.querySelector('input').setAttribute('readOnly', true);
                                    initialFields[i].setHeight(initialFields[i].getHeight() + 1);
                                }
                            }
                        }, 100);
                        var recommendedConcessionsCombo = requestactionlevelwindow.down('#recommendedConcessions');
                        recommendedConcessionsCombo.getStore().load({
                            callback: function () {
                                var formData = selection[0].data;
                                var store = me.getServicerequestactiondetailspanel().down('grid').getStore();
                                var rawData = store.proxy.reader.rawData;
                                /*var examConcessionIds = [];
                                for (var r = 0; r < rawData.length; r++) {
                                    if (examConcessionIds.indexOf(rawData[r].examConcessionId) == -1) {
                                        examConcessionIds.push(rawData[r].examConcessionId);
                                    }
                                }*/
                                var concessionIds = formData.concessionMap[formData.examConcessionDurationDetailId];
                                recommendedConcessionsCombo.setValue(concessionIds);
                                var recommendedConcessionsAddBtn = requestactionlevelwindow.down('#recommendedConcessionsAddBtn');
                                recommendedConcessionsAddBtn.fireEvent('click', recommendedConcessionsAddBtn, formData);
                                var approverName = '';
                                if (formData.approverFirstName || formData.approverLastName) {
                                    approverName = formData.approverFirstName + ' ' + formData.approverLastName;
                                }
                                requestactionlevelwindow.down('form').getForm().setValues({
                 					//recommendedConcessions: formData.examConcessionId,
                                    startDate: dateRender(formData.startDate),
                                    tillDate: dateRender(formData.endDate),
                                    plannedActionDate: dateRender(formData.plannedActionDate),
                                    actualActionDate: dateRender(formData.actualActionDate),
                                    requestActionStatus: formData.requestActionStatus,
                                    approverName: approverName,
                                    remarks: formData.remark
                                });
                                Ext.defer(function () {
                                    var fields = requestactionlevelwindow.query('field');
                                    for (var i = 0; i < fields.length; i++) {
                                        fields[i].setReadOnly(true);
                                        if (fields[i].getItemId() == 'recommendedConcessions') {
                                            fields[i].el.dom.querySelector('input').setAttribute('readOnly', true);
                                            fields[i].setHeight(fields[i].getHeight() + 1);
                                        }
                                    }
                                }, 500);
                            }
                        });
            		}
            		else{
                        return showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
            		/*if(gridStore.getCount() == 0){
            			me.openRequestActionWin(1, 'btnView');
                }
            		else if(gridStore.getCount() == 1){
            			me.openRequestActionWin(2, 'btnView');
            		}*/
            	}
            },
            'servicerequestvoluntarydocuments #btnAdd': {
                click: function (btn) {
                    this.getDocumentController().showDocumentFormWindow('serviceRequestVoluntaryDocumentForm', 'DOCUMENT');
                }
            },
            'documentformwindow[itemId=serviceRequestVoluntaryDocumentForm] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                click: this.saveServiceRequestVoluntaryDocument
            },
            'servicerequestvoluntarydocuments #btnDownload': {
                click: function (button) {
                    this.downloadServiceRequestVoluntaryDocument(button);
                }
            },
            'servicerequestvoluntarydocuments #btnDelete': {
                click: function (button) {
                    this.deleteServiceRequestVoluntaryDocument(button);
                }
            },
            'documentformwindow[itemId=serviceRequestDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] #fileDisplayField': {
                render: function (component) {
                    var me = this;
                    component.getEl().on('click', function (e) {
                        me.downloadServiceRequestMandatoryDocument();
                    });
                }
            },
            // exam request related functions
            'commonfieldsform combo[itemId=evaluationPlan]': {
                select: this.loadEvalDetailCombo
            },
            'changeofexamdateform commonfieldsform[itemId=dateCommonForm] combo#evaluationDetailedSequenceId': {
                select: this.loadExamBatchDateCombo
            },
            'changeofexamcenterform commonfieldsform[itemId=centerCommonForm] combo[itemId=evaluationDetailedSequenceId]': {
                select: this.loadExamCenterCombo
            },
            'withdrawalofexam commonfieldsform[itemId=withdrawCommmonForm] combo[itemId=evaluationDetailedSequenceId]': {
                select: this.loadCurrentDateAndCenterCombo
            },
            'lackofothercriteriaform commonfieldsform[itemId=lackCriteriaCommonForm] combo[itemId=evaluationDetailedSequenceId]': {
                select: this.setCourseValue
            },
            'examleaverequestform commonfieldsform[itemId=leaveCommonForm] combo[itemId=evaluationDetailedSequenceId]': {
                select: this.loadCurrentDateAndCenterCombo
            },
            'lackofattendancegrid': {
                render: this.loadLackOfAttendanceGrid
            },
            'requestforreexaminationform commonfieldsform[itemId=reExaminationCommonForm] combo[itemId=evaluationDetailedSequenceId]': {
                select: this.loadCurrentDateAndCenterCombo
            },
            'examrequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'revaluationofexampaperform commonfieldsform[itemId=revaluationOfExamCommonForm] combo[itemId=evaluationDetailedSequenceId]': {
                select: this.loadQuestionPaperCodes
            },
            'revaluationofexampaperform combo[itemId=questionPaperCodeId]': {
                select: this.loadQuestionNoCombo
            },
            'revaluationofexampaperform combo[itemId=questionNoId]': {
                select: this.loadQuestionNoPartCombo
            },
            'revaluationofexampaperform combo[itemId=questionNoPartId]': {
                select: this.loadQuestionNoSubPartCombo
            },
            'revaluationofexampaperform combo[itemId=questionNoPart1Id]': {
                select: this.loadQuestionsGrid
            },
            'lackofattendanceform grid[itemId=lackOfAttendanceGridId]': {
                render: this.loadAttendanceGrid
            },
            /** Fees and Payment Integration * */
            'billdetailsgrid': {
                render: this.loadBillDetailsStore
            },
            'refunddetailsgrid': {
                render: this.loadRefundDetailsStore
            },
            /** Section Trnasfer */
            'sectionrequestdetailspanel #ProgramId': {
                render: this.loadProgramCombo,
                select: this.loadBatchSectionTextFields
            },
            'sectionrequestdetailspanel #courseId': {
                select: function (combo, records) {
                    this.loadToSectionComboForCourse(combo, records);
                }
            },
            'sectionrequestdetailspanel #btnSaveRequestDetails': {
                click: this.saveSectionTransferRequest
            },
            'sectionrequestdetailspanel #isProgram': {
                change: this.toggleCourseCombo
            },
            'sectionrequestdetailspanel #hiddenBatchId': {
                change: this.loadCourseCombo
            },
            'sectionrequestdetailspanel': {
                render: this.toggleTransferModeRadioButton
            },
            'sectionrequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            /**
             * request and request sub type combo event handling
             */
            'fieldcontainer[itemId=requestTypeFieldContainer] combo[itemId=requestTypeField]': {
                select: function (combo, records, value) {
                    this.onRequestTypeSelectionDropdown(combo);
                }
            },
            'fieldcontainer[itemId=requestTypeFieldContainer] combo[itemId=certificateCategoryField]': {
                select: function (combo, records, value) {
                    this.onCategorySelectionDropdown(combo);
                }
            },
            'fieldcontainer[itemId=requestTypeFieldContainer] combo[itemId=freeFormCategoryField]': {
                select: function (combo, records, value) {
                    this.onCategorySelectionDropdown(combo);
                }
            },
            'findrequestform combo[itemId=selectedNameField]': {
                render: function (obj) {
                    var store = obj.getStore();
                    obj.setValue(store.data.items[0].data.id);
                },
                change: function (combo, records, value) {
                    this.changeNameFieldConfig(combo);
                }
            },
            'findrequestform combo[itemId=assigneeId]': {
                render: function (combo, records, value) {
                    var $this = this;
                    var academyLocationId = $this.getCurrentAcademyLocation();
                    var form = $this.getFindRequestForm();
                    var requestAssignedTo = form.down("#assigneeId");
                    var assigneeCombo = form.down("#assigneeCombo");
                    assigneeCombo.setVisible(false);
                    if ($this.getCurrentLoggedPortalId() != 2) {
                        var store = requestAssignedTo.getStore();
                        store.getProxy().extraParams = {
                            academyLocationId: academyLocationId
                        };
                        //store.load();
                        requestAssignedTo.setDisabled(false);
                    } else {
                        requestAssignedTo.setDisabled(true);
                    }
                }
            },
            'facultyfindrequestform combo[itemId=assignTo]': {
                render: function (combo, records, value) {
                    var $this = this;
                    var academyLocationId = $this.getCurrentAcademyLocation();
                    var form = $this.getFindRequestForm();
                    var requestAssignedTo = form.down("#assignTo");
                    var assigneeCombo = form.down("#assigneeCombo");
                    assigneeCombo.setVisible(false);
                    if ($this.getCurrentLoggedPortalId() != 2) {
                        var store = requestAssignedTo.getStore();
                        store.getProxy().extraParams = {
                            academyLocationId: academyLocationId
                        };
                        store.load();
                        requestAssignedTo.setDisabled(false);
                    } else {
                        requestAssignedTo.setDisabled(true);
                    }
                }
            },
            'facultyfindrequestform combo[itemId=selectedNameField]': {
                change: function (combo, records, value) {
                    this.changeNameFieldConfig(combo);
                }
            },
            'approverfeerequestdetailgrid gridview': {
                expandbody: function (rowNode, record, expandRow, eOpts) {
                    var grid = this.getApproverFeeRequestDetailGrid();
                    this.ExpandRowBody(rowNode, grid, record, expandRow);
                }
            },
            'employeeleaverequestdetailspanel button[itemId=addFilterBtn]': {
                click: function (obj) {
                    this.addMultipleLeaveType(obj);
                }
            },
            'employeeleaverequestdetailspanel button[itemId=leaveSubmitBtn]': {
                click: this.saveEmployeeLeaveServiceRequest
            },
            'searchresultgrid[itemId=trackRequestGrid] button[itemId=raiseRequestBtn]': {
                click: function (obj) {
            		//this.openCommonRaiseRequestWindow();
                    var this$ = this;
                    var window = this$.getStdandparentraiseservicerequestwindow();
                    if (!window) {
                        window = Ext.widget('stdandparentraiseservicerequestwindow');
                    }
                    window.show();
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                }
            },
            'studentportalstudentrequestgrid button[itemId=raiseRequestBtn]': {
                click: function (obj) {
                    var this$ = this;
                    var window = this$.getStdandparentraiseservicerequestwindow();
                    if (!window) {
                        window = Ext.widget('stdandparentraiseservicerequestwindow');
                    }
                    window.show();
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                }
            },
            'searchresultgrid[itemId=trackRequestGrid] button[itemId=cancelBtnRequestId]': {
                click: function (button) {
                	var formWindow = this.getCancellationReasonPopupWindow();
            		if (!formWindow) {
            			formWindow = Ext.widget('cancellationReasonPopupWindow');
            			formWindow.show();
            		}
                   
                }
            },
            'cancellationReasonPopupWindow button[itemId=submitBtn]' : {
   			 click :function(button){
   				 this.cancelRequestForStudentTransferAL(button);
   			 } 
   		 },
            
            'searchresultgrid[itemId=trackRequestGrid] #closeBtnRequestId': {
                click: function (button) {
                    var grid = this.getContentPanelActiveTab().down('#trackRequestGrid');
                    var records = grid.getSelectionModel().getSelection();
                    var approvalDetailsArray = [];
                    var docArray = [];
                    var apprvalDetailsStudentTranssfer=[];
                    Ext.each(records, function (currentRecord) {
                        var values = new Object();
                        values.executionDate = "";
                        values.admissionDate = "";
                        values.closureReasonId = "";
                        values.remark = "";
                        values.isRetainData = false;
                        values.serviceRequestId = currentRecord.data.ID;
                        values.user = this$.getCurrentlyLoggedInUser();
                        approvalDetailsArray.push(values);
                    });
                    
                    Ext.each(records, function (currentRecord) {
                        var values = new Object();
                        values.effectiveTransferDate = "";
                        values.executionDate = "";
                        values.closureReasonId = "";
                        values.remark = "";
                        values.isRetainStudentData = false;
                        values.isStudentFeeSettled = false;
                        values.isRequiredDocumentUploaded = false;
                        values.serviceRequestId = currentRecord.data.ID;
                        values.user = this$.getCurrentlyLoggedInUser();
                        values.documents = docArray;
                        values.isStudentTranssfer=true;
                        apprvalDetailsStudentTranssfer.push(values);
                        
                    });
                    var terminationrequestclosurewin = this.getTerminationrequestclosurewin();
                    var studenttransferclosurewin = this.getStudenttransferclosurewin();
                    if (!terminationrequestclosurewin &&records[0].raw.REQUEST_TYPE!='Student transfer') {
                        Ext.widget('terminationrequestclosurewin', {
                            approvalDetailsArray: approvalDetailsArray,
                            grid: grid
                        });
                        terminationrequestclosurewin = this.getTerminationrequestclosurewin();
                        terminationrequestclosurewin.show();
                    }
                    else if (!studenttransferclosurewin && records[0].raw.REQUEST_TYPE=='Student transfer') {
                        Ext.widget('studenttransferclosurewin', {
                        	approvalDetailsArray: apprvalDetailsStudentTranssfer,
                            grid: grid
                        });
                        studenttransferclosurewin = this.getStudenttransferclosurewin();
                        studenttransferclosurewin.show();
                    }
                    
                }
            },
          
            'searchresultgrid[itemId=trackRequestGrid] #reassignBtnRequestId': {
                click: function (button) {
                    var grid = this.getContentPanelActiveTab().down('#trackRequestGrid');
                    var records = grid.getSelectionModel().getSelection();
                    var approvalDetailsArray = [];
                    var reassignrequestservicerequestwin = this.getReassignrequestservicerequestwin();
                    if (!reassignrequestservicerequestwin) {
                        Ext.widget('reassignrequestservicerequestwin');
                        reassignrequestservicerequestwin = this.getReassignrequestservicerequestwin();
                    }
                    reassignrequestservicerequestwin.show();
                }
            },
            'reassignrequestservicerequestwin ': {
                render: function () {
                    var $this = this;
                    var window = $this.getReassignrequestservicerequestwin();
                    var grid = $this.getStudentSearchResultGrid();
                    var record = grid.getSelectionModel().getSelection()[0].data;
                    var userComboBox = window.down('#facultyCodeItemId');
                    userComboBox.getStore().load({
                        callback: function (records, operation, success) {
                            if (success) {
                                userComboBox.setValue(record.ASSIGNED_TO);
                            }
                        }
                    });
                }
            },
            'terminationrequestclosurewin button[itemId=formSubmitButtonId]': {
                click: function (btn) {
                	btn.setDisabled(true);
                    this.closeAllSelectedRecords(btn);
                }
            },
            'studenttransferclosurewin button[itemId=formSubmitButtonId]': {
                click: function (btn) {
                	btn.setDisabled(true);
                    this.closeAllSelectedRecords(btn);
                }
            },
            'terminationrequestclosurewin button[itemId=winCancelBtn]': {
                click: function (btn) {
                    var win = btn.up('window');
                    win.close();
                }
            },
            'reassignrequestservicerequestwin button[itemId=formSubmitButtonId]': {
                click: function (btn) {
                    this.closeAllReAssignRequestSelectedRecords(btn);
                }
            },
            'reassignrequestservicerequestwin button[itemId=winCancelBtn]': {
                click: function (btn) {
                    var win = btn.up('window');
                    win.close();
                }
            },
            'searchresultgrid[itemId=trackRequestGrid] button[itemId=approveBtnRequestId]': {
                click: function (button) {
                    var grid = button.up('grid');
                    var records = grid.getSelectionModel().getSelection();
                    var approvalDetailsArray = [];
                    Ext.each(records, function (currentRecord) {
                        var values = new Object();
                        values.remarks = "Auto Approve";
                        values.requestStatusId = "4";
                        values.actionDate = Ext.Date.format(new Date(), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
                        values.approvedScholarshipAmount = null;
                        values.serviceRequestId = currentRecord.data.ID;
                        values.user = this$.getCurrentlyLoggedInUser();
                        approvalDetailsArray.push(values);
                    });
                    this.submitEscalateDetailsRecords(approvalDetailsArray, records);
                }
            },
            'searchresultgrid[itemId=trackRequestGrid] button[itemId=rejectBtnRequestId]': {
                click: function (button) {
                    var grid = button.up('grid');
                    var records = grid.getSelectionModel().getSelection();
                    var approvalDetailsArray = [];
                    Ext.each(records, function (currentRecord) {
                        var values = new Object();
                        values.remarks = "Auto Reject";
                        values.requestStatusId = "5";
                        values.actionDate = Ext.Date.format(new Date(), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
                        values.approvedScholarshipAmount = null;
                        values.serviceRequestId = currentRecord.data.ID;
                        values.user = this$.getCurrentlyLoggedInUser();
                        approvalDetailsArray.push(values);
                    });
                    this.submitEscalateDetailsRecords(approvalDetailsArray, records);
                }
            },
            'searchresultgrid[itemId=trackRequestGrid] button[itemId=uploadDocumentBtn]': {
                click: function (obj) {
                    var grid = this.getStudentSearchResultGrid();
                    var recLen = grid.getSelectionModel().getCount();
                    if (recLen > 0) {
                        var docWin = Ext.widget('servicerequestuploaddocwin');
                        var dataview = docWin.down('#serviceReqDocDataViewAddWin');
                        var store = dataview.getStore();
                        store.removeAll();
                        docWin.show();
                    } else {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'studentportalstudentrequestgrid button[itemId=uploadDocumentBtn]': {
                click: function (obj) {
                    var grid = obj.up('grid');
                    var recLen = grid.getSelectionModel().getCount();
                    if (recLen > 0) {
                        var docWin = Ext.widget('servicerequestuploaddocwin');
                        var dataview = docWin.down('#serviceReqDocDataViewAddWin');
                        var store = dataview.getStore();
                        store.removeAll();
                        docWin.show();
                    } else {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'servicerequestuploaddocwin button#cancelImageBtnWin': {
                click: function () {
                    var docWin = this.getServicerequestuploaddocwin();
                    docWin.close();
                }
            },
            'servicerequestuploaddocwin button#submitBtn': {
                click: function (btn) {
                    var docWin = this.getServicerequestuploaddocwin();
                    this.uploadVoluntaryDocuments(btn);
                }
            },
            'studentcomplaintdetailsform combo[itemId=complaintAgainstId]': {
                select: this.changeSelectPersonComboName
            },
            'studentcomplaintdetailsform combo[itemId=complaintTypeId]': {
                render: this.loadComplaintTypeCombo,
                select: this.getSettings
            },
            'studentcomplaintdetailsform button[itemId=btnSaveComplaint]': {
                click: this.saveComplaintServiceRequestStudentPortal
            },
            'searchresultgrid[itemId=facultytrackRequestGrid] button[itemId=raiseRequestBtn]': {
                click: function (obj) {
                    this.openCommonRaiseRequestWindow();
                }
            },
            'facultyfindrequestform ': {
                render: function () {
                    var form = this.getFacultyFindRequestForm();
                    if (this.getCurrentLoggedPortalId() == 2) {
                        form.down('#selectedNameField').setVisible(false);
                        form.down('#selectedName').setVisible(false);
                        form.down('#beyond_SLA').setVisible(false);
                        form.down('#assigneeCombo').setVisible(false);
                        form.down('#request_id').setVisible(false);
                    }
                    //this.loadFacultyGridAndSearchRequest();
                }
            },
            'studentcomplaintdetailsform #withdrawButtonId': {
                click: function (button) {
                    this.withdrawComplaintRequest(button);
                }
            },
            'commonrequestcombopanel combo[itemId=serviceRequestCategoryCombo]': {
                select: function (combo, records) {
                    var value = records[0].get('value');
                    this.loadOnRequestComboChange(value);
                }
            },
            'commonrequestcombopanel combo[itemId=RequestCategoryCombo]': {
                select: function (combo, records) {
                    var value = records[0].get('value');
                    this.loadOnCategoryComboChange(value);
                }
            },
            'commonrequestcombopanel combo[itemId=serviceRequestCombo]': {
                select: function (combo, records) {
                    $this = this
                    var value = records[0];
                    var requestGroup = combo.up('panel').down('#serviceRequestCategoryCombo').getValue();
                    var serviceRequestCombo = combo.up('panel').down('#serviceRequestCombo').getValue();
                    var grid = $this.getStudentSearchResultGrid();
                    if (this.getCurrentLoggedPortalId() == 2) {
                        this.openServiceRequestTab('FACULTY_REQUEST', requestGroup, value);
                    }
                    if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
                        var academyLocationId = this.getCurrentAcademyLocation();
                        var studentId = $this.getCurrentlyLoggedInUserInfoForPortal().student.id;
                        var personId = this.getCurrentlyLoggedInUserWithPersonId();
                        if (value != undefined && value.data.code == 'HLR') {
                            Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.FIND_WHETHER_CHECKEDIN,
                                method: 'GET',
                                params: {
                                    studentId: studentId
                                },
                                async: false,
                                success: function (response, action) {
                                    var requestTypeId = serviceRequestCombo;
                                    var resp = Ext.JSON.decode(response.responseText);
                                    if (resp == true) {
                                        Ext.Ajax.request({
                                            method: "GET",
                                            type: 'rest',
                                            url: SERVERURL.PATH_FIND_BY_IS_STUDENT_ADISOR_NAME,
                                            params: {
                                                requestTypeId: requestTypeId,
                                                academyLocationId: academyLocationId,
                                                serviceRequestCategory: "STUDENT_REQUEST"
                                            },
                                            headers: {
                                                'Content-Type': 'application/json'
                                            },
                                            success: function (f, action) {
                                                var advisorVal = Ext.decode(f.responseText);
                                                if (advisorVal == true) {
                                                    Ext.Ajax.request({
                                                        type: 'rest',
                                                        url: SERVERURL.PATH_FIND_BY_ADISOR_NAME_BY_PERSON_ID,
                                                        method: 'GET',
                                                        params: {
                                                            personId: personId.id,
                                                        },
                                                        headers: {
                                                            'Content-Type': 'application/json'
                                                        },
                                                        async: false,
                                                        success: function (response, action) {
                                                            var resp = Ext.JSON.decode(response.responseText);
                                                            if (resp != null) {
                                                                $this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, value);
                                                                combo.up('panel').up('window').close();
                                                            } else {
                                                                showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('ADVISOR_NAME_IS_NOT_FOUND'));
                                                            }
                                                        }
                                                    });
                                                } else {
                                                    $this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, value);
                                                    combo.up('panel').up('window').close();
                                                }
                                            }
                                        });
                                    } else {
                                        showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('STUDENT_NOT_CHECKED_IN'));
                                    }
                                }
                            });
                        } else if (value != undefined && value.data.code == 'LR') {
                            var requestTypeId = serviceRequestCombo;
                            var academyLocationId = this.getCurrentAcademyLocation();
                            Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.PATH_FIND_BY_IS_STUDENT_ADISOR_NAME,
                                method: 'GET',
                                params: {
                                    requestTypeId: requestTypeId,
                                    academyLocationId: academyLocationId,
                                    serviceRequestCategory: "STUDENT_REQUEST"
                                },
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                async: false,
                                success: function (response, action) {
                                    var resp = Ext.JSON.decode(response.responseText);
                                    if (resp == true) {
                                        Ext.Ajax.request({
                                            type: 'rest',
                                            url: SERVERURL.PATH_FIND_BY_ADISOR_NAME_BY_PERSON_ID,
                                            method: 'GET',
                                            params: {
                                                personId: personId.id,
                                            },
                                            headers: {
                                                'Content-Type': 'application/json'
                                            },
                                            async: false,
                                            success: function (response, action) {
                                                var resp = Ext.JSON.decode(response.responseText);
                                                if (resp.value != null) {
                                                    $this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, value);
                                                    combo.up('panel').up('window').close();
                                                } else {
                                                    showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('ADVISOR_NAME_IS_NOT_FOUND'));
                                                }
                                            }
                                        });
                                    } else {
                                        $this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, value);
                                        combo.up('panel').up('window').close();
                                    }
                                }
                            });
                        } else {
                            this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, value);
                        }
                    }
                }
            },
            'commonraiseservicerequestwindow commonrequestcombopanel button[itemId=cancelButtonId]': {
                click: function (btn) {
                    this.loadFacultyGridAndSearchRequest();
                    this.loadStudentGridAndSearchRequest();
                    btn.up('form').up('window').close();
                }
            },
            'commonraiseservicerequestwindow commonrequestcombopanel[itemId=commonrequestcombopanelId]': {
                render: function (form) {
                    var serviceRequestCategoryCombo = form.down('#serviceRequestCategoryCombo');
                    var academyLocationId = this.getCurrentAcademyLocation();
                    var store = serviceRequestCategoryCombo.getStore();
                    if (this.getCurrentLoggedPortalId() == 2) {
                        store.proxy.extraParams = {
                            serviceRequestCategory: 'FACULTY_REQUEST',
                            academyLocationId: academyLocationId
                        };
                        store.load();
                    } else if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
                        store.proxy.extraParams = {
                            serviceRequestCategory: 'STUDENT_REQUEST',
                            academyLocationId: academyLocationId
                        };
                        store.load();
                    }
                }
            },
            'commonraiseservicerequestwindow': {
                afterrender: function () {
                    this.loadGridForFacultyPortal();
                },
                close: function (obj) {
                    this.loadFacultyGridAndSearchRequest();
                    this.loadStudentGridAndSearchRequest();
                }
            },
            'followupdetailspopupwindow button[itemId=studentTransferFollwupDocument]': {
                click: function () {
                    this.getDocumentController().showDocumentFormWindow('studentTransferFollowupDetailFormId', 'DOCUMENT');
                }
            },
            'studenttransferfollwupdocumentgrid button#btnDelete': {
                click: function () {
                    var $this = this;
                    var grid = $this.getStudenttransferfollwupdocumentgrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        showConfirmMessage(getCommonTranslation('DOCUMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function (btn, text) {
                            if (btn == 'yes') {
                                var store = grid.getStore();
                                var record = grid.getSelectionModel().getSelection()[0];
                                var id = record.get("id");
                                if (record) {
                                    store.remove(record);
                                    showSuccessMessage(getCommonTranslation('DOCUMENT'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
                                }
                            }
                        });
                    } else {
                        showWarningMessage(getCommonTranslation('DOCUMENT_NAME'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'documentformwindow[itemId=studentTransferFollowupDetailFormId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                click: function () {
                    var $this = this;
                    var isTransient = true;
                    var module = 'studentTransferFollowup';
                    var entityId;
                    var entityType = 'studentTransferFollowup';
                    $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function (success, response, isCallBackTransient) {
                        var documentModel = new Academia.model.servicerequest.studentservicerequest.StudentTransferFollwupDocumentModel();
                        documentModel.set("documentName", response.name);
                        documentModel.set("path", response.path);
                        documentModel.set("type", response.type);
                        documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));
                        var store = $this.getStore('servicerequest.studentservicerequest.StudentTransferFollwupDocumentStore');
                        store.add(documentModel);
                        $this.getDocumentController().closeDocumentFormWindow();
                    }, isTransient);
                }
            },
            'studenttransferexecutiondetailspanel button[itemId=studentTransferExecutionDocument]': {
                click: function () {
                    this.getDocumentController().showDocumentFormWindow('studentTransferExecutionDetailFormId', 'DOCUMENT');
                }
            },
            'studenttransferexecutiondetailspanel datefield[itemId=effectiveTransferDateId] ': {
                change: function (effectiveTransferDate) {
                    if (portalId == 1 && Ext.isDefined(this.getStudentSearchResultGrid())) {
                        var record = this.getStudentSearchResultGrid().getSelectionModel().getSelection()[0];
                        if (!isNullOrEmpty(record)) {
                            var status = record.data.SERVICE_REQUEST_STATUS;
                            if (status == "closed" || status == "Completed") {} else {
                                effectiveTransferDate.setMinValue(new Date());
                            }
                        }
                    }
                }
            },
            'documentformwindow[itemId=studentTransferExecutionDetailFormId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                click: function () {
                    var $this = this;
                    var isTransient = true;
                    var module = 'studentTransferExecution';
                    var entityId;
                    var entityType = 'studentTransferExecution';
                    $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function (success, response, isCallBackTransient) {
                        var documentModel = new Academia.model.servicerequest.studentservicerequest.StudentTransferFollwupDocumentModel();
                        documentModel.set("documentName", response.name);
                        documentModel.set("path", response.path);
                        documentModel.set("type", response.type);
                        documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));
                        var store = $this.getStore('servicerequest.studentservicerequest.StudentTransferExecutionDocumentStore');
                        store.add(documentModel);
                        $this.getDocumentController().closeDocumentFormWindow();
                    }, isTransient);
                }
            },
            'studenttransferexecutiondocumentgrid button#btnDelete': {
                click: function () {
                    this.deleteStudentTransferExecutionDocumentGrid();
                }
            },
            'studenttransferexecutiondetailspanel button[itemId=studentTransferExecutionSubmitBtn]': {
                click: function (form) {
                    this.ShowConfrimationBoxOnCheckAndUncheckOnRetainData(form)
                }
            },
            'studenttransferexecutiondetailspanel checkboxfield#retainStudentDataId': {
                change: function (obj, newValue, oldValue, eOpts) {
                    var form = obj.up('studenttransferexecutiondetailspanel');
                    var retainAcademicDataId = form.down("#retainAcademicDataId");
                    var retainServicesOptedId = form.down("#retainServicesOptedId");
                    var retainFeePaymentDataId = form.down("#retainFeePaymentDataId");
                    if (!newValue) {
                        retainAcademicDataId.setDisabled(true);
                        retainServicesOptedId.setDisabled(true);
                        retainFeePaymentDataId.setDisabled(true);
                    } else {
                        retainAcademicDataId.setDisabled(false);
                        retainServicesOptedId.setDisabled(false);
                        retainFeePaymentDataId.setDisabled(false);
                    }
                }
            },
            'studenttransferclosurewin checkboxfield#retainStudentDataId': {
                change: function (obj, newValue, oldValue, eOpts) {
                    var form = this.getStudenttransferclosurewin();
                    var retainAcademicDataId = form.down("#retainAcademicDataId");
                    var retainServicesOptedId = form.down("#retainServicesOptedId");
                    var retainFeePaymentDataId = form.down("#retainFeePaymentDataId");
                    if (!newValue) {
                        retainAcademicDataId.setDisabled(true);
                        retainServicesOptedId.setDisabled(true);
                        retainFeePaymentDataId.setDisabled(true);
                    } else {
                        retainAcademicDataId.setDisabled(false);
                        retainServicesOptedId.setDisabled(false);
                        retainFeePaymentDataId.setDisabled(false);
                    }
                }
            },
            'servicerequestfollowupdocumentsgrid': {
                cellclick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    if (columnName == "name") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("encryptedDocId");
                            if (!isNullOrEmpty(documentId)) {
                                this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'studenttransferexecutiondocumentgrid': {
                cellclick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("encryptedDocId");
                            if (!isNullOrEmpty(documentId)) {
                                this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'schoolleavingexecutiondetailspanel button[itemId=schoolLeavingExecutionSubmitBtn]': {
                click: function (form) {
                    this.SchoolLeavingExecutionSubmitForm(form);
                }
            },
            'schoolleavingexecutiondocumentgrid button#btnDelete': {
                click: function () {
                    this.deleteSchoolLeavingExecutionDocumentGrid();
                }
            },
            'schoolleavingexecutiondocumentgrid': {
                cellclick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("id");
                            if (!isNullOrEmpty(documentId)) {
                                this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'schoolleavingexecutiondetailspanel button[itemId=schoolLeavingExecutionDocument]': {
                click: function () {
                    this.getDocumentController().showDocumentFormWindow('schoolleavingExecutionDetailFormId', 'DOCUMENT');
                }
            },
            'hostelleaverequestdetailspanel combo[itemId=startTimeItemId]': {
                select: function () {
                    var $this = this;
                    var activeTab = $this.getContentPanelActiveTab();
                    var hostelleaverequestdetailspanel = activeTab.down('hostelleaverequestdetailspanel');
                    var ToTimeItemId = hostelleaverequestdetailspanel.down('#toTimeItemId');
                    var fromTime = hostelleaverequestdetailspanel.down('#startTimeItemId');
                    $this.setAllowBlank(ToTimeItemId, false);
                }
            },
            'documentformwindow[itemId=schoolleavingExecutionDetailFormId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                click: function () {
                    var $this = this;
                    var isTransient = true;
                    var module = 'schoolLeavingExecution';
                    var entityId;
                    var entityType = 'schoolLeavingExecution';
                    $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function (success, response, isCallBackTransient) {
                        var documentModel = new Academia.model.servicerequest.studentservicerequest.SchoolLeavingExecutionDocumentModel();
                        documentModel.set("documentName", response.name);
                        documentModel.set("path", response.path);
                        documentModel.set("type", response.type);
                        documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));
                        var store = $this.getStore('servicerequest.studentservicerequest.SchoolLeavingExecutionDocumentStore');
                        store.add(documentModel);
                        $this.getDocumentController().closeDocumentFormWindow();
                    }, isTransient);
                }
            },
            'hostelleaverequestdetailspanel #withdrawButtonId': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'printcertificatehostelwidow button#btnPrint': {
                click: function (button) {
                    var $this = this;
                    var serviceRequestId = this.getContentPanelActiveTab().getServiceRequestId();
                    var csvForm = Ext.create('Ext.form.Panel');
                    var parameterListObj = new Object();
                    var formWindow = $this.getPrintcertificatehostelwidow();
                    var certificateId = formWindow.down('#templateNameStudent');
                    certificateId = certificateId.getValue();
                    Ext.Ajax.request({
                        type: 'rest',
                        method: 'POST',
                        url: SERVERURL.PRINT_HOSTEL_LEAVE_CERTIFICATE,
                        standardSubmit: true,
                        params: {
                            serviceRequestId: serviceRequestId,
                            certificateId: certificateId
                        },
                        success: function (response) {
                            if (response) {
                                csvForm.getForm().submit({
                                    target: 'download_frame',
                                    method: 'POST',
                                    params: {
                                        access_token: Ext.Ajax.defaultHeaders.access_token,
                                        serviceRequestId: serviceRequestId,
                                        certificateId: certificateId
                                    },
                                    headers: {
                                        'Accept': 'application/pdf',
                                        'Content-Type': 'application/json',
                                        'Authorization': Ext.Ajax.defaultHeaders.Authorization
                                    },
                                    url: SERVERURL.PRINT_HOSTEL_LEAVE_CERTIFICATE,
                                    standardSubmit: true
                                });
                                formWindow.close();
                                $this.hideWindowMask();
                            }
                        },
                        failure: function (response, action) {
                            showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('documenttemplate_conf_not_configured'));
                        }
                    });
                }
            },
            'hostelleaverequestdetailspanel combo[itemId=leaveType]': {
                select: function (combo) {
                    var $this = this;
                    var activeTab = $this.getContentPanelActiveTab();
                    var hostelleaverequestdetailspanel = activeTab.down('hostelleaverequestdetailspanel');
                    var startDate = hostelleaverequestdetailspanel.down('#startDate').getValue();
                    var paramLeaveType = null;
                    if (dateRender(startDate) == dateRender(new Date())) {
                        paramLeaveType = true;
                    }
                    combo.getStore().getProxy().extraParams = {
                        isEmergency: paramLeaveType
                    };
                }
            },
            'servicerequestmandatorydocuments #btnDelete': {
                click: function (button) {
                    this.deleteServiceRequestMandatoryDocument(button);
                }
            },
            'servicerequestmandatorydocuments': {
                cellclick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    var $this = this;
                    if (columnName == "documentType") {
                        if (e.target.tagName == 'A') {
                            if (!isNullOrEmpty(record.data)) {
                                var documentId = record.raw.encryptedDocId;
                                if (!isNullOrEmpty(documentId)) {
                                    $this.getDocumentController().downloadDocumentFile(documentId);
                                }
                            }
                        }
                    }
                }
            },
            'requestpendingdocumentlistgrid[itemId=requestpendingdocumentlistgridItemId]': {
                cellclick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A' && !grid.isDownloading) {
                        	grid.isDownloading = true;
                            this.getDownloadReqPendingSingleFile(record.raw.displayOtherLanguage);
                            setTimeout(function(){
                            	grid.isDownloading = false;
                            },2000);
                        }
                    }
                }
            },
            'requestpendingdocumentlistgrid button[itemId=downloadDocumentItemId]': {
                click: function (obj) {
                    this.requestPendingDocumentZip('VOLUNTARY_DOC');
                }
            },
            'requestpendingmandatorydocumentlistgrid[itemId=requestpendingmandatorydocumentlistgridItemId]': {
                cellclick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A' && !grid.isDownloading) {
                        	if(!isNullOrEmpty(record.raw.isConfigure) && record.raw.isConfigure == false){
                        		grid.isDownloading = true;
                        		this.getDownloadreadmissionReqPendingSingleFile(record.raw.displayOtherLanguage,record.raw.isConfigure);
                        		setTimeout(function(){
                                	grid.isDownloading = false;
                                },2000);
                        	}else{
                        		grid.isDownloading = true;
                        		this.getDownloadReqPendingSingleFile(record.raw.displayOtherLanguage);
                        		setTimeout(function(){
                                	grid.isDownloading = false;
                                },2000);
                        	}
                        }
                    }
                }
            },
            'requestpendingmandatorydocumentlistgrid button[itemId=downloadDocumentItemId]': {
                click: function (obj) {
                    this.requestPendingDocumentZip('MANDATORY_DOC');
                }
            },
            'reasonforwithdrawalwindow button[itemId=CancelBtnReasonForWithdraw]': {
                click: function (obj) {
                    var window = obj.up('window');
                    window.close();
                }
            },
            'reasonforwithdrawalwindow button[itemId=SubmitBtnReasonForWithdraw]': {
                click: function (button) {
                    this.withdrawRequest(button);
                }
            },
            'freeformrequestdetailspanel #withdrawButtonId': {
                click: function (button) {
         		//this.withdrawRequest(button);
                    var reasonforwithdrawal = this.getReasonforwithdrawalwindow();
                    if (!reasonforwithdrawal) {
                        Ext.widget('reasonforwithdrawalwindow');
                        reasonforwithdrawal = this.getReasonforwithdrawalwindow();
                    }
                    reasonforwithdrawal.show();
                    reasonforwithdrawal.config.freeFormPanel = button.up().up();
                }
            },
            'requestactionlevelwindow button#recommendedConcessionsAddBtn': {
                click: function (button) {
                    var me = this;
                    var recommendedConcessionsCombo = button.up('fieldcontainer').down('#recommendedConcessions');
                    var recommendedConcessionsVals = recommendedConcessionsCombo.getValue();
                    if (!isNaN(recommendedConcessionsVals)) {
                        recommendedConcessionsVals = recommendedConcessionsCombo.lastSelection;
                    }
                    var examConcessionFieldContainer = button.up('window').down('#examConcessionFieldContainer');
                    var serviceRequestId = this.getContentPanelActiveTab().getServiceRequestId();
                    var level = button.up('window').level;
                    if (Ext.isDefined(recommendedConcessionsVals) && recommendedConcessionsVals.length > 3) {
                        showWarningMessage(getCommonTranslation('REQUEST_ACTION_LEVEL'), getCommonTranslation("CANNOT_SELECT_MORE_CONCESSIONS"));
                        recommendedConcessionsCombo.reset();
                        recommendedConcessionsCombo.clearValue();
                    } else if (Ext.isDefined(recommendedConcessionsVals) && recommendedConcessionsVals.length) {
                        examConcessionFieldContainer.removeAll();
                        if (!isNullOrEmpty(recommendedConcessionsVals[0])) {
                            var itemsArray = [];
                            for (i = 0; i < recommendedConcessionsVals.length; i++) {
                                Ext.Ajax.request({
                                    type: 'rest',
                                    url: SERVERURL.PATH_FIND_ALL_DEPENDENT_FIELD_BY_CONCESSION_ID,
                                    method: 'GET',
                                    async: false,
                                    params: {
                                        id: (recommendedConcessionsVals[i].data) ? recommendedConcessionsVals[i].data.id : recommendedConcessionsVals[i],
                                        isLevelTwo: (level == 1) ? false : true,
                                        serviceRequestId: serviceRequestId,
                                    },
                                    success: function (response, action) {
                                        var resp = Ext.JSON.decode(response.responseText);
                                        var count = 0;
                                        var store = me.getServicerequestactiondetailspanel().down('grid').getStore();
                                        Ext.each(resp, function (currentResp) {
                                            if (currentResp.dependentFieldType == "text box") {
                                                var fieldXType = 'textfield';
                                                var concessionNameDisplayFieldTxt = currentResp.dependentFieldName;
                                                if (button.up('window').btnView = 'btnView') {
            		        				 /*if(store.proxy.reader.rawData[count] && concessionNameDisplayFieldTxt == dependentFieldName) {
            		        					 currentResp.value = store.proxy.reader.rawData[count].dependentFieldValue;
                    		        			 count++;
            		        				 }*/
            		        				 var resultObject = searchInArray(concessionNameDisplayFieldTxt, store.proxy.reader.rawData);
                                                    if (resultObject) {
                                                        currentResp.value = resultObject.dependentFieldValue;
                                                    }
                                                }
                                                var newConcessionsComp = {
                                                    xtype: 'fieldcontainer',
                                                    width: 'auto',
                                                    defaults: {
                                                        labelAlign: 'top',
                                                        width: 226
                                                    },
                                                    layout: {
                                                        type: 'hbox'
                                                    },
                                                    items: [{
                                                        xtype: 'displayfield',
                                                        name: 'concessionNameDisplayField',
                                                        allowBlank: false,
                                                        fieldLabel: concessionNameDisplayFieldTxt
                                                    }, {
                                                        xtype: fieldXType,
                                                        name: 'concessionNameValueField',
                                                        allowBlank: false,
                                                        fieldLabel: concessionNameDisplayFieldTxt,
                                                        labelAlign: 'top',
                                                        dependentFieldName: currentResp.dependentFieldName,
                                                        examConcessionId: currentResp.examConcessionId,
                                                        fieldId: currentResp.id,
                                                        value: !isNullOrEmpty(currentResp.value) ? currentResp.value : null
                                                    }]
                                                };
        							 }
        							 else if(currentResp.dependentFieldType == "check box"){
                                                var fieldXType = 'checkboxfield';
                                                var concessionNameDisplayFieldTxt = currentResp.dependentFieldName;
                                                if (button.up('window').btnView = 'btnView') {
                                                    var resultObject = searchInArray(concessionNameDisplayFieldTxt, store.proxy.reader.rawData);
                                                    if (resultObject) {
                                                        currentResp.value = resultObject.dependentFieldValue;
                                                    }
                                                }
                                                var newConcessionsComp = {
                                                    xtype: 'fieldcontainer',
                                                    width: 'auto',
                                                    defaults: {
                                                        labelAlign: 'top',
                                                        width: 226
                                                    },
                                                    layout: {
                                                        type: 'hbox'
                                                    },
                                                    items: [{
                                                        xtype: 'displayfield',
                                                        name: 'concessionNameDisplayField',
                                                        allowBlank: false,
                                                        fieldLabel: concessionNameDisplayFieldTxt
                                                    }, {
                                                        xtype: fieldXType,
                                                        name: 'concessionNameValueField',
                                                        fieldLabel: concessionNameDisplayFieldTxt,
                                                        labelAlign: 'top',
                                                        inputValue: true,
                                                        uncheckedValue: false,
                                                        dependentFieldName: currentResp.dependentFieldName,
                                                        examConcessionId: currentResp.examConcessionId,
                                                        fieldId: currentResp.id,
                                                        listeners: {
                                                            afterrender: function (checkfld) {
                                                                if (!isNullOrEmpty(currentResp.value)) {
                                                                    checkfld.setValue(currentResp.value)
                                                                }
                                                            }
                                                        }
                                                    }]
                                                };
                                            } else if (currentResp.dependentFieldType == "radio button") {
                                                var fieldXType = 'radiofield';
                                                var concessionNameDisplayFieldTxt = currentResp.dependentFieldName;
                                                if (button.up('window').btnView = 'btnView') {
                                                    var resultObject = searchInArray(concessionNameDisplayFieldTxt, store.proxy.reader.rawData);
                                                    if (resultObject) {
                                                        currentResp.value = resultObject.dependentFieldValue;
                                                    }
                                                }
                                                var newConcessionsComp = {
                                                    xtype: 'fieldcontainer',
                                                    width: 'auto',
                                                    defaults: {
                                                        labelAlign: 'top',
                                                        width: 226
                                                    },
                                                    layout: {
                                                        type: 'hbox'
                                                    },
                                                    items: [{
                                                        xtype: 'displayfield',
                                                        name: 'concessionNameDisplayField',
                                                        allowBlank: false,
                                                        fieldLabel: concessionNameDisplayFieldTxt
                                                    }, {
                                                        xtype: fieldXType,
                                                        name: 'concessionNameValueField',
                                                        fieldLabel: concessionNameDisplayFieldTxt,
                                                        labelAlign: 'top',
                                                        inputValue: true,
                                                        dependentFieldName: currentResp.dependentFieldName,
                                                        examConcessionId: currentResp.examConcessionId,
                                                        fieldId: currentResp.id,
                                                        listeners: {
                                                            afterrender: function (radiofld) {
                                                                if (!isNullOrEmpty(currentResp.value) && currentResp.value == "true") {
                                                                    radiofld.setValue(currentResp.value == "true" ? true : false)
                                                                }
                                                            }
                                                        }
                                                    }]
                                                };
                                            }
                                            itemsArray.push(newConcessionsComp);
                                        });
                                    }
                                });
                            }
                            examConcessionFieldContainer.add(itemsArray)
                        }
                    } else {
                        examConcessionFieldContainer.removeAll();
                    }
                }
            },
            'requestactionlevelwindow button#requestActionFormSubmitBtn': {
                click: function (button) {
                    var activeTab = this.getContentPanelActiveTab();
                    var servicerequestactiondetailspanel = activeTab.down('servicerequestactiondetailspanel');
                    var mGrid = servicerequestactiondetailspanel.down('grid');
                    var win = button.up('window');
                    var form = button.up('form');
                    var formValues = form.getValues();
                    var serviceRequestId = this.getContentPanelActiveTab().getServiceRequestId();
                    var wsExamConcessionDurationDependentField = [];
                    form.down('#requestActionFormSubmitBtn').setDisabled(true);
                    Ext.each(Ext.ComponentQuery.query('[name=concessionNameValueField]'), function (currentField) {
                        wsExamConcessionDurationDependentField.push({
                            dependentFieldId: currentField.fieldId,
                            dependentFieldName: currentField.getValue(),
                            examConcessionId: currentField.examConcessionId
                        });
                    });
                    var submitData = {
                        startDate: formValues.startDate,
                        endDate: formValues.tillDate,
                        plannedActionDate: formValues.plannedActionDate,
                        actualActionDate: formValues.actualActionDate,
                        requestActionStatus: form.down('#requestActionStatus').getDisplayValue(),
                        remarks: formValues.remarks,
                        isLevelOne: ((win.level == 1) ? true : false),
                        isLevelTwo: ((win.level == 2) ? true : false),
                        approverId: formValues.approverNameId,
                        serviceRequestId: serviceRequestId,
                        wsExamConcessionDurationDependentField: wsExamConcessionDurationDependentField
                    }
                    if (!wsExamConcessionDurationDependentField.length) {
                        showErrorMessage(getCommonTranslation('REQUEST_ACTION_LEVEL'), getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
                    } else {
                        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.PATH_EXAM_CONCESSION_DURATION_DETAIL_CREATE,
                            method: 'POST',
                            jsonData: submitData,
                            async: false,
                            success: function (response, action) {
                                if (!isNullOrEmpty(response.responseText)) {
                                    Ext.getBody().unmask();
                                    showSuccessMessage(getCommonTranslation('REQUEST_ACTION_LEVEL'), getCommonTranslation('SUCCESS'));
                                    mGrid.getStore().reload();
                                    win.close();
                                }
                            },
                            failure: function (response, action) {
                                win.down('#requestActionFormSubmitBtn').setDisabled(false);
                            }
                        });
                    }
                }
            },
            'requestactionlevelwindow button#requestActionFormCancelBtn': {
                click: function (button) {
                    var me = this;
                    var win = button.up('window');
                    win.close();
                }
            },
            'stdandparentraiseservicerequestwindow treepanel': {
                beforeitemclick: function (tree, record, item, index, e, eOpts) {
                    if (record.data.children != null || e.target.tagName == 'IMG') {
                        return false;
                    } else {
                        if (e.target.tagName == 'SPAN' ||  (record.data && record.data.id)) {
                            requestId = record.data.id;
                            requestCode = record.data.code;
                            var requestGroup;
                            if (record.parentNode.raw.text == 'General') {
                                requestGroup = 'FREE_FORM';
                            } else if (record.parentNode.raw.text == getServiceRequestTranslation('TRANSFER')) {
                                requestGroup = 'TRANSFER';
                            } else if (record.parentNode.raw.text == 'Other') {
                                requestGroup = 'OTHER';
                            } else if (record.parentNode.raw.text == 'Certificate') {
                                requestGroup = 'CERTIFICATE';
                            } else if (record.parentNode.raw.text == 'Exam Related') {
                                requestGroup = 'EXAM_RELATED';
                            } else if (record.parentNode.raw.text == 'Personal Data Change Request') {
                                requestGroup = 'PERSONAL_DATA_CHANGE';
                            }
                            this.checkValidationsForRequest("STUDENT_REQUEST", requestGroup, record);
                        }
                    }
                },
                celldblclick: function (obj) {
                    return false;
                },
            },
            'stdandparentraiseservicerequestwindow button[itemId=cancelBtn]': {
                click: function (btn) {
                    var win = this.getStdandparentraiseservicerequestwindow();
                    this.loadFacultyGridAndSearchRequest();
                    this.loadStudentGridAndSearchRequest();
                    win.close();
                }
            },
            'stdandparentraiseservicerequestwindow': {
                afterrender: function (window) {
                    var $this = this;
                    window.addCls('mouseCursorCls');
                    var portalId = this.getCurrentLoggedPortalId();
                    if (portalId != 3 && portalId != 7) {
                        this.loadGridForFacultyPortal();
                    }
                    var programId = $this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.programId;
                    Ext.Ajax.request({
                        method: "GET",
                        type: 'rest',
                        timeout: 300000,
                        url: SERVERURL.PATH_RAISE_REQUEST_SETTING_FORM_API,
                        params: {
                            serviceRequestCategory: 'STUDENT_REQUEST',
                            academyLocationId: $this.getCurrentAcademyLocation(),
                            portalId: portalId,
                            programId: programId
                        },
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function (response) {
                            var data = Ext.decode(response.responseText);
                            $this.setDataOnServiceReqPortalWin(data, window);
                        }
                    });
                },
                close: function (window) {
                    this.loadStudentGridAndSearchRequest();
                }
            },
            'requestactionlevelwindow': {
                afterrender: function (win) {
                    var me = this;
                    var approverNameCombo = win.down('#approverName');
                    var recommendedConcessionsCombo = win.down('#recommendedConcessions');
                    var serviceRequestId = this.getContentPanelActiveTab().getServiceRequestId();
                    var recommendedConcessionsAddBtn = win.down('#recommendedConcessionsAddBtn');
                    recommendedConcessionsCombo.getStore().getProxy().extraParams = {
                        id: this.getContentPanelActiveTab().getRequesterId(),
                        academyLocationId: this.getCurrentAcademyLocation(),
                    };
                    if (win.level == 1) {
                        approverNameCombo.show();
                        this.setAllowBlank(approverNameCombo, false);
                        if (win.btnView != 'btnView') {
                            this.setWinFormData(1, win);
                        }
                    } else {
                        approverNameCombo.hide();
                        this.setAllowBlank(approverNameCombo, true);
                        if (win.btnView != 'btnView') {
                            this.setWinFormData(2, win);
                        }
                    }
                    recommendedConcessionsCombo.getStore().load({
                        callback: function () {
                            if (win.level == 2 && win.btnView != 'btnView') {
                                Ext.Ajax.request({
                                    type: 'rest',
                                    url: SERVERURL.PATH_FIND_CONSESSION_IDS,
                                    method: 'GET',
                                    params: {
                                        serviceRequestId: serviceRequestId
                                    },
                                    async: false,
                                    success: function (response, action) {
                                        if (!isNullOrEmpty(response.responseText)) {
                                            var data = Ext.decode(response.responseText);
                                            if (data.length) {
                                                recommendedConcessionsCombo.setValue(data);
                                                if(level) {
                                                	level.setValue(2);
                                                }
                                                recommendedConcessionsAddBtn.fireEvent('click', recommendedConcessionsAddBtn);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            },
            'requesterdetailspanel button[itemId=studentHyperLink]': {
                click: function (btn) {
                	var academyLocationId = this.getCurrentAcademyLocation();
					var isStudentJourney=false;
					
					Ext.Ajax.request({
	        			type: 'rest',
	        			url: SERVERURL.PATH_FIND_STUDENT_JOURNEY_DASHBOARD_SETTING_BY_AL_ID,
	        			method : 'GET',
	        			async : false,
	        			params:{
	        				academyLocationId:academyLocationId ,
	        			},
	        			success: function(f, action) {
	        				var data = f.responseText;
	        				if(data == "true"){	
	        					isStudentJourney=true;
	        				}else{
	        					isStudentJourney=false;
	        				}
	        			},
	        			failure: function(result, request) {
	        				showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
	        				return false;
	        			}
	        		});
                    if (btn.up('debarmentform')) {
                        if (Ext.ComponentQuery.query('#studentDebarmentGrid').length && !btn.personalId) {
                            var grid = Ext.ComponentQuery.query('#studentDebarmentGrid')[0];
                        } else if (Ext.ComponentQuery.query('#trackRequestGrid').length) {
                            var selRec = Ext.ComponentQuery.query('#trackRequestGrid')[0].getSelectionModel().getSelection()[0];
                        }
                    } else if (btn.up('servicerequestpanel') && Ext.ComponentQuery.query('#trackRequestGrid').length && btn.personalId) {
                        var selRec = Ext.ComponentQuery.query('#trackRequestGrid')[0].getSelectionModel().getSelection()[0];
                    } 
                    else if(btn.up('terminationform')){
						if (Ext.ComponentQuery.query('#studentTerminationGrid').length && !btn.personalId) {
                            var grid = Ext.ComponentQuery.query('#studentTerminationGrid')[0];
                        } else if (Ext.ComponentQuery.query('#trackRequestGrid').length) {
                            var selRec = Ext.ComponentQuery.query('#trackRequestGrid')[0].getSelectionModel().getSelection()[0];
                        }
					}
                    else {
                        var grid = this.getStudentListGrid();
                    }
                    if (grid && grid.getSelectionModel().getSelection()[0]) {
                        var selRec = grid.getSelectionModel().getSelection()[0];
                        if(isStudentJourney){
                        	this.getController('Academia.controller.personinfo.common.PersonCommonController').addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", btn.text, 'studentprofile', selRec.data.USER_ID, selRec.data.PERSON_ID, null, null, selRec.data.PROGRAM_BATCH_SEAT_CONFIG_ID);
						}else{
							this.getController('Academia.controller.personinfo.common.PersonCommonController').addContentPanelTab(btn.text,'studentprofile',selRec.data.USER_ID,selRec.data.PERSON_ID,null,null,selRec.data.PROGRAM_BATCH_SEAT_CONFIG_ID);
						}
                    } else {
                        if (btn.batchSeat && btn.personalId) {
                            //var stUserId = (selRec && selRec.data && selRec.data.USER_ID) ? selRec.data.USER_ID : ((selRec && selRec.data && selRec.data.REQUESTER) ? selRec.data.REQUESTER : null);
                        	var stUserId = btn.personalId;
                        	if(isStudentJourney){
								this.getController('Academia.controller.personinfo.common.PersonCommonController').addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", btn.text, 'studentprofile', stUserId, btn.personalId, null, null, btn.batchSeat);
							}else{
								this.getController('Academia.controller.personinfo.common.PersonCommonController').addContentPanelTab(btn.text,'studentprofile',stUserId,btn.personalId,null,null,btn.batchSeat);
							}
                        }
                    }
                }
            },
            'programrequestdetailspanel': {
				afterrender: function (pnl) {
					var me = this;
					var studentId = this.getContentPanelActiveTab().getRequesterId();
					var academicTermCombo = pnl.down("#academicTermId");
					var isServiceRequestForInActiveStudent = me.getInActiveStudentServiceRequestRequired();
                    if(!isNullOrEmpty(isServiceRequestForInActiveStudent) && isServiceRequestForInActiveStudent){
						academicTermCombo.setVisible(true);
						me.setAllowBlank(academicTermCombo,false);
					}
                    if(this.getCurrentLoggedPortalId()==3){
                    	Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.FIND_ALL_DROPDOWN,
                            method: 'GET',
                            async: false,
                            success: function (response, action) {
                            	if(response != undefined && response.responseText !=null && !isEmpty(response.responseText)){
                            	var responseTxt = Ext.decode(response.responseText);
                            	if (responseTxt!=undefined && responseTxt.type=="IsStudentJourneyImplemented" && responseTxt.name=="true"){}	  
                            		pnl.down('#toSeatTypeId').setReadOnly(true);
                            	}else {
                            		pnl.down('#toSeatTypeId').setReadOnly(false);
                            	}
                            }
                        });
                    }
					var academicTermComboStore = academicTermCombo.getStore();
					var admissionId = me.getContentPanelActiveTab().admissionId;
					var isEditRequest = false;
					var activeTab = me.getContentPanelActiveTab();
					if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
						var serviceRequestId = activeTab.getServiceRequestId();
						if (!isNullOrEmpty(serviceRequestId)) {
							isEditRequest = true;
						}
					} 
					academicTermComboStore.getProxy().extraParams = {
						studentId: studentId,
						admissionId: admissionId,
						isEditRequest : isEditRequest
					};
					academicTermComboStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if (!isNullOrEmpty(records) && records.length == 1) {
									academicTermCombo.setValue(records[0].data.id);
								}
							}
						}
					});
				},
				
                validitychange: function (cmp, valid) {
                    if (valid) {
                        if (this.getProgramrequestdetailspanel().down('#confirmationId').checked || !this.getProgramrequestdetailspanel().down('#confirmationId').isVisible()) {
                            this.getProgramrequestdetailspanel().down('#programSubmitBtn').setDisabled(false);
                        } else {
                            this.getProgramrequestdetailspanel().down('#programSubmitBtn').setDisabled(true);
                        }
                    } else {
                        return false;
                    }
                }
            },
            'programrequestdetailspanel checkboxfield[itemId=confirmationId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                    if (this.getProgramrequestdetailspanel().isValid() && newValue) {
                        this.getProgramrequestdetailspanel().down('#programSubmitBtn').setDisabled(false);
                    } else {
                        this.getProgramrequestdetailspanel().down('#programSubmitBtn').setDisabled(true);
                    }
                }
            },
          
            'exchangesemesterrequestdetailspanel checkboxfield[itemId=confirmationId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                    /*if (this.getExchangesemesterrequestdetailspanel().isValid() && newValue) {
                        this.getExchangesemesterrequestdetailspanel().down('#exchangeSemesterreqUploadSubmitBtn').setDisabled(false);
                    } else {
                        this.getExchangesemesterrequestdetailspanel().down('#exchangeSemesterreqUploadSubmitBtn').setDisabled(true);
                    }*/
                	this.onExchangeSemesterFieldCheck();
                }
            },
            
            'exchangesemesterrequestdetailspanel checkboxfield[itemId=upToDateDetailsId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onExchangeSemesterFieldCheck();
                }
            },
            
            'exchangesemesterrequestdetailspanel checkboxfield[itemId=authorizeDeclarationId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onExchangeSemesterFieldCheck();
                }
            },
            
            'exchangesemesterrequestdetailspanel checkboxfield[itemId=visaRefusalCheck]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onExchangeSemesterFieldCheck();
                }
            },
            
            'exchangesemesterrequestdetailspanel checkboxfield[itemId=studiedInUkCheck]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onExchangeSemesterFieldCheck();
                }
            },
            
            'exchangesemesterrequestdetailspanel checkboxfield[itemId=healthInsuranceCheckId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onExchangeSemesterFieldCheck();
                }
            },
            
            'exchangesemesterrequestdetailspanel checkboxfield[itemId=scholarshipCheckId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onExchangeSemesterFieldCheck();
                }
            },
            
            'exchangesemesterrequestdetailspanel checkboxfield[itemId=medicalIssuesCheckId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                	this.onExchangeSemesterFieldCheck();
                }
            },
            'leaveofabsencerequestform checkboxfield[itemId=loaRequesterDeclarationSecondId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                    this.onLeaveOfAbsenceFieldCheck();
                }
            },
            'leaveofabsencerequestform checkboxfield[itemId=loaStudentconfirmationId]': {
                change: function (cmp, newValue, oldValue, eOpts) {
                    this.onLeaveOfAbsenceFieldCheck();
                }
            },
            'rejectionrequestclosurewin button[itemId=submitBtn]': {
                click: this.onrejectWinBtnClick
            },
            'rejectionrequestclosurewin button[itemId=cancelBtn]': {
                click: function (btn) {
                    btn.up('window').close();
                }
            },
            'quickCommentInput textfield[itemId=addQuickCommentItemId]':{
            	change:function(comp){
            		var me = this;
            		var input = me.getQuickCommentInput();
            		if(comp.getValue().length>0){
            			input.down('#quickCommentSend').setDisabled(false)
            		}
            		else{
            			input.down('#quickCommentSend').setDisabled(true)
            		}
            	}
            },
            'quickCommentInput filefield[itemId=quickCommentFileUpload]':{
            	change: function(field, value) {
                    value = value.replace('C:\\fakepath\\', '');
                    value = value.replace(/ +/g, " ").split(' ').join('_');
            		quickCommentDocPath = value;
            		var isFile = field.fileInputEl.dom.files[0]
            		var fileName = value.split('\\').pop();
            		quickCommentDocName = fileName;
		            var box = this.getQuickCommentInput().down('#fileNameAddedItemId')
		            var removeBtn = this.getQuickCommentInput().down('#documentRemoveToQuickCommentItemId')
		            
            		if(isFile){
            			var fileSizeMB = isFile.size / (1024 * 1024); // Convert size to MB
                        var allowedExtensions = ['jpeg', 'jpg','png', 'pdf', 'doc', 'docx', 'xls', 'txt', 'xlsx'];
                        var fileExtension = fileName.split('.').pop();                        
            			if (fileSizeMB > 25) { 
                            showWarningMessage(getFeeAndPaymentCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('FILE_SIZE_MSG'));
                            field.reset();
            			}else if(!allowedExtensions.includes(fileExtension)){
                            showWarningMessage(getFeeAndPaymentCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('FILE_EXTENSION_MSG'));
                            field.reset();
            			}
            			else{
            				box.update(fileName);            				
            				removeBtn.addCls('documentRemoveToQuickComment')
            				removeBtn.setVisible(true)
		    	           
            			}
            		}
		            
		        }
            },
            'quickCommentInput button[itemId=documentRemoveToQuickCommentItemId]':{ 
            	click: function() { 
            		var uploadFiels = this.getQuickCommentInput().down('#quickCommentFileUpload')
            		var box = this.getQuickCommentInput().down('#fileNameAddedItemId')
		            var removeBtn = this.getQuickCommentInput().down('#documentRemoveToQuickCommentItemId')
            		uploadFiels.reset()
            		box.update("")
            		removeBtn.setVisible(false)
//            		uploadFiels.setDisabled(false)
//            		uploadFiels.removeCls('fileUploadDisabled')
            		quickCommentDocName = ''
            		quickCommentDocPath = ''
            	}
            },
            'quickCommentInput button[itemId=quickCommentSend]':{ 
            	click:function(btn){
            		this.saveAddQuickCommentRecord(btn);
            	}
            },
            'quickCommentInput button[itemId=quickCommentRefresh]':{ 
            	click: function(btn){
            		var quickCommentGrid = this.getQuickCommentGrid()
            		quickCommentGrid.getStore().load();
            	}
            },
            'quickCommentGrid':{
            	afterrender: function(grid,button){ 
            		var currentLogginUser = this.getCurrentlyLoggedInUser().id;
            		var quickCommentGrid = this.getQuickCommentGrid()
            		var store = quickCommentGrid.getStore();
            		var selRec;
            		if(portalId == '1'){
            			selRec = this.getStudentSearchResultGrid().getSelectionModel().getSelection()[0].data.ID
            		}
            		if(portalId == '2'){
            			if(typeof this.getFacultySearchResultGrid() !== 'undefined'){
            				selRec = this.getFacultySearchResultGrid().getSelectionModel().getSelection()[0].data.ID
                		}
                		else{
                			selRec = this.getRequestpendingactiongrid().getSelectionModel().getSelection()[0].data.ID
                		}	
            		}
					if(portalId == '3'){
		            	selRec = this.getStudentportalstudentrequestgrid().getSelectionModel().getSelection()[0].data.id		
					}
            		if(!isNullOrEmpty(selRec)){
            			store.proxy.extraParams = {
                    			logUserId: currentLogginUser,
                                serviceRequestId:selRec
                            };
            			store.load();
            		}
            	},
            	cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) { 
            		var $this = this;
	           		 var cellDataIndex =View.ownerCt.columnManager.columns[ColIdx].dataIndex;
	           		 if(e.target.tagName == "A" &&(cellDataIndex == "documentName") ){
	           			var previewWindow = $this.getDocumentpreviewwindow();
							if (!previewWindow) {
								Ext.widget('documentpreviewwindow', {
									documentRecord: record,
									width: '100%',
									height: Ext.getBody().getHeight(),
									itemId: 'quickCommentDocPreviewWindow'
								});
								previewWindow = $this.getDocumentpreviewwindow();
							}
	
							previewWindow.show();
	           		}
            	}
            },
            'documentpreviewwindow[itemId=quickCommentDocPreviewWindow]':{
            	afterrender: function(win){
            		var me = this;
            		var documentRecord = win.documentRecord;
            		var documentId = documentRecord.data.documentId;
            		var id = documentRecord.data.id;
            		var docId = documentRecord.data.docId;
            		var fileExtension =  documentRecord.data.documentName.split(".").pop();
            		var documentName = documentRecord.data.documentName;
            		win.setTitle(documentRecord.data.documentName);
					var url=SERVERURL.PATH_GENERATE_BASE_64_QUICK_COMMENT;
            		if(!isNullOrEmpty(documentId) && documentId){
            				Ext.Ajax.request({
            					type: 'rest',
            					url: url,
            					params:{
            						documentId:docId,
                    			},
            					method: 'GET',
            					success: function(res, action) {
            						var responseTxt = res.responseText;
            						if(responseTxt != ''){
                						if(fileExtension.toUpperCase() == "PDF"){
                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
                						}
                						else if(fileExtension.toUpperCase() == "DOCX" || fileExtension.toUpperCase() == "DOC" || fileExtension.toUpperCase() == "XLS" || 
                				                 fileExtension.toUpperCase() == "TXT" || fileExtension.toUpperCase() == "XLSX") {
                				            var link = document.createElement('a');
                				            link.href = "data:application/octet-stream;base64," + encodeURI(responseTxt);
                				            var fileName = documentName + "." + fileExtension.toLowerCase();
                				            link.download = fileName;
                				            link.click(); // Trigger the download
                				            showSuccessMessage(getCommonTranslation('SUCCESS'),getFeeAndPaymentCommonTranslation('PREVIEW_NOT_AVAILABLE_FOR_THIS_FILE'));
                				        }
                						else{
                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
                						}
            						}
            						else{
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
            						}
            					}
            				});
            		}
            	}
            },
            "quickCommentWindowStructure": {
            	afterrender:function(structure){
            		var currentLogginUser = this.getCurrentlyLoggedInUser().id;
            		var quickCommentInput = this.getQuickCommentInput();
            		var inputBox = quickCommentInput.down('#addQuickCommentItemId')
            		var sendBtn = quickCommentInput.down('#quickCommentSend')
            		var selRec;
            		if(portalId == '1'){
            			selRec = this.getStudentSearchResultGrid().getSelectionModel().getSelection()[0].data.ID
            		}
            		if(portalId == '2'){
            			if(typeof this.getFacultySearchResultGrid() !== 'undefined'){
            				selRec = this.getFacultySearchResultGrid().getSelectionModel().getSelection()[0].data.ID
                		}
                		else{
                			selRec = this.getRequestpendingactiongrid().getSelectionModel().getSelection()[0].data.ID
                		}	
            		}
					if(portalId == '3'){
		            	selRec = this.getStudentportalstudentrequestgrid().getSelectionModel().getSelection()[0].data.id		
					}
            		var submitUrl = SERVERURL.PATH_HAS_RIGHT_TO_QUICK_COMMENT;
            		Ext.Ajax.request({
                        type: 'rest',
                        url: submitUrl,
                        method: 'GET',
                        async: false,
                        params: {
                        	logUserId: currentLogginUser,
                        	serviceRequestId: selRec
                        },
                        success: function (response, action) {
                            if(response.responseText == 'false'){
                            	inputBox.setDisabled(true)
                            	sendBtn.setDisabled(true)
                            }
                        }
                    });
            	}
            },
            'requestpendingactiongrid': { 
            	selectionchange: function (column, selected, grid) {
                    this.enableDisableQuickCommentToFacultyRequestBtn(column, selected, grid);
                }
            },
            'requestpendingactiongrid button#quickCommentToFacultyRequestId': { 
            	click: function (button) {
                    this.openQuickComment(button);
                }
            },
        });
    },
    onLeaveOfAbsenceFieldCheck: function () {
        var leaveofAbsenceForm = this.getLeaveofabsencerequestform();
        var checkbox1 = leaveofAbsenceForm.down('#loaRequesterDeclarationSecondId');
        var checkbox2 = leaveofAbsenceForm.down('#loaStudentconfirmationId');
        var isMandatory1 = checkbox1.isMandatory;
        var isMandatory2 = checkbox2.isMandatory;
        if (isMandatory1 == "true" && isMandatory2 == "false") {
            if (checkbox1.checked && leaveofAbsenceForm.isValid()) {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(false);
            } else {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(true);
            }
        } else if (isMandatory2 == "true" && isMandatory1 == "false") {
            if (checkbox2.checked && leaveofAbsenceForm.isValid()) {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(false);
            } else {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(true);
            }
        } else if (isMandatory2 == "true" && isMandatory1 == "true") {
            if (checkbox1.checked && checkbox2.checked && leaveofAbsenceForm.isValid()) {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(false);
            } else {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(true);
            }
        } else if (isMandatory2 == "false" && isMandatory1 == "false") {
            if (leaveofAbsenceForm.isValid()) {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(false);
            }
        }
    },
    onStudentTransferFieldCheck: function () {
        var studentTransferPanel = this.getStudenttransferrequestdetailspanel();
      /*  
        var tab = studentTransferPanel.up('panel');
        var panel = tab.down('servicerequestdocumentspanel');*/
        var fieldsArray=[{name:'authorizeDeclaration'},{name:'upToDateDetails'},{name:'confirmation'},{name:'visaRefusalCheck'},{name:'studiedInUkCheck'},{name:'healthInsuranceCheck'},{name:'scholarshipCheck'},{name:'medicalIssuesCheck'}];
      /*  var docSubmitBtn = panel.down('#btnSaveRequestWithDocuments');*/
        var submitButton = studentTransferPanel.down('#studentTransferSubmitBtn');
        var documentPanel =submitButton.up().up().up().down('servicerequestdocumentspanel');
        if(!isNullOrEmpty(documentPanel)){
        var docSubmitBtn = documentPanel.down('#btnSaveRequestWithDocuments');
        }
        var enableSubmit = true;
        
        for (var i = 0; i < fieldsArray.length; i++) {
            var field = fieldsArray[i];
        	var field1 = studentTransferPanel.getForm().findField(field.name);
        	
        	
        	if (field1.isMandatory =="true" && field1.isVisible() && !field1.checked) {
                enableSubmit = false;
                break;
            }
        	
        	if (field1.isMandatory=="true" && !field1.isVisible()) {
                continue;
            }
        	
        	 if (!(field1.isMandatory=="true")) {
                 continue;
             }
        	
        }
        
        if(!(enableSubmit && studentTransferPanel.isValid())){
        	if(!isNullOrEmpty(docSubmitBtn) && docSubmitBtn!=undefined && docSubmitBtn.isVisible())
        	{
        		docSubmitBtn.setDisabled(true);
        	}
        	submitButton.setDisabled(true);
        }
        else
        {
        	if(!isNullOrEmpty(docSubmitBtn) && docSubmitBtn!=undefined && docSubmitBtn.isVisible())
        	{
        		docSubmitBtn.setDisabled(false);
        	}
        	submitButton.setDisabled(false);
        }
        
      /*  if (isMandatory1 == "true" && isMandatory2 == "false") {
            if (checkbox1.checked && leaveofAbsenceForm.isValid()) {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(false);
            } else {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(true);
            }
        } else if (isMandatory2 == "true" && isMandatory1 == "false") {
            if (checkbox2.checked && leaveofAbsenceForm.isValid()) {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(false);
            } else {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(true);
            }
        } else if (isMandatory2 == "true" && isMandatory1 == "true") {
            if (checkbox1.checked && checkbox2.checked && leaveofAbsenceForm.isValid()) {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(false);
            } else {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(true);
            }
        } else if (isMandatory2 == "false" && isMandatory1 == "false") {
            if (leaveofAbsenceForm.isValid()) {
                leaveofAbsenceForm.down('#leaveOfAbsenceReqUploadSubmitBtn').setDisabled(false);
            }
        }*/
    },
    
    onExchangeSemesterFieldCheck: function () {
        var exchangeSemesterPanel = this.getExchangesemesterrequestdetailspanel();    
        var fieldsArray=[{name:'authorizeDeclaration'},{name:'upToDateDetails'},{name:'confirmation'},{name:'visaRefusalCheck'},{name:'studiedInUkCheck'},{name:'healthInsuranceCheck'},{name:'scholarshipCheck'},{name:'medicalIssuesCheck'}];
        
        var submitButton = exchangeSemesterPanel.down('#exchangeSemesterreqUploadSubmitBtn');
        var documentPanel =submitButton.up().up().up().down('servicerequestdocumentspanel');
        if(!isNullOrEmpty(documentPanel)){
        var docSubmitBtn = documentPanel.down('#btnSaveRequestWithDocuments');
        }
        var enableSubmit = true;
        
        for (var i = 0; i < fieldsArray.length; i++) {
            var field = fieldsArray[i];
        	var field1 = exchangeSemesterPanel.getForm().findField(field.name);
        	
        	
        	if (field1.isMandatory =="true" && field1.isVisible() && !field1.checked) {
                enableSubmit = false;
                break;
            }
        	
        	if (field1.isMandatory=="true" && !field1.isVisible()) {
                continue;
            }
        	
        	 if (!(field1.isMandatory=="true")) {
                 continue;
             }
        	
        }
        
        if(!(enableSubmit && exchangeSemesterPanel.isValid())){
        	if(!isNullOrEmpty(docSubmitBtn) && docSubmitBtn!=undefined && docSubmitBtn.isVisible())
        	{
        		docSubmitBtn.setDisabled(true);
        	}
        	submitButton.setDisabled(true);
        }
        else
        {
        	if(!isNullOrEmpty(docSubmitBtn) && docSubmitBtn!=undefined && docSubmitBtn.isVisible())
        	{
        		docSubmitBtn.setDisabled(false);
        	}
        	submitButton.setDisabled(false);
        }
        
      
    },
    
    addMultipleLeaveType: function (obj) {
        var $this = this;
        var stopContiner = $this.getEmployeeleaverequestdetailspanel().down('#leaveContainerId');
        var panelItem = new Array();
        var fieldContainer = obj.up('fieldcontainer');
        var newcont = stopContiner.items.items.length;
        var insertPosition = newcont + 1;
        panelItem.push({
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'leaveTypeId',
                itemId: 'HRLeaveTypeItemId' + insertPosition,
                store: 'leavemanagement.LeaveTypeStore',
                displayField: 'value',
                valueField: 'id',
                width:226,
                forceSelection: true,
                editable: false,
                typeAhead: true,
                allowBlank: false,
                listeners: {
                    render: function (combo) {
                        var store = Ext.create('Academia.store.leavemanagement.LeaveTypeStore');
                        combo.bindStore(store);
                        var academyLocationId = $this.getCurrentAcademyLocation();
                        store.proxy.extraParams = {
                            academyLocationId: academyLocationId
                        };
                        store.load();
                    }
                }
            }, {
                xtype: 'datefield',
                name: 'fromDate',
                itemId: 'requestFromDateId' + insertPosition,
                format: CONSTANTS.DATE_FORMAT,
                width:226,
                vtype: 'daterange',
                endDateField: 'requestToDateId',
                allowBlank: false,
            }, {
                xtype: 'datefield',
                name: 'toDate',
                itemId: 'requestToDateId' + insertPosition,
                format: CONSTANTS.DATE_FORMAT,
                width:226,
                vtype: 'daterange',
                startDateField: 'requestFromDateId',
                allowBlank: false,
            }, {
                xtype: 'button',
                itemId: 'delFilterBtn',
                cls: 'CustomBodyBtnReject',
                glyph: ICONGLYPH.DELETEGLYPH,
                tooltip: getCommonTranslation('DELETE'),
                listeners: {
                    click: function (obj) {
                        var container = obj.up('fieldcontainer');
                        var panelContiner = $this.getEmployeeleaverequestdetailspanel().down('#leaveContainerId');
                        panelContiner.remove(container);
                        $this.getEmployeeleaverequestdetailspanel().getForm().isValid();
                    }
                }
            }, {
                xtype: 'button',
                itemId: 'addFilterBtn',
                cls: 'CustomBodyBtnSettings mtAddRow',
                text: getCommonTranslation('ADDBUTTONTEXT'),
                tooltip: getCommonTranslation('ADD'),
            }]
        });
        stopContiner.insert(insertPosition, panelItem);
        stopContiner.doLayout();
    },
    viewMultipleLeaveType: function (length, data) {
        var $this = this;
        var stopContiner = $this.getEmployeeleaverequestdetailspanel().down('#leaveContainerId');
        stopContiner.removeAll(true);
        var fieldContainer = $this.getEmployeeleaverequestdetailspanel().up('fieldcontainer');
        //var newcont = stopContiner.items.items.length;
       // var insertPosition = newcont + 1;
        for (var i = 1; i <= length; i++) {
            var panelItem = new Array();
            if (i == 1) {
                panelItem.push({
                    xtype: 'fieldcontainer',
                    width: '100%',
                    layout: 'hbox',
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [{
                        xtype: 'customcombobox',
                        name: 'leaveTypeId',
                        itemId: 'HRLeaveTypeItemId' + i,
                        store: 'leavemanagement.LeaveTypeStore',
                        fieldLabel: getCommonTranslation('LEAVE_TYPE'),
                        displayField: 'value',
                        value: data[i - 1].detail.leaveTypeId,
                        valueField: 'id',
                        forceSelection: true,
                        editable: false,
                        typeAhead: true,
                        allowBlank: false,
                        listeners: {
                            render: function (combo) {
                                var store = Ext.create('Academia.store.leavemanagement.LeaveTypeStore');
                                combo.bindStore(store);
                                var academyLocationId = $this.getCurrentAcademyLocation();
                                store.proxy.extraParams = {
                                    academyLocationId: academyLocationId
                                };
                                store.load();
                            }
                        }
                    }, {
                        xtype: 'datefield',
                        name: 'fromDate',
                        itemId: 'requestFromDateId' + i,
                        value: new Date(data[i - 1].detail.fromDate),
                        fieldLabel: getServiceRequestTranslation('LEAVE_REQUEST_FROM_DATE'),
                         //--submitFormat: CONSTANTS.DATE_FORMAT,
                        format: CONSTANTS.DMY_SLASH_DATE_FORMAT,
                        vtype: 'daterange',
                        endDateField: 'requestToDateId' + i,
                         //--submitFormat: CONSTANTS.DATE_FORMAT,
                    }, {
                        xtype: 'datefield',
                        name: 'toDate',
                         //--submitFormat: CONSTANTS.DATE_FORMAT,
                        fieldLabel: getServiceRequestTranslation('LEAVE_REQUEST_TO_DATE'),
                        itemId: 'requestToDateId' + i,
                        value: new Date(data[i - 1].detail.toDate),
                        format: CONSTANTS.DMY_SLASH_DATE_FORMAT,
                        vtype: 'daterange',
                        startDateField: 'requestFromDateId' + i,
                         //--submitFormat: CONSTANTS.DATE_FORMAT,
                    }]
                });
            } else {
                panelItem.push({
                    xtype: 'fieldcontainer',
                    width: '100%',
                    layout: 'hbox',
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [{
                        xtype: 'customcombobox',
                        name: 'leaveTypeId',
                        itemId: 'HRLeaveTypeItemId' + i,
                        store: 'leavemanagement.LeaveTypeStore',
                        displayField: 'value',
                        value: data[i - 1].detail.leaveTypeId,
                        valueField: 'id',
                        forceSelection: true,
                        editable: false,
                        typeAhead: true,
                        allowBlank: false,
                        listeners: {
                            render: function (combo) {
                                var store = Ext.create('Academia.store.leavemanagement.LeaveTypeStore');
                                combo.bindStore(store);
                                var academyLocationId = $this.getCurrentAcademyLocation();
                                store.proxy.extraParams = {
                                    academyLocationId: academyLocationId
                                };
                                store.load();
                            }
                        }
                    }, {
                        xtype: 'datefield',
                        name: 'fromDate',
                        itemId: 'requestFromDateId' + i,
                        value: new Date(data[i - 1].detail.fromDate),
                        //--submitFormat: CONSTANTS.DATE_FORMAT,
                        format: CONSTANTS.DMY_SLASH_DATE_FORMAT,
                        vtype: 'daterange',
                        endDateField: 'requestToDateId' + i,
                        //--submitFormat: CONSTANTS.DATE_FORMAT,
                    }, {
                        xtype: 'datefield',
                        name: 'toDate',
                        //--submitFormat: CONSTANTS.DATE_FORMAT,
                        itemId: 'requestToDateId' + i,
                        value: new Date(data[i - 1].detail.toDate),
                        format: CONSTANTS.DMY_SLASH_DATE_FORMAT,
                        vtype: 'daterange',
                        startDateField: 'requestFromDateId' + i,
                        //--submitFormat: CONSTANTS.DATE_FORMAT,
                    }]
                });
            }
            stopContiner.insert(i - 1, panelItem);
            stopContiner.doLayout();
        }
    },
    /**
     * This method is use to get the reference to the service
     * request constants file
     */
    getServiceRequestConstant: function () {
        var serviceRequestConstant = Academia.constants.ServiceRequestConstants;
        return serviceRequestConstant;
    },
    /**
     * This function is to export pdf and xcel
     */
    exportRequest: function (exportUrl, filetype, whetherAll, requestType) {
        var quickSearchForm = null;
        var searchResultGrid = null;
        var pagingtoolbaroptions = null;
        var reportTitle = null;
        var jsonFormatFormData = null;
        if (requestType == 'STUDENT') {
            quickSearchForm = this.getFindRequestForm();
            searchResultGrid = this.getStudentSearchResultGrid();
            pagingtoolbaroptions = this.getStudentSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
            var reportTitle = getCommonTranslation('STUDENT_REQUEST');
        }
        if (requestType == 'FACULTY') {
            quickSearchForm = this.getFacultyFindRequestForm();
            searchResultGrid = this.getFacultySearchResultGrid();
            pagingtoolbaroptions = this.getFacultySearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
            var reportTitle = getCommonTranslation('FACULTY_REQUEST');
        }
        if (requestType == 'TOOLSERVICECOMPLAINT') {
            quickSearchForm = this.getComplaintSearchForm();
            searchResultGrid = this.getComplaintSearchResultGrid();
            pagingtoolbaroptions = this.getComplaintSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
            var reportTitle = getCommonTranslation('TOOL_SERVICE_GRIEVANCE');
        }
        var searchCriteriaString = this.createSearchCriteriaString(quickSearchForm);
        if (requestType == 'TOOLSERVICECOMPLAINT') {
            jsonFormatFormData = this.createComplaintJsonFormat(quickSearchForm);
        } else {
            jsonFormatFormData = this.createJsonFormat(quickSearchForm);
        }
       
        var tempJsonFormatFormData=[]
        jsonFormatFormData.searchCriterias.forEach(function(rec){
            if(rec.paramCode != "ACADEMY_LOCATION_ID"){
            	tempJsonFormatFormData.push(rec);
            }
        })
        
        jsonFormatFormData.searchCriterias=tempJsonFormatFormData;

        
        var visibleColumns = this.getVisibleColumns(searchResultGrid);
        if (!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) && searchResultGrid.store.getCurrentSortCriteria() != undefined && searchResultGrid.store.getCurrentSortCriteria() != null) jsonFormatFormData.sortCriterias = searchResultGrid.store.getCurrentSortCriteria();
        searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions, whetherAll, searchCriteriaString, visibleColumns, reportTitle);
    },
    createSearchCriteriaString: function (searchForm) {
        var me = this;
        var formValues = new Array();
        formValues = searchForm.getForm().getValues();
        var searchCriteriaString = "";
        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField' && key !== 'requestFor') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                searchCriteriaString = searchCriteriaString + keyValueJsonObject.paramCode + " : " + searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString = searchCriteriaString.substring(0, searchCriteriaString.length - 1);
        return searchCriteriaString;
    },
    gridRenderFunction: function (grid) {
        grid.addButtonToolbar();
    },
    gridRenderFunctionForCancelRequest: function (grid) {
        var butonstoolbar = grid.down('#functionButtonsToolbar');
        butonstoolbar.insert(4, {
            xtype: 'button',
            itemId: 'approveBtnRequestId',
            disabled: true,
            text: getCommonTranslation('APPROVE'),
            tooltip: getCommonTranslation('APPROVE')
        });
        butonstoolbar.insert(5, {
            xtype: 'button',
            itemId: 'rejectBtnRequestId',
            disabled: true,
            text: getCommonTranslation('REJECT'),
            tooltip: getCommonTranslation('REJECT')
        });
        butonstoolbar.insert(6, {
            xtype: 'splitbutton',
            text: getCommonTranslation('MOREACTIONS'),
            itemId: 'moreActionBtnRequestId',
            disabled: true,
            tooltip: getCommonTranslation('MOREACTIONS'),
            initComponent: function () {
                var btn = this;
                btn.menu = new Ext.menu.Menu({
                    items: [{
                        text: getCommonTranslation('CLOSE'),
                        itemId: 'closeBtnRequestId',
                        disabled: false
                    }]
                });
                this.callParent(arguments);
            }
        });
        butonstoolbar.insert(7, {
            xtype: 'button',
            itemId: 'approveBtnRequestId',
            disabled: true,
            hidden: true,
            text: getCommonTranslation('APPROVE'),
            tooltip: getCommonTranslation('APPROVE')
        });
        butonstoolbar.insert(5, {
            xtype: 'button',
            itemId: 'rejectBtnRequestId',
            disabled: true,
            hidden: true,
            text: getCommonTranslation('REJECT'),
            tooltip: getCommonTranslation('REJECT')
        });
        butonstoolbar.insert(6, {
            xtype: 'splitbutton',
            text: getCommonTranslation('MOREACTIONS'),
            itemId: 'moreActionBtnRequestId',
            disabled: true,
            hidden: true,
            tooltip: getCommonTranslation('MOREACTIONS'),
            initComponent: function () {
                var btn = this;
                btn.menu = new Ext.menu.Menu({
                    items: [{
                        text: getCommonTranslation('CLOSE'),
                        itemId: 'closeBtnRequestId',
                        disabled: false
                    }]
                });
                this.callParent(arguments);
            }
        });
        butonstoolbar.insert(7, {
            xtype: 'button',
            itemId: 'cancelBtnRequestId',
            disabled: true,
            text: getCommonTranslation('CANCEL_REQUEST'),
            tooltip: getCommonTranslation('CANCEL_REQUEST')
        });
        butonstoolbar.insert(8, {
            xtype: 'button',
            itemId: 'reassignBtnRequestId',
            disabled: true,
            text: getCommonTranslation('RE_ASSIGN_REQUEST'),
            tooltip: getCommonTranslation('RE_ASSIGN_REQUEST')
        });
        butonstoolbar.insert(9, {
            xtype: 'button',
            itemId: 'quickCommentId',
            disabled: true,
            text: getFeeAndPaymentCommonTranslation('QUICK_COMMENT'),
            tooltip: getFeeAndPaymentCommonTranslation('QUICK_COMMENT')
        });
    },
    getDocumentController: function () {
        var this$ = this;
        return this$.getController('Academia.controller.document.DocumentController');
    },
    /**
     * This method is used to load student track request grid
     * according to search criteria
     *
     * @param model
     * @param records
     * @return request according to search criteria
     */
    loadStudentGridAndSearchRequest: function (model, records) {
        var SearchForm = this.getFindRequestForm();
        var isStudentJouneySettingDone = null;
        if (SearchForm) {
            var trackrequestpanel = SearchForm.up('trackrequestpanel');
            var cbGrid = trackrequestpanel.down('#trackRequestGrid');
            var nonCbGrid = trackrequestpanel.down('#studentrequesttransferinGrid');
            var nonCbGrid2 = trackrequestpanel.down('studentportalstudentrequestgrid');
            SearchForm.down('#findButtonId').setDisabled(true);
            if (cbGrid) {
                var approveBtnRequestId = cbGrid.down('#approveBtnRequestId');
                var rejectBtnRequestId = cbGrid.down('#rejectBtnRequestId');
                var moreActionBtnRequestId = cbGrid.down('#moreActionBtnRequestId');
                var isAutoFollowUpChecked = SearchForm.down('#autoFollowupCheck').getValue();
                if (approveBtnRequestId) {
                    if (isAutoFollowUpChecked && portalId == '1') {
                        approveBtnRequestId.show();
                    } else {
                        approveBtnRequestId.hide();
                    }
                }
                if (rejectBtnRequestId) {
                    if (isAutoFollowUpChecked && portalId == '1') {
                        rejectBtnRequestId.show();
                    } else {
                        rejectBtnRequestId.hide();
                    }
                }
                if (moreActionBtnRequestId) {
                    if (isAutoFollowUpChecked && portalId == '1') {
                        moreActionBtnRequestId.show();
                    } else {
                        moreActionBtnRequestId.hide();
                    }
                }
            }
        }
        if (!isNullOrEmpty(SearchForm)) {
            if (!this.validateDateFields(SearchForm)) {
                return;
            }
            var requestId = SearchForm.down('#request_id');
            var formValue = SearchForm.getForm().getValues();
            cbGrid.hide();
            nonCbGrid.hide();
            nonCbGrid2.hide();
            if (formValue.requestFor != "TRANSFER_IN_REQUESTS") {
                if (portalId == 3 || portalId == 7) {
                    nonCbGrid2.show();
                    var nonCbGridStore2 = nonCbGrid2.getStore();
                    setTimeout(function () {
                        structure = nonCbGrid2.up('trackrequestpanel');
                        structure.scrollBy(0, 1);
                        structure.scrollBy(0, -1);
                    }, 300);
                    var transferringOutALs;
                    if (formValue.transferringOutAL && formValue.transferringOutAL.length) {
                        if (typeof formValue.transferringOutAL[0] == "object") {
                            transferringOutALs = Ext.Array.pluck(Ext.Array.pluck(formValue.transferringOutAL, 'data'), 'id').join();
                        }
                    }
                    nonCbGridStore2.getProxy().extraParams = {
                        ALId: this.getCurrentAcademyLocation(),
                        requestId: formValue.REQUEST_ID,
                        requesterType: formValue.REQUESTER_TYPE,
                        studentId: this.getCurrentlyLoggedInUser().id,
                        assigneeID: formValue.assigneeId,
                        requestStatus: formValue.STATUS,
                        fromDate: formValue.FROM_DATE,
                        toDate: formValue.TILL_DATE,
                        requestCategory: formValue.SERVICE_REQUEST_GROUP,
                        requestTypeId: formValue.REQUEST_TYPE_ID
                    }
                    nonCbGridStore2.load({
                        callback: function (records, operation, success) {
                            if (success) {
                                SearchForm.down('#findButtonId').setDisabled(false);
                            }
                        }
                    });
                } else {
                    cbGrid.show();
                    setTimeout(function () {
                        structure = cbGrid.up('trackrequestpanel');
                        structure.scrollBy(0, 1);
                        structure.scrollBy(0, -1);
                    }, 300);
                    var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
                    if (jsonFormatFormData) {
                        var studentResultGrid = this.getStudentSearchResultGrid();
                        studentResultGrid.setVisible(true);
                        studentResultGrid.getSelectionModel().deselectAll();
                        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
                        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_TRACK_VIEWCODE);
                        if (jsonFormatFormData && jsonFormatFormData.configCode == "STUDENT_TRACK_REQUEST") {
                            if (jsonFormatFormData.searchCriterias && jsonFormatFormData.searchCriterias.length && jsonFormatFormData.searchCriterias[0].paramCode == "requestFor") {
                                if (jsonFormatFormData.searchCriterias[0].paramValues[0] == "All_REQUESTS") {
                                	Ext.Ajax.request({
                                        type: 'rest',
                                        url: SERVERURL.FIND_ALL_DROPDOWN,
                                        method: 'GET',
                                        async: false,
                                        success: function (response, action) {
                                        	if(response != undefined && response.responseText !=null && !isEmpty(response.responseText)){
                                        	var responseTxt = Ext.decode(response.responseText);
                                        	if (responseTxt!=undefined && responseTxt.type=="IsStudentJourneyImplemented" && responseTxt.name=="true"){}	  
                                        		isStudentJouneySettingDone = true;
                                        	} else {
                                        		isStudentJouneySettingDone = false;
                                        	}
                                        }
                                    });
                                    for (var ii = 0; ii < jsonFormatFormData.searchCriterias.length; ii++) {
                                    	if ( !isNullOrEmpty(isStudentJouneySettingDone) && isStudentJouneySettingDone  && jsonFormatFormData.searchCriterias[ii].paramCode == "ACADEMY_LOCATION_ID") {
                                            jsonFormatFormData.searchCriterias.splice(ii, 1);
                                            ii--;
                                        }
                                    }
                                }
                            }
                        }
                        studentResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData, SearchForm.down('#findButtonId'));
                        Ext.defer(function () {
                            var portalId = this.getCurrentLoggedPortalId();
                            if (portalId == 3 || portalId == 7) {
                                studentResultGrid.down('#uploadDocumentBtn').disable(true);
                                if (!isNullOrEmpty(grid.columnManager.columns)) {
                                    for (var i = grid.columnManager.columns.length - 1; i >= 0; i--) {
                                        var column = studentResultGrid.columnManager.columns[i];
                                        if (column.dataIndex == 'REQUESTER_NAME' || column.dataIndex == 'REQUESTER_TYPE' || column.dataIndex == 'SERVICE_REQUEST_STAGE' || column.dataIndex == 'SERVICE_REQUEST_GROUP' || column.dataIndex == 'EMAIL_ID' || column.dataIndex == 'MOBILE_NUMBER' || column.dataIndex == 'LAST_NAME' || column.dataIndex == 'SLA_DAYS' || column.dataIndex == 'PROGRAM_NAME' || column.dataIndex == 'SECTION_CODE') {
                                            column.hide();
                                        }
                                    }
                                }
                            }
                        }, 20, this);
                    }
                }
            } else {
                nonCbGrid.show();
                var nonCbGridStore = nonCbGrid.getStore();
                var transferringOutALs;
                if (formValue.transferringOutAL && formValue.transferringOutAL.length) {
                    if (typeof formValue.transferringOutAL[0] == "object") {
                        transferringOutALs = Ext.Array.pluck(Ext.Array.pluck(formValue.transferringOutAL, 'data'), 'id').join();
                    }
                }
                nonCbGridStore.getProxy().extraParams = {
                    fromALIds: transferringOutALs,
                    ALId: this.getCurrentAcademyLocation(),
                    requestId: formValue.REQUEST_ID,
                    requesterType: formValue.REQUESTER_TYPE,
                    studentId: formValue.STUDENT_ID,
                    assigneeID: formValue.assigneeId,
                    requestStatus: formValue.STATUS,
                    fromDate: formValue.FROM_DATE,
                    toDate: formValue.TILL_DATE
                }
                nonCbGridStore.load({
                    callback: function (records, operation, success) {
                        if (success) {
                            SearchForm.down('#findButtonId').setDisabled(false);
                        }
                    }
                });
            }
        }
    },
    validateDateFields: function (SearchForm) {
        if (!isNullOrEmpty(SearchForm)) {
            if (!isNullOrEmpty(SearchForm.down("#from_date").value) || !isNullOrEmpty(SearchForm.down("#till_date").value)) {
                if (isNullOrEmpty(SearchForm.down("#from_date").value)) {
                    if (SearchForm.getXType() === "facultyfindrequestform") {
                        showWarningMessage(getServiceRequestTranslation('EMPLOYEE_REQUEST'), getServiceRequestTranslation('ENTER_FROM_DATE'));
                    } else {
                        showWarningMessage(getServiceRequestTranslation('STUDENT_REQUEST'), getServiceRequestTranslation('ENTER_FROM_DATE'));
                    }
                    return false;
                }
                if (isNullOrEmpty(SearchForm.down("#till_date").value)) {
                    if (SearchForm.getXType() === "facultyfindrequestform") {
                        showWarningMessage(getServiceRequestTranslation('EMPLOYEE_REQUEST'), getServiceRequestTranslation('ENTER_TILL_DATE'));
                    } else {
                        showWarningMessage(getServiceRequestTranslation('STUDENT_REQUEST'), getServiceRequestTranslation('ENTER_TILL_DATE'));
                        SearchForm.down('#findButtonId').setDisabled(false);
                    }
                    return false;
                }
            }
        }
        return true;
    },
    validateDateFieldsForComplaint: function (SearchForm) {
        if (!isNullOrEmpty(SearchForm)) {
            if (!isNullOrEmpty(SearchForm.down("#complaint_from_date").value) || !isNullOrEmpty(SearchForm.down("#complaint_to_date").value)) {
                if (isNullOrEmpty(SearchForm.down("#complaint_from_date").value)) {
                    if (SearchForm.getXType() === "ComplaintSearchForm") {
                        showWarningMessage(getServiceRequestTranslation('EMPLOYEE_REQUEST'), getServiceRequestTranslation('ENTER_COMPLAINT_FROM_DATE'));
                    } else {
                        showWarningMessage(getServiceRequestTranslation('STUDENT_REQUEST'), getServiceRequestTranslation('ENTER_COMPLAINT_FROM_DATE'));
                    }
                    return false;
                }
                if (isNullOrEmpty(SearchForm.down("#complaint_to_date").value)) {
                    if (SearchForm.getXType() === "ComplaintSearchForm") {
                        showWarningMessage(getServiceRequestTranslation('EMPLOYEE_REQUEST'), getServiceRequestTranslation('ENTER_COMPLAINT_TO_DATE'));
                    } else {
                        showWarningMessage(getServiceRequestTranslation('STUDENT_REQUEST'), getServiceRequestTranslation('ENTER_COMPLAINT_TO_DATE'));
                    }
                    return false;
                }
            }
        }
        return true;
    },
    /**
     * This method is used to load faculty track request grid
     * according to search criteria
     *
     * @param model
     * @param records
     * @return request according to search criteria
     */
    loadFacultyGridAndSearchRequest: function (model, records) {
        var SearchForm = this.getFacultyFindRequestForm();
        var $this = this;
        if (!isNullOrEmpty(SearchForm)) {
            if (!this.validateDateFields(SearchForm)) {
                return;
            }
            var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
            if (jsonFormatFormData) {
                var facultyResultGrid = this.getFacultySearchResultGrid();
                facultyResultGrid.setVisible(true);
                var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
                resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_TRACK_VIEWCODE);
                facultyResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
            }
            Ext.defer(function () {
                var portalId = $this.getCurrentLoggedPortalId();
                if (portalId == 2 && facultyResultGrid.columnManager.columns) {
                    for (var i = facultyResultGrid.columnManager.columns.length - 1; i >= 0; i--) {
                        var column = facultyResultGrid.columnManager.columns[i];
                        if (column.dataIndex == 'REQUEST_ASSIGNED_TO') {
                            column.hide();
                        }
                    }
                }
            }, 1000, $this);
        }
    },
    /**
     * This method is used to load complaint track request grid
     * according to search criteria
     *
     * @param model
     * @param records
     * @return request according to search criteria
     */
    loadComplaintGridAndSearchRequest: function (model, records) {
        var SearchForm = this.getComplaintSearchForm();
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getGRIEVANCE_RADIO_BUTTON_PERMISSIONS());
		SearchForm.down('#allComplain').setVisible(false);
		SearchForm.down('#myComplain').setVisible(false);	   
		SearchForm.down('#complainFor').setVisible(false);
		if (!isNullOrEmpty(permissionList)) {
			SearchForm.down('#complainFor').setVisible(true);
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'ALL_GRIEVANCE') {
					SearchForm.down('#allComplain').setVisible(true);
				} else if (privilege === 'MY_GRIEVANCE') {
					SearchForm.down('#myComplain').setVisible(true);
				}
			});
			
		}
		  
        if (!this.validateDateFieldsForComplaint(SearchForm)) {
            return;
        }
        var jsonFormatFormData = this.createComplaintJsonFormat(SearchForm);
        if (jsonFormatFormData) {
            var complaintResultGrid = this.getComplaintSearchResultGrid();
            var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.COMPLAINT_VIEWCODE);
            complaintResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        }
		if (!isNullOrEmpty(permissionList) && permissionList.length === 1 && permissionList[0] === 'MY_GRIEVANCE') {
						SearchForm.down('#myComplain').setValue(true);
		}
    },
    /**
     * This method is used to create JSON format of form values
     *
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function (SearchForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        if (SearchForm) {
            if (SearchForm.xtype === 'findrequestform') {
                values.configCode = CONSTANTS.CB.STUDENT_TRACK_BASIC_CONFIGCODE;
            } else {
                values.configCode = CONSTANTS.CB.FACULTY_TRACK_BASIC_CONFIGCODE;
            }
            formValues = SearchForm.getValues();
            if (!isNullOrEmpty(formValues.autoFollowupCheck)) {
                formValues.AUTO_FOLLOWUP_CHECK = formValues.autoFollowupCheck;
                delete formValues.autoFollowupCheck;
            } else {
                formValues.AUTO_FOLLOWUP_CHECK = false;
            }
            delete formValues.selectedNameField;
            for (var key in formValues) {
                var value = formValues[key];
                if (!isNullOrEmpty(value) && key !== 'FROM_DATE' && key !== 'TILL_DATE') {
                    var keyValueJsonObject = this.getJsonObject(key, value);
                    this.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
                }
            }
            var REQUEST_DATE = this.getJsonObject('REQUEST_DATE', formValues.FROM_DATE, formValues.TILL_DATE);
            this.pushJsonObjectInArray(REQUEST_DATE, searchcriteria);
            var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', this.getCurrentAcademyLocation());
            this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);
            if (!isNullOrEmpty(formValues.assigneeId)) {
                var ASSIGNEE_ID = this.getJsonObject('ASSIGNEE_ID', formValues.assigneeId);
                this.pushJsonObjectInArray(ASSIGNEE_ID, searchcriteria);
            }
            if (!isNullOrEmpty(formValues.assignTo) && !isNullOrEmpty(formValues.assignTo.id)) {
                var ASSIGNEE_ID = this.getJsonObject('ASSIGNEE_ID', formValues.assignTo.id);
                this.pushJsonObjectInArray(ASSIGNEE_ID, searchcriteria);
            }
            if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
                var STUDENT_USERID = this.getJsonObject('STUDENT_USERID', this.getCurrentlyLoggedInUserInfoForPortal().student.id);
                var lastName = this.getCurrentlyLoggedInUserInfoForPortal().student.student_id;
                if (isNullOrEmpty(lastName)) {
                    lastName = '';
                }
                var STUDENT_LASTNAME = this.getJsonObject('REQUESTER_LASTNAME', lastName);
                this.pushJsonObjectInArray(STUDENT_USERID, searchcriteria);
                this.pushJsonObjectInArray(STUDENT_LASTNAME, searchcriteria);
                /* V2D-27897 */
                if (!isNullOrEmpty(searchcriteria)) {
                    searchcriteria = searchcriteria.filter(function (el) {
                        return el.paramCode != "REQUESTER_TYPE";
                    });
                }
            }
            if (this.getCurrentLoggedPortalId() == 2 || formValues.requestFor == 'MY_REQUESTS' || (!SearchForm.config.isPermissionGiven && this.getCurrentLoggedPortalId() != 3 && this.getCurrentLoggedPortalId() != 7)) {
                //V2D-70055
                if (this.getCurrentlyLoggedInUser().id != 1) {
                    var FACULTY_ASSIGNEEID = this.getJsonObject('ASSIGNEE_ID', this.getCurrentlyLoggedInUser().id);
                    var FACULTY_REQUESTER = this.getJsonObject('REQUESTER_ID', this.getCurrentlyLoggedInUser().id);
                    var FACULTY_ENTERED = this.getJsonObject('ENTERED_BY_ID', this.getCurrentlyLoggedInUser().id);
                }
                this.pushJsonObjectInArray(FACULTY_ASSIGNEEID, searchcriteria);
                this.pushJsonObjectInArray(FACULTY_REQUESTER, searchcriteria);
                this.pushJsonObjectInArray(FACULTY_ENTERED, searchcriteria);
            }
            values.searchCriterias = searchcriteria;
            return values;
        }
    },
    /**
     * This method is used to create JSON format of complaint
     * form values
     *
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createComplaintJsonFormat: function (SearchForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        if (SearchForm) {
            values.configCode = CONSTANTS.CB.COMPLAINT_BASIC_CONFIGCODE;
            formValues = SearchForm.getValues();
			var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', this.getCurrentAcademyLocation());
			           this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);
			var currentLoggedInUserId = this.getCurrentlyLoggedInUser().id;
            for (var key in formValues) {
                var value = formValues[key];
                if (!isNullOrEmpty(value) && key !== 'COMPLAINT_FROM_DATE' && key !== 'COMPLAINT_TO_DATE' && key !== 'complainFor') {
                    var keyValueJsonObject = this.getJsonObject(key, value);
                    this.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
                }
				if(!isNullOrEmpty(value) && key == 'complainFor' && value == 'MY_GRIEVANCE'){
					var ASSIGNEEID = this.getJsonObject('ASSIGNEE_ID', currentLoggedInUserId);
					var REQUESTER = this.getJsonObject('REQUESTER_ID', currentLoggedInUserId);
					var ENTERED_BY = this.getJsonObject('ENTERED_BY_ID', currentLoggedInUserId);
					
					this.pushJsonObjectInArray(ASSIGNEEID, searchcriteria);
					this.pushJsonObjectInArray(REQUESTER, searchcriteria);
					this.pushJsonObjectInArray(ENTERED_BY, searchcriteria);
				}
				
            }
            var COMPLAINT_TIME_BETWEEN = this.getJsonObject('COMPLAINT_TIME_BETWEEN', formValues.COMPLAINT_FROM_DATE, formValues.COMPLAINT_TO_DATE);
            this.pushJsonObjectInArray(COMPLAINT_TIME_BETWEEN, searchcriteria);
            values.searchCriterias = searchcriteria;
            return values;
        }
    },
    /**
     * This method is used to crate JSON object
     *
     * @param key
     * @param value
     * @param additional
     *            value
     * @return JSON object
     */
    getJsonObject: function (key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (key == "REQUEST_DATE" && value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value + " 00:00:00", additionalValue + " 23:59:59"]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        } else if (key == 'AUTO_FOLLOWUP_CHECK') {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        }
    },
    /**
     * This method is used to push JSON object into array &
     * create Object array
     *
     * @param JSON
     *            object
     * @param array
     * @return JSON object Array
     */
    pushJsonObjectInArray: function (object, array) {
        if (object) {
            array.push(object);
        }
    },
    /**
     * This method is used to get active tab from content panel
     *
     * @return active tab
     */
    getContentPanelActiveTab: function () {
        var this$ = this;
        var activeTab = null;
        var contentPanel = this$.getContentPanel();
        if (contentPanel) {
            activeTab = contentPanel.getActiveTab();
        }
        return activeTab;
    },
    toggleBasicDetailsFormItems: function (form) {
        var tab = this.getContentPanelActiveTab();
        var enteredBy = form.down('[name=enteredBy]');
        enteredBy.setValue(this.getCurrentlyLoggedInUser().value);
        var requestType = tab.getRequestType();
        if (requestType === 'FACULTY_REQUEST') {
            var form = tab.down('basicdetails');
            if (form != null) {
                var requestBy = form.down('[name=requesterType]');
                requestBy.setVisible(false);
                requestBy.setDisabled(true);
            } else {
                var form = tab.down('freeformrequestdetailspanel');
                if (form != null) {
                    var requestBy = form.down('[name=requesterType]');
                    requestBy.setVisible(false);
                    requestBy.setDisabled(true);
                }
            }
        } else if (requestType === 'STUDENT_REQUEST') {}
        var portalId = this.getCurrentLoggedPortalId();
        if (portalId == 1) {
            var requestBy = form.down('[name=requesterType]');
            requestBy.setValue('ACADEMIC_ADMINISTRATOR');
            var requestDate = form.down('[name=requestDate]');
            var currentDate = new Date();
            requestDate.setValue(dateFormatRender(currentDate));
        } else if (portalId == 3) {
            var requestBy = form.down('[name=requesterType]'),
                requestDate = form.down('[name=requestDate]');
            setTimeout(function () {
                requestBy.setValue('STUDENT');
            }, 300);
            requestBy.setReadOnly(true);
            requestDate.setReadOnly(true);
        } else if (portalId == 7) {
            var requestBy = form.down('[name=requesterType]'),
                requestDate = form.down('[name=requestDate]');
            requestBy.setValue('PARENTS');
            requestBy.setReadOnly(true);
            requestDate.setReadOnly(true);
        }
    },
    /**
     * This is used to set entered by in apply for placement
     * form
     *
     * @param form
     */
    togglePlacementFormItems: function (form) {
        var enteredBy = form.down('#enteredById');
        enteredBy.setValue(this.getCurrentlyLoggedInUser().value);
    },
    /**
     * This method is used to open tab after click of RequestId
     * Cell of student track request grid Required :
     *
     * @param grid
     * @param cellIndex
     * @param record
     */
    cellclickTrackRequestGrid: function (grid, cellIndex, record) {
        var columnName = grid.columnManager.columns[cellIndex].dataIndex;
        isStdDetailReport = false;
        if (columnName === "REQUEST_ID") {
            var me = this;
            var requestId = record.get('ID');
            var requestType = record.data.SERVICE_REQUEST_TYPE;
            me.setRequestData(requestId, record, requestType);
        } else if (columnName === "VAL_DOCUMENT") {
            this.openValuntoryDocWindow(record.get('ID'));
        } else if (columnName === "MAN_DOCUMENT") {
            this.openMandatoryDocWindow(record.get('ID'),record.get('REQUEST_TYPE'));
        }
        if (columnName === "APPLICATION_FORM") {
            var me = this;
            var documentId = record.get('documentId');
            me.getDocumentController().downloadDocumentFile(documentId);
        }
        if (columnName === "APPROVER_LETTER") {
            var me = this;
            var documentId = record.get('approvalLetterId');
            me.getDocumentController().downloadDocumentFile(documentId);
        }
    },
    /**
     * This method is used to open tab after click of RequestId
     * Cell of complaint track request grid Required :
     *
     * @param grid
     * @param cellIndex
     * @param record
     */
    cellclickComplaintTrackRequestGrid: function (grid, cellIndex, record) {
        var columnName = grid.columnManager.columns[cellIndex].dataIndex;
        if (columnName === "COMPLAINT_ID" || columnName === "GRIEVANCE_ID") {
            var me = this;
            var requestId = record.get('ID');
            var requestType = record.data.REQUEST_TYPE;
            me.setComplaintRequestData(requestId, record, requestType);
        }
    },
    /**
     * This method is used to set values in complaint request
     * form & make it read only in case of track request
     *
     * @param requestId
     * @param record
     *            which is selected record from grid
     */
    setComplaintRequestData: function (requestId, record, requestType) {
        var me = this;
        var param = {
            id: requestId
        };
        me.sendGetAjaxRequest(SERVERURL.COMPLAINT_FIND_BY_ID, 'GET', param, function (option, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                me.openComplaintPanel(data);
                me.saveComplaintRequestData(data, record);
                me.toggleSubmitButtonOnFollowUpForm(data, requestType);
            }
        });
    },
    /**
     * This method is used to Open complaint Panel
     */
    openComplaintPanel: function (data) {
        var me = this;
        var requestTitle = data.requestId;
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        var getTab = getcontroller.getTab(requestTitle);
        if (getTab != null) {
            contentPanel.remove(getTab, true);
        }
        var tab = this.openTab(requestTitle, 'servicerequestpanel', CONSTANTS.MENU_COLOR_NINE);
        var requestId = data.id;
        me.applyServiceRequestConfig(tab);
        me.applyRequestId(tab, requestId);
        tab.setResponseData(data);
        tab.setServiceRequestId(requestId);
        tab.setServiceRequestId(requestId);
        var requestPanel = Ext.widget('complaintdetailsform');
        if (data.detail.complaintBy === 'PARENTS' || data.detail.complaintBy === 'OTHERS') {
            var ref = requestPanel.down('#complaintByFieldContainer');
            var complaintantRef = requestPanel.down('#selectComplaintantId');
            if (complaintantRef) {
                ref.remove(complaintantRef);
                ref.insert(1, {
                    xtype: 'textfield',
                    fieldLabel: getServiceRequestTranslation('COMPLAINTANT'),
                    name: 'complainant',
                    itemId: 'complaintantId',
                    allowBlank: false
                });
                ref.doLayout();
            } else {
                var selectPersonCmbRef = requestPanel.down('#complaintantId');
                selectPersonCmbRef.reset();
            }
            var cmb = requestPanel.down('#selectPersonId');
            if (!isNullOrEmpty(cmb)) {
                cmb.setDisabled(false);
            }
        } else {
            var cmb = requestPanel.down('#selectPersonId');
            var combo = requestPanel.down('#selectComplaintantId');
            combo.reset();
            store = combo.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_FIND_BY_ID + '?id=' + requestId;
            store.load({
                callback: function (records, operation, success) {
                    if (success) {
                        combo.setValue(records[0].data.id);
                    }
                }
            });
            cmb.setDisabled(false);
            combo.setDisabled(false);
        }
        if (data.detail.against === 'NOT_APPLICABLE') {
            requestPanel.down('#selectPersonId').setVisible(false);
            requestPanel.down('#selectPersonId').setDisabled(true);
        }
        tab.add(requestPanel);
        var settingId = data.complaintTypeSetting.id;
        tab.setSettingId(settingId);
    },
    /**
     * This method is used to set complaint request data & make form readOnly
     *
     * @param data which is complaint request response from server
     * @param record which is selected record from grid
     */
    saveComplaintRequestData: function (data, record) {
        var me = this;
        var serviceRequestForm = me.getContentPanelActiveTab();
        var form = serviceRequestForm.down('form');
        this.toggleWithdrawButton(data, record, form);
        me.addComplaintDetailsForm(data, record, serviceRequestForm);
        me.setPendingDays(form, data);
        me.setComplaintData(data, form, record);
        form.down('#facilityCodeId').getStore().load();
        me.toggleReadOnlyFormItems(form.getForm(), true);
        form.down('#btnSaveComplaint').setVisible(false);
        form.down('#cancelIdComplaint').setVisible(false);
    },
    /**
     * THis is used to set data into complaint details form
     */
    setComplaintData: function (data, form, record) {
        var me = this;
        var formData = me.createComplaintRequestObject(data, record);
        form.getForm().setValues(formData);
        var selectPersonCmbRef = form.down('#selectPersonId');
        if (formData.against === 'FACULTY') {
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(formData.against);
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_FACULTY_COMBO;
            store.load({
                callback: function (records, operation, success) {
                    if (success) {
                        selectPersonCmbRef.setValue(formData.detail.complaintAgainstPerson.id);
                    }
                }
            });
        } else if (formData.against === 'STUDENT') {
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(formData.against);
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_STUDENT_COMBO;
            store.load({
                callback: function (records, operation, success) {
                    if (success) {
                        if (formData.detail && formData.detail.complaintAgainstPerson) {
                            selectPersonCmbRef && selectPersonCmbRef.setValue(formData.detail.complaintAgainstPerson.id);
                        }
                    }
                }
            });
        } else if (formData.against === 'STAFF') {
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(formData.against);
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_STAFF_COMBO;
            store.load({
                callback: function (records, operation, success) {
                    if (success) {
                        selectPersonCmbRef.setValue(formData.detail.complaintAgainstPerson.id);
                    }
                }
            });
        }
    },
    /**
     * This is used to set form values in complaint form in case of track request
     */
    createComplaintRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.complaintTypeId = data.detail.complaintTypeId;
        formData.requestDate = new Date(data.requestDate);
        formData.against = data.detail.against;
        formData.complaintBy = data.detail.complaintBy;
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        if (isNullOrEmpty(data.requestAssignedTo)) {
            formData.requestAssignedTo = data.complaintTypeSetting.defaultAssignee;
        }
        if (formData.complaintBy === 'OTHERS' || formData.complaintBy === 'PARENTS') {
            formData.complainant = data.detail.complainant;
        } else {
            formData.complainant = data.requester.value;
            if (!isNullOrEmpty(data.detail.complaintAgainstPerson)) {
                formData.complaintAgainstPerson = data.detail.complaintAgainstPerson.value;
            }
        }
        formData.internalResourceId = data.detail.internalResourceId;
        formData.facilityDescription = data.detail.facilityDescription;
        return formData;
    },
    /**
     * This method is used to set serviceRequestId to TAB
     *
     * @param newTab
     * @param tabTitle
     */
    applyRequestId: function (newTab, requestId) {
        Ext.apply(newTab, {
            serviceRequestId: '',
            setServiceRequestId: function (requestId) {
                newTab.serviceRequestId = requestId;
            },
            getServiceRequestId: function () {
                return newTab.serviceRequestId;
            }
        });
    },
    /**
     * This method is used to set values in request form & make
     * it read only in case of track request
     *
     * @param requestId
     * @param record
     *            which is selected record from grid
     */
    setRequestData: function (requestId, record, requestType) {
        var map = Academia.view.servicerequest.ServiceRequestViewMap;
        var me = this;
        var serviceRequestForm = me.getContentPanelActiveTab();
        var form = serviceRequestForm.down('form');
        var url = map.getRequestTypeUrl(requestType);
        if (isNullOrEmpty(url) && !isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.type)) {
            url = map.getRequestTypeUrl(record.data.type);
        }
        var param = {
            requestId: requestId
        };
        me.sendGetAjaxRequest(url, 'GET', param, function (option, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                me.openTrackRequestTabPanel(data, record);
                if (!isNullOrEmpty(data.requestDate)) data.requestDate = new Date(data.requestDate);
                if (!isNullOrEmpty(data.detail)) {
                    if (!isNullOrEmpty(data.detail.withdrawDate)) data.detail.withdrawDate = new Date(data.detail.withdrawDate);
                }
                if (!isNullOrEmpty(data.dueDate)) data.dueDate = new Date(data.dueDate);
                if (requestType == 'EMPLOYEELEAVE' || requestType == 'Employeeleave' || requestType == 'LEAVE') {
                    if (!isNullOrEmpty(data.detail)) {
                        data.detail.fromDate = new Date(data.detail.fromDate);
                        data.detail.toDate = new Date(data.detail.toDate);
                    }
                }
                if (requestType == 'CERTIFICATE') {
                    if (!isNullOrEmpty(data.executionDetail)) {
                        if (!isNullOrEmpty(data.executionDetail.handoverDate)) data.executionDetail.handoverDate = new Date(data.executionDetail.handoverDate);
                    }
                }
                if (requestType == "HOSTEL_LEAVE") {
                    if (!isNullOrEmpty(data.detail)) {
                        data.detail.fromDate = new Date(data.detail.fromDate);
                        data.detail.toDate = new Date(data.detail.toDate);
                        if (!isNullOrEmpty(data.detail.fromTime)) {
                            data.detail.fromTime = timeRender(data.detail.fromTime);
                        }
                        if (!isNullOrEmpty(data.detail.toTime)) {
                            data.detail.toTime = timeRender(data.detail.toTime);
                        }
                    }
                }
                me.saveRequestData(data, record);
                me.toggleSubmitButtonOnFollowUpForm(data, requestType);
                if (requestType == 'FEE_RELATED') {
                    me.setVisibleFeeRequestGrid(requestId);
                }
                if (requestType == 'TERMINATION') {
                    var i = 1;
                    data.detail.terminationRequestMultipleReason.forEach(function (rec) {
                        rec.id = rec.terminationReason.id;
                        me.addTerminationReasonFields(i, form, true, rec.id);
                        i++;
                    });
                }
            }
        });
    },
    /**
     * This method is used to open tab request & apply config
     *
     * @param data
     *            which is service request response from server
     * @param record
     *            which is selected record from grid
     */
    openTrackRequestTabPanel: function (data, record) {
        var me = this;
        var requestId = record.get('ID');
        contentPanel = this.getContentPanel();
        var tabTitle = record.get('REQUEST_ID');
        var requestGroup = record.get('SERVICE_REQUEST_GROUP');
        var requestTypeId = record.get('REQUEST_TYPE_ID');
        var requestType = record.data.SERVICE_REQUEST_TYPE;
        if (requestGroup == null || requestGroup == undefined || requestGroup == "") {
            requestGroup = record.get('SERVICE_REQUEST_TYPE');
        }
        if (record.data.requestCategory == 'CERTIFICATE') {
            requestGroup = 'CERTIFICATE';
        }
        if (data.serviceRequestSetting.serviceRequestCategory === "FACULTY_REQUEST") {
            requestGroup = data.serviceRequestSetting.serviceRequestGroup;
        }
        var tab = this.getTabReferenceByTabTitle(tabTitle);
        if (tab === null) {
            var newTab = me.openTab(tabTitle, 'servicerequestpanel', CONSTANTS.MENU_COLOR_EIGHT);
            me.setTrackRequestConfig(newTab, data, record, requestId);
            var tempProgram = null;
            var admissionId = null;
            if (!isNullOrEmpty(data.detail) && !isNullOrEmpty(data.detail.program) && !isNullOrEmpty(data.detail.program)) {
                tempProgram = {
                    id: data.detail.program.id,
                    value: data.detail.program.value
                };
            }
            if (!isNullOrEmpty(data.detail) && !isNullOrEmpty(data.detail.admissionId)) {
                admissionId = data.detail.admissionId;
            }
            var details = me.findRequesterDetailsByRequestorType(data.serviceRequestSetting.serviceRequestCategory, data.requester.id, admissionId,newTab);
            if (!isNullOrEmpty(tempProgram)) {
                details.programs = tempProgram;
            }
            if (requestType === 'TRANSFER' || requestType === 'TERMINATION' || requestType === 'DEBARMENT') {
                if (requestType === 'DEBARMENT') {
                    details.academicTermId = data.detail.academicTermId;
                    details.programId = data.detail.programId;
                    details.whetherUnenrollFromCourses = data.detail.whetherUnenrollFromCourses;
                }
                me.openStudentServiceRequestPanel(requestType, newTab, requestTypeId, details);
                if (requestType === 'DEBARMENT') {
                    newTab.down('#leavingReasonsFieldset').removeAll();
                    if (data.detail.debarmentRequestDetailMultipleReason && !data.detail.debarmentRequestDetailMultipleReason.length) {
                    	newTab.down('#leavingReasonsFieldset').setVisible(false);
                    } else {
                        var i = 1;
                        data.detail.debarmentRequestDetailMultipleReason.forEach(function (rec) {
                            rec.id = rec.debarmentReason.value;
                            me.addLeavingReasonFields(i, newTab.down('debarmentform'), true, rec);
                            i++;
                        });
                    }
                }
            } else {
                newTab.config.freeFormRaiseReq = false;
                me.openServiceRequestPanel(requestGroup, newTab, requestTypeId, details, data);
            }
        } else {
            contentPanel.setActiveTab(tab);
        }
    },
    /**
     * This method is used to set config to tab request
     *
     * @param data
     *            which is service request response from server
     * @param record
     *            which is selected record from grid
     */
    setTrackRequestConfig: function (newTab, data, record, requestId) {
        var me = this;
        me.applyRequestId(newTab, requestId);
        newTab.setServiceRequestId(requestId);
        me.applyServiceRequestConfig(newTab);
        var requestType = data.serviceRequestSetting.serviceRequestCategory;
        var requestGroup = record.get('SERVICE_REQUEST_TYPE');
        var userId = record.get('REQUESTER');
        if (isNullOrEmpty(userId)) {
            userId = record.raw.requester;
        }
        var personId = record.get('PERSON_ID');
        var settingId = data.serviceRequestSetting.id;
        var programBatchId = record.get('PROGRAM_BATCH_ID');
        var progBatchPeriodConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
        var academyLocationId = data.serviceRequestSetting.academyLocation.id;
        var requestTypeCode = null;
        if (requestType == "STUDENT_REQUEST" && requestGroup == "LEAVE") {
            if (!isNullOrEmpty(data.serviceRequestSetting.requestType)) {
                requestTypeCode = data.serviceRequestSetting.requestType.code;
                newTab.config.requestTypeCode = requestTypeCode;
            }
        } else {
            newTab.config.requestTypeCode = null;
        }
        var admmisionId = null;
        if (!isNullOrEmpty(data.certificateRequestDetail)) {
            admmisionId = data.certificateRequestDetail.admissionId
        }
        var program = null;
        if (!isNullOrEmpty(data.detail)) {
            program = data.detail.program;
        }
        me.setServiceRequestConfig(newTab, requestType, requestGroup, userId, personId, null, settingId, data, admmisionId, data.serviceRequestSetting, programBatchId, progBatchPeriodConfigId, academyLocationId, program, requestTypeCode);
    },
    /**
     * This method is used to set request data & make form
     * readOnly
     *
     * @param data
     *            which is service request response from server
     * @param record
     *            which is selected record from grid
     */
    saveRequestData: function (data, record) {
        var me = this;
        var serviceRequestForm = me.getContentPanelActiveTab();
        var requestType = record.data.SERVICE_REQUEST_TYPE;
        if (requestType == "") {
            requestType = record.data.REQUEST_TYPE;
        }
        if (requestType == 'COURSES' || requestType == 'PROGRAM') {
            requestType = 'CERTIFICATE';
        }
        if (requestType == 'Personal Detail Change' || requestType == 'Stake Holder Request' || requestType == 'Medical History' || requestType == 'Previous Education Detail' || requestType == 'Vaccination Detail' || requestType == 'Sibling Detail' || requestType == 'Address Detail' || requestType == 'work Experience' || requestType == 'Extra Curricular Detail') {
            requestType = 'PERSONAL_DATA_CHANGE';
        }
        var form = serviceRequestForm.down('form');
        if (form.down('#hiddenFromSection') != undefined && !isNullOrEmpty(data)) {
            form.down('#hiddenFromSection').setValue(data.detail.fromSectionId);
        }
        var basicDetailPnl = this.getBasicdetails();
        if (!isNullOrEmpty(data.serviceRequestSetting.academyLocation)) {
            if (Ext.isDefined(basicDetailPnl)) {
                basicDetailPnl.config.reqAcademyLocationId = data.serviceRequestSetting.academyLocation.id;
                if (data.serviceRequestSetting.defaultApprover != null) {
                    basicDetailPnl.config.reqApproverId = data.serviceRequestSetting.defaultApprover.id;
                } else {
                    basicDetailPnl.config.reqApproverId = null;
                }
            }
        }
        me.addDetailsForm(data, record, serviceRequestForm);
        this.toggleWithdrawButton(data, record, form);
        if (requestType === 'TRANSFER' || requestType === 'TERMINATION' || requestType === 'DEBARMENT') {
            me.setStudentRequestData(requestType, form, data, record);
        } else {
            var date = form.down('#RequestDate');
            delete date.minValue;
            me.setData(requestType, form, data, record);
            if (form.down('#withdrawDateId')){
            var date1 = form.down('#withdrawDateId');
            delete date1.minValue;
            }
            me.setData(requestType, form, data, record);
        }
        if (requestType === 'PROGRAM_WITHDRAWAL') {
            me.setStudentRequestProgramWithdrawlData(requestType, form, data, record);
        }
        me.toggleReadOnlyFormItems(form.getForm(), true);
        if (record.data.REQUEST_TYPE == "EMPLOYEELEAVE" || record.data.REQUEST_TYPE == "Employee Leave" || record.data.REQUEST_TYPE == "Employee leave") {
            form.down('#leaveSubmitBtn').setVisible(false);
            form.down('#addFilterBtn').setVisible(false);
        } else if (requestType === 'SCHOOL_LEAVING') {
            var reasonForLeavingField = basicDetailPnl.down('#reasonForLeavingItemId');
            var RequestReason = basicDetailPnl.down('#RequestReason');
            var remarkSubmitButton = basicDetailPnl.down('#remarkSubmitButtonId');
            reasonForLeavingField.setReadOnly(false);
            RequestReason.setReadOnly(false);
            if (record.data.SERVICE_REQUEST_STATUS === 'Closed' || record.data.SERVICE_REQUEST_STATUS === 'Completed') {
                remarkSubmitButton.setVisible(true);
            }
            var schoolLeavingSubmitBtn = form.down('#schoolLeavingSubmitBtn');
            if (!isNullOrEmpty(schoolLeavingSubmitBtn)) {
                schoolLeavingSubmitBtn.setVisible(false);
            }
            if ((data.serviceRequestStage == 'INITIATED' && record.data.SERVICE_REQUEST_STATUS != 'Withdrawn') || (data.serviceRequestStage == 'PRECLOSURE' && (record.data.SERVICE_REQUEST_STATUS != 'Approved' && record.data.SERVICE_REQUEST_STATUS != 'Rejected'))) {
                var portalId = me.getCurrentLoggedPortalId();
                if (portalId == 1 || portalId == 2) {
                    var schoolLeavingSaveBtn = form.down('#schoolLeavingSaveBtn');
                    var termEndDate = form.down('#termEndDateItemId');
                    if (!isNullOrEmpty(schoolLeavingSaveBtn)) {
                        schoolLeavingSaveBtn.setVisible(true);
                    }
                    if (!isNullOrEmpty(termEndDate)) {
                        termEndDate.setReadOnly(false);
                    }
                }
            }
        } else if (requestType === 'PROGRAM_TRANSFER') {
            form.down('#programSubmitBtn').setVisible(false);
        } else if (requestType === 'PROGRAM_WITHDRAWAL') {
            form.down('#programWithdrawSubmitBtn').setVisible(false);
        } else if (requestType === 'STUDENT_TRANSFER') {
            var reasonForLeavingField = basicDetailPnl.down('#reasonForLeavingItemId');
            var RequestReason = basicDetailPnl.down('#RequestReason');
            var remarkSubmitButton = basicDetailPnl.down('#remarkSubmitButtonId');
            reasonForLeavingField.setReadOnly(false);
            RequestReason.setReadOnly(false);
            if (record.data.SERVICE_REQUEST_STATUS === 'Closed' || record.data.SERVICE_REQUEST_STATUS === 'Completed') {
                remarkSubmitButton.setVisible(true);
            }
            if (['CANCELLED', 'WITHDRAWN', 'SUBMITTED', 'REJECTED', 'ESCALATED', 'DONE', 'ASSIGNED', 'APPROVED', 'CLOSED', 'COMPLETED','FAILED'].includes(record.data.SERVICE_REQUEST_STATUS.toUpperCase())) {
            	form.down("#studentTransferSubmitBtn").setVisible(false);
            }
        } else {
            if (requestType != 'DEBARMENT') {
                form.down('button').setVisible(false);
            }
            if (requestType == "EXAM_CONCESSION") {
                form.down('#examConcessionBtn').setVisible(false);
            }
        }
        var sbmtBtn = form.down('#submitBtn');
        if (!isNullOrEmpty(sbmtBtn)) {
            sbmtBtn.setVisible(false);
        }
        Ext.getBody().unmask();
    },
    /**
     * This method is used to set response data into Request
     * Form
     *
     * @param requestType
     *
     */
    setData: function (requestType, form, data, record) {
        var me = this;
        var serviceRequestConstants = this.getServiceRequestConstant();
        switch (requestType) {
        case 'CERTIFICATE':
        case 'Certificate':
            {
                var formData = me.createCertificateRequestObject(data, record);
                form.getForm().setValues(formData);
                var instructionBox = form.down('basicdetails').down('#instructionsReqItemId');
                instructionBox.setValue(formData.serviceRequestSetting.instructions);
                var combo = form.down('#certificateCategoryItemId');
                this.loadCertificateType(combo, formData.certificateRequestDetail.certificateCategory);
                form.down('#certificateRequestCertificateTypesId').setValue(formData.serviceRequestSetting.requestType.value);
                if (!isNullOrEmpty(formData.certificateRequestDetail.communityId)) {
                    form.down('#communityCertificateId').setValue(formData.certificateRequestDetail.communityId);
                } else if (!isNullOrEmpty(formData.certificateRequestDetail.courseId)) {
                    form.down('#courseCertificateItemId').setValue(formData.certificateRequestDetail.courseId);
                }
                form.down('#isOriginalRadio').setValue({
                    'isOriginal': formData.isOriginal
                });
                if (!formData.isOriginal) {
                    form.down('#noOfCopies').setValue(formData.certificateRequestDetail.copies);
                }
                me.setPendingDays(form, data);
                break;
            }
        case 'SCHOLARSHIP':
        case 'Scholarship':
            {
                var formData = me.createScholarshipRequestObject(data, record);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'EMPLOYEELEAVE':
        case 'Employee Leave':
        case 'Employeeleave':
            {
                var formData = me.createLeaveRequestObject(data, record);
                form.getForm().setValues(formData);
                var stopContiner = me.getEmployeeleaverequestdetailspanel().down('#leaveContainerId');
                Ext.apply(stopContiner, {
                    code: null,
                    setCode: function (code) {
                        stopContiner.code = code;
                    },
                    getCode: function () {
                        return stopContiner.code;
                    }
                });
                stopContiner.setCode(record.data.REQUEST_TYPE);
                var field = form.getForm().findField('leaveTypeId');
                var requestFromDateId = form.getForm().findField('fromDate');
                var requestToDateId = form.getForm().findField('toDate');
                var submitUrl = SERVERURL.EMPLOYEE_LEAVE_REQUEST_DETAIL_FIND_BY_REQ_ID + "?requestId=" + data.id;
                Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    method: 'GET',
                    success: function (response, action) {
                        var data = Ext.decode(response.responseText);
                        field.getStore().load({
                            callback: function (rec) {
                                for (var j in rec) {
                                    if (!isNullOrEmpty(formData.detail)) {
                                        if (rec[j].data.id == formData.detail.leaveTypeId) {
                                            if (data.length == 1) {
                                                field.setValue(rec[j].data.id);
                                                requestFromDateId.setValue(dateRender(data[0].detail.fromDate));
                                                requestToDateId.setValue(dateRender(data[0].detail.toDate));
                                            }
                                        }
                                    }
                                }
                            }
                        });
                        if (data.length > 1) {
                            me.viewMultipleLeaveType(data.length, data);
                            me.toggleReadOnlyFormItems(form.getForm(), true);
                        }
                    }
                });
                me.setPendingDays(form, data);
                break;
            }
        case 'LEAVE':
        case 'Leave':
            {
                if (form.xtype == "hostelleaverequestdetailspanel") {
                    var formData = me.createLeaveRequestObject(data, record);
                    form.getForm().setValues(formData);
                    var startDate = form.down('#startDate');
                    var enddateItemId = form.down('#enddateItemId');
                    var startTimeItemId = form.down('#startTimeItemId');
                    var toTimeItemId = form.down('#toTimeItemId');
                    var leaveType = form.down('#leaveType');
                    if (!isNullOrEmpty(data.detail.fromDate)) {
                        startDate.setMinValue(false);
                        startDate.setValue(data.detail.fromDate);
                        startDate.clearInvalid();
                    }
                    if (!isNullOrEmpty(data.detail.toDate)) {
                        enddateItemId.setMinValue(false);
                        enddateItemId.setValue(data.detail.toDate);
                    }
                    if (!isNullOrEmpty(data.detail.fromTime)) {
                        startTimeItemId.setValue(timeRender(data.detail.fromTime));
                    }
                    if (!isNullOrEmpty(data.detail.toTime)) {
                        toTimeItemId.setValue(timeRender(data.detail.toTime));
                    }
                    if (!isNullOrEmpty(data.detail.studentLeaveType)) {
                        leaveType.getStore().load({
                            callback: function (record) {
                                for (var i in record) {
                                    if (record[i].data.id == data.detail.studentLeaveType.id) {
                                        leaveType.setValue(data.detail.studentLeaveType.id);
                                    }
                                }
                            }
                        });
                    }
                    me.setPendingDays(form, data);
                } else {
                    var formData = me.createLeaveRequestObject(data, record);
                    form.getForm().setValues(formData);
                    me.setPendingDays(form, data);
                }
                break;
            }
        case 'PERSONAL_DATA_CHANGE':
        case 'Personal Data Change':
            {
                var formData = me.createPersonalDataChangeRequestObject(data, record);
                me.addShowDetailsLink(formData);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'FREE_FORM':
        case 'Free Form':
        case 'GENERAL':
            {
                var formData = me.createFreeFormObject(data, record);
                form.getForm().setValues(formData);
                var instructions = form.down('#instructionsRaiseItemId');
                var offeredModuleCmb = form.down('#offeredModuleId');
                if(!isNullOrEmpty(formData.detail.offeredModule)){
                	
                	if(formData.serviceRequestSetting.isEnrolledModule)
                	{
                		offeredModuleCmb.setFieldLabel(getCommonTranslation('ENROLLED_MODULE'));
                	}
                	else if(formData.serviceRequestSetting.isOfferedModule){
                		offeredModuleCmb.setFieldLabel(getCommonTranslation('OFFERED_MODULE'));
                	}
                	
                	var param={
                		id:formData.detail.offeredModule
                	};
                	me.sendGetAjaxRequest(SERVERURL.BASIC_COURSES_DETAILS, 'GET',param, function (opt, success, response) {
                		if(success)
                		{
                			var data = Ext.decode(response.responseText);
                			offeredModuleCmb.setValue(data.courseCodeName);
                		}
                	});
                	offeredModuleCmb.setVisible(true);
                	me.setAllowBlank(offeredModuleCmb,false);
                	offeredModuleCmb.setReadOnly(true);
                }
                instructions.setValue(formData.serviceRequestSetting.instructions);
                form.down('#subRequestType').setDisabled(false);
                if (typeof isStdDetailReport != "undefined" && isStdDetailReport) {
                    if (record.get("requestCategory") == 'FREE_FORM') {
                        form.down('#freeFormRequestType').setValue('Free Form');
                    }
                    form.down('#subRequestType').setValue(record.get("type"));
                    form.down('#freeFormRequestSubTypeId').setValue(record.get("type"));
                    isStdDetailReport = false;
                }
                me.setPendingDays(form, data);
                break;
            }
        case 'EXAM_CONCESSION':
        case 'EXAM_CONCESSION':
            {
                var formData = me.createExamRelatedObject(data, record);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'PROGRAM_TRANSFER':
        case 'Program Transfer':
            {
                var formData = me.createProgramTransferRequestObject(data, record);
                var date = form.down('#RequestDate');
                date.validationEvent = false;
                form.getForm().setValues(formData);
                var toProgramCombo = form.down('#toProgramId');
                var batchCombo = form.down('#toBatchId');
                var programGroupId = form.down('#programGroupId');
                var toPeriodId = form.down('#toPeriodId');
                var confirmationChecckBox = form.down('#confirmationId');
                var authorizeDeclarationCheckBox = form.down('#authorizeDeclarationId');
                var healthInsuranceCheckBox = form.down('#healthInsuranceCheckId');
                var scholarshipCheckBox = form.down('#scholarshipCheckId');
                var medicalIssuesCheckBox = form.down('#medicalIssuesCheckId');
                var upToDateDetailsCheckBox = form.down('#upToDateDetailsId');
                this.loadBatchComboStore(toProgramCombo, data);
                this.loadSeatTypeComboStore(batchCombo,data);
                me.setPendingDays(form, data);
                confirmationChecckBox.setValue(formData.detail.isConfirmation);
                authorizeDeclarationCheckBox.setValue(formData.detail.isAuthorizeDeclaration);
                healthInsuranceCheckBox.setValue(formData.detail.isHealthInsurance);
                scholarshipCheckBox.setValue(formData.detail.isScholarship);
                medicalIssuesCheckBox.setValue(formData.detail.isMedicalIssues);
                upToDateDetailsCheckBox.setValue(formData.detail.isUpToDateDetails);
                toPeriodId.getStore().getProxy().extraParams = {
                    batchId: formData.toBatchId
                };
                toPeriodId.getStore().load(function () {
                    toPeriodId.setValue(formData.toPeriodId);
                });
                programGroupId.getStore().load(function () {
                    programGroupId.setValue(formData.detail.programGroupId);
                });
                form.down('#leavingReasonsFieldset').removeAll();
                if (formData.detail.programTransferMultipleReason && !formData.detail.programTransferMultipleReason.length) {
                    form.down('#leavingReasonsFieldset').setVisible(false);
                } else {
                    var i = 1;
                    formData.detail.programTransferMultipleReason.forEach(function (rec) {
                        rec.id = rec.programTransferReason.id;
                        me.addLeavingReasonFields(i, form, true, rec);
                        i++;
                    });
                }
                var fromProgramCombo = form.down('#fromProgramId');
                var alIds = Ext.Array.pluck(Academia.utilities.accessControl.AccessControlManager.allocatedAcademyLocations, 'id').join();
                var fromProgramStore = fromProgramCombo.getStore();
                fromProgramStore.getProxy().extraParams = {
                    studentId: this.getContentPanelActiveTab().getRequesterId(),
                    academyLocationIds: alIds
                };
                fromProgramStore.load();
                if (formData.parentsId && formData.requester) {
                    form.down('#studentHyperLink').batchSeat = formData.parentsId.id;
                    form.down('#studentHyperLink').personalId = formData.requester.id;
                }
                break;
            }
        case 'PROGRAM_WITHDRAWAL':
        case 'Program Withdrawal':
        case 'Withdraw From Program':
            {
                var formData = me.createWithdrawProgramRequestObject(data, record);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                var fromProgramCombo = form.down('#fromProgramId');
                var confirmationChecckBox = form.down('#confirmationId');
                var authorizeDeclarationCheckBox = form.down('#authorizeDeclarationId');
                var academicTermField = form.down('#academicTermProgramWithdrwanId');
                confirmationChecckBox.setValue(formData.detail.isConfirmation);
                academicTermField.setValue(formData.detail.academicTermId);
                authorizeDeclarationCheckBox.setValue(formData.detail.isAuthorizeDeclaration);
                me.loadFromProgramComboStore(fromProgramCombo);
                me.loadAcademicTermForProgramWithdrwan(form,formData.detail.academicTermId);
                form.down('#leavingReasonsFieldset').removeAll();
                if (formData.detail.programWithdrawlRequestMultipleReason && !formData.detail.programWithdrawlRequestMultipleReason.length) {
                    form.down('#leavingReasonsFieldset').setVisible(false);
                } else {
                    var i = 1;
                    formData.detail.programWithdrawlRequestMultipleReason.forEach(function (rec) {
                        rec.id = rec.programWithdrawalReason.id;
                        me.addLeavingReasonFields(i, form, true, rec);
                        i++;
                    });
                }
                if (formData.parentsId && formData.requester) {
                    form.down('#studentHyperLink').batchSeat = formData.parentsId.id;
                    form.down('#studentHyperLink').personalId = formData.requester.id;
                }
                break;
            }
        case 'COURSE_TRANSFER':
        case 'Course Transfer':
            {
                var formData = me.createCourseTransferRequestObject(data, record);
                form.getForm().setValues(formData);
                var fromCourseCombo = form.down('#fromCourseId');
                var toCourseCombo = form.down('#toCourseId');
                me.loadFromCourseComboForTrackRequest(fromCourseCombo, formData);
                me.loadToCourseComboForTrack(toCourseCombo, formData.programId);
                me.setPendingDays(form, data);
                break;
            }
        case 'COURSE_WITHDRAWAL':
        case 'Course Withdrawal':
        case 'Withdraw From Course':
            {
                var formData = me.createWithdrawCourseRequestObject(data, record);
                form.getForm().setValues(formData);
                var cousesCombo = form.down('#courseId');
                me.loadWithdrawCourseComboForTrack(cousesCombo, formData.programId);
                me.setPendingDays(form, data);
                break;
            }
        case 'SECTION_TRANSFER':
        case 'Section Transfer':
            {
                me.setDataForSectionTransferRequest(requestType, form, data, record);
                me.setPendingDays(form, data);
                break;
            }
        case 'FEE_RELATED':
        case 'Fee Related':
            {
                var formData = me.createFeeRequestObject(data, record);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'PLACEMENT':
        case 'Placement':
            {
                var formData = me.createApplyForPlacementObject(data, record, form);
                form.down('#periodId').setDisabled(false);
                form.getForm().setValues(formData);
                form.down('#willingToTakePartRadio').setValue({
                    'isWillingForPlacement': data.detail.isWillingForPlacement
                });
                me.setPendingDays(form, data);
                break;
            }
        case 'SERVICE_SUBSCRIBE_WITHDRAW':
        case 'Service Subscribe Withdraw':
            {
                var formData = this.createWithdrawSubscribeServiceRequestObject(data, record);
                form.getForm().setValues(formData);
                this.setServiceWithdrawSubscribeFormValues(form, data, formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'CHANGE_EXAM_DATE':
            {
                var formData = me.createChangeOfExamDateRequestObject(data, record);
                var detailSequenceCmb = form.down('changeofexamdateform').down('commonfieldsform').down('#evaluationDetailedSequenceId');
                detailSequenceCmb.setDisabled(false);
                me.loadAllCombo(form, 'changeofexamdateform', data);
                if (!isNullOrEmpty(data.detail.currentExamDate)) {
                    form.down('#currentDateId').setValue(dateRender(data.detail.currentExamDate));
                }
                if (!isNullOrEmpty(data.detail.currentExamBatch)) {
                    form.down('#currentBatchId').setValue(data.detail.currentExamBatch.value);
                }
                me.loadExpectedBatchCombo(detailSequenceCmb, formData.evaluationSequenceDetailId);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'CHANGE_EXAM_CENTRE':
            {
                var formData = me.createChangeOfExamCenterRequestObject(data, record);
                var detailSequenceCmb = form.down('changeofexamcenterform').down('commonfieldsform').down('#evaluationDetailedSequenceId');
                detailSequenceCmb.setDisabled(false);
                me.loadAllCombo(form, 'changeofexamcenterform', data);
                if (!isNullOrEmpty(data.detail.currentExamCenter.code)) {
                    form.down('#currentExamCenterId').setValue(data.detail.currentExamCenter.code);
                }
                if (!isNullOrEmpty(data.detail.currentExamBatch)) {
                    form.down('#currentBatchId').setValue(data.detail.currentExamBatch.value);
                }
                me.loadExpectedDateCombo(detailSequenceCmb, formData.evaluationSequenceDetailId);
                me.loadExpectedCenterCombo(detailSequenceCmb, formData.evaluationSequenceDetailId);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'EXAM_WITHDRAWAL':
            {
                var formData = me.createWithdrawFromExamRequestObject(data, record);
                var detailSequenceCmb = form.down('withdrawalofexam').down('commonfieldsform').down('#evaluationDetailedSequenceId');
                detailSequenceCmb.setDisabled(false);
                me.loadAllCombo(form, 'withdrawalofexam', data);
                if (!isNullOrEmpty(data.detail.currentExamCenter)) {
                    form.down('#currentExamCenterId').setValue(data.detail.currentExamCenter.value);
                }
                if (!isNullOrEmpty(data.detail.currentExamDate)) {
                    form.down('#currentDateId').setValue(dateRender(data.detail.currentExamDate));
                }
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'LACK_OF_OTHER_CRITERIA':
            {
                var formData = me.createLackOfOtherCriteriaExamRequestObject(data, record);
                form.down('lackofothercriteriaform').down('commonfieldsform').down('#evaluationDetailedSequenceId').setDisabled(false);
                me.loadAllCombo(form, 'lackofothercriteriaform', data);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'EXAM_LEAVE':
            {
                var formData = me.createExamLeaveRequestObject(data, record);
                var detailSequenceCmb = form.down('examleaverequestform').down('commonfieldsform').down('#evaluationDetailedSequenceId');
                detailSequenceCmb.setDisabled(false);
                me.loadAllCombo(form, 'examleaverequestform', data);
                if (!isNullOrEmpty(data.detail.currentExamCenter)) {
                    form.down('#currentExamCenterId').setValue(data.detail.currentExamCenter.value);
                }
                if (!isNullOrEmpty(data.detail.currentExamDate)) {
                    form.down('#currentDateId').setValue(dateRender(data.detail.currentExamDate));
                }
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'LACK_OF_ATTENDANCE':
            {
                var formData = me.createLackOfAttendanceObject(data, record);
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'RE_EXAM':
            {
                var formData = me.createReExamRequestObject(data, record);
                var detailSequenceCmb = form.down('requestforreexaminationform').down('commonfieldsform').down('#evaluationDetailedSequenceId');
                detailSequenceCmb.setDisabled(false);
                me.loadAllCombo(form, 'requestforreexaminationform', data);
                if (!isNullOrEmpty(data.detail.currentExamBatch)) {
                    form.down('#currentBatchId').setValue(data.detail.currentExamBatch.value);
                }
                if (!isNullOrEmpty(data.detail.currentExamDate)) {
                    form.down('#currentDateId').setValue(dateRender(data.detail.currentExamDate));
                }
                form.getForm().setValues(formData);
                me.setPendingDays(form, data);
                break;
            }
        case 'REVALUATION_EXAM_PAPER':
            {
                var formData = me.createRevaluationOfExamPaperObject(data, record);
                me.loadAllCombo(form, 'revaluationofexampaperform', data);
                if (data.detail.whetherQuestionWise === true) {
                    me.loadQuestionsAllCombo(form, data);
                }
                if (data.detail.whetherQuestionWise === true) {
                    form.down('revaluationofexampaperform').down('#questionWiseForm').setDisabled(false);
                    form.down('revaluationofexampaperform').down('#questionWiseForm').setVisible(true);
                }
                form.getForm().setValues(formData);
                form.down('revaluationofexampaperform').down('commonfieldsform').down('#evaluationDetailedSequenceId').setDisabled(false);
                form.down('#isOriginalRadio').setValue({
                    'whetherQuestionWise': data.detail.whetherQuestionWise
                });
                if (!isNullOrEmpty(data.detail.questionNo)) {
                    form.down('#questionNoId').setValue(data.detail.questionNo);
                }
                if (!isNullOrEmpty(data.detail.questionNoPart)) {
                    form.down('#questionNoPartId').setValue(data.detail.questionNoPart);
                }
                if (!isNullOrEmpty(data.detail.questionNoPart1)) {
                    form.down('#questionNoPart1Id').setValue(data.detail.questionNoPart1);
                }
                me.setPendingDays(form, data);
                break;
            }
        case 'STUDENT_TRANSFER':
        case 'Student Transfer':
            {
                var formData = me.createProgramTransferRequestObject(data, record);
                var date = form.down('#RequestDate');
                date.validationEvent = false;
                var studentDetail = this.getCurrentlyLoggedInUserWithPersonId();
                
                form.down('#studentHyperLink').batchSeat = formData.parentsId.id;
                form.down('#studentHyperLink').personalId = formData.requester.id;
                
                form.down('#leavingReasonsFieldset').removeAll();
                if (formData.detail.wsStudentTransferRequestMultipleReason && !formData.detail.wsStudentTransferRequestMultipleReason.length) {
                    form.down('#leavingReasonsFieldset').setVisible(false);
                } else {
                    var i = 1;
                    formData.detail.wsStudentTransferRequestMultipleReason.forEach(function (rec) {
                        rec.id = rec.studentTransferReason.id;
                        me.addLeavingReasonFields(i, form, true, rec);
                        i++;
                    });
                }
                
               
                formData.reasonForLeaving = data.detail.reasonForLeaving;
                form.getForm().setValues(formData);
                var fromProgramCombo = form.down('#fromProgramId');
                var toProgramCombo = form.down('#toProgramId');
                var batchCombo = form.down('#toBatchId');
                var academyLocationCombo = form.down('#toAcademyLocationItemId');
                this.loadFromProgramComboStore(fromProgramCombo);
                this.loadBatchComboStore(toProgramCombo, data);
                this.loadAllPeriodComboStore(batchCombo, data);
                this.loadSeatTypeCombo(batchCombo, data);
                var authorizeDeclarationCheckBox = form.down('#authorizeDeclarationId');
                var confirmationChecckBox = form.down('#confirmationId');
                var healthInsuranceCheckBox = form.down('#healthInsuranceCheckId');
                var scholarshipCheckBox = form.down('#scholarshipCheckId');
                var medicalIssuesCheckBox = form.down('#medicalIssuesCheckId');
                var upToDateDetailsCheckBox = form.down('#upToDateDetailsId');
                var visaRefusalCheck=form.down('#visaRefusalCheck');
                var studiedInUkCheck=form.down('#studiedInUkCheck');
                studiedInUkCheck.setValue(formData.detail.studiedInUk);
                confirmationChecckBox.setValue(formData.detail.isConfirmation);
                healthInsuranceCheckBox.setValue(formData.detail.isHealthInsurance);
                scholarshipCheckBox.setValue(formData.detail.isScholarship);
                medicalIssuesCheckBox.setValue(formData.detail.isMedicalIssues);
                upToDateDetailsCheckBox.setValue(formData.detail.isUpToDateDetails);
                visaRefusalCheck.setValue(formData.detail.visaRefusal);
                studiedInUkCheck.setValue(formData.detail.studiedInUk);
                authorizeDeclarationCheckBox.setValue(formData.detail.isAuthorizeDeclaration);
                this.loadALComboStore(academyLocationCombo, data.detail.toALId, data.detail.toProgramId);
                
                this.loadAcademicTermForStudentTransfer(form, formData.detail.academicTermId);
                
                me.setPendingDays(form, data);
                break;
            }
        case 'SCHOOL_LEAVING':
        case 'School Leaving':
            {
                var formData = me.createSchoolLeavingRequestObject(data, record);
                var basicDetailPnl = this.getBasicdetails();
                var leavingToItemIdField = basicDetailPnl.down('#leavingToItemId');
                var date = form.down('#RequestDate');
                date.validationEvent = false;
                formData.reasonForLeaving = data.detail.reasonForLeaving;
                formData.schoolLeavingTo = data.detail.schoolLeavingTo;
                if (data.detail.leavingTo == 'PRIVATESCHOOL') {
                    leavingToItemIdField.items.items[0].setValue(true);
                    leavingToItemIdField.items.items[1].setValue(false);
                    leavingToItemIdField.items.items[2].setValue(false);
                } else if (data.detail.leavingTo == 'PUBLICSCHOOL') {
                    leavingToItemIdField.items.items[0].setValue(false);
                    leavingToItemIdField.items.items[1].setValue(true);
                    leavingToItemIdField.items.items[2].setValue(false);
                } else {
                    leavingToItemIdField.items.items[0].setValue(false);
                    leavingToItemIdField.items.items[1].setValue(false);
                    leavingToItemIdField.items.items[2].setValue(true);
                }
                form.getForm().setValues(formData);
                var fromProgramCombo = form.down('#fromProgramId');
                var dateOfTransfer = form.down('#dateOfTransferItemId');
                var termEndDate = form.down('#termEndDateItemId');
                var isWaiveNotice = form.down('#isWaiveNoticeId');
                if (!isNullOrEmpty(formData.dateOfTransfer)) {
                    dateOfTransfer.setValue(dateRender(formData.dateOfTransfer));
                }
                if (!isNullOrEmpty(formData.termEndDate)) {
                    termEndDate.setValue(dateRender(formData.termEndDate));
                }
				if (!isNullOrEmpty(formData.isWaiveNotice)) {
					isWaiveNotice.setValue(formData.isWaiveNotice);
				}
                this.loadTermComboStore(fromProgramCombo);
                me.setPendingDays(form, data);
                break;
            }
        case 'HOSTEL_LEAVE':
            {
                var formData = me.createHostelLeaveRequestObject(data, record);
                form.getForm().setValues(formData);
                var startDate = form.down('#startDate');
                var enddateItemId = form.down('#enddateItemId');
                var startTimeItemId = form.down('#startTimeItemId');
                var toTimeItemId = form.down('#toTimeItemId');
                if (!isNullOrEmpty(data.detail.fromDate)) {
                    startDate.setMinValue(false);
                    startDate.setValue(data.detail.fromDate);
                }
                if (!isNullOrEmpty(data.detail.toDate)) {
                    enddateItemId.setMinValue(false);
                    enddateItemId.setValue(data.detail.toDate);
                }
                if (!isNullOrEmpty(data.detail.fromTime)) {
                    startTimeItemId.setValue(data.detail.fromTime);
                }
                if (!isNullOrEmpty(data.detail.toTime)) {
                    toTimeItemId.setValue(data.detail.toTime);
                }
                var remarks = form.down('#RequestReason');
                if (!isNullOrEmpty(data.remarks)) {
                    remarks.setValue(data.remarks);
                }
                var leaveType = form.down('#leaveType');
                if (!isNullOrEmpty(data.detail.studentLeaveType)) {
                    leaveType.getStore().load({
                        callback: function (record) {
                            for (var i in record) {
                                if (record[i].data.id == data.detail.studentLeaveType.id) {
                                    leaveType.setValue(data.detail.studentLeaveType.id);
                                }
                            }
                        }
                    });
                }
                me.setPendingDays(form, data);
                break;
            }
        case 'LEAVE_OF_ABSENCE':
        case 'Leave of Absence':
            {
                var formData = me.createLOARequestObject(data, record);
                form.getForm().setValues(formData);
                var remarks = form.down('#RequestReason');
                var loaRequesterDeclarationSecondCheckBox = form.down('#loaRequesterDeclarationSecondId');
                var startAcademicTermCombo = form.down('#startAcademicTermCombo');
                startAcademicTermCombo.setValue(data.detail.startAcademicTermId);
                loaRequesterDeclarationSecondCheckBox.setValue(formData.detail.isLoaRequesterDeclarationSecond);
                var loaStudentConfirmationCheckBox = form.down('#loaStudentconfirmationId');
                loaStudentConfirmationCheckBox.setValue(formData.detail.isLoaStudentconfirmation);
                if (!isNullOrEmpty(data.remarks)) {
                    remarks.setValue(data.remarks);
                }
                me.setPendingDays(form, data);
                form.down('#leavingReasonsFieldset').removeAll();
                if (formData.detail.leaveOfAbsenceRequestMultipleReason && !formData.detail.leaveOfAbsenceRequestMultipleReason.length) {
                    form.down('#leavingReasonsFieldset').setVisible(false);
                } else {
                    var i = 1;
                    formData.detail.leaveOfAbsenceRequestMultipleReason.forEach(function (rec) {
                        rec.id = rec.leaveOfAbsenceRequestReason.id;
                        me.addLeavingReasonFields(i, form, true, rec);
                        i++;
                    });
                }
                if (formData.parentsId && formData.requester) {
                    form.down('#studentHyperLink').batchSeat = formData.parentsId.id;
                    form.down('#studentHyperLink').personalId = formData.requester.id;
                }
                break;
            }
        case 'EXCHANGE_SEMESTER':
        case 'Exchange Semester':
            {
                var formData = me.createESRequestObject(data, record);
                form.getForm().setValues(formData);
                form.down('#studentHyperLink').batchSeat = formData.parentsId.id;
                form.down('#studentHyperLink').personalId = formData.requester.id;
                var remarks = form.down('#RequestReason');
                var withdrawDate = form.down('#withdrawDateId');
                if (!isNullOrEmpty(data.remarks)) {
                    remarks.setValue(data.remarks);
                }
                if (!isNullOrEmpty(data.detail.withdrawDate)) {
                    withdrawDate.setValue(data.detail.withdrawDate);
                }
                me.setPendingDays(form, data);
                var authorizeDeclarationCheckBox = form.down('#authorizeDeclarationId');
                var confirmationChecckBox = form.down('#confirmationId');
                var healthInsuranceCheckBox = form.down('#healthInsuranceCheckId');
                var scholarshipCheckBox = form.down('#scholarshipCheckId');
                var medicalIssuesCheckBox = form.down('#medicalIssuesCheckId');
                var upToDateDetailsCheckBox = form.down('#upToDateDetailsId');
                var visaRefusalCheck=form.down('#visaRefusalCheck');
                var studiedInUkCheck=form.down('#studiedInUkCheck');
                studiedInUkCheck.setValue(formData.detail.studiedInUk);
                confirmationChecckBox.setValue(formData.detail.isConfirmation);
                healthInsuranceCheckBox.setValue(formData.detail.isHealthInsurance);
                scholarshipCheckBox.setValue(formData.detail.isScholarship);
                medicalIssuesCheckBox.setValue(formData.detail.isMedicalIssues);
                upToDateDetailsCheckBox.setValue(formData.detail.isUpToDateDetails);
                visaRefusalCheck.setValue(formData.detail.visaRefsual);
                studiedInUkCheck.setValue(formData.detail.studiedInUk);
                authorizeDeclarationCheckBox.setValue(formData.detail.isAuthorizeDeclaration);
                
                break;
            }
        case 'READMISSION':
        case 'Readmission Request':
        	{
        	var formData = me.createLOARequestObject(data, record);
        	 var tab = me.getContentPanelActiveTab();
        	 tab.isReadmissionFormFill=true;
        	 me.EditDocumentFormDataNew=false;
            form.getForm().setValues(formData);
        	break;
        	}
        }
    },
    setDataForSectionTransferRequest: function (requestType, form, data, record) {
        var me = this;
        var formData = me.createSectionTransferRequestObject(data, record);
        var tab = me.getContentPanelActiveTab();
        form.getForm().setValues(formData);
        var courseCombo = form.down('#courseId');
        if (data.serviceRequestSetting.serviceRequestCategory === 'FACULTY_REQUEST') {
            this.setDataForFacultySectionTransferRequest(form, data);
        } else {
            form.down('#relatedTransfer').setValue({
                'isTransferRelatedProgram': data.detail.isTransferRelatedProgram
            });
            var programCombo = form.down('#ProgramId');
            programCombo.setValue(data.detail.programId);
            var programStore = programCombo.getStore();
            programStore.load({
                params: {
                    studentId: tab.responseData.requester.id
                },
                callback: function () {
                    me.loadBatchSectionTextFields(programCombo, data);
                }
            });
            if (!data.detail.isTransferRelatedProgram) {
                var courseStore = courseCombo.getStore();
                var batchId = form.down('#hiddenBatchId').getValue();
                var courseVariantId = form.down('#courseVariantId');
                var CVid;
                if (!isNullOrEmpty(data.detail)) {
                    CVid = data.detail.courseVariantId;
                    courseVariantId.setValue(CVid);
                }
                courseStore.load({
                    params: {
                        batchId: batchId,
                        studentId: tab.getRequesterId() ? tab.getRequesterId() : data.requester.id,
                        id: CVid
                    },
                    callback: function (records, opt, success) {
                        if (success) {
                            courseCombo.setValue(data.detail.courseVariantId);
                            me.loadToSectionComboForCourse(courseCombo, records);
                            var toSectionCombo = form.down('#toSectionForCourse');
                            toSectionCombo.setValue(data.detail.toSectionId);
                        }
                    }
                });
            } else {
                var toSectionCombo = form.down('#toSectionId');
                toSectionCombo.setValue(data.detail.toSectionId);
            }
        }
    },
    setDataForFacultySectionTransferRequest: function (form, data) {
        var courseCombo = form.down('#courseId');
        courseCombo.setValue(data.detail.courseVariantId);
        var toSectionCombo = form.down('#toSectionForCourse');
        toSectionCombo.reset();
        this.loadCourseForFaculty(courseCombo, data.requester.id);
        var requsterType = data.serviceRequestSetting.serviceRequestCategory;
        this.loadToSectionComboForCourse(courseCombo, null, requsterType);
        toSectionCombo.setValue(data.detail.toSectionId);
    },
    /**
     * This is used to set Pending days & request Date on sevice
     * Request Panel
     *
     * @param form
     * @param data
     */
    setPendingDays: function (form, formData) {
        var pendingTpl = form.down('#pendingDaysMessageField');
        var requestDate = new Date(formData.requestDate);
        var one_day = 1000 * 60 * 60 * 24;
        var today = new Date((new Date()).setHours(0, 0, 0, 0));
        var days = Math.round((today.getTime() - requestDate.getTime()) / one_day);
        var serviceRequestConstants = this.getServiceRequestConstant();
        var status = null;
        var message = null;
        var requestStatusCode = null;
        if (formData.requestStatusId === serviceRequestConstants.getRequestStatus('REQUEST_STATUS_CLOSED')) {
            status = getServiceRequestTranslation('Y');
            message = "<div class='thumb-wrap1'>" + "<span style='font-weight:bold; color:blue;font-size : 110%;'> <p> " +
                getServiceRequestTranslation('REQUESTID') + " " + formData.requestId +
                "&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;" +
                "<mark>" + getServiceRequestTranslation('EXECUTION_STATUS') + "</mark>" + "&nbsp;" +
                "<span style=color:green;'font-weight:bold;><u>" + status + " </u></span></span></p></div>";
        } else if (formData.requestStatusId === serviceRequestConstants.getRequestStatus('REQUEST_STATUS_REJECTED')) {
            status = getServiceRequestTranslation('SERVICE_REQUEST_REJECTED');
            message = "<div class='thumb-wrap1'>" + "<span style='font-weight:bold; color:blue;font-size : 110%;'> <p> " +
                getServiceRequestTranslation('REQUESTID') + " " + formData.requestId +
                "&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;" +
                "<mark>" + getServiceRequestTranslation('EXECUTION_STATUS') + "</mark>" + "&nbsp;" + "<span style=color:red;'font-weight:bold;><u>" +
                status + " </u></span></span></p></div>";
        } else if (formData.requestStatusId === serviceRequestConstants.getRequestStatus('REQUEST_STATUS_WITHDRAWN')) {
            status = getServiceRequestTranslation('SERVICE_REQUEST_WITHDRAWN');
            message = "<div class='thumb-wrap1'>" + "<span style='font-weight:bold; color:blue;font-size : 110%;'> <p> " +
                getServiceRequestTranslation('REQUESTID') + " " + formData.requestId +
                "&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;" +
                "<mark>" + getServiceRequestTranslation('EXECUTION_STATUS') + "</mark>" + "&nbsp;" + "<span style=color:red;'font-weight:bold;><u>" +
                status + " </u></span></span></p></div>";
        } else {
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.COMPLETE_REQUEST,
                method: 'GET',
                async: false,
                params: {
                    serviceRequestId: formData.requestStatusId
                },
                success: function (response, action) {
                    var resp = Ext.JSON.decode(response.responseText);
                    requestStatusCode = resp.code;
                }
            });
            if (requestStatusCode == "COMPLETED" || requestStatusCode == "Completed") {
                status = getServiceRequestTranslation('Y');
                 message = "<div class='thumb-wrap1'>" + "<span style='font-weight:bold; color:blue;font-size : 110%;'> <p> " +
                     getServiceRequestTranslation('REQUESTID') + " " + formData.requestId +
                     "&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;" +
                     "<mark>" + getServiceRequestTranslation('EXECUTION_STATUS') + "</mark>" + "&nbsp;" +
                     "<span style=color:green;'font-weight:bold;><u>" + status + " </u></span></span></p></div>";
            } else {
                status = getServiceRequestTranslation('N');
                 message = "<div class='thumb-wrap1'>" + "<span style='font-weight:bold; color:blue;font-size:110%;'> <p> " +
                     getServiceRequestTranslation('REQUESTID') + " " + formData.requestId + " </span></p>" +
                     "<span style='font-weight:bold; color:red;'> <p>" + getServiceRequestTranslation('THIS_REQUEST_PENDING') + " " + days + " " +
                     getServiceRequestTranslation('DAYS') + " " + "" +
                     "&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;" +
                     "<mark>" + getServiceRequestTranslation('EXECUTION_STATUS') + "</mark>" + "&nbsp;" + "<u>" + status + " </u></span></p></div>";
            }
        }
        pendingTpl.setVisible(true);
        pendingTpl.setValue(message);
    },
    /**
     * This is used to load Assessment Scheme , evaluation
     * detailed sequence & course combo of Exam service request
     *
     * @param form
     *            which is service reuest panel
     * @param xtype
     *            alias of form
     * @param data
     *            which contains student details
     */
    loadAllCombo: function (form, xtype, data) {
        var evalPlanStore = form.down(xtype).down('commonfieldsform').down('#evaluationPlan').getStore();
        var evalDetailedStore = form.down(xtype).down('commonfieldsform').down('#evaluationDetailedSequenceId').getStore();
        var courseStore = form.down(xtype).down('commonfieldsform').down('#course').getStore();
        evalPlanStore.load({
            callback: function (records, operation, success) {
                evalDetailedStore.load({
                    params: {
                        evalPlanId: data.detail.evaluationPlanId
                    },
                    callback: function (records, operation, success) {
                        courseStore.load({
                            params: {
                                evalSeqDetailId: data.detail.evaluationSequenceDetailId
                            }
                        });
                    }
                });
            }
        });
    },
    /**
     * This is used to load question no , question Part,
     * question Part1 combo of Exam service request
     *
     * @param form
     *            which is service reuest panel
     * @param xtype
     *            alias of form
     * @param data
     *            which contains student details
     */
    loadQuestionsAllCombo: function (form, data) {
        var questionCodeStore = form.down('#questionPaperCodeId').getStore();
        var questionNoStore = form.down('#questionNoId').getStore();
        var questionPartStore = form.down('#questionNoPartId').getStore();
        var questionSubPartStore = form.down('#questionNoPart1Id').getStore();
        var questionGridStore = form.down('#revaluationgridId').getStore();
        questionCodeStore.load({
            params: {
                evalSeqDetailId: data.detail.evaluationSequenceDetailId
            },
            callback: function (records, operation, success) {
                questionNoStore.load({
                    params: {
                        questionPaperId: data.detail.questionPaperId
                    },
                    callback: function (records, operation, success) {
                        questionPartStore.load({
                            params: {
                                questionPaperId: data.detail.questionPaperId,
                                questionId: data.detail.questionId
                            },
                            callback: function (records, operation, success) {
                                questionSubPartStore.load({
                                    params: {
                                        questionPaperId: data.detail.questionPaperId,
                                        questionId: data.detail.questionId,
                                        questionPartId: data.detail.questionPartId
                                    },
                                    callback: function (records, operation, success) {
                                        questionGridStore.load({
                                            params: {
                                                questionPaperId: data.detail.questionPaperId,
                                                questionId: data.detail.questionId,
                                                questionPartId: data.detail.questionPartId,
                                                question1PartId: data.detail.question1PartId
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    },
    setServiceWithdrawSubscribeFormValues: function (form, data, formData) {
        var optedCombo = form.down('#servicesOpted');
        var withdrawCombo = form.down('#servicesToWithdraw');
        var alreadySubscribedServicesCombo = form.down('#alreadySubscribedServices');
        form.getForm().findField('validFromDate').setValue(dateRender(formData.detail.validFromDate));
        alreadySubscribedServicesCombo.setVisible(false);
        form.down('#whetherSubscribed').setValue({
            'whetherSubscribed': data.detail.whetherSubscribed
        });
        if (!isEmpty(data.detail.subscribedServices)) {
            optedCombo = form.down('#servicesOpted');
            optedCombo.getStore().loadData(data.detail.subscribedServices);
            optedCombo.setValue(formData.subscribedServices);
            optedCombo.setVisible(true);
            withdrawCombo.setVisible(false);
        } else {
            optedCombo = form.down('#servicesToWithdraw');
            optedCombo.getStore().loadData(data.detail.withdrawnServices);
            optedCombo.setValue(formData.withdrawnServices);
            optedCombo.setVisible(false);
            withdrawCombo.setVisible(true);
        }
    },
    /**
     * This method is use to hide and show withdraw button on
     * basic details form
     *
     * @param data
     *            response data
     * @param record
     *            record selected from grid
     * @param form
     *            request form
     */
    toggleWithdrawButton: function (data, record, form) {
        var withdrawButton = form.down('#withdrawButtonId');
        var serviceRequestConstants = this.getServiceRequestConstant();
        if (data.serviceRequestStage !== 'CLOSURE' && data.serviceRequestStage !== "CLOSED" && !(data.serviceRequestStage === "PRECLOSURE" && data.requestStatusId === serviceRequestConstants.getRequestStatus('REQUEST_STATUS_REJECTED'))) {
            var loggedInUser = this.getCurrentlyLoggedInUser();
            if (data.enteredBy.id === loggedInUser.id && !data.isWithdrawn) {
                withdrawButton.setVisible(true);
            }
        }
    },
    /**
     * This method is use to hide and show follow up button
     * according to logged in user id.
     */
    toggleSubmitButtonOnFollowUpForm: function (data, requestType) {
        var tab = this.getContentPanelActiveTab();
        var button = null;
        var editDocumentButton = null;
        if (requestType === 'COMPLAINT' || requestType === 'Complaint' || requestType ==='Grievance') {
            button = tab.down('complaintfollowupdetailspanel').down('#ComplaintfollowUpBtn');
        } else {
            if (!isNullOrEmpty(tab.down('followupdetailspanel'))) {
                button = tab.down('followupdetailspanel').down('#followUpBtn');
            }
            var docPanel = tab.down('servicerequestdocumentspanel');
            if (!isNullOrEmpty(docPanel)) {
                var mandatoryDocsGrid = docPanel.down('servicerequestmandatorydocuments');
                var voluntaryDocsGrid = docPanel.down('servicerequestvoluntarydocuments');
                if (!isNullOrEmpty(mandatoryDocsGrid)) {
                    var uploadButton = mandatoryDocsGrid.down('#btnUploadDocument');
                    var downloadBtn = mandatoryDocsGrid.down('#btnDownloadDocument');
                    var btnDelete = mandatoryDocsGrid.down('#btnDelete');
                    editDocumentButton = mandatoryDocsGrid.down('#btnEdit');
                    uploadButton.setVisible(false);
                    downloadBtn.setVisible(true);
                    btnDelete.setVisible(false);
                    editDocumentButton.setVisible(true);
                }
                if (!isNullOrEmpty(voluntaryDocsGrid)) {
                    var uploadButton = voluntaryDocsGrid.down('#btnAdd');
                    uploadButton.setVisible(false);
                    var deleteButton = voluntaryDocsGrid.down('#btnDelete');
                    deleteButton.setVisible(false);
                }
            }
        }
        if (data.serviceRequestStage === 'INPROGRESS' || data.serviceRequestStage === 'INITIATED') {
            var loggedInUser = this.getCurrentlyLoggedInUser();
            if (isEmpty(data.followupDetails)) {
                if (loggedInUser.id !== data.assigneeId || data.isWithdrawn) {
                    if (!isNullOrEmpty(button) && loggedInUser.id != 1) {
                        button.setVisible(false);
                    }
                    if (data.isWithdrawn) {
                        button.setVisible(false);
                    }
                }
            } else {
                Ext.each(data.followupDetails, function (detail) {
                    if (detail.whetherLatest) {
                        if (loggedInUser.id !== detail.assignee.id || data.isWithdrawn) {
                            if (!isNullOrEmpty(button) && loggedInUser.id != 1) {
                                button.setVisible(false);
                            }
                            if (data.isWithdrawn) {
                                button.setVisible(false);
                            }
                        }
                    }
                });
            }
        } else {
            if (!isNullOrEmpty(button)) {
                button.setVisible(false);
            }
        }
    },
    /**
     * add show details link and set stack holder details
     */
    addShowDetailsLink: function (data) {
        var me = this;
        var serviceRequestForm = me.getContentPanelActiveTab();
        var dataToBeChangedField = serviceRequestForm.down('#dataToBeChangedField');
        if (data.dataTobeChanged.code == 'SHR') {
            var stakeHolderTypeCombo = serviceRequestForm.down('#stakeHolderTypeId');
            stakeHolderTypeCombo.setVisible(true);
            var stakeHolderType = data.detail.dataToBeChanged.relationship;
            data.stakeHolderType = stakeHolderType;
        }
        dataToBeChangedField.add({
            xtype: 'label',
            name: 'showDetailsLink',
            html: '<a href="#">Show Details</a>',
            itemId: 'showDetailsLink',
            style: {
                marginTop: '30px'
            }
        });
    },
    /**
     * This method is used to create object
     *
     * @param datawhich is service request response from server
     * @param recordwhich is selected record from grid
     * @return object which contains common data to be set into form
     */
    createObject: function (data, record) {
        var requestAssignedTo = '';
        if (!isNullOrEmpty(record.get("REQUEST_ASSIGNED_TO"))) {
            requestAssignedTo = record.get("REQUEST_ASSIGNED_TO");
        } else {
            requestAssignedTo = 'Auto';
        }
        if (!isNullOrEmpty(record.get("LAST_NAME"))) {
            requestAssignedTo.concat(' ');
            requestAssignedTo.concat(record.get("LAST_NAME"));
        }
        data.requestAssignedTo = requestAssignedTo;
        if (isNullOrEmpty(data.requestAssignedTo)) {
            if (data.serviceRequestSetting != null)
        		  if(!isNullOrEmpty(data.serviceRequestSetting.defaultAssignee))
        	       data.requestAssignedTo = data.serviceRequestSetting.defaultAssignee.value;
        }
        return data;
    },
    /**
     * This method is used to create certificate Track Request
     * Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createCertificateRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.certificateCategory = data.certificateRequestDetail.certificateCategory;
        formData.certificateTypes = record.get("SUBREQUEST_TYPE");
        formData.isOriginal = data.certificateRequestDetail.isOriginal;
        return formData;
    },
    /**
     * This method is used to create Free Form Track Request
     * Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createFreeFormObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.freeFormRequestCategoryId = record.get("REQUEST_CATEGORY");
        if (record.get("REQUEST_CATEGORY") == "FREE_FORM") {
            formData.freeFormRequestCategoryId = "Free Form";
        }
        if (undefined != record.get("SR_REQUEST_TYPE") && !isNullOrEmpty(record.get("SR_REQUEST_TYPE"))) {
            formData.freeFormRequestTypeId = record.get("SR_REQUEST_TYPE");
        } else {
            formData.freeFormRequestTypeId = record.get("REQUEST_TYPE");
        }
        formData.freeFormRequestSubTypeId = record.get("REQUEST_SUB_TYPE");
        if (portalId == 2) {
            var requestType;
            if (undefined != record.get("REQUEST_CATEGORY") && !isNullOrEmpty(record.get("REQUEST_CATEGORY"))) {
                requestType = record.get("REQUEST_CATEGORY");
            } else if (undefined != record.get("SERVICE_REQUEST_TYPE") && !isNullOrEmpty(record.get("SERVICE_REQUEST_TYPE"))) {
                requestType = record.get("SERVICE_REQUEST_TYPE");
            }
            if (undefined != record.get("SUB_REQUEST_TYPE") && !isNullOrEmpty(record.get("SUB_REQUEST_TYPE"))) {
                formData.freeFormRequestSubTypeId = record.get("SUB_REQUEST_TYPE");
            }
            if (requestType == "FREE_FORM") {
                requestType = "Free Form";
            }
            formData.freeFormRequestCategoryId = requestType;
            if (undefined != record.get("SRS_REQUEST_TYPE") && !isNullOrEmpty(record.get("SRS_REQUEST_TYPE"))) {
                formData.freeFormRequestTypeId = record.get("SRS_REQUEST_TYPE");
            }
        }
        return formData;
    },
    createExamRelatedObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.freeFormRequestCategoryId = record.get("REQUEST_CATEGORY");
        formData.freeFormRequestTypeId = record.get("REQUEST_TYPE");
        if (portalId == 2) {
            var requestType = record.get("REQUEST_TYPE");
            if (requestType == "FREE_FORM") {
                requestType = "Free Form";
            }
            formData.freeFormRequestCategoryId = requestType;
            formData.freeFormRequestTypeId = record.get("SRS_REQUEST_TYPE");
        }
        return formData;
    },

    /**
     * This method is used to create Scholarship Track Request
     * Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createScholarshipRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.scholarshipId = data.detail.scholarshipId;
        formData.scholarshipAmount = data.detail.scholarshipAmount;
        return formData;
    },
    /**
     * This method is used to create Leave Track Request Object
     * to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createLeaveRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        if (!isNullOrEmpty(data.detail)) {
            formData.fromDate = data.detail.fromDate;
            formData.toDate = data.detail.toDate;
            if (data.detail.leaveTypeId != undefined) {
                formData.detail.leaveTypeId = data.detail.leaveTypeId;
            }
        }
        return formData;
    },
    /**
     * This method is used to create Personal Data change Track
     * Request Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createPersonalDataChangeRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        var requestType = data.serviceRequestSetting.requestType;
        data.dataTobeChanged = requestType;
        return data;
    },
    /**
     * This method is used to create Program Transfer Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createProgramTransferRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.fromProgramId = data.detail.fromProgramId;
        formData.toProgramId = data.detail.toProgramId;
        formData.toBatchId = data.detail.toBatchId;
        formData.toSeatTypeId = data.detail.toSeatTypeId;
        formData.toPeriodId = data.detail.toPeriodId;
        return formData;
    },
    /**
     * This method is used to create School Leaving Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createSchoolLeavingRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.fromProgramId = data.detail.programId;
        formData.dateOfTransfer = data.detail.dateOfTransfer;
        formData.noticeTermId = data.detail.noticeTermId;
        formData.termEndDate = data.detail.termEndDate;
		formData.isWaiveNotice=data.detail.isWaiveNotice;
        return formData;
    },
    /**
     * This method is used to create withdraw Program Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createWithdrawProgramRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.programIds = data.detail.programIds;
        formData.withdrawDate = data.detail.withdrawDate;
        return formData;
    },
    /**
     * This method is used to create Program Transfer Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createCourseTransferRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.programId = data.detail.programId;
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.fromCourseId = data.detail.fromCourseId;
        formData.toCourseId = data.detail.toCourseId;
        return formData;
    },
    createWithdrawCourseRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.programId = data.detail.programId;
        formData.coursesId = data.detail.coursesId;
        return formData;
    },
    /**
     * This method is used to create Fee Track Request Object to
     * set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createFeeRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.certificateCategory = record.get("REQUEST_TYPE");
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        return formData;
    },
    /**
     * This method is used to create exam request common fields
     * JSON Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createExamRequestCommonJsonObject: function (data, record) {
        data.requestAssignedTo = record.get("REQUEST_ASSIGNED_TO") + '' + record.get("LAST_NAME");
        data.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        data.evaluationPlanId = data.detail.evaluationPlanId;
        data.evaluationSequenceDetailId = data.detail.evaluationSequenceDetailId;
        data.courseId = data.detail.courseId;
    },
    /**
     * This method is used to create Change Of Exam Date Track
     * Request Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createChangeOfExamDateRequestObject: function (data, record) {
        var me = this;
        me.createExamRequestCommonJsonObject(data, record);
        data.expectedDate = data.detail.expectedDate;
        data.expectedExamBatchId = data.detail.expectedExamBatchId;
        data.changeOfDateReason = data.detail.changeOfDateReason;
        return data;
    },
    /**
     * This method is used to create Change Of Exam Center Track
     * Request Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createChangeOfExamCenterRequestObject: function (data, record) {
        var me = this;
        me.createExamRequestCommonJsonObject(data, record);
        data.expectedDate = data.detail.expectedDate;
        data.expectedExamCentreId = data.detail.expectedExamCentreId;
        data.centerType = data.detail.centerType;
        data.changeOfExamCenterReason = data.detail.changeOfExamCenterReason;
        return data;
    },
    /**
     * This method is used to create Withdraw from Exam Track
     * Request Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createWithdrawFromExamRequestObject: function (data, record) {
        var me = this;
        me.createExamRequestCommonJsonObject(data, record);
        data.examWithdrawalReason = data.detail.examWithdrawalReason;
        return data;
    },
    /**
     * This method is used to create Lack Of Other criteria
     * Track Request Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createLackOfOtherCriteriaExamRequestObject: function (data, record) {
        var me = this;
        me.createExamRequestCommonJsonObject(data, record);
        data.approvalSoughtFor = data.detail.approvalSoughtFor;
        data.lackOfCriteriaReason = data.detail.lackOfCriteriaReason;
        return data;
    },
    /**
     * This method is used to create Exam leave Track Request
     * Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createExamLeaveRequestObject: function (data, record) {
        var me = this;
        me.createExamRequestCommonJsonObject(data, record);
        data.examLeaveReason = data.detail.examLeaveReason;
        return data;
    },
    /**
     * This method is used to create Re-Exam Track Request
     * Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createReExamRequestObject: function (data, record) {
        var me = this;
        me.createExamRequestCommonJsonObject(data, record);
        data.approvalRequiredReason = data.detail.approvalRequiredReason;
        return data;
    },
    /**
     * This method is used to create Revaluation of Exam Paper
     * Track Request Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createRevaluationOfExamPaperObject: function (data, record) {
        var me = this;
        me.createExamRequestCommonJsonObject(data, record);
        data.questionPaperId = data.detail.questionPaperId;
        data.totalMarks = data.detail.totalMarks;
        data.whetherQuestionWise = data.detail.whetherQuestionWise;
        return data;
    },
    /**
     * This method is used to create Lack Of Attendance of Exam
     * Paper Track Request Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createLackOfAttendanceObject: function(data, record) {
        data.requestAssignedTo = record.get("REQUEST_ASSIGNED_TO") + '' + record.get("LAST_NAME");
        data.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        data.lessAttendanceReason = data.detail.lessAttendanceReason;
        return data;
    },
    /**
     * This method is used to create Subscibe request Track
     * Request Object to set form data
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createWithdrawSubscribeServiceRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        var subscribedServices = data.detail.subscribedServices;
        if (!isEmpty(subscribedServices)) {
            Ext.each(subscribedServices, function (service) {
                subscribedServices.push(service.id);
            });
            formData.subscribedServices = subscribedServices;
        }
        var withdrawnServices = data.detail.withdrawnServices;
        if (!isEmpty(withdrawnServices)) {
            Ext.each(withdrawnServices, function (service) {
                withdrawnServices.push(service.id);
            });
            formData.withdrawnServices = withdrawnServices;
        }
        formData.validFromDate = data.detail.validFromDate;
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        return formData;
    },
    /**
     * This method is used to create Apply for Placement Track
     * Request Object to set form data
     *
     * @param datawhich is service request response from server
     * @param record which is selected record from grid
     * @return object which contains all data to be set onto form
     */
    createApplyForPlacementObject: function (data, record, form) {
        data.requestAssignedTo = record.get("REQUEST_ASSIGNED_TO") + '' + record.get("LAST_NAME");
        data.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        data.placementPeriodId = data.detail.placementPeriodId;
        form.down('#programId').setValue(data.detail.program.value);
        return data;
    },
    createHostelLeaveRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        return formData;
    },
    createLOARequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        return formData;
    },
    createESRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        return formData;
    },
    
    /**
     * This method is used to add follow up details ,approval
     * details & execution details as per status of service
     * request
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @param form which is requester details form reference
     */
    addDetailsForm: function(data, record, form) {
        var stage = record.data.SERVICE_REQUEST_STAGE;
        var serviceRequestType = record.data.SERVICE_REQUEST_TYPE;
        var serviceRequestConstants = this.getServiceRequestConstant();
        if (serviceRequestType != 'FEE_RELATED') {
            this.addDocumentPanel(form, true);
            if (form.down('servicerequestdocumentspanel')) {
                var button = form.down('servicerequestdocumentspanel').down('#btnSaveRequestWithDocuments');
                button.setVisible(false);
            }
        }
        if (serviceRequestType == "EXAM_CONCESSION") {
            this.addRequestActionDetailsPanel(form, true);
        }
        if (data.serviceRequestSetting.isFeeApplicable) {
            var requestStatusId = serviceRequestConstants.getRequestStatus('REQUEST_STATUS_APPROVED');
            var closeRequestStatusId = serviceRequestConstants.getRequestStatus('REQUEST_STATUS_CLOSED');
            if (data.serviceRequestSetting.billingPreference === 'REQUEST_APPROVAL' && data.requestStatusId === requestStatusId) {
                this.addBillDetailsGrid(form, data);
            } else if (data.serviceRequestSetting.billingPreference === 'REQUEST_APPROVAL' && data.requestStatusId === closeRequestStatusId) {
                this.addBillDetailsGrid(form, data);
            } else if (data.serviceRequestSetting.billingPreference === 'REQUEST_SUBMISSION') {
                this.addBillDetailsGrid(form, data);
            }
        }
        if (stage === 'INPROGRESS' || stage === 'INITIATED') {
            this.addFollowUpDetailPanel(form, record, data);
        } else if (stage === 'PRECLOSURE') {
            this.addFollowUpDetailPanel(form, record, data);
            this.addApprovalDetailsPanel(data, form, record, false);
        } else if (stage === 'CLOSURE') {
            this.addExecutionDetailsPanel(data, form, record, false);
        } else if (stage === 'CLOSED') {
            this.addExecutionDetailsPanel(data, form, record, true);
        }
        if (serviceRequestType == 'PERSONAL_DATA_CHANGE') {
        	if (!isNullOrEmpty(data.detail.dataToBeChanged) && !isNullOrEmpty(data.detail.dataToBeChanged.id)) {
                form.down('#dataToBeChangedId').setValue(data.detail.dataToBeChanged.id);
            }
        }
    },
    /**
     * This method is use to add fees panel into the main
     * service request panel
     */
    addBillDetailsGrid: function (form, data) {
        var feePanel = form.down('servicerequestfeespanel');
        if (isNullOrEmpty(feePanel)) {
            form.add({
                xtype: 'servicerequestfeespanel'
            });
        }
        if (data.isWithdrawn) {
            var refundGrid = form.down('refunddetailsgrid');
            refundGrid.setVisible(true);
        }
    },
    /**
     * This method is used to add complaint follow up details &
     * execution details as per status of service request
     *
     * @param data which is service request response from server
     * @param record which is selected record from grid
     * @param form which is requester details form reference
     */
    addComplaintDetailsForm: function (data, record, form) {
        var stage = record.data.SERVICE_REQUEST_STAGE;
        if (stage === 'INPROGRESS' || stage === 'INITIATED') {
            this.addFollowUpDetailPanel(form, record, data);
        } else if (stage === 'PRECLOSURE') {
            this.addFollowUpDetailPanel(form, record, data);
            this.addComplaintExecutionDetailsPanel(data, form, record, false);
        } else if (stage === 'CLOSED') {
            this.addFollowUpDetailPanel(form, record, data);
            this.addComplaintExecutionDetailsPanel(data, form, record, true);
        }
    },
    /**
     * This is used to add Execution Detail form in complaint
     */
    addComplaintExecutionDetailsPanel: function (data, form, record, isClosed) {
        var me = this;
        var requestType = record.get('REQUEST_TYPE');
        var complaintForm = form.down('executiondetailspanel');
        if (isNullOrEmpty(complaintForm)) {
            form.add({
                xtype: 'executiondetailspanel'
            });
        }
        form.down('executiondetailspanel').down('#requestType').setValue(requestType);
        var executeForm = form.down('executiondetailspanel');
        this.setUserForExecution(executeForm, data, true);
        if (isClosed) {
            var executionDetail = data.executionDetail;
            this.loadApprovalDetailsForm(executeForm, executionDetail);
        } else {
            var loggedInUserId = this.getCurrentlyLoggedInUser().id;
            Ext.each(data, function (detail) {
                if (loggedInUserId === detail.complaintTypeSetting.defaultAssignee.id) {
                    executeForm.down('#executionSubmitBtn').setVisible(false);
                }
                if (!isNullOrEmpty(detail.complaintTypeSetting.defaultApprover)) {
                    if (loggedInUserId === detail.complaintTypeSetting.defaultApprover.id || loggedInUserId == 1) {
                        executeForm.down('#executionSubmitBtn').setVisible(true);
                        executeForm.down('#user').setValue(me.getCurrentlyLoggedInUser().value);
                    }
                    if (isNullOrEmpty(detail.complaintTypeSetting.defaultApprover)) {
                        if (loggedInUserId === detail.complaintTypeSetting.defaultAssignee.id) {
                            executeForm.down('#executionSubmitBtn').setVisible(true);
                            executeForm.down('#user').setValue(me.getCurrentlyLoggedInUser().value);
                        }
                    }
                }
            });
        }
        if ((requestType == 'COMPLAINT' || requestType =='Grievance') && !isNullOrEmpty(form.down('executiondetailspanel').down('#admissionDateId'))) {
            form.down('executiondetailspanel').down('#admissionDateId').setVisible(false);
            this.setAllowBlank(form.down('executiondetailspanel').down('#admissionDateId'), true);
        }
    },
    /**
     * This method is use to add execution details panel
     */
    addExecutionDetailsPanel: function (data, form, record, isClosed) {
        this.addFollowUpDetailPanel(form, record, data);
        this.addApprovalDetailsPanel(data, form, record, true);
        if (form.down('approvaldetailspanel')) {
            var approvalRemark = form.down('approvaldetailspanel').down('#approvalRemarks');
            approvalRemark.setDisabled(true);
            approvalRemark.setVisible(false);
        }
        var requestType = record.get('SERVICE_REQUEST_TYPE');
        if (requestType === 'CERTIFICATE' || requestType === 'Certificate') {
            var certForm = form.down('certificateexecutiondetailspanel');
            if (isNullOrEmpty(certForm)) {
                form.add({
                    xtype: 'certificateexecutiondetailspanel'
                });
                certForm = form.down('certificateexecutiondetailspanel');
                this.setUserForExecution(certForm, data, true);
            }
        } else if (requestType === 'STUDENT_TRANSFER') {
            var certForm = form.down('studenttransferexecutiondetailspanel');
            if (isNullOrEmpty(certForm)) {
                form.add({
                    xtype: 'studenttransferexecutiondetailspanel'
                });
                certForm = form.down('studenttransferexecutiondetailspanel');
                this.setUserForExecution(certForm, data, true);
            }
        } else if (requestType === 'SCHOOL_LEAVING') {
            var certForm = form.down('schoolleavingexecutiondetailspanel');
            if (isNullOrEmpty(certForm)) {
                form.add({
                    xtype: 'schoolleavingexecutiondetailspanel'
                });
                certForm = form.down('schoolleavingexecutiondetailspanel');
                this.setUserForExecution(certForm, data, true);
                effectiveTransferDate = certForm.down('#effectiveTransferDateId');
                if (!isNullOrEmpty(data.detail.dateOfTransfer)) {
                    effectiveTransferDate.setValue(dateRender(data.detail.dateOfTransfer));
                }
            }
        } else if (requestType === 'LEAVE' && !isNullOrEmpty(form.config.requestTypeCode) && form.config.requestTypeCode == "LR") {
            var certForm = form.down('certificateexecutiondetailspanel');
            if (isNullOrEmpty(certForm)) {
                form.add({
                    xtype: 'certificateexecutiondetailspanel'
                });
                certForm = form.down('certificateexecutiondetailspanel');
                this.setUserForExecution(certForm, data, true);
            }
        } else if (requestType === 'HOSTEL_LEAVE') {
            var certForm = form.down('certificateexecutiondetailspanel');
            if (isNullOrEmpty(certForm)) {
                form.add({
                    xtype: 'certificateexecutiondetailspanel'
                });
                certForm = form.down('certificateexecutiondetailspanel');
                this.setUserForExecution(certForm, data, true);
            }
        } else {
            var executionPanel = form.down('executiondetailspanel');
            var portalId = this.getCurrentLoggedPortalId();
            var executionDetail = data.executionDetail;
            if ((isNullOrEmpty(executionPanel) && portalId!=3 && portalId!=7) || 
            		(isNullOrEmpty(executionPanel) && !isNullOrEmpty(executionDetail) && (portalId==3 || portalId==7))) {
                form.add({
                    xtype: 'executiondetailspanel'
                });
                form.down('executiondetailspanel').down('#requestType').setValue(requestType);
                if (!isNullOrEmpty(requestType) && !isNullOrEmpty(form.down('executiondetailspanel').down('#admissionDateId'))) {
                    if (requestType == 'PROGRAM_TRANSFER') {
                        var requesterdetailspanel = form.down('requesterdetailspanel');
                        if (!isNullOrEmpty(requesterdetailspanel)) {
                            var admissionDateField = requesterdetailspanel.down('#admissionDateDisplay');
                            if (!isNullOrEmpty(admissionDateField)) {
                                var admissionDate = admissionDateField.getValue();
                            }
                            if (!isNullOrEmpty(admissionDate)) {
                                form.down('executiondetailspanel').down('#admissionDateId').setValue(admissionDate);
                                form.down('executiondetailspanel').down('#admissionDateId').setMinValue(admissionDate);
                            }
                        }
                        var portalId = this.getCurrentLoggedPortalId();
                        if (portalId != 3) {
                            form.down('executiondetailspanel').down('#admissionDateId').setVisible(true);
                        } else {
                            form.down('executiondetailspanel').down('#admissionDateId').setVisible(false);
                        }
                        this.setAllowBlank(form.down('executiondetailspanel').down('#admissionDateId'), false);
                    } else if (requestType == 'SECTION_TRANSFER' && data.serviceRequestSetting.serviceRequestCategory == "STUDENT_REQUEST") {
                        form.down('executiondetailspanel').down('#isRetainDataItemId').setVisible(true);
                        form.down('executiondetailspanel').down('#admissionDateId').setVisible(false);
                    } else if(requestType== "READMISSION") {
                    	 this.setAllowBlank(form.down('executiondetailspanel').down('#executionDateId'), false);
                    	 if(portalId != '3'){
                    		 form.down('executiondetailspanel').down('#readmissionOutcomeIds').setVisible(true);
                    	 }
                    	 
                    	 if(executionDetail && executionDetail.executionDetailReadmissionOutcomes && portalId != '3'){
                    		 var ids =[];
                    		 executionDetail.executionDetailReadmissionOutcomes.forEach(function(rec){
                    			 ids.push(rec.readmissionOutcomeCSM.id);
                    		 });
                    		 form.down('executiondetailspanel').down('#readmissionOutcomeIds').getStore().load({
     							callback : function(records,operation,success) {
    								if (success) {
    									form.down('executiondetailspanel').down('#readmissionOutcomeIds').setValue(ids);
    									form.down('executiondetailspanel').down('#readmissionOutcomeIds').setReadOnly(true);
    								}
    							}
    						})
                    		 
                    	 }else if(portalId != '3'){
                    		 form.down('executiondetailspanel').down('#readmissionOutcomeIds').setDisabled(false);
                    	 }
                    	
                    	 form.down('executiondetailspanel').down('#executionDateId').setDisabled(false);
                    	form.down('#isCalculateSeparateCGPAndSGPAId').setVisible(false);
                    	form.down('executiondetailspanel').down('#admissionDateId').setVisible(false);
                        this.setAllowBlank(form.down('executiondetailspanel').down('#admissionDateId'), true);
                    }else {
                        form.down('executiondetailspanel').down('#admissionDateId').setVisible(false);
                        this.setAllowBlank(form.down('executiondetailspanel').down('#admissionDateId'), true);
                    }
                }
                var executeForm = form.down('executiondetailspanel');
                this.setUserForExecution(executeForm, data, true);
            }
        }
        if (requestType === 'FEE_RELATED') {
            this.addFeeRequestGridOnExecutionPanel(data, form, record);
        }
        var isCertificateRequest = '';
        var executionDetailForm = '';
        var isStudentTransferRequest = false;
        var isSchoolLeavingRequest = false;
        if (requestType === 'CERTIFICATE' || requestType === 'Certificate') {
            isCertificateRequest = true;
            executionDetailForm = form.down('certificateexecutiondetailspanel');
        } else if (requestType === 'STUDENT_TRANSFER') {
            isStudentTransferRequest = true;
            executionDetailForm = form.down('studenttransferexecutiondetailspanel');
        } else if (requestType === 'SCHOOL_LEAVING') {
            isSchoolLeavingRequest = true;
            executionDetailForm = form.down('schoolleavingexecutiondetailspanel');
        } else if (requestType === 'LEAVE' && !isNullOrEmpty(form.config.requestTypeCode) && form.config.requestTypeCode == "LR") {
            isCertificateRequest = true;
            executionDetailForm = form.down('certificateexecutiondetailspanel');
        } else if (requestType === 'HOSTEL_LEAVE') {
            isCertificateRequest = true;
            executionDetailForm = form.down('certificateexecutiondetailspanel');
        }  else if(requestType== "READMISSION") {
            isCertificateRequest = false;
            executionDetailForm = form.down('executiondetailspanel');
        }else {
            isCertificateRequest = false;
            executionDetailForm = form.down('executiondetailspanel');
        }
        if (isClosed) {
        	var uploadAndSubmitButton = form.down('#freeFormSubmitBtn');
        	if(uploadAndSubmitButton) {
        		uploadAndSubmitButton.setVisible(false);
        	}
            var executionDetail = data.executionDetail;
            if (isCertificateRequest) {
                this.loadApprovalDetailsForm(executionDetailForm, executionDetail);
            } else {
                if (!isNullOrEmpty(requestType)) {
                    if (requestType == 'PROGRAM_TRANSFER') {
                        this.loadApprovalDetailsForm(executionDetailForm, executionDetail, 'PROGRAM_TRANSFER');
                    } else if (requestType == 'STUDENT_TRANSFER') {
                        this.loadApprovalDetailsForm(executionDetailForm, executionDetail, 'STUDENT_TRANSFER', data);
                    } else if (requestType == 'SCHOOL_LEAVING') {
                        this.loadApprovalDetailsForm(executionDetailForm, executionDetail, 'SCHOOL_LEAVING', data);
                    } else {
                        this.loadApprovalDetailsForm(executionDetailForm, executionDetail);
                    }
                } else {
                    this.loadApprovalDetailsForm(executionDetailForm, executionDetail);
                }
            }
        } else {
            var loggedInUserId = this.getCurrentlyLoggedInUser().id;
            var loggedInPortal = this$.getCurrentLoggedPortalId();
            var followUpDetails = data.followupDetails;
            if (requestType == 'FREE_FORM' && data.serviceRequestSetting.isAutoAssignee == true) {
                executionDetailForm.down('#executionSubmitBtn').setVisible(true);
            } else {
                Ext.each(followUpDetails, function (detail) {
                    if (detail.whetherLatest) {
                        if (loggedInUserId === 1 || loggedInUserId === detail.approver.id) {
                            if (isCertificateRequest) {
                                executionDetailForm.down('#certificateSubmitBtn').setVisible(true);
                            } else if (isStudentTransferRequest) {
                                if (loggedInPortal != 3 && loggedInPortal != 7) {
                                    executionDetailForm.down('#studentTransferExecutionSubmitBtn').setVisible(true);
                                    executionDetailForm.down('#studentTransferExecutionDocument').setVisible(true);
                                    executionDetailForm.down('#studenttransferexecutiondocumentgrid').getStore().removeAll();
                                }
                            } else if (isSchoolLeavingRequest) {
                                if (loggedInPortal != 3 && loggedInPortal != 7) {
                                    executionDetailForm.down('#schoolLeavingExecutionSubmitBtn').setVisible(true);
                                    executionDetailForm.down('#schoolLeavingExecutionDocument').setVisible(true);
                                    executionDetailForm.down('#schoolleavingexecutiondocumentgrid').getStore().removeAll();
                                }
                            } else {
                                executionDetailForm.down('#executionSubmitBtn').setVisible(true);
                            }
                        }
                    }
                });
            }
        }
    },
    loadApprovalDetailsForm: function (form, details, requestType, data) {
        form.getForm().setValues(details);
        var isFlagDoc = false;
        var docDataExecution = new Array();
        form.down('#executionDateId').setValue(dateRender(details.executionDate));
        if (!isNullOrEmpty(requestType)) {
            if (requestType == 'PROGRAM_TRANSFER') {
                if (!isNullOrEmpty(details.admissionDate)) {
                    form.down('#admissionDateId').setValue(dateRender(details.admissionDate));
                }
            } else if (requestType == 'STUDENT_TRANSFER') {
                if (!isNullOrEmpty(details.effectiveTransferDate)) {
                    form.down('#effectiveTransferDateId').setValue(dateRender(details.effectiveTransferDate));
                }
                form.down('#studenttransferexecutiondocumentgrid').down('#btnDelete').setVisible(false);
                if (data.documents.length > 0) {
                    data.documents.forEach(function (docObj) {
                        if (docObj.isExecutionDocument == true) {
                            var obj = new Object();
                            obj.documentName = docObj.name;
                            obj.createdBy = docObj.createdBy.value;
                            obj.submissionDate = docObj.submissionDate;
                            obj.id = docObj.id;
                            obj.encryptedDocId = docObj.encryptedDocId;
                            docDataExecution.push(obj);
                            isFlagDoc = true;
                        }
                    });
                    if (isFlagDoc == true) {
                        form.down('#studenttransferexecutiondocumentgrid').setVisible(true);
                        this.getStudenttransferexecutiondocumentgrid().getStore().loadData(docDataExecution, false);
                    }
                }
            } else if (requestType == 'SCHOOL_LEAVING') {
                if (!isNullOrEmpty(details.effectiveTransferDate)) {
                    form.down('#effectiveTransferDateId').setValue(dateRender(details.effectiveTransferDate));
                }
                form.down('#schoolleavingexecutiondocumentgrid').down('#btnDelete').setVisible(false);
                if (!isNullOrEmpty(data.documents) && data.documents.length > 0) {
                    data.documents.forEach(function (docObj) {
                        if (docObj.isExecutionDocument == true) {
                            var obj = new Object();
                            obj.documentName = docObj.name;
                            obj.createdBy = docObj.createdBy.value;
                            obj.submissionDate = docObj.submissionDate;
                            obj.id = docObj.id;
                            docDataExecution.push(obj);
                            isFlagDoc = true;
                        }
                    });
                    if (isFlagDoc == true) {
                        form.down('#schoolleavingexecutiondocumentgrid').setVisible(true);
                        this.getSchoolleavingexecutiondocumentgrid().getStore().loadData(docDataExecution, false);
                    }
                }
            }
        }
        var store = form.down('[name=closureReasonId]').getStore();
        store.load();
        this.toggleReadOnlyFormItems(form.getForm(), true);
        var loggedInPortal = this$.getCurrentLoggedPortalId();
        if (requestType == 'STUDENT_TRANSFER') {
            if (data.requestStatusId == 6) {
                if (loggedInPortal != 3 && loggedInPortal != 7) {
                    form.down('#studentTransferExecutionSubmitBtn').setVisible(true);
                    if (!isNullOrEmpty(details.effectiveTransferDate)) {
                        form.down('#effectiveTransferDateId').setReadOnly(false);
                    }
                }
            }
        } else if (requestType == 'SCHOOL_LEAVING') {
            if (data.requestStatusId == 6) {
                if (loggedInPortal != 3 && loggedInPortal != 7) {
                    form.down('#schoolLeavingExecutionSubmitBtn').setVisible(true);
                    if (!isNullOrEmpty(details.effectiveTransferDate)) {
                        form.down('#effectiveTransferDateId').setReadOnly(false);
                    }
                }
            }
        }
    },
    /**
     * This method is use to add fee request grid in exection
     * panel and load the follow up grid
     *
     * @param form Service request panel
     * @param record Selected service request resord f rom grid.
     */
    addFeeRequestGridOnExecutionPanel: function (data, form, record) {
        var exform = this.getExecutionDetailsPanel();
        var grid = Ext.widget('feeservicerequeststructure');
        var gridView = grid.down("#feerequestservice");
        if (data.detail[0].feeRequestAgainst === 'PENDING_BILLS') {
            gridView.columns[0].setVisible(false);
        }
        if (data.detail[0].category === 'INSTALLMENT') {
            gridView.columns[6].setVisible(true);
        } else {
            gridView.columns[4].setVisible(true);
            gridView.columns[5].setVisible(true);
        }
        exform.down("#executionfieldcontaineritemId").add(grid);
        var store = this.getContentPanelActiveTab().down('#feerequestservice').getStore();
        store.load({
            params: {
                serviceRequestId: record.data.ID
            }
        });
    },
    /**
     * This method is use to open installment window when click
     * on installin grid in exection panel
     *
     * @param id
     */
    getOpenFeeInstallment: function (grid, cellIndex, record) {
        var checkRecord = grid.selModel.getSelection();
        var columnName = grid.columnManager.columns[cellIndex].dataIndex;
        if (columnName === "installmentRequest") {
            if (checkRecord.length > 0) {
                var id = record.get("id");
                var formWin = this.getFeerelatedservicerequestinstallmentwin();
                if (!formWin) {
                    Ext.widget('feerelatedservicerequestinstallmentwin');
                    formWin = this.getFeerelatedservicerequestinstallmentwin();
                }
                var grid = this.getFeerelatedservicerequestinstallmentgrid();
                var store = grid.getStore();
                store.getProxy().extraParams = {
                    feeRelatedRequestDetailId: id
                };
                store.load();
                formWin.show();
            } else {
                showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_REQUEST_TITLE'), getFeeAndPaymentCommonTranslation('PLEASE_SELECT_CHECKBOX'));
            }
        }
    },
    /**
     * This method is use to add follow up panel in main panel
     * and load the follow up grid
     *
     * @param form Service request panel
     * @param record Selected service request resord f rom grid.
     */
    addFollowUpDetailPanel: function (form, record, data) {
        var store = '';
        var $this = this;
        var isFlagDoc = false;
        var complaintPanel = form.down('complaintfollowupdetailspanel');
		var uploadAndSubmitButton = form.down('#freeFormSubmitBtn');
		if (uploadAndSubmitButton) {
			uploadAndSubmitButton.setVisible(false);
		}
        if (record.data.REQUEST_TYPE === 'COMPLAINT' || record.data.REQUEST_TYPE === 'Complaint' || record.data.REQUEST_TYPE ==='Grievance') {
            if (isNullOrEmpty(complaintPanel)) {
                form.add({
                    xtype: 'complaintfollowupdetailspanel'
                });
                store = this.getContentPanelActiveTab().down('#complaintFollowUpDetailsGridId').getStore();
            } else {
                if (!isNullOrEmpty(this.getContentPanelActiveTab().down('#complaintFollowUpDetailsGridId'))) {
                    store = this.getContentPanelActiveTab().down('#complaintFollowUpDetailsGridId').getStore();
                }
            }
        } else if (record.data.SERVICE_REQUEST_TYPE === 'STUDENT_TRANSFER') {
            var followUpPanel = form.down('followupdetailspanel');
            var docDataFollowUp = new Array();
            if (isNullOrEmpty(followUpPanel)) {
                form.add({
                    xtype: 'followupdetailspanel'
                });
                var followupdetailsgrid = this.getContentPanelActiveTab().down('#followupdetailsgridId');
                followupdetailsgrid.down("[dataIndex=academyLocation]").setVisible(true);
                store = followupdetailsgrid.getStore();
            } else {
                if (!isNullOrEmpty(this.getContentPanelActiveTab().down('#followupdetailsgridId'))) {
                    store = this.getContentPanelActiveTab().down('#followupdetailsgridId').getStore();
                }
            }
            if (data.documents.length > 0) {
                data.documents.forEach(function (docObj) {
                    if (docObj.isFollowupDocument == true) {
                        var obj = new Object();
                        obj.name = docObj.name;
                        obj.createdBy = docObj.createdBy.value;
                        obj.submissionDate = docObj.submissionDate;
                        obj.documentId = docObj.id;
                        obj.encryptedDocId = docObj.encryptedDocId;
                        docDataFollowUp.push(obj);
                        isFlagDoc = true;
                    }
                });
                if (isFlagDoc == true) {
                    form.down('#serviceReqFollowUpDocPnlItemId').setVisible(true);
                    $this.getServicerequestfollowupdocumentsgrid().getStore().loadData(docDataFollowUp, false);
                }
            }
        } else {
            var followUpPanel = form.down('followupdetailspanel');
            if (isNullOrEmpty(followUpPanel)) {
                form.add({
                    xtype: 'followupdetailspanel'
                });
                store = this.getContentPanelActiveTab().down('#followupdetailsgridId').getStore();
            } else {
                if (!isNullOrEmpty(this.getContentPanelActiveTab().down('#followupdetailsgridId'))) {
                    store = this.getContentPanelActiveTab().down('#followupdetailsgridId').getStore();
                }
            }
        }
        store.getProxy().extraParams = {
            serviceRequestId: record.data.ID
        };
        store.load();
        Ext.defer(function () {
            if (record.data.REQUEST_TYPE == "EMPLOYEELEAVE" || record.data.REQUEST_TYPE == "Employee Leave") {
                var grid = $this.getEmployeeleavedetailgrid();
                grid.getStore().getProxy().extraParams = {
                    userId: record.data.REQUESTER,
                    academyLocationId: $this.getCurrentAcademyLocation()
                };
                grid.getStore().load();
            }
        }, 50, this);
    },
    /**
     * This method is use to add approval panel in main panel
     * and load the approval details grid
     *
     * @param form Service request panel
     * @param record Selected service request resord f rom grid.
     */
    addApprovalDetailsPanel: function (data, form, record, whetherReadOnly) {
        if (!data.serviceRequestSetting.isAutoApprove) {
            var approvalPanel = form.down('approvaldetailspanel');
            if (isNullOrEmpty(approvalPanel)) {
                form.add({
                    xtype: 'approvaldetailspanel'
                });
            }
			var academyLocationId =this.getCurrentAcademyLocation();
            this.toggleButtonsOnApprovalForm(data);
            var approvalForm = form.down('approvaldetailspanel');
            if (record.data.SERVICE_REQUEST_TYPE == 'SCHOLARSHIP') {
                approvalForm.down('#amount').setVisible(true);
                approvalForm.down('#amount').setDisabled(false);
                approvalForm.down('#amount').setReadOnly(whetherReadOnly);
                approvalForm.down('#amount').setMaxValue(data.detail.approvedScholarshipAmount);
                approvalForm.down('#amount').setMinValue(0);
                approvalForm.down('#scholarshipName').setVisible(true);
                approvalForm.down('#scholarshipName').setValue(data.detail.scholarshipName);
                approvalForm.down('#scholarshipAwardDate').setVisible(true);
                approvalForm.down('#scholarshipAwardDate').setDisabled(false);
                approvalForm.down('#scholarshipAwardDate').setReadOnly(whetherReadOnly);
                approvalForm.down('#scholarshipValidFrom').setVisible(true);
                approvalForm.down('#scholarshipValidFrom').setDisabled(false);
                approvalForm.down('#scholarshipValidFrom').setReadOnly(whetherReadOnly);
                approvalForm.down('#scholarshipValidUpto').setVisible(true);
                approvalForm.down('#scholarshipValidUpto').setDisabled(false);
                approvalForm.down('#scholarshipValidUpto').setReadOnly(whetherReadOnly);
                approvalForm.down('#amount').setValue(data.detail.approvedScholarshipAmount);
                if (whetherReadOnly) {
                    approvalForm.down('#scholarshipAwardDate').setValue(dateRender(data.detail.awardDate));
                    approvalForm.down('#scholarshipValidFrom').setValue(data.detail.validFrom);
                    approvalForm.down('#scholarshipValidUpto').setValue(data.detail.validUpto);
                }
            } else if (record.data.SERVICE_REQUEST_TYPE == 'HOSTEL_LEAVE') {
                approvalForm.down('#escalateBtn').setVisible(false);
            } else if (record.data.SERVICE_REQUEST_GROUP == 'OTHER' && record.data.SERVICE_REQUEST_TYPE == 'LEAVE') {
                approvalForm.down('#escalateBtn').setVisible(false);
				Ext.Ajax.request({
				       type: 'rest',
				       url: SERVERURL.PATH_GET_DFR_DETAILS_APPROVAL_DETAIL,
				       method: 'GET',
				       params: {
				           screenName: 'approvaldetailspanel',
				           screenMode: 'Create, Edit, and View',
				           academyLocationId: academyLocationId
				       },
				       success: function (f, action) {
				           var data = Ext.decode(f.responseText);
				           var visible = true;
				           var label = null;
						   var value = null;
				           if (!isNullOrEmpty(data) && data.length>0) {
				               var apiRecord = data[0];
				               visible = apiRecord.isVisible;
				               label = apiRecord.newLabel;
							   value = apiRecord.defaultValue;
				           }

				           var leaveOverrideCmp = approvalForm.down('#isLeaveOverride');
				           leaveOverrideCmp.setVisible(visible);
				           leaveOverrideCmp.setReadOnly(whetherReadOnly); 
						   if (!whetherReadOnly && !isNullOrEmpty(value)) {
						       var lowerVal = value.toLowerCase();

						       if (lowerVal === 'yes' || lowerVal === 'true') {
						           leaveOverrideCmp.setValue(true); 
						       } else if (lowerVal === 'no' || lowerVal === 'false') {
						           leaveOverrideCmp.setValue(false); 
						       }
						   }
				           if (!isNullOrEmpty(label)) {
							leaveOverrideCmp.setBoxLabel(label);
				           }
				       },
				       failure: function (result, request) {
				           showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
				           return false;
				       }
				   });
				
            }
            this.setUserForExecution(approvalForm, data, true);
            var store = this.getContentPanelActiveTab().down('#approvaldetailsgridId').getStore();
            if (data.serviceRequestSetting.requestType.value == "Employee Leave") {
                store.getProxy().api.read = SERVERURL.EMPLOYEE_LEAVE_REQUEST_PATH_GRID_APPROVAL_DETAIL;
            }
            store.proxy.extraParams = {
                serviceRequestId: record.data.ID
            };
            store.load();
        }
    },
    /**
     * This method is use to hide show the buttons on the
     * approver details form
     *
     * @param data
     *            Service request object
     */
    toggleButtonsOnApprovalForm: function (data) {
        var buttonContainer = this.getContentPanelActiveTab().down('approvaldetailspanel').down('#approvalButtonsContainer');
        var remarkField = this.getContentPanelActiveTab().down('approvaldetailspanel').down('#approvalRemarks');
        var loggedInUserId = this.getCurrentlyLoggedInUser().id;
        var serviceRequestConstants = this.getServiceRequestConstant();
        if (data.serviceRequestStage === 'PRECLOSURE' && data.requestStatusId !== serviceRequestConstants.getRequestStatus('REQUEST_STATUS_REJECTED') && data.requestStatusId !== serviceRequestConstants.getRequestStatus('REQUEST_STATUS_WITHDRAWN')) {
            if (isEmpty(data.approvalDetails)) {
                Ext.each(data.followupDetails, function (detail) {
                    if (detail.whetherLatest) {
                        if (isEmpty(detail.approver)) {
                            if (!isNullOrEmpty(data.serviceRequestSetting.defaultApprover) && loggedInUserId !== data.serviceRequestSetting.defaultApprover.id) {
                                buttonContainer.setVisible(false);
                                remarkField.setReadOnly(true);
                                remarkField.setVisible(false);
                            }
                            if (loggedInUserId == 1) {
                                buttonContainer.setVisible(true);
                                remarkField.setReadOnly(false);
                                remarkField.setVisible(true);
                            }
                        } else {
                            if (loggedInUserId !== detail.approver.id) {
                                buttonContainer.setVisible(false);
                                remarkField.setReadOnly(true);
                                remarkField.setVisible(false);
                            }
                            if (loggedInUserId == 1) {
                                buttonContainer.setVisible(true);
                                remarkField.setReadOnly(false);
                                remarkField.setVisible(true);
                            }
                        }
                    }
                });
            } else {
                Ext.each(data.approvalDetails, function (detail) {
                    if (detail.whetherLatest && !isNullOrEmpty(detail.escalatedApprover)) {
                        if (loggedInUserId !== detail.escalatedApprover.id) {
                            buttonContainer.setVisible(false);
                            remarkField.setReadOnly(true);
                            remarkField.setVisible(false);
                        }
                        if (loggedInUserId == 1) {
                            buttonContainer.setVisible(true);
                            remarkField.setReadOnly(false);
                            remarkField.setVisible(true);
                        }
                    }
                });
            }
        } else {
            buttonContainer.setVisible(false);
            remarkField.setReadOnly(true);
            remarkField.setVisible(false);
        }
    },
    /**
     * This method is use to get the service request setting for
     * the selected request
     *
     */
    getCertificateServiceRequestSettings: function (combo, value) {
        var tab = this.getContentPanelActiveTab();
        var submitData = new Object();
        submitData.serviceRequestCategory = this.getServiceRequestCategory();
        var assignedTo = combo.up('form').down('basicdetails').down('#assignedTo');
        var instructions = combo.up('form').down('basicdetails').down('#instructionsReqItemId');
        submitData.academyLocationId = this.getCurrentAcademyLocation();
        submitData.certificateId = value;
        submitData.personId = tab.getRequesterId();
        this.sendGetAjaxRequest(SERVERURL.GET_SERVICE_REQUEST_SETTINGS, 'GET', submitData, function (option, success, response) {
            if (success) {
                var settings = Ext.decode(response.responseText);
                if (!isNullOrEmpty(settings.defaultAssignee)) {
                    assignedTo.setValue(settings.defaultAssignee.value);
                    tab.setAssignee(settings.defaultAssignee);
                }
                instructions.reset();
                if (!isNullOrEmpty(settings.instructions)) {
                    instructions.setValue(settings.instructions);
                }
                tab.setSettingId(settings.id);
                tab.setServiceRequestSetting(settings);
            }
        });
    },
    /* ------ follow up details Functionality START --------- */
    /**
     * This method is used to open follow Up Details Pop Up form
     * on click of follow Up button
     */
    showFollowUpDetailsForm: function () { 
        var this$ = this;
        var panel =this.getActiveTabfromContentPanel();
        var followWindow = this.getFollowUpDetailsPopUpWindow();
        if (!followWindow) {
            followWindow = Ext.widget('followupdetailspopupwindow');
        }
        var requestGroup = this.getContentPanelActiveTab().getRequestGroup();
        if (!isNullOrEmpty(requestGroup) && requestGroup == 'STUDENT_TRANSFER') {
            var studentTransferFollwupDocumentGrid = this$.getStudenttransferfollwupdocumentgrid();
            var studentTransferFollwupDocumentGridStore = studentTransferFollwupDocumentGrid.getStore();
            studentTransferFollwupDocumentGridStore.removeAll();
            followWindow.down('#studentTransferFollwupDocumentContainer').setVisible(true);
            followWindow.down('#studentTransferFollwupDocument').setVisible(true);
            followWindow.down('#academyLocationItemId').setVisible(true);
            followWindow.down('#academyLocationItemId').allowBlank = false;
            followWindow.down('#documentProof').allowBlank = true;
        }
        followWindow.show();
        this.setPlannedDateForFollowup(followWindow);
    },
    /**
     * This method is used to open Complaint follow Up Details
     * Pop Up form on click of follow Up button
     */
    showComplaintFollowUpDetailsForm: function () {
        var followWindow = this.getComplaintFollowUpPopUp();
        if (!followWindow) {
            followWindow = Ext.widget('complaintfollowuppopup');
        }
        this.setPlannedDateForFollowup(followWindow);
        followWindow.show();
    },
    /**
     * This method is used to close follow Up Details Pop Up
     * form on click of follow Up button
     *
     */
    cancelFollowUpDetailsForm: function () {
        var this$ = this;
        this$.getFollowUpDetailsPopUpWindow().close();
    },
    /**
     * This method is used to close Complaint follow Up Details
     * Pop Up form on click of follow Up button
     *
     */
    cancelComplaintFollowUpDetailsForm: function () {
        var this$ = this;
        this$.getComplaintFollowUpPopUp().close();
    },
    /**
     * This method is used to submit follow Up Details Pop Up
     * form on click of submit button
     *
     */
    submitFollowUpDetailsForm: function (btn) {
        var this$ = this;
        var form = '';
        var url = '';
        var stopContiner = this$.getEmployeeleaverequestdetailspanel();
        if (stopContiner != undefined) {
            var form = stopContiner.down('#leaveContainerId');
            if (form != undefined) {
                if (form.getCode() != undefined && (form.getCode() == "EMPLOYEELEAVE" || form.getCode() == "Employee Leave")) {
                    url = SERVERURL.EMPLOYEE_LEAVE_REQUEST_PATH_SAVE_FOLLOWUP;
                }
            }
        } else {
            url = SERVERURL.FOLLOW_UP_DETAILS_SAVE;
        }
        if (btn.itemId === 'complaintFollowUpDetailsSubmitButtonId') {
            form = this$.getComplaintFollowUpDetailsPopUpForm();
        } else {
            form = this$.getFollowUpDetailsPopUpForm();
        }
        if (form.isValid()) {
            var followUpTab = this$.getContentPanelActiveTab();
            var serviceRequestId = followUpTab.getServiceRequestId();
            if (url == '' && followUpTab.getServiceRequestSetting().requestType != undefined) {
                if (followUpTab.getServiceRequestSetting().requestType.value == "Employee Leave") {
                    url = SERVERURL.EMPLOYEE_LEAVE_REQUEST_PATH_SAVE_FOLLOWUP;
                }
            }
            var user = this$.getCurrentlyLoggedInUser();
            var formData = form.getValues();
            var assignee = form.down('[name=assignee]').getValue();
            if (isNullOrEmpty(assignee)) {
                formData.assignee = this.getCurrentlyLoggedInUser();
            }
            formData.serviceRequestId = serviceRequestId;
            formData.user = user;
            var submitData = new Object();
            submitData.requestStatusId = formData.requestStatusId;
            submitData.whetherAutoApprove = formData.whetherAutoApprove;
            if (btn.itemId === 'followUpDetailsSubmitButtonId') {
                var studentTransferFollwupDocumentGrid = this$.getStudenttransferfollwupdocumentgrid();
                var studentTransferFollwupDocumentGridStore = studentTransferFollwupDocumentGrid.getStore();
                var docArray = [];
                try {
                    if (studentTransferFollwupDocumentGridStore.data.items != null && studentTransferFollwupDocumentGridStore.data.items.length > 0) {
                        Ext.each(studentTransferFollwupDocumentGridStore.data.items, function (val) {
                            var newData = {
                                "name": val.data.documentName,
                                "path": val.data.path,
                                "type": "DOCUMENT",
                                "createdBy": this$.getIdValueJson(val.data.createdBy.id, val.data.createdBy.value)
                            };
                            var document = new Object();
                            document.document = newData;
                            document.isFollowupDocument = true;
                            docArray.push(document);
                        });
                    }
                    formData.documents = docArray;
                    delete formData.academyLocation;
                    var academyLocation = new Object();
                    academyLocation.id = this.getCurrentAcademyLocation();
                    formData.academyLocation = academyLocation;
                } catch (err) {}
            }
            if(formData.agendaNumber){
            	formData.agendaNumber={
            			id:formData.agendaNumber
            	}
            	
            }else{
            	delete formData.agendaNumber;
            }
            submitData.followupDetail = formData;
            var documentProof = form.down('#documentProof');
            if (!isNullOrEmpty(documentProof)) {
                documentProofId = documentProof.getValue();
                if (isNullOrEmpty(documentProofId)) {
                    delete formData.documentProofStatus;
                }
            }
            delete formData.whetherAutoApprove;
            delete formData.requestStatusId;
            var jsonFormatFormData = Ext.encode(submitData);
            this$.applyWindowMask();
            this$.sendSaveAjaxRequest(url, 'POST', jsonFormatFormData, function (opt, success, response) {
                this$.hideWindowMask();
                if (success) {
                    if (btn.itemId === 'complaintFollowUpDetailsSubmitButtonId') {
                        this$.cancelComplaintFollowUpDetailsForm();
                    } else {
                        this$.cancelFollowUpDetailsForm();
                    }
                    showSuccessMessage(getServiceRequestTranslation('FOLLOW_UP_DETAILS'), getServiceRequestTranslation('FOLLOW_UP_DETAILS_SUCCESS'));
                    if (followUpTab.getRequestType() === 'STUDENT_REQUEST' || followUpTab.getRequestType() === 'TERMINATION_REQUEST' || followUpTab.getRequestType() === 'TRANSFER_REQUEST' || followUpTab.getRequestType() === 'DEBRAMENT_REQUEST') {
                        this$.loadStudentGridAndSearchRequest();
                    } else if (followUpTab.getRequestType() === 'FACULTY_REQUEST') {
                        this$.loadFacultyGridAndSearchRequest();
                    } else if (formData.requestType === 'COMPLAINT' || formData.requestType === 'Complaint') {
                        this$.loadComplaintGridAndSearchRequest();
                    }
                    this$.getComplaintSearchResultGrid() && this$.getComplaintSearchResultGrid().getStore().load();
                    this$.closeTab(followUpTab);
                }
            });
        } else {
            showWarningMessage(getServiceRequestTranslation('FOLLOW_UP_DETAILS'), getServiceRequestTranslation('FILL_MANDATORY_FIELDS'));
        }
    },
    blankAssignee: function (obj) {
        var frm = this.getFollowUpDetailsPopUpForm();
        var assigneeID = frm.down('#newAssigneeId');
        assigneeID.reset();
        var store = assigneeID.getStore();
        var acadLocCombo = frm.down('#academyLocationItemId');
        var academyLocationId = acadLocCombo.getValue();
        if (!isNullOrEmpty(academyLocationId)) {
            store.on('beforeload', function () {
                store.getProxy().extraParams = {
                    academyLocationId: academyLocationId
                };
            }, this);
            store.load();
        }
    },
    /**
     * This method is used to hide & show panel of Schedule next
     * Follow up & SendForApproval radio buttons on select of
     * radio button of FollowUpDetails Pop Up
     */
    hideShowPanel: function (radio, value) {
        var frm = this.getFollowUpDetailsPopUpForm();
        var panel =this.getActiveTabfromContentPanel();
        var schedulePanel = frm.down('#schedulePanel');
        var schedulePanel1 = frm.down('#schedulePanel1');
        var sendPanel = frm.down('#sendPanel');
        var nextFollowUpDate = schedulePanel.down('#nextFollowUpDate');
        var newAssigneeId = schedulePanel1.down('#newAssigneeId');
        if (value.isSendForApproval === false) {
            schedulePanel.setVisible(true);
            schedulePanel.setDisabled(false);
            schedulePanel1.setVisible(true);
            schedulePanel1.setDisabled(false);
            sendPanel.setDisabled(true);
            sendPanel.setVisible(false);
            if (!isNullOrEmpty(nextFollowUpDate)) {
                this.setAllowBlank(nextFollowUpDate, false);
            }
            if (!isNullOrEmpty(newAssigneeId)) {
                this.setAllowBlank(newAssigneeId, false);
            }
            frm.getForm().checkValidity();
        } else {
            sendPanel.setDisabled(false);
            sendPanel.setVisible(true);
            schedulePanel.setDisabled(true);
            schedulePanel.setVisible(false);
            schedulePanel1.setDisabled(true);
            schedulePanel1.setVisible(false);
            if (!isNullOrEmpty(nextFollowUpDate)) {
                this.setAllowBlank(nextFollowUpDate, true);
            }
            if (!isNullOrEmpty(newAssigneeId)) {
                this.setAllowBlank(newAssigneeId, true);
            }
            frm.getForm().checkValidity();
            var me = this;
            var combo = sendPanel.down("#approverID");
            var store = combo.getStore();
            var followWindow = this.getFollowUpDetailsPopUpWindow();
            var basicDetailPnl = me.getBasicdetails();
            var acadLocCombo = followWindow.down('#academyLocationItemId');
            var data = this.getContentPanelActiveTab().getResponseData();
            if (Ext.isDefined(basicDetailPnl)) {
                var academyLocationId = basicDetailPnl.config.reqAcademyLocationId;
                var approverId = basicDetailPnl.config.reqApproverId;
                if (approverId != null) {
                    if (!isNullOrEmpty(academyLocationId)) {
                        store.on('beforeload', function () {
                            store.getProxy().extraParams = {
                                academyLocationId: academyLocationId
                            };
                        }, this);
                        store.load({
                            callback: function () {
                                if (approverId != null) combo.setValue(approverId);
                            }
                        })
                    }
                } else {
                    sendPanel.setDisabled(true);
                    sendPanel.setVisible(false);
                    sendPanel.allowBlank = true;
					frm.getForm().checkValidity();
                }
            } else if (data.serviceRequestSetting.defaultApprover != null && data.serviceRequestSetting.defaultApprover.id != null) {
            	var academyLocationId = this.getCurrentAcademyLocation();
            	if (!isNullOrEmpty(academyLocationId)) {
            		store.on('beforeload', function () {
            			store.getProxy().extraParams = {
            				academyLocationId: academyLocationId
            			};
            		}, this);
            		store.load({
            			callback: function () {
            				if(data.serviceRequestSetting.defaultApprover.id!=null)
            					combo.setValue(data.serviceRequestSetting.defaultApprover.id);
            			}})
            	}
            } else {
                store.load();
            }
            if(panel.title == 'READMISSION' || panel.requestGroup == 'READMISSION' || panel.title== "Readmission Request"){
        		followWindow.down('#agendaNumber').setVisible(true);
    		 }
        }
        	
    },
    /**
     * This method is used to hide & show panel of Schedule next
     * Follow up panel on select of radio button of Complaint
     * FollowUpDetails Pop Up
     */
    hideShowFields: function (radio, value) {
        var frm = this.getComplaintFollowUpDetailsPopUpForm();
        var schedulePanel = frm.down('#schedulePanel');
        if (value.isSendForApproval === false) {
            schedulePanel.setVisible(true);
            schedulePanel.setDisabled(false);
        } else {
            schedulePanel.setDisabled(true);
            schedulePanel.setVisible(false);
        }
    },
    /**
     * This method is used to disable SendForApprovalRadio
     * button on select of Pending in Document Proof Status's
     * Combo in FollowUpDetails Pop Up
     *
     * @param :
     *            combo
     */
    hideRadioPanel: function (cmb) {
        var frm = this.getFollowUpDetailsPopUpForm();
        var sendRadioBtn = frm.down('#SendForRadioBtn');
        var approverPanel = frm.down('#sendPanel');
        frm.down('#ScheduleRadioBtn').reset();
        sendRadioBtn.reset();
        if (cmb.value === 'PENDING') {
            sendRadioBtn.setDisabled(true);
            approverPanel.setDisabled(true);
            approverPanel.setVisible(false);
        } else if (cmb.value === 'GIVEN' || cmb.value === 'NA') {
            sendRadioBtn.setDisabled(false);
            approverPanel.setDisabled(true);
            approverPanel.setVisible(false);
        }
    },
    /* ------ follow up details Functionality END --------- */
    /* approval details functionality START */
    /**
     * This method is used to open escalate details Pop Up form
     * on click of Escalate button
     */
    showEscalateDetailsForm: function (btn) {
        var me = this;
        var btnName = btn.name;
        var escalateWindow = me.getEscalateDetailsPopUpWindow();
        if (!escalateWindow) {
            escalateWindow = Ext.widget('escalatedetailspopupwindow');
        }
        escalateWindow.down('#userId').setValue(this.getCurrentlyLoggedInUser().value);
        escalateWindow.show();
        me.getEscalateDetailsPopUpForm().getForm().setValues({
            status: btnName
        });
    },
    /**
     * This method is use to approve the request.
     *
     * @param button approve buton on the form
     */
    approveRequest: function (button) {
        var form = button.up('form');
        var serviceRequestConstants = this.getServiceRequestConstant();
        var values = new Object();
        values.remarks = form.down('[name=remarks]').getValue();
        values.requestStatusId = serviceRequestConstants.getRequestStatus('REQUEST_STATUS_APPROVED');
        if (!isNullOrEmpty(form.down("#scholarshipAwardDate"))) {
            values.scholarshipAwardDate = form.down("#scholarshipAwardDate").value;
            values.scholarshipValidFrom = form.down("#scholarshipValidFrom").value;
            values.scholarshipValidUpto = form.down("#scholarshipValidUpto").value;
            values.approvedScholarshipAmount = form.down("#amount").value;
        }
		if (!isNullOrEmpty(form.down('#isLeaveOverride'))){
			values.isLeaveOverride=form.down('#isLeaveOverride').value;
		}
        values.actionDate = Ext.Date.format(new Date(), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
        this.submitEscalateDetailsForm(values);
    },
    /**
     * This method is use to reject the request. if scholarship
     * request, then warning message is thrown in case if the
     * remarks are not entered.
     *
     * @param button Reject button
     */
    rejectRequest: function (button) {
        var form = button.up('form');
        var serviceRequestConstants = this.getServiceRequestConstant();
        var values = new Object();
        if (isNullOrEmpty(form.up().down("approvaldetailspanel").down("#approvalRemarks").value)) {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('PLEASE_ENTER_REMARKS'));
            return false;
        }
        values.remarks = form.down('[name=remarks]').getValue();
        values.requestStatusId = serviceRequestConstants.getRequestStatus('REQUEST_STATUS_REJECTED');
        values.actionDate = Ext.Date.format(new Date(), 'Y-m-d');
        this.submitEscalateDetailsForm(values);
    },
    /**
     * This method is use to escalate the request
     *
     * @param button
     *            Escalate button
     */
    EscalateRequest: function (button) {
        var form = button.up('form');
        var serviceRequestConstants = this.getServiceRequestConstant();
        var values = form.getValues();
        values.requestStatusId = serviceRequestConstants.getRequestStatus('REQUEST_STATUS_ESCLATED');
        this.submitEscalateDetailsForm(values);
    },
    /**
     * This method is used to close escalate details Pop Up form
     * on click of Escalate button
     */
    cancelEscalateDetailsForm: function () {
        var this$ = this;
        this$.getEscalateDetailsPopUpWindow().close();
    },
    /**
     * This method is used to submit escalate details Pop Up
     * form on click of submit button
     */
    submitEscalateDetailsForm: function (values) {
        var this$ = this;
        var url;
        if (this$.getEmployeeleaverequestdetailspanel() != undefined) {
            if (this$.getEmployeeleaverequestdetailspanel().down('#leaveContainerId') != undefined) {
                var stopContiner = this$.getEmployeeleaverequestdetailspanel().down('#leaveContainerId');
                url = SERVERURL.EMPLOYEE_LEAVE_REQUEST_PATH_SAVE_APPROVAL_DETAIL;
            }
        } else {
            url = SERVERURL.APPROVAL_DETAILS_SAVE;
        }
        var serviceRequestConstants = this.getServiceRequestConstant();
        var requestId = values.requestStatusId;
        var tab = this$.getContentPanelActiveTab();
        var serviceRequestId = tab.getServiceRequestId();
        var user = this$.getCurrentlyLoggedInUser();
        values.serviceRequestId = serviceRequestId;
        values.user = user;
        var obj = new Object();
        obj.approvalDetail = values;
        obj.serviceRequestSetting = tab.getServiceRequestSetting();
        if (!isNullOrEmpty(obj.approvalDetail.scholarshipAwardDate)) {
            url = SERVERURL.SAVE_SCHOLARSHIP_APPROVAL_DETAIL;
        }
        var submitData = Ext.encode(obj);
        this$.sendSaveAjaxRequest(url, 'POST', submitData, function (opt, success, response) {
            if (success) {
                if (requestId === serviceRequestConstants.getRequestStatus('REQUEST_STATUS_ESCLATED')) {
                    this$.cancelEscalateDetailsForm();
                    showSuccessMessage(getServiceRequestTranslation('APPROVAL_DETAILS'), getServiceRequestTranslation('ESCALATED_DETAILS_SUCCESS'));
                } else if (requestId === serviceRequestConstants.getRequestStatus('REQUEST_STATUS_APPROVED')) {
                    showSuccessMessage(getServiceRequestTranslation('APPROVAL_DETAILS'), getServiceRequestTranslation('REQUEST_APPROVAL_SUCCESS'));
                } else {
                    showSuccessMessage(getServiceRequestTranslation('APPROVAL_DETAILS'), getServiceRequestTranslation('REQUEST_REJECT_SUCCESS'));
                }
                if (tab.getRequestType() === 'STUDENT_REQUEST' || tab.getRequestType() === 'TERMINATION_REQUEST' || tab.getRequestType() === 'TRANSFER_REQUEST' || tab.getRequestType() === 'DEBRAMENT_REQUEST') {
                    this$.loadStudentGridAndSearchRequest();
                } else if (tab.getRequestType() === 'FACULTY_REQUEST') {
                    this$.loadFacultyGridAndSearchRequest();
                }
                this$.closeTab(tab);
            }
        });
    },
    closeAllSelectedRecords: function (btn) {
        var me = this;
        var win = btn.up('window');
        var values = win.approvalDetailsArray;
        var grid = win.grid;
        var selectedRecords = grid.getSelectionModel().getSelection();
        var finalData = [];
        var executionDate = win.down('#executionDateId').getValue();
        var closureReasonId = win.down('#closureReasonId').getValue();
        var remark = win.down('#remark').getValue();
        if(!isNullOrEmpty(selectedRecords) && selectedRecords.length &&  selectedRecords[0].data.SERVICE_REQUEST_TYPE == "STUDENT_TRANSFER"){
        var retainStudentData = win.down('#retainStudentDataId').getValue();
        var retainAcademicData = win.down('#retainAcademicDataId').getValue();
        var retainServicesOpted = win.down('#retainServicesOptedId').getValue();
        var retainFeePaymentData = win.down('#retainFeePaymentDataId').getValue();
        }
        Ext.each(values, function (currentRecord) {
            var val = new Object();
            if(currentRecord.isStudentTranssfer)
            {
            	val.effectiveTransferDate=executionDate ;
            	val.closureReasonId = closureReasonId;
            	val.isRetainStudentData= retainStudentData;
            	val.isRetainAcademicData= retainAcademicData;
            	val.isRetainServicesOpted= retainServicesOpted;
            	val.isRetainFeesPaymentData= retainFeePaymentData;
            	val.remark=remark;
            	val.isStudentFeeSettled= true;
            	val.isRequiredDocumentUploaded= true;
            	val.documents= currentRecord.documents;
            	val.serviceRequestId= currentRecord.serviceRequestId;
            	val.user = currentRecord.user;
				if(!isNullOrEmpty(val.user)){
					delete val.user.code;
					delete val.user.value;
				}
            	finalData = val;
            }
            else{
            		val.executionDate = executionDate;
		            val.admissionDate = "";
		            val.closureReasonId = closureReasonId;
		            val.remark = remark;
		            val.isRetainData = currentRecord.isRetainData;
		            val.serviceRequestId = currentRecord.serviceRequestId;
		            val.user = currentRecord.user;
					if (!isNullOrEmpty(val.user)) {
						delete val.user.code;
						delete val.user.value;
					}
		            finalData.push(val);
            }
        });
        var requestTypeName = selectedRecords[0].data.REQUEST_TYPE;
        if (requestTypeName == 'Withdraw from program') {
            var closeUrl = SERVERURL.SAVE_PROGRAM_WITHDRAWAL_EXECUTION;
        } else if (requestTypeName == 'Program transfer') {
            var closeUrl = SERVERURL.SAVE_PROGRAM_TRANSFER_EXECUTION;
        } else if (requestTypeName == 'Leave of absence') {
            var closeUrl = SERVERURL.LEAVE_OF_ABSENCE_SR;
        } else if (requestTypeName == 'Debarment request') {
            var closeUrl = SERVERURL.STUDENT_DEBARMENT_FOR_NEW_EXECUTION;
        } else if (requestTypeName == 'Student transfer') {
            var closeUrl = SERVERURL.SAVE_STUDENT_TRANSFER_EXECUTION;
        }  
        else if (requestTypeName == 'Exchange semester') {
            var closeUrl = SERVERURL.EXCHANGE_SEMESTER_SR_EXECUTION;
            //finalData = finalData[0];
        } 
        else {
            var closeUrl = SERVERURL.SAVE_TERMINATION_EXECUTION;
        }
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: closeUrl,
            method: 'POST',
            jsonData: finalData,
            async: false,
            success: function (response, action) {
                if (!isNullOrEmpty(response.responseText)) {
                    Ext.getBody().unmask();
                    if (response.responseText.indexOf("complete_completion_process") != -1) {
                        var responseArray = response.responseText.split('</br>');
                        var msg = 'Complete completion setting for ';
                        var idArray = [];
                        Ext.each(responseArray, function (currentResp) {
                            var currentId = currentResp.replace('complete_completion_process for ', '');
                            if (currentId != "") {
                                idArray.push(currentId);
                            }
                        });
                        msg = msg + idArray.join(" and ");
                        showWarningMessage(getCommonTranslation('CLOSE_REQUEST'), msg);
                    } else if (response.responseText.indexOf("Current Period Not available") != -1) {
                        showWarningMessage(getCommonTranslation('CLOSE_REQUEST'), 'Current Period Not available');
                    } else if (response.responseText.indexOf("Unable to Close Request") != -1) {
                        showWarningMessage(getCommonTranslation('CLOSE_REQUEST'), 'Unable to Close Request');
                    } else {
                        showSuccessMessage(getCommonTranslation('CLOSE_REQUEST'), getCommonTranslation('SUCCESS'));
                    }
                    grid.getStore().reload();
                    win.close();
                }
            },
            failure: function (response, action) {
                btn.setDisabled(false);
				if (!isNullOrEmpty(response.responseText)) {
						var responseArray = JSON.parse(response.responseText);
						if (responseArray.length > 0 && responseArray[0].key === "EXEMPT_EXISTS_AFTER_THIS_LINE_PLEASE_CANCEL") {
							win.close();
							grid.getStore().reload();
					}
				}
            }
        });
    },
    closeAllReAssignRequestSelectedRecords: function (btn) {
        var $this = this;
        var window = $this.getReassignrequestservicerequestwin();
        var grid = $this.getStudentSearchResultGrid();
        var record = grid.getSelectionModel().getSelection()[0].data;
        var userComboBox = window.down('#facultyCodeItemId');
        var serviceRequestId = record.ID;
        var userComboBoxValue = userComboBox.getValue();
        if (!isNullOrEmpty(serviceRequestId) && !isNullOrEmpty(userComboBoxValue)) {
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.PATH_SAVE_RE_ASSIGN_SERVICE_REQUEST + '?userId=' + userComboBoxValue + '&serviceRequestId=' + serviceRequestId,
                method: 'POST',
                success: function (response, action) {
                    if (!isNullOrEmpty(response.responseText)) {
                        Ext.getBody().unmask();
                        showSuccessMessage(getCommonTranslation('SERVICE_REQUEST_ASSIGNEE_CHANGED'), getCommonTranslation('SUCCESS'));
                        grid.getSelectionModel().deselectAll();
                        grid.getStore().reload();
                        window.close();
                    }
                }
            });
        }
    },
    submitEscalateDetailsRecords: function (approvalDetailsArray, records) {
        var this$ = this;
        var url = SERVERURL.PATH_APPROVE_REJECT_MULTIPLE_TERMINATION_STUDENT_REQUESTS;
        var map = Academia.view.servicerequest.ServiceRequestViewMap;
        var requestTypeName = records[0].data.REQUEST_TYPE;
        if (requestTypeName == 'Withdraw from program' || requestTypeName == 'Leave of absence' || requestTypeName == 'Program transfer' || requestTypeName == 'Course transfer' || requestTypeName == 'Leave Request' || requestTypeName == 'Exchange semester' || requestTypeName == 'Student transfer') {
            requestTypeName = 'STUDENT_REQUEST';
        }
        if (requestTypeName == 'Termination request') {
            requestTypeName = 'TERMINATION_REQUEST';
        }
        if (requestTypeName == 'Debarment request') {
            requestTypeName = 'DEBRAMENT_REQUEST';
        }
        var requestTypeId = records[0].data.REQUEST_TYPE_ID;
        var serviceRequestSetting = this.getStudentServiceRequestSettings(requestTypeId, SERVERURL.FIND_REQUEST_TYPE_ID, requestTypeName);
        var obj = new Object();
        obj.approvalDetailList = approvalDetailsArray;
        obj.serviceRequestSetting = serviceRequestSetting;
        var submitData = Ext.encode(obj);
        if (obj.approvalDetailList[0].remarks == 'Auto Reject') {
            var formWindow = this$.getRejectionrequestclosurewin();
            if (!formWindow) {
                Ext.widget('rejectionrequestclosurewin', {
                    submitData: submitData
                });
                formWindow = this$.getRejectionrequestclosurewin();
            }
            formWindow.show();
        } else {
            showConfirmMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('CONFIRM_FOR_APPROVE'), function (btn, text) {
                if (btn == 'yes') {
                    this$.sendSaveAjaxRequest(url, 'POST', submitData, function (opt, success, response) {
                        if (success) {
                            showSuccessMessage(getProgramandcourseTranslation('SERVICE_REQUEST'), getCommonTranslation('SUCCESS'));
                            Ext.getBody().unmask();
                        }
                    });
                    this$.loadStudentGridAndSearchRequest();
                }
            });
        }
    },
    onrejectWinBtnClick: function (btn) {
        var me = this;
        var url = SERVERURL.PATH_APPROVE_REJECT_MULTIPLE_TERMINATION_STUDENT_REQUESTS;
        var win = btn.up('window');
        var submitData = Ext.decode(win.submitData);
        var rejectionReason = win.down('#comment').getValue();
        var approvalDetailList = submitData.approvalDetailList;
        var newListAr = [];
        Ext.each(approvalDetailList, function (approvalDetailListItem) {
            approvalDetailListItem.remarks = rejectionReason;
            newListAr.push(approvalDetailListItem);
        });
        submitData.approvalDetailList = newListAr;
        var submitDataString = Ext.encode(submitData);
        me.sendSaveAjaxRequest(url, 'POST', submitDataString, function (opt, success, response) {
            if (success) {
                showSuccessMessage(getProgramandcourseTranslation('SERVICE_REQUEST'), getCommonTranslation('SUCCESS'));
                Ext.getBody().unmask();
                win.close();
            }
        });
        me.loadStudentGridAndSearchRequest();
    },
    submitExecutionDetailsForm: function (button) {
        var this$ = this;
        var executionTab = this$.getContentPanelActiveTab();
        var serviceRequestId = executionTab.getServiceRequestId();
        var isTransferRelatedProgram = null;
        if (!isNullOrEmpty(this$.getSectionrequestdetailspanel())) {
            isTransferRelatedProgram = this$.getSectionrequestdetailspanel().getForm().findField('isTransferRelatedProgram').getValue();
        }
        var user = this$.getCurrentlyLoggedInUser();
        var url;
        var formData;
        var sectionTransferFlag = false;
        if (button.itemId === 'certificateSubmitBtn') {
            var certificatForm = this$.getExecutionDetails();
            formData = certificatForm.getValues();
            url = SERVERURL.CERTIFICATE_EXECUTION_SAVE;
            var requestType = executionTab.getRequestType();
            var requestGroup = executionTab.getRequestGroup();
            if (requestType == "STUDENT_REQUEST" && requestGroup == "LEAVE") {
                if (!isNullOrEmpty(executionTab.config.requestTypeCode) && executionTab.config.requestTypeCode == "LR") {
                    url = SERVERURL.SAVE_LEAVE_EXECUTION;
                }
            } else if (requestType == "STUDENT_REQUEST" && requestGroup == "HOSTEL_LEAVE") {
                url = SERVERURL.PATH_SAVE_HOSTEL_SERVICE_EXECUTION;
            }
        } else if (button.itemId === 'studentTransferExecutionSubmitBtn') {
            var form = this$.getStudentTransferExecutionDetails();
            formData = form.getForm().getFieldValues();
            var studenttransferexecutiondocumentgrid = this$.getStudenttransferexecutiondocumentgrid();
            var studenttransferexecutiondocumentgridStore = studenttransferexecutiondocumentgrid.getStore();
            var docArray = [];
            try {
                if (studenttransferexecutiondocumentgridStore.data.items != null && studenttransferexecutiondocumentgridStore.data.items.length > 0) {
                    Ext.each(studenttransferexecutiondocumentgridStore.data.items, function (val) {
                        var newData = {
                            "name": val.data.documentName,
                            "path": val.data.path,
                            "type": "DOCUMENT",
                            "createdBy": this$.getIdValueJson(val.data.createdBy.id, val.data.createdBy.value)
                        };
                        var document = new Object();
                        document.document = newData;
                        document.isExecutionDocument = true;
                        docArray.push(document);
                    });
                }
                formData.documents = docArray;
            } catch (err) {}
            delete formData.userId;
            delete formData.displayCheckFeesAndDocMsg;
            url = SERVERURL.SAVE_STUDENT_TRANSFER_EXECUTION;
        } else if (button.itemId === 'schoolLeavingExecutionSubmitBtn') {
            var schoolLeavingForm = this$.getSchoolLeavingExecutionDetails();
            formData = schoolLeavingForm.getForm().getFieldValues();
            var schoolleavingexecutiondocumentgrid = this$.getSchoolleavingexecutiondocumentgrid();
            var schoolleavingexecutiondocumentgridStore = schoolleavingexecutiondocumentgrid.getStore();
            var docArray = [];
            try {
                if (schoolleavingexecutiondocumentgridStore.data.items != null && schoolleavingexecutiondocumentgridStore.data.items.length > 0) {
                    Ext.each(schoolleavingexecutiondocumentgridStore.data.items, function (val) {
                        var newData = {
                            "name": val.data.documentName,
                            "path": val.data.path,
                            "type": "DOCUMENT",
                            "createdBy": this$.getIdValueJson(val.data.createdBy.id, val.data.createdBy.value)
                        };
                        var document = new Object();
                        document.document = newData;
                        document.isExecutionDocument = true;
                        docArray.push(document);
                    });
                }
                formData.documents = docArray;
            } catch (err) {}
            delete formData.userId;
            delete formData.displayCheckFeesAndDocMsg;
            url = SERVERURL.PATH_SAVE_EXECUTION_DETAIL_SCHOOL_LEAVING_REQUEST;
        } else {
            var form = this$.getExecutionDetailsPanel();
            formData = form.getValues();
            url = this.getExecutionDetailsSaveUrl(formData.requestType);
            if (formData.requestType == 'FEE_RELATED') {
                delete formData.waiverAmountApproved;
                delete formData.discountCode;
                delete formData.discountType;
            } else if (formData.requestType == 'SECTION_TRANSFER') {
                sectionTransferFlag = true;
                delete formData.requestType;
                delete formData.customData;
            } else {
                delete formData.requestType;
                delete formData.customData;
            }
        }
        formData.serviceRequestId = serviceRequestId;
        formData.user = user;
        formData.isCalculateSeparateCGPAndSGPA = formData.isCalculateSeparateCGPAndSGPA;
        delete formData.totalRecordDisplayField;
        if (url == SERVERURL.SAVE_TERMINATION_EXECUTION) {
            var jsonFormatFormData = [formData];
        } else if (url == SERVERURL.SAVE_PROGRAM_TRANSFER_EXECUTION) {
            var jsonFormatFormData = [formData];
        } else if (url == SERVERURL.LEAVE_OF_ABSENCE_SR) {
            var jsonFormatFormData = [formData];
        } else if (url == SERVERURL.SAVE_PROGRAM_WITHDRAWAL_EXECUTION) {
            var jsonFormatFormData = [formData];
        }else if(executionTab.requestGroup == 'READMISSION'){
        	url=SERVERURL.SAVE_READMISSION_EXECUTION;
        	delete formData.isRetainData;
        	delete formData.admissionDate;
        	delete formData.isCalculateSeparateCGPAndSGPA;
        	 if(formData.readmissionOutcomeIds && formData.readmissionOutcomeIds.length > 0){
     			try{
     				formData.readmissionOutcomeIds = Ext.Array.pluck(Ext.Array.pluck(formData.readmissionOutcomeIds, 'data'), 'id').join();
     			} catch(e) {
     				formData.readmissionOutcomeIds = formData.readmissionOutcomeIds.join();
     			}
     		}else if(formData.readmissionOutcomeIds){
     			formData.readmissionOutcomeIds = formData.readmissionOutcomeIds;
     		}
             
        	//formData.readmissionOutcomeIds=Ext.Array.pluck(Ext.Array.pluck(formData.readmissionOutcomeIds, 'data'), 'id').join();
          
        	var jsonFormatFormData = Ext.encode(formData);
        }else {
            var jsonFormatFormData = Ext.encode(formData);
        }
        
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        this$.sendSaveAjaxRequest(url, 'POST', jsonFormatFormData, function (opt, success, response) {
            Ext.getBody().unmask();
            if (success) {
                if (sectionTransferFlag) {
                    var MSSG = response.responseText;
                    if (MSSG == "seat capacity full") {
                        showWarningMessage(getCourseTxCommonTranslation('SECTION'), getCourseTxCommonTranslation('CAPACITY_FULL_MSSG'));
                    } else if (MSSG == "SUCCESS") {
                        showSuccessMessage(getServiceRequestTranslation('EXECUTION_DETAILS'), getServiceRequestTranslation('EXECUTION_DETAILS_SUCCESS'));
                        this$.loadStudentGridAndSearchRequest();
                    } else if (isTransferRelatedProgram && MSSG == "ATTENDANCE_OR_HW_EXIST") {
                        showWarningMessage(getCourseTxCommonTranslation('SECTION'), getCourseTxCommonTranslation('ATTENDANCE_OR_HW_EXIST'));
                    } else if (MSSG == "Failure") {
                        showErrorMessage(getCourseTxCommonTranslation('SECTION'), getCourseTxCommonTranslation('Section Transfer Service Request Failure'));
                    } else if (response.responseText.split("-")[0] == "SECTION_CAPACITY") {
                        var courseVariantValue = this$.getSectionrequestdetailspanel().down('#toSectionForCourse').getRawValue();
                        showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ENROLLMENT_SECTION_CAPACITY') + courseVariantValue + " is " + response.responseText.split("-")[1]);
                    } else if (response.responseText.split("-")[0] == "PERIOD_SECTION_CAPACITY") {
                        var programValue = this$.getSectionrequestdetailspanel().down('#ProgramId').getRawValue();
                        var batchValue = this$.getSectionrequestdetailspanel().down('#batchId').getRawValue();
                        var courseVariantValue = this$.getSectionrequestdetailspanel().down('#toSectionForCourse').getRawValue();
                        showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('ENROLLMENT_SECTION_CAPACITY') + programValue + " " + batchValue + " in " + courseVariantValue + " is " + response.responseText.split("-")[1]);
                    }
                } else {
                    if ((executionTab.getRequestType() == "TERMINATION_REQUEST" || executionTab.getRequestType() == "STUDENT_REQUEST") && response && response.responseText && response.responseText.indexOf("complete_completion_process") != -1) {
                        var responseArray = response.responseText.split('</br>');
                        var msg = 'Complete completion setting for ';
                        var idArray = [];
                        Ext.each(responseArray, function (currentResp) {
                            var currentId = currentResp.replace('complete_completion_process for ', '');
                            if (currentId != "") {
                                idArray.push(currentId);
                            }
                        });
                        msg = msg + idArray.join(" and ");
                        showWarningMessage(getCommonTranslation('CLOSE_REQUEST'), msg);
                    } else {
                        showSuccessMessage(getServiceRequestTranslation('EXECUTION_DETAILS'), getServiceRequestTranslation('EXECUTION_DETAILS_SUCCESS'));
                        if (executionTab.getRequestType() === 'STUDENT_REQUEST' || executionTab.getRequestType() === 'TERMINATION_REQUEST' || executionTab.getRequestType() === 'TRANSFER_REQUEST' || executionTab.getRequestType() === 'DEBRAMENT_REQUEST' || executionTab.getRequestType() === 'FEE_RELATED_REQUEST') {
                            this$.loadStudentGridAndSearchRequest();
                        } else if (executionTab.getRequestType() === 'FACULTY_REQUEST') {
                            this$.loadFacultyGridAndSearchRequest();
                        } else if (formData.requestType === 'COMPLAINT' || formData.requestType === 'Complaint') {
                            this$.loadComplaintGridAndSearchRequest();
                        }
                    }
                }
                this$.closeTab(executionTab);
            }
        });
        if (formData.requestType == 'FEE_RELATED') {
            var feeGrid = this$.getFeerequestservice();
            var record = feeGrid.selModel.getSelection();
            if (record.length > 0) {
                this$.getUpdateFeeRequestGrid(record);
            }
        }
    },
    printCertificate: function (button) {
        var $this = this;
        var requestGroup = this.getContentPanelActiveTab().getRequestGroup();
        var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
        if (requestGroup == 'HOSTEL_LEAVE') {
            $this.showStudentBulkPrintWin(requestGroup);
        } else if (requestGroup == 'LEAVE' && !isNullOrEmpty(requestTypeCode) && requestTypeCode == "LR") {
            $this.showStudentBulkPrintWin(requestGroup);
        } else {
            var serviceRequestId = this.getContentPanelActiveTab().getServiceRequestId();
            var csvForm = Ext.create('Ext.form.Panel', {
                items: [{
                    xtype: 'textfield',
                    itemId: 'dynamicDocumentRequestContent',
                    name: 'dynamicDocumentRequestContent'
                }]
            });
            var parameterListObj = new Object();
            parameterListObj = serviceRequestId;
            var csvForm = Ext.create('Ext.form.Panel', {
                items: [{
                    xtype: 'textfield',
                    maxLength: 20480,
                    itemId: 'dynamicDocumentRequestContent',
                    name: 'dynamicDocumentRequestContent'
                }]
            });
            csvForm.down('#dynamicDocumentRequestContent').setValue(Ext.encode(parameterListObj));
            Ext.Ajax.request({
                type: 'rest',
                method: 'POST',
                url: SERVERURL.PRINT_CERTIFICATE,
                standardSubmit: true,
                params: {
                    access_token: Ext.Ajax.defaultHeaders.access_token,
                    dynamicDocumentRequestContent: parameterListObj
                },
                success: function (response) {
                    if (response) {
                        csvForm.getForm().submit({
                            target: 'download_frame',
                            method: 'POST',
                            params: {
                                access_token: Ext.Ajax.defaultHeaders.access_token
                            },
                            headers: {
                                'Accept': 'application/pdf',
                                'Content-Type': 'application/json',
                                'Authorization': Ext.Ajax.defaultHeaders.Authorization
                            },
                            url: SERVERURL.PRINT_CERTIFICATE,
                            standardSubmit: true
                        });
                    }
                },
                failure: function (response, action) {
                    showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('documenttemplate_conf_not_configured'));
                }
            });
        }
    },
    showStudentBulkPrintWin: function (requestGroup) {
        var $this = this;
        var formWindow = $this.getPrintcertificatehostelwidow();
        if (!formWindow) {
            Ext.widget('printcertificatehostelwidow');
            formWindow = $this.getPrintcertificatehostelwidow();
        }
        formWindow.show();
        var form = $this.getPrintcertificatehostelwidow();
        var templateNameField = form.down("#templateNameStudent");
        var store = templateNameField.getStore();
        var academyLocationId = $this.getCurrentAcademyLocation();
        if (requestGroup == "HOSTEL_LEAVE") {
            store.getProxy().extraParams = {
                certificateCategory: "HOSTEL_LEAVE",
                academyLocationId: academyLocationId
            };
        } else {
            store.getProxy().extraParams = {
                certificateCategory: "LEAVE",
                academyLocationId: academyLocationId
            };
        }
        store.load();
    },
    validateHandoverDate: function (dateField) {
        var serviceRequestPanel = dateField.up("servicerequestpanel");
        var basicdetails = serviceRequestPanel.down("basicdetails");
        var requestDate = basicdetails.down("#RequestDate").getValue();
        dateField.up("certificateexecutiondetailspanel").down("#executionDateId").setMinValue(requestDate);
    },
    getUpdateFeeRequestGrid: function (record) {
        var this$ = this;
        var store = null;
        var category = record[0].get("category");
        var feerequestGrid = this$.getFeerequestservice().getSelectionModel();
        var myJsonData = [];
        if (category == 'FEE_CONCESSION') {
            if (record.length > 0) {
                for (var i in record) {
                    myJsonData.push({
                        "feeRelatedReqestDetailId": record[i].get("id"),
                        "approvedAmount": record[i].get("waiverAmountApproved"),
                        "serviceRequestId": record[i].get("serviceRequestId"),
                        "discountCodeId": record[i].get("discountCodeId"),
                        "discountType": record[i].get("discountType")
                    });
                }
            }
        } else {
            store = this$.getStore('feeandpayment.feerequest.TempInstallmentStore');
            var gridData = store.getRange();
            var installmentJson = [];
            if (gridData.length > 0) {
                for (var i in gridData) {
                    installmentJson.push({
                        "id": gridData[i].get("id"),
                        "installmentDueDate": Ext.Date.format(new Date(gridData[i].get("installmentDueDate")), CONSTANTS.DATE_FORMAT),
                        "amount": gridData[i].get("amount"),
                        "feeRelatedRequestDetail": this$.getIdValueJson(gridData[i].get("feeRelatedRequestDetail").id, null, null),
                        "status": 'APPROVED'
                    });
                }
            }
            for (var i in record) {
                myJsonData.push({
                    "feeRelatedReqestDetailId": record[0].get("id"),
                    "approvedAmount": record[0].get("waiverAmountApproved"),
                    "serviceRequestId": record[0].get("serviceRequestId"),
                    "discountCodeId": record[i].get("discountCodeId"),
                    "discountType": record[i].get("discountType"),
                    "installmentDetails": installmentJson
                });
            }
        }
        this$.sendSaveAjaxRequest(SERVERURL.FEE_RELATED_SERVICE_REQUEST_UPDATE, 'POST', myJsonData, function (opt, success, response) {
            if (success) {
                if (category == 'INSTALLMENT') {
                    store.removeAll();
                }
                feerequestGrid.setLocked(false);
            }
        });
    },
    getExecutionDetailsSaveUrl: function (requestType) {
        var url = '';
        switch (requestType) {
        case 'FREE_FORM':
        case 'Free Form':
        case 'GENERAL':
            {
                url = SERVERURL.SAVE_FREEFORM_EXECUTION;
                break;
            }
        case 'TRANSFER':
        case 'Transfer':
            {
                url = SERVERURL.SAVE_TRANSFER_EXECUTION;
                break;
            }
        case 'DEBARMENT':
        case 'Debarment':
            {
                url = SERVERURL.STUDENT_DEBARMENT_EXECUTION;
                break;
            }
        case 'PROGRAM_TRANSFER':
        case 'Program Transfer':
            {
                url = SERVERURL.SAVE_PROGRAM_TRANSFER_EXECUTION;
                break;
            }
        case 'PROGRAM_WITHDRAWAL':
        case 'Program Withdrawal':
            {
                url = SERVERURL.SAVE_PROGRAM_WITHDRAWAL_EXECUTION;
                break;
            }
        case 'EMPLOYEELEAVE':
        case 'Employee Leave':
        case 'Employeeleave':
            {
                url = SERVERURL.EMPLOYEE_LEAVE_REQUEST_PATH_SAVE_EXECUTION;
                break;
            }
        case 'LEAVE':
        case 'Leave':
            {
                url = SERVERURL.SAVE_LEAVE_EXECUTION;
                break;
            }
        case 'SCHOLARSHIP':
        case 'Scholarship':
            {
                url = SERVERURL.SAVE_SCHOLARSHIP_EXECUTION;
                break;
            }
        case 'PERSONAL_DATA_CHANGE':
        case 'Personal Data Change':
            {
                url = SERVERURL.SAVE_PERSONAL_DATA_CHANGE_EXECUTION;
                break;
            }
        case 'TERMINATION':
        case 'Termination':
            {
                url = SERVERURL.SAVE_TERMINATION_EXECUTION;
                break;
            }
        case 'COURSE_TRANSFER':
        case 'Course Transfer':
            {
                url = SERVERURL.SAVE_COURSE_TRANSFER_EXECUTION;
                break;
            }
        case 'COURSE_WITHDRAWAL':
        case 'Course Withdrawal':
            {
                url = SERVERURL.SAVE_COURSE_WITHDRAWAL_EXECUTION;
                break;
            }
        case 'FEE_RELATED':
        case 'Fee Related':
            {
                url = SERVERURL.SAVE_FEE_RELATED_EXECUTION;
                break;
            }
        case 'COMPLAINT':
        case 'Complaint':
        case 'Grievance':
            {
                url = SERVERURL.SAVE_COMPLAINT_EXECUTION;
                break;
            }
        case 'PLACEMENT':
        case 'Placement':
            {
                url = SERVERURL.SAVE_PLACEMENT_EXECUTION;
                break;
            }
        case 'CHANGE_EXAM_DATE':
            {
                url = SERVERURL.SAVE_CHANGE_EXAM_DATE_EXECUTION;
                break;
            }
        case 'CHANGE_EXAM_CENTRE':
            {
                url = SERVERURL.SAVE_CHANGE_EXAM_CENTRE_EXECUTION;
                break;
            }
        case 'EXAM_WITHDRAWAL':
            {
                url = SERVERURL.SAVE_EXAM_WITHDRAWAL_EXECUTION;
                break;
            }
        case 'EXAM_LEAVE':
            {
                url = SERVERURL.SAVE_EXAM_LEAVE_EXECUTION;
                break;
            }
        case 'LACK_OF_OTHER_CRITERIA':
            {
                url = SERVERURL.SAVE_LACK_OF_OTHER_CRITERIA_EXECUTION;
                break;
            }
        case 'RE_EXAM':
            {
                url = SERVERURL.SAVE_RE_EXAM_EXECUTION;
                break;
            }
        case 'REVALUATION_EXAM_PAPER':
            {
                url = SERVERURL.SAVE_REVALUATION_OF_EXAM_EXECUTION;
                break;
            }
        case 'SERVICE_SUBSCRIBE_WITHDRAW':
        case 'Service Subscribe Withdraw':
            {
                url = SERVERURL.SAVE_WITHDRAW_SUBSCRIB_EXECUTION;
                break;
            }
        case 'LACK_OF_ATTENDANCE':
            {
                url = SERVERURL.SAVE_LACK_OF_ATTENDANCE_EXECUTION;
                break;
            }
        case 'SECTION_TRANSFER':
        case 'Section Transfer':
            {
                url = SERVERURL.SAVE_SECTION_TRANSFER_EXECUTION;
                break;
            }
        case 'STUDENT_TRANSFER':
            {
                url = SERVERURL.SAVE_STUDENT_TRANSFER_EXECUTION;
                break;
            }
        case 'HOSTEL_LEAVE':
            {
                url = SERVERURL.PATH_SAVE_HOSTEL_SERVICE_EXECUTION;
                break;
            }
        case 'EXAM_RELATED':
            {
                url = SERVERURL.PATH_SAVE_HOSTEL_SERVICE_EXECUTION;
                break;
            }
        case 'EXAM_CONCESSION':
            {
                url = SERVERURL.EXECUTION_EXAM_CONCESSION_SR;
                break;
            }
        case 'LEAVE_OF_ABSENCE':
            {
                url = SERVERURL.LEAVE_OF_ABSENCE_SR;
                break;
            }
        case 'EXCHANGE_SEMESTER':
            {
                url = SERVERURL.EXCHANGE_SEMESTER_SR;
                break;
            }
        }
        return url;
    },
    /* ------ Approval details Functionality END------------ */
    /**
     * This method is use to set the logged in user name to the
     * user field of the forms
     */
    setUserForExecution: function (form, data, isExecution) {
        var $this = this;
        var followUpDetails = data.followupDetails;
        var approvalDetails = data.approvalDetails;
		if(!isNullOrEmpty(data.detail) && !isNullOrEmpty(data.detail.isLeaveOverride) && !isNullOrEmpty(form.down('#isLeaveOverride'))){
		form.down('#isLeaveOverride').setValue(data.detail.isLeaveOverride);
		}
        if (isExecution) {
            if (isEmpty(approvalDetails)) {
                Ext.each(followUpDetails, function (detail) {
                    if (detail.whetherLatest) {
                        if (!isNullOrEmpty(detail.approver)) {
                            form.down('#user').setValue(detail.approver.value);
                        }
                    }
                });
            } else {
                Ext.each(approvalDetails, function (detail) {
                    if (detail.whetherLatest) {
                        if (isNullOrEmpty(detail.escalatedApprover)) {
                            form.down('#user').setValue(detail.user.value);
                        } else {
                            var loggedInUser = $this.getCurrentlyLoggedInUser().value;
                            form.down('#user').setValue(loggedInUser);
                        }
                    }
                });
            }
        } else {
            Ext.each(followUpDetails, function (detail) {
                if (detail.whetherLatest) {
                    if (!isNullOrEmpty(detail.assignee)) {
                        form.down('#user').setValue(detail.assignee.value);
                    } else {
                        form.down('#user').setValue(detail.approver.value);
                    }
                }
            });
        }
    },
    /**
     * This method is use to load the store on selection of
     * certificate category
     */
    loadCertificateType: function (combo, value) {
        var certificateTypeCmb = combo.up('form').down('#certificateRequestCertificateTypesId');
        var courseCertificateCombo = combo.up('form').down('#courseCertificateItemId');
        var communityCertificatesCombo = combo.up('form').down('#communityCertificateId');
        var instructionBox = combo.up('form').down('basicdetails').down('#instructionsReqItemId');
        if (value === 'PROGRAM' || value === 'OTHER') {
            communityCertificatesCombo.setVisible(false);
            communityCertificatesCombo.setDisabled(true);
            courseCertificateCombo.setVisible(false);
            courseCertificateCombo.setDisabled(true);
        }
        var store = certificateTypeCmb.getStore();
        var portalId = this$.getCurrentLoggedPortalId();
        if (!isNullOrEmpty(this.getActiveTabfromContentPanel().getProgram())) {
            programId = this.getActiveTabfromContentPanel().getProgram().id;
            store.getProxy().extraParams = {
                serviceRequestCategory: this.getServiceRequestCategory(),
                academyLocationId: this.getCurrentAcademyLocation(),
                certificateCategory: value,
                portalId: portalId,
                programId: programId
            };
        } else {
            store.getProxy().extraParams = {
                serviceRequestCategory: this.getServiceRequestCategory(),
                academyLocationId: this.getCurrentAcademyLocation(),
                certificateCategory: value,
                portalId: portalId,
            };
        }
        store.removeAll();
        certificateTypeCmb.clearValue();
        store.load();
        var requestType = this.getContentPanelActiveTab().getRequestType();
        if (value === 'COURSES') {
            courseCertificateCombo.setVisible(true);
            courseCertificateCombo.setDisabled(false);
            communityCertificatesCombo.setVisible(false);
            communityCertificatesCombo.setDisabled(true);
            this.loadCertificateForCategory(courseCertificateCombo);
        } else if (value === 'COMMUNITY') {
            communityCertificatesCombo.setVisible(true);
            communityCertificatesCombo.setDisabled(false);
            courseCertificateCombo.setVisible(false);
            courseCertificateCombo.setDisabled(true);
            this.loadCertificateForCategory(communityCertificatesCombo);
        }
    },
    loadCertificateForCategory: function (combo) {
        var requestType = this.getContentPanelActiveTab().getRequestType();
        var portalId = this.getCurrentLoggedPortalId();
        var url = null;
        var store = combo.getStore();
        var params = null;
        if (requestType == 'FACULTY_REQUEST') {
            var itemId = combo.getItemId();
            if (itemId === 'courseCertificateItemId') {
                url = SERVERURL.COURSES_FOR_FACULTY;
                params = {
                    facultyId: this.getContentPanelActiveTab().getRequesterId()
                };
            } else {
                url = SERVERURL.FIND_ALL_COMMUNITY;
            }
            store.getProxy().api.read = url;
            store.load({
                params: params
            });
        } else {
        	if(!isNullOrEmpty(portalId) && portalId==1) {
        	store.load({
                params: {
                	admissionId: this.getContentPanelActiveTab().getAdmissionId()
                }
            });
        	} else {
            store.load({
                params: {
                    admissionId: this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id
                }
            });
        	}
        }
    },
    toggleTextField: function (radio, value) {
        var field = radio.up('fieldcontainer').down('textfield');
        if (value.isOriginal === false) {
            field.setVisible(true);
            field.setDisabled(false);
        } else {
            field.setVisible(false);
            field.setDisabled(true);
        }
    },
    saveCertificateRequest: function (button) {
        var form = button.up('form');
        var values = form.getValues();
        delete values.certificateTypes;
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        delete values.academicTermProgramWithdrwan;
        values.assignee = this.getContentPanelActiveTab().getAssignee();
        values.admissionId = this.getContentPanelActiveTab().getAdmissionId();
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    saveHostelLeaveRequest: function (button) {
        var form = button.up('form');
        var values = form.getValues();
        delete values.certificateCategory;
        delete values.certificateId;
        delete values.certificateTypes;
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        values.assignee = this.getContentPanelActiveTab().getAssignee();
        values.admissionId = this.getContentPanelActiveTab().getAdmissionId();
        if (!isNullOrEmpty(values.fromTime) && !isNullOrEmpty(values.toTime)) {
            values.fromTime = values.fromDate + " " + values.fromTime;
            values.toTime = values.toDate + " " + values.toTime;
        }
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    // Flag is for multiple values delete or not to delete
    createServiceRequestJson: function (requestDetail, documentData, voluntaryDocument, flag, id) {
        /* V2D-27897 */
        var this$ = this;
        var loggedInUser = this.getCurrentlyLoggedInUser();
        var loggedInPortal = this$.getCurrentLoggedPortalId();
        var requestObject = new Object();
        requestObject.id = null;
        requestObject.version = 0;
        requestObject.enteredBy = {
            id: loggedInUser.id
        };
        requestObject.requesterType = requestDetail.requesterType;
        /* V2D-27897 */
        if (loggedInPortal == 7) {
            var studentId = this$.getCurrentlyLoggedInUserInfoForPortal();
            var requester = {
                id: studentId.student.id,
                code: studentId.student.code
            }
            requestObject.requester = requester;
            var parentsId = {
                id: loggedInUser.id
            }
            if (id == 49) {
                requestObject.parentsId = parentsId
            }
        } else {
            requestObject.requester = requestDetail.requester;
            if (id == 49) {
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.PATH_FIND_FATHER_BY_USERID,
                    params: {
                        userId: requestDetail.requester.id
                    },
                    method: 'GET',
                    async: false,
                    success: function (data, action) {
                        var parentId = Ext.JSON.decode(data.responseText);
                        var parentsId = {
                            id: parentId
                        }
                        if (parentId > 0) {
                            requestObject.parentsId = parentsId
                        }
                    }
                });
            }
        }
        requestObject.requestDate = requestDetail.requestDate;
        requestObject.remarks = requestDetail.remarks;
        if (Ext.isDefined(requestDetail.comment)) {
            requestObject.comment = requestDetail.comment;
        }
        requestObject.isWithdrawn = false;
        var defaultAssigneeTemp = this.getContentPanelActiveTab().serviceRequestSetting.defaultAssignee;
        if(isNullOrEmpty(defaultAssigneeTemp)) {
        	defaultAssigneeTemp = null;
        }
        requestObject.serviceRequestSetting = {
            id: this.getContentPanelActiveTab().getSettingId(),
            defaultAssignee: defaultAssigneeTemp,
            defaultApprover: this.getContentPanelActiveTab().serviceRequestSetting.defaultApprover
        }, requestObject.documents = documentData;
        requestObject.voluntaryDocuments = voluntaryDocument;
        requestObject.followupDetails = null;
        requestObject.approvalDetails = null;
        if (flag == undefined || isNullOrEmpty(flag)) {
            delete requestDetail.requesterType;
            delete requestDetail.requester;
            delete requestDetail.requestDate;
            delete requestDetail.remarks;
            if (Ext.isDefined(requestDetail.comment)) {
                delete requestDetail.comment;
            }
        }
        requestObject.certificateRequestDetail = requestDetail;
        requestObject.executionDetail = null;
        requestObject.feeDetail = null;
        return requestObject;
    },
    /**
     * This method is used to set the amount on selection of scholarship
     */
    setAmount: function (combo) {
        var form = combo.up('form');
        var amount = combo.valueModels[0].raw.amount;
        form.down("#amount").setValue(amount);
    },
    /**
     * This method is used to save Scholarship Request on click of submit button
     *
     * @param button
     */
    saveScholarshipRequest: function (button) {
        var form = button.up('form');
        var values = form.getValues();
        delete values.Documents;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.serviceRequest = null;
        delete values.requestStatusId;
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    /**
     * This method is used to load follow up status combo store
     *
     * @param cmb reference of combo
     */
    loadComboStore: function (cmb) {
        var store = cmb.getStore();
        var tab = this.getContentPanelActiveTab();
        var serviceRequestSettingId = tab.getSettingId();
        store.on('beforeload', function () {
            store.getProxy().extraParams = {
                serviceRequestSettingId: serviceRequestSettingId
            };
        }, this);
    },
    /**
     * This method is used to load complaint follow up status combo store
     *
     * @param cmb reference of combo
     */
    loadComplaintComboStore: function (cmb) {
        var store = cmb.getStore();
        var tab = this.getContentPanelActiveTab();
        var complaintTypeSettingId = tab.getSettingId();
        store.on('beforeload', function () {
            store.getProxy().extraParams = {
                complaintTypeSettingId: complaintTypeSettingId
            };
        }, this);
    },
    /**
     * This method is use to set the plnned follow up date field
     * in follow up details panel
     *
     * @param window follow details panel window
     */
    setPlannedDateForFollowup: function (window) {
        var $this = this;
        var data = this.getContentPanelActiveTab().getResponseData();
        var form = window.down('form');
        var plannedDate = form.down('#plannedFollowupDate');
        form.down('#user').setValue(this.getCurrentlyLoggedInUser().value);
        plannedDate = form.getForm().findField("plannedFollowupDate");
        if (isEmpty(data.followupDetails)) {
            plannedDate.setValue(dateRender(data.requestDate));
        } else {
            Ext.each(data.followupDetails, function (detail) {
                if (detail.whetherLatest) {
                    plannedDate.setValue(dateRender(detail.nextFollowupDate));
                }
            });
        }
        if (data.serviceRequestSetting) {
            if (data.serviceRequestSetting.isAutoApprove) {
                form.down('#isAutoApprove').setValue(true);
                form.down('#approverID').setVisible(false);
                form.down('#approverID').setDisabled(true);
            } else {
                var refDefaultApprover = form.down('#approverID');
                var approverStore = refDefaultApprover.getStore();
                approverStore.load({
                    callback: function () {
                        if (!isNullOrEmpty(data.serviceRequestSetting.defaultApprover)) {
                            refDefaultApprover.setValue(data.serviceRequestSetting.defaultApprover.id);
                        }
                        if (!isNullOrEmpty(data.serviceRequestSetting.defaultApprover)) {
                            refDefaultApprover.setValue(data.serviceRequestSetting.defaultApprover.id);
                        }
                    }
                });
            }
        }
        var fp_version_field = form.down('#fp_version_field');
        if (!isNullOrEmpty(fp_version_field)) {
            fp_version_field.setValue(data.id);
            var requestId = fp_version_field.getValue();
            if (fp_version_field && !isNullOrEmpty(data.serviceRequestSetting) && !isNullOrEmpty(data.serviceRequestSetting.requestType) && data.serviceRequestSetting.requestType.value == "Student Transfer") {
                var acadCombo = form.down('#academyLocationItemId');
                if (acadCombo != undefined || acadCombo != null) {
                    var store = acadCombo.getStore();
                    store.getProxy().extraParams = {
                        requestId: requestId
                    };
                    store.load({
                        callback: function (records) {
                            acadCombo.bindStore(store);
                        }
                    });
                }
            }
        }
        if (!isNullOrEmpty(data.complaintTypeSetting) && !isNullOrEmpty(data.complaintTypeSetting.complaintType)) {
            var followUpStatusCombo = form.down('#followUpStatus');
            if(!followUpStatusCombo){
            	followUpStatusCombo=form.down('#complaintFollowUpStatus');
            }
            var extraParam = {
                complaintTypeSettingId: data.complaintTypeSetting.id
            };
            var store = Ext.create('Ext.data.Store', {
                fields: ['id', 'code', 'value'],
                proxy: {
                    type: 'rest',
                    api: {
                        read: SERVERURL.FIND_COMPLAINT_FOLLOW_UP_STATUS
                    },
                    reader: {
                        type: 'json'
                    },
                    extraParams: extraParam
                }
            });
            followUpStatusCombo.bindStore(store);
            store.load();
        }
    },
    /**
     * This method is used to create Scholarship Service Request JSON
     *
     * @param values form values
     * @return JSON object
     */
    createScholarshipServiceRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var tab = this.getContentPanelActiveTab();
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting = serviceRequestSetting;
        object.dueDate = null;
        object.detail = values;
        object.admissionId = tab.getAdmissionId();
        delete object.certificateRequestDetail;
        delete object.executionDetail;
        delete object.detail.leavingTo;
        delete object.detail.schoolLeavingTo
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    /**
     * This method is used to save Scholarship Request on click of submit button
     */
    saveFreeFormRequest: function (button) {
        var me = this;
        var form = button.up('form');
        var values = form.getValues();
        values.assignee = me.getAssignee();
        values.serviceRequestSetting = {
            id: me.getSettingId()
        };
        values.serviceRequest = null;
        values.requester = {
            id: me.getContentPanelActiveTab().getRequesterId()
        };
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    /**
     * This method is used to create Scholarship Service Request JSON
     *
     * @param values form values
     * @return JSON object
     *
     */
    createFreeFormRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting = serviceRequestSetting;
        object.minimumAmount = object.certificateRequestDetail.minimumAmount;
        object.dueDate = null;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.minimumAmount;
        delete object.detail.academicTermProgramWithdrwan;
        delete object.detail.customData;
        return object;
    },
    /**
     * This method is used to set free form serviceREquestSettingID & assignee
     *
     * @param cmb combo reference
     */
    getFreeFormRequestSettings: function (cmb) {
        var me = this;
        var tab = this.getContentPanelActiveTab();
        var assignedTo = cmb.up('form').down('#requestAssignedId');
        var instructions = cmb.up('form').down('#instructionsRaiseItemId');
        var amountField = cmb.up('form').down('#amountItemId');
        var offeredModuleCmb = cmb.up('form').down('#offeredModuleId');
        if (!isNullOrEmpty(amountField)) {
            amountField.allowBlank = true
        }
        var param = {
            serviceRequestCategory: me.getContentPanelActiveTab().getRequestType(),
            academyLocationId: me.getCurrentAcademyLocation(),
            freeFormRequestTypeId: cmb.getValue(),
            personId: me.getContentPanelActiveTab().getRequesterId()
        };
        this.sendGetAjaxRequest(SERVERURL.FIND_FREE_FORM_REQUEST, 'GET', param, function (opt, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                minimumAmount = data.minimumAmount;
                feePlanRuleStage = data.feePlanRuleStage;
                assignedTo.reset();
                if (!isNullOrEmpty(data.defaultAssignee)) {
                    me.setAssignee(data.defaultAssignee);
                    assignedTo.setValue(data.defaultAssignee.value);
                }
                if (data.isAutoAssignee) {
                    assignedTo.setValue('Auto');
                }
                instructions.reset();
                if (!isNullOrEmpty(data.instructions)) {
                    instructions.setValue(data.instructions);
                }
                amountField.reset();
                if (isNullOrEmpty(data.isAllowAmountUpdate) || data.isAllowAmountUpdate == false) {
                    amountField.setReadOnly(true);
                } else {
                    amountField.setReadOnly(false);
                }
                var feeRuleamount;
                if (feePlanRuleStage != null) {
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_FIND_ALL_FEEHEAD_SUM_AMMOUNT_BY_FEEPLANRULE_ID,
                        method: 'GET',
                        params: {
                            feePlanRuleId: data.feePlanRuleStage.id,
                        },
                        success: function (response) {
                            var feeData = Ext.decode(response.responseText);
                            feeRuleamount = feeData.feeAmount;
                            if (!isNullOrEmpty(minimumAmount)) {
                                amountField.setMaxValue(feeRuleamount);
                                amountField.setMinValue(minimumAmount);
                                amountField.setValue(minimumAmount);
                                amountField.allowBlank = false;
                            } else if (!isNullOrEmpty(feePlanRuleStage)) {
                                var data = Ext.decode(response.responseText);
                                amountField.setMaxValue(feeRuleamount);
                                amountField.setMinValue(1);
                                amountField.setValue(feeRuleamount);
                            }
                        }
                    });
                }
                if(data.isOfferedModule)
                {
                	offeredModuleCmb.setFieldLabel(getCommonTranslation('OFFERED_MODULE'));
                	var offeredModuleStore = offeredModuleCmb.getStore();
                	var batchId = me.getContentPanelActiveTab().getProgramBatchId();
                	if(isNullOrEmpty(batchId)){
						batchId = me.getContentPanelActiveTab().getResponseData().detail.batchId;
					}
                	offeredModuleStore.getProxy().extraParams={
                		isOfferedModule:data.isOfferedModule,
                		isEnrolledModule:data.isEnrolledModule,
                		personId:me.getContentPanelActiveTab().getPersonId(),
                		periodId: null,
                		batchId : batchId
                		
                	};
                	offeredModuleStore.load();
                	offeredModuleCmb.setVisible(true);
                	me.setAllowBlank(offeredModuleCmb,false);
                }
                else if(data.isEnrolledModule)
                {
                	offeredModuleCmb.setFieldLabel(getCommonTranslation('ENROLLED_MODULE'));
                	var offeredModuleStore = offeredModuleCmb.getStore();
                	offeredModuleStore.getProxy().extraParams={
                		isOfferedModule:data.isOfferedModule,
                		isEnrolledModule:data.isEnrolledModule,
                		personId:me.getContentPanelActiveTab().getPersonId(),
                		periodId: null
                	};
                	offeredModuleStore.load();
                	offeredModuleCmb.setVisible(true);
                	me.setAllowBlank(offeredModuleCmb,false);
                }
                else
                {
                	offeredModuleCmb.setVisible(false);
                	me.setAllowBlank(offeredModuleCmb,true);
                }
                me.setSettingId(data.id);
                tab.setServiceRequestSetting(data);
            }
        });
    },
    /**
     * This method is used to load sub request type combo of
     * Free Form Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadSubRequestComboStore: function (cmb) {
        var subRequestType = cmb.up('form').down('#subRequestType');
        subRequestType.setDisabled(false);
        subRequestType.reset();
        var offerModuleCombo = cmb.up('form').down('#offeredModuleId');
        offerModuleCombo.setVisible(false);
        offerModuleCombo.reset();
        var store = subRequestType.getStore();
        var portalId = this.getCurrentLoggedPortalId();
        var programId = null;
        if (!isNullOrEmpty(this.getActiveTabfromContentPanel().getProgram())) {
            if (!isNullOrEmpty(this.getActiveTabfromContentPanel().getProgram().id)) {
                programId = this.getActiveTabfromContentPanel().getProgram().id;
            } else if (!isNullOrEmpty(this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails) && !isNullOrEmpty(this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.programId)) {
                programId = this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.programId;
            }
            store.on('beforeload', function () {
                store.getProxy().extraParams = {
                    serviceRequestCategory: this.getContentPanelActiveTab().getRequestType(),
                    academyLocationId: this.getCurrentAcademyLocation(),
                    freeFormRequestCategoryId: cmb.getValue(),
                    portalId: portalId,
                    programId: programId
                };
            }, this);
            store.load();
        } else {
            store.on('beforeload', function () {
                store.getProxy().extraParams = {
                    serviceRequestCategory: this.getContentPanelActiveTab().getRequestType(),
                    academyLocationId: this.getCurrentAcademyLocation(),
                    freeFormRequestCategoryId: cmb.getValue(),
                    portalId: portalId
                };
            }, this);
            store.load();
        }
    },
    /**
     * This method is used to save Employee Leave Request on click of submit button
     */
    saveEmployeeLeaveServiceRequest: function (button) {
        var me = this;
        var form = button.up('form');
        var values = form.getValues();
        values.requester = {
            id: me.getContentPanelActiveTab().getRequesterId()
        };
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    /**
     * This method is used to save Leave Request on click of submit button
     */
    saveLeaveServiceRequest: function (button) {
        var me = this;
        var form = button.up('form');
        var values = form.getValues();
        values.requester = {
            id: me.getContentPanelActiveTab().getRequesterId()
        };
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    /**
     * This method is used to create Leave Service Request JSON
     *
     * @param values form values
     * @return JSON object
     *
     */
    createLeaveRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting = serviceRequestSetting;
        object.dueDate = null;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    /**
     * This method is used to create Employee Leave Service Request JSON
     *
     * @param values form values
     * @return JSON object
     *
     */
    createEmployeeLeaveRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        if (values.leaveTypeId != undefined) {
            if (values.leaveTypeId.length != undefined) {
                var arr = []
                for (var i in values.leaveTypeId) {
                    var object = me.createServiceRequestJson(values, documentData, voluntaryDocument, true);
                    var serviceRequestSetting = values.serviceRequestSetting;
                    object.serviceRequestSetting = serviceRequestSetting;
                    object.dueDate = null;
                    var assignee = {
                        'id': values.assignee.id
                    }
                    var data = {
                        'assignee': assignee,
                        'fromDate': values.fromDate[i],
                        'leaveTypeId': values.leaveTypeId[i],
                        'toDate': values.toDate[i]
                    }
                    object.detail = data;
                    delete object.executionDetail;
                    delete object.certificateRequestDetail;
                    delete object.feeDetail;
                    arr.push(object);
                }
                return arr;
            } else {
                var arr = []
                var object = me.createServiceRequestJson(values, documentData, voluntaryDocument, true);
                var serviceRequestSetting = values.serviceRequestSetting;
                object.serviceRequestSetting = serviceRequestSetting;
                object.dueDate = null;
                var assignee = {
                    'id': values.assignee.id
                }
                var data = {
                    'assignee': assignee,
                    'fromDate': values.fromDate,
                    'leaveTypeId': values.leaveTypeId,
                    'toDate': values.toDate
                }
                object.detail = data;
                delete object.executionDetail;
                delete object.certificateRequestDetail;
                delete object.feeDetail;
                arr.push(object);
                return arr;
            }
        } else {
            var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
            var serviceRequestSetting = values.serviceRequestSetting;
            delete values.serviceRequestSetting;
            object.serviceRequestSetting = serviceRequestSetting;
            object.dueDate = null;
            object.detail = values;
            delete object.executionDetail;
            delete object.certificateRequestDetail;
            delete object.feeDetail;
            delete object.detail.academicTermProgramWithdrwan;
            return object;
        }
    },
    /**
     * This method is use to get the request type for the request
     */
    getServiceRequestCategory: function () {
        return this.getContentPanelActiveTab().getRequestType();
    },
    /**
     * This method is used to save Program Transfer Request on click of submit button
     */
    saveProgramTransferServiceRequest: function (button) {
        var form = button.up('form');
        var values = form.getValues();
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    /**
     * This method is used to create Program Transfer Service Request JSON
     *
     * @param values
     *            form values
     * @return JSON object
     *
     */
    createProgramTransferRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        delete values.requestStatusId;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting = serviceRequestSetting;
        object.dueDate = null;
        values.programTransferMultipleReason = [];
        if (Ext.isArray(values.leavingReasonId)) {
            var i = 0;
            Ext.each(values.leavingReasonId, function (currentRec) {
                values.programTransferMultipleReason.push({
                    "programTransferReason": {
                        "id": currentRec
                    },
                    "reasonRemark": values.leavingRemarks[i]
                });
                i = i + 1;
            });
        } else {
            values.programTransferMultipleReason.push({
                "programTransferReason": {
                    "id": values.leavingReasonId
                },
                "reasonRemark": values.leavingRemarks
            });
        }
        delete values.leavingReasonId;
        delete values.leavingRemarks;
        object.detail = values;
        object.detail.programGroupId = object.detail.programGroup;
        object.detail.isConfirmation = object.detail.confirmation;
        object.detail.isAuthorizeDeclaration = object.detail.authorizeDeclaration;
        object.detail.isHealthInsurance = object.detail.healthInsuranceCheck;
        object.detail.isScholarship = object.detail.scholarshipCheck;
        object.detail.isMedicalIssues = object.detail.medicalIssuesCheck;
        object.detail.isUpToDateDetails = object.detail.upToDateDetails;
        delete object.detail.authorizeDeclaration;
        delete object.detail.healthInsuranceCheck;
        delete object.detail.scholarshipCheck;
        delete object.detail.medicalIssuesCheck;
        delete object.detail.upToDateDetails;
        delete object.detail.withdrawDate;
        delete object.detail.programGroup;
        delete object.detail.studentdeclaration;
        delete object.detail.studentApply;
        delete object.detail.confirmation;
        delete object.detail.withdrawDate;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.program
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    /**
     * This method is used to load fromProgram combo of Program
     * Transfer Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadFromProgramComboStore: function (cmb) {
        var me = this;
        var store = cmb.getStore();
        var portalId = me.getCurrentLoggedPortalId();
        var studenttransferrequestdetailspanel = cmb.up('studenttransferrequestdetailspanel');
        var schoolleavingrequestdetailspanel = cmb.up('schoolleavingrequestdetailspanel');
        var withdrawfromprogramdetailspanel = cmb.up('withdrawfromprogramdetailspanel');
         var programrequestdetailspanel = cmb.up('programrequestdetailspanel');
        var debarmentForm = cmb.up('debarmentform');
        var terminationForm = cmb.up('terminationform');
        
		var isEditRequest = false;
		var activeTab = this.getContentPanelActiveTab();
		if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
			var serviceRequestId = activeTab.getServiceRequestId();
			if (!isNullOrEmpty(serviceRequestId)) {
				isEditRequest = true;
			}
		} 
        
        var studentGrid = Ext.ComponentQuery.query("#trackRequestGrid")[0];
        if (isNullOrEmpty(studentGrid)) {
            studentGrid = Ext.ComponentQuery.query("#searchresultgrid")[0];
        }
        var basicDetailPnl = this.getBasicdetails();
        if(isNullOrEmpty(studentGrid)) {
        	var studentGrid = Ext.ComponentQuery.query('#StudentSearchResultGrid')[0];
        }
         var programId;
        if(withdrawfromprogramdetailspanel && withdrawfromprogramdetailspanel.programId){
        	programId = withdrawfromprogramdetailspanel.programId;
        }else if (studentGrid != undefined) {
            var studentRecord = studentGrid.getSelectionModel();
            if (studentRecord.selected.items[0] != undefined) {
                programId = studentRecord.selected.items[0].data.PROGRAM_ID;
            }
        }
        var al = null;
        if (!isNullOrEmpty(basicDetailPnl)) {
            al = basicDetailPnl.config.reqAcademyLocationId;
        } else {
            al = me.getCurrentAcademyLocation();
        }
        var fromProgramId = null;
        if (cmb.getValue() != null) {
            fromProgramId = cmb.getValue();
        }
        var alIds = Ext.Array.pluck(Academia.utilities.accessControl.AccessControlManager.allocatedAcademyLocations, 'id').join();
        if (cmb.up('debarmentform')) {
            var storeParams = {
                studentId: this.getContentPanelActiveTab().getRequesterId(),
                academyLocationIds: this.getCurrentAcademyLocation(),
                admissionId: this.getContentPanelActiveTab().getAdmissionId(),
                isEditRequest : isEditRequest
            };
            
            var academicTermField = debarmentForm.down('#academicTermId');
            academicTermField.setDisabled(false);
            
		} else if (cmb.up('studenttransferrequestdetailspanel')) {
				 var storeParams = {
							studentId : this.getContentPanelActiveTab().getRequesterId(),
							academyLocationIds : alIds,
							admissionId : this.getContentPanelActiveTab().getAdmissionId()
					};		
        } else if (cmb.up('schoolleavingrequestdetailspanel')) {
			 var storeParams = {
						studentId : this.getContentPanelActiveTab().getRequesterId(),
						academyLocationIds : alIds,
						admissionId : this.getContentPanelActiveTab().getAdmissionId()
				};		
            } else if (cmb.up('terminationform')) {
   			 var storeParams = {
   				  studentId: this.getContentPanelActiveTab().getRequesterId(),
                  academyLocationIds: this.getCurrentAcademyLocation(),
                  admissionId: this.getContentPanelActiveTab().getAdmissionId(),
                  isEditRequest : isEditRequest
                  };		
         }  else {
            var storeParams = {
                studentId: this.getContentPanelActiveTab().getRequesterId(),
                academyLocationIds: alIds
            };
        }
        if(debarmentForm){
            cmb.reset();
        }
        if(terminationForm){
            cmb.reset();
        }
        store.getProxy().extraParams = storeParams;
        store.load({
            callback: function (records, opt, success) {
                if (success) {
                    if (studenttransferrequestdetailspanel || schoolleavingrequestdetailspanel || withdrawfromprogramdetailspanel || debarmentForm || programrequestdetailspanel) {
                        if (studenttransferrequestdetailspanel || withdrawfromprogramdetailspanel || programrequestdetailspanel) {
                            if (records.length > 0) {
                                for (var i = 0; i < records.length; i++) {
                                    if (cmb.getValue() != null) {
                                        if (records[i].data.id == cmb.getValue()) {
                                            cmb.setValue(records[i].data.id);
                                            cmb.setReadOnly(true);
                                        }
                                    } else {
                                        if (records[i].data.id == programId || (portalId == '3' && records.length == 1)) {
                                            cmb.setValue(records[i].data.id);
                                            cmb.setReadOnly(true);
                                        }
                                    }
                                }
                            }
                        }
                        if(debarmentForm){
                        	if(records.length == 1){
                            	cmb.setValue(records[0].data.id);
                                cmb.setReadOnly(true);
                                var academicTermform = debarmentForm.down('#academicTermId');
                                var academicFormStore = academicTermform.getStore();
                                var isServiceRequestForInActiveStudent = me.getInActiveStudentServiceRequestRequired();
								var isEditRequest = false;
								var serviceRequestId = null;
								var activeTab = me.getContentPanelActiveTab();
								if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
									serviceRequestId = activeTab.getServiceRequestId();
									if (!isNullOrEmpty(serviceRequestId)) {
										isEditRequest = true;
									}
								} 
                                academicFormStore.getProxy().extraParams = {
                                	academyLocationIds: me.getCurrentAcademyLocation(),
                                    programId : records[0].data.id,
                                    studentId : me.getContentPanelActiveTab().getRequesterId(),
                                    isServiceRequestForInActiveStudent : isServiceRequestForInActiveStudent,
                                    isEditRequest:isEditRequest
                                };
                                academicFormStore.load();
                        	}
                        }
                        if (schoolleavingrequestdetailspanel) {
                            if (records.length > 0 && !isNullOrEmpty(records[0].data)) {
                            	try{
                                	if(contentPanel && contentPanel.getActiveTab() && contentPanel.getActiveTab().responseData && contentPanel.getActiveTab().responseData.detail && contentPanel.getActiveTab().responseData.detail.programId && !isNullOrEmpty(contentPanel.getActiveTab().responseData.detail.programId)){
                                        cmb.setValue(contentPanel.getActiveTab().responseData.detail.programId);
                                	}
                                	else{
                                        cmb.setValue(records[0].data.id);
                                	}
                            	}
                            	catch(e){
                            		cmb.setValue(records[0].data.id);
                            	}
                                cmb.setReadOnly(true);
                                if (schoolleavingrequestdetailspanel) {
                                    var combo = schoolleavingrequestdetailspanel.down('#noticeTermItemId');
                                    me.loadTermComboStore(combo);
                                }
                            }
                        }
                    }
                }
            }
        });
    },
    loaAcademicTermByAcademyLocationId: function (frm) {
        var leaveofabsencerequestform = this.getLeaveofabsencerequestform();
        var academicTermId = leaveofabsencerequestform.down('#startAcademicTermCombo');
        var academicTermIdStore = academicTermId.getStore();
        academicTermIdStore.getProxy().extraParams = {
            academyLocationIds: $this.getCurrentAcademyLocation(),
            academicTermName: null
        };
    },
    loaAcademicTermByPeriodDate: function (frm) {
        var debarmentForm = this.getDebarmentForm();
        var academicTermId = debarmentForm.down('#academicTermId').getValue();
        var programId = debarmentForm.down('#programDebarmentId').getValue();
        var isServiceRequestForInActiveStudent = this.getInActiveStudentServiceRequestRequired();
        var studentId = this.getContentPanelActiveTab().getRequesterId();
        var admissionId = this.getContentPanelActiveTab().getAdmissionId();
        var fromDate = debarmentForm.down('#fromDateId');
        var toDate = debarmentForm.down('#toDateId');
        fromDate.reset();
        toDate.reset();
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_STUDENT_PERIOD_DETAIL_BY_ACADEMICTERM,
            method: 'GET',
            params: {
                programId: programId,
                academicTermId: academicTermId,
                studentId: studentId,
                admissionId: admissionId,
                isServiceRequestForInActiveStudent : isServiceRequestForInActiveStudent
            },
            async: false,
            success: function (response, action) {
                var resp = Ext.JSON.decode(response.responseText);
                if (!isNullOrEmpty(resp.periodStatus) && resp.periodStatus == 'More then one period available for this academicTerm') {
                    fromDate.setValue(new Date());
                    toDate.setValue(new Date());
                } else if (new Date(resp.periodStartDate) <= new Date()) {
                    fromDate.setMinValue(new Date(resp.periodStartDate));
                    fromDate.setValue(new Date());
                    toDate.setValue(new Date(resp.periodEndDate));
                    toDate.setMaxValue(new Date(resp.periodEndDate));
                } else {
                    fromDate.setMinValue(new Date(resp.periodStartDate));
                    fromDate.setValue(new Date(resp.periodStartDate));
                    toDate.setValue(new Date(resp.periodEndDate));
                    toDate.setMaxValue(new Date(resp.periodEndDate));
                }
            }
        });
    },
    loadFromBatchProgram: function (frm) {
        var programrequestdetailspanel = frm.up('programrequestdetailspanel');
        var batchId1 = this.getContentPanelActiveTab().getProgramBatchId();
        var admissionId = this.getContentPanelActiveTab().getAdmissionId();
        var fromBatchItemId = programrequestdetailspanel.down("#fromBatchId");
        var programId = programrequestdetailspanel.down("#fromProgramId").getValue();
        fromBatchItemId.setValue(batchId1);
        var admissionItemId = programrequestdetailspanel.down("#admissionId").setValue(admissionId);
        var studentId = this.getContentPanelActiveTab().getRequesterId();
        var serviceRequestForm = this.getContentPanelActiveTab();
        var form = serviceRequestForm.down('form');
        var requestPanel = form.down('requesterdetailspanel');
        var batchendDate = requestPanel.down('#batchEndDateItemId');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PROGRAM_BATCH_BY_ADMISSION_PROGRAM_ID,
            method: 'GET',
            params: {
                studentId: studentId,
                programId: programId,
            },
            async: false,
            success: function (response, action) {
                var resp = Ext.JSON.decode(response.responseText);
                fromBatchItemId.setValue(resp.id);
                admissionItemId.setValue(resp.academicTermId);
                batchendDate.setValue(resp.date);
            }
        });
    },
    loadFromProgramByProgramGroupId: function (frm) {
        var programrequestdetailspanel = frm.up('programrequestdetailspanel');
        var studentId = this.getContentPanelActiveTab().getRequesterId();
        var alId = this.getCurrentAcademyLocation();
        var programCombo = programrequestdetailspanel.down("#toProgramId");
        var programGroupCombo = programrequestdetailspanel.down("#programGroupId");
        var periodId = this.getContentPanelActiveTab().getPeriodId();
        var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
        var programGroupId = programGroupCombo.getValue();
        var programComboStore = programCombo.getStore();
        programComboStore.getProxy().extraParams = {
            academyLocationId: alId,
            studentId: studentId,
            programGroupId: programGroupId,
            periodId : periodId,
            requestTypeCode:requestTypeCode
        };
        programCombo.reset();
        programComboStore.load({
            callback: function (records, operation, success) {
                if (success) {
                    if (!isNullOrEmpty(records) && records.length == 1) {
                    	programCombo.setValue(records[0].data.id);
                    }
                }
            }
        });
    },
    /**
     * This method is used to load toProgram combo of Program
     * Transfer Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadToProgramComboStore: function (cmb) {
    	
        var store = cmb.getStore();
        var basicDetailPnl = this.getBasicdetails();
        var al = basicDetailPnl.config.reqAcademyLocationId;
        var periodId = this.getContentPanelActiveTab().getPeriodId();
        var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
		var isEditRequest = false;
		var activeTab = this.getContentPanelActiveTab();
		if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
			var serviceRequestId = activeTab.getServiceRequestId();
			if (!isNullOrEmpty(serviceRequestId)) {
				isEditRequest = true;
			}
		} 
        if (al == undefined) {
            al = this.getCurrentAcademyLocation();
        }
        store.load({
            params: {
                studentId: this.getContentPanelActiveTab().getRequesterId(),
                academyLocationId: this.getCurrentAcademyLocation(),
                periodId : periodId,
                requestTypeCode:requestTypeCode,
                isEditRequest : isEditRequest
            }
        });
    },
    loadStudentTransferToProgramComboStore: function (cmb) {
        var studTransferPanel = this.getStudenttransferrequestdetailspanel();
        var acadLocationTo = this.getCurrentAcademyLocation();
        var store = cmb.getStore();
        store.load({
            params: {
                studentId: this.getContentPanelActiveTab().getRequesterId(),
                academyLocationId: acadLocationTo
            }
        });
    },
    /**
     * This method is use to load the batch combo on change of toprogram combo
     */
    loadBatchComboStore: function (combo, data) {
        var batchCombo = combo.up('form').down('#toBatchId');
        var alCombo = combo.up('form').down('#toAcademyLocationItemId');
        var seatTypeCombo = combo.up('form').down('#toSeatTypeId');
        var toPeriodCombo = combo.up('form').down('#toPeriodId');
        var academicTermCombo = combo.up('form').down('#academicTermId');
        var academicTermId = null;
        if (toPeriodCombo != undefined) {
            toPeriodCombo.reset();
            toPeriodCombo.clearValue();
        }
        if (seatTypeCombo != undefined) {
            seatTypeCombo.reset();
            seatTypeCombo.clearValue();
        }
        if(!isNullOrEmpty(academicTermCombo) && academicTermCombo.isVisible()){
			academicTermId = academicTermCombo.getValue();
		}
        batchCombo.reset();
        batchCombo.setDisabled(false);
        var me = this;
        var serviceRequestForm = me.getContentPanelActiveTab();
        var academyLocationId = me.getContentPanelActiveTab().academyLocationId;
        var form = serviceRequestForm.down('form');
        var requestPanel = form.down('requesterdetailspanel');
        var batchendDate = requestPanel.down('#batchEndDateItemId').getValue();
        var programrequestdetailspanel = combo.up('programrequestdetailspanel');
        var batchEndDateNew = batchendDate;
        var periodId = this.getContentPanelActiveTab().getPeriodId();
        var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
        if (programrequestdetailspanel) {
        	var parsedDate = new Date(batchendDate); // Correctly creates a Date object
        	batchEndDateNew = Ext.Date.format(parsedDate, 'Y-m-d');
        }
        var store = batchCombo.getStore();
        var academyLocationId = null;
        if(alCombo != undefined) {
        	academyLocationId = alCombo.getValue();
        }
        
        store.load({
            params: {
                batchendDate: batchEndDateNew,
                id: combo.getValue(),
                academicTermId : academicTermId,
                mappedPeriodId : periodId,
                requestTypeCode:requestTypeCode,
                academyLocationId : academyLocationId
                //V2D-85220
                //isActive: true
            }
        });
        if (!isNullOrEmpty(data.detail)) {
            batchCombo.setValue(data.detail.toBatchId);
            academicTermCombo.setValue(data.detail.academicTermId);
        }
    },
    
    loadBatchComboStoreForProgramTransfer : function (combo, data) {
        var batchCombo = combo.up('form').down('#toBatchId');
        var seatTypeCombo = combo.up('form').down('#toSeatTypeId');
        var toPeriodCombo = combo.up('form').down('#toPeriodId');
        var academicTermCombo = combo.up('form').down('#academicTermId');
        var toProgramCombo = combo.up('form').down('#toProgramId');
        var academicTermId = null;
        var programId = null;
        if (toPeriodCombo != undefined) {
            toPeriodCombo.reset();
            toPeriodCombo.clearValue();
        }
        if (seatTypeCombo != undefined) {
            seatTypeCombo.reset();
            seatTypeCombo.clearValue();
        }
        if(!isNullOrEmpty(academicTermCombo)){
			academicTermId = academicTermCombo.getValue();
		}
        if(!isNullOrEmpty(toProgramCombo)){
        	programId = toProgramCombo.getValue();
		}
        batchCombo.reset();
        batchCombo.setDisabled(false);
        var me = this;
        var serviceRequestForm = me.getContentPanelActiveTab();
        var form = serviceRequestForm.down('form');
        var requestPanel = form.down('requesterdetailspanel');
        var batchendDate = requestPanel.down('#batchEndDateItemId').getValue();
        var programrequestdetailspanel = combo.up('programrequestdetailspanel');
        var batchEndDateNew = batchendDate;
        if (programrequestdetailspanel) {
        	batchEndDateNew = Ext.Date.format(new Date(batchendDate), 'Y-m-d');
        }
        
        if(!isNullOrEmpty(programId)){
        var store = batchCombo.getStore();
        store.load({
            params: {
                batchendDate: batchEndDateNew,
                id: programId,
                academicTermId : academicTermId
                //V2D-85220
                //isActive: true
            }
        });
       
        if (!isNullOrEmpty(data.detail)) {
            batchCombo.setValue(data.detail.toBatchId);
            academicTermCombo.setValue(data.detail.academicTermId);
        }
        }
    },
    loadAllPeriodComboStore: function (combo, data) {
        var periodCmb = combo.up('form').down('#toPeriodId');
        var academicTermField = combo.up('form').down('#academicTermId');
        var periodId = this.getContentPanelActiveTab().getPeriodId();
        var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
         if(academicTermField){
        	 var academicTermId = academicTermField.getValue();
        }
        periodCmb.setDisabled(false);
        var store = periodCmb.getStore();
        periodCmb.reset();
        store.getProxy().extraParams = {
            batchId: combo.getValue(),
            academicTermId: academicTermId,
            periodId : periodId,
            requestTypeCode:requestTypeCode
        };
        store.load({
            callback: function (records, operation, success) {
                if (success) {
                    if (!isNullOrEmpty(data.detail) && !isNullOrEmpty(data.detail.toPeriodId)) {
                        periodCmb.setValue(data.detail.toPeriodId);
                    } else {
                        for (var i in records) {
                            if (records[i].data.check) {
                                periodCmb.setValue(records[i]);
                            }
                        }
                    }
                }
            }
        });
    },
    loadTermComboStore: function (combo) {
        var termCombo = combo.up('form').down('#noticeTermItemId');
        var programCombo = combo.up('form').down('#fromProgramId');
        var store = termCombo.getStore();
        store.load({
            params: {
                programId: programCombo.getValue()
            }
        });
    },
    /**
     * This method is use to set Term end date when select term
     */
    selectNoticeTerm: function (combo) {
        var termEndDate = combo.up('form').down('#termEndDateItemId');
        if (!isNullOrEmpty(combo.valueModels)) {
            if (combo.valueModels.length != 0) {
                var endDate = combo.valueModels[0].get('endDate');
                if (!isNullOrEmpty(endDate)) {
                    termEndDate.setValue(dateRender(endDate));
                }
            }
        }
    },
    /**
     * This method is use to load seat type combo on selection of batch combo
     */
    loadSeatTypeComboStore: function (combo,data) {
        var me = this;
        var seatTypeCombo = combo.up('form').down('#toSeatTypeId');
        seatTypeCombo.reset();
        seatTypeCombo.clearValue();
        var store = seatTypeCombo.getStore();
        var toPeriodCombo = combo.up('form').down('#toPeriodId');
        toPeriodCombo.reset();
        store.getProxy().extraParams = {
            batchId: combo.getValue()
        };
        store.load({
            callback: function (records, operation, success) {
                if (records.length == 1) {
                    seatTypeCombo.setValue(records[0].data.id);
                }
                me.loadToPeriodForProgTransferComboStore(combo);
            }
        });
        
        if (!isNullOrEmpty(data.detail)) {
			seatTypeCombo.setValue(data.detail.toSeatTypeId);
		}
    },
     /**
     * This method is use to load seat type combo on selection of batch combo
     */
    loadToPeriodForProgTransferComboStore: function (combo) {
        var toPeriodCombo = combo.up('form').down('#toPeriodId');
        var academicTermCombo = combo.up('form').down('#academicTermId');
        var academicTermId = null;
        var isServiceRequestForInActiveStudent = this.getInActiveStudentServiceRequestRequired();
        var periodId = this.getContentPanelActiveTab().getPeriodId();
        var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
        if(!isNullOrEmpty(academicTermCombo) && academicTermCombo.isVisible()){
			academicTermId = academicTermCombo.getValue();
		}
        var store = toPeriodCombo.getStore();
        toPeriodCombo.setDisabled(false);
        store.getProxy().extraParams = {
            batchId: combo.getValue(),
            academicTermId : academicTermId,
            periodId : periodId,
            requestTypeCode:requestTypeCode
        };
        toPeriodCombo.clearValue();
        store.load({
            callback: function (records, operation, success) {
                if (success) {
                    var showAllRecords = !isNullOrEmpty(isServiceRequestForInActiveStudent) && isServiceRequestForInActiveStudent;

                    if (showAllRecords) {
                        // Show all records without filtering
                        store.loadData(records, false);
                    } else {
                        // Filter out the record with id === periodId
                        var filteredRecords = [];
                        for (var i = 0; i < records.length; i++) {
                            if (records[i].data.id !== periodId) {
                                filteredRecords.push(records[i]);
                            }
                        }
                        store.loadData(filteredRecords, false);
                    }

                    // Optionally select default value
                    var targetRecords = showAllRecords ? records : filteredRecords;
                    for (var j = 0; j < targetRecords.length; j++) {
                        if ((showAllRecords || targetRecords[j].data.check) && !toPeriodCombo.readOnly) {
                            toPeriodCombo.setValue(targetRecords[j]);
                            break;
                        }
                    }
                    toPeriodCombo.setDisabled(false);
                }
            }
        });
    },
    /**
     * This method is used to save Withdraw Program Request on click of submit button
     */
    saveWithdrawProgramServiceRequest: function (button) {
        var form = button.up('form');
        var values = form.getValues();
        var tab = form.up('panel');
        values.serviceRequest = null;
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        var prog = tab.getProgram();
        var program = {
            id: prog.id
        };
        values.program = program;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    setProgramAsReadOnly: function (form) {
        var programField = form.down('#withdrawFromProgram');
        var tab = form.up('panel');
        programField.setValue(tab.getProgram().value);
    },
    /**
     * This method is used to create Withdraw Program Service Request JSON
     *
     * @param values form values
     * @return JSON object
     *
     */
    createWithdrawProgramRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        var isServiceRequestForInActiveStudent = this.getInActiveStudentServiceRequestRequired();
        var periodId = me.getContentPanelActiveTab().config.periodId;
        object.serviceRequestSetting = serviceRequestSetting;
        object.dueDate = null;
        values.programWithdrawlRequestMultipleReason = [];
      
        var i = 0;
        if(typeof values.leavingReasonId == "object"){
            Ext.each(values.leavingReasonId, function (currentRec) {
                values.programWithdrawlRequestMultipleReason.push({
                    "programWithdrawalReason": {
                        "id": currentRec
                    },
                    "reasonRemark": values.leavingRemarks[i]
                });
                i = i + 1;
            });
        }
        else{
            values.programWithdrawlRequestMultipleReason.push({
                "programWithdrawalReason": {
                    "id": values.leavingReasonId
                },
                "reasonRemark": values.leavingRemarks
            });
        }
        
        delete values.leavingReasonId;
        delete values.leavingRemarks;
        object.detail = values;
        object.detail.isConfirmation = object.detail.confirmation;
        object.detail.isAuthorizeDeclaration = object.detail.authorizeDeclaration;
        object.detail.isInactiveStudent = isServiceRequestForInActiveStudent;
        object.detail.periodId = periodId;
        object.detail.academicTermId = object.detail.academicTermProgramWithdrwan;
        delete object.detail.authorizeDeclaration;
        delete object.detail.studentdeclaration;
        delete object.detail.studentApply;
        delete object.detail.confirmation;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    /**
     * This method is used to load fromProgram combo of Withdraw
     * Program Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadWithdrawProgramFromComboStore: function (cmb) {
        var store = cmb.getStore();
        store.getProxy().extraParams = {
            studentId: this.getContentPanelActiveTab().getRequesterId(),
            academyLocationId: this.getCurrentAcademyLocation()
        };
        store.load();
    },
    /**
     * This method is used to save Course Transfer Request on click of submit button
     */
    saveCourseTransferServiceRequest: function (button) {
        var form = button.up('form');
        var values = form.getValues();
        values.serviceRequest = null;
        var fromCourseId = values.fromCourseId;
        var toCouseID = values.toCourseId;
        if (fromCourseId == toCouseID) {
            showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('SAME_COURSE_NOT_ALLOW'));
            return false;
        }
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        delete values.withdrawDate;
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    /**
     * This method is used to create Course Transfer Service Request JSON
     *
     * @param values form values
     * @return JSON object
     *
     */
    createCourseTransferRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.dueDate = null;
        object.detail = values;
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    /**
     * This method is used to load fromCourse combo of Course
     * Transfer Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadFromCourseComboStore: function (cmb) {
        var combo = cmb.up('form').down('#fromCourseId');
        var store = combo.getStore();
        store.getProxy().extraParams = {
            studentId: this.getContentPanelActiveTab().getRequesterId(),
            academyLocationId: this.getCurrentAcademyLocation(),
            programId: cmb.getValue()
        };
        store.load();
    },
    /**
     * This method is used to load fromCourse combo of Course
     * Transfer Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadFromCourseComboForTrackRequest: function(combo, formData) {
        var store = combo.getStore();
        store.getProxy().extraParams = {
            studentId: this.getContentPanelActiveTab().getRequesterId() ? this.getContentPanelActiveTab().getRequesterId() : formData.requester.id,
            academyLocationId: this.getCurrentAcademyLocation(),
            programId: formData.programId
        };
        store.load();
    },
    /**
     * This method is used to load toCourse combo of Course
     * Transfer Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadToCourseComboStore: function (cmb) {
        var combo = cmb.up('form').down('#fromProgramId');
        var toCourseCmb = cmb.up('form').down('#toCourseId');
        toCourseCmb.reset();
        var store = toCourseCmb.getStore();
        store.getProxy().extraParams = {
            programId: combo.getValue(),
            courseId: cmb.getValue()
        };
        store.load();
    },
    /**
     * This method is used to load toCourse combo of Course
     * Transfer Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadToCourseComboForTrack: function (combo, programId) {
        var store = combo.getStore();
        store.getProxy().extraParams = {
            programId: programId
        };
        store.load();
    },
    /**
     * This method is used to save Withdraw course Request on click of submit button
     */
    saveWithdrawCourseServiceRequest: function (button) {
        var me = this;
        var form = button.up('form');
        var values = form.getValues();
        values.assignee = me.getContentPanelActiveTab().getAssignee();
        values.serviceRequest = null;
        var courses = new Array();
        Ext.each(values.coursesId, function (course) {
            if (course instanceof Object) {
                id = course.get('id');
                courses.push(id);
            }
        });
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        delete values.withdrawDate;
        values.coursesId = courses;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    /**
     * This method is used to create Withdraw course Service Request JSON
     *
     * @param values form values
     * @return JSON object
     *
     */
    createWithdrawCourseRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.withdrawDate
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    /**
     * This method is used to load Program combo of Withdraw course Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadWithdrawCourseProgramStore: function (cmb) {
        var store = cmb.getStore();
        store.on('beforeload', function () {
            store.getProxy().extraParams = {
                studentId: this.getContentPanelActiveTab().getRequesterId(),
                academyLocationId: this.getCurrentAcademyLocation()
            };
        }, this);
    },
    /**
     * This method is used to load course combo
     *
     * @param cmb reference of combo
     */
    loadDebarmentCourseComboStore: function (cmb) {
        var debarmentRef = this.getDebarmentForm();
        var academicTermField = debarmentRef.down('#academicTermId');
        var fromDateField = debarmentRef.down('#fromDateId');
        var toDateField = debarmentRef.down('#toDateId');
        academicTermField.setDisabled(false);
        academicTermField.reset();
        fromDateField.reset();
        toDateField.reset();
        var programId = debarmentRef.down('#programDebarmentId').getValue();
        var academyLocationId = this.getCurrentAcademyLocation();
        var admissionId = this.getContentPanelActiveTab().getAdmissionId();
        var alIds = Ext.Array.pluck(Academia.utilities.accessControl.AccessControlManager.allocatedAcademyLocations, 'id').join();
        var academicFormStore = academicTermField.getStore();
        academicFormStore.getProxy().extraParams = {
            academyLocationIds: alIds,
            programId: programId,
            studentId: this.getContentPanelActiveTab().getRequesterId()
        };
        academicFormStore.load();
        var store = debarmentRef.down('#courseDebarmentId').getStore();
        store.load({
            params: {
                studentId: this.getContentPanelActiveTab().getRequesterId(),
                academyLocationId: this.getCurrentAcademyLocation(),
                programId: cmb.getValue()
            }
        });
    },
    /**
     * This method is used to load course combo of Withdraw
     * course Request DEtails Panel store
     *
     * @param cmb reference of combo
     */
    loadWithdrawCourseComboStore: function (cmb) {
        var combo = cmb.up('form').down('#courseId');
        var store = combo.getStore();
        store.getProxy().extraParams = {
            studentId: this.getContentPanelActiveTab().getRequesterId(),
            academyLocationId: this.getCurrentAcademyLocation(),
            programId: cmb.getValue()
        };
        store.load();
    },
    loadWithdrawCourseComboForTrack: function (combo, programId) {
        var store = combo.getStore();
        store.getProxy().extraParams = {
            studentId: this.getContentPanelActiveTab().getRequesterId(),
            academyLocationId: this.getCurrentAcademyLocation(),
            programId: programId
        };
        store.load();
    },
    /**
     * This method is use to withdraw the request.
     */
    withdrawRequest: function (button) {
        var me = this;
        showConfirmMessage( getServiceRequestTranslation('WITHDRAW_REQUEST'),getCommonTranslation('WANT_WITHDRAW_SELECTED_REQUEST'),function(btn,text){
			 if (btn == 'yes') {
				 
        if (button.itemId == 'withdrawButtonId') {
        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            var form = button.up('form');
            var serviceRequestId = form.getForm().findField('id').getValue();
        } else {
        	me.applyWindowMask();
            var reasonforwithWin = me.getReasonforwithdrawalwindow();
            var form = reasonforwithWin.config.freeFormPanel;
            var reqCategory = form.down('#freeFormRequestType');
            var reasonForWithdraw = button.up().up().down('#reasonForWithdraw');
            var reasonForWithdrawValue = reasonForWithdraw.getValue();
            var serviceRequestId = form.getForm().findField('id').getValue();
        }
        var json;
        if (button.itemId == 'withdrawButtonId') {
		json = {
				"id":serviceRequestId
			};
		}else{
			json = {
			"id":serviceRequestId,
			"code":reasonForWithdrawValue
			};
		}
		var formData = Ext.encode(json);
        Ext.Ajax.request({
            type: 'rest',
            method: 'POST',
            url: SERVERURL.WITHDRAW_REQUEST,
			jsonData : formData,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function (opt, success, response) {
                var controller = me.getController('Academia.controller.servicerequest.ServiceRequestController');
                var tab = form.up('panel');
                if (tab.getRequestType() === 'STUDENT_REQUEST' || tab.getRequestType() === 'TERMINATION_REQUEST' || tab.getRequestType() === 'TRANSFER_REQUEST' || tab.getRequestType() === 'DEBRAMENT_REQUEST') {
                    controller.loadStudentGridAndSearchRequest();
                } else {
                    controller.loadFacultyGridAndSearchRequest();
                }
                showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('WITHDRAWSUCCESSFULLY'));
                if (reasonforwithWin != undefined) {
                	 me.hideWindowMask();
                    reasonforwithWin.close();
                }
                Ext.getBody().unmask()
                controller.closeTab(tab);
            }
        });
 }
			 
		});
    },
    /**
     * This method is use to withdraw complaint request.
     *
     * @param button
     */
    withdrawComplaintRequest: function (button) {
        var form = button.up('form');
        var me = this;
        var serviceRequestId;
        if (form.up().down('#id') != null) {
            serviceRequestId = form.up().down('#id').getValue();
        } else {
            serviceRequestId = this.getContentPanelActiveTab().down('#id').getValue();
        }
		var json;
    	json = {
			"id":serviceRequestId,
		};
		var formData = Ext.encode(json);
        Ext.Ajax.request({
            type: 'rest',
            method: 'POST',
            url: SERVERURL.WITHDRAW_COMPLAINT_REQUEST,
			jsonData : formData,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function (opt, success, response) {
                var controller = me.getController('Academia.controller.servicerequest.ServiceRequestController');
                me.loadComplaintGridAndSearchRequest();
                var tab = form.up('panel');
                showSuccessMessage(getServiceRequestTranslation('COMPLAINT_REQUEST'), getServiceRequestTranslation('WITHDRAWSUCCESSFULLY'));
                me.getContentPanel().getActiveTab().close();
            }
        });
    },
    
    /**
     * This method is used to clear fields on Manage Complaint search form
     *
     */
    clearSearchFormManageComplaint: function (button) {
        var portalId = this.getCurrentLoggedPortalId();
        var form;
        if (portalId == 1 || portalId == 2 || portalId == 7) {
            form = button.up('form').getForm();
            form.getFields().each(function (field) {
                field.reset();
                if(field.getXType()=='datefield') {
                	field.setMinValue(null);
                	field.setMaxValue(null);
                }
            });
            var formObj = button.up('form');
            var requestTypeField = formObj.down('requestsubrequesttypefieldcontainer');
            if (requestTypeField != undefined) {
                var requestType = requestTypeField.down('#requestSubCategoryField');
                if (requestType != undefined) {
                    requestType.getStore().removeAll();
                }
            }
        }
        if (portalId == 3) {
            form = button.up('form').getForm();
            form.getFields().each(function (field) {
                if (field.name != 'selectedNameField' && field.name != 'REQUESTER_FIRSTNAME') {
                    field.reset();
                    if(field.getXType()=='datefield') {
                    	field.setMinValue(null);
                    	field.setMaxValue(null);
                    }
                }
            });
        }
    },
    
    /**
     * This method is used to clear fields on student REquest & faculty REquest's search Form
     *
     * @param button which is reference of buttton
     */
    clearSearchForm: function (button) {
        var portalId = this.getCurrentLoggedPortalId();
        var form;
        var $this = this;
        var currentForm;
        if ($this.getFacultyFindRequestForm() != undefined) {
            currentForm = $this.getFacultyFindRequestForm()
        } else {
            currentForm = $this.getFindRequestForm();
        }
        if (portalId == 1 || portalId == 2 || portalId == 7) {
            form = button.up('form').getForm();
            form.getFields().each(function (field) {
                if (field.name != 'assigneeId' && !currentForm.config.isPermissionGiven) {
                    field.reset();
                } else if (currentForm.config.isPermissionGiven) {
                    field.reset();
                }
            });
            var formObj = button.up('form');
            var requestTypeField = formObj.down('requestsubrequesttypefieldcontainer');
            var requestType = requestTypeField.down('#requestSubCategoryField');
            var certificateCategory = requestTypeField.down('#certificateCategoryField');
            var certificateType = requestTypeField.down('#certificateSubCategoryField');
            var generalCategory = requestTypeField.down('#freeFormCategoryField');
            var generalType = requestTypeField.down('#freeFormSubCategoryField');
            certificateCategory.setVisible(false);
            certificateType.setVisible(false);
            generalCategory.setVisible(false);
            generalType.setVisible(false);
            if (requestType != undefined) {
                requestType.getStore().removeAll();
                requestType.setVisible(false);
            }
            var fromDate = formObj.down('#from_date');
            var tllDate = formObj.down('#till_date');
            fromDate.setMinValue(false);
            tllDate.setMinValue(false);
            fromDate.setMaxValue(false);
            tllDate.setMaxValue(false);
        }
        if (portalId == 3) {
            var formObj = button.up('form');
            var requestTypeField = formObj.down('requestsubrequesttypefieldcontainer');
            var requestType = requestTypeField.down('#requestSubCategoryField');
            var certificateCategory = requestTypeField.down('#certificateCategoryField');
            var certificateType = requestTypeField.down('#certificateSubCategoryField');
            var generalCategory = requestTypeField.down('#freeFormCategoryField');
            var generalType = requestTypeField.down('#freeFormSubCategoryField');
            certificateCategory.setVisible(false);
            certificateType.setVisible(false);
            generalCategory.setVisible(false);
            generalType.setVisible(false);
            requestType.setVisible(false);
            form = button.up('form').getForm();
            form.getFields().each(function (field) {
                if (field.name != 'selectedNameField' && field.name != 'REQUESTER_FIRSTNAME') {
                    field.reset();
                }
            });
            var fromDate = formObj.down('#from_date');
            var tillDate = formObj.down('#till_date');
            if (!isNullOrEmpty(fromDate)) {
                fromDate.setMinValue(false);
                fromDate.setMaxValue(false);
            }
            if (!isNullOrEmpty(tillDate)) {
                tillDate.setMinValue(false);
                tillDate.setMaxValue(false);
            }
        }
    },
    /**
     * This method is used to save Student Debarment Form
     */
    saveStudentDebarmentServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        if (!isNullOrEmpty(values.userId)) {
            var userId = values.userId.id;
            delete values.userId;
            values.userId = userId;
        }
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        delete values.requestStatusId;
        delete values.customData;
        values.whetherUnenrollFromCourses = values.WhetherUnenrollFromCourses;
        delete values.WhetherUnenrollFromCourses;
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    /**
     * This method is used to create Student Debarment Service Request JSON
     *
     * @param values form values
     * @return JSON object
     *
     */
    createStudentDebarmentRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        delete values.customData;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        values.debarmentRequestDetailMultipleReason = [];
        if (Ext.isArray(values.leavingReasonId)) {
            var i = 0;
            Ext.each(values.leavingReasonId, function (currentRec) {
                values.debarmentRequestDetailMultipleReason.push({
                    "debarmentReason": {
                        "id": currentRec
                    },
                    "reasonRemark": values.leavingRemarks[i]
                });
                i = i + 1;
            });
        } else {
            values.debarmentRequestDetailMultipleReason.push({
                "debarmentReason": {
                    "id": values.leavingReasonId
                },
                "reasonRemark": values.leavingRemarks
            });
        }
        delete values.leavingReasonId;
        delete values.leavingRemarks;
        delete values.academicTerm;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    /**
     * This method is used to save Student Termination Form
     */
    saveStudentTerminationServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        if (!isNullOrEmpty(values.userId)) {
            var userId = values.userId.id;
            delete values.userId;
            values.userId = userId;
            delete values.requestStatusId;
        }
        delete values.requestStatusId;
        delete values.batchEndDate;
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    loadTerminationData: function (data, form) {
        var me = this;
        var terminationRequestMultipleReason = data.detail.terminationRequestMultipleReason;
        var firstReasonId = terminationRequestMultipleReason[0].terminationReason.id;
        var firstReasonRemark = terminationRequestMultipleReason[0].reasonRemark;
        form.down('#terminationReason_1').setValue(firstReasonId);
        form.down('#terminationRemarks_1').setValue(firstReasonRemark);
        if (data.detail.terminationRequestMultipleReason.length > 1) {
            this.addTerminationReasonFields(2, form, true, terminationRequestMultipleReason)
        }
    },
    loadLeavingData: function (data, form) {},
    addLeavingReasonFields: function (inc, form, isView, values) {
        var me = this;
        var leavingReasonsFieldset = form.down('#leavingReasonsFieldset');
        if (!Ext.isDefined(isView)) {
            isView = false;
        }
        if (inc == 1) {
            var hideDeleteBtn = true;
            var btnMargin = 30;
            var panelHeight = 90;
            var fieldHeight = 78;
            if (form.up('leaveofabsencerequestform') || form.xtype == "leaveofabsencerequestform") {
                var leavingReasonLabel = getCommonTranslation('LOA_REASON');
                var leavingRemarkLabel = getCommonTranslation('LOA_REMARKS');
            } else if (form.up('debarmentform') || form.xtype == "debarmentform") {
                var leavingReasonLabel = getServiceRequestTranslation('DEBARMENT_REASON');
                var leavingRemarkLabel = getCommonTranslation('REASON_REMARKS');
            } else {
                var leavingReasonLabel = getCommonTranslation('REASON_FOR_LEAVING');
                var leavingRemarkLabel = getCommonTranslation('REASON_REMARKS');
            }
        } else {
            var hideDeleteBtn = false;
            var btnMargin = 0;
            var panelHeight = 60;
            var fieldHeight = 60;
            var leavingReasonLabel = false;
            var leavingRemarkLabel = false;
        }
        if (form.up('withdrawfromprogramdetailspanel') || form.xtype == "withdrawfromprogramdetailspanel") {
        	var leavingReasonLabel = getServiceRequestTranslation('REASON_FOR_WITHDRAWAL_FROM_PROGRAM');
            var leavingReasonStore = 'servicerequest.studentservicerequest.ReasonForWithdrawalFromProgram';
        } else if (form.up('programrequestdetailspanel') || form.xtype == "programrequestdetailspanel") {
        	var leavingReasonLabel = getServiceRequestTranslation('REASON_FOR_PROGRAM_TRANSFER');
            var leavingReasonStore = 'servicerequest.studentservicerequest.ReasonForProgramTransferStore';
        } else if (form.up('leaveofabsencerequestform') || form.xtype == "leaveofabsencerequestform") {
            var leavingReasonStore = 'servicerequest.studentservicerequest.LeaveOfAbsenceReasonStore';
        } else if (form.up('debarmentform') || form.xtype == "debarmentform") {
            var leavingReasonStore = 'servicerequest.DebarmentReasons';
        }else if (form.up('studenttransferrequestdetailspanel') || form.xtype == "studenttransferrequestdetailspanel") {
        	var leavingReasonLabel = getServiceRequestTranslation('REASON_FOR_STUDENT_TRANSFER');
            var leavingReasonStore = 'servicerequest.studentservicerequest.ReasonForStudentTransferStore';
        } else {
            var leavingReasonStore = '';
        }
        var reasonContainer = {
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            layout: 'hbox',
            inc: inc,
            flex: 1,
            isView: isView,
            height: 'auto',
            items: [{
                xtype: 'customcombobox',
                fieldLabel: (inc === 1) ? leavingReasonLabel : '',
                store: leavingReasonStore,
                name: 'leavingReasonId',
                valueField: 'id',
                action: 'selectLeavingReasonId',
                itemId: 'leavingReason_' + inc,
                displayField: 'value',
                allowBlank: false,
                editable: false,
                readOnly: isView,
                matchFieldWidth: true,
                value: Ext.isDefined(values) ? values.id : null
            }, {
                xtype: 'textarea',
                fieldLabel: leavingRemarkLabel,
                name: 'leavingRemarks',
                itemId: 'leavingRemarks_' + inc,
                readOnly: isView,
                rows: 3,
                value: Ext.isDefined(values) ? values.reasonRemark : ""
            }, {
                xtype: 'button',
                itemId: 'leavingReasonAddBtn_' + inc,
                width: 'auto',
                cls: 'CustomBodyBtnSettings mtAddRow',
                action: 'addLeavingReason',
                text: getCommonTranslation('ADDBUTTONTEXT'),
                tooltip: getCommonTranslation('ADD'),
                style: {
                    'margin-top': btnMargin + 'px !important;'
                },
                disabled: isView
            }, {
                xtype: 'button',
                glyph: ICONGLYPH.DELETEGLYPH,
                itemId: 'leavingReasonDeleteBtn_' + inc,
                width: 'auto',
                height: 24,
                cls: 'CustomBodyBtnReject',
                action: 'deleteLeavingReason',
                tooltip: getCommonTranslation('DELETETOOLTIP'),
                hidden: hideDeleteBtn,
                style: {
                    'margin-top': btnMargin + 'px !important;'
                },
                disabled: isView
            }],
            afterender: function (btn) {
                me.validateLeavingForm(btn);
            }
        };
        var panelItem = new Array();
        panelItem.push(reasonContainer);
        leavingReasonsFieldset.add(panelItem);
        me.setAllowBlank(leavingReasonsFieldset.down('#leavingReason_' + inc), false);
        leavingReasonsFieldset.down('#leavingReason_' + inc).getStore().load();
        if (Ext.isDefined(values) && values.length) {
            setTimeout(function () {
                if (values.length > inc) {
                    var nInc = inc + 1;
                    me.addLeavingReasonFields(nInc, form, isView, values)
                }
            }, 300);
        }
    },
    addLeavingReason: function (btn) {
        var me = this;
        var fieldcontainer = btn.up('fieldcontainer');
        var newInc = fieldcontainer.inc + 1;
        var isView = fieldcontainer.isView;
        if (btn.up('withdrawfromprogramdetailspanel')) {
            var leavingform = btn.up('withdrawfromprogramdetailspanel');
        } else if (btn.up('programrequestdetailspanel')) {
            var leavingform = btn.up('programrequestdetailspanel');
        } else if (btn.up('leaveofabsencerequestform')) {
            var leavingform = btn.up('leaveofabsencerequestform');
        } else if (btn.up('debarmentform')) {
            var leavingform = btn.up('debarmentform');
        } else if (btn.up('studenttransferrequestdetailspanel')) {
            var leavingform = btn.up('studenttransferrequestdetailspanel');
        } else {
            var leavingform = '';
        }
        me.addLeavingReasonFields(newInc, leavingform, isView);
    },
    deleteLeavingReason: function (btn) {
        var me = this;
        var fieldcontainer = btn.up('fieldcontainer');
        var fieldset = fieldcontainer.up('fieldset');
        if (btn.up('withdrawfromprogramdetailspanel')) {
            var leavingform = btn.up('withdrawfromprogramdetailspanel');
        } else if (btn.up('programrequestdetailspanel')) {
            var leavingform = btn.up('programrequestdetailspanel');
        } else if (btn.up('leaveofabsencerequestform')) {
            var leavingform = btn.up('leaveofabsencerequestform');
        } else if (btn.up('debarmentform')) {
            var leavingform = btn.up('debarmentform');
        }else if (btn.up('studenttransferrequestdetailspanel')) {
            var leavingform = btn.up('studenttransferrequestdetailspanel');
        } else {
            var leavingform = '';
        }
        fieldset.remove(fieldcontainer);
        setTimeout(function () {
            me.validateLeavingForm(null, leavingform);
        }, 300);
    },
    validateLeavingForm: function (btn, form) {
        var me = this;
        if (!isNullOrEmpty(btn)) {
            if (btn.up('withdrawfromprogramdetailspanel')) {
                var leavingform = btn.up('withdrawfromprogramdetailspanel');
            } else if (btn.up('programrequestdetailspanel')) {
                var leavingform = btn.up('programrequestdetailspanel');
            } else if (btn.up('leaveofabsencerequestform')) {
                var leavingform = btn.up('leaveofabsencerequestform');
            } else if (btn.up('debarmentform')) {
                var leavingform = btn.up('debarmentform');
            } else if (btn.up('studenttransferrequestdetailspanel')) {
                var leavingform = btn.up('studenttransferrequestdetailspanel');
            }else {
                var leavingform = '';
            }
        } else {
            var leavingform = form;
        }
        leavingform.isValid();
        leavingform.getForm().clearInvalid();
    },
    addTerminationReasonFields: function (inc, form, isView, values) {
        var me = this;
        
        setTimeout(function(){
            form.up().down('#studentHyperLink').setVisible(true);	
        },1000);
        
        
        var terminationReasonsFieldset = form.down('#terminationReasonsFieldset');
        if (terminationReasonsFieldset && values && terminationReasonsFieldset.items && terminationReasonsFieldset.items.length && terminationReasonsFieldset.items.length >= values.length) {
            return false;
        }
        if (!Ext.isDefined(isView)) {
            isView = false;
        }
        if (inc == 1) {
            var hideDeleteBtn = true;
            var btnMargin = 30;
            var terminationReasonLabel = getServiceRequestTranslation('TERMINATION_REASON')+': <span class="required" style="color:red"> *</span>';
            var terminationRemarkLabel = getCommonTranslation('REASON_REMARKS');
        } else {
            var hideDeleteBtn = false;
            var btnMargin = 0;
            var terminationReasonLabel = false;
            var terminationRemarkLabel = false;
        }
        var isAdded = false;
        if (form && form.getValues() && form.getValues().terminationReasonId && form.getValues().terminationReasonId.length && values) {
            if (typeof form.getValues().terminationReasonId != "number" && form.getValues().terminationReasonId.indexOf(values[inc - 1].terminationReason.id) != -1) {
                isAdded = true;
            } else if (typeof form.getValues().terminationReasonId == "number" && form.getValues().terminationReasonId == values[inc - 1].terminationReason.id) {
                isAdded = true;
            }
        }
        var reasonContainer = {
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            layout: 'hbox',
            inc: inc,
            isView: isView,
            items: [{
                xtype: 'customcombobox',
                labelSeparator: '',
                fieldLabel: terminationReasonLabel,
                store: 'servicerequest.TerminationReasons',
                name: 'terminationReasonId',
                valueField: 'id',
                itemId: 'terminationReason_' + inc,
                displayField: 'value',
                allowBlank: false,
                editable: false,
                readOnly: isView,
                value: Ext.isDefined(values) ? values[inc - 1].terminationReason.id : null,
                listeners: {
                    afterrender: function (combo) {
                        me.setAllowBlank(combo, false);
                    }
                }
            }, {
                xtype: 'textfield',
                fieldLabel: terminationRemarkLabel,
                name: 'terminationRemarks',
                itemId: 'terminationRemarks_' + inc,
                readOnly: isView,
                value: Ext.isDefined(values) ? values[inc - 1].reasonRemark : ""
            }, {
                xtype: 'button',
                itemId: 'terminationReasonAddBtn_' + inc,
                width: 'auto',
                cls: 'CustomBodyBtnSettings mtAddRow',
                action: 'addTerminationReason',
                text: getCommonTranslation('ADDBUTTONTEXT'),
                tooltip: getCommonTranslation('ADD'),
                style: {
                    'margin-top': btnMargin + 'px !important;'
                },
                disabled: isView
            }, {
                xtype: 'button',
                glyph: ICONGLYPH.DELETEGLYPH,
                itemId: 'terminationReasonDeleteBtn_' + inc,
                width: 'auto',
                cls: 'CustomBodyBtnReject',
                action: 'deleteTerminationReason',
                tooltip: getCommonTranslation('DELETETOOLTIP'),
                hidden: hideDeleteBtn,
                style: {
                    'margin-top': btnMargin + 'px !important;'
                },
                disabled: isView
            }],
            afterender: function (btn) {
                me.validateTerminationForm(btn);
            }
        };
        if (!isAdded) {
            var panelItem = new Array();
            panelItem.push(reasonContainer);
            terminationReasonsFieldset.add(panelItem);
        }
        if (Ext.isDefined(values) && values.length) {
            setTimeout(function () {
                if (values.length > inc) {
                    var nInc = inc + 1;
                    me.addTerminationReasonFields(nInc, form, isView, values)
                }
            }, 300);
        }
        
        if(form.isValid()){
        	form.down('#terminationSubmitBtn').setDisabled(false);
        }
        else{
        	form.down('#terminationSubmitBtn').setDisabled(true);
        }
    },
    saveStudentDebarmentServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        if (!isNullOrEmpty(values.userId)) {
            var userId = values.userId.id;
            delete values.userId;
            values.userId = userId;
        }
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        delete values.requestStatusId;
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    saveStudentTerminationServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        if (!isNullOrEmpty(values.userId)) {
            var userId = values.userId.id;
            delete values.userId;
            values.userId = userId;
            delete values.requestStatusId;
        }
        delete values.requestStatusId;
        delete values.batchEndDate;
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    loadTerminationData: function (data, form) {
        var me = this;
        var terminationRequestMultipleReason = data.detail.terminationRequestMultipleReason;
        var firstReasonId = terminationRequestMultipleReason[0].terminationReason.value;
        var firstReasonRemark = terminationRequestMultipleReason[0].reasonRemark;
        form.down('#terminationReason_1').setValue(firstReasonId);
        form.down('#terminationRemarks_1').setValue(firstReasonRemark);
        if (data.detail.terminationRequestMultipleReason.length > 1) {
            this.addTerminationReasonFields(2, form, true, terminationRequestMultipleReason)
        }
    },
    addTerminationReasonFields: function (inc, form, isView, values) {
        var me = this;
        this.getContentPanelActiveTab().down('#studentHyperLink').setVisible(true);
        var terminationReasonsFieldset = form.down('#terminationReasonsFieldset');
        if (!Ext.isDefined(isView)) {
            isView = false;
        }
        if (inc == 1) {
            var hideDeleteBtn = true;
            var btnMargin = 30;
            var terminationReasonLabel = getServiceRequestTranslation('TERMINATION_REASON')+': <span class="required" style="color:red"> *</span>';
            var terminationRemarkLabel = getCommonTranslation('REASON_REMARKS');
        } else {
            var hideDeleteBtn = false;
            var btnMargin = 0;
            var terminationReasonLabel = false;
            var terminationRemarkLabel = false;
        }
        var reasonContainer = {
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            layout: 'hbox',
            inc: inc,
            isView: isView,
            items: [{
                xtype: 'customcombobox',
                labelSeparator: '',
                fieldLabel: terminationReasonLabel,
                store: 'servicerequest.TerminationReasons',
                name: 'terminationReasonId',
                valueField: 'id',
                itemId: 'terminationReason_' + inc,
                displayField: 'value',
                allowBlank: false,
                editable: false,
                readOnly: isView,
                value: Ext.isDefined(values) ? values[inc - 1].terminationReason.value : null
            }, {
                xtype: 'textfield',
                fieldLabel: terminationRemarkLabel,
                name: 'terminationRemarks',
                itemId: 'terminationRemarks_' + inc,
                readOnly: isView,
                value: Ext.isDefined(values) ? values[inc - 1].reasonRemark : ""
            }, {
                xtype: 'button',
                itemId: 'terminationReasonAddBtn_' + inc,
                width: 'auto',
                cls: 'CustomBodyBtnSettings mtAddRow',
                action: 'addTerminationReason',
                text: getCommonTranslation('ADDBUTTONTEXT'),
                tooltip: getCommonTranslation('ADD'),
                style: {
                    'margin-top': btnMargin + 'px !important;'
                },
                disabled: isView
            }, {
                xtype: 'button',
                glyph: ICONGLYPH.DELETEGLYPH,
                itemId: 'terminationReasonDeleteBtn_' + inc,
                width: 'auto',
                cls: 'CustomBodyBtnReject',
                action: 'deleteTerminationReason',
                tooltip: getCommonTranslation('DELETETOOLTIP'),
                hidden: hideDeleteBtn,
                style: {
                    'margin-top': btnMargin + 'px !important;'
                },
                disabled: isView
            }],
            afterender: function (btn) {
                me.validateTerminationForm(btn);
            }
        };
        var panelItem = new Array();
        panelItem.push(reasonContainer);
        terminationReasonsFieldset.add(panelItem);
        if (Ext.isDefined(values) && values.length) {
            setTimeout(function () {
                if (values.length > inc) {
                    var nInc = inc + 1;
                    me.addTerminationReasonFields(nInc, form, isView, values)
                }
            }, 300);
        }
    },
    addTerminationReason: function (btn) {
        var me = this;
        var fieldcontainer = btn.up('fieldcontainer');
        var newInc = fieldcontainer.inc + 1;
        var isView = fieldcontainer.isView;
        var terminationform = btn.up('terminationform');
        me.addTerminationReasonFields(newInc, terminationform, isView);
    },
    deleteTerminationReason: function (btn) {
        var me = this;
        var fieldcontainer = btn.up('fieldcontainer');
        var fieldset = fieldcontainer.up('fieldset');
        var terminationform = btn.up('terminationform');
        fieldset.remove(fieldcontainer);
        setTimeout(function () {
            me.validateTerminationForm(null, terminationform);
        }, 300);
    },
    validateTerminationForm: function (btn, form) {
        var me = this;
        if (!isNullOrEmpty(btn)) {
            var terminationform = btn.up('terminationform');
        } else {
            var terminationform = form;
        }
        if(terminationform.isValid()){
        	terminationform.down('#terminationSubmitBtn').setDisabled(false);
        }
        else{
        	terminationform.down('#terminationSubmitBtn').setDisabled(true);
        }
        terminationform.getForm().clearInvalid();
    },
    createStudentTerminationRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        values.terminationRequestMultipleReason = [];
        
        var i = 0;
        if(typeof values.terminationReasonId == "object"){
            Ext.each(values.terminationReasonId, function (currentRec) {
                values.terminationRequestMultipleReason.push({
                    "terminationReason": {
                        "id": currentRec
                    },
                    "reasonRemark": values.terminationRemarks[i]
                });
                i = i + 1;
            });
        }
        else{
            values.terminationRequestMultipleReason.push({
                "terminationReason": {
                    "id": values.terminationReasonId
                },
                "reasonRemark": values.terminationRemarks
            });
        }

        delete values.terminationReasonId;
        delete values.terminationRemarks;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    saveStudentTransferServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        if (!isNullOrEmpty(values.userId)) {
            var userId = values.userId.id;
            delete values.userId;
            values.userId = userId;
        }
        values.serviceRequest = null;
        delete values.requestStatusId;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    createStudentTransferRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        object.detail = values;
        values.wsStudentTransferRequestMultipleReason = [];
        if (Ext.isArray(values.leavingReasonId)) {
            var i = 0;
            Ext.each(values.leavingReasonId, function (currentRec) {
                values.wsStudentTransferRequestMultipleReason.push({
                    "studentTransferReason": {
                        "id": currentRec
                    },
                    "reasonRemark": values.leavingRemarks[i]
                });
                i = i + 1;
            });
        } else {
            values.wsStudentTransferRequestMultipleReason.push({
                "studentTransferReason": {
                    "id": values.leavingReasonId
                },
                "reasonRemark": values.leavingRemarks
            });
        }
        object.detail.academicTermId=object.detail.academicTerm;
        object.detail.fromPeriodId = object.detail.fromPeriod;
        object.detail.isAuthorizeDeclaration = object.detail.authorizeDeclaration;
        object.detail.visaRefsual = object.detail.visaRefusalCheck;
        object.detail.studiedInUk = object.detail.studiedInUkCheck;
        object.detail.isHealthInsurance = object.detail.healthInsuranceCheck;
        object.detail.isScholarship = object.detail.scholarshipCheck;
        object.detail.isMedicalIssues = object.detail.medicalIssuesCheck;
        object.detail.isUpToDateDetails = object.detail.upToDateDetails;
        object.detail.isConfirmation = object.detail.confirmation;
        delete object.detail.visaRefusalCheck;
        delete object.detail.authorizeDeclaration;
        delete object.detail.studiedInUkCheck;
        delete object.detail.healthInsuranceCheck;
        delete object.detail.scholarshipCheck;
        delete object.detail.medicalIssuesCheck;
        delete object.detail.fromAcademicLocation
        delete object.detail.fromBatch;
        delete object.detail.fromPeriod;
        delete object.detail.upToDateDetails;
        delete object.detail.studentdeclaration;
        delete object.detail.studentApply;
        delete object.detail.confirmation;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    setStudentRequestData: function (requestType, form, data, record) {
        var me = this;
        switch (requestType) {
        case 'TRANSFER':
            {
                var formData = me.createTransferRequestObject(data, record);
                me.setInitiatedBy(form, data);
                form.getForm().setValues(formData);
                break;
            }
        case 'TERMINATION':
            {
                if (data.detail && data.detail.terminationRequestMultipleReason && data.detail.terminationRequestMultipleReason.length) {
                    form.down('[name=terminationReasonId]').getStore().load({
                        callback: function () {
                            me.loadTerminationData(data, form);
                        }
                    });
                }
                var formData = me.createTerminationRequestObject(data, record);
                if (formData.parentsId && formData.requester) {
                    form.down('#studentHyperLink').batchSeat = formData.parentsId.id;
                    form.down('#studentHyperLink').personalId = formData.requester.id;
                }
                me.setInitiatedBy(form, data);
                form.getForm().setValues(formData);
                break;
            }
        case 'DEBARMENT':
            {
                var formData = me.createDebarmentRequestObject(data, record);
                me.setInitiatedBy(form, data);
                var debarForm = form.getForm();
                debarForm.setValues(formData);
                var isServiceRequestForInActiveStudent = me.getInActiveStudentServiceRequestRequired();
                var programId = debarForm.findField('programId');
					var isEditRequest = false;
					var serviceRequestId = null;
					var activeTab = me.getContentPanelActiveTab();
					if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
						serviceRequestId = activeTab.getServiceRequestId();
						if (!isNullOrEmpty(serviceRequestId)) {
							isEditRequest = true;
						}
					} 
                programId.getStore().getProxy().extraParams = {
                    studentId: data.requester.id,
                    isEditRequest:isEditRequest
                    //academyLocationIds:data.serviceRequestSetting.academyLocation.id
                };
                programId.getStore().load({
                    callback: function (record) {
                        programId.setValue(formData.programId);
                    }
                });
                var courseId = debarForm.findField('courseId');
                courseId.getStore().getProxy().extraParams = {
                    studentId: data.requester.id,
                    admissionId: data.detail.admissionId,
                    programId: formData.programId,
                    academyLocationId: data.serviceRequestSetting.academyLocation.id
                };
                courseId.getStore().load({
                    callback: function (record) {
                    	if(!isEmpty(record))
                        courseId.setValue(data.courseId);
                    	else
                    	courseId.setValue(null);
                    }
                });
                var fromDate = debarForm.findField('fromDate');
                fromDate.setValue(dateRender(data.fromDate));
                var toDate = debarForm.findField('toDate');
                toDate.setValue(dateRender(data.toDate));
                var academicTerm = debarForm.findField('academicTermId');
                
                academicTerm.getStore().getProxy().extraParams = {
                    studentId: data.requester.id,
                    isServiceRequestForInActiveStudent:isServiceRequestForInActiveStudent
                };
                
                academicTerm.getStore().load({
                    callback: function (record) {
                        if (data && data.detail && data.detail.academicTermId) {
                            academicTerm.setDisabled(false);
                            academicTerm.setReadOnly(true);
                            academicTerm.setValue(data.detail.academicTermId);
                        }
                    }
                });
                var whetherUnenrollFromCourses = debarForm.findField('whetherUnenrollFromCourses');
                var whetherAcademicTermSkip = debarForm.findField('whetherAcademicTermSkip');
                whetherAcademicTermSkip.setReadOnly(true);
                whetherAcademicTermSkip.setValue(data.detail.whetherAcademicTermSkip);
                var whetherCompletionProcessSkip = debarForm.findField('whetherCompletionProcessSkip');
                whetherCompletionProcessSkip.setReadOnly(true);
                whetherCompletionProcessSkip.setValue(data.detail.whetherCompletionProcessSkip);
                if (data && data.detail && data.detail.academicTermId) {
                    whetherUnenrollFromCourses.setReadOnly(true);
                    whetherUnenrollFromCourses.setValue(data.detail.whetherUnenrollFromCourses);
                }
                if (formData.parentsId && formData.requester) {
                    form.down('#studentHyperLink').batchSeat = formData.parentsId.id;
                    form.down('#studentHyperLink').personalId = formData.requester.id;
                }
                break;
            }
        }
    },
    setStudentRequestProgramWithdrawlData: function (requestType, form, data, record) {
        var me = this;
        switch (requestType) {
        case 'PROGRAM_WITHDRAWAL':
            {
                if (data.detail && data.detail.programWithdrawlRequestMultipleReason && data.detail.programWithdrawlRequestMultipleReason.length) {
                    form.down('[name=leavingReasonId]').getStore().load({
                        callback: function () {
                            me.loadLeavingData(data, form);
                        }
                    });
                }
                break;
            }
        }
    },
    setInitiatedBy: function (form, data) {
        var initiatedBy = form.down('#user_Id');
        var initiatedByStore = initiatedBy.getStore();
        var initiatedById = data.detail.userId;
        if (!isNullOrEmpty(initiatedById)) {
            initiatedByStore.load({
                callback: function () {
                    initiatedBy.setValue(initiatedById);
                }
            });
        }
    },
    createTransferRequestObject: function (data, record) {
        data.transferProgram = data.detail.transferProgram.id;
        data.transferReason = data.detail.transferReason.value;
        return data;
    },
    createTerminationRequestObject: function (data, record) {
        data.programId = data.detail.programId;
        data.terminationReasonId = data.detail.terminationReasonId;
        data.studentRemark = data.detail.studentRemark;
        data.terminationRemark = data.detail.terminationRemark;
        return data;
    },
    createDebarmentRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.programId = data.detail.programId;
        formData.courseId = data.detail.courseId;
        formData.debarmentReasonId = data.detail.debarmentReasonId;
        formData.fromDate = data.detail.fromDate;
        formData.toDate = data.detail.toDate;
        return formData;
    },
    getIdValueJson: function (id, value, code) {
        if (id) return {
            id: id,
            value: value,
            code: code
        };
    },
    customzingViewForStudentPortalWhileRaiseComplaint: function () {
        var this$ = this;
        var complaintForm = this$.getComplaintdetailsform().getForm();
        var currentLoggedUserDetail = this$.getCurrentlyLoggedInUser();
        complaintForm.findField('enteredBy').setValue(currentLoggedUserDetail.value);
        if (this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7) {
            var complaintByField = complaintForm.findField('complaintBy');
            complaintByField.setValue('STUDENT');
            complaintByField.setReadOnly(true);
            var complainantField = complaintForm.findField('complainant');
            complainantField.enable();
            complainantField.getStore().getProxy().api.read = SERVERURL.COMPLAINT_STUDENT_COMBO;
            complainantField.setReadOnly(true);
            complainantField.getStore().load({
                callback: function () {
                    complainantField.setValue(currentLoggedUserDetail.id);
                }
            });
        }
    },
    saveComplaintServiceRequest: function (button) {
        var me = this;
        var form = button.up('form').up('form');
        var values = form.getValues();
        var submitData = Ext.encode(this.createComplaintRequestJson(values));
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        this.sendSaveAjaxRequest(SERVERURL.SAVE_COMPLAINT_REQUEST, 'POST', submitData, function (opt, success, response) {
            Ext.getBody().unmask();
            if (success) {
                showSuccessMessage(getServiceRequestTranslation('GRIEVANCE_REQUEST'), getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
                me.getComplaintSearchResultGrid() && me.getComplaintSearchResultGrid().getStore().load();
                var tab = me.getContentPanelActiveTab();
                me.closeTab(tab);
                if (me.getCurrentLoggedPortalId == 1) {
                    me.closeTab(form);
                }
            }
        });
    },
    createComplaintRequestJson: function (values) {
        var me = this;
        var object = new Object();
        object.complaintTypeSetting = values.complaintTypeSetting;
        object.enteredBy = me.getCurrentlyLoggedInUser();
        if (values.complaintBy === 'OTHERS' || values.complaintBy === 'PARENTS') {
            object.requester = {
                id: null
            };
        } else {
            object.requester = {
                id: values.complainant.id
            };
            delete values.complainant;
        }
        var requestDate = values.requestDate;
        var remarks = values.remarks;
        delete values.assignee;
        delete values.complaintTypeSetting;
        delete values.remarks;
        delete values.requestDate;
        object.detail = values;
        object.requestDate = requestDate;
        object.remarks = remarks;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    changeSelectComplaintantComboName: function (cmb) {
        complaintAgainstValue = cmb.getValue();
        var store;
        if (complaintAgainstValue === 'FACULTY' || complaintAgainstValue === 'EMPLOYEE') {
            var complaintantRef = cmb.up('form').down('#complaintantId');
            if (complaintantRef) {
                var ref = cmb.up('form').down('#complaintByFieldContainer');
                ref.remove(complaintantRef);
                ref.insert(1, {
                    xtype: 'livesearchcombo',
                    labelAlign: 'top',
                    name: 'selectComplaintant',
                    fieldLabel: getServiceRequestTranslation('SELECT_COMPLAINTANT'),
                    store: 'Academia.store.servicerequest.complaintrequest.Complaintant',
                    itemId: 'selectComplaintantId',
                    allowBlank: false,
                    disabled: true,
                    displayTpl: new Ext.XTemplate('<tpl for="."between=" ">', '{[typeof values === "string" ? values : values["value"]]}' + '</tpl>')
                });
            }
            var selectPersonCmbRef = cmb.up('form').down('#selectComplaintantId');
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(complaintAgainstValue);
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_FACULTY_COMBO;
            store.load();
            selectPersonCmbRef.setVisible(true);
            selectPersonCmbRef.setDisabled(false);
        } else if (complaintAgainstValue === 'STUDENT') {
            var complaintantRef = cmb.up('form').down('#complaintantId');
            if (complaintantRef) {
                var ref = cmb.up('form').down('#complaintByFieldContainer');
                ref.remove(complaintantRef);
                ref.insert(1, {
                    xtype: 'livesearchcombo',
                    labelAlign: 'top',
                    name: 'complainant',
                    fieldLabel: getServiceRequestTranslation('SELECT_COMPLAINTANT'),
                    store: 'Academia.store.servicerequest.complaintrequest.Complaintant',
                    itemId: 'selectComplaintantId',
                    allowBlank: false,
                    disabled: true,
                    displayTpl: new Ext.XTemplate('<tpl for="."between=" ">', '{[typeof values === "string" ? values : values["value"]]}' + '</tpl>')
                });
            }
            var selectPersonCmbRef = cmb.up('form').down('#selectComplaintantId');
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(complaintAgainstValue);
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_STUDENT_COMBO;
            store.load();
            selectPersonCmbRef.setVisible(true);
            selectPersonCmbRef.setDisabled(false);
        } else if (complaintAgainstValue === 'STAFF') {
            var complaintantRef = cmb.up('form').down('#complaintantId');
            if (complaintantRef) {
                var ref = cmb.up('form').down('#complaintByFieldContainer');
                ref.remove(complaintantRef);
                ref.insert(1, {
                    xtype: 'livesearchcombo',
                    labelAlign: 'top',
                    name: 'complainant',
                    fieldLabel: getServiceRequestTranslation('SELECT_COMPLAINTANT'),
                    store: 'Academia.store.servicerequest.complaintrequest.Complaintant',
                    itemId: 'selectComplaintantId',
                    allowBlank: false,
                    disabled: true,
                    displayTpl: new Ext.XTemplate('<tpl for="."between=" ">', '{[typeof values === "string" ? values : values["value"]]}' + '</tpl>')
                });
            }
            var selectPersonCmbRef = cmb.up('form').down('#selectComplaintantId');
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(complaintAgainstValue);
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_STAFF_COMBO;
            store.load();
            selectPersonCmbRef.setVisible(true);
            selectPersonCmbRef.setDisabled(false);
        } else if (complaintAgainstValue === 'PARENTS') {
            var complaintantRef = cmb.up('form').down('#selectComplaintantId');
            if (complaintantRef) {
                var ref = cmb.up('form').down('#complaintByFieldContainer');
                ref.remove(complaintantRef);
                ref.insert(1, {
                    xtype: 'textfield',
                    fieldLabel: getServiceRequestTranslation('COMPLAINTANT'),
                    emptyText: getServiceRequestTranslation(complaintAgainstValue),
                    name: 'complainant',
                    itemId: 'complaintantId',
                    allowBlank: false
                });
                ref.doLayout();
            } else {
                var selectPersonCmbRef = cmb.up('form').down('#complaintantId');
                selectPersonCmbRef.emptyText = getServiceRequestTranslation(complaintAgainstValue);
                selectPersonCmbRef.reset();
            }
        } else if (complaintAgainstValue === 'OTHERS') {
            var complaintantRef = cmb.up('form').down('#selectComplaintantId');
            if (complaintantRef) {
                var ref = cmb.up('form').down('#complaintByFieldContainer');
                ref.remove(complaintantRef);
                ref.insert(1, {
                    xtype: 'textfield',
                    fieldLabel: getServiceRequestTranslation('COMPLAINTANT'),
                    emptyText: getServiceRequestTranslation(complaintAgainstValue),
                    name: 'complainant',
                    itemId: 'complaintantId',
                    allowBlank: false
                });
                ref.doLayout();
            } else {
                var selectPersonCmbRef = cmb.up('form').down('#complaintantId');
                selectPersonCmbRef.emptyText = getServiceRequestTranslation(complaintAgainstValue);
                selectPersonCmbRef.reset();
                selectPersonCmbRef.setVisible(true);
                selectPersonCmbRef.setDisabled(false);
            }
        }
    },
    changeSelectPersonComboName: function (cmb) {
        var selectPersonCmbRef = null;
        selectPersonCmbRef = cmb.up('form').down('#selectPersonId');
        var complaintAgainstValue = cmb.getValue();
        var store;
        if (complaintAgainstValue === 'FACULTY') {
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(complaintAgainstValue);
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_FACULTY_COMBO;
            store.load();
            selectPersonCmbRef.setVisible(true);
            selectPersonCmbRef.setDisabled(false);
        } else if (complaintAgainstValue === 'STUDENT') {
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(complaintAgainstValue);
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_STUDENT_COMBO;
            store.load();
            selectPersonCmbRef.setVisible(true);
            selectPersonCmbRef.setDisabled(false);
        } else if (complaintAgainstValue === 'STAFF') {
            selectPersonCmbRef.emptyText = getServiceRequestTranslation('EMPLOYEEE');
            selectPersonCmbRef.reset();
            store = selectPersonCmbRef.getStore();
            store.getProxy().api.read = SERVERURL.COMPLAINT_STAFF_COMBO;
            store.load();
            selectPersonCmbRef.setVisible(true);
            selectPersonCmbRef.setDisabled(false);
        } else if (complaintAgainstValue === 'NOT_APPLICABLE') {
            selectPersonCmbRef.emptyText = getServiceRequestTranslation(complaintAgainstValue);
            selectPersonCmbRef.setVisible(false);
            selectPersonCmbRef.setDisabled(true);
        }
    },
    validateComplaintAgainstValue: function (combo) {
        var form = combo.up("complaintdetailsform");
        var enteredBy = form.down("#enteredBy").value;
        var complaintAgainst = form.down("#selectPersonId").rawValue;
        if (!isNullOrEmpty(complaintAgainst) && enteredBy.trim() == complaintAgainst.trim()) {
            showWarningMessage(getServiceRequestTranslation('COMPLAINT'), getServiceRequestTranslation('COMPLAINT_AGAINT_YOURSELF'));
            return false;
        }
    },
    loadComplaintTypeCombo: function (cmb) {
        var store = cmb.getStore();
        store.getProxy().extraParams = {
            academyLocationId: this.getCurrentAcademyLocation()
        };
        store.load();
    },
    getComplaintRequestSettings: function (complaintTypeId, requestPanel) {
        var me = this;
        var param = {
            complaintTypeId: complaintTypeId,
            academyLocationId: me.getCurrentAcademyLocation()
        };
        var tab = this.getContentPanelActiveTab();
        me.sendGetAjaxRequest(SERVERURL.GET_COMPLAINT_SETTING, 'GET', param, function (opt, success, response) {
            if (success) {
                if (!isNullOrEmpty(response.responseText)) {
                    var settings = Ext.decode(response.responseText);
                    requestPanel.down('#settingId').setValue(settings.id);
                } else {
                    showWarningMessage(getServiceRequestTranslation('GRIEVANCE_REQUEST'), getServiceRequestTranslation('CONFIGURE_SETTINGS'));
                    me.closeTab(tab);
                }
            }
        });
    },
    getSettings: function (cmb) {
        var complaintTypeId = cmb.getValue();
        var requestPanel = cmb.up('form').up('form');
        this.getComplaintRequestSettings(complaintTypeId, requestPanel);
    },
    toggleQuestionWiseSection: function (radio, newValue, old) {
        var container = radio.up('form').down('#questionWiseForm');
        if (newValue.whetherQuestionWise === true) {
            container.setVisible(true);
            container.setDisabled(false);
            container.down('#questionNoId').reset();
            container.down('#questionNoPartId').reset();
            container.down('#questionNoPart1Id').reset();
            container.down('#revaluationgridId').getStore().removeAll();
        } else {
            container.setVisible(false);
            container.setDisabled(true);
        }
    },
    loadServiceOptedCombo: function (combo) {
        var tab = this.getContentPanelActiveTab();
        var id = '';
        var url = '';
        if (tab.getRequestType() === 'STUDENT_REQUEST') {
            id = tab.getAdmissionId();
            url = SERVERURL.FIND_ALL_SERVICE_FOR_STUDENT;
        } else {
            id = tab.getRequesterId();
            url = SERVERURL.FIND_ALL_SERVICE_FOR_FACULTY;
        }
        var store = combo.getStore();
        store.getProxy().api.read = url;
        if (!isNullOrEmpty(id)) {
            store.load({
                params: {
                    id: id
                }
            });
        }
    },
    loadServiceWithdrawCombo: function (combo) {
        var tab = this.getContentPanelActiveTab();
        var id = '';
        var url = '';
        if (tab.getRequestType() === 'STUDENT_REQUEST') {
            id = tab.getAdmissionId();
            url = SERVERURL.FIND_SERVICE_OPTED_BY_STUDENT;
        } else {
            id = tab.getRequesterId();
            url = SERVERURL.FIND_SERVICE_OPTED_BY_FACULTY;
        }
        var store = combo.getStore();
        store.getProxy().api.read = url;
        if (!isNullOrEmpty(id)) {
            store.load({
                params: {
                    id: id
                },
                callback: function (records, operation, success) {
                    if (combo.getItemId() === 'alreadySubscribedServices') {
                        combo.setValue(records);
                    }
                }
            });
        }
    },
    toggleServiceSubscribeCombo: function (radio, newVal, oldValue) {
        var subscribeCombo = radio.up('form').down('#servicesOpted');
        var withdrawCombo = radio.up('form').down('#servicesToWithdraw');
        var alreadySubscribedServicesCombo = radio.up('form').down('#alreadySubscribedServices');
        if (newVal.whetherSubscribed) {
            withdrawCombo.setVisible(false);
            withdrawCombo.setDisabled(true);
            subscribeCombo.setVisible(true);
            subscribeCombo.setDisabled(false);
            if (alreadySubscribedServicesCombo.isHidden()) {
                alreadySubscribedServicesCombo.setVisible(true);
                alreadySubscribedServicesCombo.setDisabled(true);
            }
            this.loadServiceWithdrawCombo(alreadySubscribedServicesCombo);
        } else {
            this.loadServiceWithdrawCombo(withdrawCombo);
            subscribeCombo.setVisible(false);
            subscribeCombo.setDisabled(true);
            alreadySubscribedServicesCombo.setVisible(false);
            alreadySubscribedServicesCombo.setDisabled(true);
            withdrawCombo.setVisible(true);
            withdrawCombo.setDisabled(false);
        }
    },
    saveWithdrawSubscribeServiceRequest: function (button) {
        var me = this;
        var form = button.up('form');
        var values = form.getValues();
        values.assignee = me.getContentPanelActiveTab().getAssignee();
        values.serviceRequest = null;
        var requestServices = '';
        !isEmpty(values.subscribedServices) ? requestServices = values.subscribedServices : requestServices = values.withdrawnServices;
        var services = new Array();
        Ext.each(requestServices, function (service) {
            if (service instanceof Object) {
                var id = service.get('id');
                var optService = new Object();
                optService.id = id;
                services.push(optService);
            }
        });
        !isEmpty(values.subscribedServices) ? values.subscribedServices = services : values.withdrawnServices = services;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    createServiceSubscribeWithdrawServiceRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        delete values.batchEndDate;
        delete values.requestStatusId;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    saveApplyForPlacementServiceRequest: function (button) {
        var me = this;
        var form = button.up('form');
        var values = form.getValues();
        values.requester = {
            id: me.getContentPanelActiveTab().getRequesterId()
        };
        delete values.requestStatusId;
        delete values.batchEndDate;
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    createApplyForPlacementRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        object.assigneeId = values.assignee.id;
        delete values.assignee;
        values.assignee = null;
        values.serviceRequest = null;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    loadPlacementProgramComboStore: function (cmb) {
        var store = cmb.getStore();
        store.load({
            params: {
                studentId: this.getContentPanelActiveTab().getRequesterId()
            }
        });
    },
    loadPeriodComboStore: function (cmb) {
        var periodCmb = cmb.up('form').down('#periodId');
        periodCmb.setDisabled(false);
        var store = periodCmb.getStore();
        store.load({
            params: {
                batchId: cmb.getValue('batchId')
            }
        });
    },
    setEnteredByName: function (form) {
        var enteredBy = form.down('#enterdById');
        enteredBy.setValue(this.getCurrentlyLoggedInUser().value);
    },
    showServiceRequestDocumentForm: function (button) {
        var grid = button.up('grid');
        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            this.getDocumentController().showDocumentFormWindow('serviceRequestDocumentForm', 'EXT_DOCUMENT');
            var formWindow = this.getDocumentController().getDocumentFormWindow();
            formWindow.setTitle(record.get('documentType').value);
            var combo = formWindow.down('#documentTypeCombo');
            formWindow.down('#submissionDate').setValue(new Date());
            var docTypes = new Array();
            docTypes.push(record.get('documentType'));
            var store = combo.getStore();
            store.loadData(docTypes);
            combo.setValue(record.get('documentType').id);
            combo.setReadOnly(true);
        } else {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    EditDocumentForm: function (button) {
        var grid = button.up('grid');
        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            var docId = record.raw.encryptedDocId;
            this.getDocumentController().editDocumentFormWindow('serviceRequestNewDocumentForm', 'EXT_DOCUMENT1', docId);
            var formWindow = this.getDocumentController().getDocumentFormWindow();
            formWindow.setTitle(record.get('documentType').value);
        } else {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    addDocumentPanel: function (tabPanel, isTrackRequest) {
        var serviceRequestSettings = tabPanel.getServiceRequestSetting();
        var panel = tabPanel.down('servicerequestdocumentspanel');
        var serviceRequestId = '';
        if (typeof tabPanel.getServiceRequestId != "undefined") {
            serviceRequestId = tabPanel.getServiceRequestId();
        }
        if (isNullOrEmpty(panel)) {
            tabPanel.add({
                xtype: 'servicerequestdocumentspanel',
                id: 'documentPanelServiceRequest' + serviceRequestId
            });
        }
        if (!isTrackRequest) {
            tabPanel.scrollBy(0, 600, true);
        }
        this.toggleMandatoryDocumentGrid(tabPanel, serviceRequestSettings, isTrackRequest);
        if (isTrackRequest === true) {
            var documentGrid = tabPanel.down('servicerequestvoluntarydocuments');
            var docComment = tabPanel.down('#RequestComments');
            var responseData = tabPanel.getResponseData();
            if (responseData.voluntaryDocuments.length !== 0) {
                documentGrid.getStore().loadData(responseData.voluntaryDocuments);
            } else {
                documentGrid.getStore().removeAll();
                documentGrid.setVisible(false);
                documentGrid.setDisabled(true);
            }
            if (!serviceRequestSettings.whetherDocumentRequired && responseData.voluntaryDocuments.length === 0) {
                tabPanel.remove('documentPanelServiceRequest' + serviceRequestId, true);
            }
            if (responseData.voluntaryDocuments.length > 0 || serviceRequestSettings.whetherDocumentRequired) {
                docComment.setValue(responseData.comment);
                docComment.setReadOnly(true);
            }
        }
    },
    addRequestActionDetailsPanel: function (tabPanel, isTrackRequest) {
        var serviceRequestSettings = tabPanel.getServiceRequestSetting();
        var panel = tabPanel.down('servicerequestactiondetailspanel');
        var serviceRequestId = '';
        if (typeof tabPanel.getServiceRequestId != "undefined") {
            serviceRequestId = tabPanel.getServiceRequestId();
        }
        if (!isNullOrEmpty(serviceRequestId) && isNullOrEmpty(panel)) {
            tabPanel.add({
                xtype: 'servicerequestactiondetailspanel'
            });
        }
    },
    toggleMandatoryDocumentGrid: function (formPanel, serviceRequestSettings, isTrackRequest) {
        var grid = formPanel.down('servicerequestmandatorydocuments');
        if (serviceRequestSettings && !serviceRequestSettings.whetherDocumentRequired) {
            grid.up('panel').setVisible(false);
            grid.setDisabled(true);
        } else {
            grid.up('panel').setVisible(true);
            grid.setDisabled(false);
            if (isTrackRequest) {
                var serviceRequestId = formPanel.getResponseData().id;
                grid.getStore().load({
                    params: {
                        serviceRequestId: serviceRequestId,
                        settingId: serviceRequestSettings.id
                    },
					callback: function(rec){
						if(rec.length == 0){
							grid.up('panel').setVisible(false);
							grid.setDisabled(true);
							grid.up('servicerequestdocumentspanel').toggleCollapse();
						}
					}
                });
            } else {
                var id = null;
				var isWaiveNotice;
				if(!isNullOrEmpty(formPanel.down()) && !isNullOrEmpty(formPanel.down().down("#isWaiveNoticeId"))){
					var waiveNoticeField = formPanel.down("#isWaiveNoticeId");
					if(waiveNoticeField.isVisible()){
						isWaiveNotice=waiveNoticeField.getValue();
					}			
				}
                formPanel.getRequestType() === 'FACULTY_REQUEST' ? id = formPanel.getRequesterId() : id = formPanel.getRequesterId();
                grid.getStore().load({
                    params: {
                        settingId: serviceRequestSettings.id,
                        serviceRequestCategory: serviceRequestSettings.serviceRequestCategory,
                        id: id
                    },
					callback: function (records, operation, success) {
						if(!isNullOrEmpty(isWaiveNotice) && !isWaiveNotice){
							Ext.Array.each(records, function (rec) {
							               if (rec.getData().documentType.value === 'Notice Waiver Approval') {
							                   grid.getStore().remove(rec);
							               }
							});
							if(grid.getStore().count() == 0){
								grid.up('panel').setVisible(false);
								grid.setDisabled(true);
							}
						}
					}
                });
            }
        }
    },
    saveServiceRequestDocumentForm: function (button) {
        this$ = this;
        var tab = this.getContentPanelActiveTab();
        var isTransient = null;
        var form = this.getDocumentController().getExtendedDocumentForm();
        var id = form.down('#document_hidden_field').getValue();
        if (!isNullOrEmpty(id)) {
            isTransient = false;
        } else {
            isTransient = true;
        }
        var module = 'service_request';
        var entityId = tab.getRequesterId();
        var entityType = 'service _request';
        var isDuplicate = null;
        this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function (success, response, isCallBackTransient) {
            if (success) {
                var documents = null;
                var documentObj = this$.createMandatoryDocumentJsonObject(response);
                documents = tab.getDocumentData();
                var isUnique = true;
                Ext.each(documents, function (doc) {
                    if (doc.documentType.id == documentObj.documentType.id) {
                        isUnique = false;
                    }
                });
                if (isUnique) {
                    if (documents == null) documents = new Array();
                    documents.push(documentObj);
                    tab.setDocumentData(documents);
                } else {
                    showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_EXISTS'));
                }
                this$.getDocumentController().closeDocumentFormWindow();
            }
        }, isTransient);
    },
    saveServiceRequest: function (button) {
        button.setDisabled(true);
        var mandatoryDocumentGrid = button.up('panel').down('servicerequestmandatorydocuments');
        var tab = this.getContentPanelActiveTab();
        var requestType = tab.getRequestGroup();
        var settings = tab.getServiceRequestSetting();
        var formData = tab.getFormData();
        if (formData.certificateStatus == 'CERTIFICATE_REQUESTED') {
            delete formData.withdrawDate;
            delete formData.dataToBeChangedId;
            if (settings.requestType && Ext.isString(formData.certificateId)) {
                formData.certificateId = settings.requestType.id;
            }
        }
        if (settings.requestType && (settings.requestType.code == "PT" || settings.requestType.code == "WFPO")) {
            delete formData.customData;
        }
        if (requestType == 'DEBRAMENT_REQUEST') {
            delete formData.customData;
            delete formData.batchEndDate;
        }
        if (formData.terminationReasonId && formData.terminationReasonId.length) {
            var btn = tab.down('#terminationSubmitBtn');
            this.saveStudentTerminationServiceRequest(btn);
            var formData = tab.getFormData();
            var hasDuplicatesVal = hasDuplicates(formData.terminationReasonId);
            if (hasDuplicatesVal) {
                showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SELECT_SINGLE_TERMINATION_REASON'));
                button.setDisabled(false);
                return false;
            }
        } else if (tab.down('#programWithdrawSubmitBtn') && formData.leavingReasonId && formData.leavingReasonId.length) {
            var btn = tab.down('#programWithdrawSubmitBtn');
            this.saveWithdrawProgramServiceRequest(btn);
            var formData = tab.getFormData();
            var hasDuplicatesVal = hasDuplicates(formData.leavingReasonId);
            if (hasDuplicatesVal) {
                showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SELECT_SINGLE_TERMINATION_REASON'));
                button.setDisabled(false);
                return false;
            }
        } else if (tab.down('#programSubmitBtn') && formData.leavingReasonId && formData.leavingReasonId.length) {
            var btn = tab.down('#programSubmitBtn');
            this.saveWithdrawProgramServiceRequest(btn);
            var formData = tab.getFormData();
            var hasDuplicatesVal = hasDuplicates(formData.leavingReasonId);
            if (hasDuplicatesVal) {
                showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SELECT_SINGLE_TERMINATION_REASON'));
                button.setDisabled(false);
                return false;
            }
        } else if (tab.down('#leaveOfAbsenceReqUploadSubmitBtn') && formData.leavingReasonId && formData.leavingReasonId.length) {
            var btn = tab.down('#leaveOfAbsenceReqUploadSubmitBtn');
            this.submitStudentLeaveOfAbsenceRequestUploadServiceRequest(btn);
            var formData = tab.getFormData();
            var hasDuplicatesVal = hasDuplicates(formData.leavingReasonId);
            if (hasDuplicatesVal) {
                showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SELECT_SINGLE_TERMINATION_REASON'));
                button.setDisabled(false);
                return false;
            }
        } else if (tab.down('#btnSaveDebarment') && formData.leavingReasonId && formData.leavingReasonId.length) {
            var btn = tab.down('#btnSaveDebarment');
            this.saveStudentDebarmentServiceRequest(btn);
            var formData = tab.getFormData();
            var hasDuplicatesVal = hasDuplicates(formData.leavingReasonId);
            if (hasDuplicatesVal) {
                showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SELECT_SINGLE_DEBARMENT_REASON'));
                button.setDisabled(false);
                return false;
            }
        }
        if (settings.requestType && settings.requestType.code == "PT") {
            delete formData.customData;
        }
        if (settings.requestType && settings.requestType.code == "STDTRAN") {
            var fromProgramIdtemp = tab.down('#fromProgramId');
            formData.admissionId = fromProgramIdtemp.getStore().findRecord(fromProgramIdtemp.valueField, fromProgramIdtemp.getValue()).raw.sequence;
        }
        if (formData.terminationReasonId && formData.terminationReasonId.length) {
            var btn = tab.down('#terminationSubmitBtn');
            this.saveStudentTerminationServiceRequest(btn);
            var formData = tab.getFormData();
            var hasDuplicatesVal = hasDuplicates(formData.terminationReasonId);
            if (hasDuplicatesVal) {
                showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SELECT_SINGLE_TERMINATION_REASON'));
                button.setDisabled(false);
                return false;
            }
        }
        delete formData.freeFormRequestSubTypeId;
        var requestcmnt = tab.down('#RequestComments').getValue();
        if (formData.requesterType == 'PARENT') {
            formData.requesterType = 'PARENTS';
        }
        if (requestType == 'TERMINATION_REQUEST') {
            if (this.getCurrentlyLoggedInUser().id == 1) formData.requesterType = 'ACADEMIC_ADMINISTRATOR';
            if (this.getCurrentlyLoggedInUser().id == 2) formData.requesterType = 'FACULTY';
            if (this.getCurrentlyLoggedInUser().id == 3) formData.requesterType = 'STUDENT';
            if (this.getCurrentlyLoggedInUser().id == 7) formData.requesterType = 'PARENTS';
        }
        var defaultAssignee = new Object();
        if (settings.isStudentAdivsor == true) {
            defaultAssignee.id = formData.defultAssgineID;
            defaultAssignee.value = formData.defultAssgineName;
            defaultAssignee.code = formData.defultAssgineCode;
            defaultAssignee.sequence = null;
            defaultAssignee.displayOtherLanguage = null;
        }
        if (formData.leaveRequest == "Other") {
            delete formData.defultAssgineID;
            delete formData.defultAssgineName;
            delete formData.defultAssgineCode;
            if (isEmpty(settings.defaultAssignee)) {
                settings.defaultAssignee = defaultAssignee;
            }
        }
        formData.comment = requestcmnt;
        if (!isNullOrEmpty(formData.batchEndDate)) {
            delete formData.batchEndDate;
        }
        if (Ext.isDefined(formData.serviceRequestCourseVariant)) {
            delete formData.serviceRequestCourseVariant;
        }
        try {
            if (settings && settings.requestType && settings.requestType.code && settings.requestType.code == "LOA") {} else {
                try {
                    delete formData.periodId;
                } catch (e) {}
            }
        } catch (e) {}
        if (formData.detail != undefined) {
            if (formData.detail.dataToBeChanged != undefined) {
                if (formData.detail.dataToBeChanged.eventId != undefined && isNullOrEmpty(formData.detail.dataToBeChanged.eventId)) {
                    delete formData.detail.dataToBeChanged.eventId;
                }
                delete formData.detail.dataToBeChanged.experienceInYear;
                delete formData.detail.dataToBeChanged.experienceInMonth;
                if (formData.detail.dataToBeChanged.latitude != undefined) {
                    delete formData.detail.dataToBeChanged.latitude;
                }
                if (formData.detail.dataToBeChanged.longitude != undefined) {
                    delete formData.detail.dataToBeChanged.longitude;
                }
                if (formData.detail.dataToBeChanged.latitude != undefined) {
                    delete formData.detail.dataToBeChanged.latitude;
                }
                if (formData.detail.dataToBeChanged.longitude != undefined) {
                    delete formData.detail.dataToBeChanged.longitude;
                }
				if(isNullOrEmpty(formData.detail.dataToBeChanged.pincodeNew)) {
					delete formData.detail.dataToBeChanged.pincodeNew;
				}
                if (formData.serviceRequestSetting.serviceRequestCategory == "STUDENT_REQUEST") {
                    if (formData.serviceRequestSetting.requestType.code == "PDCPDC") {
                        delete formData.detail.dataToBeChanged.admissionCodeField;
                        delete formData.detail.dataToBeChanged.admissionCode;
                        delete formData.detail.dataToBeChanged.isAgencyRequired;
                    }
                    delete formData.detail.dataToBeChanged.addressTextOtherLanguage;
                    delete formData.detail.dataToBeChanged.faxNumber;
                    delete formData.detail.dataToBeChanged.industry;
                    if (isNullOrEmpty(formData.detail.dataToBeChanged.armsOfService)) {
                        delete formData.detail.dataToBeChanged.armsOfService;
                    }
                    if (isNullOrEmpty(formData.detail.dataToBeChanged.advisorId)) {
                        delete formData.detail.dataToBeChanged.advisorId;
                    }
                    if (isNullOrEmpty(formData.detail.dataToBeChanged.IDType)) {
                        delete formData.detail.dataToBeChanged.IDType;
                    }
                    if (isNullOrEmpty(formData.detail.dataToBeChanged.examCenterVenue)) {
                        delete formData.detail.dataToBeChanged.examCenterVenue;
                    }
                    delete formData.detail.dataToBeChanged.applyUpdateToSiblings;
                }
                if (formData.detail.dataToBeChanged.addressesToBeChanged != null) {
                    if (formData.detail.dataToBeChanged.addressesToBeChanged.length > 0) {
                        var reqData = formData.detail.dataToBeChanged.addressesToBeChanged;
                        for (var i in reqData) {
                            delete formData.detail.dataToBeChanged.addressesToBeChanged[i].addressTextOtherLanguage;
                        }
                        delete formData.detail.dataToBeChanged.addressesToBeChanged[0].faxNumber;
                    }
                }
            }
        }
        var documentData = tab.getDocumentData();
        var voluntaryDocument = tab.getVoluntaryDocument();
        if (!isNullOrEmpty(documentData)) {
            if (mandatoryDocumentGrid.getStore().getCount() == documentData.length) {
                this.sendSaveServiceRequestRequest(requestType, formData, documentData, voluntaryDocument, tab);
            } else {
                showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('UPLOAD_MANDATORY_DOCUMENTS'));
            }
        } else if (settings.whetherDocumentRequired && mandatoryDocumentGrid.getStore().getCount()!=0) {
            showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('UPLOAD_MANDATORY_DOCUMENTS'));
        } else {
            this.sendSaveServiceRequestRequest(requestType, formData, documentData, voluntaryDocument, tab);
        }
        button.setDisabled(false);
    },
    sendSaveServiceRequestRequest: function (requestType, formData, documentData, voluntaryDocument, tab) {
        var me = this;
        var map = Academia.view.servicerequest.ServiceRequestViewMap;
        var url = null;
        var ConcessionReqType;
        var concessionFormFilledUp;
        var SearchForm = this.getFindRequestForm();
        var trackrequestpanel;
        var cbGrid;
        if (SearchForm != undefined) {
            trackrequestpanel = SearchForm.up('trackrequestpanel');
            if (SearchForm != undefined) {
                cbGrid = trackrequestpanel.down('#trackRequestGrid');
            }
        }
        if (isNullOrEmpty(formData.serviceRequestSetting)) {
            var setting = tab.getServiceRequestSetting();
            formData.serviceRequestSetting = setting;
        }
        if (requestType === 'TRANSFER') {
            var setting = tab.getServiceRequestSetting();
            var id = setting.requestType.id;
            url = map.getSaveUrlForOtherRequestType(id);
        } else if (requestType === 'EXAM_RELATED') {
            var setting = tab.getServiceRequestSetting();
            var id = setting.requestType.id;
            ConcessionReqType = setting.requestType.code;
            url = map.getSaveUrlForOtherRequestType(id);
            if (setting.requestType.code == "ECER") {
                var examConcessionFormID = tab.getSettingId();
            }
        } else if(tab.title == 'Readmission'  || tab.title =='Readmission Request') {
            url = SERVERURL.SAVE_READMISSION_REQUEST;
            
        }else {
        	if(requestType=="HOSTEL_LEAVE"){
        		requestType="OTHER";
        	}
            url = map.getSaveUrlForRequestType(requestType);
            var requestTypeCode = tab.getRequestTypeCode();
            if (!isNullOrEmpty(requestTypeCode) && requestTypeCode == "LR") {
                var setting = tab.getServiceRequestSetting();
                var id = setting.requestType.id;
                url = map.getSaveUrlForOtherRequestType(id);
            }
        }
        var data = this.getSubmitFormDataAccordingToRequestType(requestType, formData, documentData, voluntaryDocument, tab);
        if(tab.title == 'Readmission'  || tab.title =='Readmission Request') {
            delete data.detail.admissionId;
            delete data.detail.studentId;
            delete data.detail.isDrafted;
            if(!isNullOrEmpty(data.detail.readmissionRequestParentDetail)){
            	 for (var i = 0; i < (data.detail.readmissionRequestParentDetail).length; i++) {
            		 delete data.detail.readmissionRequestParentDetail[i].readmissionRequestDetailTemp;
            	 }
            }
            
        }
        if (requestType == 'TRANSFER' && !isNullOrEmpty(data.detail)) {
            delete data.detail.customData;
        }
        if (!isNullOrEmpty(data)) {
            if (!isNullOrEmpty(data.documents)) {
                for (var i = 0; i < data.documents.length; i++) {
                    if (data.documents[i].modeOfSubmission != undefined) {
                        delete data.documents[i].modeOfSubmission;
                    }
                    if (data.documents[i].modeOfReturn != undefined) {
                        delete data.documents[i].modeOfReturn;
                    }
                    if (data.documents[i].returnedDate != undefined) {
                        delete data.documents[i].isReturnable;
                    }
                    if (data.documents[i].isReturnable != undefined) {
                        delete data.documents[i].returnedDate;
                    }
                }
            }
        }
        if ((!isNullOrEmpty(url) && url == SERVERURL.SAVE_PROGRAM_TRANSFER_REQUEST) || (!isNullOrEmpty(tab.getRequestTypeCode()) && tab.getRequestTypeCode() == "PT")
        	|| (!isNullOrEmpty(url) && url == SERVERURL.SAVE_LEAVE_OF_ABSENCE_REQUEST) || (!isNullOrEmpty(tab.getRequestTypeCode()) && tab.getRequestTypeCode() == "LOA")
        	|| (!isNullOrEmpty(url) && url == SERVERURL.SAVE_EXCHANGE_SEMESTER_SERVICE_REQUEST) || (!isNullOrEmpty(tab.getRequestTypeCode()) && tab.getRequestTypeCode() == "ES") 
        	|| (!isNullOrEmpty(url) && url == SERVERURL.SAVE_WITHDRAW_PROGRAM_REQUEST) || (!isNullOrEmpty(tab.getRequestTypeCode()) && tab.getRequestTypeCode() == "WFPO")
        	|| (!isNullOrEmpty(url) && url == SERVERURL.SAVE_STUDENT_TRANSFER_REQUEST) || (!isNullOrEmpty(tab.getRequestTypeCode()) && tab.getRequestTypeCode() == "STDTRAN")
        	|| (!isNullOrEmpty(url) && url == SERVERURL.SAVE_TERMINATION_REQUEST) || (!isNullOrEmpty(tab.getRequestTypeCode()) && tab.getRequestTypeCode() == "TREO")
        	|| (!isNullOrEmpty(url) && url == SERVERURL.SAVE_DEBARMENT_REQUEST) || (!isNullOrEmpty(tab.getRequestTypeCode()) && tab.getRequestTypeCode() == "DR"))
        {
            data.detail.portalId = portalId
        }
        if (!isNullOrEmpty(url) && (url == SERVERURL.SAVE_STUDENT_TRANSFER_REQUEST || url == "rest/leaveServiceRequest " || url == "rest/hostelLeaveRequest" || url == "rest/serviceSubscribeWithdrawServiceRequest")) {
            delete data.detail.withdrawDate;
        }
        if (data && data.detail && data.detail.studentReturnStatus && isNullOrEmpty(data.detail.studentReturnStatus.id) && url == SERVERURL.SAVE_LEAVE_OF_ABSENCE_REQUEST) {
            delete data.detail.studentReturnStatus;
        }
        
        var dietPreference = null;
        if(!isNullOrEmpty(data.detail)){
        if(!isNullOrEmpty(data.detail.dataToBeChanged)){
        if(data.detail.dataToBeChanged.dataToBeChangedType==='PERSONALDATATOBECHANGED'){	
        if(!isNullOrEmpty(data.detail.dataToBeChanged.dietPreference)) {
        	dietPreference = {
                    id: data.detail.dataToBeChanged.dietPreference
            };
 		}
        data.detail.dataToBeChanged.dietPreference = dietPreference;
        
        var idtype = null;
        if(!isNullOrEmpty(data.detail.dataToBeChanged.idtype)) {
        	idtype = {
                    id: data.detail.dataToBeChanged.idtype
            };
 		}
        data.detail.dataToBeChanged.idtype = idtype;
        
        var maritalStatusId = null;
        if(!isNullOrEmpty(data.detail.dataToBeChanged.maritalStatus)){
        	maritalStatusId = {
                    id: data.detail.dataToBeChanged.maritalStatus
                };
        }
        data.detail.dataToBeChanged.maritalStatusId = maritalStatusId;
        
        var studentStatus = null;
        if(!isNullOrEmpty(data.detail.dataToBeChanged.studentStatus)){
        	studentStatus = {
                    id: data.detail.dataToBeChanged.studentStatus
                };
        }
        data.detail.dataToBeChanged.studentStatus = studentStatus;
        }
        }
        delete data.detail.dataToBeChangedId;
      }
        var disabilityJsonArry = [];
        if(!isNullOrEmpty(data.detail)){
        	 if(!isNullOrEmpty(data.detail.dataToBeChanged)){
        		 if(data.detail.dataToBeChanged.dataToBeChangedType==='PERSONALDATATOBECHANGED'){
        	     	if(!isNullOrEmpty(data.detail.dataToBeChanged.haveDisabilities) && !isNullOrEmpty(data.detail.dataToBeChanged.haveDisabilities[0])){
        	     		Ext.each(data.detail.dataToBeChanged.haveDisabilities, function(currentDisability){
        	             	var haveDisabilities = '';
        	             	var studentPerson = '';
        	             	var mainObj = '';
        	             	var disabilityId = '';
        	             	try{
        	             		disabilityId = currentDisability.data.id;
        	             	}
        	             	catch(e){
        	             		disabilityId = currentDisability.id;
        	             	}
        	             	if(!isNullOrEmpty(disabilityId)){
        	            		mainObj = {
        	            				"haveDisabilities" : {
        	            					"id" : disabilityId
        	          				},
        	         				"studentPerson" : {
        	          					"id": data.detail.dataToBeChanged.personId
        	          				}		
        	            		}
        	             		if(portalId==3 && !isNullOrEmpty(data.detail.dataToBeChanged.personId)){
        	                        mainObj = {
        	                                "haveDisabilities" : {
        	                                    "id" : disabilityId
        	                                },
        	                                "studentPerson" : {
        	                                    "id": data.detail.dataToBeChanged.personId
        	                                }        
        	                        }
        	                    }else{
        	                        mainObj = {
        	                                "haveDisabilities" : {
        	                                    "id" : disabilityId
        	                                },
        	                                "studentPerson" : {
        	                                    "id": data.detail.dataToBeChanged.personId
        	                                }        
        	                        }
        	                    }
        	             		disabilityJsonArry.push(mainObj);
        	             	}
        	             });	
        	     	}
        	     	
        	     	data.detail.dataToBeChanged.personDisability = disabilityJsonArry;
        	     	delete data.detail.dataToBeChanged.haveDisabilities;
        	     	
     	 var eduInterventionsJsonArry = [];
		 if(!isNullOrEmpty(formData.detail.dataToBeChanged.currentEducationalInterventions) && !isNullOrEmpty(data.detail.dataToBeChanged.currentEducationalInterventions[0])){
         		Ext.each(formData.detail.dataToBeChanged.currentEducationalInterventions, function(currentEduInterventions){
                 	var educationInterventions = '';
                 	var studentPerson = '';
                 	var mainObj = '';
                 	var EduInterventionsId = '';
                 	try{
                 		EduInterventionsId = currentEduInterventions.data.id;
                 	}
                 	catch(e){
                 		EduInterventionsId = currentEduInterventions.id;
                 	}
                 	if(!isNullOrEmpty(EduInterventionsId)){
                 		mainObj = {
                 				"educationInterventions" : {
                 					"id" : EduInterventionsId
                 				},
                 				"studentPerson" : {
                 					"id": data.detail.dataToBeChanged.personId
                 				}		
                 		}
						if(portalId==3 && !isNullOrEmpty(data.detail.dataToBeChanged.personId)){
                      mainObj = {
                        "educationInterventions" : {
                            "id" : EduInterventionsId
                        },
                        "studentPerson" : {
                            "id": data.detail.dataToBeChanged.personId
                        }        
                      }
                 }else{
                 mainObj = {
                        "educationInterventions" : {
                            "id" : EduInterventionsId
                        },
                        "studentPerson" : {
                            "id": data.detail.dataToBeChanged.personId
                        }        
                }
            }
                 		eduInterventionsJsonArry.push(mainObj);
                 	}
                 });	
         	}
		    data.detail.dataToBeChanged.personEducationInterventions = eduInterventionsJsonArry;
            delete formData.detail.dataToBeChanged.currentEducationalInterventions;

        	     	var departmentArray = [];
        	     	var duplicateIdMap = new Ext.util.HashMap();
        	     	if (!isNullOrEmpty(data.detail.dataToBeChanged.employeeLanguage)) {
        	     	    // Ensure employeeLanguage is always an array
        	     	    var employeeLanguages = Array.isArray(data.detail.dataToBeChanged.employeeLanguage) 
        	     	        ? data.detail.dataToBeChanged.employeeLanguage 
        	     	        : [data.detail.dataToBeChanged.employeeLanguage];

        	     	    var readValues = Array.isArray(data.detail.dataToBeChanged.read) 
        	     	        ? data.detail.dataToBeChanged.read 
        	     	        : [data.detail.dataToBeChanged.read];

        	     	    var speakValues = Array.isArray(data.detail.dataToBeChanged.speak) 
        	     	        ? data.detail.dataToBeChanged.speak 
        	     	        : [data.detail.dataToBeChanged.speak];

        	     	    var writeValues = Array.isArray(data.detail.dataToBeChanged.write) 
        	     	        ? data.detail.dataToBeChanged.write 
        	     	        : [data.detail.dataToBeChanged.write];

        	     	    var langIds = Array.isArray(data.detail.dataToBeChanged.langId) 
        	     	        ? data.detail.dataToBeChanged.langId 
        	     	        : [data.detail.dataToBeChanged.langId];

        	     	    for (var i = 0; i < employeeLanguages.length; i++) {
        	     	        var newData = {
        	     	            "multiLanguage": this.getIdValueJson(employeeLanguages[i], employeeLanguages[i]),
        	     	            "read": this.getIdValueJson(readValues[i], readValues[i]),
        	     	            "speak": this.getIdValueJson(speakValues[i], speakValues[i]),
        	     	            "write": this.getIdValueJson(writeValues[i], writeValues[i]),
        	     	            "person": this.getIdValueJson(data.detail.dataToBeChanged.personId, data.detail.dataToBeChanged.personId),
        	     	            "id": langIds[i] // Ensuring ID is taken properly
        	     	        };

        	     	        if (!isNullOrEmpty(newData.multiLanguage)) {
        	     	            delete newData.multiLanguage.value;
        	     	        }
        	     	        departmentArray.push(newData);
        	     	    }
        	     	}

        	     	data.detail.dataToBeChanged.languageCompetency = departmentArray;

        	     	delete data.detail.dataToBeChanged.langId;
        	     	delete data.detail.dataToBeChanged.read;
        	     	delete data.detail.dataToBeChanged.write;
        	     	delete data.detail.dataToBeChanged.speak;
        	     	delete data.detail.dataToBeChanged.employeeLanguage;
        	     	delete data.detail.dataToBeChanged.maritalStatus;
        	     	delete data.detail.dataToBeChanged.isAutomateExchange;
        	     	}
        	 }
        }
       
        var submitData = Ext.encode(data);
        if (ConcessionReqType == "ECER") {
            if (examConcessionFormID) {
                Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                this.sendSaveAjaxRequest(url, 'POST', submitData, function (opt, success, response) {
                    if (success) {
                        Ext.getBody().unmask();
                        showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
                        me.closeTab(tab);
                        if (cbGrid != undefined) {
                            cbGrid.getStore().load();
                            cbGrid.getSelectionModel().deselectAll();
                        }
                    } else {
                        var resp = Ext.decode(response.responseText);
                        if (!isNullOrEmpty(resp)) {
                            if (resp[0].key == 'program_request_already_present') {
                                showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getErrorTranslation('program_request_already_present'));
                            } else {
                                showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), resp[0].key);
                            }
                        }
                    }
                });
            } else {
                try {
                    if (contentPanel.getActiveTab().xtype == "servicerequestpanel") {
                        var formVals = contentPanel.getActiveTab().down('form').getValues();
                        try {
                            var preVals = contentPanel.getActiveTab().getFormData();
                            formVals.requester = {
                                id: preVals.requester.id
                            };
                        } catch (err) {
                            console.log(err);
                        }
                        contentPanel.getActiveTab().setFormData(formVals);
                    }
                } catch (e) {}
                showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('PLEASE_FILL_CONCESSION_FORM'));
            }
        } else {
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            this.sendSaveAjaxRequest(url, 'POST', submitData, function (opt, success, response) {
                if (success) {
                    Ext.getBody().unmask();
                    showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
                    me.closeTab(tab);
                    if (cbGrid != undefined) {
                        cbGrid.getStore().load();
                        cbGrid.getSelectionModel().deselectAll();
                    }
                } else {
                    var resp = Ext.decode(response.responseText);
                    if (!isNullOrEmpty(resp)) {
                        if (resp[0].key == "REQUEST_CANT_RAISED") {
                            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('REQUEST_CANT_RAISED'));
                            me.closeTab(tab);
                        } else if (SERVERURL.SAVE_DEBARMENT_REQUEST == response.request.options.url && resp[0].key == "Debarment_request_already_present") {
                            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('DEBARMENT_ALREADY_PRESENT'));
                            me.closeTab(tab);
                        }else if (resp[0].key == "MULTIPLE_FLOW_ALERT") {
                            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('MULTIPLE_FLOW_ALERT'));
                            me.closeTab(tab);
                        } else {
                            me.closeTab(tab);
                        }
                        if (cbGrid != undefined) {
                            cbGrid.getStore().load();
                            cbGrid.getSelectionModel().deselectAll();
                        }
                    }
                }
            });
        }
    },
    ShowConfrimationBoxOnCheckAndUncheckOnRetainData: function (form) {
        var me = this;
        var StudentTransferExecutionDetailsform = me.getStudentTransferExecutionDetails();
        formData = StudentTransferExecutionDetailsform.getForm().getFieldValues();
        var requestStatusId = StudentTransferExecutionDetailsform.up().getResponseData().requestStatusId;
        if (requestStatusId == 6) {
            formData = StudentTransferExecutionDetailsform.getForm().getFieldValues();
            delete formData.userId;
            delete formData.displayCheckFeesAndDocMsg;
            var executionTab = me.getContentPanelActiveTab();
            var serviceRequestId = executionTab.getServiceRequestId();
            var user = me.getCurrentlyLoggedInUser();
            var url = SERVERURL.UPDATE_STUDENT_TRANSFER_EXECUTION;
            formData.serviceRequestId = serviceRequestId;
            formData.user = user;
            var jsonFormatFormData = Ext.encode(formData);
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            this$.sendSaveAjaxRequest(url, 'POST', jsonFormatFormData, function (opt, success, response) {
                Ext.getBody().unmask();
                if (success) {
                    showSuccessMessage(getServiceRequestTranslation('EXECUTION_DETAILS'), getServiceRequestTranslation('EXECUTION_DETAILS_SUCCESS'));
                    if (executionTab.getRequestType() === 'STUDENT_REQUEST' || executionTab.getRequestType() === 'TRANSFER_REQUEST') {
                        me.loadStudentGridAndSearchRequest();
                    } else if (executionTab.getRequestType() === 'FACULTY_REQUEST') {
                        me.loadFacultyGridAndSearchRequest();
                    }
                    me.closeTab(executionTab);
                }
            });
        } else {
            var isRetainAcademicData = formData.isRetainAcademicData;
            var isRetainServicesOpted = formData.isRetainServicesOpted;
            var isRetainFeesPaymentData = formData.isRetainFeesPaymentData;
            var isRetainStudentData = formData.isRetainStudentData;
            if (isRetainAcademicData == true && isRetainFeesPaymentData == false) {
                showConfirmMessage(getServiceRequestTranslation('REQUEST_CLOSURE_CONFIRMATION'), getServiceRequestTranslation('EXECUTION_CONFIRMATION_MESSAGE_I'), function (btn, text) {
                    if (btn == 'yes') {
                        me.submitExecutionDetailsForm(form);
                    }
                });
            } else if (isRetainAcademicData == false && isRetainFeesPaymentData == true) {
                showConfirmMessage(getServiceRequestTranslation('REQUEST_CLOSURE_CONFIRMATION'), getServiceRequestTranslation('EXECUTION_CONFIRMATION_MESSAGE_II'), function (btn, text) {
                    if (btn == 'yes') {
                        me.submitExecutionDetailsForm(form);
                    }
                });
            } else if (isRetainAcademicData == false && isRetainFeesPaymentData == false) {
                showConfirmMessage(getServiceRequestTranslation('REQUEST_CLOSURE_CONFIRMATION'), getServiceRequestTranslation('EXECUTION_CONFIRMATION_MESSAGE_III'), function (btn, text) {
                    if (btn == 'yes') {
                        me.submitExecutionDetailsForm(form);
                    }
                });
            } else if (isRetainStudentData == false) {
                showConfirmMessage(getServiceRequestTranslation('REQUEST_CLOSURE_CONFIRMATION'), getServiceRequestTranslation('EXECUTION_CONFIRMATION_MESSAGE_III'), function (btn, text) {
                    if (btn == 'yes') {
                        me.submitExecutionDetailsForm(form);
                    }
                });
            } else if (isRetainAcademicData == true && isRetainFeesPaymentData == true) {
                me.submitExecutionDetailsForm(form);
            }
        }
    },
    getSubmitFormDataAccordingToRequestType: function (requestType, formData, documentData, voluntaryDocument, tab) {
        var submitData = null;
        var serviceRequestConstants = this.getServiceRequestConstant();
        switch (requestType) {
        case 'CERTIFICATE':
            {
                submitData = this.createServiceRequestJson(formData, documentData, voluntaryDocument);
                break;
            }
        case 'FREE_FORM':
            {
                submitData = this.createFreeFormRequestJson(formData, documentData, voluntaryDocument);
                break;
            }
        case 'TERMINATION_REQUEST':
            {
                submitData = this.createStudentTerminationRequestJson(formData, documentData, voluntaryDocument);
                break;
            }
        case 'TRANSFER_REQUEST':
            {
                submitData = this.createStudentTransferRequestJson(formData, documentData, voluntaryDocument);
                break;
            }
        case 'DEBRAMENT_REQUEST':
            {
                submitData = this.createStudentDebarmentRequestJson(formData, documentData, voluntaryDocument);
                break;
            }
        case 'PERSONAL_DATA_CHANGE':
            {
                formData.documents = documentData;
                formData.voluntaryDocuments = voluntaryDocument;
                try {
					if(!isNullOrEmpty(formData.detail.dataToBeChanged)){
                    delete formData.detail.dataToBeChanged.isAlumnus;
                    delete formData.detail.dataToBeChanged.schoolAttended;
                    if (isNullOrEmpty(formData.detail.dataToBeChanged.currentActivity)) {
                    delete formData.detail.dataToBeChanged.currentActivity;
                    }
                    if (isNullOrEmpty(formData.detail.dataToBeChanged.examCenterCSM)) {
                    delete formData.detail.dataToBeChanged.examCenterCSM;
                    }
                    delete formData.detail.dataToBeChanged.castCategory;
                    if (isNullOrEmpty(formData.detail.dataToBeChanged.currentEducationalInterventions)) {
                    delete formData.detail.dataToBeChanged.currentEducationalInterventions;
                    }
                    delete formData.detail.dataToBeChanged.consentedCommunicationChannel;
                    delete formData.detail.dataToBeChanged.relationship;
                    if (isNullOrEmpty(formData.detail.dataToBeChanged.accountTypeId)) {
                    delete formData.detail.dataToBeChanged.accountTypeId;
                    }
                    delete formData.detail.dataToBeChanged.checkboxDropdown;
                    if (formData.detail.dataToBeChanged.addressesToBeChanged[0].latitude != undefined) {
                        delete formData.detail.dataToBeChanged.addressesToBeChanged[0].latitude;
                    }
                    if (formData.detail.dataToBeChanged.addressesToBeChanged[0].longitude != undefined) {
                        delete formData.detail.dataToBeChanged.addressesToBeChanged[0].longitude;
                    }
                }} catch (e) {}
                submitData = formData;
                break;
            }
        case 'TRANSFER':
            {
                var settings = tab.getServiceRequestSetting();
                var id = settings.requestType.id;
                if (id == serviceRequestConstants.getRequestStatus('OTHER_SCHOLERSHIP_REQUEST_CONSTANT')) {
                    submitData = this.createScholarshipServiceRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_PROGRAM_TRANSFER_REQUEST_CONSTANT')) {
                	if(contentPanel && contentPanel.getActiveTab() && contentPanel.getActiveTab().admissionId && !isNullOrEmpty(contentPanel.getActiveTab().admissionId) ) {
                		formData.admissionId = contentPanel.getActiveTab().admissionId;
                    	formData.fromBatchId = contentPanel.getActiveTab().programBatchId;
                	}
                	submitData = this.createProgramTransferRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_LEAVE_REQUEST_CONSTANT')) {
                    submitData = this.createLeaveRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_EMPLOYEE_LEAVE_SERVICE_REQUEST_CONSTANT')) {
                    submitData = this.createEmployeeLeaveRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_COURSE_TRANSFER_REQUEST_CONSTANT')) {
                    submitData = this.createCourseTransferRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_WITHDRAW_PROGRAM_REQUEST_CONSTANT')) {
                    submitData = this.createWithdrawProgramRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_WITHDRAW_COURSE_REQUEST_CONSTANT')) {
                    submitData = this.createWithdrawCourseRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_SUBSCRIBE_WITHDRAW_SERVICES_REQUEST_CONSTANT')) {
                    submitData = this.createServiceSubscribeWithdrawServiceRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_APPLY_FOR_PLACEMENT_REQUEST_CONSTANT')) {
                    submitData = this.createApplyForPlacementRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_SECTION_TRANSFER_REQUEST_CONSTANT')) {
                    submitData = this.createSectionTransferRequestJson(formData, documentData, voluntaryDocument);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_ACADEMY_STUDENT_TRANSFER_REQUEST_CONSTANT')) {
                    submitData = this.createOtherAcademyStudentTransferRequestJson(formData, documentData, voluntaryDocument, id, tab.programBatchId, tab.periodId);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_SCHOOL_LEAVING_REQUEST_CONSTANT')) {
                    submitData = this.createOtherSchoolLeavingRequestJson(formData, documentData, voluntaryDocument, id);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_LEAVE_OF_ABSENCE_REQUEST_CONSTANT')) {
                    submitData = this.createOtherLeaveOfAbsenceRequestJson(formData, documentData, voluntaryDocument, id);
                } else if (id == serviceRequestConstants.getRequestStatus('OTHER_EXCHANGE_SEMESTER_REQUEST_CONSTANT')) {
                    submitData = this.createExchangeSemesterRequestJson(formData, documentData, voluntaryDocument, id);
                }
                break;
            }
        case 'EXAM_RELATED':
        case 'Exam Related':
            {
                submitData = this.getRequestJsonObject(formData, formData.requestType, documentData, voluntaryDocument);
                break;
            }
        case 'LEAVE':
        case 'READMISSION':
        case 'OTHER':
            {
                var formPnl = tab.down('hostelleaverequestdetailspanel');
                var requestTypeCode = tab.getRequestTypeCode();
                var requesterCode = tab.getRequesterCode();
                if(tab.title == 'Readmission' || tab.title =='Readmission Request' || requestType =='READMISSION') {
                	var formPnl = tab.down('reAddmissionServiceRequest');
                	var newValues = formPnl.getValues();
                    formData.fromDate = newValues.fromDate;
                    formData.toDate = newValues.toDate;
                    formData.serviceRequestSetting = newValues.serviceRequestSetting;
                    formData.remarks = newValues.remarks;
                    formData.fromTime = newValues.fromDate + " " + newValues.fromTime;
                    formData.toTime = newValues.toDate + " " + newValues.toTime;
                    formData.requesterType = newValues.requesterType; 
                    formData.requestDate = newValues.requestDate; 
                    formData.requester = {
                        id: newValues.requester.id,
                        code: requesterCode
                    }
                	submitData = this.createServiceRequestJson(formData, documentData, voluntaryDocument);
                    if(this.readdmmisonRequestJsonData){
                    	submitData.detail = this.readdmmisonRequestJsonData;
                    }
                    else if(this.EditDocumentFormDataNew){
                    	submitData.detail = this.EditDocumentFormDataNew;
                    }else if(tab &&  tab.getResponseData() && tab.getResponseData().detail){
                    	submitData.detail = tab.getResponseData().detail;
                    }
                	submitData.detail.version = submitData.certificateRequestDetail.version;
                	submitData.detail.id = submitData.certificateRequestDetail.id;
                	submitData.serviceRequestSetting.id =this.getContentPanelActiveTab().serviceRequestSetting.id;
                	delete submitData.certificateRequestDetail;
                	delete submitData.feeDetail;
                	delete submitData.detail.academicTermProgramWithdrwan;
                	delete this.readdmmisonRequestJsonData;
                	
                } else 
                	if (!isNullOrEmpty(requestTypeCode) && requestTypeCode == "LR") {
                    if (!isNullOrEmpty(formPnl)) {
                        var newValues = formPnl.getValues();
                        formData.fromDate = newValues.fromDate;
                        formData.toDate = newValues.toDate;
                        formData.serviceRequestSetting = newValues.serviceRequestSetting;
                        formData.remarks = newValues.remarks;
                        formData.fromTime = newValues.fromDate + " " + newValues.fromTime;
                        formData.toTime = newValues.toDate + " " + newValues.toTime;
                        formData.requesterType = newValues.requesterType;
                        formData.requestDate = newValues.requestDate;
                        formData.requester = {
                            id: newValues.requester.id,
                            code: requesterCode
                        }
                        if (!isNullOrEmpty(newValues.leaveType)) {
                            formData.studentLeaveType = {
                                "id": newValues.leaveType
                            }
                        } else {
                            formData.studentLeaveType = null
                        }
                    }
                    submitData = this.createServiceRequestJson(formData, documentData, voluntaryDocument);
                    submitData.detail = submitData.certificateRequestDetail;
                    delete submitData.certificateRequestDetail;
                    delete submitData.feeDetail;
                    delete submitData.detail.leaveType;
                    delete submitData.detail.leaveRequest;
                    delete submitData.detail.academicTermProgramWithdrwan;
                    submitData.serviceRequestSetting.id = submitData.detail.serviceRequestSetting.id;
                    delete submitData.detail.serviceRequestSetting;
                    delete submitData.detail.admissionId;
                    delete submitData.executionDetail;
                    delete submitData.detail.hostelRoomAllotmentId;
                    delete submitData.detail.academicTermProgramWithdrwan;
                    delete submitData.detail.dataToBeChangedId;
                } else {
                    if (!isNullOrEmpty(formPnl)) {
                        var newValues = formPnl.getValues();
                        formData.fromDate = newValues.fromDate;
                        formData.toDate = newValues.toDate;
                        formData.serviceRequestSetting = newValues.serviceRequestSetting;
                        formData.remarks = newValues.remarks;
                        formData.fromTime = newValues.fromDate + " " + newValues.fromTime;
                        formData.toTime = newValues.toDate + " " + newValues.toTime;
                        formData.requesterType = newValues.requesterType; 
                        formData.requestDate = newValues.requestDate; 
                        formData.requester = {
                            id: newValues.requester.id,
                            code: requesterCode
                        }
                        if (!isNullOrEmpty(newValues.leaveType)) {
                            formData.studentLeaveType = {
                                "id": newValues.leaveType
                            }
                        } else {
                            formData.studentLeaveType = null
                        }
                    }
                    submitData = this.createServiceRequestJson(formData, documentData, voluntaryDocument);
                    submitData.detail = submitData.certificateRequestDetail;
                    delete submitData.certificateRequestDetail;
                    delete submitData.feeDetail;
                    delete submitData.detail.leaveType;
                    delete submitData.detail.leaveRequest;
                    delete submitData.detail.academicTermProgramWithdrwan;
                    submitData.serviceRequestSetting.id = submitData.detail.serviceRequestSetting.id;
                    delete submitData.detail.serviceRequestSetting;
                    delete submitData.detail.admissionId;
                    delete submitData.detail.academicTermProgramWithdrwan;
                }
                break;
            }
        }
        return submitData;
    },
    saveServiceRequestVoluntaryDocument: function (button) {
        var this$ = this;
        var tab = this.getContentPanelActiveTab();
        var form = button.up('form');
        var values = form.getValues();
        var isDuplicate = false;
        var voluntaryDocs = tab.getVoluntaryDocument();
        if (!isNullOrEmpty(voluntaryDocs)) {
            Ext.each(voluntaryDocs, function (doc) {
                if (doc.name === values.name) {
                    isDuplicate = true;
                }
            });
        }
        if (!isDuplicate) {
            var isTransient = true;
            var module = 'service_request';
            var entityId = tab.getRequesterId();
            var entityType = 'service _request';
            this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function (success, response, isCallBackTransient) {
                if (success) {
                    var documentObj = new Object();
                    documentObj.name = response.name;
                    documentObj.path = response.path;
                    documentObj.type = response.type;
                    var documents = null;
                    var documentData = tab.getVoluntaryDocument();
                    if (isNullOrEmpty(documentData)) {
                        documents = new Array();
                        documents.push(documentObj);
                        tab.setVoluntaryDocument(documents);
                    } else {
                        documents = documentData;
                        documents.push(documentObj);
                        tab.setVoluntaryDocument(documents);
                    }
                    var serviceReqGrid = tab.down('servicerequestvoluntarydocuments');
                    serviceReqGrid.getStore().loadData(documents, false);
                    showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_UPLOAD'));
                }
                this$.getDocumentController().closeDocumentFormWindow();
            }, isTransient);
        } else {
            showInfoMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_EXISTS'));
        }
    },
    createMandatoryDocumentJsonObject: function (documentData) {
        var documentObj = new Object();
        documentObj.isElectronic = documentData.isElectronic;
        documentObj.isInspectionDone = documentData.isInspectionDone;
        documentObj.isInspectionRequired = documentData.isInspectionRequired;
        documentObj.inspectionDate = documentData.inspectionDate;
        documentObj.inspectionDoneBy = documentData.inspectionDoneBy;
        documentObj.modeOfSubmission = documentData.modeOfSubmission;
        documentObj.path = documentData.path;
        documentObj.submissionDate = documentData.submissionDate;
        documentObj.type = 'EXT_DOCUMENT';
        documentObj.documentType = documentData.documentType;
        documentObj.isReturnable = documentData.isReturnable;
        documentObj.modeOfReturn = documentData.modeOfReturn;
        documentObj.responsibleUser = documentData.responsibleUser;
        documentObj.returnedBy = documentData.returnedBy;
        documentObj.returnedDate = documentData.returnedDate;
        documentObj.returnedToUser = documentData.returnedToUser;
        documentObj.validTillDate = documentData.validTillDate;
        documentObj.documentNote = documentData.documentNote;
        return documentObj;
    },
    downloadServiceRequestMandatoryDocument: function (button) {
        var tab = this.getContentPanelActiveTab();
        var grid = tab.down('servicerequestmandatorydocuments');
        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            var isElectronic = record.get('isElectronic');
            if (isElectronic) {
                var docId = record.raw.encryptedDocId;
                this.getDocumentController().downloadDocumentFile(docId);
            } else {
                showInfoMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_PHYSICALLY_SUBMITTED'));
            }
        } else {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    downloadServiceRequestVoluntaryDocument: function (button) {
        var grid = button.up('grid');
        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            var isElectronic = record.get('isElectronic');
            if (isElectronic) {
                var docId = record.get('id');
                this.getDocumentController().downloadDocumentFile(docId);
            } else {
                showInfoMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_PHYSICALLY_SUBMITTED'));
            }
        } else {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    deleteServiceRequestVoluntaryDocument: function (button) {
        var grid = button.up('grid');
        var this$ = this;
        var tab = this.getContentPanelActiveTab();
        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            var voluntaryDocumentData = tab.getVoluntaryDocument();
            Ext.each(voluntaryDocumentData, function (doc) {
                if (doc instanceof Object) {
                    if (doc.name === record.get('name')) {
                        voluntaryDocumentData.pop(doc);
                    }
                }
            });
            showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_DELETE'));
            this$.getServiceRequestVoluntaryDocuments().getStore().loadData(voluntaryDocumentData, false);
        } else {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    loadEvaluationSequenceCombo: function (combo) {
        var typeCombo = combo.up('form').down('#evaluationSequenceId');
        var store = typeCombo.getStore();
        store.getProxy().extraParams = {
            id: combo.getValue()
        };
        store.load();
    },
    saveExamRelatedRequest: function (button) {
        var form = button.up('form');
        var values = form.getValues();
        delete values.pageSize;
        console.log(values);
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        if (values.requestType === 'lackofattendanceform') {
            var grid = button.up('form').down('#lackOfAttendanceGridId');
            var courses = null;
            if (grid.getSelectionModel().getCount() > 0) {
                var records = grid.getSelectionModel().getSelection();
                courses = new Array();
                Ext.each(records, function (record) {
                    courses.push({
                        id: record.get("courseId")
                    });
                });
            }
            values.courses = courses;
        }
        var tab = form.up('panel');
        tab.setFormData(values);
        this.addDocumentPanel(tab);
    },
    getRequestJsonObject: function (values, requestType, documentData, voluntaryDocument) {
        var jsonObject = null;
        switch (requestType) {
        case 'revaluationofexampaperform':
            {
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        case 'changeofexamdateform':
            {
                delete values.currentDate;
                delete values.currentBatch;
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        case 'changeofexamcenterform':
            {
                delete values.currentBatch;
                delete values.currentCenter;
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        case 'withdrawalofexam':
            {
                delete values.currentDate;
                delete values.currentCenter;
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        case 'lackofothercriteriaform':
            {
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        case 'examleaverequestform':
            {
                delete values.currentDate;
                delete values.currentCenter;
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        case 'lackofattendanceform':
            {
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        case 'requestforreexaminationform':
            {
                delete values.currentDate;
                delete values.currentBatch;
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        case 'examconcessionrequestform':
            {
                jsonObject = this.createExamRequestJson(values, documentData, voluntaryDocument);
                break;
            }
        }
        return jsonObject;
    },
    createExamRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        var tab = me.getContentPanelActiveTab();
        if (!isNullOrEmpty(tab) && tab.title == "Exam Concession Request" && !isNullOrEmpty(tab.getAdmissionId())) {
            object.admissionId = tab.getAdmissionId();
            object.periodId = tab.getProgBatchPeriodConfigId();
            object.documentId = tab.getSettingId();
        }
        object.dueDate = null;
        object.detail = values;
        object.wsExamConcessionFormDetail = null;
        delete object.wsExamConcessionFormDetail;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.detail.academicTermProgramWithdrwan;
        delete object.detail;
        console.log(object);
        return object;
    },
    loadEvalDetailCombo: function (cmb) {
        var detailSequenceCmb = cmb.up('form').down('#evaluationDetailedSequenceId');
        var courseCmb = cmb.up('form').down('#course');
        detailSequenceCmb.setDisabled(false);
        detailSequenceCmb.reset();
        courseCmb.reset();
        var detailSequenceStore = detailSequenceCmb.getStore();
        detailSequenceStore.load({
            params: {
                evalPlanId: cmb.getValue()
            }
        });
    },
    loadExamBatchDateCombo: function (cmb) {
        var me = this;
        me.setCourseValue(cmb);
        me.loadExpectedBatchCombo(cmb, null);
        me.loadExpectedDateCombo(cmb, null);
    },
    loadExamCenterCombo: function (cmb) {
        var me = this;
        me.setCourseValue(cmb);
        me.loadExpectedDateCombo(cmb, null);
        me.loadExpectedCenterCombo(cmb, null);
    },
    loadCurrentDateAndCenterCombo: function (cmb) {
        var me = this;
        me.setCourseValue(cmb);
    },
    setCourseValue: function (cmb) {
        var me = this;
        var courseCmb = cmb.up('form').up('form').down('#course');
        var commonForm = courseCmb.up('form');
        var courseStore = courseCmb.getStore();
        courseStore.load({
            params: {
                evalSeqDetailId: cmb.getValue()
            },
            callback: function (records, operation, success) {
                courseCmb.reset();
                courseCmb.setValue(records[0].data.id);
                courseCmb.setReadOnly(true);
                if (commonForm.itemId === 'dateCommonForm' || commonForm.itemId === 'reExaminationCommonForm') {
                    me.setCurrentExamBatch(courseCmb);
                    me.setCurrentExamDate(courseCmb);
                } else if (commonForm.itemId === 'centerCommonForm') {
                    me.setCurrentExamBatch(courseCmb);
                    me.setCurrentExamCenter(courseCmb);
                } else if (commonForm.itemId === 'leaveCommonForm' || commonForm.itemId === 'withdrawCommmonForm') {
                    me.setCurrentExamDate(courseCmb);
                    me.setCurrentExamCenter(courseCmb);
                }
            }
        });
    },
    setCurrentExamBatch: function (cmb, obj) {
        var me = this;
        var detailId = cmb.up('form').down('#evaluationDetailedSequenceId').getValue();
        var planId = cmb.up('form').down('#evaluationPlan').getValue();
        var courseID = cmb.getValue();
        var data = me.getParameter();
        var isCurrentPeriod = null;
        var isCurrentSection = null;
        if (!isNullOrEmpty(data)) {
            isCurrentPeriod = data[0].isCurrentPeriod;
            isCurrentSection = data[0].isCurrentSection;
        }
        var param = {
            detailSequenceId: detailId,
            evaluationPlanId: planId,
            courseId: courseID,
            admissionId: this.getContentPanelActiveTab().getAdmissionId(),
            programBatchId: this.getContentPanelActiveTab().getProgramBatchId(),
            isCurrentPeriod: isCurrentPeriod,
            progBatchPeriodConfigId: this.getContentPanelActiveTab().getProgBatchPeriodConfigId(),
            isCurrentSection: isCurrentSection
        };
        me.sendGetAjaxRequest(SERVERURL.FIND_CURRENT_EXAM_BATCH, 'GET', param, function (opt, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                if (data.length !== 0) {
                    cmb.up('form').up('form').down('#currentBatchId').setValue(data[0].value);
                    cmb.up('form').up('form').down('#hidden_batchId').setValue(data[0].id);
                }
                cmb.up('form').up('form').down('#currentBatchId').setReadOnly(true);
            }
        });
    },
    setCurrentExamDate: function (cmb) {
        var me = this;
        var detailId = cmb.up('form').down('#evaluationDetailedSequenceId').getValue();
        var planId = cmb.up('form').down('#evaluationPlan').getValue();
        var courseID = cmb.getValue();
        var data = me.getParameter();
        var isCurrentPeriod = null;
        var isCurrentSection = null;
        if (!isNullOrEmpty(data)) {
            isCurrentPeriod = data[0].isCurrentPeriod;
            isCurrentSection = data[0].isCurrentSection;
        }
        var param = {
            detailSequenceId: detailId,
            evaluationPlanId: planId,
            courseId: courseID,
            admissionId: this.getContentPanelActiveTab().getAdmissionId(),
            programBatchId: this.getContentPanelActiveTab().getProgramBatchId(),
            isCurrentPeriod: isCurrentPeriod,
            isCurrentSection: isCurrentSection,
            progBatchPeriodConfigId: this.getContentPanelActiveTab().getProgBatchPeriodConfigId(),
        };
        me.sendGetAjaxRequest(SERVERURL.FIND_CURRENT_EXAM_DATE, 'GET', param, function (opt, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                if (data.length !== 0) {
                    cmb.up('form').up('form').down('#currentDateId').setValue(data[0].value);
                    cmb.up('form').up('form').down('#hidden_dateId').setValue(data[0].id);
                }
                cmb.up('form').up('form').down('#currentDateId').setReadOnly(true);
            }
        });
    },
    setCurrentExamCenter: function (cmb) {
        var me = this;
        var detailId = cmb.up('form').down('#evaluationDetailedSequenceId').getValue();
        var planId = cmb.up('form').down('#evaluationPlan').getValue();
        var courseID = cmb.getValue();
        var data = me.getParameter();
        var isCurrentPeriod = null;
        var isCurrentSection = null;
        if (!isNullOrEmpty(data)) {
            isCurrentPeriod = data[0].isCurrentPeriod;
            isCurrentSection = data[0].isCurrentSection;
        }
        var param = {
            detailSequenceId: detailId,
            evaluationPlanId: planId,
            courseId: courseID,
            admissionId: this.getContentPanelActiveTab().getAdmissionId(),
            programBatchId: this.getContentPanelActiveTab().getProgramBatchId(),
            isCurrentPeriod: isCurrentPeriod,
            progBatchPeriodConfigId: this.getContentPanelActiveTab().getProgBatchPeriodConfigId(),
            isCurrentSection: isCurrentSection,
            centerType: 'EXTERNAL'
        };
        me.sendGetAjaxRequest(SERVERURL.FIND_CURRENT_EXAM_CENTER, 'GET', param, function (opt, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                if (data.length !== 0) {
                    cmb.up('form').up('form').down('#currentExamCenterId').setValue(data[0].value);
                    cmb.up('form').up('form').down('#hidden_centerId').setValue(data[0].id);
                }
                cmb.up('form').up('form').down('#currentExamCenterId').setReadOnly(true);
            }
        });
    },
    getParameter: function () {
        var data = null;
        Ext.Ajax.request({
            type: 'rest',
            async: false,
            method: 'GET',
            url: SERVERURL.FIND_EXAM_PARAMETER,
            params: {
                studentId: this.getContentPanelActiveTab().getRequesterId()
            },
            success: function (response, action) {
                if (!isNullOrEmpty(response.responseText)) {
                    data = Ext.decode(response.responseText);
                }
            }
        });
        return data;
    },
    loadLackOfAttendanceGrid: function (grid) {
        var gridStore = grid.getStore();
        gridStore.load({
            params: {
                admissionId: this.getContentPanelActiveTab().getAdmissionId()
            }
        });
    },
    loadExpectedBatchCombo: function (cmb, id) {
        var detailId = null;
        if (id) {
            detailId = id;
        } else {
            detailId = cmb.getValue();
        }
        var batchStore = cmb.up('form').up('form').down('#expectedBatchId').getStore();
        batchStore.getProxy().extraParams = {
            detailSequenceId: detailId
        };
        batchStore.load();
    },
    loadExpectedDateCombo: function (cmb, id) {
        var detailId = null;
        if (id) {
            detailId = id;
        } else {
            detailId = cmb.getValue();
        }
        var dateStore = cmb.up('form').up('form').down('#expectedDateId').getStore();
        dateStore.getProxy().extraParams = {
            detailSequenceId: detailId
        };
        dateStore.load();
    },
    loadExpectedCenterCombo: function (cmb, id) {
        var detailId = null;
        if (id) {
            detailId = id;
        } else {
            detailId = cmb.getValue();
        }
        var centerStore = cmb.up('form').up('form').down('#expectedCenterId').getStore();
        centerStore.getProxy().extraParams = {
            detailSequenceId: detailId
        };
        centerStore.load();
    },
    loadBillDetailsStore: function (grid) {
        var tab = this.getContentPanelActiveTab();
        var store = grid.getStore();
        store.getProxy().extraParams = {
        	serviceRequestId: tab.getServiceRequestId(),
        	raiseBillCategory: 'BILL_RECEIVABLE'
        }
        store.load();
    },
    loadRefundDetailsStore: function (grid) {
        var tab = this.getContentPanelActiveTab();
        var store = grid.getStore();
        store.getProxy().extraParams = {
        	serviceRequestId: tab.getServiceRequestId(),
        	raiseBillCategory: 'BILL_PAYABLE'
        }
        store.load();
    },
    loadQuestionPaperCodes: function (cmb) {
        this.setCourseValue(cmb);
        var questionPaperCodeStore = cmb.up('form').up('form').down('#questionPaperCodeId').getStore();
        questionPaperCodeStore.load({
            params: {
                evalSeqDetailId: cmb.getValue()
            }
        });
    },
    loadQuestionNoCombo: function (cmb) {
        var questionNoStore = cmb.up('form').down('#questionNoId').getStore();
        questionNoStore.load({
            params: {
                questionPaperId: cmb.getValue()
            }
        });
        var param = {
            questionPaperId: cmb.getValue()
        };
        this.sendGetAjaxRequest(SERVERURL.FIND_TOTAL_MARKS, 'GET', param, function (opt, success, response) {
            if (success) {
                if (!isNullOrEmpty(response.responseText)) {
                    var data = Ext.decode(response.responseText);
                    cmb.up('form').down('#totalMarksId').setValue(data);
                }
                cmb.up('form').down('#totalMarksId').setReadOnly(true);
            }
        });
    },
    loadQuestionNoPartCombo: function (cmb) {
        var questionPaperCode = cmb.up('form').down('#questionPaperCodeId');
        var questionNoPartStore = cmb.up('form').down('#questionNoPartId').getStore();
        questionNoPartStore.load({
            params: {
                questionPaperId: questionPaperCode.getValue(),
                questionId: cmb.getValue()
            }
        });
    },
    loadQuestionNoSubPartCombo: function (cmb) {
        var questionPaperCode = cmb.up('form').down('#questionPaperCodeId');
        var questionNoPart = cmb.up('form').down('#questionNoId');
        var questionNoSubPartStore = cmb.up('form').down('#questionNoPart1Id').getStore();
        questionNoSubPartStore.load({
            params: {
                questionPaperId: questionPaperCode.getValue(),
                questionId: questionNoPart.getValue(),
                questionPartId: cmb.getValue()
            }
        });
    },
    loadQuestionsGrid: function (cmb) {
        var questionPaperCode = cmb.up('form').down('#questionPaperCodeId');
        var questionNo = cmb.up('form').down('#questionNoId');
        var questionNoPart = cmb.up('form').down('#questionNoPartId');
        var gridStore = cmb.up('form').down('#revaluationgridId').getStore();
        gridStore.load({
            params: {
                questionPaperId: questionPaperCode.getValue(),
                questionId: questionNo.getValue(),
                questionPartId: questionNoPart.getValue(),
                question1PartId: cmb.getValue()
            }
        });
    },
    loadAttendanceGrid: function (grid) {
        var gridStore = grid.getStore();
        gridStore.load({
            params: {
                admissionId: this.getContentPanelActiveTab().getAdmissionId()
            }
        });
    },
    loadProgramCombo: function (combo) {
        var me = this;
        var tab = me.getContentPanelActiveTab();
        var store = combo.getStore();
        store.load({
            params: {
                studentId: tab.getRequesterId() != null ? tab.getRequesterId() : tab.responseData.requester.id,
                onlyCurrentRecords: true
            },
        });
    },
    loadBatchForSectionTransfer: function (field, record) {
        var batch = field.up('form').down('#hiddenBatchId');
        var hiddenPeriodId = field.up('form').down('#hiddenPeriodId');
        batch.setValue(record.get('batchId'));
        field.setValue(record.get('batchName'));
        hiddenPeriodId.setValue(record.get('periodId'));
    },
    loadFromSectionField: function (field, record) {
        var form = field.up('form');
        var fromSection = form.down('#hiddenFromSection');
        if (!isNullOrEmpty(form.down('#courseVariantId').getValue())) {
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.SECTION_FIND_BY_ID,
                method: 'GET',
                params: {
                    id: fromSection.getValue()
                },
                success: function (response, action) {
                    var data = Ext.decode(response.responseText);
                    fromSection.setValue(data.id);
                    field.setValue(data.sectionCode);
                }
            });
        } else {
            if (record.fromSectionId == undefined) {
                if (record.serviceRequestStage == "CLOSED") {
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.LOAD_SECTION_FOR_PROGRAM_BY_SECTIONID,
                        method: 'GET',
                        params: {
                            sectionId: record.detail.fromSectionId
                        },
                        success: function (response, action) {
                            var data = Ext.decode(response.responseText);
                            fromSection.setValue(data[0].id);
                            field.setValue(data[0].value);
                        }
                    });
                } else {
                    if (record[0] != undefined) {
                        fromSection.setValue(record[0].data.sectionId);
                        field.setValue(record[0].data.sectionCode);
                    } else {
                        fromSection.setValue(record.get('sectionId'));
                        field.setValue(record.get('sectionCode'));
                    }
                }
            } else {
                var sectionId = record.fromSectionId;
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.LOAD_SECTION_FOR_PROGRAM_BY_SECTIONID,
                    method: 'GET',
                    params: {
                        sectionId: sectionId
                    },
                    success: function (response, action) {
                        var data = Ext.decode(response.responseText);
                        fromSection.setValue(data[0].id);
                        field.setValue(data[0].value);
                    }
                });
            }
        }
    },
    loadCourseCombo: function (field) {
        var form = field.up('form');
        var combo = form.down('#courseId');
        var courseVariantId = form.down('#courseVariantId').getValue();
        var store = combo.getStore();
        var tab = this.getContentPanelActiveTab();
        var batchId = field.getValue();
        store.load({
            params: {
                batchId: batchId,
                studentId: tab.getRequesterId(),
                assignSectionType: "CourseSection",
                serviceRequestCourseVariantId: courseVariantId
            }
        });
    },
    loadToSectionComboForCourse: function (combo, records, requesterType) {
        var tab = this.getContentPanelActiveTab();
        var requestType = tab.getRequestType();
        var toSectionCombo = combo.up('form').down('#toSectionForCourse');
        var fromSection = combo.up('form').down('#fromSectionId');
        var period = combo.up('form').down('#hiddenPeriodId');
        var periodId = null;
        var store = toSectionCombo.getStore();
        if (isNullOrEmpty(requestType)) {
            requestType = requesterType;
        }
        if (!isNullOrEmpty(period)) {
            periodId = period.getValue();
        }
        if (requestType === 'FACULTY_REQUEST') {
            store.getProxy().api.read = SERVERURL.TO_SECTION_FOR_FACULTY_SECTION_TRANSFER;
            this.setFromSectionForFacultySectionTransfer(combo);
        } else {
            store.getProxy().api.read = SERVERURL.TO_PARAMETERIZED_SECTION_FOR_SECTION_TRANSFER;
            store.proxy.extraParams = {
                periodId: periodId
            }, this.loadFromSectionField(fromSection, records);
        }
        store.removeAll();
        toSectionCombo.clearValue();
        store.load({
            params: {
                variantId: combo.getValue()
            }
        });
    },
    setFromSectionForFacultySectionTransfer: function (combo) {
        var form = combo.up('form');
        var fromSectionId = form.down('#hiddenFromSection');
        var fromSection = form.down('#fromSectionId');
        var params = {
            courseVariantId: combo.getValue()
        };
        this.sendGetAjaxRequest(SERVERURL.FROM_SECTION_FOR_FACULTY_SECTION_TRANSFER, 'GET', params, function (option, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                fromSectionId.setValue(data.sectionCodeId);
                fromSection.setValue(data.sectionCode);
            }
        });
    },
    loadToSectionComboForProgram: function (combo, record, data) {
        var store = combo.getStore();
        var periodId = null;
        var sectionId = null;
        if (data != undefined && data.detail != undefined && data.detail.toSectionId != undefined) {
        		sectionId = data.detail.toSectionId;
        } else {
        	sectionId = record.get('sectionId');
        }
        if (data != undefined && data.serviceRequestStage == "CLOSED") {
            store.getProxy().api.read = SERVERURL.LOAD_SECTION_FOR_PROGRAM_BY_SECTIONID;
            store.load({
                params: {
                    sectionId: sectionId
                }
            });
        } else {
            store.getProxy().api.read = SERVERURL.LOAD_SECTION_FOR_PROGRAM;
            periodId = record.get('periodId');
            store.load({
                params: {
                    periodId: periodId,
                    sectionId: sectionId
                }
            });
        }
    },
    saveSectionTransferRequest: function (button) {
        var form = button.up('form');
        var values = form.getValues();
        var tab = this.getContentPanelActiveTab();
        values.serviceRequest = null;
        values.requester = {
            id: tab.getRequesterId()
        };
        delete values.batchData;
        delete values.fromSection;
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        delete values.withdrawDate;
        tab.setFormData(values);
        this.addDocumentPanel(tab);
    },
    createSectionTransferRequestJson: function (values, documentData, voluntaryDocument) {
        var me = this;
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete object.serviceRequestCourseVariant;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    toggleCourseCombo: function (radio, newValue, oldValue) {
        var form = radio.up('form');
        var combo = form.down('#courseId');
        var program = form.down('#ProgramId');
        var batch = form.down('#batchId');
        var fromSection = form.down('#fromSectionId');
        var sectionCombo = form.down('#toSectionId');
        var toSectionCombo = form.down('#toSectionForCourse');
        fromSection.reset();
        batch.reset();
        program.reset();
        if (oldValue === true) {
            combo.clearValue();
            toSectionCombo.reset();
            sectionCombo.reset();
            combo.setVisible(true);
            combo.setDisabled(false);
            if (!isNullOrEmpty(combo)) combo.reset();
            toSectionCombo.setVisible(true);
            toSectionCombo.setDisabled(false);
            sectionCombo.setVisible(false);
            sectionCombo.setDisabled(true);
        } else {
            combo.clearValue();
            toSectionCombo.reset();
            sectionCombo.reset();
            combo.setVisible(false);
            combo.setDisabled(true);
            toSectionCombo.setVisible(false);
            toSectionCombo.setDisabled(true);
            sectionCombo.setVisible(true);
            sectionCombo.setDisabled(false);
        }
    },
    loadBatchSectionTextFields: function (combo, data) {
        var form = combo.up('form');
        var record = combo.getStore().getAt(0);
        var batchField = form.down('#batchId');
        var fromSection = form.down('#fromSectionId');
        var toSectionCombo = form.down('#toSectionId');
        var radio = form.down('#relatedTransfer').getValue();
        this.loadBatchForSectionTransfer(batchField, record);
        if (data.serviceRequestStage == "CLOSED") {
            if (radio.isTransferRelatedProgram && !isNullOrEmpty(data)) {
                this.loadToSectionComboForProgram(toSectionCombo, record, data);
                this.loadFromSectionField(fromSection, data);
            }
        } else {
            if (radio.isTransferRelatedProgram) {
                this.loadToSectionComboForProgram(toSectionCombo, record);
                this.loadFromSectionField(fromSection, record);
            }
        }
    },
    createSectionTransferRequestObject: function (data, record) {
        var me = this;
        var formData = me.createObject(data, record);
        formData.enteredBy = typeof data.enteredBy == "object" ? data.enteredBy.value : data.enteredBy;
        formData.programIds = data.detail.programIds;
        return formData;
    },
    toggleTransferModeRadioButton: function (form) {
        var tab = this.getContentPanelActiveTab();
        var requestType = tab.getRequestType();
        var requesterId = tab.getRequesterId();
        var radio = form.down('#relatedTransfer');
        var program = form.down('#ProgramId');
        var batch = form.down('#batchId');
        var hiddenBatch = form.down('#hiddenBatchId');
        var courseCombo = form.down('#courseId');
        if (requestType === 'FACULTY_REQUEST') {
            radio.setVisible(false);
            radio.setDisabled(true);
            program.setVisible(false);
            program.setDisabled(true);
            batch.setVisible(false);
            hiddenBatch.setDisabled(true);
            this.loadCourseForFaculty(courseCombo, requesterId);
        }
    },
    loadCourseForFaculty: function (courseCombo, facutyId) {
        var store = courseCombo.getStore();
        store.getProxy().api.read = SERVERURL.LOAD_COURSE_FOR_FACULTY;
        if (!isNullOrEmpty(facutyId)) {
            store.load({
                params: {
                    facultyId: facutyId
                }
            });
        }
    },
    onRequestTypeSelectionDropdown: function (combo) {
        var $this = this;
        var form = combo.up('form');
        var value = combo.getValue();
        var requestSubCategoryField = form.down('#requestSubCategoryField');
        var certificateCategoryField = form.down('#certificateCategoryField');
        var certificateSubCategoryField = form.down('#certificateSubCategoryField');
        var freeFormCategoryField = form.down('#freeFormCategoryField');
        var freeFormSubCategoryField = form.down('#freeFormSubCategoryField');
        requestSubCategoryField.clearValue();
        certificateCategoryField.clearValue();
        certificateSubCategoryField.clearValue();
        freeFormCategoryField.clearValue();
        freeFormSubCategoryField.clearValue();
        switch (value) {
        case 'CERTIFICATE':
            certificateCategoryField.setVisible(true);
            certificateSubCategoryField.setVisible(true);
            requestSubCategoryField.setVisible(false);
            freeFormCategoryField.setVisible(false);
            freeFormSubCategoryField.setVisible(false);
            break;
        case 'FREE_FORM':
            freeFormCategoryField.setVisible(true);
            freeFormSubCategoryField.setVisible(true);
            requestSubCategoryField.setVisible(false);
            certificateCategoryField.setVisible(false);
            certificateSubCategoryField.setVisible(false);
            var store = freeFormCategoryField.getStore();
            store.reload();
            break;
        case 'TRANSFER':
        case 'PERSONAL_DATA_CHANGE':
        case 'EXAM_RELATED':
        case 'DEBARMENT':
        case 'TERMINATION':
        default:
            {
                requestSubCategoryField.setVisible(true);
                freeFormCategoryField.setVisible(false);
                freeFormSubCategoryField.setVisible(false);
                certificateCategoryField.setVisible(false);
                certificateSubCategoryField.setVisible(false);
                var store = requestSubCategoryField.getStore();
                var requestCategory = null;
                if (value == 'DEBARMENT') {
                    requestCategory = "DEBRAMENT_REQUEST";
                } else if (value == 'TERMINATION') {
                    requestCategory = "TERMINATION_REQUEST";
                } else {
                    requestCategory = form.xtype == 'facultyfindrequestform' ? "FACULTY_REQUEST" : "STUDENT_REQUEST"
                }
                store.proxy.extraParams = {
                    serviceRequestGroup: value,
                    academyLocationId: $this.getCurrentAcademyLocation(),
                    serviceRequestCategory: requestCategory
                };
                store.reload();
                break;
            }
        }
    },
    onCategorySelectionDropdown: function (combo) {
        var value = combo.getValue();
        var form = combo.up('form');
        var requestTypeField = form.down('#requestTypeField');
        var requestTypeValue = requestTypeField.getValue();
        var certificateSubCategoryField = form.down('#certificateSubCategoryField');
        var freeFormSubCategoryField = form.down('#freeFormSubCategoryField');
        switch (requestTypeValue) {
        case 'CERTIFICATE':
            this.clearCombo(certificateSubCategoryField);
            var store = certificateSubCategoryField.getStore();
            store.proxy.extraParams = {
                certificateCategory: value
            };
            store.reload();
            break;
        case 'FREE_FORM':
            this.clearCombo(freeFormSubCategoryField);
            var store = freeFormSubCategoryField.getStore();
            store.proxy.extraParams = {
                categoryId: value
            };
            store.reload();
            break;
        }
    },
    clearCombo: function (combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    changeServiceRequestStore: function (form) {
        var combo = form.down('#requestTypeField');
        var panel = form.up('form');
        if (panel.xtype === 'findrequestform') {
            var store = Ext.create('Academia.store.servicerequest.ServiceRequestCategory');
            combo.bindStore(store);
        } else {
            var store = Ext.create('Academia.store.servicerequest.FacultyServiceRequestCategory');
            combo.bindStore(store);
        }
    },
    changeNameFieldConfig: function (combo) {
        var nameField = combo.up('form').down('#selectedName');
        if (nameField != undefined) {
            nameField.setFieldLabel(combo.getRawValue());
            var name = combo.getValue();
            if (name == 'FIRST_NAME') {
                nameField.name = 'REQUESTER_FIRSTNAME';
            } else if (name == 'PRINT_NAME') {
                nameField.name = 'REQUESTER_PRINTNAME';
            } else if (name == 'LAST_NAME') {
                nameField.name = 'REQUESTER_LASTNAME';
            }
            nameField.emptyText = combo.getRawValue();
            nameField.applyEmptyText();
        }
    },
    setVisibleFeeRequestGrid: function (requestId) {
        var grid = this.getApproverFeeRequestDetailGrid();
        var store = grid.getStore();
        store.load({
            params: {
                'serviceRequestId': requestId
            }
        });
    },
    ExpandRowBody: function (me, grid, record, expandRow) {
        var expander = grid.getPlugin('feeRealtedRequestRowExpander');
        var installmentDetail = record.get('installmentDetails');
        var objectArray = new Array();
        if (installmentDetail.length > 0) {
            for (var count in installmentDetail) {
                var recordData = installmentDetail[count];
                var object = new Object();
                if (!isEmpty(recordData)) {
                    object.installmentDueDate = recordData.installmentDueDate;
                    object.amount = recordData.amount;
                    objectArray.push(object);
                }
            }
            expandRow.style.height = '130px';
            expander.rowBodyTpl.overwrite(expandRow, objectArray);
        } else {
            expandRow.style.height = '0px';
            expander.rowBodyTpl.applyTemplate('<div>No Record To display</div>');
        }
    },
    openRaiseRequest: function () {
        var me = this;
        var contentpanel = me.getContentPanel();
        var programgrid = "";
        if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
            var programgrid = Ext.widget('studentquicksearchview');
        }
        if (this.getCurrentLoggedPortalId() == 2) {
            var programgrid = Ext.widget('facultyquicksearchview');
        }
        var tabName = getCommonTranslation('RAISE_REQUEST');
        var getcontroller = this.getController('menu.CoreERPNavigationController');
        var getTab = getcontroller.getTab(tabName);
        if (getTab != null) {
            contentpanel.remove(getTab, true);
        }
        openTab(contentpanel, tabName, programgrid, CONSTANTS.MENU_COLOR_FOUR);
    },
    disableQuickCommentBtnPivilegesToFaculty: function (gridReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
        var quickCommentToFacultyId = gridReference.down('#quickCommentToFacultyId');
    	quickCommentToFacultyId.setVisible(false);
        Ext.each(permissionList, function (privilege) {
            if (privilege === 'QUICKCOMMENT') {
                if (!isNullOrEmpty(quickCommentToFacultyId)) {
                	quickCommentToFacultyId.setVisible(true);
                }
            }
        });
    
    
    },
    disableMoreActionPivileges: function (gridReference, permissionsMap) {
        if (grid && !isNullOrEmpty(grid)) {
            var associatedAcadLocationIds = new Array();
            associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
            buttonsToolBar = gridReference.query('toolbar')[0];
            var raiseRequestBtn = grid.down('#raiseRequestBtn');
            if (raiseRequestBtn && Ext.isDefined(raiseRequestBtn)) {
                raiseRequestBtn.setVisible(false);
                Ext.each(permissionList, function (privilege) {
                    if (privilege === 'RAISEREQUEST') {
                        if (!isNullOrEmpty(raiseRequestBtn)) {
                            raiseRequestBtn.setVisible(true);
                        }
                    }
                });
            }
        }
    },
    gridRenderRaiseRequestBtn: function (grid) {
        var butonstoolbar = grid.down('#functionButtonsToolbar');
        butonstoolbar.insert(4, {
            xtype: 'button',
            itemId: 'raiseRequestBtn',
            text: getCommonTranslation('RAISE_REQUEST'),
            tooltip: getCommonTranslation('RAISE_REQUEST')
        });
        butonstoolbar.insert(6, {
            xtype: 'button',
            itemId: 'uploadDocumentBtn',
            text: getCommonTranslation('UPLOAD_DOCUMENTS'),
            tooltip: getCommonTranslation('UPLOAD_DOCUMENTS'),
            disabled: true
        });
    },
    gridRenderQuickCommentBtn: function (grid) {
        var butonstoolbar = grid.down('#functionButtonsToolbar');
        butonstoolbar.insert(5, {
            xtype: 'button',
            itemId: 'quickCommentToFacultyId',
            text: getFeeAndPaymentCommonTranslation('QUICK_COMMENT'),
            tooltip: getFeeAndPaymentCommonTranslation('QUICK_COMMENT'),
            disabled: true
        });
    },
    saveComplaintServiceRequestStudentPortal: function (button) {
        var me = this;
        var form = button.up('form').up('form');
        var values = form.getValues();
        var submitData = Ext.encode(this.createComplaintRequestJsonStudentPortal(values));
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        this.sendSaveAjaxRequest(SERVERURL.SAVE_COMPLAINT_REQUEST, 'POST', submitData, function (opt, success, response) {
            Ext.getBody().unmask();
            if (success) {
                form.getForm().reset();
                me.closeTab(form.up());
                showSuccessMessage(getServiceRequestTranslation('GRIEVANCE_REQUEST'), getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
            }
        });
    },
    createComplaintRequestJsonStudentPortal: function (values) {
        var me = this;
        var object = new Object();
        object.complaintTypeSetting = values.complaintTypeSetting;
        object.enteredBy = me.getCurrentlyLoggedInUser();
        object.requester = me.getCurrentlyLoggedInUser();
        var requestDate = values.requestDate;
        var remarks = values.remarks;
        delete values.assignee;
        delete values.complaintTypeSetting;
        delete values.remarks;
        delete values.requestDate;
        object.detail = values;
        object.detail.complaintBy = 'STUDENT';
        object.requestDate = requestDate;
        object.remarks = remarks;
        return object;
    },
    loadOnRequestComboChange: function (value) {
        var this$ = this;
        var portalId = this$.getCurrentLoggedPortalId();
        var window = this$.getCommonraiseservicerequestwindow();
        if (portalId == 2) {
            var comboPanel = this$.getCommonrequestcombopanel();
            var combo = comboPanel.down('combo#serviceRequestCombo');
            var catcombo = comboPanel.down('combo#RequestCategoryCombo');
            catcombo.setVisible(false) 
            catcombo.setDisabled(true);
            combo.setDisabled(true);
            if (value === 'TRANSFER' || value === 'EXAM_RELATED') {
                combo.setVisible(true);
                combo.setDisabled(false);
                this.loadRequestComboStore(value, "FACULTY_REQUEST", this.getCurrentAcademyLocation());
            } else if (value === 'OTHER') {
                catcombo.setVisible(true);
                catcombo.setDisabled(false);
                catcombo.clearValue();
                this.loadRequestComboStore(value, "FACULTY_REQUEST", this.getCurrentAcademyLocation());
            } else {
                combo.setVisible(false);
                combo.setDisabled(true);
                this.openServiceRequestTab("FACULTY_REQUEST", value);
            }
        } else if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
            var requestType = this.getRequestType();
            var comboPanel = this.getCommonrequestcombopanel();
            var catcombo = comboPanel.down('combo#RequestCategoryCombo');
            var combo = comboPanel.down('combo#serviceRequestCombo');
            catcombo.setVisible(false) 
            catcombo.setDisabled(true);
            combo.setDisabled(true);
            if (value === 'TRANSFER' || value === 'EXAM_RELATED') {
                combo.setVisible(true);
                combo.setDisabled(false);
                this.loadRequestComboStore(value, "STUDENT_REQUEST", this.getCurrentAcademyLocation());
            } else if (value === 'OTHER') {
                catcombo.setVisible(true);
                catcombo.setDisabled(false);
                catcombo.clearValue();
                this.loadRequestComboStore(value, "STUDENT_REQUEST", this.getCurrentAcademyLocation());
            } else {
                combo.setVisible(false);
                combo.setDisabled(true);
                this.openServiceRequestTab("STUDENT_REQUEST", value);
            }
        }
    },
    loadOnCategoryComboChange: function (value) {
        var this$ = this;
        var window = this$.getCommonraiseservicerequestwindow();
        var portalId = this$.getCurrentLoggedPortalId();
        if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
            var requestType = this.getRequestType();
            var comboPanel = this.getCommonrequestcombopanel();
            var catcombo = comboPanel.down('combo#RequestCategoryCombo');
            var combo = comboPanel.down('combo#serviceRequestCombo');
            combo.setDisabled(true);
            if (value === 'LEAVE') {
                combo.setVisible(true);
                combo.setDisabled(false);
            } else {
                combo.setVisible(false);
                combo.setDisabled(true);
                this.openServiceRequestTab(requestType, value);
            }
        } else {
            var requestType = this.getRequestType();
            var comboPanel = this.getCommonrequestcombopanel();
            var catcombo = comboPanel.down('combo#RequestCategoryCombo');
            var combo = comboPanel.down('combo#serviceRequestCombo');
            combo.setDisabled(true);
            combo.clearValue();
            if (value === 'LEAVE') {
                combo.setVisible(true);
                combo.setDisabled(false);
            } else {
                combo.setVisible(false);
                combo.setDisabled(true);
                this.openServiceRequestTab(requestType, value);
            }
        }
    },
    loadRequestComboStore: function (serviceRequestGroup, serviceRequestCategory, academyLocationId) {
        var this$ = this;
        var store = null;
        var portalId = null;
        var portalId = this$.getCurrentLoggedPortalId();
        if (portalId == 2) {
            store = this$.getCommonrequestcombopanel().down('combo#serviceRequestCombo').getStore();
        } else if (portalId == 3 || portalId == 7) {
            store = this$.getStore('servicerequest.ServiceRequests');
            var programId = this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.programId;
        }
        store.load({
            params: {
                serviceRequestGroup: serviceRequestGroup,
                serviceRequestCategory: serviceRequestCategory,
                academyLocationId: academyLocationId,
                programId: programId,
                portalId: portalId
            }
        });
    },
    openCommonRaiseRequestWindow: function () {
        var this$ = this;
        var window = this$.getCommonraiseservicerequestwindow();
        if (!window) {
            window = Ext.widget('commonraiseservicerequestwindow');
        }
        window.show();
    },
    openServiceRequestTab: function (requestType, requestGroup, otherRequestType, recordParam) {
        var this$ = this;
        var portalId = this.getCurrentLoggedPortalId();
        if (portalId == 2) {
            var facultyDetail = this.getCurrentlyLoggedInUserWithPersonId();
            var record = this.getFacultySearchResultGrid().getStore().getAt(0);
            var personId = facultyDetail.personId;
            var facultyId = facultyDetail.id;
            var serviceRequestController = Academia.app.getController('Academia.controller.servicerequest.ServiceRequestBaseController');
            serviceRequestController.getRequestPanel(requestType, requestGroup, facultyId, personId, otherRequestType, record);
            this$.loadFacultyGridAndSearchRequest();
            this$.getCommonraiseservicerequestwindow().close();
        } else if (portalId == 3 || portalId == 7) {
            var studentDetail = this.getCurrentlyLoggedInUserWithPersonId();
            var grid = this.getStudentSearchResultGrid();
            if (!grid.isVisible()) {
                var grid = this.getStudentportalstudentrequestgrid();
            }
            var record = grid.getStore().getAt(0);
            if(recordParam && !isNullOrEmpty(recordParam) && recordParam.raw && recordParam.raw.categoryId){
            	record = recordParam;
            }
            else if(isNullOrEmpty(record)){
            	record = recordParam;
            }
            var personId = studentDetail.personId;
            var studentId = studentDetail.id;
            var serviceRequestController = Academia.app.getController('Academia.controller.servicerequest.ServiceRequestBaseController');
            serviceRequestController.getRequestPanel(requestType, requestGroup, studentId, personId, otherRequestType, record);
            this$.loadStudentGridAndSearchRequest();
            if (this$.getStdandparentraiseservicerequestwindow() != undefined) this$.getStdandparentraiseservicerequestwindow().close();
        }
    },
    loadGridForFacultyPortal: function () {
        if (this.getCurrentLoggedPortalId() == 2) {
            var this$ = this;
            var ResultGrid = this.getFacultySearchResultGrid();
            ResultGrid.hide();
            var comboPanel = this.getCommonrequestcombopanel();
            var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.FACULTY_LIST_VIEWCODE);
            var values = new Object();
            var searchcriteria = new Array();
            values.configCode = CONSTANTS.CB.FACULTY_LIST_BASIC_CONFIGCODE;
            var facultyId = this$.getCurrentlyLoggedInUser().id;
            var facultyIdObj = this$.getJsonObject('USER_ID', facultyId);
            this$.pushJsonObjectInArray(null, searchcriteria);
            values.searchCriterias = searchcriteria;
            var jsonFormatFormData = values;
            ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        } else if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
            var this$ = this;
            var ResultGrid = this$.getStudentSearchResultGrid();
            ResultGrid.hide();
            var comboPanel = this.getCommonrequestcombopanel();
            var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
            resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.STUDENT_LIST_VIEWCODE);
            var values = new Object();
            var searchcriteria = new Array();
            values.configCode = CONSTANTS.CB.STUDENT_LIST_BASIC_CONFIGCODE;
            var studentId = this$.getCurrentlyLoggedInUserInfoForPortal().student.id;
            var studentIdObj = this$.getJsonObject('USER_ID', studentId);
            this$.pushJsonObjectInArray(studentIdObj, searchcriteria);
            values.searchCriterias = searchcriteria;
            var jsonFormatFormData = values;
            ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        }
    },
    submitStudentTransferServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.schoolLeavingTo;
        delete values.leavingTo;
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    submitStudentLeaveOfAbsenceRequestUploadServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        delete values.requestStatusId;
        delete values.batchEndDate;
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    submitExchangeSemesterRequestUploadServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
        values.admissionId = tab.getAdmissionId();
        delete values.requestStatusId;
        delete values.batchEndDate;
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    submitSchoolLeavingServiceRequest: function (button) {
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        values.serviceRequest = null;
        values.requester = {
            id: this.getContentPanelActiveTab().getRequesterId()
        };
		var isWaiveNoticeFld = form.down("#isWaiveNoticeId");
		if(!isNullOrEmpty(isWaiveNoticeFld) && isWaiveNoticeFld.isVisible()){
			isWaiveNoticeFld.setReadOnly(true);
		}
        values.admissionId = tab.getAdmissionId();
        delete values.requestStatusId;
        delete values.batchEndDate;
        delete values.withdrawDate;
        tab.setFormData(values);
        this.addDocumentPanel(tab, false);
    },
    updateSchoolLeaveTermEndDate: function (button) {
        var this$ = this;
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        var serviceRequestId = values.id;
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        Ext.Ajax.request({
            method: 'POST',
            url: SERVERURL.PATH_UPDATE_TERM_END_DATE_SCHOOL_LEAVING_REQUEST,
            params: {
                requestId: serviceRequestId,
                termEndDate: values.termEndDate,
                reasonForLeaving: values.reasonForLeaving,
                reasonRemarks: values.remarks
            },
            headers: {
                'Content-Type': 'application/json'
            },
            success: function (opt, success, response) {
                Ext.getBody().unmask();
                showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('TERM_END_DATE_UPDATE_MSG'));
                this$.closeTab(tab);
            }
        });
    },
    createOtherAcademyStudentTransferRequestJson: function (values, documentData, voluntaryDocument, id, fromBatchId, fromPeriodId) {
        var me = this;
        var academyLocationId = me.getCurrentAcademyLocation();
        values.fromALId = academyLocationId;
        var serviceRequestSetting = values.serviceRequestSetting;
        var admissionId = values.admissionId;
        delete values.serviceRequestSetting;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument, null, id);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
              
        
        object.dueDate = null;
        object.detail = values;
        
        values.wsStudentTransferRequestMultipleReason = [];
        if (Ext.isArray(values.leavingReasonId)) {
            var i = 0;
            Ext.each(values.leavingReasonId, function (currentRec) {
                values.wsStudentTransferRequestMultipleReason.push({
                    "studentTransferReason": {
                        "id": currentRec
                    },
                    "reasonRemark": values.leavingRemarks[i]
                });
                i = i + 1;
            });
        } else {
            values.wsStudentTransferRequestMultipleReason.push({
                "studentTransferReason": {
                    "id": values.leavingReasonId
                },
                "reasonRemark": values.leavingRemarks
            });
        }
        object.detail.academicTermId=object.detail.academicTerm;
        object.detail.fromPeriodId = object.detail.fromPeriod;
        object.detail.isAuthorizeDeclaration = object.detail.authorizeDeclaration;
        object.detail.visaRefusal = object.detail.visaRefusalCheck;
        object.detail.studiedInUk = object.detail.studiedInUkCheck;
        object.detail.isHealthInsurance = object.detail.healthInsuranceCheck;
        object.detail.isScholarship = object.detail.scholarshipCheck;
        object.detail.isMedicalIssues = object.detail.medicalIssuesCheck;
        object.detail.isUpToDateDetails = object.detail.upToDateDetails;
        object.detail.isConfirmation = object.detail.confirmation;
        delete object.detail.visaRefusalCheck;
        delete object.detail.authorizeDeclaration;
        delete object.detail.studiedInUkCheck;
        delete object.detail.healthInsuranceCheck;
        delete object.detail.scholarshipCheck;
        delete object.detail.medicalIssuesCheck;
        delete object.detail.fromAcademicLocation
        delete object.detail.academicTerm
        delete object.detail.fromBatch;
        delete object.detail.fromPeriod;
        delete object.detail.upToDateDetails;
        delete object.detail.studentdeclaration;
        delete object.detail.studentApply;
        delete object.detail.confirmation;
        delete object.detail.academicTermProgramWithdrwan;
        
        delete values.leavingReasonId;
        delete values.leavingRemarks;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete values.admissionId;
        object.detail.fromAdmissionId = admissionId;
        object.detail.fromBatchId = fromBatchId;
        object.portalId = portalId;
        if(!object.detail.fromPeriodId && !isNullOrEmpty(fromPeriodId)){
            object.detail.fromPeriodId = fromPeriodId;
        }
        return object;
    },
    createOtherSchoolLeavingRequestJson: function (values, documentData, voluntaryDocument, id) {
        var me = this;
        var academyLocationId = me.getCurrentAcademyLocation();
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        delete values.admissionId;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument, null, id);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        object.detail = values;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete values.fromALId;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    createOtherLeaveOfAbsenceRequestJson: function (values, documentData, voluntaryDocument, id) {
        var me = this;
        var academyLocationId = me.getCurrentAcademyLocation();
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        delete values.withdrawDate;
        delete values.loaImportantNote;
        delete values.loaRequesterDeclaration;
        delete values.loaStudentDeclaration;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument, null, id);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        object.detail = values;
        object.detail.isLoaRequesterDeclarationSecond = object.detail.loaRequesterDeclarationSecond;
        object.detail.isLoaStudentconfirmation = object.detail.loaStudentconfirmation;
        delete object.detail.loaRequesterDeclarationSecond;
        delete object.detail.loaStudentconfirmation;
        values.leaveOfAbsenceRequestMultipleReason = [];
        if (Ext.isArray(values.leavingReasonId)) {
            var i = 0;
            Ext.each(values.leavingReasonId, function (currentRec) {
                values.leaveOfAbsenceRequestMultipleReason.push({
                    "leaveOfAbsenceRequestReason": {
                        "id": currentRec
                    },
                    "reasonRemark": values.leavingRemarks[i]
                });
                i = i + 1;
            });
        } else {
            values.leaveOfAbsenceRequestMultipleReason.push({
                "leaveOfAbsenceRequestReason": {
                    "id": values.leavingReasonId
                },
                "reasonRemark": values.leavingRemarks
            });
        }
        object.detail.startDate = object.detail.startDate;
        delete object.detail.leavingReasonId;
        delete object.detail.leavingRemarks;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete values.fromALId;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    createExchangeSemesterRequestJson: function (values, documentData, voluntaryDocument, id) {
        var me = this;
        var academyLocationId = me.getCurrentAcademyLocation();
        var serviceRequestSetting = values.serviceRequestSetting;
        delete values.serviceRequestSetting;
        delete values.leavingTo;
        delete values.schoolLeavingTo;
        var object = me.createServiceRequestJson(values, documentData, voluntaryDocument, null, id);
        object.serviceRequestSetting.id = serviceRequestSetting.id;
        object.dueDate = null;
        object.detail = values;
        object.detail.isAuthorizeDeclaration = object.detail.authorizeDeclaration;
        object.detail.visaRefsual = object.detail.visaRefusalCheck;
        object.detail.studiedInUk = object.detail.studiedInUkCheck;
        object.detail.isHealthInsurance = object.detail.healthInsuranceCheck;
        object.detail.isScholarship = object.detail.scholarshipCheck;
        object.detail.isMedicalIssues = object.detail.medicalIssuesCheck;
        object.detail.isUpToDateDetails = object.detail.upToDateDetails;
        object.detail.isConfirmation = object.detail.confirmation;
        delete object.detail.visaRefusalCheck;
        delete object.detail.authorizeDeclaration;
        delete object.detail.studiedInUkCheck;
        delete object.detail.healthInsuranceCheck;
        delete object.detail.scholarshipCheck;
        delete object.detail.medicalIssuesCheck;
        delete object.detail.upToDateDetails;
        delete object.detail.studentdeclaration;
        delete object.detail.studentApply;
        delete object.detail.confirmation;
        delete object.executionDetail;
        delete object.certificateRequestDetail;
        delete object.feeDetail;
        delete values.fromALId;
        delete object.detail.academicTermProgramWithdrwan;
        return object;
    },
    loadToProgramComboByAL: function (cmb) {
        var currentALId = this.getCurrentAcademyLocation();
        var requestPanel = cmb.up('form').down('requesterdetailspanel');
        var fromProgram = cmb.up('form').down('#fromProgramId');
        var toProgram = cmb.up('form').down('#toProgramId');
        var toBatch = cmb.up('form').down('#toBatchId');
        var toBatchStore = toBatch.getStore();
        var toseatType = cmb.up('form').down('#toSeatTypeId1');
        var toSeatTypeStore = toseatType.getStore();
        var toPeriodCombo = cmb.up('form').down('#toPeriodId');
        var toPeriodStore = toPeriodCombo.getStore();
        var values = cmb.up('form').getValues();
        var fromProgramCode = fromProgram.valueModels[0].data.code;
        var serviceRequestSettingId = values.serviceRequestSetting.id;
        var batchendDate = requestPanel.down('#batchEndDateItemId').getValue();
        var programrequestdetailspanel = cmb.up('programrequestdetailspanel');
        var batchEndDateNew = batchendDate;
        var periodId = this.getContentPanelActiveTab().getPeriodId();
        var requestTypeCode = this.getContentPanelActiveTab().getRequestTypeCode();
        if (programrequestdetailspanel) {
            batchEndDateNew = Ext.Date.format(new Date(parseInt(batchendDate)), 'Y-m-d');
        }
        if (toseatType == undefined) {
            toseatType = cmb.up('form').down('#toSeatTypeId1');
        }
        if (toPeriodCombo != undefined) {
            toPeriodCombo.reset();
        }
        toProgram.reset();
        toProgram.setDisabled(false);
        toBatch.reset();
        toBatch.setDisabled(true);
        toPeriodCombo.reset();
        toPeriodCombo.setDisabled(true);
        toseatType.reset();
        toseatType.setDisabled(true);
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_FIND_BY_SERVICE_REQUEST_SETTING_ID,
            params: {
                serviceRequestSettingId: serviceRequestSettingId
            },
            method: 'GET',
            success: function (response) {
                var data = Ext.decode(response.responseText);
                var store = toProgram.getStore();
                store.getProxy().extraParams = {
                    academyLocationId: cmb.getValue(),
                    isProgramTransferRequest: true
                };
                if ((data.isAllowSameProgram) && (currentALId != cmb.getValue())) {
                    store.load({
                        callback: function (records, operation, success) {
                            if (success) {
                                for (var i in records) {
                                    if (records[i].data.code == fromProgramCode) {
                                        toProgram.setValue(records[i].data.id);
                                        toBatch.setDisabled(false);
                                        toBatchStore.getProxy().extraParams = {
                                            batchendDate: batchEndDateNew,
                                            id: records[i].data.id,
                                        };
                                        toBatchStore.load({
                                            callback: function (record) {
                                                if (record.length == 1) {
                                                    toPeriodCombo.setDisabled(false);
                                                    toseatType.setDisabled(false);
                                                    toBatch.setValue(record[0].data.id);
                                                    toPeriodStore.getProxy().extraParams = {
                                                        batchId: record[0].data.id
                                                    };
                                                    toPeriodStore.load({
                                                        callback: function (record) {
                                                            if (record.length == 1) {
                                                                toPeriodCombo.setValue(record[0].data.id);
                                                            }
                                                        }
                                                    });
                                                    toSeatTypeStore.getProxy().extraParams = {
                                                        batchIds: record[0].data.id
                                                    };
                                                    toSeatTypeStore.load({
                                                        callback: function (record) {
                                                            if (record.length == 1) {
                                                                toseatType.setValue(record[0].data.id);
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    } else {
                                        store.removeAt(store.find('id', records[i].data.id));
                                    }
                                }
                            }
                        }
                    });
                } else {
                    store.load({
                        params: {
                            academyLocationId: cmb.getValue(),
                            isProgramTransferRequest: true,
                            periodId : periodId,
                            requestTypeCode:requestTypeCode
                        }
                    });
                }
            }
        })
    },
    loadALComboStore: function (combo, aLId, toProgramId) {
        var store = combo.getStore();
        var form = combo.up('form');
        var toProgramCombo = form.down('#toProgramId');
        store.load({
            callback: function (records, operation, success) {
                if (success) {
                    combo.setValue(aLId);
                }
                if (!isNullOrEmpty(toProgramId)) {
                    toProgramCombo.getStore().load({
                        params: {
                            academyLocationId: aLId
                        },
                        callback: function (records, operation, success) {
                            if (success) {
                                toProgramCombo.setValue(toProgramId);
                                toProgramCombo.setDisabled(false);
                            }
                        }
                    });
                }
            }
        });
    },
    enableDisableQuickCommentBtn : function (column, selected, grid) { 
    	 var quickCommentId = grid.down('#quickCommentId');
    	 if (!isNullOrEmpty(selected) && selected.length == 1) { 
    		 quickCommentId.setDisabled(false);
    	 }
    	 else{
    		 quickCommentId.setDisabled(true);
    	 }
    },
	enableDisableQuickCommentToStudentBtn : function (column, selected, grid) { 
	   	 var quickCommentToStudentId = grid.down('#quickCommentToStudentId');
		   	 if (!isNullOrEmpty(selected) && selected.length == 1) { 
		   		quickCommentToStudentId.setDisabled(false);
		   	 }
	   	 else{
	   		quickCommentToStudentId.setDisabled(true);
	   	 }
	  },
   enableDisableQuickCommentToFacultyBtn : function (column, selected, grid) { 
	  	 var quickCommentToFacultyId = grid.down('#quickCommentToFacultyId');
	  	 if (!isNullOrEmpty(selected) && selected.length == 1) { 
	  		quickCommentToFacultyId.setDisabled(false);
	  	 }
	  	 else{
	  		quickCommentToFacultyId.setDisabled(true);
	  	 }
	  },
	  enableDisableQuickCommentToFacultyRequestBtn : function (column, selected, grid) { 
		  var grid = this.getRequestpendingactiongrid()
		  	 var quickCommentToFacultyRequestId = grid.down('#quickCommentToFacultyRequestId');
		  	 if (!isNullOrEmpty(selected) && selected.length == 1) { 
		  		quickCommentToFacultyRequestId.setDisabled(false);
		  	 }
		  	 else{
		  		quickCommentToFacultyRequestId.setDisabled(true);
		  	 }
		  },
    enableDisableCancelRequestBtn: function (column, selected, grid) {
        var cancelButtonItemId = grid.down('#cancelBtnRequestId');
        var uploadDocumentBtn = grid.down('#uploadDocumentBtn');
        if (!isNullOrEmpty(selected) && selected.length == 1) {
            var data = selected[0].data;
            if (cancelButtonItemId) {
            	
                if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'STUDENT_TRANSFER'  && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                    cancelButtonItemId.setVisible(true);
                    cancelButtonItemId.setDisabled(false);
                } 
                else if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'PROGRAM_TRANSFER'  && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                    cancelButtonItemId.setVisible(true);
                    cancelButtonItemId.setDisabled(false);
                }
                else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'SCHOOL_LEAVING' && data.SERVICE_REQUEST_STATUS != 'Completed' && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                     cancelButtonItemId.setVisible(true);
                    cancelButtonItemId.setDisabled(false);
                }
                else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'EXCHANGE_SEMESTER'  && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                     cancelButtonItemId.setVisible(true);
                    cancelButtonItemId.setDisabled(false);
                }
                 else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'PROGRAM_WITHDRAWAL'  && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                    cancelButtonItemId.setVisible(true);
                    cancelButtonItemId.setDisabled(false);
                }
                else {
					cancelButtonItemId.setVisible(true);
                   // cancelButtonItemId.setDisabled(false);
                	if(data.SERVICE_REQUEST_TYPE == 'LEAVE_OF_ABSENCE' || data.SERVICE_REQUEST_TYPE == 'DEBARMENT' || data.SERVICE_REQUEST_TYPE == 'TERMINATION' || data.SERVICE_REQUEST_TYPE == 'PROGRAM_WITHDRAWAL'){
                	Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.FIND_ALL_DROPDOWN,
                        method: 'GET',
                        async: false,
                        success: function (response, action) {
                        	if(response != undefined && response.responseText !=null && !isEmpty(response.responseText)){
                        	var responseTxt = Ext.decode(response.responseText);
                        	if (responseTxt!=undefined && responseTxt.type=="IsStudentJourneyImplemented" && responseTxt.name=="true"){
                        		  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'LEAVE_OF_ABSENCE' && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                                    cancelButtonItemId.setDisabled(false);
                                }
                                else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'DEBARMENT' && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                                    cancelButtonItemId.setDisabled(false);
                                }
                                else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'TERMINATION' &&  data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                                    cancelButtonItemId.setDisabled(false);
                                }
                        	}	  
                        	}else{
                        		if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'LEAVE_OF_ABSENCE' && data.SERVICE_REQUEST_STATUS != 'Completed' && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                                    cancelButtonItemId.setDisabled(false);
                                }
                                else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'DEBARMENT' && data.SERVICE_REQUEST_STATUS != 'Completed' && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                                    cancelButtonItemId.setDisabled(false);
                                }
                                else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'TERMINATION' && data.SERVICE_REQUEST_STATUS != 'Completed' && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                                    cancelButtonItemId.setDisabled(false);
                                }
                                else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'PROGRAM_WITHDRAWAL' && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                                    cancelButtonItemId.setDisabled(false);
                                }
                                else  if (selected.length == 1 && data.SERVICE_REQUEST_TYPE == 'PROGRAM_TRANSFER' && data.SERVICE_REQUEST_STATUS != 'Cancelled' && data.SERVICE_REQUEST_STATUS != 'Rejected') {
                                    cancelButtonItemId.setDisabled(false);
                                }
                        	}
                        	
                        }
                    });
                	}else
                    cancelButtonItemId.setDisabled(true);
                }
            }
           
            if (portalId == "3" || portalId == "7") {
                if (selected.length == 1 && data.SERVICE_REQUEST_STATUS != "Rejected" && data.SERVICE_REQUEST_STATUS != "Approved") {
                    uploadDocumentBtn.enable();
                } else {
                    uploadDocumentBtn.disable();
                }
            }
        } else {
            if (cancelButtonItemId) {
                cancelButtonItemId.setDisabled(true);
            }
            if (uploadDocumentBtn) {
                uploadDocumentBtn.disable();
            }
        }
    },
    enableDisableReAssignRequestBtn: function (column, selected) {
        var grid = this.getStudentSearchResultGrid();
        var reassignBtnRequestId = grid.down('#reassignBtnRequestId');
        var uploadDocumentBtn = grid.down('#uploadDocumentBtn');
        if (!isNullOrEmpty(selected) && selected.length == 1) {
            var data = selected[0].data;
            if (selected.length == 1 && (data.SERVICE_REQUEST_STATUS == 'Closed' || data.SERVICE_REQUEST_STATUS == 'Cancelled' || data.SERVICE_REQUEST_STATUS == 'Rejected' || data.SERVICE_REQUEST_STATUS == 'Withdrawn')) {
                reassignBtnRequestId.setDisabled(true);
            } else {
                reassignBtnRequestId.setDisabled(false);
            }
        } else {
            reassignBtnRequestId.setDisabled(true);
        }
    },
    enableDisableOtherBtns: function (column, selected) {
        var grid = this.getStudentSearchResultGrid();
        var approveBtnRequestId = grid.down('#approveBtnRequestId');
        var rejectBtnRequestId = grid.down('#rejectBtnRequestId');
        var moreActionBtnRequestId = grid.down('#moreActionBtnRequestId');
        if (!isNullOrEmpty(selected) && selected.length > 0) {
            var allTerminationSelected = true;
            var allApproveSelected = true;
            var allRejectSelected = true;
            var allClosedSelected = true;
            var allInProgressSelected = true;
            var allLeaveOfAbsenseSelected = true;
            var allWithdrawFromPrgmSelected = true;
            var allInProgressTransferSelected = true;
            var allAssignedSelected = true;
            var allDebartmentSelected = true;
            var allCompletedSelected = true;
            var allApproveSelectedTemp = true;
            var allInProgressSelectedTemp = true;
            var allInStudentTransferSelected = true;
            var allExchangeSemesterSelected = true;
            Ext.each(selected, function (currentSel) {
                if (currentSel.data.SERVICE_REQUEST_TYPE != 'PROGRAM_WITHDRAWAL') {
                    allWithdrawFromPrgmSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_TYPE != 'TERMINATION') {
                    allTerminationSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_TYPE != 'LEAVE_OF_ABSENCE') {
                    allLeaveOfAbsenseSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_TYPE != 'PROGRAM_TRANSFER') {
                    allInProgressTransferSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_TYPE != 'STUDENT_TRANSFER') {
                	allInStudentTransferSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_TYPE != 'DEBARMENT') {
                    allDebartmentSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_TYPE != 'EXCHANGE_SEMESTER') {
                    allExchangeSemesterSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_STATUS != 'Approved') {
                    allApproveSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_STATUS == 'Approved') {
                    allApproveSelectedTemp = false;
                }
                if (currentSel.data.SERVICE_REQUEST_STATUS == 'Rejected') {
                    allRejectSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_STATUS == 'Closed') {
                    allClosedSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_STATUS == 'Completed') {
                    allCompletedSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_STATUS != 'Submitted') {
                    allInProgressSelected = false;
                }
                if (currentSel.data.SERVICE_REQUEST_STATUS == 'Submitted') {
                    allInProgressSelectedTemp = false;
                }
                if (currentSel.data.SERVICE_REQUEST_STATUS != 'Assigned') {
                    allAssignedSelected = false;
                }
            });
            if (allTerminationSelected || allWithdrawFromPrgmSelected || allLeaveOfAbsenseSelected || allInProgressTransferSelected || allDebartmentSelected || allInStudentTransferSelected || allExchangeSemesterSelected) {
                if (approveBtnRequestId) {
                    if (allInProgressSelected) {
                        approveBtnRequestId.enable();
                    } else {
                        approveBtnRequestId.disable();
                    }
                }
                if (rejectBtnRequestId) {
                    if (allApproveSelected || allInProgressSelected || allAssignedSelected) {
                        rejectBtnRequestId.enable();
                    } else {}
                }
                if (moreActionBtnRequestId) {
                    if (allApproveSelected) {
                        moreActionBtnRequestId.enable();
                    } else {
                        moreActionBtnRequestId.disable();
                    }
                }
                if (!allInProgressSelectedTemp) {
                    rejectBtnRequestId.enable();
                }
                if (approveBtnRequestId) {
                    if (!allApproveSelectedTemp) {
                        approveBtnRequestId.disable();
                    }
                }
                if (!allClosedSelected || !allRejectSelected || !allCompletedSelected) {
                    moreActionBtnRequestId.disable();
                    approveBtnRequestId.disable();
                    rejectBtnRequestId.disable();
                    allClosedSelected = true;
                    allRejectSelected = true;
                    allCompletedSelected = true;
                }
            } else {
                if (approveBtnRequestId) {
                    approveBtnRequestId.disable();
                }
                if (rejectBtnRequestId) {
                    if (allApproveSelected || allInProgressSelected || allAssignedSelected) {
                        rejectBtnRequestId.enable();
                    } else {}
                }
                if (moreActionBtnRequestId) {
                    moreActionBtnRequestId.disable();
                }
                if (!allClosedSelected || !allRejectSelected || !allCompletedSelected) {
                    moreActionBtnRequestId.disable();
                    approveBtnRequestId.disable();
                    rejectBtnRequestId.disable();
                    allClosedSelected = true;
                    allRejectSelected = true;
                    allCompletedSelected = true;
                }
            }
        } else {
            if (approveBtnRequestId) {
                approveBtnRequestId.disable();
            }
            if (rejectBtnRequestId) {
                rejectBtnRequestId.disable();
            }
            if (moreActionBtnRequestId) {
                moreActionBtnRequestId.disable();
            }
        }
    },
    disableQuickCommentBtnPivilegesToStudent: function (gridReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
        var quickCommentId = gridReference.down('#quickCommentToStudentId');
        quickCommentId.setVisible(false);
        Ext.each(permissionList, function (privilege) {
            if (privilege === 'QUICKCOMMENT') {
                if (!isNullOrEmpty(quickCommentId)) {
                	quickCommentId.setVisible(true);
                }
            }
        });
    },
    disableQuickCommentBtnPivileges: function (gridReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
        var quickCommentId = gridReference.down('#quickCommentId');
        quickCommentId.setVisible(false);
        Ext.each(permissionList, function (privilege) {
            if (privilege === 'QUICK_COMMENT') {
                if (!isNullOrEmpty(quickCommentId)) {
                	quickCommentId.setVisible(true);
                }
            }
        });
    },
    disableCancelBtnPivileges: function (gridReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
        var cancelButtonItemId = gridReference.down('#cancelBtnRequestId');
        var reassignBtnRequestId = gridReference.down('#reassignBtnRequestId');
        cancelButtonItemId.setVisible(false);
        Ext.each(permissionList, function (privilege) {
            if (privilege === 'CANCELREQUEST') {
                if (!isNullOrEmpty(cancelButtonItemId)) {
                    cancelButtonItemId.setVisible(true);
                }
            }
            if (privilege === 'REASSIGNREQUEST') {
                if (!isNullOrEmpty(reassignBtnRequestId)) {
                    reassignBtnRequestId.setVisible(true);
                }
            }
        });
    },
    cancelRequestForStudentTransferAL: function (button) {
        var me = this;
        var grid = me.getStudentSearchResultGrid();
        var serviceRequestSelectRcd = grid.getSelectionModel().getSelection();
        var cancellationWindow = this.getCancellationReasonPopupWindow();
   		var cancellationReason = cancellationWindow.down('#remark').getValue();
        if (!isNullOrEmpty(serviceRequestSelectRcd)) {
            var serviceRequestId = serviceRequestSelectRcd[0].data.ID;
            var requestType = serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE;
            Ext.Ajax.request({
                type: 'rest',
                method: 'POST',
                url: SERVERURL.CANCEL_REQUEST,
                params: {
                    serviceRequestId: serviceRequestId,
                    cancellationReason:cancellationReason,
                    requestType:requestType
                    
                },
                headers: {
                	'Content-Type': 'application/x-www-form-urlencoded'
                },
                success: function (opt, success, response) {
                    var controller = me.getController('Academia.controller.servicerequest.ServiceRequestController');
                    if (serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE === 'STUDENT_TRANSFER') {
                        grid.getStore().load();
                    }
                    else if (serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE === 'SCHOOL_LEAVING') {
                        grid.getStore().load();
                    }
                    else if (serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE === 'PROGRAM_TRANSFER') {
                        grid.getStore().load();
                    }
                    else if (serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE === 'LEAVE_OF_ABSENCE') {
                        grid.getStore().load();
                    }
                    else if (serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE === 'DEBARMENT') {
                        grid.getStore().load();
                    }
                    else if (serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE === 'TERMINATION') {
                        grid.getStore().load();
                    }
                     else if (serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE === 'EXCHANGE_SEMESTER') {
                        grid.getStore().load();
                    }
                     else if (serviceRequestSelectRcd[0].data.SERVICE_REQUEST_TYPE === 'PROGRAM_WITHDRAWAL') {
                        grid.getStore().load();
                    }
                    cancellationWindow.close();
                    showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('CANCELEDSUCCESSFULLY'));
                }
            });
        }
    },
    deleteStudentTransferExecutionDocumentGrid: function () {
        var $this = this;
        var grid;
        var serverURL;
        grid = $this.getStudenttransferexecutiondocumentgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('DOCUMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function (btn, text) {
                if (btn == 'yes') {
                    var store = grid.getStore();
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    if (!isNullOrEmpty(id)) {
                        Ext.Ajax.request({
                            method: "DELETE",
                            type: 'rest',
                            url: serverURL + '?id=' + id,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function (form, action) {
                                Ext.getBody().unmask();
                                store.reload();
                                showSuccessMessage(getCommonTranslation('DOCUMENT'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
                            }
                        });
                    } else {
                        if (record) {
                            store.remove(record);
                        }
                        Ext.getBody().unmask();
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('DOCMENT_NAME'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    deleteSchoolLeavingExecutionDocumentGrid: function () {
        var $this = this;
        var grid;
        var serverURL;
        grid = $this.getSchoolleavingexecutiondocumentgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('DOCUMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function (btn, text) {
                if (btn == 'yes') {
                    var store = grid.getStore();
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    if (!isNullOrEmpty(id)) {
                        Ext.Ajax.request({
                            method: "DELETE",
                            type: 'rest',
                            url: serverURL + '?id=' + id,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function (form, action) {
                                Ext.getBody().unmask();
                                store.reload();
                                showSuccessMessage(getCommonTranslation('DOCUMENT'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
                            }
                        });
                    } else {
                        if (record) {
                            store.remove(record);
                        }
                        Ext.getBody().unmask();
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('DOCMENT_NAME'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    enableDisableSubmitBtn: function (obj, newValue, oldValue) {
        var this$ = this;
        var form = this$.getStudentTransferExecutionDetails();
        var submitBtn = form.down('#studentTransferExecutionSubmitBtn');
        var feeOfStudentIsSettledValue = form.down('#feeOfStudentIsSettledId').getValue();
        var requiredDocumentAreUploadedValue = form.down("#requiredDocumentAreUploadedId").getValue();
        if (form.getForm().isValid() && feeOfStudentIsSettledValue && requiredDocumentAreUploadedValue) {
            submitBtn.setDisabled(false);
        } else {
            submitBtn.setDisabled(true);
        }
        form.getForm().isValid();
    },
    SchoolLeavingExecutionSubmitForm: function (form) {
        var me = this;
        var schoolLeavingForm = me.getSchoolLeavingExecutionDetails();
        var formData = schoolLeavingForm.getForm().getFieldValues();
        var requestStatusId = schoolLeavingForm.up().getResponseData().requestStatusId;
        if (requestStatusId == 6) {
            delete formData.userId;
            delete formData.displayCheckFeesAndDocMsg;
            delete formData.totalRecordDisplayField;
            var executionTab = me.getContentPanelActiveTab();
            var serviceRequestId = executionTab.getServiceRequestId();
            var user = me.getCurrentlyLoggedInUser();
            var url = SERVERURL.PATH_UPDATE_EXECUTION_DETAILS;
            formData.serviceRequestId = serviceRequestId;
            formData.user = user;
            var jsonFormatFormData = Ext.encode(formData);
            me.sendSaveAjaxRequest(url, 'POST', jsonFormatFormData, function (opt, success, response) {
                if (success) {
                    showSuccessMessage(getServiceRequestTranslation('EXECUTION_DETAILS'), getServiceRequestTranslation('EXECUTION_DETAILS_SUCCESS'));
                    if (executionTab.getRequestType() === 'STUDENT_REQUEST' || executionTab.getRequestType() === 'TRANSFER_REQUEST') {
                        me.loadStudentGridAndSearchRequest();
                    } else if (executionTab.getRequestType() === 'FACULTY_REQUEST') {
                        me.loadFacultyGridAndSearchRequest();
                    }
                    me.closeTab(executionTab);
                }
            });
        } else {
            me.submitExecutionDetailsForm(form);
        }
    },
    loadSeatTypeCombo: function (combo, data) {
        var me = this;
        var seatTypeCombo = combo.up('form').down('#toSeatTypeId1');
        seatTypeCombo.reset();
        seatTypeCombo.setDisabled(false);
        var store = seatTypeCombo.getStore();
        store.load({
            params: {
                batchIds: combo.getValue()
            },
            scope: this,
            callback: function (records, option, success) {
                me.loadAllPeriodComboStore(combo, data);
                if (records.length == 1) {
                    seatTypeCombo.setValue(records[0].data.id);
                }
            }
        });
        if (!isNullOrEmpty(data.detail)) {
            seatTypeCombo.setValue(data.detail.toSeatType);
        }
    },
    showServiceRequestNewDocumentForm: function (button) {
        var grid = button.up('grid');
        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            this.getDocumentController().showDocumentFormWindow('serviceRequestNewDocumentForm', 'EXT_DOCUMENT1');
            var formWindow = this.getDocumentController().getDocumentFormWindow();
            formWindow.setTitle(record.get('documentType').value);
            var combo = formWindow.down('#documentTypeCombo');
            var docTypes = new Array();
            docTypes.push(record.get('documentType'));
            var store = combo.getStore();
            store.loadData(docTypes);
            combo.setValue(record.get('documentType').id);
            combo.setReadOnly(true);
        } else {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    saveServiceRequestDocumentNewForm: function (button) {
        this$ = this;
        var tab = this.getContentPanelActiveTab();
        var isTransient = null;
        var form = this.getDocumentController().getServicerequestnewdocform();
        var id = form.down('#document_hidden_field').getValue();
        if (!isNullOrEmpty(id)) {
            isTransient = false;
        } else {
            isTransient = true;
        }
        var module = 'service_request';
        var entityId = tab.getRequesterId();
        var entityType = 'service _request';
        var isDuplicate = null;
        this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT1', function (success, response, isCallBackTransient) {
            if (success) {
                var documents = null;
                var documentObj = this$.createMandatoryDocumentJsonObject(response);
                documents = tab.getDocumentData();
                var isUnique = true;
                if (!isNullOrEmpty(documents) && documents.length != 0) {
                    if (documents[0].documentType != undefined) {
                        Ext.each(documents, function (doc) {
                            if (doc.documentType.id == documentObj.documentType.id) {
                                isUnique = false;
                            }
                        });
                    }
                }
                if (isUnique) {
                    if (documents == null) documents = new Array();
                    documents.push(documentObj);
                    tab.setDocumentData(documents);
                    if (isTransient) {
                        showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
                    } else {
                        showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_UPDATED_SUCCESSFULLY'));
                    }
                } else {
                    showErrorMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_EXISTS'));
                }
                this$.getDocumentController().closeDocumentFormWindow();
            }
        }, isTransient);
    },
    deleteServiceRequestMandatoryDocument: function (button) {
        var grid = button.up('grid');
        var this$ = this;
        var isdeleted = false;
        var tab = this.getContentPanelActiveTab();
        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            var documentData = tab.getDocumentData();
            if (!isNullOrEmpty(documentData) && documentData.length != 0) {
                Ext.each(documentData, function (doc) {
                    if (doc instanceof Object) {
                        if (doc.documentType.id === record.data.documentType.id) {
                            documentData = documentData.filter(function (rec) {
                                return rec.documentType.id != record.data.documentType.id;
                            });
                            tab.setDocumentData(documentData);
                            isdeleted = true;
                            showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getServiceRequestTranslation('DOCUMENT_DELETE'));
                            var serviceRequestSettings = tab.getServiceRequestSetting();
                            var id = null;
                            tab.getRequestType() === 'FACULTY_REQUEST' ? id = tab.getRequesterId() : id = tab.getAdmissionId();
                            grid.getStore().getProxy().extraParams = {
                                serviceRequestCategory: serviceRequestSettings.serviceRequestCategory,
                                settingId: serviceRequestSettings.id,
                                id: id
                            };
                            grid.getStore().load();
                        }
                    }
                });
                if (isdeleted == false) {
                    showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
                }
            } else {
                showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
            }
        } else {
            showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    uploadVoluntaryDocuments: function (btn) {
        var me = this;
        var grid = this.getStudentSearchResultGrid();
        if (!grid.isVisible()) {
            var grid = this.getStudentportalstudentrequestgrid();
        }
        var records = grid.getSelectionModel().getSelection()[0].data;
        var serviceRequestId = records.ID;
        var serviceRequestName = records.REQUEST_ID;
        var uploadedBy = this.getCurrentlyLoggedInUser().id;
        var formData = new FormData();
        var galleryDataViewAddWin = btn.up('form').down('#serviceReqDocDataViewAddWin');
        var galleryStore = galleryDataViewAddWin.getStore();
        if (galleryStore.data.length > 0) {
            Ext.each(galleryStore.data.items, function (currentFile) {
                formData.append("file[]", currentFile.data.fileData);
            });
        }
        btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        $.ajax({
            url: SERVERURL.PATH_UPLOAD_EC_VOLUNTARY_DOCUMENTS + '?serviceRequestId=' + serviceRequestId + '&serviceRequestName=' + serviceRequestName,
            method: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            headers: {
                'Authorization': Ext.Ajax.defaultHeaders.Authorization
            },
            success: function (response) {
                btn.up('window').body.unmask();
                btn.up('window').close();
                showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SUCCESS'));
            },
            error: function (err) {
                btn.up('window').body.unmask();
            }
        });
    },
    openValuntoryDocWindow: function (requestId) {
        var docWindow = this.getRequestpendingdocumentwindow();
        if (!docWindow) {
            docWindow = Ext.widget('requestpendingdocumentwindow', {
                itemId: 'requestpendingdocumentwindowItemId'
            });
        }
        docWindow.show();
        var requestpendingdocumentlistgrid = docWindow.down('#requestpendingdocumentlistgridItemId');
        requestpendingdocumentlistgrid.setTitle(getServiceRequestTranslation('VOLUNTARY_DOCUMENTS'));
        var store = requestpendingdocumentlistgrid.getStore();
        store.getProxy().extraParams = {
            serviceReqId: requestId
        };
        store.load();
    },
    openMandatoryDocWindow: function (requestId, requestType) {
    	 var manDocWindow = this.getRequestpendingmandatorydocumentwindow();
    	    if (!manDocWindow) {
    	        manDocWindow = Ext.widget('requestpendingmandatorydocumentwindow', {
    	            itemId: 'requestpendingmandatorydocumentwindowItemId'
    	        });
    	    }
    	    var studentGrid = this.getStudentSearchResultGrid();
    	    var sm = studentGrid.getSelectionModel();
    	    var selected = sm.getSelection()[0];
    	    if(selected){
    	    	manDocWindow.personId = selected.get('PERSON_ID');
    	    }
    	    sm.deselectAll();             
    	    manDocWindow.show();

    	    var requestGrid = manDocWindow.down('#requestpendingmandatorydocumentlistgridItemId');
    	    requestGrid.setTitle(getServiceRequestTranslation('MANDATORY_DOCUMENTS'));

    	    var gridStore;

    	    if(requestType === 'Readmission request') {
    	        gridStore = Ext.getStore('personinfo.common.request.RequestPendingMandatoryDocumentListGridReadmissionStore'); // alternate store
    	    } else {
    	        gridStore = requestGrid.getStore();
    	    }

    	    gridStore.getProxy().extraParams = { serviceReqId: requestId };
    	    gridStore.load();
    	    if(requestType === 'Readmission request') {
    	        requestGrid.reconfigure(gridStore);
    	    }
    	    var pagingToolbar = requestGrid.down('pagingtoolbar');
            if (pagingToolbar) {
                pagingToolbar.bindStore(gridStore);
            }
    },
    getDownloadReqPendingSingleFile: function (documentId) {
        if (!isNullOrEmpty(documentId)) {
            var $this = this;
            $this.getDocumentController().downloadDocumentFile(documentId);
        }
    },
    getDownloadreadmissionReqPendingSingleFile: function (documentId,isConfigured) {
        if (!isNullOrEmpty(documentId)) {
            var $this = this;
            $this.getDocumentController().downloadDocumentReadmissionFile(documentId,isConfigured);
        }
    },
    requestPendingDocumentZip: function (docType) {
        var $this = this;
        var form;
        var grid;
        var personId;
        var dispatchZipName;
        if (docType == 'VOLUNTARY_DOC') {
            form = $this.getRequestpendingdocumentwindow();
            grid = form.down('#requestpendingdocumentlistgridItemId');
            dispatchZipName = "Request Pending Voluntary Document";
        }
        if (docType == 'MANDATORY_DOC') {
            form = $this.getRequestpendingmandatorydocumentwindow();
            grid = form.down('#requestpendingmandatorydocumentlistgridItemId');
            dispatchZipName = "Request Pending Mandatory Document";
        }
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            var saveModel = [];
            var readmissionModel = [];
            personId = form.personId;
            for (var i in records) {
                if (!isNullOrEmpty(records[i].get('code'))) {
                	var code = records[i].get('code');
                	if(code.includes('readmission')){
                		readmissionModel.push(records[i].get('code'));
                	}else{
                		saveModel.push(records[i].get('code'));
                	}
                }
                showConfirmMessage(getServiceRequestTranslation('SERVICE_REQUEST_DOCUMENTS'), getServiceRequestTranslation('DOCUMENTS_ALERT'), function (btn, text) {
                    if (btn == 'yes') {
                        var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
                        $this.getController('Academia.controller.document.DocumentController').downloadMultipleDocumentFileForReadmission(saveModel, readmissionModel, dispatchZipName, directoryType, personId);
                    }
                });
            }
        } else {
            $this.hideWindowMask();
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    openRequestActionWin: function (level, btnType) {
        var me = this;
        if (level == 1) {
            var requestactionlevelwindow = this.getRequestactionlevelwindow();
            if (!requestactionlevelwindow) {
                Ext.widget('requestactionlevelwindow', {
                    level: 1,
                    title: getCommonTranslation('REQUEST_ACTION_LEVEL') + ' 1'
                });
                requestactionlevelwindow = this.getRequestactionlevelwindow();
            }
            requestactionlevelwindow.show();
        } else if (level == 2) {
            var requestactionlevelwindow = this.getRequestactionlevelwindow();
            if (!requestactionlevelwindow) {
                Ext.widget('requestactionlevelwindow', {
                    level: 2,
                    title: getCommonTranslation('REQUEST_ACTION_LEVEL') + ' 2'
                });
                requestactionlevelwindow = this.getRequestactionlevelwindow();
            }
            requestactionlevelwindow.show();
        }
    },
    setDataOnServiceReqPortalWin: function (data, window) {
        var $this = this;
        var container = window.down('#treeContainerId');
        var portalId = this.getCurrentLoggedPortalId();
        var programId = this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.programId;
        var i = 1;
        var jsonString = '';
        var newStore = [];
        Ext.each(data, function (currentPnl) {
        	var requstNameTitle = currentPnl.displayRequestName;
        	if(requstNameTitle=="Transfer"){
        		requstNameTitle = getServiceRequestTranslation('TRANSFER');
        	}
            var nStore = Ext.create('Ext.data.TreeStore', {
                fields: ['requestName', 'subRequest', 'value', 'code', {
                    name: 'text',
                    convert: function (r, rec) {
                        try {
                            if (typeof r == "string" && !isNullOrEmpty(r)) {
                                return r;
                            } else {
                                return rec.get('value');
                            }
                        } catch (e) {
                            return r;
                        }
                    }
                }],
                root: {
                    expanded: true,
                    children: [{
                        text: requstNameTitle,
                        expanded: true,
                        children: currentPnl.subRequest
                    }, ]
                }
            });
            newStore.push(nStore);
            if (i % 2 == 1) {
                if (i > 1) {
                    jsonString = jsonString + ",";
                }
                jsonString = jsonString + "{ 'xtype': 'fieldcontainer', 'layout': 'hbox','defaults': { 'labelAlign': 'top', 'width': 226 }, 'items': [";
            }
            jsonString = jsonString + "{ 'xtype':'treepanel', 'itemId':'treePanelId" + i + "', 'cls': 'treeChildNodeImg borderCls treeGridOverCls no-tree-icon', 'bodyCls':'raiseRequestTreeCls', 'rootVisible': false, 'multiSelect': false, 'width': 300, 'store':'', 'padding':3 }";
            if (i % 2 == 1) {
                jsonString = jsonString + ",";
            }
            if ((i % 2 == 0) || (i == data.length)) {
                jsonString = jsonString + "] }"
            }
            if (i == data.length) {
                jsonString = jsonString + ",{ 'xtype':'button','itemId':'cancelBtn',text: getServiceRequestTranslation('CANCEL'),ui: 'CustomBtnCancel',scale: CONSTANTS.BUTTONSIZE}";
            }
            i = i + 1;
        });
        var json = Ext.decode("[" + jsonString + "]");
        var j = 0;
        Ext.each(json, function (currentFContainer) {
            Ext.each(currentFContainer.items, function (currentFContainerItem) {
                currentFContainerItem.store = newStore[j];
                $this.setImageClsToRespectiveReq(currentFContainerItem);
                j = j + 1;
            });
        });
        window.add(json);
        window.setOverflowXY('hide', 'scroll');
        Ext.getBody().unmask();
    },
    setImageClsToRespectiveReq: function (currentFContainerItem) {
        if (currentFContainerItem.store.tree.root.firstChild.data.text == 'Other') {
            currentFContainerItem.cls = currentFContainerItem.cls + " otherReqImg";
        } else if (currentFContainerItem.store.tree.root.firstChild.data.text == getServiceRequestTranslation('TRANSFER')) {
            currentFContainerItem.cls = currentFContainerItem.cls + " transferReqImg";
        } else if (currentFContainerItem.store.tree.root.firstChild.data.text == 'Exam Related') {
            currentFContainerItem.cls = currentFContainerItem.cls + " examRelatedReqImg";
        } else if (currentFContainerItem.store.tree.root.firstChild.data.text == 'Personal Data Change Request') {
            currentFContainerItem.cls = currentFContainerItem.cls + " personalDataReqImg";
        } else if (currentFContainerItem.store.tree.root.firstChild.data.text == 'Certificate') {
            currentFContainerItem.cls = currentFContainerItem.cls + " certificateReqImg";
        } else if (currentFContainerItem.store.tree.root.firstChild.data.text == 'General') {
            currentFContainerItem.cls = currentFContainerItem.cls + " generalReqImg";
        }
    },
    checkValidationsForRequest: function (requestType, requestGroup, record) {
        $this = this
        var grid = $this.getStudentSearchResultGrid();
        var win = $this.getStdandparentraiseservicerequestwindow();
        if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
            var academyLocationId = this.getCurrentAcademyLocation();
            var studentId = $this.getCurrentlyLoggedInUserInfoForPortal().student.id;
            var personId = this.getCurrentlyLoggedInUserWithPersonId();
            if (record.data.code == 'HLR') {
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.FIND_WHETHER_CHECKEDIN,
                    method: 'GET',
                    params: {
                        studentId: studentId
                    },
                    async: false,
                    success: function (response, action) {
                        var requestTypeId = record.data.id;
                        var resp = Ext.JSON.decode(response.responseText);
                        if (resp == true) {
                            Ext.Ajax.request({
                                method: "GET",
                                type: 'rest',
                                url: SERVERURL.PATH_FIND_BY_IS_STUDENT_ADISOR_NAME,
                                params: {
                                    requestTypeId: requestTypeId,
                                    academyLocationId: academyLocationId,
                                    serviceRequestCategory: "STUDENT_REQUEST"
                                },
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function (f, action) {
                                    var advisorVal = Ext.decode(f.responseText);
                                    if (advisorVal == true) {
                                        Ext.Ajax.request({
                                            type: 'rest',
                                            url: SERVERURL.PATH_FIND_BY_ADISOR_NAME_BY_PERSON_ID,
                                            method: 'GET',
                                            params: {
                                                personId: personId.id,
                                            },
                                            headers: {
                                                'Content-Type': 'application/json'
                                            },
                                            async: false,
                                            success: function (response, action) {
                                                var resp = Ext.JSON.decode(response.responseText);
                                                if (resp.value != null) {
                                                    $this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, record.data.text);
                                                    win.close();
                                                } else {
                                                    showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('ADVISOR_NAME_IS_NOT_FOUND'));
                                                }
                                            }
                                        });
                                    } else {
                                        $this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, record.data.text);
                                        win.close();
                                    }
                                }
                            });
                        } else {
                            showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('STUDENT_NOT_CHECKED_IN'));
                        }
                    }
                });
            } else if (record.data.code == 'LR') {
                var requestTypeId = record.data.id;
                var academyLocationId = this.getCurrentAcademyLocation();
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.PATH_FIND_BY_IS_STUDENT_ADISOR_NAME,
                    method: 'GET',
                    params: {
                        requestTypeId: requestTypeId,
                        academyLocationId: academyLocationId,
                        serviceRequestCategory: "STUDENT_REQUEST"
                    },
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    async: false,
                    success: function (response, action) {
                        var resp = Ext.JSON.decode(response.responseText);
                        if (resp == true) {
                            Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.PATH_FIND_BY_ADISOR_NAME_BY_PERSON_ID,
                                method: 'GET',
                                params: {
                                    personId: personId.id,
                                },
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                async: false,
                                success: function (response, action) {
                                    var resp = Ext.JSON.decode(response.responseText);
                                    if (resp.value != null) {
                                        $this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, record.data.text);
                                        win.close();
                                    } else {
                                        showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('ADVISOR_NAME_IS_NOT_FOUND'));
                                    }
                                }
                            });
                        } else {
                            $this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, record.data.text);
                            win.close();
                        }
                    }
                });
            } else {
                this.openServiceRequestTab('STUDENT_REQUEST', requestGroup, record.data.text, record);
            }
        }
    },
    setWinFormData: function (level, win) {
        var me = this;
        var servicerequestactiondetailspanel = this.getContentPanelActiveTab().down('servicerequestactiondetailspanel');
        var nGrid = servicerequestactiondetailspanel.down('grid');
        var plannedActionDateField = win.down('#plannedActionDate');
        var actualActionDateField = win.down('#actualActionDate');
        var approverNameField = win.down("#approverName");
        var approverNameIdField = win.down('#approverNameId');
        var requestActionStatusField = win.down('#requestActionStatus');
        var requestActionStartField = win.down('#startDate');
        var requestActionEndField = win.down('#tillDate');
        var remarksField = win.down('#remarksField');
        var level1RequestStatusId = 0;
        var serviceRequestId = this.getContentPanelActiveTab().getServiceRequestId();
        if (level == 1) {
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.EXAM_CONCESSION_SERVICE_REQUEST_FIND_BY_ID,
                method: 'GET',
                params: {
                    requestId: serviceRequestId
                },
                async: false,
                success: function (response, action) {
                    if (!isNullOrEmpty(response.responseText)) {
                        var data = Ext.decode(response.responseText);
                        plannedActionDateField.setValue(dateRender(data.requestDate));
                        actualActionDateField.setValue(new Date());
                    }
                }
            });
        } else {
            var level1Record = nGrid.getStore().data.items[0];
            var level1PlannedActionDate = level1Record.data.plannedActionDate;
            var level1ActualActionDate = level1Record.data.actualActionDate;
            var level1StartDate = level1Record.data.startDate;
            var level1EndDate = level1Record.data.endDate;
            var level1Remarks = level1Record.data.remark;
            var level1RequestActionStatus = level1Record.data.requestActionStatus 
            requestActionStartField.setValue(dateRender(level1StartDate));
            requestActionEndField.setValue(dateRender(level1EndDate));
            plannedActionDateField.setValue(dateRender(level1ActualActionDate));
            actualActionDateField.setValue(new Date());
            remarksField.setValue(level1Remarks);
        }
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_FIND_APPROVER,
            method: 'GET',
            params: {
                code: 'ECER',
                academyLocationId: this.getCurrentAcademyLocation()
            },
            async: false,
            success: function (response, action) {
                if (!isNullOrEmpty(response.responseText)) {
                    var data = Ext.decode(response.responseText);
                    if (data.length) {
                        if (isNullOrEmpty(data[0].id)) {
                            approverNameField.setValue('');
                            approverNameIdField.setValue('');
                            me.setAllowBlank(approverNameField, true);
                            me.setAllowBlank(approverNameIdField, true);
                        } else {
                            var firstNameAp = !isNullOrEmpty(data[0].firstName) ? data[0].firstName : "";
                            var lastNameAp = !isNullOrEmpty(data[0].lastName) ? data[0].lastName : "";
                            var separatorAp = " ";
                            if (isNullOrEmpty(firstNameAp) || isNullOrEmpty(lastNameAp)) {
                                separatorAp = "";
                            }
                            if (isNullOrEmpty(firstNameAp) && isNullOrEmpty(lastNameAp)) {
                                me.setAllowBlank(approverNameField, true);
                                me.setAllowBlank(approverNameIdField, true);
                            }
                            approverNameField.setValue(firstNameAp + separatorAp + lastNameAp);
                            approverNameIdField.setValue(data[0].id);
                        }
                    }
                }
            }
        });
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.OTHER_REQUEST_GRID,
            method: 'POST',
            jsonData: {
                serviceRequestCategory: "STUDENT_REQUEST",
                serviceRequestGroup: "EXAM_RELATED",
                academyLocationId: this.getCurrentAcademyLocation()
            },
            async: false,
            success: function (response, action) {
                if (!isNullOrEmpty(response.responseText)) {
                    var data = Ext.decode(response.responseText);
                    Ext.each(data, function (currentData) {
                        if (currentData && currentData.requestType && currentData.requestType.code && currentData.requestType.code == "ECER") {
                            var requestStatusIds = currentData.requestStatusIds;
                            if (requestStatusIds.length) {
                                var storeData = [];
                                Ext.Ajax.request({
                                    type: 'rest',
                                    url: SERVERURL.FIND_SERVICE_REQUEST_STATUS,
                                    method: 'GET',
                                    async: false,
                                    success: function (response1, action) {
                                        if (!isNullOrEmpty(response1.responseText)) {
                                            var data1 = Ext.decode(response1.responseText);
                                            Ext.each(data1, function (currentData1) {
                                                if (Ext.Array.contains(requestStatusIds, currentData1.id)) {
                                                    storeData.push(currentData1);
                                                    if (level && level == 2 && level1RequestActionStatus && !isNullOrEmpty(level1RequestActionStatus)) {
                                                        if (currentData1.value == level1RequestActionStatus) {
                                                            level1RequestStatusId = currentData1.id;
                                                        }
                                                    }
                                                }
                                            })
                                        }
                                    }
                                });
                                requestActionStatusField.store.loadData(storeData);
                                if (level1RequestStatusId > 0) {
                                    requestActionStatusField.setValue(level1RequestStatusId);
                                }
                            }
                        }
                    })
                }
            }
        });
    },
    updateSchoolLeaveingReasonRemark: function (button) {
        var this$ = this;
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        var serviceRequestId = button.up('form').up().getValues();
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        Ext.Ajax.request({
            method: 'POST',
            url: SERVERURL.PATH_UPDATE_REASON_AND_REMARK_SCHOOL_LEAVING_REQUEST,
            params: {
                requestId: serviceRequestId,
                reasonForLeaving: values.reasonForLeaving,
                reasonRemarks: values.remarks
            },
            headers: {
                'Content-Type': 'application/json'
            },
            success: function (opt, success, response) {
                Ext.getBody().unmask();
                showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SUCCESS'));
                this$.getContentPanelActiveTab().close();
            }
        });
    },
    submitStudentTransferStudentTransferSR: function (button) {
        var this$ = this;
        var form = button.up('form');
        var tab = form.up('panel');
        var values = form.getValues();
        var serviceRequestId = button.up('form').up().getValues();
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        Ext.Ajax.request({
            method: 'POST',
            url: SERVERURL.PATH_UPDATE_REASON_AND_REMARK_STUDENT_TRANSFER_REQUEST,
            params: {
                requestId: serviceRequestId,
                reasonForLeaving: values.reasonForLeaving,
                reasonRemarks: values.remarks
            },
            headers: {
                'Content-Type': 'application/json'
            },
            
            success: function (opt, success, response) {
                Ext.getBody().unmask();
                showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'), getCommonTranslation('SUCCESS'));
                this$.getContentPanelActiveTab().close();
            }
        });
    },
    
    getMultipleReasonsRequired: function(){
		var isMultipleReasonsReq = false;
		Ext.Ajax.request({
			method : 'GET',
			url : SERVERURL.PATH_GET_MULTIPLE_REASON,
			headers : {
				'Content-Type' : 'application/json'
			},
			async: false,
			success : function(opt, success, response) {
				if(opt.responseText == "false"){
					isMultipleReasonsReq = false;
				}
				else{
					isMultipleReasonsReq = true;
				}
			}
		});
		return isMultipleReasonsReq;
	},
	 
	loadAcademicTermForStudentTransfer : function(from, academicTermId){
		 var academicTermField = from.down('#academicTermId');
         var fromAcademicLocationField = from.down('#fromAcademicLocationId');
         var isEditRequest = false;
         var activeTab = this.getContentPanelActiveTab();
					if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
						var serviceRequestId = activeTab.getServiceRequestId();
						if (!isNullOrEmpty(serviceRequestId)) {
							isEditRequest = true;
						}
					} 
		var academicTermStore = academicTermField.getStore();
        academicTermStore.getProxy().extraParams = {
        	studentId: this.getContentPanelActiveTab().getRequesterId(),
            isEditRequest : isEditRequest 
        };
        academicTermStore.load({
			   callback: function(rec, success){
				   if (success) {
					   academicTermField.setValue(academicTermId); 
				   }
			   }
		   });
	},
	loadAcademicTermForProgramWithdrwan : function(from, academicTermId){
		 var academicTermField = from.down('#academicTermProgramWithdrwanId');
     	var academicTermStore = academicTermField.getStore();
     	
		var isEditRequest = false;
		var activeTab = this.getContentPanelActiveTab();
		if (activeTab && typeof activeTab.getServiceRequestId === 'function') {
			var serviceRequestId = activeTab.getServiceRequestId();
			if (!isNullOrEmpty(serviceRequestId)) {
				isEditRequest = true;
			}
		} 
     	
     	academicTermStore.getProxy().extraParams = {
      	studentId: this.getContentPanelActiveTab().getRequesterId(),
      	isEditRequest : isEditRequest
      };
      academicTermStore.load({
			   callback: function(rec, success){
				   if (success) {
					   academicTermField.setValue(academicTermId); 
				   }
			   }
		   });
	},
	addReasonSection:function(btn){
		btn && btn.setVisible(false);
		btn && btn.nextSibling().setVisible(false);
	var me=this,
	readdmissionwin = me.getReAddmissionServiceRequestWin(),
	readdmissionForm= readdmissionwin.down('#reAddmissionFormView'),
	items=readdmissionForm.items.items,
	index = me.getPanelIndex(items);
	readdmissionForm.insert(index,{
		xtype:'selectReasonReAddmissionForm',
		width: '97%',
		margin:'40 0 10 5',
		 plugins: "formlabelrequired", 
			listeners:{
				afterrender:function(cmp){
					cmp.down('#serviceReason').maxWord=150;
					cmp.down('#deleteSectionBtn').setVisible(true);
					cmp.down('#deleteLabel').setVisible(true);
					cmp.down('#addSectionBtn').setVisible(false);
					cmp.down('#addLabel').setVisible(false);
				}
			}
	});
	readdmissionwin.down('form').fireEvent('fieldvaliditychange',readdmissionwin.down('form'));
},
	getPanelIndex:function(items) {
	    var index = -1;
	    items.forEach(function(item, idx) {
	        if (item.xtype === 'reAddmissionFileUploadForm') {
	            index = idx;
	            return false; // Stop iteration
	        }
	    });
	    return index;
	},
	
	/*saveReAddmissionForm: function(btn) {
	    btn.setDisabled(true);
	    var me = this,
	        readdmissionForm = me.getReAddmissionServiceRequestWin(),
	        formView = readdmissionForm.down('#reAddmissionFormView');
	    me.wsReadmissionModel={};
	    me.wsReadmissionReasonDocModel=[];
	    var fileFields = []; // Adjust the selector based on your implementation
	    var base64Strings = [];
	     var currentIndex = 0;
	    fileFields.push(formView.down('#uploadProgramFile'));
	    fileFields.push(formView.down('#proofOfPaymnet'));
	    fileFields.push(formView.down('#registeredStudentUploadFileField'));
	    fileFields.push(formView.down('#improveCourseUploadFileField'));
	    fileFields.push(formView.down('#studiesFutureUploadFileField'));
	    var fileFieldCount = fileFields.length;
	    me.processNextFile(currentIndex,fileFieldCount,base64Strings,fileFields,true);
	    fileFields=[];
	    readdmissionForm.query('selectReasonReAddmissionForm').forEach(function(rec){
	    	fileFields=rec.query('filefield');
	    	fileFieldCount = fileFields.length;
	    	currentIndex = 0;
	    	base64Strings = [];
	    	if(fileFieldCount){
	    		me.processNextFile(currentIndex,fileFieldCount,base64Strings,fileFields);
	    	}
	    	 
	    })
	    Ext.defer(function(){
	    	me.uploadReaddmissionFileData()
	    })
	},

	readFileAsBinary: function(file, callback) {
		var me = this;
	    var reader = new FileReader();
	    reader.onload = function(event) {
	        var binaryData = event.target.result;
	        var base64String = me.arrayBufferToBase64(binaryData);
	        callback(base64String);
	    };
	    reader.onerror = function(error) {
	        console.error('Error reading file:', error);
	        callback(null);
	    };
	    reader.readAsArrayBuffer(file);
	},

	arrayBufferToBase64 :function (buffer) {
	    var binary = '';
	    var bytes = new Uint8Array(buffer);
	    var len = bytes.byteLength;
	    for (var i = 0; i < len; i++) {
	        binary += String.fromCharCode(bytes[i]);
	    }
	    return btoa(binary);
	},
	sendAjaxRequest:function (data,isFlag) {
		var me =this;
    if(isFlag){
    	data.forEach(function(rec){
    		switch(rec.fileFieldName) {
    		  case 'proofOfPaymnet':
    			  me.wsReadmissionModel.proofPayment={
    	    			"module": "readmission",
    	    	        "entityType": "fillAdmForm",
    	    	        "name": rec.fileName,
    	    	        "file": rec.base64String,
    	    	}
    		     break;
    		  case "registeredStudentUploadFileField":
    			  me.wsReadmissionModel.section1={
    	    			"module": "readmission",
    	    	        "entityType": "fillAdmForm",
    	    	        "name": rec.fileName,
    	    	        "file": rec.base64String,
    	    	}
    		    break;
    		  case "improveCourseUploadFileField":
    			  me.wsReadmissionModel.section2={
    	    			"module": "readmission",
    	    	        "entityType": "fillAdmForm",
    	    	        "name": rec.fileName,
    	    	        "file": rec.base64String,
    	    	}
    			  break;
    		  case "studiesFutureUploadFileField":
    			  me.wsReadmissionModel.section3={
    	    			"module": "readmission",
    	    	        "entityType": "fillAdmForm",
    	    	        "name": rec.fileName,
    	    	        "file": rec.base64String,
    	    	}
    			  break;
    		  case "uploadProgramFile":
    			  me.wsReadmissionModel.programmeChangeMotivation={
    	    			"module": "readmission",
    	    	        "entityType": "fillAdmForm",
    	    	        "name": rec.fileName,
    	    	        "file": rec.base64String,
    	    	}
    			  break;
    		}
    		
    	})}else{
    		var sectionAarr =[];
    		data.forEach(function(val){
    			sectionAarr.push({
    				 "childId":1,
                     "module": "readmission",
                     "entityType": "fillAdmForm",
                     "name": val.fileName,
 	    	        "file": val.base64String,
    			})
    		})
    		 me.wsReadmissionReasonDocModel.push({
    			 id:1,
    			 child:sectionAarr
    		 });
    	}
    },
    processNextFile:function (currentIndex,fileFieldCount,base64Strings,fileFields,isFlag) {
    	var me = this;
        if (currentIndex >= fileFieldCount) {
            me.sendAjaxRequest(base64Strings,isFlag);
            return;
        }

        var fileField = fileFields[currentIndex];
        var file = fileField.fileInputEl.dom.files[0];

        if (file) {
            me.readFileAsBinary(file, function(base64String) {
                if (base64String) {
                	base64Strings.push({
                        fileFieldName: fileField.name, // Assuming each fileField has a name property
                        base64String: base64String,
                        fileName:fileField.value.split('\\fakepath\\')[1]
                    });
                }
                currentIndex++;
                me.processNextFile(currentIndex,fileFieldCount,base64Strings,fileFields,isFlag);
            });
        } else {
            currentIndex++;
            me.processNextFile(currentIndex,fileFieldCount,base64Strings,fileFields,isFlag);
        }
    },
    uploadReaddmissionFileData:function(){
    	var me = this;
    	me.wsReadmissionModel.wsReadmissionReasonDocModel=me.wsReadmissionReasonDocModel;
    	debugger;
    }
	*/
	
	addMoreReasonSection: function(cmp) {
		var me = this,
		fileUploadArray = [],
		isDuplicate = false,
		readdmissionForm = me.getReAddmissionServiceRequestWin(),
		filefieldArray = null,
		reasonCombo = readdmissionForm.query('#serviceReason'),
		fieldContainer = cmp.up();
		if(!isNullOrEmpty(cmp.lastSelection[0].data)){
			filefieldArray = cmp.lastSelection[0].data.readmissionReasonChild;

			// Check for duplicate reasons
			reasonCombo.forEach(function(fld) {
				if(!fld.getValue()){
					isDuplicate = true;
				}
				if (fld.id !== cmp.id && fld.getValue() === cmp.getValue()) {
					cmp.reset();
					showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('REASON_ALREADY_SELECTED'));
					isDuplicate = false;
				}
			});

			// If not duplicate, proceed to add file upload fields
			if (!isDuplicate) {
				filefieldArray.forEach(function(rec) {
					var isMandatory = rec.documentType !== "Mandatory",
					astrichSign = isMandatory ? '' : ':<span class="required" style="color:red"> *</span>';

					fileUploadArray.push({
						xtype: 'fieldcontainer',
						layout: 'vbox', // Set the layout to column
						width: '100%',
						columnWidth: 0.5, // Use full width for the HTML content
						minHeight: 60, // Ensure minimum height to accommodate fields
						defaults: {
							labelAlign: 'top',
							labelWidth: 150 // Adjust label width as needed
						},
						items: [{
							xtype: 'fieldcontainer',
							layout: 'column', // Set the layout to column
							width: '100%',
							minHeight: 60, // Ensure minimum height to accommodate fields
							defaults: {
								margin: '0 10 10 0', // Consistent margin for all items
								labelAlign: 'top',
								labelWidth: 150 // Adjust label width as needed
							},
							items: [{
								xtype: 'filefield',
								columnWidth: 0.8, // Set the width for the file field
								ui: 'CustomBtnCancel',
								fieldLabel: rec.documentName + astrichSign,
								fileId: rec.id,
								itemId: 'fileUploadId_' + rec.id,
								labelSeparator:' ',
								reasonId: cmp.getValue(),
								buttonText: getCommonTranslation('BROWSE'),
								name: rec.documentName,
								allowBlank: isMandatory,
								validateOnChange: true,
								listeners: {
									change: function(cmp) {
										me.checkFileExtentionandSize(cmp);
									}
								}
							},{
								xtype: 'button',
								columnWidth: 0.2, // Set the width for the button
								itemId: 'resetFileField',
								cls: 'CustomToolbarBtnReject iconDelete',
								iconCls: 'icon-Delete',
								disabled: true,
								margin: '30 0 0 0' // Adjust margin for vertical alignment
							}]
						},{
							xtype: 'container',
							cls: 'htmlClsLabel',
							itemId: 'dynamicLinkCls_' + rec.id,
							minHeight: 20,
							style: {
								'margin': '5 0 0 0 !important'
							},
							html: '' // Placeholder for additional content
						}]
					});

				});

				// Remove existing file upload container if it exists
				var existingFileFieldUploadContainer = fieldContainer.down('#fileFiledUploadContainer');
				if (existingFileFieldUploadContainer) {
					existingFileFieldUploadContainer.destroy();
				}

				// Insert new file upload container
				if (fileUploadArray.length) {
					var formPanel = Ext.create('Ext.panel.Panel', {
						layout: 'column',
						height: 'auto',
						id: 'reasonComponent_' + cmp.getValue(),
						itemId: 'fileFiledUploadContainer',
						style: {
							'margin': '0 0 0 0 !important'
						},
						width: '100%',
						items: fileUploadArray
					});
					fieldContainer.insert(formPanel);
					readdmissionForm.down('form').fireEvent('fieldvaliditychange',readdmissionForm.down('form'));
				}
			}
		}
	},

	saveReAddmissionForm: function(btn, isCalledOnClose) {
	    btn.setDisabled(true);
	    var tab = this.getContentPanelActiveTab();
	    if(tab && tab.getResponseData()){
	    	this.saveEditReaddmissionForm();
	    }else{
	    	var me = this,
	        readdmissionForm = me.getReAddmissionServiceRequestWin(),
	        formView = readdmissionForm.down('#reAddmissionFormView');
	    me.wsReadmissionModel = {};
	    me.wsReadmissionReasonDocModel = [];
	    var fileFields = []; // Adjust the selector based on your implementation
	    var base64Strings = [];
	    var currentIndex = 0;
	    fileFields.push(formView.down('#uploadProgramFile'));
	    fileFields.push(formView.down('#proofOfPaymnet'));
	    fileFields.push(formView.down('#registeredStudentUploadFileField'));
	    fileFields.push(formView.down('#improveCourseUploadFileField'));
	    fileFields.push(formView.down('#studiesFutureUploadFileField'));
	    var fileFieldCount = fileFields.length;
	    me.applyWindowMask();

	    var processedFiles = 0;
	    me.checkAllfileCreated=1;
	    function checkAllFilesProcessed() {
	        processedFiles++;
	        if (processedFiles === me.checkAllfileCreated) {
	            me.uploadReaddmissionFileData(isCalledOnClose);
	        }
	    }

	    me.processNextFile(currentIndex, fileFieldCount, base64Strings, fileFields, true, checkAllFilesProcessed);

	    readdmissionForm.query('selectReasonReAddmissionForm').forEach(function(rec) {
	        fileFields = rec.query('filefield');
	        fileFieldCount = fileFields.length;
	        currentIndex = 0;
	        base64Strings = [];
	       
	        if (fileFieldCount) {
	        	 me.checkAllfileCreated++;
	            me.processNextFile(currentIndex, fileFieldCount, base64Strings, fileFields, false, checkAllFilesProcessed);
	        }
	    });
	    }
	    
	    
	},

	readFileAsBinary: function(file, callback) {
	    var me = this;
	    var reader = new FileReader();
	    reader.onload = function(event) {
	        var binaryData = event.target.result;
	        var base64String = me.arrayBufferToBase64(binaryData);
	        callback(base64String);
	    };
	    reader.onerror = function(error) {
	        console.error('Error reading file:', error);
	        callback(null);
	    };
	    reader.readAsArrayBuffer(file);
	},

	arrayBufferToBase64: function(buffer) {
	    var binary = '';
	    var bytes = new Uint8Array(buffer);
	    var len = bytes.byteLength;
	    for (var i = 0; i < len; i++) {
	        binary += String.fromCharCode(bytes[i]);
	    }
	    return btoa(binary);
	},

	sendAjaxRequest: function(data, isFlag) {
	    var me = this;
	    if (isFlag) {
	        data.forEach(function(rec) {
	            switch (rec.fileFieldName) {
	                case 'proofOfPaymnet':
	                    me.wsReadmissionModel.proofPayment = {
	                        "moduleName": "readmission",
	                        "entityType": "fillAdmForm",
	                        "name": rec.fileName,
	                        "file": rec.base64String,
	                    };
	                    break;
	                case "registeredStudentUploadFileField":
	                    me.wsReadmissionModel.section1 = {
	                        "moduleName": "readmission",
	                        "entityType": "fillAdmForm",
	                        "name": rec.fileName,
	                        "file": rec.base64String,
	                    };
	                    break;
	                case "improveCourseUploadFileField":
	                    me.wsReadmissionModel.section2 = {
	                        "moduleName": "readmission",
	                        "entityType": "fillAdmForm",
	                        "name": rec.fileName,
	                        "file": rec.base64String,
	                    };
	                    break;
	                case "studiesFutureUploadFileField":
	                    me.wsReadmissionModel.section3 = {
	                        "moduleName": "readmission",
	                        "entityType": "fillAdmForm",
	                        "name": rec.fileName,
	                        "file": rec.base64String,
	                    };
	                    break;
	                case "uploadProgramFile":
	                    me.wsReadmissionModel.programmeChangeMotivation = {
	                        "moduleName": "readmission",
	                        "entityType": "fillAdmForm",
	                        "name": rec.fileName,
	                        "file": rec.base64String,
	                    };
	                    break;
	            }
	        });
	    } else {
	        var sectionArr = [];
	        data.forEach(function(val) {
	            sectionArr.push({
	                "childId": val.fileId,
	                "moduleName": "readmission",
	                "entityType": "fillAdmForm",
	                "name": val.fileName,
	                "file": val.base64String,
	            });
	        });
	        me.wsReadmissionReasonDocModel.push({
	            id: data[0] ?data[0].reasonId:'',
	            child: sectionArr
	        });
	    }
	},

	processNextFile: function(currentIndex, fileFieldCount, base64Strings, fileFields, isFlag, callback) {
	    var me = this;
	    if (currentIndex >= fileFieldCount) {
	    	if(base64Strings && base64Strings.length){
	    		 me.sendAjaxRequest(base64Strings, isFlag);
	 	        
	    	}
	    	if (callback) callback();
	        return;
	    }

	    var fileField = fileFields[currentIndex];
	    var file = fileField.fileInputEl.dom.files[0];

	    if (file) {
	        me.readFileAsBinary(file, function(base64String) {
	            if (base64String) {
	                base64Strings.push({
	                    fileFieldName: fileField.name, // Assuming each fileField has a name property
	                    base64String: base64String,
	                    fileName: fileField.value.split('\\fakepath\\')[1]?fileField.value.split('\\fakepath\\')[1]:fileField.value,
	                    fileId: fileField.fileId,
	    	            reasonId:fileField.reasonId,
	                });
	            }
	            currentIndex++;
	            me.processNextFile(currentIndex, fileFieldCount, base64Strings, fileFields, isFlag, callback);
	        });
	    } else {
	        
	        currentIndex++;
	        me.processNextFile(currentIndex, fileFieldCount, base64Strings, fileFields, isFlag, callback);
	    }
	   
	},

	uploadReaddmissionFileData: function(isDrafted) {
	    var me = this;
	    var tab = this.getContentPanelActiveTab();
	    me.wsReadmissionModel.wsReadmissionReasonDocModel = me.wsReadmissionReasonDocModel;
	   var readdmissionForm = me.getReAddmissionServiceRequestWin(),
	   formView = readdmissionForm.down('#reAddmissionFormView'),
	    readdmissionSaveBtn = readdmissionForm.down('#readdmissionSaveBtn');
	  // if(me.wsReadmissionModel && me.wsReadmissionModel.wsReadmissionReasonDocModel && me.wsReadmissionModel.wsReadmissionReasonDocModel.length){
	   var  submitData = Ext.encode(me.wsReadmissionModel);
	    
	    console.log(me.wsReadmissionModel); // Just for debugging purposes, you can remove this line
	    // Here you can add your logic to upload the final data model
	    me.applyWindowMask();
	    Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_SAVE_READMISSION_UPLOAD_TEMP,
            jsonData: submitData,
            method: 'POST',
            success: function (response, action) {
            	readdmissionSaveBtn.setDisabled(false);
            	me.hideWindowMask();
            	if(response && response.responseText){
            		me.uploadImageReaddmissionFormData=formView.getValues();
                	me.responseReaddmissionData=Ext.decode(response.responseText);
                	if(tab.getResponseData()){
                		me.createJsonEditSubmmision(me.uploadImageReaddmissionFormData,me.responseReaddmissionData);
                	}else if(me.EditDocumentFormDataNew){
                    		me.createJsonEditSubmmision(me.uploadImageReaddmissionFormData,me.responseReaddmissionData);
                			tab.isReadmissionFormFill=true;
                	}
             		else{
             			me.createJsonFinalSubmmision(me.uploadImageReaddmissionFormData,me.responseReaddmissionData);
             			me.saveAsDraft();
             		}
                	
                	
		            readdmissionForm.close();
            	}
            },
            failure: function (response) {
            	readdmissionSaveBtn.setDisabled(false);
            }
        });
	 //  }
	},
	saveAsDraft: function(){
		var me = this, submitData,
		readdmissionForm = me.getReAddmissionServiceRequestWin(),
		admissionId = me.getContentPanelActiveTab().admissionId;
		studentId =  me.getContentPanelActiveTab().requesterId;
		submitUrl = '';
//		readmissionForm.savedDraftedId = resp.id;
//		me.setReadmissionFormRecord(tab,tempFormData,readmissionForm);
		if(readdmissionForm.savedDraftedId){
			submitUrl = SERVERURL.PATH_UPDATE_READMISSION_TEMP_DATA;
			me.readdmmisonRequestJsonData.id = readdmissionForm.savedDraftedId;
		}else{
			submitUrl = SERVERURL.PATH_SAVE_READMISSION_TEMP_DATA;
		}
		me.readdmmisonRequestJsonData.admissionId = admissionId;
		me.readdmmisonRequestJsonData.studentId = studentId;
		submitData = Ext.encode(me.readdmmisonRequestJsonData);
		
		Ext.Ajax.request({
			type: 'rest',
			url: submitUrl,
			jsonData: submitData,
			method: 'POST',
			success: function (response, action) {
				me.hideWindowMask();
				readdmissionForm.close();
			},
			failure: function (response) {
				me.hideWindowMask();
			}
		});
	},
	reAddmissionUploadRequest:function(button){
		var me = this;
		 var form = button.up('form'); 
		 var tab=this.getActiveTabfromContentPanel();
	        var tab = form.up('panel');
	        var admissionId = tab.admissionId;
	        Ext.Ajax.request({
	                				type: 'rest',
	                				url: SERVERURL.PATH_FIND_READMISSION_REQUEST_TEMP_DATA,
	                				params: {
	                					admissionId : admissionId
	                				},
	                				method: 'GET',
	                				success: function (response, action) {
	                					if(response.responseText){
	                						var resp = JSON.parse(response.responseText);
	                						if(!me.readdmmisonRequestJsonData && !me.EditDocumentFormDataNew){
	                							me.createJsonDataFromDraftData(resp)
	                						}
	                						if(resp && !resp.isDrafted){ 
	                				        	 showWarningMessage(getPersonModuleTranslation('ALERT'), getServiceRequestTranslation('FILL_READMISSION_FORM_FIRST'));
	                				        }else {
	                				        	 var values = form.getValues();
	                				 	        values.serviceRequest = null;
	                				 	        values.requester = {
	                				 	            id: tab.getRequesterId()
	                				 	        };
	                				 	        values.admissionId = tab.getAdmissionId();
	                				 	        delete values.requestStatusId;
	                				 	        delete values.batchEndDate;
	                				 	        delete values.schoolLeavingTo;
	                				 	        delete values.leavingTo;
	                				 	        tab.setFormData(values);
	                				 	        me.addDocumentPanel(tab, false);
	                				 	        if(tab.responseData && (tab.responseData.isWithdrawn  || tab.responseData.serviceRequestStage == "CLOSED" || tab.responseData.serviceRequestStage == "PRECLOSURE")){
	                				 	        	tab.down('#btnSaveRequestWithDocuments').setVisible(false);
	                				 	        }
	                				        }
	                					}else{
	                						showWarningMessage(getPersonModuleTranslation('ALERT'), getServiceRequestTranslation('FILL_READMISSION_FORM_FIRST'));
	                					}
	                				},
	                				failure: function (response) {
	                					//
	                				}
	                			});
	        
	       
	},
	createJsonFinalSubmmision:function(uploadImageReaddmissionFormData,responseReaddmissionData){
		var me = this,
		reasonArray=[],
		reasonView,
		fileArry=[],
		imageArray=[],
		fileFielddata,
		reasonData = responseReaddmissionData.wsReadmissionReasonDocModel;
		var readdmissionForm = me.getReAddmissionServiceRequestWin();
		for(var count =0; count<reasonData.length;count++){
			var imageCount=0;
			reasonView=Ext.getCmp('reasonComponent_'+reasonData[count].id);
			if(reasonView){
			fileArry=reasonView.query('filefield');
			var imageArray=[];
			fileArry.forEach(function(){
				if(reasonData[count].child[imageCount]){
				imageArray.push({
		            "readmissionReasonChild":
		            {
		                "id":reasonData[count].child[imageCount].childId


		            },
		            "readmissionReasondoc":reasonData[count].child[imageCount].path
		        });
				
				}
				imageCount++;
			})
			reasonArray.push({
				"readmissionReason":{
					"id":reasonData[count].id
				},
				"readmissionReasontext":reasonView.up().down('textareafield').getValue(),
				"readmissionRequestChildDetail":imageArray
			});
		}
		}
		
		me.readdmmisonRequestJsonData ={
			    "planningToChangeProgram":uploadImageReaddmissionFormData.planningToChangeProgram=='on'?true:false,
			    "programChangeMotivationDoc":responseReaddmissionData.programmeChangeMotivation?responseReaddmissionData.programmeChangeMotivation.path:'',
			    "intendedALOfStudy":isNullOrEmpty(uploadImageReaddmissionFormData.intendedStudy)?null:
			    {
			        "id":uploadImageReaddmissionFormData.intendedStudy
			    },
			    "intendedProgramOfStudy":isNullOrEmpty(uploadImageReaddmissionFormData.intendedProgram)?null:
			    {
			        "id":uploadImageReaddmissionFormData.intendedProgram
			    },
			    "unRegAchievementReason":uploadImageReaddmissionFormData.registeredStudentRemark,
			    "unRegAchievementDoc":responseReaddmissionData.section1?responseReaddmissionData.section1.path:'',
			    "assistanceReason":uploadImageReaddmissionFormData.measuresWhatAssistanceRemark,
			    "assistanceDoc":responseReaddmissionData.section2?responseReaddmissionData.section2.path:'',
			    "futureSucceedReason":uploadImageReaddmissionFormData.succeedYourStudiesRemark,
			    "futureSucceedDoc":responseReaddmissionData.section3?responseReaddmissionData.section3.path:'',
			    "proofOfPaymentDoc":responseReaddmissionData.proofPayment?responseReaddmissionData.proofPayment.path:'',  
			    "termsAndConditions":uploadImageReaddmissionFormData.termsAndConditions=='on'?true:false,
			    "readmissionRequestParentDetail":reasonArray
			}
var newar =[];
		
		readdmissionForm.query('selectReasonReAddmissionForm').forEach(function(temp){
		    var isExistS=false;
		    me.readdmmisonRequestJsonData.readmissionRequestParentDetail.forEach(function(newData){
		        if(newData.readmissionReason.id == temp.down('#serviceReason').getValue()){
		            newData.readmissionReasontext=temp.down('#motivationReason').getValue();
		            isExistS=true
		        }
		    })
		    if(!isExistS){
		        newar.push({
		            	readmissionReason:{
		            		id:temp.down('#serviceReason').getValue(),
		            	},
		                readmissionReasontext:temp.down('#motivationReason').getValue(),
		                readmissionRequestChildDetail:[]

		            }
		        )
		    }
		});
		me.readdmmisonRequestJsonData.isDrafted = false;
		if(readdmissionForm.down('form').isValid() && readdmissionForm.down('#termsAndConditions').checked){
			me.readdmmisonRequestJsonData.isDrafted = true;
		}
		if(newar && newar.length){
			me.readdmmisonRequestJsonData.readmissionRequestParentDetail= me.readdmmisonRequestJsonData.readmissionRequestParentDetail.concat(newar);
		}
		
	},

	checkFileExtentionandSize:function(fileField){
		var me = this;
    	value = fileField.getValue().replace('C:\\fakepath\\', '');
    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    	fileField.setRawValue(newValue);
    	if(fileField.itemId !="uploadProgramFile" && fileField.itemId !="proofOfPaymnet"){
    		fileField.up().nextSibling() && fileField.up().nextSibling().el.setHTML('');
    	}
    	if (!isNullOrEmpty(newValue)) {
    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
    	    if (me.isValidProfileImageExtensionReAddmission(extension)) {
    	        var file = fileField.fileInputEl.dom.files[0];
    	        if (file.size / 1048576 > 2) {
    	            fileField.reset();
    	            fileField.nextSibling().setDisabled(true);
    	            showWarningMessage(getPersonModuleTranslation('ALERT'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
    	        }else{
    	        	fileField.nextSibling().setDisabled(false);
    	        }
    	    } else {
    	    	fileField.nextSibling().setDisabled(true);
    	        fileField.reset();
    	        showWarningMessage(getPersonModuleTranslation('ALERT'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
    	    }
    	}else{
    		fileField.nextSibling().setDisabled(true);
    	}
	},
	resetUploadFileField:function(btn){
		var me =this;
		var readdmissionForm = me.getReAddmissionServiceRequestWin(),
		formView = readdmissionForm.down('form'),
		fieldName=btn.previousSibling().itemId,
		filePath = btn.previousSibling().getValue(),
		readdmissionSaveBtn = readdmissionForm.down('#readdmissionSaveBtn');
		btn.previousSibling().reset();
		if(btn.nextSibling() && btn.nextSibling().itemId == 'uploadProofOfPayament'){
			btn.nextSibling().el.setHTML('');
		}else if(btn.nextSibling() && btn.nextSibling().itemId == 'programChangeMotivation'){
			btn.nextSibling().el.setHTML('');
		}else{
			btn.up().nextSibling() && btn.up().nextSibling().el.setHTML('');
		}
		try{
			if(me.EditDocumentFormDataNew){
				if(fieldName == 'improveCourseUploadFileField'){
					me.EditDocumentFormDataNew.assistanceDoc='';
				}else if(fieldName ==  'studiesFutureUploadFileField'){
					me.EditDocumentFormDataNew.futureSucceedDoc='';
				}else if(fieldName ==  'registeredStudentUploadFileField'){
					me.EditDocumentFormDataNew.unRegAchievementDoc='';
				}else if(fieldName ==  'proofOfPaymnet'){
					me.EditDocumentFormDataNew.proofOfPaymentDoc='';
				}else if(fieldName ==  'uploadProgramFile'){
					me.EditDocumentFormDataNew.programChangeMotivationDoc='';
				}else{
					var dynamicFileID=fieldName.split('_')[1];
					var count = 0;
					me.EditDocumentFormDataNew.readmissionRequestParentDetail.forEach(function(rec){
						//if(rec.readmissionReason.id == dynamicFileID){
							me.EditDocumentFormDataNew.readmissionRequestParentDetail[count].readmissionRequestChildDetail.forEach(function(newRec){
								if(newRec.readmissionReasonChild && newRec.readmissionReasonChild.id == dynamicFileID && newRec.readmissionReasondoc.split("readmission")[1].replace('\\','').replace('/', '') == filePath){
									newRec.readmissionReasondoc='';

								}
							});
						//}
						count++
					});
				}
			}
		}catch(e){
			console.error('error')
		}

		btn.setDisabled(true);
		formView.getForm().clearInvalid();
	},
	setReadmissionFormRecord:function(tab,recordData,readmissionForm){
		var me =this,mainReason=[],childFileUpload=[],
		formData=recordData.detail;
		if(!formData){
			me.EditDocumentFormDataNew=recordData;
		}
		 me.applyWindowMask();
		if(!me.EditDocumentFormDataNew){
		formData.readmissionRequestParentDetail.forEach(function(rec){
		    rec.readmissionRequestChildDetail.forEach(function(childData){
		    	childFileUpload.push({
		            readmissionReasonChild:{
		                id:childData.readmissionReasonChild.id
		            },
		            readmissionReasondoc:childData.readmissionReasondoc
		        })
		    })
		   mainReason.push({
		       "readmissionReason":
		        {
		            "id":rec.readmissionReason.id
		        },
		        "readmissionReasontext":rec.readmissionReasontext,
		        readmissionRequestChildDetail:childFileUpload
		   })  
		});
		me.EditDocumentFormDataNew={
				id:recordData.detail.id,
			    planningToChangeProgram:formData.planningToChangeProgram,
			    programChangeMotivationDoc:formData.programChangeMotivationDoc,
			    intendedALOfStudy:{
			        id:formData.intendedALOfStudy.id

			    },
			    intendedProgramOfStudy:{
			    	id:formData.intendedProgramOfStudy.id
			    },
			    unRegAchievementDoc:formData.unRegAchievementDoc,
			    unRegAchievementReason:formData.unRegAchievementReason,
			    assistanceReason:formData.assistanceReason,
			    assistanceDoc:formData.assistanceDoc,
			    futureSucceedReason:formData.futureSucceedReason,
			    futureSucceedDoc:formData.futureSucceedDoc,
			    proofOfPaymentDoc:formData.proofOfPaymentDoc,
			    termsAndConditions:formData.termsAndConditions,
			    readmissionRequestParentDetail:mainReason
			    
			};
		}
		formData=me.EditDocumentFormDataNew;
		var formField = readmissionForm.down('form'),
		planningToChangeProgram=formField.down('#planningToChangeProgram'),
		uploadProgramFile=formField.down('#uploadProgramFile'),
		intendedStudy=formField.down('#intendedStudy'),
		intendedProgram=formField.down('#intendedProgram'),
		proofOfPaymnet=formField.down('#proofOfPaymnet'),
		registeredStudentRemark=formField.down('#registeredStudentRemark'),
		registeredStudentUploadFileField=formField.down('#registeredStudentUploadFileField'),
		measuresWhatAssistanceRemark=formField.down('#measuresWhatAssistanceRemark'),
		improveCourseUploadFileField=formField.down('#improveCourseUploadFileField'),
		succeedYourStudiesRemark=formField.down('#succeedYourStudiesRemark'),
		studiesFutureUploadFileField=formField.down('#studiesFutureUploadFileField'),
		termsAndConditions=formField.down('#termsAndConditions'),
		registeredStudentUploadFileLink=formField.down('#registeredStudentUploadFileLink'),
		improveCourseUploadFileLink=formField.down('#improveCourseUploadFileLink'),
		programChangeMotivation=formField.down('#programChangeMotivation'),
		uploadProofOfPayament=formField.down('#uploadProofOfPayament'),
		studiesFutureUploadFileLink=formField.down('#studiesFutureUploadFileLink');
		
		planningToChangeProgram.setValue(formData.planningToChangeProgram);
		formData.programChangeMotivationDoc && uploadProgramFile.setRawValue(formData.programChangeMotivationDoc.split("readmission")[1].replace('\\','').replace('/', ''));
		formData.programChangeMotivationDoc && programChangeMotivation.el.setHTML('<a  href="#" link="'+formData.programChangeMotivationDoc+'" onclick="return downloadAttachedFile(this)">'+formData.programChangeMotivationDoc.split("readmission")[1].replace('\\','').replace('/', '')+'</a>');
		formData.programChangeMotivationDoc && uploadProgramFile.nextSibling().setDisabled(false)
		if(!isNullOrEmpty(formData.intendedALOfStudy)){
			intendedStudy.getStore().load({
				callback: function (records, operation, success) {
					intendedStudy.setValue(formData.intendedALOfStudy.id)
				}
			});
			intendedProgram.getStore().getProxy().extraParams={
				academyLocationId:formData.intendedALOfStudy.id
			}
		}
		
		intendedProgram.setDisabled(false);
		if(!isNullOrEmpty(formData.intendedProgramOfStudy)){
			intendedProgram.getStore().load({
				callback: function (records, operation, success) {
					intendedProgram.setValue(formData.intendedProgramOfStudy.id)
					me.hideWindowMask();
				}
			});
		}
		
		
		formData.proofOfPaymentDoc && proofOfPaymnet.setRawValue(formData.proofOfPaymentDoc.split("readmission")[1].replace('\\','').replace('/', ''));
		formData.proofOfPaymentDoc && uploadProofOfPayament.el.setHTML('<a  href="#" link="'+formData.proofOfPaymentDoc+'" onclick="return downloadAttachedFile(this)">'+formData.proofOfPaymentDoc.split("readmission")[1].replace('\\','').replace('/', '')+'</a>');
		formData.proofOfPaymentDoc && proofOfPaymnet.nextSibling().setDisabled(false);
		registeredStudentRemark.setValue(formData.unRegAchievementReason);
		formData.unRegAchievementDoc && registeredStudentUploadFileField.setRawValue(formData.unRegAchievementDoc.split("readmission")[1].replace('\\','').replace('/', ''));
		formData.programChangeMotivationDoc && registeredStudentUploadFileField.nextSibling().setDisabled(false);
		measuresWhatAssistanceRemark.setValue(formData.assistanceReason);
		formData.assistanceDoc && improveCourseUploadFileField.setRawValue(formData.assistanceDoc.split("readmission")[1].replace('\\','').replace('/', ''));
		formData.assistanceDoc && improveCourseUploadFileField.nextSibling().setDisabled(false);
		succeedYourStudiesRemark.setValue(formData.futureSucceedReason);
		formData.futureSucceedDoc && studiesFutureUploadFileField.setRawValue(formData.futureSucceedDoc.split("readmission")[1].replace('\\','').replace('/', ''));
		formData.futureSucceedDoc && studiesFutureUploadFileField.nextSibling().setDisabled(false);
		termsAndConditions.setValue(formData.termsAndConditions);
		
		formData.unRegAchievementDoc && registeredStudentUploadFileLink.el.setHTML('<a  href="#" link="'+formData.unRegAchievementDoc+'" onclick="return downloadAttachedFile(this)">'+formData.unRegAchievementDoc.split("readmission")[1].replace('\\','').replace('/', '')+'</a>');
		formData.assistanceDoc && improveCourseUploadFileLink.el.setHTML('<a href="#" link="'+formData.assistanceDoc+'" onclick="return downloadAttachedFile(this)">'+formData.assistanceDoc.split("readmission")[1].replace('\\','').replace('/', '')+'</a>');
		formData.futureSucceedDoc && studiesFutureUploadFileLink.el.setHTML('<a  href="#" link="'+formData.futureSucceedDoc+'" onclick="return downloadAttachedFile(this)">'+formData.futureSucceedDoc.split("readmission")[1].replace('\\','').replace('/', '')+'</a>');
		var count = 0;

		function processRecords(index) {
		    if (index >= formData.readmissionRequestParentDetail.length) {
		    	if(tab.responseData && (portalId == 3 || (tab.responseData && tab.responseData.isWithdrawn) || tab.responseData.serviceRequestStage == "CLOSED" || tab.responseData.serviceRequestStage == "PRECLOSURE")){
		    		var Fields= formField.getForm().getFields().items;
		    		Fields.forEach(function(rec){
		    			rec.setReadOnly(true);
		    		});
		    		var btns =formField.query('#resetFileField');
		    		btns.forEach(function(btn){
		    			btn.setDisabled(true);
		    		});
		    		var filefieldS =formField.query('filefield');
		    		filefieldS.forEach(function(file){
		    			file.setDisabled(true);
		    		});
		    		var addbtns =formField.query('#addSectionBtn');
		    		addbtns.forEach(function(addBtn){
		    			addBtn.setDisabled(true);
		    		});
		    		var deleteSectionBtn =formField.query('#addSectionBtn');
		    		deleteSectionBtn.forEach(function(deleteBtn){
		    			deleteBtn.setDisabled(true);
		    		});
		    		readmissionForm.down('#readdmissionSaveBtn').setVisible(false);
		    	}
		        console.log('All iterations completed successfully');
		        return;
		    }

		    var rec = formData.readmissionRequestParentDetail[index];
		    
		    if (count > 0) {
		    	formField.query('#addSectionBtn')[0].setVisible(false);
		    	formField.query('#addSectionBtn')[0].nextSibling().setVisible(false);
		        me.addReasonSection();
		    }

		    var reasonform = readmissionForm.query('selectReasonReAddmissionForm')[count];
		    reasonform.down('textareafield').setValue(rec.readmissionReasontext);
		    
		    reasonform.down('customcombobox').getStore().load({
		        callback: function (records, operation, success) {
		            if (success) {
		            	if(!isNullOrEmpty(rec.readmissionReason)){
		            		reasonform.down('customcombobox').setValue(rec.readmissionReason.id);
		            		reasonform.down('customcombobox').fireEvent('select', reasonform.down('customcombobox'));
		            	}
		                rec.readmissionRequestChildDetail.forEach(function(data){
		                    var fileField = reasonform.down('#fileUploadId_' + data.readmissionReasonChild.id);
		                    if (fileField) {
		                    	data.readmissionReasondoc && fileField.setRawValue(data.readmissionReasondoc.split("readmission")[1].replace('\\','').replace('/', ''));
		                        data.readmissionReasondoc && fileField.nextSibling().setDisabled(false);
		                    }
		                   var linkBtn =reasonform.down('#dynamicLinkCls_' + data.readmissionReasonChild.id);
		                   if(linkBtn){
		                    data.readmissionReasondoc && linkBtn.el.setHTML('<a href="#" link="'+data.readmissionReasondoc+'"  onclick="return downloadAttachedFile(this)">'+data.readmissionReasondoc.split("readmission")[1].replace('\\','').replace('/', '')+'</a>');
		                   }
		                   });
		                count++;
		                processRecords(index + 1); // Move to the next item
		            } else {
		                console.error('Failed to load store at index', index);
		                // Optionally, you can decide to skip this item or handle the error
		                processRecords(index + 1); // Move to the next item
		            }
		        }
		    });
		}
		Ext.defer(function(){
			me.hideWindowMask();
		},2000)

		// Start processing from the first item
		processRecords(0);

	},
	createJsonEditSubmmision:function(uploadImageReaddmissionFormData,responseReaddmissionData){
		var me = this,
		tab = this.getContentPanelActiveTab(),
		reasonArray=[],
		reasonView,
		fileArry=[],
		imageArray=[],
		fileFielddata,
		reasonData = responseReaddmissionData.wsReadmissionReasonDocModel;
		var readdmissionForm = me.getReAddmissionServiceRequestWin();
		if(reasonData){
			for(var count =0; count<reasonData.length;count++){
				var imageCount=0;
				reasonView=Ext.getCmp('reasonComponent_'+reasonData[count].id);
				fileArry=reasonView?reasonView.query('filefield'):[];
				var imageArray=[];
				fileArry.forEach(function(){
					if(reasonData[count].child[imageCount]){
					imageArray.push({
						"readmissionReasonChild":
						{
							"id":reasonData[count].child[imageCount].childId


						},
						"readmissionReasondoc":reasonData[count].child[imageCount].path
					});
					}

					imageCount++;
				})
				reasonArray.push({
					"readmissionReason":
					{
						"id":reasonData[count].id
					},
					"readmissionReasontext":reasonView ? reasonView.up().down('textareafield').getValue():'',
					"readmissionRequestChildDetail":imageArray
				})
			}
		}
		me.EditDocumentFormDataNew.planningToChangeProgram=uploadImageReaddmissionFormData.planningToChangeProgram=='on'?true:false;
		me.EditDocumentFormDataNew.programChangeMotivationDoc=responseReaddmissionData.programmeChangeMotivation?responseReaddmissionData.programmeChangeMotivation.path:me.EditDocumentFormDataNew.programChangeMotivationDoc;
		me.EditDocumentFormDataNew.intendedALOfStudy={
			"id":uploadImageReaddmissionFormData.intendedStudy
		};
		me.EditDocumentFormDataNew.intendedProgramOfStudy=
		{
			"id":uploadImageReaddmissionFormData.intendedProgram
		};
		me.EditDocumentFormDataNew.unRegAchievementReason=uploadImageReaddmissionFormData.registeredStudentRemark;
		me.EditDocumentFormDataNew.unRegAchievementDoc=responseReaddmissionData.section1?responseReaddmissionData.section1.path:me.EditDocumentFormDataNew.unRegAchievementDoc;
		me.EditDocumentFormDataNew.assistanceReason=uploadImageReaddmissionFormData.measuresWhatAssistanceRemark;
		me.EditDocumentFormDataNew.assistanceDoc=responseReaddmissionData.section2?responseReaddmissionData.section2.path:me.EditDocumentFormDataNew.assistanceDoc,
		me.EditDocumentFormDataNew.futureSucceedReason=uploadImageReaddmissionFormData.succeedYourStudiesRemark;
		me.EditDocumentFormDataNew.futureSucceedDoc=responseReaddmissionData.section3?responseReaddmissionData.section3.path:me.EditDocumentFormDataNew.futureSucceedDoc;
		me.EditDocumentFormDataNew.proofOfPaymentDoc=responseReaddmissionData.proofPayment?responseReaddmissionData.proofPayment.path:me.EditDocumentFormDataNew.proofOfPaymentDoc    
		me.EditDocumentFormDataNew.termsAndConditions=uploadImageReaddmissionFormData.termsAndConditions=='on'?true:false
		var tempArray =[];
		reasonArray.forEach(function(rec){
		    var isExist=false;
		    me.EditDocumentFormDataNew.readmissionRequestParentDetail.forEach(function(cmp){
				   
		    	if(!isNullOrEmpty(cmp.readmissionReason) && cmp.readmissionReason.id==rec.readmissionReason.id){
		    		rec.readmissionRequestChildDetail.forEach(function(childData){
		    			var isChildExist =false;
		    			if(cmp.readmissionRequestChildDetail){
		    			cmp.readmissionRequestChildDetail.forEach(function(oldRec){
		    				if(!isNullOrEmpty(oldRec.readmissionReasonChild) && oldRec.readmissionReasonChild.id == childData.readmissionReasonChild.id){
		    					oldRec.readmissionReasondoc=childData.readmissionReasondoc;
		    					isChildExist =true;
		    				}
		    			})
		    			}
		    			if(!isChildExist){
		    				cmp.readmissionRequestChildDetail.push(childData);
		    			}
		    		})
		    		   cmp.readmissionReasontext=cmp.readmissionReasontext;
				       isExist=true
				   }  
			})
		    if(!isExist){
		        tempArray.push(rec)
		    }
		});
		if(tempArray && tempArray.length){
			me.EditDocumentFormDataNew.readmissionRequestParentDetail= me.EditDocumentFormDataNew.readmissionRequestParentDetail.concat(tempArray);
		}
		var newar =[];
		
		readdmissionForm.query('selectReasonReAddmissionForm').forEach(function(temp){
		    var isExistS=false;
		    me.EditDocumentFormDataNew.readmissionRequestParentDetail.forEach(function(newData){
		        if(!isNullOrEmpty(newData.readmissionReason) && newData.readmissionReason.id == temp.down('#serviceReason').getValue()){
		            newData.readmissionReasontext=temp.down('#motivationReason').getValue();
		            isExistS=true
		        }
		    });
		    if(!isExistS){
		        newar.push({
		            	readmissionReason:{
		            		id:temp.down('#serviceReason').getValue(),
		            	},
		                readmissionReasontext:temp.down('#motivationReason').getValue(),
		                readmissionRequestChildDetail:[]

		            }
		        )
		    }
		})
		if(newar && newar.length){
			me.EditDocumentFormDataNew.readmissionRequestParentDetail= me.EditDocumentFormDataNew.readmissionRequestParentDetail.concat(newar);
		}
		var temp=[];
		readdmissionForm.query('#serviceReason').forEach(function(rec){
		    temp.push(rec.getValue())
		})
		var removeRec=[]
		for(var count =0;count<me.EditDocumentFormDataNew.readmissionRequestParentDetail.length;count++){
			if(me.EditDocumentFormDataNew.readmissionRequestParentDetail[count].readmissionReason && me.EditDocumentFormDataNew.readmissionRequestParentDetail[count].readmissionReason.id){
				removeRec.push(me.EditDocumentFormDataNew.readmissionRequestParentDetail[count]);
			}
		}
		me.EditDocumentFormDataNew.readmissionRequestParentDetail = removeRec;
		
		var  submitData = Ext.encode(me.EditDocumentFormDataNew);
		
		if(!tab.getResponseData()){
		me.EditDocumentFormDataNew.isDrafted = false;
		var win = me.getReAddmissionServiceRequestWin();
		if(win.down('form').isValid() && win.down('#termsAndConditions').checked){
			me.EditDocumentFormDataNew.isDrafted = true;
		}
			me.EditDocumentFormDataNew.id = me.getReAddmissionServiceRequestWin().savedDraftedId;
			me.EditDocumentFormDataNew.studentId = me.getContentPanelActiveTab().requesterId;
			submitDrftData = Ext.encode(me.EditDocumentFormDataNew);
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_UPDATE_READMISSION_TEMP_DATA,
				jsonData: submitDrftData,
				method: 'POST',
				async: false,
				success: function (response, action) {
					me.hideWindowMask();
					readdmissionForm.close();
				},
				failure: function (response) {
					me.hideWindowMask();
				}
			});
		}
		if(tab.getResponseData()){
			delete me.EditDocumentFormDataNew.isDrafted;
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.UPDATE_READMISSION_REQUEST_DETAILS,
				jsonData: submitData,
				method: 'POST',
				success: function (response, action) {
					me.hideWindowMask();
					readdmissionForm.close();
				},
				failure: function (response) {
					me.hideWindowMask();
				}
			});
		}
	},
	saveEditReaddmissionForm:function(isDrafted){

		var me = this,
		readdmissionForm = me.getReAddmissionServiceRequestWin(),
		formView = readdmissionForm.down('#reAddmissionFormView');
		me.applyWindowMask();
		me.wsReadmissionModel = {};
		me.wsReadmissionReasonDocModel = [];
		var fileFields = []; // Adjust the selector based on your implementation
		var base64Strings = [];
		var currentIndex = 0;
		if(formView.down('#uploadProgramFile') && formView.down('#uploadProgramFile').fileInputEl.dom && formView.down('#uploadProgramFile').fileInputEl.dom.files[0]){
			fileFields.push(formView.down('#uploadProgramFile'));
		}
		if(formView.down('#proofOfPaymnet') && formView.down('#proofOfPaymnet').fileInputEl.dom && formView.down('#proofOfPaymnet').fileInputEl.dom.files[0]){
			fileFields.push(formView.down('#proofOfPaymnet'));
		}
		if(formView.down('#registeredStudentUploadFileField') && formView.down('#registeredStudentUploadFileField').fileInputEl.dom && formView.down('#registeredStudentUploadFileField').fileInputEl.dom.files[0]){
			fileFields.push(formView.down('#registeredStudentUploadFileField'));
		}
		if(formView.down('#improveCourseUploadFileField') && formView.down('#improveCourseUploadFileField').fileInputEl.dom && formView.down('#improveCourseUploadFileField').fileInputEl.dom.files[0]){
			fileFields.push(formView.down('#improveCourseUploadFileField'));
		}
		if(formView.down('#studiesFutureUploadFileField') && formView.down('#studiesFutureUploadFileField').fileInputEl.dom && formView.down('#studiesFutureUploadFileField').fileInputEl.dom.files[0]){
			fileFields.push(formView.down('#studiesFutureUploadFileField'));
		}
		var fileFieldCount = fileFields.length;
		me.applyWindowMask();
		var processedFiles = 0;
		if(fileFieldCount>0){
			me.checkAllfileCreated=1;
		}else{
			me.checkAllfileCreated=0;
		}

		function checkAllFilesProcessed() {
			processedFiles++;
			if (processedFiles === me.checkAllfileCreated) {
				me.uploadReaddmissionFileData(isDrafted);
			}
		}
		if(fileFieldCount>0){
			me.processNextFile(currentIndex, fileFieldCount, base64Strings, fileFields, true, checkAllFilesProcessed);
		}


		readdmissionForm.query('selectReasonReAddmissionForm').forEach(function(rec) {
			var validFileField=[];
			fileFields = rec.query('filefield');
			fileFields.forEach(function(validFile){
				if(validFile && validFile.fileInputEl.dom && validFile.fileInputEl.dom.files[0]){
					validFileField.push(validFile);
				}
			})
			fileFieldCount = validFileField.length;
			currentIndex = 0;
			base64Strings = [];

			if (fileFieldCount) {
				me.checkAllfileCreated++;
				me.processNextFile(currentIndex, fileFieldCount, base64Strings, validFileField, false, checkAllFilesProcessed);
			}
		});
		Ext.defer(function(){
			if(me.checkAllfileCreated==0){
				me.uploadImageReaddmissionFormData=formView.getValues()
				me.createJsonEditSubmmision(me.uploadImageReaddmissionFormData,{});
			}
		})
	},
	 getInActiveStudentServiceRequestRequired: function(){
	   		var serviceRequestRequiredForInActiveStudent = false;
	   		Ext.Ajax.request({
	   			method : 'GET',
	   			url : SERVERURL.PATH_GET_INACTIVE_STUDENT_SERVICE_REQUEST,
	   			headers : {
	   				'Content-Type' : 'application/json'
	   			},
	   			async: false,
	   			success : function(opt, success, response) {
	   				if(opt.responseText == "false"){
	   					serviceRequestRequiredForInActiveStudent = false;
	   				}
	   				else{
	   					serviceRequestRequiredForInActiveStudent = true;
	   				}
	   			}
	   		});
	   		return serviceRequestRequiredForInActiveStudent;
	   	},
	   	openQuickComment: function(button){
	   		var me = this
	   		button.down()
	   		var record;
	   		var formWindow = this.getQuickcommentwindow();
    		if (!formWindow) {
    			formWindow = Ext.widget('quickcommentwindow');
    			formWindow.show();
    		}	   		
	   	},
	   	saveAddQuickCommentRecord : function(btn){
	   		var $this = this;
			var quickCommentInput = $this.getQuickCommentInput()
			var fileBtn = quickCommentInput.down('#quickCommentFileUpload')
			var imgVal;
			if(!isNullOrEmpty(fileBtn.getValue())){
				imgVal = fileBtn.value.split('\\')[fileBtn.value.split('\\').length-1]
			}
			quickCommentInput.getForm().setValues({
			    entityId: '391',
			    entityType: 'service_request',
			    module: 'service_request',
			    documentType: 'QUICK_COMMENT_DOCUMENT'
			});
			
			if (imgVal) {
	            // If there's an image, upload it first
				quickCommentInput.getForm().submit({
				    method: 'POST',
				    url: SERVERURL.DOCUMENT_FILE_ADD,
				    success: function (form, action) {
				        var responseData = Ext.decode(action.response.responseText);
				        var path = responseData.path;
				        $this.saveQuickCommentData(imgVal,path)
				    },
				    failure: function (form, action) {
				      
				    }
				});
	        } 
			else {
				$this.saveQuickCommentData();  // Proceed without image
	        }	
	   	},
	   	
	   	saveQuickCommentData: function(imgName,imageUrl){	
	   		var $this = this;
	   		var uploadFiels = this.getQuickCommentInput().down('#quickCommentFileUpload')
	   		var box = this.getQuickCommentInput().down('#fileNameAddedItemId')
            var removeBtn = this.getQuickCommentInput().down('#documentRemoveToQuickCommentItemId')
			var form = $this.getQuickCommentInput().getForm()
			var quickCommentGrid = $this.getQuickCommentGrid()
			var fileBtn = $this.getQuickCommentInput().down('#quickCommentFileUpload')
			quickCommentDocName = imgName;
			quickCommentDocPath = imageUrl;
			var json;
			var formData
			var submitUrl = SERVERURL.PATH_QUICK_COMMENT_SAVE;
			var comment = form.findField('addQuickComment')
			var grid;
    		if(portalId == '1'){
    			grid = $this.getStudentSearchResultGrid().getSelectionModel().getSelection()
    		}
    		if(portalId == '2'){
    			if(typeof $this.getFacultySearchResultGrid() !== 'undefined' ){
        			grid = $this.getFacultySearchResultGrid().getSelectionModel().getSelection()
        		}
        		else{
        			grid = $this.getRequestpendingactiongrid().getSelectionModel().getSelection()
        		}
    		}
			if(portalId == '3'){
				grid = $this.getStudentportalstudentrequestgrid().getSelectionModel().getSelection()		
			}
				json = $this.createJsonForAddQuickComment(form,quickCommentDocName,quickCommentDocPath);				
				formData = json;				
				//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');		
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : formData,
					method : 'POST',
					success : function(frm, action) {
						comment.reset()	
						uploadFiels.reset()
	            		box.update("")
	            		removeBtn.setVisible(false)
//	            		uploadFiels.setDisabled(false)
//	            		uploadFiels.removeCls('fileUploadDisabled')
	            		quickCommentDocName = ''
	            		quickCommentDocPath = ''						
						showSuccessMessage(getCommonTranslation('SUCCESS'), getFeeAndPaymentCommonTranslation('COMMENT_ADDED_SUCCESSFULLY'));						
						var getcontroller=$this.getController('menu.CoreERPNavigationController');
						quickCommentGrid.getStore().load()
					    //grid.getSelectionModel().deselectAll();
						}
				});	
			
	   	},
	//  Add Quick Comment json
	   	createJsonForAddQuickComment:function(form,quickCommentDocName, quickCommentDocPath){
	    	var $this = this
	    	var form = $this.getQuickCommentInput()
	    	var formDatas = form.getValues();
	    	
	    	var selectedRecId;
    		if(portalId == '1'){
    			selectedRecId = this.getStudentSearchResultGrid().getSelectionModel().getSelection()[0].data.ID
    		}
    		if(portalId == '2'){
    			if(typeof this.getFacultySearchResultGrid() !== 'undefined'){
        			selectedRecId = this.getFacultySearchResultGrid().getSelectionModel().getSelection()[0].data.ID
        		}
        		else{
        			selectedRecId = this.getRequestpendingactiongrid().getSelectionModel().getSelection()[0].data.ID
        		}	
    		}
			if(portalId == '3'){
				selectedRecId = this.getStudentportalstudentrequestgrid().getSelectionModel().getSelection()[0].data.id		
			}
			if(quickCommentDocName){
				json = {
	    				  "serviceRequest": {
	    					    "id": selectedRecId
	    					  },
	    					  "document": {
	    					    "name": typeof quickCommentDocName !== 'undefined' && quickCommentDocName ? quickCommentDocName : null,
	    					    "path": typeof quickCommentDocPath !== 'undefined' && quickCommentDocPath ? quickCommentDocPath : null,
	    					    "type": "DOCUMENT"
	    					  },
	    					  "comments": formDatas.addQuickComment?formDatas.addQuickComment:null
	    					}	
			}
			else{
				json = {
	    				  "serviceRequest": {
	    					    "id": selectedRecId
	    					  },
	    					  "comments": formDatas.addQuickComment?formDatas.addQuickComment:null
	    					}
			}
	    	return json;
	    },
	    
	    addReasonComboStore: function(form){
	    	var me = this;
	    	var panel = form.up();
	    	var combo = form.down('#reasonForLeavingItemId');
	    	var store;
	    	if(panel.xtype == "studenttransferrequestdetailspanel"){
	    		store = 'servicerequest.studentservicerequest.ReasonForStudentTransferStore';
	    		combo.bindStore(store);
	    		combo.getStore().load();
	    	}else if(panel.xtype == "programrequestdetailspanel"){
	    		store = 'servicerequest.studentservicerequest.ReasonForProgramTransferStore';
	    		combo.bindStore(store);
	    		combo.getStore().load();
	    	}else if(panel.xtype == "withdrawfromprogramdetailspanel"){
	    		store = 'servicerequest.studentservicerequest.ReasonForWithdrawalFromProgram';
	    		combo.bindStore(store);
	    		combo.getStore().load();
	    	}
	    },
	    
											  /////************************************///
											  ///*************SAVE AS DRAFT************///
											  /////***********************************////
	   
	    
	    
	    saveReAddmissionFormDraft: function (btn, isCalledOnClose) {
	        var tab = this.getContentPanelActiveTab();
	        if (tab && tab.getResponseData()) {
	            this.saveEditReaddmissionForm();
	            return;
	        }

	        var me = this,
	            readdmissionForm = me.getReAddmissionServiceRequestWin(),
	            formView = readdmissionForm.down('#reAddmissionFormView');

	        me.wsReadmissionModel = {};
	        me.wsReadmissionReasonDocModel = [];

	        // ✅ Collect base form file fields
	        var fileFields = [
	            formView.down('#uploadProgramFile'),
	            formView.down('#proofOfPaymnet'),
	            formView.down('#registeredStudentUploadFileField'),
	            formView.down('#improveCourseUploadFileField'),
	            formView.down('#studiesFutureUploadFileField')
	        ];

	        var allGroups = []; // will hold all groups of file fields to process
	        allGroups.push({ fileFields: fileFields, isFlag: true });

	        // ✅ Collect filefields from each reason section
	        readdmissionForm.query('selectReasonReAddmissionForm').forEach(function (rec) {
	            var reasonFileFields = rec.query('filefield');
	            if (reasonFileFields.length > 0) {
	                allGroups.push({ fileFields: reasonFileFields, isFlag: false });
	            }
	        });

	        me.applyWindowMask();

	        // ✅ Keep track of total groups processed
	        var processedGroups = 0;
	        var totalGroups = allGroups.length;

	        function onGroupProcessed() {
	            processedGroups++;
	            if (processedGroups === totalGroups) {
	                // ✅ All recursion groups done, call final API once
	                me.uploadReaddmissionFileDataDraft(isCalledOnClose);
	            }
	        }

	        // ✅ Start processing each group sequentially
	        allGroups.forEach(function (group) {
	            me.processNextFileDraft(0, group.fileFields.length, [], group.fileFields, group.isFlag, onGroupProcessed);
	        });
	    },

	    processNextFileDraft: function (currentIndex, fileFieldCount, base64Strings, fileFields, isFlag, callback) {
	        var me = this;

	        // ✅ Recursion exit condition
	        if (currentIndex >= fileFieldCount) {
	            if (base64Strings.length > 0) {
	                // only push if there are actual files
	                me.sendAjaxRequest(base64Strings, isFlag);
	            }
	            if (callback) callback();
	            return;
	        }

	        var fileField = fileFields[currentIndex];
	        var file = fileField.fileInputEl.dom.files[0];

	        if (file) {
	            me.readFileAsBinary(file, function (base64String) {
	                if (base64String) {
	                    base64Strings.push({
	                        fileFieldName: fileField.name,
	                        base64String: base64String,
	                        fileName: fileField.value.split('\\fakepath\\')[1] ?
	                            fileField.value.split('\\fakepath\\')[1] :
	                            fileField.value,
	                        fileId: fileField.fileId,
	                        reasonId: fileField.reasonId
	                    });
	                }
	                // ✅ Move to next file
	                me.processNextFileDraft(currentIndex + 1, fileFieldCount, base64Strings, fileFields, isFlag, callback);
	            });
	        } else {
	            // ✅ Skip empty filefields and continue recursion
	            me.processNextFileDraft(currentIndex + 1, fileFieldCount, base64Strings, fileFields, isFlag, callback);
	        }
	    },

	    uploadReaddmissionFileDataDraft: function (isDrafted) {
	        var me = this;
	        var tab = me.getContentPanelActiveTab();
	        me.wsReadmissionModel.wsReadmissionReasonDocModel = me.wsReadmissionReasonDocModel;

	        var readdmissionForm = me.getReAddmissionServiceRequestWin(),
	            formView = readdmissionForm.down('#reAddmissionFormView');

	        var submitData = Ext.encode(me.wsReadmissionModel);

	        console.log("✅ Final wsReadmissionModel:", me.wsReadmissionModel);

	        me.applyWindowMask();

	        Ext.Ajax.request({
	            type: 'rest',
	            url: SERVERURL.PATH_SAVE_READMISSION_UPLOAD_TEMP,
	            jsonData: submitData,
	            method: 'POST',
	            success: function (response) {
	                me.hideWindowMask();
	                if (response && response.responseText) {
	                    me.uploadImageReaddmissionFormData = formView.getValues();
	                    me.responseReaddmissionData = Ext.decode(response.responseText);

	                    if (tab.getResponseData()) {
	                        me.createJsonEditSubmmision(me.uploadImageReaddmissionFormData, me.responseReaddmissionData);
	                    } else {
	                        if (me.EditDocumentFormDataNew) {
	                            me.createJsonEditSubmmisionDraft(me.uploadImageReaddmissionFormData, me.responseReaddmissionData);
	                            tab.isReadmissionFormFill = true;
	                        } else {
	                            me.createJsonFinalSubmmisionDraft(me.uploadImageReaddmissionFormData, me.responseReaddmissionData);
	                            me.saveAsDraft(); // ✅ Only called once after recursion done
	                            tab.isReadmissionFormFill = true;
	                        }
	                    }

	                    readdmissionForm.close();
	                }
	            },
	            failure: function () {
	                me.hideWindowMask();
	            }
	        });
	    },

	    		saveAsDraft: function(btn){
	    			var me = this, submitData,
	    			readdmissionForm = me.getReAddmissionServiceRequestWin(),
	    			admissionId = me.getContentPanelActiveTab().admissionId;
	    			studentId =  me.getContentPanelActiveTab().requesterId;
	    			submitUrl = '';
//	    			readmissionForm.savedDraftedId = resp.id;
//	    			me.setReadmissionFormRecord(tab,tempFormData,readmissionForm);
	    			if(readdmissionForm.savedDraftedId){
	    				submitUrl = SERVERURL.PATH_UPDATE_READMISSION_TEMP_DATA;
	    				me.readdmmisonRequestJsonData.id = readdmissionForm.savedDraftedId;
	    			}else{
	    				submitUrl = SERVERURL.PATH_SAVE_READMISSION_TEMP_DATA;
	    			}
	    			me.readdmmisonRequestJsonData.admissionId = admissionId;
	    			me.readdmmisonRequestJsonData.studentId = studentId;
	    			submitData = Ext.encode(me.readdmmisonRequestJsonData);
	    			
	    			Ext.Ajax.request({
	    				type: 'rest',
	    				url: submitUrl,
	    				jsonData: submitData,
	    				method: 'POST',
	    				success: function (response, action) {
	    					me.hideWindowMask();
	    					readdmissionForm.close();
	    				},
	    				failure: function (response) {
	    					me.hideWindowMask();
	    				}
	    			});
	    		},

	    		createJsonEditSubmmisionDraft:function(uploadImageReaddmissionFormData,responseReaddmissionData){
	    			var me = this,
	    			tab = this.getContentPanelActiveTab(),
	    			reasonArray=[],
	    			reasonView,
	    			fileArry=[],
	    			imageArray=[],
	    			fileFielddata,
	    			reasonData = responseReaddmissionData.wsReadmissionReasonDocModel;
	    			var readdmissionForm = me.getReAddmissionServiceRequestWin();
	    			if(reasonData){
	    				for(var count =0; count<reasonData.length;count++){
	    					var imageCount=0;
	    					reasonView=Ext.getCmp('reasonComponent_'+reasonData[count].id);
	    					fileArry=reasonView?reasonView.query('filefield'):[];
	    					var imageArray=[];
	    					fileArry.forEach(function(){
	    						if(reasonData[count].child[imageCount]){
	    						imageArray.push({
	    							"readmissionReasonChild":
	    							{
	    								"id":reasonData[count].child[imageCount].childId


	    							},
	    							"readmissionReasondoc":reasonData[count].child[imageCount].path
	    						});
	    						}

	    						imageCount++;
	    					})
	    					reasonArray.push({
	    						"readmissionReason":
	    						{
	    							"id":reasonData[count].id
	    						},
	    						"readmissionReasontext":reasonView ? reasonView.up().down('textareafield').getValue():'',
	    						"readmissionRequestChildDetail":imageArray
	    					})
	    				}
	    			}
	    			me.EditDocumentFormDataNew.planningToChangeProgram=uploadImageReaddmissionFormData.planningToChangeProgram=='on'?true:false;
	    			me.EditDocumentFormDataNew.programChangeMotivationDoc=responseReaddmissionData.programmeChangeMotivation?responseReaddmissionData.programmeChangeMotivation.path:me.EditDocumentFormDataNew.programChangeMotivationDoc;
	    			me.EditDocumentFormDataNew.intendedALOfStudy={
	    				"id":uploadImageReaddmissionFormData.intendedStudy
	    			};
	    			me.EditDocumentFormDataNew.intendedProgramOfStudy=
	    			{
	    				"id":uploadImageReaddmissionFormData.intendedProgram
	    			};
	    			me.EditDocumentFormDataNew.unRegAchievementReason=uploadImageReaddmissionFormData.registeredStudentRemark;
	    			me.EditDocumentFormDataNew.unRegAchievementDoc=responseReaddmissionData.section1?responseReaddmissionData.section1.path:me.EditDocumentFormDataNew.unRegAchievementDoc;
	    			me.EditDocumentFormDataNew.assistanceReason=uploadImageReaddmissionFormData.measuresWhatAssistanceRemark;
	    			me.EditDocumentFormDataNew.assistanceDoc=responseReaddmissionData.section2?responseReaddmissionData.section2.path:me.EditDocumentFormDataNew.assistanceDoc,
	    			me.EditDocumentFormDataNew.futureSucceedReason=uploadImageReaddmissionFormData.succeedYourStudiesRemark;
	    			me.EditDocumentFormDataNew.futureSucceedDoc=responseReaddmissionData.section3?responseReaddmissionData.section3.path:me.EditDocumentFormDataNew.futureSucceedDoc;
	    			me.EditDocumentFormDataNew.proofOfPaymentDoc=responseReaddmissionData.proofPayment?responseReaddmissionData.proofPayment.path:me.EditDocumentFormDataNew.proofOfPaymentDoc    
	    			me.EditDocumentFormDataNew.termsAndConditions=uploadImageReaddmissionFormData.termsAndConditions=='on'?true:false
	    			var tempArray =[];
	    			reasonArray.forEach(function(rec){
	    			    var isExist=false;
	    			    me.EditDocumentFormDataNew.readmissionRequestParentDetail.forEach(function(cmp){
	    					   
	    			    	if(!isNullOrEmpty(cmp.readmissionReason) && cmp.readmissionReason.id==rec.readmissionReason.id){
	    			    		rec.readmissionRequestChildDetail.forEach(function(childData){
	    			    			var isChildExist =false;
	    			    			if(cmp.readmissionRequestChildDetail){
	    			    			cmp.readmissionRequestChildDetail.forEach(function(oldRec){
	    			    				if(oldRec.readmissionReasonChild.id == childData.readmissionReasonChild.id){
	    			    					oldRec.readmissionReasondoc=childData.readmissionReasondoc;
	    			    					isChildExist =true;
	    			    				}
	    			    			})
	    			    			}
	    			    			if(!isChildExist){
	    			    				cmp.readmissionRequestChildDetail.push(childData);
	    			    			}
	    			    		})
	    			    		   cmp.readmissionReasontext=cmp.readmissionReasontext;
	    					       isExist=true
	    					   }  
	    				})
	    			    if(!isExist){
	    			        tempArray.push(rec)
	    			    }
	    			});
	    			if(tempArray && tempArray.length){
	    				me.EditDocumentFormDataNew.readmissionRequestParentDetail= me.EditDocumentFormDataNew.readmissionRequestParentDetail.concat(tempArray);
	    			}
	    			var newar =[];
	    			var newReasonArray = [];
	    			me.EditDocumentFormDataNew.readmissionRequestParentDetail.forEach(function(reasonRec){
	    				if(reasonRec.readmissionReason || reasonRec.readmissionReasontext){
	    					newReasonArray.push(reasonRec);
	    				}
	    			});
	    			me.EditDocumentFormDataNew.readmissionRequestParentDetail=newReasonArray;
	    			readdmissionForm.query('selectReasonReAddmissionForm').forEach(function(temp){
	    			    var isExistS=false;
	    			    me.EditDocumentFormDataNew.readmissionRequestParentDetail.forEach(function(newData){
	    			        if(!isNullOrEmpty(newData.readmissionReason) && newData.readmissionReason.id == temp.down('#serviceReason').getValue()){
	    			            newData.readmissionReasontext=temp.down('#motivationReason').getValue();
	    			            isExistS=true
	    			        }
	    			    })
	    			    if(!isExistS){
	    			        newar.push({
	    			            	readmissionReason:{
	    			            		id:temp.down('#serviceReason').getValue(),
	    			            	},
	    			                readmissionReasontext:temp.down('#motivationReason').getValue(),
	    			                readmissionRequestChildDetail:[]

	    			            }
	    			        )
	    			    }
	    			})
	    			if(newar && newar.length){
	    				me.EditDocumentFormDataNew.readmissionRequestParentDetail= me.EditDocumentFormDataNew.readmissionRequestParentDetail.concat(newar);
	    			}
	    			var temp=[];
	    			readdmissionForm.query('#serviceReason').forEach(function(rec){
	    			    temp.push(rec.getValue())
	    			})
	    			var removeRec=[]
	    			for(var count =0;count<me.EditDocumentFormDataNew.readmissionRequestParentDetail.length;count++){
	    				if(!isNullOrEmpty(me.EditDocumentFormDataNew.readmissionRequestParentDetail[count].readmissionReason) && temp.indexOf(me.EditDocumentFormDataNew.readmissionRequestParentDetail[count].readmissionReason.id) == -1){
	    					removeRec.push(count);
	    				}
	    			}
	    	         for(var count=0;count<removeRec.length;count++){
	    	        	 me.EditDocumentFormDataNew.readmissionRequestParentDetail.splice(removeRec[count]-count,1);
	    	         }
	    			
	    			var  submitData = Ext.encode(me.EditDocumentFormDataNew);
	    			if(me.getReAddmissionServiceRequestWin().savedDraftedId){
	    				me.EditDocumentFormDataNew.id = me.getReAddmissionServiceRequestWin().savedDraftedId;
	    				me.EditDocumentFormDataNew.studentId = me.getContentPanelActiveTab().requesterId;
	    				submitDrftData = Ext.encode(me.EditDocumentFormDataNew);
	    				Ext.Ajax.request({
	    					type: 'rest',
	    					url: SERVERURL.PATH_UPDATE_READMISSION_TEMP_DATA,
	    					jsonData: submitDrftData,
	    					method: 'POST',
	    					async: false,
	    					success: function (response, action) {
	    						me.hideWindowMask();
	    						readdmissionForm.close();
	    					},
	    					failure: function (response) {
	    						me.hideWindowMask();
	    					}
	    				});
	    			}
	    		},


	    		createJsonFinalSubmmisionDraft:function(uploadImageReaddmissionFormData,responseReaddmissionData){
	    			var me = this,
	    			reasonArray=[],
	    			reasonView,
	    			fileArry=[],
	    			imageArray=[],
	    			fileFielddata,
	    			reasonData = responseReaddmissionData.wsReadmissionReasonDocModel;
	    			var readdmissionForm = me.getReAddmissionServiceRequestWin();
	    			for(var count =0; count<reasonData.length;count++){
	    				var imageCount=0;
	    				reasonView=Ext.getCmp('reasonComponent_'+reasonData[count].id);
	    				if(reasonView){
	    				fileArry=reasonView.query('filefield');
	    				var imageArray=[];
	    				fileArry.forEach(function(){
	    					if(reasonData[count].child[imageCount]){
	    					imageArray.push({
	    			            "readmissionReasonChild":
	    			            {
	    			                "id":reasonData[count].child[imageCount].childId


	    			            },
	    			            "readmissionReasondoc":reasonData[count].child[imageCount].path
	    			        });
	    					
	    					}
	    					imageCount++;
	    				})
	    				reasonArray.push({
	    					"readmissionReason":{
	    						"id":reasonData[count].id
	    					},
	    					"readmissionReasontext":reasonView.up().down('textareafield').getValue(),
	    					"readmissionRequestChildDetail":imageArray
	    				});
	    			}
	    			}
	    			
	    			me.readdmmisonRequestJsonData ={
	    				    "planningToChangeProgram":uploadImageReaddmissionFormData.planningToChangeProgram=='on'?true:false,
	    				    "programChangeMotivationDoc":responseReaddmissionData.programmeChangeMotivation?responseReaddmissionData.programmeChangeMotivation.path:'',
	    				    "intendedALOfStudy":isNullOrEmpty(uploadImageReaddmissionFormData.intendedStudy)?null:
	    				    {
	    				        "id":uploadImageReaddmissionFormData.intendedStudy
	    				    },
	    				    "intendedProgramOfStudy":isNullOrEmpty(uploadImageReaddmissionFormData.intendedProgram)?null:
	    				    {
	    				        "id":uploadImageReaddmissionFormData.intendedProgram
	    				    },
	    				    "unRegAchievementReason":uploadImageReaddmissionFormData.registeredStudentRemark,
	    				    "unRegAchievementDoc":responseReaddmissionData.section1?responseReaddmissionData.section1.path:'',
	    				    "assistanceReason":uploadImageReaddmissionFormData.measuresWhatAssistanceRemark,
	    				    "assistanceDoc":responseReaddmissionData.section2?responseReaddmissionData.section2.path:'',
	    				    "futureSucceedReason":uploadImageReaddmissionFormData.succeedYourStudiesRemark,
	    				    "futureSucceedDoc":responseReaddmissionData.section3?responseReaddmissionData.section3.path:'',
	    				    "proofOfPaymentDoc":responseReaddmissionData.proofPayment?responseReaddmissionData.proofPayment.path:'',  
	    				    "termsAndConditions":uploadImageReaddmissionFormData.termsAndConditions=='on'?true:false,
	    				    "readmissionRequestParentDetail":reasonArray
	    				}
	    	var newar =[];
	    			
	    			readdmissionForm.query('selectReasonReAddmissionForm').forEach(function(temp){
	    			    var isExistS=false;
	    			    me.readdmmisonRequestJsonData.readmissionRequestParentDetail.forEach(function(newData){
	    			        if(newData.readmissionReason.id == temp.down('#serviceReason').getValue()){
	    			            newData.readmissionReasontext=temp.down('#motivationReason').getValue();
	    			            isExistS=true
	    			        }
	    			    })
	    			    if(!isExistS){
	    			        newar.push({
	    			            	readmissionReason:{
	    			            		id:temp.down('#serviceReason').getValue(),
	    			            	},
	    			                readmissionReasontext:temp.down('#motivationReason').getValue(),
	    			                readmissionRequestChildDetail:[]

	    			            }
	    			        )
	    			    }
	    			});
	    			me.readdmmisonRequestJsonData.isDrafted = false;
	    			if(readdmissionForm.down('form').isValid() && readdmissionForm.down('#termsAndConditions').checked){
	    				me.readdmmisonRequestJsonData.isDrafted = true;
	    			}
	    			if(newar && newar.length){
	    				me.readdmmisonRequestJsonData.readmissionRequestParentDetail= me.readdmmisonRequestJsonData.readmissionRequestParentDetail.concat(newar);
	    			}
	    			
	    		},

	    		createJsonDataFromDraftData:function(formData){
	    			var me =this,mainReason=[],childFileUpload=[];
	    			formData.readmissionRequestParentDetail.forEach(function(rec){
	    			    rec.readmissionRequestChildDetail.forEach(function(childData){
	    			    	childFileUpload.push({
	    			            readmissionReasonChild:{
	    			                id:childData.readmissionReasonChild.id
	    			            },
	    			            readmissionReasondoc:childData.readmissionReasondoc
	    			        })
	    			    })
	    			   mainReason.push({
	    			       "readmissionReason":
	    			        {
	    			            "id":rec.readmissionReason.id
	    			        },
	    			        "readmissionReasontext":rec.readmissionReasontext,
	    			        readmissionRequestChildDetail:childFileUpload
	    			   })  
	    			});
	    			me.EditDocumentFormDataNew={
	    					id:formData.id,
	    				    planningToChangeProgram:formData.planningToChangeProgram,
	    				    programChangeMotivationDoc:formData.programChangeMotivationDoc,
	    				    intendedALOfStudy:{
	    				        id:formData.intendedALOfStudy.id

	    				    },
	    				    intendedProgramOfStudy:{
	    				    	id:formData.intendedProgramOfStudy.id
	    				    },
	    				    unRegAchievementDoc:formData.unRegAchievementDoc,
	    				    unRegAchievementReason:formData.unRegAchievementReason,
	    				    assistanceReason:formData.assistanceReason,
	    				    assistanceDoc:formData.assistanceDoc,
	    				    futureSucceedReason:formData.futureSucceedReason,
	    				    futureSucceedDoc:formData.futureSucceedDoc,
	    				    proofOfPaymentDoc:formData.proofOfPaymentDoc,
	    				    termsAndConditions:formData.termsAndConditions,
	    				    readmissionRequestParentDetail:mainReason
	    				    
	    				};
	    		}
});