/**
 * @author ravi.patidar
 */
Ext.define('Academia.controller.servicerequest.infirmarymanage.InfirmaryManageController', {
	extend: 'Academia.controller.base.BaseController',
	
	models: ['servicerequest.infirmary.InfirmaryAddEntryModel'],
	
	stores: ['user.UserAcademyLocationStore',
	         'servicerequest.infirmary.InfirmaryMedicineDetailStore',
	         'user.UsersByRoleStore',
	         'user.UsersByDepartmentANdAlStore',
	         'department.DepartmentAcademyLocationWiseStore',
	         'feeandpayment.ProgramSmartSearchStore',
	         'enquiry.AcademicBatchStore',
	         'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'
	         ,'program.programbatchdetail.BatchStore',
	         'attendance.SectionAndFacultyByPeriodID',
	         'program.StudentsByAcademyLocationIdStore',
	         'userGroup.UserTypeStore',
	         'examinationcenters.evaluationgrouplisting.applicationdetail.EvaluationGroupStore',
	         'servicerequest.infirmary.InfirmaryAddEntryStore',
	         'personinfo.student.ParentInfoByPersonStore',
	         'servicerequest.infirmary.MedicineDetailCombo',
	         
	         'program.programbatchdetail.BatchByProgramIdSSStore',
	         'program.programbatchdetail.PeriodByBatchIdSSStore',
	         'program.programbatchdetail.SectionByPeriodIDSmartSearch',
	         'common.ActiveUserStore',
	         'common.InfirmaryReasonStore',
	         'common.InfirmaryOutcomeStore',
	         'servicerequest.infirmary.InfirmaryDetailDocumentStore',
	         'servicerequest.infirmary.InfirmaryDetailDocumentStoreOnPopup',
	         'common.InfirmaryInformedStore'
	         ],
	
	views: [
		'servicerequest.infirmary.ManageEntries',
		'servicerequest.infirmary.InfirmaryManageEntryForm',
		'servicerequest.infirmary.InfirmaryManageEntriesStructure',
		'servicerequest.infirmary.InfirmaryEditForm',
		'servicerequest.infirmary.InfirmaryMedicineHistoryDetailsWindow',
		'servicerequest.infirmary.InfirmaryMedicineHistoryDetailsGrid',
		'servicerequest.infirmary.InfirmaryWhetherInformedWindow',
		'servicerequest.infirmary.InfirmaryAddEntryGrid',
		'servicerequest.infirmary.InfirmaryWhetherInformedAuthorityWindow',
		'servicerequest.infirmary.InfirmaryDetailDocumentGrid',
		'servicerequest.infirmary.InfirmaryDetailDocumentWin',
		'servicerequest.infirmary.InfirmaryDetailDocumentGridOnPopup',
		'servicerequest.infirmary.ManageEntriesForStudentProfile',
		'servicerequest.infirmary.ManageEntriesStudentProfileTabStructure',
		'servicerequest.infirmary.ManageEntriesStudentProfileFilter'
	],
	
    refs: [{
    	ref : 'contentPanel',
    	selector : 'contentpanel' 
    },{
    	ref: 'infirmarymanageentriesstructure',
    	selector: 'infirmarymanageentriesstructure'
    },{
    	ref: 'manageentries',
    	selector:'manageentries'
    },{
    	ref: 'infirmarySearchresultgrid',
    	selector:'searchresultgrid[itemId=infirmarymanageentriesgrid]'
    },{
    	ref: 'infirmarymanageentryform',
    	selector:'infirmarymanageentryform'
    },{
    	ref: 'infirmarymanageentryform',
    	selector: 'infirmarymanageentryform customcombobox[itemId=user_type_infirmarycombo]'
    },{
    	ref: 'infirmarymanageentryform',
    	selector: 'infirmarymanageentryform button#resetBtn'
    },{    	
    	ref: 'infirmarymedicinehistorydetailswindow',
    	selector: 'infirmarymedicinehistorydetailswindow'
    },{    	
    	ref: 'infirmarymedicinehistorydetailsgrid',
    	selector: 'infirmarymedicinehistorydetailsgrid'
    },{    	
    	ref: 'infirmaryeditform',
    	selector: 'infirmaryeditform'
    },{    	
    	ref: 'infirmarywhetherinformedwindow',
    	selector: 'infirmarywhetherinformedwindow'
    },{
    	ref: 'infirmaryeditform',
    	selector: 'infirmaryeditform button#resetBtnForm'
    },{
    	ref: 'infirmaryeditform',
    	selector: 'infirmaryeditform button#submitBtn'
    },{
    	ref:'infirmaryaddentrygrid',
    	selector: 'infirmaryaddentrygrid'
    },{
    	ref:'infirmaryeditform',
    	selector:'infirmaryeditform customcombobox[itemId=departmentId]'
    },{
    	ref:'infirmarywhetherinformedauthoritywindow',
    	selector:'infirmarywhetherinformedauthoritywindow'
    }, {
    	ref: 'infirmarydetaildocumentgrid',
    	selector: 'infirmarydetaildocumentgrid'
    }, {
    	ref: 'infirmarydetaildocumentwin',
    	selector: 'infirmarydetaildocumentwin'
    }, {
    	ref: 'infirmarydetaildocumentgridonpopup',
    	selector: 'infirmarydetaildocumentgridonpopup[itemId=infirmarydetaildocumentgridonpopupItemId]'
    }, {
    	ref: 'studentInfirmaryManageEntriesGrid',
    	selector:'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid]'
    },{    	
    	ref: 'studentInfirmaryEditForm',
    	selector: 'infirmaryeditform[itemId=studentInfirmaryEditForm]'
    }, {
    	ref: 'studentInfirmaryDetailDocumentGrid',
    	selector: 'infirmarydetaildocumentgrid[itemId=studentInfirmaryDetailDocumentGrid]'
    }, {
    	ref: 'manageentriesstudentprofilefilter',
    	selector: 'manageentriesstudentprofilefilter'
    },{
    	ref: 'studentInfirmaryManageInterventionGrid',
    	selector:'searchresultgrid[itemId=studentInfirmarymanageinterventiongrid]'
    }],
    config: {
    	INFIRMARY_MANAGE_ENTRIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('INFIRMARY_MANAGE_ENTRIES_PRIVILEGES'),
    	STUDENT_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_INFIRMARY_MANAGE_ENTRIES_PRIVILEGES'),
    	STUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_PRIVILEGES'),
    	STUDENT_PROFILE_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PROFILE_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES'),
    	STUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES'),
    	FACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_PRIVILEGES'),
		FACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES'),
		PARENT_INFIRMARY_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_INFIRMARY_DETAILS_PRIVILEGES'),
		FACULTY_PORTAL_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_PRIVILEGES'),
		FACULTY_PORTAL_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_DOWNLOAD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES'),
		STUDENT_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_PRIVILEGES'),
		PARENT_INFIRMARY_INTERVENTION_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_INFIRMARY_INTERVENTION_DETAILS_PRIVILEGES')
    },
    init: function(application) {
    	this.control({
    		'infirmarymanageentryform': {
    			render: function(infirmaryForm){
    				
    				var academyLocationId = this.getCurrentAcademyLocation();
    				
    				var academyLocation_infirmarycombo = infirmaryForm.down('#academy_loc_infirmarycombo');
    				var academyLocationStore = academyLocation_infirmarycombo.getStore();
    				academyLocationStore.getProxy().extraParams = {
    		    		id: this.getCurrentlyLoggedInUser().id
    		    	};
    				
    				academyLocationStore.load({
						 callback: function(records, operation, success) {
							 academyLocation_infirmarycombo.setValue(academyLocationId);
		      		   }	   
				    });
    				
    				
    				this.initInfirmarySearchForm(academyLocationId);
    			},
    		afterrender: function(infirmaryForm) {
    			
    			var userGroup_infirmarycombo = infirmaryForm.down('#user_type_infirmarycombo');
				userGroup_infirmarycombo.setValue(3);
    		}	
    		},
    		'searchresultgrid[itemId=infirmarymanageentriesgrid]': {
    			render: function(grid){
    				grid.addButtonToolbar();
    				var searchForm = this.getInfirmarymanageentryform();
    		        var jsonFormatFormData = this.createJsonFormat(searchForm);
    		        var resultGrid = this.getInfirmarySearchresultgrid();
    		        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    		        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_DETAIL_VIEWCODE);
    		        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    		        
    				this.genericCBGridAccessControlValidation(grid, this.getINFIRMARY_MANAGE_ENTRIES_PERMISSIONS());
    			},
    			afterrender : function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getINFIRMARY_MANAGE_ENTRIES_PERMISSIONS());
    			},
    			cellclick: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts){
    				this.cellClickInformaryDetailsResultGrid(view, td, cellIndex, record, tr, rowIndex, e, eOpts,'FROM_TOOLS');
    			}
    		},
    		
    		'searchresultgrid[itemId=infirmarymanageentriesgrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
 	            click: function() {
 	                this.exportInfirmaryEntryList(SERVERURL.PDFEXPORT,'pdf',false);
 	            }
 	        },
 	        'searchresultgrid[itemId=infirmarymanageentriesgrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
 	            click: function() {
 	                this.exportInfirmaryEntryList(SERVERURL.PDFEXPORT,'pdf',true);
 	            }
 	        },
 	        'searchresultgrid[itemId=infirmarymanageentriesgrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
 	            click: function() {
 	                this.exportInfirmaryEntryList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
 	            }
 	        },
 	        'searchresultgrid[itemId=infirmarymanageentriesgrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
 	            click: function() {
 	                this.exportInfirmaryEntryList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
 	            }
 	        },
    		
    		'infirmarymanageentryform button[itemId=manage_infirmary_search]': {
    			click: function(obj){
    				var searchForm = this.getInfirmarymanageentryform();
    		        var jsonFormatFormData = this.createJsonFormat(searchForm);
    		        var resultGrid = this.getInfirmarySearchresultgrid();
    		        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    		        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_DETAIL_VIEWCODE);
    		        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    			}
    		},
    		
    		'infirmarymanageentryform customcombobox[itemId=user_type_infirmarycombo]':{
    			change: function(combo,newValue, oldValue, eOpts){
    				if(!isNullOrEmpty(newValue)){
    					var infirmaryForm = this.getInfirmarymanageentryform();
        				var department_name_infirmarycombo = infirmaryForm.down('#department_name_infirmarycombo');
        				var studentUserName = infirmaryForm.down('#user_studentname_infirmarycombo');
        				var employeeUserName = infirmaryForm.down('#user_employeename_infirmarycombo');
        				
        				var academyLocationId = infirmaryForm.down('#academy_loc_infirmarycombo').getValue();
        				var programCombo = infirmaryForm.down('#program_infirmarycombo');
        				
        				if(combo.rawValue.toUpperCase() == 'STUDENT' || combo.rawValue.toUpperCase() == 'ADMIN'){
        					if(combo.rawValue.toUpperCase() == 'ADMIN'){
    							var userTypeId = infirmaryForm.down('#user_type_infirmarycombo').getValue();
    		    				var userName = infirmaryForm.down('#user_employeename_infirmarycombo');

    		    				userName.reset();
    		    				userName.setDisabled(false);
    		    				studentUserName.setVisible(false);

        						employeeUserName.reset();
        						employeeUserName.setVisible(true);
    		    				userName.reset();
    		    				userName.setDisabled(false);
    		    				department_name_infirmarycombo.setVisible(false);

    		    				userNameStore = userName.getStore();
    		    				userNameStore.getProxy().extraParams = {
    		    					academyLocationId: academyLocationId,
    		    					userTypeId:userTypeId
    		    				}
    		    				userNameStore.load(); 
    		    				
    		    				programCombo.setDisabled(true);
        						batchCombo.setDisabled(true);
        						periodCombo.setDisabled(true);
        						sectionCombo.setDisabled(true);
        						/*whetherAuthorityInformedCheckBox.setDisabled(true);
    	        				authorityUserCombo.setDisabled(true);*/
        						whetherParentInformedCheckBox.setDisabled(true);
        						studentUserName.allowBlank = true;
        						parentUserCombo.allowBlank = true;
    							
    						}else{
        					studentUserName.reset();
        					studentUserName.setVisible(true);
        					studentUserName.setDisabled(false);
        					
        					if(academyLocationId == null) {
        						academyLocationId = this.getCurrentAcademyLocation();
        					}
        					
        					var usersStore = studentUserName.getStore();
        					usersStore.getProxy().extraParams = {
            					academyLocationId: academyLocationId
            				};
            				usersStore.load();
        					
        					department_name_infirmarycombo.setVisible(false);
        					employeeUserName.setVisible(false);
        					
        					programCombo.setDisabled(false);
        				}
        					
        				} else {
        					studentUserName.setVisible(false);
        					
        					department_name_infirmarycombo.reset();
        					department_name_infirmarycombo.setVisible(true);
        					
        					this.resetAndDisabledByField('ACADEMYLOCATION');
        					programCombo.reset();
        					programCombo.setDisabled(true);
        					
        					employeeUserName.reset();
        					employeeUserName.setVisible(true);
        					
        					var usersStore = employeeUserName.getStore();
        					usersStore.getProxy().extraParams = {
            					academyLocationId: academyLocationId
            				};
            				usersStore.load();
            				var departmentStore = department_name_infirmarycombo.getStore();
            				departmentStore.getProxy().extraParams = {
            					academyLocationsIds: academyLocationId
            				};
            				departmentStore.load();
        				}
    				}
    			}
    		},
    		
			 'infirmarymanageentryform customcombobox[itemId=academy_loc_infirmarycombo]': {
	    			select: function(combo,newValue, oldValue, eOpts){
	    				
	    				var infirmaryForm = this.getInfirmarymanageentryform();
	    				
	    				this.resetAndDisabledByField('ACADEMYLOCATION');
	    				var academyLocationId = newValue[0].data.id;
	    				this.initInfirmarySearchForm(academyLocationId);
	    				
	    				var program_infirmarycombo = infirmaryForm.down('#program_infirmarycombo');
	    				program_infirmarycombo.setDisabled(false);
	    			}
			 },
			 
			 'infirmarymanageentryform customcombobox[itemId=program_infirmarycombo]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
	    				var infirmaryForm = this.getInfirmarymanageentryform();
	    				
	    				var programId = newValue[0].data.id;
	    				var batchNameCombo = infirmaryForm.down('#batch_infirmarycombo');
	    				
	    				this.resetAndDisabledByField('PROGRAM');
	    				batchNameCombo.setDisabled(false);
	    				
	    				var batchNameStore = batchNameCombo.getStore();
	    				batchNameStore.getProxy().extraParams = {
	    					programId: programId
	    				};
	    				batchNameStore.load();
	    				
	    			}
			 },
			 'infirmarymanageentryform customcombobox[itemId=batch_infirmarycombo]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
	    				var infirmaryForm = this.getInfirmarymanageentryform();
	    				
	    				var batchId = newValue[0].data.id;
	    				var periodNameCombo = infirmaryForm.down('#period_infirmarycombo');
	    				
	    				this.resetAndDisabledByField('BATCH');
	    				periodNameCombo.setDisabled(false);
	    				var periodNameStore = periodNameCombo.getStore();
	    				periodNameStore.getProxy().extraParams = {
	    					id: batchId
	    				};
	    				periodNameStore.load();
	    			}
			 },
			 'infirmarymanageentryform customcombobox[itemId=period_infirmarycombo]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
	    				var infirmaryForm = this.getInfirmarymanageentryform();
	    				
	    				var periodId = newValue[0].data.id;
	    				var sectionNameCombo = infirmaryForm.down('#section_infirmarycombo');
	    				sectionNameCombo.setDisabled(false);
	    				
	    				var sectionNameStore = sectionNameCombo.getStore();
	    				sectionNameStore.getProxy().extraParams = {
	    					periodId: periodId
	    				};
	    				sectionNameStore.load();
	    			}
			 },
    		'infirmarymanageentryform button#resetBtn':{
    			click: function(btn){
					
					var infirmaryFrm = this.getInfirmarymanageentryform();
    				
    				var infirmaryForm = this.getInfirmarymanageentryform().getForm();
    				var fromDate = infirmaryForm.findField('from_date_inmry');
    				var toDate = infirmaryForm.findField('to_date_inmry');
    				
    				infirmaryForm.reset();
    				toDate.setMinValue(fromDate.getValue());
    				fromDate.setMaxValue(toDate.getValue());
    				toDate.setValue(new Date());
    				fromDate.setValue(new Date(new Date().setDate(new Date().getDate() - 30)));
    				this.resetAndDisabledByField('ALL');
    				
    				var academyLocationId = this.getCurrentAcademyLocation();
    				
    				var academyLocation_infirmarycombo = infirmaryFrm.down('#academy_loc_infirmarycombo');
    				var academyLocationStore = academyLocation_infirmarycombo.getStore();
    				academyLocationStore.getProxy().extraParams = {
    		    		id: this.getCurrentlyLoggedInUser().id
    		    	};
    				
    				academyLocationStore.load({
						 callback: function(records, operation, success) {
							 academyLocation_infirmarycombo.setValue(academyLocationId);
		      		   }	   
				    });
    				
    				
    				this.initInfirmarySearchForm(academyLocationId);
    			}
    		},
    		
    		'infirmarymanageentryform customcombobox[itemId=department_name_infirmarycombo]': {
    			change: function(combo,newValue, oldValue, eOpts){
					 var infirmaryForm = this.getInfirmarymanageentryform();
					 
					 var userTypeId = infirmaryForm.down('#user_type_infirmarycombo').getValue();
					 
					 var academyLocationsIds = this.getCurrentAcademyLocation();
					 var userName = infirmaryForm.down('#user_employeename_infirmarycombo');
					 
					 userName.reset();
					 userName.setDisabled(false);
					 
					 userNameStore = userName.getStore();
					 userNameStore.getProxy().extraParams = {
						 departmentId:newValue,
						 academyLocationId:this.getCurrentAcademyLocation(),
						 userTypeId:userTypeId
					 }
					 userNameStore.load();                    
				 }
			 },
			 
			 'searchresultgrid[itemId=infirmarymanageentriesgrid] button[itemId=searchResultGridBtnAdd]': {
	    			click: function(btn){
	    				this.addInfirmaryEntry('add');
	    			}
	    		},
	    		'searchresultgrid[itemId=infirmarymanageentriesgrid] button[itemId=searchResultGridBtnEdit]': {
	    			click: function(btn){
	    				this.addInfirmaryEntry('edit');
	    			}
	    		},
	    		'searchresultgrid[itemId=infirmarymanageentriesgrid] button[itemId=searchResultGridBtnView]': {
	    			click: function(btn){
	    				this.addInfirmaryEntry('view');
	    			}
	    		},
	    		'searchresultgrid[itemId=infirmarymanageentriesgrid] button[itemId=searchResultGridBtnDelete]': {
	    			click: function(btn){
	    				this.deleteInfirmaryEnrtriesData();
	    			}
	    		},
    		
    		/*
    		 * @ravi.patidar
    		 */
    		
    		'infirmaryeditform customcombobox[itemId=programId]': {
    			select: function(combo,newValue, oldValue, eOpts){

    				var getActiveTab = this.getActiveTabfromContentPanel();
		        	var infirmaryeditform = getActiveTab.down('infirmaryeditform');

    				var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
            		
    				var programId = newValue[0].data.id;
    				var batchNameCombo = infirmaryeditform.down('#batchId');

    				this.resetAndDisabledByFieldInfirmaryEdit('PROGRAM');
    				batchNameCombo.setDisabled(false);
    				batchNameCombo.allowBlank = false;
    				batchNameCombo.labelSeparator = '';
    				batchNameCombo.setFieldLabel(getCommonTranslation('BATCH')+allowblankFalse);
    				
    				var batchNameStore = batchNameCombo.getStore();
    				batchNameStore.getProxy().extraParams = {
    					programId: programId
    				};
    				batchNameStore.load();
    				
    				var periodNameCombo = infirmaryeditform.down('#periodId');
    				periodNameCombo.allowBlank = false;
    				periodNameCombo.labelSeparator = '';
    				periodNameCombo.setFieldLabel(getCommonTranslation('PERIOD')+allowblankFalse);
    			}
    		},
    		'infirmaryeditform customcombobox[itemId=batchId]': {
    			select: function(combo,newValue, oldValue, eOpts){

    				var getActiveTab = this.getActiveTabfromContentPanel();
		        	var infirmaryeditform = getActiveTab.down('infirmaryeditform');
		        	
    				var batchId = newValue[0].data.id;
    				var periodNameCombo = infirmaryeditform.down('#periodId');

    				this.resetAndDisabledByFieldInfirmaryEdit('BATCH');
    				periodNameCombo.setDisabled(false);
    				var periodNameStore = periodNameCombo.getStore();
    				periodNameStore.getProxy().extraParams = {
    					id: batchId
    				};
    				periodNameStore.load();
    			}
    		},
    		'infirmaryeditform customcombobox[itemId=periodId]': {
    			select: function(combo,newValue, oldValue, eOpts){

    				var getActiveTab = this.getActiveTabfromContentPanel();
		        	var infirmaryeditform = getActiveTab.down('infirmaryeditform');

    				var periodId = newValue[0].data.id;
    				var sectionNameCombo = infirmaryeditform.down('#sectionId');
    				sectionNameCombo.setDisabled(false);

    				var sectionNameStore = sectionNameCombo.getStore();
    				sectionNameStore.getProxy().extraParams = {
    					periodId: periodId
    				};
    				sectionNameStore.load();
    			}
    		},
    		
    		
    		'infirmaryeditform customcombobox[itemId=academyLocationId]': {
    			select: function(combo,newValue, oldValue, eOpts){

    				var getActiveTab = this.getActiveTabfromContentPanel();
		        	var infirmaryform = getActiveTab.down('infirmaryeditform');

    				this.resetAndDisabledByFieldInfirmaryEdit('ACADEMYLOCATION');
    				var academyLocationId = newValue[0].data.id;
    				this.initInfirmaryEntryForm(academyLocationId);
    				
    				var program_infirmarycombo = infirmaryform.down('#programId');
    				program_infirmarycombo.setDisabled(false);
    			}
    		},
    		'infirmaryeditform customcombobox[itemId=userGroupId]':{
    			change: function(combo,newValue, oldValue, eOpts){
    				if(!isNullOrEmpty(newValue)){
    					var getActiveTab = this.getActiveTabfromContentPanel();
    		        	var infirmaryeditform = getActiveTab.down('infirmaryeditform');
	    				var department_name_infirmarycombo = infirmaryeditform.down('#departmentId');
	    				var studentUserName = infirmaryeditform.down('#user_studentname_infirmarycombo');
	    				var employeeUserName = infirmaryeditform.down('#user_employeename_infirmarycombo');
	    				
	    				var programCombo = infirmaryeditform.down('#programId');
	    				var batchCombo = infirmaryeditform.down('#batchId');
	    				var periodCombo = infirmaryeditform.down('#periodId');
	    				var sectionCombo = infirmaryeditform.down('#sectionId');
	    				/*var whetherAuthorityInformedCheckBox = infirmaryeditform.down('#whetherAuthorityInformed');*/
	    				var authorityUserCombo = infirmaryeditform.down('#authorityUserId');
	    				var whetherParentInformedCheckBox = infirmaryeditform.down('#whetherParentInformed');
	    				var parentUserCombo = infirmaryeditform.down('#parentUserId');
	    				
	    				var academyLocationId = infirmaryeditform.down('#academyLocationId').getValue();
	    				infirmaryeditform.down('button#submitBtn').setDisabled(true);
	    				if(combo.rawValue.toUpperCase() == 'STUDENT' || combo.rawValue.toUpperCase() == 'ADMIN'){
	    					if(combo.rawValue.toUpperCase() == 'ADMIN'){
    							var userTypeId = infirmaryeditform.down('#userGroupId').getValue();
    		    				var userName = infirmaryeditform.down('#user_employeename_infirmarycombo');

    		    				userName.reset();
    		    				userName.setDisabled(false);
    		    				studentUserName.setVisible(false);

        						employeeUserName.reset();
        						employeeUserName.setVisible(true);
    		    				department_name_infirmarycombo.setVisible(false);

    		    				userNameStore = userName.getStore();
    		    				userNameStore.getProxy().extraParams = {
    		    					academyLocationId: academyLocationId,
    		    					userTypeId:userTypeId
    		    				}
    		    				userNameStore.load(); 
    		    				
    		    				programCombo.setDisabled(true);
        						batchCombo.setDisabled(true);
        						periodCombo.setDisabled(true);
        						sectionCombo.setDisabled(true);
        						/*whetherAuthorityInformedCheckBox.setDisabled(true);
    	        				authorityUserCombo.setDisabled(true);*/
        						whetherParentInformedCheckBox.setDisabled(true);
        						studentUserName.allowBlank = true;
        						parentUserCombo.allowBlank = true;
        						//studentUserName.setVisible(false)
    							
    						}else{
	    					studentUserName.reset();
	    					studentUserName.setVisible(true);
	    					studentUserName.setDisabled(false);

	    					var usersStore = studentUserName.getStore();
	    					usersStore.getProxy().extraParams = {
	    						academyLocationId: academyLocationId
	    					};
	    					usersStore.load();

	    					department_name_infirmarycombo.setVisible(false);
	    					employeeUserName.setVisible(false);
	    					employeeUserName.allowBlank = true;
	    					studentUserName.allowBlank = false;

	    					programCombo.setDisabled(false);
	    					whetherParentInformedCheckBox.setDisabled(false);
	    					}	
	    				} else {
	    					studentUserName.setVisible(false);
	    					
	    					department_name_infirmarycombo.reset();
	    					department_name_infirmarycombo.setVisible(true);
	    					
	    					employeeUserName.reset();
	    					employeeUserName.setVisible(true);
	    					
	    					var usersStore = employeeUserName.getStore();
	    					usersStore.getProxy().extraParams = {
	        					academyLocationId: academyLocationId
	        				};
	        				usersStore.load();
	        				
	        				this.resetAndDisabledByFieldInfirmaryEdit('ACADEMYLOCATION');
        					programCombo.reset();
        					programCombo.setDisabled(true);
	        				
	        				var departmentStore = department_name_infirmarycombo.getStore();
	        				departmentStore.getProxy().extraParams = {
	        					academyLocationsIds: academyLocationId
	        				};
	        				departmentStore.load();
	        				
	        				programCombo.setDisabled(true);
	        				batchCombo.setDisabled(true);
	        				periodCombo.setDisabled(true);
	        				sectionCombo.setDisabled(true);
	        				/*whetherAuthorityInformedCheckBox.setDisabled(true);
	        				authorityUserCombo.setDisabled(true);*/
	        				whetherParentInformedCheckBox.setDisabled(true);
	        				studentUserName.allowBlank = true;
	        				parentUserCombo.allowBlank = true;
	        				employeeUserName.allowBlank = false;
	        				authorityUserCombo.allowBlank = true;
	        				parentUserCombo.setDisabled(true);
	    				}
    				}
    			}
    		},
    		
			 'infirmaryeditform customcombobox[itemId=departmentId]': {
				 change: function(combo,newValue, oldValue, eOpts){
					 
					 var getActiveTab = this.getActiveTabfromContentPanel();
 		        	 var infirmaryeditform = getActiveTab.down('infirmaryeditform');
					 
					 var academyLocationId = infirmaryeditform.down('#academyLocationId').getValue();
					 var userTypeId = infirmaryeditform.down('#userGroupId').getValue();
					 //var academyLocationsIds = this.getCurrentAcademyLocation();
					 var userName = infirmaryeditform.down('#user_employeename_infirmarycombo');
					 
					 userName.reset();
					 userName.setDisabled(false);

					 userNameStore = userName.getStore();
					 userNameStore.getProxy().extraParams = {
						 departmentId:newValue,
						 academyLocationId: academyLocationId,
						 userTypeId:userTypeId
					 }
					 userNameStore.load();                    
				 }
			 },
			 
    		
    		
    		'infirmaryeditform customcombobox[itemId=academy_loc_infirmary_edit]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
					    var getActiveTab = this.getActiveTabfromContentPanel();
 		        	    var infirmaryform = getActiveTab.down('infirmaryeditform');
	    				
	    				var academyLocationId = newValue[0].data.id;
	    				
	    				var program_infirmarycombo = infirmaryform.down('#program_infirmary_edit');
	    				var programStore = program_infirmarycombo.getStore();
	    				programStore.getProxy().extraParams = {
	    					academyLocationId: academyLocationId
	    				};
	    				programStore.load();
	    				
	    			}
			 },
			 'infirmaryeditform customcombobox[itemId=user_studentname_infirmarycombo]': {
				    select: function(combo, newValue, oldValue, eOpts) {
				    	var getActiveTab = this.getActiveTabfromContentPanel();
    		        	var infirmaryeditform = getActiveTab.down('infirmaryeditform');
				        var parentUserCombo = infirmaryeditform.down('#parentUserId');
				        var parentUserComboStore = parentUserCombo.getStore();
				        parentUserComboStore.getProxy().extraParams = {
				            personId: newValue[0].get('id')
				        };
				        parentUserComboStore.load();

				        var userCombo = infirmaryeditform.down('#userGroupId');
				        var userType = userCombo.getValue(); 
				        if (!isNullOrEmpty(userType) && userType == 3) { // userType == 3(Student)
				            var studentId = combo.getValue();
				            Ext.Ajax.request({
				                method: "GET",
				                type: 'rest',
				                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
				                headers: {
				                    'Content-Type': 'application/json'
				                },
				                params: {
				                    studentId: studentId
				                },
				                success: function(response, action) {
				                    var data = Ext.decode(response.responseText);
				                    var programCombo = infirmaryeditform.down('#programId');
				                    programCombo.setReadOnly(true);
				                    var programComboStore = programCombo.getStore();
				                    programComboStore.load({
				                        callback: function(records, operation, success) {
				                            if (!isNullOrEmpty(data[0].programId)) {
					                            programCombo.setValue(data[0].programId);
				                                var batchCombo = infirmaryeditform.down('#batchId');
				                                batchCombo.setReadOnly(true);
				                                batchCombo.setDisabled(false);
				                                batchCombo.allowBlank = false;
				                                var batchComboStore = batchCombo.getStore();
				                                batchComboStore.getProxy().extraParams = {
				                                    programId: data[0].programId
				                                };

				                                batchComboStore.load({
				                                    callback: function(records, operation, success) {
				                                        if (!isNullOrEmpty(data[0].batchId)) {
					                                        batchCombo.setValue(data[0].batchId);
				                                            var periodCombo = infirmaryeditform.down('#periodId');
				                                            periodCombo.setReadOnly(true);
				                                            periodCombo.setDisabled(false);
				                                            var periodComboStore = periodCombo.getStore();
				                                            periodComboStore.getProxy().extraParams = {
				                                                id: data[0].batchId
				                                            };

				                                            periodComboStore.load({
				                                                callback: function(records, operation, success) {
				                                                    if (!isNullOrEmpty(data[0].programPeriodId)) {
					                                                    periodCombo.setValue(data[0].programPeriodId);
				                                                        var sectionCombo = infirmaryeditform.down('#sectionId');
				                                                        sectionCombo.setReadOnly(true);
				                                                        sectionCombo.setDisabled(false);
				                                                        var sectionComboStore = sectionCombo.getStore();
				                                                        sectionComboStore.getProxy().extraParams = {
				                                                            periodId: data[0].programPeriodId
				                                                        };
				                                                        sectionComboStore.load({
				                                                            callback: function(records, operation, success) {
				                                                            	if (!isNullOrEmpty(data[0].sectionId)) {
					                                                                sectionCombo.setValue(data[0].sectionId);
				                                                            	}else {
				                                                            		sectionCombo.emptyText = [ '' ];
				                                                            		sectionCombo.applyEmptyText();
				                                                            		sectionCombo.reset();
				                                                            	}
				                                                            }
				                                                        });
				                                                    }
				                                                }
				                                            });
				                                        }
				                                    }
				                                });
				                            }
				                        }
				                    });
				                }
				            });
				        }
				    }
				},
    		'infirmaryeditform customcombobox[itemId=program_infirmary_edit]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
					    var getActiveTab = this.getActiveTabfromContentPanel();
 		        	    var infirmaryForm = getActiveTab.down('infirmaryeditform');
	    				
	    				var programId = newValue[0].data.id;
	    				var batchNameCombo = infirmaryForm.down('#batch_infirmary_edit');
	    				
	    				/*this.resetAndDisabledByField('PROGRAM');
	    				batchNameCombo.setDisabled(false);*/
	    				
	    				var batchNameStore = batchNameCombo.getStore();
	    				batchNameStore.getProxy().extraParams = {
	    					programId: programId
	    				};
	    				batchNameStore.load();
	    				
	    			}
			 },
			 'infirmaryeditform customcombobox[itemId=batch_infirmary_edit]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
					 	var getActiveTab = this.getActiveTabfromContentPanel();
		        	    var infirmaryForm = getActiveTab.down('infirmaryeditform');
	    				
	    				var batchId = newValue[0].data.id;
	    				var periodNameCombo = infirmaryForm.down('#period_infirmary_edit');
	    				
	    				this.resetAndDisabledByField('BATCH');
	    				periodNameCombo.setDisabled(false);
	    				var periodNameStore = periodNameCombo.getStore();
	    				periodNameStore.getProxy().extraParams = {
	    					id: batchId
	    				};
	    				periodNameStore.load();
	    			}
			 },
			 'infirmaryeditform customcombobox[itemId=period_infirmary_edit]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
					    var getActiveTab = this.getActiveTabfromContentPanel();
		        	    var infirmaryForm = getActiveTab.down('infirmaryeditform');
	    				//var infirmaryForm = this.getInfirmaryeditform();
	    				
	    				var periodId = newValue[0].data.id;
	    				var sectionNameCombo = infirmaryForm.down('#section_infirmary_edit');
	    				sectionNameCombo.setDisabled(false);
	    				
	    				var sectionNameStore = sectionNameCombo.getStore();
	    				sectionNameStore.getProxy().extraParams = {
	    					periodId: periodId
	    				};
	    				sectionNameStore.load();
	    			}
			 },
			 'infirmaryeditform button#resetBtnForm':{
				click: function(btn){
					this.resetInfirmaryEditForm(btn);
					this.resetAndDisabledByFieldInfirmaryEdit('ALL');
					this.addNewRowInGrid(1);
				} 
			 },
			 'infirmaryeditform button#submitBtn':{
					click: function(btn){
						this.submitInfirmaryEditForm(btn);
					} 
				 },
			 'infirmaryaddentrygrid': {
    			cellclick: function(row, td, cellIndex, record, tr, rowIndex, e, eOpts){
    				 var $this = this;
    				 var grid = row.up('grid');
                     var columnName = grid.columnManager.columns[cellIndex].dataIndex;
                     if (e.target.tagName == 'DIV') {
                         if (columnName == "addButton") {
                             if (e.target.className == "addButtonClsForGridActionCls") {
                                 if (record.data.addButton) {
                                     var serialNo;
                                     if (grid.getStore() != null)
                                         serialNo = grid.getStore().getCount();
                                     this.addNewRowInGrid(serialNo + 1);
                                 }
                             }
                         } else if (columnName == "deleteButton") {
                             if (e.target.className == "deleteButtonClsForGridActionCls") {
                                 if (record.data.deleteButton) {
                                     if (grid.getStore().getRange().length > 1) {
                                         //grid.getStore().remove(grid.getSelectionModel().getSelection()[0]);
                                         grid.getStore().removeAt(rowIndex);
                                         var models = grid.getStore().getRange();
                                         for (var i = 0; i < models.length; i++) {
                                             models[i].data.serialNo = i + 1;
                                         }
                                         grid.getStore().loadRawData(models, true);
                                     }
                                 }
                             }
                         }
                     }

    			}
    		},
    		'infirmaryeditform button#documentUploadItemId': {
                click: function() {
                    this.getDocumentController().showDocumentFormWindow('infirmaryeditformItemId', 'DOCUMENT');
                }
            },
            'documentformwindow[itemId=infirmaryeditformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
                click: function() {
                    var $this = this;
                    var isTransient = true;
                    var module = 'toolnservice';
                    var entityId;
                    var entityType = 'infirmary';
                    
                    var getActiveTab = $this.getActiveTabfromContentPanel();
            	    var documentGrid=getActiveTab.down('infirmarydetaildocumentgrid');

                    $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient) {
                        var documentModel = new Academia.model.fdmanagement.FDManagementDocumentModel();
                        documentModel.set("documentName", response.name);
                        documentModel.set("path", response.path);
                        documentModel.set("type", response.type);
                        documentModel.set("documentName", response.name);
                        documentModel.set("isNewRecord", true);
                        documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));

                        var store = documentGrid.getStore();
                        store.add(documentModel);
                        documentGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());
                        if (documentGrid.isHidden() && store.data.items.length > 0) {
                            documentGrid.setVisible(true);
                        }
                        Ext.apply(documentGrid, {
                            code: null,
                            setCode: function(code) {
                                documentGrid.code = code;
                            },
                            getCode: function() {
                                return documentGrid.code;
                            }
                        });
                        documentGrid.setCode(documentModel);
                        $this.getDocumentController().closeDocumentFormWindow();
                    }, isTransient);
                }
            },
            'documentformwindow[itemId=infirmaryeditformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId': {
                click: function() {
                    this.getDocumentController().closeDocumentFormWindow();
                }
            },
            'infirmarydetaildocumentgrid button#btnDelete': {
                click: function() {
                    this.deleteDocumentFromGrid('GridOnForm');
                }
            },
            'infirmarydetaildocumentgrid[itemId=infirmarydetaildocumentgridItemId]': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                   var getActiveTab = $this.getActiveTabfromContentPanel();
            	    var documentGrid=getActiveTab.down('infirmarydetaildocumentgrid');
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'infirmarydetaildocumentgridonpopup[itemId=infirmarydetaildocumentgridonpopupItemId]': {
            	afterrender:function(grid){
            		if (portalId == 1){
            		   grid.addCls('infirmaryDocTitleGrid');
            		}
            	},
            	render: function(grid){
            		var formWindow = this.getInfirmarydetaildocumentwin();
                	var openFrom = formWindow.getOpenFrom(openFrom);
                	if(portalId == 3) {
                		this.disableDownloadActionPivileges(grid, this.getSTUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PERMISSIONS());
                	} else if(portalId == 2) {
                		this.disableDownloadActionPivileges(grid, this.getFACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PERMISSIONS());
                	}  else if (portalId == 1 && openFrom == 'FROM_STUDENT') {
                		this.disableDownloadActionPivileges(grid, this.getSTUDENT_PROFILE_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PERMISSIONS());
                	}
    			},
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
            	    var documentGrid = $this.getInfirmarydetaildocumentgridonpopup();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'infirmarydetaildocumentgridonpopup[itemId=infirmarydetaildocumentgridonpopupItemId] button#btnDelete': {
                click: function() {
                    this.deleteDocumentFromGrid('GridOnPopup');
                }
            },
            'infirmarydetaildocumentgridonpopup[itemId=infirmarydetaildocumentgridonpopupItemId] button[itemId=downloadDocumentItemId]': {
            	click:function(obj){
            		this.downloadInfirmaryDetailDocumentZip();
            	}
            },
    		'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid]': {
    			render: function(grid){
    				grid.addButtonToolbar();
    				if (portalId == 3) {
    					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS());
    				} else if (portalId == 2) {
    					this.genericCBGridAccessControlValidation(grid, this.getFACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS());
    				} else if(portalId == 7){
    					this.genericCBGridAccessControlValidation(grid, this.getPARENT_INFIRMARY_DETAILS_PERMISSIONS());
    				} else if (portalId == 1) {
    					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS());
    				}
    				
    				var searchForm = this.getInfirmarymanageentryform();
    		        var jsonFormatFormData = this.createJsonFormatforStudentProfile();
    		        var getActiveTab = this.getActiveTabfromContentPanel();
    		    	var resultGrid=getActiveTab.down('searchresultgrid');
    		        //var resultGrid = this.getStudentInfirmaryManageEntriesGrid();
    		    	resultGrid.setTitle(getPersonModuleTranslation('CLINIC_DETAILS'));
    		        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    		        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_DETAIL_VIEWCODE);
    		        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    			
    			},
    			cellclick: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts){
    				 this.cellClickInformaryDetailsResultGrid(view, td, cellIndex, record, tr, rowIndex, e, eOpts,'FROM_STUDENT');
    			}
    		},
    		'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid]': {
    			render: function(grid){
    				grid.addButtonToolbar();
    				if (portalId == 3) {
    					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_PERMISSIONS());
    				} else if (portalId == 2) {
    					this.genericCBGridAccessControlValidation(grid, this.getFACULTY_PORTAL_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_PERMISSIONS());
    				} else if(portalId == 7){
    					this.genericCBGridAccessControlValidation(grid, this.getPARENT_INFIRMARY_INTERVENTION_DETAILS_PERMISSIONS());
    				} else if (portalId == 1) {
    					this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_PERMISSIONS());
    				}
    			},
    			cellclick: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts){
    				var manageInterventionController = this.getController('Academia.controller.servicerequest.infirmarymanage.ManageInterventionController');
    		    	manageInterventionController.cellClickInformaryDetailsResultGrid(view, td, cellIndex, record, tr, rowIndex, e, eOpts,'FROM_STUDENT');
    			}
    		},
    		'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid] button[itemId=searchResultGridBtnAdd]': {
    			click: function(btn){
    				this.addInfirmaryEntryForStudentProfile('add');
    			}
    		},
    		'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid] button[itemId=searchResultGridBtnEdit]': {
    			click: function(btn){
    				this.addInfirmaryEntryForStudentProfile('edit');
    			}
    		},
    		'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid] button[itemId=searchResultGridBtnView]': {
    			click: function(btn){
    				this.addInfirmaryEntryForStudentProfile('view');
    			}
    		},
    		'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid] button[itemId=searchResultGridBtnDelete]': {
    			click: function(btn){
    				this.deleteInfirmaryEnrtriesData();
    			}
    		},
    		'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
 	            click: function() {
 	                this.exportInfirmaryEntryListForStudentProfile(SERVERURL.PDFEXPORT,'pdf',false,'CLINIC');
 	            }
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
 	            click: function() {
 	                this.exportInfirmaryEntryListForStudentProfile(SERVERURL.PDFEXPORT,'pdf',true,'CLINIC');
 	            }
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
 	            click: function() {
 	                this.exportInfirmaryEntryListForStudentProfile(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'CLINIC');
 	            }
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageEntriesGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
 	            click: function() {
 	                this.exportInfirmaryEntryListForStudentProfile(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'CLINIC');
 	            }
 	        },
 	        
 	        
 	        'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid] button[itemId=searchResultGridBtnAdd]': {
 	        	click: function(btn){
 	        		this.addEntryForStudentProfileIntervention('add');
 	        	}
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid] button[itemId=searchResultGridBtnEdit]': {
 	        	click: function(btn){
 	        		this.addEntryForStudentProfileIntervention('edit');
 	        	}
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid] button[itemId=searchResultGridBtnView]': {
 	        	click: function(btn){
 	        		this.addEntryForStudentProfileIntervention('view');
 	        	}
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid] button[itemId=searchResultGridBtnDelete]': {
 	        	click: function(btn){
 	        		this.deleteEntryForStudentProfileIntervention();
 	        	}
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
 	        	click: function() {
 	        		this.exportInfirmaryEntryListForStudentProfile(SERVERURL.PDFEXPORT,'pdf',false,'INTERVENTION');
 	        	}
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
 	        	click: function() {
 	        		this.exportInfirmaryEntryListForStudentProfile(SERVERURL.PDFEXPORT,'pdf',true,'INTERVENTION');
 	        	}
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
 	        	click: function() {
 	        		this.exportInfirmaryEntryListForStudentProfile(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'INTERVENTION');
 	        	}
 	        },
 	        'searchresultgrid[itemId=studentInfirmaryManageInterventionGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
 	        	click: function() {
 	        		this.exportInfirmaryEntryListForStudentProfile(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'INTERVENTION');
 	        	}
 	        },
 	       
    		'manageentriesstudentprofilefilter button[itemId=searchProfileFilterBtn]': {
    			click: function(obj){
    				var searchForm = this.getManageentriesstudentprofilefilter();
    				var rgpInfirmaryOption = searchForm.down('#rgpInfirmaryOption');
    				var val = rgpInfirmaryOption.getValue();
    				var getActiveTab = this.getActiveTabfromContentPanel();
    		    	var resultGridClinic=getActiveTab.down('searchresultgrid#studentInfirmaryManageEntriesGrid');
    		    	var resultGridIntervention=getActiveTab.down('searchresultgrid#studentInfirmaryManageInterventionGrid');
    				if(val.rgpInfirmaryOption){
    					// For Clinic Checkbox

        				var searchForm = this.getInfirmarymanageentryform();
        		        var jsonFormatFormData = this.createJsonFormatforStudentProfileBySearchBtn('CLINIC');
        		        resultGridClinic.setVisible(true);
        		        resultGridIntervention.setVisible(false);
        		        resultGridClinic.setTitle(getPersonModuleTranslation('CLINIC_DETAILS'));
        		        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        		        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_DETAIL_VIEWCODE);
        		        resultGridClinic.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    				}
    				else{
    					//For Intervention Checkbox
    					Academia.app.getController('Academia.controller.servicerequest.infirmarymanage.ManageInterventionController');
    					var searchForm = this.getInfirmarymanageentryform();
    					var jsonFormatFormData = this.createJsonFormatforStudentProfileBySearchBtn('INTERVENTION');
    					resultGridClinic.setVisible(false);
        		        resultGridIntervention.setVisible(true);
    					resultGridIntervention.setTitle(getPersonModuleTranslation('INTERVENTION_DETAILS'));
        		        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        		        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_COUNSELLOR_DETAIL_VIEWCODE);
        		        resultGridIntervention.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        		        
    				}
    			}
    		},
    		'infirmarymanageentriesstructure': {
	        	afterrender: function(structure) {
	        		var grid = this.getInfirmarySearchresultgrid();
	        	    this.getCBGridHeaderFreeze(grid,structure,false);
	        	}
	        },
	        'infirmaryeditform': {
	        	afterrender: function(myform) {
                	Ext.defer(function() {
						var arr = ['whetherParentInformed', 'whetherAuthorityInformed'];
						for(var i=0;i<arr.length;i++) {
							var cb = myform.down('#'+arr[i]);
							var newWidth = 226;
							cb.setWidth(newWidth);
							cb.boxLabelEl.setWidth(newWidth - 19);
						}
					}, 500);
                }
	        }
    	});
    	this.callParent(arguments);
    },
    
    initInfirmarySearchForm: function(academyLocationId){
    	
    	var infirmaryForm = this.getInfirmarymanageentryform();
    	
    	var department_name_infirmarycombo = infirmaryForm.down('#department_name_infirmarycombo');
		
		department_name_infirmarycombo.reset();
		var departmentStore = department_name_infirmarycombo.getStore();
		departmentStore.getProxy().extraParams = {
			academyLocationsIds: academyLocationId
		};
		departmentStore.load();
		
		var doctor_name_infirmarycombo = infirmaryForm.down('#docor_name_infirmarycombo');
		var doctorStore = doctor_name_infirmarycombo.getStore();
		doctorStore.getProxy().extraParams = {
			academyLocationId:academyLocationId,
			roleName: 'DOCTOR'
		};
		doctorStore.load();
		
		var program_infirmarycombo = infirmaryForm.down('#program_infirmarycombo');
		var programStore = program_infirmarycombo.getStore();
		programStore.getProxy().extraParams = {
			academyLocationId: academyLocationId
		};
		programStore.load();
		
		var studentUserName = infirmaryForm.down('#user_studentname_infirmarycombo');
		studentUserName.reset();
		var studentUserNameStore = studentUserName.getStore();
		studentUserNameStore.getProxy().extraParams = {
			academyLocationId: academyLocationId
		};
		studentUserNameStore.load();

		var academyLocation_infirmarycombo = infirmaryForm.down('#academy_loc_infirmarycombo');
		academyLocation_infirmarycombo.setValue(academyLocationId);
		
		var userGroup_infirmarycombo = infirmaryForm.down('#user_type_infirmarycombo');
		userGroup_infirmarycombo.setValue(3);
    },
    
    initInfirmaryEntryForm: function(academyLocationId){
    	
    	var getActiveTab = this.getActiveTabfromContentPanel();
	    var infirmaryForm = getActiveTab.down('infirmaryeditform');
    	
    	var department_name_infirmarycombo = infirmaryForm.down('#departmentId');
		
		department_name_infirmarycombo.reset();
		var departmentStore = department_name_infirmarycombo.getStore();
		departmentStore.getProxy().extraParams = {
			academyLocationsIds: academyLocationId
		};
		departmentStore.load();
		
		var doctor_name_infirmarycombo = infirmaryForm.down('#doctorUserId');
		var doctorStore = doctor_name_infirmarycombo.getStore();
		doctorStore.getProxy().extraParams = {
			//academyLocationId:academyLocationId,
			roleName: 'DOCTOR'
		};
		doctorStore.load();
		
		var program_infirmarycombo = infirmaryForm.down('#programId');
		var programStore = program_infirmarycombo.getStore();
		programStore.getProxy().extraParams = {
			academyLocationId: academyLocationId
		};
		programStore.load();
		
		var studentUserName = infirmaryForm.down('#user_studentname_infirmarycombo');
		studentUserName.reset();
		var studentUserNameStore = studentUserName.getStore();
		studentUserNameStore.getProxy().extraParams = {
			academyLocationId: academyLocationId
		};
		studentUserNameStore.load();
    },
    
    deleteInfirmaryEnrtriesData:function(){
    	var $this=this;
    	 var getActiveTab = this.getActiveTabfromContentPanel();
    	var grid=getActiveTab.down('searchresultgrid');
    	var recordCount = grid.getSelectionModel().getCount();
    	if(recordCount>0){
    		var records = grid.getSelectionModel().getSelection();	
    		var arr = [];
    		for(var i=0;i<records.length;i++)
    		{
    			arr.push(records[i].data.ID);
    		}
    		var ids = arr.join();
    		showConfirmMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				 function(btn, text) {
    			 if (btn == 'yes'){
		    		 Ext.Ajax.request({
		    			 method: "GET",
		    			 type: 'rest',
		    			 url: SERVERURL.PATH_DELETE_INFIRMARY_MANAGE_ENTRIES_BY_IDS,
		    			 headers: {
		    				 'Content-Type': 'application/json'
		    			 },
		    			 params: {
		    				 ids: ids
		    			 },
		    			 success: function(form, action) {
		    				 grid.store.reload();
		    				 showSuccessMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'), getServiceRequestTranslation('INFIRMARY_DELETED_SUCCESS_MSG'));
		    			 }
		    		 });
    			 }
    		 });
    	 } else {
    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
    	 }
    },
    
    resetAndDisabled : function(field) {
    	field.reset();
    	field.setDisabled(true);
    },
    
    resetAndDisabledByField : function(value) {
    	
    	var infirmaryForm = this.getInfirmarymanageentryform();
    	
    	var programCombo = infirmaryForm.down('#program_infirmarycombo');
    	var batchCombo = infirmaryForm.down('#batch_infirmarycombo');
    	var periodCombo = infirmaryForm.down('#period_infirmarycombo');
    	var sectionCombo = infirmaryForm.down('#section_infirmarycombo');
    	var employeeUserCombo = infirmaryForm.down('#user_employeename_infirmarycombo');
    	
    	if(value == 'ACADEMYLOCATION') {
    		this.resetAndDisabled(batchCombo);
    		this.resetAndDisabled(periodCombo);
    		this.resetAndDisabled(sectionCombo);
    		this.resetAndDisabled(employeeUserCombo);
    		
    	} else if(value == 'PROGRAM') {

    		this.resetAndDisabled(periodCombo);
    		this.resetAndDisabled(sectionCombo);

    	} else if(value == 'BATCH') {
    		this.resetAndDisabled(sectionCombo);
    	} else if(value == 'ALL') { 
    		this.resetAndDisabled(programCombo);
    		this.resetAndDisabled(batchCombo);
    		this.resetAndDisabled(periodCombo);
    		this.resetAndDisabled(sectionCombo);
    		this.resetAndDisabled(employeeUserCombo);
    	}
    },
    
    /**
     * ravi.patidar
     */
    resetAndDisabledByFieldInfirmaryEdit : function(value) {

    	var getActiveTab = this.getActiveTabfromContentPanel();
	    var infirmaryeditform = getActiveTab.down('infirmaryeditform');
    	var batchCombo = infirmaryeditform.down('#batchId');
    	var periodCombo = infirmaryeditform.down('#periodId');
    	var sectionCombo = infirmaryeditform.down('#sectionId');
    	var departmentCombo = infirmaryeditform.down('#departmentId');
    	var employeeUserCombo = infirmaryeditform.down('#user_employeename_infirmarycombo');
    	var parentUserId = infirmaryeditform.down('#parentUserId');
    	
      	
    	if(value == 'ACADEMYLOCATION') {
    		this.resetAndDisabled(batchCombo);
    		this.resetAndDisabled(periodCombo);
    		this.resetAndDisabled(sectionCombo);
    		this.resetAndDisabled(employeeUserCombo);
    		
    		batchCombo.allowBlank = true;
    		batchCombo.labelSeparator = '';
    		batchCombo.setFieldLabel(getCommonTranslation('BATCH'));
    		
    		periodCombo.allowBlank = true;
    		periodCombo.labelSeparator = '';
    		periodCombo.setFieldLabel(getCommonTranslation('PERIOD'));
    		
    		departmentCombo.reset();

    	} else if(value == 'PROGRAM') {

    		this.resetAndDisabled(periodCombo);
    		this.resetAndDisabled(sectionCombo);
    		
    		if(infirmaryeditform.config.action == "add")
			{
			parentUserId.getStore().removeAll();
        	parentUserId.getStore().clearData();
        	delete parentUserId.getStore().proxy.extraParams.personId;
			}

    	} else if(value == 'BATCH') {
    		this.resetAndDisabled(sectionCombo);
    	} else if(value == 'ALL') { 
    		this.resetAndDisabled(batchCombo);
    		this.resetAndDisabled(periodCombo);
    		this.resetAndDisabled(sectionCombo);
    		this.resetAndDisabled(employeeUserCombo);
    		parentUserId.getStore().removeAll();
        	parentUserId.getStore().clearData();

    		
    		batchCombo.allowBlank = true;
    		batchCombo.labelSeparator = '';
    		batchCombo.setFieldLabel(getCommonTranslation('BATCH'));
    		
    		periodCombo.allowBlank = true;
    		periodCombo.labelSeparator = '';
    		periodCombo.setFieldLabel(getCommonTranslation('PERIOD'));
    	}
    },
    addInfirmaryEntry: function(btnaction){
    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var structure = Ext.widget('infirmaryeditform');
    	structure.config.action = btnaction;
    	var tabName = getServiceRequestTranslation('ADD_ENTRY');
    	if(btnaction == "edit"){
    		tabName = getServiceRequestTranslation('EDIT_ENTRY');
    	} else if(btnaction == "view"){
    		tabName = getServiceRequestTranslation('VIEW_ENTRY');
    	}
    	
    	var infirmarySearchresultgrid = this.getInfirmarySearchresultgrid();
    	var selectedRec = infirmarySearchresultgrid.getSelectionModel().getSelection();
    	var selectedRecord = selectedRec[0];
    	/**
    	 * This is to remove tab from content panel and open same tab again
    	 */
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(getServiceRequestTranslation('ADD_ENTRY'));
	    	if(!getTab){
	    		getTab=getcontroller.getTab(getServiceRequestTranslation('EDIT_ENTRY'));
	    	}
	    	if(!getTab){
	    		getTab=getcontroller.getTab(getServiceRequestTranslation('VIEW_ENTRY'));
	    	}
    	if(getTab!=null){
    		contentPanel.remove(getTab, true);
    	}
    	
    	if((btnaction == "edit" || btnaction == "view") && selectedRec.length == 1){
    		try{
    			
    	    	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
    	    
    	    	var infirmaryaddentrygrid=structure.down('infirmaryaddentrygrid');
	    		Ext.Ajax.request({
	    			method: "GET",
	    			type: 'rest',
	    			scope:this,
	    			url: SERVERURL.FIND_INFIRMARY__PARENT_DETAIL_BYID,
	    			params:{
	    				id:selectedRecord.get('ID')
	    			},
	    			callback: function(response, action,resText) {
	    				var formData = Ext.decode(resText.responseText);
	    				
	    				formData['timeIn'] = timeRender(formData.timeIn);
	    				formData['timeOut'] = timeRender(formData.timeOut);
	    				
	    				var doctor_name_infirmarycombo = structure.down('#doctorUserId');
	    				var doctorStore = doctor_name_infirmarycombo.getStore();
	    				
	    				doctorStore.getProxy().extraParams = {
	    					academyLocationId:formData.academyLocationId,
	    					roleName: 'DOCTOR'
	    				};
	    				doctorStore.load({
	    					callback: function(){
	    						if(!isNullOrEmpty(formData.doctorUserId))
	    							doctor_name_infirmarycombo.setValue(formData.doctorUserId);
	    					}
	    				});
	    				var infirmaryReasonCombo=structure.down('#infirmaryReasonId');
	    				var infirmaryReasonComboStore=infirmaryReasonCombo.getStore();
	    				
	    				infirmaryReasonComboStore.load({
	    					callback : function(record,	operation, success) {
            					if (success) {
            						if(!isNullOrEmpty(formData.infirmaryReasonId)){
            							infirmaryReasonCombo.setValue(formData.infirmaryReasonId);
            						}
            					}
            				}
	    				});
	    				
	    				var infirmaryOutcomeItemId=structure.down('#infirmaryOutcomeItemId');
	    				if (!isNullOrEmpty(formData.infirmaryOutcome) && !isNullOrEmpty(formData.infirmaryOutcome.id)) {
	    					infirmaryOutcomeItemId.getStore().load({
	    	                    callback: function(records, operation, success) {
	    	                    	infirmaryOutcomeItemId.setValue(formData.infirmaryOutcome.id);
	    	                    }
	    	                });
	    	            }
	    				
	    				if(formData.whetherAuthorityInformed){
	    					var authorityUserCombo = structure.down('#authorityUserId');
	    					var authorityUserComboStore = authorityUserCombo.getStore();
	    					
	    					authorityUserCombo.setDisabled(false);
	    					authorityUserComboStore.getProxy().extraParams = {
	    						academyLocationId:formData.academyLocationId
	    					};
	    					authorityUserComboStore.load({
	    						scope:this,
	    						callback: function(){
	    							if(!isNullOrEmpty(formData.authorityUserId))
	    								authorityUserCombo.setValue(formData.authorityUserId);
	    						}
	    					});
	    				} else {
	    					var authorityUserCombo = structure.down('#authorityUserId');
	    					authorityUserCombo.setDisabled(true);
	    				}
	    				var parentUserCombo = structure.down('#parentUserId');
	    				var parentUserComboStore = parentUserCombo.getStore();
	    				if(formData.whetherParentInformed){
	    					parentUserCombo.setDisabled(false);
	    					
	    				} else {
	    					parentUserCombo.setDisabled(true);
	    				}
	    				
	    				parentUserComboStore.getProxy().extraParams = {
    						personId:formData.userId
    					};
	    				var personparentIds=[];
    					parentUserComboStore.load({
    						scope:this,
    						callback: function(){
    							if(!isNullOrEmpty(formData.personparentIds)){
                                    for(var i in formData.personparentIds){
  								  personparentIds.push(formData.personparentIds[i].personIds.id);
  						       }
  							parentUserCombo.setValue(personparentIds);
    							
    							}
    							}
    					});
    					
	    				var userStudentCombo = structure.down('#user_studentname_infirmarycombo');
    					var userStudentComboStore = userStudentCombo.getStore();
	    				if(!isNullOrEmpty(formData.departmentId)){
	    					var departmentCombo = structure.down('#departmentId');
	    					var userEmployeeCombo = structure.down('#user_employeename_infirmarycombo');
	    					var userEmployeeStore = userEmployeeCombo.getStore();
	    					var departStore = departmentCombo.getStore();
	    					
	    					departmentCombo.setVisible(true);
	    					userStudentCombo.setVisible(false);
	    					userStudentCombo.setDisabled(false);
	    					userEmployeeCombo.setVisible(true);
	    					
	    					
	    					
	    					departStore.getProxy().extraParams = {
	    						academyLocationsIds:formData.academyLocationId
	    					};
	    					departStore.load({
	    						callback: function(){
	    							if(!isNullOrEmpty(formData.departmentId))
	    								departmentCombo.setValue(formData.departmentId);
	    						}
	    					});
	    					
	    					userEmployeeStore.getProxy().extraParams = {
	    						academyLocationId: formData.academyLocationId,
	    						departmentId:formData.departmentId,
	    					};
	    					userEmployeeStore.load({
	    						callback: function(){
	    							if(!isNullOrEmpty(formData.userId))
	    								userEmployeeCombo.setValue(formData.userId);
	    						},
	    					});
	    				}else{
	    					if(formData.userGroupId==1){
	    						var userEmployeeCombo = structure.down('#user_employeename_infirmarycombo');
		    					var userEmployeeStore = userEmployeeCombo.getStore();
		    					userEmployeeStore.getProxy().extraParams = {
		    						academyLocationId: formData.academyLocationId,
		    					};
		    					userEmployeeStore.load({
		    						callback: function(){
		    							if(!isNullOrEmpty(formData.userId))
		    								userEmployeeCombo.setValue(formData.userId);
		    						},
		    					});
	    					}
	    				}
	    				
	    				userStudentComboStore.getProxy().extraParams = {
    						academyLocationId: formData.academyLocationId
    					};
    					userStudentComboStore.load({
    						async:false,
    						callback: function(){
    							Ext.getBody().unmask();
    							if(!isNullOrEmpty(formData.userId))
    								userStudentCombo.setValue(formData.userId);
    						}
    					});
    					
	    				if(!isNullOrEmpty(formData.programId)){
	    					var programCombo = structure.down('#programId');
	    					var batchNameCombo = structure.down('#batchId');
	    					var batchNameStore = batchNameCombo.getStore();
	    					var programComboStore = programCombo.getStore();
	    					
	    					programComboStore.getProxy().extraParams = {
	    						academyLocationId:formData.academyLocationId
	    					};
	    					programComboStore.load({
	    						callback: function(){
	    							if(!isNullOrEmpty(formData.programId))
	    								programCombo.setValue(formData.programId);
	    						}
	    					});
	    					
	    					
	    		
	    					this.resetAndDisabledByFieldInfirmaryEdit('PROGRAM');
	    					batchNameCombo.setDisabled(false);
	    		
	    					
	    					batchNameStore.getProxy().extraParams = {
	    						programId: formData.programId
	    					};
	    					batchNameStore.load({
	    						callback: function(){
	    							if(!isNullOrEmpty(formData.batchId))
	    								batchNameCombo.setValue(formData.batchId);
	    						}
	    					});
	    					
	    					if(!isNullOrEmpty(formData.batchId)){
	    						var periodNameCombo = structure.down('#periodId');
	    						var periodNameStore = periodNameCombo.getStore();
	    						this.resetAndDisabledByFieldInfirmaryEdit('BATCH');
	    						periodNameCombo.setDisabled(false);
	    						
	    						periodNameStore.getProxy().extraParams = {
	    							id: formData.batchId
	    						};
	    						periodNameStore.load({
	    							callback: function(){
	    								if(!isNullOrEmpty(formData.periodId))
	    									periodNameCombo.setValue(formData.periodId);
	    							}
	    						});
	    		
	    						if(!isNullOrEmpty(formData.periodId)){
	    							var sectionNameCombo = structure.down('#sectionId');
	    							var sectionNameStore = sectionNameCombo.getStore();
	    							sectionNameCombo.setDisabled(false);
	    							sectionNameStore.getProxy().extraParams = {
	    								periodId: formData.periodId
	    							};
	    							sectionNameStore.load({
	    								callback: function(){
	    									if(!isNullOrEmpty(formData.sectionId))
	    										sectionNameCombo.setValue(formData.sectionId);
	    								}
	    							});
	    						}
	    					}
	    				}
	    				
	    		    	structure.getForm().setValues(formData);
	    		    	structure.getForm().findField('infirmaryDate').setValue(dateRender(formData.infirmaryDate));
	    		    	structure.getForm().findField('whetherAuthorityInformed').setValue(formData.whetherAuthorityInformed);
	    		    	structure.getForm().findField('whetherParentInformed').setValue(formData.whetherParentInformed);
	    		    	var infirmaryAddEntryGridStore = infirmaryaddentrygrid.getStore();
	    	    		infirmaryAddEntryGridStore.loadData(formData.infirmaryMedicineDetails);
	    	    		model = infirmaryAddEntryGridStore.getRange();
	    	    		var docGrid = this.getInfirmarydetaildocumentgrid();
	    	    		var docStore = this.getInfirmarydetaildocumentgrid().getStore();
	    	            docStore.getProxy().extraParams = {
	    	            	infirmaryDetailId: formData.id
	    	            };
	    	            docStore.load({
	    	            	callback:function(){
	    	            		docGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ docStore.getCount());
	    	            	}
	    	            });
	    	    		if(btnaction == 'edit'){
		    	    		for(var i in model){
		    	    			var serialNo = parseInt(i)+1;
		    	    			model[i].set('addButton', true);
		    	    			model[i].set('serialNo', serialNo);
		    	    			model[i].set('isEditable', true);
		    	    			if(i>0)
		    	    				model[i].set('deleteButton', true);
		    	    			else
		    	    				model[i].set('deleteButton', false);
		    	    		}
		    	    		structure.down('button[itemId=resetBtnForm]').setVisible(false);
	    	    		} else if(btnaction == 'view'){
	    	    			var fieldItems = structure.getForm().getFields().items;
	    	    			for(i in fieldItems){
	    	    				fieldItems[i].setReadOnly(true);
	    	    			}
	    	    			structure.down('button[itemId=submitBtn]').setVisible(false);
	    	    			structure.down('button[itemId=resetBtnForm]').setVisible(false);
	    	    			structure.down('button[itemId=documentUploadItemId]').setVisible(false);
	    	    			for(var i in model){
		    	    			var serialNo = parseInt(i)+1;
		    	    			model[i].set('addButton', false);
		    	    			model[i].set('serialNo', serialNo);
	    	    				model[i].set('deleteButton', false);
	    	    				model[i].set('isEditable', false);
		    	    		}
		    	    		infirmaryaddentrygrid.columnManager.columns.forEach(function(obj){
	    	    				if(obj.dataIndex == 'addButton' || obj.dataIndex == 'deleteButton'){
	    	    					obj.destroy();
	    	    				}
	    	    			});
	    	    			infirmaryaddentrygrid.reconfigure();
	    	    			this.getInfirmarydetaildocumentgrid().down('#btnDelete').setVisible(false);
	    	    		}
	    			}
	    		});
    		}
    		catch(e){
    			console.log(e);
    			Ext.getBody().unmask();
    		}
    		
    	} else if(btnaction == "add"){
    		var academyLocationId = this.getCurrentAcademyLocation();
    		
        	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
        	var infirmaryaddentrygrid = this.getInfirmaryaddentrygrid();
        	
    		structure.getForm().findField('id').setValue(null);
    		structure.getForm().findField('academyLocationId').setValue(academyLocationId);
    		structure.getForm().findField('infirmaryDate').setValue(new Date());
    		structure.getForm().findField('userGroupId').setValue(3);
    		var doctor_name_infirmarycombo = structure.down('#doctorUserId');

    		var doctorStore = doctor_name_infirmarycombo.getStore();
    		doctorStore.getProxy().extraParams = {
    		    academyLocationId:academyLocationId,
    		    roleName: 'DOCTOR'
    		};
    		doctorStore.load({
    			scope:this,
				callback: function(rec, callback){
					var currentUserId = this.getCurrentlyLoggedInUser().id;
					var index = doctor_name_infirmarycombo.getStore().find('id',currentUserId);
					if(index != -1)
					doctor_name_infirmarycombo.setValue(currentUserId);
				}
			});

    		var authorityUserCombo = structure.down('#authorityUserId');
    		var parentUserCombo = structure.down('#parentUserId');
			parentUserCombo.setDisabled(true);
    		var authorityUserComboStore = authorityUserCombo.getStore();

    		authorityUserCombo.setDisabled(true);
    		authorityUserComboStore.getProxy().extraParams = {
    		    academyLocationId: academyLocationId
    		};
    		authorityUserComboStore.load();

    		var departmentCombo = structure.down('#departmentId');
    		var userStudentCombo = structure.down('#user_studentname_infirmarycombo');
    		var userEmployeeCombo = structure.down('#user_employeename_infirmarycombo');
    		var userEmployeeStore = userEmployeeCombo.getStore();
    		var departStore = departmentCombo.getStore();

    		userEmployeeStore.getProxy().extraParams = {
    		    academyLocationId: academyLocationId
    		};
    		userEmployeeStore.load();

    		departStore.getProxy().extraParams = {
    			academyLocationsIds:academyLocationId
    		};
    		departStore.load();


    		var programCombo = structure.down('#programId');
    		var batchNameCombo = structure.down('#batchId');
    		var batchNameStore = batchNameCombo.getStore();
    		var programComboStore = programCombo.getStore();

    		programComboStore.getProxy().extraParams = {
    		    academyLocationId:academyLocationId
    		};
    		programComboStore.load();

    		this.resetAndDisabledByFieldInfirmaryEdit('PROGRAM');
    		//batchNameCombo.setDisabled(false);

    		infirmaryaddentrygrid.getStore().removeAll();
    		var docStore = this.getInfirmarydetaildocumentgrid().getStore();
	        docStore.removeAll();
	        docStore.loadData([]);
    		this.addNewRowInGrid(1);
    		Ext.getBody().unmask();
    	} else {
    		if(selectedRec.length > 1){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
    		}
    		else if(selectedRec.length == 0){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    		}
    		Ext.getBody().unmask();
    	}
    },
    
    createJsonFormat: function(searchForm) {
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_DETAIL_CONFIGCODE;

        formValues = searchForm.getValues();        
        
        var userType = searchForm.down('#user_type_infirmarycombo');
        if(isNullOrEmpty(formValues.ACADEMY_LOCATION_ID)){
        	formValues.ACADEMY_LOCATION_ID = this$.getCurrentAcademyLocation();
        }
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'STUDENT_USER_ID' && key !== 'EMPLOYEE_USER_ID'
            	&& key !== 'DEPARTMENT_ID' && key != 'from_date_inmry' && key != 'to_date_inmry'){
                var keyValueJsonObject = this$.getJsonObject( key , value);
                this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        var userId = null;
        if(userType.rawValue.toUpperCase() == 'STUDENT') {
        	userId = formValues.STUDENT_USER_ID;
        } else {
        	userId = formValues.EMPLOYEE_USER_ID;
        	var departmentIdObj = this$.getJsonObject( 'DEPARTMENT_ID' , formValues.DEPARTMENT_ID);
            this$.pushJsonObjectInArray(departmentIdObj,searchcriteria);
        }
        
        var userIdObj = this$.getJsonObject( 'USER_ID' , userId);
        this$.pushJsonObjectInArray(userIdObj,searchcriteria);
        if(!isNullOrEmpty(formValues.infirmaryReasonId)){
        	 var infirmaryReasonIdObj = this$.getJsonObject( 'INFIRMARY_REASON_ID' ,formValues.infirmaryReasonId);
             this$.pushJsonObjectInArray(infirmaryReasonIdObj,searchcriteria);
        }
       
        var today = new Date();
        var frmDate = Ext.Date.format(new Date(), CONSTANTS.SUBMIT_DATE_FORMAT);
        
        var oldDate = new Date(new Date().setDate(today.getDate()-30));
    	var priorDate = Ext.Date.format(oldDate, CONSTANTS.SUBMIT_DATE_FORMAT);
        
        var infirmaryDateObj = this$.getJsonObject( 'INFIRMARY_DATE' , formValues.from_date_inmry, formValues.to_date_inmry);
        
        if(formValues.from_date_inmry == '' && formValues.to_date_inmry == '') {
        	var priorDate = Ext.Date.format(oldDate,CONSTANTS.SUBMIT_DATE_FORMAT);
        	var todate = Ext.Date.format(new Date(),CONSTANTS.SUBMIT_DATE_FORMAT);
        	infirmaryDateObj = this$.getJsonObject( 'INFIRMARY_DATE' , priorDate, todate);
        	
        } else if(formValues.to_date_inmry == '') {
        	infirmaryDateObj = this$.getJsonObject('INFIRMARY_DATE' , frmDate, frmDate);
        } else if(formValues.from_date_inmry == '') {
        	infirmaryDateObj = this$.getJsonObject('INFIRMARY_DATE' , frmDate, frmDate);
        }
        
        this$.pushJsonObjectInArray(infirmaryDateObj,searchcriteria);
        
        var typeObj = this$.getJsonObject( 'TYPE' , 'CLINIC');
        this$.pushJsonObjectInArray(typeObj,searchcriteria);

        if(portalId != 7 || portalId != 3){
        	var userId = this$.getCurrentlyLoggedInUser().id;
        	Ext.Ajax.request({
        		type : 'rest',
        		url :SERVERURL.PATH_CHECK_WHETHER_USER_DOCTOR,
        		method : 'GET',
        		async: false,
        		success : function(response, action) {
        			var resp = Ext.JSON.decode(response.responseText);
        			if(!resp){
        				if(userId!=1){
        					//searchcriteria =  [{"paramCode": "CREATED_BY_USER","paramValues": [userId]}];
        					var createdby = this$.getJsonObject( 'CREATED_BY_USER' , userId);
        					var doctorUserId = this$.getJsonObject( 'DOCTOR_USER_ID' , userId);
        					this$.pushJsonObjectInArray(createdby,searchcriteria);
        					this$.pushJsonObjectInArray(doctorUserId,searchcriteria);
        				}
        			}
        		}});
        }
        
        values.searchCriterias = searchcriteria;
        return values;
    },
    createJsonFormatforStudentProfile: function() {
    	var this$=this;
        var values = new Object();
        var searchcriteria = new Array();
    
        values.configCode = CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_DETAIL_CONFIGCODE;
        var academyLocationId = this.getCurrentAcademyLocation();
        var getActiveTab = this.getActiveTabfromContentPanel();
        var userId = this$.getCurrentlyLoggedInUser().id;
        var parentPersonId = localStorage.getItem('loggedInParentPersonId');
        var searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["CLINIC"]}];
        if(portalId == 7){
        	searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["CLINIC"]},{"paramCode":"WHETHER_PARENT_INFORMED","paramValues":[true]},{"paramCode":"PARENT_USER_ID","paramValues":[parentPersonId]}];
        }
        else if(portalId == 2){
        	searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["CLINIC"]},{"paramCode":"WHETHER_AUTHORITY_INFORMED","paramValues":[true]},{"paramCode":"AUTHORITY_USER_ID","paramValues":[userId]}];
        }
        values.searchCriterias = searchcriteria;
        return values;
    },
    
    createJsonFormatforStudentProfileBySearchBtn: function(typeChk) {
    	var this$=this;
        var values = new Object();
        var searchcriteria = new Array();
        var userId = this$.getCurrentlyLoggedInUser().id;
        var parentPersonId = localStorage.getItem('loggedInParentPersonId');
    
        if(typeChk == "CLINIC"){
        	values.configCode = CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_DETAIL_CONFIGCODE;
            var academyLocationId = this.getCurrentAcademyLocation();
            var getActiveTab = this.getActiveTabfromContentPanel();
            var searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["CLINIC"]}];
            if(portalId == 7){
            	searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["CLINIC"]},{"paramCode":"WHETHER_PARENT_INFORMED","paramValues":[true]},{"paramCode":"PARENT_USER_ID","paramValues":[parentPersonId]}];
            }
            else if(portalId == 2){
            	searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["CLINIC"]},{"paramCode":"WHETHER_AUTHORITY_INFORMED","paramValues":[true]},{"paramCode":"AUTHORITY_USER_ID","paramValues":[userId]}];
            }
            
            values.searchCriterias = searchcriteria;
            return values;	
        }
        else{
        	values.configCode = CONSTANTS.CB.INFIRMARY_MANAGE_ENTRIES_COUNSELLOR_DETAIL_CONFIGCODE;
            var academyLocationId = this.getCurrentAcademyLocation();
            var getActiveTab = this.getActiveTabfromContentPanel();
            var searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["INTERVENTION"]}];
            if(portalId == 7){
            	searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["INTERVENTION"]},{"paramCode":"WHETHER_PARENT_INFORMED","paramValues":[true]},{"paramCode":"PARENT_USER_ID","paramValues":[parentPersonId]}];
            }
            else if(portalId == 2){
            	searchcriteria =  [{"paramCode": "USER_TYPE_ID","paramValues": [3]}, {"paramCode": "ACADEMY_LOCATION_ID","paramValues": [academyLocationId]},{"paramCode": "USER_ID","paramValues": [getActiveTab.getUserId()]},{"paramCode":"TYPE","paramValues":["INTERVENTION"]},{"paramCode":"WHETHER_AUTHORITY_INFORMED","paramValues":[true]},{"paramCode":"AUTHORITY_USER_ID","paramValues":[userId]}];
            }
            values.searchCriterias = searchcriteria;
            return values;
        }
        
    },
    
    cellClickInformaryDetailsResultGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts,openFrom) {
    	
    	var this$ = this;
        
    	var columnName = view.getGridColumns()[cellIndex].dataIndex;
        studentDetails=record;
        
        var getActiveTab = this.getActiveTabfromContentPanel();
    	var grid=getActiveTab.down('searchresultgrid');
    	
        var infirmaryId = record.data.ID;
        
        if (e.target.tagName == 'A') {
        if (columnName == "EXAMINATION_HISTORY") {
        	
        	var formWindow = this$.getInfirmarymedicinehistorydetailswindow();
			if (!formWindow) {
				 Ext.widget('infirmarymedicinehistorydetailswindow');
				 formWindow = this$.getInfirmarymedicinehistorydetailswindow();
			 }
			formWindow.show();
			
			var userType = record.data['USER_TYPE'];
			
			formWindow.down('#userCodeName').setValue(record.data['USER_CODE_OR_NAME']);
			formWindow.down('#userType').setValue(userType);
			formWindow.down('#doctorName').setValue(record.data['DOCTOR_USER_NAME']);
			formWindow.down('#academy').setValue(record.data['ACADEMY_LOCATION_NAME']);
			
			this.setVisibilityAndValue(userType, record, formWindow);
			
			var detailsGrid = formWindow.down("#infirmarymedicinehistorydetailswindow").down('#infirmarymedicinehistorydetailsgridId');
			var detailStore = detailsGrid.getStore();
			 detailStore.getProxy().extraParams = {
				 id: infirmaryId
			 },
			 detailStore.load(); 
        } else if(columnName == 'WHETHER_PARENT_INFORMED' || columnName == 'WHETHER_AUTHORITY_INFORMED') {
        	var formWindow = this$.getInfirmarywhetherinformedwindow();
        	if(columnName == 'WHETHER_PARENT_INFORMED') {
        		formWindow = this$.getInfirmarywhetherinformedwindow();
        		if (!formWindow) {
        			Ext.widget('infirmarywhetherinformedwindow');
        			formWindow = this$.getInfirmarywhetherinformedwindow();
        		}
        	} else if(columnName == 'WHETHER_AUTHORITY_INFORMED') {
        		formWindow = this$.getInfirmarywhetherinformedauthoritywindow();
        		if (!formWindow) {
        			Ext.widget('infirmarywhetherinformedauthoritywindow');
        			formWindow = this$.getInfirmarywhetherinformedauthoritywindow();
        		}
        	}
			
			formWindow.show();
			var recordId = record.data['ID'];
			var this$ = this;
			var submitURL = SERVERURL.FIND_INFIRMARY_INFORMED_DETAILS_BYID+"?id="+recordId;
			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
 			Ext.Ajax.request({
 	        		url: submitURL,
 	        		method: 'GET',
 	        		success: function(response) {
 	        			var obj = Ext.decode(response.responseText);
 	        			var arr=[];
 	        			var grid = formWindow.down("#whetherInformedStatusGrid");
 	        			if(columnName == 'WHETHER_PARENT_INFORMED') {

 	        				var json ={
 	        						"whetherInformedStatus":statusYesNoRender(obj[0].whetherParentInformed),
 	        						"informedUserName":obj[0].parentPersonName,
 	        						"remark":obj[0].remark
 	        				};
 	        				formWindow.setTitle(getServiceRequestTranslation('WHETHER_INFORMED_PARENT'));
 	        				
 	        				grid.setTitle(getServiceRequestTranslation('WHETHER_INFORMED_PARENT'));
 	        				arr.push(json);

 	        			} else if(columnName == 'WHETHER_AUTHORITY_INFORMED') {

 	        				var json ={
 	        						"whetherInformedStatus":statusYesNoRender(obj[0].whetherAthorityInformed),
 	        						"informedUserName":obj[0].authorityUserName,
 	        				};
 	        				formWindow.setTitle(getServiceRequestTranslation('WHETHER_INFORMED_A_F'));
 	        				grid.setTitle(getServiceRequestTranslation('WHETHER_INFORMED_A_F'));	
 	        				arr.push(json);

 	        			}
 	        			grid.getStore().loadRawData(arr);
 	        			Ext.getBody().unmask();
 	        		}
 	        	});
        } else if (columnName=='ATTACHMENTS' && record.data.ATTACHMENTS > 0) {
        	var $this = this;
        	var formWindow = $this.getInfirmarydetaildocumentwin();
        	if (!formWindow) {
        		Ext.widget('infirmarydetaildocumentwin');
        		formWindow = $this.getInfirmarydetaildocumentwin();
        	}
        	Ext.apply(formWindow, {
        		openFrom: null,
        		setOpenFrom: function(openFrom) {
        			formWindow.openFrom = openFrom;
        		},
        		getOpenFrom: function() {
        			return formWindow.openFrom;
        		}
        	});
        	formWindow.setOpenFrom(openFrom);
        	formWindow.show();
        	var documentGrid = $this.getInfirmarydetaildocumentgridonpopup();
        	documentGrid.getStore().getProxy().extraParams = {
        		infirmaryDetailId: infirmaryId
        	};
        	$this.resetPageSetting(documentGrid.getStore());
        	documentGrid.getStore().load();
        }
        }
    },
    
    exportInfirmaryEntryList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getInfirmarymanageentryform();	
    	var searchResultGrid = this.getInfirmarySearchresultgrid();
    	var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('MANAGE_CLINIC_REPORT');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
    
	setVisibilityAndValue : function(userType, record, formWindow) {
		
		formWindow.down('#program').setVisible(false);
		formWindow.down('#batch').setVisible(false);
		formWindow.down('#period').setVisible(false);
		formWindow.down('#section').setVisible(false);
		formWindow.down('#department').setVisible(false);
		
		if(userType.toUpperCase() == 'STUDENT') {

			formWindow.down('#program').setVisible(true);
			formWindow.down('#batch').setVisible(true);
			formWindow.down('#period').setVisible(true);
			formWindow.down('#section').setVisible(true);
			
			formWindow.down('#program').setValue(record.data['PROGRAM_NAME']);
			formWindow.down('#batch').setValue(record.data['BATCH_NAME']);
			formWindow.down('#period').setValue(record.data['BATCH_NAME']);
			formWindow.down('#section').setValue(record.data['SECTION_NAME']);
		} else {
			formWindow.down('#department').setVisible(true);
			formWindow.down('#department').setValue(record.data['DEPARTMENT_NAME']);
		}
	},
	
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
	
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    addNewRowInGrid: function(serialNo) {
        var $this = this;
        var getActiveTab = $this.getActiveTabfromContentPanel();
	    var grid=getActiveTab.down('infirmaryaddentrygrid');
        var ObjModel = [];
        var infirmaryGridModel = new Academia.model.servicerequest.infirmary.InfirmaryAddEntryModel();
       
        infirmaryGridModel.set("serialNo", serialNo);
        infirmaryGridModel.set("description", '');
        infirmaryGridModel.set("medicineName", '');
        infirmaryGridModel.set("addButton", true);
        infirmaryGridModel.set("isEditable", true);
        infirmaryGridModel.set("deleteButton", true);

        ObjModel.push(infirmaryGridModel);
        grid.getStore().loadRawData(ObjModel, true);
    },
    resetInfirmaryEditForm: function(btn){
    	var $this = this;
    	var infirmaryEditForm = btn.up('infirmaryeditform');
    	infirmaryEditForm.getForm().reset();
    	var getActiveTab = $this.getActiveTabfromContentPanel();
 	    var infirmaryaddentrygrid=getActiveTab.down('infirmaryaddentrygrid');
    	infirmaryaddentrygrid.getStore().removeAll();
    },
    submitInfirmaryEditForm: function(btn){
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        var $this = this;
    	try {
    		var infirmaryProfile = this.getActiveTabfromContentPanel();
        	var infirmaryEditForm = infirmaryProfile.down('infirmaryeditform');
			var formValues = infirmaryEditForm.getValues();
			var medicineComboStore = Academia.app.getStore('servicerequest.infirmary.MedicineDetailCombo');
			
	 	    var infirmaryaddentrygrid=infirmaryProfile.down('infirmaryaddentrygrid');
			
			var infirmaryaddentrygridModel = infirmaryaddentrygrid.getStore().getRange();
			var tempInfirmaryMedicineDetail = [];
			var tempIdValue = null;
			var tempUserIdValue = null;
			formValues['infirmaryMedicineDetails'] = [];
			//tempIdValue = formValues['id'];
			/*formValues['id'] = parseInt(tempIdValue);
			if (formValues['userId'] && formValues['userId'].length > 1) {
				tempUserIdValue = formValues['userId'][0];
			} else {
				tempUserIdValue = formValues['userId'];
			}*/
			var form = infirmaryEditForm.getForm();
			var userGroupName = form.findField('userGroupId').rawValue;
			var usetStudent = infirmaryEditForm.down
			//if (userGroupName.toUpperCase() == 'STUDENT') {
			if (userGroupName.toUpperCase() == getCommonTranslation('STUDENT').toUpperCase()) {
				getCommonTranslation('PLEASE_SELECT_RECORD')
				tempUserIdValue = infirmaryEditForm.down('#user_studentname_infirmarycombo').getValue();
			} else {
				tempUserIdValue = infirmaryEditForm.down('#user_employeename_infirmarycombo').getValue();
			}
			
			formValues['userId'] = tempUserIdValue;
			
			if (!isNullOrEmpty(formValues.infirmaryOutcomeId)) {
				formValues['infirmaryOutcome'] = {
	                    id: formValues.infirmaryOutcomeId
	            };
			}
			
			if(!formValues['authorityUserId']){
				formValues['authorityUserId'] = null;
			}
			
			if(!formValues['parentUserId']){
				formValues['parentUserId'] = null;
			}
			
			if (infirmaryaddentrygridModel.length > 0) {
				for ( var i in infirmaryaddentrygridModel) {
					
					if(infirmaryEditForm.config.action == 'edit'){
						var id = '';
						tempInfirmaryMedicineDetail.push({
							id : infirmaryaddentrygridModel[i].get('id'),
							medicineId : infirmaryaddentrygridModel[i].get('medicineId'),
							description : infirmaryaddentrygridModel[i].get('description')
						});
					} else {
						tempInfirmaryMedicineDetail.push({
							medicineId : infirmaryaddentrygridModel[i].get('medicineId'),
							description : infirmaryaddentrygridModel[i].get('description')
						});
					}
				}
				formValues['infirmaryMedicineDetails'] = tempInfirmaryMedicineDetail;
			}
			
			var parentUserIds = formValues['parentUserId'];
            var personparentIds = [];
            for(var i in parentUserIds){
				  if(Ext.isObject(parentUserIds[0])){
					  personparentIds.push({
  					       "personIds" : {
							  "id":parentUserIds[i].get("id")
					  }
  				  });
			  }else{
				  personparentIds.push({
					  "personIds" :{
						  "id":parentUserIds[i]
					  }
				  });
				  formValues['personparentIds'] = personparentIds;
				  }
			  }
            formValues['personparentIds'] = personparentIds;
  
			if(infirmaryEditForm.config.action == 'add'){
				delete formValues['id'];
			}
			
			delete formValues['description'];
			delete formValues['medicineId'];
			delete formValues['infirmaryOutcomeId'];
			delete formValues['parentUserId'];
			
			var getActiveTab = this.getActiveTabfromContentPanel();
    	    var documentGrid=getActiveTab.down('infirmarydetaildocumentgrid');
    	    
            var docStore = documentGrid.getStore();
            var docArray = [];
            try {
                if (!isNullOrEmpty(documentGrid.getCode()) && documentGrid.getCode() != undefined) {
                    if (docStore.data.items != null && docStore.data.items.length > 0) {
                        Ext.each(docStore.data.items, function(val) {
                            if (val.data.isNewRecord != undefined && val.data.isNewRecord) {
                                var newData = {
                                    "name": val.data.documentName,
                                    "path": val.data.path,
                                    "type": "DOCUMENT",
                                    "createdBy": $this.getIdValueJson(val.data.createdBy.id, val.data.createdBy.value)
                                };

                                var newData2 = {
                                		"document": newData
                                };
                                docArray.push(newData2);
                            }
                        });
                    }
                }
            } catch (err) {

            }
            
            formValues['infirmaryDetailDocuments'] = docArray;
            formValues['type'] = 'CLINIC';
			
			var requestUrl = SERVERURL.INFIRMARY_UPDATE;
			if (infirmaryEditForm.config.action == "add") {
				requestUrl = SERVERURL.INFIRMARY_CREATE;
				success_msg = getServiceRequestTranslation('INFIRMARY_SAVED_SUCCESS_MSG');
			} else {
				success_msg = getServiceRequestTranslation('INFIRMARY_UPDATED_SUCCESS_MSG');
			}
			Ext.Ajax.request({
				method : "POST",
				type : 'rest',
				scope:this,
				url : requestUrl,
				jsonData : Ext.encode(formValues),
				callback : function(response, action) {
					if(action){
						Ext.getBody().unmask();
						showSuccessMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'), success_msg);
						var infirmarySearchresultgrid = this.getInfirmarySearchresultgrid();
						if(infirmarySearchresultgrid){
							infirmarySearchresultgrid.getStore().load();
						}
						var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				    	var infirmaryeditform = this.getInfirmaryeditform();
				    	var tabName = getServiceRequestTranslation('ADD_ENTRY');
				    	if(infirmaryeditform.config.action == 'edit'){
				    		tabName = getServiceRequestTranslation('EDIT_ENTRY');
				    	}
				    	/**
						 * This is to remove tab from content panel and open
						 * same tab again
						 */
				    	if(infirmaryProfile.down('#studentInfirmaryEditForm'))
				    		{
				    		var tabpanel=infirmaryProfile.down('tabpanel');
				    		infirmaryTab = tabpanel.getActiveTab();
				    		infirmaryTab.close();
				    		
				    		var getActiveTab = this.getActiveTabfromContentPanel();
				    	    var infirmarySearchresultgrid=getActiveTab.down('searchresultgrid');
				    	    
							if(infirmarySearchresultgrid){
								infirmarySearchresultgrid.getStore().load();
							}
				    		
				    		}else{
				    	var getcontroller=this.getController('menu.CoreERPNavigationController');
				    	var getTab=getcontroller.getTab(tabName);
				    	if(getTab!=null){
				    		contentPanel.remove(getTab, true);
				    	}
					}
				    	
				    	
					}
				}
			});
		} catch (e) {
			Ext.getBody().unmask();
			console.log(e);
		}
    },
    getDocumentController: function() {
        var this$ = this;
        return this$.getController('Academia.controller.document.DocumentController');
    },
    getIdValueJson: function(id, value) {
        if (id)
            return {
                id: id,
                value: value
            };
    },
    deleteDocumentFromGrid: function(gridFrom) {
        var $this = this;
        var grid;
        if (gridFrom == 'GridOnForm') {
             var getActiveTab = $this.getActiveTabfromContentPanel();
	         var grid=getActiveTab.down('infirmarydetaildocumentgrid');
        } else if (gridFrom == 'GridOnPopup') {
            grid = $this.getInfirmarydetaildocumentgridonpopup();
        }
        var serverURL = SERVERURL.INFIRMARY_DETAILS_DOCUMENT_DELETE;
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            var ids = [];
            Ext.Array.each(records, function(value) {
            	if (!isNullOrEmpty(value.data.id)) {
            		ids.push(value.data.id);
            	}
            });
            showConfirmMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var store = grid.getStore();
                    Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    if (!isNullOrEmpty(ids) && ids.length > 0) {
                        Ext.Ajax.request({
                            method: "DELETE",
                            type: 'rest',
                            url: serverURL + '?ids=' + ids,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function(form, action) {
                                Ext.getBody().unmask();
                                store.reload();
                                showSuccessMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'), getServiceRequestTranslation('INFIRMARY_DOCUMENT_DELETED_SUCCESS_MSG'));
                            }
                        });
                    } else {
                        var record = grid.getSelectionModel().getSelection()[0];
                        if (record) {
                            store.remove(record);
                            grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());
                        }
                        Ext.getBody().unmask();
                    }
                }
            });
        } else {
            showWarningMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    downloadInfirmaryDetailDocumentZip: function() {
        var $this = this;
        var grid = $this.getInfirmarydetaildocumentgridonpopup();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            var dispatchZipName = getServiceRequestTranslation('INFIRMARY_DETAILS_DOCUMENTS_DOWNLOAD_ALL_ZIP_FILE_NAME');
            var saveModel = [];
            for (var i in records) {
                if (!isNullOrEmpty(records[i].get('path'))) {
                    saveModel.push(records[i].get('path'));
                }
                showConfirmMessage(getServiceRequestTranslation('INFIRMARY_DETAILS_DOCUMENTS'),
                    getServiceRequestTranslation('INFIRMARY_DETAILS_DOCUMENTS_DOWNLOAD_ALL_ALERT'),
                    function(btn, text) {
                        if (btn == 'yes') {
                            var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
                            $this.getDocumentController()
                                .downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
                        }
                    });
            }
        } else {
            $this.hideWindowMask();
            showWarningMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    addInfirmaryEntryForStudentProfile: function(btnaction){
    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var structure = Ext.widget('infirmaryeditform');
    	structure.config.action = btnaction;
    	var tabName = getServiceRequestTranslation('ADD_ENTRY');
    	if(btnaction == "edit"){
    		tabName = getServiceRequestTranslation('EDIT_ENTRY');
    	} else if(btnaction == "view"){
    		tabName = getServiceRequestTranslation('VIEW_ENTRY');
    	}
    	
    	var personController = this.getController('Academia.controller.personinfo.common.PersonCommonController');
    	if(portalId ==1){
    		var studentProfileTab = personController.getContentPanelActiveTab();
    		var personInfoPanelTab = studentProfileTab.down('personinfopanel');
    		var nTab = personInfoPanelTab.items.findBy( function(tab) {
    			if(tab.title == 'Edit Entry'){
    				return true;
    			}else if(tab.title == 'View Entry'){
    				return true;
    			}else if(tab.title == 'Add Entry'){
    				return true;
    			}else{
    				return false;
    			}
    		});
    		if(nTab){
    			nTab.close();
    		}
    	}
    	var getActiveTab = this.getActiveTabfromContentPanel();
    	var infirmarySearchresultgrid=getActiveTab.down('searchresultgrid');
    	var selectedRec = infirmarySearchresultgrid.getSelectionModel().getSelection();
    	var selectedRecord = selectedRec[0];
    	/**
    	 * This is to remove tab from content panel and open same tab again
    	 */

    	if((btnaction == "edit" || btnaction == "view") && selectedRec.length == 1){
    		try{
    			if(portalId == 3 || portalId == 7){
               	 var getcontroller = this.getController('menu.CoreERPNavigationController');
               	 var getTab = getcontroller.getTab(tabName);
               	 if (getTab != null) {
               		 contentPanel.remove(getTab, true);
               	 }
               	 openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_SEVEN);
    			}else{
    				personType='STUDENT';
        			tabPanelTitle= tabName;
        			tabPanelItemId= 'studentInfirmaryEditFormDetails';
        			tabPanelItemXtype = 'infirmaryeditform';
        			xtypeItemId = 'studentInfirmaryEditForm';
        			defaultPanel= true;
        			personController.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);	
    			}
    			var getActiveTab = this.getActiveTabfromContentPanel();
    			var infirmaryaddentrygrid=getActiveTab.down('infirmaryaddentrygrid');
    			Ext.Ajax.request({
    				method: "GET",
    				type: 'rest',
    				scope:this,
    				url: SERVERURL.FIND_INFIRMARY__PARENT_DETAIL_BYID,
    				params:{
    					id:selectedRecord.get('ID')
    				},
    				callback: function(response, action,resText) {
    					var formData = Ext.decode(resText.responseText);

    					formData['timeIn'] = timeRender(formData.timeIn);
    					formData['timeOut'] = timeRender(formData.timeOut);
    					var infirmaryProfile = this.getActiveTabfromContentPanel();
    					var infirmaryPanel = infirmaryProfile.down('infirmaryeditform');

    					var doctor_name_infirmarycombo = infirmaryPanel.down('#doctorUserId');
    					var doctorStore = doctor_name_infirmarycombo.getStore();

    					doctorStore.getProxy().extraParams = {
    						academyLocationId:formData.academyLocationId,
    						roleName: 'DOCTOR'
    					};
    					doctorStore.load({
    						callback: function(){
    							if(!isNullOrEmpty(formData.doctorUserId))
    								doctor_name_infirmarycombo.setValue(formData.doctorUserId);
    						}
    					});


    					var userGroupIdComboField = infirmaryPanel.down('#userGroupId');
    					var userGroupIdComboFieldStore = userGroupIdComboField.getStore();

    					userGroupIdComboFieldStore.load({
    						callback:function(records,response,success){
    							for(var i in records){
    								if(formData.userGroupId==records[i].data.id){
    									userGroupIdComboField.setValue(formData.userGroupId);
    								}
    							}
    						}
    					});
    					userGroupIdComboField.setReadOnly(true);

    					var infirmaryReasonCombo=infirmaryPanel.down('#infirmaryReasonId');
    					var infirmaryReasonComboStore=infirmaryReasonCombo.getStore();

    					infirmaryReasonComboStore.load({
    						callback : function(record,	operation, success) {
    							if (success) {
    								if(!isNullOrEmpty(formData.infirmaryReasonId)){
    									infirmaryReasonCombo.setValue(formData.infirmaryReasonId);
    								}
    							}
    						}
    					});
    					var academyLocationId = this.getCurrentAcademyLocation();

    					var academyLocation_infirmarycombo = infirmaryPanel.getForm().findField('academyLocationId');
    					var academyLocationStore = academyLocation_infirmarycombo.getStore();
    					academyLocationStore.getProxy().extraParams = {
    						id: this.getCurrentlyLoggedInUser().id
    					};

    					academyLocationStore.load({
    						callback: function(records, operation, success) {
    							academyLocation_infirmarycombo.setValue(academyLocationId);
    						}	   
    					});
    					academyLocation_infirmarycombo.setReadOnly(true);

    					var infirmaryOutcomeItemId=infirmaryPanel.down('#infirmaryOutcomeItemId');
    					if (!isNullOrEmpty(formData.infirmaryOutcome) && !isNullOrEmpty(formData.infirmaryOutcome.id)) {
    						infirmaryOutcomeItemId.getStore().load({
    							callback: function(records, operation, success) {
    								infirmaryOutcomeItemId.setValue(formData.infirmaryOutcome.id);
    							}
    						});
    					}

    					if(formData.whetherAuthorityInformed){
    						var authorityUserCombo = infirmaryPanel.down('#authorityUserId');
    						var authorityUserComboStore = authorityUserCombo.getStore();

    						authorityUserCombo.setDisabled(false);
    						authorityUserComboStore.getProxy().extraParams = {
    							academyLocationId:formData.academyLocationId
    						};
    						authorityUserComboStore.load({
    							scope:this,
    							callback: function(){
    								if(!isNullOrEmpty(formData.authorityUserId))
    									authorityUserCombo.setValue(formData.authorityUserId);
    							}
    						});
    					} else {
    						var authorityUserCombo = infirmaryPanel.down('#authorityUserId');
    						authorityUserCombo.setDisabled(true);
    					}


    					var programCombo = infirmaryPanel.getForm().findField('programId');
    					var programComboStore = programCombo.getStore();
    					programComboStore.getProxy().extraParams = {
    						academyLocationId:academyLocationId
    					};
    					programComboStore.load();
    					programCombo.setReadOnly(true);
    					var batchNameCombo = infirmaryPanel.getForm().findField('batchId');
    					var periodNameCombo = infirmaryPanel.getForm().findField('periodId');
    					var sectionNameCombo = infirmaryPanel.getForm().findField('sectionId');
    					sectionNameCombo.emptyText=' ';


    					var studentprogramComboStore = programCombo.getStore();
    					var studentbatchNameComboStore = batchNameCombo.getStore();
    					var studentperiodNameComboStore = periodNameCombo.getStore();
    					var studentsectionNameComboStore = sectionNameCombo.getStore();
    					if(portalId == 3 || portalId == 7)
    					{
    						var documentUploadItemId = infirmaryPanel.down('#documentUploadItemId');
    						documentUploadItemId.setVisible(false);
    						id = this.getCurrentlyLoggedInUser().id;

    					}else
    					{
    						id = infirmaryProfile.getUserId();
    					}
    					Ext.Ajax.request({
    						type: 'rest',
    						url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+id,
    						method: 'GET',
    						async: false,
    						success: function(res, action) {
    							var data = Ext.decode(res.responseText);

    							studentprogramComboStore.load({
    								async:false,
    								callback: function(){
    									if(!isNullOrEmpty(data[0].programBatchDetails.programId))
    										programCombo.setValue(data[0].programBatchDetails.programId);
    								}
    							});
    							studentbatchNameComboStore.getProxy().extraParams = {
    		                         programId:data[0].programBatchDetails.programId
    		                     };
    							studentbatchNameComboStore.load({
    								async:false,
    								callback: function(){
    									if(!isNullOrEmpty(data[0].programBatchDetails.batchId))
    										batchNameCombo.setValue(data[0].programBatchDetails.batchId);
    								}
    							});
    							studentperiodNameComboStore.getProxy().extraParams = {
    		                        id: data[0].programBatchDetails.batchId
    		                    };
    							studentperiodNameComboStore.load({
    								async:false,
    								callback: function(){
    									Ext.getBody().unmask();
    									if(!isNullOrEmpty(data[0].programBatchDetails.periodId))
    										periodNameCombo.setValue(data[0].programBatchDetails.periodId);
    								}
    							});
    							studentsectionNameComboStore.getProxy().extraParams = {
    		                        periodId: data[0].programBatchDetails.periodId
    		                    };
    							studentsectionNameComboStore.load({
    								async:false,
    								callback: function(){
    									Ext.getBody().unmask();
    									if(!isNullOrEmpty(data[0].programBatchDetails.sectionId))
    										sectionNameCombo.setValue(data[0].programBatchDetails.sectionId);
    								}
    							});
    						}
    					});
    					batchNameCombo.setDisabled(false);
    					batchNameCombo.setReadOnly(true);

    					periodNameCombo.setDisabled(false);
    					periodNameCombo.setReadOnly(true);

    					sectionNameCombo.setDisabled(false);
    					sectionNameCombo.setReadOnly(true);

    					infirmaryPanel.getForm().setValues(formData);
    					infirmaryPanel.getForm().findField('infirmaryDate').setValue(dateRender(formData.infirmaryDate));
    					infirmaryPanel.getForm().findField('whetherAuthorityInformed').setValue(formData.whetherAuthorityInformed);
    					infirmaryPanel.getForm().findField('whetherParentInformed').setValue(formData.whetherParentInformed);

    					var userStudentComboField = infirmaryPanel.down('#user_studentname_infirmarycombo');
    					var userStudentComboFieldStore = userStudentComboField.getStore();


    					userStudentComboFieldStore.getProxy().extraParams = {
    						academyLocationId: formData.academyLocationId
    					};
    					userStudentComboFieldStore.load({
    						callback:function(records,response,success){
    							userStudentComboField.setValue(formData.userId);
    						}
    					});

    					userStudentComboField.setDisabled(false);
    					userStudentComboField.setReadOnly(true);

    					var parentUserCombo = infirmaryPanel.down('#parentUserId');
    					var parentUserComboStore = parentUserCombo.getStore();
    					if(formData.whetherParentInformed){
    						parentUserCombo.setDisabled(false);
    						var personparentIds=[];
	    					parentUserComboStore.load({
	    						scope:this,
	    						callback: function(){
	    							parentUserComboStore.getProxy().extraParams = {
	    	    						personId:formData.userId
	    	    					};
	    							if(!isNullOrEmpty(formData.personparentIds)){
	                                    for(var i in formData.personparentIds){
	  								  personparentIds.push(formData.personparentIds[i].personIds.id);
	  						       }
	  							parentUserCombo.setValue(personparentIds);
	    							
	    							}
	    						}
	    					});
    					} else {
    						parentUserCombo.setDisabled(true);
    					}

    					parentUserComboStore.getProxy().extraParams = {
    						personId:formData.userId
    					};
    				
                        var infirmaryAddEntryGridStore = infirmaryaddentrygrid.getStore();
    					infirmaryAddEntryGridStore.loadData(formData.infirmaryMedicineDetails);
    					model = infirmaryAddEntryGridStore.getRange();

    					var getActiveTab = this.getActiveTabfromContentPanel();
    					var docStoreGrid=getActiveTab.down('infirmarydetaildocumentgrid');
    					var docStore = docStoreGrid.getStore();
    					docStore.getProxy().extraParams = {
    						infirmaryDetailId: formData.id
    					};
    					docStore.load();
    					if(portalId == 3 || portalId == 7)
    					{
    						docStoreGrid.down('#btnDelete').setVisible(false);
    					}
    					if(btnaction == 'edit'){
    						for(var i in model){
    							var serialNo = parseInt(i)+1;
    							model[i].set('addButton', true);
    							model[i].set('serialNo', serialNo);
    							model[i].set('isEditable', true);
    							if(i>0)
    								model[i].set('deleteButton', true);
    							else
    								model[i].set('deleteButton', false);
    						}
    						infirmaryPanel.down('button[itemId=resetBtnForm]').setVisible(false);
    					} else if(btnaction == 'view'){
    						var fieldItems = infirmaryPanel.getForm().getFields().items;
    						for(i in fieldItems){
    							fieldItems[i].setReadOnly(true);
    						}
    						infirmaryPanel.down('button[itemId=submitBtn]').setVisible(false);
    						infirmaryPanel.down('button[itemId=resetBtnForm]').setVisible(false);
    						infirmaryPanel.down('button[itemId=documentUploadItemId]').setVisible(false);
    						var grid=getActiveTab.down('infirmarydetaildocumentgrid');
    						grid.down('#btnDelete').setVisible(false);
    						for(var i in model){
    							var serialNo = parseInt(i)+1;
    							model[i].set('addButton', false);
    							model[i].set('serialNo', serialNo);
    							model[i].set('deleteButton', false);
    							model[i].set('isEditable', false);
    						}
    						infirmaryaddentrygrid.columnManager.columns.forEach(function(obj){
    							if(obj.dataIndex == 'addButton' || obj.dataIndex == 'deleteButton'){
    								obj.destroy();
    							}
    						});
    						infirmaryaddentrygrid.reconfigure();
    					}
    				}
    			});
    		}
    		catch(e){
    			console.log(e);
    			Ext.getBody().unmask();
    		}

    	} else if(btnaction == "add"){
    		var academyLocationId = this.getCurrentAcademyLocation();

    		personType='STUDENT';
    		tabPanelTitle= tabName;
    		tabPanelItemId= 'studentInfirmaryEditFormDetails';
    		tabPanelItemXtype = 'infirmaryeditform';
    		xtypeItemId = 'studentInfirmaryEditForm';
    		defaultPanel= true;
    		personController.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
    		var getActiveTab = this.getActiveTabfromContentPanel();
    		var infirmaryaddentrygrid=getActiveTab.down('infirmaryaddentrygrid');
    		var infirmaryProfile = this.getActiveTabfromContentPanel();
    		var infirmaryPanel = infirmaryProfile.down('infirmaryeditform');
    		infirmaryPanel.getForm().findField('id').setValue(null);
    		infirmaryPanel.getForm().findField('academyLocationId').setValue(academyLocationId);
    		infirmaryPanel.getForm().findField('infirmaryDate').setValue(new Date());
    		infirmaryPanel.getForm().findField('userGroupId').setValue(3);
    		infirmaryPanel.getForm().findField('userGroupId').setReadOnly(true);
    		var doctor_name_infirmarycombo = infirmaryPanel.down('#doctorUserId');
    		infirmaryPanel.down('button[itemId=resetBtnForm]').setVisible(false);

    		var academyLocationId = this.getCurrentAcademyLocation();

    		var academyLocation_infirmarycombo = infirmaryPanel.getForm().findField('academyLocationId');
    		var academyLocationStore = academyLocation_infirmarycombo.getStore();
    		academyLocationStore.getProxy().extraParams = {
    			id: this.getCurrentlyLoggedInUser().id
    		};

    		academyLocationStore.load({
    			callback: function(records, operation, success) {
    				academyLocation_infirmarycombo.setValue(academyLocationId);
    			}	   
    		});
    		academyLocation_infirmarycombo.setReadOnly(true);
    		var doctorStore = doctor_name_infirmarycombo.getStore();
    		doctorStore.getProxy().extraParams = {
    			academyLocationId:academyLocationId,
    			roleName: 'DOCTOR'
    		};
    		doctorStore.load({
    			scope:this,
    			callback: function(rec, callback){
    				var currentUserId = this.getCurrentlyLoggedInUser().id;
    				var index = doctor_name_infirmarycombo.getStore().find('id',currentUserId);
    				if(index != -1)
    					doctor_name_infirmarycombo.setValue(currentUserId);
    			}
    		});

    		var authorityUserCombo = infirmaryPanel.down('#authorityUserId');
    		
    		var parentUserCombo = infirmaryPanel.down('#parentUserId');
    		var parentUserComboStore = parentUserCombo.getStore();

    		parentUserComboStore.getProxy().extraParams = {
    			personId:infirmaryProfile.getUserId()
    		};
    		parentUserComboStore.load();
    		parentUserCombo.setDisabled(true)

    		var authorityUserComboStore = authorityUserCombo.getStore();

    		authorityUserCombo.setDisabled(true);
    		authorityUserComboStore.getProxy().extraParams = {
    			academyLocationId: academyLocationId
    		};
    		authorityUserComboStore.load();

    		var userStudentCombo = infirmaryPanel.getForm().findField('userId');
    		var userStudentComboStore = userStudentCombo.getStore();
    		userStudentComboStore.getProxy().extraParams = {
    			academyLocationId: academyLocationId
    		};
    		userStudentComboStore.load({
    			async:false,
    			callback: function(){
    				Ext.getBody().unmask();
    				if(!isNullOrEmpty(infirmaryProfile.getUserId()))
    					userStudentCombo.setValue(infirmaryProfile.getUserId());
    			}
    		});

    		var programCombo = infirmaryPanel.getForm().findField('programId');
    		var programComboStore = programCombo.getStore();
    		programComboStore.getProxy().extraParams = {
    			academyLocationId:academyLocationId
    		};
    		programComboStore.load();
    		programCombo.setReadOnly(true);
    		var batchNameCombo = infirmaryPanel.getForm().findField('batchId');
    		var periodNameCombo = infirmaryPanel.getForm().findField('periodId');
    		var sectionNameCombo = infirmaryPanel.getForm().findField('sectionId');
    		sectionNameCombo.emptyText=' ';

    		var studentprogramComboStore = programCombo.getStore();
    		var studentbatchNameComboStore = batchNameCombo.getStore();
    		var studentperiodNameComboStore = periodNameCombo.getStore();
    		var studentsectionNameComboStore = sectionNameCombo.getStore();

    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+infirmaryProfile.getUserId(),
    			method: 'GET',
    			async: false,
    			success: function(res, action) {
    				var data = Ext.decode(res.responseText);

    				studentprogramComboStore.load({
    					callback: function(){
    						if(!isNullOrEmpty(data[0].programBatchDetails.programId))
    							programCombo.setValue(data[0].programBatchDetails.programId);
    					}
    				});
    				
    				studentbatchNameComboStore.getProxy().extraParams = {
                         programId:data[0].programBatchDetails.programId
                     };
    				studentbatchNameComboStore.load({
    					callback: function(){
    						if(!isNullOrEmpty(data[0].programBatchDetails.batchId))
    							batchNameCombo.setValue(data[0].programBatchDetails.batchId);
    					}
    				});
    				studentperiodNameComboStore.getProxy().extraParams = {
                        id: data[0].programBatchDetails.batchId
                    };
    				studentperiodNameComboStore.load({
    					callback: function(){
    						Ext.getBody().unmask();
    						if(!isNullOrEmpty(data[0].programBatchDetails.periodId))
    							periodNameCombo.setValue(data[0].programBatchDetails.periodId);
    					}
    				});
    				studentsectionNameComboStore.getProxy().extraParams = {
                        periodId: data[0].programBatchDetails.periodId
                    };
    				studentsectionNameComboStore.load({
    					callback: function(){
    						Ext.getBody().unmask();
    						if(!isNullOrEmpty(data[0].programBatchDetails.sectionId))
    							sectionNameCombo.setValue(data[0].programBatchDetails.sectionId);
    					}
    				});
    			}
    		});
    		batchNameCombo.setDisabled(false);
    		batchNameCombo.setReadOnly(true);

    		periodNameCombo.setDisabled(false);
    		periodNameCombo.setReadOnly(true);

    		sectionNameCombo.setDisabled(false);
    		sectionNameCombo.setReadOnly(true);

    		var userStudentComboField = infirmaryPanel.down('#user_studentname_infirmarycombo');
    		userStudentComboField.setDisabled(false);
    		userStudentComboField.setReadOnly(true);

    		infirmaryaddentrygrid.getStore().removeAll();
    		var getActiveTab = this.getActiveTabfromContentPanel();
    		var docStoreGrid=getActiveTab.down('infirmarydetaildocumentgrid');
    		var docStore = docStoreGrid.getStore();

    		docStore.removeAll();
    		docStore.loadData([]);
    		this.addNewRowInGrid(1);
    		Ext.getBody().unmask();
    	} else {
    		if(selectedRec.length > 1){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
    		}
    		else if(selectedRec.length == 0){
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    		}
    		Ext.getBody().unmask();
    	}
    },
    
    exportInfirmaryEntryListForStudentProfile : function(exportUrl,filetype,whetherAll,type) {
    	var getActiveTab = this.getActiveTabfromContentPanel();
    	var searchResultGrid=getActiveTab.down('searchresultgrid');
    	if(type == "INTERVENTION"){
    		searchResultGrid=getActiveTab.down('searchresultgrid#studentInfirmaryManageInterventionGrid');
    	}
    	var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaStringForStudentProfile();
    	var jsonFormatFormData=this.createJsonFormatforStudentProfile();
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('STUDENT_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	createSearchCriteriaStringForStudentProfile: function() {
		var academyLocationId = this.getCurrentAcademyLocation();
		var displayName = this.getAcademyLocationDisplayName(academyLocationId);
		var searchCriteriaString =  'USER_TYPE_ID  : Student ,ACADEMY_LOCATION_ID  :'+displayName;   
        return searchCriteriaString;
    },
    //******************Disable Download button**********************************
    disableDownloadActionPivileges: function(grid,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var btnDelete = grid.down('#btnDelete');
    	var downloadDocumentItemId = grid.down('#downloadDocumentItemId');
    	btnDelete.setVisible(false);
    	downloadDocumentItemId.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'DELETE') {
    			btnDelete.setVisible(true);
    		}
    		if (privilege === 'DOWNLOADALL') {
    			downloadDocumentItemId.setVisible(true);
    		}
    	});
    },
    addEntryForStudentProfileIntervention: function(btnaction){
    	var manageInterventionController = this.getController('Academia.controller.servicerequest.infirmarymanage.ManageInterventionController');
    	manageInterventionController.addInterventionEntryForStudentProfile(btnaction);
    },
    deleteEntryForStudentProfileIntervention:function(){
    	var $this=this;
    	var getActiveTab = this.getActiveTabfromContentPanel();
    	var grid=getActiveTab.down('searchresultgrid#studentInfirmaryManageInterventionGrid');
    	var recordCount = grid.getSelectionModel().getCount();
    	if(recordCount>0){
    		var records = grid.getSelectionModel().getSelection();	
    		var arr = [];
    		for(var i=0;i<records.length;i++)
    		{
    			arr.push(records[i].data.ID);
    		}
    		var ids = arr.join();
    		showConfirmMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn, text) {
    			if (btn == 'yes'){
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.PATH_DELETE_INFIRMARY_MANAGE_ENTRIES_BY_IDS,
    					headers: {
    						'Content-Type': 'application/json'
    					},
    					params: {
    						ids: ids
    					},
    					success: function(form, action) {
    						grid.store.reload();
    						showSuccessMessage(getServiceRequestTranslation('INFIRMARY_MANAGEMENT'), getServiceRequestTranslation('INFIRMARY_DELETED_SUCCESS_MSG'));
    					}
    				});
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
    	}
    }
});
