/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.controller.setup.droolrules.DroolRulesController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : [
		'setup.droolrules.DroolMasterStore',
		'setup.droolrules.ApplyDroolGridStore',
		'setup.droolrules.AcademyLocationDroolMappingList',
		'common.AcademyLocationByName',
		'feeandpayment.ALProgramBatchList',
		'feeandpayment.ALProgramBatchSearchCombo',
		'feeandpayment.ALProgramBatchListForDrool'
	],
	views : [
		'droolmaster.DroolRulesStructure', 
		'droolmaster.ApplyDroolStructure',
		'droolmaster.AddMappingDroolStructure',
		'droolmaster.AddMappingDroolTabs',
		//'feeandpayment.adjustment.AdjustmentProgressTracker',
		//'feeandpayment.AcademyLocationGridWithFeePayment',
		'droolmaster.DroolALMappingGrid',
		//'feeandpayment.AlProgramBatchGrid',
		'droolmaster.DroolALProgramBatchGrid'
	],
	config: {
		DROOL_RULES_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DROOL_RULES_PRIVILEGES')
	},
	refs : [{
		ref: 'contentPanel',
		selector: 'contentPanel'
	},{
		ref: 'droolrulesstructure',
		selector: 'droolrulesstructure'
	},{
		ref: 'applydroolstructure',
		selector: 'applydroolstructure'
	},{
		ref: 'addmappingdroolstructure',
		selector: 'addmappingdroolstructure'
	},{
		ref: 'addmappingdrooltabs',
		selector: 'addmappingdrooltabs'
	},{
		ref: 'adjustmentprogresstracker',
		selector: 'adjustmentprogresstracker'
	},{
		ref: 'academylocationgridwithfeepayment',
		selector: 'academylocationgridwithfeepayment'
	},{
		ref: 'alprogrambatchgrid',
		selector: 'alprogrambatchgrid'
	},{
		ref:'droolalmappinggrid',
		selector: 'droolalmappinggrid'
	},{
		ref:'droolalprogrambatchgrid',
		selector: 'droolalprogrambatchgrid'
	}],
	init : function() {
		this.control({
			'droolrulesstructure grid':{
				afterrender : function(grid){
					grid.getStore().loadPage(1);
					this.disableMoreActionGridPivileges(grid, this.getDROOL_RULES_PRIVILEGES());
				},
				selectionchange: function(grid, selected) {
					grid.view.up().down('#btnApplyToItemId').setDisabled(!selected.length);
				}
			},
			'droolrulesstructure button[itemId=btnApplyToItemId]':{
				click: function(btn){
					var me = this;
					var grid = btn.up('grid');
					var record = grid.getSelectionModel().getSelection()[0];
					
					var droolId = record.get('droolId');
					var droolPrintName = record.get('droolPrintName');
					var droolCode = record.get('droolCode');
					var droolFor = record.get('droolFor');
					
					var contentpanel = me.getContentPanel();
					var applyDroolStructure = Ext.widget('applydroolstructure');
					var tabName = getExaminationTranslation('APPLY_DROOL');
					
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentpanel.remove(getTab, true);
					}
					
					if(contentPanel!=undefined){
				  		var newTab = contentPanel.items.findBy( function(tab) {
				  			return tab.title === tabName;
				  		 });
				  		
				  		if(!newTab){
				  			var newTab = contentPanel.add({
				  				xtype: 'applydroolstructure',
				  				closable:true,										 
				  				title: tabName,
				  				droolId: droolId,
				  				droolPrintName: droolPrintName,
				  				droolCode:droolCode,
				  				droolFor:droolFor,
				  				menuColorCls: CONSTANTS.MENU_COLOR_THIRTEEN
				  			});
				  		}																	
				  		contentPanel.setActiveTab(newTab);
				  		contentPanel.doLayout();		
				  	}
				}
			},
			'applydroolstructure grid':{
				afterrender : function(grid){
					var droolId = grid.up('applydroolstructure').droolId;
					grid.getStore().getProxy().extraParams = {
						droolId: droolId,
						sort:null
					};
					grid.getStore().loadPage(1);
				},
			},
			'applydroolstructure button[itemId=btnAdd]':{
				click: function(btn){
					var me = this;
					var droolId = btn.up('applydroolstructure').droolId;
					var droolPrintName = btn.up('applydroolstructure').droolPrintName;
					var droolCode = btn.up('applydroolstructure').droolCode;
					var droolFor = btn.up('applydroolstructure').droolFor;
					
					var contentpanel = me.getContentPanel();
					var applyDroolStructure = Ext.widget('addmappingdroolstructure');
					var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
					
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentpanel.remove(getTab, true);
					}
					
					if(contentPanel!=undefined){
				  		var newTab = contentPanel.items.findBy( function(tab) {
				  			return tab.title === tabName;
				  		 });
				  		
				  		if(!newTab){
				  			var newTab = contentPanel.add({
				  				xtype: 'addmappingdroolstructure',
				  				closable:true,										 
				  				title: tabName,
				  				droolId: droolId,
				  				droolPrintName: droolPrintName,
				  				menuColorCls: CONSTANTS.MENU_COLOR_THIRTEEN
				  			});
				  		}																	
				  		contentPanel.setActiveTab(newTab);
				  		contentPanel.doLayout();		
				  	}
					
					
					setTimeout(function(){
						var droolNameField = newTab.down('#droolNameField');
						var getDroolId = newTab.down('#droolId');
						var getDroolCode = newTab.down('#droolCode');
						var getDroolFor = newTab.down('#droolFor');
						
						droolNameField.setValue(droolPrintName);
						getDroolId.setValue(droolId);
						getDroolCode.setValue(droolCode);
						getDroolFor.setValue(droolFor);
						var adjustmentprogresstracker = newTab.down("#adjustmentprogresstracker");
						adjustmentprogresstracker.setVisible(true);
						me.resetProgressTracker();
						var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
						progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
						progresstracker1.textEl.addCls("inProgressCss-progress-text");
						progresstracker1.updateText("Step 1 In Progress");
					},500);
				}
			},
			'applydroolstructure button[itemId=btnDelete]':{
				click: function(btn){
					var grid=btn.up().up();
					var records=grid.getSelectionModel().getSelection();
					if(records.length>0){

						var id=grid.getSelectionModel().getSelection()[0].data.id
						showConfirmMessage(getExaminationTranslation('DROOL_MAPPING'), getExaminationTranslation('DELETE_REMARK_CORFIRMATION_MSG'), 
								function(btn, text) {
							if (btn == 'yes') {
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.DELETE_DROOL_BATCH_MAPPING+'?id='+id,
									method: 'DELETE',
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {
										showSuccessMessage(getExaminationTranslation('DROOL_MAPPING'),
												getExaminationTranslation('DROOL_MAPPING_DELETE_SUCCESS_MSG'));
										grid.getStore().load();
									}
								});
							}
						});

					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'droolalmappinggrid':{
				afterrender : function(grid){
					grid.getStore().clearFilter();
					grid.getStore().loadPage(1);
				}
			},
			/*'alprogrambatchgrid':{
				afterrender : function(grid){
					grid.getStore().loadPage(1);
				}
			 },*/
			'droolalmappinggrid button#nextButton':{
				click:function(btn){
					this.academyLocationNextEvent(btn);
				}
			},
			 'droolalprogrambatchgrid button#submitFeeMapping':{
	 			  click:function(btn){
	 				  this.submitDroolBatchMapping(btn);
	 			  }
	 		 },
	 		'droolalmappinggrid customcombobox#academylocationsearchcombo' : {
	 			  select:function(obj, record){
	 				 this.getDroolalmappinggrid().getStore().clearFilter();
	 				 //this.getAcademylocationgridwithfeepayment().getStore().filter('id', record[0].get('id'));
	 				 this.getDroolalmappinggrid().getStore().filter({property: 'id',
						  value: record[0].get('id'),
						  exactMatch: true,
						  caseSensitive: true});
	 			  }
	 		  },
	 		  
	 		 'droolalprogrambatchgrid customcombobox#programbatchsearchcombo' : {
	 			  select:function(obj, record){
	 				 this.getDroolalprogrambatchgrid().getStore().clearFilter();
	 				 //this.getdroolalmappingstructure().getStore().filter('id', record[0].get('id'));
	 				 this.getDroolalprogrambatchgrid().getStore().filter({property: 'batchId',
						  value: record[0].get('id'),
						  exactMatch: true,
						  caseSensitive: true});
	 			  }
	 		  },
	 		  
	 		 
	 		'addmappingdrooltabs button#resetBtn':{
	 			click:function(btn){
	 				var tabStructure = this.getAddmappingdrooltabs();
	 				var activeGrid = tabStructure.getActiveTab().down('grid');
	 				btn.up().up().getSelectionModel().deselectAll()
	 				btn.up().up().getStore().clearFilter();
	 				if(btn.up().up().down('customcombobox'))
	 					btn.up().up().down('customcombobox').reset();
	 				btn.up().up().getStore().load();
	 			}
	 		  },
		});
	},
    setProgressTracker : function(progresstracker){
    	var structure = this.getContentPanel().getActiveTab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");

    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    	}
    	
    },
    resetProgressTracker : function(){
    	var structure = this.getAddmappingdroolstructure();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    },
    academyLocationNextEvent:function(btn){
    	var academylocationgrid = btn.up('droolalmappinggrid');
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
    		var addmappingdrooltabsstructure = this.getContentPanel().getActiveTab().down('addmappingdrooltabs');
    		var droolPrintName=addmappingdrooltabsstructure.down('#droolNameField').getValue();
    		var droolId=addmappingdrooltabsstructure.down('#droolId').getValue();
    		var droolCode=addmappingdrooltabsstructure.down('#droolCode').getValue();
    		var programbatchcontainer = addmappingdrooltabsstructure.down('#programbatchcontainer');
    		programbatchcontainer.setDisabled(false);
    		addmappingdrooltabsstructure.setActiveTab(programbatchcontainer);
    		var alProgramGrid = this.getAddmappingdroolstructure().down('#programbatchcontainer').down('#droolalprogrambatchgrid');
    		programbatchcontainer.down('#droolId').setValue(droolId);
    		programbatchcontainer.down('#droolNameField').setValue(droolPrintName);
    		programbatchcontainer.down('#droolCode').setValue(droolCode);
    		var alProgramSearchCombo = alProgramGrid.down('#programbatchsearchcombo');
    		alProgramSearchCombo.getStore().getProxy().extraParams= {
    			academyLocationIds: academyLocationIdsArr.join()
    		};
    		alProgramSearchCombo.getStore().load();
    		var alProgramGridStore = alProgramGrid.getStore();
    		alProgramGridStore.getProxy().extraParams= {
    			academyLocationIds: academyLocationIdsArr.join()
    		};
    		alProgramGridStore.clearFilter();
    		alProgramGridStore.load();
    		this.setProgressTracker(1);
    		/*if(this.getManageFeePlanList()){
    			var records = this.getManageFeePlanList().getSelectionModel().getSelection()[0];
    			if(records){
    				var structure = this.getAddprogramfeemappingtabstructure();
    				var feePlanName = structure.down('#feePlanMappingName').getValue();
    				feeplanwithprogrambatchseatstructure.down("#feePlanProgramTab").setValue(feePlanName);              	
    			}
    		}*/
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    submitDroolBatchMapping: function(btn){
    	var me=this;
    	var tabStructure = this.getAddmappingdrooltabs();
    	var activeGrid = btn.up().up();
    	var batches = '';
    	var masterGrid=this.getApplydroolstructure().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var droolId = btn.up().up().up().down('#droolId');
    	var droolCode = btn.up().up().up().down('#droolCode').getValue();
    	var droolFor = btn.up().up().up().down('#droolFor').getValue();
    	if(selectedRecord.length>0){
    	if(droolFor == 'SELECTION_STAGE') {
        		var batches = [];
    			   for (var i=0 ; i<selectedRecord.length; i++){
    				   batches.push(selectedRecord[i].data.batchId);
    			}
        		var submitUrl = SERVERURL.PATH_SAVE_ALL_DROOL_BATCH_MAPPING;
        		var alreadySharedBatchIds = [];
    			var notSharedBatchIds = [];
    			var academyLocationId=null;
    			var masterData=null;
    		    Ext.each(selectedRecord, function(currentRecord){
    					notSharedBatchIds.push(currentRecord.get('batchId'));
    			});
        		if(notSharedBatchIds.length>0){
    				var batches = notSharedBatchIds.join(',');
    			}
        		if(notSharedBatchIds.length>0){
    				me.submitShareAjax(droolId,droolCode,academyLocationId,batches,masterGrid);
    			}
    	}else{
        		var batches = [];
    			   for (var i=0 ; i<selectedRecord.length; i++){
    				   batches.push(selectedRecord[i].data.batchId);
    			}
        		var submitUrl = SERVERURL.PATH_SAVE_ALL_DROOL_BATCH_MAPPING;
        		var alreadySharedBatchIds = [];
    			var notSharedBatchIds = [];
    			var masterRecordsMaps = new Ext.util.HashMap();
    			var academyLocationId=null;
    			var masterData=null;
    			if(!isNullOrEmpty(masterGrid.getStore().load().data)){
    				Ext.Ajax.request({
    					   type : 'rest',
    					   url : SERVERURL.FIND_ALL_DROOL_MAPPING_BY_DROOL_ID,
    					   async:false,
    					   params:{
    						   batchIds:batches.join()
    					   },
    					   method : 'GET',
    					   success : function(resp, action) {
    						   var respData = resp.responseText;
    						   masterData=Ext.JSON.decode(respData);
    					   }
    				   });
    			}
    			for(var i=0;i<masterData.length;i++){
    				masterRecordsMaps.add(masterData[i].id,masterData[i].id);
    			}
    		   Ext.each(selectedRecord, function(currentRecord){
    				if(!isNullOrEmpty(currentRecord.get('batchId')) && masterRecordsMaps.containsKey(currentRecord.get('batchId'))){
    					alreadySharedBatchIds.push(currentRecord.get('programName')+'-'+currentRecord.get('batchName'));
    				}
    				else{
    					notSharedBatchIds.push(currentRecord.get('batchId'));
    				}
    			});
    			
        		if(notSharedBatchIds.length>0){
    				var batches = notSharedBatchIds.join(',');
    			}
        		
        		if(alreadySharedBatchIds.length){
    				var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+'Alert'+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+'<b>'+getCommonTranslation('ALREADY_MAPPED_IN_PB')+'</b><br /><div style="overflow-x: hidden;height: 155px;width:330px;overflow-y: auto;">'+alreadySharedBatchIds.join('<br />')+'</div>'+'</span>';
					var box2 =Ext.Msg.show({
					//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
					msg	: msg,
					buttons	: Ext.MessageBox.OK,
					icon: Ext.Msg.INFO,
					cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
					fn	: function(response){
						if(response=="ok"){
							me.mapAlbumMessageCallbackFunction(response,droolId,droolCode,academyLocationId,batches,masterGrid,notSharedBatchIds);
						}
					}
					});
					box2.removeCls('newClsMessageConfirmBox');
					box2.dockedItems.items[1].layout.pack = "end";
					box2.doLayout();
					box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');
    			}
    			else if(notSharedBatchIds.length>0){
    				me.submitShareAjax(droolId,droolCode,academyLocationId,batches,masterGrid);
    			}
        
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    mapAlbumMessageCallbackFunction: function(response,droolId,droolCode,academyLocationId,batches,masterGrid,notSharedBatchIds){
		var me = this;
		if(response=="ok"){
			if(notSharedBatchIds.length>0){
				me.submitShareAjax(droolId,droolCode,academyLocationId,batches,masterGrid);
			}
		}
	},
    
    submitShareAjax: function(droolId,droolCode,academyLocationId,batches,masterGrid){
		var me = this;
		Ext.Ajax.request({
			method : "POST",
			type : 'rest',
			url : SERVERURL.PATH_SAVE_ALL_DROOL_BATCH_MAPPING,
			jsonData : {
				droolId: parseInt(droolId.getValue()),
				academyLocationId: academyLocationId,
				batches: batches,
				droolCode:droolCode
			},
			success : function(f, action) {
				if(f.responseText=="true"){
					masterGrid.getStore().load();
					showSuccessMessage(getExaminationTranslation('DROOL_MAPPING'),getExaminationTranslation('MAPPED_SUCCESSFULLY')); 
					me.getContentPanel().getActiveTab().close();
					var isShareOpened = me.getContentPanel().items.findBy( function(tab) {
						return tab.title === getCommonTranslation('SHARE_ALBUM');
					});
					if(isShareOpened){
						isShareOpened.down('grid').getStore().loadPage(1);
					}
				}
				else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENCY_EXISTS'));
				}
			}
		});
	},
	
	 disableMoreActionGridPivileges: function(grid,permissionsMap) {
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    	var portalId = this.getCurrentLoggedPortalId();
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			//var btnEdit = structure.down('#btnEdit');
	    	var btnApplyToItemId = grid.down('#btnApplyToItemId');
	    	btnApplyToItemId.setVisible(false);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'APPLY_TO') {
	    			btnApplyToItemId.setVisible(true);
	    		}         		
	    	});
	    },
});