Ext.define('Academia.controller.sponsorship.SponsorshipBillingController', {

	extend: 'Academia.controller.base.BaseController',

	views: ['sponsorship.SponsorshipBilling','sponsorship.SponsorshipBillingSearchForm',
	        'sponsorship.SponsorshipBillingGrid','sponsorship.SponsorshipBillingScreen'],

	        stores:['common.AcademyLocationNameSeparated','feeandpayment.reports.Student','sponsorship.SponsorsNameCodeStore','scholarships.TransactionTypes',
	                'sponsorship.SponsoredBillingStudentSearchStore'],
	                refs: [{
	                	ref: 'contentPanel',
	                	selector: 'contentPanel'
	                },{
	                	ref : 'sponsorshipbilling',
	                	selector : 'sponsorshipbilling'
	                }, {
	                	ref : 'sponsorshipBillingForm',
	                	selector : 'sponsorshipbillingsearchform form[itemId=sponsorshipBilling]'
	                }, {
	                	ref : 'sponsorshipbillinggrid',
	                	selector:'sponsorshipbillinggrid'
	                }],
	                config: {
	                	SPONSOR_BILLING_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSOR_BILLING_REPORT_PRIVILEGES')
	                },
	                init: function(application) {
	                	this.control({
	                		'sponsorshipbilling' : {
	                    		tabchange: function(view,newTab,oldtab){
	                    			var master=this.getSponsorshipbilling();
	                    			var advancesearch = master.down('advancedsearchquerybuilder');
	                    			var combo1 = advancesearch.down('#loadSavedSearchComboId');
	                    			combo1.setVisible(false);
	                    		}
	                    	},

	                		'sponsorshipbillinggrid':{
	    		   				 render : function(grid) {
	    			                	this.doAccessControlValidation(grid, this.getSPONSOR_BILLING_REPORT_PERMISSIONS());
	    		   				 },
	    		   				afterrender:function(grid){
	    		   						var me = this;
	    		   						setTimeout(function(){
	    		   						me.addDataGridConfigButton(grid,me.getSPONSOR_BILLING_REPORT_PERMISSIONS());
	    		   						},1500);
	    		   				}
	                		},
	                		
	                		'sponsorshipbillingsearchform form[itemId=sponsorshipBilling] button[itemId=sponsorshipBillSearchBtn]' : {
	                			click : this.loadSponsorBillingSearchGridUsers
	                		},
	            			'sponsorshipbillingsearchform form[itemId=sponsorshipBilling] button[itemId=resetButtonId]' : {
	           				 click: function(button, eOpts) {
	           	                	var form = this.getSponsorshipBillingForm();
	           	                	form.getForm().reset();
	           	                	var academyLocation = form.down('#academyLocationId');
	           						academyLocation.onTrigger1Click();
	           						var studentId = form.down('combo[name=STUDENT_ID]');
	           						studentId.setDisabled(true);
	           	                	
	           	                }
	           		    	},
	                		'sponsorshipbillingsearchform form[itemId=sponsorshipBilling] multiselectcombofield[itemId=academyLocationId]' : {
	                			change:function(obj,rec){
	                				var $this = this;
	                				var form = $this.getSponsorshipBillingForm().getForm();
	                				var studentId = form.findField('STUDENT_ID');
	                				if(rec.length>0){
	                					if(!isNullOrEmpty(rec) && typeof rec[0] !='object') {
	                						studentId.setDisabled(false);
	                						var academyLocations=[];
	                						if(rec.length > 0){
	                							academyLocations.push(rec);
	                						}
	                						studentId.getStore().getProxy().extraParams = {
	                							academyLocationIds:academyLocations.join()
	                						};
	                						studentId.getStore().load();
	                					}
	                				}else{
	                					studentId.reset();
	                					studentId.setDisabled(true);}
	                			}
	                		//select : this.loadLocationComboStore
	                		},

	                	});
	                },
	                
	                addContentPanelTab: function(tabTitle, contentXtype,closable,sponsorId) 
	                {
	                
	                	this.loadContollers(contentXtype);
	                	
	                	var $this=this;
	                	
	                	if(isNullOrEmpty(closable)){
	                		closable = true;
	                	}
	                	
	                    var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                    var newTab = this.getTabReferenceByTabTitle(tabTitle);
	                    if (!newTab) {
	                        newTab = contentPanel.add({
	                            xtype: contentXtype,
	                            closable: closable,
	                            title: tabTitle,
	                            menuColorCls:CONSTANTS.MENU_COLOR_SEVEN
	                        });
	                    }
	                    
	                    var form = this.getSponsorshipBillingForm();
                		var sponsorCombo = form.down('#sponMaster_sponId');
                		sponsorCombo.getStore().load({
       					 callback: function(records, operation, success) {
       						 for(var i in records){
       							 if(records[i].data.id==sponsorId){
       								 sponsorCombo.setValue(records[i].data.id);
       							 }
       						 }
      	                    $this.loadSponsorBillingSearchGridUsers();
       					 }
       				 });
	                    contentPanel.setActiveTab(newTab);
	                },
	                
	                loadSponsorBillingSearchGridUsers: function(model, records) {
	                	var $this=this;
	                	var form = $this.getSponsorshipBillingForm();
	                	var studentId = form.down("#sponBill_studId").getValue();
	                	var sponsorId = form.down("#sponMaster_sponId").getValue();
	                	var academyLocationId = form.down("#academyLocationId").getValue();
	                	var fromDateFormat = form.down("#fromDate").getValue();
	                	if(fromDateFormat){
	                	var fromDate = Ext.Date.format(new Date(fromDateFormat), 'Y-m-d');
	                	}
	                	var toDateFormat = form.down("#toDate").getValue();
	                	if(toDateFormat){
	                	var toDate = Ext.Date.format(new Date(toDateFormat), 'Y-m-d');
	                	}
	                	var searchJson=[];
	                	for(var i in academyLocationId){
	                		if(Ext.isObject(academyLocationId[i])){
	                			searchJson.push(academyLocationId[i].data.id);
	                		}else{
	                			searchJson.push(academyLocationId[i]);
	                		}
	                	}
	                	academyLocationIds=searchJson.join();
	                	var grid = $this.getSponsorshipbillinggrid();
	                	var store =  grid.getStore();
	                	store.getProxy().extraParams = {
	                		sponsorId: sponsorId,
	                		academyLocationIds: academyLocationIds,
	                		studentId: studentId,
	                		billingFromDate:fromDate,
	                		billingToDate:toDate

	                	};
	                	//$this.resetPageSetting(store);
	                	// store.load();
	                	store.load();
	                },
});
