/**
 * @author Vishal Joshi
 */
Ext.define('Academia.controller.student.report.StudentTransferReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['student.report.StudentTransferReportGridStore','common.ProgramByAcademyLocationStore',
	          'feeandpayment.managebill.Student','student.report.ServiceRequestTypeStore',
	          'attendance.StudentCourses','enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.SectionAndFacultyByPeriodID','coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore','organization.academylocations.AcademyLocationStore',
	          'program.ProgramGroupStore','student.report.StudentALTransferReportGridStore','student.report.StudentSearchServiceRequest','feeandpayment.reports.Program',
	          'common.AcademyLocationNameSeparated','Academia.store.user.UserAcademyLocationStore'],
	views : ['student.report.StudentTransferReportTabStructure','student.report.StudentTransferReportStructure',
	         'student.report.StudentTransferReportFilter','student.report.StudentTransferReportGrid',
	         'student.report.StudentALTransferReportGrid'],
	config:{
		STUDENT_TRANSFER_REPORTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TRANSFER_REPORTS_PRIVILEGES')
	},	         
	refs : [
	        {
	        	ref : 'studenttransferreportstructure',
	        	selector : 'studenttransferreportstructure'
	        },{
	        	ref : 'studenttransferreportfilter',
	        	selector : 'studenttransferreportfilter'
	        },{
	        	ref: 'studenttransferreportgrid',
	        	selector: 'studenttransferreportgrid'
	        },{
	        	ref: 'contentPanel',
	        	selector: 'contentPanel'
	        },{
	        	ref: 'studentaltransferreportgrid',
	        	selector: 'studentaltransferreportgrid'
	        }],
	        init : function() {
	        	this.control({
	        		'studenttransferreportfilter button[itemId=searchBtn]': {
	        			click: this.loadStudentTransferReportGrid
	        		},
	        		'studenttransferreportfilter button[itemId=resetBtn]': {
	        			click: this.resetStudentTransferReportFilter
	        		},
	        		'studenttransferreportfilter combo[itemId=requestTypeId]': {
	        			afterrender: this.setStudentTransferDefault,
	        			change: this.selectRequestType
	        		},
	        		'studenttransferreportfilter combo[itemId=Program_Group]': {
	        			select: this.selectProgramGroup
	        		},
	        		'studenttransferreportfilter combo[itemId=programId]': {
	        			afterrender: this.setAcademyLocationIdToProgram,
	        			select: this.selectProgram
	        		},
	        		'studenttransferreportfilter combo[itemId=batchId]': {
	        			select: this.selectBatch
	        		},
	        		'studenttransferreportfilter combo[itemId=periodId]': {
	        			select: this.selectPeriod
	        		},
	        		'studenttransferreportgrid': {
	        			render: function(grid) {
	        				this.doAccessControlValidation(grid, this.getSTUDENT_TRANSFER_REPORTS_PERMISSIONS());
	        			}
	        		},
	        		'studenttransferreportfilter customcombobox[itemId=student]': {
	        			select: this.selectProgramBatchAuto
	        		},
	        		'studentaltransferreportgrid': {
	        			render: function(grid) {
	        				this.doAccessControlValidation(grid, this.getSTUDENT_TRANSFER_REPORTS_PERMISSIONS());
	        			},
	        		   afterrender:function(grid){
 	   				        var me = this;
 	   				        setTimeout(function(){
 	   					        me.addDataGridConfigButton(grid, me.getSTUDENT_TRANSFER_REPORTS_PERMISSIONS());
 	   				        },1500);
 			           }
	        		}
	        	});
	        },

	        loadStudentTransferReportGrid:function(){
	        	var $this=this;
	        	var grid = $this.getStudenttransferreportgrid();
	        	var gridAL = $this.getStudentaltransferreportgrid();
	        	var form = $this.getStudenttransferreportfilter();
	        	var filter = form.getForm();
	        	form.down('#searchBtn').setDisabled(true);
	        	var formValue = filter.getValues();
	        	var status =filter.findField("STATUS").getValue();
	        	if(status != null){
	        		
            	var checkStatus = null;
            
            	if(status){
            		checkStatus='true';
            	}
            	else{
            		checkStatus='false';
            	}
	        	}
	        	var toAcademyLocationData=[];
	        	if(formValue.toALId !="" && formValue.toALId !=null){
	    			for(var i in formValue.toALId){
	    				if(Ext.isObject(formValue.toALId[i])&& !isNullOrEmpty(formValue.toALId[i])){
	    					al = formValue.toALId[i].get("id");
	    					toAcademyLocationData.push(al);
	    				}else{
	    					if(!isNullOrEmpty(formValue.toALId[i])){
	    					al = formValue.toALId[i];
	    					toAcademyLocationData.push(al);
	    					}
	    				}
	    			}
	    		}	
	        	var fromAcademyLocationData=[];
	        	if(formValue.fromAl !="" && formValue.fromAl !=null){
	    			for(var i in formValue.fromAl){
	    				if(Ext.isObject(formValue.fromAl[i])&& !isNullOrEmpty(formValue.fromAl[i])){
	    					al = formValue.fromAl[i].get("id");
	    					fromAcademyLocationData.push(al);
	    				}else{
	    					if(!isNullOrEmpty(formValue.fromAl[i])){
	    					al = formValue.fromAl[i];
	    					fromAcademyLocationData.push(al);
	    					}
	    				}
	    			}
	    		}	
	        	if(!grid.isHidden())
	        	{
	        		var store = grid.getStore();
		        	store.getProxy().extraParams = {
		        		studentId : formValue.student,
		        		requestTypeId : formValue.requestTypeId,
		        		programId : formValue.programId,
		        		courseId : formValue.courseId,
		        		batchId : formValue.batchId,
		        		periodId : formValue.periodId, 
		        		sectionId : formValue.sectionId,
		        		fromDate : formValue.startDate, 
		        		toDate : formValue.endDate,
		        		status:checkStatus
		        	}
	        	}else{
	        		var store = gridAL.getStore();
		        	store.getProxy().extraParams = {
		        		studentId : formValue.student,
		        		requestTypeId : formValue.requestTypeId,
		        		programGroup : formValue.programGroup,
		        		programId : formValue.programId,
		        		batchId : formValue.batchId,
		        		fromDate : formValue.startDate, 
		        		toDate : formValue.endDate,
		        		toAl : toAcademyLocationData.join(),
		        		status:checkStatus,
		        		fromAl:fromAcademyLocationData.join()
		        	}
	        		
	        	}	
	        	$this.resetPageSetting(store);
	        	store.load({
					 callback: function(records, operation, success) {
						 form.down('#searchBtn').setDisabled(false); 
					 }	
				 });
	        	grid.config.searchFilterForm = $this.getStudenttransferreportfilter();
	        	gridAL.config.searchFilterForm = $this.getStudenttransferreportfilter();

	        }, 
	        
	        
	        resetStudentTransferReportFilter:function(){
	        	 var $this=this;
	        	 var form = this.getStudenttransferreportfilter();
	        	 
	        	 var program = form.down('#programId');
	        	 var course = form.down('#courseId');
	        	 var batch = form.down('#batchId');
	        	 var period = form.down('#periodId');
	        	 var student = form.down('#student');
	        	 var section = form.down('#sectionId');
	        	 var programGroup = form.down('#Program_Group');
	        	 var toALId = form.down('#toAcademyLocationItemId');
	        	 var startDateFrom = form.down('#startDate');
	 			 var endDateTo = form.down('#endDate');
	 			 var status = form.down('#status');
	 			var fromAl = form.down('#fromAl');

	        	 program.reset();
	        	 course.reset();
	        	 batch.reset();
	        	 period.reset();
	        	 section.reset();
	        	 toALId.reset();
	        	 student.reset();
	        	 programGroup.reset();
	        	 startDateFrom.reset();
	        	 endDateTo.reset();
	        	 status.reset();
	        	 status.setReadOnly(false);
	        	 batch.setDisabled(true);
	        	 fromAl.reset();
	        	 var requestTypeId = form.getForm().findField('requestTypeId');
	        	 var searchBtn = form.down('#searchBtn');
	        	 var requestTypeFieldStore = requestTypeId.getStore();
	        	 requestTypeFieldStore.load({
					 callback: function(records, operation, success) {
						   for(var i in records){
							   if(records[i].data.value=='Student Transfer'){
								   requestTypeId.setValue(records[i].data.id);
								   searchBtn.setDisabled(false);
							   }
						   }
					   }	
				 });
	        	 
	        	var programGroupCombo = form.getForm().findField('programGroup');
 				programGroupCombo.setReadOnly(false);
 				var programIdCombo = form.getForm().findField('programId');
 				programIdCombo.setReadOnly(false);
 				programIdCombo.clearValue();
 				$this.setAcademyLocationIdToProgramFilter();
 				var batchIdCombo = form.getForm().findField('batchId');
 				batchIdCombo.setReadOnly(false);
 				var startDateFrom = form.getForm().findField('startDate');
 				var endDateTo = form.getForm().findField('endDate');
 				startDateFrom.setMaxValue(false);
 				startDateFrom.setMinValue(false);
 				endDateTo.setMaxValue(false);
 				endDateTo.setMinValue(false);
	        },
	        setStudentTransferDefault : function(obj){
				 var requestTypeFieldStore=obj.getStore();
				 requestTypeFieldStore.load({
					 callback: function(records, operation, success) {
						   for(var i in records){
							   if(records[i].data.value=='Student Transfer'){
								   obj.setValue(records[i].data.id);
							   }
						   }
					   }	
				 });
	        },
	        selectRequestType : function(combo,record){
	        	$this = this;
	        	var filterform = combo.up('studenttransferreportfilter');
	        	
	        	var program = filterform.down('#programId');
	        	var course = filterform.down('#courseId');
	        	var batch = filterform.down('#batchId');
	        	var period = filterform.down('#periodId');
	        	var student = filterform.down('#student');
	        	var section = filterform.down('#sectionId');
	        	var programGroup = filterform.down('#Program_Group');
	        	var toALId = filterform.down('#toAcademyLocationItemId');
	        	var fromAl=filterform.down('#fromAl');
	        	var searchBtn = filterform.down('#searchBtn');
	        	var studentStore = student.getStore();
	        	
	        	toALId.getStore().load();
	        	fromAl.getStore().load();
	        	
	        	
	        	program.setVisible(false);
	        	course.setVisible(false);
	        	batch.setVisible(false);
	        	period.setVisible(false);
	        	section.setVisible(false);
	        	toALId.setVisible(false);
	        	fromAl.setVisible(false);
	        	
	        	
	        	program.reset();
	        	course.reset();
	        	batch.reset();
	        	period.reset();
	        	section.reset();
	        	toALId.reset();
	        	student.reset();
	        	programGroup.reset();
	        	
	        	course.setDisabled(true);
	        	batch.setDisabled(true);
	        	period.setDisabled(true);
	        	section.setDisabled(true);
	        	
	        	var studentALTransferGrid = $this.getStudentaltransferreportgrid();
				var studentTransferGrid = $this.getStudenttransferreportgrid();
	        	
	        	var value = combo.getValue();
	        	if(value==1){
	        		program.setVisible(true);
	        		toALId.setVisible(false);
	        		programGroup.setVisible(false);
	        		studentTransferGrid.setVisible(true);
	        		studentALTransferGrid.setVisible(false);
	        		fromAl.setVisible(false);
	        	}else if(value==2){
	        		program.setVisible(true);
	        		batch.setVisible(true);
	        		course.setVisible(true);
	        		toALId.setVisible(false);
	        		programGroup.setVisible(false);
	        		studentTransferGrid.setVisible(true);
	        		studentALTransferGrid.setVisible(false);
	        		fromAl.setVisible(false);
	        	}else if(value==3){
	        		program.setVisible(true);
	        		batch.setVisible(true);
	        		period.setVisible(true);
	        		section.setVisible(true);
	        		toALId.setVisible(false);
	        		programGroup.setVisible(false);
	        		studentTransferGrid.setVisible(true);
	        		studentALTransferGrid.setVisible(false);
	        		fromAl.setVisible(false);
	        	}else if(value==49){
	        		program.setVisible(true);
	        		batch.setVisible(true);
	        		toALId.setVisible(true);
	        		fromAl.setVisible(true);
	        		programGroup.setVisible(true);
	        		toALId.clearValue();
	        		fromAl.clearValue();
	        		studentALTransferGrid.setVisible(true);
	        		studentTransferGrid.setVisible(false);
	        		$this.setAcademyLocationIdToProgramFilter();
	        	}
	        	setTimeout(function(){
	        		searchBtn.setDisabled(false);
	        		var getActiveTab = $this.getContentPanel().down('studenttransferreporttabstructure');
	        		if(!isNullOrEmpty(getActiveTab)){
	        			getActiveTab.scrollBy(0,1);
	        			getActiveTab.scrollBy(0,-1);
            		}
	        	},10);

	        	studentALTransferGrid.getStore().removeAll();
	        	studentTransferGrid.getStore().removeAll();
	        	studentStore.getProxy().extraParams = {
	        		requestId:value
	        	};
	        	studentStore.load();
	        },
	        setAcademyLocationIdToProgram : function(obj){
	        	var ALID = this.getCurrentAcademyLocation();
	        	var store = obj.getStore();
	        	store.getProxy().extraParams = {
	        		academyLocationIds:ALID
	        	};
	        },
	        
	        setAcademyLocationIdToProgramFilter : function(){
	        	var $this=this;
	        	var filterform = this.getStudenttransferreportfilter();
	        	var requestType = filterform.down('#requestTypeId').getValue();
	        	var ALID = this.getCurrentAcademyLocation();
	        	if(requestType == 49  || requestType==null){
	        		var program = filterform.down('#programId');
	        		program.clearValue();
	        		var store = program.getStore();
	        		store.getProxy().extraParams = {
	        			academyLocationIds:ALID
	        		};
	        		store.load();
	        		if(!isNullOrEmpty(filterform.up())){
						filterform.up().scrollBy(0,1);
						filterform.up().scrollBy(0,-1);
					}
	        	}
	        },
	        
	        selectProgramGroup : function(combo,record){
	        	var filterform = combo.up('studenttransferreportfilter');
	        	var requestType = filterform.down('#requestTypeId').getValue();
	        	var ALID = this.getCurrentAcademyLocation();

	        	if(requestType == 49){
	        		var programGroupId = combo.getValue();
	        		var program = filterform.down('#programId');
	        		program.clearValue();
	        		var store = program.getStore();
	        		store.getProxy().extraParams = {
	        			academyLocationIds:ALID,
		        		programGroupId:programGroupId
	        		};
	        		store.load();
	        	}
	        },
	        
	        selectProgram : function(combo,record){
	        	var filterform = combo.up('studenttransferreportfilter');
	        	var requestType = filterform.down('#requestTypeId').getValue();
	        	
	        	if(requestType !=1){
	        		var programId = combo.getValue();
	        		var batch = filterform.down('#batchId');
	        		batch.setDisabled(false);
	        		batch.clearValue();
	        		var store = batch.getStore();
	        		store.getProxy().extraParams = {
	        			id:programId
	        		};
	        		store.load();
	        	}
	        },
	        
	        selectBatch : function(combo,record){
	        	var filterform = combo.up('studenttransferreportfilter');
	        	var requestType = filterform.down('#requestTypeId').getValue();
	        	var batchId = combo.getValue();
	        	var course = filterform.down('#courseId');
	        	var period = filterform.down('#periodId');
	        	var section = filterform.down('#sectionId');
	        	
	        	if(requestType==2){
	        		course.clearValue();
	        		course.setDisabled(false);
	        		var store = course.getStore();
	        		store.getProxy().extraParams = {
	        			batchId:batchId
		        	};
	        		store.load();
	        	}else if(requestType==3){
	        		period.clearValue();
	        		period.setDisabled(false);
	        		var store = period.getStore();
	        		store.getProxy().extraParams = {
	        			id:batchId
		        	};
	        		store.load();
	        	}
	        },
	        
	        selectPeriod : function(combo,record){
	        	var filterform = combo.up('studenttransferreportfilter');
	        	var periodId = combo.getValue();
	        	var section = filterform.down('#sectionId');
	        	section.setDisabled(false);
	        	section.clearValue();
	        	var store = section.getStore();
        		store.getProxy().extraParams = {
        			periodId:periodId
	        	};
        		store.load();
	        },
	        selectProgramBatchAuto : function(combo,record){
	        	var getActiveTab = this.getActiveTabfromContentPanel();
	        	var studentTransferReportFilterForm = getActiveTab.down('studenttransferreportfilter');
	        	var requestTypeId = studentTransferReportFilterForm.down('#requestTypeId');
	        	var studentCombo = studentTransferReportFilterForm.down('#student');
				var academyLocationIds = this.getCurrentAcademyLocation();
	        	var studentComboStore = studentCombo.getStore();
	        	studentComboStore.getProxy().extraParams = {
	        		requestId: requestTypeId.getValue()
	        	};
	        	studentComboStore.load();

	        		var studentId = combo.getValue();
	        		Ext.Ajax.request({
	        			method: "GET",
	        			type: 'rest',
	        			url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
	        			headers: {
	        				'Content-Type': 'application/json'
	        			},
	        			params: {
	        				studentId: studentId
	        			},
	        			success: function(response, action) {
	        				var data = Ext.decode(response.responseText);
	        				var programGroupCombo = studentTransferReportFilterForm.down('#Program_Group');
	        				programGroupCombo.setReadOnly(true);
	        				var programGroupComboStore = programGroupCombo.getStore();
	        				programGroupComboStore.load({
	        					callback: function(records, operation, success) {
	        						if (!isNullOrEmpty(data[0])) {
	        							programGroupCombo.setValue(data[0].programGroupId);
	        							var programCombo = studentTransferReportFilterForm.down('#programId');
	        							//programCombo.setReadOnly(true);
	        							//programCombo.setDisabled(false);
	        							var programComboStore = programCombo.getStore();
	        							programComboStore.getProxy().extraParams = {
	        								programGroupId: data[0].programGroupId,
	        								academyLocationIds:academyLocationIds
	        							};

	        							programComboStore.load({
	        								callback: function(records, operation, success) {
	        									if (!isNullOrEmpty(data[0].programId)) {
	        										//programCombo.setValue(data[0].programId);
	        										var batchCombo = studentTransferReportFilterForm.down('#batchId');
	        										batchCombo.setReadOnly(true);
	        										batchCombo.setDisabled(false);
	        										var batchComboStore = batchCombo.getStore();
	        										batchComboStore.getProxy().extraParams = {
	        											programId: data[0].programId
	        										};

	        										batchComboStore.load({
	        											callback: function(records, operation, success) {
	        												if (!isNullOrEmpty(data[0].batchId)) {
	        													batchCombo.setValue(data[0].batchId);
	        												}
	        											}
	        										});
	        									}
	        								}
	        							});
	        						}
	        					}
	        				});
	        			}
	        			
	        		});
            				var studentId = record[0].get("id");
            				var form = combo.up('form').getForm();
            				var studentComboBox = this.getStudenttransferreportfilter().down('customcombobox#student');
            				var studentStatus = form.findField('STATUS');
            				studentComboBox.setDisabled(false);
            				Ext.Ajax.request({
                                method: 'GET',
                                url: SERVERURL.PATH_STUDENT_STATUS,
                                params: {
                                	studentId: studentId
                                },
                                success: function(response) {
                                var status = Ext.decode(response.responseText);
	                			 if(status)
	                			 {
	                				 studentStatus.setValue(true);
	                				 studentStatus.setReadOnly(true);
	                			 }
	                			 else
	                			 {
	                				 studentStatus.setValue(false);
	                				 studentStatus.setReadOnly(true);
	                			 } 
                                }
	        		});
}
});

