Ext.define('Academia.model.common.IdValueCodeDataModelForParentSibling', {
	extend : 'Ext.data.Model',
	fields : [ 'id','ids','value','code','isCurrentPeriodOfProgram','whetherCurrentAcademicTerm',{
        name    : 'valueCode', 
        convert : function (v, rec) {
           return rec.get('code') + ' / ' + rec.get('value');
        }
    },{
        name    : 'displayValue', 
        convert : function (v, rec) {
        	if(!isNullOrEmpty(rec.get('value'))){
        		 return Ext.String.trim(rec.get('value'));
        	}else{
        		 return null;
        	}
          
        },
        
    },{
        name    : 'camelCaseValue', 
        convert : function (v, rec) {
        	if(!isNullOrEmpty(rec.get('value'))){
        		 return rec.get('value').replace(/(?:^\w|[A-Z]|\b\w|\s+)/g, function(match, index) {
         		    if (+match === 0) return "";
         		    return index == 0 ? match.toUpperCase() : match.toLowerCase();
         	 });
        	} else {
        		 return null;
        	}
        }
    },{
        name    : 'codeValue', 
        convert : function (v, rec) {
           return rec.get('value') + ' / ' + rec.get('code');
        }
    }/*,{
        name    : 'recordId', 
        convert : function (v, rec) {
           return rec.get('sequence');
        }}*/, 'secondValue', 'doubleValue', 'check','studentId', 'secondCode','secondCheck','sequence','sectionAtComponentLevel'
    ]
});