/**
 * This model is used for Completion Checklists Store of the Completion Checklist grid.
 * @author Akshay.Kalbhor
 */
 
 Ext.define('Academia.model.completion.setup.CompletionChecklist', {
    extend: 'Ext.data.Model',
    fields: ['progBatchSeatConfId','academyLocation', 'program', 'batch', 'seatType', 'transactionType', 'certificateCount', 
             'checklistItemCount','completionChecklistId',
             {name: 'programName', mapping: 'program.value'},
             {name: 'batchName', mapping: 'batch.value'},
             {name: 'seatTypeName', mapping: 'seatType.value'},
             {name: 'transactionTypeName', mapping: 'transactionType.value'},
             {name: 'transactionTypeId', mapping: 'transactionType.id'},
             {
            	 name: 'transactionTypeTranslation',
            	 convert: function(v, rec){
            		 if(!isNullOrEmpty(rec.get("transactionType"))){
                		 var code = rec.get('transactionType').code;
                		 return getCompletionModuleTranslation(code);
            		 }
            		 else{
            			 return '';
            		 }
            	 }
             }
    ]
    	
});