/**
 * @author Chanchal Prajapat
 */
Ext.define('Academia.model.personinfo.common.personalinfo.StudentJourneyModel',{
	extend: "Academia.model.AbstractDataModel",
	fields: [
		'id',
		'academicTermId',
		'academicTermCode',
		'academicLocationId',
		'academicLocationName',
		'admissionId',
		'programId',
		'programName',
		'batchId',
		'batchName',
		'programBatchPrefix',
		'programBatchSeq',
		{
			name: 'campusId',
			convert: function(val, rec){
				return rec.get('academyLocationCampusId');
			}
		},
		'campusName',
		'periodId',
		'periodName',
		'periodStatus',
		'resultStatus',
		'studentId',
		'programPeriodSeq',
		'academicTermSeq',
		'seatTypeId',
		'programCode',
		{
			name: 'seatType',
			mapping: 'seatTypeName'
		}, 
		'seatTypeName',
		'progressionStatus',
		'likelytoReturn',
		'academyLocationCampusId',
		'programJourneySeq', //For managing multiple programs
		{
			name: 'addedStatus',
			convert: function(val, rec) {
				var studentJourneyAddedStatusDetails = rec.get('studentJourneyAddedStatusDetails');
				if(!isNullOrEmpty(val) && val.length && isNullOrEmpty(val[0])){
					return "";
				} else if(!isNullOrEmpty(val) && val.length && typeof val[0] == "object"){
					return val;
				} else if(studentJourneyAddedStatusDetails.length) {
					var newVal = [];
					Ext.each(studentJourneyAddedStatusDetails, function(cur){
						if(cur && cur.studentJourneyAddedStatus && cur.studentJourneyAddedStatus.id){
							var addedStatusId = cur.studentJourneyAddedStatus.id;
							var addedStatusVal = cur.studentJourneyAddedStatus.value;
						}
						else{
							var addedStatusId = cur.data.id;
							var addedStatusVal = cur.data.value;
						}
						newVal.push({
							data:{
								id: addedStatusId,
								value: addedStatusVal
							},
							raw:{
								id: addedStatusId,
								value: addedStatusVal
							}
						});
					});
					return newVal;
				}
				else{
					return "";
				}
			}
		},
		'studentJourneyAddedStatusDetails',
		'isAcademicTermEditable',
		'attributeValue',
		'isperiodEditable'
	]
});

