/**
 * by Kuldeep Yadav
 */
Ext.define('Academia.model.student.studentprofile.AcademicsTopicQuickSearchGridModel', {
	extend : 'Ext.data.Model',
	fields :['admission', 'student', 'batch', 'period','date','academicTopics', 'academicSubTopics', 'description','id',
	         'programId','academicTopicId','studentCode','studentName', 'programName', 'createdAt', 'createdBy', 'updatedAt', 'updatedBy', 'status', 'academicTopicDocuments',
	         'academicTopicUrls', 'isPublished', 'documents','academicTerm','studentDate','studentCreatedAt','studentUpdatedAt',{
		name: 'documentName',
		convert: function(val, rec) {
			var docs = rec.get('documents');
			if(docs && docs.length > 1) {
				return docs.length;
			}
			else if(docs && docs.length == 0) {
				return "";
			}
			else {
				if(isNullOrEmpty(rec.get("documents"))) {
					return "";
				}
				return rec.get('documents')[0].name;
			}
		}
	}, {
		name: 'urlName',
		convert: function(val, rec) {
			var urls = rec.get('academicTopicUrls');
			if(urls && urls.length > 1) {
				return urls.length;
			}
			else if(urls && urls.length == 0) {
				return "";
			}
			else if(rec.get('academicTopicUrls') && rec.get('academicTopicUrls')[0]){
				return rec.get('academicTopicUrls')[0].name;
			}
			else {
				return "";
			}
		}
	}, {
		name: 'Status',
		convert: function(val, rec) {
			return rec.get('status')
		}
	},{
		name: 'academicTopic',
		mapping: 'academicTopics.value'
	},{
		name: 'academicSubTopic',
		mapping: 'academicSubTopics.value'
	}]
});