/**
 * @author Rohit Sharma
 */
Ext.define('Academia.store.eventlevelremark.EventLevelRemarkComboStore',{
	extend:'Ext.data.Store',
	fields: [
		'id', 'remarkCode', 'remarkName', 'status',
		{
			name: 'value',
			convert: function(val, rec) {
				return rec.get('remarkCode') + '/' + rec.get('remarkName');
			}
		}
	],
	proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.PATH_FIND_ALL_EVENT_LVL_REMARK
        },
        reader: {
        	type:'json',
			root: 'rows',
			totalProperty: 'records'
        }
    }
});