/**
 * @author Prakash.Soni
 */
Ext.define('Academia.store.feeandpayment.managebill.StudentDetailsByNationalId', {
	extend : 'Ext.data.Store',
	model : 'Academia.model.feeandpayment.managebill.Student',
	autoLoad : false,
	sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('studentName');
	        var value2 = o2.get('studentName');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.BILL_STUDENT_DETAILS_NATIONAL_ID
		},
		reader: {
			type:'json'
		}
	}

});