/**
 * @author Rohit Sharma
 */
Ext.define('Academia.store.manageMarksModeration.MarksModerationProgramStore', {
    extend: 'Ext.data.Store',
    fields: [
    	'id', 'code', 'value',
    	{
    		name: 'displayValue',
    		convert: function(val, rec) {
    			return rec.get('code') + '/' + rec.get('value');
    		}
    	}
    ],
    autoLoad: false,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.PATH_FIND_PROGRAMS_BY_COURSE_AND_VARIANT_IDS,
        },
        actionMethods: {
            read: 'POST'
        },
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records',
            successProperty: 'success'
        }
    }
});