/**
 * Live search combo details store
 * 
 */
Ext.define('Academia.store.messaging.ApprovarComboStore',{
	extend:'Ext.data.Store',
	model : 'Academia.model.common.LiveSearchComboModel',
	pageSize : 5,	
	autoLoad : false,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.FIND_ALL_APPROVARS //rest/users/findAllApprovers 
		},
		reader : {
			type : 'json'			
		}
	},	
    listeners: {
    	beforeload:{
    		 element: 'el',
             fn: function(store, records, successful, eOpts) {
                 var academyLocationId = Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getValue();
                 store.getProxy().extraParams = {
                	 academyLocationId:academyLocationId
                 };   
             } 
    	},
        load: {
            element: 'el',
            fn: function(store, records, successful, eOpts) {
                var me = this;
                for (var count = 0; count < records.length; count++) {
                    var record = records[count];
                    var concatValue = "";
                  //  concatValue = me.concatValue(concatValue, record, 'salutation.value');
                    concatValue = me.concatValue(concatValue, record, 'firstName');
                    concatValue = me.concatValue(concatValue, record, 'lastName');
                    concatValue = me.concatBracketWithValue(concatValue, record, 'code');
                   // concatValue = me.concatBracketWithValue(concatValue, record, 'department');
                    records[count].set('value', concatValue);
                }
                store.commitChanges();
            }
        }, 
     
    },
    concatValue: function(concatValue, record, key) {
        var value = record.get(key);
        if (!isNullOrEmpty(value)) {
            concatValue = concatValue.concat("  " + value);
            return concatValue;
        } else {
            return concatValue;
        }
    },
    concatBracketWithValue : function (concatValue, record, key){
    	var value = record.get(key);
        if (!isNullOrEmpty(value)) {
            concatValue = concatValue.concat("  [" + value+"]");
            return concatValue;
        } else {
            return concatValue;
        }
    }
});
