Ext.define('Academia.store.messaging.MessageSubCategoryStore', {
     extend: 'Ext.data.Store',
     model: 'Academia.model.common.IdValueCodeDataModel',
     autoLoad: false,
     sorters: [{
         property: 'code',
         direction: 'ASC'
     }],
     sortOnLoad: true,
     remoteSort: false,
     proxy: {
         type: 'rest',
         api: {        	   
             read: SERVERURL.FIND_ALL_MESSAGE_SUB_CATEGORY      //URL -rest/msgCatagoryResource/findAllMsgSubCategory?id=# 
         },
         reader: {
             type: 'json'
         }
     },
     listeners: {
         load: {
             element: 'el',
             fn: function(store, records, successful, eOpts) {                 
                 for (var count = 0; count < records.length; count++) {
                     var record = records[count];
                     var resultKey=record.get('code');
                     if(!isNullOrEmpty(resultKey) && resultKey==="Time table change"){
                    	 records[count].set('code', "Timetable change");
                     }else{
                    	 records[count].set('code', getMessagingModuleTranslation(resultKey)); 
                     }                     
                 }
                 store.commitChanges();
             }
         }
     }
 });