/**
 * @author Ravi Choudahry
 * used to fetch all students of a academy location
 */
Ext.define('Academia.store.program.StudentsByAcademyLocationIdStore',{
	extend : 'Ext.data.Store',
	model : 'Academia.model.common.IdValueCodeDataModel',
	sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('value');
	        var value2 = o2.get('value');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
	autoLoad : false,
	proxy : {
		type: 'rest',
		api : {
			read : SERVERURL.COMPLAINT_STUDENT_COMBO 
		},
		method: 'GET',
		reader: {
			type: 'json'
		} 
	}
});