/**
 * @author Sandeep.Pal
 */
Ext.define('Academia.store.servicerequest.studentservicerequest.StudentPortalStudentRequestStore', {
	extend : 'Ext.data.Store',
	fields:[
		"fromAcademyLocationName",
		"assigneeName", 
		"batchName", 
		"birthDate", 
		"gender",
		"cancellationReason",
		"id", 
		{
			name: "ID",
			mapping: "id"
		},
		"intakeYear", 
		"programName", 
		"programId", 
		"requestDate", 
		"requestId", 
		{
			name: "REQUEST_ID",
			mapping: "requestId"
		},
		"SERVICE_REQUEST_GROUP",
		"REQUEST_TYPE_ID",
		"approvalLetter",
		"applicationForm",
		"requestStatus", 
		"requesterCode", 
		"approvalLetterStrId",
		"documentStrId",
		"documentId",
		"approvalLetterId",
		"requesterName", 
		{
            name: "REQUEST_SUB_TYPE",
            mapping: "requestSubType"
        },
		"sla",
		"sectionName",
		{
            name: "REQUEST_TYPE",
            mapping: "requestType"
        },
		"serviceRequestType",
		{
	        name    : 'requestBy', 
	        convert : function (v, rec) {
	        	if(!isNullOrEmpty(v)){
					return getServiceRequestTranslation(v);
	        	}else{
	        		 return null;
	        	}
	          
	        },
	        
	    },
		//"service_REQUEST_TYPE",
		{
	        name    : 'SERVICE_REQUEST_TYPE', 
	        convert : function (v, rec) {
	        	if(!isNullOrEmpty(rec.get('serviceRequestType'))){
					return Ext.String.trim(rec.get('serviceRequestType'));
	        	}else{
	        		 return null;
	        	}
	          
	        },
	        
	    },
	    {
			name: "SERVICE_REQUEST_GROUP",
			mapping: "serviceRequestGroup"
		},{
			name: "REQUEST_TYPE_ID",
			mapping: "requestTypeId"
		},
		'sectionCode',
		{
            name: "REQUEST_CATEGORY",
            mapping: "requestCategory"
        },

		'requestAssignedTo',
		'serviceRequestStatus',
		'serviceRequestStage',
		{
        	name: "SERVICE_REQUEST_STAGE",
            mapping: "serviceRequestStage"
		}
	],
	autoLoad : false,
	pageSize: 10,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.PATH_FIND_STUDENT_REQUEST_FOR_STUDENT_PORTAL
		},
		reader : {
			type : 'json',
			root:'rows'
		}
	}
});
