/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.servicerequest.studentservicerequest.StudentRequestTransferInStore', {
	extend : 'Ext.data.Store',
	fields:[
		"fromAcademyLocationName",
		"assigneeName", 
		"batchName", 
		"birthDate", 
		"gender", 
		"id", 
		{
			name: "ID",
			mapping: "id"
		},
		"intakeYear", 
		"programName", 
		"requestDate", 
		"requestId", 
		{
			name: "REQUEST_ID",
			mapping: "requestId"
		},
		"SERVICE_REQUEST_GROUP",
		"REQUEST_TYPE_ID",
		"requestStatus", 
		"requesterCode", 
		"requesterName", 
		"sectionName",
		//"requestBy",
		"requestType",
		"service_REQUEST_TYPE",
		{
	        name    : 'requestBy', 
	        convert : function (v, rec) {
	        	if(!isNullOrEmpty(v)){
					return getServiceRequestTranslation(v);
	        	}else{
	        		 return null;
	        	}
	          
	        },
	        
	    },
		//"service_REQUEST_TYPE",
		{
	        name    : 'SERVICE_REQUEST_TYPE', 
	        convert : function (v, rec) {
	        	if(!isNullOrEmpty(rec.get('service_REQUEST_TYPE'))){
					return Ext.String.trim(rec.get('service_REQUEST_TYPE'));
	        	}else{
	        		 return null;
	        	}
	          
	        },
	        
	    },
	    {
			name: "SERVICE_REQUEST_GROUP",
			mapping: "serviceRequestGroup"
		},{
			name: "REQUEST_TYPE_ID",
			mapping: "requestTypeId"
		}
	],
	autoLoad : false,
	pageSize: 10,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.PATH_FIND_ALL_AL_TRANSFER_REQUESTS
		},
		reader : {
			type : 'json',
			root:'rows'
		}
	}
});
