/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.survey.SendSurveyCreatePBSLevelSurveyGridStore',{
	extend:'Ext.data.Store',
	fields: [
		'academiaLimeSurveyId',
		'academicTermId',
		'academicTermName',
		'academyLocationId',
		'academyLocationName',
		'batchId',
		'batchName',
		'courseId',
		'courseName',
		'courseVariantId',
		'courseVariantName',
		'emailId',
		'facultyId',
		'facultyName',
		'id',
		'lastName',
		'lastUpdate',
		'lastUpdatedBy',
		'periodId',
		'periodName',
		'programId',
		'programName',
		'sectionId',
		'sectionName',
		'status',
		'newlyEnrolled',
		{
			name: 'surveyStatus',
			convert : function (v, rec) {
				var surveyStartDate = rec.get('surveyStartDate');
				var surveyEndDate = rec.get('surveyEndDate')
				var today = new Date();

		        if (!isNullOrEmpty(surveyStartDate) && !isNullOrEmpty(surveyEndDate)) {
		            var startDate = new Date(surveyStartDate+" 00:00:00");
		            var endDate = new Date(surveyEndDate+" 23:59:59");
		
		            if (today >= startDate && today <= endDate) {
		                return getCommonTranslation("ACTIVE");
		            } else  if (today > endDate) {
		                return getCommonTranslation("INACTIVE");
		            }
		        } else if(rec.get('status') == "CREATED"){
		            return getCommonTranslation("CREATED");
		        } else if(rec.get('status') == "ACTIVE"){
		            return getCommonTranslation("ACTIVE");
		        }
		        return rec.get('status');
	        }
		},
		'studentId',
		'studentName',
		'surveyEndDate',
		'surveyId',
		'surveyName',
		'surveyStartDate',
		'totalEmailSent',
		'totalParticipant',
		'totalSurveyEnrolled',
		'noOfQuestions',
		{
			name: 'surveyRemaining',
			convert: function(v, rec){
				var totalParticipants = rec.get('totalParticipant');
				var totalEmailSent = rec.get('totalEmailSent');
				
				var totalSurveyEnrolled = rec.get('totalSurveyEnrolled');
				var academiaLimeSurveyId = rec.get('academiaLimeSurveyId');
				
				if(totalSurveyEnrolled == 0 || isNullOrEmpty(academiaLimeSurveyId)){
					return 0;
				}
				else{
					totalParticipants = (totalParticipants == null) ? 0 : totalParticipants;
					totalEmailSent = (totalEmailSent == null) ? 0 : totalEmailSent;
					
					return (parseInt(totalParticipants) - parseInt(totalEmailSent));
				}
			}
		},
		'isAnonymized'
	],
	pageSize: CONSTANTS.DEFAULT_PAGESIZE,
	proxy: {
	    type: 'rest',
	    method: 'GET',
	    api: {
	        read: SERVERURL.PATH_GET_PBS_LEVEL_SURVEY_LIST_BEFORE_CREATING_SURVEY
	    },
	    reader: {
	        type: 'json',
	        root: 'rows',
	        totalProperty: 'records'
	    }
	}
});

