Ext.define('Academia.utilities.ColumnProgressBar', {
	extend: 'Ext.grid.column.Column',
	requires: 'Ext.ProgressBar',
	alias: ['widget.columnprogressbar'],

	//header: '&#160;',

	/**
	 * @cfg {number} min
	 * The min of the progress bar, for normalization purpose. Defaults to <tt>0</tt>
	 */
	min: 0,

	/**
	 * @cfg {number} max
	 * The max of the progress bar, for normalization purpose. Defaults to <tt>100</tt>
	 */
	max: 100,

	constructor: function (config) {

		var me = this;
		me.callParent(arguments);
		
		me.renderer = function (v, meta, rec, r, c, store, view) {
			setTimeout(function() {
				var row = view.getNode(rec);
				var pb = Ext.create('Ext.ProgressBar', {
					renderTo: Ext.fly(Ext.fly(row).query('.x-grid-cell')[c]).down('div'),
					//style:{marginTop:'-17px'},
					value: v,
					min: me.min,
					max: me.max
				});
				
				console.log(v);

				if(v==='Ready'){
					pb.textEl.removeCls("x-progress-text x-progress-text-back");
					pb.textEl.addCls("inProgressCss-progress-text");
					pb.updateText("Ready");
				}else if(v==='Uploading'){
					pb.textEl.removeCls("x-progress-text x-progress-text-back");
					pb.textEl.addCls("inProgressCss-progress-text");
					pb.updateText("Uploading");
				}else if(v==='Uploaded'){
					pb.textEl.removeCls("x-progress-text x-progress-text-back");
					pb.textEl.addCls("inProgressCss-progress-text");
					pb.updateText("Uploaded");
				}
				/*me.on('resize', function(cp, w, h) {
					pb.resize(w, h);
				});*/
			}, 50);
		};
	},
	
	/**
	 * Destroy?
	 */
	destroy: function() {
		delete this.renderer;
		delete this.pb;
		return this.callParent(arguments);
	}
});