Ext.define('Academia.utilities.vTypeValidations.Validation', {
});

/**
 * File that will have the custom validations using vtypes.
 * #author: Akshay Kalbhor
 */

 Ext.apply(Ext.form.field.VTypes, {
	 linkedInUrlVType: function(val) {
	        // Regular expression for LinkedIn URL validation
	        var linkedinRegex = /linkedin\.com/;
	        return linkedinRegex.test(val);
	    
	 },
	 linkedInUrlVTypeText: 'Invalid LinkedIn URL. It must start with "linkedin.com/"',
	 twitterUrlVType: function(val) {
	        // Regular expression for LinkedIn URL validation
	        var linkedinRegex = /x\.com|twitter\.com/; //https://x.com/
	        return linkedinRegex.test(val);	    
	 },
	 twitterUrlVTypeText: 'Invalid Twitter URL. It must start with "x.com/"',
	 websiteUrlVType: function(val) {
		 var domainRegex = /^(?!-)(?!.*-\.)[a-zA-Z0-9-]+(\.[a-zA-Z]{2,})+$/;
	        // Validate against the regex
	        return domainRegex.test(val);
	    
	 },
	 websiteUrlVTypeText: 'Invalid Domain. It should not have spaces, invalid characters, or consecutive dots, and must end with a valid domain extension (e.g., .com, .org)',

            daterange: function(val, field) {
                var date = field.parseDate(val);

                if (!date) {
                	// If field is cleared, reset min/max constraints
                    if (field.startDateField) {
                        var start = field.up('form').down('datefield#' + field.startDateField);
                        if (start) {
                            start.setMaxValue(null);
                            start.validate();
                        }
                    }
                    if (field.endDateField) {
                        var end = field.up('form').down('datefield#' + field.endDateField);
                        if (end) {
                            end.setMinValue(null);
                            end.validate();
                        }
                    }
                    return true;
                }
                if (field.startDateField && (!this.dateRangeMax || (date.getTime() != this.dateRangeMax.getTime()))) {
                    var start = (field.up('form').query('datefield#'+field.startDateField))[0];
                    start.setMaxValue(date);
                    this.dateRangeMax = date;
                    start.validate();
                }
                else if (field.endDateField && (!this.dateRangeMin || (date.getTime() != this.dateRangeMin.getTime()))) {
                    var end = (field.up('form').query('datefield#'+field.endDateField))[0];
                    end.setMinValue(date);
                    this.dateRangeMin = date;
                    end.validate();
                }
                /*
                 * Always return true since we're only using this vtype to set the
                 * min/max allowed values (these are tested for after the vtype test)
                 */
                this.dateRangeMax = undefined;
                this.dateRangeMin = undefined;
                return true;
            },
            searchDaterange: function(val, field) {
                var date = field.parseDate(val);

                if (!date) {
                    return false;
                }
                if (field.startDateField && (!this.dateRangeMax || (date.getTime() != this.dateRangeMax.getTime()))) {
                    var start = (field.up('form').query('datefield#'+field.startDateField))[0];
                    start.setMaxValue(date);
                    this.dateRangeMax = date;
                }
                else if (field.endDateField && (!this.dateRangeMin || (date.getTime() != this.dateRangeMin.getTime()))) {
                    var end = (field.up('form').query('datefield#'+field.endDateField))[0];
                    end.setMinValue(date);
                    this.dateRangeMin = date;
                }
                /*
                 * Always return true since we're only using this vtype to set the
                 * min/max allowed values (these are tested for after the vtype test)
                 */
                this.dateRangeMax = undefined;
                this.dateRangeMin = undefined;
                return true;
            },
            //TODO: figure out the way to take the messages from translations.
            daterangeText: getErrorTranslation('DATE_RANGE_ERROR'),
            //daterangeText: 'Start date must be less than end date',
            
            timerange : function(val, field) {
                var time = field.parseDate(val);
                if(!time){
                    return;
                }
                if (field.startTimeField && (!this.timeRangeMax || (time.getTime() != this.timeRangeMax.getTime()))) {
                	var startTime = (field.up('form').query('timefield#' + field.startTimeField))[0];                	
                	startTime.setMaxValue(time);
                	this.timeRangeMax = time;
                	startTime.validate();
                } 
                else if (field.endTimeField && (!this.timeRangeMin || (time.getTime() != this.timeRangeMin.getTime()))) {
                	var endTime = (field.up('form').query('timefield#' + field.endTimeField))[0];                	
                	endTime.setMinValue(time);
                	this.timeRangeMin = time;
                	endTime.validate();
                }
                this.timeRangeMax = undefined;
                this.timeRangeMin = undefined;
                return true;
            },
            timerangeText: getErrorTranslation('TIME_RANGE_ERROR'),
            //timerangeText: 'Start time must be less than end time',
            /**
             * validation for checking if number entered in a particular field is not greater than the number in the other
             * field.
             * eg: in case of marks obtained(variableNumberField) and total Marks (totalNumberField) the value entered in
             * the marks obtained should not exceed the value entered in the total marks field.
             */
            numberrange : function(val, field) {
            	 var inputValue = field.getValue();
           
                if (field.variableNumberField && (!field.variableNumberField || (inputValue != this.numberRangeMax))) {
                	var variableField = (field.up('form').query('numberfield#' + field.variableNumberField))[0];                	
                	variableField.setMaxValue(inputValue);
                	this.numberRangeMax = inputValue;
                	variableField.validate();
                } 
                else if (field.totalNumberField && (!field.totalNumberField || (inputValue != this.numberRangeMin))) {
                	var totalField = (field.up('form').query('numberfield#' + field.totalNumberField))[0];                	
                	totalField.setMinValue(inputValue);
                	this.numberRangeMin = inputValue;
                	totalField.validate();
                }
                
                this.numberRangeMax = undefined;
                this.numberRangeMin = undefined;
                return true;
            },
            numberrangeText: getErrorTranslation('NUMBER_RANGE_ERROR'),
            //numberrangeText: 'Minimum and Maximum numbers are not proper',

            password: function(val, field) {
                if (field.initialPassField) {
                    var pwd = field.up('form').down('#' + field.initialPassField);
                    return (val == pwd.getValue());
                }
                return true;
            },
            //passwordText: getErrorTranslation('PASSWORDS_MISMATCH')
            passwordText:'Passwords do not match',
            	
            NospaceAsInput: function(value,field) {
            	if(field.itemId=="ckEditor" || field.itemId=="templateCKEditor" || field.itemId=="remarkValueItemId" || field.itemId=="evaluationremark_hindi"){
            		return value;
            	}
                return /^([`~a-zA-Z0-9.,;!@#$%^&*()-_\=\{\}:/\\'"\[\]|]+\s?)*$/.test(value);
            },
            NoSpeceAndSpecialCharacters: function(value,field) {
            	return /^[a-zA-Z0-9-]+$/.test(value);
            },
            spaceAsInput: function(value) {
                return /^([a-zA-Z0-9.,;!@#$%^&*()-_ \=\{\}:/\\'"\[\]|]+\s?)*$/.test(value);
            },
            NospaceAsInputText: 'The data entered in this field is not valid',
            NospaceAsInputFrench: function(value,field) {
            	if(field.itemId=="ckEditor" || field.itemId=="templateCKEditor" || field.itemId=="remarkValueItemId" || field.itemId=="evaluationremark_hindi"){
            		return value;
            	}
            	return /^([`~a-zA-Z0-9.,;!@#$%^&*()-_\=\{\}:/\\'"\[\]|àâäèéêëîïôœùûüÿçæÀÂÄÈÉÊËÎÏÔŒÙÛÜŸÇ]+\s?)*$/.test(value);
            },
            NospaceAsInputFrenchText: 'The data entered in this field is not valid',

            spaceAndFrenchSpecialCharactersAsInput: function(value) {
            	return /^([a-zA-Z0-9._`'àâäèéêëîïôœùûüÿçæÀÂÄÈÉÊËÎÏÔŒÙÛÜŸÇ]+\s?)*$/.test(value);
            },
            spaceAndFrenchSpecialCharactersAsInputText: 'The data entered in this field is not valid',
            NoSpaceAndSpecialCharactersAsInput: function(value) {
                return /^([a-zA-Z.]+\s?)*$/.test(value);
            },
            NoSpaceAndSpecialCharactersAsInputText: 'The data entered in this field is not valid',

			alphanumspace: function(value){
				return /^[a-z0-9 ]+$/i.test(value);
				//return /^[a-zA-Z0-9 ]*$/.test(value);
			},
			alphanumspaceText: 'Only alpha numeric value is valid for this field.',
            
            NoSpaceAndSpecialCharactersWithNumberAsInput: function(value) {
                return /^([a-zA-Z0-9]+\s?)*$/.test(value);   
            },
            NoSpaceAndSpecialCharactersWithNumberAsInputText: 'The data entered in this field is not valid',
            
            spaceAndSpecialCharactersAsInput: function(value) {
                return /^([a-zA-Z0-9._`']+\s?)*$/.test(value);
            },
            NoSpecialCharactersWithNumberWithoutSpaceAsInput: function(value) {
                return /^([a-zA-Z0-9]+?)*$/.test(value);
            },
            NoSpecialCharactersWithNumberWithoutSpaceAsInputText: 'The data entered in this field is not valid',
            
            SpecialCharactersWithNumberWithoutSpaceAsInput: function(value) {
                return /^([a-zA-Z0-9,:-]+?)*$/.test(value);
            },
            SpecialCharactersWithNumberWithoutSpaceAsInputText: 'The data entered in this field is not valid',
            
            spaceAndSpecialCharactersAsInputText: 'The data entered in this field is not valid',
            
            someSpecialCharactersWithAplhaNumericAsInput: function(value) {
            	return  /^([A-Za-z0-9,:-]+\s?)*$/.test(value);
            },
            someSpecialCharactersWithAplhaNumericAsInputText: 'The data entered in this field is not valid',
            
            NoSpecialCharacterAsInput: function(value) {
            	return  /^[a-zA-Z0-9 ]+$/.test(value);
            },
            NoSpecialCharacterAsInputText: 'The data entered in this field is not valid',
            
            /**
             * VType for numberField, throws error when data is pasted in the field
             */
            numericValueValidation: function(value) {
                 return /^\d{0,2}$/.test(value)?true:"Invalid Number";
            },
            numericValueValidationText: 'Invalid Number',
            
            //multiemailText: 'This field should be an e-mail address in the format "user@example.com',
           multiemailText: 'This field should be an proper e-mail address format',
            multiemail: function(v) {
                var array = v.split(',');
                var valid = true;
                Ext.each(array, function(value) {
                  if (!this.email(value)) {
                    valid = false;
                    return false;
                  }
                }, this);
                return valid;
           },
           
           myemailText: 'This field should be an email address in the format "user@example.com" with a domain extension up to 20 characters.',
           myemailMask: /[a-z0-9._%+-@]/i,
           myemail: function(value) {
               // Custom regex to validate any domain extension up to 20 characters in length
               return /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,20}$/.test(value);
           },
           
           allowSlashAndHyphen: function(value) {
               return /^([a-zA-Z0-9 \-\/]+\s?)*$/.test(value);
           },
           allowSlashAndHyphenText: 'Not allowed',
           
           allowNumberAndHyphen: function(value) {
               return /^([0-9-]+\s?)*$/.test(value);
           },
           allowNumberAndHyphenText: 'Not allowed',
           
           passwordAndPolicyMatch: function(val, field, valid) {
        	   if (field.initialPassField) {
        		   var pwd = field.up('form').down('#' + field.initialPassField);
        		   if(val == pwd.getValue()) {
        			   var confirmPsdw = field.previousSibling();
        			   var acticeError = confirmPsdw.activeError;
        			   if(!isNullOrEmpty(acticeError)) {
        				   return false;
        			   } else {
        				   return true; 
        			   }
        		   } else {
        			   return false;
        		   }

        	   }
        	   return false;
           },
           //passwordText: getErrorTranslation('PASSWORDS_MISMATCH')
           passwordAndPolicyMatchText:'The password does not match',
           
            
 });
//                Ext.getCmp('vpCenter').body.scrollTo('top', 0)