Ext.define('Academia.view.DMSView.SiteDashboardCenterPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.sitedashboardcenterpanel',
    margin: 0,
    items:[{
    	xtype: 'panel',
    	title: getDMSTranslation('SITE_CONTENT'),
    	autoScroll: true,
        frame: true,
        border: true,
        height: 280,
        dockedItems: [{
            xtype: 'toolbar',
            dock: 'top',
            style: 'background:rgb(224, 224, 224);',
            items: [{
            	xtype : 'combobox',
            	name : 'siteContentFilter',
            	itemId:'siteContentFilterItemId',
            	store: new Ext.data.ArrayStore({
            		id: 0,
            		fields: [
            			'displayFilter',
            			'valueFilter'
            			],
            			data: [["I've Recently Modified",'recentlyModifiedByMe'], ["I'm Editing",'editingMe'],["My Favorites",'favourites']]  // data is local
            	}),
            	valueField: 'valueFilter',
            	displayField: 'displayFilter',
            	triggerAction: 'all',
            	editable: false
            }]
        }],
    	items:[{
    		xtype: 'dataview',
    		itemId: 'siteContentDataViewItemId',
    		autoScroll: true,
    		store: Ext.create('Academia.store.DMSStore.DMSSiteContentStore'),
    		tpl: new Ext.XTemplate(
		    	    '<tpl for=".">',
		            '<div class="thumb-wrap-site-content">',
		              '<img src="{[this.getImage(values)]}" />',
		              '<div><span class="dmsFileNameSpan">{fileName}</span><br /><span style="float: left;">Created about {[this.timeSince(values)]} ago in {location_siteTitle}</span></div>',
		            '</div>',
		        '</tpl>',
		        {
		    	    getImage: function(values) {
		    	    	var fileName = values.fileName;
		    	    	var fileExtension = fileName.split(".")[fileName.split(".").length-1];
		    	    	if(!isNullOrEmpty(fileExtension)){
		    				var audioFiles = ['aif','cda','mid','midi','mp3','mpa','ogg','wav','wma','wpl'];
		    				var zipFiles = ['7z','arj','deb','pkg','rar','rpm','gz','z','zip'];
		    				var databaseFiles = ['csv','dat','db','dbf','log','mdb','sav','sql','tar','xml'];
		    				var imageFiles = ['ai','bmp','gif','ico','jpeg','jpg','png','ps','psd','svg','tif','tiff'];
		    				var netFiles = ['asp','aspx','cer','cfm','cgi','pl','css','htm','html','js','jsp','part','php','py','rss','xhtml'];
		    				var presentationFiles = ['key','odp','pps','ppt','pptx'];
		    				var spreadSheetFiles = ['ods','xlr','xls','xlsx'];
		    				var videoFiles = ['3g2','3gp','avi','flv','h264','m4v','mkv','mov','mp4','mpg','mpeg','rm','swf','vob','wmv'];
		    				var docFiles = ['doc','docx','odt']
		    				var textFiles = ['pdf', 'rtf', 'tex', 'txt', 'wks', 'wps', 'wpd'];
		    				
		    				var imageFile = "resources/images/generic-file-32.png";
		    				if(Ext.Array.contains(audioFiles,fileExtension)){
		    					var imageFile = "resources/images/mp3-file-32.png";
		    				}
		    				else if(Ext.Array.contains(zipFiles,fileExtension)){
		    					var imageFile = "resources/images/zip-file-32.png";
		    				}
		    				else if(Ext.Array.contains(databaseFiles,fileExtension)){
		    					var imageFile = "resources/images/xml-file-32.png";
		    				}
		    				else if(Ext.Array.contains(imageFiles,fileExtension)){
		    					var imageFile = "resources/images/img-file-32.png";
		    				}
		    				else if(Ext.Array.contains(netFiles,fileExtension)){
		    					var imageFile = "resources/images/pdf-file-32.png";
		    				}
		    				else if(Ext.Array.contains(presentationFiles,fileExtension)){
		    					var imageFile = "resources/images/ppt-file-32.png";
		    				}
		    				else if(Ext.Array.contains(spreadSheetFiles,fileExtension)){
		    					var imageFile = "resources/images/xls-file-32.png";
		    				}
		    				else if(Ext.Array.contains(videoFiles,fileExtension)){
		    					var imageFile = "resources/images/mp4-file-32.png";
		    				}
		    				else if(Ext.Array.contains(docFiles,fileExtension)){
		    					var imageFile = "resources/images/doc-file-32.png";
		    				}
		    				else if(Ext.Array.contains(textFiles,fileExtension)){
		    					var imageFile = "resources/images/pdf-file-32.png";
		    				}
		    				return imageFile;
		    			}
		    			else{
		    				return "resources/images/generic-file-32.png";
		    			}
		    	    },
	    	    	timeSince: function(values) {
	    	    		var Day = new Date(values.createdOn).getTime();
	    	    		var seconds = (Date.now()-Day)/ 1000;

	    	    		var interval = Math.floor(seconds / 31536000);

	    	    		if (interval > 1) {
	    	    			return interval + " years";
	    	    		}
	    	    		else if(interval == 1) {
	    	    			return interval + " year";
	    	    		}
	    	    		
	    	    		interval = Math.floor(seconds / 2592000);
	    	    		if (interval > 1) {
	    	    			return interval + " months";
	    	    		}
	    	    		else if (interval == 1) {
	    	    			return interval + " month";
	    	    		}
	    	    		
	    	    		interval = Math.floor(seconds / 86400);
	    	    		if (interval > 1) {
	    	    			return interval + " days";
	    	    		}
	    	    		else if (interval == 1) {
	    	    			return "a day";
	    	    		}
	    	    		
	    	    		interval = Math.floor(seconds / 3600);
	    	    		if (interval > 1) {
	    	    			return interval + " hours";
	    	    		}
	    	    		else if (interval == 1) {
	    	    			return interval + " hour";
	    	    		}
	    	    		
	    	    		interval = Math.floor(seconds / 60);
	    	    		if (interval > 1) {
	    	    			return interval + " minutes";
	    	    		}
	    	    		else if (interval == 1) {
	    	    			return interval + " minute";
	    	    		}
	    	    		
	    	    		return Math.floor(seconds) + " seconds";
	    	    	}
		        }
		    ),
		    itemSelector: 'div.thumb-wrap',
		    emptyText: 'Keep track of content changes<br />Easily see which document library items site members have been working on. In the detailed view you can like an item and mark it as a favorite. You can also jump to the details page to leave a comment.',
    	}]
    },{
    	xtype: 'panel',
    	title: getDMSTranslation('SITE_ACTIVITIES'),
    	autoScroll: true,
        frame: true,
        border: true,
        height: 280,
        itemId: 'siteActivitiesMainPanelItemId',
        cls: 'activities',
        dockedItems: [{
        	xtype: 'toolbar',
        	dock: 'top',
        	style: 'background:rgb(224, 224, 224);',
        	items: [{
        		xtype : 'combobox',
        		name : 'userFilter',
        		itemId:'siteUserFilterItemId',
        		store: new Ext.data.ArrayStore({
        			id: 0,
        			fields: [
        				'displayFilter',
        				'valueFilter'
        				],
        				data: [["My activities",'mine'], ["Everyone else's activities","others"],["Everyone's activities","all"],["I'm following","following"]]  // data is local
        		}),
        		valueField: 'valueFilter',
        		displayField: 'displayFilter',
        		triggerAction: 'all',
        		editable: false
        	},{
        		xtype : 'combobox',
        		name : 'activityFilter',
        		itemId:'siteActivityFilterItemId',
        		store: new Ext.data.ArrayStore({
        			id: 0,
        			fields: [
        				'displayFilter',
        				'valueFilter'
        				],
        				data: [
        					["all items",''],
        					["comments","org.alfresco.comments.comment-created,org.alfresco.comments.comment-updated"],
        					["content","org.alfresco.documentlibrary.file-updated,org.alfresco.documentlibrary.file-added,org.alfresco.documentlibrary.files-added,org.alfresco.documentlibrary.files-deleted,org.alfresco.documentlibrary.files-updated,org.alfresco.documentlibrary.file-deleted,org.alfresco.documentlibrary.inline-edit,org.alfresco.documentlibrary.file-previewed,org.alfresco.documentlibrary.file-downloaded,org.alfresco.doclink.link-created,org.alfresco.wiki.page-created,org.alfresco.wiki.page-edited,org.alfresco.wiki.page-renamed,org.alfresco.wiki.page-deleted,org.alfresco.blog.post-created,org.alfresco.blog.post-updated,org.alfresco.blog.post-deleted"],
        					["memberships","org.alfresco.site.user-joined,org.alfresco.site.user-left,org.alfresco.site.user-role-changed,org.alfresco.site.group-added,org.alfresco.site.group-removed,org.alfresco.site.group-role-changed"]]  // data is local
        		}),
        		valueField: 'valueFilter',
        		displayField: 'displayFilter',
        		triggerAction: 'all',
        		editable: false
        	},{
        		xtype : 'combobox',
        		name : 'dateFilter',
        		itemId:'siteDateFilterItemId',
        		store: new Ext.data.ArrayStore({
        			id: 0,
        			fields: [
        				'displayFilter',
        				'valueFilter'
        				],
        				data: [["today",'today'], ["in the last 7 days","7"],["in the last 14 days","14"],["in the last 28 days","28"]]  // data is local
        		}),
        		valueField: 'valueFilter',
        		displayField: 'displayFilter',
        		triggerAction: 'all',
        		editable: false
        	}]
        }],
    	items:[]
    }]
});