var imagestore = Ext.create('Ext.data.Store', {
	fields: ['name', 'size', 'file', 'status']
});

//var postDocument = this.postDocument;

Ext.define('Academia.view.MultipleDragAndDrop', {
	extend : 'Ext.grid.Panel',
	alias: 'widget.multipledraganddrop',
	xtype: 'multipledraganddrop',
	title: 'Multiple upload',
	store: imagestore,
	multiSelect: true,
	id: 'UploadGrid',
	border:true,
	columns: [{
		header: getCommonTranslation('NAME'),
		dataIndex: 'name',
		flex: 2
	}, {
		header: getCommonTranslation('SIZE'),
		dataIndex: 'size',
		flex: 1,
		renderer: Ext.util.Format.fileSize
	}, {
		header: getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex: 1,
		renderer: function(value, metaData, record, rowIndex, colIndex, imagestore){
			if(value === "Ready"){
				return value;
			}else{
				if(value=== "Uploading"){
					var id = Ext.id();
					Ext.defer(function () {
						var pb = Ext.widget('progressbar', {
							renderTo: id,
							id:'update_progressBare',
							interval: 500, //bar will move fast!
							duration: 50000,
							increment: 15,
							text: 'Uploading...',
							scope: this,
						});
						pb.textEl.removeCls("x-progress-text x-progress-text-back");
						pb.textEl.addCls("inProgressCss-progress-text");
					}, 50);
					return Ext.String.format('<div id="{0}"></div>', id);
				}else{
					var id = Ext.id();
					Ext.defer(function () {
						var pb = Ext.widget('progressbar', {
							renderTo: id,
							interval: 500, //bar will move fast!
							duration: 50000,
							increment: 15,
							text: 'Uploaded',
							scope: this,
						});
						pb.textEl.removeCls("x-progress-text x-progress-text-back");
						pb.textEl.addCls("inProgressCss-progress-text");
					}, 50);
					return Ext.String.format('<div id="{0}"></div>', id);
				}
			}
		}
	}],

	viewConfig: {
		emptyText: getCommonTranslation('DROP_FILES_HERE'),
		deferEmptyText: false,
		stripeRows : CONSTANTS.STRIPEROWS
	},
	listeners: {
		drop: {
			element: 'el',
			fn: 'drop'
		},

		dragstart: {
			element: 'el',
			fn: 'addDropZone'
		},

		dragenter: {
			element: 'el',
			fn: 'addDropZone'
		},

		dragover: {
			element: 'el',
			fn: 'addDropZone'
		},

		dragleave: {
			element: 'el',
			fn: 'removeDropZone'
		},

		dragexit: {
			element: 'el',
			fn: 'removeDropZone'
		},

	},

	noop: function(e) {
		e.stopEvent();
	},

	addDropZone: function(e) {
		if (!e.browserEvent.dataTransfer || Ext.Array.from(e.browserEvent.dataTransfer.types).indexOf('Files') === -1) {
			return;
		}

		e.stopEvent();

		this.addCls('drag-over');
	},

	removeDropZone: function(e) {
		var el = e.getTarget(),
		thisEl = this.getEl();

		e.stopEvent();


		if (el === thisEl.dom) {
			this.removeCls('drag-over');
			return;
		}

		while (el !== thisEl.dom && el && el.parentNode) {
			el = el.parentNode;
		}

		if (el !== thisEl.dom) {
			this.removeCls('drag-over');
		}

	},

	drop: function(e) {
		Ext.Array.forEach(Ext.Array.from(e.browserEvent.dataTransfer.files), function(file) {
			imagestore.add({
				file: file,
				name: file.name,
				size: file.size,
				status: 'Ready'
			});
		});
		//Ext.getCmp('UploadGrid').getView().refresh();
		
		this.removeCls('drag-over');
		e.stopEvent();
	},

	tbar: [{
		text: getCommonTranslation('UPLOAD'),
		handler: function() {
			for (var i = 0; i < imagestore.data.items.length; i++) {
				console.log(imagestore.data.getAt(i).data.file);
				if (!(imagestore.data.getAt(i).data.status === "Uploaded")) {
					imagestore.data.getAt(i).data.status = "Uploading";
					imagestore.data.getAt(i).commit();
					postDocument(SERVERURL.IMPORT_UTILITY_MASTER_CREATE, imagestore, i);
				}
			}

		}
	}, {
		text: getCommonTranslation('ERASE_EVERYTHING'),
		handler: function() {
			imagestore.reload();
		}
	}, {
		text: "Erase uploaded files",
		hidden:true,
		handler: function() {
			for (var i = 0; i < imagestore.data.items.length; i++) {
				var record = imagestore.getData().getAt(i);
				if ((record.data.status === "Uploaded")) {
					imagestore.remove(record);
					i--;
				}
			}
		}
	}, {
		text: "Erase selected files",
		hidden:true,
		handler: function() {
			imagestore.remove(Ext.getCmp('UploadGrid').getSelection());
		}
	}]
});


 function postDocument(urlS, imagestore, i) {
	 var url = 'rest/ImgageFileResource/uploadImageForRajKumar';
	var xhr = new XMLHttpRequest();
	var fd = new FormData();
	var boundary = "---------------------------7da24f2e50046";
	xhr.open("POST", url, true);
	fd.append('upload', imagestore.data.getAt(i).data.file);
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && xhr.status == 200) {
			Ext.getCmp('update_progressBare').updateText('Uploaded');
			imagestore.data.getAt(i).data.status = "Uploaded";
			imagestore.data.getAt(i).commit();
		} else if (xhr.readyState == 4 && xhr.status == 404) {
			imagestore.data.getAt(i).data.status = "Error";
			imagestore.data.getAt(i).commit();
		}
	};
	xhr.send(fd);
}