/**
 * This Grid is used for Program Groups Grid of the Admission Cycle setup
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.ProgramGroupsGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.programgroupsgrid',
	title : getAdmissionTranslation('PROGRAM_GROUPS'),
	collapsible: true,
    titleCollapse: true,
	border : true,
	store: 'Academia.store.admission.admissionCycle.ProgramGroups',
	columns : [{
		text : getAdmissionTranslation('GROUP_NAME'),
		dataIndex: 'programGroup',
		sortable : true,
		flex : .2,
		renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}
	},  {
		text : getAdmissionTranslation('FORM_SALE_START_DATE'),
		dataIndex: 'appFormStartDate',
		sortable : true,
		flex : .2,
		renderer : function(date) {
			return dateRender(date);
		}
	}, {
		text : getAdmissionTranslation('FORM_SALE_END_DATE'),
		dataIndex : 'appFormEndDate',
		sortable : true,
		flex : .2,
		renderer : function(date) {
			return dateRender(date);
		}
	},  {
		text : getAdmissionTranslation('FORM_SUBMISSION_START_DATE'),
		dataIndex: 'appFormSubmitStartDate',
		sortable : true,
		flex : .2,
		renderer : function(date) {
			return dateRender(date);
		}
	}, {
		text : getAdmissionTranslation('FORM_SUBMISSION_END_DATE'),
		dataIndex : 'appFormSubmitEndDate',
		sortable : true,
		flex : .2,
		renderer : function(date) {
			return dateRender(date);
		}
	}, {
		text : getAdmissionTranslation('MAX_PROGRAM_ALLOWED'),
		dataIndex : 'maxProgramsAllowed',
		sortable : true,
		flex : .2,
		hidden : true,
		renderer : function(obj) {
			return obj
		}
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,
        	emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
        	store: 'Academia.store.admission.admissionCycle.ProgramGroups'
        }]
    }],
    tbar : [{
		xtype: 'fieldcontainer',
		items: [{
            xtype: 'radiogroup',
            itemId: 'groupTypeRadio',
            fieldLabel: getAdmissionTranslation('GROUP_TYPE'),
            columns: 2,
            width: '250px',
            //labelWidth: 'auto',
            vertical: false,
            layout: {
            	type: 'hbox'
            },
            items: [{
                boxLabel: getAdmissionTranslation('CONFIGURED'),
                name: 'wetherConfigured',
                inputValue: true,
                checked: true
            }, {
                boxLabel: getAdmissionTranslation('NOT_CONFIGURED'),
                name: 'wetherConfigured',
                inputValue: false
            }]
		}]
	}, {
		xtype: 'button',
		itemId: 'configureGroup',
		tooltip : getAdmissionTranslation('CONFIGURE_GROUP'),
		text: getAdmissionTranslation('CONFIGURE_GROUP')
	}]
});