/**
 * @author Rohit Thadani
 * 
 * This component is used for to show current program details in grid 
 */

var changeProgStore = Ext.create('Academia.store.admission.applicationFormSale.ChangeProgramCurrentStore');
Ext.define('Academia.view.admission.applicationFormSale.ChangeProgramWindowCurrentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.changeprogramwindowcurrentgrid',
    title:getAdmissionTranslation('CURRENT_APPLICATION_PROGRAM'),
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    store:changeProgStore,
    border: true,
    columns: [{
            header: getCommonTranslation('ACADEMY'), //Academy Location
            dataIndex: 'academyLocationName',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('PROGRAM_GROUP'), //Program Group
            dataIndex: 'programGroupName',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('PROGRAM'), //Program
            dataIndex: 'programName',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('BATCH'), //Batch
            dataIndex: 'batchName',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('SEAT_TYPE'), //Seat Type
            dataIndex: 'seatTypeName',
            flex: .2,
            sortable: true
        }, {
		   header: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
		   dataIndex: 'schoolAttendanceStartDate',
		   flex: .2,
		   sortable: true,
		   renderer: function(val) {
			  if (!isNullOrEmpty(val)) {
				  return dateRender(val);
			  }
		  }
	    }, {
            header: getCommonTranslation('MODE_OF_DELIVERY'), //Mode of Delivery
            dataIndex: 'modeOfDelivery',
            flex: .2,
            sortable: true
        }, {
            header: getCommonTranslation('REGISTRATION_TYPE'), //Registration Type
            dataIndex:'batchPartTime',
            flex: .2,
            sortable: true
        }]
});
